/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.naming.ContextUtils;
import com.evermind.server.ejb.IncrementalDeploymentHandler;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.MethodStateFactory;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.naming.NamingException;

public abstract class ExposableBeanDescriptor
extends BeanDescriptor {
    public static final String LOCAL_LOCATION_SUFFIX = "Local";
    private String remoteHomeName;
    private String localHomeName;
    private String remoteInterfaceName;
    private String localInterfaceName;
    private Set localInterfaceNames;
    private Set remoteInterfaceNames = new HashSet(1);
    private String location;
    private String localLocation;
    private String qualifiedLocation;
    private String qualifiedLocalLocation;
    private String remoteHomeWrapperName;
    private String localHomeWrapperName;
    private String localWrapperName;
    private String remoteWrapperName;
    private boolean generatedRemoteInterface = false;
    private boolean generatedLocalInterface = false;
    private boolean generatedRemoteHome = false;
    private boolean generatedLocalHome = false;
    private boolean isServiceEndPointOnly;
    private Class remoteHome;
    private Class remoteInterface;
    private Class localHome;
    private Class localInterface;
    private Class serviceEndpoint;
    private boolean generateIIOP;
    private Class remoteWrapper;
    private Class localWrapper;
    private Class remoteHomeWrapper;
    private Class localHomeWrapper;
    private Map localHomeMethodStates = null;
    private Map remoteHomeMethodStates = null;
    private Map localComponentMethodStates = null;
    private Map remoteComponentMethodStates = null;

    protected ExposableBeanDescriptor(EJBPackage ejbPackage) {
        super(ejbPackage);
        this.localInterfaceNames = new HashSet(1);
    }

    protected void initialize() throws InstantiationException {
        super.initialize();
        if (this.getQualifiedLocation() == null) {
            this.setQualifiedLocation(this.getEJBPackage().getName() + "_" + this.getName());
        }
        if (this.getQualifiedLocalLocation() == null) {
            this.setQualifiedLocalLocation(this.getQualifiedLocation() + LOCAL_LOCATION_SUFFIX);
        }
        if (this.getLocation() == null) {
            this.setLocation(this.getName());
        }
        if (this.getLocalLocation() == null) {
            this.setLocalLocation(this.getQualifiedLocalLocation());
        }
        if (this.getRemoteInterfaceNames().size() == 1) {
            this.setRemoteInterfaceName((String)this.getRemoteInterfaceNames().toArray()[0]);
        } else if (this.getRemoteInterfaceNames().size() > 1) {
            if (this.getPackage().getCompatibility() < 3) {
                throw new InstantiationException("Only one remote interface may be specified for a bean");
            }
            if (this.getRemoteHomeName() != null && !this.isGeneratedRemoteHome()) {
                throw new InstantiationException("Home interfaces may not be specified when more than one remote component interface is present.  Bean: " + this.getName() + " Interfaces: " + this.getRemoteInterfaceNames());
            }
        }
        if (this.getRemoteHomeName() != null && this.getRemoteInterfaceNames().size() == 0) {
            throw new InstantiationException("remote type not specified for bean " + this.getName());
        }
        if (this.getPackage().getCompatibility() < 3 && this.getRemoteInterfaceNames().size() > 0 && this.getRemoteHomeName() == null) {
            throw new InstantiationException("home type not specified for bean " + this.getName());
        }
        if (this.getLocalInterfaceNames().size() == 1) {
            this.setLocalInterfaceName((String)this.getLocalInterfaceNames().toArray()[0]);
        } else if (this.getLocalInterfaceNames().size() > 1) {
            if (this.getPackage().getCompatibility() < 3) {
                throw new InstantiationException("Only one local interface may be specified for a bean");
            }
            if (this.getLocalHomeName() != null && !this.isGeneratedLocalHome()) {
                throw new InstantiationException("Home interfaces may not be specified when more than one local component interface is present.  Bean: " + this.getName() + " Interfaces: " + this.getLocalInterfaceNames());
            }
        }
        if (this.getLocalHomeName() != null && this.getLocalInterfaceNames().size() == 0) {
            throw new InstantiationException("local type not specified for bean " + this.getName());
        }
        if (this.getPackage().getCompatibility() < 3 && this.getLocalInterfaceNames().size() > 0 && this.getLocalHomeName() == null) {
            throw new InstantiationException("local-home type not specified for bean " + this.getName());
        }
        if (this.getLocalInterfaceName() == null && this.getRemoteInterfaceName() == null && this.getLocalInterfaceNames().isEmpty() && this.getRemoteInterfaceNames().isEmpty()) {
            EJBDeploymentMessages.warningSessionBizInterfaceNotDefined(this);
        }
    }

    public void initialize(EJBDeploymentContext container) throws InstantiationException {
        boolean validateClass;
        super.initialize(container);
        if (this.generatedLocalInterface || this.generatedRemoteInterface) {
            this.getEJBPackage().getDeployment().addGeneratedInterfaceCodeSource();
        }
        boolean bl = validateClass = this.getPackage().getCompatibility() < 3;
        if (this.getRemoteHomeName() != null) {
            Class clazz = validateClass ? EJBHome.class : null;
            this.setRemoteHome(this.loadClass(this.getRemoteHomeName(), clazz, this.getEJBPackage().getEJBClassLoader()));
        }
        if (this.getRemoteInterfaceName() != null) {
            Class clazz = validateClass && !this.getRemoteInterfaceName().equals(this.getServiceEndpointName()) ? EJBObject.class : null;
            this.setRemoteInterface(this.loadClass(this.getRemoteInterfaceName(), clazz, this.getEJBPackage().getEJBClassLoader()));
        }
        if (this.getLocalHomeName() != null) {
            Class clazz = validateClass ? EJBLocalHome.class : null;
            this.setLocalHome(this.loadClass(this.getLocalHomeName(), clazz, this.getEJBPackage().getEJBClassLoader()));
        }
        if (this.getLocalInterfaceName() != null) {
            Class clazz = validateClass ? EJBLocalObject.class : null;
            this.setLocalInterface(this.loadClass(this.getLocalInterfaceName(), clazz, this.getEJBPackage().getEJBClassLoader()));
        }
        if (this.isServiceEndpoint()) {
            Class clazz = validateClass ? Remote.class : null;
            this.setServiceEndpoint(this.loadClass(this.getServiceEndpointName(), clazz, this.getEJBPackage().getEJBClassLoader()));
        }
    }

    public void resetForCompile() {
        this.setLocalHomeWrapperName(null);
        this.setRemoteHomeWrapperName(null);
    }

    private Class loadClass(String name, Class typeToImplement, ClassLoader loader) throws InstantiationException {
        try {
            Class<?> type = Class.forName(name, true, loader);
            if (typeToImplement != null && !typeToImplement.isAssignableFrom(type)) {
                throw new InstantiationException(name + " does not implement " + typeToImplement.getName());
            }
            return type;
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException("Unable to initialize bean " + this.getName() + ": class '" + name + "' not found").initCause(e);
        }
        catch (Throwable t) {
            if (t instanceof InstantiationException) {
                throw (InstantiationException)t;
            }
            throw (InstantiationException)new InstantiationException("Unable to initialize bean " + this.getName() + ": error loading class '" + name + "'").initCause(t);
        }
    }

    public String getLocalHomeName() {
        return this.localHomeName;
    }

    public String getLocalInterfaceName() {
        return this.localInterfaceName;
    }

    public Set getLocalInterfaceNames() {
        return this.localInterfaceNames;
    }

    public String getLocalHomeWrapperName() {
        return this.localHomeWrapperName;
    }

    public String getRemoteHomeName() {
        return this.remoteHomeName;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public Set getRemoteInterfaceNames() {
        return this.remoteInterfaceNames;
    }

    public void addLocalInterfaceName(String intfName) throws InstantiationException {
        if (this.remoteInterfaceNames.contains(intfName)) {
            throw new InstantiationException("Business interface: " + intfName + " cannot be defined as both Remote/Local");
        }
        this.localInterfaceNames.add(intfName);
    }

    public void addRemoteInterfaceName(String intfName) throws InstantiationException {
        if (this.localInterfaceNames.contains(intfName)) {
            throw new InstantiationException("Business interface: " + intfName + " cannot be defined as both Remote/Local");
        }
        this.remoteInterfaceNames.add(intfName);
    }

    public String getRemoteHomeWrapperName() {
        return this.remoteHomeWrapperName;
    }

    public boolean isGeneratedLocalHome() {
        return this.generatedLocalHome;
    }

    public boolean isGeneratedLocalInterface() {
        return this.generatedLocalInterface;
    }

    public boolean isGeneratedRemoteHome() {
        return this.generatedRemoteHome;
    }

    public boolean isGeneratedRemoteInterface() {
        return this.generatedRemoteInterface;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocalLocation() {
        return this.localLocation;
    }

    public String getQualifiedLocation() {
        return this.qualifiedLocation;
    }

    public String getQualifiedLocalLocation() {
        return this.qualifiedLocalLocation;
    }

    public void setLocalHomeName(String localHomeName) {
        this.localHomeName = localHomeName;
        this.firePropertyChangeEvent("localHomeName", this.localHomeName, localHomeName);
    }

    public void setLocalInterfaceName(String localInterfaceName) {
        this.localInterfaceName = localInterfaceName;
    }

    public void setLocalHomeWrapperName(String name) {
        this.localHomeWrapperName = name;
    }

    public void setRemoteHomeName(String remoteHomeName) {
        this.remoteHomeName = remoteHomeName;
        this.firePropertyChangeEvent("homeName", this.remoteHomeName, remoteHomeName);
    }

    public void setRemoteInterfaceName(String remoteInterfaceName) {
        this.remoteInterfaceName = remoteInterfaceName;
    }

    public void setRemoteHomeWrapperName(String name) {
        this.remoteHomeWrapperName = name;
    }

    public void setGeneratedRemoteHomeName(String name) {
        this.remoteHomeName = name;
        this.generatedRemoteHome = true;
    }

    public void setGeneratedLocalHomeName(String name) {
        this.localHomeName = name;
        this.generatedLocalHome = true;
    }

    public void setGeneratedRemoteInterfaceName(String name) {
        this.remoteInterfaceName = name;
        this.generatedRemoteInterface = true;
    }

    public void setGeneratedLocalInterfaceName(String name) {
        this.localInterfaceName = name;
        this.generatedLocalInterface = true;
    }

    protected void setLocation(String location) {
        this.location = location;
        this.firePropertyChangeEvent("location", this.location, location);
    }

    protected void setLocalLocation(String location) {
        this.localLocation = location;
    }

    private void setQualifiedLocation(String location) {
        this.qualifiedLocation = location;
    }

    private void setQualifiedLocalLocation(String location) {
        this.qualifiedLocalLocation = location;
    }

    public Class getRemoteHome() {
        return this.remoteHome;
    }

    public Class getRemoteInterface() {
        return this.remoteInterface;
    }

    public Class getLocalHome() {
        return this.localHome;
    }

    public Class getLocalInterface() {
        return this.localInterface;
    }

    public void setLocalHome(Class localHome) {
        this.localHome = localHome;
    }

    public void setLocalInterface(Class local) {
        this.localInterface = local;
    }

    public void setRemoteHome(Class remoteHome) {
        this.remoteHome = remoteHome;
    }

    public void setRemoteInterface(Class remote) {
        this.remoteInterface = remote;
    }

    public String isDeployed() {
        String reason = null;
        reason = this.checkBeanUpdate();
        if (reason != null) {
            return reason;
        }
        reason = this.checkWrapperUpdate();
        if (reason != null) {
            return reason;
        }
        return super.isDeployed();
    }

    protected String checkBeanUpdate() {
        String reason = null;
        reason = this.checkClassForUpdate(this.getRemoteInterfaceName());
        if (reason != null) {
            return reason;
        }
        reason = this.checkClassForUpdate(this.getLocalInterfaceName());
        if (reason != null) {
            return reason;
        }
        reason = this.checkClassForUpdate(this.getRemoteHomeName());
        if (reason != null) {
            return reason;
        }
        reason = this.checkClassForUpdate(this.getLocalHomeName());
        if (reason != null) {
            return reason;
        }
        reason = this.checkClassForUpdate(this.getEJBClassName());
        return reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String checkWrapperUpdate() {
        block25: {
            if (this.getRemoteHomeWrapperName() == null && this.getLocalHomeWrapperName() == null) {
                return "No complete previous deployment found  (neither local nor remote home wrapper set)";
            }
            if (this.getRemoteHomeWrapperName() != null) {
                ctx = null;
                try {
                    ctx = this.getEJBPackage().getDeployment().getWrapperClassContext();
                    ctx.lookup(this.getRemoteHomeWrapperName() + ".class");
                    var5_2 = null;
                    ** if (ctx == null) goto lbl-1000
                }
                catch (Throwable var4_13) {
                    var5_4 = null;
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException e) {
                            // empty catch block
                        }
                    }
                    throw var4_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                    catch (Exception e) {
                        var3_11 = "No complete previous deployment found (remote home wrapper not found)";
                        var5_3 = null;
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException e) {
                                // empty catch block
                            }
                        }
                        return var3_11;
                    }
                }
            }
        }
        if (this.getLocalHomeWrapperName() != null) {
            ctx = null;
            try {
                ctx = this.getEJBPackage().getDeployment().getWrapperClassContext();
                ctx.lookup(this.getLocalHomeWrapperName() + ".class");
            }
            catch (Exception e) {
                var3_12 = "No complete previous deployment found (local home wrapper not found)";
                return var3_12;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
        }
        return null;
    }

    protected String checkClassForUpdate(String name) {
        if (name != null) {
            String className = name.replace('.', '/').concat(".class");
            long newTime = ContextUtils.getFileLastModified(this.getEJBPackage().getContext(), className);
            IncrementalDeploymentHandler handler = this.getEJBPackage().getContainer().getIncrementalDeploymentHandler();
            if (handler != null && handler.getEjbModuleName().equals(this.getEJBPackage().getDeployment().getModule().getName())) {
                long oldTime = ContextUtils.getFileLastModified(handler.getBackupEJBArchiveContext(this.getEJBPackage().getDeployment()), className);
                if (newTime > oldTime) {
                    return "Class '" + name + " changed in new module archive";
                }
                if (newTime < oldTime) {
                    return "Class '" + name + " changed in new module archive." + " (WARNING: new class older than prior version)";
                }
            } else if (ContextUtils.getFileLastModified(this.getEJBPackage().getContext(), className) > this.getEJBPackage().getTimeOfLastDeployment()) {
                return "Class '" + name + "' has been updated since last deployment";
            }
        }
        return null;
    }

    public String getServiceEndpointName() {
        return null;
    }

    public boolean isServiceEndpoint() {
        return false;
    }

    public Class getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(Class serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public MethodState getMethodState(boolean isLocal, boolean isHome, String signature) {
        MethodState methodState = null;
        methodState = isLocal ? (isHome ? (MethodState)this.getLocalHomeMethodStates().get(signature) : (MethodState)this.getLocalComponentMethodStates().get(signature)) : (isHome ? (MethodState)this.getRemoteHomeMethodStates().get(signature) : (MethodState)this.getRemoteComponentMethodStates().get(signature));
        if (methodState != null) {
            methodState.initialize();
        }
        return methodState;
    }

    public void destroyMethodStates() {
        MethodState methodState;
        Iterator i;
        if (this.localHomeMethodStates != null) {
            i = this.localHomeMethodStates.values().iterator();
            while (i.hasNext()) {
                methodState = (MethodState)i.next();
                methodState.destroy();
            }
            this.localHomeMethodStates.clear();
        }
        if (this.localComponentMethodStates != null) {
            i = this.localComponentMethodStates.values().iterator();
            while (i.hasNext()) {
                methodState = (MethodState)i.next();
                methodState.destroy();
            }
            this.localComponentMethodStates.clear();
        }
        if (this.remoteHomeMethodStates != null) {
            i = this.remoteHomeMethodStates.values().iterator();
            while (i.hasNext()) {
                methodState = (MethodState)i.next();
                methodState.destroy();
            }
            this.remoteHomeMethodStates.clear();
        }
        if (this.remoteComponentMethodStates != null) {
            i = this.remoteComponentMethodStates.values().iterator();
            while (i.hasNext()) {
                methodState = (MethodState)i.next();
                methodState.destroy();
            }
            this.remoteComponentMethodStates.clear();
        }
    }

    private Map createMethodStates(boolean isLocal, boolean isHome, Class interfaceClass) {
        return this.createMethodStates(isLocal, isHome, interfaceClass, new HashMap());
    }

    private Map createMethodStates(boolean isLocal, boolean isHome, Class interfaceClass, Map methodStates) {
        Method[] methodDefinitions = interfaceClass.getMethods();
        for (int i = 0; i < methodDefinitions.length; ++i) {
            Method method = methodDefinitions[i];
            MethodState methodState = MethodStateFactory.createMethodState(this, method, isLocal, isHome);
            if (methodState == null) continue;
            methodStates.put(method.getName() + ClassUtils.getCodedArguments(method), methodState);
        }
        return methodStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getLocalHomeMethodStates() {
        if (this.localHomeMethodStates == null && this.getLocalHome() != null) {
            Class clazz = this.getLocalHome();
            synchronized (clazz) {
                if (this.localHomeMethodStates == null) {
                    this.localHomeMethodStates = this.createMethodStates(true, true, this.getLocalHome());
                }
            }
        }
        return this.localHomeMethodStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getRemoteHomeMethodStates() {
        if (this.remoteHomeMethodStates == null && this.getRemoteHome() != null) {
            Class clazz = this.getRemoteHome();
            synchronized (clazz) {
                if (this.remoteHomeMethodStates == null) {
                    this.remoteHomeMethodStates = this.createMethodStates(false, true, this.getRemoteHome());
                }
            }
        }
        return this.remoteHomeMethodStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getLocalComponentMethodStates() {
        if (this.localComponentMethodStates == null && this.getLocalInterface() != null) {
            Class clazz = this.getLocalInterface();
            synchronized (clazz) {
                if (this.localComponentMethodStates == null) {
                    this.localComponentMethodStates = this.createMethodStates(true, false, this.getLocalInterface());
                }
            }
        }
        return this.localComponentMethodStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getRemoteComponentMethodStates() {
        if (this.remoteComponentMethodStates == null && (this.getRemoteInterface() != null || this.getServiceEndpoint() != null)) {
            Class sync;
            Class clazz = sync = this.getRemoteInterface() != null ? this.getRemoteInterface() : this.getServiceEndpoint();
            synchronized (clazz) {
                if (this.remoteComponentMethodStates == null) {
                    HashMap tempMap = new HashMap();
                    if (this.getRemoteInterface() != null) {
                        this.createMethodStates(false, false, this.getRemoteInterface(), tempMap);
                    }
                    if (this.getServiceEndpoint() != null) {
                        this.createMethodStates(false, false, this.getServiceEndpoint(), tempMap);
                    }
                    this.remoteComponentMethodStates = tempMap;
                }
            }
        }
        return this.remoteComponentMethodStates;
    }

    public String getLocalWrapperName() {
        return this.localWrapperName;
    }

    public String getRemoteWrapperName() {
        return this.remoteWrapperName;
    }

    public void setLocalWrapperName(String localWrapperName) {
        this.localWrapperName = localWrapperName;
    }

    public void setRemoteWrapperName(String remoteWrapperName) {
        this.remoteWrapperName = remoteWrapperName;
    }

    public boolean isServiceEndPointOnly() {
        return this.isServiceEndPointOnly;
    }

    public void setIsServiceEndPointOnly(boolean isServiceEndPointOnly) {
        this.isServiceEndPointOnly = isServiceEndPointOnly;
    }

    public Class getLocalHomeWrapper() {
        return this.localHomeWrapper;
    }

    public void setLocalHomeWrapper(Class localHomeWrapper) {
        this.localHomeWrapper = localHomeWrapper;
    }

    public Class getLocalWrapper() {
        return this.localWrapper;
    }

    public void setLocalWrapper(Class localWrapper) {
        this.localWrapper = localWrapper;
    }

    public Class getRemoteHomeWrapper() {
        return this.remoteHomeWrapper;
    }

    public void setRemoteHomeWrapper(Class remoteHomeWrapper) {
        this.remoteHomeWrapper = remoteHomeWrapper;
    }

    public Class getRemoteWrapper() {
        return this.remoteWrapper;
    }

    public void setRemoteWrapper(Class remoteWrapper) {
        this.remoteWrapper = remoteWrapper;
    }

    public boolean getGenerateIIOP() {
        return this.generateIIOP;
    }

    public void setGenerateIIOP(boolean generateIIOP) {
        this.generateIIOP = generateIIOP;
    }
}

