/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.admin;

import com.evermind.server.ejb.MessageDrivenBeanPool;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.deployment.ActivationConfig;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.MessageDrivenBeanCallBackIf;

public class MessageDrivenBeanCallBackIfImpl
implements MessageDrivenBeanCallBackIf {
    private MessageDrivenBeanDescriptor descriptor;

    public MessageDrivenBeanCallBackIfImpl(MessageDrivenBeanDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private MessageDrivenHome getHome() {
        MessageDrivenHome home = this.descriptor.getPackage().getDeployment().getMessageDrivenHome(this.descriptor.getName());
        if (home == null) {
            throw new JMXRuntimeException("Unable to access message driven bean '" + this.descriptor.getName() + "'. Ensure that parent application is in RUNNING state");
        }
        return home;
    }

    public final String getName() {
        return this.descriptor.getName();
    }

    public final int getCreateCount() {
        MessageDrivenBeanPool pool = (MessageDrivenBeanPool)this.descriptor.getBeanPool();
        if (pool != null) {
            return pool.getEjbCreateCount();
        }
        return 0;
    }

    public final int getRemoveCount() {
        MessageDrivenBeanPool pool = (MessageDrivenBeanPool)this.descriptor.getBeanPool();
        if (pool != null) {
            return pool.getEjbRemoveCount();
        }
        return 0;
    }

    public final String getTransactionType() {
        return this.descriptor.getTransactionType() == 0 ? "Container" : "Bean";
    }

    public final String getTransactionAttribute() {
        if (this.descriptor.getTransactionType() == 1) {
            return null;
        }
        return this.descriptor.getTransactionType(this.getHome().getOnMessageMethodState().getBeanMethod(), false, false) == 1 ? "Required" : "NotSupported";
    }

    public final boolean getRAEnabled() {
        return this.descriptor.getResourceAdapter() != null;
    }

    public final String getResourceAdapter() {
        return this.descriptor.getResourceAdapter();
    }

    public final String getDestination() {
        return this.descriptor.getDestinationLocation();
    }

    public final String getConnectionFactory() {
        return this.descriptor.getConnectionFactoryLocation();
    }

    public final String getMessagingType() {
        return this.descriptor.getMessagingType();
    }

    public final String getDestinationType() {
        return this.descriptor.getDestinationType();
    }

    public final String getSubscriptionName() {
        return this.descriptor.getSubscriptionName();
    }

    public final int getListenerThreads() {
        return this.descriptor.getListenerThreads();
    }

    public final int getTransactionTimeout() {
        return this.descriptor.getTransactionTimeout();
    }

    public final String getMessageSelector() {
        return this.descriptor.getMessageSelector();
    }

    public final String getAcknowledgeMode() {
        int ackMode = this.descriptor.getAcknowledgeMode();
        if (ackMode == 1) {
            return "AUTO_ACKNOWLEDGE";
        }
        if (ackMode == 2) {
            return "CLIENT_ACKNOWLEDGE";
        }
        if (ackMode == 3) {
            return "DUPS_OK_ACKNOWLEDGE";
        }
        return null;
    }

    public final String getSubscriptionDurability() {
        return this.descriptor.isDurable() ? "Durable" : "NonDurable";
    }

    public final List getActivationConfigProperties() {
        return this.descriptor.getMDBActivationConfigProperties();
    }

    public final void setResourceAdapter(String raName) {
        this.descriptor.setResourceAdapter(raName);
        this.persistConfigChange();
    }

    public final void setActivationConfigProperties(Map params) {
        if (params != null && this.descriptor.getResourceAdapter() != null) {
            List a_list = this.descriptor.getOracleActivationConfigs();
            String a_name = null;
            String a_value = null;
            String name = null;
            String value = null;
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry t = it.next();
                name = t.getKey().toString();
                if (name != null) {
                    value = t.getValue().toString();
                }
                boolean newConfig = true;
                for (int i = 0; i < a_list.size(); ++i) {
                    ActivationConfig activationConfig = (ActivationConfig)a_list.get(i);
                    a_name = activationConfig.getName();
                    a_value = activationConfig.getStringValue();
                    if (!name.equalsIgnoreCase(a_name)) continue;
                    if (value == null) {
                        this.descriptor.getActivationConfigs().remove(i);
                        this.descriptor.getOracleActivationConfigs().remove(i);
                        newConfig = false;
                        break;
                    }
                    activationConfig.setStringValue(value);
                    newConfig = false;
                    break;
                }
                if (!newConfig) continue;
                this.descriptor.addActivationConfigProperty(new ActivationConfig(name, null, value, "activation-config-property"));
                this.descriptor.addOracleActivationConfig(new ActivationConfig(name, null, value, "config-property"));
            }
        }
        this.persistConfigChange();
    }

    public final void stop() {
        try {
            this.getHome().stop();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    public final void start() {
        try {
            this.getHome().start();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void persistConfigChange() {
        try {
            this.descriptor.getEJBPackage().storeDeployment();
        }
        catch (ClassCastException e) {
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public PhaseEventIntf getMsgDeliveryCountPhaseEvent() {
        return this.getHome().getMsgDeliveryCountPhaseEvent();
    }

    public EventIntf getSucMsgDeliveryCountEvent() {
        return this.getHome().getSucMsgDeliveryCountEvent();
    }

    public EventIntf getFailedDeliveryCountEvent() {
        return this.getHome().getFailedDeliveryCountEvent();
    }

    public int getActiveInstancesHighWaterMark() {
        if (this.descriptor.getBeanPool() != null) {
            return this.descriptor.getBeanPool().getActiveCountHighWaterMark();
        }
        return 0;
    }

    public int getActiveInstances() {
        if (this.descriptor.getBeanPool() != null) {
            return this.descriptor.getBeanPool().getActiveCount();
        }
        return 0;
    }

    public final void startRecursive() {
        this.start();
    }

    public final long getstartTime() {
        return this.getHome().getStartTime();
    }

    public final int getstate() {
        return this.getHome().getState();
    }

    public boolean getEnabled() {
        return this.descriptor.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (!enabled && this.getHome().getState() == 1) {
            throw new JMXRuntimeException("An MDB cannot be disabled while it is RUNNING");
        }
        this.descriptor.setEnabled(enabled);
        this.persistConfigChange();
    }

    public int getPooledCount() {
        if (this.descriptor.getBeanPool() != null) {
            return this.descriptor.getBeanPool().getPooledCount();
        }
        return 0;
    }
}

