/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.admin;

import com.evermind.naming.ContextUtils;
import com.evermind.server.ServerComponent;
import com.evermind.server.ejb.deployment.EJBPackage;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import oracle.oc4j.admin.management.callbackinterfaces.EJBModuleCallBackIf;
import oracle.xml.parser.v2.DOMParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class EJBModuleCallbackIfImpl
implements EJBModuleCallBackIf {
    private EJBPackage module;

    public EJBModuleCallbackIfImpl(EJBPackage module) {
        this.module = module;
    }

    public String getdeploymentDescriptor() {
        String descriptorStr;
        String encoding = null;
        try {
            byte[] data = ContextUtils.readFromContext(this.module.getContext(), this.module.getAssemblyDescriptorPath(), false).getBytes();
            InputSource source = new InputSource(new ByteArrayInputStream(data));
            try {
                source.setSystemId(".");
            }
            catch (Throwable t) {
                // empty catch block
            }
            DOMParser parser = new DOMParser();
            parser.setValidationMode(0);
            parser.setEntityResolver((EntityResolver)this.module);
            parser.setErrorHandler((ErrorHandler)this.module);
            parser.parse(source);
            encoding = parser.getDocument().getXmlEncoding();
            descriptorStr = encoding == null ? new String(data) : new String(data, encoding.trim());
        }
        catch (UnsupportedEncodingException ex) {
            descriptorStr = "Deployment descriptor ejb-jar.xml is not available because encoding for \"" + encoding + "\" is not supported.";
        }
        catch (Exception e) {
            descriptorStr = "Deployment descriptor ejb-jar.xml is not available.";
        }
        return descriptorStr;
    }

    public String getproprietaryDeploymentDescriptor() {
        return this.module.getproprietaryDeploymentDescriptor();
    }

    public String getwsDeploymentDescriptor() {
        if (this.module.getWebServicesDescriptor() != null) {
            return ((ServerComponent)((Object)this.module.getWebServicesDescriptor())).getdeploymentDescriptor();
        }
        return null;
    }

    public String getproprietaryWsDeploymentDescriptor() {
        if (this.module.getWebServicesDescriptor() != null) {
            return ((ServerComponent)((Object)this.module.getWebServicesDescriptor())).getproprietaryDeploymentDescriptor();
        }
        return null;
    }
}

