/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.ORCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ORCollectionIterator
implements Iterator {
    private ORCollection collection;
    private int pos;
    private int lastPos;
    private Object currentObject;

    public ORCollectionIterator(ORCollection collection) {
        this.collection = collection;
        this.getNextObject();
    }

    public boolean hasNext() {
        return this.currentObject != null;
    }

    public Object next() {
        Object current = this.currentObject;
        if (current == null) {
            throw new NoSuchElementException();
        }
        this.getNextObject();
        return current;
    }

    protected void getNextObject() {
        this.lastPos = this.pos - 1;
        this.collection.checkScope();
        while (this.pos < this.collection.objects.length) {
            Object object;
            if ((object = this.collection.objects[this.pos++]) instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)object;
                if (change.newValue == null) continue;
                this.currentObject = change.newValue;
                return;
            }
            this.currentObject = object;
            return;
        }
        this.currentObject = null;
    }

    public void remove() {
        if (this.lastPos < 0) {
            throw new IllegalStateException("Attempt to remove from invalid iterator position");
        }
        this.collection.remove(this.lastPos);
        this.lastPos = -1;
    }
}

