/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.EntityEJBObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.TimerService;
import oracle.ias.container.timer.EJBTimerServiceImpl;

public class EvermindEntityContext
extends AbstractEJBContext
implements EntityContext,
Serializable {
    protected EntityBean object;
    private boolean lazy = true;
    private boolean toBeDiscarded = false;
    private boolean bmpStored = false;
    private boolean inPool = false;
    private boolean sqlExecuted = true;
    protected int cacheStartTime;
    public ArrayList wrapList = new ArrayList(10);

    public EvermindEntityContext(EntityEJBHome home, EntityBean object) {
        if (home.isRemote) {
            this.remoteHome = home;
        } else {
            this.localHome = home;
        }
        this.object = object;
    }

    public EntityBean getObject() {
        return this.object;
    }

    public void setObject(EntityBean anObject) {
        this.object = anObject;
    }

    public EntityEJBObject getAnEJBObject_Local_or_Remote() {
        try {
            EJBLocalObject o = this.getEJBLocalObject();
            if (o != null) {
                return (EntityEJBObject)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (EntityEJBObject)this.getEJBObject();
    }

    public void resetFields() {
        this.lazy = true;
        this.setSqlExecuted(true);
        this.toBeDiscarded = false;
        super.resetFields();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    public Object getPrimaryKey() {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call getPrimaryKey from within the setEntityContext(...) method");
        }
        if (this.actionTaken == 6) {
            EJBUtils.throwGetPrimaryKeyInEJBCreateException();
        }
        if (this.localWrapper == null && this.remoteWrapper == null) {
            throw new IllegalStateException("EntityBean not associated with an instance, see chapter 10.5.4 of the EJB 2.0 specification");
        }
        return this.internalGetPrimaryKey();
    }

    public final Object cloneObject(Object object) throws RemoteException {
        return EJBUtils.cloneObject(object, this.remoteHome);
    }

    public final Object cloneLocalObject(Object object) {
        return EJBUtils.cloneLocalObject(object, this.localHome);
    }

    public void setRollbackOnly() {
        EJBTransactionManager.getInstance().setContainerRollbackOnly();
    }

    public String toString() {
        AbstractEJBObject gwrapper;
        if (this.object == null) {
            return "Generic EntityContext";
        }
        String objectClassName = this.object.getClass().getName().indexOf("_PersistenceManager") >= 0 ? this.object.getClass().getSuperclass().getName() : this.object.getClass().getName();
        AbstractEJBObject abstractEJBObject = gwrapper = this.remoteWrapper != null ? this.remoteWrapper : this.localWrapper;
        if (gwrapper == null) {
            return objectClassName + " EntityContext, [" + this.object + "]";
        }
        try {
            return objectClassName + " " + ((EntityEJBObject)gwrapper).getPrimaryKey_X() + " EntityContext";
        }
        catch (RemoteException e) {
            return objectClassName + " unknown ID EntityContext, [" + this.object + "]";
        }
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public synchronized void setLazy(boolean aValue) {
        this.lazy = aValue;
    }

    public boolean isToBeDiscarded() {
        return this.toBeDiscarded;
    }

    public synchronized void setToBeDiscarded(boolean v) {
        this.toBeDiscarded = v;
    }

    public boolean equals(Object o) {
        if (o == null && !(o instanceof EvermindEntityContext)) {
            return false;
        }
        if (this.localWrapper == null && this.remoteWrapper == null) {
            return false;
        }
        return this.getPrimaryKey().equals(((EvermindEntityContext)o).getPrimaryKey());
    }

    public boolean isBMPStored() {
        return this.bmpStored;
    }

    public synchronized void setBMPStored(boolean aValue) {
        this.bmpStored = aValue;
    }

    public void setInPool(boolean inPool) {
        this.inPool = inPool;
    }

    public boolean getInPool() {
        return this.inPool;
    }

    public boolean isSqlExecuted() {
        return this.sqlExecuted;
    }

    public void setSqlExecuted(boolean newSqlExecuted) {
        this.sqlExecuted = newSqlExecuted;
    }

    public void removeTimers() {
        ((EJBTimerServiceImpl)this.getTimerService()).removeEntityBeanTimers();
    }

    protected Object internalGetPrimaryKey() {
        Object pk = null;
        Exception ise = null;
        try {
            if (this.localWrapper != null) {
                pk = ((EntityEJBObject)this.localWrapper).getPrimaryKey_X();
            }
        }
        catch (Exception e) {
            ise = e;
        }
        try {
            if (pk == null && this.remoteWrapper != null) {
                pk = ((EntityEJBObject)this.remoteWrapper).getPrimaryKey_X();
            }
        }
        catch (Exception e) {
            ise = e;
        }
        if (pk == null && ise != null) {
            throw new IllegalStateException(ise.getMessage());
        }
        return pk;
    }

    protected TimerService getInternalTimerService() {
        if (this.actionTaken == 3) {
            throw new IllegalStateException("Cannot call getTimerService() from within a finder method.");
        }
        if (this.timersvc == null || !((EJBTimerServiceImpl)this.timersvc).internalHasPK()) {
            Object pk = null;
            try {
                pk = this.internalGetPrimaryKey();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.timersvc = EJBTimerServiceImpl.create(this, pk);
        }
        return this.timersvc;
    }
}

