/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.EnvironmentPropertyDescription;
import com.evermind.server.deployment.ResourceInfo;
import com.evermind.server.deployment.ResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class ContextScanningResourceProvider
implements ResourceProvider {
    private String name;
    private Context context;
    private Map types = new HashMap();
    private Set enabledTypes;

    public EnvironmentPropertyDescription[] getPropertyDescriptions() {
        return null;
    }

    public void init(Map properties) throws InstantiationException {
        String token;
        StringTokenizer tokenizer;
        InitialContext context;
        String resourceNames = (String)properties.remove("resource.names");
        String enabledTypesProperty = (String)properties.remove("resource.types");
        try {
            context = new InitialContext(new Hashtable(properties));
        }
        catch (NamingException e) {
            throw new InstantiationException("Error creating naming context instance: " + e);
        }
        if (enabledTypesProperty != null) {
            this.enabledTypes = new HashSet();
            tokenizer = new StringTokenizer(enabledTypesProperty, ",");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                this.enabledTypes.add(token);
            }
        }
        if (resourceNames != null) {
            this.context = context;
            tokenizer = new StringTokenizer(resourceNames, ",");
            while (tokenizer.hasMoreTokens()) {
                Object resource;
                token = tokenizer.nextToken();
                try {
                    resource = context.lookup(token);
                }
                catch (NameNotFoundException e) {
                    throw new InstantiationException("Resource '" + token + "' as specified by resource.names not found");
                }
                catch (NamingException e) {
                    throw new InstantiationException("Error looking up resource '" + token + "': " + e.getMessage());
                }
                this.registerIfResource(resource.getClass(), "", token);
            }
        } else {
            this.setContext(context);
        }
    }

    protected void setContext(Context context) throws InstantiationException {
        this.context = context;
        try {
            this.bindContext(context, "");
        }
        catch (NamingException e) {
            throw new InstantiationException("Error traversing naming context instance: " + e);
        }
    }

    protected void bindContext(Context context, String root) throws NamingException {
        NamingEnumeration<NameClassPair> enumeration = null;
        try {
            enumeration = context.list(new CompositeName());
        }
        catch (NamingException nex) {
            return;
        }
        while (enumeration.hasMore()) {
            Class<?> type;
            NameClassPair pair = enumeration.next();
            String name = pair.getName();
            String className = pair.getClassName();
            try {
                type = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                type = context.lookup(name).getClass();
            }
            this.registerIfResource(type, root, name);
        }
    }

    protected void registerIfResource(Class type, String root, String name) {
        if (DataSource.class.isAssignableFrom(type)) {
            this.bindResource("javax.sql.DataSource", root, name);
        }
        if (XADataSource.class.isAssignableFrom(type)) {
            this.bindResource("javax.sql.XADataSource", root, name);
        }
        if (ConnectionPoolDataSource.class.isAssignableFrom(type)) {
            this.bindResource("javax.sql.ConnectionPoolDataSource", root, name);
        }
        if (Queue.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.Queue", root, name);
        }
        if (Topic.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.Topic", root, name);
        }
        if (ConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.ConnectionFactory", root, name);
        }
        if (QueueConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.QueueConnectionFactory", root, name);
        }
        if (TopicConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.TopicConnectionFactory", root, name);
        }
        if (XAConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.XAConnectionFactory", root, name);
        }
        if (XAQueueConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.XAQueueConnectionFactory", root, name);
        }
        if (XATopicConnectionFactory.class.isAssignableFrom(type)) {
            this.bindResource("javax.jms.XATopicConnectionFactory", root, name);
        }
    }

    protected void bindResource(String type, String root, String name) {
        if (this.enabledTypes != null && !this.enabledTypes.contains(type)) {
            return;
        }
        ArrayList<ResourceInfo> preexisting = (ArrayList<ResourceInfo>)this.types.get(type);
        if (preexisting == null) {
            preexisting = new ArrayList<ResourceInfo>();
        }
        preexisting.add(new ResourceInfo(root.length() == 0 ? name : root + "/" + name));
        if (preexisting.size() == 1) {
            this.types.put(type, preexisting);
        }
    }

    public String getDisplayName() {
        return "Context resource provider for " + (this.context == null ? "<generic context>" : this.context.toString());
    }

    public String getDescription() {
        return "A resource provider that supplies the content of an arbitary context specified by the init parameters. For init parameter values see the JNDI API.";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getHandledTypes() {
        return this.types.keySet();
    }

    public ResourceInfo getDefaultResource(String type) {
        List resources = (List)this.types.get(type);
        if (resources != null) {
            return (ResourceInfo)resources.get(0);
        }
        return null;
    }

    public Set getResources(String type) {
        return new HashSet((Collection)this.types.get(type));
    }

    public Object getResource(String name) throws InstantiationException {
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new InstantiationException("Error looking up resource '" + name + "': " + e.getMessage());
        }
    }
}

