/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.AdminObject;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.InboundResourceAdapter;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.OutboundResourceAdapter15;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.server.connector.deployment.SecurityPermission;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAdapter15
extends AbstractDescribable
implements XMLizable,
ResourceAdapterDescriptor {
    protected String m_resourceAdapterClass;
    protected List m_resourceAdapterConfigurationProperties;
    protected OutboundResourceAdapter15 m_outboundResourceAdapter;
    protected InboundResourceAdapter m_inboundResourceAdapter;
    protected List m_adminObjects;
    protected List m_securityPermissions;

    public ResourceAdapter15() {
    }

    public ResourceAdapter15(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("resourceadapter-class")) {
                    this.m_resourceAdapterClass = value;
                    continue;
                }
                if (nodeName.equals("outbound-resourceadapter")) {
                    this.m_outboundResourceAdapter = new OutboundResourceAdapter15(node);
                    continue;
                }
                if (nodeName.equals("inbound-resourceadapter")) {
                    this.m_inboundResourceAdapter = new InboundResourceAdapter(node);
                    continue;
                }
                if (nodeName.equals("adminobject")) {
                    this.addAdminObject(new AdminObject(node));
                    continue;
                }
                if (nodeName.equals("security-permission")) {
                    this.addSecurityPermission(new SecurityPermission(node));
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addResourceAdapterConfigurationProperty(new ConfigurationProperty(node));
                    continue;
                }
                throw new InstantiationException("Unknown resourceadapter subtag: " + nodeName);
            }
        }
    }

    public void addResourceAdapterConfigurationProperty(ConfigurationProperty property) {
        if (this.m_resourceAdapterConfigurationProperties == null) {
            this.m_resourceAdapterConfigurationProperties = new ArrayList();
        }
        this.m_resourceAdapterConfigurationProperties.add(property);
    }

    public String getResourceAdapterClass() {
        return this.m_resourceAdapterClass;
    }

    public List getResourceAdapterConfigurationProperties() {
        if (this.m_resourceAdapterConfigurationProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_resourceAdapterConfigurationProperties;
    }

    public void addAdminObject(AdminObject adminObject) {
        if (this.m_adminObjects == null) {
            this.m_adminObjects = new ArrayList();
        }
        this.m_adminObjects.add(adminObject);
    }

    public List getAdminObjects() {
        if (this.m_adminObjects == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_adminObjects;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this.m_outboundResourceAdapter;
    }

    public InboundResourceAdapter getInboundResourceAdapter() {
        return this.m_inboundResourceAdapter;
    }

    public void addSecurityPermission(SecurityPermission permission) {
        if (this.m_securityPermissions == null) {
            this.m_securityPermissions = new ArrayList();
        }
        this.m_securityPermissions.add(permission);
    }

    public List getSecurityPermissions() {
        if (this.m_securityPermissions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_securityPermissions;
    }

    public boolean equals(Object other) {
        if (other instanceof ResourceAdapter15) {
            return ((ResourceAdapter15)other).getName().equals(this.getName());
        }
        return false;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<resourceadapter>");
        if (this.m_resourceAdapterClass != null) {
            out.println(indention + "\t<resourceadapter-class>" + XMLUtils.encode(this.m_resourceAdapterClass) + "</resourceadapter-class>");
        }
        if (this.m_resourceAdapterConfigurationProperties != null) {
            XMLUtils.writeAll(this.m_resourceAdapterConfigurationProperties, out, indention + "\t");
        }
        if (this.m_outboundResourceAdapter != null) {
            this.m_outboundResourceAdapter.writeXML(out, indention + "\t");
        }
        if (this.m_inboundResourceAdapter != null) {
            this.m_inboundResourceAdapter.writeXML(out, indention + "\t");
        }
        if (this.m_securityPermissions != null) {
            XMLUtils.writeAll(this.m_securityPermissions, out, indention + "\t");
        }
        if (this.m_adminObjects != null) {
            XMLUtils.writeAll(this.m_adminObjects, out, indention + "\t");
        }
        out.println(indention + "</resourceadapter>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
    }
}

