/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.auth;

import com.evermind.server.auth.OC4JPrincipal;
import com.evermind.server.rmi.RMIContext;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import oracle.j2ee.rmi.RMIInitialContextFactory;

public class OC4JLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private OC4JPrincipal userPrincipal;
    private RMIContext rmiContext;
    private boolean askForRetry = true;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean login() throws LoginException {
        LoginException exception;
        ConfirmationCallback retryCallback;
        Map environment = this.sharedState;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[3];
        String previousUsername = (String)environment.get("java.naming.security.principal");
        String previousURL = (String)environment.get("java.naming.provider.url");
        if (previousURL == null) {
            previousURL = "ormi://";
        }
        callbacks[0] = previousUsername == null ? new NameCallback("Username") : new NameCallback("Username", previousUsername);
        callbacks[1] = new PasswordCallback("Password", false);
        callbacks[2] = new TextInputCallback("URL", previousURL);
        do {
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[0]).getName();
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmpPassword == null) {
                    tmpPassword = new char[]{};
                }
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                ((PasswordCallback)callbacks[1]).clearPassword();
                String url = ((TextInputCallback)callbacks[2]).getText();
                if (this.username != null) {
                    environment.put("java.naming.security.principal", this.username);
                }
                if (this.password != null) {
                    environment.put("java.naming.security.credentials", new String(this.password));
                }
                if (url != null) {
                    environment.put("java.naming.provider.url", url);
                }
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
            }
            if (this.debug) {
                System.out.println("\t\t[OC4JLoginModule] user entered username: " + this.username);
                System.out.print("\t\t[SampleLoginModule] user entered password: ");
                for (int i = 0; i < this.password.length; ++i) {
                    System.out.print(this.password[i]);
                }
                System.out.println();
            }
            exception = null;
            try {
                this.rmiContext = (RMIContext)new RMIInitialContextFactory().getInitialContext(new Hashtable(environment));
                if (this.debug) {
                    System.out.println("\t\t[OC4JLoginModule] authentication succeeded");
                }
                this.succeeded = true;
                return true;
            }
            catch (SecurityException e) {
                this.authenticationFailed();
                exception = new FailedLoginException(e.getMessage());
            }
            catch (NamingException e) {
                this.authenticationFailed();
                exception = new LoginException(e.getMessage());
            }
            if (this.succeeded || !this.askForRetry) {
                throw exception;
            }
            retryCallback = new ConfirmationCallback(exception.getMessage(), 2, 0, 0);
            try {
                this.callbackHandler.handle(new Callback[]{retryCallback});
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
            }
        } while (retryCallback.getSelectedIndex() == 0);
        throw exception;
    }

    private void authenticationFailed() throws FailedLoginException {
        if (this.debug) {
            System.out.println("\t\t[OC4JLoginModule] authentication failed");
        }
        this.succeeded = false;
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        throw new FailedLoginException("Password Incorrect");
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new OC4JPrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[SampleLoginModule] added SamplePrincipal to Subject");
        }
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    public RMIContext getRMIContext() {
        return this.rmiContext;
    }
}

