/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.security.SecuritySensitive;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationState;
import com.evermind.server.ContextContainer;
import com.evermind.server.DataSharedBetweenStates;
import com.evermind.server.ServerApplicationClientLauncherImpl;
import com.evermind.server.ServerMessages;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.connector.deployment.ConnectorPropertySet;
import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.server.connector.deployment.SharedConnectionPool;
import com.evermind.server.deployment.ApplicationClientServerArchive;
import com.evermind.server.deployment.ClientModule;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.ResourceProvider;
import com.evermind.server.deployment.ResourceProviderDescriptor;
import com.evermind.server.deployment.ResourceProviderFilter;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.IncrementalDeploymentHandler;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.PersistenceUnitManagerFactory;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpSite;
import com.evermind.util.ConfigUtils;
import com.evermind.util.LogEvent;
import com.evermind.util.TaskManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.util.VersionNumber;
import oracle.dms.instrument.NounIntf;
import oracle.ias.container.persistence.InternalPMManager;
import oracle.j2ee.connector.DeployedAdapter;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.ResourceAdapter;
import oracle.oc4j.loader.OC4JProtectionPolicy;
import oracle.oc4j.loader.config.ConfigurationConsumer;
import oracle.oc4j.loader.config.ImportedSharedLibrariesType;
import oracle.oc4j.loader.config.OC4JConfigurationType;
import oracle.oc4j.sql.ConnectionPoolImpl;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourcesConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.XARecoveryConfig;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;

public class ApplicationStateRunning
extends ApplicationState {
    private static Logger m_logger = TraceLogger.getLogger(ApplicationStateRunning.class);
    private Map clients;
    private List m_deployedAdapters;
    private long startTime;
    private Map webApplications;
    private List m_activeAdapters;
    private ResourceProvider[] resourceProviders;
    private PolicyClassLoader classLoader;
    private EJBContainer ejbContainer;
    private PersistenceUnitManager persistenceUnitManager;

    public ApplicationStateRunning(Application application, DataSharedBetweenStates sharedData) {
        super(application);
        this.sharedData = sharedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void initializeApplication(ApplicationConfig config, Notifier notifier) throws InstantiationException {
        ContextContainer origContextContainer;
        ThreadState threadState;
        block16: {
            ClassLoader applicationContextClassLoader2;
            this.webApplications = null;
            boolean resetClassLoader = false;
            threadState = ThreadState.getCurrentState();
            origContextContainer = threadState.contextContainer;
            threadState.contextContainer = this.application;
            String appName = this.application.getName();
            try {
                ClassLoader currentContextClassLoader;
                if (notifier != null) {
                    notifier.sendNotification("INITIALIZING_CLASSLOADER");
                }
                this.initClassLoaders(config);
                ServerMessages.infoInitializingClassLoader(this.classLoader.getUniqueName());
                if (this.application.getName().equals("system") && (currentContextClassLoader = Thread.currentThread().getContextClassLoader()) != this.classLoader) {
                    ServerMessages.warningContextClassLoaderNeedsReset(currentContextClassLoader.toString(), this.classLoader.toString());
                    m_logger.warning("The classloader associated with this thread is: " + currentContextClassLoader + ", it should actually be: " + this.classLoader);
                    resetClassLoader = true;
                    AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), (ClassLoader)this.classLoader));
                }
                this.application.setRMIContextClassLoader((ClassLoader)this.classLoader);
                m_logger.fine("Initializing the resource providers");
                this.initResourceProviders(config.getResourceProviders());
                ServerMessages.infoInitializedResourceProviders();
                IncrementalDeploymentHandler handler = null;
                if (this.sharedData != null && this.sharedData.getSharedEjbContainer() != null) {
                    handler = this.sharedData.getSharedEjbContainer().getIncrementalDeploymentHandler();
                    this.sharedData.getSharedEjbContainer().destroyNonTimerObjects();
                    this.sharedData.setSharedEjbContainer(null);
                }
                if (!this.application.isDevTestMode()) {
                    this.ejbContainer = new EJBContainer(this.application, this.parent == null ? null : this.parent.getEJBContainer());
                    ServerMessages.infoEJBContainerInitializing();
                } else {
                    this.ejbContainer = this.application.getEJBContainer();
                }
                this.ejbContainer.setIncrementalDeploymentHandler(handler);
                if (notifier != null) {
                    notifier.sendNotification("EJB_CONTAINER_INITIALIZING");
                }
                this.ejbContainer.preInit(config.getEJBContainerConfig(), this.classLoader);
                config.initUserManagers((ClassLoader)this.classLoader);
                this.application.setUserManager(config.getUserManager());
                if (this.application.getParent() == null) {
                    SecuritySensitive.setGlobal(config.getSensitiveManager());
                }
                if (notifier != null) {
                    notifier.sendNotification("LOADING_CONNECTORS");
                }
                ServerMessages.infoLoadingConnectors();
                if (config.getConnectorModules() != null && !config.getConnectorModules().isEmpty()) {
                    this.m_deployedAdapters = this.loadConnectors(config, notifier);
                }
                ServerMessages.infoInitializingDataSources();
                m_logger.fine("Initializing data sources");
                this.initDataSources(config.getDataSourcesConfig());
                this.application.setMailSessions(config.getMailSessions());
                this.application.addJ2EEApplicationMBean(notifier);
                this.initConnectors(notifier);
                if (((EnterpriseArchive)config).getCompatibility() >= 1 || this.application.getConfig().getContext() == null) {
                    this.setPersistenceUnitManager(PersistenceUnitManagerFactory.createPersistenceUnitManager(this.application));
                    if (this.getPersistenceUnitManager() != null) {
                        this.getPersistenceUnitManager().initialize();
                    }
                }
                this.ejbContainer.postInit(config.getEJBContainerConfig(), notifier);
                ServerMessages.infoEjbContainerInitialized();
                if (notifier != null) {
                    notifier.sendNotification("COMMITING_CLASSLOADER");
                }
                this.classLoader.commit();
                ServerMessages.infoClassLoaderCommitted(this.classLoader.getUniqueName(), this.classLoader.toString());
                ServerMessages.infoInitializingAppClients();
                m_logger.fine("Initializing application clients");
                this.startClients(notifier, config);
                if (this.sharedData == null) {
                    this.sharedData = new DataSharedBetweenStates();
                }
                this.sharedData.setSharedEjbContainer(this.ejbContainer);
                config.validateUserManagers();
                Object var9_8 = null;
                if (!resetClassLoader) break block16;
                m_logger.warning("Thread has the wrong classloader. Resetting the classloader associated with this thread to be that of the thread pool's classloader");
                applicationContextClassLoader2 = this.server.getThreadPool().getClassLoader();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (resetClassLoader) {
                    m_logger.warning("Thread has the wrong classloader. Resetting the classloader associated with this thread to be that of the thread pool's classloader");
                    ClassLoader applicationContextClassLoader2 = this.server.getThreadPool().getClassLoader();
                    AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), applicationContextClassLoader2));
                }
                threadState.setContextContainer(origContextContainer);
                this.ejbContainer.initReplicationService();
                throw throwable;
            }
            AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), applicationContextClassLoader2));
            {
            }
        }
        threadState.setContextContainer(origContextContainer);
        this.ejbContainer.initReplicationService();
    }

    DeployedAdapter addConnector(ConnectorModule module, String moduleDeploymentPlan, Notifier notifier) throws InstantiationException {
        DeployedAdapter adapter = this.loadConnector(this.application.getConfig(), module, moduleDeploymentPlan, false);
        if (notifier != null) {
            notifier.sendNotification("STARTING_UP_RESOURCE_ADAPTER");
        }
        this.initConnector(adapter, notifier);
        return adapter;
    }

    private List loadConnectors(ApplicationConfig config, Notifier notifier) throws InstantiationException {
        Iterator iterator = config.getConnectorModules().iterator();
        ArrayList<DeployedAdapter> adapters = new ArrayList<DeployedAdapter>();
        this.application.removeAllResourceAdapterModuleMBeans();
        while (iterator.hasNext()) {
            ConnectorModule module = (ConnectorModule)iterator.next();
            try {
                String deplData = (String)this.application.getConfig().getExtraParam(module.getName() + ".rar");
                DeployedAdapter adapter = this.loadConnector(config, module, deplData, true);
                adapters.add(adapter);
            }
            catch (InstantiationException e) {
                String[] params = new String[]{this.application.getName(), e.getMessage()};
                if (notifier != null) {
                    notifier.sendNotification("EMBEDDED_RESOURCE_ADAPTER_NOT_LOADED", params);
                }
                m_logger.warning("Exception loading connector " + module.getName() + " : " + e.getMessage());
            }
        }
        return adapters;
    }

    private void initConnectors(Notifier notifier) throws InstantiationException {
        DeployedAdapter adapter;
        if (this.application.getName().equals(ApplicationServer.getSystemApplicationName())) {
            return;
        }
        if (this.m_deployedAdapters == null) {
            if (this.application.isDefaultApplication()) {
                ApplicationServer.getInstance().setupTransactioning();
            }
            return;
        }
        Iterator iter = this.m_deployedAdapters.iterator();
        if (notifier != null) {
            notifier.sendNotification("STARTING_UP_RESOURCE_ADAPTERS");
        }
        while (iter.hasNext()) {
            adapter = (DeployedAdapter)iter.next();
            if (!adapter.isDatasourceAdapter()) continue;
            ServerMessages.infoInitializingConnector(adapter.getName());
            this.initConnector(adapter, notifier);
        }
        ApplicationServer.getInstance().setupTransactioning();
        iter = this.m_deployedAdapters.iterator();
        while (iter.hasNext()) {
            adapter = (DeployedAdapter)iter.next();
            if (adapter.isDatasourceAdapter()) continue;
            ServerMessages.infoInitializingConnector(adapter.getName());
            this.initConnector(adapter, notifier);
        }
    }

    protected void addActiveResourceAdapter(DeployedAdapter adapter) {
        if (adapter == null) {
            return;
        }
        if (this.m_activeAdapters == null) {
            this.m_activeAdapters = new ArrayList();
        }
        this.m_activeAdapters.add(0, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized HttpApplication getHttpApplication(String name, String root, boolean share, long maxInactivityTime, boolean accessLog, HttpSite site, boolean forceLoad) throws InstantiationException {
        HttpApplication application = null;
        if (share) {
            if (this.webApplications == null) {
                this.webApplications = new HashMap();
            }
            if ((application = (HttpApplication)this.webApplications.get(name)) != null && application.isShared()) {
                return application;
            }
        }
        if (!forceLoad) {
            return null;
        }
        HttpApplicationConfig config = this.application.getHttpApplicationConfig(name);
        if (config == null) {
            return null;
        }
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            state.contextContainer = this.application;
            application = new HttpApplication(this.application, site, config, root, name, share, accessLog);
        }
        finally {
            state.contextContainer = previousContainer;
        }
        if (share) {
            this.webApplications.put(name, application);
        }
        return application;
    }

    EJBContainer getEJBContainer() {
        return this.ejbContainer;
    }

    PolicyClassLoader getBeansClassLoader() {
        return this.classLoader;
    }

    Application getParent() {
        return this.application.getParent();
    }

    synchronized void flushDynamicLoaders() {
    }

    String getejbClassLoaderPath() {
        return this.getFullPath((ClassLoader)this.getBeansClassLoader());
    }

    byte[] getiiopStubs(ApplicationConfig config) throws IOException {
        try {
            Context ctx = config.getDeploymentContext();
            byte[] clientJarBytes = (byte[])ctx.lookup("_iiopClient.jar");
            return clientJarBytes;
        }
        catch (NameNotFoundException e) {
            throw new FileNotFoundException("IIOP client stubs jar file not found. " + e.getMessage());
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    boolean isInitialized() {
        return this.startTime != 0L;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    final long getstartTime() {
        return this.startTime;
    }

    DeployedAdapter getResourceAdapter(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (this.m_activeAdapters != null) {
            Iterator iter = this.m_activeAdapters.iterator();
            while (iter.hasNext()) {
                DeployedAdapter adapter = (DeployedAdapter)iter.next();
                if (!name.equals(adapter.getOc4jDescriptorConfig().getResourceAdapterWrapperLocation())) continue;
                return adapter;
            }
        }
        return null;
    }

    ResourceAdapterWrapper lookupResourceAdapter(String name) throws NamingException {
        DeployedAdapter adapter = this.getResourceAdapter(name);
        if (adapter == null) {
            if (this.parent != null) {
                return this.parent.lookupResourceAdapter(name);
            }
            throw new NameNotFoundException("No resource adapter named '" + name + "' found in application '" + this.application.getName() + "'");
        }
        return adapter.getResourceAdapterWrapper();
    }

    DeployedAdapter getActiveDeployedAdapter(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (this.m_activeAdapters != null) {
            Iterator iter = this.m_activeAdapters.iterator();
            while (iter.hasNext()) {
                DeployedAdapter adapter = (DeployedAdapter)iter.next();
                if (!name.equals(adapter.getOc4jDescriptorConfig().getName())) continue;
                return adapter;
            }
        }
        return null;
    }

    public ResourceProvider[] getResourceProviders() {
        return this.resourceProviders;
    }

    synchronized void stopClients(Notifier notifier) {
        if (this.clients == null) {
            return;
        }
        if (notifier != null) {
            notifier.sendNotification("STOPPING_APPLICATION_CLIENTS");
        }
        Iterator iterator = this.clients.values().iterator();
        while (iterator.hasNext()) {
            ServerApplicationClientLauncherImpl appClientLauncherImpl = (ServerApplicationClientLauncherImpl)iterator.next();
            appClientLauncherImpl.stop();
        }
        this.clients.clear();
    }

    private String getFullPath(ClassLoader loader) {
        StringBuffer buf = new StringBuffer();
        while (loader != null) {
            buf.append(loader.toString());
            loader = loader.getParent();
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForComponentUpdates(String webApplicationConfigsLock, Map webApplicationConfigs) {
        String string = webApplicationConfigsLock;
        synchronized (string) {
            if (webApplicationConfigs == null) {
                return;
            }
            Iterator iterator = webApplicationConfigs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                HttpApplicationConfig descriptor = (HttpApplicationConfig)entry.getValue();
                if (!descriptor.isUpdated()) continue;
                iterator.remove();
                ApplicationStateRunning applicationStateRunning = this;
                synchronized (applicationStateRunning) {
                    if (this.webApplications != null) {
                        this.webApplications.remove(entry.getKey().toString());
                    }
                }
                ApplicationServer server = this.application.getServer();
                if (server.getHttpServer() == null) continue;
                server.getHttpServer().invalidateHttpApplications(new HttpApplicationReference(this.application.getName(), entry.getKey().toString()));
            }
        }
    }

    void recordApplicationStartTime() {
        this.startTime = System.currentTimeMillis();
        m_logger.fine("application was started at: " + this.startTime);
    }

    void addResourceProvider(ResourceProviderDescriptor descriptor) throws InstantiationException {
        if (this.resourceProviders != null) {
            for (int i = 0; i < this.resourceProviders.length; ++i) {
                if (!descriptor.getName().equals(this.resourceProviders[i].getName())) continue;
                this.updateResourceProvider(descriptor, i);
                return;
            }
        }
        int resourceProvidersLength = this.resourceProviders == null ? 0 : this.resourceProviders.length;
        ResourceProvider[] updatedResourceProviders = new ResourceProvider[resourceProvidersLength + 1];
        if (resourceProvidersLength > 0) {
            System.arraycopy(this.resourceProviders, 0, updatedResourceProviders, 0, resourceProvidersLength);
        }
        ResourceProvider newResourceProvider = (ResourceProvider)this.loadClassForResourceProviderDescriptor(descriptor);
        newResourceProvider.setName(descriptor.getName());
        ServerMessages.infoInitializingResourceProvider(descriptor.getName());
        newResourceProvider.init(descriptor.getProperties() == null ? new HashMap() : descriptor.getProperties());
        updatedResourceProviders[resourceProvidersLength] = newResourceProvider;
        this.resourceProviders = updatedResourceProviders;
    }

    private void updateResourceProvider(ResourceProviderDescriptor descriptor, int i) throws InstantiationException {
        ResourceProvider newResourceProvider = (ResourceProvider)this.loadClassForResourceProviderDescriptor(descriptor);
        newResourceProvider.setName(descriptor.getName());
        ServerMessages.infoInitializingResourceProvider(descriptor.getName());
        newResourceProvider.init(descriptor.getProperties() == null ? new HashMap() : descriptor.getProperties());
        this.resourceProviders[i] = newResourceProvider;
    }

    private void initResourceProviders(List resourceProviderConfigurations) throws InstantiationException {
        this.resourceProviders = null;
        if (resourceProviderConfigurations != null && !resourceProviderConfigurations.isEmpty()) {
            ResourceProvider[] resourceProviders = new ResourceProvider[resourceProviderConfigurations.size()];
            for (int i = 0; i < resourceProviders.length; ++i) {
                ResourceProviderDescriptor descriptor = (ResourceProviderDescriptor)resourceProviderConfigurations.get(i);
                Object instance = this.loadClassForResourceProviderDescriptor(descriptor);
                try {
                    resourceProviders[i] = (ResourceProvider)instance;
                }
                catch (ClassCastException e) {
                    throw new InstantiationException("resource-provider class '" + descriptor.getClassName() + "' did not implement com.evermind.server.deployment.ResourceProvider");
                }
                resourceProviders[i].setName(descriptor.getName());
                ServerMessages.infoInitializingResourceProvider(descriptor.getName());
                resourceProviders[i].init(descriptor.getProperties() == null ? new HashMap() : descriptor.getProperties());
            }
            this.resourceProviders = resourceProviders;
        }
    }

    Object loadClassForResourceProviderDescriptor(ResourceProviderDescriptor descriptor) throws InstantiationException {
        Object instance;
        try {
            String providerClassName = ResourceProviderFilter.mapProvider(descriptor.getClassName());
            instance = this.classLoader.loadClass(providerClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("resource-provider class '" + descriptor.getClassName() + "' not found");
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Error instantiating resource-provider '" + descriptor.getClassName() + "': " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Error instantiationg resource-provider '" + descriptor.getClassName() + "', illegal access modifier on type");
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void startClients(Notifier notifier, ApplicationConfig config) throws InstantiationException {
        Collection clients = config.getClients();
        if (clients.size() <= 0) {
            return;
        }
        Iterator iterator = clients.iterator();
        while (iterator.hasNext()) {
            String[] params;
            ClientModule client = (ClientModule)iterator.next();
            if (notifier != null) {
                params = new String[]{client.getName()};
                notifier.sendNotification("INSTALLING_APPLICATION_CLIENT", params);
            }
            if (config.getContext() instanceof LastModifiedContainer) {
                boolean investigate = false;
                String path = client.getPath().endsWith(".jar") ? client.getPath() : client.getPath() + "/META-INF/application-client.xml";
                try {
                    long lastModified = ((LastModifiedContainer)((Object)config.getContext())).getLastModified(path);
                    long deploymentLastModified = ((LastModifiedContainer)((Object)config.getDeploymentContext())).getLastModified(client.getName());
                    if (lastModified > client.getDeploymentTime() && lastModified > deploymentLastModified || lastModified <= 0L) {
                        investigate = true;
                    }
                }
                catch (IOException e) {
                    investigate = true;
                }
                if (investigate) {
                    try {
                        void var10_21;
                        Context clientContext;
                        ApplicationClientServerArchive archive = config.getClientArchive(client.getPath(), (ClassLoader)this.classLoader);
                        if (client.getAltDD() != null) {
                            URL url = this.application.getConfig().getURL();
                            String absoluteAltDD = ConfigUtils.getAbsolutePath(url, client.getAltDD());
                            archive.setAltDD(absoluteAltDD);
                        }
                        archive.init();
                        Context deploymentContext = this.application.getConfig().getDeploymentContext();
                        try {
                            clientContext = (Context)deploymentContext.lookup(client.getName());
                        }
                        catch (NameNotFoundException e) {
                            try {
                                File clientFile = new File(client.getName());
                                clientContext = clientFile.isDirectory() ? ContextUtils.getContext(clientFile.toURL(), false) : deploymentContext.createSubcontext(client.getName());
                            }
                            catch (NamingException ne) {
                                if (notifier != null) {
                                    try {
                                        String[] params2 = new String[]{client.getName()};
                                        notifier.sendNotification("ERROR_CREATING_CONTEXT_FOR", params2, ne);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                throw new InstantiationException("Error create context for " + client.getName() + " : " + ne.getMessage());
                            }
                        }
                        catch (NamingException e) {
                            if (notifier != null) {
                                try {
                                    String[] params3 = new String[]{client.getName()};
                                    notifier.sendNotification("ERROR_LOOKUP_CONTEXT_FOR", params3, e);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            throw new InstantiationException("Error lookup  context for " + client.getName() + " : " + e.getMessage());
                        }
                        archive.setDeploymentContext((Context)var10_21);
                        String deplData = (String)this.application.getConfig().getExtraParam(client.getName() + ".jar");
                        if (deplData != null) {
                            archive.setDeploymentData(deplData);
                        }
                        String reason = archive.initDeployment();
                        archive.doServiceRefCodeGeneration(this.application);
                        archive.storeDeployment();
                        if (reason != null || archive.getMailSessions() != null && archive.getMailSessions().size() != 0) {
                            System.out.print("Auto-deploying " + client.getName() + " (" + reason + ")... ");
                            System.out.flush();
                            try {
                                String clientName = client.getName();
                                Context targetContextParent = this.shouldDeployWithConfigContext(config) ? config.getDeploymentContext() : null;
                                archive.deploy(this.application, targetContextParent, clientName);
                                if (this.shouldDeployWithConfigContext(config)) {
                                    try {
                                        System.out.print("(wrote deployed archive to " + config.getDeploymentContext().getNameInNamespace() + File.separatorChar + clientName + ") ");
                                        System.out.flush();
                                    }
                                    catch (NamingException e) {}
                                }
                            }
                            catch (IOException e) {
                                if (notifier != null) {
                                    try {
                                        String[] params4 = new String[]{client.getName()};
                                        notifier.sendNotification("IO_ERROR_DEPLOYING", params4, e);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                System.err.println("IO Error deploying " + client.getName() + ": " + e.getMessage());
                                this.application.getLogger().log(new LogEvent("IO Error deploying " + client.getName() + ": " + e.getMessage()));
                            }
                            this.application.getLogger().log(new LogEvent("Auto-deploying " + client.getName() + "... done."));
                        }
                        client.setDeploymentTime(((LastModifiedContainer)((Object)config.getContext())).getLastModified(path));
                        this.application.getTransportManager().createTransportApplicationContext(this.application.getName(), this.application.getContext());
                        ((EnterpriseArchive)config).storeDeployment();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        throw new InstantiationException("Error auto-deploying application-client at " + client.getName() + ": " + e.getMessage());
                    }
                    catch (IOException e) {
                        if (notifier != null) {
                            try {
                                String[] params5 = new String[]{client.getName()};
                                notifier.sendNotification("ERROR_LOADING_APP_CLIENT", params5, e);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw new InstantiationException("Error loading application-client at " + client.getName() + ": " + e.getMessage());
                    }
                }
            }
            if (client.getAutoStart()) {
                if (notifier != null) {
                    try {
                        params = new String[]{client.getName()};
                        notifier.sendNotification("STARTING_APP_CLIENT", params);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (this.clients == null || !this.clients.containsKey(client.getPath())) {
                    try {
                        if (client.getUsername() == null) {
                            String msg = "No user specified for application-client " + client.getName() + ", needed when auto-start=\"true\"";
                            if (notifier != null) {
                                try {
                                    String[] params6 = new String[]{client.getName()};
                                    notifier.sendNotification("MISSING_REQUIRED_USER_FOR_APP_CLIENT_IN_AUTO_START", params6);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            throw new InstantiationException(msg);
                        }
                        User user = this.application.getUserManager().getUser(client.getUsername());
                        if (user == null) {
                            throw new InstantiationException("User specified for application-client " + client.getName() + ", '" + client.getUsername() + "' not found");
                        }
                        this.application.getLogger().log(new LogEvent("Auto-starting " + client.getName() + "..."));
                        this.startClient(client, user);
                    }
                    catch (IOException e) {
                        if (notifier != null) {
                            notifier.sendErrorNotification(e);
                        }
                        throw new InstantiationException("Error starting " + this + ", IO Error: " + e.getMessage());
                    }
                }
            }
            this.application.addAppClientModuleMBean(client, config);
        }
    }

    private boolean shouldDeployWithConfigContext(ApplicationConfig config) {
        boolean deploywith = ((EnterpriseArchive)config).isSeparateDeploymentContext() && config.getContext() instanceof MemoryArchiveContext;
        return deploywith;
    }

    private synchronized void startClient(ClientModule client, User user) throws InstantiationException, IOException {
        try {
            ApplicationClientServerArchive archive = this.application.getConfig().getClientArchive(client.getPath(), (ClassLoader)this.classLoader);
            archive.init();
            ServerApplicationClientLauncherImpl serverAppClientLauncherImpl = new ServerApplicationClientLauncherImpl(client, this.application, archive, user, (ClassLoader)this.classLoader);
            serverAppClientLauncherImpl.start();
            if (this.clients == null) {
                this.clients = new HashMap();
            }
            this.clients.put(client.getPath(), serverAppClientLauncherImpl);
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Error starting application-client " + client.getName() + ": " + e.getMessage());
        }
    }

    ResourceProvider getProvider(String name) {
        if (this.resourceProviders == null) {
            return null;
        }
        for (int i = 0; i < this.resourceProviders.length; ++i) {
            if (!name.equals(this.resourceProviders[i].getName())) continue;
            return this.resourceProviders[i];
        }
        return null;
    }

    List getActiveResourceAdapters() {
        return this.m_activeAdapters;
    }

    void destroyActiveRunningStateObjects(com.evermind.util.Logger logger) {
        this.stopOrDestroyActiveRunningStateObjects(logger, true);
    }

    void stopActiveRunningStateObjects(com.evermind.util.Logger logger) {
        this.stopOrDestroyActiveRunningStateObjects(logger, false);
    }

    private void stopOrDestroyActiveRunningStateObjects(com.evermind.util.Logger logger, boolean isDestroy) {
        this.clientsCleanUp(logger);
        m_logger.fine("destroying persistence unit manager");
        this.destroyPersistenceUnitManager();
        m_logger.fine("destroying connectors");
        if (this.m_activeAdapters != null) {
            Iterator iter = this.m_activeAdapters.iterator();
            while (iter.hasNext()) {
                DeployedAdapter adapter = (DeployedAdapter)iter.next();
                if (isDestroy || adapter.isDatasourceAdapter()) {
                    adapter.getOc4jDescriptorConfig().destroy(logger);
                    continue;
                }
                ResourceAdapter resourceAdapterMBean = adapter.getOc4jDescriptorConfig().getResourceAdapterMBean();
                if (resourceAdapterMBean == null) continue;
                resourceAdapterMBean.stop();
            }
        }
        m_logger.fine("cleaning up data sources");
        ApplicationContext applicationContext = this.application.getContext();
        Iterator iter = this.application.getNativeDataSourceConfigs().values().iterator();
        while (iter.hasNext()) {
            NativeDataSourceConfig ndsConfig = (NativeDataSourceConfig)iter.next();
            DataSource dataSource = null;
            try {
                dataSource = (DataSource)applicationContext.lookup(ndsConfig.getJndiName());
                applicationContext.unbind(ndsConfig.getJndiName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dataSource == null) continue;
            try {
                this.application.removeNativeDataSourceMBean(dataSource, ndsConfig);
            }
            catch (MBeanException mBeanException) {
                m_logger.warning("Exception destroying native data source: '" + ndsConfig.getName() + "'.  Exception: " + mBeanException);
            }
        }
        this.application.getNativeDataSourceConfigs().clear();
        this.application.setDataSourceConnectorArchive(null);
        InternalPMManager.getInstance().remove(this.application.getName());
        this.application.resetSessionManager();
    }

    void clientsCleanUp(com.evermind.util.Logger logger) {
        try {
            if (this.clients != null) {
                Iterator iterator = this.clients.values().iterator();
                while (iterator.hasNext()) {
                    ((ServerApplicationClientLauncherImpl)iterator.next()).destroy();
                }
            }
        }
        catch (Throwable t) {
            logger.log(new LogEvent("Error closing applications", t));
        }
        this.clients = null;
    }

    void destroyClassLoaders() {
        if (this.classLoader == null) {
            return;
        }
        this.classLoader.close();
        this.classLoader = null;
    }

    private void initParentClassLoader() {
        if (this.parent != null) {
            if (this.parent.getClassLoader() == null) {
                throw new InternalError("Parent beans-loader was null");
            }
            this.parentClassLoader = this.parent.getClassLoader();
        } else {
            if (this.server.getLibraryClassLoader() == null) {
                throw new InternalError("Server library-loader was null");
            }
            this.parentClassLoader = this.server.getLibraryClassLoader();
        }
    }

    private void createClassLoader(ApplicationConfig config) throws Exception {
        String applicationName = this.application.getName();
        if (applicationName.startsWith("application ")) {
            applicationName = applicationName.substring("application ".length());
        }
        String loaderName = applicationName + ".root";
        ImportedSharedLibrariesType imports = config.getImportedSharedLibraries();
        VersionNumber version = new VersionNumber(0, 0, this.application.getGenerationNumber());
        String configPath = config.getURL().getPath();
        ProtectionPolicy policy = OC4JProtectionPolicy.applicationPolicy(applicationName);
        PolicyClassLoader[] standaloneImports = null;
        boolean isSystemApp = ApplicationServer.getSystemApplicationName().equals(applicationName);
        if (!this.application.isDefaultApplication() && !isSystemApp) {
            standaloneImports = ConnectorArchive.getStandaloneImports();
        }
        this.classLoader = ConfigurationConsumer.createApplicationLoader(loaderName, version, this.parentClassLoader, standaloneImports, configPath, imports, policy);
    }

    private void initClassLoaders(ApplicationConfig config) throws InstantiationException {
        this.initParentClassLoader();
        try {
            this.createClassLoader(config);
            PolicyClassLoader libLoader = this.getApplicationLibrariesLoader();
            String originPath = libLoader.getOrigin().getOrigin();
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_LIBRARY_ELEMENT, originPath);
            List paths = config.getCanonicalLibraryPaths();
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                libLoader.addCodeSource(path, origin);
            }
            this.populateLoaderWithLibraryDirectory(config);
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private void populateLoaderWithLibraryDirectory(ApplicationConfig config) throws IOException {
        if (config.getLibraryDirectory() == null || config.getLibraryDirectory().equals("")) {
            return;
        }
        File libraryDirectory = new File(config.getURL().getFile(), config.getLibraryDirectory());
        if (libraryDirectory.exists()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_LIBRARY_DIRECTORY, libraryDirectory.getPath());
            String[] files = libraryDirectory.list();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                if (!fileName.endsWith(".jar")) continue;
                File file = new File(libraryDirectory, fileName);
                this.classLoader.addCodeSource(file, origin);
            }
        }
    }

    private PolicyClassLoader getApplicationLibrariesLoader() {
        return this.classLoader;
    }

    private void initConnector(DeployedAdapter adapter, Notifier notifier) throws InstantiationException {
        block17: {
            try {
                adapter.start(this.application, this.server.getTaskManager(), notifier);
                if (adapter.getOc4jDescriptorConfig() == this.application.getDataSourceConnectorArchive()) {
                    this.initDataSourceConnector();
                    HashMap connectionManagers = adapter.getOc4jDescriptorConfig().getConnectionManagers();
                    if (connectionManagers != null) {
                        Iterator iter = connectionManagers.values().iterator();
                        while (iter.hasNext()) {
                            ApplicationConnectionManager acm = (ApplicationConnectionManager)iter.next();
                            acm.initConnectionPool();
                        }
                    }
                }
                this.addActiveResourceAdapter(adapter);
                if (adapter.getOc4jDescriptorConfig().isMaintainMBeans()) {
                    adapter.getOc4jDescriptorConfig().addStandardDescriptorMBeans();
                }
            }
            catch (DataSourceException e) {
                javax.resource.spi.ResourceAdapter resourceAdapter = adapter.getResourceAdapter();
                if (resourceAdapter != null) {
                    resourceAdapter.stop();
                }
                if (notifier != null) {
                    if (this.application == this.server.getDefaultApplication()) {
                        notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER");
                    } else {
                        String[] params = new String[]{this.application.getName()};
                        notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER_IN", params);
                    }
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String msg = "Error occurred initializing connectors.  Exception is: " + e.getMessage();
                m_logger.severe(msg);
                m_logger.severe("Stack trace: " + sw.toString());
                throw new InstantiationException(msg);
            }
            catch (DataSourceConfigException e) {
                if (notifier != null) {
                    if (this.application == this.server.getDefaultApplication()) {
                        notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER");
                    } else {
                        String[] params = new String[]{this.application.getName()};
                        notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER_IN", params);
                    }
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String msg = "Error occurred initializing connectors.  Exception is: " + e.getMessage();
                m_logger.severe(msg);
                m_logger.severe("Stack trace: " + sw.toString());
                throw new InstantiationException(msg);
            }
            catch (InstantiationException e) {
                if (this.application == this.server.getDefaultApplication()) {
                    String msg = "Warning: Unable to set up connection factory for a  resource adapter deployed as stand-alone:'" + e.getMessage();
                    System.out.println(msg);
                    if (notifier != null) {
                        notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER");
                    }
                }
                String msg = "Warning: Unable to set up connection factory for a resource adapter in " + this.application.getName() + ": " + e.getMessage();
                System.out.println(msg);
                if (notifier == null) break block17;
                String[] params = new String[]{this.application.getName()};
                notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER_IN", params);
            }
        }
    }

    private DeployedAdapter loadConnector(ApplicationConfig config, ConnectorModule module, String moduleDeploymentPlan, boolean isStartup) throws InstantiationException {
        Context context;
        File moduleFile;
        try {
            moduleFile = new File(module.getPath());
            context = module.getName().equals("datasources") ? ContextUtils.getContext(moduleFile.toURL(), false) : (config.getContext() != null && !moduleFile.isDirectory() ? ContextUtils.getContext(config.getContext(), module.getPath(), false) : ContextUtils.getContext(moduleFile.toURL(), false));
        }
        catch (NamingException e) {
            throw new InstantiationError("Error loading connector-archive '" + module.getPath() + "' in application '" + this.application.getName() + "': " + e.getMessage());
        }
        catch (IOException e) {
            throw new InstantiationError("Error loading connector-archive '" + module.getPath() + "' in application '" + this.application.getName() + "': " + e.getMessage());
        }
        DeployedAdapter adapter = new DeployedAdapter(module);
        ConnectorArchive archive = adapter.getOc4jDescriptorConfig();
        archive.setContext(context);
        archive.init();
        if (config != null && ((EnterpriseArchive)config).isSeparateDeploymentContext()) {
            Context deploymentContext;
            if (moduleFile.isDirectory() && ((EnterpriseArchive)config).isExplodedDeployment()) {
                try {
                    Context ctx = ContextUtils.getContext(moduleFile.toURL(), false);
                    if (ctx.lookup("META-INF") != null) {
                        deploymentContext = (Context)ctx.lookup("META-INF");
                    }
                    deploymentContext = ctx.createSubcontext("META-INF");
                }
                catch (NamingException ne) {
                    throw new InstantiationException("Error creating deployment directory: " + ne.getMessage());
                }
                catch (IOException io) {
                    throw new InstantiationException("Error creating deployment directory: " + io.getMessage());
                }
            } else {
                deploymentContext = config.getDeploymentContext();
                if (deploymentContext != null) {
                    try {
                        deploymentContext = (Context)deploymentContext.lookup(module.getName());
                    }
                    catch (NamingException e) {
                        try {
                            deploymentContext = deploymentContext.createSubcontext(module.getName());
                        }
                        catch (NamingException ne) {
                            throw new InstantiationException("Error creating deployment directory: " + e.getMessage());
                        }
                    }
                }
            }
            if (deploymentContext != null) {
                archive.setDeploymentContext(deploymentContext);
            }
        }
        if (moduleDeploymentPlan != null) {
            archive.setDeploymentData(moduleDeploymentPlan);
        }
        archive.initDeployment();
        try {
            if (adapter.isDatasourceAdapter()) {
                this.application.setDataSourceConnectorArchive(archive);
            } else {
                archive.storeDeployment();
            }
        }
        catch (IOException e) {
            throw new InstantiationError("Error initializing connector-archive '" + module.getPath() + "' in application '" + this.application.getName() + "': " + e.getMessage());
        }
        module.setResourceAdapterDescriptor(archive.getResourceAdapterDescriptor());
        if (module.getName().equals("datasources")) {
            if (this.application.isDefaultApplication()) {
                module.setApplication(this.application);
            }
        } else {
            module.setApplication(this.application);
        }
        if (!isStartup || module.isAppNullOrNotDefault()) {
            module.persistConfigChange();
        }
        archive.preInit((ClassLoader)this.classLoader, module, this.application);
        if (!module.isDataSourceModule()) {
            this.application.addResourceAdapterModuleMBean(module);
        }
        return adapter;
    }

    void initDataSources(DataSourcesConfig dataSourcesConfig) throws InstantiationException {
        NativeDataSourceConfig[] nativeDataSourceConfigs = dataSourcesConfig.getNativeDataSources();
        if (nativeDataSourceConfigs != null) {
            for (int i = 0; i < nativeDataSourceConfigs.length; ++i) {
                try {
                    ServerMessages.infoInitializingDataSource(nativeDataSourceConfigs[i].getName());
                    this.initNativeDataSource(nativeDataSourceConfigs[i], false);
                    continue;
                }
                catch (Exception exception) {
                    throw new InstantiationException(exception.getMessage());
                }
            }
        }
    }

    synchronized void initNativeDataSource(NativeDataSourceConfig config, boolean addToAppConfig) throws DataSourceException, MBeanException, DataSourceConfigException {
        String dataSourceName = config.getName();
        String msg = "";
        if (!this.isDataSourceNameUnique(config.getName())) {
            msg = ServerMessages.getMessageDSCreateCompNameInUse("native data source", config.getName());
            throw new DataSourceException(msg);
        }
        String jndiLocation = config.getJndiName();
        DataSource nativeDataSource = DataSourceUtils.createDataSource(config);
        try {
            this.application.getContext().bind(jndiLocation, (Object)nativeDataSource);
            this.application.addNativeDataSourceMBean(nativeDataSource, config);
            this.application.getNativeDataSourceConfigs().put(dataSourceName, config);
            if (addToAppConfig) {
                DataSourcesConfig dataSourcesConfig = this.application.getConfig().getDataSourcesConfig();
                dataSourcesConfig.addNativeDataSourceConfig(config);
            }
        }
        catch (NamingException ne) {
            msg = ServerMessages.severeDSCreateNamingException("native data source", ne.getMessage());
            throw new DataSourceException(msg);
        }
        catch (MBeanException mbeanException) {
            msg = ServerMessages.warningDSCreateCreateMBeanException(config.getName(), mbeanException.getTargetException());
            try {
                this.application.getContext().unbind(jndiLocation);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }

    void initManagedDataSource(ManagedDataSourceConfig config, boolean addToAppConfig) throws DataSourceException, DataSourceConfigException {
        if (!this.isDataSourceNameUnique(config.getName())) {
            String msg = ServerMessages.getMessageDSCreateCompNameInUse("managed data source", config.getName());
            throw new DataSourceException(msg);
        }
        ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)this.application.getDataSourceConnectorArchive().getResourceAdapter();
        DataSourceConnectionPool dataSourceConnectionPool = resourceAdapter.getDataSourceConnectionPool(config.getConnectionPoolName());
        if (dataSourceConnectionPool == null) {
            String msg = ServerMessages.warningDSCreateNoConnectionPool(config.getConnectionPoolName());
            m_logger.warning(msg);
            throw new DataSourceException(msg);
        }
        this.addConnectionFactory(config, dataSourceConnectionPool);
        this.application.getManagedDataSourceConfigs().put(config.getName(), config);
        if (addToAppConfig) {
            DataSourcesConfig dataSourcesConfig = this.application.getConfig().getDataSourcesConfig();
            dataSourcesConfig.addManagedDataSourceConfig(config);
        }
    }

    private synchronized void addConnectionFactory(ManagedDataSourceConfig config, DataSourceConnectionPool dsConnectionPool) throws DataSourceException {
        try {
            ConnectorPropertySet cps = new ConnectorPropertySet(this.application.getDataSourceConnectorArchive(), "javax.sql.DataSource", null);
            cps.setName(config.getName() + " JDBC Resource Adapter");
            cps.setLocation(config.getJndiName());
            cps.setUseWhichConnectionPool(2);
            cps.setSharedConnectionPoolName(config.getConnectionPoolName());
            String txLevel = config.getTxLevel();
            if (txLevel.equals("local")) {
                cps.setTransactionSupport(1);
            } else {
                cps.setTransactionSupport(3);
            }
            cps.addConfigProperty("managedDataSourceConfigXML", config.createXMLString());
            XARecoveryConfig xaRecoveryConfig = dsConnectionPool.getConfig().getConnectionFactoryConfig().getXARecoveryConfig();
            if (xaRecoveryConfig != null) {
                cps.addXaRecoveryConfigCredentials(new PrincipalHolder(xaRecoveryConfig.getUsername(), xaRecoveryConfig.getPassword()));
            }
            ConnectorArchive connectorArchive = this.application.getDataSourceConnectorArchive();
            ApplicationConnectionManager connectionManager = connectorArchive.addConnectionFactory(cps, dsConnectionPool.getGlobalInstanceName());
            ManagedConnectionFactoryImpl managedConnectionFactory = (ManagedConnectionFactoryImpl)connectionManager.getMcf();
            this.application.addManagedDataSourceMBean(managedConnectionFactory, config);
        }
        catch (Exception exception) {
            String msg = ServerMessages.severeDSCreateConnectorPropertySetException(exception.getMessage());
            throw new DataSourceException(msg, exception);
        }
    }

    private synchronized boolean isDataSourceNameUnique(String name) {
        HashMap map = this.application.getNativeDataSourceConfigs();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            NativeDataSourceConfig nds = (NativeDataSourceConfig)iter.next();
            if (!nds.getName().equals(name)) continue;
            return false;
        }
        map = this.application.getManagedDataSourceConfigs();
        iter = map.values().iterator();
        while (iter.hasNext()) {
            ManagedDataSourceConfig mds = (ManagedDataSourceConfig)iter.next();
            if (!mds.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    synchronized void copyNativeDataSource(String dataSourceToCopy, String newJndiLocation, String newDataSourceName) throws DataSourceConfigException, DataSourceException, MBeanException {
        NativeDataSourceConfig nativeDataSourceConfig = (NativeDataSourceConfig)this.application.getNativeDataSourceConfigs().get(dataSourceToCopy);
        if (nativeDataSourceConfig == null) {
            String msg = ServerMessages.warningDSCopyNonExistentDS("native", dataSourceToCopy);
            throw new DataSourceException(msg);
        }
        NativeDataSourceConfig newNativeDataSourceConfig = new NativeDataSourceConfig(nativeDataSourceConfig);
        newNativeDataSourceConfig.setJndiName(newJndiLocation);
        newNativeDataSourceConfig.setName(newDataSourceName);
        this.initNativeDataSource(newNativeDataSourceConfig, true);
    }

    synchronized void renameNativeDataSource(String dataSourceName, String newName) throws DataSourceConfigException, DataSourceException {
        NativeDataSourceConfig config = (NativeDataSourceConfig)this.validateNamesForRenamingDataSource(dataSourceName, newName, this.application.getNativeDataSourceConfigs());
        try {
            this.application.getContext().lookup(config.getJndiName());
        }
        catch (NamingException e) {
            String msg = ServerMessages.warningDSRenameNonExistentDS("native", e.getMessage());
            throw new DataSourceException(msg, e);
        }
        this.application.getNativeDataSourceConfigs().remove(config.getName());
        config.setName(newName);
        this.application.getNativeDataSourceConfigs().put(newName, config);
    }

    private Object validateNamesForRenamingDataSource(String dataSourceName, String newName, HashMap configs) throws DataSourceException {
        if (dataSourceName == null) {
            String msg = ServerMessages.warningDSRenameNameNull();
            throw new DataSourceException(msg);
        }
        if (newName == null || newName.trim().length() == 0) {
            String msg = ServerMessages.warningDSRenameNewNameEmpty();
            throw new DataSourceException(msg);
        }
        if (configs.get(newName) != null) {
            String msg = ServerMessages.warningDSRenameDSExists(newName);
            throw new DataSourceException(msg);
        }
        Object config = configs.get(dataSourceName);
        if (config == null) {
            String msg = ServerMessages.warningDSRenameMissingConfig(dataSourceName);
            throw new DataSourceException(msg);
        }
        return config;
    }

    synchronized void removeDataSourceConnectionPool(String name) throws DataSourceException, MBeanException {
        ResourceAdapterImpl resourceAdapter;
        DataSourceConnectionPool dscp;
        if (name == null) {
            name = "";
        }
        if ((dscp = (resourceAdapter = (ResourceAdapterImpl)this.application.getDataSourceConnectorArchive().getResourceAdapter()).getDataSourceConnectionPool(name)) == null) {
            String msg = ServerMessages.warningDSRemoveNonExistentConnectionPool(name);
            throw new DataSourceException(msg);
        }
        int numFactories = resourceAdapter.getNumConnectionFactories(name);
        if (numFactories > 0) {
            String msg = ServerMessages.warningDSRemoveManagedDataSourcesExist();
            throw new DataSourceException(msg);
        }
        this.application.getConfig().getDataSourcesConfig().removeConnectionPoolConfig(name);
        resourceAdapter.stopDataSourceConnectionPool(dscp);
        resourceAdapter.removeDataSourceConnectionPool(name);
        this.application.removeDataSourceConnectionPoolMBean(dscp);
        try {
            this.application.getDataSourceConnectorArchive().removeSharedConnectionPoolDefinition(name);
        }
        catch (InstantiationException e) {
            String msg = ServerMessages.warningDSRemoveConnectionPoolException(e.getMessage());
            throw new DataSourceException(msg, e);
        }
    }

    void removeNativeDataSource(String dataSourceName) throws DataSourceException, MBeanException {
        NativeDataSourceConfig nativeDataSourceConfig = (NativeDataSourceConfig)this.application.getNativeDataSourceConfigs().get(dataSourceName);
        if (nativeDataSourceConfig == null) {
            String msg = ServerMessages.warningDSRemoveNonExistentDataSource("native data source", dataSourceName);
            throw new DataSourceException(msg);
        }
        String jndiLocation = nativeDataSourceConfig.getJndiName();
        ApplicationContext applicationContext = this.application.getContext();
        try {
            Object object = applicationContext.lookup(jndiLocation);
            if (!DataSource.class.isInstance(object)) {
                String msg = ServerMessages.warningDSRemoveJNDIObjectNotDataSource(jndiLocation, object.getClass().getName());
                throw new DataSourceException(msg);
            }
            applicationContext.unbind(jndiLocation);
            this.application.getNativeDataSourceConfigs().remove(dataSourceName);
            this.application.getConfig().getDataSourcesConfig().removeNativeDataSourceConfig(dataSourceName);
            this.application.removeNativeDataSourceMBean((DataSource)object, nativeDataSourceConfig);
        }
        catch (NamingException namingException) {
            String msg = ServerMessages.warningDSRemoveNamingException(dataSourceName, jndiLocation, namingException.getMessage());
            throw new DataSourceException(msg, namingException);
        }
    }

    synchronized void copyDataSourceConnectionPool(String connectionPoolToCopy, String newName, String newFactoryClass) throws DataSourceException, DataSourceConfigException, MBeanException, ResourceException {
        ResourceAdapterImpl resourceAdapter;
        DataSourceConnectionPool pool;
        if (connectionPoolToCopy == null) {
            connectionPoolToCopy = "";
        }
        if (newName == null) {
            newName = "";
        }
        if (newFactoryClass == null) {
            newFactoryClass = "";
        }
        if ((pool = (resourceAdapter = (ResourceAdapterImpl)this.application.getDataSourceConnectorArchive().getResourceAdapter()).getDataSourceConnectionPool(connectionPoolToCopy)) == null) {
            String msg = ServerMessages.warningDSCopyConnectionPoolNonExistentPool(connectionPoolToCopy);
            throw new DataSourceException(msg);
        }
        ConnectionFactoryConfig newConnectionFactoryConfig = new ConnectionFactoryConfig(pool.getConfig().getConnectionFactoryConfig());
        newConnectionFactoryConfig.setFactoryClass(newFactoryClass);
        this.initDataSourceConnectionPool(new ConnectionPoolConfig(newConnectionFactoryConfig, newName, pool.getConfig()), true);
    }

    synchronized void removeManagedDataSource(String dataSourceName) throws DataSourceException, MBeanException {
        ManagedDataSourceConfig mdsConfig = (ManagedDataSourceConfig)this.application.getManagedDataSourceConfigs().get(dataSourceName);
        if (mdsConfig == null) {
            String msg = ServerMessages.warningDSRemoveNonExistentDataSource("managed data source", dataSourceName);
            throw new DataSourceException(msg);
        }
        try {
            this.application.getDataSourceConnectorArchive().removeConnectionFactory(mdsConfig.getJndiName(), true);
            ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)this.application.getDataSourceConnectorArchive().getResourceAdapter();
            resourceAdapter.unbindConnectionFactoryToConnectionPool(mdsConfig.getJndiName(), mdsConfig.getConnectionPoolName());
        }
        catch (InstantiationException e) {
            String msg = ServerMessages.warningDSRemoveConnectionFactoryFromRA(dataSourceName, e.getMessage());
            throw new MBeanException(e);
        }
        this.application.getManagedDataSourceConfigs().remove(dataSourceName);
        this.application.getConfig().getDataSourcesConfig().removeManagedDataSourceConfig(dataSourceName);
        this.application.removeManagedDataSourceMBean(dataSourceName);
    }

    synchronized void copyManagedDataSource(String dataSourceToCopy, String newJndiLocation, String newDataSourceName) throws DataSourceConfigException, DataSourceException {
        ManagedDataSourceConfig dataSourceConfig = (ManagedDataSourceConfig)this.application.getManagedDataSourceConfigs().get(dataSourceToCopy);
        if (dataSourceConfig == null) {
            String msg = ServerMessages.warningDSCopyNonExistentDS("managed data source", dataSourceToCopy);
            throw new DataSourceException(msg);
        }
        ManagedDataSourceConfig newManagedDataSourceConfig = new ManagedDataSourceConfig(dataSourceConfig);
        newManagedDataSourceConfig.setJndiName(newJndiLocation);
        newManagedDataSourceConfig.setName(newDataSourceName);
        this.initManagedDataSource(newManagedDataSourceConfig, true);
    }

    synchronized void renameManagedDataSource(String dataSourceName, String newName) throws DataSourceConfigException, DataSourceException {
        ManagedDataSourceConfig config = (ManagedDataSourceConfig)this.validateNamesForRenamingDataSource(dataSourceName, newName, this.application.getManagedDataSourceConfigs());
        ManagedDataSource dataSource = null;
        try {
            dataSource = (ManagedDataSource)this.application.getContext().lookup(config.getJndiName());
        }
        catch (NamingException e) {
            String msg = ServerMessages.warningDSRenameNonExistentDS("managed", e.getMessage());
            throw new DataSourceException(msg, e);
        }
        this.application.getManagedDataSourceConfigs().remove(config.getName());
        config.setName(newName);
        this.application.getManagedDataSourceConfigs().put(newName, config);
        dataSource.setDataSourceName(newName);
    }

    DataSourceConnectionPool getDataSourceConnectionPool(String name) {
        ResourceAdapterImpl resourceAdapter;
        DataSourceConnectionPool connectionPool = null;
        ConnectorArchive dataSourcesConnectorArchive = this.application.getDataSourceConnectorArchive();
        if (dataSourcesConnectorArchive != null && (resourceAdapter = (ResourceAdapterImpl)dataSourcesConnectorArchive.getResourceAdapter()) != null) {
            connectionPool = resourceAdapter.getDataSourceConnectionPool(name);
        }
        return connectionPool;
    }

    private void verifyInstanceType(Object object, Class clazz, String errorMsg) throws DataSourceException {
        if (!clazz.isInstance(object)) {
            throw new DataSourceException(errorMsg);
        }
    }

    void initDataSourceConnector() throws DataSourceException, DataSourceConfigException {
        DataSourcesConfig dataSourcesConfig = this.application.getConfig().getDataSourcesConfig();
        ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)this.application.getDataSourceConnectorArchive().getResourceAdapter();
        resourceAdapter.setApplication(this.application);
        resourceAdapter.setUpdateStatisticsInterval(dataSourcesConfig.getDMSUpdateInterval());
        ConnectionPoolConfig[] connectionPoolConfigs = dataSourcesConfig.getConnectionPools();
        for (int i = 0; i < connectionPoolConfigs.length; ++i) {
            this.initDataSourceConnectionPool(connectionPoolConfigs[i], false);
        }
        ManagedDataSourceConfig[] managedDataSourceConfigs = dataSourcesConfig.getManagedDataSources();
        if (managedDataSourceConfigs != null) {
            for (int i = 0; i < managedDataSourceConfigs.length; ++i) {
                this.initManagedDataSource(managedDataSourceConfigs[i], false);
            }
        }
    }

    protected void initDataSourceConnectionPool(ConnectionPoolConfig connectionPoolConfig, boolean addToAppConfig) throws DataSourceException {
        try {
            ConnectorArchive connectorArchive = this.application.getDataSourceConnectorArchive();
            ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)connectorArchive.getResourceAdapter();
            if (resourceAdapter.getDataSourceConnectionPool(connectionPoolConfig.getName()) != null) {
                String msg = ServerMessages.warningDSCreateConnectionPoolExists(connectionPoolConfig.getName());
                throw new DataSourceException(msg);
            }
            NounIntf noun = connectorArchive.getNoun();
            TaskManager taskManager = connectorArchive.getTaskManager();
            SharedConnectionPool jcaConnectionPool = new SharedConnectionPool(connectionPoolConfig.getName());
            DataSourceConnectionPool dataSourceConnectionPool = DataSourceUtils.getDataSourceConnectionPool(resourceAdapter, connectionPoolConfig, jcaConnectionPool, noun, taskManager, this.application.getName());
            ((ConnectionPoolImpl)dataSourceConnectionPool.getConnectorConnectionPool()).setDedicatedThreadConnections(connectionPoolConfig.isDedicatedThreadConnections());
            connectorArchive.addSharedConnectionPoolDefinition(jcaConnectionPool);
            this.application.addDataSourceConnectionPoolMBean(dataSourceConnectionPool);
            if (addToAppConfig) {
                DataSourcesConfig dataSourcesConfig = this.application.getConfig().getDataSourcesConfig();
                dataSourcesConfig.addConnectionPoolConfig(connectionPoolConfig);
            }
        }
        catch (DataSourceException dataSourceException) {
            throw dataSourceException;
        }
        catch (Exception exception) {
            String msg = ServerMessages.warningDSCreateConnectionPoolException(exception.getMessage());
            throw new DataSourceException(msg, exception);
        }
    }

    Map getWebApplications() {
        return this.webApplications;
    }

    public PersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    protected void destroyPersistenceUnitManager() {
        if (this.getPersistenceUnitManager() != null) {
            this.getPersistenceUnitManager().destroy();
            this.setPersistenceUnitManager(null);
        }
    }
}

