/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.configuration.XMLSerializableBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractThreadPoolConfig
extends XMLSerializableBase {
    private int minPoolSize;
    private int maxPoolSize;
    private int queueSize;
    private long keepAliveTime;
    private boolean poolDebug;
    private boolean implicit;
    private String name;
    protected static final String HTTP = "http";
    protected static final String AJP = "ajp";
    protected static final String RMI = "rmi";
    protected static final String SYSTEM = "system";
    protected static final String WORK_MANAGER = "work-manager";
    private int m_count = 0;

    public AbstractThreadPoolConfig(String name) {
        this.name = name;
        this.reset();
    }

    public AbstractThreadPoolConfig(Node node) throws ConfigException {
        super(node);
    }

    public AbstractThreadPoolConfig(Node node, String name) throws ConfigException {
        super(node);
        this.name = name;
    }

    public void read(Node node, String name) throws DOMException {
        this.name = name;
        this.read(node);
    }

    public void read(Node node) throws DOMException {
        String minString = XMLUtils.getNodeAttribute(node, "min");
        String maxString = XMLUtils.getNodeAttribute(node, "max");
        String qsizeString = XMLUtils.getNodeAttribute(node, "queue");
        String aliveString = XMLUtils.getNodeAttribute(node, "keepAlive");
        String debugString = XMLUtils.getNodeAttribute(node, "debug");
        if (minString != null) {
            this.setMinPoolSize(Integer.parseInt(minString));
        }
        if (maxString != null) {
            this.setMaxPoolSize(Integer.parseInt(maxString));
        }
        if (aliveString != null) {
            this.setKeepAliveTime(Long.parseLong(aliveString));
        }
        if (qsizeString != null) {
            this.setQueueSize(Integer.parseInt(qsizeString));
        }
        if (debugString != null) {
            this.setPoolDebug(debugString.compareToIgnoreCase("true") == 0);
        }
        ++this.m_count;
    }

    public void write(PrintWriter out, String indent) throws IOException {
        if (this.isImplicit()) {
            return;
        }
        out.print(indent + "<" + this.name + "-thread-pool");
        out.print(" min=\"" + this.minPoolSize + "\"");
        out.print(" max=\"" + this.maxPoolSize + "\"");
        out.print(" queue=\"" + this.queueSize + "\"");
        out.print(" keepAlive=\"" + this.keepAliveTime + "\"");
        if (this.poolDebug) {
            out.print(" debug=\"true\"");
        }
        out.println(" />");
    }

    public void writeNewFormat(PrintWriter out, String indent) throws IOException {
        if (this.isImplicit()) {
            return;
        }
        out.print(indent + "<thread-pool ");
        out.print("name=\"jca\"");
        out.print(" min=\"" + this.minPoolSize + "\"");
        out.print(" max=\"" + this.maxPoolSize + "\"");
        out.print(" queue=\"" + this.queueSize + "\"");
        out.print(" keepAlive=\"" + this.keepAliveTime + "\"");
        if (this.poolDebug) {
            out.print(" debug=\"true\"");
        }
        out.println(" />");
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int size) {
        this.minPoolSize = size;
        this.implicit = false;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int size) {
        this.maxPoolSize = size;
        this.implicit = false;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
        this.implicit = false;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long timeInMs) {
        this.keepAliveTime = timeInMs;
        this.implicit = false;
    }

    public boolean isPoolDebug() {
        return this.poolDebug;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean b) {
        this.implicit = b;
    }

    public void setPoolDebug(boolean d) {
        this.poolDebug = d;
        if (this.poolDebug) {
            this.implicit = false;
        }
    }

    public int getCount() {
        return this.m_count;
    }

    public void reset() {
        this.minPoolSize = 20;
        this.maxPoolSize = 40;
        this.queueSize = 80;
        this.keepAliveTime = 600000L;
        this.poolDebug = false;
        this.implicit = true;
    }
}

