/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.net.MulticastMessage;
import com.evermind.net.MulticastSender;
import com.evermind.util.HTTPProperties;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

public class MulticastReceiver {
    protected InetAddress group;
    protected int port;
    protected MulticastSocket socket;
    protected long clientID;
    protected int currentMessageID;
    protected long currentClientID;
    protected List partialMessages = new ArrayList();
    protected boolean noLocal;
    protected long messageTimeout = 20000L;

    public MulticastReceiver(InetAddress address, int port, long id) throws IOException {
        this.group = address;
        this.port = port;
        this.socket = new MulticastSocket(port);
        if (MulticastSender.secondInterface != null) {
            this.socket.setInterface(InetAddress.getByName(MulticastSender.secondInterface));
        }
        this.socket.joinGroup(address);
        this.clientID = id;
    }

    public void setNoLocal(boolean value) {
        this.noLocal = value;
    }

    public void setMessageTimeout(long timeout) {
        this.messageTimeout = timeout;
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void setReceiverBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public long getMessageClientID() {
        return this.currentClientID;
    }

    public int getMessageID() {
        return this.currentMessageID;
    }

    public byte[] nextMessage() throws IOException {
        while (true) {
            byte[] data = new byte[1024];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            this.socket.receive(packet);
            long clientID = ((long)data[8] & 0xFFL) << 56 | ((long)data[7] & 0xFFL) << 48 | ((long)data[6] & 0xFFL) << 40 | ((long)data[5] & 0xFFL) << 32 | ((long)data[4] & 0xFFL) << 24 | ((long)data[3] & 0xFFL) << 16 | ((long)data[2] & 0xFFL) << 8 | (long)data[1] & 0xFFL;
            int messageID = ((char)data[12] & 0xFF) << 24 | ((char)data[11] & 0xFF) << 16 | ((char)data[10] & 0xFF) << 8 | (char)data[9] & 0xFF;
            int segmentID = ((char)data[16] & 0xFF) << 24 | ((char)data[15] & 0xFF) << 16 | ((char)data[14] & 0xFF) << 8 | (char)data[13] & 0xFF;
            if (this.noLocal && clientID == this.clientID) continue;
            if (segmentID == 0 && data[0] == 1) {
                byte[] messageData = new byte[packet.getLength() - 17];
                System.arraycopy(data, 17, messageData, 0, messageData.length);
                if (HTTPProperties.getMulticastDebug()) {
                    System.out.println("Multicast: Receiving " + messageData.length + " long message...");
                }
                this.currentClientID = clientID;
                this.currentMessageID = messageID;
                return messageData;
            }
            boolean found = false;
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < this.partialMessages.size(); ++i) {
                MulticastMessage message = (MulticastMessage)this.partialMessages.get(i);
                if (message.clientID == clientID && message.id == messageID) {
                    found = true;
                    message.addPart(data, packet.getLength(), segmentID);
                    if (message.isComplete()) {
                        this.partialMessages.remove(i);
                        this.currentClientID = message.clientID;
                        this.currentMessageID = message.id;
                        return message.construct();
                    }
                    message.lastPieceReceived = currentTime;
                    break;
                }
                if (message.lastPieceReceived + this.messageTimeout >= currentTime) continue;
                this.partialMessages.remove(i--);
            }
            if (found) continue;
            MulticastMessage message = new MulticastMessage(clientID, messageID);
            message.addPart(data, packet.getLength(), segmentID);
            message.lastPieceReceived = currentTime;
            this.partialMessages.add(message);
        }
    }
}

