/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.memory;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class EntrySetNamingEnumeration
implements NamingEnumeration {
    protected Iterator entries;
    protected Context context;
    protected Object current;
    protected NamingException exception;
    protected boolean bindings;

    public EntrySetNamingEnumeration(Set entrySet, Context context, boolean bindings) {
        this.entries = entrySet.iterator();
        this.context = context;
        this.current = this.getNextValue();
        this.bindings = bindings;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() {
        return this.current != null;
    }

    public void close() {
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        Object value = this.current;
        this.current = this.getNextValue();
        return value;
    }

    private NameClassPair getNextValue() {
        if (!this.entries.hasNext()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)this.entries.next();
        return this.bindings ? new Binding((String)entry.getKey(), entry.getValue()) : new NameClassPair((String)entry.getKey(), entry.getValue().getClass().getName());
    }

    public Object next() throws NamingException {
        if (this.current == null && this.exception != null) {
            throw this.exception;
        }
        Object pair = this.current;
        this.current = this.getNextValue();
        return pair;
    }
}

