/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.archive;

import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.AwareSubContext;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.FlatContext;
import com.evermind.naming.MapNamingEnumeration;
import com.evermind.naming.RelativeContext;
import com.evermind.util.ArrayUtils;
import com.evermind.util.ByteString;
import com.evermind.util.LengthContainer;
import com.evermind.zip.MemoryArchive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class MemoryArchiveContext
extends FlatContext
implements LastModifiedContainer,
LengthContainer,
RelativeContext {
    protected Context parent;
    protected String contextName;
    protected boolean autoFlush;
    protected long lastModified;
    protected MemoryArchive archive;

    public MemoryArchiveContext(Context parent, String contextName, byte[] data, int start, int length, boolean autoFlush) throws IOException, NamingException {
        if ((parent == null || contextName == null) && data == null) {
            throw new NullPointerException("Both data and parent was null");
        }
        this.parent = parent;
        this.contextName = contextName;
        this.autoFlush = autoFlush;
        if (data != null) {
            this.archive = new MemoryArchive(data, start, length, contextName);
        }
    }

    public void clear() {
        this.archive = new MemoryArchive(new byte[0], 0, 0, this.contextName);
    }

    public MemoryArchiveContext(Context parent, String contextName, boolean autoFlush) throws IOException, NamingException {
        this.parent = parent;
        this.contextName = contextName;
        this.autoFlush = autoFlush;
    }

    public MemoryArchiveContext(byte[] data, boolean autoFlush) throws NamingException, IOException {
        this(null, null, data, 0, data == null ? 0 : data.length, autoFlush);
    }

    public void setData(byte[] data, int start, int length) {
        this.archive = new MemoryArchive(data, start, length, this.contextName);
    }

    public Context getParent() {
        return this.parent;
    }

    public String getName() {
        return this.contextName;
    }

    public synchronized ByteString lookupString(String name) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            return this.archive.getContent(name);
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public synchronized Object lookup(String name) throws NamingException {
        ByteString string = this.lookupString(name);
        if (string == null) {
            if (this.archive.containsDirectory(name)) {
                return new AwareSubContext(this, name);
            }
            throw new NameNotFoundException(name);
        }
        return string.getBytes();
    }

    public MemoryArchive getArchive() throws IOException, NamingException {
        if (this.archive == null) {
            this.load();
        }
        return this.archive;
    }

    public ByteString getData() throws NamingException {
        try {
            if (this.archive != null) {
                return this.archive.getData();
            }
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
        if (this.parent == null) {
            return null;
        }
        try {
            try {
                if (this.parent instanceof LastModifiedContainer) {
                    this.lastModified = ((LastModifiedContainer)((Object)this.parent)).getLastModified(this.contextName);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            ByteString string = ContextUtils.lookupString(new Context[]{this.parent}, this.contextName);
            return string;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public void save() throws NamingException {
        if (this.autoFlush) {
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new NamingException("IO Error: " + e.getMessage());
            }
        }
    }

    public void writeTo(OutputStream basicOut) throws IOException, NamingException {
        if (this.archive == null) {
            this.load();
        }
        ByteString string = this.archive.getData();
        basicOut.write(string.data, string.offset, string.length);
    }

    public void flush() throws IOException, NamingException {
        if (this.parent != null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            this.writeTo(byteOut);
            byteOut.flush();
            this.parent.rebind(this.contextName, (Object)byteOut.toByteArray());
        }
    }

    public void bind(String name, Object data) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            if (this.archive.contains(name)) {
                throw new NameAlreadyBoundException(name);
            }
            this.archive.write(name, data, System.currentTimeMillis());
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public void rebind(String name, Object data) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            this.archive.write(name, data, System.currentTimeMillis());
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public boolean setLastModified(String name, long value) throws IOException {
        if (name.endsWith("/")) {
            name = name.substring(1);
        }
        try {
            ByteString string;
            if (this.archive == null) {
                this.load();
            }
            if ((string = this.archive.getContent(name)) != null) {
                this.archive.write(name, string.getBytes(), value);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (NamingException e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    public long getLastModified(String name) throws IOException {
        if (name.endsWith("/")) {
            name = name.substring(1);
        }
        try {
            if (this.archive == null) {
                this.load();
            }
            return this.archive.getLastModified(name);
        }
        catch (NamingException e) {
            throw new IOException("Naming error: " + e.getMessage());
        }
    }

    public long getLength(String name) throws IOException {
        return this.archive.getLength(name);
    }

    public void load() throws IOException, NamingException {
        ByteString string = this.getData();
        if (string == null) {
            throw new IOException("unable to find " + this.contextName);
        }
        this.archive = new MemoryArchive(string.data, string.offset, string.length, this.contextName);
    }

    public synchronized void unload() {
        this.archive = null;
    }

    public String getNameInNamespace() {
        return this.toString();
    }

    public String toString() {
        try {
            return this.parent == null ? "<unknown>" : this.parent.getNameInNamespace() + "/" + this.contextName;
        }
        catch (NamingException e) {
            return "<unknown>";
        }
    }

    public Context getRelative(String path) throws NamingException {
        Object object;
        int slashPos;
        if (this.contextName != null && path.equals(this.contextName)) {
            throw new NamingException("Relative was myself");
        }
        if (this.parent == null) {
            throw new NameNotFoundException(path);
        }
        if (this.parent instanceof MemoryArchiveContext) {
            ByteString string = ((MemoryArchiveContext)this.parent).lookupString(path);
            try {
                slashPos = path.lastIndexOf(47);
                if (string != null) {
                    return new MemoryArchiveContext(slashPos < 0 ? this.parent : (Context)this.parent.lookup(path.substring(0, slashPos)), slashPos < 0 ? path : path.substring(slashPos + 1), string.data, string.offset, string.length, this.autoFlush);
                }
            }
            catch (IOException e) {
                throw new NamingException(e.getMessage());
            }
        }
        if ((object = this.parent.lookup(path)) instanceof Context) {
            return (Context)object;
        }
        if (object instanceof byte[]) {
            try {
                slashPos = path.lastIndexOf(47);
                byte[] data = (byte[])object;
                return new MemoryArchiveContext(slashPos < 0 ? this.parent : (Context)this.parent.lookup(path.substring(0, slashPos)), slashPos < 0 ? path : path.substring(slashPos + 1), data, 0, data.length, this.autoFlush);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new NameNotFoundException(path);
    }

    public boolean equals(Object other) {
        if (!(other instanceof MemoryArchiveContext)) {
            return false;
        }
        MemoryArchiveContext archive = (MemoryArchiveContext)other;
        if (this.parent != null && archive.parent != null && !this.parent.equals(archive.parent)) {
            return false;
        }
        if (this.contextName != null && archive.contextName != null && !this.contextName.equals(archive.contextName)) {
            return false;
        }
        try {
            if (this.archive != null && archive.archive != null) {
                ByteString thisString = this.archive.getData();
                ByteString otherString = archive.getData();
                if (this.archive != null && !ArrayUtils.compare(thisString.data, thisString.offset, thisString.length, otherString.data, otherString.offset, otherString.length)) {
                    return false;
                }
            }
        }
        catch (NamingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code;
        int n = code = this.parent == null ? 0 : this.parent.hashCode();
        if (this.contextName != null) {
            code += this.contextName.hashCode();
        }
        return code;
    }

    public void setAutoFlush(boolean flush) {
        this.autoFlush = flush;
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            try {
                if (this.parent instanceof LastModifiedContainer) {
                    this.lastModified = ((LastModifiedContainer)((Object)this.parent)).getLastModified(this.contextName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.lastModified;
    }

    public boolean isUpToDate() {
        if (this.lastModified == 0L) {
            return true;
        }
        if (this.parent instanceof LastModifiedContainer) {
            try {
                return ((LastModifiedContainer)((Object)this.parent)).getLastModified(this.contextName) == this.lastModified;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public Object addToEnvironment(String name, Object object) {
        return null;
    }

    public synchronized Context createSubcontext(String name) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            this.archive.write(name + "/", new byte[0], System.currentTimeMillis());
            if (this.autoFlush) {
                this.flush();
            }
            return new AwareSubContext(this, name);
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public synchronized void destroySubcontext(String name) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            if (this.autoFlush) {
                this.flush();
            }
            this.archive.write(name + "/", new byte[0], System.currentTimeMillis());
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public void close() {
        this.archive = null;
    }

    public Hashtable getEnvironment() {
        return new Hashtable();
    }

    public synchronized NamingEnumeration list(String path) throws NamingException {
        return this.list(path, false);
    }

    public synchronized NamingEnumeration list(String path, boolean bindings) throws NamingException {
        try {
            if (this.archive == null) {
                this.load();
            }
            HashMap<String, Object> entries = new HashMap<String, Object>();
            String dirPath = path.equals("") ? "" : path.concat("/");
            Iterator iterator = this.archive.getNames().iterator();
            while (iterator.hasNext()) {
                String name = iterator.next().toString();
                if (!name.startsWith(dirPath)) continue;
                if (name.lastIndexOf(47) == path.length() || path.length() == 0 && name.lastIndexOf(47) < 0) {
                    if (!name.endsWith("/")) {
                        if (bindings) {
                            entries.put(name.substring(dirPath.length()), new Object[]{"java.lang.Object", this.archive.getContent(name)});
                            continue;
                        }
                        entries.put(name.substring(dirPath.length()), "java.lang.Object");
                        continue;
                    }
                    if (name.length() == path.length() + 1) continue;
                    if (bindings) {
                        entries.put(name.substring(dirPath.length(), name.length() - 1), new Object[]{"javax.naming.Context", new AwareSubContext(this, name)});
                        continue;
                    }
                    entries.put(name.substring(dirPath.length(), name.length() - 1), "javax.naming.Context");
                    continue;
                }
                String directory = name.substring(dirPath.length(), name.indexOf(47, path.length() + 1));
                if (bindings) {
                    entries.put(directory, new Object[]{"javax.naming.Context", new AwareSubContext(this, directory)});
                    continue;
                }
                entries.put(directory, "javax.naming.Context");
            }
            return new MapNamingEnumeration(entries, bindings);
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public NamingEnumeration listBindings(String path) throws NamingException {
        return this.list(path, true);
    }

    public Object lookupLink(String name) {
        throw new UnsupportedOperationException("lookupLink is not supported");
    }

    public Object removeFromEnvironment(String name) {
        return null;
    }

    public synchronized void rename(String from, String to) throws NamingException {
        try {
            ByteString string;
            if (this.archive == null) {
                this.load();
            }
            if ((string = this.archive.getContent(from)) == null) {
                throw new NameNotFoundException(from);
            }
            this.archive.write(from, null, System.currentTimeMillis());
            this.archive.write(to, string.getBytes(), System.currentTimeMillis());
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public synchronized void unbind(String name) throws NamingException {
        try {
            int position;
            if (this.archive == null) {
                this.load();
            }
            if ((position = this.archive.getOffset(name)) < 0 && (position = this.archive.getOffset(name = name + "/")) < 0) {
                throw new NameNotFoundException(name);
            }
            this.archive.write(name, null, System.currentTimeMillis());
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }
}

