/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.CodeStringTokenizer;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.LiteralClassDescription;
import com.evermind.compiler.MethodDescription;
import com.evermind.compiler.ReferenceDescription;
import com.evermind.compiler.SyntaxError;
import java.util.Vector;

public class LiteralMethodDescription
extends MethodDescription {
    public LiteralClassDescription classDescription;
    public String name;
    public int modifiers;
    public String body;

    public LiteralMethodDescription(LiteralClassDescription classDescription, String content) throws CompilationException {
        String word;
        this.classDescription = classDescription;
        CodeStringTokenizer tokenizer = new CodeStringTokenizer(content);
        while ((word = tokenizer.readSingleWord()) != null) {
            if (word.equals("public")) {
                this.modifiers |= 1;
                continue;
            }
            if (word.equals("private")) {
                this.modifiers |= 2;
                continue;
            }
            if (word.equals("protected")) {
                this.modifiers |= 4;
                continue;
            }
            if (word.equals("final")) {
                this.modifiers |= 0x10;
                continue;
            }
            if (word.equals("static")) {
                this.modifiers |= 8;
                continue;
            }
            if (word.equals("strict")) {
                this.modifiers |= 0x800;
                continue;
            }
            if (word.equals("transient")) {
                this.modifiers |= 0x80;
                continue;
            }
            if (word.equals("volatile")) {
                this.modifiers |= 0x40;
                continue;
            }
            if (word.equals("synchronized")) {
                this.modifiers |= 0x20;
                continue;
            }
            if (word.equals("native")) {
                this.modifiers |= 0x100;
                continue;
            }
            if (word.equals("abstract")) {
                this.modifiers |= 0x400;
                continue;
            }
            this.returnValue = this.getType(classDescription.imports, word);
            if (word.equals("interface")) {
                this.modifiers |= 0x200;
            } else if (!word.equals("class")) {
                throw new SyntaxError("Expected class or interface");
            }
            classDescription.name = classDescription.packageName == null ? tokenizer.readSingleWord() : classDescription.packageName.concat(tokenizer.readSingleWord().replace('.', '/'));
            while ((word = tokenizer.readSingleWord()) != null) {
                if (word.equals("extends")) {
                    classDescription.superName = tokenizer.readSingleWord();
                    continue;
                }
                if (!word.equals("implements")) continue;
                while ((word = tokenizer.readSingleWord()) != null) {
                    classDescription.interfaceNames.add(word);
                }
            }
        }
    }

    public ReferenceDescription getType(Vector imports, String name) {
        return null;
    }
}

