/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.ExternalJavac;
import com.evermind.compiler.FileLinkedCompiler;
import com.evermind.compiler.Javac;
import com.evermind.compiler.LinkedCompiler;
import com.evermind.util.CompilerProperties;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.management.callbackinterfaces.CompilerCallBackIf;

public class CompilerFactory
implements CompilerCallBackIf {
    private static Logger m_logger = TraceLogger.getLogger(CompilerFactory.class);
    protected String name = CompilerProperties.getBuildCompiler();
    protected String dir = CompilerProperties.getBuildCompilerDir();
    protected String ext = System.getProperty("java.ext.dirs");
    protected String encoding = CompilerProperties.getBuildCompilerEncoding();
    protected boolean inProcess = CompilerProperties.getBuildCompilerInProcess();
    protected static String BUILD_COMPILER_OPTIONS_DEFAULT = "-J-Xmx1024m";
    protected String options = CompilerProperties.getBuildCompilerOptions();
    protected static String tempDir = ".";
    protected static final String javaHome = System.getProperty("java.home");
    protected static final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    protected static final String pathSep = System.getProperty("path.separator");
    protected static final boolean isDos = pathSep.equals(";") && osName.indexOf("netware") <= -1;
    protected boolean configured = this.initDefault();
    private static CompilerFactory _instance = null;

    protected CompilerFactory() {
    }

    private boolean initDefault() {
        if (this.isJavac() && !this.getName().equalsIgnoreCase("classic")) {
            this.inProcess = false;
        }
        this.configured = true;
        return this.configured;
    }

    public static CompilerFactory instance() {
        if (null == _instance) {
            _instance = new CompilerFactory();
        }
        return _instance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
            this.configured = true;
        }
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        if (dir != null) {
            this.dir = dir;
            this.configured = true;
        }
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        if (ext != null) {
            this.ext = ext;
            this.configured = true;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean isOptionsDefault() {
        return this.options.equals(BUILD_COMPILER_OPTIONS_DEFAULT);
    }

    public String getTempDir() {
        return tempDir;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
            this.configured = true;
        }
    }

    public void setOptions(String options) {
        if (options != null) {
            this.options = options;
            this.configured = true;
        }
    }

    public void setTempDir(String dir) {
        if (dir != null) {
            tempDir = dir;
            this.configured = true;
        }
    }

    public boolean isInProcess() {
        return this.inProcess;
    }

    public void setInProcess(boolean inProcess) {
        this.inProcess = inProcess;
        this.configured = true;
    }

    public void setInProcess(String nodeAttribute) {
        if (nodeAttribute != null) {
            this.inProcess = nodeAttribute.compareToIgnoreCase("true") == 0;
            this.configured = true;
        }
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public static boolean isDebug() {
        return CompilerProperties.getBuildDebug();
    }

    public void setDebug(String nodeAttribute) {
        if (nodeAttribute != null && nodeAttribute.compareToIgnoreCase("true") == 0) {
            CompilerProperties.setBuildDebug(true);
            this.configured = true;
        }
    }

    public LinkedCompiler create(ClassLoader loader) {
        FileLinkedCompiler javacCompiler = null;
        javacCompiler = this.inProcess ? new Javac(loader) : new ExternalJavac();
        return javacCompiler;
    }

    public boolean isJavac() {
        return this.name.compareToIgnoreCase("classic") == 0 || this.name.compareToIgnoreCase("modern") == 0 || this.name.compareToIgnoreCase("javac") == 0;
    }

    public String getCommand() {
        String command = null;
        command = this.isJavac() ? "javac" : this.name;
        return command;
    }

    public String getBuildCompilerOptions() {
        return this.getOptions();
    }

    public void setBuildCompilerOptions(String compilerOptions) {
        this.setOptions(compilerOptions);
    }

    public String getCompilerDirectory() {
        return this.getDir();
    }

    public void setCompilerDirectory(String compilerDirectory) {
        this.setDir(compilerDirectory);
    }

    public String getBuildCompilerEncoding() {
        return this.getEncoding();
    }

    public void setBuildCompilerEncoding(String compilerEncoding) {
        this.setEncoding(compilerEncoding);
    }

    public String getExtensionDirectory() {
        return this.getExt();
    }

    public void setExtensionDirectory(String directoryExtension) {
        this.setExt(directoryExtension);
    }

    public String getTemporaryDirectory() {
        return this.getTempDir();
    }
}

