/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.ApplicationAdminCommandBase;
import com.evermind.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class UpdateEJBModuleCommand
extends ApplicationAdminCommandBase {
    private String _fileName = null;
    private String _module = this.getNextArgument("EJB module path");

    public UpdateEJBModuleCommand(List args) throws AdminCommandException {
        super(args);
        if (!this.isArgsEmpty()) {
            String in = this.getNextArgument("updateEJBModule subcommand");
            if (in.equals("-file")) {
                this._fileName = this.getNextArgument("jar filename");
            } else {
                throw new AdminCommandException("Unknown -updateEJBModule switch: " + in, 21);
            }
        }
        if (this._fileName == null) {
            this._fileName = this._module;
        }
    }

    public void doIt() throws AdminCommandException {
        File packageFile = new File(this._fileName);
        if (!packageFile.exists()) {
            throw new AdminCommandException("Unable to find archive " + this._fileName, 22);
        }
        if (packageFile.isDirectory()) {
            throw new AdminCommandException(this._fileName + " is a directory, not an archive.", 23);
        }
        if (!this._fileName.endsWith(".jar")) {
            throw new AdminCommandException(this._fileName + " is not a .jar file.", 24);
        }
        byte[] data = null;
        try {
            data = IOUtils.getContent(packageFile);
        }
        catch (IOException e) {
            throw new AdminCommandException(e, "Error reading archive file " + packageFile + ": " + e.getMessage(), 24);
        }
        try {
            this._appAdmin.updateEJBModule(data, this._module);
            System.out.println("Update complete");
        }
        catch (Exception e) {
            throw new AdminCommandException((Throwable)e, "Update error: " + e.getMessage());
        }
    }
}

