/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandBase;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.AdminCommandUsage;
import com.evermind.client.orion.AdminCommandUtils;
import com.evermind.client.orion.ApplicationAdminCommandParser;
import com.evermind.client.orion.BindWebAppCommand;
import com.evermind.client.orion.ConvertDataSourceConfigurationCommand;
import com.evermind.client.orion.DeployCommand;
import com.evermind.client.orion.DeployConnectorCommand;
import com.evermind.client.orion.RestartCommand;
import com.evermind.client.orion.ShutdownCommand;
import com.evermind.client.orion.UndeployCommand;
import com.evermind.client.orion.UndeployConnectorCommand;
import com.evermind.client.orion.UpdateConfigCommand;
import com.evermind.client.orion.VersionCommand;
import java.util.List;

public class AdminCommandParser {
    public static AdminCommandBase parse(List args) throws AdminCommandException {
        String command = AdminCommandUtils.getNextArgument(args, "command");
        if (command.equals("-shutdown")) {
            return new ShutdownCommand(args);
        }
        if (command.equals("-restart")) {
            return new RestartCommand(args);
        }
        if (command.equals("-deploy")) {
            return new DeployCommand(args);
        }
        if (command.equals("-undeploy")) {
            return new UndeployCommand(args);
        }
        if (command.equals("-deployconnector") || command.equals("-deployConnector")) {
            return new DeployConnectorCommand(args);
        }
        if (command.equals("-undeployconnector") || command.equals("-undeployConnector")) {
            return new UndeployConnectorCommand(args);
        }
        if (command.equals("-bindWebApp") || command.equals("-bindwebapp")) {
            return new BindWebAppCommand(args);
        }
        if (command.equals("-application")) {
            return ApplicationAdminCommandParser.parse(args);
        }
        if (command.equals("-site")) {
            throw new AdminCommandException("-site command is no longer supported", 0);
        }
        if (command.equals("-updateConfig") || command.equals("-updateconfig")) {
            return new UpdateConfigCommand(args);
        }
        if (command.equals("-version")) {
            return new VersionCommand(args);
        }
        if (command.equals("-convertDataSourceConfiguration")) {
            args.add(0, command);
            args.add(0, "default");
            return new ConvertDataSourceConfigurationCommand(args);
        }
        throw new AdminCommandException("Illegal command " + command + "\n" + AdminCommandUsage.getUsage(), 10);
    }
}

