'---------------------------------------------------------------------------------------------------
'	File Name :	ipdetails.vbs 
'	
'	Purpose   :	This file is VBScript code which will display the  Hostname,
'			ipaddresses configured in a system and MAC Address.
'	
'	The output in the file as follows ...	
'	
'	Microsoft (R) Windows Script Host Version 5.8
'	Copyright (C) Microsoft Corporation. All rights reserved.

'	HostName:2k8r2issci
'	IP Address: 192.168.9.23
'	IP Address: 192.168.9.15
'	IP Address: 10.0.0.7
'	IP Address: 10.0.0.5
'	IP Address: 1.127.5.1
'	Physical Addresses: B8:AC:6F:6B:5A:FB,70:F1:A1:BD:BC:DA
'
'	Created Date 	:	04-10-2012
'	Last Modifed 	:	27-12-2012
'
'	Author 		:	Rama R.
'	LastModified By :	Rama R.
'
'---------------------------------------------------------------------------------------------------
On Error Resume Next
intCount = 0
ipcount = 0
strMAC   = ""
flag = "false"
' We're interested in MAC addresses of physical adapters only
strQuery = "SELECT * FROM Win32_NetworkAdapter WHERE NetConnectionID > ''"

Set objNTInfo = CreateObject("WinNTSystemInfo")
GetComputerName = lcase(objNTInfo.ComputerName)
Wscript.Echo "HostName:" + GetComputerName


Set objWMIService = GetObject( "winmgmts://./root/CIMV2" )
Set colItems      = objWMIService.ExecQuery( strQuery, "WQL", 48 )

For Each objItem In colItems
    If InStr( strMAC, objItem.MACAddress ) = 0 Then
        strMAC   = strMAC & "," & objItem.MACAddress
        intCount = intCount + 1
    End If	

	Set colNicConfigs = objWMIService.ExecQuery ("ASSOCIATORS OF " & "{Win32_NetworkAdapter.DeviceID='" & objItem.DeviceID & "'}" & " WHERE AssocClass=Win32_NetworkAdapterSetting")
	For Each objNicConfig In colNicConfigs
		If Not IsNull(objNicConfig.IPAddress) Then
			For i=LBound(objNicConfig.IPAddress)  To UBound(objNicConfig.IPAddress)
				strIPAddress = objNicConfig.IPAddress(i)
				If InStr(strIPAddress,"127.")<> 1 And InStr(strIPAddress,"169.254")<> 1 Then
					Wscript.Echo "IP Address: " &  strIPAddress
				End If
			Next
		End If
	Next
Next

' Remove leading comma
If intCount > 0 Then 
	strMAC = Mid( strMAC, 2 )
End If 

Select Case intCount
    Case 0
        WScript.Echo "No Physical Addresses were found"
    Case 1
        WScript.Echo "Physical Addresses: " & strMAC
    Case Else
        WScript.Echo "Physical Addresses: " & strMAC
End Select