#!/bin/bash

#Arguments e indicates - php|phpfpm, p indicates path of the binary file, a indicates the eGurkha installed directory

usage() {       echo "**** eG_PHP_BTM uninstallation failed ****"
                echo "Usage: $0 [-e <1-php|2-php-fpm>] [(optional) -p <Path of php|php-fpm executable>] [(optional) -a <Path of eGurkha installed directory>]" 1>&2; exit 1; }

while getopts ":e:p:a:" o; do
    case "${o}" in
        e)
            e=${OPTARG}
            ((e == 1 || e == 2)) || usage
            ;;
        p)
            p=${OPTARG}
            ;;
        a)
           a=${OPTARG}
            ;;

        *)
            usage
            ;;
    esac
done
shift $((OPTIND-1))

if [ -z "${e}" ]; then
    usage
fi

#check the argument to install php or php-fpm
if [ "$e" == 1 ] ; then
        phpProgram="php"
else
        phpProgram="php-fpm"
fi

#Reads the PHP binary location from the arguments - p
configpath="/opt/egurkha/"
if [ -z "${p}" ] ; then
        phpProgram=${phpProgram}
else
        phpProgram="${p}/${phpProgram}"
fi

#Reads the PHPBTM log & configuration file location from the arguments
if [ -z "${a}" ] ; then
        configpath="/opt/egurkha/"
else
        configpath=${a}
fi

# Getting additional .ini files location
additnlIniDir=$(${phpProgram} -i 2> /dev/null | grep "Scan this dir for additional .ini files")
additnlIniDir="$(cut -d'>' -f2 <<<"$additnlIniDir")"
additnlIniDir="${additnlIniDir// /}"                           
echo ""
    if [ "$additnlIniDir" != "" ]; then
        eginifile="/eG_phpBTM.ini"
        file="$additnlIniDir$eginifile"
        if [ ! -f "$file" ]
          then
            echo "*** eG PHP BTM Configuration file not found ($file) or eG PHP BTM already uninstalled ***"
        else
             echo "  Removing eG_phpBTM.ini from ""${additnlIniDir}/"
             rm -f "$file"
        fi
    else
        #Get the (php.ini) location
        iniPath=$(${phpProgram} -i 2> /dev/null | grep "Configuration File (php.ini) Path")
        iniPath="$(cut -d'>' -f2 <<<"$iniPath")"
        iniPath="${iniPath// /}"
        phpinifile="/php.ini"
        file="$iniPath$phpinifile"
        if [ ! -f "$file" ]
          then
            echo "*** PHP Configuration file not found ($file) ***"
            echo "Uninstallation Aborted"
            exit
        else
            echo "  Removing extension from ""${file}"
            echo "$configpath"
            sed -i "/\b\(.*eG_phpBTM\)\b/d" "${file}"
            sed -i "/\b\(egagent.configpath*\)\b/d" "${file}"

        fi
    fi
	
	
#Get the extension directory location
extDir=$(${phpProgram} -i 2> /dev/null | grep -w "extension_dir" | head -n 1)
extDir="$(cut -d'>' -f3 <<<"$extDir")"
extDir="${extDir// /}"
file="$extDir/eG_phpBTM.so"

if [ ! -f "$file" ]
    then
        echo "*** eG PHP BTM Module not found ($file) or eG PHP BTM already uninstalled ***"
else
    echo "  Removing the PHP BTM module from ""${extDir}/"
    if rm -f "$extDir/eG_phpBTM.so"
       then
        echo ""
        echo "-----------------------------------------------------"
        echo "  eG PHP BTM Uninstalled Successfully"
        echo "-----------------------------------------------------"
    else
        echo "Uninstallation Aborted"
    fi
fi

