package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgDateInfo;
import com.eg.EgServicesInfo;
import com.eg.EgTablesInfo;
import com.eg.EgTesterInfo;
import com.eg.EgDbInfo;
import com.eg.EgMappingInfo;
import com.eg.EgTestInfo;
import com.eg.EgSpecsInfo;
import com.eg.EgURLDecoder;
import com.eg.EgConfigInfo;
import com.egurkha.util.DateTimeTokenizer;
import com.egurkha.util.DateUtil;
import egurkha.reporter.ErInfo;
import com.egurkha.util.StringUtils;
import com.eg.EgReportInfo;
import java.text.SimpleDateFormat;
import com.eg.MappingNameSorter;
import com.eg.EgName;
import net.sf.json.*;
import java.util.*;
import java.text.*;
import com.eg.EgReportInfo;
import com.eg.EgDateInfo;
import com.egurkha.util.*;

public final class ErSystemCapacityReportJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	private int[] getDefinedPercentile(String testName, String measureName) {
		EgTesterInfo testerInfo=new EgTesterInfo("manager");
		EgServicesInfo servicesInfo = new EgServicesInfo("manager");
		String customPercentileName = testerInfo.getCustomPercentileName(testName + ":" + measureName);
		int[] percentile = null;
		if(customPercentileName == null) {
			percentile = servicesInfo.getDefaultPercentileForCapacity();
		} else {
			percentile = servicesInfo.getPercentileForCapacity(customPercentileName);
			if(percentile == null) {
				percentile = servicesInfo.getDefaultPercentileForCapacity();
			}
		}
		return percentile;
	}

	private static final String BLANK_SPACE = " ";
	private static final String COMA = ",";
	private static final String COLON = ":";
	private static final String UTF_8 = "UTF-8";

 
	public JSONArray getLastCalenJson(List weekList) {
		JSONArray tmpJsonArr=new JSONArray();
		JSONObject timelineJSON = new JSONObject();	
		String tmpTimeLine = null;
		String viewField=null;			
		for(int x=0;x<weekList.size();x++){
			tmpTimeLine = (String)weekList.get(x);	
			int spaceCount = 0;	
			for(int y=0; y<tmpTimeLine.length();y++){				
				char ch = tmpTimeLine.charAt(y);
				if(ch== ' '){
				   spaceCount++; 
				}
			}
			if(spaceCount > 1){
				//Last 2 weeks    weeks_last 2
				String countStr = tmpTimeLine.substring(tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = tmpTimeLine.substring(tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.length());
				String last = tmpTimeLine.substring(0, tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr +" "+ end + "_" + last;				
			}else{
				viewField = "1 "+tmpTimeLine.substring(tmpTimeLine.lastIndexOf(" ")+1, tmpTimeLine.length())  + "_" + tmpTimeLine.substring(0, tmpTimeLine.indexOf(" "));				
			}			
			timelineJSON.put("displayField",tmpTimeLine);
			timelineJSON.put("valueField", viewField.toLowerCase());
			tmpJsonArr.add( timelineJSON );		
		}		
		return tmpJsonArr;
   } 


	public List<String> getLastWeekMonthList(String currentDateFormat, User user, String timeLine, boolean isZoneType){
		EgDateInfo egDt = new EgDateInfo();
		List<String> lastWeekList = new ArrayList<String>();
		String startDate = null;
		String endDate = null;
		int count = Integer.parseInt(timeLine.substring(0, timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)));
		String unit = timeLine.substring(timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,timeLine.length());
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		java.util.Date today = egDt.egetRealDate();
		String currentDateTime = sdf.format(today);
		String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
		String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
		String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1,currentDateTime.lastIndexOf(":"));
		String time = " "+currentHr+":"+currentMin;
		String curFormatDate  = DateUtil.changeDateFormat(currentDate, "MM/dd/yyyy", currentDateFormat);		
		String userFormat = user.getUserDateFormat();
		try{
			java.util.Date realDate = null;
			if(!isZoneType){
				EgTimeZoneConverter tmZoneConverter = new EgTimeZoneConverter(curFormatDate+time,user);				
				realDate = new SimpleDateFormat(userFormat).parse(tmZoneConverter.getDateTime());
				sdf = new SimpleDateFormat(userFormat);
			}else{
				realDate = new SimpleDateFormat(userFormat).parse(curFormatDate);
			}
					
			Calendar c = Calendar.getInstance();
			c.setTime(realDate);
			if(unit.startsWith("we")){
				int weekCount = count;
				int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
				int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
				int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
				c.add(Calendar.DATE, - i - startDayCount);
				startDate = sdf.format(c.getTime());
				c.add(Calendar.DATE, lastDayCount);	
				endDate = sdf.format(c.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));					
				}															
			}else if(unit.startsWith("mo")){
				int monthCount = count;
				c.add(Calendar.MONTH, -monthCount);
				c.set(Calendar.DATE, 1);
				startDate = sdf.format(c.getTime());				
				
				Calendar c1 = Calendar.getInstance();
				c1.setTime(realDate);
				c1.add(Calendar.MONTH, -1);
				c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
				endDate = sdf.format(c1.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));	
				}
			}else{}
			lastWeekList.add(startDate);
			lastWeekList.add(endDate);
		}catch(Exception e){
			e.printStackTrace();
		}
		return lastWeekList;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/reporter/ErReporterTracker.jsp");
    _jspx_dependants.add("/reporter/ErTimeFormatJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String reporter_Skin = null;

	boolean id_u = false;
	boolean isLastTimeLine = false;
	String urs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	UserRegistry registry= null;
	User thisuser=null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	String usr_Id_proc = request.getParameter("er_userid");
	String usr_Id = request.getParameter("eruserid");
	String userID = request.getParameter("userID");
	if(session!=null)
	{
		 UBean = (ErUserData) session.getAttribute("UBean");
		 if(throughSchedule.equalsIgnoreCase("true")) {
			 try
			 {
			if(UBean == null) {
				if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id,false);
					usr_Id_proc = usr_Id;
				}
				else if(userID != null){
					UBean = new ErUserData(userID,false);
					usr_Id_proc = userID;
				}
				else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id_proc,false);
				}
				else{
					UBean = new ErUserData(usr_Id_proc,false);
				}

			}
			}
			catch(Throwable t)
			{
			t.printStackTrace();
			}
		}
		if(UBean != null)
		{
			registry = UserRegistry.getInstance();
			thisuser= registry.getUser(session.getId(),true);
			if(thisuser!=null)
			{
				id_u = thisuser.isIdDeletedWhileLoggedIn();
				if(id_u==false )
				{
					urs = thisuser.getLoginID();
					if(!User.isDefaultUser(urs))
					{
						u_v_till = UBean.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
			if(thisuser == null && usr_Id_proc!= null ) {
				try {
					thisuser = UBean.getUser(usr_Id_proc);
					registry.setUser(session.getId(), thisuser, false);
					System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
				} catch(Exception ex) {
					System.out.println("Setting user object failed");
					ex.printStackTrace();
				}
			}
		}
	}
	if(session == null || thisuser == null)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");		
	}
	else if(id_u== true)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}

	if(session!=null && UBean != null && thisuser!=null)
	{
		//session.putValue("Page_IdentifierR",request.getRequestURI());	
		String pageName = request.getRequestURI();
		if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
		{
			//session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
		}
	}
	

	if (thisuser!=null)
	{
		String trackerUserLang = thisuser.getLanguage();
		thisuser.setUserLanguageAndSkins();
		reporter_Skin  = thisuser.getReporterSkin();

		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	//Added by Sakthivel - 26/03/2008
	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
	//Variable to be used in javascript code
	String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(thisuser!=null)
	{
		currentDateFormatForJS = thisuser.getUserDateFormat();
	}
	String strUserDateFormat =currentDateFormatForJS;
	if(currentDateFormatForJS.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormatForJS.length();i++)
		{
			if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
			{
				currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
			}
		}
	}
	egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
	String strArray[] =erbgreport.getSelection(urs);
	String strforeground = strArray[0];
	String strbackground =  strArray[1];
	String bgString="'";



	
	String titleToDisplay=request.getParameter("er_RmDispName");					

	//Back Button - Start
	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");
	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	ErHelperUtils erhelputils = null;
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);
	boolean enableBack=erhelputils.isBackButtonEnable();
	String queryString="";

	String backButtonEnable = request.getParameter("back");
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		bggroundStr = (String)request.getParameter("bggroundStr");
		request.setAttribute("SYSTEM_CAPACITY_REPORT", null);
	}
try
{
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	String uiFile = "eg_ui.ini";
	JSONObject json = new JSONObject();
	ErUserData erdata = new ErUserData(UBean.getUserId(),false);
	ErUtils erUtils = new ErUtils();
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
    String thisLanguage = ui.getDefaultLanguage();
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
    MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
	EgDateInfo egDt = new EgDateInfo();
	EgReportInfo reportInfo = new EgReportInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo ("manager");
	EgCrawler crawlerBean = new EgCrawler(new IniFile(s_iniFile_dir + "eg_topology.ini"));
	EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());
	EgDbInfo dbInfo = new EgDbInfo("manager");
	ErInfo erInfo = new ErInfo();
	EgTestInfo tokInfo = new EgTestInfo("manager");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	

	User this_user = UserRegistry.getInstance().getUser(session.getId());
	ErComponentsUtils compUtil = new ErComponentsUtils(thisuser.getLoginID());
	ErReportHelper erh = new ErReportHelper();
	EgUserRole userRole = this_user.getUserRole();
	boolean hasAdminTab = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	boolean isCompletedUserRole = userRole.hasAllComponentAccess();

	com.eg.IniFile servicesInfo = new com.eg.IniFile(s_iniFile_dir + "eg_services.ini");
	String isCapacityTrendEnabled=servicesInfo.getValue("MISC_ARGS","CapacityTrendEnabled");
	
	  json.put("hasAdminTab",hasAdminTab);
	  json.put("isCompletedUserRole",isCompletedUserRole);
	  json.put("isCapacityTrendEnabled",isCapacityTrendEnabled);

	queryString="";
	String[] options = {"Any","1 day", "2 days", "3 days", "4 days","5 days", "6 days","1 week","2 weeks","3 weeks","1 month"};
	String dispDate = null;
	String comFormat = null;
	String disable="";

	String currentDateFormat = strUserDateFormat;

	String s_site = "";
	String isSubmit = request.getParameter("isSubmit");
	String er_type = request.getParameter("er_type");
	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String er_timeline = request.getParameter("er_timeline");
	String s_inidate = request.getParameter("inidate");
	String strmin = request.getParameter("startmin");
	String enmin = request.getParameter("endmin");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String s_comptype = request.getParameter("er_comptype");
	status = (String)request.getAttribute("status");
	String[] selectedCompArray = request.getParameterValues("er_component");
	String schedule_id = request.getParameter("schedule_id");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");

	String selectedComponents = "";
	String userid = UBean.getUserId();
	boolean isBackgroundProcess = false;
	
	Vector v_site = new Vector();
	Vector v_component = new Vector();
	Vector v_componentName = new Vector();
	Vector v_comptype = new Vector();
	Vector temp_component = new Vector();
	Vector unique_component = new Vector();
	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();
	String selectedGroup = request.getParameter("select_group");
	com.eg.EgTopoInfo topoInfo = new com.eg.EgTopoInfo("manager");
	String treeParam = request.getParameter("treeParam");

	if(selectedGroup!=null && selectedGroup.equalsIgnoreCase("Service"))
	{
		session.setAttribute("Source","Service"); // for eg help
		v_site = erdata.getSites();
		s_site = request.getParameter("er_site");
		if(treeParam!=null && treeParam.length() >0)
		{
			s_site = treeParam;
		}
		if(s_site != null) {
			temp_component=crawlerBean.getAssociates(s_site);
			for(int i=0;i<temp_component.size();i++)
			{
				String temp = (String)temp_component.get(i);
				String tempStr = temp.substring(0,temp.lastIndexOf(COLON));
				String compName = temp.substring(temp.indexOf(COLON)+1,temp.lastIndexOf(COLON));
				if(compName.indexOf(COLON)>-1)
				{
					tempStr = tempStr.substring(0,tempStr.lastIndexOf(COLON));
					if(!unique_component.contains(tempStr))
					{
						unique_component.add(tempStr);
						v_component.add(temp);
					}
				}else
				{
					if(!unique_component.contains(tempStr))
					{
						unique_component.add(tempStr);
						v_component.add(temp);
					}
				}
			}
		}
	}
	else if(selectedGroup!=null && selectedGroup.equals("Segment"))
	{
		session.setAttribute("Source","Segment"); // for eg help
		v_site=erdata.getSegments();
		s_site = request.getParameter("er_site");
		if(treeParam!=null && treeParam.length() >0)
		{
			s_site = treeParam;
		}
		if(s_site != null) {
			temp_component = topoInfo.getAssociatesForSegment(s_site,2);
			for(int i=0;i<temp_component.size();i++)
			{
				String temp = (String)temp_component.get(i);
				String tempStr = temp.substring(0,temp.lastIndexOf(COLON));
				String compName = temp.substring(temp.indexOf(COLON)+1,temp.lastIndexOf(COLON));
				if(compName.indexOf(COLON)>-1)
				{
					tempStr = tempStr.substring(0,tempStr.lastIndexOf(COLON));
					if(!unique_component.contains(tempStr))
					{
						unique_component.add(tempStr);
						v_component.add(temp);
					}
				}else
				{
					if(!unique_component.contains(tempStr))
					{
						unique_component.add(tempStr);
						v_component.add(temp);
					}
				}
			}
		}
	}
	else if(selectedGroup!=null && selectedGroup.equals("Component"))
	{
		boolean relevant = false;
		String str_token="";
		String s_tmp = "";
		String server_type = "";
		session.setAttribute("Source","Component"); // for eg help
		temp_component = UBean.getAllUserComponents(3);
		List compTypes = this_user.getAllServerType();
		//
		Vector v_compt = new Vector();
		List aSpecificTest = new ArrayList();
		String cpuUtilization = reportInfo.getValue("SYSTEM_CAPACITY","Measure1");
		String freeMemoryAvailable = reportInfo.getValue("SYSTEM_CAPACITY","Measure2");
		String diskspaceUsage = reportInfo.getValue("SYSTEM_CAPACITY","Measure3");
		String networkAvailability = reportInfo.getValue("SYSTEM_CAPACITY","Measure5");
		String diskBusy = reportInfo.getValue("SYSTEM_CAPACITY","Measure4");
		aSpecificTest.add(cpuUtilization);
		aSpecificTest.add(freeMemoryAvailable);
		aSpecificTest.add(diskspaceUsage);
		aSpecificTest.add(networkAvailability);
		aSpecificTest.add(diskBusy);

		String strAggcpuUtilization = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure1");
		String strAggfreeMemoryAvailable = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure2");
		String strAggdiskspaceUsage = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure3");
		String strAggnetworkAvailability = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure5");
		String strAggdiskBusy = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure4");
		aSpecificTest.add(strAggcpuUtilization);
		aSpecificTest.add(strAggfreeMemoryAvailable);
		aSpecificTest.add(strAggdiskspaceUsage);
		aSpecificTest.add(strAggnetworkAvailability);
		aSpecificTest.add(strAggdiskBusy);

		String SeparateTest = "";
		for(int j=0; j< compTypes.size(); j++)
		{
			server_type = (String)compTypes.get(j);
			relevant = false;
			if(aSpecificTest != null && aSpecificTest.size() > 0)
			{
				for(int k =0;k<aSpecificTest.size();k++)
				{
					SeparateTest=(String)aSpecificTest.get(k);
					if(SeparateTest == null || SeparateTest.indexOf(":")==-1)
						continue;
					SeparateTest = SeparateTest.substring(0,SeparateTest.indexOf(":"));
					if(specsInfo.isTestRelevantForServer(server_type,SeparateTest,false))
					{
						relevant = true;
						break;
					}
				}
			}
			if(relevant)
			{
				v_compt.add(server_type);
			}
		}
		compTypes= new ArrayList();
		if(v_compt!=null && v_compt.size() > 0)
		{
			compTypes.addAll(v_compt);
		}
		else
		{
			compTypes = this_user.getAllServerType();
		}
		//
		if(compTypes.size() > 0)
		{
			v_comptype.addAll(compTypes);
			/*List rList = new ArrayList();
			for(int j=0; j< v_comptype.size(); j++)
			{
				String tempStr = (String)v_comptype.get(j);
				if(tempStr.startsWith("Agg_"))
					rList.add(tempStr);
			}
			v_comptype.removeAll(rList);*/
			v_comptype.remove("Host_system");
			if(s_comptype == null)
				s_comptype = (String)v_comptype.get(0);
			if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable") && v_comptype.contains(s_comptype)) 
			{
				List removeList = new ArrayList();
				for(int i=0; i<temp_component.size(); i++) 
				{
					String v_comp = (String)temp_component.get(i);
					String temp = v_comp.substring(v_comp.lastIndexOf(":")+1);
					//if(!(temp.equals(s_comptype)) || temp.startsWith("Agg_")) 
					if(!(temp.equals(s_comptype)))
					{
						removeList.add(v_comp);
					}
				}
				temp_component.removeAll(removeList);
				for(int i=0;i<temp_component.size();i++)
				{
					String tempComp = (String) temp_component.get(i);
					String componentName = tempComp.substring(0,tempComp.indexOf(":"));
					if(!v_componentName.contains(componentName))
					{
						v_componentName.add(componentName);
						v_component.add(tempComp);
					}
				}
			}
			else
			{
				v_component = new Vector();
			}
		}
	}
	String dispCsvStartDate = s_st_time+" "+s_st_hr+COLON+strmin;
	String dispCsvEndDate = s_en_time+" "+s_en_hr+COLON+enmin;

	String confirmation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	status = (String)request.getAttribute("status");
	
	String startDateTime = "";
	String endDateTime = "";
	long msecsPerHour = (long) 1000 * 60 * 60;

	if(er_timeline == null)
	{
		er_timeline="1 week";
	}

	List selectedCompList = new ArrayList();
	if(selectedCompArray != null) 
	{
		for (int i = 0; i < selectedCompArray.length; i++) 
		{
			try 
			{
				selectedCompList.add(EgURLDecoder.decode(selectedCompArray[i], UTF_8));
			}
			catch (Exception e1) {}
		}
	}
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =  egDt.egetRealDate();
			endDateTime = sdf.format(today);

			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = egDt.egetRealDate();
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(erUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = new java.util.Date();
				java.util.Date startTmp=new java.util.Date(endDateTime);
				start.setTime(startTmp.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			s_inidate="MM/dd/yyyy";
			try
			{
				int shr=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(COLON)));
				strmin=startDateTime.substring(startDateTime.indexOf(COLON)+1);
				int en_hr=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(COLON)));
				enmin=endDateTime.substring(endDateTime.indexOf(COLON)+1);
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
			catch(Exception e)
			{
				System.out.println("Eception caught :"+e);
				e.printStackTrace();
			}
		}
	}
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(new java.util.Date());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
			s_inidate="MM/dd/yyyy";
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
	}
	if(er_type == null) {
		er_type="Yes";
	}
	boolean isServiceChange = false;
	
	if(request.getParameter("isServiceChange") != null && request.getParameter("isServiceChange").equalsIgnoreCase("true")) {
		isServiceChange = true;
	}
	boolean noDataFound = true;
	Map resultMap = (Map) session.getAttribute("SYSTEM_CAPACITY_REPORT");
	/** For Save CSV Data Format */
	List list = new LinkedList();		//Add List of Data
	Vector v_measure_csv = new Vector();	//User ColumnName
	List list_data = new LinkedList();	//ColumnData
	Hashtable h_tabrc = new Hashtable();	//SubTable Data
	Hashtable h_tab = new Hashtable();	//SunTitle with SubTable Data
	String s_title = "";

	if(resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true"))
	{
		Boolean noData = ((Boolean) resultMap.get("NO_DATA_FOUND"));
		if(noData != null)
			noDataFound = noData.booleanValue();
	}
	/*boolean isDescriptorAvailable = false;
	if(resultMap != null && isSubmit != null && isSubmit.equalsIgnoreCase("true"))
	{
		Boolean descData = ((Boolean) resultMap.get("DESCRIPTOR_AVAILABLE"));
		if(descData != null)
			isDescriptorAvailable = descData.booleanValue();
	}*/
	String excludeweekend = request.getParameter("er_excwe");
	if (excludeweekend == null || excludeweekend.equals("")) {
		excludeweekend = "Yes";
	}
	String Days = (erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days") == null) ?
			"Saturday,Sunday" : erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days");
	
	Vector v_time = new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min = new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("25");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	String timefrom="";
	String minfrom="";
	String timeto="";
	String minto="";
	String timefrom1=(erh.getTimeFrame("TIMEFRAME","From")==null) ? "00:00" :erh.getTimeFrame("TIMEFRAME","From");
	String timeto1=(erh.getTimeFrame("TIMEFRAME","To")==null) ? "23:59" :erh.getTimeFrame("TIMEFRAME","To");
	timefrom1 = reportInfo.getValue("SYSTEM_CAPACITY","startTime");
	timeto1 = reportInfo.getValue("SYSTEM_CAPACITY","endTime");
	StringTokenizer st;
	if(timefrom1 != null)
	{
		st = new StringTokenizer(timefrom1,":");
		if(st.hasMoreTokens())
		{
			timefrom=st.nextToken();
			minfrom=st.nextToken();
		}
	}
	if(timeto1 != null)
	{
		st=new StringTokenizer(timeto1,":");
		if(st.hasMoreTokens())
		{
			timeto=st.nextToken();
			minto=st.nextToken();
		}
	}
	String timefrom2 = request.getParameter("timefrom");
	String minfrom2 = request.getParameter("minfrom");
	String timeto2 = request.getParameter("timeto");
	String minto2 = request.getParameter("minto");
	String stmin = "00";

	if (timefrom2!=null)
		timefrom = timefrom2;
	if (minfrom2!=null)
		minfrom = minfrom2;
	if (timeto2!=null)
		timeto = timeto2;
	if (minto2!=null)
		minto = minto2;

	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErSystemCapacityReportPrint.jsp");

	//json = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	hiddenParams.put("er_trenddata","Yes");
	hiddenParams.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenParams.put("fromSchedule",reqFromSchedule);
	hiddenParams.put("bgenabled",strbgrepportName);
//	hiddenParams.put("forwardto","ErSystemCapacityReport");
	hiddenParams.put("isServiceChange","false");
	hiddenParams.put("er_type",er_type);
	hiddenParams.put("er_rtype","Capacity Planning");
	hiddenParams.put("er_trgttype","System");
//	hiddenParams.put("isFavorite","false");
	hiddenParams.put("inidate",currentDateFormat);
	hiddenParams.put("select_group",selectedGroup);
	//hiddenParams.put("isSchedule","false");
	hiddenParams.put("schedule_id",schedule_id);
	hiddenParams.put("limitforbg",limitforbg);
	hiddenParams.put("savereport","save");
	hiddenParams.put("savereport","save");
	hiddenParams.put("er_bgreportfrom","CapacityPlanning_System");
	hiddenParams.put("eruserid",userid);
	hiddenParams.put("er_ViewName","ErSystemCapacityReport.jsp");
	if(fromScheduleModify!=null)
		hiddenParams.put("fromScheduleModify",fromScheduleModify);
	else
		hiddenParams.put("fromScheduleModify","null");
	if(fromFavoriteModify!=null)
		hiddenParams.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddenParams.put("fromFavoriteModify","null");
	hiddenParams.put("favorite_id", favorite_id);
	hiddenParams.put("er_favorite", er_favorite);
	


/*******************************************************************************
* File name : ErTimeFormat.jsp
* Purpose   : Time Control to be used thorugh out Reporter.
* Version   : Reporter 4.0
*******************************************************************************/


	JSONArray timelineComboArray=new JSONArray();
	JSONArray timelineHourComboArray=new JSONArray();
	String startDateJSON="";
	String endDateJSON="";
	String startHourJSON="";
	String endHourJSON="";
	String selectedGraphMode="";
	String startDateForHighchart=null;
	String endDateForHighchart=null;
	String chartTypeForUI=null;
	
	User userName = UserRegistry.getInstance().getUser(session.getId());
	ErReportHelper er_rpthelper = new ErReportHelper();
	EgReportInfo rptInfo = new EgReportInfo("manager");
	EgMappingInfo mappingObj = new EgMappingInfo(thisuser.getLanguage());
	String reqOption = request.getParameter("option");
	String deftimeline = rptInfo.getDefaultTimeLine("MISC","MaxTimeline");
	List alist = Arrays.asList(options);
	String loginName = userName.getLoginID();
	int len;
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	//String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
	String[] lstWeeksArr = new String[]{"Last week", "Last month"};	
	if(strUsrTimeline != null && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
		
	if (reqOption!=null && reqOption.equalsIgnoreCase("Citrix"))
	{
		if(deftimeline !=null && !deftimeline.equals("-1"))
		{
			if(len > alist.indexOf(deftimeline)+1)
			{
				len=alist.indexOf(deftimeline)+1;
			}
			if (len >0)
				strUsrTimeline = (String)alist.get(len-1);
			else
				strUsrTimeline = (String)alist.get(len);
		}

	}
	if(len == 0)
		len = options.length;
	String grophmodeon = request.getParameter("grophmodeon");
	String r_type = request.getParameter("er_type");
	String reporttype = request.getParameter("reporttype");
	String er_rtype = request.getParameter("er_rtype");
	String er_rtype_proc = request.getParameter("er_rtype_proc");
	String timeformat_trend = request.getParameter("er_trenddata");
	if (timeformat_trend == null || timeformat_trend ==" " )
		timeformat_trend = "No";

	if (reporttype==null || reporttype.equalsIgnoreCase("null"))
	{
		if (er_rtype!=null && er_rtype.equalsIgnoreCase("macro"))
		{
			reporttype="executive";
		} else if (er_rtype!=null && ( er_rtype.equalsIgnoreCase("application") || er_rtype.equalsIgnoreCase("network") 
		|| er_rtype.equalsIgnoreCase("site") || er_rtype.equalsIgnoreCase("system") ||  er_rtype.equalsIgnoreCase("Event") ) )
		{
			reporttype="operation";
		}

	}

	String colum="";
	if(reporttype!=null &&reporttype.equalsIgnoreCase("executive"))
		colum="9";
	else
		colum="6";
	String er_gtype=request.getParameter("er_gtype");

	java.util.Date start = egDt.egetRealDate();
	String startMin = Integer.toString(start.getMinutes());
	String endMin = Integer.toString(start.getMinutes());
	String strsmin_11=request.getParameter("startmin");
	String etrsmin_11=request.getParameter("endmin");
	if(strsmin_11 != null && strsmin_11.length()>0)
		startMin = strsmin_11;
	if(etrsmin_11 != null && etrsmin_11.length()>0)
		endMin = etrsmin_11;

	EgTimeZoneConverter timeZoneConverterStart = null;
	EgTimeZoneConverter timeZoneConverterEnd = null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay = null;
	String endMinForDisplay = null;
	for(int e_ctr=0; e_ctr<len; e_ctr++)
	{
		String s_timeline=options[e_ctr];
		if(s_timeline.equalsIgnoreCase("Any"))
		{
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",mappingObj.getTextDescription("reporter.common."+s_timeline));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}else if(s_timeline.contains("Last")){
			String displayField=null;
			String viewField=null;
			displayField = s_timeline;
			int spaceNum = 0;
			for(int i=0; i<s_timeline.length();i++){
				char ch = s_timeline.charAt(i);
				if(ch== ' '){
				   spaceNum++; 
				}
			}
			if(spaceNum > 2){
				String countStr = s_timeline.substring(s_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = s_timeline.substring(s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.length());
				String last = s_timeline.substring(0, s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr + end + "_" + last;				
			}else{
				viewField = "1 "+s_timeline.substring(s_timeline.lastIndexOf(" ")+1, s_timeline.length())  + "_" + s_timeline.substring(0, s_timeline.indexOf(" "));				
			}
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",displayField);
			timelineJSON.put("valueField", viewField.toLowerCase());
			timelineComboArray.add( timelineJSON );			
		}
		else
		{
			String numstr = s_timeline.substring(0,s_timeline.indexOf(" "));
			String strextra = s_timeline.substring(s_timeline.indexOf(" ")+1);

			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",numstr+" "+ mappingObj.getTextDescription("reporter.common."+strextra));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}

		/*if(er_timeline!=null && er_timeline.equals((String)options[e_ctr]))
		{
			if(er_timeline.equalsIgnoreCase("Any"))
			{
				String strer_timeline="reporter.common."+er_timeline;

			}
			else
			{
				String numstr = er_timeline.substring(0,er_timeline.indexOf(" "));
				String strextra = er_timeline.substring(er_timeline.indexOf(" ")+1);
				String str_strextra="reporter.common."+strextra;
			}
		}
		else
		{
			if(options[e_ctr].equalsIgnoreCase("Any"))
			{
				String  str_options="reporter.common."+options[e_ctr];
			}
			else
			{
				String numstr = options[e_ctr].substring(0,options[e_ctr].indexOf(" "));
				String strextra = options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				//FIX FOR SUPPORT TOMCAT 6.0
				String str_extra= "reporter.common."+strextra;
			}
		}*/
	} 

	List lastDataList = new ArrayList();
	JSONArray lastDataJSON = null;
	int lastWeekCount = 1;		
	if(isLastTimeLine){
		if(strUsrTimeline.equals("-1")){
			for(int i=0;i<lstWeeksArr.length;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 week")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("2 weeks")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("3 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("4 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 month")){
			lastWeekCount = 2;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);			
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}		
		}	
	}
	
	String isVmReport = request.getParameter("isVmReport");
	if(er_timeline!=null && !er_timeline.equals("Any"))
	{
		/*if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		}
		else*/
	
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			
			
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat); 
	}
	else
	{
	
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		
		
		//dispDate = s_st_time;
	}
	if (timeformat_trend!=null && timeformat_trend.equals("Yes")&& er_timeline!=null && !er_timeline.equals("Any")) {
		
		s_st_hr="00";
		startMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start //User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;	
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName,true); 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" + startMin; 
			
			startDateForDisplay = dispDate;
			startHourForDisplay = s_st_hr;
			startMinForDisplay = startMin;

			dispDate=(String) timeZoneConverterStart.getDate(false);
			s_st_time=dispDate;
			startDateJSON=dispDate;
			s_st_hr = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();
		}
		
	} else { 
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;			
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName);
	 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" +startMin; 
			startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
			startHourForDisplay = timeZoneConverterStart.getHour();
			s_st_hr = s_st_hr.trim();
			startMinForDisplay = timeZoneConverterStart.getMinute();
			startDateJSON=dispDate;			
		}
		
	}
 	/*if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_st_time;
	}*/
	
 

	for(int s_ctr=0; s_ctr<24; s_ctr++)
	{
		s_st_hr = s_st_hr.trim();
		if(!er_timeline.endsWith("last"))
			startHourJSON=s_st_hr;
		JSONObject timelineHourJSON = new JSONObject();
		timelineHourJSON.put("displayField",String.valueOf(s_ctr));
		timelineHourJSON.put("valueField",String.valueOf(s_ctr));
		timelineHourComboArray.add( timelineHourJSON );
	}

	
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
		else
		{
			if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
			{
				comFormat = currentDateFormat;
			}
			else
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
	}
	else
	{
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		//comFormat = currentDateFormat;
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat); 
	}

	if (timeformat_trend!=null && timeformat_trend.equals("Yes") && er_timeline!=null && !er_timeline.equals("Any")) {
		s_en_hr="00";
		endMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			System.out.println("1Manager Start Time-->"+startDateForHighchart);
			System.out.println("1Manager Start Hour-->"+startHourJSON);
			System.out.println("1Manager End Time--->"+endDateForHighchart);		

		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " " + s_en_hr + ":" + endMin, userName,true);
		
		endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;

			endDateForDisplay = dispDate;
			endHourForDisplay = s_en_hr;
			endMinForDisplay = endMin;
				
			dispDate=(String) timeZoneConverterEnd.getDate(false);
			s_en_time=dispDate;
			endDateJSON=dispDate;
			s_en_hr = timeZoneConverterEnd.getHour();
			endHourJSON=s_en_hr;
			endMin = timeZoneConverterEnd.getMinute(); 
		}		
		
	} else {
		if(er_timeline.endsWith("last")){			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			/*System.out.println("2Manager Start Time-->"+startDateForHighchart);
			System.out.println("2Manager Start Hour-->"+startHourJSON);
			System.out.println("2Manager End Time--->"+endDateForHighchart);*/
			System.out.println("2Manager-Last Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " "+ s_en_hr + ":" + endMin, userName);

			endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;
			endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
			endHourForDisplay = timeZoneConverterEnd.getHour(); 
			endHourJSON=s_en_hr;
			s_en_hr = s_en_hr.trim();
			endMinForDisplay = timeZoneConverterEnd.getMinute();
			endDateJSON=dispDate;
			System.out.println("2Manager Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}
	}

	//for(int e_ctr=0; e_ctr<24; e_ctr++)
	//{
		//s_en_hr=s_en_hr.trim();
		//endHourJSON=s_en_hr;
	//}
	if(request.getParameter("er_type")!=null && !(request.getParameter("er_type")).equalsIgnoreCase("Comparison"))
	{
		if(request.getParameter("er_type").equals("Yes") || request.getParameter("er_type").equals("Vmgstatus"))
		{
		
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_type_proc")!=null)
	{
		if(request.getParameter("er_type_proc").equals("Yes"))// || request.getParameter("er_type_proc").equals("Vmgstatus"))
		{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_rtype")!=null && request.getParameter("er_rtype").equalsIgnoreCase("AlarmHistory"))
	{
		
	}
	else if(reporttype!=null && (reporttype.equalsIgnoreCase("executive")|| reporttype.equalsIgnoreCase("operation")||reporttype.equalsIgnoreCase("TopN")) || (grophmodeon!=null && grophmodeon.equalsIgnoreCase("yes")) ||er_gtype!=null && er_gtype.equalsIgnoreCase("Comparison"))
	{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D"))
			{
				selectedGraphMode="2D";
			}
			if(mode.equals("3D"))
			{
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
	}


	hiddenParams.put("er_usertimeline",strUsrTimeline);
	String action = request.getParameter("action");
	if(action!=null && action.equals("changeComponent"))
	{
		//er_component
		JSONArray componentList = new JSONArray();
		if(v_component.size() == 0)
		{
			v_comp_popup.add("-1");
			v_comp_popup_disp.add("Not Applicable!");
			JSONObject jObj = new JSONObject();
			jObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
			jObj.put("valueField","-1");
			componentList.add(jObj);
			pageParams.put("selectedComps","-1");
		}
		else
		{
			Collections.sort(v_component,String.CASE_INSENSITIVE_ORDER);
			String tempComponent = (String) v_component.get(0);
			StringBuffer sbSelectedValues= new StringBuffer();
			for( int i=0; i<v_component.size(); i++)
			{
				String s=(String)v_component.get(i);
				String strcompname = "";
				strcompname = s.substring(0,s.indexOf(COLON));
				if(selectedCompList.size() == 0 || selectedCompList.contains("-1") || selectedCompList.contains(v_component.get(i)))
				{
					sbSelectedValues.append(","+s);
				}
				v_comp_popup.add(s);
				v_comp_popup_disp.add(strcompname);
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",strcompname);
				jObj.put("valueField",s);
				componentList.add(jObj);
			}
			if(sbSelectedValues!=null)
			{
				String selectedComps = sbSelectedValues.toString();
				if(selectedComps!=null && (selectedComps.length()>0 && selectedComps.indexOf(",")==0))
					selectedComps = selectedComps.substring(1);

				pageParams.put("selectedComps",selectedComps);
			}
		}
		json.put("pageParams",pageParams);
		json.put("hiddenParams",hiddenParams);
		json.put("componentList",componentList);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(json.toString());
	}
	else
	{
		String strWidth = "90%";
		if(backreqMap == null || backreqMap != null && backreqMap.size() == 0)
			strWidth="100%";

		String timePeriodLbl = intlmap.getTextDescription("reporter.common.Time Period");
		String timeLineLbl = intlmap.getTextDescription("reporter.common.Timeline");
		String fromLbl = intlmap.getTextDescription("reporter.common.From");
		String toLbl = intlmap.getTextDescription("reporter.common.To");
		String compLbl = intlmap.getTextDescription("reporter.capacity.Component");
		String systemLbl = intlmap.getTextDescription("reporter.capacity.System");

		screenLabels.put("reporter.common.SYSTEM CAPACITY REPORT",intlmap.getTextDescription("reporter.common.SYSTEM CAPACITY REPORT"));
		screenLabels.put("reporter.common.Back",intlmap.getTextDescription("reporter.common.Back"));
		screenLabels.put("reporter.common.SAVE",intlmap.getTextDescription("reporter.common.SAVE"));
		screenLabels.put("reporter.common.PRINT",intlmap.getTextDescription("reporter.common.PRINT"));
		screenLabels.put("reporter.common.MAIL",intlmap.getTextDescription("reporter.common.MAIL"));
		screenLabels.put("reporter.capacity.Component Type",intlmap.getTextDescription("reporter.capacity.Component Type"));
		screenLabels.put("reporter.common.Not Applicable",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
		screenLabels.put("reporter.capacity.Component",compLbl);
		screenLabels.put("reporter.common.Time period",timePeriodLbl);
		screenLabels.put("reporter.common.From",fromLbl);
		screenLabels.put("reporter.common.To",toLbl);
		screenLabels.put("reporter.common.Hrs",intlmap.getTextDescription("reporter.common.Hrs"));
		screenLabels.put("reporter.common.Mins",intlmap.getTextDescription("reporter.common.Mins"));
		screenLabels.put("reporter.common.Timeline",timeLineLbl);
		screenLabels.put("reporter.common.Report Generation",intlmap.getTextDescription("reporter.common.Report Generation"));
		screenLabels.put("reporter.common.Exclude weekends",intlmap.getTextDescription("reporter.common.Exclude weekends"));
		screenLabels.put("reporter.common.Report Name",intlmap.getTextDescription("reporter.common.Report Name"));
		screenLabels.put("reporter.common.Excludes",intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);

		String fromFavSch = request.getParameter("fromFavSch");
		if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") || (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
		{
			json.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		}
		queryString = request.getQueryString();
		String selected = "";
		if(selectedGroup!=null && (selectedGroup.equalsIgnoreCase("Service") || selectedGroup.equalsIgnoreCase("Segment")))
		{
			pageParams.put("selectedGroup",selectedGroup);
			screenLabels.put("selectedGroup",intlmap.getTextDescription("reporter.common."+selectedGroup));
			JSONArray selectedGrpList = new JSONArray();
			if(v_site.size() == 0)
			{
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
				jObj.put("valueField","-1");
				selectedGrpList.add(jObj);
				pageParams.put("selectedGroupValue","-1");
			}
			else
			{
				Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);
				String tempService = (String) v_site.get(0);

				JSONObject jObj = new JSONObject();
				jObj.put("displayField",intlmap.getTextDescription("reporter.capacity.Please select a "+selectedGroup));
				jObj.put("valueField","-1");
				selectedGrpList.add(jObj);
				if(v_site==null || v_site.size()==0)
				{
					pageParams.put("selectedGroupValue","-1");
				}
				for( int i=0; i<v_site.size(); i++)
				{
					String grpValue = (String)v_site.get(i);
					jObj = new JSONObject();
					jObj.put("displayField",grpValue);
					jObj.put("valueField",grpValue);
					selectedGrpList.add(jObj);
					if(s_site != null)
					{
						if(s_site.equalsIgnoreCase(grpValue))
							pageParams.put("selectedGroupValue",grpValue);
					}
					else
					{
						if(tempService.equalsIgnoreCase(grpValue))
							pageParams.put("selectedGroupValue",grpValue);
					}
				}
			}
			json.put("selectedGrpList",selectedGrpList);
		}
		else if(selectedGroup!=null && selectedGroup.equalsIgnoreCase("Component"))
		{
			pageParams.put("selectedGroup",selectedGroup);
			screenLabels.put("selectedGroup",intlmap.getTextDescription("reporter.common."+selectedGroup));
			//er_comptype
			JSONArray componentTypeList = new JSONArray();
			selected = "";
			if(v_comptype.size() == 0)
			{
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
				jObj.put("valueField","-1");
				componentTypeList.add(jObj);
				pageParams.put("selectedCompType","-1");
			}
			else
			{
				Collections.sort(v_comptype,String.CASE_INSENSITIVE_ORDER);
				String defaultOption = "";
				if(s_comptype == null)
				{
					pageParams.put("selectedCompType","-1");
				}
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Component Type"));
				jObj.put("valueField","-1");
				componentTypeList.add(jObj);

				//v_comptype=compUtil.getIntnlSupportCompType(v_comptype,"#");
			
				ArrayList sortedNameList1 = new ArrayList();
				sortedNameList1 = sorter.getSortedCompTypeList(v_comptype);
				for(int n=0;n<sortedNameList1.size();n++)
				{
					EgName nameObj =(EgName) sortedNameList1.get(n);
					String dispValue = nameObj.getLocalName();
					String sCompType = nameObj.getActualName();
					//String s=(String)v_comptype.get(n);
					//ArrayList aListData = tokInfo.egTokenizer(s,"#");
			        //String CompTypeDisp=(String)aListData.get(0);
					//String CompTypeValue=(String)aListData.get(1);

					jObj = new JSONObject();
					jObj.put("displayField",dispValue);
					jObj.put("valueField",sCompType);
					componentTypeList.add(jObj);

					if(s_comptype != null)
					{
						if(s_comptype.equalsIgnoreCase(sCompType))
							pageParams.put("selectedCompType",sCompType);
					}
				}
			}
			json.put("componentTypeList",componentTypeList);
			//er_component
			JSONArray componentList = new JSONArray();
			selected = "";
			if(v_component.size() == 0)
			{
				v_comp_popup.add("-1");
				v_comp_popup_disp.add("Not Applicable!");
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
				jObj.put("valueField","-1");
				componentList.add(jObj);
				pageParams.put("selectedComps","-1");
			}
			else
			{
				Collections.sort(v_component,String.CASE_INSENSITIVE_ORDER);
				String tempComponent = (String) v_component.get(0);
				StringBuffer sbSelectedValues= new StringBuffer();
				for( int i=0; i<v_component.size(); i++)
				{
					String s=(String)v_component.get(i);
					String strcompname = "";
					strcompname = s.substring(0,s.indexOf(COLON));
					if(selectedCompList.size() == 0 || selectedCompList.contains("-1") || selectedCompList.contains(v_component.get(i)))
					{
						sbSelectedValues.append(","+s);
					}
					v_comp_popup.add(s);
					v_comp_popup_disp.add(strcompname);
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",strcompname);
					jObj.put("valueField",s);
					componentList.add(jObj);
				}
				if(sbSelectedValues!=null)
				{
					String selectedComps = sbSelectedValues.toString();
					if(selectedComps!=null && (selectedComps.length()>0 && selectedComps.indexOf(",")==0))
						selectedComps = selectedComps.substring(1);

					pageParams.put("selectedComps",selectedComps);
				}
			}
			json.put("componentList",componentList);
		}
		JSONArray yesNoOpts = new JSONArray();
		JSONObject yesOpt = new JSONObject();
		yesOpt.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		yesOpt.put("valueField","Yes");
		yesNoOpts.add(yesOpt);
		JSONObject noOpt = new JSONObject();
		noOpt.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		noOpt.put("valueField","No");
		yesNoOpts.add(noOpt);

		json.put("yesNoOpts",yesNoOpts);

		if (!StringUtils.isNull(titleToDisplay)){ 
			list.add(titleToDisplay);
		}
		else
		{
			list.add(intlmap.getTextDescription("reporter.common.SYSTEM CAPACITY REPORT"));
		}
		if(excludeweekend.equalsIgnoreCase("Yes") )
		{
			list.add('"'+timePeriodLbl+":"+fromLbl+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+toLbl+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs")+'"'+","+'"'+intlmap.getTextDescription("reporter.common.Exclude weekends")+":"+Days+'"');
		}
		else
		{
			list.add(timePeriodLbl+":"+fromLbl+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+toLbl+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs"));
		}
		json.put("timelineComboArray",timelineComboArray);
		pageParams.put("startDateJSON",startDateJSON);
		pageParams.put("endDateJSON",endDateJSON);
		pageParams.put("startHourJSON",startHourJSON);
		pageParams.put("endHourJSON",endHourJSON);

		pageParams.put("startDateForDisplay",startDateForDisplay);
		pageParams.put("startHourForDisplay",startHourForDisplay);
		pageParams.put("startMinForDisplay",startMinForDisplay);
		pageParams.put("endDateForDisplay",endDateForDisplay);
		pageParams.put("endHourForDisplay",endHourForDisplay);
		pageParams.put("endMinForDisplay",endMinForDisplay);

		pageParams.put("startmin",startMin);
		pageParams.put("endmin",endMin);
		pageParams.put("timefrom",timefrom);
		pageParams.put("minfrom",minfrom);
		pageParams.put("timeto",timeto);
		pageParams.put("minto",minto);

		pageParams.put("selectedTimeline",er_timeline);
		String er_reportgenration = request.getParameter("er_reportgenration");
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
			pageParams.put("er_reportgenration","background");
		}
		else if (er_reportgenration != null && er_reportgenration.equals("background-csv"))
		{
			pageParams.put("er_reportgenration","background-csv");
		}
		else
		{
			pageParams.put("er_reportgenration","foreground");
		}
		String bg_reportname = request.getParameter("bg_reportname");
		if(bg_reportname == null)
		{
			bg_reportname = "";
		}
		JSONArray repGenOpts= new JSONArray();
		JSONObject bgOpt = new JSONObject();
		bgOpt.put("displayField",strbackground);
		bgOpt.put("valueField","background");
		repGenOpts.add(bgOpt);

		bgOpt = new JSONObject();
		bgOpt.put("displayField","Background Save - CSV");
		bgOpt.put("valueField","background-csv");
		repGenOpts.add(bgOpt);

		bgOpt = new JSONObject();
		bgOpt.put("displayField",strforeground);
		bgOpt.put("valueField","foreground");
		repGenOpts.add(bgOpt);
		json.put("repGenOpts",repGenOpts);

		pageParams.put("bg_reportname",bg_reportname);

		if(reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes"))
		{
			screenLabels.put("selectSubmitBtnLbl",intlmap.getTextDescription("reporter.common.SAVE"));
		}
		else
		{
			screenLabels.put("selectSubmitBtnLbl",intlmap.getTextDescription("reporter.common.SUBMIT"));
		}
		String heading1="",title="";
		if(s_site!=null)
		{
			heading1 = " Service - " + s_site;
		    title="Service";
		}
		if(selectedGroup!=null && selectedGroup.equalsIgnoreCase("Component")) {
			if(s_comptype!=null)
			{
				heading1 = " Component Type - " + intlmap.getComponentTypeDescription(s_comptype);
				 title=" Component Type";
			}
		}
		else if(selectedGroup!=null && selectedGroup.equalsIgnoreCase("Segment")) {
			if(s_site!=null)
			{
				heading1 = " Segment - " + s_site;
				 title="Segment";
			}
		}
		String sDateForDisplay=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
		String eDateForDisplay=endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

		screenLabels.put("selectionDetailsTitle",title);
		JSONObject selDetailsJson = new JSONObject();
		selDetailsJson.put(intlmap.getTextDescription("reporter.cpacity.Analyze by"),heading1);
		selDetailsJson.put(intlmap.getTextDescription("reporter.cpacity.Exclude weekends"),excludeweekend);
		selDetailsJson.put(timePeriodLbl,excludeweekend);
		selDetailsJson.put(timePeriodLbl,"<span class='font_bold'> </span> "+timefrom+":"+minfrom+"   "+"<span class='font_bold'> to </span> "+timeto+":"+minto);
		selDetailsJson.put(timeLineLbl,"<span class='font_bold'> </span> "+sDateForDisplay+" " + intlmap.getTextDescription("reporter.common.hrs")+"  "+"<span class='font_bold'> to </span>  "+eDateForDisplay + " " + intlmap.getTextDescription("reporter.common.hrs"));

		json.put("selDetailsJson",selDetailsJson);
		if (er_reportgenration != null && (er_reportgenration.equals("background") || er_reportgenration.equals("background-csv")))
		{
			if(bggroundStr != null && !bggroundStr.equals(""))
			{
				isBackgroundProcess = true;
		/*		if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
				{
				}*/
				pageParams.put("bggroundStr",bggroundStr);
				pageParams.put("status",status);
				pageParams.put("bgRrtMsg",erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
				pageParams.put("bgRrtUrl","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom=CapacityPlanning_System&userID="+urs+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
				pageParams.put("bgRptLinkMsg",intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
				json.put("dataAvailable","true");
			}
			else
			{
				json.put("dataAvailable","false");
			}
		}
		else 
		{
			if(isSubmit != null && isSubmit.equalsIgnoreCase("true"))
			{
				String heading = "";
				if(s_site!=null)
					heading = " Service - " + s_site;
				if(selectedGroup.equalsIgnoreCase("Component")) {
					if(s_comptype!=null)
						heading = " Component Type - " + intlmap.getComponentTypeDescription(s_comptype);
				} else if(selectedGroup.equalsIgnoreCase("Segment")) {
					if(s_site!=null)
						heading = " Segment - " + s_site;
				}

				// Added for csv
				Vector v_date = new Vector();
				v_date.add("\""+intlmap.getTextDescription("reporter.common.Start Date")+" : "+sDateForDisplay+"\"");
				v_date.add("\""+intlmap.getTextDescription("reporter.common.End Date")+" : "+eDateForDisplay+"\"");
				
				s_title = "";
				list.add(v_date);
				list.add(intlmap.getTextDescription("reporter.common.System Capacity Report") + " - "+heading);
				// added for csv ends

				String cpuUtilization = reportInfo.getValue("SYSTEM_CAPACITY","Measure1");
				String freeMemoryAvailable = reportInfo.getValue("SYSTEM_CAPACITY","Measure2");
				String diskspaceUsage = reportInfo.getValue("SYSTEM_CAPACITY","Measure3");
				String diskBusy = reportInfo.getValue("SYSTEM_CAPACITY","Measure4");
				String networkAvailability = reportInfo.getValue("SYSTEM_CAPACITY","Measure5");
				if(s_comptype!=null && s_comptype.startsWith("Agg_"))
				{
					cpuUtilization = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure1");
					freeMemoryAvailable = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure2");
					diskspaceUsage = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure3");
					diskBusy = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure4");
					networkAvailability = reportInfo.getValue("SYSTEM_CAPACITY","AggMeasure5");
				}
				
				int[] percentiles;
				String rhs = "";
				String strPercentile = "";

				String cpuUtilTest = cpuUtilization.substring(0,cpuUtilization.indexOf(COLON));
				String cpuUtilMeasure = cpuUtilization.substring(cpuUtilization.indexOf(COLON)+1);
				String cpuUtilMeasureUnit = tablesInfo.getUnitForMeasure(cpuUtilTest,cpuUtilMeasure);
				
				String memoryTest = freeMemoryAvailable.substring(0,freeMemoryAvailable.indexOf(COLON));
				String memoryMeasure = freeMemoryAvailable.substring(freeMemoryAvailable.indexOf(COLON)+1);
				String memoryMeasureUnit = tablesInfo.getUnitForMeasure(memoryTest,memoryMeasure);
				
				String diskspaceTest = diskspaceUsage.substring(0,diskspaceUsage.indexOf(COLON));
				String diskspaceMeasure = diskspaceUsage.substring(diskspaceUsage.indexOf(COLON)+1);
				String diskspaceMeasureUnit = tablesInfo.getUnitForMeasure(diskspaceTest,diskspaceMeasure);
				
				String networkTest = networkAvailability.substring(0,networkAvailability.indexOf(COLON));
				String networkMeasure = networkAvailability.substring(networkAvailability.indexOf(COLON)+1);
				String networkMeasureUnit = tablesInfo.getUnitForMeasure(networkTest,networkMeasure);

				String diskActivityTest = diskBusy.substring(0,diskBusy.indexOf(COLON));
				String diskActivityMeasure = diskBusy.substring(diskBusy.indexOf(COLON)+1);
				String diskActivityMeasureUnit = tablesInfo.getUnitForMeasure(diskActivityTest,diskActivityMeasure);

				Vector v_test = new Vector();
				v_test.add(cpuUtilization);
				v_test.add(freeMemoryAvailable);
				v_test.add(diskspaceUsage);
				v_test.add(diskBusy);
				v_test.add(networkAvailability);
				String systemTest = "SystemTest";
				if(s_comptype!=null && s_comptype.startsWith("Agg_"))
				{
					systemTest = cpuUtilTest;
				}
				String greaterThan = ">";
				String measure1_Check = reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Check");
				String measure2_Check = reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Check");
				String measure3_Check = reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Check");
				String measure4_Check = reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Check");
				String measure5_Check = reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Check");

				String measure1_Title = reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Title");
				String measure2_Title = reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Title");
				String measure3_Title = reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Title");
				String measure4_Title = reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Title");
				String measure5_Title = reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Title");
				
				Collections.sort(v_component);

				if(!noDataFound)
				{
					json.put("dataAvailable","true");
					boolean isSummaryOnly = false;
					String summaryOnly = reportInfo.getValue("SYSTEM_CAPACITY","SummaryOnly");
					if(summaryOnly != null && summaryOnly.equalsIgnoreCase("yes"))
						isSummaryOnly = true;

					screenLabels.put("measure1_Title",measure1_Title+" ("+cpuUtilMeasureUnit+")");
					screenLabels.put("measure2_Title",measure2_Title+" ("+memoryMeasureUnit+")");
					screenLabels.put("measure3_Title",measure3_Title+" ("+diskspaceMeasureUnit+")");
					screenLabels.put("measure4_Title",measure4_Title+" ("+diskActivityMeasureUnit+")");
					screenLabels.put("measure5_Title",measure5_Title+" ("+networkMeasureUnit+")");
					// added for csv starts
					list_data = new LinkedList();
					v_measure_csv = new Vector();
					h_tabrc = new Hashtable();
					h_tab = new Hashtable();

					v_measure_csv.add(intlmap.getTextDescription("reporter.capacity.Component"));
					v_measure_csv.add(measure1_Title + " "+ cpuUtilMeasureUnit);
					v_measure_csv.add("");
					v_measure_csv.add("");
					v_measure_csv.add("");
					//if(!isSummaryOnly)
					//	v_measure_csv.add("");
					v_measure_csv.add(measure2_Title + " " + memoryMeasureUnit);
					v_measure_csv.add("");
					v_measure_csv.add("");
					v_measure_csv.add("");
					
					v_measure_csv.add(measure3_Title + " " + diskspaceMeasureUnit);
					v_measure_csv.add("");
					v_measure_csv.add("");
					v_measure_csv.add("");
					
					v_measure_csv.add(measure4_Title + " " + networkMeasureUnit);
					v_measure_csv.add("");
					v_measure_csv.add("");
					v_measure_csv.add("");

					v_measure_csv.add(measure5_Title + " " + networkMeasureUnit);
					v_measure_csv.add("");
					v_measure_csv.add("");
					v_measure_csv.add("");
					
					list_data.add("");
					boolean descriptorAvail = false;
					Hashtable infoTable  = new Hashtable();

					JSONArray gridData = new JSONArray();
					JSONArray columnDetails = new JSONArray();

					JSONObject cObj = new JSONObject();
					cObj.put("colName","System");
					cObj.put("Measurement","NONE");
					cObj.put("SUB_COLUMNS","0");
					columnDetails.add(cObj);

					int gridColumnCnt = 1;
					for(int i =0; i<v_test.size();i++)
					{
						descriptorAvail = false;
						String temStrTest = (String)v_test.get(i);
						String test = temStrTest.substring(0,temStrTest.indexOf(COLON));
						String measure = temStrTest.substring(temStrTest.indexOf(COLON)+1);
						String measureUnit = tablesInfo.getUnitForMeasure(test,measure);
						if(measureUnit==null || measureUnit.length()==0)
							measureUnit = "%";
						percentiles = getDefinedPercentile(test,measure);
						rhs = reportInfo.getValue("CAPACITY_PLANNING",test+ COLON +measure);
						if(rhs == null || rhs.length() == 0){
							rhs = "MAX";
						}
						if("MP".equalsIgnoreCase(rhs)){
							rhs = "MIN";
						}else{
							rhs = "MAX";
						}
						String percentile = (rhs.equals("MAX") ? String.valueOf(percentiles[1]) : String.valueOf(percentiles[0]));
						
						String service =null;
						Vector infos = null;
						for(int j=0; j<v_component.size(); j++)
						{
							String componentType = "";
							String tempCompType = (String)v_component.get(j);
							if(!selectedGroup.equalsIgnoreCase("Component"))
							{
								componentType = tempCompType.substring(tempCompType.indexOf(COLON)+1);
								componentType = componentType + COLON + tempCompType.substring(0,tempCompType.indexOf(COLON));
							}
							else
							{
								componentType = tempCompType;
							}
							//componentType = componentType.substring(componentType.indexOf("#")+1);
							infos = erInfo.getInfosForTest(service,test,componentType);
							if(infos.size()>0)
								descriptorAvail = true;
						}
						infoTable.put(test,new Boolean(descriptorAvail));
						JSONObject jObj = new JSONObject();

						String measureDispName = reportInfo.getValue("SYSTEM_CAPACITY","Measure"+(i+1)+"_Title");

						jObj.put("colName",measureDispName);
						jObj.put("Measurement",measureUnit);
						
						if((isSummaryOnly && systemTest.equalsIgnoreCase(test)) || !descriptorAvail)
						{
							gridColumnCnt = gridColumnCnt+2;
							jObj.put("SUB_COLUMNS","3");
							JSONArray subHeadingsForMeasure =  new JSONArray();
							subHeadingsForMeasure.add(percentile+intlmap.getTextDescription("reporter.capcity.th")+"\n"+intlmap.getTextDescription("reporter.common.%tile"));
							subHeadingsForMeasure.add(intlmap.getTextDescription("reporter.cpacity.Avg"));
							subHeadingsForMeasure.add(intlmap.getTextDescription("reporter.cpacity.Current"));
							jObj.put("subHeadingsForMeasure",subHeadingsForMeasure);
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Descriptor"));
							list_data.add(percentile+intlmap.getTextDescription("reporter.cpacity.th Percentile"));
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Avg"));
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Current"));
						}
						else
						{
							gridColumnCnt = gridColumnCnt+3;
							jObj.put("SUB_COLUMNS","4");
							JSONArray subHeadingsForMeasure =  new JSONArray();
							subHeadingsForMeasure.add(intlmap.getTextDescription("reporter.capcity.Descriptor"));
							subHeadingsForMeasure.add(percentile+intlmap.getTextDescription("reporter.capcity.th")+"\n"+intlmap.getTextDescription("reporter.common.%tile"));
							subHeadingsForMeasure.add(intlmap.getTextDescription("reporter.cpacity.Avg"));
							subHeadingsForMeasure.add(intlmap.getTextDescription("reporter.cpacity.Current"));
							jObj.put("subHeadingsForMeasure",subHeadingsForMeasure);
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Descriptor"));	list_data.add(percentile+intlmap.getTextDescription("reporter.cpacity.th Percentile"));
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Avg"));
							list_data.add(intlmap.getTextDescription("reporter.cpacity.Current"));
						}
						columnDetails.add(jObj);
					}
					if(selectedGroup.equals("Component"))
					{
						String[] selectedComps = request.getParameterValues("er_component");
						List componentList = Arrays.asList(selectedComps);
						v_component.clear();
						v_component.addAll(componentList);
					}
					String tdClass = "";
					for(int i = 0; i < v_component.size(); i++)
					{
						String compStr = (String)v_component.get(i);
						String component = "";
						String compType = "";
						
						 if(selectedGroup.equals("Component")) {
							 compType = compStr.substring(compStr.lastIndexOf(COLON)+1);
							 component = compStr.substring(0,compStr.indexOf(COLON));
						} else {
							 component = compStr.substring(compStr.indexOf(COLON)+1,compStr.lastIndexOf(COLON));
							 if(component.indexOf(COLON) != -1)
								 component = component.substring(0,component.indexOf(COLON));
							 compType = compStr.substring(0,compStr.indexOf(COLON));
						}
						
						compType = intlmap.getComponentTypeDescription(compType);
						boolean isInfosAvail = true;
						boolean initialFalg = true;
						boolean isSameComponent = true;
						
						int count = 0;
						String previousComp = "";
						int infoCount = 0;
						String strTemp = (String)resultMap.get(component+COLON+"rowSpan");

						Boolean valuesAvailable = (Boolean)resultMap.get(component);
						boolean isValuesAvailable = false;
						if(valuesAvailable != null)
							isValuesAvailable = valuesAvailable.booleanValue();
						if(!isValuesAvailable)
							continue;
						if(i == 0 && !tdClass.equalsIgnoreCase("tdborder")){
							tdClass = "tdborder";
						}else if( i % 2 ==  0 && !tdClass.equalsIgnoreCase("tdborder")){
							tdClass = "tdborder";
						}else if(!tdClass.equalsIgnoreCase("tdborder2")){
							tdClass = "tdborder2";
						} else {
							tdClass = "tdborder";
						}
						if(strTemp != null) {
							infoCount = Integer.parseInt(strTemp);
						}
						//for( int k=0; k<infoCount; k++)
						while(isInfosAvail)
						{
							if(count == 0)
							{
								list_data.add(component);
							}
							else
							{
								list_data.add("");
							}
							//added for csv ends

							int gridRowColCount = 1;

							JSONObject gridRow =  new JSONObject();
							gridRow.put("COLUMN_0",systemLbl+ " : " +component);
							String majorColor=reportInfo.getValue("SYSTEM_CAPACITY","Major");
							String criticalColor=reportInfo.getValue("SYSTEM_CAPACITY","Critical");
							for( int j=0; j<v_test.size(); j++)
							{
								String tempStr = (String)v_test.get(j);
								String tempTest = tempStr.substring(0,tempStr.indexOf(COLON));
								String tempMeasure = tempStr.substring(tempStr.indexOf(COLON)+1);
								String tempStrMax = "";
								String tempStrAvg = "";
								String tempStrCurrent = "";
								String temprhs = reportInfo.getValue("CAPACITY_PLANNING",tempTest+ COLON +tempMeasure);
								if(temprhs == null || temprhs.length() == 0){
									temprhs = "MAX";
								}
								if("MP".equalsIgnoreCase(temprhs)){
									temprhs = "MIN";
								}else{
									temprhs = "MAX";
								}
								
								tempMeasure = dbInfo.getColumnForMeasure(tempTest, tempMeasure);
								List infoList = null;
								infoList = (ArrayList)resultMap.get(component+COLON+tempTest);
								if(infoList == null) {
									infoList = new ArrayList();
								}
								String desc = "";
								if(infoList.size() > 0)
								{
									if(infoList.size() > count)
										desc = (String) infoList.get(count);
									else
										desc = "-";
								}
								else
								{
									infoList = null;
									desc = "-";
								}
								if(desc != null)
								{
									tempStrMax = (String)resultMap.get(component+COLON+tempTest+COLON+tempMeasure+"_"+temprhs+COLON+desc+COLON+"minmax");
									tempStrAvg = (String)resultMap.get(component+COLON+tempTest+COLON+tempMeasure+"_"+temprhs+COLON+desc+COLON+"avg");
									tempStrCurrent=(String)resultMap.get(component+COLON+tempTest+COLON+tempMeasure+"_"+temprhs+COLON+desc+COLON+"current");
                                    
								}
								
								if(desc == null)
									desc ="-";
								if(tempStrMax == null || tempStrMax.equals(""))
									tempStrMax= "-";

								if(tempStrAvg == null)
									tempStrAvg = "-";
								  if(tempStrCurrent==null)
									  tempStrCurrent="-";
								String color = "";
								double tempValue = 0;
								
								String tempCpuTest = cpuUtilization.substring(0,cpuUtilization.indexOf(COLON));
								String tempCpuMeasure = cpuUtilization.substring(cpuUtilization.indexOf(COLON)+1);
								tempCpuMeasure = dbInfo.getColumnForMeasure(tempCpuTest,tempCpuMeasure);
								
								String tempMemoryTest = freeMemoryAvailable.substring(0,freeMemoryAvailable.indexOf(COLON));
								String tempMemoryMeasure = freeMemoryAvailable.substring(freeMemoryAvailable.indexOf(COLON)+1);
								tempMemoryMeasure = dbInfo.getColumnForMeasure(tempMemoryTest,tempMemoryMeasure);
								
								String tempDiskspacetest = diskspaceUsage.substring(0,diskspaceUsage.indexOf(COLON));
								String tempDiskspaceMeasure = diskspaceUsage.substring(diskspaceUsage.indexOf(COLON)+1);
								tempDiskspaceMeasure = dbInfo.getColumnForMeasure(tempDiskspacetest,tempDiskspaceMeasure);

								String tempNetworkTest = networkAvailability.substring(0,networkAvailability.indexOf(COLON));
								String tempNetworkMeasure = networkAvailability.substring(networkAvailability.indexOf(COLON)+1);
								tempNetworkMeasure = dbInfo.getColumnForMeasure(tempNetworkTest,tempNetworkMeasure);

								String tempDiskActivityTest = diskBusy.substring(0,diskBusy.indexOf(COLON));
								String tempDiskActivityMeasure = diskBusy.substring(diskBusy.indexOf(COLON)+1);
								tempDiskActivityMeasure = dbInfo.getColumnForMeasure(tempDiskActivityTest,tempDiskActivityMeasure);
								if(!tempStrMax.equals("-"))
								{
									tempValue = Double.valueOf(tempStrMax).doubleValue();
								}
								
								if(tempTest.equalsIgnoreCase(tempCpuTest) && tempMeasure.equalsIgnoreCase(tempCpuMeasure) && !tempStrMax.equals("-"))
								{
									double cpuUtilMin = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Major")).doubleValue();
									double cpuUtilMax = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Critical")).doubleValue();
									if(measure1_Check.equalsIgnoreCase(greaterThan))
									{
										if( tempValue > cpuUtilMax )
											color = criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if( tempValue > cpuUtilMin )
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
									else
									{
										if( tempValue < cpuUtilMin )
											color = criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if( tempValue < cpuUtilMax )
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
								}
								else if(tempTest.equalsIgnoreCase(tempMemoryTest) && tempMeasure.equalsIgnoreCase(tempMemoryMeasure) && !tempStrMax.equals("-"))
								{

									double memoryMin = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Major")).doubleValue();
									double memoryMax = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Critical")).doubleValue();
									if(measure2_Check.equalsIgnoreCase(greaterThan))
									{
										if( tempValue > memoryMax )
											color = criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue > memoryMin )
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
									else
									{
										if( tempValue < memoryMin )
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue < memoryMax )
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}

								}
								else if(tempTest.equalsIgnoreCase(tempDiskspacetest) && tempMeasure.equalsIgnoreCase(tempDiskspaceMeasure) && !tempStrMax.equals("-"))
								{
									double diskspaceMin = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Major")).doubleValue();
									double diskspaceMax = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Critical")).doubleValue();
									if(measure3_Check.equalsIgnoreCase(greaterThan))
									{
										if( tempValue > diskspaceMax )
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue > diskspaceMin )
											color =majorColor;// "MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
									else
									{
										if( tempValue < diskspaceMin )
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue < diskspaceMax )
											color =majorColor;// "MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
								}
								else if(tempTest.equalsIgnoreCase(tempNetworkTest) && tempMeasure.equalsIgnoreCase(tempNetworkMeasure) && !tempStrMax.equals("-"))
								{
									double networkMin = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Major")).doubleValue();
									double networkMax = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Critical")).doubleValue();
									if(measure5_Check.equalsIgnoreCase(greaterThan))
									{
										if( tempValue > networkMax )
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue > networkMin)
											color =majorColor;// "MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
									else
									{
										if( tempValue < networkMin)
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue < networkMax)
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
								}
								else if(tempTest.equalsIgnoreCase(tempDiskActivityTest) && tempMeasure.equalsIgnoreCase(tempDiskActivityMeasure) && !tempStrMax.equals("-"))
								{
									double diskActivityMin = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Major")).doubleValue();
									double diskActivityMax = Double.valueOf(reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Critical")).doubleValue();
									if(measure4_Check.equalsIgnoreCase(greaterThan))
									{
										if( tempValue > diskActivityMax )
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue > diskActivityMin)
											color = majorColor;//"MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
									else
									{
										if( tempValue < diskActivityMin)
											color =criticalColor;//"HighBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Critical");
										else if(tempValue < diskActivityMax)
											color =majorColor;// "MediumBgCls";//reportInfo.getValue("SYSTEM_CAPACITY","Major");
									}
								}

								if(desc.length() > 0)
									desc = desc.substring(desc.indexOf("+")+1);
								if(desc.equals(""))
									desc = "-";
								String tempDesc = reportInfo.getValue("SYSTEM_CAPACITY","RemoveDescriptor");
								String removeTest = tempDesc.substring(0,tempDesc.indexOf(COLON));
								String removeMeasure = tempDesc.substring(tempDesc.indexOf(COLON)+1 , tempDesc.lastIndexOf(COLON));
								String removeDesc = tempDesc.substring(tempDesc.lastIndexOf(COLON)+1);
								if(tempTest.equalsIgnoreCase(removeTest)&& tempMeasure.equalsIgnoreCase(removeMeasure)&& desc.equalsIgnoreCase(removeDesc))
								{
									int colIdx1 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx1,"-");

									int colIdx2 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx2,"-");

									int colIdx3 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx3,"-");
									
									//added for csv starts
									list_data.add(dbInfo.formatValue("-"));
									list_data.add(dbInfo.formatValue("-"));
									list_data.add(dbInfo.formatValue("-"));
									//added for csv ends
									continue;
								}
								Boolean tempVal = (Boolean)infoTable.get(tempTest);
								descriptorAvail = tempVal.booleanValue();
								if((isSummaryOnly && tempTest.equalsIgnoreCase(systemTest)) || !descriptorAvail)
								{
									if(StringUtils.isNull(color))
										color ="-";

									int colIdx1 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx1,dbInfo.formatValue(tempStrMax));
									gridRow.put("COLUMN_Color"+colIdx1,color);

									int colIdx2 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx2,dbInfo.formatValue(tempStrAvg));

									int colIdx3 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx3,tempStrCurrent);

									//added for csv starts
									list_data.add("-");
									list_data.add(dbInfo.formatValue(tempStrMax));
									list_data.add(dbInfo.formatValue(tempStrAvg));
									list_data.add(tempStrCurrent);//For Current Value
									//added for csv ends
								}
								else
								{
									if(StringUtils.isNull(color))
										color ="-";

									int colIdx = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx,desc);

									int colIdx1 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx1,dbInfo.formatValue(tempStrMax));
									gridRow.put("COLUMN_Color"+colIdx1,color);

									int colIdx2 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx2,dbInfo.formatValue(tempStrAvg));
									int colIdx3 = gridRowColCount++;
									gridRow.put("COLUMN_"+colIdx3,tempStrCurrent);
									
									//added for csv starts
									list_data.add(desc);
									list_data.add(dbInfo.formatValue(tempStrMax));
									list_data.add(dbInfo.formatValue(tempStrAvg));
									   if(tempStrCurrent==null)tempStrCurrent="-";
									list_data.add(tempStrCurrent); //For Current Value
									//added for csv ends
								}
								if(infoList == null )
								{
									List tempInfoList = (ArrayList)resultMap.get(component+COLON+cpuUtilTest);
									if(tempInfoList == null)
									{
										tempInfoList =(ArrayList)resultMap.get(component+COLON+memoryTest);
										if(tempInfoList == null)
										{
											tempInfoList = (ArrayList)resultMap.get(component+COLON+diskspaceTest);
											if(tempInfoList == null)
											{
												tempInfoList = (ArrayList)resultMap.get(component+COLON+networkTest);
												if(tempInfoList == null)
													isInfosAvail = false;
											}
										}
									}
								}
								else if(count == infoCount-1)
								{
									isInfosAvail = false;
											
								}
							}// test loop
							count ++;
							//isSameComponent = false;
							gridData.add(gridRow);
						}// isinfo loop
					}// component loop

					// added for csv 
					h_tabrc.put(v_measure_csv,list_data);
					h_tab.put(s_title,h_tabrc);
					list.add(h_tab);
					list_data.add("\n");
					v_measure_csv = new Vector();
					list_data = new LinkedList();
					h_tabrc = new Hashtable();
					h_tab = new Hashtable();

					//json.put("gridData",gridData);
					//json.put("gridSubHeaders",gridSubHeaders);

					JSONObject gridObj = new JSONObject();
					gridObj.put("gridData",gridData);
					gridObj.put("COLUMNS",columnDetails);
					gridObj.put("gridColumnCnt",String.valueOf((gridColumnCnt-1)));
					gridObj.put("GRID_TITLE",intlmap.getTextDescription("reporter.common.System Capacity Report")+" "+heading);

					json.put("gridObj",gridObj);
					
					//added for csv Ends
					String majorColor = reportInfo.getValue("SYSTEM_CAPACITY","Major");
					String criticalColor = reportInfo.getValue("SYSTEM_CAPACITY","Critical");
					String legendTextMajor = reportInfo.getValue("SYSTEM_CAPACITY","LegendTextMajor");
					String legendTextCritical = reportInfo.getValue("SYSTEM_CAPACITY","LegendTextCritical");
					// added fro csv
					v_measure_csv.add("Measurements");
					v_measure_csv.add("Major / "+legendTextMajor);
					v_measure_csv.add("Critical / "+legendTextCritical);

					screenLabels.put("reporter.common.Measurements",intlmap.getTextDescription("reporter.common.Measurements"));
					screenLabels.put("reporter.capacity.Major",intlmap.getTextDescription("reporter.capacity.Major /")+" "+legendTextMajor);
					screenLabels.put("reporter.capacity.Critical",intlmap.getTextDescription("reporter.capacity.Critical")+" "+legendTextCritical);

					JSONArray measThreshDataArr =  new JSONArray();
					JSONObject measThreshData =  new JSONObject();

					measThreshData.put("measure",measure1_Title);
					measThreshData.put("major",measure1_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Major")+" "+cpuUtilMeasureUnit);
					measThreshData.put("critical",measure1_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Critical")+" "+cpuUtilMeasureUnit);

					measThreshDataArr.add(measThreshData);

					list_data.add(measure1_Title);
					list_data.add(measure1_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Major")+" "+cpuUtilMeasureUnit);
					list_data.add(measure1_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure1_Critical")+" "+cpuUtilMeasureUnit);

					measThreshData =  new JSONObject();
					measThreshData.put("measure",measure2_Title);
					measThreshData.put("major",measure2_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Major")+" "+memoryMeasureUnit);
					measThreshData.put("critical",measure2_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Critical")+" "+memoryMeasureUnit);

					measThreshDataArr.add(measThreshData);
										
					list_data.add(measure2_Title);
					list_data.add(measure2_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Major")+" "+memoryMeasureUnit);
					list_data.add(measure2_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure2_Major")+" "+memoryMeasureUnit);

					measThreshData =  new JSONObject();
					measThreshData.put("measure",measure3_Title);
					measThreshData.put("major",measure3_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Major")+" "+memoryMeasureUnit);
					measThreshData.put("critical",measure3_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Critical")+" "+memoryMeasureUnit);

					measThreshDataArr.add(measThreshData);
										
					list_data.add(measure3_Title);
					list_data.add(measure3_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Major")+" "+diskspaceMeasureUnit);
					list_data.add(measure3_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure3_Critical")+" "+diskspaceMeasureUnit);


					measThreshData =  new JSONObject();
					measThreshData.put("measure",measure4_Title);
					measThreshData.put("major",measure4_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Major")+" "+memoryMeasureUnit);
					measThreshData.put("critical",measure4_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Critical")+" "+memoryMeasureUnit);

					measThreshDataArr.add(measThreshData);
					list_data.add(measure4_Title);
					list_data.add(measure4_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Major")+" "+diskActivityMeasureUnit);
					list_data.add(measure4_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure4_Critical")+" "+diskActivityMeasureUnit);

					measThreshData =  new JSONObject();
					measThreshData.put("measure",measure5_Title);
					measThreshData.put("major",measure5_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Major")+" "+memoryMeasureUnit);
					measThreshData.put("critical",measure5_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Critical")+" "+memoryMeasureUnit);

					measThreshDataArr.add(measThreshData);
					list_data.add(measure5_Title);
					list_data.add(measure5_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Major")+" "+networkMeasureUnit);
					list_data.add(measure5_Check+" "+reportInfo.getValue("SYSTEM_CAPACITY","Measure5_Critical")+" "+networkMeasureUnit);

					json.put("measThreshDataArr",measThreshDataArr);
				}// no data found false
				else
				{
					json.put("dataAvailable","false");
					screenLabels.put("errorMsg",intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
				}
			}// submit block
			// added for csv starts
			h_tabrc.put(v_measure_csv,list_data);
			h_tab.put(s_title,h_tabrc);
			list.add(h_tab);
			list_data.add("\n");
			v_measure_csv = new Vector();
			list_data = new LinkedList();
			h_tabrc = new Hashtable();
			h_tab = new Hashtable();
			if(list!= null && !list.isEmpty())
			{
				session.setAttribute("list",list);
			}
			//added for csv ends
		}// for foreground report
		//for mail starts
		
		json.put("hiddenParams",hiddenParams);
		json.put("screenLabels",screenLabels);
		json.put("pageParams",pageParams);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(json.toString());
		String strEncodeer_timeline = er_timeline;
		if(er_timeline != null)
			strEncodeer_timeline = com.eg.EgURLEncoder.encode(er_timeline,UTF_8);
		s_st_time  = request.getParameter("startdate");
		s_en_time  = request.getParameter("enddate");
		if(s_st_time != null && s_en_time != null && s_inidate != null)
		{
			s_st_time = com.eg.EgURLEncoder.encode(s_st_time,UTF_8);
			s_en_time = com.eg.EgURLEncoder.encode(s_en_time,UTF_8);
			s_inidate = com.eg.EgURLEncoder.encode(s_inidate,UTF_8);
		}
		String dataProcess = mngrIProc+"/final/reporter/ErSystemCapacityReportPrint.jsp;jsessionid="+ session.getId()+"?select_group="+selectedGroup+"&er_comptype="+s_comptype+"&er_site="+s_site+"&startdate="+s_st_time+"&enddate="+s_en_time+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&er_timeline="+strEncodeer_timeline+"&startmin="+startMin+"&endmin="+endMin+"&inidate="+s_inidate+"&pageWidthProces=400";
		if(selectedCompArray != null)
		{
			//for(int j=0; j<selectedCompArray.length; j++)
			{
				//dataProcess += "&er_component=" + com.eg.EgURLEncoder.encode(selectedCompArray[j],UTF_8);
			}
		}
		session.setAttribute("MAIL_URL",dataProcess);
	}
	//for mail ends
	// for redirecting same page in reporter Starts
	queryString=(String)ErUtils.prepareQueryString(request.getParameterMap());
	String qString="";
	String qStringBackUrl = "";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);
			String value = parameter.substring(ind+1);
			if(reqparam!=null) {
				if(reqparam.equals("er_site"))
				{
					value=com.eg.EgURLEncoder.encode(value, UTF_8);
				} else if(reqparam.equals("startdate"))
				{
					value=com.eg.EgURLEncoder.encode(value, UTF_8);
				} else if(reqparam.equals("enddate"))
				{
					value=com.eg.EgURLEncoder.encode(value, UTF_8);
				} else if(reqparam.equals("inidate"))
				{
					value=com.eg.EgURLEncoder.encode(value, UTF_8);
				}
				qString += reqparam+"="+value+"&";
			}
		}
		if(request.getParameter("isSubmit")!=null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErSystemCapacityReport.jsp?isSubmit=true&"+ qString);
		}
		else 
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErSystemCapacityReport.jsp?" + qString);
		}
	}// redirecting reporter same page ends
}
catch(Throwable t)
{
	t.printStackTrace();
}
	//Back Button - Start
	ArrayList listbackvar = new  ArrayList();
	if(request.getParameter("isSubmit")!=null)
	{
		listbackvar.add("ErSystemCapacityReport.jsp?");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else 
	{
		listbackvar.add("ErSystemCapacityReport.jsp");
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	//Back Button - End

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
