package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import egurkha.reporter.*;
import java.util.*;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import com.eg.ErDbServer;
import egurkha.*;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.egurkha.ini.*;
import com.eg.EgDateInfo;
import com.eg.EgTopoInfo;
import com.eg.EgGroupInfo;
import com.eg.EgReportInfo;
import com.egurkha.*;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import java.net.*;
import com.eg.EgThresholdInfo;
import com.eg.EgTablesInfo;
import com.eg.EgMappingInfo;
import java.net.URLEncoder;
import java.net.URLDecoder;
import com.eg.EgURLEncoder;
import com.egurkha.util.DateTimeTokenizer;
import com.egurkha.util.DateUtil;
import com.egurkha.util.StringUtils;
import com.eg.MappingNameSorter;
import com.eg.EgName;
import java.text.*;
import com.eg.EgConfigInfo;
import net.sf.json.*;
import java.util.*;
import java.text.*;
import com.eg.EgReportInfo;
import com.eg.EgDateInfo;
import com.egurkha.util.*;

public final class ErRumReportJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

 
	public JSONArray getLastCalenJson(List weekList) {
		JSONArray tmpJsonArr=new JSONArray();
		JSONObject timelineJSON = new JSONObject();	
		String tmpTimeLine = null;
		String viewField=null;			
		for(int x=0;x<weekList.size();x++){
			tmpTimeLine = (String)weekList.get(x);	
			int spaceCount = 0;	
			for(int y=0; y<tmpTimeLine.length();y++){				
				char ch = tmpTimeLine.charAt(y);
				if(ch== ' '){
				   spaceCount++; 
				}
			}
			if(spaceCount > 1){
				//Last 2 weeks    weeks_last 2
				String countStr = tmpTimeLine.substring(tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = tmpTimeLine.substring(tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.length());
				String last = tmpTimeLine.substring(0, tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr +" "+ end + "_" + last;				
			}else{
				viewField = "1 "+tmpTimeLine.substring(tmpTimeLine.lastIndexOf(" ")+1, tmpTimeLine.length())  + "_" + tmpTimeLine.substring(0, tmpTimeLine.indexOf(" "));				
			}			
			timelineJSON.put("displayField",tmpTimeLine);
			timelineJSON.put("valueField", viewField.toLowerCase());
			tmpJsonArr.add( timelineJSON );		
		}		
		return tmpJsonArr;
   } 


	public List<String> getLastWeekMonthList(String currentDateFormat, User user, String timeLine, boolean isZoneType){
		EgDateInfo egDt = new EgDateInfo();
		List<String> lastWeekList = new ArrayList<String>();
		String startDate = null;
		String endDate = null;
		int count = Integer.parseInt(timeLine.substring(0, timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)));
		String unit = timeLine.substring(timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,timeLine.length());
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		java.util.Date today = egDt.egetRealDate();
		String currentDateTime = sdf.format(today);
		String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
		String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
		String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1,currentDateTime.lastIndexOf(":"));
		String time = " "+currentHr+":"+currentMin;
		String curFormatDate  = DateUtil.changeDateFormat(currentDate, "MM/dd/yyyy", currentDateFormat);		
		String userFormat = user.getUserDateFormat();
		try{
			java.util.Date realDate = null;
			if(!isZoneType){
				EgTimeZoneConverter tmZoneConverter = new EgTimeZoneConverter(curFormatDate+time,user);				
				realDate = new SimpleDateFormat(userFormat).parse(tmZoneConverter.getDateTime());
				sdf = new SimpleDateFormat(userFormat);
			}else{
				realDate = new SimpleDateFormat(userFormat).parse(curFormatDate);
			}
					
			Calendar c = Calendar.getInstance();
			c.setTime(realDate);
			if(unit.startsWith("we")){
				int weekCount = count;
				int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
				int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
				int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
				c.add(Calendar.DATE, - i - startDayCount);
				startDate = sdf.format(c.getTime());
				c.add(Calendar.DATE, lastDayCount);	
				endDate = sdf.format(c.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));					
				}															
			}else if(unit.startsWith("mo")){
				int monthCount = count;
				c.add(Calendar.MONTH, -monthCount);
				c.set(Calendar.DATE, 1);
				startDate = sdf.format(c.getTime());				
				
				Calendar c1 = Calendar.getInstance();
				c1.setTime(realDate);
				c1.add(Calendar.MONTH, -1);
				c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
				endDate = sdf.format(c1.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));	
				}
			}else{}
			lastWeekList.add(startDate);
			lastWeekList.add(endDate);
		}catch(Exception e){
			e.printStackTrace();
		}
		return lastWeekList;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/reporter/ErReporterTracker.jsp");
    _jspx_dependants.add("/reporter/ErTimeFormatJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/************************************************************************************************
* File				: ErRumReportJson.jsp
* Purpose			:	Displays the configured measures and its details for the RUM Reorts
* Creation Date	:	26/11/2014
*
*************************************************************************************************/


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String reporter_Skin = null;

	boolean id_u = false;
	boolean isLastTimeLine = false;
	String urs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	UserRegistry registry= null;
	User thisuser=null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	String usr_Id_proc = request.getParameter("er_userid");
	String usr_Id = request.getParameter("eruserid");
	String userID = request.getParameter("userID");
	if(session!=null)
	{
		 UBean = (ErUserData) session.getAttribute("UBean");
		 if(throughSchedule.equalsIgnoreCase("true")) {
			 try
			 {
			if(UBean == null) {
				if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id,false);
					usr_Id_proc = usr_Id;
				}
				else if(userID != null){
					UBean = new ErUserData(userID,false);
					usr_Id_proc = userID;
				}
				else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id_proc,false);
				}
				else{
					UBean = new ErUserData(usr_Id_proc,false);
				}

			}
			}
			catch(Throwable t)
			{
			t.printStackTrace();
			}
		}
		if(UBean != null)
		{
			registry = UserRegistry.getInstance();
			thisuser= registry.getUser(session.getId(),true);
			if(thisuser!=null)
			{
				id_u = thisuser.isIdDeletedWhileLoggedIn();
				if(id_u==false )
				{
					urs = thisuser.getLoginID();
					if(!User.isDefaultUser(urs))
					{
						u_v_till = UBean.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
			if(thisuser == null && usr_Id_proc!= null ) {
				try {
					thisuser = UBean.getUser(usr_Id_proc);
					registry.setUser(session.getId(), thisuser, false);
					System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
				} catch(Exception ex) {
					System.out.println("Setting user object failed");
					ex.printStackTrace();
				}
			}
		}
	}
	if(session == null || thisuser == null)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");		
	}
	else if(id_u== true)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}

	if(session!=null && UBean != null && thisuser!=null)
	{
		//session.putValue("Page_IdentifierR",request.getRequestURI());	
		String pageName = request.getRequestURI();
		if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
		{
			//session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
		}
	}
	

	if (thisuser!=null)
	{
		String trackerUserLang = thisuser.getLanguage();
		thisuser.setUserLanguageAndSkins();
		reporter_Skin  = thisuser.getReporterSkin();

		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	//Added by Sakthivel - 26/03/2008
	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
	//Variable to be used in javascript code
	String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(thisuser!=null)
	{
		currentDateFormatForJS = thisuser.getUserDateFormat();
	}
	String strUserDateFormat =currentDateFormatForJS;
	if(currentDateFormatForJS.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormatForJS.length();i++)
		{
			if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
			{
				currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
			}
		}
	}
	egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
	String strArray[] =erbgreport.getSelection(urs);
	String strforeground = strArray[0];
	String strbackground =  strArray[1];
	String bgString="'";


	
	String titleToDisplay=request.getParameter("er_RmDispName");					

	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabelJson = new JSONObject();
	JSONObject hiddenfieldsJson=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();
	boolean isEnglishLanguage=false;
	if(trackerLanguage!=null && trackerLanguage.equals("en_US"))
	{
		isEnglishLanguage=true;
	}

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	
		

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	String backButtonEnable = request.getParameter("back");
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("htdata",null);
		request.setAttribute("app_topusers",null);
		request.setAttribute("appChartData",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	String componenttest = request.getParameter("componenttest");
	
	String isreportsneedService = request.getParameter("isreportsneedService");
	//Back Button - End

try
{
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	
	String s_tit1= "";
	Hashtable ht1 = new Hashtable();
	List lst_dat1 = new LinkedList();
	Hashtable sen1 = new Hashtable();
	Vector vec1 = new Vector();
	List lst_dat2 = new LinkedList();
	Vector v_val1 = new Vector();
	List lst = new LinkedList();

	IniUI ui = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;
	String variable;
	String s_QSGraph="";
	StringTokenizer st;

	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	MappingNameSorter sorter = new MappingNameSorter(thisuser.getLanguage());
	ErUtils erUtils = new ErUtils();
	ErInfo erInfo = new ErInfo();
	EgReportInfo reportInfo=new EgReportInfo("manager");
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	EgThresholdInfo hreshholdInfo = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	String s_user = request.getParameter("er_user");
	String strGraphViewType = request.getParameter("graphViewtype");
	String strSelectedCompType = request.getParameter("er_comptype");
	String ConstantDispNameDisp=(String)reportInfo.getValue("RUM_REPOTRS","ConstantDispName");
	String ConstantDispName="--"+ConstantDispNameDisp+"--";

	Hashtable htt=new Hashtable();
	Vector titleVc=new Vector();
	Vector select_farms=new Vector();
	htt=(Hashtable)request.getAttribute("htdata");
	
	titleVc=(Vector)request.getAttribute("titleToDisplay");
	select_farms=(Vector)request.getAttribute("select_farms");
	
	
	session.setAttribute("htdata",htt);
	Vector v_components = UBean.getAllUserComponents(3);
	Vector v_component = new Vector();
	Vector v_temp = new Vector();
	Vector defComps = new Vector();
	Vector colZoneComps = new Vector();
	Vector v_comptype=new Vector();
	ArrayList aListCompType = new ArrayList();
	Vector v_infos=null;
	Vector v_application=new Vector();
	String installDir = EgInstallInfo.getInstallDir();
	IniFile inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	String sub = "MISC";
	String var = "CtxServer";
	String values = inifile.getValue(sub,var);
	String val="";
	String s_component = "";
	String s_qryString	="";
	String timeline =request.getParameter("er_timeline");
	String testmes = request.getParameter("select_testmes");
	String rtype =request.getParameter("er_type");
	String show_timeinuse = request.getParameter("sh_timeinuse");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String schedule_id = request.getParameter("schedule_id");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");
	String divStatus = request.getParameter("divStatus");
	String searchUser = request.getParameter("er_tapplication");
	String er_rep = request.getParameter("er_rep");
	String rep_title = request.getParameter("er_rep");
	
	if(rep_title==null)
		rep_title=intlmap.getTextDescription("reporter.application.RUM Report");
		else
		rep_title="RUM Report";
	String srcForImg="";
	if(er_rep==null)
			er_rep="User";
	if(divStatus==null)
	{
	divStatus="none";
	}
	if(divStatus.equals("none"))
	{
		srcForImg="/final/images/moreoption.png";
	}
	else if(divStatus.equals("block"))
	{
		srcForImg="/final/images/lessoption.png";
	}
	ArrayList aListSupportedComponentType = reportInfo.getComponentsList("RUM_REPOTRS",false);
	ArrayList aListAlltype = new ArrayList();

	for(int kk=0;kk<aListSupportedComponentType.size();kk++)
	{
		aListAlltype.add("All "+aListSupportedComponentType.get(kk));
	}

	if (rtype==null)
	{
		rtype="Yes";
	}
	boolean termpresent=false;
	Vector v_testmes = new Vector();

	
	int maxInfo = (int) Integer.parseInt((String) reportInfo.getValue("RUM_REPOTRS","ShowTop"));
	

	Vector v_show=new Vector();
	v_show.add("TOP  - " +maxInfo/4);
	v_show.add("TOP  - " +maxInfo/2);
	v_show.add("TOP  - " +maxInfo);
	v_show.add("ALL");	
	String priority=request.getParameter("er_priority");
	if(priority==null || priority.equals(""))
		priority="TOP  - " +maxInfo;


	Hashtable ht_data = (Hashtable)request.getAttribute("Report_data");
	Vector app_data = (Vector)request.getAttribute("App_data");
	session.setAttribute("App_data",app_data);
	
	ArrayList app_topusers = (ArrayList)request.getAttribute("app_topusers");
	Vector v_qry_string = (Vector)request.getAttribute("appChartData");
	Vector pdfQuery = (Vector)request.getAttribute("appPdfData");
	String backQS = (String)session.getAttribute("topBackQuery");
	String backQSserver = (String)session.getAttribute("topBackQuery_server");
	
	session.setAttribute("ApplicationReport",app_data);
	session.setAttribute("appForPrint",app_topusers);
	session.removeAttribute("topBackQuery");
	session.removeAttribute("backQSserver");

	HashMap Report_data=null;
	Hashtable h_data = new Hashtable();
	Hashtable h_rep = new Hashtable();
	Vector v_data1 = new Vector();
	Vector  v_add = new Vector();
	Vector v_sort=new Vector();

	ArrayList subjects = (ArrayList)reportInfo.getVariables("RUM_REPOTRS");
	String numTopUsers = reportInfo.getTop("RUM_REPOTRS");

	String s_variable="";
	StringTokenizer tok1=null;
	String type="";
	String mes="";
	
	String s_sort=request.getParameter("er_sortby");
	String s_uisort=request.getParameter("er_uisortby");
	String tbound = request.getParameter("er_tbound");
	String cTime = request.getParameter("currTime");
	String s_application1 = request.getParameter("er_application1");

	String key="";
	ErReqData erd = new ErReqData(request);
	EgDateInfo egDate = new EgDateInfo();
	String stdate="";
	String enddate="";
	String sthr="";
	String endhr="";
	String sthr1 = "";
	String endhr1 = "";
	long msecsPerHour = (long) 1000 * 60 * 60;

	fromTime = reportInfo.getTimeFrame("RUM_REPOTRS","FROM");
	toTime = reportInfo.getTimeFrame("RUM_REPOTRS","TO");

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}
	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}

	String Days = reportInfo.getExcludeWeekend("RUM_REPOTRS");
	Vector v_time=new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min=new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;

	String value1 = inifile.getValue(sub,var);
	sub ="LIST_OF_ZONES";
	inifile = new IniFile(installDir +"/manager/config/eg_group.ini");
	String vari[] = inifile.getVariables(sub);
	for(int i=0;i<vari.length;i++)
	{
		variable = vari[i];
		v_component.add(variable);
	}

	String s_farmserver = request.getParameter("select_farm");
	String s_farmserverAr[] = (String[])request.getParameterValues("select_farm");
	ArrayList s_farmServerAL=new ArrayList();
	if(s_farmserverAr!=null)
	{
		for(int i=0;i<s_farmserverAr.length;i++)
		{
			s_farmServerAL.add((String)s_farmserverAr[i]);
		}
	}
	
	String s_application = request.getParameter("er_application");
	String s_server = request.getParameter("er_server");
	String serverForSorting=null;
	String strzoneCheck = "";
	String strServercheck = "";
	String s_perserver=request.getParameter("er_perserver");
	if (s_perserver==null || s_perserver.equals(""))
		s_perserver="Yes";

	
	String strEncodeServer = s_server;
	
	if(strEncodeServer!=null)
		strEncodeServer = EgURLEncoder.encode(strEncodeServer,"UTF-8");

	String sortRowDisplaySatus = "table-row";
	String sortRowDisplaySatus_1 = "none";


	if(s_application!=null && !s_application.equals("-1") && !s_application.equalsIgnoreCase("Not Applicable"))
	{
		sortRowDisplaySatus = "none";
		sortRowDisplaySatus_1 = "block";
	}
	if(s_server !=null && s_server.equals("-1"))
	{
		sortRowDisplaySatus = "none";
		sortRowDisplaySatus_1 = "block";
	}

	EgGroupInfo gpinfo = new EgGroupInfo();
	String tmpComponent="";
	Vector v_comp=UBean.getAllUserComponents(3);
	String sub1 = "MISC";
	String var1 = "CtxServer";
	Vector v_server=new Vector();
	boolean present=false;
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	String loginid = this_user.getLoginID();
	Vector dispzone=new Vector();
	
	if(s_farmServerAL.size()==0)
	{
		s_farmServerAL.add((String)ConstantDispName);
		s_farmserver=ConstantDispName;
	}
	String er_option="Service";
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	Hashtable htAllGroups =new Hashtable();
	if(er_option!=null && (er_option.equalsIgnoreCase("Segment")||er_option.equalsIgnoreCase("Service")||er_option.equalsIgnoreCase("Zone")))
	{
		htAllGroups = erEsxUtils.getGroups(null, aListSupportedComponentType, thisuser, loginid, "Yes",true);
	}
	List v_site = new ArrayList();
	if(er_option!=null)
	{
		List aListComponentTemp=null;
		v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
		
		if(v_site!=null)
		{
			Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);		
			dispzone.addAll(v_site);
		}
		if((s_farmserver==null && v_site!=null && v_site.size()>0) || (s_farmserver!=null && v_site!=null && (!v_site.contains(s_farmserver)  && !s_farmserver.equalsIgnoreCase(ConstantDispName)) && v_site!=null && v_site.size()>0))
		{
			s_farmserver=(String)v_site.get(0);
		}
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,s_farmserver);
		 
		
		if(s_farmserver.equalsIgnoreCase(ConstantDispName))
		{
			if(aListComponentTemp==null && v_components!=null && v_components.size()>0)
			{
				Vector v_componentsDummy=new Vector();
				for(int i=0;i<v_components.size();i++)
				{
					String compVal=(String) v_components.get(i);
					String compType=compVal.substring(compVal.lastIndexOf(":")+1);
					if(aListSupportedComponentType.contains(compType))
					{
						v_componentsDummy.add(compVal);
					}
				}
				aListCompType.addAll(aListSupportedComponentType);
				v_components=v_componentsDummy;
			}
			if(v_site!=null && v_site.size()>0)
			{
				Vector removeCmps=new Vector();
				for(int i=0;i<v_site.size();i++)
				{
					String siteVal=(String) v_site.get(i);
					removeCmps.addAll(erEsxUtils.getComponentForGroup(htAllGroups,er_option,siteVal));
				}
				v_components.removeAll(removeCmps);
			}
		}
		
		if(aListComponentTemp!=null && aListComponentTemp.size()>0)
		{
			v_components = new Vector();
			v_components.addAll(aListComponentTemp);
		}
		
		if(aListComponentTemp!=null && aListComponentTemp.size()>0)
		{
			aListCompType = new ArrayList();
			for(int i=0; i<aListComponentTemp.size(); i++) 
			{
				String loopComponent = (String) aListComponentTemp.get(i);
				if(loopComponent.lastIndexOf(":")>-1){
					String loopComp = loopComponent.substring(0,loopComponent.lastIndexOf(":"));
					String  loopType = loopComponent.substring(loopComponent.lastIndexOf(":")+1);

						if(aListCompType!=null && !aListCompType.contains(loopType))
							aListCompType.add(loopType);											
				}
			}
		}		
		
		if(strSelectedCompType == null || strSelectedCompType.equals("")  || strSelectedCompType.equals("-1"))
		{
			if(aListCompType!=null && aListCompType.size()>0){
				ArrayList sortedNameList1 = new ArrayList();
				sortedNameList1 = sorter.getSortedCompTypeList(aListCompType);
				EgName obj_name1 = (EgName) sortedNameList1.get(0); 
				strSelectedCompType = obj_name1.getActualName();
			}
		}	
	}	
	int v_componentSize=v_components.size();
	boolean allServerPresent=false;
	Hashtable htComponentcount = new Hashtable();
	Vector vecAll = new Vector();
	if(v_components!=null )
	{
		for(int m=0;m< v_components.size();m++)
		{
			String tempcomp=(String)v_components.get(m);
			StringTokenizer t_token= new StringTokenizer(tempcomp,":");
			while(t_token.hasMoreTokens())
			{
				String tempcomptype=t_token.nextToken();
				if(strSelectedCompType!=null && strSelectedCompType.equalsIgnoreCase(tempcomptype))
				{
					vecAll.add(tempcomp);					
				}
			}
		}
	}
	v_components=vecAll;
	
Collections.sort(v_components,String.CASE_INSENSITIVE_ORDER);
	
	if(v_components !=null && v_components.size()>0)
	{	
		if((s_server==null || s_server.equals("undefined")) && v_components!=null && v_components.size()>0)
			s_server=(String)v_components.get(0);
		if(vecAll.size()>1)
			allServerPresent=true;
	}
	if((strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline")) ||
		(rtype!=null && rtype.equals("No") && !v_components.contains(s_server)))
		s_server = "-1";
	if(s_server!=null && (s_server.equalsIgnoreCase("All") || s_server.equalsIgnoreCase("-1")) && v_components!=null && v_components.size()>0) 
		s_server=(String) v_components.get(0);
	
	String vCompServValue=s_server;
	
	if(vCompServValue!=null)
	{
		v_application=new Vector();
		Vector v_app=new Vector();
		String serverCC=(String) vCompServValue;		
		String strTempComponentType1 = serverCC.substring(serverCC.lastIndexOf(":")+1);			
		String strTest = reportInfo.getTestName("RUM_REPOTRS",strTempComponentType1,false);
		if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
		{
			strTest=componenttest;
		}
		if(reportInfo.isVmComponent(serverCC))
		{
			v_app.addAll(reportInfo.getUserNameAlonefromVM(strTest,serverCC));
		}
		else{
			if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
			{
				for(int i=0;i<s_farmServerAL.size();i++)
				{
					v_app.addAll(erInfo.getInfosForTest("NULL",strTest,serverCC));
				}
			}else
				v_app.addAll(erInfo.getInfosForTest("NULL",strTest,serverCC));
		}
		v_app.remove("+#~#~#");
		v_app = ErUtils.formatString(v_app,"$0+$1","$1");
	
		for (int m=0;m<v_app.size();m++)
		{
			String app=(String)v_app.get(m);
			if (!v_application.contains(app))
				v_application.add(app);
		}
	}	
	Collections.sort(v_application,String.CASE_INSENSITIVE_ORDER);
	serverForSorting=s_server;	
	for(int m=0;m<subjects.size();m++)
	{
		s_variable = (String)subjects.get(m);
		tok1 = new StringTokenizer(s_variable,":");
		String displayname="";
		String s_test="";
		String s_measure="";
		while(tok1.hasMoreTokens())
		{
			String com=tok1.nextToken();
			if(aListCompType !=null && !aListCompType.contains(com))
				continue;
			if(strSelectedCompType!=null && !strSelectedCompType.equals(com))
				continue;
			s_test = tok1.nextToken();
			if(componenttest!=null && !componenttest.equalsIgnoreCase(s_test))
				continue;
			String val2=tok1.nextToken();
		
			if(val2.indexOf("#~&~#")>-1)
				val2=val2.substring(val2.indexOf("#~&~#")+5,val2.lastIndexOf("#"));
			
				StringTokenizer meas=new StringTokenizer(val2,"#");
				
				if(meas.hasMoreTokens() )
					 mes=meas.nextToken();			
			else 
				 mes=val2;
			if(meas.hasMoreTokens() )
				displayname=meas.nextToken();
			else
				displayname=val2;
				
				displayname=mes;
			if (!v_testmes.contains(s_test+"/"+mes))
				v_testmes.add(s_test+"/"+mes);
		}
		if(serverForSorting!=null && !serverForSorting.equals("All") && !serverForSorting.equals("-1"))
		{
			if(serverForSorting.indexOf(":")>-1)
			{
				serverForSorting=serverForSorting.substring(serverForSorting.lastIndexOf(":")+1,serverForSorting.length());
			}
			else if(serverForSorting.indexOf("All")>-1 && serverForSorting.indexOf(" ")>-1)
			{
				serverForSorting=serverForSorting.substring(serverForSorting.indexOf("All")+4,serverForSorting.length());
			}
			if(s_variable.indexOf(":")>-1)
			{
				String str_temp=s_variable.substring(0,s_variable.indexOf(":"));
				if(str_temp.equalsIgnoreCase(serverForSorting))
				{
					if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
					{
						if(s_variable.indexOf(componenttest)>-1)
						{
							String st_value=reportInfo.getValue("RUM_REPOTRS",s_variable);
							
							if(st_value.equalsIgnoreCase("wAvg"))
								st_value="Avg";
							StringTokenizer cols=new StringTokenizer(st_value,",");
							while (cols.hasMoreTokens())
							{								
								v_sort.add(displayname+"_"+cols.nextToken());
							}
						}
					}
				}
			}
		}
	}
	
	int totalspan=1;
	if(v_sort!=null && v_sort.size()>0)
		totalspan +=v_sort.size();
	//v_testmes.add("Number of unique users");
	if(testmes == null && v_testmes != null && v_testmes.size() >0)
	{
		testmes = (String)v_testmes.get(0);
	}
	if(s_uisort == null || s_uisort.equals(""))
	{
		s_uisort = "1";
	}

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;
	String starttimeformat="";
	String endtimeformat="";
	String dispDate = null;
	String comFormat = null;
	String  s_st_time   = request.getParameter("startdate");
	String s_en_time    = request.getParameter("enddate");
	String s_st_hr      = request.getParameter("starthr");
	String s_en_hr      = request.getParameter("endhr");
	String strmin       = request.getParameter("startmin");
	String enmin        = request.getParameter("endmin");
	String  er_timeline = request.getParameter("er_timeline");
	String start_date   = request.getParameter("startdate");
	String end_date     = request.getParameter("enddate");
	

	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}

	//Date calculation according to time select
	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months","3 months"};

	String startDateTime=null;
	String endDateTime=null;
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =egDt.egetRealDate();
			endDateTime = sdf.format(today);
			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,
				"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = egDt.egetRealDate();
				start.setTime(today.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			strmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
		}
	}

	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}

	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		strmin="00";
		enmin="00";
	}
	String selectedArrangeOrder   = request.getParameter("arrangeOrderBy");
	if(selectedArrangeOrder == null || selectedArrangeOrder.trim().length()==0)
		selectedArrangeOrder = "desc";
	String nextOrderBy="asc";
	String imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
	if(selectedArrangeOrder!=null && selectedArrangeOrder.equals("desc"))
	{
		nextOrderBy="asc";
		imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
	}
	else if(selectedArrangeOrder!=null && selectedArrangeOrder.equals("asc"))
	{
		nextOrderBy="desc";
		imgurl="/final/monitor/eg_images/arrow_up_black_small.gif";
	}
	String strScreenWidth = request.getParameter("screenWidth");
	int screenWidth = 990;
	try{
		screenWidth = Integer.parseInt(strScreenWidth);
	}catch(Exception e){screenWidth = 990;}


	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";


	hiddenfieldsJson.put("option","Citrix");
	hiddenfieldsJson.put("er_RmDispName",titleToDisplay);
	hiddenfieldsJson.put("inidate",currentDateFormat);
	hiddenfieldsJson.put("currTime","");
	hiddenfieldsJson.put("er_rtype","CtxUserActivity");
	hiddenfieldsJson.put("er_trgttype","RUM_Report");
	hiddenfieldsJson.put("er_gtype","Citrix");
	
	hiddenfieldsJson.put("uid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenfieldsJson.put("userID",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenfieldsJson.put("er_trenddata","No");
	if(request.getParameter("servers")!=null)
		hiddenfieldsJson.put("servers",request.getParameter("servers"));
	else
		hiddenfieldsJson.put("servers","null");
	//hiddenfieldsJson.put("er_check",request.getParameter("er_check"));
	if(request.getParameter("er_check")!=null)
		hiddenfieldsJson.put("er_check",request.getParameter("er_check"));
	else
		hiddenfieldsJson.put("er_check","null");
	if(request.getParameter("er_application1")!=null)
		hiddenfieldsJson.put("er_application1",request.getParameter("er_application1"));
	else
		hiddenfieldsJson.put("er_application1","null");
	//hiddenfieldsJson.put("er_application1",request.getParameter("er_application1"));
	if(reqFromSchedule!=null)
		hiddenfieldsJson.put("fromSchedule",reqFromSchedule);
	else
		hiddenfieldsJson.put("fromSchedule","null");

	if(fromScheduleModify!=null)
		hiddenfieldsJson.put("fromScheduleModify",fromScheduleModify);
	else
		hiddenfieldsJson.put("fromScheduleModify","null");

	if(fromFavoriteModify!=null)
		hiddenfieldsJson.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddenfieldsJson.put("fromFavoriteModify","null");
	hiddenfieldsJson.put("favorite_id", favorite_id);
	hiddenfieldsJson.put("er_favorite", er_favorite);
	if(schedule_id!=null)
		hiddenfieldsJson.put("schedule_id",schedule_id);
	else
		hiddenfieldsJson.put("schedule_id","null");

	hiddenfieldsJson.put("er_ViewName","ErRumReport.jsp");
	hiddenfieldsJson.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenfieldsJson.put("forwardto","ErRumReportJson");
	hiddenfieldsJson.put("er_bgreportfrom","RUM_Report");
	hiddenfieldsJson.put("bgenabled",strbgrepportName);
	hiddenfieldsJson.put("limitforbg",limitforbg);
	hiddenfieldsJson.put("savereport","save");
	hiddenfieldsJson.put("servletName","com.eg.ErCtxRumReportC");
	hiddenfieldsJson.put("divStatus",divStatus);
	hiddenfieldsJson.put("arrangeOrderBy",selectedArrangeOrder);
	
	if(rtype!=null&&rtype.equals("Yes"))
	{
		hiddenfieldsJson.put("opt","chart");
	}
	else
	{
		hiddenfieldsJson.put("opt","data");
	}

	String isSubmitted =request.getParameter("isSubmit");
	rootJson.put("isSubmit",isSubmitted);

	String strwidth = "90%";
	if(backreqMap == null || backreqMap != null && backreqMap.size() == 0)
		strwidth="100%";

	if(backreqMap != null && backreqMap.size() > 0  && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") )
	{
		rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}
		rootJson.put("reportTitle",intlmap.getTextDescription("reporter.thin.THIN CLIENT REPORTS")+" - "+intlmap.getTextDescription("reporter.thin.USER ACTIVITY"));
	if (!StringUtils.isNull(titleToDisplay)){ 
		lst.add(titleToDisplay);
	}
	else
	{
		lst.add(intlmap.getTextDescription("reporter.thin.RUM Reports"));
	}
	


	if (dispzone != null)
	Collections.sort(dispzone,String.CASE_INSENSITIVE_ORDER);
	screenLabelJson.put("reporter.consolidated.Zone",intlmap.getTextDescription("reporter.consolidated.Service"));

	JSONArray zoneArray = new JSONArray();
	


	if(dispzone!=null )
	{
		if(!dispzone.contains(ConstantDispName))
			dispzone.add(0,ConstantDispName);
	}
	
	for(int n=0;n<dispzone.size();n++)
	{
		String s=(String)dispzone.get(n);
		loopJsonObj = new JSONObject();
		if(!s.equalsIgnoreCase(ConstantDispName))
			loopJsonObj.put("displayField",s);
		else
			loopJsonObj.put("displayField",ConstantDispNameDisp);
		loopJsonObj.put("valueField",s);
		zoneArray.add(loopJsonObj);

		if(s_farmServerAL!=null && s_farmServerAL.contains(s))
		{
			rootJson.put("selectedZone",s);
		}			
	}
	rootJson.put("zoneCombo",zoneArray);
		


	screenLabelJson.put("reporter.thin.Component Type",intlmap.getTextDescription("reporter.thin.Component Type"));
	JSONArray comptypeArray = new JSONArray();
	if(aListCompType!=null && aListCompType.size()>0)
	{
		ArrayList sortedNameList1 = new ArrayList();
		sortedNameList1 = sorter.getSortedCompTypeList(aListCompType);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Component Type"));
		loopJsonObj.put("valueField", "-1");
		comptypeArray.add(loopJsonObj);
		
		
		for(int n=0;n<sortedNameList1.size();n++)
		{
			EgName nameObj =(EgName) sortedNameList1.get(n);
			String dispValue = nameObj.getLocalName();
			String sCompType = nameObj.getActualName();
			

			if(strSelectedCompType!=null && strSelectedCompType.equals(sCompType)&& ! strSelectedCompType.equals("-1"))
			{
				rootJson.put("selectedCompType",sCompType);
			}else
			{
			}
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",dispValue);
			loopJsonObj.put("valueField",sCompType);
			comptypeArray.add(loopJsonObj);
		}
	}else{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
		loopJsonObj.put("valueField", "-1");
		comptypeArray.add(loopJsonObj);
	}
	rootJson.put("compTypeCombo",comptypeArray);
	//if(rtype == null || (rtype!=null && rtype.equals("No")))
	{
		screenLabelJson.put("reporter.common.Server",intlmap.getTextDescription("reporter.common.Component"));
		JSONArray serverArray =  new JSONArray();
		if(dispzone != null && !dispzone.isEmpty() && s_farmServerAL.contains("-1"))
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Server"));
			loopJsonObj.put("valueField", "-1");
			serverArray.add(loopJsonObj);
		}		
		
		
		if(v_components !=null && !v_components.isEmpty())
		{
			 ArrayList sortedNameList1 = new ArrayList();
			 sortedNameList1 = sorter.getSortedCompTypeList(v_components);
			 for(int n=0;n<sortedNameList1.size();n++)
			 {

				EgName nameObj =(EgName) sortedNameList1.get(n);
				String dispValue = nameObj.getLocalName();
				String s = nameObj.getActualName();
				String displayField2 = dispValue.substring(0, dispValue.lastIndexOf(":"));

				String s1 = s;
				if(s1.indexOf(":NULL")>-1)
					s1 = s1.substring(0,s1.indexOf(":NULL"))+s1.substring(s1.indexOf(":NULL")+5);
				if(s_server!=null && s_server.equalsIgnoreCase(s))
				{
					rootJson.put("selectedServer",s_server);
				}
				if(s.indexOf(":")>-1 || s.indexOf("All ")>-1)
				{
					String strTemp="";
					String strTemp1="";
					if(s.indexOf(":")>-1)
					{
						strTemp = s1.substring(0,s1.lastIndexOf(":"));
						strTemp1 = s.substring(s.lastIndexOf(":")+1);
					}
					if(s.indexOf("All ")>-1)
					{
						strTemp = s.substring(0,s.lastIndexOf("All ")+("All ".length()));
						strTemp1 = s.substring(s.lastIndexOf("All ")+("All ".length()));
					}
			
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",strTemp);
					loopJsonObj.put("valueField",s);
					serverArray.add(loopJsonObj);
				}
				else
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+s1));
					loopJsonObj.put("valueField",s);
					serverArray.add(loopJsonObj);
				}
			 }
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "-1");
			serverArray.add(loopJsonObj);
		}


		rootJson.put("serverCombo",serverArray);
}
	

		screenLabelJson.put("reporter.thin.Report Type",intlmap.getTextDescription("reporter.thin.Report Type"));
		JSONArray reporttypeArray =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Graph"));
		loopJsonObj.put("valueField", "Yes");
		reporttypeArray.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Data"));
		loopJsonObj.put("valueField", "No");
		reporttypeArray.add(loopJsonObj);	

		rootJson.put("reportTypeCombo",reporttypeArray);
		rootJson.put("selectedreportType",rtype);


	if(rtype==null || (rtype!=null && rtype.equals("No")) || (strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline")))
	{
		JSONArray userArray = new JSONArray();
		screenLabelJson.put("reporter.thin.User",intlmap.getTextDescription("reporter.thin."+er_rep));
		if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline"))
		{
			String str_select="";
			if(v_application!=null && v_application.size()>0)
			{
				if(s_application==null || s_application.equals("-1"))
				{
					str_select="selected"; 
				}
				if(rtype!=null&&rtype.equals("No"))
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.All Users"));
					loopJsonObj.put("valueField", "--All--");
					userArray.add(loopJsonObj);
				}
				for(int n=0;n<v_application.size();n++)
				{
					String s=(String)v_application.get(n);
					if(s_application!=null && s_application.equalsIgnoreCase(s))
					{
						rootJson.put("selectedUser",s);
					}					
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",s);
					loopJsonObj.put("valueField",s);
					userArray.add(loopJsonObj);
				}
			}
			else
			{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "Not Applicable");
			userArray.add(loopJsonObj);
			}
		}
		else
		{
			if((isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes")))
			{
				String str_select="";
				if(v_application!=null && v_application.size()>0)
				{
					if(s_application==null || s_application.equals("-1"))
					{
						str_select="selected";
					}
					if(rtype!=null&&rtype.equals("No"))
					{
						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.-- All --"));
						loopJsonObj.put("valueField", "--All--");
						userArray.add(loopJsonObj);
					}
					for(int n=0;n<v_application.size();n++)
					{
						String s=(String)v_application.get(n);
						if(s_application!=null && s_application.equalsIgnoreCase(s))
						{
							rootJson.put("selectedUser",s);
						}						
						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",s);
						loopJsonObj.put("valueField",s);
						userArray.add(loopJsonObj);
					}
				}
				else
				{
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
				loopJsonObj.put("valueField", "Not Applicable");
				userArray.add(loopJsonObj);
				}
			}
			else
			{
				userArray=null;
				String strDisp = searchUser;
				if(strDisp == null || strDisp.equals("") || strDisp.equalsIgnoreCase("null") )
					strDisp = "";
			}
		}
		
		rootJson.put("userCombo",userArray);

	}
	screenLabelJson.put("reporter.thin.Based on measure",intlmap.getTextDescription("reporter.thin.Based on Measure"));
	
	
	if((rtype!=null && rtype.equalsIgnoreCase("No")) && (isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes")))
	{
		if(strGraphViewType == null || strGraphViewType.length() == 0)
				strGraphViewType = "Distribution"; 
		String strTimeLineSelect = "";
		String strDistributionSelect = "";
		screenLabelJson.put("reporter.thin.Graph Type",intlmap.getTextDescription("reporter.thin.Graph Type"));
		JSONArray graphTypeArray =  new JSONArray();
		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", "Distribution");
		loopJsonObj.put("valueField", "distribution");
		graphTypeArray.add(loopJsonObj);
		loopJsonObj=new JSONObject();
		loopJsonObj.put("displayField", "Timeline");
		loopJsonObj.put("valueField", "timeline");
		graphTypeArray.add(loopJsonObj);
		rootJson.put("graphTypeArray",graphTypeArray);

		if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline"))
		{
			strTimeLineSelect = "selected";
			rootJson.put("selectedGraphType","timeline");
		}
		else if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Distribution"))
		{
			strDistributionSelect = "selected";
			rootJson.put("selectedGraphType","distribution");
		}
		
		
		screenLabelJson.put("reporter.thin.Measure",intlmap.getTextDescription("reporter.thin.Measure"));
		JSONArray measureArray = new JSONArray();
		
		if(v_sort!=null && v_sort.size()>0)	
		{
			for(int n=0;n<v_sort.size();n++)
			{
				String s=(String)v_sort.get(n);
				if(s.indexOf("_")>-1)
				{
					String testdisp=s.substring(0,s.lastIndexOf("_"));
					String mesdisp =s.substring(s.indexOf("_")+1);
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getMeasureDescription(componenttest,testdisp));
					loopJsonObj.put("valueField",s);
					measureArray.add(loopJsonObj);

					if(testmes!=null && testmes.equalsIgnoreCase(s))
					{
					rootJson.put("selecteder_sort",intlmap.getMeasureDescription(testdisp,mesdisp));
					}
				}
				else
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getMeasureDescription(componenttest,s));
					loopJsonObj.put("valueField",s);
					measureArray.add(loopJsonObj);
					if(testmes!=null && testmes.equalsIgnoreCase(s))
					{
						rootJson.put("selecteder_sort",testmes);
					}
				}
			}
		}else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "Not Applicable");
			measureArray.add(loopJsonObj);
		}


		rootJson.put("er_sortCombo",measureArray);		
	}
	if(rtype!=null && rtype.equals("Yes"))
	{
			if(strGraphViewType == null || strGraphViewType.length() == 0)
				strGraphViewType = "Distribution"; 
			String strTimeLineSelect = "";
			String strDistributionSelect = "";
			screenLabelJson.put("reporter.thin.Graph Type",intlmap.getTextDescription("reporter.thin.Graph Type"));
			JSONArray graphTypeArray =  new JSONArray();
			loopJsonObj=new JSONObject();
			loopJsonObj.put("displayField", "Distribution");
			loopJsonObj.put("valueField", "distribution");
			graphTypeArray.add(loopJsonObj);
			loopJsonObj=new JSONObject();
			loopJsonObj.put("displayField", "Timeline");
			loopJsonObj.put("valueField", "timeline");
			graphTypeArray.add(loopJsonObj);
			rootJson.put("graphTypeArray",graphTypeArray);

			if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline"))
			{
				strTimeLineSelect = "selected";
				rootJson.put("selectedGraphType","timeline");
			}
			else if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Distribution"))
			{
				strDistributionSelect = "selected";
				rootJson.put("selectedGraphType","distribution");
			}
			if(strGraphViewType!=null && strGraphViewType.equalsIgnoreCase("Timeline"))
			{
				if(s_perserver == null || s_perserver.length() == 0)
					s_perserver = "Yes"; 

				screenLabelJson.put("reporter.thin.Aggregate across servers",intlmap.getTextDescription("reporter.thin.Aggregate across servers"));
				JSONArray aggTypeArray =  new JSONArray();
				loopJsonObj=new JSONObject();
				loopJsonObj.put("displayField", "Yes");
				loopJsonObj.put("valueField", "No");
				aggTypeArray.add(loopJsonObj);
				loopJsonObj=new JSONObject();
				loopJsonObj.put("displayField", "No");
				loopJsonObj.put("valueField", "Yes");
				aggTypeArray.add(loopJsonObj);
				rootJson.put("aggbasedOn",aggTypeArray);

				if (s_perserver!=null && s_perserver.equals("Yes"))
				{
					strzoneCheck = "CHECKED";
					rootJson.put("selectedAgg","Yes");
				}
				else 
				{
					strServercheck = "CHECKED";
					rootJson.put("selectedAgg","No");
				}
			}else{
				screenLabelJson.put("reporter.thin.Measure",intlmap.getTextDescription("reporter.thin.Measure"));
				JSONArray measureArray = new JSONArray();
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Measure"));
				loopJsonObj.put("valueField", "-1");
				measureArray.add(loopJsonObj);				
				
				for(int n=0;n<v_testmes.size();n++)
				{
					String s=(String)v_testmes.get(n);
					if(s.indexOf("/")>-1)
					{
						String testdisp=s.substring(0,s.indexOf("/"));
						String mesdisp =s.substring(s.indexOf("/")+1);
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getMeasureDescription(testdisp,mesdisp));
					loopJsonObj.put("valueField",s);
					measureArray.add(loopJsonObj);

						if(testmes!=null && testmes.equalsIgnoreCase(s))
						{
						rootJson.put("selectedMeasure",testmes);
						}
					}
					else
					{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getTestDescription("reporter.common."+s));
					loopJsonObj.put("valueField",s);
					measureArray.add(loopJsonObj);

						if(testmes!=null && testmes.equalsIgnoreCase(s))
						{
							rootJson.put("selectedMeasure",testmes);
						}
					}
				}


			rootJson.put("measureCombo",measureArray);
		}
	}



	screenLabelJson.put("reporter.comparison.Show Top",intlmap.getTextDescription("reporter.comparison.Show Top"));	
	JSONArray priorityArray =  new JSONArray();
	for(int n=0;n<v_show.size();n++)
	{
		String s=(String)v_show.get(n);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+s));
		loopJsonObj.put("valueField", s);
		priorityArray.add(loopJsonObj);

		if(priority!=null && priority.equalsIgnoreCase(s))
		{
		rootJson.put("selectedPriority",priority);
		}									
	}
	rootJson.put("priorityCombo",priorityArray);


	
		screenLabelJson.put("reporter.common.Time period", intlmap.getTextDescription("reporter.common.Time period"));
		screenLabelJson.put("reporter.common.Hrs", intlmap.getTextDescription("reporter.common.Hrs"));
		screenLabelJson.put("reporter.common.Mins", intlmap.getTextDescription("reporter.common.Mins"));
		rootJson.put("selectedTimeFrom",Hourfrom);
		rootJson.put("selectedMinsFrom",Minfrom);
		rootJson.put("selectedTimeTo",Hourto);
		rootJson.put("selectedMinsTo",Minto);

		screenLabelJson.put("reporter.common.Exclude weekends",intlmap.getTextDescription("reporter.common.Exclude weekends"));
		JSONArray exclweekArray  =  new JSONArray();
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		exclweekArray.add(loopJsonObj);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		exclweekArray.add(loopJsonObj);
		rootJson.put("excludeWeekCombo",exclweekArray);
		rootJson.put("excludeWeek",excludeweekend);
		screenLabelJson.put("MappedExcludeDays", intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);
		screenLabelJson.put("reporter.comparison.Weighted Average",intlmap.getTextDescription("reporter.comparison.Weighted Average"));
		JSONArray weightedArray =  new JSONArray();

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		weightedArray.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		weightedArray.add(loopJsonObj);	

		rootJson.put("weightedAvgCombo",weightedArray);
	if(rtype!=null&&rtype.equals("No") || rtype== null)
	{
		screenLabelJson.put("reporter.thin.Aggregate across servers on",intlmap.getTextDescription("reporter.thin.Aggregate across servers"));
		JSONArray aggbasedon  =  new JSONArray();
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Yes"));
		loopJsonObj.put("valueField", "Yes");
		aggbasedon.add(loopJsonObj);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.No"));
		loopJsonObj.put("valueField", "No");
		aggbasedon.add(loopJsonObj);
		rootJson.put("aggAcrossServer",aggbasedon);
		rootJson.put("selectedAggServer",s_perserver);
	}
	if(excludeweekend.equalsIgnoreCase("Yes") )
	{

		lst.add('"'+intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs")+'"'+","+'"'+
		intlmap.getTextDescription("reporter.common.Exclude weekends")+":"+Days+'"');
	}
	else
	{
		lst.add(intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs"));
	}


	String select_yes = "";
	String select_no = "";
	if(show_timeinuse != null && show_timeinuse.equalsIgnoreCase("Yes"))
	{
		select_yes = "checked";
		select_no="";
		rootJson.put("weightedAvg","Yes");

	}
	else
	{
		select_yes="";
		select_no = "checked";
		rootJson.put("weightedAvg","No");

	}


/*******************************************************************************
* File name : ErTimeFormat.jsp
* Purpose   : Time Control to be used thorugh out Reporter.
* Version   : Reporter 4.0
*******************************************************************************/


	JSONArray timelineComboArray=new JSONArray();
	JSONArray timelineHourComboArray=new JSONArray();
	String startDateJSON="";
	String endDateJSON="";
	String startHourJSON="";
	String endHourJSON="";
	String selectedGraphMode="";
	String startDateForHighchart=null;
	String endDateForHighchart=null;
	String chartTypeForUI=null;
	
	User userName = UserRegistry.getInstance().getUser(session.getId());
	ErReportHelper er_rpthelper = new ErReportHelper();
	EgReportInfo rptInfo = new EgReportInfo("manager");
	EgMappingInfo mappingObj = new EgMappingInfo(thisuser.getLanguage());
	String reqOption = request.getParameter("option");
	String deftimeline = rptInfo.getDefaultTimeLine("MISC","MaxTimeline");
	List alist = Arrays.asList(options);
	String loginName = userName.getLoginID();
	int len;
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	//String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
	String[] lstWeeksArr = new String[]{"Last week", "Last month"};	
	if(strUsrTimeline != null && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
		
	if (reqOption!=null && reqOption.equalsIgnoreCase("Citrix"))
	{
		if(deftimeline !=null && !deftimeline.equals("-1"))
		{
			if(len > alist.indexOf(deftimeline)+1)
			{
				len=alist.indexOf(deftimeline)+1;
			}
			if (len >0)
				strUsrTimeline = (String)alist.get(len-1);
			else
				strUsrTimeline = (String)alist.get(len);
		}

	}
	if(len == 0)
		len = options.length;
	String grophmodeon = request.getParameter("grophmodeon");
	String r_type = request.getParameter("er_type");
	String reporttype = request.getParameter("reporttype");
	String er_rtype = request.getParameter("er_rtype");
	String er_rtype_proc = request.getParameter("er_rtype_proc");
	String timeformat_trend = request.getParameter("er_trenddata");
	if (timeformat_trend == null || timeformat_trend ==" " )
		timeformat_trend = "No";

	if (reporttype==null || reporttype.equalsIgnoreCase("null"))
	{
		if (er_rtype!=null && er_rtype.equalsIgnoreCase("macro"))
		{
			reporttype="executive";
		} else if (er_rtype!=null && ( er_rtype.equalsIgnoreCase("application") || er_rtype.equalsIgnoreCase("network") 
		|| er_rtype.equalsIgnoreCase("site") || er_rtype.equalsIgnoreCase("system") ||  er_rtype.equalsIgnoreCase("Event") ) )
		{
			reporttype="operation";
		}

	}

	String colum="";
	if(reporttype!=null &&reporttype.equalsIgnoreCase("executive"))
		colum="9";
	else
		colum="6";
	String er_gtype=request.getParameter("er_gtype");

	java.util.Date start = egDt.egetRealDate();
	String startMin = Integer.toString(start.getMinutes());
	String endMin = Integer.toString(start.getMinutes());
	String strsmin_11=request.getParameter("startmin");
	String etrsmin_11=request.getParameter("endmin");
	if(strsmin_11 != null && strsmin_11.length()>0)
		startMin = strsmin_11;
	if(etrsmin_11 != null && etrsmin_11.length()>0)
		endMin = etrsmin_11;

	EgTimeZoneConverter timeZoneConverterStart = null;
	EgTimeZoneConverter timeZoneConverterEnd = null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay = null;
	String endMinForDisplay = null;
	for(int e_ctr=0; e_ctr<len; e_ctr++)
	{
		String s_timeline=options[e_ctr];
		if(s_timeline.equalsIgnoreCase("Any"))
		{
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",mappingObj.getTextDescription("reporter.common."+s_timeline));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}else if(s_timeline.contains("Last")){
			String displayField=null;
			String viewField=null;
			displayField = s_timeline;
			int spaceNum = 0;
			for(int i=0; i<s_timeline.length();i++){
				char ch = s_timeline.charAt(i);
				if(ch== ' '){
				   spaceNum++; 
				}
			}
			if(spaceNum > 2){
				String countStr = s_timeline.substring(s_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = s_timeline.substring(s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.length());
				String last = s_timeline.substring(0, s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr + end + "_" + last;				
			}else{
				viewField = "1 "+s_timeline.substring(s_timeline.lastIndexOf(" ")+1, s_timeline.length())  + "_" + s_timeline.substring(0, s_timeline.indexOf(" "));				
			}
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",displayField);
			timelineJSON.put("valueField", viewField.toLowerCase());
			timelineComboArray.add( timelineJSON );			
		}
		else
		{
			String numstr = s_timeline.substring(0,s_timeline.indexOf(" "));
			String strextra = s_timeline.substring(s_timeline.indexOf(" ")+1);

			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",numstr+" "+ mappingObj.getTextDescription("reporter.common."+strextra));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}

		/*if(er_timeline!=null && er_timeline.equals((String)options[e_ctr]))
		{
			if(er_timeline.equalsIgnoreCase("Any"))
			{
				String strer_timeline="reporter.common."+er_timeline;

			}
			else
			{
				String numstr = er_timeline.substring(0,er_timeline.indexOf(" "));
				String strextra = er_timeline.substring(er_timeline.indexOf(" ")+1);
				String str_strextra="reporter.common."+strextra;
			}
		}
		else
		{
			if(options[e_ctr].equalsIgnoreCase("Any"))
			{
				String  str_options="reporter.common."+options[e_ctr];
			}
			else
			{
				String numstr = options[e_ctr].substring(0,options[e_ctr].indexOf(" "));
				String strextra = options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				//FIX FOR SUPPORT TOMCAT 6.0
				String str_extra= "reporter.common."+strextra;
			}
		}*/
	} 

	List lastDataList = new ArrayList();
	JSONArray lastDataJSON = null;
	int lastWeekCount = 1;		
	if(isLastTimeLine){
		if(strUsrTimeline.equals("-1")){
			for(int i=0;i<lstWeeksArr.length;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 week")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("2 weeks")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("3 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("4 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 month")){
			lastWeekCount = 2;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);			
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}		
		}	
	}
	
	String isVmReport = request.getParameter("isVmReport");
	if(er_timeline!=null && !er_timeline.equals("Any"))
	{
		/*if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		}
		else*/
	
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			
			
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat); 
	}
	else
	{
	
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		
		
		//dispDate = s_st_time;
	}
	if (timeformat_trend!=null && timeformat_trend.equals("Yes")&& er_timeline!=null && !er_timeline.equals("Any")) {
		
		s_st_hr="00";
		startMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start //User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;	
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName,true); 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" + startMin; 
			
			startDateForDisplay = dispDate;
			startHourForDisplay = s_st_hr;
			startMinForDisplay = startMin;

			dispDate=(String) timeZoneConverterStart.getDate(false);
			s_st_time=dispDate;
			startDateJSON=dispDate;
			s_st_hr = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();
		}
		
	} else { 
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;			
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName);
	 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" +startMin; 
			startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
			startHourForDisplay = timeZoneConverterStart.getHour();
			s_st_hr = s_st_hr.trim();
			startMinForDisplay = timeZoneConverterStart.getMinute();
			startDateJSON=dispDate;			
		}
		
	}
 	/*if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_st_time;
	}*/
	
 

	for(int s_ctr=0; s_ctr<24; s_ctr++)
	{
		s_st_hr = s_st_hr.trim();
		if(!er_timeline.endsWith("last"))
			startHourJSON=s_st_hr;
		JSONObject timelineHourJSON = new JSONObject();
		timelineHourJSON.put("displayField",String.valueOf(s_ctr));
		timelineHourJSON.put("valueField",String.valueOf(s_ctr));
		timelineHourComboArray.add( timelineHourJSON );
	}

	
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
		else
		{
			if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
			{
				comFormat = currentDateFormat;
			}
			else
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
	}
	else
	{
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		//comFormat = currentDateFormat;
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat); 
	}

	if (timeformat_trend!=null && timeformat_trend.equals("Yes") && er_timeline!=null && !er_timeline.equals("Any")) {
		s_en_hr="00";
		endMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			System.out.println("1Manager Start Time-->"+startDateForHighchart);
			System.out.println("1Manager Start Hour-->"+startHourJSON);
			System.out.println("1Manager End Time--->"+endDateForHighchart);		

		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " " + s_en_hr + ":" + endMin, userName,true);
		
		endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;

			endDateForDisplay = dispDate;
			endHourForDisplay = s_en_hr;
			endMinForDisplay = endMin;
				
			dispDate=(String) timeZoneConverterEnd.getDate(false);
			s_en_time=dispDate;
			endDateJSON=dispDate;
			s_en_hr = timeZoneConverterEnd.getHour();
			endHourJSON=s_en_hr;
			endMin = timeZoneConverterEnd.getMinute(); 
		}		
		
	} else {
		if(er_timeline.endsWith("last")){			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			/*System.out.println("2Manager Start Time-->"+startDateForHighchart);
			System.out.println("2Manager Start Hour-->"+startHourJSON);
			System.out.println("2Manager End Time--->"+endDateForHighchart);*/
			System.out.println("2Manager-Last Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " "+ s_en_hr + ":" + endMin, userName);

			endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;
			endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
			endHourForDisplay = timeZoneConverterEnd.getHour(); 
			endHourJSON=s_en_hr;
			s_en_hr = s_en_hr.trim();
			endMinForDisplay = timeZoneConverterEnd.getMinute();
			endDateJSON=dispDate;
			System.out.println("2Manager Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}
	}

	//for(int e_ctr=0; e_ctr<24; e_ctr++)
	//{
		//s_en_hr=s_en_hr.trim();
		//endHourJSON=s_en_hr;
	//}
	if(request.getParameter("er_type")!=null && !(request.getParameter("er_type")).equalsIgnoreCase("Comparison"))
	{
		if(request.getParameter("er_type").equals("Yes") || request.getParameter("er_type").equals("Vmgstatus"))
		{
		
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_type_proc")!=null)
	{
		if(request.getParameter("er_type_proc").equals("Yes"))// || request.getParameter("er_type_proc").equals("Vmgstatus"))
		{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_rtype")!=null && request.getParameter("er_rtype").equalsIgnoreCase("AlarmHistory"))
	{
		
	}
	else if(reporttype!=null && (reporttype.equalsIgnoreCase("executive")|| reporttype.equalsIgnoreCase("operation")||reporttype.equalsIgnoreCase("TopN")) || (grophmodeon!=null && grophmodeon.equalsIgnoreCase("yes")) ||er_gtype!=null && er_gtype.equalsIgnoreCase("Comparison"))
	{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D"))
			{
				selectedGraphMode="2D";
			}
			if(mode.equals("3D"))
			{
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
	}


								
	String sdate = request.getParameter("startdate");	
	String edate = request.getParameter("enddate");	
	String shr = request.getParameter("starthr");	
	String ehr = request.getParameter("endhr");	
	String smin = request.getParameter("startmin");	
	String emin = request.getParameter("endmin");
	
	starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
	
	endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
	
							
							

	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		er_background = "selected";
		er_foreground = "";
	}
	else
	{
		er_background = "";
		er_foreground = "selected";
	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	
	//
	
	String  pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String  pdfEndDate   = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
	String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";

	Vector applnPdfData = new Vector();
	applnPdfData = (Vector)request.getAttribute("applnPdfData");
	if(applnPdfData == null)
		applnPdfData = new Vector();
	pdfTime = "Application Report "+pdfTime;

	if(applnPdfData!=null && !applnPdfData.isEmpty())
	{
		Vector forTime = (Vector)applnPdfData.get(1);
		forTime.removeElementAt(0);
		forTime.insertElementAt(pdfTime,0);
		applnPdfData.removeElementAt(1);
		applnPdfData.insertElementAt(forTime,1);
	}
	
	//
	Vector dvec = new Vector();
	String stimefmt = "Start Date : "+pdfStartDate;
	String etimefmt = "End Date : "+pdfEndDate;
	dvec.add('"'+stimefmt+'"');
	dvec.add('"'+etimefmt+'"');
	lst.add(dvec);
	
	hiddenfieldsJson.put("pdfTime",pdfTime);
	hiddenfieldsJson.put("userTimeline",strUsrTimeline);
	screenLabelJson.put("reporter.common.Timeline", intlmap.getTextDescription("reporter.common.Timeline"));
	screenLabelJson.put("reporter.common.From", intlmap.getTextDescription("reporter.common.From"));
	screenLabelJson.put("reporter.common.To", intlmap.getTextDescription("reporter.common.To"));
	screenLabelJson.put("reporter.common.Hr", intlmap.getTextDescription("reporter.common.Hr"));
	screenLabelJson.put("reporter.common.Graph", intlmap.getTextDescription("reporter.common.Graph"));

	rootJson.put("timelineCombo",timelineComboArray);
	//rootJson.put("timelineHourCombo",timelineHourComboArray);
	rootJson.put("selectedTimeline",er_timeline);
	rootJson.put("startDate",startDateJSON);
	rootJson.put("endDate",endDateJSON);
	rootJson.put("startHour",startHourJSON);
	rootJson.put("endHour",endHourJSON);
	rootJson.put("startmin",strmin);
	rootJson.put("endmin",enmin);
	rootJson.put("selectedGraphMode",selectedGraphMode);

	//User TimeZone changes
	rootJson.put("startDateForDisplay",startDateForDisplay);
	rootJson.put("startHourForDisplay",startHourForDisplay);
	rootJson.put("startMinForDisplay",startMinForDisplay);
	rootJson.put("endDateForDisplay",endDateForDisplay);
	rootJson.put("endHourForDisplay",endHourForDisplay);
	rootJson.put("endMinForDisplay",endMinForDisplay);
	chartTypeForUI=ErHighchartUtils.getChartType(startDateForHighchart,endDateForHighchart,currentDateFormat+" HH:mm");
	rootJson.put("chartType",chartTypeForUI);
	screenLabelJson.put("reporter.common.Report Generation", intlmap.getTextDescription("reporter.common.Report Generation"));
	screenLabelJson.put("reporter.common.SUBMIT", intlmap.getTextDescription("reporter.common.SUBMIT"));
	screenLabelJson.put("reporter.common.Report Name", intlmap.getTextDescription("reporter.common.Report Name"));
	JSONArray reportGenerationComboArray =  new JSONArray();
	JSONObject tmpobj=new JSONObject();
	tmpobj.put("displayField", strbackground);
	tmpobj.put("valueField", "background");
	reportGenerationComboArray.add(tmpobj);
	tmpobj=new JSONObject();
	tmpobj.put("displayField", strforeground);
	tmpobj.put("valueField", "foreground");
	reportGenerationComboArray.add(tmpobj);
	rootJson.put("reportGenerationCombo",reportGenerationComboArray);

	screenLabelJson.put("reporter.common.Report For", intlmap.getTextDescription("reporter.common.Report For"));

	JSONArray viewApplnCombo =  new JSONArray();
	tmpobj=new JSONObject();
	tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.RUM Report"));
	tmpobj.put("valueField", "RUM");
	viewApplnCombo.add(tmpobj);
	tmpobj=new JSONObject();
	tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.Error Report"));
	tmpobj.put("valueField", "Error");
	viewApplnCombo.add(tmpobj);
	rootJson.put("reportForCombo",viewApplnCombo);
	rootJson.put("reportFor","RUM");

	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
		rootJson.put("reportGeneration","background");
		}
		else
		{
		rootJson.put("reportGeneration","foreground");
		}
	}
		
if(bggroundStr != null && !bggroundStr.equals(""))
{
	rootJson.put("backgroundReportStatus",status);
	String strreportName ="RUM_Report";
	if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
	{
		strreportName ="All Report Types";
	}
		String bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
		rootJson.put("bgroundResponseTxt",bgroundResponseTxt);
		rootJson.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&er_userid="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		rootJson.put("backgroundAnchor", intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));


}


int appValue=0;
if(htt!=null && !htt.isEmpty())
{
	for(Enumeration en = htt.keys(); en.hasMoreElements();)
	{
		Vector v_value = (Vector)htt.get((String)en.nextElement());
		if(v_value!=null && !v_value.isEmpty())
			appValue++;
	}
}

if((htt!=null && appValue >0) || (app_topusers!=null && app_topusers.size()>0) || (v_qry_string!=null && v_qry_string.size()>0))
{
	JSONObject selectionDetails=new JSONObject();
	 rootJson.put("reporter.common.SelectionDetailsfor", intlmap.getTextDescription("reporter.common.Selection Details for ")+" "+ intlmap.getComponentTypeDescription(strSelectedCompType));



	String s_reportType="";
	if(rtype!=null && rtype.equals("Yes")) {
		s_reportType="Graph";
	} else {
		s_reportType="Data";
	}
	selectionDetails.put(intlmap.getTextDescription("reporter.common.Report Type"),s_reportType);
	//selectionDetails.put(intlmap.getTextDescription("reporter.consolidated.Component Type"),intlmap.getComponentTypeDescription(strSelectedCompType));
	
	





if(s_farmServerAL!=null &&s_farmServerAL.size()!=0)
	{
		String sTxt="";
		for(int cc=0;cc<s_farmServerAL.size();cc++)
		{
			sTxt+=(String) s_farmServerAL.get(cc);
			if(cc!=(s_farmServerAL.size()-1))
			sTxt+=", ";
		}
		if(sTxt.equalsIgnoreCase(ConstantDispName))
			sTxt=ConstantDispNameDisp;
		
		selectionDetails.put(intlmap.getTextDescription("reporter.common.Service"),sTxt);
	}
{
	String server = (s_server!=null && s_server.equals("-1")) ? "All Server" : s_server;
	if(server.indexOf(":NULL")>-1)
		server = server.substring(0,server.indexOf(":NULL"))+server.substring(server.indexOf(":NULL")+5);
	if(rtype!=null && rtype.equals("No") && server!=null && !server.equals("-1"))
	{
	selectionDetails.put(intlmap.getTextDescription("reporter.common.Components"),server.substring(0,server.lastIndexOf(":")));
}
}



	
	if(rtype!=null && rtype.equals("No")) 
	{
		if(s_sort!=null && s_sort.indexOf("_")>-1)
		{
			s_sort=s_sort.substring(0,s_sort.lastIndexOf("_"));
			s_sort=intlmap.getMeasureDescription(componenttest,s_sort);
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Based on Measure"),intlmap.getTextDescription("reporter.common."+s_sort));
		}
	}


	if(testmes!=null && rtype!= null && rtype.equals("Yes"))
	{


		if(testmes.indexOf("/") >-1)
		{
			String str_test = testmes.substring(0,testmes.indexOf("/"));
			String s_meas = testmes.substring(testmes.indexOf("/")+1);
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Measure"),intlmap.getMeasureDescription(str_test, s_meas));



		} else {
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Measure"),intlmap.getTextDescription("reporter.common."+testmes));



		}
	}
	String strApp = (s_application!=null && s_application.equals("-1")) ? "All Users" : s_application;
	if(rtype!=null && rtype.equals("No") && strApp!=null && !strApp.equals("-1"))
	{
	selectionDetails.put(intlmap.getTextDescription("reporter.common."+er_rep),strApp);



	}
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Exclude weekends"),excludeweekend);
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period "),"<span class='font_bold'></span> "+Hourfrom+":"+Minfrom+"<span class='font_bold'> "+intlmap.getTextDescription("reporter.common.to")+" </span>"+Hourto+":"+Minto);
			selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),"<span class='font_bold'></span> "+pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <span class='font_bold'> "+intlmap.getTextDescription("reporter.common.to")+" </span> "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
			rootJson.put("selectionDetails",selectionDetails);


	}
	ArrayList sublist=(ArrayList)reportInfo.getVariables("RUM_REPOTRS");
	for(int i=0; i<sublist.size(); i++)
	{
		String tempsub1=(String)sublist.get(i);
		String s=request.getParameter("er_server");
		String s1=request.getParameter("componenttest");
	
		if(s!=null && !s.equals("All") && !s.equals("-1") && s.lastIndexOf(":")>0)
		{
			s=s.substring(s.lastIndexOf(":")+1,s.length());
			s=s.trim();
			String s3=s+":"+s1;
			
			if(tempsub1.indexOf(s3)==-1)
			{
				sublist.remove(i);
				i=i-1;
			}
		}
	}
	if(rtype==null)
	{
		rtype="No";
	}
	if(rtype!=null&&rtype.equals("No") || rtype== null)
	{
		JSONObject reportDataJson = new JSONObject();
		JSONArray reportDataArray = new JSONArray();
		
		if(app_topusers == null || app_topusers.isEmpty() || app_topusers.size() == 0)
		{
			Vector value=new Vector();
			Vector value_1=new Vector();
			String AddFieldsDisplay="";
			String FieldstoDisplay="$F{title}";
			String Fields="title";
			String addMapping="";
			String pdfKey="";
			String con="yes";
			if (htt!=null )
			{
				Enumeration enum1 = htt.keys();
				if (htt.isEmpty())
				{


				}
				while(enum1.hasMoreElements())
				{
					String key1 = (String)enum1.nextElement();
					value_1=(Vector)htt.get(key1);

					if(value_1.isEmpty() && con.equals("yes"))
					{


						con="no";
					}
					
					if(!value_1.isEmpty())
					{
						JSONObject gridObj=new JSONObject();
						JSONObject gridColumnsDetails=new JSONObject();
						JSONObject unitForMeasure=new JSONObject();
						JSONArray gridDataArray=new JSONArray();
						int totalColumnCount=0;
						int havingSingleColumn=0;
						
						for(int gg=0;gg<value_1.size();gg++)
						{	
							value=(Vector)value_1.get(gg);
							if(!value.isEmpty())
							{
							
						
						 gridObj=new JSONObject();
						 gridColumnsDetails=new JSONObject();
						 unitForMeasure=new JSONObject();
						 gridDataArray=new JSONArray();
						 totalColumnCount=0;
						 havingSingleColumn=0;
						 
						 String s_serverVal=(String)select_farms.get(gg);

						if(s_serverVal.equals("-1") && value.get(0) instanceof Vector)
							totalspan= ((Vector)value.get(0)).size();


					
						if(s_serverVal==null || s_serverVal.equals("-1") || s_serverVal.equals("")|| aListAlltype.contains(s_serverVal))
						{
							pdfKey=(String)s_farmServerAL.get(0);
							if(pdfKey.equalsIgnoreCase(ConstantDispName))
							{
								pdfKey=ConstantDispNameDisp;
							}


							s_tit1 = rep_title+" for '"+pdfKey+"' Service";
							gridObj.put("gridTitle",s_tit1);					


							if (s_perserver!=null && s_perserver.equalsIgnoreCase("No"))
							{
								AddFieldsDisplay="Server / User";


							
							vec1.add(intlmap.getTextDescription("reporter.common.Service"));

							if(!componenttest.equalsIgnoreCase("RUMAppTest"))
							{
							//		vec1.add(intlmap.getTextDescription("reporter.common.Component"));
								gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Server")+" /"+intlmap.getTextDescription("reporter.common.User"),new JSONArray());
							//	gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
							}else
								gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
							
							totalColumnCount++;
							}
							else
							{


								AddFieldsDisplay="Application";
								vec1.add(intlmap.getTextDescription("reporter.common."+er_rep));
								if(!componenttest.equalsIgnoreCase("RUMAppTest"))
								{
								//vec1.add(intlmap.getTextDescription("reporter.common.Component"));
								vec1.add(intlmap.getTextDescription("reporter.common."+er_rep));
								//gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
								}
								else
								gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
								totalColumnCount++;
							}							


							FieldstoDisplay+=",-";
						}
						else if ((s_serverVal!=null || !s_serverVal.equals("-1") || !s_serverVal.equals("")) )
						{
							String s_server_sub = s_serverVal;
							if(s_server_sub.indexOf(":NULL")>-1)
								s_server_sub = s_server_sub.substring(0,s_server_sub.indexOf(":NULL"))+s_server_sub.substring(s_server_sub.indexOf(":NULL")+5);
							String t_srv=s_server_sub.substring(0,s_server_sub.lastIndexOf(":"));
							if(t_srv!=null && t_srv.indexOf(",")>0 && strSelectedCompType!=null && strSelectedCompType.trim().length()>0)
								t_srv=intlmap.getComponentTypeDescription(strSelectedCompType);

							pdfKey=s_server_sub.substring(0,s_server_sub.lastIndexOf(":"));
							AddFieldsDisplay="Application";
							FieldstoDisplay+=",-";
							if(isreportsneedService!=null &&isreportsneedService.equalsIgnoreCase("Yes"))
								t_srv=(String)titleVc.get(gg);
							if(t_srv.equalsIgnoreCase(ConstantDispName))
							{
								t_srv=ConstantDispNameDisp;
							}
							s_tit1 = rep_title+" for '"+t_srv+"' Service";
							vec1.add(intlmap.getTextDescription("reporter.common."+er_rep));
							gridObj.put("gridTitle",s_tit1);
							if(!componenttest.equalsIgnoreCase("RUMAppTest"))
							{						
								//vec1.add(intlmap.getTextDescription("reporter.common.Component"));
								gridColumnsDetails.put(intlmap.getTextDescription("reporter.common."+er_rep),new JSONArray());							
								//gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
							}else
							gridColumnsDetails.put(intlmap.getTextDescription("reporter.common.Component"),new JSONArray());
							totalColumnCount++;

						}
						else
						{
							pdfKey=s_application;
							AddFieldsDisplay="Application";
							FieldstoDisplay+=",-";
							if(isreportsneedService!=null &&isreportsneedService.equalsIgnoreCase("Yes"))
								s_application=(String)titleVc.get(gg);
							if(s_application.equalsIgnoreCase(ConstantDispName))
							{
								s_application=ConstantDispNameDisp;
							}
							s_tit1 = rep_title+" for '"+s_application+"' Service";
							gridObj.put("gridTitle",s_tit1);					

						}
						if (FieldstoDisplay.equals(""))
						{
							FieldstoDisplay="-,-";
						}
						else
						{
							FieldstoDisplay+=",-,-";
						}
						String s_var = "";
						Vector v_val = new Vector();
						if (Fields.equals(""))
						{
							//Fields="Application,Timeinuse,Users";
							Fields="User";
						}
						else
						{
							//Fields+=",Application,Timeinuse,Users";
							Fields+=",Application";
						}
						if (addMapping.equals(""))
						{
							//addMapping="Application#Application,Timeinuse#Timeinuse,Users#Users";
							addMapping="Users#Users";
						}
						else
						{
							//addMapping+=",Application#Application,Timeinuse#Timeinuse,Users#Users";
							addMapping+=",Users#Users";
						}
						Class [] addFieldClassTypes = new Class[sublist.size()+3] ;

						addFieldClassTypes[0]=java.lang.String.class;
						addFieldClassTypes[1]=java.lang.String.class;
						addFieldClassTypes[2]=java.lang.String.class;
						v_val1=new Vector();
						int sortCount=0;
						int sortByVal=0;
						if(s_uisort!=null && !s_uisort.equalsIgnoreCase(""))
						{
							try{
								sortByVal=(int)Integer.parseInt(s_uisort)-1;
								String subListVal=(String)sublist.get(sortByVal);
								
								sublist.remove(sortByVal);
								sublist.add(0,subListVal);
						
							}catch(Exception ee)
							{
								ee.printStackTrace();
							}
						}
						for(int m=0;m<sublist.size();m++)
						{
							s_var = (String)sublist.get(m);
							String st_value="";
							String displayname="";
							String strTempDisplayname="";
							String val2="";
							String testname="";
							String s_unit = "";
							if ((s_serverVal==null || s_serverVal.equals("-1") || s_serverVal.equals("")) &&  s_farmServerAL!=null && !s_farmServerAL.contains("") || aListAlltype.contains(s_serverVal))
							{
								
								if(s_var.startsWith(key1))
								{
									StringTokenizer tok2 = new StringTokenizer(s_var,":");
									while(tok2.hasMoreTokens())
									{
										tok2.nextToken();
										testname=tok2.nextToken();
										val2=tok2.nextToken();
										
											if(val2.indexOf("#~&~#")>-1)
											{
												val2=val2.substring(val2.indexOf("#~&~#")+5);
											}
										StringTokenizer meas=new StringTokenizer(val2,"#");
										if(meas.hasMoreTokens() )
										{
											mes=meas.nextToken();
										}
										else
										{
											mes=val2;
										}
										if(meas.hasMoreTokens() )
										{
											displayname=meas.nextToken();
										}
										else
										{
											displayname=val2;
										}
										displayname=mes;
										strTempDisplayname = displayname;
										s_unit=tablesInfo.getUnitForMeasure(testname,mes);
										if(s_unit != null && !s_unit.equals(""))
											//displayname = displayname+" ("+s_unit+")";
											displayname = displayname;
									}
									st_value=reportInfo.getValue("RUM_REPOTRS",s_var);
								}
								v_val.add(st_value);
							}
							else
							{
							
								String strCompType = null;
								if(s_serverVal.lastIndexOf(":")>-1)
									strCompType = s_serverVal.substring(s_serverVal.lastIndexOf(":")+1);
								if(strCompType!=null && s_var !=null && !s_var.startsWith(strCompType))
									continue;
								StringTokenizer tok2 = new StringTokenizer(s_var,":");
								while(tok2.hasMoreTokens())
								{
									tok2.nextToken();
									testname=tok2.nextToken();
									val2=tok2.nextToken();
										if(val2.indexOf("#~&~#")>-1)
											val2=val2.substring(val2.indexOf("#~&~#")+5);
									StringTokenizer meas=new StringTokenizer(val2,"#");
									if(meas.hasMoreTokens() )
									{
										mes=meas.nextToken();
									}
									else
									{
										mes=val2;
									}
									if(meas.hasMoreTokens() )
									{
										displayname=meas.nextToken();
									}
									else
									{
										displayname=val2;
									}
									displayname=mes;
									strTempDisplayname = displayname;
									s_unit=tablesInfo.getUnitForMeasure(testname,mes);
									if(s_unit != null && !s_unit.equals(""))
										//displayname = displayname+"("+s_unit+")";
										displayname = displayname;
								}
								st_value=reportInfo.getValue("RUM_REPOTRS",s_var);
								
								v_val.add(st_value);
							}
							if (st_value.equals(""))
							{
								st_value="Avg";
							}
							StringTokenizer st_val=new StringTokenizer(st_value,",");
							StringTokenizer st_val_temp=new StringTokenizer(st_value,",");
							int countTokens=st_val.countTokens();
							if(!displayname.equals(""))
							{
								sortCount = sortCount+1;
							}
							String strsort_temp=String.valueOf(sortCount);
							if(st_value.indexOf("Avg")>-1 && st_value.indexOf("Pct")>-1 && st_value.indexOf("Max")  >-1 )
							{
								for (int l=0;l<countTokens;l++)
								{
									if (Fields.equals(""))
									{
										Fields=mes+(l+1);
									}
									else
									{
										Fields+=","+mes+(l+1);
									}
								}
								if(addMapping.equals(""))
								{
									addMapping=mes+"1#"+mes+countTokens;
								}else
								{
									addMapping+=","+mes+"1#"+mes+countTokens;
								}
								JSONArray subheaders=new JSONArray();
								
								String sTxt=" ";													
								if(s_unit!=null && s_unit.indexOf("Number")==-1)
							sTxt=" "+"  ("+s_unit.toLowerCase()+")";
	
								for(int k=0;k < v_val.size(); k++)
								{
								
									String str = (String)v_val.get(k);


									if (str.equals("") || str.equalsIgnoreCase("Wavg"))
									{
									str="Avg";
									}
									if(str.indexOf(",")== -1)
									havingSingleColumn++;
									StringTokenizer st_tok=new StringTokenizer(str,",");

									while (st_tok.hasMoreTokens())
									{

										String token_val=st_tok.nextToken()+"  ("+s_unit.toLowerCase()+")";
										subheaders.add(token_val);
										totalColumnCount++;
										vec1.add(intlmap.getMeasureDescription(componenttest,displayname)+sTxt);  
									}

								}							
								
								
								gridColumnsDetails.put(intlmap.getMeasureDescription(componenttest,displayname)+sTxt,new JSONArray());

								
							}
							else if((st_value.indexOf("Avg")>-1 && st_value.indexOf("Pct")>-1) || (st_value.indexOf("Avg")>-1 && st_value.indexOf("Max")>-1) || (st_value.indexOf("Max")>-1 && st_value.indexOf("Pct")>-1))
							{
								for (int l=0;l<countTokens;l++)
								{
									if (Fields.equals(""))
									{
										Fields=mes+(l+1);
									}
									else
									{
										Fields+=","+mes+(l+1);
									}
								}
								if (addMapping.equals(""))
								{
									addMapping=mes+"1#"+mes+countTokens;
								}
								else
								{
									addMapping+=","+mes+"1#"+mes+countTokens;
								}
								
								if(!displayname.equals(""))
								{
									JSONArray subheaders=new JSONArray();
									String sTxt=" ";
													
								if(s_unit!=null && s_unit.indexOf("Number")==-1)
							sTxt=" "+"  ("+s_unit.toLowerCase()+")";

									for(int k=0;k < v_val.size(); k++)
									{
									
										String str = (String)v_val.get(k);


										if (str.equals("") || str.equalsIgnoreCase("Wavg"))
										{
											str="Avg";
										}
									if(str.indexOf(",")== -1)
									havingSingleColumn++;
										StringTokenizer st_tok=new StringTokenizer(str,",");

										while (st_tok.hasMoreTokens())
										{
											String token_val=st_tok.nextToken()+"  ("+s_unit.toLowerCase()+")";
											subheaders.add(token_val);
											totalColumnCount++;
											vec1.add(intlmap.getMeasureDescription(componenttest,displayname)+sTxt); 
										}
									}
							
								
								
								gridColumnsDetails.put(intlmap.getMeasureDescription(componenttest,displayname)+sTxt,new JSONArray());

								}
								
							}
							else
							{
								for (int l=0;l<countTokens;l++)
								{
									if (Fields.equals(""))
									{
										Fields=mes+(l+1);
									}
									else
									{
										Fields+=","+mes+(l+1);
									}
								}
								if (addMapping.equals(""))
								{
									addMapping=mes+"1#"+mes+countTokens;
								}else
								{
									addMapping+=","+mes+"1#"+mes+countTokens;
								}
								if(!displayname.equals(""))
								{
									JSONArray subheaders=new JSONArray();
									String sTxt=" ";
													
								if(s_unit!=null && s_unit.indexOf("Number")==-1)
							sTxt=" "+"  ("+s_unit.toLowerCase()+")";

									for(int k=0;k < v_val.size(); k++)
									{
									
										String str = (String)v_val.get(k);


										if (str.equals("") || str.equalsIgnoreCase("Wavg"))
										{
										str="Avg";
										}
										if(str.indexOf(",")== -1)
										havingSingleColumn++;
										StringTokenizer st_tok=new StringTokenizer(str,",");

										while (st_tok.hasMoreTokens())
										{
											String token_val=st_tok.nextToken()+"  ("+s_unit.toLowerCase()+")";
											subheaders.add(token_val);
											totalColumnCount++;
											vec1.add(intlmap.getMeasureDescription(componenttest,displayname)+sTxt); 
										}
									}
									
									
									gridColumnsDetails.put(intlmap.getMeasureDescription(componenttest,displayname)+sTxt,new JSONArray());
								}							
							}
							for(int x=0;x< v_val.size();x++)
							{
								v_val1.add(v_val.get(x));
							}														
							v_val = new Vector();
						}


						int fieldsize=1;
						for(int v=0;v<v_val1.size();v++)
						{
							String v_value = (String)v_val1.get(v);
							StringTokenizer tokenizer=new StringTokenizer(v_value,",");
							while(tokenizer.hasMoreTokens())
							{
								String str1=tokenizer.nextToken();
								fieldsize=fieldsize+1;
								if (FieldstoDisplay.equals(""))
								{
									FieldstoDisplay=str1;
								}
								else
								{
									FieldstoDisplay+=","+str1;
								}


							}
						}


				Class [] fieldClassTypes = new Class[fieldsize+1];
						for (int z=0;z<fieldClassTypes.length;z++)
						{
							fieldClassTypes[z]=java.lang.String.class;
						}
						Vector v_pdfdata=new Vector();
						String st_app="";
						if (s_serverVal==null || s_serverVal.equals("-1") || s_serverVal.equals("")|| aListAlltype.contains(s_serverVal))
						{
							
							app_data=value;
						}
						if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
							app_data=value;
						
						for (int z=0;z<app_data.size();z++)
						{
							Vector v_data=(Vector)app_data.get(z);
							String st_check="-";
						JSONArray rowOfdata=new JSONArray();
					//	if(!componenttest.equalsIgnoreCase("RUMAppTest"))						
						//	v_data.remove(1);
							for (int i=0;i<v_data.size();i++)
							{
								String strdata=v_data.get(i).toString();
								if(i==0)
								{
									st_app =strdata;
								}
								if (i==1)
								{
									strdata = (strdata == null || strdata.equals("")||strdata.equals("-5.0"))? "-" : strdata;
								}
								else if (i==2)
								{
									if(strdata.equals("-5.0"))
										st_check=strdata;
									strdata = (strdata == null ||strdata.equals("-")|| strdata.equals("")||strdata.equals("-5.0"))? "-" : strdata;
								}
								else if(i>2)
								{
									strdata = (strdata == null || strdata.equals("")||strdata.equals("-5.0"))? "-" : strdata;
								}
								v_pdfdata.add(strdata);
								String strdata_disp = strdata;
								if(strdata_disp!= null && strdata_disp.indexOf(":NULL")>-1)
									strdata_disp = strdata_disp.substring(0,strdata_disp.indexOf(":NULL"))+strdata_disp.substring(strdata_disp.indexOf(":NULL")+5);
								String lstToAdd=strdata;
								try{
										DecimalFormat df = new DecimalFormat("###");
										if(v_data.size()==i+1 && componenttest!=null && !componenttest.equalsIgnoreCase("RUMGrpTest"))
											df = new DecimalFormat("###.##");
										 double aDouble = Double.parseDouble(lstToAdd);
										 lstToAdd=df.format(aDouble);
									}catch(Exception e)
									{
										
									}
								if (i==0)
								{


									lst_dat1.add(lstToAdd);
									rowOfdata.add(strdata_disp);
								}
								else if (i==2)
								{
									if(strdata_disp.equals("-"))
									{


										lst_dat1.add(lstToAdd);
										rowOfdata.add(strdata_disp);
									}
									else
									{


										lst_dat1.add(lstToAdd);
								 rowOfdata.add(strdata_disp);

									}
								}
								else
								{


									lst_dat1.add(lstToAdd);
								 rowOfdata.add(strdata);

								}
							
							}
								gridDataArray.add(rowOfdata);
							String stg_server = st_app;
							if(s_serverVal!=null&&s_serverVal.equals("-1")&&s_perserver.equals("No"))
							{
								st_app=st_app.substring(st_app.indexOf("/")+2,st_app.length());
							}
							String qryback_Allserver ="../servlet/com.eg.ErCtxRumReportC?isSubmit=true";
							String qryback_perserver ="../servlet/com.eg.ErCtxRumReportC?isSubmit=true";


						}
						TreeMap paramMap = new TreeMap();
						TreeMap pdfData=new TreeMap();
						pdfData.put(pdfKey,v_pdfdata);

						boolean fieldWidthInPercentage = false;
						boolean addFieldWidthInPercentage =true;
						StringTokenizer stfields=new StringTokenizer(Fields,",");
						int [] xCoor = new int [stfields.countTokens()] ;
						int [] yCoor = new int [stfields.countTokens()] ;
						int coorsize=762/stfields.countTokens();
						for (int k=0;k<xCoor.length;k++)
						{
							if (k==0)
							{
								xCoor[k]=0;
								yCoor[k]=5;
							}
							else
							{
								if (k==1)
								{
									xCoor[k]=0;
									yCoor[k]=35;
								}
								else if (k==2)
								{
									xCoor[k]=120;
									yCoor[k]=35;
								}
								else
								{
									xCoor[k]=xCoor[k-1]+coorsize;
									yCoor[k]=35;
								}
							}
						}
						int size=752/(stfields.countTokens());
						int [] fieldWidth = new int [stfields.countTokens()] ;
						int [] fieldHeight= new int [stfields.countTokens()];

						for (int l=0;l<fieldWidth.length;l++)
						{
							if (l==0)
							{
								fieldWidth[l]=752;
								fieldHeight[l]=10;
							}else
							{
								fieldWidth[l]=size;
								fieldHeight[l]=10;
							}
						}

						StringTokenizer staddfields=new StringTokenizer(AddFieldsDisplay,",");
						int [] addFieldWidth = new int [staddfields.countTokens()] ;
						int [] addFieldHeight= new int [staddfields.countTokens()];
						int [] addXCoor = new int [staddfields.countTokens()] ;
						int [] addYCoor = new int [staddfields.countTokens()] ;
						int addwidth=0;
						int addcoorsize=762/staddfields.countTokens();
						if(staddfields.countTokens()>0)
						{
							addwidth=100/staddfields.countTokens();
						}
						else
						{
							addwidth=10;
						}

						for(int k=0;k<addFieldWidth.length;k++)
						{
							addFieldWidth[k]=addwidth;
							addFieldHeight[k]=10;
						}
						int [] lineXCoor = new int [] {0, 0, 0};
						int [] lineYCoor = new int [] {15, 48, 10};
						int [] bandHeight = new int [] {49, 20, 35};
						paramMap.put("fields", Fields);
						paramMap.put("display", FieldstoDisplay);
						paramMap.put("addDisplay", AddFieldsDisplay);
						paramMap.put("addMapping", addMapping); //must
						paramMap.put("dataBag", pdfData);
						paramMap.put("pageLayout", "Landscape");
						paramMap.put("rowSize", new Integer(xCoor.length-1));//must
						paramMap.put("xCoor", xCoor);
						paramMap.put("lineXCoor", lineXCoor);
						paramMap.put("lineYCoor", lineYCoor);
						paramMap.put("bandHeight", bandHeight);
						paramMap.put("fieldWidth", fieldWidth);//must
						paramMap.put("fieldHeight", fieldHeight);
						paramMap.put("fieldClassTypes", fieldClassTypes);
						paramMap.put("addFieldClassTypes", addFieldClassTypes);
						paramMap.put("fieldWidthInPercentage", new Boolean(fieldWidthInPercentage));
						paramMap.put("addFieldWidthInPercentage", new Boolean(addFieldWidthInPercentage));

						Vector vdata=new Vector();
						Vector extraparam=new Vector();
						extraparam.add("Application Report");
						extraparam.add("From	 "+erd.s_stdate+" hrs "+""+" To "+erd.s_enddate+"  hrs");
						vdata.add(paramMap);
						vdata.add(extraparam);
						Hashtable ht_pdfdata=new Hashtable();
						ht_pdfdata.put("commandName","DynamicTest");
						ht_pdfdata.put("pdfData",applnPdfData);
						ht_pdfdata.put("pdfFileName","RUM_REPOTRS");
						session.setAttribute("sessionVal", ht_pdfdata);
						HashMap param =new HashMap();
						param.put("REPORT_PARAM",ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap())));
						param.put("REPORT_DATA",applnPdfData);
						session.setAttribute("parameters", param);
						//gridObj.put("units",unitForMeasure);
						
						gridObj.put("columns",gridColumnsDetails);
						gridObj.put("dataArray",gridDataArray);
						gridObj.put("TOTAL_COLUMN_COUNT",String.valueOf(totalColumnCount));
						gridObj.put("SINGLE_SUBCOLUMN_COUNT",										String.valueOf(havingSingleColumn));
						reportDataJson.put("GridObj"+gg,gridObj);
						
						reportDataArray.add(gridObj);
						}
					}
					
					}
				}
				rootJson.put("reportData",reportDataArray);
			}
			
		}
		else if(app_topusers!=null && app_topusers.size() > 0 || s_server.equals("-1")||app_topusers!=null && app_topusers.size() > 0 ||!s_server.equals("-1"))
		{
		}
	} //Graph View start here
		else if(v_qry_string!=null&&v_qry_string.size()>0)
	{

		JSONObject reportDataJson = new JSONObject();
		JSONArray chartUrls = new JSONArray();

		int count = 0;
		String s_title="";
		int flag=0;
		
		for(int ii=0;ii<s_farmServerAL.size();ii++)
		{
			String sel_Farms=(String)s_farmServerAL.get(ii);
			if(v_qry_string !=null)
			{
				for(int k=0;k<v_qry_string.size();k+=2) //New Fix
				{
					s_title = (String)v_qry_string.get(k);
					if(s_title.length() > 44)
					{
						flag++;
					}
				}
			}
			String Str_test ="";
			String Str_mes ="";
			String Str_units="";
			if(v_qry_string != null && v_qry_string.size() > 2)
			{

				String st_qryString = "";
				Vector  sqry = new Vector();
				sqry.add("opt");
				sqry.add("rtype");
				sqry.add("chartFor");
				for(int i=0;i<v_qry_string.size();i+=4)
				{
					s_title= (String)v_qry_string.get(i);
					if(s_title.indexOf("*")>-1)
						s_title = s_title.replace('*','%');
					st_qryString = (String)v_qry_string.get(i+1);
					//Adding the title and the URL of the image for saving to PDF
					count++;
					String theWidth = "";
					String theHeight = "";

					String isPie = reportInfo.getChartTypeForDist("APPLICATION_REPORT");
					if(isPie!=null && isPie.equalsIgnoreCase("Pie"))
					{
						theWidth = "740";
						theHeight = "250";
					}
					else
					{
						theWidth = "740";
						theHeight = "380";
					}
	

					st_qryString = st_qryString;
					String queryString = "";
					String 	queryStringdata="";
					String controlfile = st_qryString.substring(0,st_qryString.indexOf("?"));
					st_qryString = st_qryString.substring(st_qryString.indexOf("?")+1);
					HashMap param  = ErUtils.parseQueryString(st_qryString);
					
					Set s_param = param.keySet();
					Iterator i_param = s_param.iterator();
					
					while(i_param.hasNext())
					{
						String st_key = (String)i_param.next();
						
						
						
						
						if(!st_key.equalsIgnoreCase("select_farm") && !st_key.equalsIgnoreCase("er_server")&& !st_key.equalsIgnoreCase("er_workgroupserver"))
						{
							
							String value = "";
							try
							{
								value = (String)param.get(st_key);
							}catch(Exception er)
							{
									String valueArr[]=(String[]) param.get(st_key);
									if(valueArr!=null && valueArr.length>1)
										value = (String)valueArr[0];
							}
							
							if(st_key!=null&&st_key.equals("er_test"))
							{
								Str_test = value;
							}
							else if(st_key!=null&&st_key.equals("er_meas"))
							{
								Str_mes=value;
							}
							if(!sqry.contains(st_key))
							{
								queryStringdata+=st_key+ "=" + URLEncoder.encode(value) + "&";
							}
							if(st_key!=null&&st_key.equals("select_farm"))
							{
								queryString+=st_key+ "=" + EgURLEncoder.encode(value,"UTF-8") + "&";
							}
							else
							{
								queryString+=st_key+ "=" + URLEncoder.encode(value) + "&";
							}
						}
						else if(st_key.equalsIgnoreCase("er_server"))
						{
							try{						
						
							String[] vale= (String[])param.get(st_key);
							
							for(int z=0;z<vale.length;z++)	
								queryString+=st_key+ "=" + EgURLEncoder.encode(vale[z],"UTF-8") + "&";
								
							}catch(Exception e)
							{
								String value = (String)param.get(st_key);
								if(st_key!=null&&st_key.equals("er_server"))
								{
									queryString+=st_key+ "=" + EgURLEncoder.encode(value,"UTF-8") + "&";
								}
							}
						}
						else if(st_key.equalsIgnoreCase("er_workgroupserver"))
						{
							try{						
						
							String[] vale= (String[])param.get(st_key);
							
							for(int z=0;z<vale.length;z++)	
								queryString+=st_key+ "=" + EgURLEncoder.encode(vale[z],"UTF-8") + "&";
								
							}catch(Exception e)
							{
								String value = (String)param.get(st_key);
								if(st_key!=null&&st_key.equals("er_workgroupserver"))
								{
									queryString+=st_key+ "=" + EgURLEncoder.encode(value,"UTF-8") + "&";
								}
							}
						}						
					}				
					
					queryString+="select_farm=" + EgURLEncoder.encode(sel_Farms,"UTF-8");

					Str_units = tablesInfo.getUnitForMeasure(Str_test,Str_mes);
					if(s_title!=null && s_title.equals("Number of unique users"))
					{
						s_title = intlmap.getTextDescription("reporter.common."+s_title) + " (Number)";
					}
					else
					{
						s_title = s_title + " ("+Str_units+")";
						//s_title =intlmap.getTestDescription(s_title.substring(0,s_title.indexOf("/")))+"/"+intlmap.getMeasureDescription(s_title.substring(0,s_title.indexOf("/")),s_title.substring(s_title.indexOf("/")+1,s_title.indexOf("(")));
					}
					queryString = controlfile+"?"+queryString+"&startmin="+strmin+"&endmin="+enmin;
					queryStringdata = queryStringdata+"&startmin="+strmin+"&endmin="+enmin +"er_sortby=-1&optt=data&dataFor=distribution";

					session.setAttribute("distQryData",queryStringdata);
					reportDataJson.put("title",rep_title);
					if(s_title.indexOf("/")>-1)
						s_title=s_title.substring(s_title.indexOf("/")+1);
					reportDataJson.put("sub_titile",s_title);	

					queryString=queryString+"&startdate="+s_st_time+"&enddate="+s_en_time+"&starthr="+s_st_hr+"&endhr="+s_en_hr;
					//chartUrls.add(queryString+"&er_width=620&er_height=250&er_align=left&optt=graph&er_view=APPLET");
	
					
					if(v_qry_string.size() != (i + 2))					
					{
						theWidth = "740";
						theHeight = "380";
						s_title=(String)v_qry_string.elementAt(i+2);
						if(s_title.indexOf("*")>-1)
						s_title = s_title.replace('*','%');
						s_qryString = (String)v_qry_string.elementAt(i+3);
						String ertest = request.getParameter("er_test");
						String ermeas = request.getParameter("er_meas");
						String 	query_String="";
						controlfile = s_qryString.substring(0,s_qryString.indexOf("?"));
						query_String = s_qryString.substring(s_qryString.indexOf("?")+1);
						String qrydata = "";
						param  = ErUtils.parseQueryString(query_String);
						
						HashMap param1  = ErUtils.parseQueryString(query_String);						
					
						param1.remove("select_farm");
							param1.put("select_farm",URLEncoder.encode(sel_Farms));
						query_String  = ErUtils.prepareQueryString(param1);
						s_param = param.keySet();
						i_param = s_param.iterator();
						String Tinfos[]=null;
						String er_test="";
						String er_meas="";

						while(i_param.hasNext())
						{
						
							String st_key = (String)i_param.next();
						if(!st_key.equalsIgnoreCase("select_farm") && !st_key.equalsIgnoreCase("er_server")&& !st_key.equalsIgnoreCase("er_workgroupserver"))
						{
							String value = "";
							try
							{
								value = (String)param.get(st_key);
							}catch(Exception er)
							{
									String valueArr[]=(String[]) param.get(st_key);
									if(valueArr!=null && valueArr.length>1)
										value = (String)valueArr[0];
							}

							if(st_key.equals("er_test"))
								er_test = value;

							if(st_key.equals("er_meas"))
								er_meas = value;

							if(!sqry.contains(st_key))
							{
								qrydata+=st_key+ "=" + URLEncoder.encode(value) + "&";
							}
						}
						else
						{
							try{						
						
							String[] vale= (String[])param.get(st_key);
							
							for(int z=0;z<vale.length;z++)	
								qrydata+=st_key+ "=" + EgURLEncoder.encode(vale[z],"UTF-8") + "&";
								
							}catch(Exception e)
							{
								String value = (String)param.get(st_key);
								if(st_key!=null&&st_key.equals(st_key))
								{
									qrydata+=st_key+ "=" + EgURLEncoder.encode(value,"UTF-8") + "&";
								}
							}
						}
						}

						Str_units = tablesInfo.getUnitForMeasure(er_test,er_meas);
						if(s_title!=null && s_title.equals("Number of unique users"))
						{
							s_title = s_title + " (Number)";
						}
						else
						{
							s_title = s_title + " ("+Str_units+")";
						}
						query_String = controlfile+"?"+query_String;
						qrydata = qrydata +"er_sortby=-1&optt=data";
						//Adding the title and the URL of the image for saving to PDF
						count++;
						session.setAttribute("topQryData",qrydata);
					
						//chartUrls.add(chartUrls.size()-1,query_String+"&startmin="+strmin+"&endmin="+enmin + "&er_width=" + theWidth + "&er_height=" + theHeight + "&er_align=center&optt=graph&er_view=APPLET");
						chartUrls.add(query_String+"&startmin="+strmin+"&endmin="+enmin + "&er_width=" + theWidth + "&er_height=" + theHeight + "&er_align=center&optt=graph&er_view=APPLET");


	

					}
	
	
	

				}
	

			}
			}
		HashMap param =new HashMap();
		param.put("REPORT_PARAM",ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap())));
		param.put("REPORT_DATA",pdfQuery);
		param.put("fileName","ApplicationActivityReport");
		session.setAttribute("parameters", param);
		reportDataJson.put("chartUrls",chartUrls);
		rootJson.put("reportData",reportDataJson);

	}
	int pageWidthProces=1024;
	pageWidthProces=(totalspan * 82)+250;
	
	if(rtype!=null&&!rtype.equals("Yes"))
	{
		hiddenfieldsJson.put("pageWidth",""+pageWidthProces);
		//--start-- For bug ID 9515
		hiddenfieldsJson.put("pageWidthProces",""+pageWidthProces);
		//--End--
	}
	
	
	session.setAttribute("htdat",htt);
	session.setAttribute("titleToDisplay",titleVc);
	session.setAttribute("select_farms",select_farms);


	sen1 = new Hashtable();
	if(lst_dat1!=null && !lst_dat1.isEmpty())
	{
	
			
			sen1.put(vec1,lst_dat1);
			
			
			ht1=new Hashtable();
			ht1.put(s_tit1,sen1);
			
			String s_serverDisp=s_server;
			if(s_serverDisp!=null && s_serverDisp.indexOf(":")>-1)
				s_serverDisp=s_serverDisp.substring(0,s_serverDisp.indexOf(":"));
			lst.add(intlmap.getTextDescription("reporter.common.RUM Report for Component")+" - "+s_serverDisp);
			
			lst.add(ht1);
			
			//lst.add(lst_dat3.get(i));
			sen1 = new Hashtable();
			ht1 = new Hashtable();
		
		
	
		session.setAttribute("list",lst);
	}
	else 
	{
		session.setAttribute("list",lst);
	}

	String processVal="";
	String strtestmes =testmes;
	if(testmes!=null && testmes.length()>0)
		strtestmes = EgURLEncoder.encode(testmes,"UTF-8");
	if(rtype!=null && rtype.equals("Yes")) {
		processVal="&printGraph=yes&opt=chart&uid="+EgURLEncoder.encode(loginid,"UTF-8")+ "&select_testmes=" +strtestmes+"&er_type=yes&er_sortby=-1";
	} else {
		processVal="&er_view=PRINT&";
	}
	String[] strEncodeselect_farm = (String[])request.getParameterValues("select_farm");
	String strTime = request.getParameter("startdate");
	String enTime = request.getParameter("enddate");
	String strEncodeselect_Farmm = "&select_farm=";
	
	if(strEncodeselect_farm!=null)
	{
		for(int l=0;l<strEncodeselect_farm.length;l++)
		{
			String s=strEncodeselect_farm[l];
			if(s != null)
				strEncodeselect_Farmm += "&select_farm="+EgURLEncoder.encode(s,"UTF-8");
		}
	}else
	{
		strEncodeselect_Farmm = "&select_farm=";
	}
	String strEncodetimeline = timeline;
	if(timeline != null)
		strEncodetimeline = EgURLEncoder.encode(timeline,"UTF-8");
	String strEncodestrTime = strTime;
	if(strTime != null)
		strEncodestrTime = EgURLEncoder.encode(strTime,"UTF-8");
	String strEncodeenTime = enTime;
	if(enTime != null)
		strEncodeenTime = EgURLEncoder.encode(enTime,"UTF-8");
	String strEncodeer_server = request.getParameter("er_server");
	if(request.getParameter("er_server") != null)
		strEncodeer_server = EgURLEncoder.encode(request.getParameter("er_server"),"UTF-8");
	String strEncodesel_mes = "";
	if(request.getParameter("select_testmes") != null)
		strEncodesel_mes = EgURLEncoder.encode(request.getParameter("select_testmes"),"UTF-8");

	if(strTime !=null && enTime !=null){


		
		String qStrng =(String)ErUtils.prepareQueryString(request.getParameterMap());		
				String Qstring="";
		if(qStrng!=null)
		{
			StringTokenizer strtok = new StringTokenizer(qStrng,"&");
			while(strtok.hasMoreTokens())
			{
				String param = strtok.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0 || param.indexOf("responseType")>-1)
					continue;
				String reqparam =param.substring(0,ind);
				String value = param.substring(ind+1);
				
				if(reqparam!=null&&reqparam.equals("er_timeline"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("limitforbg"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_RmDispName"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_priority"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_rep"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("select_farm"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_userid"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_user"))
				{
					value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
				}
				if(reqparam!=null&&reqparam.equals("er_application"))
				{
					value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
				}
				if(reqparam!=null&&reqparam.equals("er_sortby"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("uid"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") ) )
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				

				Qstring=Qstring+reqparam+"="+value+"&";
			}
			
		}
		String mailurl= mngrIProc+"/final/servlet/com.eg.ErCtxRumReportC;jsessionid="+session.getId()+"?"+Qstring+"&printGraph=yes&er_view=PRINT";
		if(rtype!=null&&!rtype.equals("Yes"))
		{
			mailurl+="&pageWidthProces="+pageWidthProces;
		}
		session.setAttribute("MAIL_URL",mailurl);

	}



Map parameters = new HashMap();
parameters= request.getParameterMap();
String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());


String Qstring="";
if(queryString!=null)
{
	StringTokenizer strtok = new StringTokenizer(queryString,"&");
	while(strtok.hasMoreTokens())
	{
		String param = strtok.nextToken();
		int ind = param.indexOf("=");
		if (ind < 0 || param.indexOf("responseType")>-1)
			continue;
		String reqparam =param.substring(0,ind);
		String value = param.substring(ind+1);
		
		
		if(reqparam!=null&&reqparam.equals("select_farm"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("er_userid"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("er_user"))
		{
			value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
		}
		if(reqparam!=null&&reqparam.equals("er_application"))
		{
			value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
		}
		if(reqparam!=null&&reqparam.equals("uid"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") ) )
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("showLegend"))
		{
			rootJson.put("showLegend",value);
		}

		Qstring=Qstring+reqparam+"="+value+"&";
	}
	//Qstring+="pageWidth="+pageWidthProces;
	rootJson.put("saveQString",Qstring);
	
}
session.setAttribute("PDF_URL", mngrIProc+"/final/servlet/com.eg.ErCtxRumReportC;jsessionid="+session.getId()+"");
//Back button - Start
ArrayList listbackvar = new  ArrayList();
if(request.getParameter("isSubmit")!=null)
{
	listbackvar.add("/servlet/com.eg.ErCtxRumReportC?");
	listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
	session.setAttribute("favSchBackDisplay","Yes");
}
else
{
	listbackvar.add("ErCtxUserActivityReport.jsp");
	listbackvar.add(queryString);
	session.setAttribute("favSchBackDisplay","No");
}
	session.setAttribute("reportLastAccessedURL","/final/reporter/ErRumReport.jsp?"+Qstring);

	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);

//Back button - End

//method for removing the VM name form username
	rootJson.put("hiddenfields",hiddenfieldsJson);
	rootJson.put("screenLabels",screenLabelJson);
	out.println(rootJson.toString());
	

}catch(Throwable t)
{t.printStackTrace();}


    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
