package org.apache.jsp.reporter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import egurkha.reporter.*;
import java.util.Date;
import java.util.*;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import com.eg.ErDbServer;
import egurkha.*;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.egurkha.ini.*;
import com.eg.EgDateInfo;
import com.eg.EgTopoInfo;
import com.eg.EgGroupInfo;
import com.eg.EgReportInfo;
import com.egurkha.*;
import java.util.*;
import java.io.*;
import java.sql.*;
import egurkha.*;
import egurkha.reporter.*;
import com.egurkha.*;
import com.egurkha.ini.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import java.net.*;
import com.eg.EgThresholdInfo;
import com.eg.EgTablesInfo;
import com.eg.EgMappingInfo;
import java.net.URLEncoder;
import java.net.URLDecoder;
import com.eg.EgURLEncoder;
import com.egurkha.util.DateTimeTokenizer;
import com.egurkha.util.DateUtil;
import com.egurkha.util.StringUtils;
import com.eg.MappingNameSorter;
import com.eg.EgName;
import java.text.*;
import com.eg.EgConfigInfo;
import net.sf.json.*;
import java.util.*;
import java.text.*;
import com.eg.EgReportInfo;
import com.eg.EgDateInfo;
import com.egurkha.util.*;

public final class ErJsErrorReportJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

 
	public JSONArray getLastCalenJson(List weekList) {
		JSONArray tmpJsonArr=new JSONArray();
		JSONObject timelineJSON = new JSONObject();	
		String tmpTimeLine = null;
		String viewField=null;			
		for(int x=0;x<weekList.size();x++){
			tmpTimeLine = (String)weekList.get(x);	
			int spaceCount = 0;	
			for(int y=0; y<tmpTimeLine.length();y++){				
				char ch = tmpTimeLine.charAt(y);
				if(ch== ' '){
				   spaceCount++; 
				}
			}
			if(spaceCount > 1){
				//Last 2 weeks    weeks_last 2
				String countStr = tmpTimeLine.substring(tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = tmpTimeLine.substring(tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.length());
				String last = tmpTimeLine.substring(0, tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr +" "+ end + "_" + last;				
			}else{
				viewField = "1 "+tmpTimeLine.substring(tmpTimeLine.lastIndexOf(" ")+1, tmpTimeLine.length())  + "_" + tmpTimeLine.substring(0, tmpTimeLine.indexOf(" "));				
			}			
			timelineJSON.put("displayField",tmpTimeLine);
			timelineJSON.put("valueField", viewField.toLowerCase());
			tmpJsonArr.add( timelineJSON );		
		}		
		return tmpJsonArr;
   } 


	public List<String> getLastWeekMonthList(String currentDateFormat, User user, String timeLine, boolean isZoneType){
		EgDateInfo egDt = new EgDateInfo();
		List<String> lastWeekList = new ArrayList<String>();
		String startDate = null;
		String endDate = null;
		int count = Integer.parseInt(timeLine.substring(0, timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)));
		String unit = timeLine.substring(timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,timeLine.length());
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		java.util.Date today = egDt.egetRealDate();
		String currentDateTime = sdf.format(today);
		String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
		String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
		String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1,currentDateTime.lastIndexOf(":"));
		String time = " "+currentHr+":"+currentMin;
		String curFormatDate  = DateUtil.changeDateFormat(currentDate, "MM/dd/yyyy", currentDateFormat);		
		String userFormat = user.getUserDateFormat();
		try{
			java.util.Date realDate = null;
			if(!isZoneType){
				EgTimeZoneConverter tmZoneConverter = new EgTimeZoneConverter(curFormatDate+time,user);				
				realDate = new SimpleDateFormat(userFormat).parse(tmZoneConverter.getDateTime());
				sdf = new SimpleDateFormat(userFormat);
			}else{
				realDate = new SimpleDateFormat(userFormat).parse(curFormatDate);
			}
					
			Calendar c = Calendar.getInstance();
			c.setTime(realDate);
			if(unit.startsWith("we")){
				int weekCount = count;
				int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
				int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
				int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
				c.add(Calendar.DATE, - i - startDayCount);
				startDate = sdf.format(c.getTime());
				c.add(Calendar.DATE, lastDayCount);	
				endDate = sdf.format(c.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));					
				}															
			}else if(unit.startsWith("mo")){
				int monthCount = count;
				c.add(Calendar.MONTH, -monthCount);
				c.set(Calendar.DATE, 1);
				startDate = sdf.format(c.getTime());				
				
				Calendar c1 = Calendar.getInstance();
				c1.setTime(realDate);
				c1.add(Calendar.MONTH, -1);
				c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
				endDate = sdf.format(c1.getTime());
				if(isZoneType){
					startDate = startDate.substring(0, startDate.indexOf(DateTimeTokenizer.BLANK_SPACE));
					endDate = endDate.substring(0, endDate.indexOf(DateTimeTokenizer.BLANK_SPACE));	
				}
			}else{}
			lastWeekList.add(startDate);
			lastWeekList.add(endDate);
		}catch(Exception e){
			e.printStackTrace();
		}
		return lastWeekList;
	}


	public Vector getPriorityValues(int maxInfo)
	{		
		Vector v_show=new Vector();
		v_show.add("TOP  - " +maxInfo/4);
		v_show.add("TOP  - " +maxInfo/2);
		v_show.add("TOP  - " +maxInfo);
		v_show.add("ALL");
		return v_show;
	}
	public JSONArray getGraphTypeValues(EgMappingInfo intlmap)
	{
		JSONArray graphTypeArray =  new JSONArray();
			JSONObject loopJsonObj=new JSONObject();
			loopJsonObj.put("displayField", "Distribution");
			loopJsonObj.put("valueField", "distribution");
			graphTypeArray.add(loopJsonObj);
			loopJsonObj=new JSONObject();
			loopJsonObj.put("displayField", "Timeline");
			loopJsonObj.put("valueField", "timeline");
			graphTypeArray.add(loopJsonObj);
		return graphTypeArray;
	}
	public JSONArray geWeightedAvgComboValues(EgMappingInfo intlmap,EgReportInfo reportInfo,String strSelectedCompType)
	{
		JSONArray weightedArray =  new JSONArray();
		JSONObject loopJsonObj = new JSONObject();	
		String str=(String)reportInfo.getValue("JAVASCRIPT_ERROR",strSelectedCompType+":GroupBy");
		
		
		if(str!=null && str.indexOf(",")>-1)
		{
			StringTokenizer strtok = new StringTokenizer(str,"&");
			while(strtok.hasMoreTokens())
			{
				String val = strtok.nextToken();
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+val));
				loopJsonObj.put("valueField", val);
				weightedArray.add(loopJsonObj);
			}				
		}
		
		return weightedArray;
	}
	public JSONArray getExcludeWeekValues(EgMappingInfo intlmap)
	{
		JSONArray exclweekArray  =  new JSONArray();
		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		exclweekArray.add(loopJsonObj);
		
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		exclweekArray.add(loopJsonObj);
		return exclweekArray;
	}
	public JSONArray getExcludeWeekComboValues(EgMappingInfo intlmap)
	{
		JSONArray exclweekArray  =  new JSONArray();
		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Yes"));
		loopJsonObj.put("valueField", "Yes");
		exclweekArray.add(loopJsonObj);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
		loopJsonObj.put("valueField", "No");
		exclweekArray.add(loopJsonObj);
		return exclweekArray;
	}
	public JSONArray getReportTypeComboValues(EgMappingInfo intlmap)
	{
		JSONArray reporttypeArray =  new JSONArray();

		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Graph"));
		loopJsonObj.put("valueField", "Yes");
		reporttypeArray.add(loopJsonObj);

		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.thin.Data"));
		loopJsonObj.put("valueField", "No");
		reporttypeArray.add(loopJsonObj);	
		return reporttypeArray;
	}
	public JSONArray getReportGenerationComboValues(EgMappingInfo intlmap,String strbackground,String strforeground)
	{
		JSONArray reportGenerationComboArray =  new JSONArray();
		JSONObject tmpobj=new JSONObject();
		tmpobj.put("displayField", strbackground);
		tmpobj.put("valueField", "background");
		reportGenerationComboArray.add(tmpobj);
		tmpobj=new JSONObject();
		tmpobj.put("displayField", strforeground);
		tmpobj.put("valueField", "foreground");
		reportGenerationComboArray.add(tmpobj);
		return reportGenerationComboArray;
	}
	public JSONArray getReportGenTypeCombo(EgMappingInfo intlmap)
	{
		JSONObject tmpobj=new JSONObject();
		JSONArray viewApplnCombo =  new JSONArray();
		tmpobj=new JSONObject();
		tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.Summary"));
		tmpobj.put("valueField", intlmap.getTextDescription("reporter.common.Summary"));
		viewApplnCombo.add(tmpobj);
		tmpobj=new JSONObject();
		tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.Details"));
		tmpobj.put("valueField", intlmap.getTextDescription("reporter.common.Details"));
		viewApplnCombo.add(tmpobj);
		return viewApplnCombo;
	}
	public JSONArray getReportForComboValues(EgMappingInfo intlmap)
	{
		JSONObject tmpobj=new JSONObject();
		JSONArray viewApplnCombo =  new JSONArray();
		tmpobj=new JSONObject();
		tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.RUM Report"));
		tmpobj.put("valueField", "RUM");
		viewApplnCombo.add(tmpobj);
		tmpobj=new JSONObject();
		tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.Error Report"));
		tmpobj.put("valueField", "Error");
		viewApplnCombo.add(tmpobj);
		return viewApplnCombo;
	}
	public int getValueFromINI()
	{
		JSONArray groupFieldMp=new JSONArray();
		groupFieldMp.add("RUMCityTest");
		groupFieldMp.add("RUMCountryTest");
		groupFieldMp.add("RUMRegionTest");
		groupFieldMp.add("RUMBrowserTest");
		groupFieldMp.add("RUMDeviceTest");
		groupFieldMp.add("RUMAppTest");
		groupFieldMp.add("RUMGrpTest");
		groupFieldMp.add("RUMPageTypeTest");	
		String iniValue="";
		int maxTImeLineVal=7;
		String installDir = EgInstallInfo.getInstallDir();
		IniFile inifile = new IniFile(installDir + "/manager/config/eg_format.ini");
		try{
			for(int i=0;i<groupFieldMp.size();i++)
			{
				String comp=(String) groupFieldMp.get(i);
				iniValue = inifile.getValue("DDD_CLEANUP", ""+comp+"");
				if(iniValue!=null && iniValue.length()>0)
				{
					int curValue=(int) Integer.parseInt(iniValue);
					if(maxTImeLineVal<curValue)
						maxTImeLineVal=curValue;
				}
			}
		}catch(Exception e)
		{	
		}		
		return maxTImeLineVal;		
	}
		

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/reporter/ErReporterTracker.jsp");
    _jspx_dependants.add("/reporter/ErTimeFormatJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/************************************************************************************************
* File				: ErJsErrorReportJson.jsp
* Purpose			:	Displays the configured measures and its details for the Javascript Error Reorts
* Creation Date	:	9/12/2014
*
*************************************************************************************************/


//	response.setHeader("Cache-Control","no-store");
//	response.setHeader("Pragma","no-cache");
//	response.setDateHeader ("Expires", -1);
	
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	String imageName = null;
	IniUI egui = IniUI.getInstance();
	imageName = egui.getReporterHomeLogo();
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String reporter_Skin = null;

	boolean id_u = false;
	boolean isLastTimeLine = false;
	String urs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	UserRegistry registry= null;
	User thisuser=null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	String usr_Id_proc = request.getParameter("er_userid");
	String usr_Id = request.getParameter("eruserid");
	String userID = request.getParameter("userID");
	if(session!=null)
	{
		 UBean = (ErUserData) session.getAttribute("UBean");
		 if(throughSchedule.equalsIgnoreCase("true")) {
			 try
			 {
			if(UBean == null) {
				if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id,false);
					usr_Id_proc = usr_Id;
				}
				else if(userID != null){
					UBean = new ErUserData(userID,false);
					usr_Id_proc = userID;
				}
				else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null")){
					UBean = new ErUserData(usr_Id_proc,false);
				}
				else{
					UBean = new ErUserData(usr_Id_proc,false);
				}

			}
			}
			catch(Throwable t)
			{
			t.printStackTrace();
			}
		}
		if(UBean != null)
		{
			registry = UserRegistry.getInstance();
			thisuser= registry.getUser(session.getId(),true);
			if(thisuser!=null)
			{
				id_u = thisuser.isIdDeletedWhileLoggedIn();
				if(id_u==false )
				{
					urs = thisuser.getLoginID();
					if(!User.isDefaultUser(urs))
					{
						u_v_till = UBean.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
			if(thisuser == null && usr_Id_proc!= null ) {
				try {
					thisuser = UBean.getUser(usr_Id_proc);
					registry.setUser(session.getId(), thisuser, false);
					System.out.println("Setting user object. user reporter skin : " + thisuser.getReporterSkin());
				} catch(Exception ex) {
					System.out.println("Setting user object failed");
					ex.printStackTrace();
				}
			}
		}
	}
	if(session == null || thisuser == null)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");		
	}
	else if(id_u== true)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		response.sendError(500,"session invalid exception");
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}

	if(session!=null && UBean != null && thisuser!=null)
	{
		//session.putValue("Page_IdentifierR",request.getRequestURI());	
		String pageName = request.getRequestURI();
		if(!pageName.endsWith("ErMeasureData.jsp") && !pageName.endsWith("ErMeasure.jsp") && !pageName.endsWith("ErPrintReport.jsp") && !pageName.endsWith("ErPrintDataReport.jsp") && !pageName.endsWith("ErComparisonData.jsp") && !pageName.endsWith("ErMacroData.jsp") && !pageName.endsWith("ErCtxUserGraph.jsp") && !pageName.endsWith("ErMacroPrint.jsp") && !pageName.endsWith("ErHomePrint.jsp"))
		{
			//session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
		}
	}
	

	if (thisuser!=null)
	{
		String trackerUserLang = thisuser.getLanguage();
		thisuser.setUserLanguageAndSkins();
		reporter_Skin  = thisuser.getReporterSkin();

		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	//Added by Sakthivel - 26/03/2008
	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
	//Variable to be used in javascript code
	String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(thisuser!=null)
	{
		currentDateFormatForJS = thisuser.getUserDateFormat();
	}
	String strUserDateFormat =currentDateFormatForJS;
	if(currentDateFormatForJS.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormatForJS.length();i++)
		{
			if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
			{
				currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
			}
		}
	}
	egurkha.reporter.ErBackgroundReportGenerator erbgreport = new egurkha.reporter.ErBackgroundReportGenerator();
	String strArray[] =erbgreport.getSelection(urs);
	String strforeground = strArray[0];
	String strbackground =  strArray[1];
	String bgString="'";


	
	String titleToDisplay=request.getParameter("er_RmDispName");					

	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabelJson = new JSONObject();
	JSONObject hiddenfieldsJson=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();
	JSONObject selectionDetails=new JSONObject();
	JSONObject selectionDetailsForXl=new JSONObject();

	
	String isSubmit=request.getParameter("isSubmit");
	String rep_genType=request.getParameter("rep_genType");
	String s_uisort=request.getParameter("er_uisortby");
	String show_timeinuse = request.getParameter("sh_timeinuse");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String schedule_id = request.getParameter("schedule_id");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");
	String divStatus = request.getParameter("divStatus");
	String searchUser = request.getParameter("er_tapplication");
	String s_server = request.getParameter("er_server");
	String rtype =request.getParameter("er_type");
	String strSelectedCompType = request.getParameter("er_comptype");
	String priority=request.getParameter("er_priority");	
	String componenttest = request.getParameter("componenttest");
	String isreportsneedService = request.getParameter("isreportsneedService");
	String s_serverArr[] = (String[])request.getParameterValues("er_server");
	String s_farmserver = (String)request.getParameter("select_farm");
	String s_farmserverAr[] = (String[])request.getParameterValues("select_farm");
		
	ArrayList s_farmServerAL=new ArrayList();
	ArrayList s_serverAL=new ArrayList();
	if(s_serverArr!=null)
	{
		for(int i=0;i<s_serverArr.length;i++)
		{
			s_serverAL.add((String)s_serverArr[i]);
		}
	}	
	if(s_farmserverAr!=null)
	{
		for(int i=0;i<s_farmserverAr.length;i++)
		{
			s_farmServerAL.add((String)s_farmserverAr[i]);
		}
	}	
	if (rtype==null)
	{
		rtype="Yes";
	}
	if(s_uisort == null || s_uisort.equals(""))
	{
		s_uisort = "1";
	}
	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	MappingNameSorter sorter = new MappingNameSorter(thisuser.getLanguage());
	ErUtils erUtils = new ErUtils();
	ErInfo erInfo = new ErInfo();
	EgReportInfo reportInfo=new EgReportInfo("manager");
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	EgThresholdInfo hreshholdInfo = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ErReportHelper er_helper = new ErReportHelper();
	

	String installDir = EgInstallInfo.getInstallDir();
	Vector v_comp=UBean.getAllUserComponents(3);
	Vector v_server=new Vector();
	boolean present=false;
	IniFile inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	EgGroupInfo gpinfo = new EgGroupInfo();
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	
	String loginid = this_user.getLoginID();
	Vector dispzone=new Vector();
	List zonelist = this_user.getZones();
	List serviceList = this_user.getSites();
	ArrayList aListCompType = new ArrayList();
	ArrayList aListAlltype = new ArrayList();
	Vector v_components = UBean.getAllUserComponents(3);
	Vector v_component = new Vector();
	Vector v_temp = new Vector();
	Vector defComps = new Vector();
	Vector colZoneComps = new Vector();
	Vector v_comptype=new Vector();
	Vector v_tmp = new Vector();
	Vector v_infos=null;
	StringTokenizer st;
	String tmpComponent="";
	String sub = "MISC";
	String var = "CtxServer";
	String value1 = inifile.getValue(sub,var);
	boolean termpresent=false;
	
	String ConstantDispNameDisp=(String)reportInfo.getValue("JAVASCRIPT_ERROR","ConstantDispName");
	String ConstantDispName="--"+ConstantDispNameDisp+"--";
	ArrayList aListSupportedComponentType = reportInfo.getComponentsList("JAVASCRIPT_ERROR",false);	
	for(int kk=0;kk<aListSupportedComponentType.size();kk++)
	{
		aListAlltype.add("All "+aListSupportedComponentType.get(kk));
	}
	
	//RUM_REPOTRS
	if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
	{		
		zonelist = new ArrayList();
		zonelist.addAll(serviceList);
	}
	
	if(s_farmServerAL.size()==0)
	{
		s_farmServerAL.add((String)ConstantDispName);
		s_farmserver=ConstantDispName;
	}
	String er_option="Service";
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	Hashtable htAllGroups =new Hashtable();
	if(er_option!=null && (er_option.equalsIgnoreCase("Segment")||er_option.equalsIgnoreCase("Service")||er_option.equalsIgnoreCase("Zone")))
	{
		htAllGroups = erEsxUtils.getGroups(null, aListSupportedComponentType, thisuser, loginid, "Yes",true);
	}
	List v_site = new ArrayList();
	if(er_option!=null)
	{
		List aListComponentTemp=null;
		v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
		
		if(v_site!=null)
		{
			Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);		
			dispzone.addAll(v_site);
		}
		if((s_farmserver==null && v_site!=null && v_site.size()>0) || (s_farmserver!=null && v_site!=null && (!v_site.contains(s_farmserver)  && !s_farmserver.equalsIgnoreCase(ConstantDispName)) && v_site!=null && v_site.size()>0))
		{
			s_farmserver=(String)v_site.get(0);
		}
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,s_farmserver);
		 
		
		if(s_farmserver.equalsIgnoreCase(ConstantDispName))
		{
			if(aListComponentTemp==null && v_components!=null && v_components.size()>0)
			{
				Vector v_componentsDummy=new Vector();
				for(int i=0;i<v_components.size();i++)
				{
					String compVal=(String) v_components.get(i);
					String compType=compVal.substring(compVal.lastIndexOf(":")+1);
					if(aListSupportedComponentType.contains(compType))
					{
						v_componentsDummy.add(compVal);
					}
				}
				v_components=v_componentsDummy;
			}
			if(v_site!=null && v_site.size()>0)
			{
				Vector removeCmps=new Vector();
				for(int i=0;i<v_site.size();i++)
				{
					String siteVal=(String) v_site.get(i);
					removeCmps.addAll(erEsxUtils.getComponentForGroup(htAllGroups,er_option,siteVal));
				}
				v_components.removeAll(removeCmps);
			}
		}
		
		if(aListComponentTemp!=null && aListComponentTemp.size()>0)
		{
			v_components = new Vector();
			v_components.addAll(aListComponentTemp);
		}
		
		if(aListComponentTemp!=null && aListComponentTemp.size()>0)
		{
			aListCompType = new ArrayList();
			for(int i=0; i<aListComponentTemp.size(); i++) 
			{
				String loopComponent = (String) aListComponentTemp.get(i);
				if(loopComponent.lastIndexOf(":")>-1){
					String loopComp = loopComponent.substring(0,loopComponent.lastIndexOf(":"));
					String  loopType = loopComponent.substring(loopComponent.lastIndexOf(":")+1);

						if(aListCompType!=null && !aListCompType.contains(loopType))
							aListCompType.add(loopType);											
				}
			}
		}		
		
		if(strSelectedCompType == null || strSelectedCompType.equals("")  || strSelectedCompType.equals("-1"))
		{
			if(aListCompType!=null && aListCompType.size()>0){
				ArrayList sortedNameList1 = new ArrayList();
				sortedNameList1 = sorter.getSortedCompTypeList(aListCompType);
				EgName obj_name1 = (EgName) sortedNameList1.get(0); 
				strSelectedCompType = obj_name1.getActualName();
			}
		}
	
	}	
	
	
	Collections.sort(v_components,String.CASE_INSENSITIVE_ORDER);

	
	
	

	if (dispzone != null)
	Collections.sort(dispzone,String.CASE_INSENSITIVE_ORDER);
	if(isreportsneedService!=null && isreportsneedService.equalsIgnoreCase("Yes"))
		screenLabelJson.put("reporter.consolidated.Zone",intlmap.getTextDescription("reporter.consolidated.Service"));
	else
		screenLabelJson.put("reporter.consolidated.Zone",intlmap.getTextDescription("reporter.consolidated.Zone"));
	JSONArray zoneArray = new JSONArray();
	if(dispzone!=null )
	{
			if(!dispzone.contains(ConstantDispName))
				dispzone.add(0,ConstantDispName);
			

	}
	for(int n=0;n<dispzone.size();n++)
	{
		String s=(String)dispzone.get(n);
		loopJsonObj = new JSONObject();
		if(!s.equalsIgnoreCase(ConstantDispName))
				loopJsonObj.put("displayField",s);
			else
				loopJsonObj.put("displayField",ConstantDispNameDisp);
		loopJsonObj.put("valueField",s);
		zoneArray.add(loopJsonObj);
		if(s_farmServerAL!=null && s_farmServerAL.contains(s))
		{
			rootJson.put("selectedZone",s);
		}
	}
	rootJson.put("zoneCombo",zoneArray);
	

	screenLabelJson.put("reporter.thin.Component Type",intlmap.getTextDescription("reporter.thin.Component Type"));
	JSONArray comptypeArray = new JSONArray();
	if(aListCompType!=null && aListCompType.size()>0)
	{
		ArrayList sortedNameList1 = new ArrayList();
		sortedNameList1 = sorter.getSortedCompTypeList(aListCompType);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Component Type"));
		loopJsonObj.put("valueField", "-1");
		comptypeArray.add(loopJsonObj);
		
		for(int n=0;n<sortedNameList1.size();n++)
		{
			EgName nameObj =(EgName) sortedNameList1.get(n);
			String dispValue = nameObj.getLocalName();
			String sCompType = nameObj.getActualName();

			if(strSelectedCompType!=null && strSelectedCompType.equals(sCompType)&& ! strSelectedCompType.equals("-1"))
			{
				strSelectedCompType=sCompType;
				
			}else
			{
				
			}
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",dispValue);
			loopJsonObj.put("valueField",sCompType);
			comptypeArray.add(loopJsonObj);
		}
		if(strSelectedCompType==null&&  strSelectedCompType.equals("-1") )
		{
			EgName nameObj =(EgName) sortedNameList1.get(0);
				String dispValue = nameObj.getLocalName();
				String sCompType = nameObj.getActualName();
			strSelectedCompType=sCompType;
		}
		rootJson.put("selectedCompType",strSelectedCompType);
	}else{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
		loopJsonObj.put("valueField", "-1");
		comptypeArray.add(loopJsonObj);
	}
	
	
	
	rootJson.put("compTypeCombo",comptypeArray);
	

		JSONArray serverArray =  new JSONArray();
		JSONArray selectedCombo=new JSONArray();
		if(v_components !=null && !v_components.isEmpty())
		{
			 ArrayList sortedNameList1 = new ArrayList();
			 sortedNameList1 = sorter.getSortedCompTypeList(v_components);
			 for(int n=0;n<sortedNameList1.size();n++)
			 {

				EgName nameObj =(EgName) sortedNameList1.get(n);
				String dispValue = nameObj.getLocalName();
				String s = nameObj.getActualName();
				String displayField2 = dispValue.substring(0, dispValue.lastIndexOf(":"));
				String str = dispValue.substring(0, dispValue.indexOf(":"));

				String s1 = s;
				if(s1.indexOf(":NULL")>-1)
					s1 = s1.substring(0,s1.indexOf(":NULL"))+s1.substring(s1.indexOf(":NULL")+5);
					
				if(s_serverAL!=null && s_serverAL.contains(s))
				{
					selectedCombo.add(s);
				}else if(s_server!=null && s_server.equalsIgnoreCase(str))
				{
					selectedCombo.add(s);
				}
				if(s.indexOf(":")>-1 || s.indexOf("All ")>-1)
				{
					String strTemp="";
					String strTemp1="";
					if(s.indexOf(":")>-1)
					{
						strTemp = s1.substring(0,s1.lastIndexOf(":"));
						strTemp1 = s.substring(s.lastIndexOf(":")+1);
					}
					if(s.indexOf("All ")>-1)
					{
						strTemp = s.substring(0,s.lastIndexOf("All ")+("All ".length()));
						strTemp1 = s.substring(s.lastIndexOf("All ")+("All ".length()));
					}			
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",strTemp);
					loopJsonObj.put("valueField",s);
					serverArray.add(loopJsonObj);
				}
				else
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+s1));
					loopJsonObj.put("valueField",s);
					serverArray.add(loopJsonObj);
				}
			 }
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "-1");
			serverArray.add(loopJsonObj);
		}
		
		rootJson.put("selectedServer",selectedCombo);
		rootJson.put("serverCombo",serverArray);
	
	
	IniUI ui = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;

	//------------ For displaying  Time Zone------------ 
	Calendar cal = Calendar.getInstance();
	ErReqData erd = new ErReqData(request);
	EgDateInfo egDate = new EgDateInfo();
	Date local_date = new Date(egDate.egetUTCDate());	  
	cal.setTime(local_date);
    cal.setTimeZone(egDate.getRealTimeZone());
    String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
    String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
    String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",strUserDateFormat);
    TimeZone tz = egDate.getRealTimeZone();
    String tzName = tz.getDisplayName(tz.inDaylightTime(local_date), TimeZone.SHORT);
    EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,this_user);
    String loginUserDateTime = (String)timeZoneConverter.getDate(false);
    Date loginUserDate = (Date)timeZoneConverter.getDate(true);
    TimeZone user_tz = (TimeZone)timeZoneConverter.getTimeZone();
    if( loginUserDateTime != null && !loginUserDateTime.trim().equals(""))
    {
    	dispDate = loginUserDateTime;
		tzName = user_tz.getDisplayName(user_tz.inDaylightTime(loginUserDate), TimeZone.SHORT);
    }

	String stdate="";
	String enddate="";
	String sthr="";
	String endhr="";
	String sthr1 = "";
	String endhr1 = "";
	long msecsPerHour = (long) 1000 * 60 * 60;

	fromTime = reportInfo.getTimeFrame("JAVASCRIPT_ERROR","FROM");
	toTime = reportInfo.getTimeFrame("JAVASCRIPT_ERROR","TO");

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}
	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}

	String Days = reportInfo.getExcludeWeekend("JAVASCRIPT_ERROR");
	Vector v_time=new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min=new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;
	boolean isEnglishLanguage=false;
	if(trackerLanguage!=null && trackerLanguage.equals("en_US"))
	{
		isEnglishLanguage=true;
	}
	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");		

	ErHelperUtils erhelputils = null;
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();
	String backButtonEnable = request.getParameter("back");
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("htdata",null);
		request.setAttribute("app_topusers",null);
		request.setAttribute("appChartData",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	
	
	int maxInfo = er_helper.getMaxInfos("INFOS","Showtop");
	if(priority==null || priority.equals(""))
		priority="TOP  - " +maxInfo;	
	
	


	screenLabelJson.put("reporter.thin.Report Type",intlmap.getTextDescription("reporter.thin.Report Type"));	
	rootJson.put("reportTypeCombo",getReportTypeComboValues(intlmap));
	rootJson.put("selectedreportType",rtype);


	Vector v_show=(Vector)getPriorityValues(maxInfo);
	screenLabelJson.put("reporter.comparison.Show Top",intlmap.getTextDescription("reporter.comparison.Show Top"));	
	JSONArray priorityArray =  new JSONArray();
	for(int n=0;n<v_show.size();n++)
	{
		String s=(String)v_show.get(n);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",intlmap.getTextDescription("reporter.common."+s));
		loopJsonObj.put("valueField", s);
		priorityArray.add(loopJsonObj);
		if(priority!=null && priority.equalsIgnoreCase(s))
		{
			rootJson.put("selectedPriority",priority);
		}
	}
	rootJson.put("priorityCombo",priorityArray);
	


String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;
	String starttimeformat="";
	String endtimeformat="";
	
	String comFormat = null;
	String  s_st_time   = request.getParameter("startdate");
	String s_en_time    = request.getParameter("enddate");
	String s_st_hr      = request.getParameter("starthr");
	String s_en_hr      = request.getParameter("endhr");
	String strmin       = request.getParameter("startmin");
	String enmin        = request.getParameter("endmin");
	String  er_timeline = request.getParameter("er_timeline");
	String start_date   = request.getParameter("startdate");
	String end_date     = request.getParameter("enddate");	
	

	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}
	String maxTimeLine="1 week";
	int maxTImeLineVal=getValueFromINI();

	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week"};
	
		if(maxTImeLineVal>60 && maxTImeLineVal==0)
		{
			maxTimeLine="3 months";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months","3 months"};
			 
		}else if(maxTImeLineVal>30)
		{
			maxTimeLine="2 months";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}else if(maxTImeLineVal>28)
		{
			maxTimeLine="1 month";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
		}
		else if(maxTImeLineVal>21)
		{
			maxTimeLine="4 weeks";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks"};
		}
		else if(maxTImeLineVal>14)
		{
			maxTimeLine="3 weeks";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks"};
		}
		else if(maxTImeLineVal>7)
		{
			maxTimeLine="2 weeks";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks"};
		}
		else if(maxTImeLineVal>6)
		{
			maxTimeLine="1 week";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week"};
		}
		else if(maxTImeLineVal<=1)
		{
			maxTimeLine="1 day";
			options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day"};
		}
		else
		{
			List tmeLst=new ArrayList();
			tmeLst.add("Any");
			tmeLst.add("1 hour");
			tmeLst.add("3 hour");
			tmeLst.add("6 hour");
			tmeLst.add("9 hour");
			tmeLst.add("12 hour");
			tmeLst.add("15 hour");
			tmeLst.add("18 hour");
			tmeLst.add("21 hour");
			for(int ik=1;ik<=maxTImeLineVal;ik++)
			{
				if(ik==1)
					tmeLst.add((int)ik+" day");
				else
					tmeLst.add((int)ik+" days");
			}
			options =(String[]) tmeLst.toArray(new String[tmeLst.size()]);
			maxTimeLine=maxTImeLineVal+" days";
		}
		
	

	String startDateTime=null;
	String endDateTime=null;
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =egDt.egetRealDate();
			endDateTime = sdf.format(today);
			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,
				"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = egDt.egetRealDate();
				start.setTime(today.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			strmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
		}
	}

	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}

	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		strmin="00";
		enmin="00";
	}
	String selectedArrangeOrder   = request.getParameter("arrangeOrderBy");
	if(selectedArrangeOrder == null || selectedArrangeOrder.trim().length()==0)
		selectedArrangeOrder = "desc";
	String nextOrderBy="asc";
	String imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
	if(selectedArrangeOrder!=null && selectedArrangeOrder.equals("desc"))
	{
		nextOrderBy="asc";
		imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
	}
	else if(selectedArrangeOrder!=null && selectedArrangeOrder.equals("asc"))
	{
		nextOrderBy="desc";
		imgurl="/final/monitor/eg_images/arrow_up_black_small.gif";
	}
	String strScreenWidth = request.getParameter("screenWidth");
	int screenWidth = 990;
	try{
		screenWidth = Integer.parseInt(strScreenWidth);
	}catch(Exception e){screenWidth = 990;}


	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";


/*******************************************************************************
* File name : ErTimeFormat.jsp
* Purpose   : Time Control to be used thorugh out Reporter.
* Version   : Reporter 4.0
*******************************************************************************/


	JSONArray timelineComboArray=new JSONArray();
	JSONArray timelineHourComboArray=new JSONArray();
	String startDateJSON="";
	String endDateJSON="";
	String startHourJSON="";
	String endHourJSON="";
	String selectedGraphMode="";
	String startDateForHighchart=null;
	String endDateForHighchart=null;
	String chartTypeForUI=null;
	
	User userName = UserRegistry.getInstance().getUser(session.getId());
	ErReportHelper er_rpthelper = new ErReportHelper();
	EgReportInfo rptInfo = new EgReportInfo("manager");
	EgMappingInfo mappingObj = new EgMappingInfo(thisuser.getLanguage());
	String reqOption = request.getParameter("option");
	String deftimeline = rptInfo.getDefaultTimeLine("MISC","MaxTimeline");
	List alist = Arrays.asList(options);
	String loginName = userName.getLoginID();
	int len;
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	//String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
	String[] lstWeeksArr = new String[]{"Last week", "Last month"};	
	if(strUsrTimeline != null && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
		
	if (reqOption!=null && reqOption.equalsIgnoreCase("Citrix"))
	{
		if(deftimeline !=null && !deftimeline.equals("-1"))
		{
			if(len > alist.indexOf(deftimeline)+1)
			{
				len=alist.indexOf(deftimeline)+1;
			}
			if (len >0)
				strUsrTimeline = (String)alist.get(len-1);
			else
				strUsrTimeline = (String)alist.get(len);
		}

	}
	if(len == 0)
		len = options.length;
	String grophmodeon = request.getParameter("grophmodeon");
	String r_type = request.getParameter("er_type");
	String reporttype = request.getParameter("reporttype");
	String er_rtype = request.getParameter("er_rtype");
	String er_rtype_proc = request.getParameter("er_rtype_proc");
	String timeformat_trend = request.getParameter("er_trenddata");
	if (timeformat_trend == null || timeformat_trend ==" " )
		timeformat_trend = "No";

	if (reporttype==null || reporttype.equalsIgnoreCase("null"))
	{
		if (er_rtype!=null && er_rtype.equalsIgnoreCase("macro"))
		{
			reporttype="executive";
		} else if (er_rtype!=null && ( er_rtype.equalsIgnoreCase("application") || er_rtype.equalsIgnoreCase("network") 
		|| er_rtype.equalsIgnoreCase("site") || er_rtype.equalsIgnoreCase("system") ||  er_rtype.equalsIgnoreCase("Event") ) )
		{
			reporttype="operation";
		}

	}

	String colum="";
	if(reporttype!=null &&reporttype.equalsIgnoreCase("executive"))
		colum="9";
	else
		colum="6";
	String er_gtype=request.getParameter("er_gtype");

	java.util.Date start = egDt.egetRealDate();
	String startMin = Integer.toString(start.getMinutes());
	String endMin = Integer.toString(start.getMinutes());
	String strsmin_11=request.getParameter("startmin");
	String etrsmin_11=request.getParameter("endmin");
	if(strsmin_11 != null && strsmin_11.length()>0)
		startMin = strsmin_11;
	if(etrsmin_11 != null && etrsmin_11.length()>0)
		endMin = etrsmin_11;

	EgTimeZoneConverter timeZoneConverterStart = null;
	EgTimeZoneConverter timeZoneConverterEnd = null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay = null;
	String endMinForDisplay = null;
	for(int e_ctr=0; e_ctr<len; e_ctr++)
	{
		String s_timeline=options[e_ctr];
		if(s_timeline.equalsIgnoreCase("Any"))
		{
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",mappingObj.getTextDescription("reporter.common."+s_timeline));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}else if(s_timeline.contains("Last")){
			String displayField=null;
			String viewField=null;
			displayField = s_timeline;
			int spaceNum = 0;
			for(int i=0; i<s_timeline.length();i++){
				char ch = s_timeline.charAt(i);
				if(ch== ' '){
				   spaceNum++; 
				}
			}
			if(spaceNum > 2){
				String countStr = s_timeline.substring(s_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = s_timeline.substring(s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,s_timeline.length());
				String last = s_timeline.substring(0, s_timeline.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr + end + "_" + last;				
			}else{
				viewField = "1 "+s_timeline.substring(s_timeline.lastIndexOf(" ")+1, s_timeline.length())  + "_" + s_timeline.substring(0, s_timeline.indexOf(" "));				
			}
			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",displayField);
			timelineJSON.put("valueField", viewField.toLowerCase());
			timelineComboArray.add( timelineJSON );			
		}
		else
		{
			String numstr = s_timeline.substring(0,s_timeline.indexOf(" "));
			String strextra = s_timeline.substring(s_timeline.indexOf(" ")+1);

			JSONObject timelineJSON = new JSONObject();
			timelineJSON.put("displayField",numstr+" "+ mappingObj.getTextDescription("reporter.common."+strextra));
			timelineJSON.put("valueField", s_timeline);
			timelineComboArray.add( timelineJSON );
		}

		/*if(er_timeline!=null && er_timeline.equals((String)options[e_ctr]))
		{
			if(er_timeline.equalsIgnoreCase("Any"))
			{
				String strer_timeline="reporter.common."+er_timeline;

			}
			else
			{
				String numstr = er_timeline.substring(0,er_timeline.indexOf(" "));
				String strextra = er_timeline.substring(er_timeline.indexOf(" ")+1);
				String str_strextra="reporter.common."+strextra;
			}
		}
		else
		{
			if(options[e_ctr].equalsIgnoreCase("Any"))
			{
				String  str_options="reporter.common."+options[e_ctr];
			}
			else
			{
				String numstr = options[e_ctr].substring(0,options[e_ctr].indexOf(" "));
				String strextra = options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				//FIX FOR SUPPORT TOMCAT 6.0
				String str_extra= "reporter.common."+strextra;
			}
		}*/
	} 

	List lastDataList = new ArrayList();
	JSONArray lastDataJSON = null;
	int lastWeekCount = 1;		
	if(isLastTimeLine){
		if(strUsrTimeline.equals("-1")){
			for(int i=0;i<lstWeeksArr.length;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 week")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("2 weeks")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("3 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("4 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 month")){
			lastWeekCount = 2;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);			
			for(int i=0;i<lastDataJSON.size();i++){
				timelineComboArray.add(lastDataJSON.get(i));
			}		
		}	
	}
	
	String isVmReport = request.getParameter("isVmReport");
	if(er_timeline!=null && !er_timeline.equals("Any"))
	{
		/*if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		}
		else*/
	
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			
			
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat); 
	}
	else
	{
	
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		
		
		//dispDate = s_st_time;
	}
	if (timeformat_trend!=null && timeformat_trend.equals("Yes")&& er_timeline!=null && !er_timeline.equals("Any")) {
		
		s_st_hr="00";
		startMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start //User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;	
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName,true); 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" + startMin; 
			
			startDateForDisplay = dispDate;
			startHourForDisplay = s_st_hr;
			startMinForDisplay = startMin;

			dispDate=(String) timeZoneConverterStart.getDate(false);
			s_st_time=dispDate;
			startDateJSON=dispDate;
			s_st_hr = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();
		}
		
	} else { 
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			//User Zone Start time
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			startDateForDisplay = userTimeZoneList.get(0);
			startHourForDisplay = "00";
			startMinForDisplay = "00";
			
			timeZoneConverterStart = new EgTimeZoneConverter(startDateForDisplay + " "+ startHourForDisplay + ":" + startMinForDisplay, userName, true);
			startDateJSON = (String) timeZoneConverterStart.getDate(false);
			startHourJSON = timeZoneConverterStart.getHour();
			startMin = timeZoneConverterStart.getMinute();

			startDateForHighchart = startDateJSON + " " + startHourJSON + ":" + startMin;			
		}else{
			timeZoneConverterStart = new EgTimeZoneConverter(dispDate + " "+ s_st_hr + ":" + startMin, userName);
	 
			startDateForHighchart=dispDate + " "+ s_st_hr + ":" +startMin; 
			startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
			startHourForDisplay = timeZoneConverterStart.getHour();
			s_st_hr = s_st_hr.trim();
			startMinForDisplay = timeZoneConverterStart.getMinute();
			startDateJSON=dispDate;			
		}
		
	}
 	/*if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_st_time;
	}*/
	
 

	for(int s_ctr=0; s_ctr<24; s_ctr++)
	{
		s_st_hr = s_st_hr.trim();
		if(!er_timeline.endsWith("last"))
			startHourJSON=s_st_hr;
		JSONObject timelineHourJSON = new JSONObject();
		timelineHourJSON.put("displayField",String.valueOf(s_ctr));
		timelineHourJSON.put("valueField",String.valueOf(s_ctr));
		timelineHourComboArray.add( timelineHourJSON );
	}

	
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if (isVmReport != null && isVmReport.equals("Yes"))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
		else
		{
			if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
			{
				comFormat = currentDateFormat;
			}
			else
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
			}
			//comFormat = currentDateFormat;
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
	}
	else
	{
		if (currentDateFormat!=null && currentDateFormat.equals("dd/MM/yyyy"))
		{
			comFormat = currentDateFormat;
		}
		else
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
		}
		//comFormat = currentDateFormat;
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat); 
	}

	if (timeformat_trend!=null && timeformat_trend.equals("Yes") && er_timeline!=null && !er_timeline.equals("Any")) {
		s_en_hr="00";
		endMin="00";
		if(er_timeline.endsWith("last")){
			// Last Week or Last Month
			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			System.out.println("1Manager Start Time-->"+startDateForHighchart);
			System.out.println("1Manager Start Hour-->"+startHourJSON);
			System.out.println("1Manager End Time--->"+endDateForHighchart);		

		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " " + s_en_hr + ":" + endMin, userName,true);
		
		endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;

			endDateForDisplay = dispDate;
			endHourForDisplay = s_en_hr;
			endMinForDisplay = endMin;
				
			dispDate=(String) timeZoneConverterEnd.getDate(false);
			s_en_time=dispDate;
			endDateJSON=dispDate;
			s_en_hr = timeZoneConverterEnd.getHour();
			endHourJSON=s_en_hr;
			endMin = timeZoneConverterEnd.getMinute(); 
		}		
		
	} else {
		if(er_timeline.endsWith("last")){			
			boolean isZoneType = false;
			List<String> userTimeZoneList = getLastWeekMonthList(currentDateFormat,  userName, er_timeline, isZoneType);
			
			endDateForDisplay = userTimeZoneList.get(1);			
			endHourForDisplay = "23";			
			endMinForDisplay = "59";
										
			timeZoneConverterEnd = new EgTimeZoneConverter(endDateForDisplay + " "+ endHourForDisplay + ":" + endMinForDisplay, userName, true);
	
			endDateJSON=(String) timeZoneConverterEnd.getDate(false);
			endHourJSON=timeZoneConverterEnd.getHour();
			endMin = timeZoneConverterEnd.getMinute(); 
			endDateForHighchart=endDateJSON + " "+ endHourJSON + ":" + endMin;
			/*System.out.println("2Manager Start Time-->"+startDateForHighchart);
			System.out.println("2Manager Start Hour-->"+startHourJSON);
			System.out.println("2Manager End Time--->"+endDateForHighchart);*/
			System.out.println("2Manager-Last Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}else{
			timeZoneConverterEnd = new EgTimeZoneConverter(dispDate + " "+ s_en_hr + ":" + endMin, userName);

			endDateForHighchart=dispDate + " "+ s_en_hr + ":" + endMin;
			endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
			endHourForDisplay = timeZoneConverterEnd.getHour(); 
			endHourJSON=s_en_hr;
			s_en_hr = s_en_hr.trim();
			endMinForDisplay = timeZoneConverterEnd.getMinute();
			endDateJSON=dispDate;
			System.out.println("2Manager Start Date-->"+startDateJSON+"  Start Hour-->"+startHourJSON+"  Start Min-->"+startMin);
		}
	}

	//for(int e_ctr=0; e_ctr<24; e_ctr++)
	//{
		//s_en_hr=s_en_hr.trim();
		//endHourJSON=s_en_hr;
	//}
	if(request.getParameter("er_type")!=null && !(request.getParameter("er_type")).equalsIgnoreCase("Comparison"))
	{
		if(request.getParameter("er_type").equals("Yes") || request.getParameter("er_type").equals("Vmgstatus"))
		{
		
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_type_proc")!=null)
	{
		if(request.getParameter("er_type_proc").equals("Yes"))// || request.getParameter("er_type_proc").equals("Vmgstatus"))
		{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D")){
				selectedGraphMode="2D";
			}
			if(mode.equals("3D")){
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
		}
	}
	else if(request.getParameter("er_rtype")!=null && request.getParameter("er_rtype").equalsIgnoreCase("AlarmHistory"))
	{
		
	}
	else if(reporttype!=null && (reporttype.equalsIgnoreCase("executive")|| reporttype.equalsIgnoreCase("operation")||reporttype.equalsIgnoreCase("TopN")) || (grophmodeon!=null && grophmodeon.equalsIgnoreCase("yes")) ||er_gtype!=null && er_gtype.equalsIgnoreCase("Comparison"))
	{
		String mode = request.getParameter("er_mode");
		boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D"))
			{
				selectedGraphMode="2D";
			}
			if(mode.equals("3D"))
			{
				selectedGraphMode="3D";
			}
		}
		else
		{
			if(use3DGraphs){
				selectedGraphMode="3D";
			}
			else{
				selectedGraphMode="2D";
			}
		}
	}


								
	String sdate = request.getParameter("startdate");	
	String edate = request.getParameter("enddate");	
	String shr = request.getParameter("starthr");	
	String ehr = request.getParameter("endhr");	
	String smin = request.getParameter("startmin");	
	String emin = request.getParameter("endmin");
	starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
	endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
	
//
	String  pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String  pdfEndDate   = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
	String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";
	
	//
	try
	{
		String er_reportgenration = request.getParameter("er_reportgenration");
		if(er_reportgenration==null || er_reportgenration.equalsIgnoreCase(""))
			er_reportgenration="foreground";
		String er_background ="";
		String er_foreground ="";
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
			er_background = "selected";
			er_foreground = "";
		}
		else
		{
			er_background = "";
			er_foreground = "selected";
		}
		String bg_reportname = request.getParameter("bg_reportname");
		if(bg_reportname == null)
		{
			bg_reportname = "";
		}
		hiddenfieldsJson.put("userTimeline",strUsrTimeline);
		screenLabelJson.put("reporter.common.Timeline", intlmap.getTextDescription("reporter.common.Timeline"));
		screenLabelJson.put("reporter.common.From", intlmap.getTextDescription("reporter.common.From"));
		screenLabelJson.put("reporter.common.To", intlmap.getTextDescription("reporter.common.To"));
		screenLabelJson.put("reporter.common.Hr", intlmap.getTextDescription("reporter.common.Hr"));
		screenLabelJson.put("reporter.common.Graph", intlmap.getTextDescription("reporter.common.Graph"));
		screenLabelJson.put("reporter.common.Time period", intlmap.getTextDescription("reporter.common.Time period"));
		screenLabelJson.put("reporter.common.Hrs", intlmap.getTextDescription("reporter.common.Hrs"));
		screenLabelJson.put("reporter.common.Mins", intlmap.getTextDescription("reporter.common.Mins"));
		screenLabelJson.put("MappedExcludeDays", intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);
		screenLabelJson.put("reporter.comparison.Weighted Average",intlmap.getTextDescription("reporter.comparison.Weighted Average"));
		screenLabelJson.put("reporter.common.Exclude weekends",intlmap.getTextDescription("reporter.common.Exclude weekends"));
	
		rootJson.put("selectedTimeFrom",Hourfrom);
		rootJson.put("selectedMinsFrom",Minfrom);
		rootJson.put("selectedTimeTo",Hourto);
		rootJson.put("selectedMinsTo",Minto);
		rootJson.put("excludeWeekCombo",getExcludeWeekValues(intlmap));
		rootJson.put("excludeWeek",excludeweekend);
		rootJson.put("timelineCombo",timelineComboArray);
		rootJson.put("selectedTimeline",er_timeline);
		rootJson.put("startDate",startDateJSON);
		rootJson.put("endDate",endDateJSON);
		rootJson.put("startHour",startHourJSON);
		rootJson.put("endHour",endHourJSON);
		rootJson.put("startmin",strmin);
		rootJson.put("endmin",enmin);
		rootJson.put("selectedGraphMode",selectedGraphMode);
		rootJson.put("startDateForDisplay",startDateForDisplay);
		rootJson.put("startHourForDisplay",startHourForDisplay);
		rootJson.put("startMinForDisplay",startMinForDisplay);
		rootJson.put("endDateForDisplay",endDateForDisplay);
		rootJson.put("endHourForDisplay",endHourForDisplay);
		rootJson.put("endMinForDisplay",endMinForDisplay);
		chartTypeForUI=ErHighchartUtils.getChartType(startDateForHighchart,endDateForHighchart,currentDateFormat+" HH:mm");
		rootJson.put("chartType",chartTypeForUI);
		screenLabelJson.put("reporter.common.Component", intlmap.getTextDescription("reporter.common.Component"));
		screenLabelJson.put("reporter.common.Report Generation", intlmap.getTextDescription("reporter.common.Report Generation"));
		screenLabelJson.put("reporter.common.SUBMIT", intlmap.getTextDescription("reporter.common.SUBMIT"));
		screenLabelJson.put("reporter.common.Report Name", intlmap.getTextDescription("reporter.common.Report Name"));
		screenLabelJson.put("reporter.common.Report For", intlmap.getTextDescription("reporter.common.Report For"));
		screenLabelJson.put("reporter.common.Time period", intlmap.getTextDescription("reporter.common.Time period"));
		screenLabelJson.put("reporter.common.Hrs", intlmap.getTextDescription("reporter.common.Hrs"));
		screenLabelJson.put("reporter.common.Mins", intlmap.getTextDescription("reporter.common.Mins"));
		screenLabelJson.put("MappedExcludeDays", intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);
		screenLabelJson.put("reporter.comparison.Weighted Average",intlmap.getTextDescription("reporter.comparison.Group By"));
		screenLabelJson.put("reporter.common.Exclude weekends",intlmap.getTextDescription("reporter.common.Exclude weekends"));
		screenLabelJson.put("reporter.thin.Graph Type",intlmap.getTextDescription("reporter.thin.Graph Type"));
		screenLabelJson.put("reporter.thin.rep_genType",intlmap.getTextDescription("reporter.thin.Type"));
		
		rootJson.put("graphTypeArray",getGraphTypeValues(intlmap));
		rootJson.put("selectedTimeFrom",Hourfrom);
		rootJson.put("selectedMinsFrom",Minfrom);
		rootJson.put("selectedTimeTo",Hourto);
		rootJson.put("selectedMinsTo",Minto);
		//rootJson.put("excludeWeek",getExcludeWeekComboValues(intlmap));	
		rootJson.put("weightedAvgCombo",geWeightedAvgComboValues(intlmap,reportInfo,strSelectedCompType));
		rootJson.put("reportGeneration",er_reportgenration);
		rootJson.put("reportGenerationCombo",getReportGenerationComboValues(intlmap,strbackground,strforeground));
		rootJson.put("reportForCombo",getReportForComboValues(intlmap));
		if(rep_genType==null)
			rep_genType="Summary";
			
		rootJson.put("rep_genType",getReportGenTypeCombo(intlmap));
		rootJson.put("selected_genType",rep_genType);
		rootJson.put("reportFor","Error");
		
		hiddenfieldsJson.put("option","Citrix");
		hiddenfieldsJson.put("er_RmDispName",titleToDisplay);
		hiddenfieldsJson.put("isJSerrorReport","true");
		rootJson.put("maxTimeLine",maxTimeLine);
		hiddenfieldsJson.put("inidate",currentDateFormat);
		hiddenfieldsJson.put("currTime","");
		hiddenfieldsJson.put("er_rtype","CtxUserActivity");
		hiddenfieldsJson.put("er_trgttype","RUM_Report");
		hiddenfieldsJson.put("er_gtype","Citrix");
		hiddenfieldsJson.put("pdfTime",pdfTime);
		hiddenfieldsJson.put("uid",EgURLEncoder.encode(loginid,"UTF-8"));
		hiddenfieldsJson.put("userID",EgURLEncoder.encode(loginid,"UTF-8"));
		hiddenfieldsJson.put("er_trenddata","No");
		if(request.getParameter("servers")!=null)
			hiddenfieldsJson.put("servers",request.getParameter("servers"));
		else
			hiddenfieldsJson.put("servers","null");
		//hiddenfieldsJson.put("er_check",request.getParameter("er_check"));
		if(request.getParameter("er_check")!=null)
			hiddenfieldsJson.put("er_check",request.getParameter("er_check"));
		else
			hiddenfieldsJson.put("er_check","null");
		if(request.getParameter("er_application1")!=null)
			hiddenfieldsJson.put("er_application1",request.getParameter("er_application1"));
		else
			hiddenfieldsJson.put("er_application1","null");
		//hiddenfieldsJson.put("er_application1",request.getParameter("er_application1"));
		if(reqFromSchedule!=null)
			hiddenfieldsJson.put("fromSchedule",reqFromSchedule);
		else
			hiddenfieldsJson.put("fromSchedule","null");

		if(fromScheduleModify!=null)
			hiddenfieldsJson.put("fromScheduleModify",fromScheduleModify);
		else
			hiddenfieldsJson.put("fromScheduleModify","null");

		if(fromFavoriteModify!=null)
			hiddenfieldsJson.put("fromFavoriteModify",fromFavoriteModify);
		else
			hiddenfieldsJson.put("fromFavoriteModify","null");
		hiddenfieldsJson.put("favorite_id", favorite_id);
		hiddenfieldsJson.put("er_favorite", er_favorite);
		if(schedule_id!=null)
			hiddenfieldsJson.put("schedule_id",schedule_id);
		else
			hiddenfieldsJson.put("schedule_id","null");

		hiddenfieldsJson.put("er_ViewName","ErRumReport.jsp");
		hiddenfieldsJson.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
		hiddenfieldsJson.put("forwardto","ErRumReportJson");
		hiddenfieldsJson.put("er_bgreportfrom","RUM_Report");
		hiddenfieldsJson.put("bgenabled",strbgrepportName);
		hiddenfieldsJson.put("limitforbg",limitforbg);
		hiddenfieldsJson.put("savereport","save");
		hiddenfieldsJson.put("servletName","com.eg.ErCtxRumReportC");
		hiddenfieldsJson.put("divStatus",divStatus);
		hiddenfieldsJson.put("arrangeOrderBy",selectedArrangeOrder);	
		if(rtype!=null&&rtype.equals("Yes"))
		{
			hiddenfieldsJson.put("opt","chart");
		}
		else
		{
			hiddenfieldsJson.put("opt","data");
		}
		hiddenfieldsJson.put("er_uisortby",s_uisort);
		
		if(backreqMap != null && backreqMap.size() > 0  && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") )
		{
			rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		}		
		


String qStrng =(String)ErUtils.prepareQueryString(request.getParameterMap());
String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

String Qstring="";
if(qStrng!=null)
{
	StringTokenizer strtok = new StringTokenizer(qStrng,"&");
	while(strtok.hasMoreTokens())
	{
		String param = strtok.nextToken();
		int ind = param.indexOf("=");
		if (ind < 0 || param.indexOf("responseType")>-1)
			continue;
		String reqparam =param.substring(0,ind);
		String value = param.substring(ind+1);
		
		if(reqparam!=null&&reqparam.equals("select_farm"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("er_userid"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("er_user"))
		{
			value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
		}
		if(reqparam!=null&&reqparam.equals("er_application"))
		{
			value=com.egurkha.util.StringUtils.replace(value,"\\", "\\\\");
		}
		if(reqparam!=null&&reqparam.equals("uid"))
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") ) )
		{
			value=com.eg.EgURLEncoder.encode(value, "UTF-8");
		}
		if(reqparam!=null&&reqparam.equals("showLegend"))
		{
			rootJson.put("showLegend",value);
		}

		Qstring=Qstring+reqparam+"="+value+"&";
	}
	rootJson.put("saveQString",Qstring);
}
session.setAttribute("PDF_URL", mngrIProc+"/final/servlet/com.eg.ErCtxRumReportC");
session.setAttribute("MAIL_URL", mngrIProc+"/final/servlet/com.eg.ErCtxRumReportC;jsessionid="+session.getId()+"?"+Qstring+"&printGraph=yes&er_view=PRINT");
session.setAttribute("reportLastAccessedURL","/final/reporter/ErRumReport.jsp?"+Qstring);

		
		
	
		if(isSubmit!=null && isSubmit.equalsIgnoreCase("true"))
		{
			if(rtype.equalsIgnoreCase("No"))
			{
				JSONObject jsonObj=(JSONObject) request.getAttribute("htdata");
				if(jsonObj!=null && !jsonObj.isEmpty())
				{		
					rootJson.put("Results",jsonObj);
					session.setAttribute("htdata",jsonObj);
				}
			}else
			{
				JSONArray chartUrls = new JSONArray();
				String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
				queryString +="&chartFor=Top&rtype=chart";
				chartUrls.add(queryString);
				rootJson.put("chartURLs",chartUrls);
			}
			
	

			String s_reportType="";
			if(rtype!=null && rtype.equals("Yes")) {
				s_reportType="Graph";
			} else {
				s_reportType="Data";
			}
			//selectionDetails.put(intlmap.getTextDescription("reporter.common.Type"),rep_genType);
			
			if(s_farmServerAL!=null &&s_farmServerAL.size()!=0)
			{
				String sTxt="";
				for(int cc=0;cc<s_farmServerAL.size();cc++)
				{
					sTxt+=(String) s_farmServerAL.get(cc)+",";
				}
				if(sTxt.indexOf(",")>-1)
					sTxt=sTxt.substring(0,sTxt.length()-1);
				if(sTxt.equalsIgnoreCase(ConstantDispName))
					sTxt=ConstantDispNameDisp;
		
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Service"),sTxt);
			}
			String values="";
			if(s_serverArr!=null)
			{
				for(int m=0;m<s_serverArr.length;m++)
				{
					String str=(String) s_serverArr[m];
					if(str.indexOf(":")>-1)
					str=str.substring(0,str.indexOf(":"));
					values+=str;
					
					if(m!=s_serverArr.length-1)
						values+=",";
				}
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Components"),values);
			}
				
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Exclude weekends"),excludeweekend);
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period "),"<span class='font_bold'></span> "+Hourfrom+":"+Minfrom+"<span class='font_bold'> "+intlmap.getTextDescription("reporter.common.to")+" </span>"+Hourto+":"+Minto);
			selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),"<span class='font_bold'></span> "+pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <span class='font_bold'> "+intlmap.getTextDescription("reporter.common.to")+" </span> "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" "+tzName);

			
	


			rootJson.put("selectionDetails",selectionDetails);
			selectionDetailsForXl=selectionDetails;
			selectionDetailsForXl.put((String)intlmap.getTextDescription("reporter.common.TimelineXL")," "+pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+"  "+intlmap.getTextDescription("reporter.common.to")+" "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" "+tzName);
			selectionDetailsForXl.put(intlmap.getTextDescription("reporter.common.Time PeriodXL "),""+Hourfrom+":"+Minfrom+" "+intlmap.getTextDescription("reporter.common.to")+""+Hourto+":"+Minto);

			JSONObject jsonObj=(JSONObject)session.getAttribute("htdata");
			jsonObj.put("selectionDetailsForXl",selectionDetailsForXl);

			

		}


if(bggroundStr != null && !bggroundStr.equals(""))
{
	rootJson.put("backgroundReportStatus",status);


	String strreportName ="RUM_Report";
	if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
	{
		strreportName ="All Report Types";


	}
		String bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
		rootJson.put("bgroundResponseTxt",bgroundResponseTxt);
		rootJson.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&er_userid="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		rootJson.put("backgroundAnchor", intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));



}


		
		rootJson.put("hiddenfields",hiddenfieldsJson);
		rootJson.put("screenLabels",screenLabelJson);
		out.println(rootJson.toString());	

	}catch(Throwable t)
	{
		t.printStackTrace();
	}
	

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
