package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.supermanager.*;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.eg.IniFile;
import com.eg.EgGroupInfo;
import com.eg.EgStateZone;
import com.eg.EgInstallInfo;
import com.egurkha.ini.IniUI;
import com.egurkha.util.*;
import com.egurkha.monitor.EgGeoCoordinate;
import com.egurkha.monitor.GeoCoordinateGenerator;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.json.*;

public final class zoneMapCoordinate_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgMonitorTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/**************************************************************************************************
*	Name			:	zoneMapCoordinate.jsp
*	Purpose			:	Returns the state information of the zones to the map.
*	Version			:	eG 4.0
*	Author			:	N.Gokulanand
*	Creation Date	:	April-17-2007
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***************************************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String mgrDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	boolean isMobileCall=false;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;	
	String fromMobile=request.getParameter("fromMobile");
	String isFromMenu=request.getParameter("isFromMenu");
	String dateFormatForDatePicker ="";

	User u_ser = null;
	EgMappingInfo mappingInfo = null;
	String trackerLanguage = trackerUI.getDefaultLanguage();
	/**
			 Operation - Mobile check
			 Purpose - Support for accessing the manager via mobile.
			 Author - Praveen 8/4/2014
	**/
	if (fromMobile!=null&&fromMobile.equals("yes"))
	{
		String uname=request.getParameter("uname");
		isMobileCall=true;
		try
		{
			ErUserData userData = new ErUserData(uname,false);
			if(userData!=null)
			{
				u_ser=userData.usr;
				if(u_ser==null)
				{
					u_ser = userData.getUser(uname);
				}
				if(u_ser!=null)
				{
					String userLang = u_ser.getLanguage();
					if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
					{
						trackerLanguage=userLang;
					}
					mappingInfo = new EgMappingInfo(trackerLanguage);
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	} // Ends here
	else
	{
		if(session.getAttribute("sessionId_SM") != null)
		{
			from_sm = true;
			sessionId_sm = (String)session.getAttribute("sessionId_SM");
		}
		if(session!=null)
		{
			if(from_sm)
			{
				u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
			}
			else
			{
				u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
			}
			if(u_ser!=null)
			{
				id_u = u_ser.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  u_ser.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = u_ser.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
		if ( session != null || u_ser != null )
		{
			String smartValue=request.getParameter("smart");
			String page_help=request.getRequestURI();
			if(isFromMenu != null && isFromMenu.trim().length() > 0 && smartValue==null || (smartValue!=null && smartValue.trim().length()==0) )
			{
				if(!(page_help.endsWith("EgPrintGraph.jsp") || page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")))
					session.setAttribute("Page_IdentifierM", request.getRequestURI());
			}
		}

		if (u_ser!=null)
		{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
		}
		mappingInfo = new EgMappingInfo(trackerLanguage);
		if(u_ser != null)
		{
			dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		}
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}

		if(session == null || u_ser == null)
		{
			throw new Exception("<customerror>user-session-invalid</customerror>");
		}
		else if(id_u== true)
		{
			throw new Exception("<customerror>user-deleted</customerror>");
		}
		else if (u_v_till < l_accessed)
		{
			throw new Exception("<customerror>user-timedout</customerror>");
		}
	}


	/** Getting the refresh time for the IniUI file */
	response.setContentType("application/json");
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	String parentZone = null;
	
	String sessionId = session.getId();
	double minLat = 90;
	double minLng = 180;
	double maxLat = -90;
	double maxLng = -180;
	parentZone = request.getParameter("Zone");
	String allcase = request.getParameter("all");
	IniFile groupIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String showAllSub = groupIni.getValue("ShowSubZone","ShowSubZoneMap");
	boolean allFlag = false;
	if(allcase != null && allcase.trim().length() > 0 && allcase.equalsIgnoreCase("true"))
		allFlag=true;
	else if((allcase == null || allcase.trim().length()==0) && (showAllSub != null && (showAllSub.equalsIgnoreCase("true") || showAllSub.equalsIgnoreCase("yes"))))
		allFlag=true;
	boolean isSelectedZone = false;
	if(parentZone!=null && !parentZone.equalsIgnoreCase("NULL") && parentZone.trim().length()>0)
		isSelectedZone = true;
	GeoCoordinateGenerator geoCode;
	EgGroupInfo groupInfo = new EgGroupInfo();
	JSONObject json  = new JSONObject();
	List mainZoneList = new LinkedList();
	mainZoneList = u_ser.getZones();

	if(mainZoneList!=null && mainZoneList.size()>0)
	{
		ArrayList tempZones=new ArrayList(mainZoneList);
		for(int i=0;i<tempZones.size();i++)
		{
			String tempZone =(String)tempZones.get(i);
			if(tempZone!=null && tempZone.trim().length()>0)
			{
				ArrayList subZones=(ArrayList)groupInfo.getSubZoneList(tempZone,false);

				if(subZones!=null && subZones.size()>0)
				{
					mainZoneList.addAll(subZones);
				}
			}
		}
		mainZoneList=ListUtils.removeDuplicates(mainZoneList);
	}
	/** To consider only the subzones under the zone */
	if(parentZone != null && !parentZone.equals(""))
	{
		geoCode = new GeoCoordinateGenerator(sessionId, parentZone);


	}
	else
	{
		/** To consider all zones under a User */
		geoCode = new GeoCoordinateGenerator(sessionId);
	}
	
	//IniFile groupIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	ArrayList zoneDetails = geoCode.getZoneDetails();
	String[] noSubZone = groupIni.getVariables("LIST_OF_ZONES");
	ArrayList zonelist = new ArrayList();
	if(noSubZone!=null && noSubZone.length>0)
	{
		for(int p=0;p<noSubZone.length;p++)
		{
			if(noSubZone[p]!=null && noSubZone[p].trim().length()>0 && mainZoneList.contains(noSubZone[p]))
			{
				zonelist.add(noSubZone[p]);
			}
		}
	}

	ArrayList latitudeArray = new ArrayList();
	ArrayList longitudeArray = new ArrayList();
	
	JSONArray  zoneArray = new JSONArray();
	JSONArray  stateArray = new JSONArray();
	JSONArray  jsonLatitudeArray = new JSONArray();
	JSONArray  jsonLongitudeArray = new JSONArray();
	JSONArray  subZoneMapCount = new JSONArray();
	JSONArray  subZoneListCount = new JSONArray();
	JSONArray  southWestGeoCode = new JSONArray();
	JSONArray  northEastGeoCode = new JSONArray();
	JSONArray  centerGeoCode = new JSONArray();
		
	for(int i=0;i<zoneDetails.size();i++)
	{
		EgGeoCoordinate res = (EgGeoCoordinate) zoneDetails.get(i);
		zonelist.remove(res.zoneName);
		ArrayList subZoneList =groupInfo.getDirectSubZoneList(res.zoneName, false);
		int numberOfSubZones = 0;
		if(subZoneList != null && subZoneList.size() > 0)
		{
			for(int k=0;k<subZoneList.size();k++)
			{
				StringTokenizer st = new StringTokenizer(groupIni.getValue("ZONE_LOCATION", (String)subZoneList.get(k)), "|");
				int switchCount = 0;
				boolean latitudeExsist = false;
				boolean longitudeExsist = false;

				/** To collect the zone Coordinates (latitude, longitude) */
				while (st.hasMoreTokens())
				{
					String currentToken = st.nextToken();
					switch(switchCount)
					{
						case 0:
							if(!currentToken.equals("null"))
							{
								latitudeExsist = true;
							}
						break;
						case 1:
							if(!currentToken.equals("null"))
							{
								longitudeExsist = true;
							}
						break;
					}
					if(latitudeExsist && longitudeExsist)
					{
						numberOfSubZones++;
					}
					switchCount++;
				}
			}
		}
		String state = EgStateZone.getState("Zone:"+res.zoneName+":NULL");
		latitudeArray.add(String.valueOf(res.latitude));
		longitudeArray.add(String.valueOf(res.longitude));
		
		zoneArray.add(res.zoneName);
		stateArray.add(state);
		jsonLatitudeArray.add(res.latitude);
		jsonLongitudeArray.add(res.longitude);
		subZoneMapCount.add(numberOfSubZones);
		subZoneListCount.add(subZoneList.size());


	}
	if(zonelist != null && zonelist.size() > 0 && allFlag && !isSelectedZone){
		for(int p=0;p<zonelist.size();p++){
			String zZoneName = (String)zonelist.get(p);
			if(zZoneName == null || zZoneName.trim().length() == 0)
				continue;

			ArrayList subZoneList =groupInfo.getDirectSubZoneList(zZoneName, false);
			int numberOfSubZones = 0;
			if(subZoneList != null && subZoneList.size() > 0)
			{
				for(int k=0;k<subZoneList.size();k++)
				{
					StringTokenizer st = new StringTokenizer(groupIni.getValue("ZONE_LOCATION", (String)subZoneList.get(k)), "|");
					int switchCount = 0;
					boolean latitudeExsist = false;
					boolean longitudeExsist = false;

					/** To collect the zone Coordinates (latitude, longitude) */
					while (st.hasMoreTokens())
					{
						String currentToken = st.nextToken();
						switch(switchCount)
						{
							case 0:
								if(!currentToken.equals("null"))
								{
									latitudeExsist = true;
								}
							break;
							case 1:
								if(!currentToken.equals("null"))
								{
									longitudeExsist = true;
								}
							break;
						}
						if(latitudeExsist && longitudeExsist )
						{
							numberOfSubZones++;
						}
						switchCount++;
					}
				}
			}

			String state = EgStateZone.getState("Zone:"+zZoneName+":NULL");
			String zoneLatlang = groupIni.getValue("ZONE_LOCATION",zZoneName);
			String lat="";
			String lang="";
			
			if( zoneLatlang.trim().equalsIgnoreCase("null|null") )
				continue;

			if(zoneLatlang != null && zoneLatlang.indexOf("|") != -1){
				lat = zoneLatlang.substring(0,zoneLatlang.indexOf("|"));
				lang = zoneLatlang.substring(zoneLatlang.indexOf("|")+1);
				latitudeArray.add(String.valueOf(lat.trim()));
				longitudeArray.add(String.valueOf(lang.trim()));
			}

			zoneArray.add(zZoneName);
			stateArray.add(state);
			jsonLatitudeArray.add(lat);
			jsonLongitudeArray.add(lang);
			subZoneMapCount.add(0);
			subZoneListCount.add(0);
		}
	}
	json.put("zoneArray",zoneArray);
	json.put("stateArray",stateArray);
	json.put("latitudeArray",jsonLatitudeArray);
	json.put("longitudeArray",jsonLongitudeArray);
	json.put("subZoneMapCount",subZoneMapCount);
	json.put("subZoneListCount",subZoneListCount);

	/** To calculate minimun and maximum coordinate of tha map area to be displayed */
	if(latitudeArray.size() != 0 && longitudeArray.size() != 0)
	{
		for (int i=0;i<latitudeArray.size();i++)
		{
			double miniLat = Double.parseDouble((String)latitudeArray.get(i));
			if(miniLat < minLat)
			{				
				minLat = miniLat;
			}
			double maxiLat = Double.parseDouble((String)latitudeArray.get(i));
			if(maxiLat > maxLat)
			{				
				maxLat = maxiLat;
			}		
		}
		for (int i=0;i<longitudeArray.size();i++)
		{
			double miniLng = Double.parseDouble((String)longitudeArray.get(i));
			if(miniLng < minLng)
			{				
				minLng = miniLng;
			}
			double maxiLng = Double.parseDouble((String)longitudeArray.get(i));
			if(maxiLng > maxLng)
			{
				maxLng = maxiLng;
			}
		}
		minLat = (minLat-1);
		minLng = (minLng-1);
		maxLat = (maxLat+1);
		maxLng = (maxLng+1);

		/** To calculate the Center coordinate of tha map area to be displayed */
		double avgLat = (((maxLat-minLat)/2)+minLat);
		double avgLng = (((maxLng-minLng)/2)+minLng);
		
		southWestGeoCode.add(minLat);
		southWestGeoCode.add(minLng);
		northEastGeoCode.add(maxLat);
		northEastGeoCode.add(maxLng);
		centerGeoCode.add(avgLat);
		centerGeoCode.add(avgLng);
		
		json.put("southWestGeoCode",southWestGeoCode);
		json.put("northEastGeoCode",northEastGeoCode);
		json.put("centerGeoCode",centerGeoCode);
	}
	try{
		response.getWriter().write(json.toString());
	}
	catch(Exception zoneMapException)
	{
		System.out.println("Exception in zoneMap..");
		zoneMapException.printStackTrace();
	}


    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
