package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.egurkha.monitor.*;
import com.eg.*;
import java.text.*;
import com.egurkha.util.DateTimeTokenizer;
import com.egurkha.util.*;
import com.eg.EgSpecsInfo;
import egurkha.reporter.ErUtils;
import egurkha.*;
import com.egurkha.EgUserPermission;
import com.egurkha.monitor.EgServerDashboardModel;
import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.supermanager.*;
import net.sf.json.*;
import com.egurkha.util.MathUtils;

public final class egDashboardOverviewJSON_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgServerDashboardTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("application/json;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbsM.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*****************************************************************************************************
 *	Name			:	EgServerDashboardTracker.jsp
 *	Version			:	eG 5.6
 *	Purpose			:	
 *	Creation Date	:	24-05-2012
 *	Last Modified	:	
 *****************************************************************************************************/


	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = null;

	boolean from_sm = false;
	String sessionId_sm = null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{
			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if (u_ser!=null)
	{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
			String trackerUserLang = u_ser.getLanguage();
			if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
			{
				trackerLanguage=trackerUserLang;
			}
	}
	String  script_src="script_item_"+trackerLanguage+".js";

	String uiFileTemp = "eg_ui.ini";
	String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);

	String mgrDateFormat = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(u_ser !=null)
	{
		String dateFormatForDatePicker = (String)u_ser.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}
	}

	if(session == null || u_ser == null)
    {
        throw new Exception("<customerror>user-session-invalid</customerror>");
    }
    else if(id_u== true)
    {
        throw new Exception("<customerror>user-deleted</customerror>");
    }
    else if (u_v_till < l_accessed)
    {
        throw new Exception("<customerror>user-timedout</customerror>");
    }


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);


try
{
	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
	
	long HOUR=60*60*1000;
	long DAY=24*60*60*1000;
	SimpleDateFormat  sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
	java.util.Date end_Date=new java.util.Date();
	java.util.Date start_Date=new java.util.Date(end_Date.getTime()-(HOUR));
	java.util.Date start_DateForDay=new java.util.Date(end_Date.getTime()-(DAY));

	String compType=request.getParameter("compType");
	if (EgInstallInfo.isSuperManager)
	{
		String s_comp = compType+":"+request.getParameter("hostName");// gen_26:NULL:Generic_server
		String currentSession = session.getId();
		if(s_comp != null && s_comp.indexOf(":")>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("component",s_comp);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				EgThreadLocal.clear();
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}

	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	EgUserRole userRole = u_ser.getUserRole();
	String monitorSkin = u_ser.getMonitorSkin();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgAgentInfo agentInfo = new EgAgentInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();
	Hashtable  list = null;
	String lastmsmtTime = "";
	int lastmsmtTimeIndex =0;
	boolean isAnyTestExcludedOrDisabledForDial = false;
	String dashboardIni = "eg_serverdashboard.ini";

	EgServerDashboardModel  egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);
	IniFile uiIni=new IniFile(s_iniFile_dir+"eg_ui.ini");
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(session.getId(),trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(session.getId(),trackerLanguage);
	String currentDateFormat = uiIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();

	ErUtils  erutils=new  ErUtils();
	SimpleDateFormat testDateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	SimpleDateFormat timeOutDateFormat= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
	String subject=request.getParameter("subject");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	Hashtable measureLastData = dashboardDAO.getMeasureLast();

	if(tab==null)
		tab="System";

	String compName=request.getParameter("hostName");
	String tmpCmpName = compName;
	if(compName!=null && compName.endsWith(":NULL"))
	{
		tmpCmpName = compName.substring(0,compName.indexOf(":NULL"));
	}	

	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
						session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	String hostName="";
	String portNo="";
	String sid="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startDateTime="";
	String endDateTime="";
	String state="";
	String info="";
	String msmtHost="";
	String test="";
	String measure="";
	String site=request.getParameter("site");

	if(site==null || site.trim().length()==0)
		site="NULL";

	int emptyTDCount=0;
	int digitalChartCount=0;
	int digitalChartNoMeasuresCount=0;
	int dialChartNoMeasuresCount=0;
	boolean isTRNeedInDigitalChart=false;
	boolean isTRNeedInDialChart=false;
	boolean isEjbGroupingRequired = false;
	int tempDialGraphCount=0;
	int tempDigitalGraphCount=0;
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	boolean isOracleServer=false;
	String cnameDAO = compName;
	if(compType.equalsIgnoreCase("Oracle_server") && compName.indexOf(":")!=compName.lastIndexOf(":"))
	{
		isOracleServer=true;
		cnameDAO = compName.substring(0,compName.lastIndexOf(":"));
	}
	boolean isWeblogicServer=false;
	if(compType!=null && (compType.equals("WebLogic_server") || compType.equalsIgnoreCase("weblogic6x_server")))
		isWeblogicServer=true;
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	ArrayList enabledConfigTests=specsInfo.getEnabledTests(compType,true);

	boolean isSystemTab=(tab!=null && tab.equalsIgnoreCase("System"));
	boolean isNetworkTab=(tab!=null && tab.equalsIgnoreCase("Network"));
	boolean isApplicationTab=(tab!=null && tab.equalsIgnoreCase("Application"));
		list =(Hashtable) measureLastData.get(cnameDAO);

	int divCount=0;
	if(isSystemTab)
	{
		subject="System_Dashboard_Metrics";
	}
	else if(isNetworkTab)
	{
		subject="Network_Dashboard_Metrics";
	}
	else
	{
		subject=compType;
	}

	String s_specificsubject=iniObj.getValue("CommonDashboardConfiguration",compType);

	String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
	String DialChartNeed=iniObj.getValue("Dashboard_Settings","UseDial");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	if(DialChartNeed==null || DialChartNeed.equals(""))
		DialChartNeed="Yes";

	if((isSystemTab || isNetworkTab) && s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes"))
	{
		subject=compType;
	}

	egDashboard.setSubject(subject);

	Hashtable currentStatus=egDashboard.getCurrentStatusForServer(compName,compType,tab);
	Hashtable performanceIndicators=egDashboard.getPerformanceIndicators(compName,compType,tab,site);
	String defaultSparklineDuration=iniObj.getValue("Default_SparkLineGraph_Duration","duration");
	if(defaultSparklineDuration==null || (defaultSparklineDuration!=null && defaultSparklineDuration.equals("")))
		defaultSparklineDuration="1 hour";
	String sparkLineStartTime="";
	String sparkLineEndTime="";
	String sparkLineStartHour="";
	String sparkLineEndHour="";
	Vector sparkLineTimes=egDashboard.getStartEndDateTimeForMeasure(defaultSparklineDuration);
	if(sparkLineTimes!=null && sparkLineTimes.size()>=4)
	{
		sparkLineStartTime=(String)sparkLineTimes.get(0);
		sparkLineEndTime=(String)sparkLineTimes.get(1);
		sparkLineStartHour=(String)sparkLineTimes.get(2);
		sparkLineEndHour=(String)sparkLineTimes.get(3);
	}

	boolean isFullViewForKPI=false;
	boolean isFullViewForConfig=false;
	String lastFullViewURL=(String)session.getAttribute("lastFullViewURLForDashboard");
	String fullViewGraphType="";

	if(lastFullViewURL!=null && (!lastFullViewURL.equals("") && !lastFullViewURL.equalsIgnoreCase("null")))
	{
		String tempLastFullViewURL=lastFullViewURL.substring((lastFullViewURL.indexOf("?")+1));
		StringTokenizer stkParams=new StringTokenizer(tempLastFullViewURL,"&");
		while(stkParams.hasMoreTokens())
		{
			String paramWithValue=stkParams.nextToken();
			if(paramWithValue!=null && paramWithValue.indexOf("=")>0)
			{
				String param=paramWithValue.substring(0,paramWithValue.indexOf("="));
				if(param!=null && param.equals("isFullView"))
				{
					String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(value!=null && value.equalsIgnoreCase("true"))
					{
						isFullViewForKPI=true;
					}
					
				}
				else if(param!=null && param.equals("isFullViewForConfig"))
				{
					String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(value!=null && value.equalsIgnoreCase("true"))
					{
						isFullViewForConfig=true;
						break;
					}
					
				}
				else if(param!=null && param.equals("graphType"))
				{
					fullViewGraphType=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(fullViewGraphType!=null && (!fullViewGraphType.equals("") && !fullViewGraphType.equalsIgnoreCase("null")))
					{
						if(isFullViewForKPI)
							break;
					}

				}
			}
		}
	}
	EgMemCheck memCheck = new EgMemCheck();
	boolean hasConfig=memCheck.isCMEnabled();
	Vector configData=new Vector();

	if(hasConfig)
	{
		if(isSystemTab)
			configData=egDashboard.getSystemConfig(compName,compType);
		else if(isNetworkTab)
			configData=egDashboard.getNetworkConfig(compName,compType);
		else
			configData=egDashboard.getApplicationConfig(compName,compType);
	}
	if(hasConfig)
		hasConfig=userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String overviewDialGraphs=iniObj.getValue(subject,tab+"_Overview_DialGraphs");
	String digitalGraphs=iniObj.getValue(subject,tab+"_Overview_DigitalGraphs");

	int graphCount=0;

	Vector runningtests=dashboardDAO.getRunningTestsForServer(compName,compType,tab);
	runningtests.retainAll(enabledTests);

	String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
	state=egDashboard.getServerState(hostName,compType,site);

	String s_disabledBlocks=iniObj.getValue("Disabled_blocks",tab+"_Overview");
	Vector disabledBlocks=egDashboard.getTokensAsVector(s_disabledBlocks,",");
	Vector times=egDashboard.getStartEndDateTimeForMeasure(defaultMGraphDuration);

	if(times!=null && times.size()>=4)
	{
		startTime=(String)times.get(0);
		endTime=(String)times.get(1);
		startHour=(String)times.get(2);
		endHour=(String)times.get(3);
	}

	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));

	String healthTitle=tab;
	if(healthTitle.equalsIgnoreCase("System"))
	{
		healthTitle="OS";
	}
	double defaultPieGraphWidth=191; // default pie graph width for calculation
	double defaultPieGraphHeight=115;  // default pie graph height for calculation
	double defaultPieRadius=40;  // default pie graph radius for calculation
	double pieGraphWidth=191;
	double pieGraphHeight=115;
	String pieRadius="40"; //default radius for 190 width
	double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
	pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
	pieGraphWidth=MathUtils.round(pieGraphWidth,0);
	double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;
	pieGraphHeight=pieGraphWidth*pieGraphHeightToDefaultWidthInPercent;
	pieGraphHeight=MathUtils.round(pieGraphHeight,0);
	double pieRadiusToDefaultWidthInPercent=defaultPieRadius/defaultPieGraphWidth;
	double pieRadiusInDouble=pieGraphWidth*pieRadiusToDefaultWidthInPercent;
	pieRadius=erutils.round(pieRadiusInDouble,0);
	int count=0;
	Vector healthChartAttributes=new Vector();
	healthChartAttributes.add("palette='2'");
	healthChartAttributes.add("decimals='2'");
	healthChartAttributes.add("enableRotation='1'");
	healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
	healthChartAttributes.add("bgAlpha='0,0'");
	healthChartAttributes.add("bgRatio='0,100'");
	healthChartAttributes.add("bgAngle='360'");
	healthChartAttributes.add("showBorder='0'");
	healthChartAttributes.add("startingAngle='80'");
	//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
	healthChartAttributes.add("chartLeftMargin ='0'");
	healthChartAttributes.add("chartTopMargin ='0'");
	healthChartAttributes.add("chartBottomMargin ='0'");
	healthChartAttributes.add("chartRightMargin ='0'");
	healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieSliceDepth='7'");
	healthChartAttributes.add("numberSuffix='%'");
	//healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
	healthChartAttributes.add("pieInnerFaceAlpha  ='100'");
	healthChartAttributes.add("pieYScale  ='60'");
	healthChartAttributes.add("smartLineColor  ='000000'");
	healthChartAttributes.add("smartLabelClearance  ='2'");
	healthChartAttributes.add("captionPadding  ='0'");
	healthChartAttributes.add("bgSWFAlpha  ='0'");
	healthChartAttributes.add("enableSmartLabels='1'");
	healthChartAttributes.add("pieRadius='"+pieRadius+"'");
	healthChartAttributes.add("labelDistance='6'");
	healthChartAttributes.add("isSmartLineSlanted='1'");
	healthChartAttributes.add("exportEnabled='0'");
	healthChartAttributes.add("exportAction='download'");
	healthChartAttributes.add("exportAtClient='0'");
	healthChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

	String xmlData=graphUtil.getXMLtoHealth(compName,compType,tab,healthChartAttributes);

	JSONObject healthObj = new JSONObject();
	healthObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Current "+healthTitle+" Health"));
	healthObj.put("HEIGHT", pieGraphHeight+"");
	healthObj.put("WIDTH", pieGraphWidth+"");
	if(xmlData!=null && !xmlData.trim().equals(""))
	{
		healthObj.put("XML_DATA", xmlData);
		healthObj.put("SWF_PATH", "/final/FusionCharts/swf/Pie3D.swf");
	}
	else
	{
		healthObj.put("XML_DATA", "-");
		healthObj.put("MSG", mappingInfo.getTextDescription("monitor.common.No measures available")+"!");
	}
	rootJson.put("HEALTH", healthObj);
	if(isApplicationTab && isWeblogicServer)
	{
		JSONObject heapUsageObj = new JSONObject();
		heapUsageObj.put("HEIGHT", (pieGraphHeight+20)+"");
		heapUsageObj.put("WIDTH", pieGraphWidth+"");
		heapUsageObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Weblogic Heap Usage"));
			
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
		if(runingTestList!=null && runingTestList.contains("WebLogicTest"))
		{
			boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType,tmpCmpName,"WebLogicTest");
			if(enabledTests!=null && enabledTests.contains("WebLogicTest") && !isExcludedTest)
			{
				heapUsageObj.put("DATA", "true");
				HashMap MeasureValues=new HashMap();
				Vector jvmHeapAttributes=new Vector();
				double freeHeapSizeMeasure=0.0;
				double totalHeapSizeMeasure=0.0;
				boolean isTestHas_CutOffFactor=false;
				msmtHost=(String)allMsmtHosts.get("WebLogicTest");
				String totalHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Total_heap_size");
				String freeHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Free_heap_size");
				String totalHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",totalHeapSizeDBColumn,msmtHost);
				String freeHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",freeHeapSizeDBColumn,msmtHost);
				if((totalHeapSize!=null && !totalHeapSize.equals("") && !totalHeapSize.equalsIgnoreCase("null")) && (freeHeapSize!=null && !freeHeapSize.equals("") && !freeHeapSize.equalsIgnoreCase("null")))
				{
					totalHeapSizeMeasure=Double.parseDouble(totalHeapSize);
					freeHeapSizeMeasure=Double.parseDouble(freeHeapSize);
					double usedHeapSizeMeasure=totalHeapSizeMeasure-freeHeapSizeMeasure;
					usedHeapSizeMeasure=((usedHeapSizeMeasure/totalHeapSizeMeasure)*100);
					freeHeapSizeMeasure=((freeHeapSizeMeasure/totalHeapSizeMeasure)*100);
					String usedHeapSize=erutils.round(usedHeapSizeMeasure,2);
					freeHeapSize=erutils.round(freeHeapSizeMeasure,2);
					if((usedHeapSize!=null && !usedHeapSize.equals("") && !usedHeapSize.equalsIgnoreCase("null")))
					{
						MeasureValues.put("Used_heap",usedHeapSize);
						MeasureValues.put("Free_heap",freeHeapSize);
					}
				}
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor("WebLogicTest"))
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,"WebLogicTest",msmtHost,"+");
						if(isTestExceededCutOffFactor)
						{
							isTestHas_CutOffFactor=true;
						}
					}
				}
				jvmHeapAttributes.add("palette='2'");
				jvmHeapAttributes.add("decimals='2'");
				jvmHeapAttributes.add("enableRotation='1'");
				jvmHeapAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmHeapAttributes.add("bgAlpha='0,0'");
				jvmHeapAttributes.add("bgRatio='0,100'");
				jvmHeapAttributes.add("bgAngle='360'");
				jvmHeapAttributes.add("showBorder='0'");
				jvmHeapAttributes.add("startingAngle='80'");
				jvmHeapAttributes.add("chartLeftMargin ='20'");
				jvmHeapAttributes.add("chartTopMargin ='10'");
				jvmHeapAttributes.add("chartBottomMargin ='10'");
				jvmHeapAttributes.add("chartRightMargin ='10'");
				jvmHeapAttributes.add("showToolTipShadow ='1'");
				jvmHeapAttributes.add("pieSliceDepth='7'");
				jvmHeapAttributes.add("numberSuffix='%'");
				//jvmHeapAttributes.add("showToolTipShadow ='1'");
				jvmHeapAttributes.add("pieOuterFaceAlpha  ='75'");
				jvmHeapAttributes.add("pieInnerFaceAlpha  ='100'");
				jvmHeapAttributes.add("pieYScale  ='60'");
				jvmHeapAttributes.add("smartLineColor  ='000000'");
				jvmHeapAttributes.add("smartLabelClearance  ='2'");
				jvmHeapAttributes.add("captionPadding  ='0'");
				jvmHeapAttributes.add("bgSWFAlpha  ='0'");
				jvmHeapAttributes.add("enableSmartLabels='1'");
				jvmHeapAttributes.add("pieRadius='"+pieRadius+"'");
				jvmHeapAttributes.add("labelDistance='6'");
				jvmHeapAttributes.add("isSmartLineSlanted='1'");
				jvmHeapAttributes.add("exportEnabled='0'");
				jvmHeapAttributes.add("exportAction='download'");
				jvmHeapAttributes.add("exportAtClient='0'");
				jvmHeapAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				String xmlDataForJVMHeap="";
				if(MeasureValues!=null && !MeasureValues.isEmpty())
					xmlDataForJVMHeap=graphUtil.getXMLForHeap(MeasureValues,jvmHeapAttributes,"Overview");
				if(xmlDataForJVMHeap!=null && !xmlDataForJVMHeap.equals("") && !isTestHas_CutOffFactor)
				{
					heapUsageObj.put("XML_DATA", xmlDataForJVMHeap);
					heapUsageObj.put("SWF_PATH", "/final/FusionCharts/swf/Pie3D.swf");
				}
				else
				{
					heapUsageObj.put("XML_DATA", "-");
					heapUsageObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
				}
			}
			else
			{
				heapUsageObj.put("XML_DATA", "-");
				heapUsageObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled!"));
			}
		}
		else
		{
			heapUsageObj.put("DATA", "false");
			heapUsageObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
		}
		rootJson.put("WEBLOGIC_HEAP_USAGE", heapUsageObj);
	}
	boolean isHopDelayNeed=true;
	if(isNetworkTab)
	{
		int dialcount=0;
		boolean isNetworkTests=false;
		String tempDialGraphtest="";
		StringTokenizer stkSubSystemTestMeasures=new StringTokenizer(overviewDialGraphs,",");
		ArrayList defaultTests = egDashboard.getDefaultTestsForServer(compType);
		while(stkSubSystemTestMeasures.hasMoreTokens())
		{
			String subSystemTestMeasures=stkSubSystemTestMeasures.nextToken();
			String subSystemTest=subSystemTestMeasures.substring(0,subSystemTestMeasures.indexOf(":"));
			boolean isRelevent=specsInfo.isTestRelevantForServer(compType,subSystemTest);
			if(subSystemTestMeasures.trim().equals("NetworkTest:Availability")) {
				isNetworkTests=true;
				
			}
			else if(subSystemTestMeasures.trim().equals("NetworkTest:Pkt_loss_pct")) {
				isNetworkTests=true;
			}
			if(specsInfo.isTestRelevantForServer(compType,subSystemTest) && (runningtests.contains(subSystemTest) || isNetworkTests))
			{
				tempDialGraphtest+=subSystemTestMeasures+",";
				dialcount++;
			}

			if(defaultTests != null && defaultTests.contains(subSystemTest) && enabledTests != null && !enabledTests.contains(subSystemTest)) {
				isAnyTestExcludedOrDisabledForDial = true;
			}	
		}

		if(dialcount>2)
			isHopDelayNeed=false;

		if(tempDialGraphtest!=null && tempDialGraphtest.indexOf(",")!=-1)
			tempDialGraphtest=tempDialGraphtest.substring(0,tempDialGraphtest.length()-1);

		overviewDialGraphs=tempDialGraphtest;
	}

	Vector dialGraphtests=egDashboard.getTokensAsVector(overviewDialGraphs,",");
	int dialChartCount=0;
	ArrayList dialmeasuresNAList = new ArrayList();
	double defaultDialGraphWidth=191;  // default dial graph width for calculation
	double defaultDialGraphHeight=115;  // default dial graph height for calculation
	double dialGraphWidth=191;  
	double dialGraphHeight=115;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=65; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="62";
	String gaugeXPos="90";
	String gaugeYPos="93";
	if(dialGraphtests.size()>0)
	{
		dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
		dialGraphWidth=MathUtils.round(dialGraphWidth,0);
		dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
		dialGraphHeight=MathUtils.round(dialGraphHeight,0);
		double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
		double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
		gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
		double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
		double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
		double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
		gaugeXPos=erutils.round(gaugeXPosInDouble,0);
		double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
		gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	}
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);

	boolean isAllDialGraphHasNoMeasures=false;
	
	JSONArray dialArr = new JSONArray();
	for(int i= 0; i < dialGraphtests.size();i++ )
	{
		JSONObject dialObj = new JSONObject();
		String testmeasure=(String)dialGraphtests.get(i);
		test=testmeasure.substring(0,testmeasure.indexOf(":"));
		measure=testmeasure.substring(testmeasure.indexOf(":")+1);

		boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType, tmpCmpName, test);
		if(isExcludedTest) {
			isAnyTestExcludedOrDisabledForDial = true;
			continue;
		}

		if(enabledTests!=null && !enabledTests.contains(test)) {
			isAnyTestExcludedOrDisabledForDial = true;
			continue;
		}	

		msmtHost=(String)allMsmtHosts.get(test);

		String measureValue="";
		String measureForDB=dbInfo.getColumnForMeasure(test,measure);

		String dial_measureMapping=iniObj.getValue("Dashboard_Dial_mapping",testmeasure);


		if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
			dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);

		String tooltip=dial_measureMapping;

		if(dial_measureMapping!=null && !dial_measureMapping.equals("") && dial_measureMapping.length()>24)
			dial_measureMapping=dial_measureMapping.substring(0,21)+"...";

		msmtHost=(String)allMsmtHosts.get(test);
		String unit=tablesInfo.getUnitForMeasure(test,measure);
		if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
			continue;
		if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
			unit="%";

		Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,test,tab);
		String oneMsmtTime=dashboardDAO.lastMeasurementTimeForTest(compName,compType,test,tab);
		if(msmtHost==null)
			msmtHost="";
		boolean isFullView=false;
		Vector infos=(Vector)allTestInfos.get(test);
		Vector infosForCutOffFactor = new Vector();
		boolean isTestHas_CutOffFactor=true;
		if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
		{
			
			if(egDashboard.isTestHasCutOffFactor(test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,(String)infos.get(d));
						if(isTestExceededCutOffFactor)
						{
							infosForCutOffFactor.add(infos.get(d));
						}
						else
						{
							isTestHas_CutOffFactor=false;
						}
					}
				}
				/*if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}*/				
			}
		}
		if(infos!=null && !infos.isEmpty() && infos.size()>1)
		{
			isFullView=true;
		}


		if (test != null && test.equals("SystemTest") &&  measure != null &&  measure.equals("Cpu_util")) {
				info = "+Summary";
		} else {
			info = fusionChart.getInfoForDial(test, measure, compType, hostName, portNo, msmtHost, "NULL", sid, isThresholdNeed);
		}

		if(info!=null && info.indexOf("+")!=-1)
			info=info.substring(info.indexOf("+")+1);

		info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

		Vector dialChartAttributes=new Vector();
		String dialXMLData="";
		if(!isTestHas_CutOffFactor)
		{
			dialChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			//dialChartAttributes.add("unescapeLinks='1'");
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");

			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
			{
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

				//String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=";

				//dialXMLData=graphUtil.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,"dialUrl"+dialChartCount);
				 dialXMLData=graphUtil.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl);
			}
			else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
			{	
					
					Vector jvmChartAttributes=new Vector();
					jvmChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");
					jvmChartAttributes.add("upperLimit='100'");
					jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
					jvmChartAttributes.add("bgAlpha='0,0'");
					jvmChartAttributes.add("showBorder='0'");
					jvmChartAttributes.add("adjustTM='0'");
					jvmChartAttributes.add("lowerLimit='0'");
					jvmChartAttributes.add("decimals='2'");
					jvmChartAttributes.add("showValue='0'");
					jvmChartAttributes.add("majorTMNumber='5'");
					//jvmChartAttributes.add("baseFontSize='8'");
					jvmChartAttributes.add("majorTMColor='000000'");
					jvmChartAttributes.add("majorTMHeight='5'");
					jvmChartAttributes.add("minorTMNumber='2'");
					jvmChartAttributes.add("minorTMColor='000000'");
					jvmChartAttributes.add("minorTMHeight='2'");
					jvmChartAttributes.add("majorTMThickness='1'");
					jvmChartAttributes.add("decimalPrecision='0'");
					jvmChartAttributes.add("ledGap='"+ledGap+"'");
					jvmChartAttributes.add("ledSize='"+ledSize+"'");
					jvmChartAttributes.add("tickValueDistance='2'");
					jvmChartAttributes.add("tickMarkDistance='1'");
					jvmChartAttributes.add("tickValueStep='1'");
					jvmChartAttributes.add("tickValueDecimals='8'");
					jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
					jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
					jvmChartAttributes.add("chartTopMargin='21'");
					jvmChartAttributes.add("chartBottomMargin='20'");
					jvmChartAttributes.add("baseFontSize ='9'");
					jvmChartAttributes.add("showToolTip='1'");
					jvmChartAttributes.add("baseFontColor  ='000000'");
					jvmChartAttributes.add("annRenderDelay='1.7'");
					jvmChartAttributes.add("exportEnabled='0'");
					jvmChartAttributes.add("exportAction='download'");
					jvmChartAttributes.add("exportAtClient='0'");
					jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight);
			}
			String dialInterfaceData="";
			if(dialXMLData !=null && !dialXMLData.equals("") && dialXMLData.indexOf("-")>0)
			{
				dialInterfaceData=dialXMLData.substring(dialXMLData.indexOf("-")+1);
				//dialXMLData=dialXMLData.substring(0,dialXMLData.indexOf("-"));
			}
			if(dialXMLData !=null && !dialXMLData.equals("") && !dialXMLData.equalsIgnoreCase("true"))
			{
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&msmtHost="+msmtHost+"&tab="+tab;
				dialObj.put("TOOL_TIP_TITLE",tooltip+" ("+unit+")");
				dialObj.put("TITLE",dial_measureMapping+" ("+unit+")");
				
				if(isFullView)//sarav info based test image in dial chart 
				{
					dialObj.put("METHOD_NAME", "showMaximizedView");
					dialObj.put("Dial_Fullview", "true");
					dialObj.put("PARAMS", moreDescriptorUrl);
				}
				dialObj.put("XML_DATA", dialXMLData);
				dialObj.put("HEIGHT", ""+dialGraphHeight);
				dialObj.put("WIDTH", ""+dialGraphWidth);
				dialObj.put("subTitle_Dial",info);
				dialObj.put("DialPARAMS","dialUrl"+dialChartCount);
				dialObj.put("dialInterfaceFlag","false");
				if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
				{
					dialObj.put("SWF_PATH", "/final/FusionCharts/swf/AngularGauge.swf"); 
				} 
				else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
				{
					dialObj.put("SWF_PATH", "/final/FusionCharts/swf/VLED.swf");
				}
				hiddens.put("dialUrl"+dialChartCount, layerPageUrl);
				dialChartCount++;
				count++;
			}
			else if(dialXMLData.equalsIgnoreCase("true"))
			{
				dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
				dialObj.put("TOOL_TIP_TITLE",tooltip+" ("+unit+")");
				dialObj.put("TITLE",dial_measureMapping+" ("+unit+")");
				dialObj.put("XML_DATA",dialInterfaceData);
				dialObj.put("dialInterfaceFlag","true");
			}
			else
			{
				dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
				continue;
				/*
				dialObj.put("TOOL_TIP_TITLE",tooltip+" ("+unit+")");
				dialObj.put("TITLE",dial_measureMapping+" ("+unit+")");
				dialObj.put("dialInterfaceFlag","false");
				dialObj.put("XML_DATA","-");*/
			}
		}
		if(dialXMLData ==null || dialXMLData.equals("") || isTestHas_CutOffFactor)
		{
			dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
			continue;
			/*
			dialObj.put("TOOL_TIP_TITLE",tooltip+" ("+unit+")");
			dialObj.put("TITLE",dial_measureMapping+" ("+unit+")");
			dialObj.put("XML_DATA","-");
			dialObj.put("dialInterfaceFlag","false");*/
		}
		if ( !dialObj.isEmpty() )
		{
			dialArr.add(dialObj);
		}
	}
	if ( !dialArr.isEmpty() )
	{
		rootJson.put("DIAL", dialArr);
	}
	if((dialmeasuresNAList!=null && dialGraphtests!=null) && (dialmeasuresNAList.size()==dialGraphtests.size()))
	{
		isAllDialGraphHasNoMeasures=true;
	}
	else
	{
	}

	String ddtest="";
	String ddmeasure="";
	String unit="";
	String ddformat="";

	boolean isDDTestRelevantForServer=false;
	if(isNetworkTab && isHopDelayNeed)
	{
		String s_singleDDtestmeasure=iniObj.getValue(subject,"Network_HopDelays");

		if(s_singleDDtestmeasure!=null && s_singleDDtestmeasure.indexOf(":")>0)
		{
			ddtest=s_singleDDtestmeasure.substring(0,s_singleDDtestmeasure.indexOf(":"));
			ddmeasure=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf(":")+1,s_singleDDtestmeasure.indexOf("#"));
			ddformat=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf("#")+1,s_singleDDtestmeasure.length());
			isDDTestRelevantForServer=specsInfo.isTestRelevantForServer(compType,ddtest);
			unit=tablesInfo.getUnitForMeasure(ddtest,ddmeasure);
		}
	}
	
	JSONArray hopArr = new JSONArray();
	if(isDDTestRelevantForServer)
	{
		JSONObject hopObj = new JSONObject();		
		EgDDOverview  ddoverview=new  EgDDOverview();
		String vRouterMH = (String)allMsmtHosts.get(ddtest);
		Hashtable analysisData=ddoverview.getDDAnalysisData(compName,compType,ddtest,ddmeasure,ddformat,"Network","","","","","","","",vRouterMH);

		Hashtable graphParams=new Hashtable();
		boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType, tmpCmpName, ddtest);
		

		if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest && analysisData!=null && analysisData.size()>0)
		{
			int   topcnt=0;
			hopObj.put("WIDTH",(dialGraphWidth*2));
			hopObj.put("HEIGHT",(dialGraphHeight+20));
			hopObj.put("TITLE","Routers by HopDelay(ms)");
			hopObj.put("NoMess","false");
			hopObj.put("COLUMN_0",mappingInfo.getTextDescription("monitor.dashboard.Router"));
			hopObj.put("COLUMN_1",mappingInfo.getTextDescription("monitor.common.Hop Delay"));

			Vector top=ddoverview.getTopValues();
			for(int j=0;j <top.size();j++)
			{
				String key=(String)top.get(j);
				Vector  analysis=(Vector)analysisData.get(key);
				if(analysis!=null)
				{
					Vector graphValues=(Vector)analysis.get(0);
					Vector graphData=(Vector)analysis.get(1);
					graphParams.put(key,graphValues);
					if(topcnt==10)
					break;
					
					hopObj.put("COLUMN_0_val",key);
					hopObj.put("COLUMN_1_val_0",(String)graphData.get(0));
					hopObj.put("COLUMN_1_val_1",(String)graphData.get(1));
					hopObj.put("COLUMN_1_val_2",(String)graphData.get(2));
									
					topcnt++;
				}
			}
		}
		else
		{
			hopObj.put("NoMess","true");
			hopObj.put("WIDTH",(dialGraphWidth*2));
			hopObj.put("HEIGHT",(dialGraphHeight+20));
			hopObj.put("TITLE","Routers by HopDelay(ms)");
			if( isExcludedTest || (enabledTests != null && !enabledTests.contains(ddtest))) {
				hopObj.put("HopMsg", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled") + "!");
			} else {
				hopObj.put("HopMsg", mappingInfo.getTextDescription("monitor.common.No measures available") + "!");
			}
		}
	hopArr.add(hopObj);
	rootJson.put("hopObj",hopObj);
	}	
	else if(!isAllDialGraphHasNoMeasures)
	{
		//rootJson.put("DIAL", "-");
	}
	Vector digitalGraphTests=egDashboard.getTokensAsVector(digitalGraphs,",");
	ArrayList digitalmeasuresNAList = new ArrayList();
	int digitalChartWidth=100;
	int rowCount=0;
	boolean isAllDigitalGraphsHasNoMeasures=false;
	boolean isAnyTestExcludedOrDisabledForDigital = false;
	JSONArray digitalArr = new JSONArray();
	for(int k=0 ; k < digitalGraphTests.size();k++ )
	{
		JSONObject digitalObj = new JSONObject();
		String testMeasure=(String)digitalGraphTests.get(k);
		test=testMeasure.substring(0,testMeasure.indexOf(":"));
		measure=testMeasure.substring(testMeasure.indexOf(":")+1);

		if(isNetworkTab && !specsInfo.isTestRelevantForServer(compType,test)) {
			continue;
		}
		
		boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType, tmpCmpName, test);
		if(isExcludedTest ) {
			isAnyTestExcludedOrDisabledForDigital = true;
			continue;
		}
				
		if(enabledTests!=null && !enabledTests.contains(test) ) {
			isAnyTestExcludedOrDisabledForDigital = true;
			continue;
		}
		msmtHost=(String)allMsmtHosts.get(test);
		if(msmtHost==null)
			msmtHost="";

		String measureForDB=dbInfo.getColumnForMeasure(test,measure);

		Vector topInfoWithMeasure = null;
		if(isOracleServer && isApplicationTab) 
		{
			topInfoWithMeasure = dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true, sid);
		} else {
			topInfoWithMeasure = dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true);
		}

		String toolTipmeasureValue="";
		String measureValue="";
		String measureMapping="";	
		boolean isTestHas_CutOffFactor=false;
		boolean isMeasureAvailable=false;
		if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>1)
		{
			info=(String)topInfoWithMeasure.get(0);
			toolTipmeasureValue=(String)topInfoWithMeasure.get(1);
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(test))
				{
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,info);
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
		}
		if(info!=null && info.indexOf("+")!=-1)
			info=info.substring(info.indexOf("+")+1);

		info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

		if(toolTipmeasureValue!=null && !toolTipmeasureValue.equals(""))
			measureValue=erutils.round(Double.parseDouble(toolTipmeasureValue),2);
		msmtHost=(String)allMsmtHosts.get(test);
		if(msmtHost==null)
			msmtHost="";
		double defaultDigitalGraphWidth=125;  // default dial graph width for calculation
		double defaultDigitalGraphHeight=42;  // default dial graph height for calculation
		double digitalGraphWidth=125;  
		double digitalGraphHeight=42;
		String digitalGraphWidthStr="125";
		String digitalGraphHeightStr="42";
		double digitalGraphWidthTo1024PxInPercent=defaultDigitalGraphWidth/1024;
		double digitalGraphHeightToDefaultWidthInPercent=defaultDigitalGraphHeight/defaultDigitalGraphWidth;
		digitalGraphWidth=screenWidthInDouble*digitalGraphWidthTo1024PxInPercent;
		if(measureValue!=null && measureValue.length()>0)
			digitalChartWidth=(measureValue.length()>4)?(measureValue.length()*18):100;
		digitalGraphHeight=digitalGraphWidth*digitalGraphHeightToDefaultWidthInPercent;
		digitalGraphHeightStr=erutils.round(digitalGraphHeight,0);
		digitalGraphWidthStr=erutils.round(digitalGraphWidth,0);
		
		isMeasureAvailable=(measureValue!=null && !measureValue.trim().equals("") && ((!measureValue.trim().equals("-5") && !measureValue.trim().equals("-1") && !testerInfo.getAllowNegativeValues(test,measure)) || (testerInfo.getAllowNegativeValues(test,measure))));	
		if(testerInfo.getAllowNegativeValues(test,measure) && isMeasureAvailable)
		{
			measureValue=com.egurkha.util.StringUtils.replace(measureValue,"+","");
		}
		measureMapping=iniObj.getValue("Dashboard_Digital_mapping",testMeasure);

		if(measureMapping==null || measureMapping.trim().equals(""))
			measureMapping=mappingInfo.getMeasureDescription(test,measure);

		String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

		String compTypeForAlarm=compType;
		if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
			compTypeForAlarm="Host_system";

		String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

		String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";
		if(isMeasureAvailable && !isTestHas_CutOffFactor)
		{
			hiddens.put("digitalUrl"+digitalChartCount, layerPageUrl);
			digitalObj.put("IMG_HEADING", measureMapping);
			digitalObj.put("METHOD_NAME", "wayToLayerModel");
			//digitalObj.put("PARAMS", "digitalUrl"+digitalChartCount);			
			digitalObj.put("PARAMS", layerPageUrl);			
			digitalObj.put("HEIGHT", digitalGraphHeightStr);
			digitalObj.put("WIDTH", digitalGraphWidthStr);
			digitalObj.put("CONTAINER_WIDTH", ""+dialGraphWidth);
			digitalObj.put("IMG_SRC","../servlet/com.egurkha.monitor.egDigitalChart?forecolor=ffffff&background=35c8c2&background1=35c8c2&dotColorCode=35c8c2&value="+measureValue+"&width="+digitalGraphWidthStr+"&height="+digitalGraphHeightStr);
			digitalObj.put("IMG_TITLE", com.egurkha.util.StringUtils.replace(info,"+","")+" ("+toolTipmeasureValue+")");
			digitalObj.put("UNIT", " ("+tablesInfo.getUnitForMeasure(test,measure)+")");
				digitalChartCount++;
				rowCount++;
		}
		else
		{
			digitalmeasuresNAList.add(measureMapping+"#"+(tablesInfo.getUnitForMeasure(test,measure)));
			continue;
			/*
			if(measureMapping!=null && !measureMapping.equals(""))
			{
				digitalObj.put("IMG_HEADING", measureMapping);
				digitalObj.put("UNIT", " ("+tablesInfo.getUnitForMeasure(test,measure)+")");
				digitalObj.put("IMG_SRC","-");
			}*/
		}
		if ( !digitalObj.isEmpty() )
		{
			digitalArr.add(digitalObj);
		}
	}
	if ( !digitalArr.isEmpty() )
	{
		rootJson.put("DIGITAL", digitalArr);
	}
	if((digitalmeasuresNAList!=null && digitalGraphTests!=null) && (digitalmeasuresNAList.size()==digitalGraphTests.size()))
	{
		isAllDigitalGraphsHasNoMeasures=true;
	}

	if(isAnyTestExcludedOrDisabledForDial || isAnyTestExcludedOrDisabledForDigital){
		rootJson.put("DIAL_DIGITAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled") + "!");
	} 
	
	if(isAnyTestExcludedOrDisabledForDial){
		rootJson.put("DIAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled") + "!");
	} 

	if(isAnyTestExcludedOrDisabledForDigital){
		rootJson.put("DIGITAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled") + "!");
	} 
	/**
	rootJson.put("DIAL_AND_DIGITAL_TITLE", mappingInfo.getTextDescription("monitor.dashboard.Dial and Digital Graphs"));
	rootJson.put("DIAL_TITLE", mappingInfo.getTextDescription("monitor.dashboard.Dial Graphs"));
	rootJson.put("DIGITAL_TITLE", mappingInfo.getTextDescription("monitor.dashboard.Digital Graphs"));
	*/
	rootJson.put("SYS_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.System Performance"));
	rootJson.put("NET_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.Availability/Network Traffic"));
	rootJson.put("APP_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.Application Performance "));

	if(isTRNeedInDigitalChart)
	{


	}
	int totalCount=digitalChartCount+digitalChartNoMeasuresCount;

	if(totalCount%5>0)
		emptyTDCount=5-(totalCount%5);
	else
		emptyTDCount=0;
	String tmpVar = tab+" Config";
	String configDivCount="img"+divCount;
	String configTitleStr="";

	JSONArray configsArr = new JSONArray();
	if(hasConfig && !disabledBlocks.contains(tmpVar))
	{
		JSONObject configsObj = new JSONObject();
		configTitleStr = mappingInfo.getTextDescription("monitor.dashboard."+tab+" Configuration");
		configsObj.put("TITLE", configTitleStr);
		configsObj.put("TYPE", "TABLE");
		if(adminPermission==true)
		{
			configsObj.put("ADMIN_PERMISSION", "true");
			configsObj.put("MAXIMIZE_METHOD_NAME", "showMaximizedTable");
			configsObj.put("MAXIMIZE_PARAMS", "event|ConfigDataDiv||img"+divCount+"|"+configTitleStr);
			configsObj.put("CLOSE_METHOD_NAME", "closeDiv");
			configsObj.put("CLOSE_PARAMS", divCount+"|"+tab+"_Overview|"+tab+" Config");
		}
		else
		{
			configsObj.put("ADMIN_PERMISSION", "false");
			configsObj.put("MAXIMIZE_METHOD_NAME", "showMaximizedTable");
			configsObj.put("MAXIMIZE_PARAMS", "event|ConfigDataDiv||img"+divCount+"|"+configTitleStr);
		}
		if(configData!=null && configData.size()>0)
		{
			ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName,compType);
			JSONArray conArr = new JSONArray();
			boolean isTestExcludedORDisabled = false;
			for(int c=0;c<configData.size();c=c+2)
			{
				JSONObject conObj = new JSONObject();
				String testMeasure=(String)configData.get(c);
				String configration=(String)configData.get(c+1);
				if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_info"))
				{
					String testNameForConfig=configration.substring(0,configration.indexOf("|"));
					configration=configration.substring(configration.indexOf("|")+1,configration.length());
					configration=com.egurkha.util.StringUtils.replace(configration,"+","");
					if(getExcludedTest!=null && getExcludedTest.contains(testNameForConfig))
					{
						isTestExcludedORDisabled=true;
						continue;
					}
					if(enabledConfigTests!=null && !enabledConfigTests.contains(testNameForConfig))
					{						
						isTestExcludedORDisabled=true;
						continue;
					}
					conObj.put("VALUE_1", mappingInfo.getTestDescription(testNameForConfig));
					conObj.put("VALUE_2", configration);
				}
				else if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_test"))
				{
					conObj.put("TITLE", mappingInfo.getTestDescription(configration));
				}
				else if(testMeasure!=null && testMeasure.equalsIgnoreCase("empty_row"))
				{
					conObj.put("TITLE", "&nbsp;");
				}
				else
				{
					String measureNameMapping=iniObj.getValue("Dashboard_measures_mapping",testMeasure);
					String measureName = testMeasure.substring(testMeasure.indexOf(":")+1,testMeasure.length());
					
					String testName = testMeasure.substring(0,testMeasure.indexOf(":"));
					
					if(getExcludedTest!=null && getExcludedTest.contains(testName))
					{
						
						isTestExcludedORDisabled=true;
						continue;
					}

					if(enabledConfigTests!=null && !enabledConfigTests.contains(testName))
					{
						isTestExcludedORDisabled=true;
						continue;
					}

					if((measureNameMapping==null || measureNameMapping.trim().equals("")) && !testName.equals(""))
						measureNameMapping=mappingInfo.getMeasureDescription(testName,measureName);
					conObj.put("VALUE_1", measureNameMapping);
					conObj.put("VALUE_2", configration);
				}
				conArr.add(conObj);
			}			
			if(isTestExcludedORDisabled)
			{
				configsObj.put("CONFIGURATION", "-");
				configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Test has been excluded or disabled")+"!");
			}
			else
			{
				configsObj.put("CONFIGURATION", conArr);	
			}
		}
		else
		{
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Configuration details are not available")+"!");
		}
		configsArr.add(configsObj);
//		rootJson.put("CONFIGURATIONS", configsArr);
	}
	if(!disabledBlocks.contains("Layerhealth") && !hasConfig)
	{
		JSONObject configsObj = new JSONObject();
		configsObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Current Layerwise Health"));
		configsObj.put("TYPE", "FUSION_CHART");
		String healthGraphURL="../servlet/com.egurkha.monitor.EgEventChart?hostName="+compName+"&compType="+compType+"&module="+tab+"&monitorSkin="+monitor_Skin+"&fromHealth=true&width=350&height=110&imgdate="+new java.util.Date();

		Vector chartAttributes=new Vector();
		chartAttributes.add("showLegend='0'");
		chartAttributes.add("palette='2'");
		chartAttributes.add("useRoundEdges='1'");
		chartAttributes.add("showValues='0'");
		chartAttributes.add("clickURL='javascript:showBigGraph(&apos;"+EgURLEncoder.encode(healthGraphURL,"UTF-8")+"&apos;,this.event,1,&apos;LayerwiseHealth&apos;)'");
		chartAttributes.add("bgAlpha='0,0'");
		chartAttributes.add("bgColor='ffffff,ffffff'");
		chartAttributes.add("showToolTipShadow='1'");
		chartAttributes.add("canvasLeftMargin='5'");
		chartAttributes.add("canvasRightMargin='5'");
		chartAttributes.add("canvasTopMargin='5'");
		chartAttributes.add("canvasBottomMargin='5'");
		chartAttributes.add("baseFontColor ='000000'");
		chartAttributes.add("baseFontSize ='9'");
		chartAttributes.add("baseFont  ='verdana'");
		chartAttributes.add("showBorder  ='0'");
		chartAttributes.add("showPlotBorder  ='0'");
		chartAttributes.add("plotSpacePercent='40'");
		chartAttributes.add("adjustDiv='0'");
		chartAttributes.add("yAxisMaxValue='100.001'");
		chartAttributes.add("decimals='2'");
		chartAttributes.add("exportEnabled='0'");
		chartAttributes.add("exportAction='download'");
		chartAttributes.add("exportAtClient='0'");
		chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

		String layerHealthXML=graphUtil.getXMLForLayerHealth(compName,compType,tab,false,chartAttributes);
		String layerHealthURL=response.encodeURL("/final/monitor/egDashTimeline.jsp")+"?"+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&graphType=LayerwiseHealth&module="+tab;

		if(adminPermission==true)
		{
			configsObj.put("ADMIN_PERMISSION", "true");

		}
		else
		{
			configsObj.put("ADMIN_PERMISSION", "false");
		}
		if(layerHealthXML ==null || layerHealthXML.equals("") )
		{
			configsObj.put("XML_DATA", "-");
		}
		else
		{
		configsObj.put("XML_DATA", layerHealthXML);
		}
		configsObj.put("SWF_PATH", "/final/FusionCharts/swf/StackedBar2D.swf");
		configsObj.put("HEIGHT", "400");
		configsObj.put("WIDTH", "110");
		configsArr.add(configsObj);
	}
	if(!disabledBlocks.contains("KPI"))
	{
		JSONObject configsObj = new JSONObject();
		String kpiFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&state="+state+"&blockType=KPI";
		configsObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Key Performance Indicators"));
		configsObj.put("TYPE", "SPARK");
		if(adminPermission==true)
		{
			configsObj.put("ADMIN_PERMISSION", "true");
		}
		else
		{
			configsObj.put("ADMIN_PERMISSION", "false");
		}
	Vector states=new Vector();
	states.add("HIGH");
	states.add("INTERMEDIATE");
	states.add("LOW");
	states.add("UNKNOWN");
	states.add("GOOD");

	boolean isPerformanceIndicatorsAvailable=egDashboard.getPerformanceIndicatorsAvailable();
	boolean isAnyTestEnabledorDisabledForKPI = egDashboard.isAnyTestEnabledorDisabledForKPI();
	if(performanceIndicators!=null && performanceIndicators.size()>0 && isPerformanceIndicatorsAvailable)
	{
		int i_indicatorCount=0;
		Iterator ptr=states.iterator();
		boolean isKPIAvailable=false;
		JSONArray configArr = new JSONArray();
		boolean isTestExcludedORDisabled = false;
		while(ptr.hasNext())
		{
			String  keyState = (String)ptr.next();
			Vector indicators=(Vector)performanceIndicators.get(keyState);

			if(indicators!=null && indicators.size()>0)
			{
				for(int  i=0;i<indicators.size();i++)
				{
					JSONObject configObj = new JSONObject();
					String perfIndicatorValue=(String)indicators.get(i);
					String tstmeasure ="";
					String desc="";
					String  indicURL="";

					if(perfIndicatorValue.indexOf("{")!=-1)
					{
						tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("{"));
						desc = perfIndicatorValue.substring(perfIndicatorValue.indexOf("{")+1,perfIndicatorValue.indexOf("@")-1);
					}
					else if(perfIndicatorValue.indexOf("@")!=-1)
					{
						tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("@"));
					}

					if(perfIndicatorValue.indexOf("@")!=-1)
						indicURL=perfIndicatorValue.substring(perfIndicatorValue.indexOf("@")+1,perfIndicatorValue.length());

					String cur_Measure = "";
					String dispInfo="";

					if(desc!=null && !desc.equals("+") && !desc.equals("") && !desc.equals("Summary"))
					{
						dispInfo=" {"+desc+"}";
					}
					String testname="",testmeasure="";
					if(tstmeasure!=null && tstmeasure.indexOf(":")>0)
					{
						testname=tstmeasure.substring(0,tstmeasure.indexOf(":"));
						testmeasure=tstmeasure.substring(tstmeasure.indexOf(":")+1);
					}
					
					boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType,tmpCmpName,testname);
					if(isExcludedTest)
					{
						isTestExcludedORDisabled = true;
						continue;
					}

					if(enabledTests!=null && !enabledTests.contains(testname))
					{
						isTestExcludedORDisabled = true;
						continue;
					}

					String kpimeasureForDB=dbInfo.getColumnForMeasure(testname,testmeasure);

					String infoForSparkline="+"+desc;
					String sidForSparkline=sid;

					if(isOracleServer && (tab.equalsIgnoreCase("System") || tab.equalsIgnoreCase("Network")))
						sidForSparkline=null;

					String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,infoForSparkline,sidForSparkline,testname,kpimeasureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");

					msmtHost=(String)allMsmtHosts.get(testname);
					if(msmtHost==null)
						msmtHost="";

					if(infoForSparkline!=null && infoForSparkline.indexOf("*")==-1)
						infoForSparkline="*"+infoForSparkline;
					String  excludedInfos = egDashboard.convertTokensAsString(dashboardDAO.getExcludedInfo(testname,testmeasure,compType,true,false),",");
					dashboardDAO.setOmittedInfo(excludedInfos);
					
					Vector topInfoWithMeasure = null;
					if(isOracleServer && isApplicationTab) 
					{
						 topInfoWithMeasure = dashboardDAO.getCurrentForTop(hostName,portNo,testname,kpimeasureForDB,msmtHost,true,1,true,sid);
					} else {
						 topInfoWithMeasure = dashboardDAO.getCurrentForTop(hostName,portNo,testname,kpimeasureForDB,msmtHost,true,1,true);
					}

					if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>=2)
					{
						infoForSparkline=(String)topInfoWithMeasure.get(0);
						cur_Measure=(String)topInfoWithMeasure.get(1);
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(testname))
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testname,msmtHost,infoForSparkline);
								if(isTestExceededCutOffFactor)
									continue;
							}
						}
					}

					if(cur_Measure==null || cur_Measure.trim().equals("") || cur_Measure.trim().equals("-5") || cur_Measure.trim().equals("-1") && !testerInfo.getAllowNegativeValues(testname,testmeasure))
						cur_Measure="-";
					String unitValue = tablesInfo.getUnitForMeasure(testname,testmeasure);

					if(cur_Measure!=null && !cur_Measure.equals("-") && unitValue!=null && unitValue.equalsIgnoreCase("MB"))
					{
						double floatVal=(Double.parseDouble(cur_Measure))/1024;
						floatVal=MathUtils.round(floatVal,2);
						cur_Measure=floatVal+"";
						unitValue="GB";
					}

					if(unitValue.equalsIgnoreCase("boolean"))
					{
						if(cur_Measure.equals("0"))
							cur_Measure="No";
						else if(cur_Measure.equals("1"))
							cur_Measure="Yes";
					}

					if((unitValue!=null) && (unitValue.equalsIgnoreCase("percent") || unitValue.equalsIgnoreCase("percentage")))
						unitValue="%";

					String kpiMeasureMapping=iniObj.getValue("Dashboard_KPI_mapping",tstmeasure);
					if(kpiMeasureMapping==null || kpiMeasureMapping.trim().equals(""))
					{
						String kpiTest = "";
						String kpiMeasure = "";
						kpiTest = tstmeasure.substring(0,tstmeasure.indexOf(":"));
						kpiMeasure = tstmeasure.substring(tstmeasure.indexOf(":")+1,tstmeasure.length());
						kpiMeasureMapping=mappingInfo.getMeasureDescription(kpiTest,kpiMeasure);
					}
					String sidformax = "";
					if(isOracleServer && sid!=null && !sid.equals(""))
					{
						sidformax = "sid="+sid+"&";
					}
					if(isfromSuper)
					{
						if(indicURL.indexOf("?") > -1)
						{
							String url = indicURL.substring(0,indicURL.indexOf("?")+1);
							indicURL = response.encodeURL(url)+indicURL.substring(indicURL.indexOf("?")+1);
						}
					}
					if(!isKPIAvailable)
						isKPIAvailable=true;
					if(indicURL!=null)
					{
						if(indicURL.indexOf("&fromPage=")>0)
						{
							indicURL = com.egurkha.util.StringUtils.replace(indicURL,"fromPage=componentList","fromPage="+tab+"_Dashboard&backNav=cmpDashboard");
						}
					}

					configObj.put("STATE", keyState);
					JSONObject linkObj = new JSONObject();
					linkObj.put("METHOD_NAME", "wayToLayerModel");
					hiddens.put("configUrl"+i_indicatorCount, indicURL);
					//linkObj.put("PARAMS",  "configUrl"+i_indicatorCount);
					linkObj.put("PARAMS",  indicURL);
					linkObj.put("MEASURE", kpiMeasureMapping+" ("+unitValue+") "+dispInfo);
					configObj.put("LINK", linkObj);
					configObj.put("IMG_HIDDEN", indicURL);
					
					Vector infos = null;
					if(isOracleServer && isApplicationTab) 
					{
						 infos = dashboardDAO.getInfosbyMeasure(testname,hostName,portNo,kpimeasureForDB,site,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00",tab, sid);
					} else {
						 infos = dashboardDAO.getInfosbyMeasure(testname,hostName,portNo,kpimeasureForDB,site,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00",tab);
					}
					
					if(infos.indexOf("+")>=0)
					{
						infos.remove(infos.indexOf("+"));
					}
					String overviewinfo="";
					String infoForTable="";
					boolean infoRelevant=false;
					for(int j=0;j<infos.size();j++)
					{
						overviewinfo += com.egurkha.util.StringUtils.replace((String)infos.get(j),"+","*")+",";
						infoForTable +=com.egurkha.util.StringUtils.replace((String)infos.get(j),"+","$")+",";
					}
					if((overviewinfo.equalsIgnoreCase("*,") || overviewinfo.equalsIgnoreCase("+*,") || overviewinfo.equalsIgnoreCase("+,") || overviewinfo.equalsIgnoreCase("$,")))
					{
						overviewinfo="";
						infoForTable="";
					}
					if(infos!=null && infos.size()>1)
					{
						infoRelevant=true;
					}
					String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?"+sidformax+"measure="+kpimeasureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&test="+testname+"&info="+overviewinfo+"&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&isInfoReleventGraph="+infoRelevant+"&s_measure="+testmeasure+"&module="+tab+"&infoForTable="+infoForTable+"&fromKPI=true";
					if(graph_values.length()>1700)
						graph_values = graph_values.substring(0,1700);
					Vector spartLineAttributes=new Vector();
					spartLineAttributes.add("palette='2'");
					spartLineAttributes.add("setAdaptiveYMin='1'");
					spartLineAttributes.add("bgAlpha='0,0'");
					spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
					spartLineAttributes.add("showHighAnchor ='0'");
					spartLineAttributes.add("showLowAnchor ='0'");
					spartLineAttributes.add("showOpenValue ='0'");
					spartLineAttributes.add("showCloseValue ='0'");
					spartLineAttributes.add("showHighLowValue ='0'");
					spartLineAttributes.add("showOpenAnchor ='0'");
					spartLineAttributes.add("showCloseAnchor ='0'");
					spartLineAttributes.add("lineThickness='1.5'");
					spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;kpisparkurl"+i_indicatorCount+"&apos;)'");
					spartLineAttributes.add("exportEnabled='0'");
					spartLineAttributes.add("exportAction='download'");
					spartLineAttributes.add("exportAtClient='0'");
					spartLineAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

					Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");
					String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);

					if(graph_values!=null  && graph_values.length()>0 && (sparkValues!=null && sparkValues.size()>1))
					{
						configObj.put("XML_DATA", sparkXML);
						configObj.put("SWF_PATH", "/final/FusionCharts/swf/SparkLine.swf");
					}
					else
					{
						configObj.put("XML_DATA", "-");
					}
					configObj.put("VALUE", cur_Measure);
					hiddens.put("kpisparkurl"+i_indicatorCount, urlForMaximize);
					i_indicatorCount++;
					if ( !configObj.isEmpty() )
					{
						configArr.add(configObj);
					}
				}
				if ( !configArr.isEmpty() )
				{
					configsObj.put("CONFIGURATION", configArr);
				}
			}
		}
		if(isTestExcludedORDisabled)
		{
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
		}
		if(!isKPIAvailable)
		{
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
		}
	} else if (isAnyTestEnabledorDisabledForKPI){
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Test has been excluded or disabled")+"!");
	}
	else
	{
		configsObj.put("CONFIGURATION", "-");
		configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
	}
	configsArr.add(configsObj);
//	rootJson.put("CONFIGURATIONS", configsArr);
	}
	if(isApplicationTab && isWeblogicServer)
	{
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
		Vector measureData = new Vector();
		Vector unitObj=new Vector();
		ArrayList measureMappingData = new ArrayList();
		ddtest="HttpTest";
		
		JSONObject configsObj = new JSONObject();
		configsObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Weblogic server Details"));
		configsObj.put("COLUMN_WIDTH", "1.0");
		configsObj.put("ADMIN_PERMISSION", "true");
		configsObj.put("TYPE", "XTEMPLATE");

		if(runingTestList!=null && runingTestList.contains(ddtest))
		{
			boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType,tmpCmpName,ddtest);
			if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
			{
				String testMeasures =iniObj.getValue(subject,tab+"_Overview_HttpTest"); 
				Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");
				String measuresForDB="";
				for(int i=0;i<allMeasures.size();i++)
				{
					String tempStr=(String)allMeasures.get(i);
					if(tempStr!=null && tempStr.indexOf(":")!=-1)
					{
						String testName=tempStr.substring(0,tempStr.indexOf(":"));
						String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
						measureMappingData.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
							String unitVal= tablesInfo.getUnitForMeasure(testName,tempMeasure);
							unitObj.add(unitVal);
						measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
						if(allMeasures.size()>i+1)
							measuresForDB+=",";
					}
				}
				msmtHost = (String)allMsmtHosts.get(ddtest);
				measureData=dashboardDAO.getCurrentForAllInfos(hostName,portNo,ddtest,measuresForDB,msmtHost);
				measureData.remove("+");
				Vector temp_infos=dashboardDAO.getDescriptorsForTest(hostName+":"+portNo,compType,ddtest,tab);
				String info_for_cutofffactor="";
				if(temp_infos!=null && !temp_infos.isEmpty())
					info_for_cutofffactor=(String)temp_infos.get(0);
				boolean isTestHas_cutOffFactor=false;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(ddtest))
					{
						
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,ddtest,msmtHost,info_for_cutofffactor);
						if(isTestExceededCutOffFactor)
						{
							isTestHas_cutOffFactor=true;
						}
					}
				}
				
				if(!isTestHas_cutOffFactor)
				{
					JSONArray conArr = new JSONArray();
					JSONObject conObj = new JSONObject();
					conObj.put("VALUE_1", (String)measureMappingData.get(0));
					if(measureData!=null && measureData.size()>0)
					{
						if(measureData.get(1).equals("100"))
						{
							conObj.put("VALUE_2", "iconArrowUp");
						}
						else
						{
							conObj.put("VALUE_2", "iconArrowDown");
						}
					}
					conObj.put("VALUE_3", measureMappingData.get(1)+" ("+(String)unitObj.get(1)+")");
					if(measureData!=null && measureData.size()>0)
					{
						if(measureData.get(2).toString().contains("-"))
						{
							conObj.put("VALUE_4", "-");
						}
						else
						{
							conObj.put("VALUE_4", (String)measureData.get(2));
						}
					}
					conArr.add(conObj);
					conObj = new JSONObject();
					conObj.put("VALUE_1", (String)measureMappingData.get(2)+" ("+unitObj.get(2)+")");
					if(measureData!=null && measureData.size()>0)
					{
						if(measureData.get(3).toString().contains("-"))
						{
							conObj.put("VALUE_2", "-");
						}
						else
						{
							conObj.put("VALUE_2", (String)measureData.get(3));
						}
					}
					conObj.put("VALUE_3", (String)measureMappingData.get(3)+" ("+unitObj.get(3)+")");
					if(measureData!=null && measureData.size()>0)
					{
						if(measureData.get(4).toString().contains("-"))
						{
							conObj.put("VALUE_4", "-");
						}
						else
						{
							conObj.put("VALUE_4", (String)measureData.get(4));
						}
					}
					conArr.add(conObj);
					if ( !conArr.isEmpty() )
					{
						configsObj.put("CONFIGURATION", conArr);
					}
				}
				else
				{
					configsObj.put("CONFIGURATION", "-");
					configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
				}
				configsArr.add(configsObj);
			}
			else
			{
				configsObj.put("CONFIGURATION", "-");
				configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
				configsArr.add(configsObj);
			}
		}
		else
		{
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test is not running")+"!");
			configsArr.add(configsObj);
		}
	}
	else if(isApplicationTab && isOracleServer)
	{
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
		Vector measureData = new Vector();
		Vector unitObj=new Vector();
		ArrayList measureMappingData = new ArrayList();
		ddtest="OraSqlNetTest";		
		JSONObject configsObj = new JSONObject();
		configsObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Oracle Availability"));
		configsObj.put("COLUMN_WIDTH", "1.0");
		configsObj.put("ADMIN_PERMISSION", "true");
		configsObj.put("TYPE", "XTEMPLATE");
		if(runingTestList!=null && runingTestList.contains(ddtest))		
		{
			boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType,tmpCmpName,ddtest);
			if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
			{
				String testMeasures =iniObj.getValue(subject,tab+"_Overview_OraSqlNetTest"); 
				Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");
				String measuresForDB="";
				for(int i=0;i<allMeasures.size();i++)
				{
					String tempStr=(String)allMeasures.get(i);
					if(tempStr!=null && tempStr.indexOf(":")!=-1)
					{
						String testName=tempStr.substring(0,tempStr.indexOf(":"));
						String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
						measureMappingData.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
							String unitVal= tablesInfo.getUnitForMeasure(testName,tempMeasure);
							unitObj.add(unitVal);
							
						measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
						if(allMeasures.size()>i+1)
							measuresForDB+=",";
					}
				}
				msmtHost = (String)allMsmtHosts.get(ddtest);
				if(list!=null && list.containsKey(ddtest))
				{
				/*lastmsmtTimeIndex = list.indexOf(ddtest)+3;
				lastmsmtTime = list.get(lastmsmtTimeIndex).toString();
				tempDate =testDateFormat.parse(lastmsmtTime);
				lastmsmtTime=timeFormat.format(tempDate);*/
					
					if(isOracleServer && isApplicationTab) 
					{
						measureData = dashboardDAO.getCurrentForAllInfos(hostName, portNo, ddtest, measuresForDB, msmtHost, sid);
					} else {
						measureData = dashboardDAO.getCurrentForAllInfos(hostName, portNo, ddtest, measuresForDB, msmtHost);
					}
				}
				measureData.remove("+");
				if(isOracleServer && sid!=null && !sid.equals(""))
					measureData.remove(sid+"+");
				Vector temp_infos=dashboardDAO.getDescriptorsForTest(hostName+":"+portNo,compType,ddtest,tab);
				String info_for_cutofffactor="";
				if(temp_infos!=null && !temp_infos.isEmpty())
					info_for_cutofffactor=(String)temp_infos.get(0);
				boolean isTestHas_cutOffFactor=false;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(ddtest))
					{
						
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,ddtest,msmtHost,info_for_cutofffactor);
						if(isTestExceededCutOffFactor)
						{
							isTestHas_cutOffFactor=true;
						}
					}
				}			
				if(!isTestHas_cutOffFactor)
				{
					JSONArray conArr = new JSONArray();
					JSONObject conObj = new JSONObject();
					
					if(measureData!=null && measureData.size()>0)
					{
						conObj.put("VALUE_1", (String) measureMappingData.get(0));
						if(measureData.get(0).equals("100"))
						{
							conObj.put("VALUE_2", "iconArrowUp");
						}
						else
						{
							conObj.put("VALUE_2", "iconArrowDown");
						}
						conObj.put("VALUE_3", (String) measureMappingData.get(1)+" ("+(String)unitObj.get(1)+")");
						if(measureData.get(1).toString().contains("-"))
						{
							conObj.put("VALUE_4", "-");
						}
						else
						{
							conObj.put("VALUE_4", (String)measureData.get(1));
						}
						conArr.add(conObj);
					}					
					conObj = new JSONObject();					
					if(measureData!=null && measureData.size()>0)
					{
						conObj.put("VALUE_1", (String)measureMappingData.get(2)+" ("+(String)unitObj.get(2)+")");
						if(measureData.get(2).toString().contains("-"))
						{
							conObj.put("VALUE_2", "-");
						}
						else
						{
							conObj.put("VALUE_2", (String)measureData.get(2));
						}
						conObj.put("VALUE_3", (String)measureMappingData.get(3)+" ("+(String)unitObj.get(3)+")");
						if(measureData.get(3).toString().contains("-"))
						{
							conObj.put("VALUE_4", "-");
						}
						else
						{
							conObj.put("VALUE_4", (String)measureData.get(3));
						}
						conArr.add(conObj);
					}					
					if ( !conArr.isEmpty() )
					{
						configsObj.put("CONFIGURATION", conArr);
					}
				}	
				else
				{
					configsObj.put("CONFIGURATION", "-");
					configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
				}
				configsArr.add(configsObj);
			}
			else
			{
				configsObj.put("CONFIGURATION", "-");
				configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
				configsArr.add(configsObj);
			}
		}
		else
		{
			configsObj.put("CONFIGURATION", "-");
			configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.The test is not running")+"!");
			configsArr.add(configsObj);
		}
	}
	String s_comparisiontable=iniObj.getValue(subject,tab+"_Overview_comparisiontable");
	boolean isNetworkNode=(compType!=null && compType.equalsIgnoreCase("Network_node"));

	if(s_comparisiontable!=null && !s_comparisiontable.trim().equals(""))
	{
		int tablescount=0;
		int imgcnt=0;
		int stColPos=1;
		int endColPos=0;
		String DefaultFullViewComparisonTable=iniObj.getValue("Default_ComparisonTable_FullTableView","FullViewComparisonTables");
		Vector fullViewComparisonTablesVector=egDashboard.getTokensAsVector(DefaultFullViewComparisonTable,",");
		Vector comparisionVector=egDashboard.getTokensAsVector(s_comparisiontable,"#");

		Iterator comparionTableItr=comparisionVector.iterator();
		while(comparionTableItr.hasNext())
		{
			String s_alltestmeasure=(String)comparionTableItr.next();
			String colspan="1";
			String tableWidth="50%";

			info="+";

			Vector allMeasures=egDashboard.getTokensAsVector(s_alltestmeasure,",");
			Iterator allMeasuresItr=allMeasures.iterator();

			String tempTestName="";
			if(allMeasures.size()>0)
			{
				tempTestName=(String)allMeasures.get(0);
				if(tempTestName!=null && tempTestName.indexOf(":")!=-1)
					tempTestName=tempTestName.substring(0,tempTestName.indexOf(":"));
			}
			String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",tempTestName);
			String show_esx_ds_summary = iniObj.getValue("Dashboard_Settings","SHOW_ESX_DS_SUMMARY");
			boolean isDBSummaryNeeded =  true;
			if ( show_esx_ds_summary != null && show_esx_ds_summary.equalsIgnoreCase("No") )
			{
				isDBSummaryNeeded = ( tempTestName != null && !tempTestName.equalsIgnoreCase("EsxDiskUsageTest") && !tempTestName.equalsIgnoreCase("XenHostDiskSpaceTest") ) ? true:false;
			}
			if(tableTitle!=null && tableTitle.equals(""))
			{
				tableTitle=mappingInfo.getTestDescription(tempTestName);
			}

			Vector allInfos=(Vector)allTestInfos.get(tempTestName);

			boolean hasInfos=(allInfos!=null && allInfos.size()>0 && !(allInfos.size()==1 && allInfos.contains("+")));
			int colCountForFullTable=5;
			if(tempTestName!=null && tempTestName.equalsIgnoreCase("MsSqlConnsTest"))
			{
				colCountForFullTable=6;
			}
			else if(tempTestName!=null && tempTestName.equalsIgnoreCase("MsSqlSpaceTest"))
			{
				colCountForFullTable=3;
			}

			if(allMeasures!=null && allMeasures.size()>=colCountForFullTable && hasInfos)
			{
				tableWidth="100%";
				colspan="2";
			}
			String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&state="+state+"&blockType=comparisontable&tableIdx="+tablescount;
			
			boolean isExcludedTest = egDashboard.isExcludedComponentForTest(compType,tmpCmpName,tempTestName);	

			if(hasInfos && enabledTests.contains(tempTestName) && !isExcludedTest)
			{
				if(s_alltestmeasure!=null && (s_alltestmeasure.trim().equals("SystemTest:Cpu_util") || s_alltestmeasure.trim().equals("HvProcessorTest:Cpu_utilization") || s_alltestmeasure.trim().equals("EsxCpuTest:Usage")))
				{
					test=s_alltestmeasure.substring(0,s_alltestmeasure.indexOf(":"));
					String tempMeasure = s_alltestmeasure.substring(s_alltestmeasure.indexOf(":")+1);
					msmtHost=(String)allMsmtHosts.get(test);
					if(msmtHost==null)
						msmtHost="";
					String  excludedInfosForSpark = egDashboard.convertTokensAsString(dashboardDAO.getExcludedInfo(test,tempMeasure,compType,true,false),",");
					dashboardDAO.setOmittedInfo(excludedInfosForSpark);
					Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,dbInfo.getColumnForMeasure(test,tempMeasure),msmtHost,true,10,true);
					String  excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",s_alltestmeasure);
					StringTokenizer infos=new StringTokenizer(excludedInfos,",");
					Vector excluded_infos=new Vector();
					while(infos.hasMoreTokens())
					{
							excluded_infos.add("+"+infos.nextToken());
					}
					String checkVal="";
					Vector filtered_infos=new Vector();
					if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>0)
					{
						for(int i=0;i<topInfoWithMeasure.size();i+=2)
						{
							 String ex_info=(String)topInfoWithMeasure.get(i);
							 String value=(String)topInfoWithMeasure.get(i+1);
							 if(!excluded_infos.contains(ex_info))
							{
									filtered_infos.add(ex_info);
									filtered_infos.add(value);

							}
						}
					}
					for(int i=0;i<filtered_infos.size();i+=2)
					{
						 checkVal=(String)filtered_infos.get(i+1);
					}
					if(checkVal!=null && !checkVal.equals("-") && !checkVal.equals("-5") && !checkVal.trim().equals(""))
					{		
						String rsTableName="rsTable"+(tablescount+1);
						endColPos+=2;
						if(!disabledBlocks.contains(test))
						{
					
							JSONObject cpuSumObj=new JSONObject();
							cpuSumObj.put("TITLE",tableTitle);
							cpuSumObj.put("TYPE", "LINEAR");
							cpuSumObj.put("HIDDEN", comparisonTableFullViewURL);
							if(adminPermission==true)
							{
								cpuSumObj.put("ADMIN_PERMISSION", "true");	
							}
							else
							{
								cpuSumObj.put("ADMIN_PERMISSION", "false");	
							}

					String col_mapping=iniObj.getValue("Dashboard_TableColumn_mapping","SystemTest:Cpu_util");
					if(col_mapping==null || col_mapping.trim().equals(""))
						col_mapping=mappingInfo.getMeasureDescription("SystemTest","Cpu_util");
					String info_mapping=iniObj.getValue("Dashboard_Info_Mapping","SystemTest");
					boolean isTestHas_CutOffFactor=false;
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(test))
							{
								if(filtered_infos!=null && !filtered_infos.isEmpty())
								{
									for(int d=0;d<filtered_infos.size();d++)
									{
										boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,(String)filtered_infos.get(d));
										if(isTestExceededCutOffFactor)
										{
											isTestHas_CutOffFactor=true;
										}
									}
								}			
							}
						}
						if(!isTestHas_CutOffFactor)
						{	
							cpuSumObj.put("COLUMN_0",info_mapping);
							cpuSumObj.put("COLUMN_1",col_mapping+" (%)");
							JSONArray summaryArr = new JSONArray();
							for(int i=0;i<filtered_infos.size();i+=2)
							{
								JSONObject summaryObj = new JSONObject();
								String infoForDisp=(String)filtered_infos.get(i);
								
								String val=(String)filtered_infos.get(i+1);
									Vector chartAttributes=new Vector();
									if(monitorSkin.equalsIgnoreCase("Dark"))
									{
											chartAttributes.add("baseFontColor='FFFFFF'");
									}
									else
									{
										chartAttributes.add("baseFontColor='000000'");
									}
									chartAttributes.add("bgColor='FFFFFF'");
									chartAttributes.add("bgAlpha='0'");
									chartAttributes.add("showBorder='0'");
									chartAttributes.add("upperLimit='100'");
									chartAttributes.add("lowerLimit='0'");
									chartAttributes.add("ticksBelowGauge='1'");
									chartAttributes.add("placeValuesInside='0'");
									chartAttributes.add("showGaugeLabels='0'");
									chartAttributes.add("valueAbovePointer='0'");
									chartAttributes.add("pointerOnTop='1'");
									chartAttributes.add("pointerRadius='6'");
									chartAttributes.add("chartTopMargin='5'");
									chartAttributes.add("chartBottomMargin='5'");
									chartAttributes.add("chartLeftMargin='25'");
									chartAttributes.add("chartRightMargin='25'");
									chartAttributes.add("majorTMColor='D73027'");
									chartAttributes.add("plotFillPercent='60'");
									chartAttributes.add("plotFillColor='000000'");
									chartAttributes.add("baseFontSize='8'");
									
									chartAttributes.add("pointerBgColor='000000'");
									chartAttributes.add("placeTicksInside='0'");
									chartAttributes.add("gaugeFillMix='{light-60},{light-40},{light-20},{dark-5},{D95F02},{light-30},{light-50},{dark-10}'");
									chartAttributes.add("gaugeFillRatio='20,30,20'");
									chartAttributes.add("gaugeRoundRadius='3'");
									chartAttributes.add("exportEnabled='0'");
									chartAttributes.add("exportAction='download'");
									chartAttributes.add("exportAtClient='0'");
									chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

									String linearGaugeXML=fusionChart.getXmlForLinearGauge(val,chartAttributes);
									JSONObject chartObj = new JSONObject();
									chartObj.put("XML_DATA",linearGaugeXML);
									chartObj.put("SWF_PATH","/final/FusionCharts/swf/HLinearGauge.swf");
									summaryObj.put("COLUMN_0", (com.egurkha.util.StringUtils.replace(infoForDisp,"+","")));
									summaryObj.put("COLUMN_1", chartObj);
									summaryArr.add(summaryObj);
							}
							cpuSumObj.put("SUMMARY", summaryArr);
							
						}
						else
						{
							cpuSumObj.put("SUMMARY", "-");
							cpuSumObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
						}

						imgcnt+=2;
						stColPos=imgcnt+1;
						configsArr.add(cpuSumObj);
					}
					
					}
					else
					{	
						JSONObject cpuSumObj=new JSONObject();
						cpuSumObj.put("TITLE",tableTitle);
						cpuSumObj.put("TYPE", "LINEAR");
						cpuSumObj.put("HIDDEN", comparisonTableFullViewURL);
						if(adminPermission==true)
						{
							cpuSumObj.put("ADMIN_PERMISSION", "true");	
						}
						else
						{
							cpuSumObj.put("ADMIN_PERMISSION", "false");	
						}
						cpuSumObj.put("SUMMARY", "-");
						cpuSumObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
						configsArr.add(cpuSumObj);
					}
				}
				else
				{
					Vector measures=new Vector();
					String measuresForDB="";
					String testName="";

					for(int i=0;i<allMeasures.size();i++)
					{
						String tempStr=(String)allMeasures.get(i);
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(allMeasures.size()>i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";
					String s_infomapping=iniObj.getValue("Dashboard_Info_Mapping",testName);
					if(testName.equals("WLEJBPoolsTest") || testName.equals("WLEJBTransTest") || testName.equals("WLServletTest"))
					{
						String groupingRequired=agentInfo.getParamValue(testName,msmtHost,portNo,info, msmtHost,"autoDiscovery");
						if(groupingRequired!=null && groupingRequired.equals("true"))
						{
							if(testName.equals("WLServletTest"))
								s_infomapping="Servlet name";
							else
								s_infomapping="Bean name";
						}
						else
						{
							s_infomapping="Group name";
						}
					}
					if(s_infomapping==null || s_infomapping.trim().length()==0)
					{
						s_infomapping="Info";
					}
					String rsTableName="rsTable"+(tablescount+1);
					int totalMeasureCols=measures.size();
					boolean isNetworkInterfaceTest=(isNetworkNode && (testName!=null && testName.equalsIgnoreCase("NetworkInterfaceTest")));
					boolean isEsxNetworkInterfaceTest=(testName!=null && testName.equalsIgnoreCase("EsxNetworkTest"));
					
					boolean isEsxDiskUsageTest=(testName!=null && testName.equalsIgnoreCase("EsxDiskUsageTest"));
				
					Vector allValuesForInfo=new Vector();
					if(isNetworkInterfaceTest)
					{
						allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost,dbInfo.getColumnForMeasure(testName,"Pct_bandwidth_used"),true,"10");
						endColPos+=(totalMeasureCols);
					}
					else
					{
						if(isOracleServer && isApplicationTab) {
							allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost,sid);
						} else {
							allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
						}
						
						endColPos+=(totalMeasureCols+1);
					}
					boolean isValuesAvailableForInfo=(allValuesForInfo!=null && !allValuesForInfo.isEmpty());
					if(!disabledBlocks.contains(testName) && isValuesAvailableForInfo && isDBSummaryNeeded )
					{
						JSONObject configsObj = new JSONObject();	
						configsObj.put("TITLE", tableTitle);
						configsObj.put("TYPE", "GRID");		
						boolean isFullTable=false;
						if(allMeasures.size()>5 || (fullViewComparisonTablesVector.contains(tempTestName)))
							isFullTable=true;							
						
						if(adminPermission==true)
						{
							configsObj.put("ADMIN_PERMISSION", "true");
						}
						else
						{
							configsObj.put("ADMIN_PERMISSION", "false");
						}
						String innerComptableDivID="overViewCompTableInnerDiv"+divCount;
						if(isFullTable)
							innerComptableDivID="overViewCompTableFullInnerDiv"+divCount;

				Vector  excludedInfosForTest = dashboardDAO.getExcludedInfo(testName,"",compType,false,false);
				boolean isTestHas_CutOffFactor=true;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(testName))
					{
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							for(int d=0;d<allValuesForInfo.size();d+=measures.size()+1)
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,(String)allValuesForInfo.get(d));
								String omitedInfo = (String)allValuesForInfo.get(d);
								if ( excludedInfosForTest.contains(omitedInfo))
									continue;
								if(!isTestExceededCutOffFactor)
									isTestHas_CutOffFactor=false;
							}
						}			
					}
				}
				if(!isTestHas_CutOffFactor)
				{
					JSONArray gridColumnArr = new JSONArray();

					if(isOracleServer && isApplicationTab)
					{
						String testNameforMapping=iniObj.getValue("Dashboard_TableColumn_mapping",testName);
						if(testNameforMapping==null || testNameforMapping.equalsIgnoreCase(""))
						{
							gridColumnArr.add(mappingInfo.getTextDescription("monitor.dashboard."+s_infomapping));
						}
						else
						{
							gridColumnArr.add(testNameforMapping);
						}
					}
					else
					{
						gridColumnArr.add(mappingInfo.getTextDescription("monitor.dashboard."+s_infomapping));
					}
					imgcnt=imgcnt+1;
					String  excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",testName);
					Vector excluded_infos=new Vector();
					if(!StringUtils.isNull(excludedInfos))
					{
						StringTokenizer infos=new StringTokenizer(excludedInfos,",");
						while(infos.hasMoreTokens())
						{
							excluded_infos.add("+"+infos.nextToken());
						}
					}
					for(int i=0;i<totalMeasureCols&&measures.size()>i;i++)
					{
						measure=(String)measures.get(i);

						String tableHeader=iniObj.getValue("Dashboard_TableColumn_mapping",testName+":"+measure);
						if(tableHeader!=null && tableHeader.equals(""))
						{
							tableHeader=mappingInfo.getMeasureDescription(testName,measure);
						}

						excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",testName+":"+measure);

						if(!StringUtils.isNull(excludedInfos))
						{
							StringTokenizer infos=new StringTokenizer(excludedInfos,",");
							while(infos.hasMoreTokens())
							{
								String exclude_info="+"+infos.nextToken();
								if(excluded_infos!=null && !excluded_infos.contains(exclude_info))
									excluded_infos.add(exclude_info);
							}
						}
						String units = tablesInfo.getUnitForMeasure(testName,measure);

						if(units!=null && units.equalsIgnoreCase("MB"))
							units="GB";

						if(!((isNetworkInterfaceTest || isEsxNetworkInterfaceTest )&& (tableHeader!=null && tableHeader.equalsIgnoreCase("Status"))))
						{
							if(isEsxDiskUsageTest && tableHeader.equalsIgnoreCase("Availability"))
							{
								gridColumnArr.add(tableHeader);
							}
							else
							{
								gridColumnArr.add(tableHeader+"<br/>("+units+")");
							}
							imgcnt++;
						}
						else
						{
							gridColumnArr.add(tableHeader);
						}
					}
					configsObj.put("GRID_COLUMNS", gridColumnArr);
					JSONArray gridArr = new JSONArray();
					for(int i=0;i<allValuesForInfo.size();i+=measures.size()+1)
					{
						int colCount = 0;
						JSONObject gridObj = new JSONObject();
						info=(String)allValuesForInfo.get(i);
						info=com.egurkha.util.StringUtils.replace(info,sid+"+","");
						if(excluded_infos!=null && excluded_infos.contains("+"+info))
							continue;
						info=com.egurkha.util.StringUtils.replace(info,"+","");
						if(isNetworkNode && info!=null && info.equalsIgnoreCase("Total"))
						{
							continue;
						}
						if (info.length() < 60)
						{
							if(isEsxDiskUsageTest)
							{
								String img="<img  src='/final/monitor/eg_images/storage.png'/>";
								gridObj.put("COLUMN_"+(colCount++),img +" "+info.trim());

							}else{
							
							gridObj.put("COLUMN_"+(colCount++),info.trim());
							}
						}
						else
						{
							info=info.trim();
							
							int idx = info.length()/60;
							int index = 0;
							for (int j=0; j<idx; j++)
							{
								gridObj.put("COLUMN_"+(colCount++),info.substring(index,index+60));
								index = index+60;
							}
							if(isEsxDiskUsageTest)
							{
								String img="<img  src='/final/monitor/eg_images/storage.png'/>";
								gridObj.put("COLUMN_"+(colCount++),img);	
							}
							else
							{
								gridObj.put("COLUMN_"+(colCount++),info.substring(index));
							}
						}
						for(int j=1;j<=measures.size();j++)
						{
							measure=(String)measures.get(j-1);
							String value=(String)allValuesForInfo.get(j+i);
							String units = tablesInfo.getUnitForMeasure(testName,measure);

							if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
							{
								value = "-";
							}

							if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("MB")))
							{
								double floatVal=(Double.parseDouble(value))/1024;
								floatVal=MathUtils.round(floatVal,2);
								value=floatVal+"";
							}
							else if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("boolean")))
							{
								if(value.equals("0"))
									value="No";
								else if(value.equals("1"))
									value="Yes";
							}

							if(isNetworkInterfaceTest && (measure!=null && measure.equalsIgnoreCase("Availability")))
							{
								String tooltitle="";
								JSONObject statusObj = new JSONObject();
								if(value!=null && value.equals("100"))
								{
									tooltitle = info+"  is Up";
									statusObj.put("STATUS", "up");
									statusObj.put("TOOLTIP_TITLE", tooltitle);
									
								}
								else
								{
									tooltitle = info+"  is Down";
									statusObj.put("STATUS", "down");
									statusObj.put("TOOLTIP_TITLE", tooltitle);
								}
								int rcolIdx=colCount++;
								gridObj.put("COLUMN_"+rcolIdx,statusObj);
//								gridObj.put("COLUMN_"+rcolIdx+"_toolTip",tooltitle);
							}
							else
							{
								if(isEsxDiskUsageTest && (measure!=null && measure.equalsIgnoreCase("Availability")))
								{
									String img="";
									if ( value != null && !value.trim().equals("-") )
									{
										if(value.equals("100"))
										{
											img="<img src='/final/monitor/eg_images/icon_availability_up.png' />";
										}
										else
										{
											img="<img src='/final/monitor/eg_images/icon_availability_down.png' />";
										}
										gridObj.put("COLUMN_"+(colCount++),img);
									}
									else
									{
										gridObj.put("COLUMN_"+(colCount++),"-");									
									}

								}
								else
								{
									if ( isEsxNetworkInterfaceTest && measure.equalsIgnoreCase("availability") )
									{
										String tooltitle = "";
										if ( value != null && !value.trim().equals("-") )
										{
											JSONObject statusObj = new JSONObject();
											if ( value.trim().equals("100") )
											{
												//img = "<img src='up-arrow.png' />";
												//img = "<img  src=\"/final/images/spacer.gif\" class=\"iconArrowUp\" border=\"0\">";
												tooltitle = info+"  is Up";
												statusObj.put("STATUS", "up");
												statusObj.put("TOOLTIP_TITLE", tooltitle);
											}
											else if ( value.trim().equals("0") )
											{
												//img = "<img src='down-arrow.png' />";
												 //img = "<img  src=\"/final/images/spacer.gif\" class=\"iconArrowDown\" border=\"0\">";

												tooltitle = info + "  is Down";
												statusObj.put("STATUS", "down");
												statusObj.put("TOOLTIP_TITLE", tooltitle);
											}
											gridObj.put("COLUMN_"+(colCount++), statusObj);
										}
										else
										{
											gridObj.put("COLUMN_"+(colCount++),"-");
										}
									}
									else
									{
										gridObj.put("COLUMN_"+(colCount++),value);
									}
								}
							}

						}
						gridArr.add(gridObj);
					}
						configsObj.put("GRID_VALUES", gridArr);
						configsObj.put("GRID_COLUMNS", gridColumnArr);

						if ( gridColumnArr.size() > 4 && !isSystemTab)
						{
							configsObj.put("COLUMN_WIDTH", "1.0");
						}
					}
					else
					{
						configsObj.put("CONFIGURATION", "-");
						configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
					}
//					rootJson.put("CONFIGURATIONS", configsArr);
					int defaultColumnSortIndex=0;
					int defaultColumnSortImageIndex=stColPos;
					if(isNetworkInterfaceTest)
					{
						defaultColumnSortIndex=4;
						defaultColumnSortImageIndex=4;
					}
					else if(testName!=null && (testName.equals("XenCpuTest") || testName.equals("XenHostDiskSpaceTest")))
					{
						defaultColumnSortIndex=1;
						defaultColumnSortImageIndex=defaultColumnSortImageIndex+1;
					}
						stColPos=imgcnt+1;
						configsArr.add(configsObj);
					}
					else if(isValuesAvailableForInfo && isDBSummaryNeeded )
					{
						JSONObject configsObj = new JSONObject();
						configsObj.put("CONFIGURATION","-");
						configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
						configsArr.add(configsObj);
					}
				}
				
			}
			else if(enabledTests.contains(tempTestName) && !isExcludedTest)
			{
				if(s_alltestmeasure!=null && s_alltestmeasure.trim().equals("SystemTest:Cpu_util"))
				{
					Vector measures=new Vector();
					Vector testMapping = new Vector();
					String measuresForDB="";
					String testName="";
					String tempMeasures[] ={"SystemTest:Cpu_util","SystemTest:System_cpu_util"};
					for(int i=0;i<tempMeasures.length;i++)
					{
						String tempStr=tempMeasures[i];
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							testMapping.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(tempMeasures.length >i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";

					
					Vector allValuesForInfo = null;
					if(isOracleServer && isApplicationTab) 
					{
						allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName, portNo, testName, measuresForDB, msmtHost, sid);
						
					} else {
						allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName, portNo, testName, measuresForDB, msmtHost);
					}

					allValuesForInfo.remove("+");
					JSONArray cpuArr = new JSONArray();
					
					if(!disabledBlocks.contains(testName))
					{
						JSONObject cpuSumObj=new JSONObject();
						cpuSumObj.put("TITLE",mappingInfo.getTextDescription("monitor.dashboard.CPU Usage Summary"));
						cpuSumObj.put("TYPE", "LINEAR");
						cpuSumObj.put("HIDDEN", comparisonTableFullViewURL);
						
						if(adminPermission==true)
						{
							cpuSumObj.put("ADMIN_PERMISSION", "true");	
						}
						else
						{
							cpuSumObj.put("ADMIN_PERMISSION", "false");	
						}
						
					if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
					{
						JSONArray summaryArr=new JSONArray();
						JSONObject sumCol=new JSONObject();
						sumCol.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard.Measure"));
						sumCol.put("COLUMN_1", mappingInfo.getTextDescription("monitor.dashboard.Used")+" (%)");

						for(int k=0;k<allValuesForInfo.size();k++)
						{
								JSONObject summaryObj = new JSONObject();
								String val=(String)allValuesForInfo.get(k);
								Vector chartAttributes=new Vector();
								chartAttributes.add("bgColor='FFFFFF'");
								chartAttributes.add("bgAlpha='0'");
								chartAttributes.add("showBorder='0'");
								chartAttributes.add("upperLimit='100'");
								chartAttributes.add("lowerLimit='0'");
								chartAttributes.add("ticksBelowGauge='1'");
								chartAttributes.add("placeValuesInside='0'");
								chartAttributes.add("showGaugeLabels='0'");
								chartAttributes.add("valueAbovePointer='0'");
								chartAttributes.add("pointerOnTop='1'");
								chartAttributes.add("pointerRadius='6'");
								chartAttributes.add("chartTopMargin='5'");
								chartAttributes.add("chartBottomMargin='5'");
								chartAttributes.add("chartLeftMargin='25'");
								chartAttributes.add("chartRightMargin='25'");
								chartAttributes.add("majorTMColor='D73027'");
								chartAttributes.add("plotFillPercent='60'");
								chartAttributes.add("plotFillColor='000000'");
								chartAttributes.add("baseFontSize='8'");
								chartAttributes.add("baseFontColor='000000'");
								chartAttributes.add("pointerBgColor='000000'");
								chartAttributes.add("placeTicksInside='0'");
								chartAttributes.add("gaugeFillMix='{light-60},{light-40},{light-20},{dark-5},{D95F02},{light-30},{light-50},{dark-10}'");
								chartAttributes.add("gaugeFillRatio='20,30,20'");
								chartAttributes.add("gaugeRoundRadius='3'");
								chartAttributes.add("exportEnabled='0'");
								chartAttributes.add("exportAction='download'");
								chartAttributes.add("exportAtClient='0'");
								chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

								String linearGaugeXML=fusionChart.getXmlForLinearGauge(val,chartAttributes);
								JSONObject chartObj = new JSONObject();
								chartObj.put("XML_DATA",linearGaugeXML);
								chartObj.put("SWF_PATH","/final/FusionCharts/swf/HLinearGauge.swf");
								summaryObj.put("COLUMN_0", sumCol);
								summaryObj.put("COLUMN_1", chartObj);
								summaryArr.add(summaryObj);
						}
						cpuSumObj.put("SUMMARY", summaryArr);
						
					}
					else
					{
						cpuSumObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
						cpuSumObj.put("SUMMARY", "-");
						
					}
					if(!compType.startsWith("Agg_")){
						configsArr.add(cpuSumObj);
					}
				}
			
				}
				else
				{
				Vector measures=new Vector();
				String measuresForDB="";
				String testName="";

				for(int i=0;i<allMeasures.size();i++)
				{
					String tempStr=(String)allMeasures.get(i);
					if(tempStr!=null && tempStr.indexOf(":")!=-1)
					{
						testName=tempStr.substring(0,tempStr.indexOf(":"));
						String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
						Vector excludedInfos = dashboardDAO.getExcludedInfo(testName,tempMeasure,compType,false,false);
						measures.add(tempMeasure);
						measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
						if(allMeasures.size()>i+1)
							measuresForDB+=",";
					}
				}

				msmtHost=(String)allMsmtHosts.get(testName);
				if(msmtHost==null)
					msmtHost="";
				
				Vector allValuesForInfo = null;
				if(isOracleServer && isApplicationTab) 
				{
					 allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost,sid);
				}else {
					 allValuesForInfo = dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
				}

				allValuesForInfo.remove("+");
				if(isOracleServer && sid!=null && !sid.equals(""))
					allValuesForInfo.remove(sid+"+");				
					if(!disabledBlocks.contains(testName) && isDBSummaryNeeded)
					{
						JSONObject configsObj = new JSONObject();
						configsObj.put("TITLE", tableTitle);
						configsObj.put("TYPE", "SPARK");
						if(adminPermission==true)
						{
							configsObj.put("ADMIN_PERMISSION", "true");
						}
						else
						{
							configsObj.put("ADMIN_PERMISSION", "false");
						}
						boolean isMeasureAvaliable=false;
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							int jvmThreadsCnt = 0;
							JSONArray configArr = new JSONArray();
							for(int i=0;i<allValuesForInfo.size()&&measures.size()>i;i++)
							{
								JSONObject configObj = new JSONObject();
								if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
								{
									if(egDashboard.isTestHasCutOffFactor(testName))
									{
											boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,(String)allValuesForInfo.get(i));
											if(isTestExceededCutOffFactor)
												continue;
									}
								}
								if(!isMeasureAvaliable)
									isMeasureAvaliable=true;
								measure=(String)measures.get(i);
								String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
								String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,"+",sid,testName,measureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");

								String sidForGph = "";
								String layerNameTemp = "HOST";
								String tempInfo = "*";
								if (sid != null && !sid.equalsIgnoreCase("")) {
									sidForGph = sid;
									layerNameTemp = dashboardDAO.getLayerForTest(compType, testName, measure);
									tempInfo = sid + "*";
								} 

								String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?sid="+sidForGph+"&s_measure="+measure+"&measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+hostName+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&test="+testName+"&info="+tempInfo+"&layer="+layerNameTemp+"&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&module="+tab;

								//String urlForSummary="/final/monitor/egSummaryJSON.jsp?hostName="+compName+"&compType="+compType+"&subsystem=JVM Thread&ddmeasure="+measure+"&fullview=true&subject="+subject;
								
								SimpleDateFormat  sdf_dd=new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
								String s_startTime_DD=sdf_dd.format(start_Date);
								String urlForSummary=response.encodeURL("/final/monitor/ThreadDetails.jsp?")+"site=NULL&host="+com.eg.EgURLEncoder.encode(hostName,"UTF-8")+"&port="+portNo+"&test="+testName+"&msmt_host="+com.eg.EgURLEncoder.encode(msmtHost,"UTF-8")+"&flag=1&firsttime=true&sdate="+com.eg.EgURLEncoder.encode(s_startTime_DD,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(startTime,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(endTime,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(startHour,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(endHour,"UTF-8")+"&s_st_min="+endDate.getMinutes()+"&s_end_min="+startDate.getMinutes();
								String timeVal="";
								String key=hostName+":"+portNo+":"+testName+":"+msmtHost;
								String msmtTimeStr=dashboardDAO.getMeasureLastMsmtTime(key);
								if(!StringUtils.isNull(msmtTimeStr))
								{
									String db_date = msmtTimeStr.substring(0,msmtTimeStr.indexOf(" "));
									if(db_date!=null && db_date.indexOf("-")>-1)
									{
										String db_time = msmtTimeStr.substring(msmtTimeStr.indexOf(" ")+1);
										if(db_time!=null && db_time.endsWith(".0"))
											db_time = db_time.substring(0,db_time.lastIndexOf("."));
										db_date = DateUtil.changeDateFormat(db_date,"yyyy-MM-dd",currentDateFormat);
										msmtTimeStr = db_date+" "+db_time;
									}
									timeVal = com.eg.EgURLEncoder.encode(msmtTimeStr,"UTF-8");
								}
								
								String summaryTitle="Thread Details";

								if(compType!=null && compType.equalsIgnoreCase("MS_sql_server"))
								{
									String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
									String testMeasureState=egDashboard.getTestMeasureState(compName,compType,layerName,test,measure);

									urlForSummary="/final/monitor/egDashDDData.jsp?fromPage=current&site="+site+"&comptype=Host_system"+"&host="+hostName+"&port="+portNo+"&layer=HOST&test="+testName+"&stest="+testName+"-*&info=*&msmt_host="+msmtHost+"&time=Any&timeline=Any&measure="+measure+"&from=0&firsttime=true&flag=1&fromDDGraphs=false&newWindow=false&comeFrom=null&ddTitle="+EgURLEncoder.encode("MSSQL Processes","UTF-8")+"&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&fromDashboardOverview=true";
									summaryTitle="SQL "+mappingInfo.getMeasureDescription(testName,measure)+" Summary";
								}

								String value=(String)allValuesForInfo.get(i);
								if(!testerInfo.getAllowNegativeValues(test,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
								{
									value = "-";
								}

								Vector spartLineAttributes=new Vector();
								spartLineAttributes.add("palette='2'");
								spartLineAttributes.add("setAdaptiveYMin='0'");
								spartLineAttributes.add("bgAlpha='0,0'");
								spartLineAttributes.add("showHighAnchor ='0'");
								spartLineAttributes.add("showLowAnchor ='0'");
								spartLineAttributes.add("showOpenValue ='0'");
								spartLineAttributes.add("showCloseValue ='0'");
								spartLineAttributes.add("showHighLowValue ='0'");
								spartLineAttributes.add("showOpenAnchor ='0'");
								spartLineAttributes.add("showCloseAnchor ='0'");
								spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
								spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;comparesparkurl"+i+"&apos;)'");

								Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");

								String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);

								if(value!=null && !value.equals("-"))
								{
									JSONObject linkObj = new JSONObject();
									linkObj.put("MEASURE", mappingInfo.getMeasureDescription(testName, measure));
									if ( testName.equals("JvmThreadTest") )
									{
										//linkObj.put("METHOD_NAME", "wayToLayerModel");
										//hiddens.put("threadsConfigUrl"+tablescount, urlForSummary+"|event|"+summaryTitle);
										//hiddens.put("comparesparkurl"+i, urlForSummary+"&title="+summaryTitle);
										//linkObj.put("PARAMS", "threadsConfigUrl"+jvmThreadsCnt);
										linkObj.put("click","true");
										linkObj.put("measureName",measure);
										linkObj.put("Thread_METHOD_NAME", "sparklineOnclickForJavaThread");
										linkObj.put("Thread_PARAMS", urlForSummary);
										linkObj.put("METHOD_NAME", "sparklineOnclick");
										linkObj.put("PARAMS", "comparesparkurl"+jvmThreadsCnt);
										linkObj.put("comparesparkurl"+jvmThreadsCnt, urlForSummary);
										linkObj.put("summaryTitle", summaryTitle);
										linkObj.put("timeVal", timeVal);

										}
									configObj.put("LINK", linkObj);

								}
								else
								{
									configObj.put("MEASURE", mappingInfo.getMeasureDescription(testName, measure));
								}
								if(graph_values!=null  && graph_values.length()>0)
								{
									configObj.put("XML_DATA", sparkXML);
									configObj.put("SWF_PATH", "/final/FusionCharts/swf/SparkLine.swf");
									hiddens.put("comparesparkurl"+jvmThreadsCnt, urlForMaximize);
								}
								else
								{
									configObj.put("XML_DATA", "-");
								}
								configObj.put("VALUE", value);
								configArr.add(configObj);
								jvmThreadsCnt++;
							}
							if ( !configArr.isEmpty() )
							{
								
							if(!compType.startsWith("Agg_"))
							{
								configsObj.put("CONFIGURATION", configArr);
								configsArr.add(configsObj);
							}
							}
							else
							{
								if(!compType.startsWith("Agg_"))
								{
									configsObj.put("CONFIGURATION", "-");
									configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
									configsArr.add(configsObj);
								}
							}
						}
						
						if(!isMeasureAvaliable) 
						{
							if(!compType.startsWith("Agg_"))
							{
								configsObj.put("CONFIGURATION", "-");
								configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
								configsArr.add(configsObj);
							}
						}
					}
				}
			}
			else
			{				
				JSONObject configsObj = new JSONObject();
				configsObj.put("TITLE", tableTitle);
				configsObj.put("TYPE", "SPARK");
				configsObj.put("CONFIGURATION", "-");
				configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Test has been excluded or disabled")+"!");
				
				if(adminPermission==true)
				{
					configsObj.put("ADMIN_PERMISSION", "true");
				}
				else
				{
					configsObj.put("ADMIN_PERMISSION", "false");
				}
				//configsObj.put("CONFIGURATIONS", "-");
				//configsObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available")+"!");
				if(!compType.startsWith("Agg_"))
				{
					configsArr.add(configsObj);
				}
			}
			tablescount++;
		}		
	}
	rootJson.put("CONFIG_DATAS",configsArr);
	if(isFullViewForKPI)
	{
		JSONObject fullViewObj = new JSONObject();
		fullViewObj.put("lastFullViewURL",lastFullViewURL);
		fullViewObj.put("method","reloadFullView");
		rootJson.put("fullView", fullViewObj);
	}
	else if(isFullViewForConfig)
	{
		JSONObject fullViewObj = new JSONObject();
		fullViewObj.put("lastFullViewURL",lastFullViewURL);
		fullViewObj.put("method","showMaximizedTable");
		fullViewObj.put("params","event|ConfigDataDiv|"+configDivCount+"|"+configTitleStr);
		rootJson.put("fullView", fullViewObj);
	}
	String requestData = ErUtils.prepareQueryString(request.getParameterMap());
	if(requestData!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+requestData+"&host="+EgURLEncoder.encode(request.getParameter("hostName"),"UTF-8")+"&comptype="+request.getParameter("compType")+"&tab="+tab+"&graphType=SummaryAtGlance&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&host="+EgURLEncoder.encode(request.getParameter("hostName"),"UTF-8")+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	rootJson.put("hiddens", hiddens);
//	System.out.println("rootJson dashboardoverview "+rootJson.toString());
	out.println(rootJson.toString());
}
catch(Exception ex)
{
	ex.printStackTrace();
}

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
