package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.eg.EgDateInfo;
import com.egurkha.EgTimeZoneConverter;
import java.util.TimeZone;
import java.util.Calendar;
import com.egurkha.util.DateUtil;
import egurkha.config.EcUtils;
import com.egurkha.util.StringUtils;
import com.egurkha.util.EgSorter;
import com.egurkha.ini.IniUI;
import com.eg.EgInstallInfo;
import com.eg.EgURLEncoder;
import com.eg.IniFile;
import com.egurkha.util.DateUtil;
import com.egurkha.util.DateTimeTokenizer;
import java.text.SimpleDateFormat;
import com.eg.EgDbInfo;
import java.util.*;
import com.eg.EgSpecsInfo;

public final class MsSqlSysProcesses_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	public ArrayList arrayListSort(ArrayList arrList, int cols, int totalCols , String testName )
	{
		ArrayList result = new ArrayList();
		if (arrList==null || arrList.size()==0)
			return result;

		ArrayList dataTypeList = new ArrayList();
		dataTypeList.add("ZERO");
		if(testName.equals("SybSysProcessTest"))
		{
			dataTypeList.add("Long#asc");		//spid
			for(int k=0;k<5;k++){
				dataTypeList.add("String#asc"); //status , user , db , hostname , program_name
			}
			for(int k=0;k<5;k++){
				dataTypeList.add("Long#asc");	//blocking_spid , time_blocked, cpu(ticks) , physical_io, memusage
			}
			dataTypeList.add("String#asc");		//command
		}
		else if(testName.equals("MsSqlSysProcsTest") || testName.equals("MsSqlConnsTest"))
		{
			dataTypeList.add("Long#asc");		//SPID
			int times = 6;
			if(totalCols == 14) times = 5; 
			for(int k=0;k<times;k++){
				dataTypeList.add("String#asc");	//[User],DB,HOST,Program_Name,Login_Name,Last Execution
			}
			dataTypeList.add("Long#desc");		//Waittime
			dataTypeList.add("String#asc");		//Waittype
			dataTypeList.add("Long#asc");		//SPID Blocking
			for(int k=0;k<4;k++){
				dataTypeList.add("Long#desc");	//Trans, Physical_io, Mem_usage, Sleeptime
			}
			dataTypeList.add("String#asc");		//Last command
		}
		else if(testName.equals("OraSessionTest") || testName.equals("OraConnectionsTest"))
		{
			dataTypeList.add("Long#asc");
			dataTypeList.add("Long#asc");
			int times = 6;
			if(testName.equals("OraConnectionsTest"))
				times = 5;
			for(int k=0;k<times;k++){
				dataTypeList.add("String#asc");
			}
			dataTypeList.add("Long#asc");
			dataTypeList.add("String#asc");
			dataTypeList.add("String#asc");
		}

		if(dataTypeList.size() == 1)
			return result;

		String requiredType = (String) dataTypeList.get(cols);
		String colType = requiredType.substring(0,requiredType.indexOf("#"));
		String order =requiredType.substring(requiredType.indexOf("#")+1);

		EgSorter egSort = new EgSorter(arrList,totalCols);
		ArrayList sortList = (ArrayList)egSort.sort(cols,colType,order);
		return sortList;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgLoginTracker.jsp");
  }

  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.release();
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbsM.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*******************************************************************************
*	File name		: MsSqlSysProcesses.jsp
*	Purpose			: To show the Sql & Sybase sysprocesses along with its details
*	Version			: eG 5.3.
*	Creation Date	: 15/03/2011
*	Modifed			: 15/07/2011	- Support Sybase sysprocess
*	Modifed			: 10/08/2011	- To Provide Support for Oracle Sessions & Oracle User connections
******************************************************************************/


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile reportIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String strYaxisBasedOnData = reportIni.getValue("CHART_TYPE","YaxisBasedOnData");
	boolean isYaxisBasedOnData=false;
	if(strYaxisBasedOnData!=null && (strYaxisBasedOnData.equalsIgnoreCase("yes") || strYaxisBasedOnData.equalsIgnoreCase("true")))
		isYaxisBasedOnData = true;

	if(!request.getRequestURI().endsWith("EgMonitorHome.jsp"))
	{

      out.write("<script>\n\t\t\tfunction openWindow(path,name,winOptions)\n\t\t\t{\n\t\t\t\tvar win;\n\t\t\t\tvar obj = window.parent;\n\t\t\t\tif(window==window.parent)\n\t\t\t\t\tobj =window.opener;\n\t\t\t\tif(obj.openWindow!=null)\n\t\t\t\t\twin = obj.openWindow(path,name,winOptions);\n\t\t\t\telse\n\t\t\t\t\twin= window.open(path,name,winOptions);\n\t\t\t\treturn win;\n\t\t\t}\n\t\t</script>\n");

	}

      out.write("<script>\n\n\t/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE(){if(document.all){(message);return false;}}\n\tfunction clickNS(e){if(document.layers||(document.getElementById&&!document.all)){\n\tif(e.which==2||e.which==3){(message);return false;}}}\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers){document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;}\n\t\telse{document.onmouseup=clickNS;document.oncontextmenu=clickIE;}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n\n\n\t/**  To disable drag and selection */\n\tvar alltables = document.getElementsByTagName(\"body\");\n\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\twindow.onload = function() {\n\t\t\tfunction disableSelection(element) {\n\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\treturn false;\n\t\t\t\t};\n\t\t\t\telement.unselectable = \"on\";\n\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\telement.style.cursor = \"default\";\n\t\t\t}\n\n\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t}\n\n\t\t}\n\t}\n\n\tfunction callWindow(opt)\n\t{\n\t\tvar topWindow = window;\n\t\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t\t{\n\t\t\tmainWindow = topWindow;\n\t\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t\t}\n\t\tif(topWindow.location.pathname!=\"/\")\n\t\t\tmainWindow=topWindow;\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t\tmainWindow.focus();\n\t}\n</script>\n\n");

	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	String productionMode = trackerUI.getValue("UI_MIGRATION","SenchaProductionMode");
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	String userLogos = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{

			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				userLogos = u_ser.getUserLogo();

				trackerUI.set_loginID(u_rs);
				trackerUI.set_userLogo(userLogos);

				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || u_ser ==null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

			return;
	}
	else if(id_u== true)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(2);\n\t\t</script>\n");

			return;
	}
	else if (u_v_till < l_accessed)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\t\tcallWindow(3);\n\t\t\t</script>\n");

			return;
	}
	else
	{
		String smartValue=request.getParameter("smart");
		String site=request.getParameter("site");
		String servicename=request.getParameter("servicename");
		String page_help=request.getRequestURI();
		if((servicename==null || servicename.trim().length()==0) && (site==null || site.trim().length()==0))
		{
		if(smartValue==null || (smartValue!=null && smartValue.trim().length()==0))
		{
			if(!(page_help.endsWith("EgPrintGraph.jsp") || 
				page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")||(page_help.indexOf("Egprintdata.jsp")>-1)))
			{
				session.setAttribute("Page_IdentifierM", request.getRequestURI());
				if(page_help!=null && page_help.endsWith("componentMeasureTabSet.jsp"))
				{
					session.setAttribute("Page_IdentifierMP", request.getRequestURI());
				}
			}
			}
		}
	}

	String timezoneOffsetValue ="";
	EgDateInfo tracker_tdateInfo = new EgDateInfo();
	TimeZone tracker_tz = null;
	if (u_ser!=null)
	{
		u_ser.setUserLanguageAndSkins();
		monitor_Skin  = u_ser.getMonitorSkin();
		String trackerUserLang = u_ser.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}

		Calendar cal = Calendar.getInstance();
		java.util.Date local_date = new java.util.Date(tracker_tdateInfo.egetUTCDate());
		cal.setTime(local_date);
		cal.setTimeZone(tracker_tdateInfo.getRealTimeZone());
		String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
		String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
		String trac_currentDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",trac_currentDateFormat);
		EgTimeZoneConverter tracker_timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,u_ser);
		tracker_tz = tracker_timeZoneConverter.getTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));

		

		Calendar cal3 = GregorianCalendar.getInstance(tracker_tz);
		int offsetInMillis = tracker_tz.getOffset(cal3.getTimeInMillis());
		int offsetmin = 0;
		if(offsetInMillis<0)
			offsetmin =(Math.abs(offsetInMillis)/1000)/60;
		else
			offsetmin = (offsetInMillis/1000)/60;
		String offset = String.valueOf(offsetmin);
		
		//if(offsetInMillis>0)
		//{
			if(tracker_tz.getRawOffset()>=0)
				timezoneOffsetValue="-"+offset;
			else
				timezoneOffsetValue="+"+offset;
		//}
		//else
			//timezoneOffsetValue = (offsetInMillis >= 0 ? "+" : "-") + offset;
	}
	else
	{
		tracker_tz = tracker_tdateInfo.getRealTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));
		
		if(tracker_tz.getRawOffset()>=0)
			timezoneOffsetValue="-"+timezoneOffsetValue;
		else
			timezoneOffsetValue="+"+timezoneOffsetValue;
	}

		String  script_src="script_item_"+trackerLanguage+".js";
		String uiFileTemp = "eg_ui.ini";
		String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
		
		EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);

		//Variable to be used in javascript code
		String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String dateFormatNew = mgrDateFormat;
		if(currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}

		String dateFormatForDatePicker=(String)u_ser.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}
		IniUI egui_temp = IniUI.getInstance();
		String  strer_modeInTracker="2D";
		

      out.write("<script>\n\tvar strSkin='");
      out.print(monitor_Skin);
      out.write("';\n\tvar isYaxisBasedOnData=");
      out.print(isYaxisBasedOnData);
      out.write(";\n\tvar netRow = ( strSkin == 'Light' )?'netRow loaded':'darkRow loaded';\n\tvar pageListRow = ( strSkin == 'Light' )?'pageRow':'darkPageRow';\n\tvar netCol = ( strSkin == 'Light' )?'netCol':'darkNetCol';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netSummaryRow':'darkNetSummaryRow';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netRow tabView':'darkNetRow darkTabView';\n\tvar netFullHrefLabel = ( strSkin == 'Light' )?'netFullHrefLabel':'netFullHrefLabel';\n\tvar er_modeInTracker='");
      out.print(strer_modeInTracker);
      out.write("'\n\tvar dateFormatForTimeline = '");
      out.print(dateFormatNew);
      out.write("';\n\tvar settings='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Settings"));
      out.write("';\n\tvar toolData='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.SAVE"));
      out.write("';\n\tvar toolMail='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.MAIL"));
      out.write("';\n\tvar toolPrint='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.PRINT"));
      out.write("';\n\tvar timelineLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Hr"));
      out.write("';\n\tvar minLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Min"));
      out.write("';\n\tvar Tolbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.summary.Graph"));
      out.write("';\n\n\t// For Highcharts - UTC - timezoneOffset\n\tvar timeZoneOffsetVal='");
      out.print(timezoneOffsetValue);
      out.write("';\n\t//-----end-----\n\tdocument.onkeydown = fkey;\n\nfunction fkey(e){\n  e = e || window.event;\n\t  if (e.which == 116 || (e.keyCode == 82 && e.ctrlKey)) { //116 = F5\n\t\t\ttry\n\t\t\t{\n\t\t\t\twindow.parent.refreshEgIndexPage();\t\n\t\t\t}\n\t\t\tcatch (e)\n\t\t\t{\n\t\t\t\ttry{\n\t\t\t\t\twindow.parent.parent.refreshEgIndexPage();\t\n\t\t\t\t}\n\t\t\t\tcatch (e)\n\t\t\t\t{\n\t\t\t\t\twindow.opener.refreshEgIndexPage();\n\t\t\t\t}\n\t\t\t}\n\t return false;\n\t\t\n\t}\n }\n\n</script>\n\n\n\n\n\n\n\n\n\n");
      out.write("<html>\n<head>\n<title>MsSql Sys Processes</title>\n");
      if (_jspx_meth_egui_005fskin_005f0(_jspx_page_context))
        return;
      out.write("<style>\nselect {\n    padding:3px;\n    margin: 0;\n    -webkit-border-radius:0px;\n    -moz-border-radius:0px;\n    border-radius:0px;\n    /*-webkit-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;\n    -moz-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;\n    box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;*/\n    background: #fff;\n\tbackground:url(\"/final/images/Light/form_input_buttons.png\") no-repeat scroll 165px 1px #fff !important;\n    color:#000;\n    border-color:#abb2bd;\n\tborder-style:solid;\n\tborder-width:1px 1px 1px 1px;\n    display: inline-block;\n    -webkit-appearance:none;\n    -moz-appearance:none;\n    appearance:none;\n    cursor:pointer;\n\tposition: relative; \n\n\t&:focus {\n    z-index: 3;\n    width: 100%;\n    color: red;\n    outline: 2px solid #49aff2;\n    outline: 2px solid -webkit-focus-ring-color;\n    outline-offset: -2px;\n  }\n\t> option {\n    margin: 3px;\n    padding: 6px 8px;\n    text-shadow: none;\n    background: red;\n    border-radius: 3px;\n    cursor: pointer;\n  }\n}\n\n/* Targetting Webkit browsers only. FF will show the dropdown arrow with so much padding. */\n");
      out.write("@media screen and (-webkit-min-device-pixel-ratio:0) {\n    select {padding-right:18px}\n}\n\nlabel {position:relative;padding:2px}\nlabel:after {\n    content:'<>';\n    font:11px \"LucidaGrandeRegular\";\n    color:#aaa;\n    -webkit-transform:rotate(90deg);\n    -moz-transform:rotate(90deg);\n    -ms-transform:rotate(90deg);\n    transform:rotate(90deg);\n    right:8px; top:2px;\n    padding:0 0 2px;\n    border-bottom:1px solid #ddd;\n    position:absolute;\n    pointer-events:none;\n}\nlabel:before {\n    content:'';\n    right:6px; top:0px;\n    width:20px; height:20px;\n    background:#f8f8f8;\n\tpadding:2px 0 0,\n    position:absolute;\n    pointer-events:none;\n    display:block;\n}\nselect::-ms-expand {\n    display: none; /* hide default arrow in IE10 */\n}\n\n.option{\n\n\tpadding:2px;\n\theight:20px;\n\tbackground:green\n\n}\noption[selected=\"selected\"] {\n    /*css style here*/\n\tpadding:2px;\n\theight:20px;\n\tbackground:red\n}\n\t.jtm_DatapanelBody .jtm_Table td div{display:table-row;word-wrap:break-word !important;width:auto !important}\n</style>\n<script type=\"text/javascript\" src=\"/final/monitor/eg_scripts/eg_aggregate.js\"></script>\n");
      out.write("</head>\n<script type=\"text/javascript\">\n\n\tfunction showDetails(value)\n\t{\n\t\tvar measureTime=document.getElementById(\"time\").value;\n\t\tvar testname=document.getElementById(\"testname\").value;\n\t\tif(value == \"None\")\n\t\t{\n\t\t\tfillTabs('div_scroll','");
      out.print(response.encodeURL("../monitor/sqlProcess.jsp?"));
      out.write("'+\"details=None\");\n\t\t}\n\t\telse\n\t\t{\n\t\t\tvar mesValue = document.getElementById(\"measurename\").value;\n\t\t\tfillTabs('div_scroll','");
      out.print(response.encodeURL("../monitor/sqlProcess.jsp?"));
      out.write("'+\"&details=\"+encodeURIComponent(value)+\"&time=\"+encodeURIComponent(measureTime)+\"&measure=\"+encodeURIComponent(mesValue)+\"&test=\"+encodeURIComponent(testname));\n\t\t}\n\t\thideDivs('linkDiv');\n\t}\n\n\tfunction reloadUrl(url,mesValue,sortValue,measureTime)\n\t{\n\t\tvar fdate=ThreadForm.fdate.value;\n\t\tif(mesValue==null)\n\t\t\tmesValue = document.getElementById(\"measurename\").value;\n\t\tif(sortValue==null)\n\t\t\tsortValue = document.getElementById(\"sortname\").value;\n\t\tif(measureTime==null)\n\t\t\tmeasureTime=document.getElementById(\"time\").value;\n\n\t\turl=url+\"&s_measure=\"+mesValue+\"&sortby=\"+sortValue+\"&time=\"+measureTime;\n\t\tif(fdate!=null)\n\t\t\turl = url + \"&filterdate=\"+fdate;\n\t\twindow.location.href=url;\n\t}\n\n\tfunction hideDivs(divId)\n\t{\n\t\tvar show_div = document.getElementById(divId);\n\t\tif(show_div!=null)\n\t\t{\n\t\t\tshow_div.style.display=\"none\";\n\t\t}\n\t}\n\n\tfunction showThreadDetails(details,measuretime,measurename,testname)\n\t{\n\t\tvar divId = \"linkDiv\";\n\t\tvar linkDiv = document.getElementById(divId);\n\t\tvar title = \"Blocking process details\";\n\t\tvar popup_topright= (navigator.appVersion.toLowerCase().indexOf(\"msie 6.0\"))==-1?\"popup_topright\":\"popup_topright_noshade\";\n");
      out.write("\t\tvar popup_rightbg = (navigator.appVersion.toLowerCase().indexOf(\"msie 6.0\"))==-1?\"popup_rightbg\":\"popup_rightbg_noshade\";\n\t\tvar popup_bottomleft = (navigator.appVersion.toLowerCase().indexOf(\"msie 6.0\"))==-1?\"popup_bottomleft\":\"popup_bottomleft_noshade\";\n\t\tvar popup_bottombg = (navigator.appVersion.toLowerCase().indexOf(\"msie 6.0\"))==-1?\"popup_bottombg\":\"popup_bottombg_noshade\";\n\t\tvar popup_bottomright = (navigator.appVersion.toLowerCase().indexOf(\"msie 6.0\"))==-1?\"popup_bottomright\":\"popup_bottomright_noshade\";\n\n\t\tif(linkDiv!=null)\n\t\t{\n\t\t\tvar str='<table border=\"0\" bordercolor=\"blue\" cellpadding=\"0\" cellspacing=\"0\" >';\n\t\t\t\t\tstr+='<tr>';\n\t\t\t\t\t\tstr+='<td colspan=\"3\" width=\"100%\" onmousedown=\"dragOBJ(linkDiv,event); return false;\">';\n\t\t\t\t\t\t\tstr+='<table border=\"0\"  cellpadding=\"0\" cellspacing=\"0\" width=\"98%\"  class=\"jtm_InnerHeader\">';\n\t\t\t\t\t\t\t\tstr+='<tr>';\n\t\t\t\t\t\t\t\t\t//str+='<td width=\"10\" height=\"27\" class=\"popup_topleft\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"10\" height=\"27\" border=\"0\"></td>';\n\t\t\t\t\t\t\t\t\tstr+='<td id=\"GraphTitle\" style=\"padding-left:10px\" height=\"27px\">'+title+'</td>';\n");
      out.write("\t\t\t\t\t\t\t\t\tstr+='<td align=\"right\" style=\"padding-right:10px\"><img class=\"iconClose3\" src=\"/final/images/clear.png\" border=\"0\" class=\"mouse\" title=\"close\" vspace=\"2\" onclick=\"javascript:hideDivs(\\''+divId+'\\');\"> </td>';\n\t\t\t\t\t\t\t\t\t//str+='<td width=\"17\" height=\"27\" class=\"'+popup_topright+'\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"17\" height=\"27\" border=\"0\"></td>';\n\t\t\t\t\t\t\t\tstr+='</tr>';\n\t\t\t\t\t\t\tstr+='</table>';\n\t\t\t\t\t\tstr+='</td>';\n\t\t\t\t\tstr+='</tr>';\n\t\t\t\t\tstr+='<tr>';\n\t\t\t\t\t\tstr+='<td class=\"popup_leftbg\"  width=\"7px\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"7\"></td>';\n\t\t\t\t\t\tstr+='<td align=\"center\" valign=\"top\" >';\n\t\t\t\t\t\t\t//str+='<div  class=\"div_scroll\">';\n\t\t\t\t\t\t\t\tstr+='<table border=\"0\" bordercolor=\"green\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" height=\"100%\">';\n\t\t\t\t\t\t\t\t\tstr+='<tr>';\n\t\t\t\t\t\t\t\t\t\tstr+='<td class=\"white_bg\">';\n\t\t\t\t\t\t\t\t\t\t\t //str+='<iframe src=\"'+url+'\" width=\"635\" height=\"250\" frameborder=\"0\" leftmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" rightmargin=\"0\"> </iframe>';\n\t\t\t\t\t\t\t\t\t\t\tstr+='<div class=\"div_scroll\" id=\"innerDiv\"  name=\"innerDiv\" style=\"left:0px;top:0px;width:660px;overflow-x:hidden;overflow-y:auto;height:270px;border:0px solid #ff0000;padding:4px;\"> </div>';\n");
      out.write("\t\t\t\t\t\t\t\t\t\tstr+='</td>';\n\t\t\t\t\t\t\t\t\tstr+='</tr>';\n\t\t\t\t\t\t\t\tstr+='</table>';\n\t\t\t\t\t\t\t//str+='</div>';\n\t\t\t\t\t\tstr+='</td>';\n\t\t\t\t\t\tstr+='<td class=\"'+popup_rightbg+'\" width=\"14px\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"14\"></td>';\n\t\t\t\t\tstr+='</tr>';\n\t\t\t\t\tstr+='<tr>';\n\t\t\t\t\t\tstr+='<td class=\"'+popup_bottomleft+'\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"7\" height=\"16\"></td>';\n\t\t\t\t\t\tstr+='<td  class=\"'+popup_bottombg+'\" height=\"16\"><img src=\"/final/monitor/eg_images/spacer.gif\"></td>';\n\t\t\t\t\t\tstr+='<td class=\"'+popup_bottomright+'\"><img src=\"/final/monitor/eg_images/spacer.gif\" width=\"14\" height=\"16\"></td>';\n\t\t\t\t\tstr+='</tr>';\n\t\t\t\tstr+='</table>';\n\t\t\tlinkDiv.innerHTML=str;\n\t\t\tshowDivs('linkDiv');\n\t\t\tfillTabs('innerDiv','");
      out.print(response.encodeURL("../monitor/sqlProcess.jsp?"));
      out.write("'+\"&details=\"+encodeURIComponent(details)+\"&time=\"+encodeURIComponent(measuretime)+\"&measure=\"+encodeURIComponent(measurename)+\"&test=\"+encodeURIComponent(testname));\n\t\t}\n\t}\n\n\tfunction showDivs(divId)\n\t{\n\t\tvar show_div = document.getElementById(divId);\n\t\tif(show_div!=null)\n\t\t{\n\t\t\tshow_div.style.display = 'block';\n\t\t\tshow_div.style.position = 'absolute';\n\t\t\tbringToFront(show_div);\n\t\t}\n\t}\n\n\t// <-- Dragging the Div -->\n\tfunction $(v) \n\t{ \n\t\treturn(document.getElementById(v)); \n\t}\n\n\tfunction agent(v) \n\t{ \n\t\treturn(Math.max(navigator.userAgent.toLowerCase().indexOf(v),0)); \n\t}\n\n\tfunction xy(e,v) \n\t{ \n\t\treturn(v?(agent('msie')?event.clientY+document.body.scrollTop:e.pageY):(agent('msie')?event.clientX+document.body.scrollTop:e.pageX)); \n\t}\n\n\tfunction dragOBJ(d,e) \n\t{\n\t\tvar divId = d.id;\n\t\tfunction drag(e) \n\t\t{ \n\t\t\tif(!stop) \n\t\t\t{ \n\t\t\t\ttX = xy(e,1)+oY-eY; \n\t\t\t\ttY = xy(e)+oX-eX; \n\t\t\t\td.style.top= ((tX <= windowHeight)? tX : windowHeight)+'px';\n\t\t\t\td.style.left=((tY <=windowWidth) ? tY : windowWidth)+'px';\n\t\t\t}\n\t\t}\n\n\t\tvar oX=parseInt(d.style.left),oY=parseInt(d.style.top),eX=xy(e),eY=xy(e,1),tX,tY,stop;\n");
      out.write("\t\tvar windowWidth = document.body.clientWidth;\n\t\tvar\twindowHeight = document.body.clientHeight;\n\n\t\tdocument.onmousemove=drag; \n\t\tdocument.onmouseup=function()\n\t\t{ \n\t\t\tstop=1; \n\t\t\tdocument.onmousemove=''; \n\t\t\tdocument.onmouseup=''; \n\t\t\tbringToFront(d);\n\t\t};\n\t}\n</script>\n<body leftmargin=\"0\" topmargin=\"0\" marginheight=\"0\" marginwidth=\"0\" scroll=\"no\" style=\"overflow:hidden\">\n<div id=\"linkDiv\" name=\"linkDiv\" class=\"linesquare\" style=\"display:none;left:125px;top:90px;width:677px;height:306px; position:absolute;background:#fff;overflow-x:hidden;overflow-y:hidden;position:absolute;-webkit-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);-moz-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);box-shadow:0 10px 10px 0 rgba(100,100,100,0.45)\"></div>\n\n");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

      egurkha.TransactionBean trans = null;
      synchronized (_jspx_page_context) {
        trans = (egurkha.TransactionBean) _jspx_page_context.getAttribute("trans", PageContext.PAGE_SCOPE);
        if (trans == null){
          trans = new egurkha.TransactionBean();
          _jspx_page_context.setAttribute("trans", trans, PageContext.PAGE_SCOPE);
        }
      }
      com.egurkha.monitor.EgDiagnosisBean dd = null;
      synchronized (_jspx_page_context) {
        dd = (com.egurkha.monitor.EgDiagnosisBean) _jspx_page_context.getAttribute("dd", PageContext.PAGE_SCOPE);
        if (dd == null){
          dd = new com.egurkha.monitor.EgDiagnosisBean();
          _jspx_page_context.setAttribute("dd", dd, PageContext.PAGE_SCOPE);
        }
      }

	String isTable="";
	isTable = isFirefox ? "Auto" : "Fixed";
	String s_mes = null;
	String s_st_time = "";
	String s_st_hr = "0";
	String s_en_time = "";
	String s_en_hr = "0";
	String s_st_min = "0";
	String s_end_min = "0";
	String s_info=request.getParameter("info");
	String s_first_time = request.getParameter("firsttime");
	String s_flag = request.getParameter("flag");
	String s_site=request.getParameter("site");
	String s_host=request.getParameter("host");
	String s_port=request.getParameter("port");
	String s_test=request.getParameter("test");
	String s_date=request.getParameter("sdate");
	String s_measure=request.getParameter("s_measure");
	String s_msmt_host=request.getParameter("msmt_host");
	String sortOrder=request.getParameter("sortby");
	String filterdate = request.getParameter("filterdate");

	boolean isSqlConnTest = false; 
	boolean isSybaseTest = false;
	boolean isOraSessionTest = false;
	boolean isOraConnectionsTest = false;
	boolean isSqlSysProcessTest = false;
	if(s_test!=null)
	{
		if(s_test.equalsIgnoreCase("MsSqlConnsTest"))
			isSqlConnTest = true;
		else if(s_test.equalsIgnoreCase("SybSysProcessTest"))
			isSybaseTest = true;
		else if(s_test.equalsIgnoreCase("OraSessionTest"))
			isOraSessionTest = true;
		else if(s_test.equalsIgnoreCase("OraConnectionsTest"))
			isOraConnectionsTest = true;
		else
			isSqlSysProcessTest = true;
	}
	if(s_info == null)
		s_info = "NONE";
	
	EgDbInfo dbInfo = new EgDbInfo("manager");
	trans.createFile("eg_format.ini");
	String strValue=trans.getStrValue("DDD_TESTS", s_test);
	String [] colNames = dbInfo.getColumnNamesForTest(s_test+"_DDD");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	if(s_date!=null && s_date.length() > 0)
	{
		s_st_time=request.getParameter("s_st_time");
		s_en_time=request.getParameter("s_en_time");
		s_st_hr=request.getParameter("s_st_hr");
		s_en_hr=request.getParameter("s_en_hr");
		s_st_min=request.getParameter("s_st_min");
		s_end_min=request.getParameter("s_end_min"); 
	}

	Vector v_measures = new Vector();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String comFormat = null;
	String endDateTime ="";
	String startDateTime ="";
	String colNamesForQuery = "";
	String lastMesTime = request.getParameter("time");
	String dummylastMesTime = lastMesTime;
	String s_st_sec="00";

	// Table and cell Width for Browser Compatability
	String wd = "";
	String wdtd = "";
	String divHeight = "";

	ArrayList a_results = new ArrayList();
	if((s_st_time!=null && s_st_time.equals("")) || (s_en_time!=null && s_en_time.equals("")))
	{
		String tempp = currentDateFormat +" HH:mm";

		SimpleDateFormat sdf = new SimpleDateFormat(tempp);
		java.util.Date tmpday = new java.util.Date();
		endDateTime = sdf.format(tmpday);
		java.util.Date startDate2 = new java.util.Date();
		startDate2.setTime(tmpday.getTime() - (3600 * 1000));
		startDateTime = sdf.format(startDate2);

		s_st_time = startDateTime.substring(0,startDateTime.lastIndexOf(" "));
		s_en_time = endDateTime.substring(0,endDateTime.lastIndexOf(" "));

		s_st_hr = startDateTime.substring(startDateTime.lastIndexOf(" ")+1,startDateTime.indexOf(":"));
		s_en_hr = endDateTime.substring(endDateTime.lastIndexOf(" ")+1,endDateTime.indexOf(":"));

		s_st_min = startDateTime.substring(startDateTime.indexOf(":")+1);
		s_end_min = endDateTime.substring(endDateTime.indexOf(":")+1);
	}

	boolean filterDateFlag = false;
	String fdate="";
	if(filterdate!=null && filterdate.length()>4)
	{
		String tmpDate="";
		if(filterdate.indexOf(":")>-1)
		{
			fdate=filterdate.substring(0, filterdate.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
		}

		int shr = Integer.parseInt(filterdate.substring(filterdate.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1, filterdate.indexOf(":")));
		int st_min=Integer.parseInt(filterdate.substring(filterdate.indexOf(":")+1,filterdate.lastIndexOf(":")));
		int st_sec=Integer.parseInt(filterdate.substring(filterdate.lastIndexOf(":")+1));
		s_st_time=filterdate.substring(0, filterdate.indexOf(DateTimeTokenizer.BLANK_SPACE));
		s_st_hr = String.valueOf(shr);
		s_st_min = String.valueOf(st_min);
		s_en_hr=String.valueOf(shr);
		s_st_sec=String.valueOf(st_sec);

		if(!DateUtil.isDate(fdate,"MM/dd/yyyy"))
		{
			fdate = DateUtil.changeDateFormat(fdate,currentDateFormat,"MM/dd/yyyy");
		}
		filterDateFlag=true;
	}

	EgTimeZoneConverter startConverter = new EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+s_st_min+":00",user,true);
	String ss_st_time = (String)startConverter.getDate(false);
	String ss_st_hr = startConverter.getHour();
	String ss_st_min = startConverter.getMinute();

	EgTimeZoneConverter endConverter = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+s_end_min+":00",user,true);
	String se_en_time = (String)endConverter.getDate(false);
	String ss_en_hr = endConverter.getHour();
	String ss_end_min = endConverter.getMinute();

	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		comFormat = "MM/dd/yyyy";
	else
		comFormat = currentDateFormat;

	//String ss_st_time = s_st_time;

	if(!DateUtil.isDate(ss_st_time,"MM/dd/yyyy"))
		ss_st_time = DateUtil.changeDateFormat(ss_st_time,comFormat,"MM/dd/yyyy");
	
	if(DateUtil.isDate(se_en_time,"MM/dd/yyyy"))
		comFormat = "MM/dd/yyyy";
	else
		comFormat = currentDateFormat;

	//String se_en_time = s_en_time;

	if(!DateUtil.isDate(se_en_time,"MM/dd/yyyy"))
		se_en_time = DateUtil.changeDateFormat(se_en_time,comFormat,"MM/dd/yyyy");

	if (!strValue.equals(""))
	{
		if(colNames != null && colNames.length > 0)
		{
			for(int r=0; r<colNames.length; r++)
			{
				colNamesForQuery +=colNames[r] + ",";
			}
			if(colNamesForQuery.endsWith(","))
			{
				colNamesForQuery = colNamesForQuery.substring(0, (colNamesForQuery.length()-1));
			}
		}
	}

	if(s_first_time != null && !s_first_time.equals("") && s_first_time.equals("true"))
	{
		if(s_test != null && !s_test.equals(""))
			v_measures=dd.populateMeasures(s_test);
	}

	s_mes = (String) v_measures.get(0);
	String[] Desc = dd.getDescription(s_test,s_mes);

	if(s_measure!=null && s_measure.length()>0)
	{
		if(filterDateFlag)
		{
			ArrayList al = dd.getDiagnosisDataForDate(s_host, s_port,s_site, s_test, s_measure, s_info, ss_st_time, se_en_time, ss_st_hr, ss_en_hr,ss_st_min,ss_end_min,s_st_sec,s_flag,colNamesForQuery,s_msmt_host,fdate);
			if(al != null && al.size() > 0)
				a_results.addAll(al);
		}
		else
		{
			ArrayList al = dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_measure, s_info, ss_st_time, se_en_time, ss_st_hr, ss_en_hr,ss_st_min+":"+s_st_sec,ss_end_min+":59",s_flag,colNamesForQuery,s_msmt_host);
			if(al != null && al.size() > 0)
				a_results.addAll(al);
		}
	}
	
	Hashtable mappingTable = new Hashtable();
	ArrayList columnList = new ArrayList();

	if(Desc!=null && s_measure!=null)
	{
		String colStr = Desc[0].substring(Desc[0].indexOf(":")+1);
		StringTokenizer st = new StringTokenizer(colStr);
		int count = st.countTokens();
		String[] col = new String[15];
		if(isSqlConnTest)
			col = new String[14];
		else if(isSybaseTest)
			col = new String[12];
		else if(isOraSessionTest)
			col = new String[11];
		else if(isOraConnectionsTest)
			col = new String[10];
		for(int j=0;j<count;j++)
		{
			col[j] = st.nextToken();
			columnList.add(col[j]);
			mappingTable.put(col[j],new Integer(j+1));
		}
	}

	String [] test_array=trans.getVariables("OS_DEPENDENT_DD_TEST");
	ArrayList osDepTestList = new ArrayList();
	if(test_array!=null && test_array.length>0)
		osDepTestList = new ArrayList(Arrays.asList(test_array));

	String s_ct=request.getParameter("comptype");
	String os_name="";
	boolean isOSDepTest=false;
	if(osDepTestList!=null && s_test!=null && osDepTestList.contains(s_test))
	{
		os_name=(String)Server.getOSName(s_ct,s_host);
		if(os_name!=null && os_name.trim().length()>0)
		{
			os_name=os_name.toLowerCase();
			isOSDepTest = true;
		}
	}

	String osDepColumn  = null;
	if(isOSDepTest)
	{
		if(os_name!=null && os_name.startsWith("win"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Windows");
		else if(os_name!=null && os_name.startsWith("lin"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Linux");
		else if(os_name!=null && os_name.startsWith("sol"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Solaris");
	}

	String emptyColumn = trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure);

	if(osDepColumn!=null && osDepColumn.trim().length()>0)
	{
		emptyColumn=(emptyColumn==null)?"":emptyColumn;
		if(emptyColumn!=null && emptyColumn.trim().length()>0)
			emptyColumn=emptyColumn+","+osDepColumn;
		else
			emptyColumn=osDepColumn;
	}

	ArrayList emptyColumnsList = new ArrayList();
	if(emptyColumn!=null && emptyColumn.indexOf(",") > -1)
	{
		emptyColumnsList = com.egurkha.util.StringUtils.egTokenizer(emptyColumn,",",true,false,true);
	}
	ArrayList valList = new ArrayList();
	ArrayList measureTimeList = new ArrayList();

	if(a_results.size()>0)
	{
		if(StringUtils.isNull(lastMesTime))
		{
			if(s_date!=null && s_date.length()>0)
			{
				lastMesTime= s_date;
			}
			else
				lastMesTime=(String) a_results.get(0);
		}

		for(int k=0;k<a_results.size();k=k+2)
		{
			String mesTime = (String) a_results.get(k);
			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(mesTime, user);
			mesTime = timeZoneConverter.getDateTime();
			measureTimeList.add(mesTime);
			if(lastMesTime.equals(mesTime))
			{
				ArrayList val = (ArrayList) a_results.get(k+1);
				Set valSet = new HashSet(val);
				List listVal = new ArrayList(valSet);
				for(int j=0;j<listVal.size();j++)
				{
					ArrayList tmpArrList = (ArrayList) listVal.get(j);
					if(tmpArrList!=null && tmpArrList.size() > 0){
						valList.add(tmpArrList);
					}
				}
			}
		}
	}
	int totCols = 0;

	if(isSybaseTest)	// For Sybase System process
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		if(s_measure!=null)
		{
			totCols = 12;
		}
	}
	else if(isOraSessionTest)
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		totCols = 11;
	}
	else if(isOraConnectionsTest)
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		totCols = 10;
	}
	else	// For Ms-SQL System process
	{
		totCols = isSqlConnTest ? 14:15 ;
		if(s_measure!=null && StringUtils.isNull(sortOrder))
		{
			if(s_measure.equalsIgnoreCase("Sleeping_processes"))
				sortOrder = isSqlConnTest ? "13" : "14" ;
			else 
				sortOrder = isSqlConnTest ? "11" : "12" ;
		}
	}
	int sortColumn = Integer.parseInt(sortOrder);
	ArrayList tmpList = arrayListSort(valList,sortColumn,totCols ,s_test);

	ArrayList spidList = new ArrayList();
	Hashtable resultTable = new Hashtable();

	for(int k=0;k<tmpList.size();k++)
	{
		ArrayList arrList =  (ArrayList) tmpList.get(k);
		if(arrList!=null && arrList.size() > 0)
		{
			String spid = (String)arrList.get(0);
			spidList.add(spid);
			StringBuffer sb = new StringBuffer();
			int size = arrList.size();
			for(int y=0;y<size;y++)
			{
				String line = (String) arrList.get(y);
				if(y==(size-1))
				{
					while(line.indexOf(">")>=0)
						line = line.replaceAll(">","&gt;");
					while(line.indexOf("<")>=0)
						line = line.replaceAll("<","&lt;");
					while(line.indexOf("\"")>=0)
						line = line.replaceAll("\"","&quot");
				}
				while(line.indexOf("\\")>=0)
				{
					String before = line.substring(0,line.indexOf("\\"));
					String after = line.substring(line.indexOf("\\")+1);
					line = before +"&#092;" + after;
				}
				sb.append(line + "#~#");
			}
			String res  = (sb.toString()).substring(0,sb.length()-3);
			resultTable.put(spid,res);
		}
	}

	if(spidList.size()==0)
	{
		spidList.add("None*:*None");
		measureTimeList.add(dummylastMesTime);
		resultTable.put("None*:*None","None");
	}

	//To avoid duplicate measurement time
	TreeSet ts = new TreeSet(measureTimeList);
	measureTimeList = new ArrayList(ts);

	if (isFirefox)
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "354px";
	}	
	else if (isChrome)
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "380px";
	}
	else
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "358px";
	}

	if(StringUtils.isNull(lastMesTime))
		lastMesTime = "Not Available";

	if(!lastMesTime.equals("Not Available")||(s_date!=null) && spidList.size()>=0 && a_results.size()>0)
	{

      out.write("<table align=\"left\" cellspacing=\"0\" cellpadding=\"4\" border=\"0\" class=\"data_border\" style=\"table-layout:");
      out.print(isTable);
      out.write(";border-top-width:0px;height:100%\" ><col width=\"150\"><col width=\"6px\"><col width=\"80%\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"3\" style=\"font-size:8pt;border-top-width:0px;border-bottom-width:0px\" >\n");

		String Url="";
		if(s_date==null || s_date.length()==0)
		{
			Url = "../monitor/MsSqlSysProcesses.jsp?site=" + EgURLEncoder.encode("NULL","UTF-8") + "&host=" +com.eg.EgURLEncoder.encode(s_host,"UTF-8") +"&port=" + s_port + "&test="+s_test+"&msmt_host="+com.eg.EgURLEncoder.encode(s_msmt_host,"UTF-8")+ "&from=0&flag=1&firsttime=true"+"&info="+com.eg.EgURLEncoder.encode(s_info,"UTF-8");
		}
		else
		{
			Url = "../monitor/MsSqlSysProcesses.jsp?site=" + EgURLEncoder.encode("NULL","UTF-8") + "&host=" +com.eg.EgURLEncoder.encode(s_host,"UTF-8") +"&port=" + s_port + "&test="+s_test+"&msmt_host="+com.eg.EgURLEncoder.encode(s_msmt_host,"UTF-8")+ "&from=0&flag=1&firsttime=true&sdate="+com.eg.EgURLEncoder.encode(s_date,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(s_st_time,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(s_en_time,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(s_st_hr,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(s_en_hr,"UTF-8")+"&s_st_min="+com.eg.EgURLEncoder.encode(s_st_min,"UTF-8")+"&s_end_min="+com.eg.EgURLEncoder.encode(s_end_min,"UTF-8")+"&info="+com.eg.EgURLEncoder.encode(s_info,"UTF-8");
		}

      out.write("<div class=\"jtm_formouter\" style=\"height:40px;padding:10px;display:inline-block;width:97%\"><table class=\"jtm_Table\" align=\"left\" cellspacing=\"0\" cellpadding=\"4\" border=\"0\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td ><div style=\"padding:2px;font-weight:bold\"> ");
      if (_jspx_meth_egui_005fintnl_005f0(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t\t\t\t<div><select name =\"time\" id=\"time\" class=\"jtm_Select\" style=\"width:180px\" onChange=\"javaScript:reloadUrl('");
      out.print(response.encodeURL(Url));
      out.write("',null,null,this.value)\">\n");

		for(int i=measureTimeList.size()-1;i>=0;i--)
		{
			String tmp = (String)measureTimeList.get(i);
			EgTimeZoneConverter egTimeZoneConverter = new EgTimeZoneConverter(tmp,user);
			String displayDateTime = egTimeZoneConverter.getDateTime();
			String selected="";
			if (tmp.equals(lastMesTime))
				selected ="selected";
			else
				selected="";

      out.write("<option value=\"");
      out.print(tmp);
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write('>');
      out.write(' ');
      out.print(displayDateTime);
      out.write("</option>\n");

		}

      out.write("</select></div>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td ><div style=\"padding:2px;font-weight:bold\"> ");
      if (_jspx_meth_egui_005fintnl_005f1(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t\t\t\t<div><select name=\"measurename\" id=\"measurename\" class=\"jtm_Select\" style=\"width:180px\" onChange=\"javaScript:reloadUrl('");
      out.print(response.encodeURL(Url));
      out.write("',this.value,null,null)\">\n");

		for(int k=0;k<v_measures.size();k++)
		{
			String tmp = (String) v_measures.get(k);
			String selected="";
			if(tmp.equals(s_measure))
				selected="selected";
			else
				selected="";

      out.write("<option value =\"");
      out.print(tmp);
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f2 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f2.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f2.setParent(null);
      // /monitor/MsSqlSysProcesses.jsp(818,51) name = measure type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f2.setMeasure(s_test+":"+tmp);
      int _jspx_eval_egui_005fintnl_005f2 = _jspx_th_egui_005fintnl_005f2.doStartTag();
      if (_jspx_th_egui_005fintnl_005f2.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
      out.write("</option>\n");

		}

      out.write("</select></div>\n\t\t\t\t\t\t\t\t\t</td>\n");

		if(columnList!=null && columnList.size() > 0)
		{

      out.write("<td ><div style=\"padding:2px;font-weight:bold\"> ");
      if (_jspx_meth_egui_005fintnl_005f3(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t\t\t\t<div><select name=\"sortname\" id=\"sortname\"  class=\"jtm_Select\"  style=\"width:180px\" onChange=\"javaScript:reloadUrl('");
      out.print(response.encodeURL(Url));
      out.write("',null,this.value,null)\">\n");

			for(int k=0;k<columnList.size();k++)
			{
				String tmp = (String) columnList.get(k);
				if(emptyColumnsList.contains(tmp))
					continue;
				Integer indexObj = (Integer)mappingTable.get(tmp);
				String selected="";
				if(sortOrder.equals(indexObj.toString()))
					selected="selected";
				else
					selected="";

      out.write("<option value =\"");
      out.print(indexObj.toString());
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f4 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f4.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f4.setParent(null);
      // /monitor/MsSqlSysProcesses.jsp(843,67) name = measure type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f4.setMeasure(s_test+":"+tmp);
      int _jspx_eval_egui_005fintnl_005f4 = _jspx_th_egui_005fintnl_005f4.doStartTag();
      if (_jspx_th_egui_005fintnl_005f4.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
      out.write("</option>\n");

			}

      out.write("</select></div>\n\t\t\t\t\t\t\t\t\t</td>\n");

		}
		else
		{

      out.write("<td align=\"right\" class=\"eg_75bold\">&nbsp;</td>\n");

		}

      out.write("</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td colspan=\"3\" valign=\"top\" width=\"100%\" style=\"padding:8px\">\n\t\t\t\t\t\t<table align=\"left\" cellspacing=\"0\" cellpadding=\"4\" border=\"0\" class=\"jtm_datapanel\" style=\"table-layout:auto;\"  width=\"100%\">\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td height=\"100%\" valign=\"top\"  style=\"width:220px;padding:0px\">\n\t\t\t\t\t\t\t\t\t<table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" class=\"jtm_table\">\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td height=\"100%\" >\n\t\t\t\t\t\t\t\t\t\t\t<div class=\"jtm_DatapanelHeader\" style=\"padding:3px;margin:8px 0 8px 8px\"> ");
      if (_jspx_meth_egui_005fintnl_005f5(_jspx_page_context))
        return;
      out.write("</div>\n\t\t\t\t\t\t\t\t\t\t\t\t<div style=\"height:410px;width:220px;position:relative;\">\n");

		if(monitor_Skin.equalsIgnoreCase("Dark") || monitor_Skin.equalsIgnoreCase("dark"))
		{ 

      out.write("<select NAME=\"threadname\" id=\"threadname\" size=\"10\" style=\"top:0;bottom:0;width:220px;border:0px;position:absolute;height:inherit;background:#515151 !important;color:#c6c6c6!important;\" onChange=\"javaScript:showDetails(this.value)\">\n");

		}
		else
		{

      out.write("<select NAME=\"threadname\" id=\"threadname\" size=\"10\" style=\"top:0;bottom:0;width:220px;border:0px;position:absolute;height:inherit;background:#fff !important;color:#000!important;\" onChange=\"javaScript:showDetails(this.value)\">\n");

		}


		int count =spidList.size();
		if(count==1) 
		{
			if(spidList.contains("None*:*None"))
				count=0;
		}
		for(int k=0;k<spidList.size();k++)
		{
			String spid = (String) spidList.get(k);
			String optionValue = (String) resultTable.get(spid);
			if(spid.indexOf("*:*") > 0)
			{
				spid = spid.substring(0,spid.indexOf("*:*"));
			}
			String selected="";
			selected = (k==0)?"selected":"";

      out.write("<option VALUE=\"");
      out.print(optionValue);
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write(" title='");
      if (_jspx_meth_egui_005fintnl_005f6(_jspx_page_context))
        return;
      out.print(count);
      out.write('\'');
      out.write('>');
      out.print(spid);
      out.write("</option>\n");

		}

      out.write("</select>\n\t\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t<td style=\"padding:3px\" style=\"width:6px\"><img src = \"/final/images/spacer.gif\" width=\"6px\"></td>\n\t\t\t\t\t\t\t\t<td valign=\"top\" class=\"jtm_datapanel\" width=\"100%\"  style=\"height:100%;padding:14px 14px 0 14px\" >\n\t\t\t\t\t\t\t\t\t<form name=\"ThreadForm\" style=\"margin:0px;padding:0px\" id=\"ThreadForm\">\n\t\t\t\t\t\t\t\t\t\t<div id=\"div_scroll\" style=\"overflow-x:hidden;overflow-y:auto;border:0px solid blue;height:427px;width:100%\"></div>\n\t\t\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"fdate\" id=\"fdate\" value=\"");
      out.print(filterdate);
      out.write("\">\n\t\t\t\t\t\t\t\t\t</form>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t\t<input type=\"hidden\" name=\"testname\" id=\"testname\" value='");
      out.print(s_test);
      out.write('\'');
      out.write('>');
      out.write('\n');

		if(spidList.size() >0 && spidList != null)
		{
			String firstKey = (String)spidList.get(0);
			String firstOptionValue = (String)resultTable.get(firstKey);

      out.write("<script type=\"text/javascript\">\n\t\t\t\tvar t=setTimeout(\"showDetails('");
      out.print(firstOptionValue);
      out.write("')\",0)\n\t\t\t</script>\n");

		}
	}
	else
	{
		String msg = "monitor.layermodel.Details not available";

      out.write("<table height=\"100%\" width=\"100%\" border=\"0\" class=\"data_border\" style=\"table-layout:");
      out.print(isTable);
      out.write(";border-top-width:0px\" >\n\t\t\t\t<tr>\n\t\t\t\t\t<td align=\"center\" valign=\"middle\" class=\"commonErrorMsgText\" > \n\t\t\t\t\t\t<img src=\"/final/images/clear.png\" class=\"iconExclamation\" align=\"center\" border=\"0\" /><br>\n\t\t\t\t\t\t");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f7 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f7.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f7.setParent(null);
      // /monitor/MsSqlSysProcesses.jsp(950,6) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f7.setText(msg);
      int _jspx_eval_egui_005fintnl_005f7 = _jspx_th_egui_005fintnl_005f7.doStartTag();
      if (_jspx_th_egui_005fintnl_005f7.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
      out.write("</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n");

	}
}
catch(Exception ex)
{
	System.out.println("Exception in MsSqlSysProcesses.jsp");
	ex.printStackTrace();
}

      out.write("</body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_egui_005fskin_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:skin
    com.egurkha.tags.Skin _jspx_th_egui_005fskin_005f0 = (com.egurkha.tags.Skin) _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.get(com.egurkha.tags.Skin.class);
    _jspx_th_egui_005fskin_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fskin_005f0.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(95,0) name = ui type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fskin_005f0.setUi("monitor");
    int _jspx_eval_egui_005fskin_005f0 = _jspx_th_egui_005fskin_005f0.doStartTag();
    if (_jspx_th_egui_005fskin_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f0 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f0.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(786,57) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f0.setText("monitor.layermodel.Measurement Time ");
    int _jspx_eval_egui_005fintnl_005f0 = _jspx_th_egui_005fintnl_005f0.doStartTag();
    if (_jspx_th_egui_005fintnl_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f1(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f1 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f1.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f1.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(806,57) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f1.setText("monitor.layermodel.Measurement");
    int _jspx_eval_egui_005fintnl_005f1 = _jspx_th_egui_005fintnl_005f1.doStartTag();
    if (_jspx_th_egui_005fintnl_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f3(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f3 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f3.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f3.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(828,57) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f3.setText("monitor.layermodel.Sort By");
    int _jspx_eval_egui_005fintnl_005f3 = _jspx_th_egui_005fintnl_005f3.doStartTag();
    if (_jspx_th_egui_005fintnl_005f3.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f5(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f5 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f5.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f5.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(871,86) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f5.setText("Process ID");
    int _jspx_eval_egui_005fintnl_005f5 = _jspx_th_egui_005fintnl_005f5.doStartTag();
    if (_jspx_th_egui_005fintnl_005f5.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f6(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f6 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f6.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f6.setParent(null);
    // /monitor/MsSqlSysProcesses.jsp(907,66) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f6.setText("No of Processes=");
    int _jspx_eval_egui_005fintnl_005f6 = _jspx_th_egui_005fintnl_005f6.doStartTag();
    if (_jspx_th_egui_005fintnl_005f6.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
    return false;
  }
}
