package org.apache.jsp.monitor;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.SidCheck;
import com.egurkha.*;
import com.egurkha.ini.*;
import java.util.*;
import java.util.*;
import egurkha.reporter.*;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.supermanager.*;
import com.eg.EgDateInfo;
import com.egurkha.EgTimeZoneConverter;
import java.util.TimeZone;
import java.util.Calendar;
import com.egurkha.util.DateUtil;
import egurkha.config.EcUtils;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgDbAdapterTypeUI;
import com.eg.EgDeletedAlarms;
import com.eg.EgTablesInfo;
import com.eg.IniFile;
import com.egurkha.*;
import com.egurkha.monitor.alarms.*;
import com.egurkha.util.*;
import egurkha.EgDbAdapterUI;
import egurkha.EgSettingsTimeStamp;
import java.io.*;
import java.sql.*;
import java.util.*;

public final class EgAlarms1_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	String blank = "&nbsp;";
	public String checkForNULL(String str)
	{
		if(str.equals("NULL"))
		{
			return "NONE";
		}
		else
		{
			return str;
		}
	}

	public String[] getSelectedAlarms(String result, String alarmSeparator)
	{
		if (result != null)
		{
			String[] alarms = null;
			StringTokenizer st;
			if (result.indexOf(alarmSeparator) != -1)
			{
				st = new StringTokenizer(result, alarmSeparator);
				int count = st.countTokens();
				alarms = new String[count];
				for (int a=0; a<count; a++)
				{
					alarms[a] = st.nextToken();
				}
			}
			else
			{
				alarms = new String[1];
				alarms[0] = result;
			}
			return alarms;
		}
		return null;
	}

	private String split (String string, int width)
	{
		String breakStr = "<br>&nbsp;&nbsp;";
		StringBuffer splitStr = new StringBuffer();

		int times = string.length()/width;
		int start = 0;
		for (int a=0; a<times; a++)
		{
			splitStr.append(string.substring(start, start+width));
			splitStr.append(blank);
			start += width;
			splitStr.append(breakStr);
		}

		splitStr.append(string.substring(width*times));
		return splitStr.toString();
	}



  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/monitor/EgLoginTracker.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbsM.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/**
 *	Displays alarms occurring currently, marked as critical/minor/warning/normal/unknown. Allows alarms to be 
 *	viewed based on the type - all/critical/critical & minor. Allows selected alarms to be deleted.
 *
 *	@author		Sandhya. K
 *	@created	09/05/2001
 *	@version	3.0
 *
 *	@modified	
 *		24-07-2001	Bala	Incorporate msmt_host virtual ip changes
 *		31-07-2001	kk		added a tstate param to the EgSiteInfraView query String.
 *		16-01-2002			check for New Fix in the code
 *		06-02-2003	Arun	Incorporate alarm deletion & filtering of priorities
 *		26-03-2003	Arun	Fixed the alarm deletion problem
 *		08-07-2003	Arun	Changed UserRegistry to use session ID instead of login ID
 *		08-09-2003	Arun	Changed description to show meaningful messages instead of measures
 *		19-09-2003	John	eG 3.0 Layout Modifications
 *		26-09-2003	John	Footer page included
 *		27-09-2003	Arun	Swapped Description and Service columns
 *		04-11-2003	Arun	Hide checkboxes and the DELETE button if alarm deletion is not allowed
 *		12-11-2003	Arun	Shows last measurement value if enabled in eg_services.ini
 *		19/11/2003	Arun	Removed usage of EgSessionCheck and fixed bug for displaying last measurement
 *					values (shown irrespective of the value set in eg_services.ini)
 *		20/12/2003	Arun	Fixed Alarm Refresh problem - null query string was set
 *		20/05/2004	Arun	Fixed bug that showed -1.0 for last measurement values
 *		07/07/2004	Arun	Uses configuration in eg_ui.ini to show alarms in a table 
 *							or when the mouse hovers over it.
 *		06-10-2004	Vijay - GUI Changes
 *		
 */


/*****************************************************************************************************
 *	Name			:	EgTrackerA.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		SmSessionData smsData = new SmSessionData(currentSession);
		EgThreadLocal egtl = new EgThreadLocal();
		egtl.set(smsData);
	}
	/* This is for SuperManager - ends */
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}

	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile reportIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection"); 
	String strYaxisBasedOnData = reportIni.getValue("CHART_TYPE","YaxisBasedOnData");
	boolean isYaxisBasedOnData=false;
	if(strYaxisBasedOnData!=null && (strYaxisBasedOnData.equalsIgnoreCase("yes") || strYaxisBasedOnData.equalsIgnoreCase("true")))
		isYaxisBasedOnData = true;

	if(!request.getRequestURI().endsWith("EgMonitorHome.jsp"))
	{

      out.write("<script>\n\t\t\tfunction openWindow(path,name,winOptions)\n\t\t\t{\n\t\t\t\tvar win;\n\t\t\t\tvar obj = window.parent;\n\t\t\t\tif(window==window.parent)\n\t\t\t\t\tobj =window.opener;\n\t\t\t\tif(obj.openWindow!=null)\n\t\t\t\t\twin = obj.openWindow(path,name,winOptions);\n\t\t\t\telse\n\t\t\t\t\twin= window.open(path,name,winOptions);\n\t\t\t\treturn win;\n\t\t\t}\n\t\t</script>\n");

	}

      out.write("<script>\n\n\t/** To Disable Right Click */\n\tvar message=\"\";\n\tfunction clickIE(){if(document.all){(message);return false;}}\n\tfunction clickNS(e){if(document.layers||(document.getElementById&&!document.all)){\n\tif(e.which==2||e.which==3){(message);return false;}}}\n\tif('");
      out.print(RightClikMode);
      out.write("'=='production')\n\t{\n\t\tif (document.layers){document.captureEvents(Event.MOUSEDOWN);document.onmousedown=clickNS;}\n\t\telse{document.onmouseup=clickNS;document.oncontextmenu=clickIE;}\n\t\tdocument.oncontextmenu=new Function(\"return false\")\n\t}\n\n\n\t/**  To disable drag and selection */\n\tvar alltables = document.getElementsByTagName(\"body\");\n\tif ('");
      out.print(SelectionMode);
      out.write("' == 'production') {\n\t\twindow.onload = function() {\n\t\t\tfunction disableSelection(element) {\n\t\t\t\telement.onselectstart = function() {\n\t\t\t\t\treturn false;\n\t\t\t\t};\n\t\t\t\telement.unselectable = \"on\";\n\t\t\t\telement.style.MozUserSelect = \"none\";\n\t\t\t\telement.style.cursor = \"default\";\n\t\t\t}\n\n\t\t\tfor (var i = 0; i < alltables.length; i++) {\n\n\t\t\t\tdisableSelection(alltables[i]); //disable text selection within all tables on the page\n\t\t\t}\n\n\t\t}\n\t}\n\n\tfunction callWindow(opt)\n\t{\n\t\tvar topWindow = window;\n\t\twhile(topWindow.parent!=topWindow ||  topWindow.opener!=null)\n\t\t{\n\t\t\tmainWindow = topWindow;\n\t\t\ttopWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);\n\t\t}\n\t\tif(topWindow.location.pathname!=\"/\")\n\t\t\tmainWindow=topWindow;\n\t\tmainWindow.location.href=\"/final/servlet/com.egurkha.Logout?errmsg=\"+opt;\n\t\tmainWindow.focus();\n\t}\n</script>\n\n");

	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	String productionMode = trackerUI.getValue("UI_MIGRATION","SenchaProductionMode");
	User u_ser = null;
	boolean id_u = false;
	String u_rs = null;
	String userLogos = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String monitor_Skin = "Light";
	boolean from_sm = false;
	String sessionId_sm = null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		sessionId_sm = (String)session.getAttribute("sessionId_SM");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sessionId_sm,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
		if(u_ser!=null)
		{

			id_u = u_ser.isIdDeletedWhileLoggedIn();
			if(id_u == false)
			{
				u_rs =  u_ser.getLoginID();
				userLogos = u_ser.getUserLogo();

				trackerUI.set_loginID(u_rs);
				trackerUI.set_userLogo(userLogos);

				if(!User.isDefaultUser(u_rs))
				{
					ErUserData er = u_ser.getReporterData();
					u_v_till = er.getUserValidtill();
					l_accessed = session.getLastAccessedTime();
				}
			}
		}
	}
	if(session == null || u_ser ==null)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(1);\n\t\t</script>\n");

			return;
	}
	else if(id_u== true)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\tcallWindow(2);\n\t\t</script>\n");

			return;
	}
	else if (u_v_till < l_accessed)
	{

      out.write("<script language=\"JavaScript\">\n\t\t\t\tcallWindow(3);\n\t\t\t</script>\n");

			return;
	}
	else
	{
		String smartValue=request.getParameter("smart");
		String site=request.getParameter("site");
		String servicename=request.getParameter("servicename");
		String page_help=request.getRequestURI();
		if((servicename==null || servicename.trim().length()==0) && (site==null || site.trim().length()==0))
		{
		if(smartValue==null || (smartValue!=null && smartValue.trim().length()==0))
		{
			if(!(page_help.endsWith("EgPrintGraph.jsp") || 
				page_help.endsWith("EgGraphData.jsp") || page_help.endsWith("trendData.jsp")||(page_help.indexOf("Egprintdata.jsp")>-1)))
			{
				session.setAttribute("Page_IdentifierM", request.getRequestURI());
				if(page_help!=null && page_help.endsWith("componentMeasureTabSet.jsp"))
				{
					session.setAttribute("Page_IdentifierMP", request.getRequestURI());
				}
			}
			}
		}
	}

	String timezoneOffsetValue ="";
	EgDateInfo tracker_tdateInfo = new EgDateInfo();
	TimeZone tracker_tz = null;
	if (u_ser!=null)
	{
		u_ser.setUserLanguageAndSkins();
		monitor_Skin  = u_ser.getMonitorSkin();
		String trackerUserLang = u_ser.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}

		Calendar cal = Calendar.getInstance();
		java.util.Date local_date = new java.util.Date(tracker_tdateInfo.egetUTCDate());
		cal.setTime(local_date);
		cal.setTimeZone(tracker_tdateInfo.getRealTimeZone());
		String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
		String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
		String trac_currentDateFormat = controlModeUIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",trac_currentDateFormat);
		EgTimeZoneConverter tracker_timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,u_ser);
		tracker_tz = tracker_timeZoneConverter.getTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));

		

		Calendar cal3 = GregorianCalendar.getInstance(tracker_tz);
		int offsetInMillis = tracker_tz.getOffset(cal3.getTimeInMillis());
		int offsetmin = 0;
		if(offsetInMillis<0)
			offsetmin =(Math.abs(offsetInMillis)/1000)/60;
		else
			offsetmin = (offsetInMillis/1000)/60;
		String offset = String.valueOf(offsetmin);
		
		//if(offsetInMillis>0)
		//{
			if(tracker_tz.getRawOffset()>=0)
				timezoneOffsetValue="-"+offset;
			else
				timezoneOffsetValue="+"+offset;
		//}
		//else
			//timezoneOffsetValue = (offsetInMillis >= 0 ? "+" : "-") + offset;
	}
	else
	{
		tracker_tz = tracker_tdateInfo.getRealTimeZone();

		long timezoneinMins = (Math.abs((tracker_tz.getRawOffset() / (60 * 1000))));
		long daylighttime = (tracker_tz.getDSTSavings() / (60 * 1000));
		timezoneOffsetValue = String.valueOf(Math.abs(timezoneinMins-daylighttime));
		
		if(tracker_tz.getRawOffset()>=0)
			timezoneOffsetValue="-"+timezoneOffsetValue;
		else
			timezoneOffsetValue="+"+timezoneOffsetValue;
	}

		String  script_src="script_item_"+trackerLanguage+".js";
		String uiFileTemp = "eg_ui.ini";
		String s_iniFile_dir_temp = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUIIni = new IniFile(s_iniFile_dir_temp + uiFileTemp);
		
		EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);

		//Variable to be used in javascript code
		String currentDateFormatForJS = egUIIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String mgrDateFormat = currentDateFormatForJS;
		String dateFormatNew = mgrDateFormat;
		if(currentDateFormatForJS.indexOf("MMM") >= 0)
		{
			for(int i=0; i < currentDateFormatForJS.length();i++)
			{
				if(String.valueOf(currentDateFormatForJS.charAt(i)).equals("M"))
				{
					currentDateFormatForJS = currentDateFormatForJS.replace('M','N');
				}
			}
		}

		String dateFormatForDatePicker=(String)u_ser.getUserDateFormat();
		if(dateFormatForDatePicker!=null && (dateFormatForDatePicker.equalsIgnoreCase("default") || com.egurkha.util.StringUtils.isNull(dateFormatForDatePicker)))
		{
			dateFormatForDatePicker = mgrDateFormat;
		}
		IniUI egui_temp = IniUI.getInstance();
		String  strer_modeInTracker="2D";
		

      out.write("<script>\n\tvar strSkin='");
      out.print(monitor_Skin);
      out.write("';\n\tvar isYaxisBasedOnData=");
      out.print(isYaxisBasedOnData);
      out.write(";\n\tvar netRow = ( strSkin == 'Light' )?'netRow loaded':'darkRow loaded';\n\tvar pageListRow = ( strSkin == 'Light' )?'pageRow':'darkPageRow';\n\tvar netCol = ( strSkin == 'Light' )?'netCol':'darkNetCol';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netSummaryRow':'darkNetSummaryRow';\n\tvar netSummaryRow = ( strSkin == 'Light' )?'netRow tabView':'darkNetRow darkTabView';\n\tvar netFullHrefLabel = ( strSkin == 'Light' )?'netFullHrefLabel':'netFullHrefLabel';\n\tvar er_modeInTracker='");
      out.print(strer_modeInTracker);
      out.write("'\n\tvar dateFormatForTimeline = '");
      out.print(dateFormatNew);
      out.write("';\n\tvar settings='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Settings"));
      out.write("';\n\tvar toolData='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Data"));
      out.write("';\n\tvar toolCSV='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.CSV"));
      out.write("';\n\tvar toolSave ='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.SAVE"));
      out.write("';\n\tvar toolMail='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.MAIL"));
      out.write("';\n\tvar toolPrint='");
      out.print(trackerMappingInfo.getTextDescription("reporter.common.PRINT"));
      out.write("';\n\tvar timelineLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Timeline"));
      out.write("';\n\tvar hrLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Hr"));
      out.write("';\n\tvar minLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.Min"));
      out.write("';\n\tvar Tolbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.common.To"));
      out.write("';\n\tvar fromLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.history.From"));
      out.write("';\n\tvar graphLbl='");
      out.print(trackerMappingInfo.getTextDescription("monitor.summary.Graph"));
      out.write("';\n\n\t// For Highcharts - UTC - timezoneOffset\n\tvar timeZoneOffsetVal='");
      out.print(timezoneOffsetValue);
      out.write("';\n\t//-----end-----\n\tdocument.onkeydown = fkey;\n\nfunction fkey(e){\n  e = e || window.event;\n\t  if (e.which == 116 || (e.keyCode == 82 && e.ctrlKey)) { //116 = F5\n\t\t\ttry\n\t\t\t{\n\t\t\t\twindow.parent.refreshEgIndexPage();\t\n\t\t\t}\n\t\t\tcatch (e)\n\t\t\t{\n\t\t\t\ttry{\n\t\t\t\t\twindow.parent.parent.refreshEgIndexPage();\t\n\t\t\t\t}\n\t\t\t\tcatch (e)\n\t\t\t\t{\n\t\t\t\t\twindow.opener.refreshEgIndexPage();\n\t\t\t\t}\n\t\t\t}\n\t return false;\n\t\t\n\t}\n }\n\n</script>\n\n\n\n\n\n\n\n\n\n");

	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgAlarms");

	String[] options = {"All", 
	ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY)+" & "+ ui.getStateDisplayLabel(AlarmPriorities.MEDIUM_PRIORITY), ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY)};
	int[] priorities = {10, 2, 1};
	String[] colrs = {"r","o","p"};
	StringBuffer metaRefreshUrl = new StringBuffer(64);
	metaRefreshUrl.append("EgAlarms1.jsp");
	String queryString = request.getQueryString();
	if (queryString != null)
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}

	boolean isInMainWin = "true".equalsIgnoreCase(request.getParameter("dispAtMainWin"));
	String s_topLeftImg= "TopLeft.gif";
	String s_topRightImg = "TopRight.gif";
	String s_topLeft2Img= "TopLeft2.gif";
	String s_topRight2Img = "TopRight2.gif";
	String s_sideLeftbg= "SideLeftBg.gif";
	String s_sideRightbg = "SideRightBg.gif";
	String s_dashbotLeft1= "DashBotLeft1.gif";
	String s_dashbotRight1 = "DashBotRight1.gif";
	if(isInMainWin)
	{
		s_topLeftImg= "TopLeftmain.gif";
		s_topRightImg = "TopRightmain.gif";
		s_topLeft2Img= "TopLeft2main.gif";
		s_topRight2Img = "TopRight2main.gif";
		s_sideLeftbg= "SideLeftBgmain.gif";
		s_sideRightbg = "SideRightBgmain.gif";
		s_dashbotLeft1= "DashBotLeft1main.gif";
		s_dashbotRight1 = "DashBotRight1main.gif";
	}

      out.write("<html>\n<head>\n<title> &nbsp; Alarms &nbsp; - &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>\n<meta name=\"Author\" content=\"John Williams\" />\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n<meta http-equiv=\"refresh\" content=\"");
      out.print(refreshTime.trim());
      out.write(";url=");
      out.print(metaRefreshUrl.toString());
      out.write("\">\n<link rel=\"stylesheet\" href=\"eg_styles/eg_monitorstyle.css\" />\n<script language=\"javascript\">\nn = (document.layers) ? 1:0\nie = (document.all) ? 1:0\n\nfunction show(step)\n{\n\tvar layername=\"layer\"+step;\n\tif(n) document.layers[layername].visibility = \"show\";\n\tif(ie) document.all[layername].style.visibility = \"visible\"\n}\n\nfunction hide(step)\n{\n\tvar layername=\"layer\"+step;\n\tif(n) document.layers[layername].visibility = \"hide\"\n\tif(ie) document.all[layername].style.visibility = \"hidden\"\n}\n</script>\n<script language=\"javascript\">\nisIE=document.all?true:false;\nvar isNS4=document.layers?true:false; \nvar isNS6=navigator.userAgent.indexOf(\"Gecko\")!=-1?true:false;\nvar eg_bC=new Array('#FFFFFF','#E6E6E6');\nvar eg_C=new Array('#000000','#000000');\n\nvar alarmSelectCount = 0;\n\n\nfunction onSelectAlarmType()\n{\n\tif (document.eGAlarms.deletealarms.selectedIndex != -1)\n\t{\n\t\tdocument.eGAlarms.submit();\n\t}\n}\n\nfunction eg_colorchange(_v)\n{\n\tvar eg_X=eval(\"document.eGAlarms.eg_deletebox\"+_v+\".checked?0:1\");\n\n\tif(isIE)\n\t{\n\t\teval(\"eg_tr\"+_v+\".style.backgroundColor=eg_bC[eg_X]\");\n");
      out.write("\t\teval(\"eg_tr\"+_v+\".style.color=eg_C[eg_X]\");\n\t}\n\tif(isNS6)\n\t{\n\t\tdocument.getElementById(\"eg_tr\"+_v).style.backgroundColor=eg_bC[X];\n\t\tdocument.getElementById(\"eg_tr\"+_v).style.color=eg_C[eg_X];\n\t}\n\n\tif (eg_X == 0)\n\t{//Alarm selected\n\t\talarmSelectCount++;\n\t}\n\telse\n\t{//Alarm deselected\n\t\talarmSelectCount--;\n\t}\n}\n</script>\n<style>\n\t#alarmborder{border:1px #ffffff }\n\t#alarmborder td {border:1px #ffffff solid}\n\ta.alarm:link {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}\n\ta.alarm:active {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}\n\ta.alarm:visited {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}\n\ta.alarm:hover {text-decoration: underline;color:#000000}\n\t.alarm{text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}\n\t\n</style>\n</head>\n<body leftmargin=\"5\" topmargin=\"5\" marginheight=\"5\" marginwidth=\"5\" bgcolor=\"#FFFFFF\">\n<form name=\"eGAlarms\" method=\"GET\" action=\"/final/monitor/EgAlarms1.jsp\">\n");
      out.write("<input type=\"hidden\" name=\"delAlarmIDs\" value=\"");
      out.print(System.currentTimeMillis());
      out.write('"');
      out.write('>');
      out.write('\n');

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	//If alarms were selected for deletion, do them here
	String result = request.getParameter("delAlarmIDs");
	String[] alarms = this.getSelectedAlarms(result, "#");
	if (alarms != null)
	{
		StringTokenizer st;
		EgDeletedAlarms eda = new EgDeletedAlarms();
		boolean alarmsDeleted = false;
		for (int a=0; a<alarms.length; a++)
		{
			st = new StringTokenizer(alarms[a], "@");

			if (st.countTokens() == 4)
			{
				String cName = st.nextToken();
				String cType = st.nextToken();
				String layer = st.nextToken();
				
				//Now comes the problem, in ways more than one
				String problem = st.nextToken();
				StringTokenizer commaTokenizer = new StringTokenizer(problem, ",");
				int commaCount = commaTokenizer.countTokens();
				for (int b=0; b<commaCount; b++)
				{
					//Now take out the pipes
					StringTokenizer pipeTokenizer = new StringTokenizer(commaTokenizer.nextToken(), "|");
					int pipeCount = pipeTokenizer.countTokens();
					String[] columns = new String[pipeCount];
					for (int c=0; c<pipeCount; c++)
					{
						columns[c] = pipeTokenizer.nextToken();
					}

					String mHost = columns[columns.length-1]; // or pipeCount - 1
					String site = columns[0];
					String desc = columns[1];
					String test = columns[2];
					String measure = columns[3];

					eda.addToDeletedAlarms(mHost, cName+desc, cType, site, layer, test, measure);
					if (!alarmsDeleted)
					{
						alarmsDeleted = true;
					}
				}
			}
		}
		//---Run a loop here to see if the file has been modified after the above loop
		if (alarmsDeleted)
		{
			while (!eda.isDeletionComplete())
			{
				try 
				{
					Thread.sleep(500);
				}
				catch(InterruptedException ie)
				{
					//session.putValue("ErrorMsg", ie.toString());
					throw (ie);
				}
			}
		}
	}
	int selectedPriority = 0;



      out.write("<table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" height=\"100%\" border=\"0\">\n\t<tr>\n\t\t<td width=\"100%\" valign=\"bottom\" align=\"left\" height=\"32\">\n\t\t\t<table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" height=\"32\" border=\"0\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td width=\"36\" height=\"32\" nowrap><img src=\"eg_images/eg_layout/eg_window/");
      out.print(s_topLeftImg);
      out.write("\" width=\"36\" height=\"32\" border=\"0\" /></td>\n\t\t\t\t\t<th width=\"100%\" id=\"eg_whitecontent\" background=\"eg_images/eg_layout/eg_window/TopBg.gif\" align=\"left\">Alarms</th>\n\t\t\t\t\t<th id=\"eg_calth\" nowrap=\"nowrap\" background=\"eg_images/eg_layout/eg_window/TopBg.gif\" align=\"left\">&nbsp;Show :&nbsp;</th>\n\t\t\t\t\t<td nowrap background=\"eg_images/eg_layout/eg_window/TopBg.gif\" align=\"left\">\n\t\t\t\t\t\t<select name=\"deletealarms\" onChange=\"onSelectAlarmType()\">\n");

	String selectedOption = request.getParameter("deletealarms");
	if (selectedOption == null)
	{
		selectedOption = options[0];
	}
	else
	{
		for (int a=0; a<options.length; a++)
		{
			if (selectedOption.equals(options[a]))
			{
				selectedPriority = a;
				break;
			}
		}
	}

	out.println(HtmlUtils.setSelectOptions(options, selectedOption));

      out.write("</select>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td width=\"36\" height=\"32\" nowrap><img src=\"eg_images/eg_layout/eg_window/");
      out.print(s_topRightImg);
      out.write("\" width=\"36\" height=\"32\" border=\"0\" /></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<!--FIRST ROW ENDS HERE-->\n\t</tr>\n\t<tr>\n\t\t<td width=\"100%\" valign=\"bottom\" align=\"left\" height=\"100%\">\t\t\t\t\t\t\t\t\t\t<!--SECOND ROW STARTS HERE-->\n\t\t\t<table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" height=\"100%\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td rowspan=\"2\" width=\"17\" nowrap id=\"eg_blankspace\" background=\"eg_images/eg_layout/eg_window/SideLeftBg.gif\" valign=\"top\">\n\t\t\t\t\t\t<img src=\"eg_images/eg_layout/eg_window/TopLeft2.gif\" height=\"24\" border=\"0\" />\n\t\t\t\t\t</td>\n\t\t\t\t\t<td rowspan=\"2\" width=\"100%\" id=\"eg_cellbglight\" valign=\"top\" height=\"100%\" align=\"center\"><br>\n");

	//Local Variable declarations
	Hashtable ht = null;
	HashMap testKey = null; 
	String status="";
	String strName="";
	String strType="";
	String strLayer="";
	String strTime="";
	String strPriority="";
	String str_sql="";
	String strSite="";
	String strTest="";
	String strMeasure="";
	String strProblem="";
	String strproblem_desc="";
	Vector v_alarms = new Vector();
	String strtok="";
	String str_site = "";
	String str_test = "";

	//one of the new strings for vips
	String str_u_comp = "";
	Statement st=null;
	ResultSet rs=null;
	boolean b_state = false;
	boolean b_recordspresent = false;

	/*
	 * Increment values used for alarms DIV display. 
	 * DO NOT CHANGE IT UNLESS YOU KNOW WHAT YOU ARE DOING.
	 */
	int inc=122;

	int j;
	int k;
	int noalarms = 0;
	Vector v_ph,v_pi,v_pl;
	Vector v_h = new Vector();
	Vector v_i = new Vector();
	Vector v_l = new Vector();

	/*
	 * For showing last measurement value 
	 */
	boolean showLastMeasurementValue = false;
	IniFile servicesIni = new IniFile(new EgConfigInfo(EgConstants.MANAGER).getServicesFile());
	String mailLastValueStr = servicesIni.getValue("MISC_ARGS", "MailLastValue");
	showLastMeasurementValue = (mailLastValueStr != null) && ((mailLastValueStr.equalsIgnoreCase("yes")) || (mailLastValueStr.equalsIgnoreCase("yes")));

	
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	List siteNames = new LinkedList();
	siteNames.addAll(user.getSites());
	siteNames.addAll(user.getServices());

	boolean isDeleteAllowed = ui.isDeleteAlarmsEnabled(user.getLoginID());

	Vector v_user_comp = new Vector();
	v_user_comp.addAll(user.getServers(false));

	Vector v_user_comp_notype = new Vector();
	Map tests = null;
	if (!user.isSuperMonitor())
		tests = user.getTests();
		
	for(int x=0;x < v_user_comp.size();x++)
	{
		String s_tmp = (String)v_user_comp.elementAt(x);
		s_tmp = s_tmp.substring(s_tmp.indexOf(":") + 1);
		s_tmp = s_tmp.substring(0,s_tmp.indexOf(":"));
		s_tmp = s_tmp + ":NULL";
		v_user_comp_notype.add(s_tmp);
	}
	EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
	status=egDb.setConnection();
	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			String str_user_comp = null;
			String str_tmpcomp = null;
			String str_u_comp_type = null;
			
			StringBuffer sb = new StringBuffer(128);
			v_alarms.clear();

			rs = egDb.SelectAlarms();
			b_state=egDb.getState();
			while(rs.next())
			{
				sb = new StringBuffer(128);
				str_u_comp = rs.getString("COMP_NAME");
				str_u_comp_type = rs.getString("COMP_TYPE");
				str_user_comp = str_u_comp_type + ":" + str_u_comp;
				
				boolean bf = false;
				if(str_user_comp.startsWith("Host_system"))
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp,"/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp_notype.contains(str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp_notype.contains(str_u_comp))
					{
						bf = true;
					}
				}
				else
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp, "/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp.contains(str_u_comp_type + ":" + str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp.contains(str_user_comp))
					{
						bf = true;
					}
				}
				if(bf)
				{
					String prob_desc = rs.getString("PROBLEM_DESC");
					boolean pd_flag = false;
					boolean isSuperMonitor = user.isSuperMonitor();
					if (user.isSuperMonitor())
						pd_flag = true;
					StringTokenizer st_tmp = new StringTokenizer(prob_desc, ",");
					prob_desc = "";
					str_site = "";
					str_test = "";
					StringTokenizer st_ftmp = null;
					int i_ctr;
					int i_tokens = st_tmp.countTokens();
					for(i_ctr=0;i_ctr < i_tokens; i_ctr++)
					{
						String tmp_sitestr = st_tmp.nextToken();
						if (isSuperMonitor)
						{
							prob_desc += ","+tmp_sitestr;
							continue;
						}
						st_ftmp = new StringTokenizer(tmp_sitestr,"|");
						str_site = st_ftmp.nextToken();
						String inf = st_ftmp.nextToken();
						String test = st_ftmp.nextToken();
						if(siteNames.contains(str_site) || str_site.equals("NULL"))
						{
							if (tests != null &&
								tests.containsKey(test))
							{
								prob_desc += "," + tmp_sitestr;
								pd_flag = true;
							}
						}
					}
					
					if(pd_flag)
					{
						b_recordspresent=true;
						v_alarms.add(str_u_comp);
						v_alarms.add(str_u_comp_type);
						v_alarms.add(rs.getString("LAYER_NAME"));
						v_alarms.add(rs.getString("MS_TIME"));
						v_alarms.add(rs.getString("PRIORITY"));
						v_alarms.add(prob_desc.substring(1,prob_desc.length()));
						v_alarms.add(rs.getString("ALARM_ID"));
						
					}
				}
			}
			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception bug123)
				{
				}
			}
			if(b_recordspresent==false)
			{
				noalarms = 1;
			}

			b_recordspresent=false;
		}
		egDb.releaseConnection(false);
	}
	catch(Exception e)
	{
		String s_errmsg = "";
		if(!status.equals("CONNECTED"))
		{
			s_errmsg = "Could not establish connection with the database";
		}
		else if(b_state == false)
		{
			s_errmsg = "Error in query due to invalid connection";
		}
		else
		{
			s_errmsg = e.toString();
		}
		if (rs != null)
		{
			try
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ec)
		{
		}
		s_errmsg = "EgProbsM.jsp?msg=" + s_errmsg;

      if (true) {
        _jspx_page_context.forward(s_errmsg);
        return;
      }

		return;
	}
	
	EgDbAdapterTypeUI.releaseObject(egDb);

      out.write("<table  id=\"alarmborder\" cellspacing=\"0\" cellpadding=\"2\" align=\"center\" width=\"100%\" height=\"19\" border=\"0\">\n");

	if (noalarms != 1)
	{

      out.write("<tr>\n\t\t\t\t\t\t\t\t<td valign=\"middle\" nowrap width=\"2%\" height=\"19\" id=\"eg_alarmlayerhead\" align=\"center\">&nbsp;</td>\n\t\t\t\t\t\t\t\t<td valign=\"middle\" class=\"submenu\" nowrap width=\"15%\" height=\"19\" id=\"eg_alarmlayerhead\" align=\"center\">START TIME </td>\n\t\t\t\t\t\t\t\t<td align=\"center\" width=\"20%\" height=\"19\" id=\"eg_alarmlayerhead\" > COMPONENT </td>\n\t\t\t\t\t\t\t\t<td id=\"eg_alarmlayerhead\" width=\"23%\" align=\"center\">COMP TYPE</td>\n\t\t\t\t\t\t\t\t<td valign=\"middle\" nowrap width=\"40%\" height=\"19\" id=\"eg_alarmlayerhead\" align=\"center\"> DESCRIPTION </td>\n\t\t\t\t\t\t\t</tr>\n");

	}
	else
	{

      out.write("<tr>\n\t\t\t\t\t\t\t\t<td align=\"center\" height=\"323\" id=\"eg_errorbig\"><img src=\"eg_images/eg_layout/eg_error.gif\" width=\"150\" height=\"150\" align=\"center\" border=\"0\" vspace=\"10\" /><br>No alarms found</td>\n\t\t\t\t\t\t\t</tr>\n");


	}

	ht = (Hashtable) session.getAttribute("alarm_vects");
	if( ht != null)
	{
		v_ph = (Vector)ht.get("high");
		v_pi = (Vector)ht.get("inter");
		v_pl = (Vector)ht.get("low");
	}
	else
	{
		v_ph = new Vector();
		v_pi = new Vector();
		v_pl = new Vector();
	}

	k=0;

	DateTimeTokenizer dtt = new DateTimeTokenizer();
	dtt.setDateFormat(DateTimeTokenizer.MDY);
	dtt.setTimeFormat(DateTimeTokenizer.HMS);
	dtt.setYearAsYY(true);

	List forDivTag = new LinkedList();
	egDb = EgDbAdapterTypeUI.getObject();
	status=egDb.setConnection();

	EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);

	for(int v_ctr=0; v_ctr < v_alarms.size(); v_ctr=v_ctr + 7)
	{
		strName=(String) v_alarms.elementAt(v_ctr);
		strType=(String) v_alarms.elementAt(v_ctr + 1);
		strLayer=(String) v_alarms.elementAt(v_ctr + 2);
		//strTime=(String) v_alarms.elementAt(v_ctr + 3);
		dtt.setStartDateTime((String) v_alarms.elementAt(v_ctr + 3));
		strTime = dtt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR) + DateTimeTokenizer.BLANK_SPACE + dtt.getStartTimeAsFormat(DateTimeTokenizer.HM,DateTimeTokenizer.COLON_SEPARATOR);
		strPriority = (String) v_alarms.elementAt(v_ctr + 4);
		
		int priority = priorities[0];//At the moment equals 10
		String colr = colrs[0];
		if(strPriority.equalsIgnoreCase(AlarmPriorities.HIGH_PRIORITY))
		{
			priority = 2;
			colr = "r" ;
			v_h.add(v_alarms.elementAt(v_ctr+6));
		}
		else if(strPriority.equalsIgnoreCase(AlarmPriorities.MEDIUM_PRIORITY))
		{
			priority = 1;
			colr = "o" ;
			v_i.add(v_alarms.elementAt(v_ctr+6));
		}
		else
		{
			priority = 0;
			colr = "p" ;
			v_l.add(v_alarms.elementAt(v_ctr+6));
		}
		if (priority >= selectedPriority)
		{
			String[] compNameTokens = StringUtils.getTokens(strName, "/");
			str_u_comp = compNameTokens[0];

			strProblem = (String) v_alarms.elementAt(v_ctr + 5);
			StringTokenizer sta = new StringTokenizer(strProblem, ",");
			int index = -1;
			String mHost = null;
			int tokensCount = sta.countTokens();
			List row = new LinkedList();
			testKey = new HashMap();
			while (sta.hasMoreTokens())
			{
				String problemDesc = sta.nextToken();
				StringTokenizer st_ftmp = new StringTokenizer(problemDesc ,"|");
				str_site =st_ftmp.nextToken();
				String inf = st_ftmp.nextToken();
				String test = st_ftmp.nextToken();
				str_test = test + "-" + inf;
				String measure = st_ftmp.nextToken();

				if((!siteNames.contains(str_site)) && (!str_site.equals("NULL")))
				{
					continue;
				}

				String[] values;
				if (showLastMeasurementValue)
				{
					values = new String[6];
				}
				else
				{
					values = new String[5];
				}	

				values[0] = test;
				values[1] = measure;
				values[2] = str_site;
				values[3] = inf;
				String inf1 = " ";
				String inf11 = " ";
				String info = values[3].substring(1,values[3].length());
				StringBuffer str_inf = new StringBuffer();
				str_inf.append(values[0]);
				str_inf.append(":");
				str_inf.append(values[1]);
				StringBuffer sb =(StringBuffer) testKey.get(str_inf.toString());
				if (sb!=null)
				{
					if ((", " + sb.toString() + ",").indexOf(", " + info + ",") ==-1)
					{
						sb.append(", ");
						sb.append(info);
					}
					testKey.put(str_inf.toString(),sb);
					//inf11 = (String)testKey.get(str_inf.toString());
				}
				else
				{
					sb = new StringBuffer(info);
					testKey.put(str_inf.toString(),sb);
					//inf1 = (String)testKey.get(str_inf.toString());
				}
				
				values[4] = st_ftmp.nextToken();
				/*
				 * For clubbed alarms, the DispLayers page shows information for
				 * the first component. So use the measurement host of the first
				 * component only.
				 */
				if (mHost == null)
				{
					mHost = values[4];
				}


			}




			String displayString = StringUtils.replace(strName,":NULL"," ");
			//System.out.println("displayString : " + displayString);
/*			if (strName.length() > 50)
			{
				displayString = StringUtils.elipsis(strName, 50);
			}
*/			


					Iterator itr = testKey.keySet().iterator();
					while (itr.hasNext()) 
					{
						String s = (String) itr.next();

						String inn =  testKey.get(s).toString();
						StringTokenizer st_test = new StringTokenizer(s ,":");
						String tst = st_test.nextToken();
						String DispString = split(displayString,20);

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"2%\" nowrap align=\"center\" valign=\"middle\" >\n\t\t\t\t\t\t\t\t\t\t\t\t<a class=\"alarm\" href=\"EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=");
      out.print(str_u_comp);
      out.write("&layer=");
      out.print(strLayer);
      out.write("&site=");
      out.print(str_site);
      out.write("&test=");
      out.print(str_test);
      out.write("&comptype=");
      out.print(strType);
      out.write("&tstate=");
      out.print(strPriority);
      out.write("&msmt_host=");
      out.print(mHost);
      out.write("\" target=\"eg_operations\"\n\t\t\t\t\t\t\t\t\t\t\t\t><img src=\"/final/reporter/images/");
      out.print(colr);
      out.write("circle.gif\" border=\"0\"></a></td>\n\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" id=\"eg_cellbglits\" width=\"15%\" nowrap><a  class=\"alarm\" href=\"EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=");
      out.print(str_u_comp);
      out.write("&layer=");
      out.print(strLayer);
      out.write("&site=");
      out.print(str_site);
      out.write("&test=");
      out.print(str_test);
      out.write("&comptype=");
      out.print(strType);
      out.write("&tstate=");
      out.print(strPriority);
      out.write("&msmt_host=");
      out.print(mHost);
      out.write("\" target=\"eg_operations\" \n\t\t\t\t\t\t\t\t\t\t\t\tid=\"eg_alarmlink\">");
      out.print(strTime);
      out.write("</a></td>\n\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"left\" id=\"eg_cellbglits\" width=\"20%\">&nbsp;<a class=\"alarm\" href=\"EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=");
      out.print(str_u_comp);
      out.write("&layer=");
      out.print(strLayer);
      out.write("&site=");
      out.print(str_site);
      out.write("&test=");
      out.print(str_test);
      out.write("&comptype=");
      out.print(strType);
      out.write("&tstate=");
      out.print(strPriority);
      out.write("&msmt_host=");
      out.print(mHost);
      out.write("\" target=\"eg_operations\" \n\t\t\t\t\t\t\t\t\t\t\t\tid=\"eg_alarmlink\">");
      out.print(DispString);
      out.write("</a></td>\n\n\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"eg_cellbglits\"  width=\"23%\" nowrap align=\"center\" valign=\"middle\" >\n\t\t\t\t\t\t\t\t\t\t\t\t<a class=\"alarm\"  href=\"EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=");
      out.print(str_u_comp);
      out.write("&layer=");
      out.print(strLayer);
      out.write("&site=");
      out.print(str_site);
      out.write("&test=");
      out.print(str_test);
      out.write("&comptype=");
      out.print(strType);
      out.write("&tstate=");
      out.print(strPriority);
      out.write("&msmt_host=");
      out.print(mHost);
      out.write("\" target=\"eg_operations\" id=\"eg_alarmlink\"\n\t\t\t\t\t\t\t\t\t\t\t\t>");
      out.print(strType);
      out.write("</a></td>        \n\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"eg_cellbglits\" nowrap class=\"alarm\" width=\"40%\" >&nbsp;\n\t\t\t\t\t\t\t\t\t\t\t");

											if(inn.trim().length() > 0)inn="<b>" +inn +"</b>";	
      out.print(split(tablesInfo.getMeasureAlert(s,inn),50)	);
      out.write(" &nbsp;</td> \t\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\n");

		}	//**end of while loop**


		}
	}

      out.write("</table>\n\n");

	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			egDb.releaseConnection(false);
		}
	}
	catch(Exception e)
	{
		egDb.releaseConnection(true);
	}
	EgDbAdapterTypeUI.releaseObject(egDb);


      out.write("</td>\n\t\t\t\t\n\t\t\t\t<td width=\"17\" nowrap id=\"eg_blankspace\" background=\"eg_images/eg_layout/eg_window/SideRightBg.gif\" valign=\"top\"><img src=\"eg_images/eg_layout/eg_window/TopRight2.gif\" width=\"17\" height=\"24\" border=\"0\" /></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td width=\"17\" nowrap id=\"eg_blankspace\" background=\"eg_images/eg_layout/eg_window/SideRightBg.gif\" valign=\"bottom\" align=\"right\">\n\t\t\t\t\t<img src=\"eg_images/eg_layout/eg_window/BottomRight3.gif\" width=\"17\t\" height=\"24\" border=\"0\" hspace=\"0\" align=\"right\"/>\n\t\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</td>\n\t\t<!--SECOND ROW ENDS HERE-->\n\t</tr>\n\t<tr>\n\t\t<td width=\"100%\" height=\"34\" valign=\"top\" align=\"right\">\n\t\t<!--THIRD ROW STARTS HERE-->\n\n\t\t\t<table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" height=\"34\" border=\"0\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t<td width=\"36\" height=\"34\" nowrap><img src=\"eg_images/eg_layout/eg_window/BottomLeft.gif\" width=\"36\" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"100%\" align=\"center\" background=\"eg_images/eg_layout/eg_window/BottomBgLeft.gif\">");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "EgFooter.jsp", out, true);
      out.write("</td>\n\t\t\t\t\t<td width=\"70\" height=\"34\"><img src=\"eg_images/eg_layout/eg_window/BottomCurve.gif\" width=\"70\" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"60\" nowrap height=\"34\" background=\"eg_images/eg_layout/eg_window/BottomBgRight.gif\"><img src=\"eg_images/eg_layout/eg_window/HIGH.gif\" width=\"46\" alt=\"  ");
      out.print(ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY));
      out.write("  \" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"60\" nowrap height=\"34\" background=\"eg_images/eg_layout/eg_window/BottomBgRight.gif\"><img src=\"eg_images/eg_layout/eg_window/INTERMEDIATE.gif\" width=\"46\" alt=\"  ");
      out.print(ui.getStateDisplayLabel(AlarmPriorities.MEDIUM_PRIORITY));
      out.write("  \" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"60\" nowrap height=\"34\" background=\"eg_images/eg_layout/eg_window/BottomBgRight.gif\"><img src=\"eg_images/eg_layout/eg_window/LOW.gif\" width=\"46\" alt=\"  ");
      out.print(ui.getStateDisplayLabel(AlarmPriorities.LOW_PRIORITY));
      out.write("  \" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"60\" nowrap height=\"34\" background=\"eg_images/eg_layout/eg_window/BottomBgRight.gif\"><img src=\"eg_images/eg_layout/eg_window/UNKNOWN.gif\" width=\"46\" alt=\"  ");
      out.print(ui.getStateDisplayLabel(AlarmPriorities.UNKNOWN_STATE));
      out.write("  \" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"46\" height=\"34\" background=\"eg_images/eg_layout/eg_window/BottomBgRight.gif\"><img src=\"eg_images/eg_layout/eg_window/GOOD.gif\" width=\"46\" alt=\"  ");
      out.print(ui.getStateDisplayLabel(AlarmPriorities.GOOD_STATE));
      out.write("  \" height=\"34\" border=\"0\"></td>\n\t\t\t\t\t<td width=\"36\" height=\"34\" nowrap><img src=\"eg_images/eg_layout/eg_window/BottomRight.gif\" width=\"38\" height=\"34\" border=\"0\"></td>\n\t\t\t\t</tr>\n\t\t\t</table>\t\n\t\t</td>\n\t\t<!--THIRD ROW STARTS HERE-->\n\t</tr>\n</table>\n<!----- MAIN TABLE ENDS HERE ----->\n\n");

	v_alarms.clear();

	inc=0;
	String s_high_wav = "eg_waves/high.wav";
	String s_inter_wav = "eg_waves/medium.wav";
	String s_low_wav = "eg_waves/low.wav";
	if(v_h.size() > 0 || v_i.size() > 0 || v_l.size() > 0)
	{
		if(v_h.size() > v_ph.size())
		{
			out.println("<bgsound src='" + s_high_wav + "' loop='1'>");
		}
		else if(! v_h.equals(v_ph) && v_h.size() > 0)
		{
			out.println("<bgsound src='" + s_high_wav + "' loop='1'>");
		}
		else if(v_i.size() > v_pi.size())
		{
			out.println("<bgsound src='" + s_inter_wav + "' loop='1'>");
		}
		else if(! v_i.equals(v_pi) && v_i.size() > 0)
		{
			out.println("<bgsound src='" + s_inter_wav + "' loop='1'>");
		}
		else if(v_l.size() > v_pl.size())
		{
			out.println("<bgsound src='" + s_low_wav + "' loop='1'>");
		}
		else if(!v_l.equals(v_pl) && v_l.size() > 0)
		{
			out.println("<bgsound src='" + s_low_wav + "' loop='1'>");
		}
	}

	ht = new Hashtable();
	ht.put("high",v_h);
	ht.put("inter",v_i);
	ht.put("low",v_l);
	session.setAttribute("alarm_vects", ht);


      out.write("</form>\n</body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
