package org.apache.jsp.config;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.eg.EgConfigTestsInfo;
import com.eg.EgConfigConstants;
import egurkha.config.EcProcessChangeData;
import egurkha.config.EcPrintData;
import egurkha.config.EcUserData;
import java.util.*;
import java.text.*;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.egurkha.util.DateUtil;
import com.egurkha.User;
import com.egurkha.UserRegistry;
import com.egurkha.ini.IniUI;
import com.eg.EgMappingInfo;
import egurkha.config.EcUtils;
import com.eg.EgDbInfo;
import com.egurkha.util.StringUtils;
import com.eg.EgURLEncoder;
import com.egurkha.EgTimeZoneConverter;

public final class EcPrintDataReport_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	String[] userOptions = {"Component Name","Component Type","All Components"};

	String[] criterias = {"Zone","Service","Segment","Component"};

	public String decodeString(String s)
	{
		StringBuffer sb = new StringBuffer();
		int len = s.length();
		for(int i=0; i<len; i++)
		{
			char c = s.charAt(i);
			switch (c)
			{
				case '%':
					try
					{
						sb.append((char)Integer.parseInt(s.substring(i+1,i+3),16));
					}
					catch (NumberFormatException e) 
					{
						throw new IllegalArgumentException();
					}
					i += 2;
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}

	private String[] getValues(String str,String delimiter)
	{
		StringTokenizer strTokens = new StringTokenizer(str,delimiter);
		int i_count = strTokens.countTokens();
		String[] tempValues = new String[i_count];
		for (int i=0;i<tempValues.length;i++)
		{
			String s1 = strTokens.nextToken();
			tempValues[i] = s1;
		}
		return tempValues;
	}

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}

	//For e.g., str can be OS=Microsoft Windows XP Professional#Service=eG##Mon#Installed=All##All
	//Note : delimiter should be a single character
	private ArrayList getParameters(String str,String delimiter)
	{
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		int delimiterIdx = str.indexOf(delimiter);
		while (delimiterIdx != -1)
		{
			String cutString = str.substring(0,delimiterIdx);

			if (cutString.length() == 0)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(1);
			}
			else if (cutString.trim().indexOf("=") == -1)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + cutString;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(cutString.length()+1);
			}
			else
			{
				String key = cutString.substring(0,cutString.indexOf("="));
				String value = cutString.substring(cutString.indexOf("=")+1);
				aListResultant.add(key.trim());
				aListResultant.add(value.trim());
				prevKey = key.trim();
				str = str.substring(delimiterIdx+1);
			}

			delimiterIdx = str.indexOf(delimiter);
		}

		if (str.length() > 0)
		{
			if (str.indexOf("=") != -1)
			{
				String lastKey = str.substring(0,str.indexOf("="));
				String lastValue = str.substring(str.indexOf("=")+1);
				aListResultant.add(lastKey.trim());
				aListResultant.add(lastValue.trim());
			}
			else
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
		}

		ArrayList aListTemp = new ArrayList();
		for (int i=0;i<aListResultant.size();i=i+2)
		{
			aListTemp.add((String)aListResultant.get(i)+"="+(String)aListResultant.get(i+1));
		}

		return aListTemp;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody;
  private org.apache.jasper.runtime.TagHandlerPool _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(getServletConfig());
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.release();
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.release();
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*
 *   File				:	EcPrintDataReport.jsp
 *   Purpose			:	Prints selected configuration details
 *   Creation Date		:	20/06/2006
 *   Author				:	Krishnamurthi, Balasigamani
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */


	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	String startDateAndTime = null;
	String endDateAndTime = null;
	String ec_userName = request.getParameter("userName");
	String ec_user_language = request.getParameter("user_language");

	//user language
	String userLanguage = null;
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	else if (user == null)
	{
		EcUserData ecUserData = new EcUserData(ec_userName,false);
		user = ecUserData.getUser(ec_userName);
		userLanguage = ec_user_language;
	}

	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgConfigTestsInfo configtestsinfo = new EgConfigTestsInfo("manager");
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EcUtils ecUtils = new EcUtils();

	String ec_component = "";
	String ec_option1 = "";
	String ec_option2 = "";
	String ec_timeline = "";
	String s_start_time = "";
	String s_end_time = "";
	String ec_stdate = "";
	String sHour = "";
	String sMinute = "";
	String ec_enddate = "";
	String eHour = "";
	String eMinute = "";
	String ec_changetype = "";
	String s_viewchange = "";
	String ec_maxPageItems = "";
	String displayNameForChangeType = "";
	String selectedTests = "";
	String selectedDate = null;
	String selectedHour = null;
	TreeMap tmap_changeConfigDetails = null;
	ArrayList aListComponents = null;
	boolean requestHomePage = false;
	int topN = 10;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_userOption = (String)session.getAttribute("ec_userOption");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_type = request.getParameter("ec_type");
	String ec_trgttype = request.getParameter("ec_trgttype");
	String ec_forPDF = request.getParameter("ec_forPDF");
	String requestFrom = request.getParameter("requestFrom");
	String searchCompValue = request.getParameter("searchCompValue");
	String searchTestValue = request.getParameter("searchTestValue");
	String searchDescValue = request.getParameter("searchDescValue");

	if (ec_type != null)
	{
		if (ec_type.equalsIgnoreCase("Current"))
		{
			ec_component = request.getParameter("ec_component");
		}

		if (ec_type.equalsIgnoreCase("Change") || ec_type.equalsIgnoreCase("ShowComponentChanges"))
		{
			if (requestFrom != null && requestFrom.equals("Schedule"))
			{
				ec_option1 = (String)request.getAttribute("option1");
				ec_option2 = (String)request.getAttribute("option2");

				ec_timeline = (String)request.getAttribute("timeline");

				s_start_time = (String)request.getAttribute("startDateAndTime");
				s_end_time = (String)request.getAttribute("endDateAndtime");

				String tempDateTime = s_start_time.substring(0,s_start_time.lastIndexOf(':'));
				String tempSDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempSTime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempSDate = DateUtil.changeDateFormat(tempSDate,"MM/dd/yyyy",currentDateFormat);
				s_start_time = tempSDate + " " + tempSTime;

				tempDateTime = s_end_time.substring(0,s_end_time.lastIndexOf(':'));
				String tempEDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempETime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempEDate = DateUtil.changeDateFormat(tempEDate,"MM/dd/yyyy",currentDateFormat);
				s_end_time = tempEDate + " " + tempETime;

				ec_changetype = (String)request.getAttribute("changeType");

				s_viewchange = (String)request.getAttribute("viewChange");

				String strTopN = (String)request.getAttribute("topN");
				if (strTopN != null && !strTopN.equals("null"))
				{
					topN = Integer.parseInt(strTopN);
				}

				tmap_changeConfigDetails = (TreeMap)request.getAttribute("CHANGE_DATA");
			}
			else
			{
				EcPrintData ecData = (EcPrintData)session.getAttribute("CHANGE_COMPONENT_DATA");

				ec_option1 = ecData.getOptionOne();
				ec_option2 = ecData.getOptionTwo();

				ec_timeline = ecData.getTimeLine();

				s_start_time = ecData.getStartTime();
				s_end_time = ecData.getEndTime();

				ec_stdate = ecData.getStartDate();

				String ec_sthr = ecData.getStartHour();
				if (ec_sthr != null)
				{
					if (ec_sthr.length() == 1)
						sHour = "0" + ec_sthr;
					else
						sHour = ec_sthr;
				}

				String ec_startmin = ecData.getStartMinute();
				if (ec_startmin != null)
				{
					if (ec_startmin.length() == 1)
						sMinute = "0" + ec_startmin;
					else
						sMinute = ec_startmin;
				}

				ec_enddate = ecData.getEndDate();

				String ec_endhr = ecData.getEndHour();
				if (ec_endhr != null)
				{
					if (ec_endhr.length() == 1)
						eHour = "0" + ec_endhr;
					else
						eHour = ec_endhr;
				}

				String ec_endmin = ecData.getEndMinute();
				if (ec_endmin != null)
				{
					if (ec_endmin.length() == 1)
						eMinute = "0" + ec_endmin;
					else
						eMinute = ec_endmin;
				}

				ec_changetype = ecData.getChangeType();

				s_viewchange = ecData.getViewChange();

				selectedDate = ecData.getSelectedDate();
				if (selectedDate != null) requestHomePage = true;
				selectedHour = ecData.getSelectedHour();

				topN = ecData.getTopNChanges();

				ec_component = request.getParameter("componentName");

				tmap_changeConfigDetails = ecData.getChangeData();
			}

			if (ec_changetype != null)
			{
				if (ec_changetype.equalsIgnoreCase("Latest"))
				{
					displayNameForChangeType = "Recent";
				}
				else
				{
					displayNameForChangeType = "All";
				}
			}

			if (ec_type.equalsIgnoreCase("Change"))
			{
				aListComponents = new ArrayList();
				Iterator component_keys = tmap_changeConfigDetails.keySet().iterator();
				while (component_keys.hasNext())
				{
					String key_component = (String)component_keys.next();
					if (!key_component.equalsIgnoreCase("Change By Date"))
					{
						aListComponents.add(key_component);
					}
				}
			}

			tmap_changeConfigDetails = processChangeData.getChangeSummary(tmap_changeConfigDetails,searchCompValue,searchTestValue,searchDescValue,userLanguage);
		}
	}

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = (String)timeZoneConverter.getDateTime();
	/* Added by Prakash.K ends */
	
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}

	String reportTitle = ec_type;
	if (ec_type != null && ec_type.equalsIgnoreCase("Current"))
	{
		reportTitle = "CURRENT";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Application_Users"))
	{
		reportTitle = "THIN CLIENT APPLICATIONS";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("User_Applications"))
	{
		if (requestFrom != null && requestFrom.equalsIgnoreCase("currentConfigThinClient"))
			reportTitle = "USERS AND THEIR ASSOCIATED APPLICATIONS";
		else
			reportTitle = "THIN CLIENT USERS";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ShowComponentChanges"))
	{
		reportTitle = "CHANGE";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Change"))
	{
		reportTitle = "CHANGE";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentType"))
	{
		reportTitle = "COMPONENT TYPE CHANGE SUMMARY";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentName"))
	{
		reportTitle = "COMPONENT NAME CHANGE SUMMARY";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Consolidated_View"))
	{
		reportTitle = "CONSOLIDATED VIEW";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Search"))
	{
		reportTitle = "SEARCH";
	}

	String fontStyle = "";
	if ((dbInfo.doubleByteEnabled || !userLanguage.equals("en_US")) && 
		(ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes")))
	{
		fontStyle = "multi_font";
	}

	boolean isLangCHJPKR = false;
	boolean isSingleByte = false;
	if (userLanguage.equals("ch_CH") || 
		userLanguage.equals("ja_JP") || 
		userLanguage.equals("ko_KR"))
	{
		isLangCHJPKR = true;
	}
	else if (userLanguage.equals("pt_BR") || 
		userLanguage.equals("it_IT") || 
		userLanguage.equals("fr_FR") || 
		userLanguage.equals("es_ES") || 
		userLanguage.equals("de_DE"))
	{
		isSingleByte = true;
	}

	String result1 = "<LINK href=\"../";

	String result2 = "config/styles/ec_style_" + user.getConfigSkin();
	if (isLangCHJPKR)
	{
		result2 = result2 + "_multi";
	}
	else if (isSingleByte)
	{
		result2 = result2 + "_singlebyte";
	}

	String result3 = ".css\" type=\"text/css\" rel=\"stylesheet\">";

	String strStyleSheet = result1 + result2 + result3;

      out.write("<html style=\"background:#ffffff!important\">\n<head>\n\t<title>");
      if (_jspx_meth_egui_005fintnl_005f0(_jspx_page_context))
        return;
      out.write("</title>\n\t");
//=strStyleSheet
      if (_jspx_meth_egui_005fskin_005f0(_jspx_page_context))
        return;
      out.write("<script language=\"Javascript\">\n\t\t//window.print();\n\t</script>\n</head>\n\n<body leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" bgcolor=\"#FFFFFF\" onLoad=\"javascript:void(0);\" onUnLoad=\"javascript:void(0)\">\n<form name=\"EcPrint\" method=\"post\" onSubmit=\"return false;\">\n<input type=\"hidden\" name=\"ec_criteriaPrevious\" value=\"");
      out.print(ec_criteria);
      out.write("\">\n<input type=\"hidden\" name=\"ec_userOptionPrevious\" value=\"");
      out.print(ec_userOption);
      out.write("\">\n\n\t<table width=\"99%\" align=\"center\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");

	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
	{

      out.write("<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\">\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" height=\"24\" border=\"0\" width=\"100%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f1(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\" height=\"24\">\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"5\" height=\"24\" border=\"0\" width=\"100%\" id=\"bottomtable\">\n\t\t\t\t\t<tr>\n");

		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1") && !ec_criteria.equalsIgnoreCase("null"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();

      out.write("<td align=\"left\" width=\"95%\"><b>");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f2 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f2.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f2.setParent(null);
      // /config/EcPrintDataReport.jsp(586,38) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f2.setText("configmgmt.common."+reportTitle);
      int _jspx_eval_egui_005fintnl_005f2 = _jspx_th_egui_005fintnl_005f2.doStartTag();
      if (_jspx_th_egui_005fintnl_005f2.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f2);
      out.write("&nbsp;");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f3 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f3.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f3.setParent(null);
      // /config/EcPrintDataReport.jsp(586,103) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f3.setText("configmgmt.common."+ec_trgttype.toUpperCase());
      int _jspx_eval_egui_005fintnl_005f3 = _jspx_th_egui_005fintnl_005f3.doStartTag();
      if (_jspx_th_egui_005fintnl_005f3.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f3);
      out.write("&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f4(_jspx_page_context))
        return;
      out.write("&nbsp;'");
      out.print(ec_userOption);
      out.write("'&nbsp;");
      out.print(ec_criteria);
      out.write("</b></td>\n");

		}
		else
		{

      out.write("<td align=\"left\" width=\"95%\"><b>");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f5 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f5.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f5.setParent(null);
      // /config/EcPrintDataReport.jsp(592,38) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f5.setText("configmgmt.common."+reportTitle);
      int _jspx_eval_egui_005fintnl_005f5 = _jspx_th_egui_005fintnl_005f5.doStartTag();
      if (_jspx_th_egui_005fintnl_005f5.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f5);
      out.write("&nbsp;");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f6 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f6.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f6.setParent(null);
      // /config/EcPrintDataReport.jsp(592,103) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f6.setText("configmgmt.common."+ec_trgttype.toUpperCase());
      int _jspx_eval_egui_005fintnl_005f6 = _jspx_th_egui_005fintnl_005f6.doStartTag();
      if (_jspx_th_egui_005fintnl_005f6.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f6);
      out.write("</b></td>\n");

		}

      out.write("<td align=\"center\" width=\"5%\" >\n\t\t\t\t\t\t\t<img class=\"mouse\" src=\"../config/images/printer_print.jpg\" border=\"0\" onClick=\"javascript:print()\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n");

	}
	else if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		//String imageName = iniUI.getConfigHomeLogo();
		String imageName = user.getConfigLogo();

      out.write("<tr>\n\t\t\t<td>\n\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" width=\"30%\" valign=\"bottom\"><img src=\"");
      out.print(imageName);
      out.write("\" border=\"0\"></td>\n\t\t\t\t\t\t<td width=\"70%\" align=\"right\" valign=\"bottom\">\n\t\t\t\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");

		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1") && !ec_criteria.equalsIgnoreCase("null"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.common."+reportTitle));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common."+ec_trgttype.toUpperCase()));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.OF"));
      out.write("&nbsp;'");
      out.print(ec_userOption);
      out.write("'&nbsp;");
      out.print(ec_criteria);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t<tr>\n");

		}
		else
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.common."+reportTitle));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common."+ec_trgttype.toUpperCase()));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

	}

	if (ec_type!=null && ec_type.equalsIgnoreCase("CURRENT"))
	{
		String component = ec_component.substring(0,ec_component.lastIndexOf(':'));
		if (component.endsWith(":NULL"))
			component = component.substring(0,component.lastIndexOf(':'));

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
		{

      out.write("<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

		int i_configDataColumnCountout = configtestsinfo.getConfigurationDataColumnCount();
		ArrayList al_configDetails = (ArrayList)session.getAttribute("CURRENT_DATA");

		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			al_configDetails = (ArrayList)request.getAttribute("CURRENT_DATA");
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
			String strComponentType = ec_component.substring(ec_component.lastIndexOf(":")+1);
			strComponentType = mappingInfo.getComponentTypeDescription(strComponentType);

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.configuration.Configuration Details for"));
      out.write("&nbsp;");
      out.print(component);
      out.write("&nbsp;[");
      out.print(strComponentType);
      out.write("]</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.configuration.as on"));
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

		if (al_configDetails!=null && !al_configDetails.isEmpty())
		{
			ArrayList a_title = (ArrayList)al_configDetails.get(0);//ArrayList for Title
			String title = (String) a_title.get(0);

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"body_text\" >\n");

			if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
			{

      out.write("<tr>\n\t\t\t\t\t\t<td width=\"70%\" id=\"main_head\" align=\"center\"><b>");
      if (_jspx_meth_egui_005fintnl_005f7(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(component);
      out.write("&nbsp;[");
      out.print(title);
      out.write("]</b></td>\n\t\t\t\t\t</tr>\n");

			}

			for(int m=1;m<al_configDetails.size();m++)
			{
				ArrayList a = (ArrayList)al_configDetails.get(m); //ArrayList for each test

				ArrayList al_heading = (ArrayList)a.get(0); //Heading
				String heading = (String)al_heading.get(0);

				ArrayList al_flags_both = (ArrayList)a.get(1); //Rows and Column Display Flags 
				ArrayList al_flags_row = (ArrayList)al_flags_both.get(0); //Row Display Flags
				ArrayList al_flags_column = (ArrayList)al_flags_both.get(1); //Column Display Flags

				ArrayList al_columnNames = (ArrayList)a.get(2); //Column Names
				int colCount = al_columnNames.size();
				TreeMap tmap_data = (TreeMap)a.get(3); //Values - TreeMap

				ArrayList aListInfoHeadings = (ArrayList)a.get(4); //Info Headings - ArrayList

				boolean isDynamicMeasureTest = false;
				String firstKey = (String)tmap_data.firstKey();
				int idx_M = firstKey.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"center\" >\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td colspan=\"2\" height=\"3\"><img src=\"/final/config/images/spacer.gif\" height=\"5\"></td></tr></table>\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"2\" height=\"24\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.configuration."+heading));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"100%\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" class=\"body_text\">\n");

				Iterator iter = tmap_data.keySet().iterator();
				boolean colHeading_flag = false;
				int trueFlagColCount = 0;
				int f = 0;
				while(iter.hasNext())
				{
					String key_info = (String)iter.next();
					ArrayList al2 = (ArrayList)tmap_data.get(key_info);
					if (al2.size() != (colCount - 1)) continue;
					if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
					{
						//Show row-wise data - Non-Info based - Don't show Descriptor
						for (int x=1; x<colCount; x++)
						{
							String display_flag = (String)al_flags_column.get(x);
							if (display_flag.equals("true"))
							{
								String columnName = (String)al_columnNames.get(x);
								String strValue = (String)al2.get(x-1);

      out.write("<tr>\n");

								if (strValue.startsWith("<?configuration?>"))
								{

      out.write("<td width=\"50%\" id=\"linebottomright\" valign=\"top\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(columnName);
      out.write("</td>\n");

								}
								else
								{

      out.write("<td width=\"50%\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(columnName);
      out.write("</td>\n");

								}

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								if(strValue == null || strValue.trim().length() == 0)
								{
									strValue = "-";
								}

								if (strValue.startsWith("<?configuration?>"))
								{
									strValue = StringUtils.replace(strValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
									out.println(strValue);
								}
								else
								{

									//removing BOM Character begin
									byte[] bytes = strValue.getBytes(EcUtils.UTF8_ENCODING);
									if (EcUtils.isUTF8(bytes))
									{
										strValue = EcUtils.printSkippedBomString(bytes);
									}
									//end

									if (strValue.length() <= 100)
									{
										out.println(strValue);
									}
									else
									{
										ArrayList aListStrValues = null;
										if (columnName.equalsIgnoreCase("VM Arguments"))
										{
											aListStrValues = breakString(strValue,68);
										}
										else
										{
											aListStrValues = breakString(strValue,70);
										}
										for (int r=0;r<aListStrValues.size();r++)
										{
											String str_value = (String)aListStrValues.get(r);
											str_value = EcUtils.replaceTags(str_value);
											out.println(str_value+"<br>");
										}
									}
								}

      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

							}
						}
					}
					else
					{
						//Info-Based
						if (colCount <= i_configDataColumnCountout)
						{
							//Column-wise
							if (!colHeading_flag)
							{

      out.write("<tr>\n");

								if (colCount == 2)
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else if (colCount == 3)
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" width=\"33%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else if (colCount == 4)
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else if (colCount == 5)
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else if (colCount == 6)
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" width=\"16%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else
								{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}

      out.write('<');
      out.write('b');
      out.write('>');
      out.print((String)al_columnNames.get(0));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

								for (int n=1; n<colCount; n++)
								{
									String display_flag = (String)al_flags_column.get(n);
									if(display_flag!=null && display_flag.equals("true"))
									{
										trueFlagColCount++;
										if (colCount == 2)
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else if (colCount == 3)
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" width=\"33%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else if (colCount == 4)
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else if (colCount == 5)
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else if (colCount == 6)
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" width=\"16%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)al_columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
									}
								}

      out.write("</tr>\n");

								colHeading_flag = true;
							}

							//if (key_info.indexOf('>') != -1) //Present... Tree form
							//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);

							String row_flag = (String)al_flags_row.get(f);
							if (row_flag.equals("true"))
							{

      out.write("<tr>\n");

								if (!isDynamicMeasureTest)
								{
									String strInfo = ecUtils.getInfoForDisplay(key_info);
									if (strInfo.startsWith("<?configuration?>"))
									{
										strInfo = StringUtils.replace(strInfo,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
										out.print(strInfo);
									}
									else
									{
										if (strInfo.length() <= 50)
										{

      out.write("<td valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(strInfo);
      out.write("</td>\n");

										}
										else
										{

      out.write("<td valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

											ArrayList aListStrValues = breakString(strInfo,50);
											for (int r=0;r<aListStrValues.size();r++)
											{
												String str_value = (String)aListStrValues.get(r);
												out.print(str_value+"<br>");
											}

      out.write("</td>\n");

										}
									}
								}
								else
								{

      out.write("<td valign=\"top\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
										}
									}
									out.println(strData);

      out.write("</td>\n");

								}

								for (int z=0; z<colCount-1; z++)
								{
									String display_flag = (String)al_flags_column.get(z+1);
									if (display_flag.equals("true"))
									{
										String s_value = (String)al2.get(z);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTextDescription("configmgmt.common.Yes"));
      out.write("</td>\n");

										}
										else
										{
											if(s_value == null || s_value.trim().length() == 0)
											{
												s_value = "-";
											}

											if (!s_value.startsWith("<?configuration?>"))
											{
												//removing BOM Character begin
												byte[] bytesArr = s_value.getBytes(EcUtils.UTF8_ENCODING);
												if (EcUtils.isUTF8(bytesArr))
												{
													s_value = EcUtils.printSkippedBomString(bytesArr);
												}
												//end

												if (s_value.length()<=25)
												{
													s_value = EcUtils.replaceTags(s_value);

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

												}
												else
												{
													if (colCount == 3)
													{
														if (s_value.length()<=33)
														{
															s_value = EcUtils.replaceTags(s_value);

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

														}
														else
														{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

															ArrayList aListStrValues = breakString(s_value,33);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}

      out.write("</td>\n");

														}
													}
													else if (colCount == 2)
													{
														if (s_value.length()<=100)
														{
															s_value = EcUtils.replaceTags(s_value);

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

														}
														else
														{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

															ArrayList aListStrValues = breakString(s_value,100);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}

      out.write("</td>\n");

														}
													}
													else if (colCount == 5 || colCount == 6 || colCount == 7)
													{
														if (s_value.length()<=35)
														{
															s_value = EcUtils.replaceTags(s_value);

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

														}
														else
														{

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

															ArrayList aListStrValues = breakString(s_value,35);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}

      out.write("</td>\n");

														}
													}
													else
													{
														s_value = EcUtils.replaceTags(s_value);

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

													}
												}
											}
											else
											{
												s_value = StringUtils.replace(s_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td wrap valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(s_value);
      out.write("</td>\n");

											}
										}
									}
								}
							}
							else
							{

      out.write("<td id=\"linebottomright\" style=\"border-left-width:1px\" valign=\"top\" colspan=\"");
      out.print(trueFlagColCount+1);
      out.write("\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(ecUtils.getInfoForDisplay(key_info));
      out.write("</td>\n");

							}

      out.write("</tr>\n");

						}
						else
						{
							//Row-wise
							String row_flag = (String)al_flags_row.get(f);
							if (row_flag.equals("true"))
							{
								//if (key_info.indexOf('>') != -1) //Present... Tree form
								//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);
								if (!isDynamicMeasureTest)
								{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td height=\"20\" colspan=\"2\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(ecUtils.getInfoForDisplay(key_info));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

								}
								else
								{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td height=\"20\" colspan=\"2\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
										}
									}
									out.println(strData);

      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

								}

								for (int p=1; p<colCount; p++)
								{
									String display_flag = (String)al_flags_column.get(p);
									if (display_flag.equals("true"))
									{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"50%\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print((String)al_columnNames.get(p));
      out.write("</td>\n");

										String s_value = (String)al2.get(p-1);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{

      out.write("<td width=\"50%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTextDescription("configmgmt.common.Yes"));
      out.write("&nbsp;\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else
										{
											if(s_value == null || s_value.trim().length() == 0)
											{
												s_value = "-";
											}
											//removing BOM Character begin
											byte[] bytesArr = s_value.getBytes(EcUtils.UTF8_ENCODING);
											if (EcUtils.isUTF8(bytesArr))
											{
												s_value = EcUtils.printSkippedBomString(bytesArr);
											}
											//end

											if (s_value.length() <= 100)
											{
												s_value = EcUtils.replaceTags(s_value);

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(s_value);
      out.write("&nbsp;</td>\n");

											}
											else
											{

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

												ArrayList aListStrValues = breakString(s_value,100);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}

      out.write("</td>\n");

											}
										}

      out.write("</tr>\n");

									}
								}
							}
							else
							{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td height=\"20\" colspan=\"2\" id=\"linebottomright\" style=\"border-left-width:1px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(ecUtils.getInfoForDisplay(key_info));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

							}
						}
					}
					f++;
				}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

			}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

		}
		else
		{

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"50\"></td></tr></table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" height=\"100%\" valign=\"top\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" height=\"100%\">\n\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\" height=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"center\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\"><img src=\"/final/config/images/unavailable-data.gif\"></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.common.No data found"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n");

		}
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Application_Users"))
	{
		String component = "";
		String heading = "";
		String farmName = "";
		String serverName = "";
		String applicationName = "";
		TreeMap tmapCitrixApplicationsAndUsers = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			component = (String)request.getAttribute("ec_component");
			heading = (String)request.getAttribute("heading");
			farmName = (String)request.getAttribute("farmName");
			serverName = (String)request.getAttribute("serverName");
			applicationName = (String)request.getAttribute("applicationName");

			tmapCitrixApplicationsAndUsers = (TreeMap)request.getAttribute("CitrixApplicationUsers");

		}
		else
		{
			component = (String)session.getAttribute("ec_component");
			heading = (String)session.getAttribute("heading");
			farmName = (String)session.getAttribute("farmName");
			serverName = (String)session.getAttribute("serverName");
			applicationName = (String)session.getAttribute("applicationName");

			tmapCitrixApplicationsAndUsers = (TreeMap)session.getAttribute("CitrixApplicationUsers");
		}
		ArrayList aListCitrixApplicationUsers = null;
		if (applicationName != null && !(applicationName.equalsIgnoreCase("All") || applicationName.equals("-1")))
		{
			aListCitrixApplicationUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationName);
		}

		String componentName = component.substring(0,component.lastIndexOf(":"));
		String componentType = component.substring(component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f8(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" width=\"50%\" cellspacing=\"0\" cellpadding=\"0\" height=\"25\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f9(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t");
      out.print(componentName+":"+componentType);
      out.write("</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n");

		if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		{

      out.write("<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f10(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t");
      out.print(farmName);
      out.write("</td>\n");

		}
		else
		{

      out.write("<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f11(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t");
      out.print(serverName);
      out.write("</td>\n");

		}

      out.write("</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f12(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t");
      out.print(applicationName);
      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\n\t\t<tr><td><img src=\"/final/config/images/spacer.gif\" height=\"5\" border=\"0\"></td></tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" class=\"body_text\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n");

		if (aListCitrixApplicationUsers != null)
		{
			ArrayList aList = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer((String)aListCitrixApplicationUsers.get(0),",");

      out.write("<tr>\n\t\t\t\t\t\t<td width=\"90%\" colspan=\"4\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f13(_jspx_page_context))
        return;
      out.print(applicationName);
      out.write("&nbsp;:&nbsp;");
      out.print(strTokens.countTokens());
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"90%\" colspan=\"4\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f14(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

			while (strTokens.hasMoreTokens())
			{
				String token = strTokens.nextToken();
				aList.add(token);
			}

			for (int d=0; d<aList.size(); d=d+4)
			{

      out.write("<tr>\n");

				for (int e=d; e<d+4; e++)
				{
					if (e<aList.size())
					{
						String userKey = (String)aList.get(e);
						if (e == d+4-1)
						{

      out.write("<td id=\"linebottom\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}
						else
						{

      out.write("<td id=\"linebottomright\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}

      out.print(userKey);
      out.write("</td>\n");

					}
					else
					{
						if (e == d+4-1)
						{

      out.write("<td id=\"linebottom\" width=\"25%\">\n");

						}
						else
						{

      out.write("<td id=\"linebottomright\" width=\"25%\">\n");

						}

      out.write("\n\t\t\t\t\t\t\t&nbsp;\n\t\t\t\t\t\t</td>\n");

					}
				}

      out.write("</tr>\n");

			}
		}
		else
		{

      out.write("<tr>\n\t\t\t\t\t\t<td width=\"100%\" id=\"linebottom\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f15(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"body_text\" width=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"25%\" id=\"linebottomright\" align=\"left\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f16(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"75%\" id=\"linebottom\" align=\"center\" height=\"20\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f17(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td valign=\"top\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" class=\"body_text\">\n");

			Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
			while (applicationAsKeys.hasNext())
			{
				String applicationKey = (String)applicationAsKeys.next();
				ArrayList aListUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationKey);
				ArrayList aList = new ArrayList();
				StringTokenizer strTokens = new StringTokenizer((String)aListUsers.get(0),",");
				while (strTokens.hasMoreTokens())
				{
					String token = strTokens.nextToken();
					aList.add(token);
				}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"25%\" align=\"left\" valign=\"top\" id=\"linebottomright\" style=\"padding:4px 4px 4px 4px\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(applicationKey);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"75%\" height=\"20\" style=\"padding:0px\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\" width=\"100%\">\n");

				for (int d=0; d<aList.size(); d=d+3)
				{

      out.write("<tr>\n");

					for (int e=d; e<d+3; e++)
					{
						if (e<aList.size())
						{
							String userKey = (String)aList.get(e);
							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"25%\" style=\"padding:4px 4px 4px 4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"25%\" style=\"padding:4px 4px 4px 4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}

      out.print(userKey);
      out.write("</td>\n");

						}
						else
						{
							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"25%\" style=\"padding:4px 4px 4px 4px\">\n");

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"25%\" style=\"padding:4px 4px 4px 4px\">\n");

							}

      out.write("\n\t\t\t\t\t\t\t\t\t\t\t\t&nbsp;</td>\n");

						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

			}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

		}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("User_Applications"))
	{
		String component = "";
		String heading = "";
		String farmName = "";
		String serverName = "";
		String userName = "";
		TreeMap tmapCitrixUsersAndApplications = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			component = (String)request.getAttribute("ec_component");
			heading = (String)request.getAttribute("heading");
			farmName = (String)request.getAttribute("farmName");
			serverName = (String)request.getAttribute("serverName");
			userName = (String)request.getAttribute("userName");

			tmapCitrixUsersAndApplications = (TreeMap)request.getAttribute("CitrixUserApplications");

		}
		else
		{
			component = (String)session.getAttribute("ec_component");
			heading = (String)session.getAttribute("heading");
			farmName = (String)session.getAttribute("farmName");
			serverName = (String)session.getAttribute("serverName");
			userName = (String)session.getAttribute("userName");

			tmapCitrixUsersAndApplications = (TreeMap)session.getAttribute("CitrixUserApplications");
		}
		ArrayList aListCitrixUserApplications = null;
		if (userName != null && !(userName.equalsIgnoreCase("All") || userName.equals("-1")))
		{
			aListCitrixUserApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userName);
		}

		String componentName = component.substring(0,component.lastIndexOf(":"));
		String componentType = component.substring(component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f18(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" width=\"50%\" cellspacing=\"0\" cellpadding=\"0\" height=\"25\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f19(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t");
      out.print(componentName+":"+componentType);
      out.write("</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<!--<tr>-->\n");

		//if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		//{

      out.write("<!--<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f20(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t");
//=farmName
      out.write("</td>-->\n");

		//}
		//else
		//{

      out.write("<!--<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f21(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t");
//=serverName
      out.write("</td>-->\n");

		//}

      out.write("<!--</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"right\" width=\"20%\" height=\"20\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f22(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t\t<td align=\"center\" width=\"3%\"><b>:</b></td>\n\t\t\t\t\t\t<td align=\"left\" width=\"27%\" class=\"");
//=fontStyle
      out.write("\">\n\t\t\t\t\t\t\t");
//=userName
      out.write("</td>\n\t\t\t\t\t</tr>-->\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\n\t\t<tr><td><img src=\"/final/config/images/spacer.gif\" height=\"5\" border=\"0\"></td></tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" class=\"body_text\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n");

		if (aListCitrixUserApplications != null)
		{
			int applicationSize = aListCitrixUserApplications.size();

      out.write("<tr>\n\t\t\t\t\t\t<td width=\"90%\" colspan=\"4\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f23(_jspx_page_context))
        return;
      out.print(userName);
      out.write("&nbsp;:&nbsp;");
      out.print(applicationSize);
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"90%\" colspan=\"4\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f24(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

			for (int d=0; d<applicationSize; d=d+4)
			{

      out.write("<tr>\n");

				for (int e=d; e<d+4; e++)
				{
					if (e<applicationSize)
					{
						if (e == d+4-1)
						{

      out.write("<td id=\"linebottom\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}
						else
						{

      out.write("<td id=\"linebottomright\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}

      out.print(aListCitrixUserApplications.get(e));
      out.write("</td>\n");

					}
					else
					{
						if (e == d+4-1)
						{

      out.write("<td id=\"linebottom\" width=\"25%\">\n");

						}
						else
						{

      out.write("<td id=\"linebottomright\" width=\"25%\">\n");

						}

      out.write("\n\t\t\t\t\t\t\t&nbsp;\n\t\t\t\t\t\t</td>\n");

					}
				}

      out.write("</tr>\n");

			}
		}
		else
		{

      out.write("<tr>\n\t\t\t\t\t\t<td width=\"100%\" id=\"linebottom\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f25(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"body_text\" width=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"25%\" id=\"linebottomright\" align=\"left\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f26(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"75%\" id=\"linebottom\" align=\"center\" height=\"20\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f27(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td valign=\"top\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" class=\"body_text\">\n");

			Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
			while (userAsKeys.hasNext())
			{
				String userKey = (String)userAsKeys.next();
				ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userKey);

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"25%\" align=\"left\" valign=\"top\" id=\"linebottomright\" style=\"padding:4px 4px 4px 4px\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(userKey);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"75%\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\" width=\"100%\">\n");

				for (int d=0; d<aListApplications.size(); d=d+3)
				{

      out.write("<tr>\n");

					for (int e=d; e<d+3; e++)
					{
						if (e<aListApplications.size())
						{
							String applicationKey = (String)aListApplications.get(e);
							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"25%\" style=\"padding:4px 4px 4px 4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"25%\" style=\"padding:4px 4px 4px 4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}

      out.print(applicationKey);
      out.write("</td>\n");

						}
						else
						{
							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"25%\" style=\"padding:4px 4px 4px 4px\">\n");

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"25%\" style=\"padding:4px 4px 4px 4px\">\n");

							}

      out.write("\n\t\t\t\t\t\t\t\t\t\t\t\t&nbsp;</td>\n");

						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

			}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

		}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Change"))
	{
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGE"));
      out.write("&nbsp;:&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.DETAILED"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

			if (ec_option1.equalsIgnoreCase(userOptions[0]))
			{

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.COMPONENT NAME"));
      out.write("</b>\n");

			}
			else if (ec_option1.equalsIgnoreCase(userOptions[1]))
			{

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.COMPONENT TYPE"));
      out.write("</b>\n");

			}
			else
			{

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.ALL COMPONENTS"));
      out.write("</b>\n");

			}

      out.write("</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td>\n");

		if (tmap_changeConfigDetails!=null && !tmap_changeConfigDetails.isEmpty())
		{

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n");

			if (ec_option1.equalsIgnoreCase(userOptions[2])) //Only for All Components
			{

      out.write("<table border=\"0\" align=\"center\" width=\"99%\"  id=\"bottomtable\" cellpadding=\"2\" cellspacing=\"0\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+ec_option1));
      out.write("</b></td>\n\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

				if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

				}
				else
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

				}

      out.write("</td>\n\t\t\t\t\t</tr>\n");

				if (requestHomePage)
				{
					String displayDate = DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",userDateFormat);

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"right\" colspan=\"2\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date"));
      out.write(" : </b>");
      out.print(displayDate);

					if (!selectedHour.equals(""))
					{

      out.write("\n\t\t\t\t\t\t\t&nbsp;&nbsp;<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour"));
      out.write(" : </b>");
      out.print(selectedHour);

					}

      out.write("</td>\n\t\t\t\t\t</tr>\n");

				}

      out.write("</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"15\"></td></tr></table>\n");

				TreeMap tmapAllComponentChanges = processChangeData.getAllComponentSummary(tmap_changeConfigDetails,selectedDate,selectedHour);

				Iterator changeCountKeys = tmapAllComponentChanges.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					if (changeCount.intValue() == -1) continue;
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				StringBuffer strBufferChangedComponentsTypes = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				ArrayList aListChangedComponentTypes = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();

				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapAllComponentChanges.get(changeCount);
					aListChangedComponentTypes.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}

				//Build graph for TopN items
				boolean topNFlag = false;
				int indexCount = 0;
				if (aListChangedComponentTypes.size() < topN)
				{
					indexCount = aListChangedComponentTypes.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				for (int b=0; b<indexCount; b++)
				{
					String componentType = (String)aListChangedComponentTypes.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);

					count = count + changeCount.intValue();

					if (b==0)
					{
						strBufferChangedComponentsTypes.append(mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(changeCount.intValue());
					}
					else
					{
						strBufferChangedComponentsTypes.append(","+mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(","+changeCount.intValue());
					}
				}

				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
				String maximumRange = ""+maxCount;

				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.component types with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" align=\"center\">\n\t\t\t\t\t\t\t<img src=\"../servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range=");
      out.print(maximumRange);
      out.write("&chartTitle=");
      out.print(EgURLEncoder.encode(titleName,"UTF-8"));
      out.write("&sampleValues=");
      out.print(EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8"));
      out.write("&barLabels=");
      out.print(EgURLEncoder.encode(strBufferChangedComponentsTypes.toString(),"UTF-8"));
      out.write("&userName=");
      out.print(EgURLEncoder.encode(ec_userName,"UTF-8"));
      out.write("\" border=\"0\" hspace=\"0\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

				TreeMap tmapChangedComponentsUnderType = (TreeMap)tmapAllComponentChanges.get(new Integer("-1"));

      out.write("<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"3\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes by component type"));
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" colspan=\"3\" align=\"center\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed component types"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(aListChangedComponentTypes.size());
      out.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(totalCount);
      out.write("</b></td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type"));
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"5%\" id=\"linebottomright\" align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes"));
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"75%\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components"));
      out.write("</b></td>\n\t\t\t\t\t</tr>\n");

				ArrayList aListChangedComponents = new ArrayList();

				for (int g=0; g<aListChangedComponentTypes.size(); g++)
				{
					String componentType = (String)aListChangedComponentTypes.get(g);
					Integer changes = (Integer)aListChangeCount.get(g);

      out.write("<tr>\n\t\t\t\t\t\t<td id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(mappingInfo.getComponentTypeDescription(componentType));
      out.write("</td>\n\t\t\t\t\t\t<td id=\"linebottomright\" valign=\"top\" align=\"center\">");
      out.print(changes);
      out.write("</td>\n\t\t\t\t\t\t<td align=\"left\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\">\n");

					ArrayList aListTemp = (ArrayList)tmapChangedComponentsUnderType.get(componentType);
					for (int m=0; m<aListTemp.size(); m=m+2)
					{

      out.write("<tr>\n");

						for (int n=m; n<m+2; n++)
						{
							if (n<aListTemp.size())
							{
								String s1 = (String)aListTemp.get(n);

								String comp = s1.substring(0,s1.indexOf('@'));
								String changeCount = s1.substring(s1.indexOf('@')+1);

								aListChangedComponents.add(comp);
								String s_comp = new String(comp);
								s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));
								if (s_comp.endsWith(":NULL"))
									s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));

								String tmpStr = s_comp;
								int displayLength = 28;
								String strCName = StringUtils.egSubString(tmpStr,displayLength);

								if (n == m+2-1)
								{

      out.write("<td width=\"50%\" valign=\"top\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}
								else
								{

      out.write("<td width=\"50%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								}

      out.write("\n\t\t\t\t\t\t\t\t\t\t&nbsp;");
      out.print(strCName);
      out.write(' ');
      out.write('[');
      out.print(changeCount);
      out.write("]\n\t\t\t\t\t\t\t\t\t</td>\n");

							}
							else
							{
								if (n == m+2-1)
								{

      out.write("<td width=\"50%\" valign=\"top\" id=\"linebottom\">\n");

								}
								else
								{

      out.write("<td width=\"50%\" valign=\"top\" id=\"linebottomright\">\n");

								}

      out.write("\n\t\t\t\t\t\t\t\t\t\t&nbsp;\n\t\t\t\t\t\t\t\t\t</td>\n");

							}
						}

      out.write("</tr>\n");

					}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

				}

				aListComponents = aListChangedComponents;

      out.write("</table>\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

			}

			if (ec_option1.equalsIgnoreCase(userOptions[1])) //Only for Component Type
			{
				String componentType = ec_option2;

      out.write("<table border=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" cellpadding=\"2\" cellspacing=\"0\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(mappingInfo.getComponentTypeDescription(componentType));
      out.write("</b></td>\n\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

				if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

				}
				else
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

				}

      out.write("</td>\n\t\t\t\t\t</tr>\n");

				if (requestHomePage)
				{
					String displayDate = DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",userDateFormat);

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"right\" colspan=\"2\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date"));
      out.write(" : </b>");
      out.print(displayDate);

					if (!selectedHour.equals(""))
					{

      out.write("\n\t\t\t\t\t\t\t&nbsp;&nbsp;<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour"));
      out.write(" : </b>");
      out.print(selectedHour);

					}

      out.write("</td>\n\t\t\t\t\t</tr>\n");

				}

      out.write("</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"15\"></td></tr></table>\n");

				TreeMap tmapChangedComponents = processChangeData.getSummary(tmap_changeConfigDetails,selectedDate,selectedHour);
				Iterator changeCountKeys = tmapChangedComponents.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				StringBuffer strBufferChangedComponents = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				ArrayList aListChangedComponents = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();

				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapChangedComponents.get(changeCount);
					aListChangedComponents.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}

				//Build graph for TopN items
				boolean topNFlag = false;
				int indexCount = 0;
				if (aListChangedComponents.size() < topN)
				{
					indexCount = aListChangedComponents.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				for (int b=0; b<indexCount; b++)
				{
					String comp = (String)aListChangedComponents.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);
					count = count + changeCount.intValue();

					comp = comp.substring(0,comp.lastIndexOf(':'));
					if (comp.endsWith(":NULL"))
						comp = comp.substring(0,comp.lastIndexOf(':'));

					if (b==0)
					{
						strBufferChangedComponents.append(comp);
						strBufferChangeCounts.append(changeCount.intValue());
					}
					else
					{
						strBufferChangedComponents.append(","+comp);
						strBufferChangeCounts.append(","+changeCount.intValue());
					}
				}

				aListComponents = aListChangedComponents;

				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
				String maximumRange = ""+maxCount;

				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.components with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\" >\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" align=\"center\">\n\t\t\t\t\t\t\t<img src=\"../servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range=");
      out.print(maximumRange);
      out.write("&chartTitle=");
      out.print(EgURLEncoder.encode(titleName,"UTF-8"));
      out.write("&sampleValues=");
      out.print(EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8"));
      out.write("&barLabels=");
      out.print(EgURLEncoder.encode(strBufferChangedComponents.toString(),"UTF-8"));
      out.write("&userName=");
      out.print(EgURLEncoder.encode(ec_userName,"UTF-8"));
      out.write("\" border=\"0\" hspace=\"0\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" width=\"99%\" cellspacing=\"0\" cellpadding=\"2\" align=\"center\" class=\"bottomtable\" style=\"border-bottom-width:0px\" >\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td id=\"linebottom\" colspan=\"3\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components"));
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" id=\"linebottom\" colspan=\"3\" align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed components"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(aListChangedComponents.size());
      out.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(totalCount);
      out.write("</b></td>\n\t\t\t\t\t</tr>\n");

				for (int d=0; d<aListChangedComponents.size(); d=d+3)
				{

      out.write("<tr>\n");

					for (int e=d; e<d+3; e++)
					{
						if (e<aListChangedComponents.size())
						{
							String strComp = (String)aListChangedComponents.get(e);
							strComp = strComp.substring(0,strComp.lastIndexOf(':'));
							if (strComp.endsWith(":NULL"))
								strComp = strComp.substring(0,strComp.lastIndexOf(':'));

							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}

      out.write("\n\t\t\t\t\t\t\t&nbsp;");
      out.print(strComp);
      out.write(' ');
      out.write('[');
      out.print(aListChangeCount.get(e));
      out.write("]\n\t\t\t\t\t\t</td>\n");

						}
						else
						{
							if (e == d+3-1)
							{

      out.write("<td id=\"linebottom\" width=\"20%\">\n");

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"20%\">\n");

							}

      out.write("\n\t\t\t\t\t\t\t&nbsp;\n\t\t\t\t\t\t</td>\n");

						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

			}

			if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byDate"))
			{
				if (ec_option1.equalsIgnoreCase(userOptions[0]))
				{
					String key_component = (String)aListComponents.get(0);

					String component = key_component.substring(0,key_component.lastIndexOf(':'));
					if (component.endsWith(":NULL"))
						component = component.substring(0,component.lastIndexOf(':'));

					String component_type = key_component.substring(key_component.lastIndexOf(':')+1);

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"15\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" style=\"font-size:8pt;font-family:Verdana\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(component);
      out.write(' ');
      out.write('[');
      out.print(mappingInfo.getComponentTypeDescription(component_type));
      out.write("]</b></td>\n\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

					if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
						startDateAndTime = (String)timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
						endDateAndTime = (String)timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

					}
					else
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
						startDateAndTime = (String)timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
						endDateAndTime = (String)timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

					}

      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"15\"></td></tr></table>\n\n");

					TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,selectedHour);
					Iterator changeCountKeys = tmapChanges.keySet().iterator();
					int totalCount=0;
					int maxCount=0;
					ArrayList aList = new ArrayList();
					while (changeCountKeys.hasNext())
					{
						Integer changeCount = (Integer)changeCountKeys.next();
						aList.add(changeCount);
						maxCount=Math.max(maxCount,changeCount.intValue());
					}
					Collections.reverse(aList);

					ArrayList aListTestnames = new ArrayList();
					ArrayList aListChangeCount = new ArrayList();

					StringBuffer strBufferTestnames = new StringBuffer();
					StringBuffer strBufferChangeCounts = new StringBuffer();

					int i_totalChangeCount = 0;
					for (int a=0; a<aList.size(); a++)
					{
						Integer changeCount = (Integer)aList.get(a);
						ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

						aListTestnames.addAll(aListTemp);

						for (int i=0; i<aListTemp.size(); i++)
						{
							aListChangeCount.add(changeCount);
							i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
						}
					}

					//Build graph for TopN items
					boolean topNFlag = false;
					int indexCount = 0;
					if (aListTestnames.size() < topN)
					{
						indexCount = aListTestnames.size();
					}
					else
					{
						indexCount = topN;
						topNFlag = true;
					}

					for (int b=0; b<indexCount; b++)
					{
						String testname = (String)aListTestnames.get(b);
						Integer changeCount = (Integer)aListChangeCount.get(b);
						if (b == 0)
						{
							strBufferTestnames.append(mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(changeCount.intValue());
						}
						else
						{
							strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(","+changeCount.intValue());
						}
						totalCount = totalCount + changeCount.intValue();
					}

					String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
					maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
					String maximumRange = ""+maxCount;

					if (topNFlag)
					{
						titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
					}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" align=\"center\">\n\t\t\t\t\t\t\t<img src=\"../servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range=");
      out.print(maximumRange);
      out.write("&chartTitle=");
      out.print(EgURLEncoder.encode(titleName,"UTF-8"));
      out.write("&sampleValues=");
      out.print(EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8"));
      out.write("&barLabels=");
      out.print(EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8"));
      out.write("&userName=");
      out.print(EgURLEncoder.encode(ec_userName,"UTF-8"));
      out.write("\" border=\"0\" hspace=\"0\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

				}

				ArrayList aListChangesDatewise = null;
				aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

				aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,searchCompValue,searchTestValue,searchDescValue,userLanguage);

				if (requestHomePage)
				{
					//Add the code here for restricting the data to the selected date
					aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,selectedHour);
				}
				int aListChangesDatewiseSize = aListChangesDatewise.size();

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" style=\"border-bottom-width:0px; border-right-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

				String strInformationWidth = "15%";
				String strDescriptionWidth = "20%";

				boolean heading_flag = false;
				for(int i=0; i<aListChangesDatewiseSize; i++)
				{
					ArrayList al = (ArrayList)aListChangesDatewise.get(i);
					if (!heading_flag)
					{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" width=\"5%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Change Date"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n");

						if (!ec_option1.equalsIgnoreCase(userOptions[0]))
						{

      out.write("<td id=\"linebottomright\" width=\"10%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n");

							strInformationWidth = "10%";
							strDescriptionWidth = "15%";
						}

      out.write("<td id=\"linebottomright\" width=\"");
      out.print(strInformationWidth);
      out.write("\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Information"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" width=\"");
      out.print(strDescriptionWidth);
      out.write("\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

						heading_flag = true;
					}

					String strDateTime = (String)al.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
					String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
					String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",userDateFormat);

					String component = (String)al.get(1);
					String cname = component.substring(0,component.lastIndexOf(':'));
					if (cname.endsWith(":NULL"))
						cname = cname.substring(0,cname.lastIndexOf(':'));
					String ctype = component.substring(component.lastIndexOf(':')+1);
					String displayComponent = cname + ":" + mappingInfo.getComponentTypeDescription(ctype);

					String testname = (String)al.get(2);
					String info = (String)al.get(3);
					Object measure_obj = al.get(4);
					Object previous_obj = al.get(5);
					Object present_obj = al.get(6);

					boolean isDynamicMeasureTest = false;
					int idx_M = info.indexOf("~M~");
					if (idx_M != -1)
					{
						isDynamicMeasureTest = true;
					}

					ArrayList aListInfoHeadings = null;
					if (isDynamicMeasureTest)
					{
						aListInfoHeadings = new ArrayList();
						String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
						if (infoHeadings != null && infoHeadings.length() > 0)
						{
							StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
							while (strTokensTemp.hasMoreTokens())
							{
								String str_temp = strTokensTemp.nextToken();
								aListInfoHeadings.add(str_temp);
							}
						}
					}

					boolean newInfoFlag = false;
					if (measure_obj instanceof ArrayList)
					{
						newInfoFlag = true;
					}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" wrap valign=\"top\" width=\"5%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(displayDate + " " + strTime);
      out.write("</td>\n");

					if (!ec_option1.equalsIgnoreCase(userOptions[0]))
					{

      out.write("<td id=\"linebottomright\" wrap valign=\"top\" width=\"10%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(displayComponent);
      out.write("</td>\n");

					}

      out.write("<td id=\"linebottomright\" wrap valign=\"top\" width=\"");
      out.print(strInformationWidth);
      out.write("\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTestDescription(testname));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td valign=\"top\" width=\"");
      out.print(strDescriptionWidth);
      out.write("\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

					if (!isDynamicMeasureTest)
					{
						info = ecUtils.getInfoForDisplay(info);
						if (!info.equals("+"))
						{
							if (info.length()<=25)
							{
								out.println(info);
							}
							else
							{
								ArrayList aListStrValues = breakString(info,25);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									out.println(str_value+"<br>");
								}
							}
						}
						else
						{
							out.println("&nbsp;");
						}
					}
					else
					{
						if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
						{
							out.println("&nbsp;");
						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strData = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								}
								else
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								}
							}
							out.println(strData);
						}
					}

					if (newInfoFlag)
					{

      out.write("<img src=\"/final/config/images/new_info.gif\" border=\"0\">\n");

					}

      out.write("</td>\n");

					if (measure_obj instanceof String)
					{
						String previous_value = (String)previous_obj;
						String present_value = (String)present_obj;

						if(previous_value == null || previous_value.trim().length() == 0)
						{
							previous_value = "-";
						}
						if(present_value == null || present_value.trim().length() == 0)
						{
							present_value = "-";
						}

						if (!previous_value.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(previous_value.getBytes()))
							{
								previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
							}
						}
						if (!present_value.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(present_value.getBytes()))
							{
								present_value = EcUtils.printSkippedBomString(present_value.getBytes());
							}
						}

						boolean newMeasureFlag = false;
						boolean deletedMeasureFlag = false;
						if (isDynamicMeasureTest && !newInfoFlag)
						{
							if (previous_value.equalsIgnoreCase("##NEW##") || 
								previous_value.equalsIgnoreCase("##NEW-INFO##") || 
								previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								newMeasureFlag = true;
							}
							else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								deletedMeasureFlag = true;
							}
						}

						if (newMeasureFlag)
						{

      out.write("<td width=\"20%\" valign=\"top\" wrap id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("<br><img src=\"/final/config/images/new_info.png\" border=\"0\"></td>\n");

						}
						else if (deletedMeasureFlag)
						{

      out.write("<td width=\"20%\" valign=\"top\" wrap id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("<br><img src=\"/final/config/images/removed_info.png\" border=\"0\"></td>\n");

						}
						else
						{

      out.write("<td width=\"20%\" valign=\"top\" wrap id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("</td>\n");

						}

						if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
						{
							previous_value = "[N/PV]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							previous_value = "[N/A]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (previous_value.startsWith("<?configuration?>"))
						{
							previous_value = StringUtils.replace(previous_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_value);
      out.write("&nbsp;</td>\n");

						}
						else
						{
							if (previous_value.length()<=18)
							{
								previous_value = EcUtils.replaceTags(previous_value);

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_value);
      out.write("&nbsp;</td>\n");

							}
							else
							{

      out.write("<td valign=\"top\" id=\"linebottomright\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								ArrayList aListStrValues = breakString(previous_value,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}

      out.write("</td>\n");

							}
						}

						if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							present_value = "[N/A]";
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (present_value.startsWith("<?configuration?>"))
						{
							present_value = StringUtils.replace(present_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_value);
      out.write("&nbsp;</td>\n");

						}
						else
						{
							if (present_value.length()<=18)
							{
								present_value = EcUtils.replaceTags(present_value);

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_value);
      out.write("&nbsp;</td>\n");

							}
							else
							{

      out.write("<td valign=\"top\" id=\"linebottomright\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								ArrayList aListStrValues = breakString(present_value,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}

      out.write("</td>\n");

							}
						}
					}
					else
					{
						ArrayList mn = (ArrayList)measure_obj;
						ArrayList prev = (ArrayList)previous_obj;
						ArrayList pres = (ArrayList)present_obj;

      out.write("<td valign=\"top\" width=\"60%\" height=\"100%\" style=\"padding:0px\" colspan=\"3\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" height=\"100%\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

						for (int z=0;z<mn.size();z++)
						{
							String measure = (String)mn.get(z);
							String prevValue = (String)prev.get(z);
							String presValue = (String)pres.get(z);

							if(prevValue == null || prevValue.trim().length() == 0)
							{
								prevValue = "-";
							}
							if(presValue == null || presValue.trim().length() == 0)
							{
								presValue = "-";
							}

							if (!prevValue.startsWith("<?configuration?>"))
							{
								if (EcUtils.isUTF8(prevValue.getBytes()))
								{
									prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
								}
							}
							if (!presValue.startsWith("<?configuration?>"))
							{
								if (EcUtils.isUTF8(presValue.getBytes()))
								{
									presValue = EcUtils.printSkippedBomString(presValue.getBytes());
								}
							}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"33%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure);
      out.write("</td>\n");

							if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
							{
								prevValue = "[N/PV]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								prevValue = "[N/A]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (prevValue.startsWith("<?configuration?>"))
							{
								prevValue = StringUtils.replace(prevValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"33%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(prevValue);
      out.write("&nbsp;</td>\n");

							}
							else
							{
								if (prevValue.length()<=18)
								{
									prevValue = EcUtils.replaceTags(prevValue);

      out.write("<td width=\"33%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(prevValue);
      out.write("&nbsp;</td>\n");

								}
								else
								{

      out.write("<td valign=\"top\" id=\"linebottomright\" width=\"33%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListStrValues = breakString(prevValue,18);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.println(str_value+"<br>");
									}

      out.write("</td>\n");

								}
							}

							if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								presValue = "[N/A]";
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (presValue.startsWith("<?configuration?>"))
							{
								presValue = StringUtils.replace(presValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"33%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(presValue);
      out.write("&nbsp;</td>\n");

							}
							else
							{
								if (presValue.length()<=18)
								{
									presValue = EcUtils.replaceTags(presValue);

      out.write("<td width=\"33%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(presValue);
      out.write("&nbsp;</td>\n");

								}
								else
								{

      out.write("<td valign=\"top\" id=\"linebottomright\" width=\"33%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListStrValues = breakString(presValue,18);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.println(str_value+"<br>");
									}

      out.write("</td>\n");

								}
							}

      out.write("</tr>\n");

						}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n");

					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n");

			}
			else
			{
				//Display changes information-wise(testname)
				//if (ec_option1.equalsIgnoreCase(userOptions[0]))
				//{
					for (int g=0; g<aListComponents.size(); g++)
					{
						String key_component = (String)aListComponents.get(g);
						TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(key_component);

						String component = key_component.substring(0,key_component.lastIndexOf(':'));
						if (component.endsWith(":NULL"))
							component = component.substring(0,component.lastIndexOf(':'));

						String component_type = key_component.substring(key_component.lastIndexOf(':')+1);

      out.write("<table border=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(component);
      out.write(' ');
      out.write('[');
      out.print(mappingInfo.getComponentTypeDescription(component_type));
      out.write("]</b></td>\n\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
							startDateAndTime = (String)timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
							endDateAndTime = (String)timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

						}
						else
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
							startDateAndTime = (String)timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
							endDateAndTime = (String)timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.write("&nbsp;");
      out.print(startDateAndTime);
      out.write("&nbsp;");
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.write("&nbsp;");
      out.print(endDateAndTime);
      out.write("</b>\n");

						}

      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

						TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,selectedHour);
						Iterator changeCountKeys = tmapChanges.keySet().iterator();
						int totalCount=0;
						int maxCount=0;
						ArrayList aList = new ArrayList();
						while (changeCountKeys.hasNext())
						{
							Integer changeCount = (Integer)changeCountKeys.next();
							aList.add(changeCount);
							maxCount=Math.max(maxCount,changeCount.intValue());
						}
						Collections.reverse(aList);

						StringBuffer strBufferTestnames = new StringBuffer();
						StringBuffer strBufferChangeCounts = new StringBuffer();
						ArrayList aListTestnames = new ArrayList();
						ArrayList aListChangeCount = new ArrayList();

						int i_totalChangeCount = 0;
						for (int a=0; a<aList.size(); a++)
						{
							Integer changeCount = (Integer)aList.get(a);
							ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

							aListTestnames.addAll(aListTemp);

							for (int i=0; i<aListTemp.size(); i++)
							{
								aListChangeCount.add(changeCount);
								i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
							}
						}

						//Build graph for TopN items
						boolean topNFlag = false;
						int indexCount = 0;
						if (aListTestnames.size() < topN)
						{
							indexCount = aListTestnames.size();
						}
						else
						{
							indexCount = topN;
							topNFlag = true;
						}

						for (int b=0; b<indexCount; b++)
						{
							String testname = (String)aListTestnames.get(b);
							Integer changeCount = (Integer)aListChangeCount.get(b);
							if (b == 0)
							{
								strBufferTestnames.append(mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(changeCount.intValue());
							}
							else
							{
								strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(","+changeCount.intValue());
							}
							totalCount = totalCount + changeCount.intValue();
						}

						String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
						maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
						String maximumRange = ""+maxCount;

						if (topNFlag)
						{
							titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
						}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" align=\"center\">\n\t\t\t\t\t\t\t<img src=\"../servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range=");
      out.print(maximumRange);
      out.write("&chartTitle=");
      out.print(EgURLEncoder.encode(titleName,"UTF-8"));
      out.write("&sampleValues=");
      out.print(EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8"));
      out.write("&barLabels=");
      out.print(EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8"));
      out.write("&userName=");
      out.print(EgURLEncoder.encode(ec_userName,"UTF-8"));
      out.write("\" border=\"0\" hspace=\"0\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n");

						tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,selectedHour);

						for (int c=0; c<aListTestnames.size(); c++)
						{
							String key_testname = (String)aListTestnames.get(c);
							Integer changeCount = (Integer)aListChangeCount.get(c);
							TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
							Iterator info_keys = temp_tmap_Data.keySet().iterator();

							boolean isDynamicMeasureTest = false;
							String firstKey = (String)temp_tmap_Data.firstKey();
							int idx_M = firstKey.indexOf("~M~");
							if (idx_M != -1)
							{
								isDynamicMeasureTest = true;
							}

							ArrayList aListInfoHeadings = null;
							if (isDynamicMeasureTest)
							{
								aListInfoHeadings = new ArrayList();
								String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
								if (infoHeadings != null && infoHeadings.length() > 0)
								{
									StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
									while (strTokensTemp.hasMoreTokens())
									{
										String str_temp = strTokensTemp.nextToken();
										aListInfoHeadings.add(str_temp);
									}
								}
							}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" style=\"border-bottom-width:0px\" >\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td style=\"padding:3px\" colspan=\"4\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      out.print(mappingInfo.getTestDescription(key_testname));
      out.write("&nbsp;&nbsp;(");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(changeCount);
      out.write(")</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

							boolean heading_flag = false;
							while (info_keys.hasNext())
							{

      out.write("<tr>\n");

								String key_info = (String)info_keys.next();
								if (!heading_flag)
								{
									if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
									{

      out.write("<td width=\"20%\" id=\"linebottomright\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
      out.write("</b></td>\n");

									}

      out.write("<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottom\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n");

									heading_flag = true;
								}

								TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
								Iterator measure_keys = tmap_Data.keySet().iterator();

								boolean newInfoFlag = false;
								int idx_NI = key_info.indexOf("~NEW-INFO~");
								if (idx_NI != -1)
								{
									newInfoFlag = true;
									key_info = key_info.substring(idx_NI+10);
								}

								if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
								{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"5\" id=\"linebottom\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\"  width=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									if (!isDynamicMeasureTest)
									{

      out.write("<b style=\"font-size:7.5pt\">");
      out.print(ecUtils.getInfoForDisplay(key_info));
      out.write("</b>\n");

									}
									else
									{
										ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
										int aListTokensSize = aListTokens.size();
										String strData = "";
										for (int x=0;x<aListTokensSize;x++)
										{
											String infoHeading = (String)aListInfoHeadings.get(x);
											String strTemp = (String)aListTokens.get(x);
											if (x == aListTokensSize-1)
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
											}
											else
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
											}
										}
										out.println(strData);
									}

									if (newInfoFlag)
									{

      out.write("<img src=\"/final/config/images/new_info.gif\" border=\"0\">\n");

									}

      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

								}

								measure_keys = tmap_Data.keySet().iterator();
								while (measure_keys.hasNext())
								{
									String key_measure = (String)measure_keys.next();
									ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);
									boolean measureFlag = false;

									for(int y=0;y<al_data.size();y++)
									{
										ArrayList arraylist_temp = (ArrayList)al_data.get(y);

										String previous_measurevalue = (String)arraylist_temp.get(1);
										String present_measurevalue = (String)arraylist_temp.get(2);

										if (!isDynamicMeasureTest)
										{
											if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase("##R##") && !present_measurevalue.equalsIgnoreCase("##R##"))
											{

      out.write("<tr>\n");

												if (!key_info.equals("+"))
												{

      out.write("<td width=\"20%\" id=\"linebottomright\">&nbsp;</td>\n");

												}

												if (!measureFlag)
												{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("</td>\n");

													measureFlag = true;
												}
												else
												{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\">&nbsp;</td>\n");

												}

												String strDateTime = (String)arraylist_temp.get(0);
												String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
												String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
												String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

												/* Added by Prakash.K starts */
												timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
												startDateAndTime = (String)timeZoneConverter.getDateTime();
												/* Added by Prakash.K ends */

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(startDateAndTime);
      out.write("</td>\n");

												if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.common.Yes"));
      out.write("</td>\n");

												}
												else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.common.No"));
      out.write("</td>\n");

												}
												else
												{
													if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
													{
														previous_measurevalue = "[N/PV]";
													}

													if (previous_measurevalue.startsWith("<?configuration?>"))
													{
														previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

													}
													else
													{
														if (previous_measurevalue.length()<=28)
														{
															previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

														}
														else
														{

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

															ArrayList aListStrValues = breakString(previous_measurevalue,28);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.println(str_value+"<br>");
															}

      out.write("</td>\n");

														}
													}
												}

												if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTextDescription("configmgmt.common.Yes"));
      out.write("</td>\n");

												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTextDescription("configmgmt.common.No"));
      out.write("</td>\n");

												}
												else
												{
													if (present_measurevalue.startsWith("<?configuration?>"))
													{
														present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t");
      out.print(present_measurevalue);
      out.write("&nbsp;\n\t\t\t\t\t\t\t\t\t\t</td>\n");

													}
													else
													{
														if (present_measurevalue.length()<=28)
														{
															present_measurevalue = EcUtils.replaceTags(present_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t");
      out.print(present_measurevalue);
      out.write("&nbsp;\n\t\t\t\t\t\t\t\t\t\t</td>\n");

														}
														else
														{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

															ArrayList aListStrValues = breakString(present_measurevalue,28);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.println(str_value+"<br>");
															}

      out.write("</td>\n");

														}
													}
												}

      out.write("</tr>\n");

											}
										}
										else
										{

      out.write("<tr>\n");

											if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
											{

      out.write("<td width=\"20%\" id=\"linebottomright\">&nbsp;</td>\n");

											}

											boolean newMeasureFlag = false;
											boolean deletedMeasureFlag = false;
											if (!newInfoFlag)
											{
												if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
													previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
													previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													newMeasureFlag = true;
												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													deletedMeasureFlag = true;
												}
											}

											if (newMeasureFlag)
											{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("&nbsp;<img src=\"/final/config/images/new_info.png\" border=\"0\"></td>\n");

											}
											else if (deletedMeasureFlag)
											{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("&nbsp;<img src=\"/final/config/images/removed_info.png\" border=\"0\"></td>\n");

											}
											else
											{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("</td>\n");

											}

											String strDateTime = (String)arraylist_temp.get(0);
											String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
											String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
											String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

											/* Added by Prakash.K starts */
											timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
											startDateAndTime = (String)timeZoneConverter.getDateTime();
											/* Added by Prakash.K ends */

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(startDateAndTime);
      out.write("</td>\n");

											if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
											{
												previous_measurevalue = "[N/PV]";
											}
											else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												previous_measurevalue = "[N/A]";
											}

											if (previous_measurevalue.length()<=28)
											{
												previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

											}
											else
											{

      out.write("<td width=\"20%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

												ArrayList aListStrValues = breakString(previous_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}

      out.write("</td>\n");

											}

											if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												present_measurevalue = "[N/A]";
											}

											if (present_measurevalue.length()<=28)
											{
												present_measurevalue = EcUtils.replaceTags(present_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_measurevalue);
      out.write("&nbsp;</td>\n");

											}
											else
											{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

												ArrayList aListStrValues = breakString(present_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}

      out.write("</td>\n");

											}

      out.write("</tr>\n");

										}
									}
								}
							}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

						}

						if (g < aListComponents.size()-1)
						{

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"15\"></td></tr></table>\n");

						}
					}
				//}
			}
		}
		else
		{

      out.write("<table border=\"0\" align=\"center\" width=\"100%\" id=\"bottomtable\" cellpadding=\"2\" cellspacing=\"0\">\n\t\t\t\t\t<tr>\n");

			if (ec_option1.equalsIgnoreCase(userOptions[2])) //Only for All Components
			{

      out.write("<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+ec_option1));
      out.write("</b></td>\n");

			}
			else if (ec_option1.equalsIgnoreCase(userOptions[1])) //Only for Component Type
			{
				String componentType = ec_option2;

      out.write("<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(mappingInfo.getComponentTypeDescription(componentType));
      out.write("</b></td>\n");

			}
			else if (ec_option1.equalsIgnoreCase(userOptions[0]))
			{
				String key_component = ec_option2;

				String component = key_component.substring(0,key_component.lastIndexOf(':'));
				if (component.endsWith(":NULL"))
				{
					component = component.substring(0,component.lastIndexOf(':'));
				}

				String component_type = key_component.substring(key_component.lastIndexOf(':')+1);

      out.write("<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name"));
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(component);
      out.write(' ');
      out.write('[');
      out.print(mappingInfo.getComponentTypeDescription(component_type));
      out.write("]</b></td>\n");

			}

      out.write("<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

			if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
			{

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.print(s_start_time);
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.print(s_end_time);
      out.write("</b>\n");

			}
			else
			{

      out.write('<');
      out.write('b');
      out.write('>');
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes"));
      out.print(mappingInfo.getTextDescription("configmgmt.common.between"));
      out.print(ec_stdate);
      out.print(sHour);
      out.write(':');
      out.print(sMinute);
      out.print(mappingInfo.getTextDescription("configmgmt.common.and"));
      out.print(ec_enddate);
      out.print(eHour);
      out.write(':');
      out.print(eMinute);
      out.write("</b>\n");

			}

      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"50\"></td></tr></table>\n\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" height=\"100%\" valign=\"top\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" height=\"100%\">\n\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\"  cellspacing=\"0\" cellpadding=\"0\" height=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"center\" height=\"100%\" >\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\"  cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\"> <img src=\"/final/config/images/unavailable-data.gif\" title='");
      if (_jspx_meth_egui_005fintnl_005f28(_jspx_page_context))
        return;
      out.write("'> </td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.changes.detailed.There were no configuration changes in the selected timeline"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

		}

      out.write("</td>\n\t\t</tr>\n");

	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ShowComponentChanges"))
	{
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f29(_jspx_page_context))
        return;
      out.write("&nbsp;:&nbsp;");
      if (_jspx_meth_egui_005fintnl_005f30(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f31(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td>\n");

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
		{

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n");

		}

		String component = ec_component.substring(0,ec_component.lastIndexOf(':'));
		if (component.endsWith(":NULL"))
			component = component.substring(0,component.lastIndexOf(':'));

		String component_type = ec_component.substring(ec_component.lastIndexOf(':')+1);

      out.write("<table border=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f32(_jspx_page_context))
        return;
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(component);
      out.write(' ');
      out.write('[');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f33 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f33.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f33.setParent(null);
      // /config/EcPrintDataReport.jsp(3900,132) name = type type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f33.setType(component_type);
      int _jspx_eval_egui_005fintnl_005f33 = _jspx_th_egui_005fintnl_005f33.doStartTag();
      if (_jspx_th_egui_005fintnl_005f33.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.reuse(_jspx_th_egui_005fintnl_005f33);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.reuse(_jspx_th_egui_005fintnl_005f33);
      out.write("]</b></td>\n\t\t\t\t\t\t<td align=\"right\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

		if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
		{
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
			startDateAndTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
			endDateAndTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f34 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f34.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f34.setParent(null);
      // /config/EcPrintDataReport.jsp(3912,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f34.setText("configmgmt.changes.detailed."+displayNameForChangeType+" changes");
      int _jspx_eval_egui_005fintnl_005f34 = _jspx_th_egui_005fintnl_005f34.doStartTag();
      if (_jspx_th_egui_005fintnl_005f34.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f34);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f34);
      if (_jspx_meth_egui_005fintnl_005f35(_jspx_page_context))
        return;
      out.print(startDateAndTime);
      if (_jspx_meth_egui_005fintnl_005f36(_jspx_page_context))
        return;
      out.print(endDateAndTime);
      out.write("</b>\n");

		}
		else
		{
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
			startDateAndTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
			endDateAndTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */

      out.write('<');
      out.write('b');
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f37 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f37.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f37.setParent(null);
      // /config/EcPrintDataReport.jsp(3924,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f37.setText("configmgmt.changes.detailed."+displayNameForChangeType+" changes");
      int _jspx_eval_egui_005fintnl_005f37 = _jspx_th_egui_005fintnl_005f37.doStartTag();
      if (_jspx_th_egui_005fintnl_005f37.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f37);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f37);
      if (_jspx_meth_egui_005fintnl_005f38(_jspx_page_context))
        return;
      out.print(startDateAndTime);
      if (_jspx_meth_egui_005fintnl_005f39(_jspx_page_context))
        return;
      out.print(endDateAndTime);
      out.write("</b>\n");

		}

      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

		TreeMap tmapChanges = processChangeData.getComponentSummary(ec_component,tmap_changeConfigDetails,selectedDate,selectedHour);
		Iterator changeCountKeys = tmapChanges.keySet().iterator();
		int totalCount=0;
		int maxCount=0;
		ArrayList aList = new ArrayList();
		while (changeCountKeys.hasNext())
		{
			Integer changeCount = (Integer)changeCountKeys.next();
			aList.add(changeCount);
			maxCount=Math.max(maxCount,changeCount.intValue());
		}
		Collections.reverse(aList);

		StringBuffer strBufferTestnames = new StringBuffer();
		StringBuffer strBufferChangeCounts = new StringBuffer();
		ArrayList aListTestnames = new ArrayList();
		ArrayList aListChangeCount = new ArrayList();
		int i_totalChangeCount = 0;

		for (int a=0; a<aList.size(); a++)
		{
			Integer changeCount = (Integer)aList.get(a);
			ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

			aListTestnames.addAll(aListTemp);

			for (int i=0; i<aListTemp.size(); i++)
			{
				aListChangeCount.add(changeCount);
				i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
			}
		}

		//Build graph for TopN items
		boolean topNFlag = false;
		int indexCount = 0;
		if (aListTestnames.size() < topN)
		{
			indexCount = aListTestnames.size();
		}
		else
		{
			indexCount = topN;
			topNFlag = true;
		}

		for (int b=0; b<indexCount; b++)
		{
			String testname = (String)aListTestnames.get(b);
			Integer changeCount = (Integer)aListChangeCount.get(b);
			if (b == 0)
			{
				strBufferTestnames.append(mappingInfo.getTestDescription(testname));
				strBufferChangeCounts.append(changeCount.intValue());
			}
			else
			{
				strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
				strBufferChangeCounts.append(","+changeCount.intValue());
			}
			totalCount = totalCount + changeCount.intValue();
		}

		String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + totalCount;
		maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
		String maximumRange = ""+maxCount;

		if (topNFlag)
		{
			titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
		}

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n\n\t\t\t\t<table border=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" align=\"center\" >\n\t\t\t\t\t\t\t<img src=\"../servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range=");
      out.print(maximumRange);
      out.write("&chartTitle=");
      out.print(EgURLEncoder.encode(titleName,"UTF-8"));
      out.write("&sampleValues=");
      out.print(EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8"));
      out.write("&barLabels=");
      out.print(EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8"));
      out.write("&userName=");
      out.print(EgURLEncoder.encode(ec_userName,"UTF-8"));
      out.write("\" border=\"0\" hspace=\"0\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

		//Display changes information-wise(testname)
		if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byInformation"))
		{
			TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(ec_component);
			tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,selectedHour);
			for (int c=0; c<aListTestnames.size(); c++)
			{
				String key_testname = (String)aListTestnames.get(c);
				Integer changeCount = (Integer)aListChangeCount.get(c);
				TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
				Iterator info_keys = temp_tmap_Data.keySet().iterator();

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\"  id=\"bottomtable\" class=\"body_text\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td id=\"linebottom\" style=\"padding:3px\" colspan=\"4\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f40 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f40.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f40.setParent(null);
      // /config/EcPrintDataReport.jsp(4031,10) name = test type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f40.setTest(key_testname);
      int _jspx_eval_egui_005fintnl_005f40 = _jspx_th_egui_005fintnl_005f40.doStartTag();
      if (_jspx_th_egui_005fintnl_005f40.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f40);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f40);
      out.write("&nbsp;&nbsp;(");
      if (_jspx_meth_egui_005fintnl_005f41(_jspx_page_context))
        return;
      out.write(' ');
      out.write(':');
      out.write(' ');
      out.print(changeCount);
      out.write(")</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

				boolean isDynamicMeasureTest = false;
				String firstKey = (String)temp_tmap_Data.firstKey();
				int idx_M = firstKey.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

				ArrayList aListInfoHeadings = null;
				if (isDynamicMeasureTest)
				{
					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

				boolean heading_flag = false;
				while (info_keys.hasNext())
				{

      out.write("<tr>\n");

					String key_info = (String)info_keys.next();
					if (!heading_flag)
					{
						if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
						{

      out.write("<td width=\"20%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f42(_jspx_page_context))
        return;
      out.write("</b></td>\n");

						}

      out.write("<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f43(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f44(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f45(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottom\" nowrap class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f46(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n");

						heading_flag = true;
					}

					TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
					Iterator measure_keys = tmap_Data.keySet().iterator();

					boolean newInfoFlag = false;
					int idx_NI = key_info.indexOf("~NEW-INFO~");
					if (idx_NI != -1)
					{
						newInfoFlag = true;
						key_info = key_info.substring(idx_NI+10);
					}

					if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
					{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"5\" id=\"linebottom\">\n\t\t\t\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"body_text\"  height=\"18\" width=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"left\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						if (!isDynamicMeasureTest)
						{

      out.write("<b style=\"font-size:7.5pt\">&nbsp;");
      out.print(ecUtils.getInfoForDisplay(key_info));
      out.write("</b>\n");

						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strData = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								}
								else
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								}
							}
							out.println("&nbsp;"+strData);
						}

						if (newInfoFlag)
						{

      out.write("<img src=\"/final/config/images/new_info.gif\" border=\"0\">\n");

						}

      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

					}

					measure_keys = tmap_Data.keySet().iterator();
					while (measure_keys.hasNext())
					{
						String key_measure = (String)measure_keys.next();
						ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);
						boolean measureFlag = false;
						for(int y=0;y<al_data.size();y++)
						{
							ArrayList arraylist_temp = (ArrayList)al_data.get(y);
							String previous_measurevalue = (String)arraylist_temp.get(1);
							String present_measurevalue = (String)arraylist_temp.get(2);

							if (!isDynamicMeasureTest)
							{
								if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase("##R##") && !present_measurevalue.equalsIgnoreCase("##R##"))
								{

      out.write("<tr>\n");

									if (!key_info.equals("+"))
									{

      out.write("<td width=\"20%\" id=\"linebottomright\">&nbsp;</td>\n");

									}

									if (!measureFlag)
									{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("</td>\n");

										measureFlag = true;
									}
									else
									{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\">&nbsp;</td>\n");

									}

									String strDateTime = (String)arraylist_temp.get(0);
									String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
									String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
									String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

									/* Added by Prakash.K starts */
									timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
									startDateAndTime = (String)timeZoneConverter.getDateTime();
									/* Added by Prakash.K ends */

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(startDateAndTime);
      out.write("</td>\n");

									if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
									{

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      if (_jspx_meth_egui_005fintnl_005f47(_jspx_page_context))
        return;
      out.write("</td>\n");

									}
									else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
									{

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      if (_jspx_meth_egui_005fintnl_005f48(_jspx_page_context))
        return;
      out.write("</td>\n");

									}
									else
									{
										if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
										{
											previous_measurevalue = "[N/PV]";
										}

										if (previous_measurevalue.startsWith("<?configuration?>"))
										{
											previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

										}
										else
										{

											if (previous_measurevalue.length()<=28)
											{
												previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

											}
											else
											{

      out.write("<td width=\"20%\" valign=\"top\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

												ArrayList aListStrValues = breakString(previous_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}

      out.write("</td>\n");

											}
										}
									}

									if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
									{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      if (_jspx_meth_egui_005fintnl_005f49(_jspx_page_context))
        return;
      out.write("</td>\n");

									}
									else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
									{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      if (_jspx_meth_egui_005fintnl_005f50(_jspx_page_context))
        return;
      out.write("</td>\n");

									}
									else
									{
										if (present_measurevalue.startsWith("<?configuration?>"))
										{
											present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t");
      out.print(present_measurevalue);
      out.write("&nbsp;\n\t\t\t\t\t\t\t\t\t\t</td>\n");

										}
										else
										{
											if (present_measurevalue.length()<=28)
											{
												present_measurevalue = EcUtils.replaceTags(present_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t");
      out.print(present_measurevalue);
      out.write("&nbsp;\n\t\t\t\t\t\t\t\t\t\t</td>\n");

											}
											else
											{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

												ArrayList aListStrValues = breakString(present_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}

      out.write("</td>\n");

											}
										}
									}

      out.write("</tr>\n");

								}
							}
							else
							{

      out.write("<tr>\n");

								if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
								{

      out.write("<td width=\"20%\" id=\"linebottomright\">&nbsp;</td>\n");

								}

								boolean newMeasureFlag = false;
								boolean deletedMeasureFlag = false;
								if (!newInfoFlag)
								{
									if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
										previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
										previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
									{
										newMeasureFlag = true;
									}
									else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
									{
										deletedMeasureFlag = true;
									}
								}

								if (newMeasureFlag)
								{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("&nbsp;<img src=\"/final/config/images/new_info.png\" border=\"0\"></td>\n");

								}
								else if (deletedMeasureFlag)
								{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("&nbsp;<img src=\"/final/config/images/removed_info.png\" border=\"0\"></td>\n");

								}
								else
								{

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_measure);
      out.write("</td>\n");

								}

								String strDateTime = (String)arraylist_temp.get(0);
								String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
								String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
								String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

								/* Added by Prakash.K starts */
								timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
								startDateAndTime = (String)timeZoneConverter.getDateTime();
								/* Added by Prakash.K ends */

      out.write("<td width=\"20%\" nowrap id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(startDateAndTime);
      out.write("</td>\n");

								if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
								{
									previous_measurevalue = "[N/PV]";
								}
								else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									previous_measurevalue = "[N/A]";
								}

								if (previous_measurevalue.length()<=28)
								{
									previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_measurevalue);
      out.write("&nbsp;</td>\n");

								}
								else
								{

      out.write("<td width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListStrValues = breakString(previous_measurevalue,28);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.print(str_value+"<br>");
									}

      out.write("</td>\n");

								}

								if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									present_measurevalue = "[N/A]";
								}

								if (present_measurevalue.length()<=28)
								{
									present_measurevalue = EcUtils.replaceTags(present_measurevalue);

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_measurevalue);
      out.write("&nbsp;</td>\n");

								}
								else
								{

      out.write("<td width=\"20%\" id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

									ArrayList aListStrValues = breakString(present_measurevalue,28);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.print(str_value+"<br>");
									}

      out.write("</td>\n");

								}

      out.write("</tr>\n");

							}
						}
					}
				}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"20\"></td></tr></table>\n");

			}
		}
		else
		{
			ArrayList aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

			if ((searchCompValue != null && !searchCompValue.equals("")) || 
				(searchTestValue != null && !searchTestValue.equals("")) || 
				(searchDescValue != null && !searchDescValue.equals("")))
			{
				aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,ec_component,searchCompValue,searchTestValue,searchDescValue,userLanguage);
			}
			else
			{
				aListChangesDatewise = processChangeData.getDatewiseChangeDataForComponent(aListChangesDatewise,ec_component,selectedDate,selectedHour);
			}

			if (requestHomePage)
			{
				//Code for restricting the data to the selected date
				aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,selectedHour);
			}

			int aListChangesDatewiseSize = aListChangesDatewise.size();

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

			boolean heading_flag = false;
			for(int i=0; i<aListChangesDatewiseSize; i++)
			{
				ArrayList al = (ArrayList)aListChangesDatewise.get(i);
				if (!heading_flag)
				{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" height=\"20\" width=\"5%\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f51(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" height=\"20\" width=\"15%\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f52(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" height=\"20\" width=\"20%\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f53(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f54(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f55(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" id=\"linebottom\" style=\"padding-left:2px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f56(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n");

					heading_flag = true;
				}

				String strDateTime = (String)al.get(0);
				String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
				String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
				String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

				/* Added by Prakash.K starts */
				timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
				startDateAndTime = (String)timeZoneConverter.getDateTime();
				/* Added by Prakash.K ends */

				String testname = (String)al.get(2);
				String info = (String)al.get(3);
				Object measure_obj = al.get(4);
				Object previous_obj = al.get(5);
				Object present_obj = al.get(6);

				String styleID = "linebottomright";
				String styleIDForPresent = "linebottom";
				if (i == aListChangesDatewiseSize-1)
				{
					styleID = "lineright";
					styleIDForPresent = "line";
				}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" wrap width=\"5%\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(startDateAndTime);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" wrap width=\"15%\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t");
      out.print(mappingInfo.getTestDescription(testname));
      out.write("</td>\n");

				boolean isDynamicMeasureTest = false;
				int idx_M = info.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

				ArrayList aListInfoHeadings = null;
				if (isDynamicMeasureTest)
				{
					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

				boolean newInfoFlag = false;
				if (measure_obj instanceof ArrayList)
				{
					newInfoFlag = true;
				}

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

				if (!isDynamicMeasureTest)
				{
					info = ecUtils.getInfoForDisplay(info);
					if (!info.equals("+"))
					{
						if (info.length()<=29)
						{
							out.println(info);
						}
						else
						{
							ArrayList aListStrValues = breakString(info,29);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								out.println(str_value+"<br>");
							}
						}
					}
					else
					{
						out.println("");
					}
				}
				else
				{
					if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
					{
						out.println("");
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
						out.println(strData);
					}
				}

				if (newInfoFlag)
				{

      out.write("<img src=\"/final/config/images/new_info.gif\" border=\"0\">\n");

				}

      out.write("\n\t\t\t\t\t\t\t\t\t&nbsp;</td>\n");

				if (measure_obj instanceof String)
				{
					String previous_value = (String)previous_obj;
					String present_value = (String)present_obj;

					if(previous_value == null || previous_value.trim().length() == 0)
					{
						previous_value = "-";
					}
					if(present_value == null || present_value.trim().length() == 0)
					{
						present_value = "-";
					}

					if (!previous_value.startsWith("<?configuration?>"))
					{
						if (EcUtils.isUTF8(previous_value.getBytes()))
						{
							previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
						}
					}
					if (!present_value.startsWith("<?configuration?>"))
					{
						if (EcUtils.isUTF8(present_value.getBytes()))
						{
							present_value = EcUtils.printSkippedBomString(present_value.getBytes());
						}
					}

					boolean newMeasureFlag = false;
					boolean deletedMeasureFlag = false;
					if (isDynamicMeasureTest && !newInfoFlag)
					{
						if (previous_value.equalsIgnoreCase("##NEW##") || 
							previous_value.equalsIgnoreCase("##NEW-INFO##") || 
							previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							newMeasureFlag = true;
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							deletedMeasureFlag = true;
						}
					}

					if (newMeasureFlag)
					{

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" wrap style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("<br><img src=\"/final/config/images/new_info.png\" border=\"0\"></td>\n");

					}
					else if (deletedMeasureFlag)
					{

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" wrap style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("<br><img src=\"/final/config/images/removed_info.png\" border=\"0\"></td>\n");

					}
					else
					{

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" wrap style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure_obj);
      out.write("</td>\n");

					}

					if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
					{
						previous_value = "[N/PV]";
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						previous_value = "[N/A]";
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (previous_value.startsWith("<?configuration?>"))
					{
						previous_value = StringUtils.replace(previous_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_value);
      out.write("&nbsp;</td>\n");

					}
					else
					{
						if (previous_value.length()<=29)
						{
							previous_value = EcUtils.replaceTags(previous_value);

      out.write("<td width=\"20%\" id=\"");
      out.print(styleID);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(previous_value);
      out.write("&nbsp;</td>\n");

						}
						else
						{

      out.write("<td width=\"20%\" valign=\"top\" id=\"");
      out.print(styleID);
      out.write("\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							ArrayList aListStrValues = breakString(previous_value,24);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}

      out.write("</td>\n");

						}
					}

					if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						present_value = "[N/A]";
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						present_value = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (present_value.startsWith("<?configuration?>"))
					{
						present_value = StringUtils.replace(present_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"20%\" id=\"");
      out.print(styleIDForPresent);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_value);
      out.write("&nbsp;</td>\n");

					}
					else
					{
						if (present_value.length()<=29)
						{
							present_value = EcUtils.replaceTags(present_value);

      out.write("<td width=\"20%\" id=\"");
      out.print(styleIDForPresent);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(present_value);
      out.write("&nbsp;</td>\n");

						}
						else
						{

      out.write("<td width=\"20%\" valign=\"top\" id=\"");
      out.print(styleIDForPresent);
      out.write("\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							ArrayList aListStrValues = breakString(present_value,24);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}

      out.write("</td>\n");

						}
					}
				}
				else
				{
					ArrayList mn = (ArrayList)measure_obj;
					ArrayList prev = (ArrayList)previous_obj;
					ArrayList pres = (ArrayList)present_obj;

      out.write("<td valign=\"top\" width=\"60%\" height=\"100%\" style=\"padding:0px\" colspan=\"3\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" height=\"100%\" align=\"center\" width=\"100%\" class=\"body_text\">\n");

					for (int z=0;z<mn.size();z++)
					{
						String measure = (String)mn.get(z);
						String prevValue = (String)prev.get(z);
						String presValue = (String)pres.get(z);

						if(prevValue == null || prevValue.trim().length() == 0)
						{
							prevValue = "-";
						}
						if(presValue == null || presValue.trim().length() == 0)
						{
							presValue = "-";
						}

						if (prevValue.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(prevValue.getBytes()))
							{
								prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
							}
						}
						if (presValue.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(presValue.getBytes()))
							{
								presValue = EcUtils.printSkippedBomString(presValue.getBytes());
							}
						}

						String styleIDTemp = "linebottomright";
						String styleIDTempForPresent = "linebottom";
						if ((z == mn.size()-1) && (i == aListChangesDatewiseSize-1))
						{
							styleIDTemp = "lineright";
							styleIDTempForPresent = "line";
						}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"33%\" id=\"");
      out.print(styleIDTemp);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measure);
      out.write("</td>\n");

						if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
						{
							prevValue = "[N/PV]";
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							prevValue = "[N/A]";
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (prevValue.startsWith("<?configuration?>"))
						{
							prevValue = StringUtils.replace(prevValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"33%\" id=\"");
      out.print(styleIDTemp);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(prevValue);
      out.write("&nbsp;</td>\n");

						}
						else
						{
							if (prevValue.length()<=29)
							{
								prevValue = EcUtils.replaceTags(prevValue);

      out.write("<td width=\"33%\" id=\"");
      out.print(styleIDTemp);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(prevValue);
      out.write("&nbsp;</td>\n");

							}
							else
							{

      out.write("<td width=\"33%\" valign=\"top\" id=\"");
      out.print(styleIDTemp);
      out.write("\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								ArrayList aListStrValues = breakString(prevValue,24);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}

      out.write("</td>\n");

							}
						}

						if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							presValue = "[N/A]";
						}
						else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							presValue = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (presValue.startsWith("<?configuration?>"))
						{
							presValue = StringUtils.replace(presValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

      out.write("<td width=\"33%\" id=\"");
      out.print(styleIDTempForPresent);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(presValue);
      out.write("&nbsp;</td>\n");

						}
						else
						{
							if (presValue.length()<=29)
							{
								presValue = EcUtils.replaceTags(presValue);

      out.write("<td width=\"33%\" id=\"");
      out.print(styleIDTempForPresent);
      out.write("\" valign=\"top\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(presValue);
      out.write("&nbsp;</td>\n");

							}
							else
							{

      out.write("<td width=\"33%\" valign=\"top\" id=\"");
      out.print(styleIDTempForPresent);
      out.write("\" style=\"padding-left:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

								ArrayList aListStrValues = breakString(presValue,24);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}

      out.write("</td>\n");

							}
						}

      out.write("</tr>\n");

					}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n");

				}

      out.write("</tr>\n");

			}

      out.write("</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"5\"></td></tr></table>\n");

		}

      out.write("</td>\n\t\t</tr>\n");

	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Search"))
	{
		ArrayList aListSearchDetails = (ArrayList)session.getAttribute("SEARCH_DATA");
		ArrayList aListQueryDisplayValues = (ArrayList)session.getAttribute("INTNL_QUERIES");

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f57(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td>\n");

		if (aListSearchDetails != null)
		{

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"6\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"0\"></td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"6\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"0\"></td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

			for (int i=0; i<aListSearchDetails.size(); i++)
			{
				ArrayList aList = (ArrayList)aListSearchDetails.get(i);

				//String aListQuery = (String)aList.get(0);
				String aListQuery = (String)aListQueryDisplayValues.get(i);
				ArrayList aListColumnHeading = (ArrayList)aList.get(1);
				ArrayList aListData = (ArrayList)aList.get(2);

				int count = aListColumnHeading.size();

				String[] userOption = getValues(aListQuery,"|");
				String[] searchOption1 = getValues(userOption[0],":");
				List list = getParameters(userOption[1],"#");
				StringBuffer strBuffer = new StringBuffer();
				for (int y=0; y<list.size(); y++)
				{
					String tmpStr = (String)list.get(y);
					if (tmpStr.startsWith("Networkadapter=") && tmpStr.indexOf("@@@") > 0)
					{
						String strId = tmpStr.substring(tmpStr.indexOf("@@@")+3);
						tmpStr = tmpStr.substring(0,tmpStr.indexOf("@@@"));
						if (!strId.equals("-"))
						{
							tmpStr += " {"+strId+"}";
						}
					}
					strBuffer.append(tmpStr+", ");
				}
				String searchCondition = strBuffer.substring(0,strBuffer.length()-2);

      out.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"99%\" id=\"bottomtable\" class=\"body_text\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td id=\"linebottom\" height=\"24\" colspan=\"");
      out.print(((count == 0)?"1":""+(count-1)));
      out.write("\" style=\"padding-left:6px;padding-top:2px;padding-bottom:2px;padding-right:2px\"  class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f58(_jspx_page_context))
        return;
      out.write('=');
      out.print(searchOption1[0]);
      out.write(',');
      out.write(' ');
      if (_jspx_meth_egui_005fintnl_005f59(_jspx_page_context))
        return;
      out.write('=');
      out.print(searchOption1[1]);
      out.write(',');
      out.write(' ');
      out.print(searchCondition);
      out.write("</td>\n\t\t\t\t\t</tr>\n");

				if (count == 0)
				{

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"center\" id=\"linebottom\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f60(_jspx_page_context))
        return;
      out.write("</b>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

				}
				else
				{
					ArrayList a = (ArrayList)aListData.get(0);
					String strInfo = (String)a.get(0);

      out.write("<tr>\n");

					for (int j=1; j<aListColumnHeading.size(); j++)
					{
						if (j == aListColumnHeading.size()-1)
						{

      out.write("<td align=\"left\" id=\"linebottom\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}
						else
						{

      out.write("<td align=\"left\" id=\"linebottomright\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}

      out.write("\n\t\t\t\t\t\t\t&nbsp;<b>");
      out.print((String)aListColumnHeading.get(j));
      out.write("</b>\n\t\t\t\t\t\t</td>\n");

					}

      out.write("</tr>\n");

					boolean displayFlag = false;
					String oldInfo = "";

					for (int x=0; x<aListData.size(); x++)
					{
						ArrayList aListTemp = (ArrayList)aListData.get(x);
						String info = (String)aListTemp.get(0);
						String system = (String)aListTemp.get(1);
						String ip = (String)aListTemp.get(2);
						ArrayList aListValues = (ArrayList)aListTemp.get(3);

						if (!info.equals("+"))
						{
							if (!oldInfo.equalsIgnoreCase(info) && !oldInfo.equalsIgnoreCase(""))
								displayFlag = false;

							if (!displayFlag)
							{
								String strColHead = (String)aListColumnHeading.get(0);
								String tmpInfo = info;
								if (strColHead.equalsIgnoreCase("Network Adapter"))
								{
									if (tmpInfo.indexOf("@@@") > 0)
									{
										String tmpId = strInfo.substring(tmpInfo.indexOf("@@@")+3);
										tmpInfo = strInfo.substring(0,tmpInfo.indexOf("@@@"));
										if (!tmpId.equals("-"))
										{
											tmpInfo += " {"+tmpId+"}";
										}
									}
								}

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"left\" id=\"linebottom\" height=\"20\" colspan=\"");
      out.print(count-1);
      out.write("\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t&nbsp;<b>");
      out.print((String)aListColumnHeading.get(0));
      out.write("</b>: ");
      out.print(tmpInfo);
      out.write("</td>\n\t\t\t\t\t</tr>\n");

								displayFlag = true;
							}

							oldInfo = info;
						}

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"left\" id=\"linebottomright\" valign=\"top\" height=\"20\" wrap class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(system);
      out.write("</td>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<td align=\"left\" id=\"linebottomright\" height=\"20\" valign=\"top\" wrap class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(ip);
      out.write("</td>\n\n");

						for (int k=0; k<aListValues.size(); k++)
						{
							String value = (String)aListValues.get(k);

							int m = value.indexOf('=');
							if (m != -1)
								value = value.substring(m+1,value.length());
					
							value = decodeString(value);

							/* Added by Prakash.K for TimeZone - Starts*/
							boolean isDate = DateUtil.validDate(value,currentDateFormat);
							if (isDate)
							{
								int idx_colon = value.indexOf(':');
								if (idx_colon != -1)
								{
									if (value.indexOf("AM") != -1 || value.indexOf("PM") != -1)
									{
										boolean isPM = (value.substring(value.lastIndexOf(" ")+1)).equalsIgnoreCase("PM");

										value = value.substring(0,value.lastIndexOf(" "));
										String timeDate = value.substring(0,value.lastIndexOf(" "));
										String timeVal  = value.substring(value.lastIndexOf(" ")+1);

										String timeHour = null;
										String timeMin = null;
										String timeSec = null;

										ArrayList aListTokens = StringUtils.egTokenizer(timeVal,":");
										if (aListTokens != null)
										{
											timeHour = (String)aListTokens.get(0);
											timeMin = (String)aListTokens.get(1);
											timeSec = (String)aListTokens.get(2);
										}

										if (isPM)
										{
											int timeHourInt = Integer.parseInt(timeHour) + 12;
											timeHour = Integer.toString(timeHourInt);
										}

										timeVal = timeHour + ":" + timeMin + ":" + timeSec;
										value = timeDate + " " + timeVal;
									}

									timeZoneConverter = new EgTimeZoneConverter(value,user);
									value = (String)timeZoneConverter.getDateTime();
								}
								else
								{
									value = DateUtil.changeDateFormat(value,currentDateFormat,userDateFormat);
								}
							}
							/* Added by Prakash.K for TimeZone - Ends*/

							if (k == aListValues.size()-1)
							{

      out.write("<td align=\"left\" id=\"linebottom\" valign=\"top\" height=\"20\" wrap class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;\n");

							}
							else
							{

      out.write("<td align=\"left\" id=\"linebottomright\" valign=\"top\" height=\"20\" wrap class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;\n");

							}

							if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								out.println(mappingInfo.getTextDescription("configmgmt.common.Yes"));
							}
							else
							{
								out.println(value);
							}

      out.write("</td>\n");

						}

      out.write("</tr>\n");

					}
				}

      out.write("</table>\n\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"20\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"0\"></td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

			}
		}

      out.write("</td>\n\t\t</tr>\n");

	}
	else if(request.getParameter("selection_check")!=null && request.getParameter("selection_check").equalsIgnoreCase("System"))
	{
		String system = request.getParameter("systemName");

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f61(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}
		else
		{

      out.write("<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"10\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

		if (system != null && system.length() > 0 && !system.equalsIgnoreCase("All"))
		{

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table align=\"center\" width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" id=\"bottomtable\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" nowrap align=\"center\" height=\"24\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t<b>");
      if (_jspx_meth_egui_005fintnl_005f62(_jspx_page_context))
        return;
      out.write("</b> : ");
      out.print(request.getParameter("ec_system"));
      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t<tr>\n");

		}

      out.write("<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"10\">\n\t\t\t</td>\n\t\t</tr>\n");

		if(system!=null && system.length()>0)
		{
			if (system.equalsIgnoreCase("All"))
			{
				ArrayList aListTestnames = null;
				TreeMap testMeasureMapping = null;
				int measureCount = 0;
				TreeMap tmapSystemInformationDetails = null;
				if (requestFrom != null && requestFrom.equals("Schedule"))
				{
					aListTestnames = (ArrayList)request.getAttribute("Testnames");
					testMeasureMapping = (TreeMap)request.getAttribute("TestMeasureMap");
					measureCount = ((Integer)request.getAttribute("measureCount")).intValue();
					tmapSystemInformationDetails = (TreeMap)request.getAttribute("SystemInformationDetails");
				}
				else
				{
					aListTestnames = (ArrayList)session.getAttribute("Testnames");
					testMeasureMapping = (TreeMap)session.getAttribute("TestMeasureMap");
					measureCount = ((Integer)session.getAttribute("measureCount")).intValue();
					tmapSystemInformationDetails = (TreeMap)session.getAttribute("SystemInformationDetails");
				}

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" class=\"body_text\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"");
      out.print(measureCount+1);
      out.write("\" height=\"20\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f63(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"20\" id=\"linebottomright\" style=\"text-align:center\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f64(_jspx_page_context))
        return;
      out.write("<b></td>\n");

				int tempCount = 0;
				for (int k=0; k<aListTestnames.size(); k++)
				{
					String testname = (String)aListTestnames.get(k);
					ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
					for (int m=0; m<aListMeasures.size(); m++)
					{
						String measure = (String)aListMeasures.get(m);
						tempCount++;
						if (tempCount == measureCount)
						{

      out.write("<td height=\"20\" id=\"linebottom\" style=\"text-align:center\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}
						else
						{

      out.write("<td height=\"20\" id=\"linebottomright\" style=\"text-align:center\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

						}

      out.write('<');
      out.write('b');
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f65 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f65.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f65.setParent(null);
      // /config/EcPrintDataReport.jsp(5369,10) name = measure type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f65.setMeasure(testname+":"+measure);
      int _jspx_eval_egui_005fintnl_005f65 = _jspx_th_egui_005fintnl_005f65.doStartTag();
      if (_jspx_th_egui_005fintnl_005f65.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f65);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005fmeasure_005fnobody.reuse(_jspx_th_egui_005fintnl_005f65);
      out.write("</b>\n\t\t\t\t\t\t</td>\n");

					}
				}

      out.write("</tr>\n");

				Iterator system_keys = tmapSystemInformationDetails.keySet().iterator();
				while (system_keys.hasNext())
				{

      out.write("<tr>\n");

					String key_system = (String)system_keys.next();

      out.write("<td id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(key_system);
      out.write("</td>\n");

					tempCount = 0;
					TreeMap tmapTestDetails = (TreeMap)tmapSystemInformationDetails.get(key_system);
					for (int i=0; i<aListTestnames.size(); i++)
					{
						String testname = (String)aListTestnames.get(i);
						ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
						TreeMap tmapMeasureDetails = (TreeMap)tmapTestDetails.get(testname);
						if (tmapMeasureDetails == null)
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								tempCount++;
								if (tempCount == measureCount)
								{

      out.write("<td id=\"linebottom\" style=\"text-align:center\" valign=\"top\">&nbsp;-&nbsp;</td>\n");

								}
								else
								{

      out.write("<td id=\"linebottomright\" style=\"text-align:center\" valign=\"top\">&nbsp;-&nbsp;</td>\n");

								}
							}
						}
						else
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								String measure = (String)aListMeasures.get(j);
								ArrayList aListMeasureValue = (ArrayList)tmapMeasureDetails.get(measure);
								String measureValue = "-";
								if (aListMeasureValue != null)
								{
									if (testname.equalsIgnoreCase("DiskCapacity_cf") && measure.equalsIgnoreCase("Capacity"))
									{
										int i_size = aListMeasureValue.size()-1;
										measureValue = (String)aListMeasureValue.get(i_size);
									}
									else
									{
										measureValue = aListMeasureValue.toString();
										measureValue = measureValue.substring(1,measureValue.length()-1);
									}
								}
								tempCount++;
								if (tempCount == measureCount)
								{

      out.write("<td id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measureValue);
      out.write("</td>\n");

								}
								else
								{

      out.write("<td id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(measureValue);
      out.write("</td>\n");

								}
							}
						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

			}
			else
			{
				Map systemData = new TreeMap();
				Map commonInformation = new TreeMap();
				ArrayList systemDetailData = new ArrayList();
				if (requestFrom != null && requestFrom.equals("Schedule"))
				{
					systemDetailData = (ArrayList)request.getAttribute("SpecificData");
					commonInformation = (TreeMap)request.getAttribute("CommonData");
				}
				else
				{
					systemDetailData = (ArrayList)session.getAttribute("SpecificData");
					commonInformation = (TreeMap)session.getAttribute("CommonData");
				}

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"99%\" class=\"body_text\" id=\"bottomtable\">\n");

				if (systemDetailData!= null && systemDetailData.size()>0)
				{

      out.write("<tr>\n\t\t\t\t\t\t<td colspan=\"3\" height=\"20\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f66(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(system);
      out.write("</b></td>\n\t\t\t\t\t</tr>\n");

					int count = systemDetailData.size();
					int j=0;
					if (count <=3)
					{
						count = 3;
					}
					else if(count % 3 != 0)
					{
						count = count+3 - count % 3;
					}

					for (j=0; (j<systemDetailData.size() || j < count); j++)
					{
						if (j%3 == 0)
						{

      out.write("<tr>\n");

						}
						if ( j <systemDetailData.size())
						{
							String componentName=(String)systemDetailData.get(j);
							StringTokenizer st=new StringTokenizer(componentName,":");
							String subNickName=st.nextToken();
							String displayName="";
							String port=st.nextToken();
							if(componentName.endsWith("Oracle_server"))
								port+=":"+st.nextToken();
							String type=st.nextToken();

							//String port=cName.substring(cName.lastIndexOf(':')+1);
							if(!port.equalsIgnoreCase("NULL"))
								displayName=subNickName+":"+port;
							else
								displayName=subNickName;

							String compType = mappingInfo.getComponentTypeDescription(type);

							String strComp = displayName+":"+compType;

							if (j%3 == 2)
							{

      out.write("<td width=\"30%\" id=\"line\" height=\"20\" style=\"padding-left:4px;padding-right:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}
							else
							{

      out.write("<td width=\"30%\" id=\"lineright\" height=\"20\" style=\"padding-left:4px;padding-right:4px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.write('\n');

							}

      out.print(strComp);
      out.write("</td>\n");

						}
						else
						{
							if (j%3 == 2)
							{

      out.write("<td width=\"30%\" height=\"20\">&nbsp;</td>\n");

							}
							else
							{

      out.write("<td width=\"30%\" id=\"lineright\" height=\"20\">&nbsp;</td>\n");

							}
						}

						if (j%3 == 2)
						{

      out.write("</tr>\n");

						}
					}
				}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n\n\t\t<tr><td height=\"5\"><img src=\"/final/config/images/spacer.gif\"  border=\"0\"></td></tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\" width=\"100%\">\n");

				if (commonInformation!=null && commonInformation.size()>0)
				{
					ArrayList details=null;
					String serverName="";
					int count=0;
					String boxName=system+":NULL:Win_generic_server";
					ArrayList alist=new ArrayList();

					Iterator iterat = commonInformation.keySet().iterator();
					while(iterat.hasNext())
					{
						String svalue=(String)iterat.next();
						details=(ArrayList)commonInformation.get(svalue);
						if(details==null || details.size()==0)
							continue;
						alist.add(svalue);
					}
					details=new ArrayList();

					ArrayList comDetails=(ArrayList)commonInformation.get(boxName);
					if (comDetails==null)
					{
						boxName=system+":NULL:Generic_server";
						details=(ArrayList)commonInformation.get(boxName);
						if(details==null || details.size()==0)
						{
							if(alist!=null && alist.size()>0)
							{
								boxName=(String)alist.get(0);
								details=(ArrayList)commonInformation.get(boxName);
							}
						}
					}
					else
						details=comDetails;

					//commonInformation.remove(boxName);
					int loopCount=commonInformation.size();

					Iterator iteration = commonInformation.keySet().iterator();
					do
					{
						if(count==0)
						{
							serverName=boxName;
						}
						else
						{
							serverName=(String)iteration.next();
							details=(ArrayList)commonInformation.get(serverName);
						}

						if (details==null || details.size()==0)
							continue;

						ArrayList title= (ArrayList)details.get(0);

      out.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\"><tr><td><img src=\"/final/config/images/spacer.gif\" height=\"10\" border=\"0\"></td></tr></table>\n\n\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"body_text\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"body_text\" >\n\n\t\t\t\t\t\t\t\t<!-- <tr><td colspan=\"3\" bgColor=\"white\"><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td><img src=\"/final/config/images/spacer.gif\" height=\"5\"></td></tr></table></td></tr> -->\n\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"20%\" height=\"20\" align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t&nbsp;&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f67(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(system);
      out.write("</b>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t<td style=\"background-color:#ffffff\" width=\"3%\" align=\"left\"><!-- <img src=\"/final/config/images/cell_corner_dark.gif\"> --></td>\n\t\t\t\t\t\t\t\t\t<td align=\"left\" style=\"background-color:#ffffff\" width=\"50%\">&nbsp;\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

						for(int m=1;m<details.size();m++)
						{
							if (m >= 2) continue;
							ArrayList testWiseInfo = (ArrayList)details.get(m); 

							ArrayList testName = (ArrayList)testWiseInfo.get(0);
							ArrayList flag= (ArrayList)testWiseInfo.get(1);
							ArrayList columnNames = (ArrayList)testWiseInfo.get(2);
							TreeMap data = (TreeMap)testWiseInfo.get(3);
			
							ArrayList flagRow = (ArrayList)flag.get(0);
							ArrayList flagColumn = (ArrayList)flag.get(1);

							int columnCount = columnNames.size();

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t<!-- <table cellspacing=\"0\"  align=\"center\"cellpadding=\"0\" border=\"0\"><tr><td colspan=\"2\" height=\"3\"><img src=\"/final/config/images/spacer.gif\" height=\"5\"></td></tr></table> -->\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t<table width=\"99%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" id=\"bottomtable\" style=\"border-bottom-width:0px; border-right-width:0px\">\n");

							if(count!=0)
							{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"2\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>&nbsp;");
      out.print(testName.get(0));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n");

							}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"100%\" >\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" class=\"body_text\">\n");

							Iterator iterate =data.keySet().iterator();
							boolean colHeading_flag = false;
							int f = 0;
							while(iterate.hasNext())
							{
								String info = (String)iterate.next();
								ArrayList infoDetails = (ArrayList)data.get(info);
								if (info.equals("+"))//Show row-wise data - Non-Info based - Don't show Descriptor
								{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"100%\" style=\"padding:0px\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" cellspacing=\"0\" cellpadding=\"2\" class=\"body_text\" width=\"100%\">\n");

									for(int x=1;x<columnCount;x++)
									{
										String flagValue = (String)flagColumn.get(x);
										if (flagValue.equals("true"))
										{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" width=\"50%\" height=\"20\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print((String)columnNames.get(x));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" height=\"20\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(infoDetails.get(x-1));
      out.write("</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

										}
									}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

								}
								else //Info-Based
								{
									if (columnCount <=5) //Column-wise
									{
										if (!colHeading_flag)
										{

      out.write("<tr>\n");

											for(int n=0;n<columnCount;n++)
											{
												String flagValue = (String)flagColumn.get(n);
												if(flagValue!=null && flagValue.equals("true"))
												{
													if (columnCount == 2)
													{

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

													}
													else if (columnCount == 3)
													{

      out.write("<td id=\"linebottomright\" width=\"33%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

													}
													else if (columnCount == 4)
													{

      out.write("<td id=\"linebottomright\" width=\"25%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

													}
													else if (columnCount == 5)
													{

      out.write("<td id=\"linebottomright\" width=\"20%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print((String)columnNames.get(n));
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n");

													}
												}
											}

      out.write("</tr>\n");

											colHeading_flag = true;
										}

										String flagValue = (String)flagRow.get(f);
										if (flagValue.equals("true"))
										{
											if (info.indexOf('>') != -1) //Present... Tree form
												info = info.substring(info.lastIndexOf('>')+1);

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(info.trim());
      out.write("</td>\n");

											for(int z=0;z<columnCount-1;z++)
											{
												String displayName= (String)flagColumn.get(z+1);
												if (displayName.equals("true"))
												{
													String value = (String)infoDetails.get(z);
													if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
													{

      out.write("<td id=\"linebottomright\" wrap class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      if (_jspx_meth_egui_005fintnl_005f68(_jspx_page_context))
        return;
      out.write("</td>\n");

													}
													else
													{

      out.write("<td id=\"linebottomright\" wrap class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(value);
      out.write("&nbsp;</td>\n");

													}
												}
											}
										}

      out.write("</tr>\n");

									}
									else
									{
										//Row-wise
										String flagValue = (String)flagRow.get(f);
										if (flagValue.equals("true"))
										{
											if (info.indexOf('>') != -1) //Present... Tree form
												info = info.substring(info.lastIndexOf('>')+1);

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td  height=\"20\" colspan=\"2\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<b>");
      out.print(info.trim());
      out.write("</b>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td width=\"100%\" style=\"padding:0px\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" align=\"center\" cellpadding=\"2\" class=\"body_text\" width=\"100%\">\n");

											for(int p=1;p<columnCount;p++)
											{
												flagValue = (String)flagColumn.get(p);
												if (flagValue.equals("true"))
												{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write("\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
      out.print((String)columnNames.get(p));
      out.write("</td>\n");

													String value = (String)infoDetails.get(p-1);
													if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
													{

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      if (_jspx_meth_egui_005fintnl_005f69(_jspx_page_context))
        return;
      out.write("&nbsp;</td>\n");

													}
													else
													{

      out.write("<td id=\"linebottomright\" width=\"50%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(value);
      out.write("&nbsp;</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

													}
												}
											}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n");

										}
									}
								}
								f++;
							}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td colspan=\"2\"><img src=\"/final/config/images/spacer.gif\" height=\"5\"></td>\n\t\t\t\t\t</tr>\n");

						}

      out.write("</table>\n");

						count++;
					}
					while (false);
				}

      out.write("</td>\n\t\t</tr>\n");

			}
		}
	}   // end-if system information
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentType"))
	{
		String totalChanges = "";
		ArrayList aListChangedComponentTypes = null;
		ArrayList aListChangeCount = null;
		TreeMap tmapFinal = null;
		String startDateTime = "";
		String endDateTime = "";
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			totalChanges = (String)request.getAttribute("TOTAL_CHANGES");
			aListChangedComponentTypes = (ArrayList)request.getAttribute("CHANGED_COMPONENT_TYPES");
			aListChangeCount = (ArrayList)request.getAttribute("CHANGED_COMPONENT_TYPES_CHANGE_COUNT");
			tmapFinal = (TreeMap)request.getAttribute("CHANGED_COMPONENTS_UNDER_EACH_COMPONENT_TYPE");
			startDateTime = (String)request.getAttribute("START_DATETIME");
			endDateTime = (String)request.getAttribute("END_DATETIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */	
		}
		else
		{
			totalChanges = (String)session.getAttribute("TOTAL_CHANGES");
			aListChangedComponentTypes = (ArrayList)session.getAttribute("CHANGED_COMPONENT_TYPES");
			aListChangeCount = (ArrayList)session.getAttribute("CHANGED_COMPONENT_TYPES_CHANGE_COUNT");
			tmapFinal = (TreeMap)session.getAttribute("CHANGED_COMPONENTS_UNDER_EACH_COMPONENT_TYPE");
			startDateTime = (String)session.getAttribute("START_DATETIME");
			endDateTime = (String)session.getAttribute("END_DATETIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
		}
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f70(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}
		if (aListChangedComponentTypes != null && !aListChangedComponentTypes.isEmpty())
		{

      out.write("<tr><td align=\"center\"><table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" class=\"body_text\"><tr><td height=\"10\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"1\"></td></tr></table></td></tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"20\" align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f71(_jspx_page_context))
        return;
      out.write("&nbsp;:&nbsp;");
      out.print(totalChanges);
      out.write("</b></td>\n\t\t\t\t\t\t<td height=\"20\" align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f72(_jspx_page_context))
        return;
      out.write("</b>&nbsp;<b>");
      out.print(startDateTime);
      out.write("</b>&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f73(_jspx_page_context))
        return;
      out.write("</b>&nbsp;<b>");
      out.print(endDateTime);
      out.write("</b>&nbsp;&nbsp;</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"20%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f74(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"7%\" id=\"linebottomright\" align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f75(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"73%\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f76(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t</tr>\n");

			for (int g=0; g<aListChangedComponentTypes.size(); g++)
			{
				String componentType = (String)aListChangedComponentTypes.get(g);
				Integer changes = (Integer)aListChangeCount.get(g);

      out.write("<tr>\n\t\t\t\t\t\t<td colspan=\"3\" valign=\"top\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"2\" align=\"center\" border=\"0\" width=\"100%\" id=\"body_text\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td nowrap width=\"20%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f77 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f77.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f77.setParent(null);
      // /config/EcPrintDataReport.jsp(5995,95) name = type type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f77.setType(componentType);
      int _jspx_eval_egui_005fintnl_005f77 = _jspx_th_egui_005fintnl_005f77.doStartTag();
      if (_jspx_th_egui_005fintnl_005f77.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.reuse(_jspx_th_egui_005fintnl_005f77);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftype_005fnobody.reuse(_jspx_th_egui_005fintnl_005f77);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"7%\" align=\"center\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(changes);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"73%\" align=\"left\" valign=\"top\" style=\"padding:0px\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" class=\"body_text\">\n");

				ArrayList aListChangedComponents = (ArrayList)tmapFinal.get(componentType);
				int size = aListChangedComponents.size();
				for (int d=size-1; d>=0; d=d-2)
				{

      out.write("<tr>\n");

					for (int e=d; e>d-2; e--)
					{
						if (e >= 0)
						{
							String component = (String)aListChangedComponents.get(e);
							String componentName = component.substring(0,component.lastIndexOf(":"));
							String strCount = component.substring(component.indexOf("@")+1);
							if (componentName.endsWith(":NULL"))
							{
								componentName= componentName.substring(0,componentName.lastIndexOf(':'));
							}

							//String tmpStr = componentName;
							//int displayLength = 19;
							//String strCName = StringUtils.egSubString(tmpStr,displayLength);

							if (e == d-2+1)
							{

      out.write("<td id=\"linebottom\" width=\"50%\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(componentName);
      out.write(' ');
      out.write('[');
      out.print(strCount);
      out.write("]</td>\n");

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"50%\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;");
      out.print(componentName);
      out.write(' ');
      out.write('[');
      out.print(strCount);
      out.write("]</td>\n");

							}
						}
						else
						{
							if (e == d-2+1)
							{

      out.write("<td id=\"linebottom\" width=\"50%\" valign=\"top\">&nbsp;</td>\n");

							}
							else
							{

      out.write("<td id=\"linebottomright\" width=\"50%\" valign=\"top\">&nbsp;</td>\n");

							}
						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

			}
		}
		else
		{

      out.write("<tr>\n\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"50\"></td></tr></table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" height=\"100%\" valign=\"top\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td width=\"100%\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\"><img src=\"/final/config/images/unavailable-data.gif\"></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n");
      out.write("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.common.There were no configuration changes in the selected timeline"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

		}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentName"))
	{
		String totalChanges = "";
		ArrayList aListChangeCount = null;
		TreeMap tmapTemp = null;
		TreeMap tmapChangedTestnames = null;
		String startDateTime = "";
		String endDateTime = "";
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			totalChanges = (String)request.getAttribute("TOTAL_CHANGES_COUNT");
			aListChangeCount = (ArrayList)request.getAttribute("CHANGED_COMPONENT_NAMES_CHANGE_COUNT");
			tmapTemp = (TreeMap)request.getAttribute("CHANGED_COMPONENT_NAMES");
			tmapChangedTestnames = (TreeMap)request.getAttribute("CHANGED_TESTNAMES_UNDER_EACH_COMPONENT_NAME");
			startDateTime = (String)request.getAttribute("START_DATE_TIME");
			endDateTime = (String)request.getAttribute("END_DATE_TIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */		
		}
		else
		{
			totalChanges = (String)session.getAttribute("TOTAL_CHANGES_COUNT");
			aListChangeCount = (ArrayList)session.getAttribute("CHANGED_COMPONENT_NAMES_CHANGE_COUNT");
			tmapTemp = (TreeMap)session.getAttribute("CHANGED_COMPONENT_NAMES");
			tmapChangedTestnames = (TreeMap)session.getAttribute("CHANGED_TESTNAMES_UNDER_EACH_COMPONENT_NAME");
			startDateTime = (String)session.getAttribute("START_DATE_TIME");
			endDateTime = (String)session.getAttribute("END_DATE_TIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f78(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}
		if (aListChangeCount != null && !aListChangeCount.isEmpty())
		{

      out.write("<tr><td align=\"center\"><table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" class=\"body_text\"><tr><td height=\"10\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"1\"></td></tr></table></td></tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"20\" align=\"left\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f79(_jspx_page_context))
        return;
      out.write("&nbsp;:&nbsp;");
      out.print(totalChanges);
      out.write("</b></td>\n\t\t\t\t\t\t<td height=\"20\" align=\"right\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f80(_jspx_page_context))
        return;
      out.write("</b>&nbsp;<b>");
      out.print(startDateTime);
      out.write("</b>&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f81(_jspx_page_context))
        return;
      out.write("</b>&nbsp;<b>");
      out.print(endDateTime);
      out.write("</b>&nbsp;&nbsp;</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"33%\" id=\"linebottomright\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f82(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"7%\" id=\"linebottomright\" align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f83(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t\t<td width=\"60%\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f84(_jspx_page_context))
        return;
      out.write("</b></td>\n\t\t\t\t\t</tr>\n");

			for (int i=0; i<aListChangeCount.size(); i++)
			{
				Integer changeCount = (Integer)aListChangeCount.get(i);

				ArrayList aListComponentsTemp = (ArrayList)tmapTemp.get(changeCount);
				Collections.sort(aListComponentsTemp);

				for (int j=0; j<aListComponentsTemp.size(); j++)
				{
					String component = (String)aListComponentsTemp.get(j);

					String temp1 = component.substring(0,component.lastIndexOf(":"));
					if (temp1.endsWith(":NULL"))
						temp1 = temp1.substring(0,temp1.indexOf(":"));
					String temp2 = component.substring(component.lastIndexOf(":")+1);
					temp2 = mappingInfo.getComponentTypeDescription(temp2);
					temp1 = temp1 + ":"+ temp2;

					ArrayList aListTestnames = (ArrayList)tmapChangedTestnames.get(component);

					//String tmpStr = temp1;
					//int displayLength = 28;
					//String strCName = StringUtils.egSubString(tmpStr,displayLength);

      out.write("<tr>\n\t\t\t\t\t\t<td colspan=\"3\" valign=\"top\" style=\"padding:0px\">\n\t\t\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"4\" align=\"center\" border=\"0\" width=\"100%\" id=\"body_text\" style=\"table-layout:fixed\"><col width=\"33%\"><col width=\"7%\"><col width=\"60%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td wrap width=\"33%\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(temp1);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"7%\" align=\"center\" id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(changeCount);
      out.write("</td>\n\t\t\t\t\t\t\t\t\t<td width=\"60%\" align=\"left\" valign=\"top\" style=\"padding:0px\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"4\" class=\"body_text\" height=\"100%\">\n");

					int size = aListTestnames.size();
					for (int d=0; d<size; d=d+3)
					{

      out.write("<tr>\n");

						for (int e=d; e<d+3; e++)
						{
							if (e < size)
							{
								String testname = (String)aListTestnames.get(e);

								if (e == d+3-1)
								{

      out.write("<td id=\"linebottom\" width=\"33%\" valign=\"top\" height=\"100%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f85 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f85.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f85.setParent(null);
      // /config/EcPrintDataReport.jsp(6251,94) name = test type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f85.setTest(testname);
      int _jspx_eval_egui_005fintnl_005f85 = _jspx_th_egui_005fintnl_005f85.doStartTag();
      if (_jspx_th_egui_005fintnl_005f85.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f85);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f85);
      out.write("</td>\n");

								}
								else
								{

      out.write("<td id=\"linebottomright\" width=\"33%\" valign=\"top\" height=\"100%\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      //  egui:intnl
      com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f86 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.get(com.egurkha.tags.Intnl.class);
      _jspx_th_egui_005fintnl_005f86.setPageContext(_jspx_page_context);
      _jspx_th_egui_005fintnl_005f86.setParent(null);
      // /config/EcPrintDataReport.jsp(6257,99) name = test type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_egui_005fintnl_005f86.setTest(testname);
      int _jspx_eval_egui_005fintnl_005f86 = _jspx_th_egui_005fintnl_005f86.doStartTag();
      if (_jspx_th_egui_005fintnl_005f86.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
        _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f86);
        return;
      }
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftest_005fnobody.reuse(_jspx_th_egui_005fintnl_005f86);
      out.write("</td>\n");

								}
							}
							else
							{
								if (e == d+3-1)
								{

      out.write("<td id=\"linebottom\" width=\"33%\" valign=\"top\" height=\"100%\">&nbsp;</td>\n");

								}
								else
								{

      out.write("<td id=\"linebottomright\" width=\"33%\" valign=\"top\" height=\"100%\">&nbsp;</td>\n");

								}
							}
						}

      out.write("</tr>\n");

					}

      out.write("</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n");

				}
			}

      out.write("</table>\n\t\t\t</td>\n\t\t</tr>\n");

		}
		else
		{

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td height=\"0\"><img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"50\"></td></tr></table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\" height=\"100%\" valign=\"top\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td width=\"100%\" height=\"100%\">\n\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\" height=\"100%\">\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"center\" height=\"100%\">\n\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"0\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\"><img src=\"/final/config/images/unavailable-data.gif\"></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      out.print(mappingInfo.getTextDescription("configmgmt.common.There were no configuration changes in the selected timeline"));
      out.write("</b></td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n");

		}
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Consolidated_View"))
	{
		String componentType = "";
		String testName = "";
		ArrayList aListConsolidatedData = null;
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			componentType = (String)request.getAttribute("componentType");
			testName = (String)request.getAttribute("testName");
			aListConsolidatedData = (ArrayList)request.getAttribute("ConsolidatedViewData");
		}
		else
		{
			componentType = (String)session.getAttribute("componentType");
			testName = (String)session.getAttribute("testName");
			aListConsolidatedData = (ArrayList)session.getAttribute("ConsolidatedViewData");
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\">\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td align=\"right\" valign=\"bottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f87(_jspx_page_context))
        return;
      out.write("&nbsp;");
      out.print(dateString);
      out.write("</b></td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td height=\"5\">\n\t\t\t\t<img src=\"/final/config/images/spacer.gif\" border=\"0\" height=\"30\">\n\t\t\t</td>\n\t\t</tr>\n");

		}

      out.write("<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"5\" id=\"blank\">&nbsp;</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t\t<table width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" id=\"bottomtable\" style=\"border-bottom-width:0px\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"20\" align=\"left\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\">&nbsp;<b>");
      if (_jspx_meth_egui_005fintnl_005f88(_jspx_page_context))
        return;
      out.write("&nbsp;:&nbsp;");
      out.print(mappingInfo.getComponentTypeDescription(componentType));
      out.write("</b></td>\n\t\t\t\t\t\t<td height=\"20\" align=\"right\" id=\"linebottom\" class=\"");
      out.print(fontStyle);
      out.write("\"><b>");
      if (_jspx_meth_egui_005fintnl_005f89(_jspx_page_context))
        return;
      out.write("&nbsp;:&nbsp;<b>");
      out.print(mappingInfo.getTestDescription(testName));
      out.write("</b>&nbsp;&nbsp;</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"5\" id=\"blank\">&nbsp;</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

		if (aListConsolidatedData != null && !aListConsolidatedData.isEmpty())
		{
			ArrayList aListDistinctDescriptors = (ArrayList)aListConsolidatedData.get(0);
			ArrayList aListAllMeasures = (ArrayList)aListConsolidatedData.get(1);
			TreeMap tmapData = (TreeMap)aListConsolidatedData.get(2);
			int idx_msize = aListAllMeasures.size();

      out.write("<table border=\"0\" align=\"center\" width=\"100%\" class=\"body_text\" height=\"100%\" cellspacing=\"0\" cellpadding=\"4\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td valign=\"top\">\n");

			for (int i=0;i<aListDistinctDescriptors.size();i++)
			{
				String strDescriptor = (String)aListDistinctDescriptors.get(i);
				ArrayList aListData = (ArrayList)tmapData.get(strDescriptor);
				int idx_dataSize = aListData.size();

				ArrayList aListInfoHeadings = null;
				boolean isDynamicMeasureTest = false;
				int idx_M = strDescriptor.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;

					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testName);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

      out.write("<table border=\"0\" width=\"100%\" class=\"body_text\" cellspacing=\"0\" cellpadding=\"4\" id=\"bottomtable\" style=\"border-bottom-width:0pt\">\n");

				if (!strDescriptor.equals("+") && 
					!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) && 
					!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY))
				{
					if (!isDynamicMeasureTest)
					{

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"");
      out.print(idx_msize);
      out.write("\" id=\"linebottom\" style=\"font-weight:bold;padding:2px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(ecUtils.getInfoForDisplay(strDescriptor));
      out.write("</td>\n\t\t\t\t\t\t\t\t</tr>\n");

					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(strDescriptor),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}

      out.write("<tr>\n\t\t\t\t\t\t\t\t\t<td colspan=\"");
      out.print(idx_msize);
      out.write("\" id=\"linebottom\" style=\"font-weight:bold;padding:2px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(strData);
      out.write("</td>\n\t\t\t\t\t\t\t\t</tr>\n");

					}
				}

      out.write("<tr>\n");

				for (int j=0;j<idx_msize;j++)
				{
					if (j == idx_msize-1)
					{

      out.write("<td id=\"linebottom\" style=\"font-weight:bold;padding:2px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print((String)aListAllMeasures.get(j));
      out.write("</td>\n\n");

					}
					else
					{

      out.write("<td id=\"linebottomright\" style=\"font-weight:bold;padding:2px\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print((String)aListAllMeasures.get(j));
      out.write("</td>\n");

					}
				}

      out.write("</tr>\n");

				for (int m=0;m<idx_dataSize;m=m+idx_msize)
				{

      out.write("<tr>\n");

					for (int n=m;n<m+idx_msize;n++)
					{
						String strData = (String)aListData.get(n);

						if(strData == null || strData.trim().length() == 0)
						{
							strData = "-";
						}

						if (strData.startsWith("<?configuration?>"))
						{
							strData = StringUtils.replace(strData,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
						}
						else
						{
							//removing BOM Character begin
							byte[] bytes = strData.getBytes(EcUtils.UTF8_ENCODING);
							if (EcUtils.isUTF8(bytes))
							{
								strData = EcUtils.printSkippedBomString(bytes);
							}
							//end

							strData = EcUtils.replaceTags(strData);
						}
						if (n == m+idx_msize-1)
						{

      out.write("<td id=\"linebottom\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(strData);
      out.write("</td>\n");

						}
						else
						{

      out.write("<td id=\"linebottomright\" valign=\"top\" class=\"");
      out.print(fontStyle);
      out.write('"');
      out.write('>');
      out.print(strData);
      out.write("</td>\n");

						}
					}

      out.write("</tr>\n");

				}

      out.write("</table>\n\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td height=\"15\" id=\"blank\" colspan=\"");
      out.print(idx_msize);
      out.write("\">&nbsp;</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n");

			}

      out.write("</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n");

		}

      out.write("</td>\n\t\t</tr>\n");

	}

      out.write("</table>\n</form>\n\n</body>\n</html>\n\n\n\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_egui_005fintnl_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f0 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f0.setParent(null);
    // /config/EcPrintDataReport.jsp(542,8) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f0.setText("configmgmt.common.eG Configuration Report");
    int _jspx_eval_egui_005fintnl_005f0 = _jspx_th_egui_005fintnl_005f0.doStartTag();
    if (_jspx_th_egui_005fintnl_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fskin_005f0(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:skin
    com.egurkha.tags.Skin _jspx_th_egui_005fskin_005f0 = (com.egurkha.tags.Skin) _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.get(com.egurkha.tags.Skin.class);
    _jspx_th_egui_005fskin_005f0.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fskin_005f0.setParent(null);
    // /config/EcPrintDataReport.jsp(544,1) name = ui type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fskin_005f0.setUi("config");
    int _jspx_eval_egui_005fskin_005f0 = _jspx_th_egui_005fskin_005f0.doStartTag();
    if (_jspx_th_egui_005fskin_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fskin_0026_005fui_005fnobody.reuse(_jspx_th_egui_005fskin_005f0);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f1(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f1 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f1.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f1.setParent(null);
    // /config/EcPrintDataReport.jsp(570,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f1.setText("configmgmt.common.Generated on");
    int _jspx_eval_egui_005fintnl_005f1 = _jspx_th_egui_005fintnl_005f1.doStartTag();
    if (_jspx_th_egui_005fintnl_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f1);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f4(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f4 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f4.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f4.setParent(null);
    // /config/EcPrintDataReport.jsp(586,182) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f4.setText("configmgmt.common.OF");
    int _jspx_eval_egui_005fintnl_005f4 = _jspx_th_egui_005fintnl_005f4.doStartTag();
    if (_jspx_th_egui_005fintnl_005f4.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f4);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f7(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f7 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f7.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f7.setParent(null);
    // /config/EcPrintDataReport.jsp(713,55) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f7.setText("configmgmt.configuration.Configuration Details for");
    int _jspx_eval_egui_005fintnl_005f7 = _jspx_th_egui_005fintnl_005f7.doStartTag();
    if (_jspx_th_egui_005fintnl_005f7.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f7);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f8(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f8 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f8.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f8.setParent(null);
    // /config/EcPrintDataReport.jsp(1415,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f8.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f8 = _jspx_th_egui_005fintnl_005f8.doStartTag();
    if (_jspx_th_egui_005fintnl_005f8.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f8);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f9(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f9 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f9.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f9.setParent(null);
    // /config/EcPrintDataReport.jsp(1437,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f9.setText("configmgmt.common.Component");
    int _jspx_eval_egui_005fintnl_005f9 = _jspx_th_egui_005fintnl_005f9.doStartTag();
    if (_jspx_th_egui_005fintnl_005f9.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f9);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f10(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f10 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f10.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f10.setParent(null);
    // /config/EcPrintDataReport.jsp(1452,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f10.setText("configmgmt.configuration.Farm name");
    int _jspx_eval_egui_005fintnl_005f10 = _jspx_th_egui_005fintnl_005f10.doStartTag();
    if (_jspx_th_egui_005fintnl_005f10.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f10);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f11(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f11 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f11.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f11.setParent(null);
    // /config/EcPrintDataReport.jsp(1464,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f11.setText("configmgmt.configuration.Server name");
    int _jspx_eval_egui_005fintnl_005f11 = _jspx_th_egui_005fintnl_005f11.doStartTag();
    if (_jspx_th_egui_005fintnl_005f11.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f11);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f12(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f12 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f12.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f12.setParent(null);
    // /config/EcPrintDataReport.jsp(1477,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f12.setText("configmgmt.configuration.Application");
    int _jspx_eval_egui_005fintnl_005f12 = _jspx_th_egui_005fintnl_005f12.doStartTag();
    if (_jspx_th_egui_005fintnl_005f12.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f12);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f13(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f13 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f13.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f13.setParent(null);
    // /config/EcPrintDataReport.jsp(1501,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f13.setText("configmgmt.configuration.Total users for");
    int _jspx_eval_egui_005fintnl_005f13 = _jspx_th_egui_005fintnl_005f13.doStartTag();
    if (_jspx_th_egui_005fintnl_005f13.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f13);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f14(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f14 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f14.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f14.setParent(null);
    // /config/EcPrintDataReport.jsp(1507,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f14.setText("configmgmt.configuration.List of users");
    int _jspx_eval_egui_005fintnl_005f14 = _jspx_th_egui_005fintnl_005f14.doStartTag();
    if (_jspx_th_egui_005fintnl_005f14.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f14);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f15(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f15 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f15.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f15.setParent(null);
    // /config/EcPrintDataReport.jsp(1573,83) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f15.setText("configmgmt.configuration.List of applications with their associated users");
    int _jspx_eval_egui_005fintnl_005f15 = _jspx_th_egui_005fintnl_005f15.doStartTag();
    if (_jspx_th_egui_005fintnl_005f15.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f15);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f16(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f16 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f16.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f16.setParent(null);
    // /config/EcPrintDataReport.jsp(1580,103) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f16.setText("configmgmt.configuration.Application");
    int _jspx_eval_egui_005fintnl_005f16 = _jspx_th_egui_005fintnl_005f16.doStartTag();
    if (_jspx_th_egui_005fintnl_005f16.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f16);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f17(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f17 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f17.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f17.setParent(null);
    // /config/EcPrintDataReport.jsp(1584,55) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f17.setText("configmgmt.configuration.Users");
    int _jspx_eval_egui_005fintnl_005f17 = _jspx_th_egui_005fintnl_005f17.doStartTag();
    if (_jspx_th_egui_005fintnl_005f17.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f17);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f18(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f18 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f18.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f18.setParent(null);
    // /config/EcPrintDataReport.jsp(1731,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f18.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f18 = _jspx_th_egui_005fintnl_005f18.doStartTag();
    if (_jspx_th_egui_005fintnl_005f18.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f18);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f19(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f19 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f19.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f19.setParent(null);
    // /config/EcPrintDataReport.jsp(1753,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f19.setText("configmgmt.common.Component");
    int _jspx_eval_egui_005fintnl_005f19 = _jspx_th_egui_005fintnl_005f19.doStartTag();
    if (_jspx_th_egui_005fintnl_005f19.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f19);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f20(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f20 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f20.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f20.setParent(null);
    // /config/EcPrintDataReport.jsp(1768,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f20.setText("configmgmt.configuration.Farm name");
    int _jspx_eval_egui_005fintnl_005f20 = _jspx_th_egui_005fintnl_005f20.doStartTag();
    if (_jspx_th_egui_005fintnl_005f20.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f20);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f21(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f21 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f21.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f21.setParent(null);
    // /config/EcPrintDataReport.jsp(1780,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f21.setText("configmgmt.configuration.Server name");
    int _jspx_eval_egui_005fintnl_005f21 = _jspx_th_egui_005fintnl_005f21.doStartTag();
    if (_jspx_th_egui_005fintnl_005f21.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f21);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f22(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f22 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f22.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f22.setParent(null);
    // /config/EcPrintDataReport.jsp(1793,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f22.setText("configmgmt.configuration.User");
    int _jspx_eval_egui_005fintnl_005f22 = _jspx_th_egui_005fintnl_005f22.doStartTag();
    if (_jspx_th_egui_005fintnl_005f22.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f22);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f23(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f23 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f23.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f23.setParent(null);
    // /config/EcPrintDataReport.jsp(1816,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f23.setText("configmgmt.configuration.Total applications for");
    int _jspx_eval_egui_005fintnl_005f23 = _jspx_th_egui_005fintnl_005f23.doStartTag();
    if (_jspx_th_egui_005fintnl_005f23.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f23);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f24(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f24 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f24.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f24.setParent(null);
    // /config/EcPrintDataReport.jsp(1822,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f24.setText("configmgmt.configuration.List of applications");
    int _jspx_eval_egui_005fintnl_005f24 = _jspx_th_egui_005fintnl_005f24.doStartTag();
    if (_jspx_th_egui_005fintnl_005f24.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f24);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f25(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f25 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f25.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f25.setParent(null);
    // /config/EcPrintDataReport.jsp(1881,83) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f25.setText("configmgmt.configuration.List of users with their associated applications");
    int _jspx_eval_egui_005fintnl_005f25 = _jspx_th_egui_005fintnl_005f25.doStartTag();
    if (_jspx_th_egui_005fintnl_005f25.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f25);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f26(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f26 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f26.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f26.setParent(null);
    // /config/EcPrintDataReport.jsp(1888,103) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f26.setText("configmgmt.configuration.User");
    int _jspx_eval_egui_005fintnl_005f26 = _jspx_th_egui_005fintnl_005f26.doStartTag();
    if (_jspx_th_egui_005fintnl_005f26.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f26);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f27(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f27 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f27.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f27.setParent(null);
    // /config/EcPrintDataReport.jsp(1892,55) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f27.setText("configmgmt.configuration.Applications");
    int _jspx_eval_egui_005fintnl_005f27 = _jspx_th_egui_005fintnl_005f27.doStartTag();
    if (_jspx_th_egui_005fintnl_005f27.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f27);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f28(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f28 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f28.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f28.setParent(null);
    // /config/EcPrintDataReport.jsp(3827,95) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f28.setText("configmgmt.common.No Data");
    int _jspx_eval_egui_005fintnl_005f28 = _jspx_th_egui_005fintnl_005f28.doStartTag();
    if (_jspx_th_egui_005fintnl_005f28.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f28);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f28);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f29(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f29 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f29.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f29.setParent(null);
    // /config/EcPrintDataReport.jsp(3855,53) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f29.setText("configmgmt.changes.detailed.CONFIGURATION CHANGE ");
    int _jspx_eval_egui_005fintnl_005f29 = _jspx_th_egui_005fintnl_005f29.doStartTag();
    if (_jspx_th_egui_005fintnl_005f29.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f29);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f29);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f30(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f30 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f30.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f30.setParent(null);
    // /config/EcPrintDataReport.jsp(3855,137) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f30.setText("configmgmt.changes.detailed.DETAILED");
    int _jspx_eval_egui_005fintnl_005f30 = _jspx_th_egui_005fintnl_005f30.doStartTag();
    if (_jspx_th_egui_005fintnl_005f30.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f30);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f30);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f31(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f31 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f31.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f31.setParent(null);
    // /config/EcPrintDataReport.jsp(3864,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f31.setText("configmgmt.changes.detailed.COMPONENT NAME");
    int _jspx_eval_egui_005fintnl_005f31 = _jspx_th_egui_005fintnl_005f31.doStartTag();
    if (_jspx_th_egui_005fintnl_005f31.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f31);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f31);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f32(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f32 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f32.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f32.setParent(null);
    // /config/EcPrintDataReport.jsp(3900,49) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f32.setText("configmgmt.changes.detailed.Component Name");
    int _jspx_eval_egui_005fintnl_005f32 = _jspx_th_egui_005fintnl_005f32.doStartTag();
    if (_jspx_th_egui_005fintnl_005f32.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f32);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f32);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f35(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f35 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f35.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f35.setParent(null);
    // /config/EcPrintDataReport.jsp(3912,104) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f35.setText("configmgmt.common.between");
    int _jspx_eval_egui_005fintnl_005f35 = _jspx_th_egui_005fintnl_005f35.doStartTag();
    if (_jspx_th_egui_005fintnl_005f35.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f35);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f35);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f36(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f36 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f36.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f36.setParent(null);
    // /config/EcPrintDataReport.jsp(3912,174) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f36.setText("configmgmt.common.and");
    int _jspx_eval_egui_005fintnl_005f36 = _jspx_th_egui_005fintnl_005f36.doStartTag();
    if (_jspx_th_egui_005fintnl_005f36.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f36);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f36);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f38(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f38 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f38.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f38.setParent(null);
    // /config/EcPrintDataReport.jsp(3924,104) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f38.setText("configmgmt.common.between");
    int _jspx_eval_egui_005fintnl_005f38 = _jspx_th_egui_005fintnl_005f38.doStartTag();
    if (_jspx_th_egui_005fintnl_005f38.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f38);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f38);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f39(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f39 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f39.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f39.setParent(null);
    // /config/EcPrintDataReport.jsp(3924,174) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f39.setText("configmgmt.common.and");
    int _jspx_eval_egui_005fintnl_005f39 = _jspx_th_egui_005fintnl_005f39.doStartTag();
    if (_jspx_th_egui_005fintnl_005f39.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f39);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f39);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f41(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f41 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f41.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f41.setParent(null);
    // /config/EcPrintDataReport.jsp(4031,62) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f41.setText("configmgmt.changes.detailed.Changes");
    int _jspx_eval_egui_005fintnl_005f41 = _jspx_th_egui_005fintnl_005f41.doStartTag();
    if (_jspx_th_egui_005fintnl_005f41.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f41);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f41);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f42(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f42 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f42.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f42.setParent(null);
    // /config/EcPrintDataReport.jsp(4074,72) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f42.setText("configmgmt.changes.detailed.Descriptor");
    int _jspx_eval_egui_005fintnl_005f42 = _jspx_th_egui_005fintnl_005f42.doStartTag();
    if (_jspx_th_egui_005fintnl_005f42.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f42);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f42);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f43(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f43 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f43.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f43.setParent(null);
    // /config/EcPrintDataReport.jsp(4078,79) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f43.setText("configmgmt.changes.detailed.Measure");
    int _jspx_eval_egui_005fintnl_005f43 = _jspx_th_egui_005fintnl_005f43.doStartTag();
    if (_jspx_th_egui_005fintnl_005f43.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f43);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f43);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f44(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f44 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f44.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f44.setParent(null);
    // /config/EcPrintDataReport.jsp(4079,79) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f44.setText("configmgmt.changes.detailed.Date");
    int _jspx_eval_egui_005fintnl_005f44 = _jspx_th_egui_005fintnl_005f44.doStartTag();
    if (_jspx_th_egui_005fintnl_005f44.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f44);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f44);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f45(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f45 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f45.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f45.setParent(null);
    // /config/EcPrintDataReport.jsp(4080,79) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f45.setText("configmgmt.changes.detailed.Previous Value");
    int _jspx_eval_egui_005fintnl_005f45 = _jspx_th_egui_005fintnl_005f45.doStartTag();
    if (_jspx_th_egui_005fintnl_005f45.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f45);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f45);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f46(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f46 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f46.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f46.setParent(null);
    // /config/EcPrintDataReport.jsp(4081,74) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f46.setText("configmgmt.changes.detailed.Present Value");
    int _jspx_eval_egui_005fintnl_005f46 = _jspx_th_egui_005fintnl_005f46.doStartTag();
    if (_jspx_th_egui_005fintnl_005f46.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f46);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f46);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f47(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f47 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f47.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f47.setParent(null);
    // /config/EcPrintDataReport.jsp(4206,82) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f47.setText("configmgmt.common.Yes");
    int _jspx_eval_egui_005fintnl_005f47 = _jspx_th_egui_005fintnl_005f47.doStartTag();
    if (_jspx_th_egui_005fintnl_005f47.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f47);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f47);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f48(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f48 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f48.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f48.setParent(null);
    // /config/EcPrintDataReport.jsp(4212,82) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f48.setText("configmgmt.common.No");
    int _jspx_eval_egui_005fintnl_005f48 = _jspx_th_egui_005fintnl_005f48.doStartTag();
    if (_jspx_th_egui_005fintnl_005f48.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f48);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f48);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f49(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f49 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f49.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f49.setParent(null);
    // /config/EcPrintDataReport.jsp(4262,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f49.setText("configmgmt.common.Yes");
    int _jspx_eval_egui_005fintnl_005f49 = _jspx_th_egui_005fintnl_005f49.doStartTag();
    if (_jspx_th_egui_005fintnl_005f49.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f49);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f49);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f50(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f50 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f50.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f50.setParent(null);
    // /config/EcPrintDataReport.jsp(4270,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f50.setText("configmgmt.common.No");
    int _jspx_eval_egui_005fintnl_005f50 = _jspx_th_egui_005fintnl_005f50.doStartTag();
    if (_jspx_th_egui_005fintnl_005f50.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f50);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f50);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f51(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f51 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f51.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f51.setParent(null);
    // /config/EcPrintDataReport.jsp(4495,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f51.setText("configmgmt.changes.detailed.Change Date");
    int _jspx_eval_egui_005fintnl_005f51 = _jspx_th_egui_005fintnl_005f51.doStartTag();
    if (_jspx_th_egui_005fintnl_005f51.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f51);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f51);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f52(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f52 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f52.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f52.setParent(null);
    // /config/EcPrintDataReport.jsp(4498,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f52.setText("configmgmt.changes.detailed.Information");
    int _jspx_eval_egui_005fintnl_005f52 = _jspx_th_egui_005fintnl_005f52.doStartTag();
    if (_jspx_th_egui_005fintnl_005f52.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f52);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f52);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f53(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f53 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f53.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f53.setParent(null);
    // /config/EcPrintDataReport.jsp(4501,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f53.setText("configmgmt.changes.detailed.Descriptor");
    int _jspx_eval_egui_005fintnl_005f53 = _jspx_th_egui_005fintnl_005f53.doStartTag();
    if (_jspx_th_egui_005fintnl_005f53.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f53);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f53);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f54(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f54 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f54.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f54.setParent(null);
    // /config/EcPrintDataReport.jsp(4504,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f54.setText("configmgmt.changes.detailed.Measure");
    int _jspx_eval_egui_005fintnl_005f54 = _jspx_th_egui_005fintnl_005f54.doStartTag();
    if (_jspx_th_egui_005fintnl_005f54.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f54);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f54);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f55(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f55 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f55.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f55.setParent(null);
    // /config/EcPrintDataReport.jsp(4507,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f55.setText("configmgmt.changes.detailed.Previous Value");
    int _jspx_eval_egui_005fintnl_005f55 = _jspx_th_egui_005fintnl_005f55.doStartTag();
    if (_jspx_th_egui_005fintnl_005f55.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f55);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f55);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f56(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f56 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f56.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f56.setParent(null);
    // /config/EcPrintDataReport.jsp(4510,13) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f56.setText("configmgmt.changes.detailed.Present Value");
    int _jspx_eval_egui_005fintnl_005f56 = _jspx_th_egui_005fintnl_005f56.doStartTag();
    if (_jspx_th_egui_005fintnl_005f56.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f56);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f56);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f57(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f57 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f57.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f57.setParent(null);
    // /config/EcPrintDataReport.jsp(4990,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f57.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f57 = _jspx_th_egui_005fintnl_005f57.doStartTag();
    if (_jspx_th_egui_005fintnl_005f57.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f57);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f57);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f58(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f58 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f58.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f58.setParent(null);
    // /config/EcPrintDataReport.jsp(5059,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f58.setText("configmgmt.inventory.search.Search for");
    int _jspx_eval_egui_005fintnl_005f58 = _jspx_th_egui_005fintnl_005f58.doStartTag();
    if (_jspx_th_egui_005fintnl_005f58.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f58);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f58);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f59(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f59 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f59.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f59.setParent(null);
    // /config/EcPrintDataReport.jsp(5059,93) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f59.setText("configmgmt.inventory.search.Search by");
    int _jspx_eval_egui_005fintnl_005f59 = _jspx_th_egui_005fintnl_005f59.doStartTag();
    if (_jspx_th_egui_005fintnl_005f59.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f59);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f59);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f60(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f60 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f60.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f60.setParent(null);
    // /config/EcPrintDataReport.jsp(5068,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f60.setText("configmgmt.inventory.search.No result found for the current selection");
    int _jspx_eval_egui_005fintnl_005f60 = _jspx_th_egui_005fintnl_005f60.doStartTag();
    if (_jspx_th_egui_005fintnl_005f60.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f60);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f60);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f61(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f61 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f61.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f61.setParent(null);
    // /config/EcPrintDataReport.jsp(5265,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f61.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f61 = _jspx_th_egui_005fintnl_005f61.doStartTag();
    if (_jspx_th_egui_005fintnl_005f61.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f61);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f61);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f62(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f62 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f62.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f62.setParent(null);
    // /config/EcPrintDataReport.jsp(5299,10) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f62.setText("configmgmt.inventory.view.System");
    int _jspx_eval_egui_005fintnl_005f62 = _jspx_th_egui_005fintnl_005f62.doStartTag();
    if (_jspx_th_egui_005fintnl_005f62.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f62);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f62);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f63(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f63 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f63.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f63.setParent(null);
    // /config/EcPrintDataReport.jsp(5342,100) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f63.setText("configmgmt.inventory.view.System Information");
    int _jspx_eval_egui_005fintnl_005f63 = _jspx_th_egui_005fintnl_005f63.doStartTag();
    if (_jspx_th_egui_005fintnl_005f63.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f63);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f63);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f64(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f64 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f64.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f64.setParent(null);
    // /config/EcPrintDataReport.jsp(5345,108) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f64.setText("configmgmt.inventory.view.System");
    int _jspx_eval_egui_005fintnl_005f64 = _jspx_th_egui_005fintnl_005f64.doStartTag();
    if (_jspx_th_egui_005fintnl_005f64.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f64);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f64);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f66(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f66 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f66.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f66.setParent(null);
    // /config/EcPrintDataReport.jsp(5483,82) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f66.setText("configmgmt.inventory.view.Components managed on");
    int _jspx_eval_egui_005fintnl_005f66 = _jspx_th_egui_005fintnl_005f66.doStartTag();
    if (_jspx_th_egui_005fintnl_005f66.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f66);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f66);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f67(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f67 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f67.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f67.setParent(null);
    // /config/EcPrintDataReport.jsp(5645,25) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f67.setText("configmgmt.inventory.view.Basic Configuration for");
    int _jspx_eval_egui_005fintnl_005f67 = _jspx_th_egui_005fintnl_005f67.doStartTag();
    if (_jspx_th_egui_005fintnl_005f67.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f67);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f67);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f68(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f68 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f68.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f68.setParent(null);
    // /config/EcPrintDataReport.jsp(5797,65) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f68.setText("configmgmt.common.Yes");
    int _jspx_eval_egui_005fintnl_005f68 = _jspx_th_egui_005fintnl_005f68.doStartTag();
    if (_jspx_th_egui_005fintnl_005f68.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f68);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f68);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f69(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f69 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f69.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f69.setParent(null);
    // /config/EcPrintDataReport.jsp(5847,75) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f69.setText("configmgmt.common.Yes");
    int _jspx_eval_egui_005fintnl_005f69 = _jspx_th_egui_005fintnl_005f69.doStartTag();
    if (_jspx_th_egui_005fintnl_005f69.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f69);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f69);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f70(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f70 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f70.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f70.setParent(null);
    // /config/EcPrintDataReport.jsp(5945,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f70.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f70 = _jspx_th_egui_005fintnl_005f70.doStartTag();
    if (_jspx_th_egui_005fintnl_005f70.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f70);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f70);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f71(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f71 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f71.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f71.setParent(null);
    // /config/EcPrintDataReport.jsp(5970,67) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f71.setText("configmgmt.changes.detailed.Total Changes");
    int _jspx_eval_egui_005fintnl_005f71 = _jspx_th_egui_005fintnl_005f71.doStartTag();
    if (_jspx_th_egui_005fintnl_005f71.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f71);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f71);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f72(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f72 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f72.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f72.setParent(null);
    // /config/EcPrintDataReport.jsp(5971,62) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f72.setText("configmgmt.changes.summary.Between");
    int _jspx_eval_egui_005fintnl_005f72 = _jspx_th_egui_005fintnl_005f72.doStartTag();
    if (_jspx_th_egui_005fintnl_005f72.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f72);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f72);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f73(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f73 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f73.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f73.setParent(null);
    // /config/EcPrintDataReport.jsp(5971,162) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f73.setText("configmgmt.common.and");
    int _jspx_eval_egui_005fintnl_005f73 = _jspx_th_egui_005fintnl_005f73.doStartTag();
    if (_jspx_th_egui_005fintnl_005f73.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f73);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f73);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f74(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f74 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f74.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f74.setParent(null);
    // /config/EcPrintDataReport.jsp(5981,75) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f74.setText("configmgmt.changes.detailed.Component Type");
    int _jspx_eval_egui_005fintnl_005f74 = _jspx_th_egui_005fintnl_005f74.doStartTag();
    if (_jspx_th_egui_005fintnl_005f74.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f74);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f74);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f75(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f75 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f75.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f75.setParent(null);
    // /config/EcPrintDataReport.jsp(5982,83) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f75.setText("configmgmt.changes.summary.Changes");
    int _jspx_eval_egui_005fintnl_005f75 = _jspx_th_egui_005fintnl_005f75.doStartTag();
    if (_jspx_th_egui_005fintnl_005f75.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f75);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f75);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f76(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f76 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f76.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f76.setParent(null);
    // /config/EcPrintDataReport.jsp(5983,70) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f76.setText("configmgmt.changes.summary.Changed components");
    int _jspx_eval_egui_005fintnl_005f76 = _jspx_th_egui_005fintnl_005f76.doStartTag();
    if (_jspx_th_egui_005fintnl_005f76.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f76);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f76);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f78(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f78 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f78.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f78.setParent(null);
    // /config/EcPrintDataReport.jsp(6162,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f78.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f78 = _jspx_th_egui_005fintnl_005f78.doStartTag();
    if (_jspx_th_egui_005fintnl_005f78.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f78);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f78);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f79(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f79 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f79.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f79.setParent(null);
    // /config/EcPrintDataReport.jsp(6187,67) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f79.setText("configmgmt.changes.detailed.Total Changes");
    int _jspx_eval_egui_005fintnl_005f79 = _jspx_th_egui_005fintnl_005f79.doStartTag();
    if (_jspx_th_egui_005fintnl_005f79.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f79);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f79);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f80(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f80 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f80.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f80.setParent(null);
    // /config/EcPrintDataReport.jsp(6188,62) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f80.setText("configmgmt.changes.summary.Between");
    int _jspx_eval_egui_005fintnl_005f80 = _jspx_th_egui_005fintnl_005f80.doStartTag();
    if (_jspx_th_egui_005fintnl_005f80.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f80);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f80);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f81(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f81 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f81.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f81.setParent(null);
    // /config/EcPrintDataReport.jsp(6188,162) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f81.setText("configmgmt.common.and");
    int _jspx_eval_egui_005fintnl_005f81 = _jspx_th_egui_005fintnl_005f81.doStartTag();
    if (_jspx_th_egui_005fintnl_005f81.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f81);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f81);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f82(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f82 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f82.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f82.setParent(null);
    // /config/EcPrintDataReport.jsp(6198,75) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f82.setText("configmgmt.changes.detailed.Component Name");
    int _jspx_eval_egui_005fintnl_005f82 = _jspx_th_egui_005fintnl_005f82.doStartTag();
    if (_jspx_th_egui_005fintnl_005f82.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f82);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f82);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f83(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f83 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f83.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f83.setParent(null);
    // /config/EcPrintDataReport.jsp(6199,83) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f83.setText("configmgmt.changes.summary.Changes");
    int _jspx_eval_egui_005fintnl_005f83 = _jspx_th_egui_005fintnl_005f83.doStartTag();
    if (_jspx_th_egui_005fintnl_005f83.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f83);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f83);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f84(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f84 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f84.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f84.setParent(null);
    // /config/EcPrintDataReport.jsp(6200,70) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f84.setText("configmgmt.changes.summary.Changes in");
    int _jspx_eval_egui_005fintnl_005f84 = _jspx_th_egui_005fintnl_005f84.doStartTag();
    if (_jspx_th_egui_005fintnl_005f84.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f84);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f84);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f87(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f87 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f87.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f87.setParent(null);
    // /config/EcPrintDataReport.jsp(6365,69) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f87.setText("configmgmt.configuration.as on");
    int _jspx_eval_egui_005fintnl_005f87 = _jspx_th_egui_005fintnl_005f87.doStartTag();
    if (_jspx_th_egui_005fintnl_005f87.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f87);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f87);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f88(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f88 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f88.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f88.setParent(null);
    // /config/EcPrintDataReport.jsp(6391,83) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f88.setText("configmgmt.consolidated.Component Type");
    int _jspx_eval_egui_005fintnl_005f88 = _jspx_th_egui_005fintnl_005f88.doStartTag();
    if (_jspx_th_egui_005fintnl_005f88.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f88);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f88);
    return false;
  }

  private boolean _jspx_meth_egui_005fintnl_005f89(PageContext _jspx_page_context)
          throws Throwable {
    PageContext pageContext = _jspx_page_context;
    JspWriter out = _jspx_page_context.getOut();
    //  egui:intnl
    com.egurkha.tags.Intnl _jspx_th_egui_005fintnl_005f89 = (com.egurkha.tags.Intnl) _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.get(com.egurkha.tags.Intnl.class);
    _jspx_th_egui_005fintnl_005f89.setPageContext(_jspx_page_context);
    _jspx_th_egui_005fintnl_005f89.setParent(null);
    // /config/EcPrintDataReport.jsp(6392,78) name = text type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_egui_005fintnl_005f89.setText("configmgmt.consolidated.Report Type");
    int _jspx_eval_egui_005fintnl_005f89 = _jspx_th_egui_005fintnl_005f89.doStartTag();
    if (_jspx_th_egui_005fintnl_005f89.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f89);
      return true;
    }
    _005fjspx_005ftagPool_005fegui_005fintnl_0026_005ftext_005fnobody.reuse(_jspx_th_egui_005fintnl_005f89);
    return false;
  }
}
