package org.apache.jsp.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import egurkha.EgDBConnectUI;
import java.util.*;
import java.sql.*;
import com.egurkha.util.StringUtils;
import com.eg.EgInstallInfo;
import com.eg.IniFile;

public final class EgViewTopServers_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	String[] categoryDisplayField = {
		"Performance test tables",
		"Configuration test tables",
		"DDD tables",
		"Thresh tables",
		"Trend tables",
		"Aggregate test tables",
		"Performance rating test tables",
		"Other tables"
	};

	String[] categoryValueField = {
		"perfTestTables",
		"confTestTables",
		"dddTables",
		"threshTables",
		"trendTables",
		"aggTestTables",
		"perfRxTestTables",
		"otherTables"
	};

	private ArrayList getData(String strQuery)
	{
		ArrayList aListData = new ArrayList();

		EgDBConnectUI dbconnect = new EgDBConnectUI();
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		try
		{
			conn = dbconnect.getConnection();
			stmt = conn.createStatement();
			rs = stmt.executeQuery(strQuery);

			ResultSetMetaData rsmd = rs.getMetaData();
			int numberOfColumns = rsmd.getColumnCount();

			while (rs.next())
			{
				for (int i=1;i<=numberOfColumns;i++)
				{
					String strTable = rs.getString(i);
					aListData.add(strTable);
				}
			}
		}
		catch(Exception e)
		{
			//e.printStackTrace();
			dbconnect.changeConn();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}
				if (stmt != null)
				{
					stmt.close();
				}
				dbconnect.releaseConnection();
			}
			catch(Exception e1)
			{
				//e1.printStackTrace();
			}
			rs = null;
			stmt = null;
			conn = null;
		}

		return aListData;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"EgProbs.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("<!DOCTYPE html>\n\n");

	String whoami = request.getParameter("whoami");
	String pwd = request.getParameter("pwd");
	String tempStr = request.getParameter("temp");

	if (tempStr == null)
	{
		String fromToolKit = request.getParameter("fromToolKit");
		if (fromToolKit == null || fromToolKit.equals("null"))
		{
			session.setAttribute("reqFrom","ViewTopServers");
			String redirectURL = "EgToolKit.jsp?whoami=egurkha&pwd=admin";
			response.sendRedirect(redirectURL);
		}

		String comeFrom = request.getParameter("comeFrom");
		if (!StringUtils.isNull(comeFrom) && comeFrom.equals("ViewTopServers"))
		{
			session.setAttribute("treeViewSrc","ViewTopServers");
		}
	}

	String strCategory = request.getParameter("category");
	String strPrevCategory = request.getParameter("previousCategory");
	String strTableName = request.getParameter("tablename");

	String dbType = "mssql";
	IniFile dbFilePtr = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_db.ini");
	String dbServerType = dbFilePtr.getValue("DB_PROPERTIES","DB_Server_Type");
	if (dbServerType.equals("EgOracleAdapter"))
	{
		dbType = "oracle";
	}

      out.write("<html>\n\n<head>\n<link rel=\"stylesheet\" href=\"eg_styles/eg_adminstyle.css\" />\n</head>\n\n<body>\n\n<script type=\"text/javascript\">\n\nfunction submitForm()\n{\n\tdocument.myForm1.action = \"EgViewTopServers.jsp\";\n\tdocument.myForm1.submit();\n}\n\n</script>\n\n<form name=\"myForm1\" method=\"post\">\n<input type=\"hidden\" name=\"whoami\" value=\"");
      out.print(whoami);
      out.write("\"/>\n<input type=\"hidden\" name=\"pwd\" value=\"");
      out.print(pwd);
      out.write("\"/>\n<input type=\"hidden\" name=\"temp\" value=\"temp\"/>\n<input type=\"hidden\" name=\"previousCategory\" value=\"");
      out.print(strCategory);
      out.write("\"/>\n<br>\n<table border=\"1\" width=\"50%\" align=\"center\">\n\t<tr>\n\t\t<td id=\"subhead\" width=\"50%\"><b>Category</b></td>\n\t\t<td align=\"center\">\n\t\t\t<select name=\"category\" onchange=\"javascript:submitForm()\" style=\"width: 300px\">\n\t\t\t\t<option value=\"-1\">Please select a category</option>\n");

	for (int i=0;i<categoryDisplayField.length;i++)
	{
		String strCDF = categoryDisplayField[i];
		String strCVF = categoryValueField[i];
		String selected = "";
		if (strCategory != null && strCategory.equalsIgnoreCase(strCVF))
		{
			selected = "selected";
		}

      out.write("<option value=\"");
      out.print(strCVF);
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write('>');
      out.print(strCDF);
      out.write("</option>\n");

	}

      out.write("</select>\n\t\t</td>\n\t</tr>\n\n");

	if (strCategory != null && !strCategory.equals("-1"))
	{
		ArrayList aListTables = null;

		String whereClause = "";
		String dbVersionName = com.eg.EgDbInfo.getDBVersion();
		String colName = "name";
		String tableName = "sys.tables";
		if(dbVersionName!=null && (dbVersionName.indexOf("SQL")>-1 && (dbVersionName.indexOf("2005")>-1 || dbVersionName.indexOf("2000")>-1))){
			tableName = "information_schema.tables";
			colName = "table_name";
		}

		if (strCategory.equalsIgnoreCase(categoryValueField[0]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_Test' or "+colName+" like '%_TEST' or "+colName+" like '%_ex'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_Test' or tname like '%_TEST' or tname like '%_ex'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[1]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_cf' or "+colName+" like '%_cf_ex'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_cf' or tname like '%_cf_ex'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[2]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_DDD'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_DDD'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[3]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_THRESH'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_THRESH'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[4]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_TREND'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_TREND'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[5]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_ag' or "+colName+" like '%_agx'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_ag' or tname like '%_agx'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[6]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_rx'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_rx'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[7]))
		{
			IniFile iniObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_dbase.ini");
			Vector var_vec = iniObj.getVariables("DEF_TABLES",true);
			aListTables = new ArrayList(var_vec);
		}

		if (!strCategory.equalsIgnoreCase(categoryValueField[7]))
		{
			String strQuery = "";
			if (dbType.equalsIgnoreCase("mssql"))
			{
				strQuery = "SELECT "+colName+" from " +tableName+" "+ whereClause;
			}
			else //oracle
			{
				strQuery = "SELECT tname from tab " + whereClause;
			}
			aListTables = getData(strQuery);
			if (strCategory.equalsIgnoreCase(categoryValueField[0]))
			{
				aListTables.remove("METATEST");
			}
		}

      out.write("<tr>\n\t\t<td id=\"subhead\" width=\"50%\"><b>Table</b></td>\n\t\t<td align=\"center\">\n\t\t\t<select name=\"tablename\" onchange=\"javascript:submitForm()\" style=\"width: 300px\">\n");

		int i_idx = aListTables.size();
		if (i_idx > 0)
		{
			Collections.sort(aListTables,String.CASE_INSENSITIVE_ORDER);

      out.write("<option value=\"-1\">Please select a table</option>\n");

		}
		else
		{

      out.write("<option value=\"-1\">Not applicable</option>\n");

		}

		for (int i=0;i<i_idx;i++)
		{
			String strTable = (String)aListTables.get(i);
			String selected = "";
			if (strTable != null && strTable.equals(strTableName))
			{
				selected = "selected";
			}

      out.write("<option value=\"");
      out.print(strTable);
      out.write('"');
      out.write(' ');
      out.print(selected);
      out.write('>');
      out.print(strTable);
      out.write("</option>\n");

		}

      out.write("</select>\n\t\t</td>\n\t</tr>\n");

	}
	else
	{

      out.write("<tr>\n\t\t<td id=\"subhead\" width=\"50%\"><b>Table</b></td>\n\t\t<td align=\"center\">\n\t\t\t<select name=\"tablename\" style=\"width: 300px\">\n\t\t\t\t<option value=\"-1\">Not applicable</option>\n\t\t\t</select>\n\t\t</td>\n\t</tr>\n");

	}

      out.write("</table>\n</form>\n\n<br>\n<br>\n\n");

	if (strCategory != null && !strCategory.equals("-1") && 
		strPrevCategory != null && strPrevCategory.equalsIgnoreCase(strCategory) && 
		strTableName != null && !strTableName.equals("-1"))
	{
		String strQuery = "select count(1) from " + strTableName;
		ArrayList aListData = getData(strQuery);

      out.write("<table border=\"1\" width=\"50%\" align=\"center\">\n\t<tr>\n\t\t<th colspan=\"2\">");
      out.print(strTableName);
      out.write("</th>\n\t</tr>\n\t<tr>\n\t\t<th align=\"left\" width=\"70%\"><b>Total number of rows</b></th>\n\t\t<th width=\"30%\">");
      out.print((String)aListData.get(0));
      out.write("</th>\n\t</tr>\n");

		if (dbType.equalsIgnoreCase("mssql"))
		{
			strQuery = "select TOP(25) trgt_host,count(trgt_host) from " + strTableName + " group by trgt_host order by 2 desc";
		}
		else //oracle
		{
			strQuery = "select * from (select trgt_host,count(trgt_host) from " + strTableName + " group by trgt_host order by 2 desc) WHERE ROWNUM < 26";
		}
		aListData = getData(strQuery);
		if (aListData != null && !aListData.isEmpty())
		{

      out.write("<tr>\n\t\t<th colspan=\"2\">Top 25 targets by row count</th>\n\t</tr>\n\t<tr>\n\t\t<th>Target Host</th><th>Record Count</th>\n\t</tr>\n");

			for (int i=0;i<aListData.size();i=i+2)
			{
				String data1 = (String) aListData.get(i);
				String data2 = (String) aListData.get(i+1);

      out.write("<tr>\n\t\t<td>");
      out.print(data1);
      out.write("</td><td>");
      out.print(data2);
      out.write("</td>\n\t</tr>\n");

			}
		}

      out.write("</table>\n");

	}

      out.write("<br>\n</body>\n\n</html>\n\n\n\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
