package org.apache.jsp.admin.AgentStatus.data;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.egurkha.*;
import java.util.*;
import com.eg.EgDbAdapterTypeUI;
import egurkha.EgDbAdapterUI;
import egurkha.reporter.*;
import com.eg.*;
import java.util.*;
import com.egurkha.EgUserPermission;
import com.egurkha.EgUserRole;
import com.eg.EgDateInfo;
import com.eg.EgMappingInfo;
import com.eg.IniFile;
import com.eg.EgInstallInfo;
import egurkha.UserBean;
import com.eg.EgUsersInfo;
import com.eg.EgLicenseInfo;
import com.eg.EgServerList;
import com.eg.IniFile;
import com.egurkha.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.sf.json.JSONObject;
import net.sf.json.JSONArray;

public final class EgServerListJson_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


	public boolean isNullOrEmpty(Object object)
	{
		try
		{
			if(object == null)
			{
				return true;
			}
			else if(object instanceof java.lang.String)
			{
				String string = (String) object;
				if (string.equals("") || string.equalsIgnoreCase("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.lang.StringBuffer)
			{
				String stringBuffer = (String)object.toString();
				if (stringBuffer.equals("") || stringBuffer.equals("null"))
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.StringTokenizer)
			{
				StringTokenizer st = (StringTokenizer) object;
				if (!st.hasMoreTokens())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.List)
			{
				List list =(List)object;
				if (list.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Map)
			{
				Map map =(Map)object;
				if (map.isEmpty())
				{
					return true;
				}
				return false;
			}
			else if(object instanceof java.util.Set)
			{
				Set set =(Set)object;
				if (set.isEmpty())
				{
					return true;
				}
				return false;
			}
			else
			{
				return false;
			}
		}
		catch (Exception e)
		{
			System.out.println("Execption in the method isNullOrEmpty @ /final/admin/EgTrackerA.jsp :"+e);
		}
		return false;
	}

	public boolean isNull(Object object)
	{
		if(object == null)
		{
			return true;
		}
		return false;
	}


	String USER_COMP_AGENTS = "Agents for user licensed types";
	String[] agentTypes = {"BasicAgents","PremiumAgents", "ExternalAgents", "RemoteAgents",USER_COMP_AGENTS};
	String[] agentStatus = {"All","Running","NotRunning"};


	public String getAssignedHostsForExternalAgent(String agentName)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Test_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		com.eg.EgDiscInfo discInfoObj = new com.eg.EgDiscInfo("manager");
		String rumServerList[] = discInfoObj.getAllServersOfType("Real_user_monitor");
		ArrayList varsList = new ArrayList(Arrays.asList(vars));
		boolean isRUMCompExists = false;
		try{
			if (rumServerList != null ) {
				for (int a=0;a<rumServerList.length;a++) {
					String serverName = (String)rumServerList[a];
					if (serverName != null && serverName.startsWith("Real_user_monitor")) {
						try{
							serverName = serverName.substring(serverName.indexOf(":")+1,serverName.lastIndexOf(":"));
							isRUMCompExists = true;
						} catch(Exception ex){
							serverName = serverName;
						}
						varsList.remove(serverName);
					}
				}
			}
		}
		catch(Exception ex){
			ex.printStackTrace();
		}
		if (isRUMCompExists){
			vars = (String[])varsList.toArray(new String[varsList.size()]);
		}
		for (int v=0; v<vars.length; v++)
		{
			String host = vars[v];
			String agents = extIni.getValue("Test_Mapping_Section",host);
			StringTokenizer stt = new StringTokenizer(agents,",");
			while (stt.hasMoreTokens())
			{
				if (agentName.equals(stt.nextToken()))
				{
					//res += host+", ";
					tmpList.add(host);
					break;
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

	public String getAssignedHostsForRemoteAgent(String agentName)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Remote_Agent_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		for (int v=0; v<vars.length; v++)
		{
			String host = vars[v];
			String agent = extIni.getValue("Remote_Agent_Mapping_Section",host);
			if (agent.equals(agentName))
			{
				//res += host+", ";
				tmpList.add(host);
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/admin/AgentStatus/data/../../../admin/EgTrackerAJSON.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


/*
 *	Name		:	EgServerListJSON.jsp
 *	Purpose		:	To view all agents' current status
 *	Navigation	:	Home > [Click here to get the license details] > [Agent Status]
 */


/*****************************************************************************************************
 *	Name			:	EgTrackerAJSON.jsp
 *	Version			:	eG 3.1.6
 *	Purpose			:	
 *	Creation Date	:	01-03-2005.
 *	Author			:	Bala Murali
 *	Last Modified	:	
 *****************************************************************************************************/


	IniFile controlModeUIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String RightClikMode = controlModeUIni.getValue("MODE_OF_OPERATION","rightClick");
	String SelectionMode = controlModeUIni.getValue("MODE_OF_OPERATION","selection");
	EgDbAdapterUI egDbTracker = EgDbAdapterTypeUI.getObject();
	String dbTrackerStatus =egDbTracker.setConnection();
	if(dbTrackerStatus == null)
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(dbTrackerStatus != null && !dbTrackerStatus.equals("CONNECTED"))
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	egDbTracker.releaseConnection(false);
	EgDbAdapterTypeUI.releaseObject(egDbTracker);
	com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String trackerLanguage = trackerUI.getDefaultLanguage();
	ErUserData UBean = null;
	String sessionID = null;
	UserRegistry registry = null;
	User _user = null;
	boolean id_u = false;
	String u_rs = null;
	long u_v_till = 0L;
	long l_accessed = 0L;
	String admin_Skin = null;
	String throughSchedule = request.getParameter("throughSchedule");
	if(throughSchedule == null) {
		throughSchedule = "";
	}
	if(throughSchedule.equalsIgnoreCase("true"))
	{
		String usr_Id_proc = request.getParameter("er_userid");
		String usr_Id = request.getParameter("eruserid");
		String userID = request.getParameter("userID");
		if(session!=null)
		{
			 UBean = (ErUserData) session.getAttribute("UBean");
			 if(throughSchedule.equalsIgnoreCase("true")) {
				 try
				 {
					if(UBean == null)
					{
						if(usr_Id !=null && !usr_Id.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id,false);
							usr_Id_proc = usr_Id;
						}
						else if(userID != null)
						{
							UBean = new ErUserData(userID,false);
							usr_Id_proc = userID;
						}
						else if(usr_Id_proc == null || usr_Id_proc.equalsIgnoreCase("null"))
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}
						else
						{
							UBean = new ErUserData(usr_Id_proc,false);
						}

					}
				}
				catch(Throwable t)
				{
					t.printStackTrace();
				}
			}
			if(UBean != null)
			{
				registry = UserRegistry.getInstance();
				_user= registry.getUser(session.getId(),true);
				if(_user!=null)
				{
					id_u = _user.isIdDeletedWhileLoggedIn();
					if(id_u==false )
					{
						u_rs = _user.getLoginID();
						if(!User.isDefaultUser(u_rs))
						{
							u_v_till = UBean.getUserValidtill();
							l_accessed = session.getLastAccessedTime();
						}
					}
				}
				if(_user == null && usr_Id_proc!= null ) {
					try {
						_user = UBean.getUser(usr_Id_proc);
						registry.setUser(session.getId(), _user, false);
						System.out.println("Setting user object. user admin skin : " + _user.getAdminSkin());
					} catch(Exception ex) {
						System.out.println("Setting user object failed");
						ex.printStackTrace();
					}
				}
			}
		}
	}
	else
	{
		if(session!=null)
		{
			sessionID = session.getId();
			registry = UserRegistry.getInstance();
			//_user = registry.getUser(sessionID);
			_user = registry.getUser(sessionID,true);
			if(_user!=null)
			{
				id_u = _user.isIdDeletedWhileLoggedIn();
				if(id_u == false)
				{
					u_rs =  _user.getLoginID();
					if(!User.isDefaultUser(u_rs))
					{
						ErUserData er = _user.getReporterData();
						u_v_till = er.getUserValidtill();
						l_accessed = session.getLastAccessedTime();
					}
				}
			}
		}
	}

	if(session == null || _user == null)
	{
		throw new Exception("<customerror>user-session-invalid</customerror>");
	}
	else if(id_u== true)
	{
		throw new Exception("<customerror>user-deleted</customerror>");
	}
	else if (u_v_till < l_accessed)
	{
		throw new Exception("<customerror>user-timedout</customerror>");
	}
	else
	{
		if(request.getQueryString()!=null)
		{
			String Module_Name=request.getParameter("moduleName");
			if(Module_Name!=null && Module_Name.equalsIgnoreCase("ADMIN"))
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("MONITOR"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("REPORTER"))
			{
				session.setAttribute("Page_IdentifierM",request.getRequestURI()+"?"+request.getQueryString());
			}
			else if(Module_Name!=null && Module_Name.equalsIgnoreCase("CONFIGURATION"))
			{
				session.setAttribute("Page_IdentifierC",request.getRequestURI()+"?"+request.getQueryString());
			}
			else
			{
				String strQueryURI = request.getRequestURI();
				String strQueryString = request.getQueryString();
				if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
					(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
				{
					session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
				}
			}
		}
		else
		{
			String strQueryURI = request.getRequestURI();
			String strQueryString = request.getQueryString();
			if ((strQueryURI.indexOf("/EgNotificationManagerJson.jsp") == -1) && 
				(strQueryURI.indexOf("/EgDashboardAlertsJson.jsp") == -1))
			{
				session.setAttribute("Page_IdentifierA",strQueryURI+"?"+strQueryString);
			}
		}
	}
	if (_user!=null)
	{
		String trackerUserLang = _user.getLanguage();
		if (trackerUserLang!=null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			trackerLanguage=trackerUserLang;
		}
		_user.setUserLanguageAndSkins();
		admin_Skin = _user.getAdminSkin();
	}
	String script_src = "script_item_"+trackerLanguage+".js";
	EgMappingInfo _mapping = new EgMappingInfo(trackerLanguage);


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");


	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isUserBasedCert = false;
	if (usersInfo.getUserAllowedCount() > 0)
	{
		isUserBasedCert = true;
	}
	JSONObject rootJSON = new JSONObject();
	JSONArray agentTys = new JSONArray();
	for (int a=0; a<agentTypes.length; a++)
	{
		String agentType = agentTypes[a];
		if (!isUserBasedCert && agentType.equals(USER_COMP_AGENTS))
		{
			continue;
		}
		JSONObject obj = new JSONObject();
		obj.put("valueField",agentType);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+agentType));
		agentTys.add(obj);
	}
	rootJSON.put("agentTypes",agentTys);
	//For CSV
	List csvData = new ArrayList();
	csvData.add("Agents Status Report");
	csvData.add("");
	
	String agentType = request.getParameter("agent"); // Agent Type
	if (StringUtils.isNull(agentType))
	{
		agentType = agentTypes[0];
	}
	rootJSON.put("agentType",agentType);
	csvData.add("Agent Type,"+agentType);
	JSONArray agentsSts = new JSONArray();
	for (int s=0;s<agentStatus.length;s++)
	{
		String status = agentStatus[s];
		JSONObject obj = new JSONObject();
		obj.put("valueField",status);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+status));
		agentsSts.add(obj);
	}
	rootJSON.put("agentStatus",agentsSts);
	String agentState=request.getParameter("status"); // Agent status
	if (StringUtils.isNull(agentState))
	{
		agentState = agentStatus[0];
	}
	rootJSON.put("agentState",agentState);
	csvData.add("Agent Status,"+agentState);
	csvData.add("");
	//Only when search option is enabled, 'hostname' & 'search' 
	//will be obtained
	String hostname = request.getParameter("hostname");
	if(hostname == null)
		hostname = "";
	String search = request.getParameter("search");
	if(search == null)
		search = "false";

	rootJSON.put("hostname",hostname);
	rootJSON.put("search",search);
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();
	EgServerList serverList = new EgServerList();
	int totalAgentCount = (licInfo.getExternalAgents()).size() + (licInfo.getBasicAgents()).size() + (licInfo.getPremiumAgents()).size() + (licInfo.getRemoteAgents()).size();
	rootJSON.put("totalAgentCount",totalAgentCount);

	ArrayList agentList = new ArrayList();
	ArrayList allAgents = licInfo.getTotalAgents();
	if(search.equals("false"))
	{
		if(agentType.equalsIgnoreCase("ExternalAgents"))
			agentList = licInfo.getExternalAgents();
		else if(agentType.equalsIgnoreCase("BasicAgents"))
			agentList = licInfo.getBasicAgents();
		else if(agentType.equalsIgnoreCase("PremiumAgents"))
		{
			agentList = userBean.getPremiumAgents();
		}
		else if(agentType.equalsIgnoreCase("RemoteAgents"))
			agentList = licInfo.getRemoteAgents();
		else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
		{
			agentList = userBean.getPremiumAgents(true);
		}
	}
	else
	{
		StringTokenizer st1 = new StringTokenizer(hostname);
		while (st1.hasMoreTokens())
		{
			String Token = st1.nextToken().trim();
			if (Token.equals("") || Token.length() == 0)
				continue;
			agentList.add(Token);
		}
		if(!agentList.contains(hostname.trim()))
		{
			agentList.add(hostname.trim());
		}
	}
	List csvAssignHosts = new ArrayList();
	if(agentList == null || agentList.size() == 0)
	{
		rootJSON.put("noManagedHostsFound",true);
		csvData.add("-No Agents Found-");
	}
	else
	{
		if(search.equals("true"))
		{
			ArrayList comps = (ArrayList)agentList.clone();
			ArrayList newGetreqArraylist = new ArrayList();
			agentList.clear();
			for(int i=0;i<comps.size(); i++)
			{
				String comp_name = (String)comps.get(i);
				comp_name = comp_name.trim();
				if(agentType.equalsIgnoreCase("ExternalAgents"))
					allAgents=licInfo.getExternalAgents(); 
				else if(agentType.equalsIgnoreCase("BasicAgents"))
					allAgents=licInfo.getBasicAgents();
				else if(agentType.equalsIgnoreCase("PremiumAgents"))
					allAgents = userBean.getPremiumAgents();
				else if(agentType.equalsIgnoreCase("RemoteAgents"))
					allAgents=licInfo.getRemoteAgents();
				else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
					allAgents = userBean.getPremiumAgents(true);

				for(int j=0;j<allAgents.size(); j++)
				{
					if(((String)allAgents.get(j)).toLowerCase().indexOf(comp_name.toLowerCase()) > -1)
					{
						if(!agentList.contains(allAgents.get(j)))
							agentList.add(allAgents.get(j));
					}
				}
			}
		}
		Hashtable nick_ip_map = new com.eg.EgDiscInfo("manager").getNickIpMap();
		if(nick_ip_map == null)
		{
			nick_ip_map = new Hashtable();
		}
		IniFile agentStatus_ini =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentoutputstatus.ini");
		Hashtable debug_status = new Hashtable();
		String variables_ini[] = agentStatus_ini.getVariables("AGENT_OUTPUT_STATUS");
		if(variables_ini != null && variables_ini.length>0)
		{
			for(int i=0;i<variables_ini.length;i++)
			{
				debug_status.put(variables_ini[i],agentStatus_ini.getValue("AGENT_OUTPUT_STATUS",variables_ini[i]));
			}
		}

		ArrayList totalAgents = null;
		ArrayList a_tmp = new ArrayList();
		a_tmp.add("Not Installed-Not Running");
		a_tmp.add("Installed-Not Running");
		a_tmp.add("Installed-Running");

		//coding insertion for sorted list of agents according to ip and status starts
		Vector v1=new Vector();
		Vector v2=new Vector();
		Vector v3=new Vector();
		String agentIP = "";
		String message = "";
		String installed = "";
		String insGif  = "";
		String running  = "";
		String runGif  = "";
		ArrayList agentless=new ArrayList();
		ArrayList agentlesscom=new ArrayList();
		ArrayList aList = serverList.getAgentListFromDB();
		String currList[] = serverList.getTargetNames();
		totalAgents=serverList.getAgentList(agentList,aList,currList);

		if(totalAgents.size() > 0)
		{
			for(int j=0;j<totalAgents.size();j=j+4)
			{
				agentIP = (String)totalAgents.get(j);
				message = (String)totalAgents.get(j+1);
				if(agentState.equalsIgnoreCase("All")||agentState.equalsIgnoreCase("NotRunning"))
				{
					if(message.equals("Not Installed-Not Running"))
						v1.add(agentIP);
					else if(message.equals("Installed-Not Running"))
						v2.add(agentIP);
				}
				if(agentState.equalsIgnoreCase("All")||agentState.equalsIgnoreCase("Running"))
				{
					if(message.equals("Installed-Running"))
					v3.add(agentIP);
				}
			}
		}
		totalAgents.clear();
		Collections.sort(v1,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v1.size();i++)
		{
			totalAgents.add(v1.get(i));
			totalAgents.add("Not Installed-Not Running");
			totalAgents.add("/final/admin/eg_images/Installed-Not.gif");
			totalAgents.add("eg_images/newnotrunning2.gif");
		}
		Collections.sort(v2,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v2.size();i++)
		{
			totalAgents.add(v2.get(i));
			totalAgents.add("Installed-Not Running");
			totalAgents.add("/final/admin/eg_images/Installed-Running.gif");
			totalAgents.add("eg_images/newnotrunning2.gif");
		}
		Collections.sort(v3,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v3.size();i++)
		{
			totalAgents.add(v3.get(i));
			totalAgents.add("Installed-Running");
			totalAgents.add("/final/admin/eg_images/Installed-Running.gif");
			totalAgents.add("eg_images/newstatus.gif");
		}
		v1=null;v2=null;v3=null;
		JSONArray agentsDetails = new JSONArray();
		if(totalAgents.size() > 0)
		{
			csvData.add("Total number of Agents,"+(totalAgents.size()/4));
			csvData.add("");
			csvData.add("Agent IP/Nickname,Installed,Status,Output Logging Enabled");
			rootJSON.put("enableSearch",true);
			rootJSON.put("managedHostsFoundForSearch",true);
			for(int i=0;i<totalAgents.size();i=i+4)
			{
				boolean border=(i+4)<totalAgents.size();
				agentIP = (String)totalAgents.get(i);
				message = (String)totalAgents.get(i+1);
				installed = message.substring(0,message.indexOf("-"));
				insGif = (String)totalAgents.get(i+2);
				running = message.substring(message.indexOf("-")+1);
				runGif = (String)totalAgents.get(i+3);

				String restartFlg = "No";
				if(installed != null && (installed.equals("Not Installed") || running.equals("Not Running")))
				{
					restartFlg = "No";
				}
				else
				{
					restartFlg = "Yes";
				}
				//String onSelected="";
				//String offSelected="";
				boolean output = false;
				String agent_ip_address=null;
				String debugStatus=null;
				if(nick_ip_map.containsKey(agentIP))
				{
					agent_ip_address = (String)nick_ip_map.get(agentIP);
				}
				if(agent_ip_address != null && debug_status.containsKey(agent_ip_address))
				{
					debugStatus = (String)debug_status.get(agent_ip_address);
				}
				if(debugStatus != null && debugStatus.equalsIgnoreCase("yes"))
				{
					//onSelected = "selected";
					//offSelected = "";
					output=true;
				}
				else
				{
					//onSelected = "";
					//offSelected = "selected";
					output=false;
				}//AgentIP/Nickname-Installed-Status-Output-Restart-Logs
				rootJSON.put(agentIP+"_IP",agent_ip_address);
				JSONObject obj = new JSONObject();
				String tempInstalled = "Yes";
				if (installed.equalsIgnoreCase("Not Installed"))
				{
					tempInstalled = "No";
				}
				obj.put("AgentIP",agentIP+'~'+tempInstalled);
				obj.put("Installed",tempInstalled);
				obj.put("Status",running);
				obj.put("Output",output);
				obj.put("Restart",restartFlg+"~"+agentIP);
				String csvOutput = "No";
				if (output)
					csvOutput = "Yes";
				csvData.add(agentIP+","+tempInstalled+","+running+","+csvOutput);
				if(installed.equalsIgnoreCase("Not Installed") || running.equalsIgnoreCase("Not Running"))
				{
					obj.put("Logs","DoNotShow");
				}
				else
				{
					obj.put("Logs","Show");
				}
				if(agentType.equalsIgnoreCase("ExternalAgents"))
				{
					String hosts = getAssignedHostsForExternalAgent(agentIP);
					if(hosts.trim().equals(""))
						hosts = "- No assigned hosts found -";
					obj.put("AssignedHosts",hosts);
					csvAssignHosts.add(agentIP+"#@#"+hosts);
				}
				else if (agentType.equalsIgnoreCase("RemoteAgents"))
				{
					String hosts = getAssignedHostsForRemoteAgent(agentIP);
					if(hosts.trim().equals(""))
						hosts = "- No assigned hosts found -";
					obj.put("AssignedHosts",hosts);
					csvAssignHosts.add(agentIP+"#@#"+hosts);
				}
				obj.put("StopAgent",restartFlg+"~"+agentIP);
				agentsDetails.add(obj);
			}
		}
		else
		{
			rootJSON.put("enableSearch",false);
			rootJSON.put("managedHostsFoundForSearch",false);
		}
		rootJSON.put("agentDetails",agentsDetails);
	}
	if (csvAssignHosts.size() > 0)
	{
		String agentIPs = "";
		int big = 0;
		ArrayList allAssignHosts = new ArrayList();
		for (int c=0; c<csvAssignHosts.size(); c++)
		{
			String tmpStr = csvAssignHosts.get(c).toString();
			String agent = tmpStr.substring(0,tmpStr.indexOf("#@#"));
			String assignHosts = tmpStr.substring(tmpStr.indexOf("#@#")+3);
			ArrayList assignHostsList = StringUtils.egTokenizer(assignHosts,",");
			int size = assignHostsList.size();
			agentIPs += agent +" ("+size+")"+",";
			if(size > big)
				big = size;

			allAssignHosts.add(assignHostsList);
		}
		csvData.add("");
		csvData.add("");
		csvData.add("Assigned Hosts");
		csvData.add("");
		csvData.add(agentIPs);
		csvData.add("");
		for (int b=0; b<big; b++)
		{
			String row = "";
			for(int a=0; a<allAssignHosts.size(); a++)
			{
				ArrayList tmpList = (ArrayList)allAssignHosts.get(a);
				if(b < tmpList.size())
				{
					row += tmpList.get(b).toString()+",";
				}
				else
				{
					row += ""+",";
				}				
			}
			csvData.add(row);
		}
	}
	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	out.println(rootJSON);

    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
