/**
 * List compiled by mystix on the extjs.com forums.
 * Thank you Mystix!
 *
 * Turkish translation by Alper YAZGAN
 * 2008-01-24, 10:29 AM
 *
 * Updated to 2.2 by YargicX
 * 2008-10-05, 06:22 PM
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Yȭkleniyor ...</div>';
    }

    Ext.define("Ext.locale.tr.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.tr.grid.Grid", {
        override: "Ext.grid.Grid",
        ddText: "SeȺili satȻr sayȻsȻ : {0}"
    });

    Ext.define("Ext.locale.tr.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Sekmeyi kapat"
    });

    Ext.define("Ext.locale.tr.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Bu alandaki deȗer geȺersiz"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.tr.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Yȭkleniyor ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Ocak", "Ȥʾubat", "Mart", "Nisan", "MayȻs", "Haziran", "Temmuz", "Aȗustos", "Eylȭl", "Ekim", "KasȻm", "AralȻk"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            Jan: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            May: 4,
            Jun: 5,
            Jul: 6,
            Aug: 7,
            Sep: 8,
            Oct: 9,
            Nov: 10,
            Dec: 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Pazar", "Pazartesi", "SalȻ", "arȾʹamba", "PerȾʹembe", "Cuma", "Cumartesi"];

        Ext.Date.shortDayNames = ["Paz", "Pzt", "Sal", "rȾʹ", "PrȾ", "Cum", "Cmt"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.shortDayNames[day];
        };
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "Tamam",
            cancel: "×ptal",
            yes: "Evet",
            no: "HayȻr"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'TL',
            // Turkish Lira
            dateFormat: 'd/m/Y'
        });
    }

    Ext.define("Ext.locale.tr.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Bugȭn",
        minText: "Bu tarih izin verilen en kȭȺȭk tarihten daha ȵnce",
        maxText: "Bu tarih izin verilen en bȭyȭk tarihten daha sonra",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Gelecek Ay (Control+Right)',
        prevText: 'nceki Ay (Control+Left)',
        monthYearText: 'Bir ay sʹeȺiniz (YȻlȻ artȻrmak/azaltmak iȺin Control+Up/Down)',
        todayTip: "{0} (BoȾʹluk TuȾʹu - Spacebar)",
        format: "d/m/Y",
        startDay: 1
    });

    Ext.define("Ext.locale.tr.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;Tamam&#160;",
        cancelText: "×ptal"
    });

    Ext.define("Ext.locale.tr.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Sayfa",
        afterPageText: " / {0}",
        firstText: "×lk Sayfa",
        prevText: "nceki Sayfa",
        nextText: "Sonraki Sayfa",
        lastText: "Son Sayfa",
        refreshText: "Yenile",
        displayMsg: "Gȵsterilen {0} - {1} / {2}",
        emptyMsg: 'Gȵsterilebilecek veri yok'
    });

    Ext.define("Ext.locale.tr.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Girilen verinin uzunluȗu en az {0} olabilir",
        maxLengthText: "Girilen verinin uzunluȗu en fazla {0} olabilir",
        blankText: "Bu alan boȾʹ bȻrakȻlamaz",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.tr.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "En az {0} girilebilir",
        maxText: "En Ⱥok {0} girilebilir",
        nanText: "{0} geȺersiz bir sayȻdȻr"
    });

    Ext.define("Ext.locale.tr.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Disabled",
        disabledDatesText: "Disabled",
        minText: "Bu tarih, {0} tarihinden daha sonra olmalȻdȻr",
        maxText: "Bu tarih, {0} tarihinden daha ȵnce olmalȻdȻr",
        invalidText: "{0} geȺersiz bir tarihdir - tarih formatȻ {1} Ⱦʹeklinde olmalȻdȻr",
        format: "d/m/Y",
        altFormats: "d.m.y|d.m.Y|d/m/y|d-m-Y|d-m-y|d.m|d/m|d-m|dm|dmY|dmy|d|Y.m.d|Y-m-d|Y/m/d"
    });

    Ext.define("Ext.locale.tr.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Yȭkleniyor ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.form.field.VTypes["emailText"] = 'Bu alan "user@example.com" Ⱦʹeklinde elektronik posta formatȻnda olmalȻdȻr';
        Ext.form.field.VTypes["urlText"] = 'Bu alan "http://www.example.com" Ⱦʹeklinde URL adres formatȻnda olmalȻdȻr';
        Ext.form.field.VTypes["alphaText"] = 'Bu alan sadece harf ve _ iȺermeli';
        Ext.form.field.VTypes["alphanumText"] = 'Bu alan sadece harf, sayȻ ve _ iȺermeli';
    }

    Ext.define("Ext.locale.tr.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'Lȭtfen bu baȗlantȻ iȺin gerekli URL adresini giriniz:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'KalȻn(Bold) (Ctrl+B)',
                    text: 'ȤʾeȺili yazȻyȻ kalȻn yapar.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: '×talik(Italic) (Ctrl+I)',
                    text: 'ȤʾeȺili yazȻyȻ italik yapar.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Alt izgi(Underline) (Ctrl+U)',
                    text: 'ȤʾeȺili yazȻnȻn altȻnȻ Ⱥizer.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Fontu bȭyȭlt',
                    text: 'YazȻ fontunu bȭyȭtȭr.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Fontu kȭȺȭlt',
                    text: 'YazȻ fontunu kȭȺȭltȭr.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Arka Plan Rengi',
                    text: 'SeȺili yazȻnȻn arka plan rengini deȗiȾʹtir.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'YazȻ Rengi',
                    text: 'SeȺili yazȻnȻn rengini deȗiȾʹtir.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Sola Daya',
                    text: 'YazȻyȻ sola daya.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Ortala',
                    text: 'YazȻyȻ editȵrde ortala.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Saȗa daya',
                    text: 'YazȻyȻ saȗa daya.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'NoktalȻ Liste',
                    text: 'NoktalȻ listeye baȾʹla.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'NumaralȻ Liste',
                    text: 'NumaralȻ lisyeye baȾʹla.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Web Adresi(Hyperlink)',
                    text: 'SeȺili yazȻyȻ web adresi(hyperlink) yap.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Kaynak kodu Dȭzenleme',
                    text: 'Kaynak kodu dȭzenleme moduna geȺ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.tr.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Artan sȻrada sȻrala",
        sortDescText: "Azalan sȻrada sȻrala",
        lockText: "Kolonu kilitle",
        unlockText: "Kolon kilidini kaldȻr",
        columnsText: "Kolonlar"
    });

    Ext.define("Ext.locale.tr.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Yok)',
        groupByText: 'Bu Alana Gȵre Grupla',
        showGroupsText: 'Gruplar Halinde Gȵster'
    });

    Ext.define("Ext.locale.tr.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Ad",
        valueText: "Deȗer",
        dateFormat: "d/m/Y"
    });

});
