
/**
 * Russian translation
 * By ZooKeeper (utf-8 encoding)
 * 6 November 2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ϳϴ ϸϗϸϦϗ...</div>';
    }

    Ext.define("Ext.locale.ru.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.ru.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ϙϘϗϻϻ ϾϦ"
    });

    Ext.define("Ext.locale.ru.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ϗϦ  ϙϦϩϗϳϦ"
    });

    Ext.define("Ext.locale.ru.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ϻϗϴϻϹϴ ϙ Ͼϭ Ͼϩϴ ϻϴϙϴϻϾϴ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.ru.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ϗϸϦϗ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ϯϻϙϗ", "ϴϙϗϩ", "ϣϗ", "ϴϩ", "ϣϗϠ", "ϻ", "ϩ", "ϙ", "ϴϻϘ", "ϤϦϘ", "ϥϾϘ", "ϴϦϗϘ"];

        Ext.Date.shortMonthNames = ["ϯϻϙ", "ϴϙ", "ϣϗ", "", "ϣϗϠ", "ϻ", "ϩ", "ϙ", "ϴϻ", "ϤϦ", "ϥϾϘ", "ϴϦ"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.shortMonthNames[month];
        };

        Ext.Date.monthNumbers = {
            'ϯϻϙ': 0,
            'ϴϙ': 1,
            'ϣϗ': 2,
            '': 3,
            'ϣϗϠ': 4,
            'ϻ': 5,
            'ϩ': 6,
            'ϙ': 7,
            'ϴϻ': 8,
            'ϤϦ': 9,
            'ϥϾ': 10,
            'ϴϦ': 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["ϾϦϴϴϻϴ", "ϖϾϻϴϳϴϩϻϹϦ", "ϾϻϹϦ", "ϴϳϗ", "Ϻϴϙϴ", "ϖϻϹϗ", "ϘϘϾϗ"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }
    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Ϥϭϴϻϗ",
            yes: "ϗ",
            no: "ϥϴ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u0440\u0443\u0431',
            // Russian Ruble
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.ru.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "ϴϾϳϻ",
        minText: "ϡϗ ϳϗϗ ϗϻϴ ϭϹϻϹϭϗϩϻϾϠ ϳϗ",
        maxText: "ϡϗ ϳϗϗ Ͼϸϵϴ ϭϗϦϹϭϗϩϻϾϠ ϳϗ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'ϩϴϳϹϠ ϭϴ (Control+ϗϙϾ)',
        prevText: 'ϖϴϳϳϹϠ ϭϴ (Control+ϩϴϙϾ)',
        monthYearText: 'ϘϾ ϭϴϗ (Control+ϙϴ/ϻϹϸ ϳϩ ϙϘϾϗ Ͼϳϗ)',
        todayTip: "{0} (ϖϾϘϴϩ)",
        format: "d.m.y",
        startDay: 1
    });

    Ext.define("Ext.locale.ru.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Ϥϭϴϻϗ"
    });

    Ext.define("Ext.locale.ru.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "ϗϻϹϗ",
        afterPageText: "Ϲϸ {0}",
        firstText: "ϖϴϙϗ ϗϻϹϗ",
        prevText: "ϖϴϳϳϗ ϗϻϹϗ",
        nextText: "ϩϴϳϗ ϗϻϹϗ",
        lastText: "ϖϾϩϴϳϻ ϗϻϹϗ",
        refreshText: "ϤϘϻϾϙϹ",
        displayMsg: "ϤϾϘϗϵϗ ϸϗϹϹ  {0} Ͼ {1}, ϙϴϾ {2}",
        emptyMsg: 'ϥϴ ϳϗϻϻ ϳϩ ϾϾϘϗϵϴϻϹ'
    });

    Ext.define("Ext.locale.ru.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "ϣϹϻϹϭϗϩϻϗ ϳϩϹϻϗ ϾϾ Ͼϩ {0}",
        maxLengthText: "ϣϗϦϹϭϗϩϻϗ ϳϩϹϻϗ ϾϾ Ͼϩ {0}",
        blankText: "ϡϾ Ͼϩϴ ϾϘϸϗϴϩϻϾ ϳϩ ϸϗϾϩϻϴϻϹ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.ru.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "ϻϗϴϻϹϴ ϾϾ Ͼϩ ϻϴ ϭϾϵϴ Ϙ ϭϴϻϴ {0}",
        maxText: "ϻϗϴϻϹϴ ϾϾ Ͼϩ ϻϴ ϭϾϵϴ Ϙ ϘϾϩϴ {0}",
        nanText: "{0} ϻϴ ϙϩϴ ϹϩϾϭ"
    });

    Ext.define("Ext.locale.ru.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "ϥϴ ϳϾϻϾ",
        disabledDatesText: "ϥϴ ϳϾϻϾ",
        minText: "ϗϗ ϙ Ͼϭ Ͼϩϴ ϳϾϩϵϻϗ Ϙ Ͼϸϳϴ {0}",
        maxText: "ϗϗ ϙ Ͼϭ Ͼϩϴ ϳϾϩϵϻϗ Ϙ ϗϻϴ {0}",
        invalidText: "{0} ϻϴ ϙϩϴ ϗϙϹϩϻϾϠ ϳϗϾϠ - ϳϗϗ ϳϾϩϵϻϗ Ϙ Ϧϗϸϗϻϗ ϙ Ͼϭϗϴ {1}",
        format: "d.m.y",
        altFormats: "d.m.y|d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
    });

    Ext.define("Ext.locale.ru.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ϗϸϦϗ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'ϡϾ Ͼϩϴ ϳϾϩϵϻϾ Ͼϳϴϵϗ ϗϳϴ ϩϴϦϾϻϻϾϠ Ͼ ϙ Ͼϭϗϴ "user@example.com"',
            urlText: 'ϡϾ Ͼϩϴ ϳϾϩϵϻϾ Ͼϳϴϵϗ URL ϙ Ͼϭϗϴ "http:/' + '/www.example.com"',
            alphaText: 'ϡϾ Ͼϩϴ ϳϾϩϵϻϾ Ͼϳϴϵϗ ϾϩϦϾ ϩϗϹϻϦϹϴ ϘϦϙ Ϲ ϹϭϙϾϩ ϾϳϴϦϹϙϗϻϹ "_"',
            alphanumText: 'ϡϾ Ͼϩϴ ϳϾϩϵϻϾ Ͼϳϴϵϗ ϾϩϦϾ ϩϗϹϻϦϹϴ ϘϦϙ, Ϲ Ϲ ϹϭϙϾϩ ϾϳϴϦϹϙϗϻϹ "_"'
        });
    }

    Ext.define("Ext.locale.ru.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'ϖϾϵϗϩϠϗ ϙϙϴϳϹϴ ϗϳϴ:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'ϖϾϩϵϹϻϠ (Ctrl+B)',
                    text: 'ϖϹϭϴϻϴϻϹϴ ϾϩϵϹϻϾϾ ϻϗϴϗϻϹ Ϧ ϙϳϴϩϴϻϻϾϭ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Ϲϙ (Ctrl+I)',
                    text: 'ϖϹϭϴϻϴϻϹϴ ϦϹϙϻϾϾ ϻϗϴϗϻϹ Ϧ ϙϳϴϩϴϻϻϾϭ ϴϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'ϖϾϳϦϻϠ (Ctrl+U)',
                    text: 'ϖϾϳϦϹϙϗϻϹϴ ϙϳϴϩϴϻϻϾϾ ϴϦϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'ϙϴϩϹϹ ϗϸϭϴ',
                    text: 'ϙϴϩϹϴϻϹϴ ϗϸϭϴϗ Ϲϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'ϭϴϻϹ ϗϸϭϴ',
                    text: 'ϭϴϻϴϻϹϴ ϗϸϭϴϗ Ϲϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'ϗϩϹϙϦϗ',
                    text: 'ϸϭϴϻϴϻϹϴ ϙϴϗ Ͼϻϗ ϳϩ ϙϳϴϩϴϻϻϾϾ ϴϦϗ ϹϩϹ ϗϘϸϗϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Ϫϙϴ ϴϦϗ',
                    text: 'ϸϭϴϻϹϴ ϙϴϗ ϴϦϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Ͼϙϻ ϴϦ Ͼ ϩϴϙϾϭ Ϧϗ',
                    text: 'ϾϙϻϹϙϗϻϹϴ ϴϦϗ Ͼ ϩϴϙϾϭ Ϧϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'ϖϾ ϴϻ',
                    text: 'ϾϙϻϹϙϗϻϹϴ ϴϦϗ Ͼ ϴϻ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Ͼϙϻ ϴϦ Ͼ ϗϙϾϭ Ϧϗ',
                    text: 'ϾϙϻϹϙϗϻϹϴ ϴϦϗ Ͼ ϗϙϾϭ Ϧϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'ϣϗϦϴ',
                    text: 'ϥϗϗ ϭϗϦϹϾϙϗϻϻϠ ϹϾϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'ϥϭϴϗϹ',
                    text: 'ϥϗϗ ϻϭϴϻϾϙϗϻϻϠ ϹϾϦ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'ϗϙϹ ϹϴϩϦ',
                    text: 'ϾϸϳϗϻϹϴ ϩϦϹ Ϲϸ ϙϳϴϩϴϻϻϾϾ ϴϦϗ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'ϾϳϻϠ ϦϾϳ',
                    text: 'ϖϴϴϦϩϹ ϻϗ ϹϾϳϻϠ ϦϾϳ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.ru.form.Basic", {
        override: "Ext.form.Basic",
        waitTitle: "ϖϾϵϗϩϠϗ ϾϳϾϵϳϹϴ..."
    });

    Ext.define("Ext.locale.ru.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "ϾϹϾϙϗ Ͼ ϙϾϸϗϗϻϹ",
        sortDescText: "ϾϹϾϙϗ Ͼ ϘϙϗϻϹ",
        lockText: "ϗϦϴϹ ϾϩϘϴ",
        unlockText: "ϻ ϸϗϦϴϩϴϻϹϴ ϾϩϘϗ",
        columnsText: "ϾϩϘ"
    });

    Ext.define("Ext.locale.ru.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(ϖϾ)',
        groupByText: 'ϹϾϙϗ Ͼ Ͼϭ Ͼϩ',
        showGroupsText: 'ϤϾϘϗϵϗ Ͼ ϗϭ'
    });

    Ext.define("Ext.locale.ru.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "ϥϗϸϙϗϻϹϴ",
        valueText: "ϻϗϴϻϹϴ",
        dateFormat: "d.m.Y"
    });

    Ext.define("Ext.locale.ru.SplitLayoutRegion", {
        override: "Ext.SplitLayoutRegion",
        splitTip: "ϻϹϴ ϳϩ ϹϸϭϴϻϴϻϹ ϗϸϭϴϗ.",
        collapsibleSplitTip: "ϻϹϴ ϳϩ ϹϸϭϴϻϴϻϹ ϗϸϭϴϗ. ϙϾϠϻϾϠ ϴϩϾϦ ϴ ϗϻϴϩ."
    });

});
