/**
 * Lithuanian Translations (UTF-8)
 * Vladas Saulis (vladas at prodata dot lt),  03-29-2009
 * Vladas Saulis (vladas at prodata dot lt),  10-18-2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Kraunasi...</div>';
    }

    Ext.define("Ext.locale.lt.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.lt.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.lt.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} paʾymt eilui"
    });

    Ext.define("Ext.locale.lt.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Uʾdaryti i uʾskland"
    });

    Ext.define("Ext.locale.lt.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "io lauko reikm neteisinga"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.lt.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Kraunasi..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Sausis", "Vasaris", "Kovas", "Balandis", "Geguʾ", "Birʾelis", "Liepa", "Rugpjʽtis", "Rugsjis", "Spalis", "Lapkritis", "Gruodis"];

        Ext.Date.getShortMonthName = function(month) {
            // Uncommons
            if (month == 7) return "Rgp";
            if (month == 8) return "Rgs";
            if (month == 11) return "Grd";
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            Sau: 0,
            Vas: 1,
            Kov: 2,
            Bal: 3,
            Geg: 4,
            Bir: 5,
            Lie: 6,
            Rgp: 7,
            Rgs: 8,
            Spa: 9,
            Lap: 10,
            Grd: 11
        };

        Ext.Date.getMonthNumber = function(name) {

            // Some uncommons
            if (name == "Rugpjʽtis") return 7;
            if (name == "Rugsjis") return 8;
            if (name == "Gruodis") return 11;
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Sekmadienis", "Pirmadienis", "Antradienis", "Treiadienis", "Ketvirtadienis", "Penktadienis", "etadienis"];

        Ext.Date.parseCodes.S.s = "(?:as|as|as|as)";

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }
    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "Gerai",
            cancel: "Atsisakyti",
            yes: "Taip",
            no: "Ne"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'Lt',
            // Lithuanian Litai
            dateFormat: 'Y-m-d'
        });
    }

    Ext.define("Ext.locale.lt.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "iandien",
        minText: "i data yra maʾesn uʾ leistin",
        maxText: "i data yra didesn uʾ leistin",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Kitas mnuo (Control+Right)',
        prevText: 'Ankstesnis mnuo (Control+Left)',
        monthYearText: 'Pasirinkti mnes (Control+Up/Down perjimui tarp met)',
        todayTip: "{0} (Tarpas)",
        format: "y-m-d",
        startDay: 1
    });

    Ext.define("Ext.locale.lt.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;Gerai&#160;",
        cancelText: "Atsisaktyi"
    });

    Ext.define("Ext.locale.lt.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Puslapis",
        afterPageText: "i {0}",
        firstText: "Pirmas puslapis",
        prevText: "Ankstesnis pusl.",
        nextText: "Kitas puslapis",
        lastText: "Pakutinis pusl.",
        refreshText: "Atnaujinti",
        displayMsg: "Rodomi raai {0} - {1} i {2}",
        emptyMsg: 'Nra duomen'
    });

    Ext.define("Ext.locale.lt.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Minimalus io lauko ilgis yra {0}",
        maxLengthText: "Maksimalus io lauko ilgis yra {0}",
        blankText: "is laukas yra privalomas",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.lt.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Minimalus io lauko ilgis yra {0}",
        maxText: "Maksimalus io lauko ilgis yra {0}",
        nanText: "{0} yra neleistina reikm"
    });

    Ext.define("Ext.locale.lt.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Neprieinama",
        disabledDatesText: "Neprieinama",
        minText: "iame lauke data turi bʽti didesn uʾ {0}",
        maxText: "iame lauke data turi bʽti maʾesn uʾ {0}",
        invalidText: "{0} yra neteisinga data - ji turi bʽti vesta formatu {1}",
        format: "y-m-d",
        altFormats: "y-m-d|y/m/d|Y-m-d|m/d|m-d|md|ymd|Ymd|d|Y-m-d"
    });

    Ext.define("Ext.locale.lt.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Kraunasi..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'iame lauke turi bʽti el.pato adresas formatu "user@example.com"',
            urlText: 'iame lauke turi bʽti nuoroda (URL) formatu "http:/' + '/www.example.com"',
            alphaText: 'iame lauke gali bʽti tik raids ir ʾenklas "_"',
            alphanumText: 'iame lauke gali bʽti tik raids, skaiiai ir ʾenklas "_"'
        });
    }

    Ext.define("Ext.locale.lt.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'veskite URL iai nuorodai:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'Bold (Ctrl+B)',
                    text: 'Teksto parykinimas.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Italic (Ctrl+I)',
                    text: 'Kursyvinis tekstas.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Underline (Ctrl+U)',
                    text: 'Teksto pabraukimas.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Padidinti rift',
                    text: 'Padidinti rifto dyd.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Sumaʾinti rift',
                    text: 'Sumaʾinti rifto dyd.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Nuspalvinti teksto fon',
                    text: 'Pakeisti teksto fono spalv.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Teksto spalva',
                    text: 'Pakeisti paʾymto teksto spalv.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Ilyginti kairen',
                    text: 'Ilyginti tekst  kair.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Centruoti tekst',
                    text: 'Centruoti tekt redaktoriaus lange.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Ilyginti deinn',
                    text: 'Ilyginti tekst  dein.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Paprastas sraas',
                    text: 'Pradti neorganizuot sra.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Numeruotas sraas',
                    text: 'Pradti numeruot sra.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Nuoroda',
                    text: 'Padaryti paʾymta tekst nuoroda.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Ieities tekstas',
                    text: 'Persijungti  ieities teksto koregavimo reʾim.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.lt.form.Basic", {
        override: "Ext.form.Basic",
        waitTitle: "Palaukite..."
    });

    Ext.define("Ext.locale.lt.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Rʽiuoti didjania tvarka",
        sortDescText: "Rʽiuoti maʾjania tvarka",
        lockText: "Uʾfiksuoti stulpel",
        unlockText: "Atlaisvinti stulpel",
        columnsText: "Stulpeliai"
    });

    Ext.define("Ext.locale.lt.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Nra)',
        groupByText: 'Grupuoti pagal  lauk',
        showGroupsText: 'Rodyti grupse'
    });

    Ext.define("Ext.locale.lt.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Pavadinimas",
        valueText: "Reikm",
        dateFormat: "Y-m-d"
    });

    Ext.define("Ext.locale.lt.form.field.Time", {
        override: "Ext.form.field.Time",
        minText: "Laikas turi buti lygus arba vlesnis uʾ {0}",
        maxText: "Laikas turi bʽti lygus arba ankstesnis uʾ {0}",
        invalidText: "{0} yra neteisingas laikas",
        format: "H:i",
        altFormats: "g:ia|g:iA|g:i a|g:i A|h:i|g:i|H:i|ga|ha|gA|h a|g a|g A|gi|hi|gia|hia|g|H"
    });

    Ext.define("Ext.locale.lt.form.CheckboxGroup", {
        override: "Ext.form.CheckboxGroup",
        blankText: "Jʽs turite padaryti bent vien pasirinkim ioje grupje"
    });

    Ext.define("Ext.locale.lt.form.RadioGroup", {
        override: "Ext.form.RadioGroup",
        blankText: "Jʽs turite padaryti bent vien pasirinkim ioje grupje"
    });
});
