/**
 * Korean Translations By nicetip
 * 05 September 2007
 * Modify by techbug / 25 February 2008
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">...</div>';
    }

    Ext.define("Ext.locale.ko.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.ko.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0}  ⥋贋."
    });

    Ext.define("Ext.locale.ko.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ｊ"
    });

    Ext.define("Ext.locale.ko.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ѹ ƌ ֋."
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.ko.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];

        Ext.Date.dayNames = ["", "", "", "", "", "", ""];
    }
    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "򌥹",
            cancel: "",
            yes: "",
            no: ""
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ',',
            decimalSeparator: '.',
            currencySign: '\u20a9',
            // Korean Won
            dateFormat: 'm/d/Y'
        });
    }

    Ext.define("Ext.locale.ko.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "",
        minText: " ጺѭ 贋.",
        maxText: " ጺѭ 贋.",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: '(蹋+ѹ 鳍)',
        prevText: ' (蹋+֭ 鳍)',
        monthYearText: ' ⥍乌. (蹋+/䋤 鳍)',
        todayTip: "{0} ()",
        format: "m/d/y",
        startDay: 0
    });

    Ext.define("Ext.locale.ko.picker.Month", {
        override: "Ext.picker.Month",
        okText: "򌥹",
        cancelText: ""
    });

    Ext.define("Ext.locale.ko.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "",
        afterPageText: "/ {0}",
        firstText: " ",
        prevText: " ",
        nextText: " ",
        lastText: "ꌺǋ ",
        refreshText: "ጠ",
        displayMsg: "䌙 {2}  {0} - {1}",
        emptyMsg: '棌 엌䗊 贋.'
    });

    Ext.define("Ext.locale.ko.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: " {0}.",
        maxLengthText: "Ǌ {0}.",
        blankText: "ƌ э乌.",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.ko.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "ƌ {0}.",
        maxText: "Ǌƌ {0}.",
        nanText: "{0} ѹ 꽌Ɋ ֋."
    });

    Ext.define("Ext.locale.ko.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "֣",
        disabledDatesText: "֣",
        minText: "{0}  .",
        maxText: "{0} 䌥 .",
        invalidText: "{0} ѹ ጺ樓 ֋. -  ֌ 樓 . {1}",
        format: "m/d/y"
    });

    Ext.define("Ext.locale.ko.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: '  樓  э. (: "user@example.com")',
            urlText: 'URL 樓  э. (: "http:/' + '/www.example.com")',
            alphaText: ', (_) э  贋.',
            alphanumText: ', 꽌, (_) э  贋.'
        });
    }

    Ext.define("Ext.locale.ko.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'URL э乌:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: ' (Ctrl+B)',
                    text: '⥍ 蹋ѭ  棌.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'ܹ䊭 (Ctrl+I)',
                    text: '⥍ 蹋ѭ ܹ䊭 棌.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: ' (Ctrl+U)',
                    text: '⥍ 蹌 䌥 棌.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Ǌ ',
                    text: 'Ǌ ѭ  .',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Ǌ 䌤',
                    text: 'Ǌ ѭ 抙 .',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: '  ',
                    text: '⥍ 蹌 댥 Ǌ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Ǌ',
                    text: '⥍ 蹌 댥 Ǌ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: ' ֭ ',
                    text: '֭ 蹋ѭ ы.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'ǌܳ ',
                    text: 'ǌܳ엌 蹋ѭ ы.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: ' ѹ ',
                    text: 'ѹ 蹋ѭ ы.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'ǋ ',
                    text: 'ǋ   .',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: ' 񊹗',
                    text: ' 񊹗  .',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: '쭋',
                    text: '⥍ 蹌 쭋ѭ .',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Ĺ',
                    text: 'Ĺ  Ǎ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.ko.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "䌗 ",
        sortDescText: "鳋 ",
        lockText: " ኹ",
        unlockText: " ኹ",
        columnsText: " "
    });

    Ext.define("Ext.locale.ko.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(None)',
        groupByText: '䌤  .',
        showGroupsText: ' '

    });

    Ext.define("Ext.locale.ko.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "򡋬",
        valueText: "",
        dateFormat: "m/j/Y"
    });

});
