
/**
 * List compiled by mystix on the extjs.com forums.
 * Thank you Mystix!
 *
 * Hungarian Translations (utf-8 encoded)
 * by Amon <amon@theba.hu> (27 Apr 2008)
 * encoding fixed by Vili (17 Feb 2009)
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">BetȵltȨs...</div>';
    }

    Ext.define("Ext.locale.hu.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.hu.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} kivlasztott sor"
    });

    Ext.define("Ext.locale.hu.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Fȭl bezrsa"
    });

    Ext.define("Ext.locale.hu.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Hibs ȨrtȨk!"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.hu.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "BetȵltȨs..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Janur", "Februr", "Mrcius", "prilis", "Mjus", "JȦnius", "JȦlius", "Augusztus", "Szeptember", "Oktber", "November", "December"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            'Jan': 0,
            'Feb': 1,
            'Mr': 2,
            'pr': 3,
            'Mj': 4,
            'JȦn': 5,
            'JȦl': 6,
            'Aug': 7,
            'Sze': 8,
            'Okt': 9,
            'Nov': 10,
            'Dec': 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Vasrnap", "HȨtf", "Kedd", "Szerda", "Csȭtȵrtȵk", "PȨntek", "Szombat"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "MȨgsem",
            yes: "Igen",
            no: "Nem"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'Ft',
            // Hungarian Forint
            dateFormat: 'Y m d'
        });
    }

    Ext.define("Ext.locale.hu.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Mai nap",
        minText: "A dtum korbbi a megengedettnȨl",
        maxText: "A dtum kȨsbbi a megengedettnȨl",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Kȵv. hnap (CTRL+Jobbra)',
        prevText: 'Elz hnap (CTRL+Balra)',
        monthYearText: 'Vlassz hnapot (vvlaszts: CTRL+Fel/Le)',
        todayTip: "{0} (Szkȵz)",
        format: "y-m-d",
        startDay: 0
    });

    Ext.define("Ext.locale.hu.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "MȨgsem"
    });

    Ext.define("Ext.locale.hu.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Oldal",
        afterPageText: "a {0}-bl/bl",
        firstText: "Els oldal",
        prevText: "Elz oldal",
        nextText: "Kȵvetkez oldal",
        lastText: "Utols oldal",
        refreshText: "FrissȡtȨs",
        displayMsg: "{0} - {1} sorok lthatk a {2}-bl/bl",
        emptyMsg: 'Nincs megjelenȡthet adat'
    });

    Ext.define("Ext.locale.hu.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "A mez tartalma legalbb {0} hosszȦ kell legyen",
        maxLengthText: "A mez tartalma legfeljebb {0} hosszȦ lehet",
        blankText: "Kȵtelezen kitȵltend mez",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.hu.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "A mez tartalma nem lehet kissebb, mint {0}",
        maxText: "A mez tartalma nem lehet nagyobb, mint {0}",
        nanText: "{0} nem szm"
    });

    Ext.define("Ext.locale.hu.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Nem vlaszthat",
        disabledDatesText: "Nem vlaszthat",
        minText: "A dtum nem lehet korbbi, mint {0}",
        maxText: "A dtum nem lehet kȨsbbi, mint {0}",
        invalidText: "{0} nem megfelel dtum - a helyes formtum: {1}",
        format: "Y m d",
        altFormats: "Y-m-d|y-m-d|y/m/d|m/d|m-d|md|ymd|Ymd|d"
    });

    Ext.define("Ext.locale.hu.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "BetȵltȨs..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'A mez email cȡmet tartalmazhat, melynek formtuma "felhasznl@szolgltat.hu"',
            urlText: 'A mez webcȡmet tartalmazhat, melynek formtuma "http:/' + '/www.weboldal.hu"',
            alphaText: 'A mez csak betʘket Ȩs alhȦzst (_) tartalmazhat',
            alphanumText: 'A mez csak betʘket, szmokat Ȩs alhȦzst (_) tartalmazhat'
        });
    }

    Ext.define("Ext.locale.hu.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'Add meg a webcȡmet:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'FȨlkȵvȨr (Ctrl+B)',
                    text: 'FȨlkȵvȨrrȨ teszi a kijelȵlt szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Dlt (Ctrl+I)',
                    text: 'DltȨ teszi a kijelȵlt szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'AlhȦzs (Ctrl+U)',
                    text: 'AlhȦzza a kijelȵlt szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Szȵveg nagyȡts',
                    text: 'Nȵveli a szȵvegmȨretet.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Szȵveg kicsinyȡtȨs',
                    text: 'Csȵkkenti a szȵvegmȨretet.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'HttȨrszȡn',
                    text: 'A kijelȵlt szȵveg httȨrszȡnȨt mdosȡtja.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Szȵvegszȡn',
                    text: 'A kijelȵlt szȵveg szȡnȨt mdosȡtja.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Balra zrt',
                    text: 'Balra zrja a szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'KȵzȨpre zrt',
                    text: 'KȵzȨpre zrja a szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Jobbra zrt',
                    text: 'Jobbra zrja a szȵveget.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Felsorols',
                    text: 'Felsorolst kezd.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Szmozs',
                    text: 'Szmozott listt kezd.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Hiperlink',
                    text: 'A kijelȵlt szȵveget linkkȨ teszi.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Forrs nȨzet',
                    text: 'Forrs nȨzetbe kapcsol.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.hu.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Nȵvekv rendezȨs",
        sortDescText: "Csȵkken rendezȨs",
        lockText: "Oszlop zrols",
        unlockText: "Oszlop felolds",
        columnsText: "Oszlopok"
    });

    Ext.define("Ext.locale.hu.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Nincs)',
        groupByText: 'Oszlop szerint csoportosȡts',
        showGroupsText: 'Csoportos nȨzet'
    });

    Ext.define("Ext.locale.hu.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "NȨv",
        valueText: "rtȨk",
        dateFormat: "Y m j"
    });

});
