
/**
 * France (France) translation
 * By Thylia
 * 09-11-2007, 02:22 PM
 * updated by disizben (22 Sep 2008)
 * updated by Thylia (20 Apr 2010)
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">En cours de chargement...</div>';
    }

    Ext.define("Ext.locale.fr.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.fr.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ligne{1} sȨlectionnȨe{1}"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.fr.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "En cours de chargement..."
    });

    if (Ext.Date) {
        Ext.Date.shortMonthNames = ["Janv", "FȨvr", "Mars", "Avr", "Mai", "Juin", "Juil", "Aoȩt", "Sept", "Oct", "Nov", "DȨc"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.shortMonthNames[month];
        };

        Ext.Date.monthNames = ["Janvier", "FȨvrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Aoȩt", "Septembre", "Octobre", "Novembre", "DȨcembre"];

        Ext.Date.monthNumbers = {
            "Janvier": 0,
            "Janv": 0,
            "FȨvrier": 1,
            "FȨvr": 1,
            "Mars": 2,
            "Mars": 2,
            "Avril": 3,
            "Avr": 3,
            "Mai": 4,
            "Juin": 5,
            "Juillet": 6,
            "Aoȩt": 7,
            "Septembre": 8,
            "Sept": 8,
            "Octobre": 9,
            "Oct": 9,
            "Novembre": 10,
            "Nov": 10,
            "DȨcembre": 11,
            "DȨc": 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[Ext.util.Format.capitalize(name)];
        };

        Ext.Date.dayNames = ["Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };

        Ext.Date.parseCodes.S.s = "(?:er)";

        Ext.override(Date, {
            getSuffix: function() {
                return (this.getDate() == 1) ? "er" : "";
            }
        });
    }
    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Annuler",
            yes: "Oui",
            no: "Non"
        };
    }

    if (Ext.util.Format) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u20ac',
            // French Euro
            dateFormat: 'd/m/Y'
        });
    }

    Ext.define("Ext.locale.fr.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Aujourd'hui",
        minText: "Cette date est antȨrieure  la date minimum",
        maxText: "Cette date est postȨrieure  la date maximum",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Mois suivant (CTRL+Flȿche droite)',
        prevText: "Mois prȨcȨdent (CTRL+Flȿche gauche)",
        monthYearText: "Choisissez un mois (CTRL+Flȿche haut ou bas pour changer d'annȨe.)",
        todayTip: "{0} (Barre d'espace)",
        format: "d/m/y",
        startDay: 1
    });

    Ext.define("Ext.locale.fr.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Annuler"
    });

    Ext.define("Ext.locale.fr.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Page",
        afterPageText: "sur {0}",
        firstText: "Premiȿre page",
        prevText: "Page prȨcȨdente",
        nextText: "Page suivante",
        lastText: "Derniȿre page",
        refreshText: "Actualiser la page",
        displayMsg: "Page courante {0} - {1} sur {2}",
        emptyMsg: 'Aucune donnȨe  afficher'
    });

    Ext.define("Ext.locale.fr.form.Basic", {
        override: "Ext.form.Basic",
        waitTitle: "Veuillez patienter..."
    });

    Ext.define("Ext.locale.fr.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "La valeur de ce champ est invalide"
    });

    Ext.define("Ext.locale.fr.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "La longueur minimum de ce champ est de {0} caractȿre(s)",
        maxLengthText: "La longueur maximum de ce champ est de {0} caractȿre(s)",
        blankText: "Ce champ est obligatoire",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.fr.form.field.Number", {
        override: "Ext.form.field.Number",
        decimalSeparator: ",",
        decimalPrecision: 2,
        minText: "La valeur minimum de ce champ doit Ȭtre de {0}",
        maxText: "La valeur maximum de ce champ doit Ȭtre de {0}",
        nanText: "{0} n'est pas un nombre valide"
    });

    Ext.define("Ext.locale.fr.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "DȨsactivȨ",
        disabledDatesText: "DȨsactivȨ",
        minText: "La date de ce champ ne peut Ȭtre antȨrieure au {0}",
        maxText: "La date de ce champ ne peut Ȭtre postȨrieure au {0}",
        invalidText: "{0} n'est pas une date valide - elle doit Ȭtre au format suivant: {1}",
        format: "d/m/y",
        altFormats: "d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
    });

    Ext.define("Ext.locale.fr.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "En cours de chargement..."
        });
    });

    if (exists("Ext.form.field.VTypes")) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'Ce champ doit contenir une adresse email au format: "usager@example.com"',
            urlText: 'Ce champ doit contenir une URL au format suivant: "http:/' + '/www.example.com"',
            alphaText: 'Ce champ ne peut contenir que des lettres et le caractȿre soulignȨ (_)',
            alphanumText: 'Ce champ ne peut contenir que des caractȿres alphanumȨriques ainsi que le caractȿre soulignȨ (_)'
        });
    }

    Ext.define("Ext.locale.fr.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: "Veuillez entrer l'URL pour ce lien:"
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'Gras (Ctrl+B)',
                    text: 'Met le texte sȨlectionnȨ en gras.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Italique (Ctrl+I)',
                    text: 'Met le texte sȨlectionnȨ en italique.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'SoulignȨ (Ctrl+U)',
                    text: 'Souligne le texte sȨlectionnȨ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Agrandir la police',
                    text: 'Augmente la taille de la police.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'RȨduire la police',
                    text: 'RȨduit la taille de la police.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Couleur de surbrillance',
                    text: 'Modifie la couleur de fond du texte sȨlectionnȨ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Couleur de police',
                    text: 'Modifie la couleur du texte sȨlectionnȨ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Aligner  gauche',
                    text: 'Aligne le texte  gauche.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Centrer',
                    text: 'Centre le texte.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Aligner  droite',
                    text: 'Aligner le texte  droite.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Liste  puce',
                    text: 'DȨmarre une liste  puce.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'Liste numȨrotȨe',
                    text: 'DȨmarre une liste numȨrotȨe.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Lien hypertexte',
                    text: 'Transforme en lien hypertexte.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Code source',
                    text: 'Basculer en mode Ȩdition du code source.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.fr.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Tri croissant",
        sortDescText: "Tri dȨcroissant",
        columnsText: "Colonnes"
    });

    Ext.define("Ext.locale.fr.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Aucun)',
        groupByText: 'Grouper par ce champ',
        showGroupsText: 'Afficher par groupes'
    });

    Ext.define("Ext.locale.fr.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "PropriȨtȨ",
        valueText: "Valeur",
        dateFormat: "d/m/Y",
        trueText: "vrai",
        falseText: "faux"
    });

    Ext.define("Ext.locale.fr.form.field.Time", {
        override: "Ext.form.field.Time",
        minText: "L'heure de ce champ ne peut Ȭtre antȨrieure  {0}",
        maxText: "L'heure de ce champ ne peut Ȭtre postȨrieure  {0}",
        invalidText: "{0} n'est pas une heure valide",
        format: "H:i",
        altFormats: "g:ia|g:iA|g:i a|g:i A|h:i|g:i|H:i|ga|h a|g a|g A|gi|hi|Hi|gia|hia|g|H"
    });

    Ext.define("Ext.locale.fr.form.CheckboxGroup", {
        override: "Ext.form.CheckboxGroup",
        blankText: "Vous devez sȨlectionner au moins un ȨlȨment dans ce groupe"
    });

    Ext.define("Ext.locale.fr.form.RadioGroup", {
        override: "Ext.form.RadioGroup",
        blankText: "Vous devez sȨlectionner au moins un ȨlȨment dans ce groupe"
    });

});
