/**
 * Farsi (Persian) translation
 * By Mohaqa
 * 03-10-2007, 06:23 PM
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ۯۘ ۡۺ ۿۺۘۗۺۘ ...</div>';
    }

    Ext.define("Ext.locale.fa.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.fa.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ۘۘۯ ۺ۬۫ۺۿ ۳ۯ"
    });

    Ext.define("Ext.locale.fa.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ۿ۬"
    });

    Ext.define("Ext.locale.fa.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ۯۺۘ ۯ ۴ۡۡ ۬"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.fa.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ۯۘ ۡۺ ۿۺۘۗۺۘ ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ۺ", "ۘ", "ۺۘ", "ۘ", "", "۪", "ۼۺ", "۬", "۬ۺۿۘ", "ۺ۬ۿۘ", "ۺۿۘ", "ۯۺۿۘ"];

        Ext.Date.monthNumbers = {
            Jan: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            May: 4,
            Jun: 5,
            Jul: 6,
            Aug: 7,
            Sep: 8,
            Oct: 9,
            Nov: 10,
            Dec: 11
        };

        Ext.Date.dayNames = ["۳ۿ", "ۯ۳ۿ", " ۳ۿ", "ۺۘ۳ۿ", "ۼ۳ۿ", "ۼ۠", "۳ۿ"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "۬ۺۯ",
            cancel: "ۿۺۙ۳۬",
            yes: "ۿ",
            no: "۫ۘ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\ufdfc',
            // Iranian Rial
            dateFormat: 'Y/m/d'
        });
    }

    Ext.define("Ext.locale.fa.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "ۺۘۙ",
        minText: "ۺ ۬ۺۘ۫ ۿ ۺۙ ۡۯۯ ۼۺۙ ۺ۬",
        maxText: "ۺ ۬ۺۘ۫  ۺۙ ۡۯۯ ۼۺۙ ۺ۬",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'ۺ ۿ۠ۯ (Control + Right)',
        prevText: 'ۺ ۿ (Control+Left)',
        monthYearText: ' ۺ ۘۺ ۺ۬۫ۺۿ ۯ (Control+Up/Down ۿۘۺ ۺ۬ۺ ۯۘ ۺ)',
        todayTip: "{0} (Spacebar)",
        format: "y/m/d",
        startDay: 0
    });

    Ext.define("Ext.locale.fa.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Cancel"
    });

    Ext.define("Ext.locale.fa.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "۴ۡ",
        afterPageText: "ۺۙ {0}",
        firstText: "۴ۡ ۺ",
        prevText: "۴ۡ ۿ",
        nextText: "۴ۡ ۿ۠ۯ",
        lastText: "۴ۡ ۫ۘ",
        refreshText: "ۿۺۙ۫ۺ",
        displayMsg: "ۺ۳ {0} - {1} of {2}",
        emptyMsg: 'ۯۺۯ ۺ ۿۘۺ ۺ۳ ۼۯ ۯۺۘۯ'
    });

    Ext.define("Ext.locale.fa.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "ۡۯۺ ۸ ۺ ۯ ۿۘۺۿۘ ۺ۬ ۿۺ {0}",
        maxLengthText: "ۡۯۺ۽ۘ ۸ ۺ ۯ ۿۘۺۿۘ ۺ۬ ۿۺ {0}",
        blankText: "ۺ ۯ ۿۺۯ ۯۺۘ ۯۺ۳۬ ۿۺ۳ۯ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.fa.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "ۡۯۺ ۯۺۘ ۺ ۯ ۿۘۺۿۘ ۺ۬ ۿۺ {0}",
        maxText: "ۡۯۺ۽ۘ ۯۺۘ ۺ ۯ ۿۘۺۿۘ ۺ۬ ۿۺ {0}",
        nanText: "{0}  ۠ۯۯ ۬"
    });

    Ext.define("Ext.locale.fa.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "ۦۘ۠ۺ",
        disabledDatesText: "ۦۘ۠ۺ",
        minText: "۬ۺۘ۫ ۿۺۯ  ۺۙ {0} ۿۺ۳ۯ",
        maxText: "۬ۺۘ۫ ۿۺۯ  ۺۙ {0} ۿۺ۳ۯ",
        invalidText: "{0} ۬ۺۘ۫ ۴ۡۡ ۬ - ۘ۬ ۴ۡۡ {1}",
        format: "y/m/d"
    });

    Ext.define("Ext.locale.fa.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ۯۘ ۡۺ ۿۺۘۗۺۘ ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'ۯۺۘ ۺ ۯ ۿۺۯ  ۺ ۿۺ ۺ ۘ۬ ۿۺ۳ۯ "user@example.com"',
            urlText: 'ۯۺۘ ۺ ۯۘ ۿۺۯ  ۯۘ ۺ۬ ۿۺ ۺ ۘ۬ ۿۺ۳ۯ "http:/' + '/www.example.com"',
            alphaText: 'ۯۺۘ ۺ ۯ ۿۺۯ ۸ ۺۙ ۡۘ ۺۿۺ  _ ۬۳ ۳ۯ ۿۺ۳ۯ ',
            alphanumText: 'ۯۺۘ ۺ ۯ ۿۺۯ ۸ ۺۙ ۡۘ ۺۿۺ ۺ۠ۯۺۯ  _ ۬۳ ۳ۯ ۿۺ۳ۯ'
        });
    }

    Ext.define("Ext.locale.fa.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: '۸ۺ ۯۘ  ۘۺ ۺۘۯ ۯ:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: '۬ۘ (Ctrl+B)',
                    text: '۬ ۺ۬۫ۺۿ ۳ۯ ۘۺ ۬ۘ  ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'ۺ۬ۺ (Ctrl+I)',
                    text: '۬ ۺ۬۫ۺۿ ۳ۯ ۘۺ ۺ۬ۺ  ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'ۙۘ۫۸ (Ctrl+U)',
                    text: 'ۙۘ ۘ ۳۬  ۫۸ ۺ۳  ۯۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'ۺۙۺ۳ ۺۯۺۙ',
                    text: 'ۺۯۺۙ ۬ ۘۺ ۺۙۺ۳  ۯۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'ۺ۳ ۺۯۺۙ',
                    text: 'ۺۯۺۙ ۬ ۘۺ ۺ۳  ۯۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'ۘ ۙ ۬',
                    text: 'ۿۘۺ ۬ۦۘ ۘ ۙ ۬ ۺ۬ۺۯ  ۳ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'ۘ ',
                    text: 'ۘ   ۬ ۘۺ ۬ۦۘ  ۯۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'ۯ ۬ ۺۙ ۬ ',
                    text: '۬ ۺۙ ۬  ۯ ۳ۯ  ۳ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: '۬ ۯۘ ۸ ',
                    text: 'ۺ۳ ۬ ۯۘ ۬ ۸ ۴ۡ  ۘ۠ۺۿ۬ ۬   ۘۺ۬.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'ۯ ۬ ۺۙ ۬ ۘۺ۬',
                    text: '۬ ۺۙ ۬ ۘۺ۬ 㾚ۯ ۫ۺۯ ۳ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: '۬ ۘۺ ۿۺ ۠ۺ۬',
                    text: ' ۬ ۼۯۯ ۺۼۺۯ  ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: '۬ ۠ۯۯ',
                    text: ' ۬ ۠ۯۯ ۺۼۺۯ  ۯ. ',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: '',
                    text: '۬ ۺ۬۫ۺۿ ۳ۯ ۘۺ ۿ  ۬ۿۯ ۯ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'ۘۺ۳ ۘ',
                    text: 'ۘ۬ ۿ ۡۺ۬ ۘۺ۳ ۘ.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.fa.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "ۘ۬ۿ ۺۙ ۺۙۺ۳",
        sortDescText: "ۘ۬ۿ ۺۙ ۺ۳",
        lockText: " ۬ ۺ",
        unlockText: "ۿۺۙۘۯ ۬ ۺ",
        columnsText: "۬ ۺ"
    });

    Ext.define("Ext.locale.fa.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "ۺ",
        valueText: "ۯۺۘ",
        dateFormat: "Y/m/d"
    });

});
