/*
 * Decompiled with CFR 0.152.
 */
package eg.syslog.server;

import eg.syslog.utils.Resources;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.productivity.java.syslog4j.server.SyslogServer;

public class EgSyslogServer {
    static Resources resources;
    static InetAddress localHost;
    static int localPort;
    static String syslog_path;
    static int syslog_max_size;
    static boolean debug;
    static String protocol;
    int config_recheck_period;

    public void init() {
        resources = new Resources("syslog");
        String local = resources.get("bind.host");
        if (local == null || local.trim().equals("")) {
            local = "0.0.0.0";
        }
        localPort = resources.integer("bind.port");
        syslog_path = resources.getAndTrim("file.path");
        syslog_max_size = resources.integer("file.size");
        debug = resources.isTrue("debugOn");
        protocol = resources.getAndTrim("prot");
        try {
            localHost = InetAddress.getByName(local);
        }
        catch (UnknownHostException e) {
            localHost = null;
        }
    }

    public EgSyslogServer() {
        this.init();
    }

    public void start() {
        try {
            this.readDataFromPort();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void readDataFromPort() throws Throwable {
        try {
            if (this.validateInputs()) {
                String host = localHost.toString().replace("/", "");
                String[] serverInputs = new String[]{"-h", host, "-p", Integer.toString(localPort), "-o", syslog_path, "-s", Integer.toString(syslog_max_size), "-a", "-q", protocol};
                if (debug) {
                    serverInputs = new String[]{"-h", host, "-p", Integer.toString(localPort), "-o", syslog_path, "-s", Integer.toString(syslog_max_size), "-a", protocol};
                }
                SyslogServer.main((String[])serverInputs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean validateInputs() {
        boolean success = true;
        if (localHost == null) {
            System.err.println("Unknown host");
            success = false;
        }
        if (localPort == 0) {
            System.err.println("Given port is Invalid");
            success = false;
        }
        if (syslog_path != null) {
            syslog_path = syslog_path.replaceAll("\\\\", "\\\\\\\\");
        } else {
            System.err.println("Syslog file path should not be empty");
            success = false;
        }
        if (protocol == null) {
            System.err.println("Protocol should not be null");
            success = false;
        }
        if (syslog_max_size == 0) {
            System.err.println("syslog file size should be greater than zero");
        } else {
            syslog_max_size *= 1000000;
        }
        return success;
    }
}

