#!/usr/bin/perl -w
# usage
#  getinfo.pl  [<server> <user> <password>]

BEGIN {
   if ($^O eq "MSWin32") {
      @INC = (
         # Set the path to your VmPerl Scripting directory if different
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005',
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005\MSWin32-x86');
   }
}

use VMware::VmPerl;
use VMware::VmPerl::VM;
use VMware::VmPerl::Server;
use VMware::VmPerl::ConnectParams;
use strict;

# Retrieves a pre-defined constant value.
sub vm_constant {
my $constant_str = shift;
return VMware::VmPerl::constant($constant_str, 0);
}

my $state_string_map = {};
my @state_strings = (
"VM_EXECUTION_STATE_ON",
"VM_EXECUTION_STATE_OFF",
"VM_EXECUTION_STATE_SUSPENDED",
"VM_EXECUTION_STATE_STUCK",
"VM_EXECUTION_STATE_UNKNOWN"
);
foreach my $state_string (@state_strings) {
$state_string_map->{vm_constant($state_string)} = $state_string;
}

my ($server_name, $user, $passwd) = @ARGV;

# Change this to your port if it is different.
my $port = 0;

# Create a ConnectParams object

my $connect_params =
   VMware::VmPerl::ConnectParams::new($server_name,$port,$user,$passwd);

# Create a Server object
my $server = VMware::VmPerl::Server::new();

# Establish a persistent connection with server
if (!$server->connect($connect_params))
{
   my ($error_number, $error_string) = $server->get_last_error();
   die "Could not connect to server: Error $error_number: $error_string\n";
}
my @list = $server->registered_vm_names();
if (!defined($list[0])) {
   my ($error_number, $error_string) = $server->get_last_error();
   die "Could not get list of VMs from server: Error $error_number: ".
       "$error_string\n";
}
my $config;

$|=1;
foreach $config (@list) {
	my $vm = VMware::VmPerl::VM::new();
	$vm->set_timeout(10000); 
	if(!$vm->connect($connect_params,$config)){
		my ($error_number, $error_string) = $vm->get_last_error();
          unded $vm;
	 die "Could not connect to vm: Error $error_number: $error_string\n";

	}
	my $ip =$vm->get_guest_info('ip');
	my $name=$vm->get_config('displayName');
	my $os=$vm->get_config('guestOS');

	#print "The Machine Name is: $name1\n";
	#print "The Machine has: $mem MB RAM\n";
	#print "The OS is: $os\n";
	#print "The IP address of is: $ip\n";
	#print "The Machine has:$cpu CPU\n";

	my $cur_state = $vm->get_execution_state();
	if (!defined($cur_state)) {
	my ($error_number, $error_string) = $vm->get_last_error();
	die "Could not get execution state: Error $error_number: $error_string\n";
	}
	#print "The execution state of $config is: $state_string_map->{$cur_state}\n";
	my $state=$state_string_map->{$cur_state};
	if(!$ip)
	{
		$ip="";
	}
	print "Machine Name:$name#IP Address:$ip#OS:$os#State:$state\n"; 
	
	$vm->disconnect();
	undef $vm;
}
$server->disconnect();
undef $server;
kill 9,$$;



