Ext.define('TemplateReportApp.view.SqlReportResult',{
	extend:'Ext.container.Container',
	alias:'widget.sqlreportresult',
	layout:'column',
	columnWidth:1.0,
	id:'sqlreportresult_id',
	margin: '10 0 10 0',
	totalAjaxCount:7,
	currentAjaxCount:0,
	items:[],
	listeners:
	{
		//boxready:function(obj)
		afterrender:function(obj)
		{
			this.setData();
		}
	},
	setData:function()
	{
		this.removeAll();
		var me = this;
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		var thisWidth=mainDivWidth-52;
		var params = this.params;
		console.log ('mainDivWidth  ',mainDivWidth);
		console.log('thisWidth  ',thisWidth);
		me.currentAjaxCount = 0;
		try
		{
			this.add({
				xtype:'panel',
				columnWidth:1.0,
				ui:'newGraphPanel',
				layout:'column',
				margin:'0 0 10 0',
				padding:'0 10 10 0',
				params:params+'&requestFor=forSqlUrls',
				title:'Top 10 Business Transactions by SQL Execution Time',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
					{
						var datas = resultJson.RESULTS;
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var ExecutionTimeData = datas.ExecutionTimeData;
						var ExecutionTimeCol = datas.ExecutionTimeCol;
						
						if(ExecutionTimeCol!=undefined)
						{
							var mainColArray=new Array();
							var fieldsToStore=new Array();
							for (var key in ExecutionTimeCol)
							{
								var align = 'left';
								if(key != 'INFO')
									align = 'center';
								fieldsToStore.push(key);
								mainColArray.push({
									header: ExecutionTimeCol[key],
									sortable: true,
									resizable :true,
									flex:1,
									align:align,
									dataIndex: key,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										if(value!=undefined && value.indexOf('~')>-1)
										{
											var val = value.substring(0,value.indexOf('~'));
											var url = value.substring(value.indexOf('~')+1);
											metaData.tdAttr = 'data-qtip="' + val + '"';

											value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');">'+val+'</a>';
										}
										else
										{
											metaData.tdAttr = 'data-qtip="' + value + '"';
										}
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
												{
													var tmp = v1.substring(0, v1.lastIndexOf(' '));

													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
												}
												if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
												{
													var tmp = v2.substring(0, v2.lastIndexOf(' '));
													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
												}
												if(!isNaN(v1) && !isNaN(v2))
												{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
													}
												}
												else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
								});
							}
							var isPagingHidden=false;
							var gridPageSize=10;
							 if (ExecutionTimeData!=undefined && ExecutionTimeData.length<=gridPageSize)
								isPagingHidden=true;
							else
								isPagingHidden=false;
							
							var storeObj=Ext.create('Ext.data.Store', {
								fields:fieldsToStore,
								proxy: {
									type: 'pagingmemory',
									reader: {
										type: 'json', root : 'data', totalProperty : 'total'
									},
									data : ExecutionTimeData,
								},
								sorters: { property: fieldsToStore[3], direction : 'ASC' },
								pageSize:gridPageSize,
								autoLoad : true,
							});
							var activePage=1;
							this.add({
								xtype:'customgrid',
								store:storeObj,
								forceFit:true,
								columnWidth:1.0,
								margin:'0 0 0 10',
								sortableColumns:true,
								ui:'newGridPanel',
								border:true,
								id:'executiontime_id',
								columns:mainColArray,
								style:
								{
									'box-shadow':'none !important',
								},
								scroll:true,
								autoScroll:true,
								dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}
									}
								}],
								listeners:
								{
									render:function(obj)
									{
										Ext.defer(function() 
										{
											if(!Ext.isEmpty(obj.columns[1]))
											{
												obj.columns[3].doSort('DESC');
											}
										},100);
									}
								}
							});
						}
						else
						{
							this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
						}
					}
					else
					{
						this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				columnWidth:1.0,
				ui:'newGraphPanel',
				layout:'column',
				margin:'0 0 10 0',
				padding:'0 10 10 0',
				params:params+'&requestFor=forSqlExecution',
				title:'By SQL Query Issued',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
					{
						var datas = resultJson.RESULTS;
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var ExecutionSQL_QUERY = datas.ExecutionSQL_QUERY;
						var ExecutionSQL_QUERYCol = datas.ExecutionSQL_QUERYCol;
						
						if(ExecutionSQL_QUERYCol!=undefined)
						{
							var mainColArray=new Array();
							var fieldsToStore=new Array();
							for (var key in ExecutionSQL_QUERYCol)
							{
								var align = 'left';
								if(key != 'SQL_QUERY')
									align = 'center';
								fieldsToStore.push(key);
								var flexVal = 1;
								mainColArray.push({
									header: ExecutionSQL_QUERYCol[key],
									sortable: true,
									resizable :true,
									//flex:flexVal,
									//width:150,
									align:align,
									dataIndex: key,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										if(row==0)
										{
											if(col!=0)
											{
												value = '<div style="font-weight:500">'+value+'</div>';
											}
											else
											{
												value = '<div style="float:left" class="iconTreeDownArrow"></div><div style="font-weight:500">&nbsp;'+value+'</div>';
											}
										}
										else
										{
											if(col==0)
											{
												value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+value;
											}
										}
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												try
												{
													if(v1.data.IS_SUMMARY == 'yes')
													{
														if(state=='DESC')
														{
															return 1;
														}
														else
														{
															return -1;
														}
													}
													if(v2.data.IS_SUMMARY == 'yes')
													{
														if(state=='DESC')
														{
															return -1;
														}
														else
														{
															return 1;
														}
													}
													v1 = v1.get(field)+'';
													v2 = v2.get(field)+'';
													if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
													{
														var tmp = v1.substring(0, v1.lastIndexOf(' '));

														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
													}
													if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
													{
														var tmp = v2.substring(0, v2.lastIndexOf(' '));
														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
													}
													if(!isNaN(v1) && !isNaN(v2))
													{
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														if (state=='ASC')
														{
															v1= isNaN(v1) ? 999999 : v1;
															v2= isNaN(v2) ? 999999 : v2;
														}
														else
														{
															v1= isNaN(v1) ? 0 : v1;
															v2= isNaN(v2) ? 0 : v2;
														}
													}
													else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
													{
														v2=new Date(v2).getTime(); 
														v1=new Date(v1).getTime(); 
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
												catch (e)
												{
													console.log(e);
												}
											}
										});
									},
								});
								if(key!='SQL_QUERY')
								{
									mainColArray[mainColArray.length-1].maxWidth = 140;
								}
							}
							fieldsToStore.push("app");
							fieldsToStore.push("IS_SUMMARY");
							/*for( var index in ExecutionSQL_QUERY)
							{
								var subTable = '<div>test</div>';
								ExecutionSQL_QUERY[index]['app']=subTable;
							}*/
							var isPagingHidden=false;
							var gridPageSize=11;
							 if (ExecutionSQL_QUERY!=undefined && ExecutionSQL_QUERY.length<=gridPageSize)
								isPagingHidden=true;
							else
								isPagingHidden=false;

							var storeObj=Ext.create('Ext.data.Store', {
								fields:fieldsToStore,
								proxy: {
									type: 'pagingmemory',
									reader: {
										type: 'json', root : 'data', totalProperty : 'total'
									},
									data : ExecutionSQL_QUERY,
								},
								sorters: { property: fieldsToStore[1], direction : 'ASC' },
								pageSize:gridPageSize,
								autoLoad : true,
							});
							var activePage=1;
							this.add({
								xtype:'customgrid',
								store:storeObj,
								forceFit:true,
								columnWidth:1.0,
								margin:'0 0 0 10',
								sortableColumns:true,
								ui:'newGridPanel',
								border:true,
								id:'sqlExecution_id',
								columns:mainColArray,
								style:
								{
									'box-shadow':'none !important',
								},
								scroll:true,
								autoScroll:true,
								dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}
									}
								}],
								listeners:
								{
									render:function(obj)
									{
										Ext.defer(function() 
										{
											if(!Ext.isEmpty(obj.columns[1]))
											{
												obj.columns[2].doSort('DESC');
											}
										},100);
									}
								}
							});
						}
						else
						{
							this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
						}
					}
					else
					{
						this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				columnWidth:1.0,
				ui:'newGraphPanel',
				layout:'column',
				margin:'0 0 10 0',
				padding:'0 10 10 0',
				params:params+'&requestFor=forSqlError',
				title:'SQL Queries with Error',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
					{
						var datas = resultJson.RESULTS;
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var ExecutionERROR_QUERY = datas.ExecutionERROR_QUERY;
						var ExecutionERROR_QUERYCol = datas.ExecutionERROR_QUERYCol;
						if(ExecutionERROR_QUERYCol!=undefined)
						{
							var mainColArray=new Array();
							var fieldsToStore=new Array();
							for (var key in ExecutionERROR_QUERYCol)
							{
								var align = 'left';
								if(key != 'SQL_QUERY')
									align = 'center';
								fieldsToStore.push(key);
								var flexVal = 1;
								mainColArray.push({
									header: ExecutionERROR_QUERYCol[key],
									sortable: true,
									resizable :true,
									//flex:flexVal,
									//width:150,
									align:align,
									dataIndex: key,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										if(row==0)
										{
											if(col!=0)
											{
												value = '<div style="font-weight:500">'+value+'</div>';
											}
											else
											{
												value = '<div style="float:left" class="iconTreeDownArrow"></div><div style="font-weight:500">&nbsp;'+value+'</div>';
											}
										}
										else
										{
											if(col==0)
											{
												value='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+value;
											}
										}
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												try
												{
													if(v1.data.IS_SUMMARY == 'yes')
													{
														if(state=='DESC')
														{
															return 1;
														}
														else
														{
															return -1;
														}
													}
													if(v2.data.IS_SUMMARY == 'yes')
													{
														if(state=='DESC')
														{
															return -1;
														}
														else
														{
															return 1;
														}
													}
													v1 = v1.get(field)+'';
													v2 = v2.get(field)+'';
													if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
													{
														var tmp = v1.substring(0, v1.lastIndexOf(' '));

														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
													}
													if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
													{
														var tmp = v2.substring(0, v2.lastIndexOf(' '));
														var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
														var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
														v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
													}
													if(!isNaN(v1) && !isNaN(v2))
													{
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														if (state=='ASC')
														{
															v1= isNaN(v1) ? 999999 : v1;
															v2= isNaN(v2) ? 999999 : v2;
														}
														else
														{
															v1= isNaN(v1) ? 0 : v1;
															v2= isNaN(v2) ? 0 : v2;
														}
													}
													else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
													{
														v2=new Date(v2).getTime(); 
														v1=new Date(v1).getTime(); 
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
														
												}
												catch (e)
												{
													console.log(e);
												}
											}
										});
									}
								});
								if(key!='SQL_QUERY')
								{
									mainColArray[mainColArray.length-1].maxWidth = 140;
								}
							}
							fieldsToStore.push("app");
							fieldsToStore.push("IS_SUMMARY");
							isPagingHidden=false;
							var gridPageSize=11;
							 if (ExecutionERROR_QUERY!=undefined && ExecutionERROR_QUERY.length<=gridPageSize)
								isPagingHidden=true;
							else
								isPagingHidden=false;

							var storeObj=Ext.create('Ext.data.Store', {
								fields:fieldsToStore,
								proxy: {
									type: 'pagingmemory',
									reader: {
										type: 'json', root : 'data', totalProperty : 'total'
									},
									data : ExecutionERROR_QUERY,
								},
								sorters: { property: fieldsToStore[1], direction : 'ASC' },
								pageSize:gridPageSize,
								autoLoad : true,
							});
							var activePage=1;
							this.add({
								xtype:'customgrid',
								store:storeObj,
								forceFit:true,
								columnWidth:1.0,
								margin:'0 0 0 10',
								sortableColumns:true,
								ui:'newGridPanel',
								border:true,
								id:'sqlErrorQuery_id',
								columns:mainColArray,
								style:
								{
									'box-shadow':'none !important',
								},
								scroll:true,
								autoScroll:true,
								dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}
									}
								}],
								listeners:
								{
									render:function(obj)
									{
										Ext.defer(function() 
										{
											if(!Ext.isEmpty(obj.columns[1]))
											{
												obj.columns[1].doSort('DESC');
											}
										},100);
									}
								}
							});
						}
						else
						{
							this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
						}
					}
					else
					{
						this.add(me.getNoMeasure(150,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				layout:
				{
					type:'vbox',
					align: 'stretch'
				},
				ui:'newGraphPanel',
				columnWidth:.5,
				height:457,
				margin:'0 5 0 0',
				params:params+'&requestFor=topProfileLoad',
				title:'Top 5 Servers by SQLs Executed',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					var datas = resultJson.RESULTS;
					if(datas!=undefined && datas.Load_Profile!=undefined)
					{
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var Load_Profile = datas.Load_Profile;
						this.add(
						{
							xtype:'container',
							id:'loadProileId_GraphPanel',
							height:357,
							html:'<div id="loadProileId" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('loadProileId',"230","200"), lineChart);
									lineChart.setData(Load_Profile,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							id:'loadProileId_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px'
							}
						});
					}
					else
					{
						this.add(me.getNoMeasure(385,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				layout:
				{
					type:'vbox',
					align: 'stretch'
				},
				ui:'newGraphPanel',
				columnWidth:.5,
				height:457,
				margin:'0 0 0 5',
				params:params+'&requestFor=topProfileExecution',
				title:'Top 5 Servers by SQL Execution Time (Secs)',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					var datas = resultJson.RESULTS;
					if(datas!=undefined && datas.Exection_Time_Profile!=undefined)
					{
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var Exection_Time_Profile = datas.Exection_Time_Profile;
						this.add(
						{
							xtype:'container',
							id:'executionTimeId_GraphPanel',
							height:357,
							html:'<div id="executionTimeId" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('executionTimeId',"230","200"), lineChart);
									lineChart.setData(Exection_Time_Profile,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							id:'executionTimeId_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px'
							}
						});
					}
					else
					{
						this.add(me.getNoMeasure(385,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				layout:
				{
					type:'vbox',
					align: 'stretch'
				},
				ui:'newGraphPanel',
				columnWidth:.5,
				height:457,
				margin:'10 5 0 0',
				params:params+'&requestFor=topTransactionUrls',
				title:'Top 5 Business Transactions by SQLs Executed',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					var datas = resultJson.RESULTS;
					if(datas!=undefined && datas.Traffic_Exe!=undefined )
					{
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var Traffic_Exe = datas.Traffic_Exe;
						this.add(
						{
							xtype:'container',
							id:'loadTrafficId_GraphPanel',
							height:357,
							html:'<div id="loadTrafficId" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('loadTrafficId',"230","200"), lineChart);
									lineChart.setData(Traffic_Exe,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							id:'loadTrafficId_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px',
							}
						});
					}
					else
					{
						this.add(me.getNoMeasure(385,'iconInformation','No Measures Available'));
					}
				}
			});
			this.add({
				xtype:'panel',
				layout:
				{
					type:'vbox',
					align: 'stretch'
				},
				ui:'newGraphPanel',
				columnWidth:.5,
				height:457,
				margin:'10 0 0 5',
				params:params+'&requestFor=topTransactionExecution',
				title:'Top 5 Business Transactions by SQLs Execution Time',
				listeners:
				{
					boxready:function(obj)
					{
						var msk = new Ext.LoadMask(this.getEl(),{msg:"Loading ..."});
						msk.show();
						Ext.Ajax.request(
						{
							url :'../../final/servlet/com.eg.'+processServlet,
							params :this.params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								try
								{
									me.currentAjaxCount = me.currentAjaxCount+1;
									msk.hide();
									var resultJson = Ext.decode(response.responseText);
									this.setPanelData(resultJson);
								}
								catch(e)
								{
									console.log(e)
								}
							}
						});
					}
				},
				setPanelData:function(resultJson)
				{
					if(me.currentAjaxCount == 1)
					{
						appConstants.appObj.getController(appConstants.appController).enableTools();
					}
					var datas = resultJson.RESULTS;
					if(datas!=undefined && datas.TrafficTime_Exe!=undefined)
					{
						if(me.currentAjaxCount == me.totalAjaxCount)
						{
							me.setSelectionDetails(datas);
						}
						var TrafficTime_Exe = datas.TrafficTime_Exe;
						this.add(
						{
							xtype:'container',
							id:'ExecutionTrafficId_GraphPanel',
							height:357,
							html:'<div id="ExecutionTrafficId" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('ExecutionTrafficId',"230","200"), lineChart);
									lineChart.setData(TrafficTime_Exe,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							id:'ExecutionTrafficId_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px',
							}
						});
					}
					else
					{
						this.add(me.getNoMeasure(385,'iconInformation','No Measures Available'));
					}
				}
			});
		}
		catch(e)
		{
			console.log(e);
		}
	},
	setSelectionDetails:function(RESULTS)
	{
		if(appConstants.showMainForm=='yes')
		{
			Ext.getCmp('selectionDetails').setSelectionDetailsData(RESULTS.selectionDetails);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'container',
			columnWidth:1.0,
			margin:10,
			height:height,
			html:'<div class="egFlexCenterByColumnWise" style="height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'!</div> </div>'
		}
	}
});


