<%@ page import = "egurkha.reporter.ErScheduleTask" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "egurkha.EgUIUtils" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import =  "java.util.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] mailFrequencies = {"All","Daily","Weekly","WeekEnd","Monthly","MonthEnd"};
%>

<%
	EgToolKitInfo tkinfo = new EgToolKitInfo();
	if (!tkinfo.isToolkitAccessEnabled)
	{
		return;
	}

	ErUtils erUtils = new ErUtils();
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");

	String authenticated = (String)session.getAttribute("authenticated");
	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=Reporter");
				return;
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
				return;
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=Reporter");
				return;
			}
			else
			{
				session.setAttribute("reqFromForTk","Reporter");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
				return;
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
			return;
		}
	}
	session.setAttribute("reqFromForTk","Reporter");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("Reporter"))
	{
		session.setAttribute("treeViewSrc","Reporter");
	}

	ArrayList myMap = new ArrayList();
	ErScheduleTask[] newtask = ErScheduleTask.getAllDetails();
	if (newtask != null)
	{
		for(int i=0;i<newtask.length;i++)
		{
			String userName = (String)newtask[i].uname;
			String mailFreq = (String)newtask[i].getMailFrequency();
			String scheduleName = (String)newtask[i].name;
			String mailID = (String)newtask[i].getMailId();
			String groupName = (String)newtask[i].strGroupName;

			HashMap newMap = new HashMap();
			newMap.put("username",userName);
			newMap.put("mailFrequency",mailFreq);
			newMap.put("Mail",mailID);
			if(newtask[i].isAddedInGroup)
			{
				Hashtable scheduleInfoTable = ErScheduleTask.isNeedMerge(groupName);

				String MailSubject = (String)scheduleInfoTable.get("scheduleName");
				newMap.put("ScheduleName",MailSubject);
				newMap.put("groupName",groupName);
			}
			else if(!newtask[i].isAddedInGroup)
			{
				newMap.put("ScheduleName",scheduleName);
			}
			myMap.add(newMap);
		}
	}
	EgUIUtils egUIUtils = new EgUIUtils();

	String selectedUser = egUIUtils.decodeSecurityChar(request.getParameter("user_list"));
	String selectedSchedule = request.getParameter("sch_list");
	String clickSubmit = request.getParameter("clickSubmit");

	Vector users = new Vector();
	users.add("Please select the User");

	Vector name_schedules = new Vector();
	name_schedules.add("Please select the Schedule");
	name_schedules.add("All Schedules");
	for(int m=0;m<myMap.size();m++)
	{
		HashMap bMap = (HashMap)myMap.get(m);
		String username = (String)bMap.get("username");
		String newScheduleName = (String)bMap.get("ScheduleName");
		if(username.equals(selectedUser))
		{
			if(!name_schedules.contains(newScheduleName))
				name_schedules.add(newScheduleName);
		}
		if(!users.contains(username))
			users.add(username);
	}

	EgDateInfo date = new EgDateInfo();
	String mail_frequency = request.getParameter("mail");
	if (mail_frequency == null) mail_frequency = "Daily";
%>

<html>
<head>
<title>Reporter - Schedule Reports</title>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script>
document.onscroll = function()
{
	clearTimeout(time);
	time = setTimeout(logout,timeoutTime);
}
</script>
</head>

<body>

<script language="JavaScript">
	function userChange()
	{
		var thisForm = document.EgSchedule;
		thisForm.action="Schedule.jsp?sessionInUse=true";
		
		if(thisForm.sch_list != undefined)
		{
			thisForm.sch_list.value = undefined;
		}
			thisForm.submit();
	}
	
	function scheduleChange()
	{
		var thisForm = document.EgSchedule;
		thisForm.action="Schedule.jsp?sessionInUse=true";
		thisForm.submit();
	}

	function submitted(usr,sch)
	{
		if(usr == null || usr == 'null' || usr == 'Please select the User')
		{
			alert('Please Select the User');
		}
		else if(sch == null || sch == 'null' || sch == 'Please select the Schedule')
		{
			alert('Please Select the Schedule');
		}
	}
</script>
<FORM name="EgSchedule" method="post" ACTION="Schedule.jsp?sessionInUse=true">
<table border="1" style=" border: 1px solid #6C4996; border-collapse: collapse;" width="75%" align="center">
<br><br>
	<tr>
		<td width="45%" ><b>User ID </td>
		<td width="45%">
			<select name="user_list" onChange="javascript:userChange()" <%=erUtils.fillSelectBoxForConfig("Please select the User",users,selectedUser) %>></select></b>
		</td>
	</tr>
<%
	if(selectedUser != null && !selectedUser.equals("Please select the User"))
	{
%>
	<tr>
		<td width="45%" ><b>Schedule Name </td>
		<td width="45%">
			<select name="sch_list" id="sch_list" onChange="javascript:scheduleChange()" <%=erUtils.fillSelectBoxForConfig("Please select the Schedule",name_schedules,selectedSchedule) %>></select></b>
		</td>
	</tr>

<%
	}

	if(selectedSchedule != null && selectedSchedule.equals("All Schedules"))
	{
%>
	<tr>
		<td width="45%"><b>Mail Frequency  </b></td>
		<td width="65%">
			<select name="mail">
<%
	for (int i=0;i<mailFrequencies.length;i++)
	{
		String selected = "";
		if (mail_frequency.equalsIgnoreCase(mailFrequencies[i]))
		{
			selected = "selected";
		}
%>
				<option value="<%=mailFrequencies[i]%>" <%=selected%>><%=mailFrequencies[i]%></option>
<%
	}
%>
			</select>
		</td>
	</tr>
<%
	}
	else
	{
		mail_frequency = null;
	}
%>
	<tr>
		<td colspan=2 align="center"><INPUT onClick="javascript:submitted('<%=selectedUser%>','<%=selectedSchedule%>');" name ="clickSubmit" TYPE="submit"></td>
	</tr>

</table>
</FORM>
<%

if(clickSubmit != null && clickSubmit.equals("Submit"))
{
	if(selectedUser != null && !selectedUser.equals("Please select the User") && selectedSchedule != null && !selectedSchedule.equals("Please select the Schedule"))
	{
		Vector vec = new Vector();
		Vector vecGroupName = new Vector();
		Vector scheduleInfoVec = new Vector();
		ErScheduleTask[] task = ErScheduleTask.getScheduleListForUser(selectedUser);
		Calendar cal = Calendar.getInstance();
		cal.setTime(new java.util.Date(date.egetUTCDate(false)));
		cal.setTimeZone(date.getRealTimeZone());
		java.util.Date sch_date = cal.getTime();
		if (task != null)
		{
			for(int i=0;i<task.length;i++)
			{
				if(mail_frequency!=null && !mail_frequency.equalsIgnoreCase("All") && !mail_frequency.equalsIgnoreCase(task[i].getMailFrequency()))
					continue;
				if(task[i].isAddedInGroup)
				{
					String bookletName = task[i].strGroupName;
					Hashtable newscheduleInfoTable = ErScheduleTask.isNeedMerge(bookletName);
					String newMailSubject = (String)newscheduleInfoTable.get("scheduleName");

					if(selectedSchedule.equalsIgnoreCase(newMailSubject) || selectedSchedule.equalsIgnoreCase("All Schedules"))
					{
						ErPdfGroupBean obj = new ErPdfGroupBean(task[i].getScheduleId()+"",bookletName,task[i].getDetails(),task[i].name);
						vec.add(obj);
						if(!vecGroupName.contains(bookletName))
						{
							Hashtable scheduleInfoTable = ErScheduleTask.isNeedMerge(bookletName);
							scheduleInfoTable.put("mailId",task[i].getMailId());
							scheduleInfoVec.add(scheduleInfoTable);
							vecGroupName.add(bookletName);
						}
					}
				}
			}
			for(int i=0;i<task.length;i++)
			{
				try
				{
					if(mail_frequency!=null && !mail_frequency.equalsIgnoreCase("All") && !mail_frequency.equalsIgnoreCase(task[i].getMailFrequency()))
					{
						continue;
					}
					if(!task[i].isAddedInGroup)
					{
						String scheduleName = task[i].getName();
						if(selectedSchedule.equalsIgnoreCase(scheduleName) || selectedSchedule.equalsIgnoreCase("All Schedules"))
						{
							task[i].execute(sch_date);
							out.println("Mailing report '"+scheduleName+"' for '"+selectedUser+"' :  Success");
							out.println("<br>");
						}
						else
						{
							continue;
						}
					}
				}
				catch(Exception ex)
				{
					out.println("<font color=red>Mailing report '"+task[i].getName()+"' for '"+selectedUser+"' :  Failure</font>");
					out.println("failed to send mail");
					System.out.println("Schedule Reports failed");
					ex.printStackTrace();
				}
			}
			String strGroupName = "";
			try
			{
				for(int g=0;g<vecGroupName.size();g++)
				{
					strGroupName = (String)vecGroupName.get(g);
					Hashtable scheduleInfoTable = (Hashtable)scheduleInfoVec.get(g);
					String mailId = (String)scheduleInfoTable.get("mailId");
					String MailSubject = (String)scheduleInfoTable.get("scheduleName");
					boolean isMerge = false;
					if(scheduleInfoTable.get("needToMerge")!=null)
						isMerge = Boolean.parseBoolean((String)scheduleInfoTable.get("needToMerge"));
					ErPdfGroupGenerator oo = new ErPdfGroupGenerator(vec,true);
					oo.sendGroupMail(strGroupName,mailId,null,null,isMerge,MailSubject);
					out.println("Mailing Booklet mail report '"+MailSubject+"' for '"+selectedUser+" to "+mailId+"' :  Success </br>");
				}
			}
			catch(Exception e)
			{
				out.println("<font color=red>Mailing report '"+strGroupName+"' for '"+selectedUser+"' :  Failed</font>");
				out.println("failed to send mail");
				System.out.println("Schedule Reports failed");
				e.printStackTrace();
			}
		}
	}
}
%>

</body>
</html>



