Ext.define('MyDashBoard.controller.WidgetConfigurationController',
{
	extend : 'Ext.app.Controller',
	requires : ['MyDashBoard.view.WidgetOptionsWindow','MyDashBoard.view.AddExternalMetrics','MyDashBoard.view.KpiConfigListWidget','MyDashBoard.view.TextEditor','MyDashBoard.view.AddHealthSummaryWidget','MyDashBoard.view.RUMUXConfigWindow'],
	refs :[
		{
			ref : 'widgetOptionsWindow',
			selector : 'widgetOptionsWindow'
		},
		{
			ref : 'comparisontable',
			selector : 'comparisontable'
		},
		{
			ref:'gridstackpanel',
			selector:'gridstackpanel'
		},
		{
			ref:'portlet',
			selector:'portlet'
		},
		{
			ref : 'topologysettingswindow',
			selector : 'topologysettingswindow'
		},
		{
			ref : 'gridcomparisontable',
			selector : 'gridcomparisontable'
		},
		{
			ref : 'addexternalmetrics',
			selector : 'addexternalmetrics'
		},
		{
			ref : 'rumuxconfigwindow',
			selector : 'rumuxconfigwindow'
		}
	],
	init : function() {
		
		this.control({
			'widgetOptionsWindow button[id="descriptorExpandSelector"]' : {
				'click' : this.expandMe
			},
			'widgetOptionsWindow button[id="componentExpandSelector"]' : {
				'click' : this.expandMe
			},
			'widgetOptionsWindow button[id="measureExpandSelector"]' : {
				'click' : this.expandMe
			},
			'widgetOptionsWindow button[id="ddColumnsExpandSelector"]' : {
				'click' : this.expandMe
			},
			'widgetOptionsWindow button[id="summarizeDDColumnExpandSelector"]' : {
				'click' : this.expandMe
			},
			'widgetOptionsWindow button[id="addNewGridData"]' : {
				'click':this.addBlockConfig
			},
			/*'widgetOptionsWindow button[id="finishButton"]' : {
				'click':this.addBlockConfig
			},*/
			'widgetOptionsWindow combo[id="testCombo"]' : {
				'select' : this.testsOnChange
			},
			'widgetOptionsWindow combo[id="componentTypeCombo"]' : {
				'select' : this.loadComponents
			},
			'widgetOptionsWindow multiselect[id="componentCombo"]' : {
				'change' : this.loadDescriptors
			},
			'widgetOptionsWindow combo[id="measureCombo"]' : {
				'select' : this.measureComboOnChange
			},
			'widgetOptionsWindow multiselect[id="measureCombo"]' : {
				'change' : this.measureComboOnChange
			},
			'widgetOptionsWindow combo[id="componentCombo"]' : {
				'select' : this.componentOnChange
			},
			'widgetOptionsWindow switchfield[id="showAggOpt"]' : {
				'change' : this.showAggOptions
			},
			'#descriptorListC1' : {
				'itemclick' : this.testFn
			},
			'widgetOptionsWindow button[id="doneButton"]' : 
			{
				'click':this.updateWidget
			},
			'widgetOptionsWindow  combo[id="viewTypeCombo"]' : {
				'select' : this.getViewTypeValueForHealthSummary
			},
		/*	'widgetOptionsWindow switchfield[id="Stacked"]':
			{
				'change' : this.showStackedChart
			}, */
			'widgetOptionsWindow combo[id="period"]' : {
				'select' : this.durationComboOnChange
			},
			'widgetOptionsWindow button[id="addVMBlockConfig"]' : {
				'click' : this.addVMConfigGrid
			},
			'widgetOptionsWindow combo[id="displayType"]' : {
				'select' : this.displayTypeOnChange
			},
			'widgetOptionsWindow switchfield[id="ChartSummaryEnabled"]': {
				'change':this.enableDigitalChartSummary
			},
			'widgetOptionsWindow multiselect[id="descriptorCombo"]': {
				'change':this.descriptorOnChange
			},
			'widgetOptionsWindow combo[id="descriptorCombo"]': {
				'change':this.descriptorOnChange
			},
			'widgetOptionsWindow switchfield[id="useExternalData"]': {
				'change':this.externalDataSourceOnChange
			},
			'widgetOptionsWindow switchfield[id="enableChartSummary"]': {
				'change':this.enableTableChartSummary
			},
			'kpiConfigurationWindow button[id="kpiDoneButton"]' : 
			{
				'click':this.updateKpiWidget
			},
			'widgetOptionsWindow  combo[id="categoryOpts"]' : {
				'select' : this.changeCategoryOptionCombo
			},
			'widgetOptionsWindow  combo[id="healthCenterCompTypeCombo"]' : {
				'select' : this.changeHealthCenterCompTypeVal
			},
			'widgetOptionsWindow  combo[id="uptimeForCombo"]' : {
				'select' : this.changeUptimeForComboVal
			},
			'widgetOptionsWindow  combo[id="uptimeDowntimeAnalysisBy"]' : {
				'select' : this.changeUptimeDowntimeAnalysisByVal
			},
			'widgetOptionsWindow  combo[id="subTypeCompCombo"]' : {
				'select' : this.loadCompTypesForSelectedInfraType
			},
			'widgetOptionsWindow  combo[id="compntTypFilterCmb"]' : {
				'select' : this.loadCompsForSelectedInfraType
			},
			'widgetOptionsWindow  combo[id="hostPoolFilterCmb"]' : {
				'select' : this.loadCompsForSelectedInfraType
			},
			'widgetOptionsWindow  button[id="updateUpDownExcludeInclude"]' : {
				'click':this.saveUpDownExcludeIncludeWidgetConfig
			},
			'widgetOptionsWindow  combo[id="healthCenterCompScrollCombo"]' : {
				'select' : this.changeHealthCenterCompScrollCombo
			},
			'widgetOptionsWindow  combo[id="healthCenterTestScrollCombo"]' : {
				'select' : this.changeHealthCenterTestScrollCombo
			},
			'widgetOptionsWindow button[id="updateHealthCenter"]': {
				'click':this.updateHealthCenterServers
			},
			'widgetOptionsWindow button[id="addHealthCenter"]': {
				'click':this.addHealthCenterDescriptors
			},
			'widgetOptionsWindow button[id="updateBlockConfig"]' : {
				'click' : this.updateHealthCenterDescriptors
			},
			'widgetOptionsWindow multiselect[id="healthCenterComponentCombo"]' : {
				'change' : this.loadVms
			},
			'widgetOptionsWindow combo[id="chartTypeCombo"]' : {
				'select' : this.onChangeDDChartType
			},
			'#filterPopupWindow  combo[id="categoryOpts"]' : {
				'select' : this.changeCategoryOptionCombo
			},
			'#filterPopupWindow  combo[id="healthCenterCompTypeCombo"]' : {
				'select' : this.changeHealthCenterCompTypeVal
			},
			'#filterPopupWindow  combo[id="healthCenterCompScrollCombo"]' : {
				'select' : this.changeHealthCenterCompScrollCombo
			},
			'#filterPopupWindow button[id="applyFilterOpts"]' : {
				'click' : this.applyFilterOptions
			},
      'rumuxconfigwindow button[id="rumuxBtn"]' : {
				'click' : this.updateRUMUXWidgetConfig
			}
		});
	},
	externalDataSourceOnChange : function(switchObj)
	{
		var meC=this;
		var useExternalData=switchObj.getValue();
		if(useExternalData != null && useExternalData == true)
		{
			if(switchObj.isSettingDefaultValue)
				return;

			var widgetOptionsWindowObj=Ext.getCmp('widgetOptionsWindow');
			widgetOptionsWindowObj.removeAll();
			widgetOptionsWindowObj.add(meC.createExternalConfigWindow());
			if(!widgetOptionsWindowObj.isExternalDataSourceWidget)
			{
				widgetOptionsWindowObj.setDefaultWidgetPreviewImage(widgetOptionsWindowObj.widgetType,widgetOptionsWindowObj.widgetID);
			}
			else
			{
				widgetOptionsWindowObj.loadSampleSnippet();
			}

		}
		else
		{
			var widgetOptionsWindowObj=Ext.getCmp('widgetOptionsWindow');
			widgetOptionsWindowObj.removeAll();
			widgetOptionsWindowObj.createConfigLayout(true);
			//widgetOptionsWindowObj.loadSampleSnippet();
			
		}
		var addMetricsObj = this.getWidgetOptionsWindow();
		if (!Ext.isEmpty(addMetricsObj))
		{
			addMetricsObj.isExternalDataSourceWidget = useExternalData;
		}
		Ext.getCmp('doneButton').enable();
	},
	createExternalConfigWindow : function()
	{
		var addMetricsObj = this.getWidgetOptionsWindow();
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if (widgetID != null && widgetID.indexOf("_") > 0)
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		return {
					xtype : 'addexternalmetrics',
					id : 'widgetChartAttrs',
					name : 'widgetChartAttrs',
					margin:'5 0 10 5',
					widgetID : widgetID,
					widgetType : widgetType,
					isKpi : addMetricsObj.isKpi,
					Kpicount : addMetricsObj.Kpicount,
					totalKpiCount : addMetricsObj.totalKpiCount,
					kpiBlckId : addMetricsObj.kpiBlckId

					
		};
	},
	descriptorOnChange :  function(cmbObj)
	{
		var addMetricsObj = this.getWidgetOptionsWindow();
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if (widgetID != null && widgetID.indexOf("_") > 0)
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		if(widgetType!=null && (widgetType=='TopNAnalysis' || widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox'))
		{
			Ext.getCmp('doneButton').enable();
		}
		else if(widgetType=='ddTable')
		{
			Ext.getCmp('doneButton').enable();
		}
		if((widgetType!=null &&  (widgetType=='dialChart' || widgetType=='digitalChart')))
		{
			var cmbVal=cmbObj.getValue();
			if(!Ext.isEmpty(cmbVal) && (cmbVal!="-1" && cmbVal!="null" && cmbVal!="chooseDescriptors"))
			{
				this.showWidgetPreview(addMetricsObj.widgetID);
			}
		}

		if(widgetType != null && widgetType == 'ScatterPlot')
		{
			this.saveSelection('descCombo');
		}
	},
	enableDigitalChartSummary : function(chkBoxObj)
	{
		if(chkBoxObj!=null && chkBoxObj.getValue()==true)
		{
			Ext.getCmp('SummaryGraphType').setDisabled(false);
			Ext.getCmp('ShowIcon').setDisabled(false);
		}
		else
		{
			Ext.getCmp('SummaryGraphType').setDisabled(true);
			Ext.getCmp('ShowIcon').setDisabled(true);
			Ext.getCmp('ShowIcon').setValue(false);
		}
	},
	enableTableChartSummary : function(chkBoxObj)
	{
		if(chkBoxObj!=null && chkBoxObj.getValue()==true)
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg: performanceAlertLbl,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			
			Ext.getCmp('SummaryGraphType').setDisabled(false);
		}
		else
		{
			Ext.getCmp('SummaryGraphType').setDisabled(true);
		}
	},		
	displayTypeOnChange : function(cmbObj)
	{
		var addDialMetricsObj = this.getWidgetOptionsWindow();

		var configForm = addDialMetricsObj.getComponent('configForm').getForm();
		if(cmbObj.getValue()=="bar")
		{
			configForm.findField('ViewType').show();
			configForm.findField('ColorPalette').show();
		}
		else
		{
			configForm.findField('ViewType').hide();
			configForm.findField('ColorPalette').hide();
		}
	},
	addVMConfigGrid : function()
	{
		var vmConfigForm = Ext.getCmp('configForm').getForm();
		var vmCompType = vmConfigForm.findField('componentTypeCombo');

		var vmCompTypeValue = vmCompType.getValue();
		var vmCompTypeDispValue = vmCompType.getRawValue();

		var vmCompCombo = vmConfigForm.findField('componentCombo');
		var vmCompComboValue = vmCompCombo.getValue();
		var vmCompComboDispValue = vmCompCombo.getRawValue();

		var vmDescrCombo = vmConfigForm.findField('vmListCombo');
		var vmDescrComboValue = vmDescrCombo.getValue();
		
		if (vmCompTypeValue != null && vmCompTypeValue == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (vmCompComboValue != null && (vmCompComboValue == '' || vmCompComboValue == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (vmDescrComboValue != null && vmDescrComboValue == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : descriptorAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var DescrComboStore = vmDescrCombo.getStore();
		var dispDescriptor ='';
		var iniDescriptor ='';

		for ( var Desc in vmDescrComboValue) {
			var selectedDesc = vmDescrComboValue[Desc];
			var DescRecord = DescrComboStore.findRecord(vmDescrCombo.valueField, selectedDesc, 0, false, true, true);

			var DIdx = DescrComboStore.indexOf(DescRecord);
			var dispDesc= DescrComboStore.getAt(DIdx).get('displayField');
			var valueDesc= DescrComboStore.getAt(DIdx).get('valueField');
			if(valueDesc!=null && valueDesc.indexOf("+")==0)
				valueDesc=valueDesc.substring(1);

			dispDescriptor = dispDescriptor+ dispDesc+',';
			iniDescriptor = iniDescriptor+ valueDesc+'!@!';
		}

		var iniValC = iniDescriptor.lastIndexOf("!@!");
		var iniDescriptorForSave = iniDescriptor.substring(0, iniValC)
		var disValC = dispDescriptor.lastIndexOf(",");
		var DescriptorForDisplay = dispDescriptor.substring(0, disValC)

		hiddenVals=vmCompComboValue+'!$!'+vmCompComboDispValue+'!$!'+iniDescriptorForSave;
		var gridObj = this.getGridcomparisontable();
		var gridStore = gridObj.getStore();
		var getCIdx = gridStore.find('ComponentName', vmCompComboDispValue, 0, false, true, true);
		var getIdx = gridStore.find('hiddenVal', hiddenVals, 0, false, true, true);
		var gridObj = this.getGridcomparisontable();
		var gridStore = gridObj.getStore();
		var gridRecordCount = gridObj.getStore().getCount();

		var addedDes=iniDescriptorForSave.split("!@!");

		if(addedDes!=null && (addedDes.length>1) && iniDescriptorForSave.indexOf('allVms')>-1){
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : individualVMsCannotAdd,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			
		if (getIdx == -1 && getCIdx == -1) {
			gridStore.add({
				VmName:DescriptorForDisplay,
				ComponentName:vmCompComboDispValue,
				ComponentType:vmCompTypeDispValue,
				hiddenVal:hiddenVals
				});
				Ext.getCmp('doneButton').enable();
		}
		else if(getCIdx>-1)
		{
			var gridRec = gridStore.findRecord('ComponentName', vmCompComboDispValue);
			var existingHiddenval=gridRec.get('hiddenVal');
			var addedvms = existingHiddenval.substring(existingHiddenval.lastIndexOf("!$!")+3);		
			var individualVM = iniDescriptorForSave.split("!@!");
			for(var i=0;i<individualVM.length;i++)
			{
				if(addedvms!= null && addedvms.indexOf(individualVM[i])>-1)
				{
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : selAlreadyExt,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
			}
			var firstAddedvms = addedvms.split("!@!");
									
			if(firstAddedvms[0]!= null && firstAddedvms[0]!= 'allVms' && iniDescriptorForSave.indexOf('allVms')>-1)
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : allVMsCannotAdd,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
				
			else if(addedvms!=null && addedvms.indexOf('allVms')>-1)
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : selAlreadyExt,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			else
			{
				var existingDispVms=gridRec.get('VmName');
				existingHiddenval=existingHiddenval+'!@!'+iniDescriptorForSave;
				existingDispVms=existingDispVms+","+DescriptorForDisplay;
				gridRec.set("hiddenVal", existingHiddenval);
				gridRec.set("VmName", existingDispVms);
				gridRec.commit();
			}
			Ext.getCmp('doneButton').enable();
		}
		else {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : selAlreadyExt,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
	},
	changeScriptCombo : function(comboObj)
	{
		var configPanl=Ext.getCmp(comboObj.widgetId);
		var selectedElement=comboObj.getValue();
		configPanl.destoryChart();
//			configPanl.removeAll();
		var webSimulationURL=comboObj.webSimulationURL;
		
		if(webSimulationURL!=null && webSimulationURL.indexOf("scriptName=") > -1)
		{
			if(webSimulationURL.indexOf("scriptName=") > -1)
			{
				webSimulationURL=webSimulationURL.replace(/(scriptName=).*?(&)/,'$1' + selectedElement + '$2');
				webSimulationURL=webSimulationURL+"&selectedScript="+selectedElement;
			}
		}
		else
		{
			var urlData = webSimulationURL.split("?");
			var secUrl = urlData[0]+"?"+"selectedScript="+selectedElement+"&scriptName="+selectedElement+"&"+urlData[1];
			webSimulationURL = secUrl;
		}
		webSimulationURL=webSimulationURL+"&scriptChange=true";
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		Ext.state.Manager.set("selectedProfile", profileName);
		Ext.state.Manager.set(profileName + "_" + comboObj.widgetId + "_selectedScript", selectedElement);
		
		configPanl.update('');
		configPanl.suspendEvents(true);
		configPanl.update('<iframe src="'+webSimulationURL+'" width="100%" height="100%" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" leftmargin="10" topmargin="10" allowtransparency="true" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>');
			
		configPanl.resumeEvents();
		configPanl.doComponentLayout();
	},
	changeTopology : function(comboObj)
	{
		var configPanl=Ext.getCmp(comboObj.topologyWidgetId);
		var selectedElement=comboObj.getValue();
		configPanl.destoryChart();
//			configPanl.removeAll();
		var configuredInfraType=configPanl.topologyData.infraType;
		var configuredInfraElement=configPanl.topologyData.selectedInfraElement;
		if(configuredInfraType!=null && configuredInfraType=="Service")
		{
			var configuredInfraElement=configPanl.topologyData.selectedInfraElement;
			var serviceState=configPanl.topologyData.serviceState;
			var topologyURL="/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&fromHomepage=&serviceGroup=null&iszoneName=&isFromZone=null&parentZone=undefined&action=service&serviceState=service20New_"+serviceState+"&service="+encodeURIComponent(configuredInfraElement)+"&segment="+encodeURIComponent(selectedElement)+"&site="+encodeURIComponent(configuredInfraElement)+"&fromMyDashboard=true&myDashboardTheme="+strSkin+"&widgetWidth="+encodeURIComponent(configPanl.getWidth())+"&widgetHeight="+encodeURIComponent(configPanl.getHeight());

			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			if (isAnonymousUserAccess) {				
				topologyURL = topologyURL + '&anonymousUser=true';
			}
			else if(isMonitorHome)
			{
				topologyURL=topologyURL+"&setMonitorHome=true";
			}
			else if(disableMydashboardPopout)
			{
				topologyURL=topologyURL+"&isDisablePopupOption=true";
			}
			var tmpProfNam=profileName;
			if(!Ext.isEmpty(tmpProfNam))
			{
				tmpProfNam=this.filterEncode(tmpProfNam);
			}
			topologyURL = topologyURL + '&profileName='+encodeURIComponent(tmpProfNam);
			
			Ext.state.Manager.set("selectedProfile", profileName);
			Ext.state.Manager.set(profileName + "_" + comboObj.topologyWidgetId + "_selectedSegment", selectedElement);

			configPanl.update('');
			configPanl.suspendEvents(true);
			configPanl.update('<iframe src="'+topologyURL+'" width="100%" height="100%" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" leftmargin="10" topmargin="10" allowtransparency="true" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>');
		}
		else if(configuredInfraType!=null && configuredInfraType=="Segment")
		{
			var configuredInfraElement=configPanl.topologyData.selectedInfraElement;
			var segComboStore=comboObj.getStore();
			var selectedSegRecord = comboObj.getStore().findRecord(comboObj.valueField, selectedElement, 0, false, true, true);
			var cIdx = segComboStore.indexOf(selectedSegRecord);
			var segmentState = segComboStore.getAt(cIdx).get('state');
			//var segmentState=configPanl.topologyData.segmentState;
			var topologyURL="/final/monitor/EgSegmentTopologyD3JS.jsp?segment="+encodeURIComponent(selectedElement)+"&physical_topology=1&fromHomepage=&type=segment&zoom=100&isFromZone=null&iszoneName=&parentZone=null&segmentState="+encodeURIComponent("segment20New_"+segmentState)+"&fromMyDashboard=true&myDashboardTheme="+strSkin+"&widgetWidth="+encodeURIComponent(configPanl.getWidth())+"&widgetHeight="+encodeURIComponent(configPanl.getHeight());
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			if (isAnonymousUserAccess) {
				topologyURL = topologyURL + '&anonymousUser=true';
			}
			else if(isMonitorHome)
			{
				topologyURL=topologyURL+"&setMonitorHome=true";
			}
			else if(disableMydashboardPopout)
			{
				topologyURL=topologyURL+"&isDisablePopupOption=true";
			}
			var tmpProfNam=profileName;
			if(!Ext.isEmpty(tmpProfNam))
			{
				tmpProfNam=this.filterEncode(tmpProfNam);
			}
			topologyURL = topologyURL + '&profileName='+encodeURIComponent(tmpProfNam);
			configPanl.update('');
			configPanl.suspendEvents(true);
			configPanl.update('<iframe src="'+topologyURL+'" width="100%" height="100%" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" leftmargin="10" topmargin="10" allowtransparency="true" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>');
		}
		
		configPanl.resumeEvents();
		configPanl.doComponentLayout();
	},
	saveTopologyConfig : function() {
		return saveTopologyConfig(false,'');
	},
	saveTopologyConfig : function(isWidgetPreviewMode,previewImageContainer) {
		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = Ext.getCmp('topologyconfigform').getForm();
		var viewTypeVal = configForm.findField('viewTypeValueCombo');
		var viewType = configForm.findField('viewTypeCombo').getValue();
		//var viewType=viewTypeVal.fieldLabel;
		var widgetID = addMetricsObj.widgetID;
		var selectedViewTypeVal = viewTypeVal.getValue();
		if (selectedViewTypeVal != null && selectedViewTypeVal == '-1')
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : screenLabelsObj['chooseGrouping'],
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		paramsForSave = "action=saveToplogyConfig&profileName="+encodeURIComponent(tmpProfNam)+"&blockId="+widgetID+"&configuredViewTypeVal="+encodeURIComponent(selectedViewTypeVal);
		if(viewType!=null && viewType!='')
		{
			paramsForSave=paramsForSave+'&configuredViewType='+encodeURIComponent(viewType);
		}
		
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridSterObj=null;
		delete gridSterObj;
		
		var configPanl =null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
		}
		else
		{
			configPanl=Ext.getCmp(widgetID);
			addMetricsObj.close();
		}
		
		Ext.Ajax
		.request({
			url : '/final/servlet/com.eg.egMyDashboardController',
			method : 'POST',
			params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					//meC.getPortlet().setRefresh(configPanl);
					configPanl.isConfigured=true;
					var jsonData = Ext.decode(jsonText);
					myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, widgetID);
					jsonData=null;
					delete jsonData;
				/*	configPanl
								.add({
									xtype : 'panel',
									html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
											+ (configPanl.getHeight() - 20)
											+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
											+ requestTimeoutMsg + '</div></td></tr></table></div>'
								});
					jsonData=null;
					delete jsonData;*/
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				if (response.timedout) {
					configPanl.removeAll();
					configPanl
							.add({
								xtype : 'panel',
								html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
										+ (configPanl.getHeight() - 20)
										+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
										+ requestTimeoutMsg + '</div></td></tr></table></div>'
							});
					
					configPanl.setLoading(false);
							configPanl.doLayout();
						}
					}
				});

	},
	durationComboOnChange : function(periodComboObj)
	{
		var obj = Ext.getCmp('er_timeline');
		var periodVal=periodComboObj.getValue();
		var timeline = obj.getValue();
		if ( periodVal!=null && periodVal.toLowerCase()==("h") )
		{
			timeline="24 hours";
		}
		else if ( periodVal!=null && periodVal.toLowerCase()==("d") )
		{
			timeline="1 week";
		}
		else if ( periodVal!=null && periodVal.toLowerCase()==("m") )
		{
			timeline="6 months";
		}
		var periodVal=periodComboObj.getValue();
		var param="comesFrom=myDashboard&action=TrendDurationChanged&time="+timeline+"&period="+periodVal;
		Ext.Ajax.request(
		{
			url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var timelineComboObj = Ext.getCmp('er_timeline');
					timelineComboObj.getStore().loadRawData(jsonData['timelinedetails']['timeline']);
					timelineComboObj.setValue(timeline);

					var startdateObj =Ext.getCmp('er_stdate');
					var enddateObj =Ext.getCmp('er_enddate');
					var startHourObj =Ext.getCmp('er_sthr');
					var endHourObj =Ext.getCmp('er_endhr');
					var startMinObj =Ext.getCmp('er_stmin');
					var endMinObj =Ext.getCmp('er_endmin');

					startdateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartDate']);
					startdateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startDateInMgrDateFormat'];
					enddateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndDate']);
					enddateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endDateInMgrDateFormat'];
					startHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartHour']);
					startHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startHrInMgrDate'];
					endHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndHour']);
					endHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endHourInMgrDate'];
					stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
					enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
					startMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartMin']);
					endMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndMin']);
					mgr_stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
					mgr_enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
					if (displayTimeline) {
						if (timeline != null && timeline == 'Any') {
							timelineContObj.selectedMgrStMin=mgr_stmin;
							timelineContObj.selectedMgrEndMin=mgr_enmin;
							timelineContObj.selectedStMinForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedStartMin'];
							timelineContObj.selectedEndminForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedEndMin'];
							timelineComboObj.fireEvent('select', timelineComboObj);
						}
					}
				}
			}
		});
	},
	showStackedChart : function(chkBoxObj)
	{
		if(!Ext.isEmpty(chkBoxObj))
		{
			/*if(chkBoxObj.isLoadedFirstTime==true)
			{
				chkBoxObj.isLoadedFirstTime=false;
				return;
			}*/
			var addMetricsObj = this.getWidgetOptionsWindow();
			var widgetID = addMetricsObj.widgetID;
			var widgetType = '';
			if (widgetID != null && widgetID.indexOf("_") > 0)
				widgetType = widgetID.substr(0, widgetID.indexOf("_"));

			if(widgetType!=null && widgetType!='BarChart')
			{
				return;
			}

			var configForm = addMetricsObj.getComponent('configForm').getForm();
			var stValObj=chkBoxObj.getValue();
			var isStacked='no';
		/*	if(!Ext.isEmpty(stValObj) && stValObj.hasOwnProperty('stacked'))
			{
				isStacked=stValObj.stacked;
			}
			*/

			if(!Ext.isEmpty(stValObj) && stValObj)
			{
				isStacked = 'yes';
			}
			if(isStacked!=null && isStacked=='yes') {
				configForm.findField('showAggOpt').hide();
				configForm.findField('aggOptions').show();
				configForm.findField('descriptorCombo').hide();
				Ext.getCmp('descriptorExpandSelector').hide();
				Ext.getCmp('descriptorComboLbl').hide();
				Ext.getCmp('descriptorSearchTextBox').hide();
				Ext.getCmp('descriptorMultiSelectOuterBox').hide();
				var gridObj = this.getComparisontable();
				var gridStore = gridObj.getStore();
				var configuredData = [];
				var gridRecordCount = gridObj.getStore().getCount();
				for ( var i = 0; i < gridRecordCount; i++) {
					var component = gridObj.getStore().getAt(i).get('component');
					var test = gridObj.getStore().getAt(i).get('test');
					var measure = gridObj.getStore().getAt(i).get('measure');
					var descriptor = gridObj.getStore().getAt(i).get('descriptor');
					var measuresHidVal = gridObj.getStore().getAt(i).get('measuresHidVal');
					var descriptorHidVal = gridObj.getStore().getAt(i).get('descriptorHidVal');
					var componentsHidVal = gridObj.getStore().getAt(i).get('componentsHidVal');
					var isAggregationEnabled = gridObj.getStore().getAt(i).get('isAggregationEnabled');
					var aggFunction = gridObj.getStore().getAt(i).get('aggFunction');
					var hidVal = gridObj.getStore().getAt(i).get('hidVal');
					var chartType = gridObj.getStore().getAt(i).get('chartType');
					if(isAggregationEnabled == 'No')
					{
						if(!Ext.isEmpty(descriptor) && descriptor == 'All Descriptors')
							descriptor = 'AllInfos';
						// hidVal change
						if(!Ext.isEmpty(hidVal) && hidVal.indexOf(descriptor) > 0)
							hidVal = hidVal.substring(0,hidVal.indexOf(descriptor)-1) + '|HASH|avg:-';

						// measuresHidVal change

						if(!Ext.isEmpty(measuresHidVal))
						{
							if(measuresHidVal.indexOf("$")>0 && measuresHidVal.indexOf("(Avg)")<0)
							{
								var strV1 = measuresHidVal.substring(0,measuresHidVal.indexOf("$"))+" (Avg)";
								var strV2 = measuresHidVal.substring(measuresHidVal.indexOf("$"));
								measuresHidVal=strV1 + strV2;
							}

							if(measuresHidVal.indexOf("|HASH|")<0)
							{
								measuresHidVal=measuresHidVal+'|HASH|avg';	
							}
						}
						if(!Ext.isEmpty(descriptorHidVal) && descriptorHidVal.lastIndexOf("$")>0)
						{
							if(descriptorHidVal.indexOf("|")>0)
							{	
								var stringVariable1 = descriptorHidVal.substring(0,descriptorHidVal.indexOf("|"));
								var stringVariable2 = descriptorHidVal.substring(descriptorHidVal.indexOf("|"));
								var stringVariable3 = stringVariable2.substring(0,stringVariable2.indexOf("$"))+" (Avg)";
								var stringVariable4 = stringVariable2.substring(stringVariable2.indexOf("$"));
								descriptorHidVal = stringVariable1 + stringVariable3 + stringVariable4;
								
							}
							if(descriptorHidVal.indexOf("!HYPEN!")>0)
							{
								var strVal1 = descriptorHidVal.substring(0,descriptorHidVal.indexOf("!HYPEN!"));
								var strVal2 = descriptorHidVal.substring(descriptorHidVal.indexOf("!HYPEN!"),descriptorHidVal.indexOf("|"));
								var strVal3 = descriptorHidVal.substring(descriptorHidVal.indexOf("|"));
								descriptorHidVal = strVal1 + strVal3;
							}
							if(descriptorHidVal.indexOf("|HASH|")<0)
							{
								descriptorHidVal=descriptorHidVal.substring(0,descriptorHidVal.lastIndexOf("$"))+'|HASH|avg$-';	
							}
						}
						descriptor = '-';
						isAggregationEnabled = 'Yes';
						aggFunction = 'Avg';
					}
					configuredData.push({
						component : component,
						test : test,
						measure : measure,
						descriptor : descriptor,
						measuresHidVal : measuresHidVal,
						descriptorHidVal : descriptorHidVal,
						componentsHidVal : componentsHidVal,
						isAggregationEnabled : isAggregationEnabled,
						aggFunction : aggFunction,
						hidVal : hidVal,
						chartType : chartType
					});
				}
				gridStore.removeAll();
				gridStore.add(configuredData);
			} else {
				var descriptorComboObj=Ext.getCmp('descriptorCombo');
				if(!Ext.isEmpty(descriptorComboObj))
				{
					var selectedDescriptor=descriptorComboObj.getValue();
					if(!Ext.isEmpty(selectedDescriptor) && selectedDescriptor!="-1")
					{
						configForm.findField('showAggOpt').show();
					}
				}
				configForm.findField('aggOptions').hide();
				configForm.findField('descriptorCombo').show();
				Ext.getCmp('descriptorExpandSelector').show();
				Ext.getCmp('descriptorComboLbl').show();
				Ext.getCmp('descriptorSearchTextBox').show();
				Ext.getCmp('descriptorMultiSelectOuterBox').show();
			}
		}
	},
	getViewTypeValueForHealthSummary:function(viewTypeComboObj)
	{
		var widgetOptionsWindow = this.getWidgetOptionsWindow();
		if (Ext.isEmpty(widgetOptionsWindow))
			widgetOptionsWindow = Ext.widget('widgetOptionsWindow');

		var  widgetOptionsWindowForm = Ext.getCmp('topologyconfigform').getForm();
		var selectedType = widgetOptionsWindowForm.findField('viewTypeCombo').getValue();
		var viewTypeValueComboObj = widgetOptionsWindowForm.findField('viewTypeValueCombo');
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		if (profileName == null || profileName == '') {
			profileName = "None";
		}
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var meC = this;
		iAjax.request({
			 url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadTopologyConfigPopup&profileName=' + encodeURIComponent(tmpProfNam) + '&selectedViewType=' + selectedType +'&viewByTypeChange=true&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					meC.setValueWithOptionInList(viewTypeValueComboObj, jsonData['configuredDetails']['viewByType'], jsonData['configuredDetails']['selectedTypeValue'], '');
					viewTypeValueComboObj.setFieldLabel(widgetOptionsWindowForm.findField('viewTypeCombo').getRawValue());
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			}
		});
	},
	measureComboOnChange : function(cmbObj)
	{
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		if(!Ext.isEmpty(widgetType) && widgetType=='ddTable')
		{
			this.loadDDColumns(cmbObj);
		}
		if(widgetType!=null && (widgetType=='ddTable' || widgetType=='TopNAnalysis' || widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox' || widgetType=='ScatterPlot'))
		{
			var controllerSettingObj=Ext.getCmp('controllerSetting');
			if(!Ext.isEmpty(controllerSettingObj))
			{
				controllerSettingObj.setDisabled(false);
			}
		}
		if(widgetType != null && widgetType == 'ScatterPlot')
		{
			this.saveSelection('measureCombo');
		}
	},
	openWidgetConfigurationWindow : function(btn,widgetID,action)
	{
		var isOneClickDashboard=false;
		var oneClickWidgets=[];
		if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
		{
			oneClickWidgets=publicJson['myDashboardConfigDetails']['oneClickWidgets'];
        }
		var portalPanlId = widgetID;
		if(portalPanlId!=null && portalPanlId.indexOf("ChartArea_")>-1)
		{
			portalPanlId=portalPanlId.substring(portalPanlId.indexOf("_")+1,portalPanlId.length);
		}
		var conftitle = portalPanlId.split('_');
		var conf_title = configTitle[conftitle[0]]+' - '+configurationMsg;
		var widgetType = portalPanlId;
		if(portalPanlId!=null && portalPanlId.indexOf("_")>0)
		{	
			widgetType=portalPanlId.substr(0, portalPanlId.indexOf("_"));
		}
		var defaultAction = publicJson['action'];

		if (defaultAction != null && defaultAction == "showMyDashboard") {
			if(widgetType != null && widgetType == 'weather'){
				  var win = Ext.widget('widgetmetrics', {
					blockId : portalPanlId,
					renderTo:portalPanlId+'-body',
					blckType : widgetType,
					isFluidWindowConfigPopup : true
				});
				if (win != null) {
					win.setTitle(weatherTitle+" - "+settingsLbl);
					win.show();
				}
			}
			else if(widgetType != null && widgetType == 'textWidget')
			{
				var textWidgetPopupObj=Ext.getCmp(portalPanlId+'_txtwid');
				if(!Ext.isEmpty(textWidgetPopupObj))
				{
					textWidgetPopupObj.configWindow();
				}
				else
				{
					var confPnl=Ext.getCmp(portalPanlId);
					if(!Ext.isEmpty(confPnl))
					{
						//confPnl.removeAll();
				var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
				var profileName = dashLayoutObj.profileName;
						confPnl.add({
							xtype: 'textWidget',
								id:portalPanlId+'_txtwid',
								partalID:portalPanlId,
								profileName:profileName,
								action:'configme',
								layout:'fit',
								flex:1,
								html:'Add text here',
								myText:'Add text here',
								textOrientation1:false,
								computedStyle:''
								
						});
					}
				}
			}
			else if(widgetType != null && (widgetType == 'rumUXIndexWidget' || widgetType == 'webSimulationWidget')){
      
         var win =null;
        if(widgetType == 'rumUXIndexWidget')
        {
          var win = Ext.widget('rumuxconfigwindow', {
					blockId : portalPanlId,
					//renderTo:portalPanlId+'-body',
					blckType : widgetType,
					isFluidWindowConfigPopup : true
          });
		  if (win != null) {
				win.setTitle(rumUxWidgetConfTitle);
				win.show();
			}
        }
        else
        {
          var win = Ext.widget('rumuxconfigwindow', {
					blockId : portalPanlId,
					blckType : widgetType,
					isFluidWindowConfigPopup : true
          });
		  if (win != null) {
				win.setTitle(webappSimulationWidgetConfTitle);
				win.show();
			}
        }
			}
			else if(widgetType != null && widgetType == 'news'){
				  var win = Ext.widget('newswidgetmetrics', {
					blockId : portalPanlId,
					renderTo:portalPanlId+'-body',
					blckType : widgetType,
					isFluidWindowConfigPopup : true
				});
				if (win != null) {
					win.setTitle(newsConfTitle);
					win.show();
				}
			} /*else if(widgetType != null && widgetType == 'vmAlarmsWidget'){
				  var win = Ext.widget('vmAlarmsWidgetConfigPopup', {
					blockId : portalPanlId,
					//renderTo:portalPanlId,
					blckType : widgetType,
					isFluidWindowConfigPopup : true
				});
				if (win != null) {
					win.setTitle('vmAlerts');
					//win.showAt([c.el.getX()-210,c.el.getY()+20]);
					win.show();
				}
			}*/
			else if(widgetType != null && widgetType == 'mapwidget')
			{
				this.mapWindowModifyClick(portalPanlId);
			}
			else if(widgetType != null && widgetType == 'KpiWidget')
			{
				var win = Ext.widget('kpiConfigurationWindow', {
					blockId : portalPanlId,
					//renderTo:portalPanlId,
					blckType : widgetType,
					isFluidWindowConfigPopup : true
				});
				if (win != null) {
					win.setTitle('KPI Configuration');
					win.show();
				}		
				
			}
			else if(widgetType != null && widgetType == 'healthsummary')
			{
				var win = Ext.widget('addhealthsummarywidget', {
					blockId : portalPanlId,
					//renderTo:portalPanlId,
					blckType : widgetType,
					isFluidWindowConfigPopup : true
				});
				if (win != null) {
					win.show();
				}		
				
			}
			else if(widgetType != null && (widgetType == 'networkhealth' || widgetType == 'tierhealth'))
			{
				this.openFilterPopup(portalPanlId,widgetType);
			}
			else {
				if(Ext.Array.contains(oneClickWidgets,portalPanlId) || (widgetType != null && widgetType == 'CitrixReceiverAnalysis')){
					if(widgetType != null && widgetType == 'ResourceConsumptionAnalysis')
					{
						this.showWidgetOptionsWindow(btn,widgetID,action,false,'',null,'','',false);
					}
					else
					{
						if(widgetType!=null && (widgetType=='serverUptimeDowntimeAnalysis' || widgetType=='TopologyWidget' || widgetType=='ScatterPlot'))
						{
							this.showWidgetOptionsWindow(btn,widgetID,action,false,'',null,'','',false);
						}
						else
						{
							var win = Ext.widget('oneclickwidgetconfiguration', {
								blockId : portalPanlId,
								blckType : widgetType,
								isFluidWindowConfigPopup : true
							});
							if (win != null) {
								win.setTitle(conf_title);
								win.show();
							}
						}
					}
				}
				/*else if(widgetType != null && widgetType == 'TopologyWidget'){
					var win = Ext.widget('topologysettingswindow', {
						blockId : portalPanlId,
						blckType : widgetType,
						isFluidWindowConfigPopup : true
					});
					if (win != null) {
						win.show();
					}
				}*/
				else{
					this.showWidgetOptionsWindow(btn,widgetID,action,false,'',null,'','',false);
				}
			}
		} 
		
	},
	showWidgetPreviewAtPopupStartUp : function(widgetID)
	{
		return showWidgetPreviewAtPopupStartUp(widgetID,false);
	},
	showWidgetPreviewAtPopupStartUp :function(widgetID,isExternalDataSourceWidget)
	{		
		var widgetBlockID = widgetID;
		var addMetricsPopup = this.getWidgetOptionsWindow();
		
		var winBlckId = '';
		var Kpicount = '';
		var isKpiWidget = false;
		if(!Ext.isEmpty(addMetricsPopup))
		{
			winBlckId = addMetricsPopup.kpiBlckId;
			Kpicount = addMetricsPopup.Kpicount;
		}

		if(winBlckId!=null && winBlckId.indexOf("KpiWidget")>-1)
		{
			isKpiWidget = true;
			widgetBlockID = winBlckId;
		}

		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForData = '&action=loadBlockData&defaultwidgetpreview=yes&profileName=' + encodeURIComponent(tmpProfNam) + '&blockId=' + widgetBlockID;
		var defaultAction = publicJson['action'];
		var widgetType = widgetID;

		if(widgetID!=null && widgetID.indexOf("_")>-1)
		{
			widgetType=widgetID.substring(0, widgetID.indexOf("_"));
		}
		if(widgetType!=null && (widgetType=='TopologyWidget' || widgetType=='vmAlarmsWidget'))
		{
			 return;
		}
		var configPanl=Ext.getCmp(widgetID+'_previewImage');
		configPanl.setLoading(true, true);
		configPanl.showLoadingMsg=true;
		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForData + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') 
						{
							var jsonData = Ext.decode(jsonText);
							var updateBxId=widgetID+"_previewImage";
							configPanl.widgetPreviewOnStartup=true;
							if(isExternalDataSourceWidget)
							{
								if(isKpiWidget)
								{
									var kpiChartData = jsonData.kpiChartData;
									var measDataObj='';
									for(var count in kpiChartData)
									{
										if(Kpicount==count)
										{
											measDataObj = kpiChartData[count];
											jsonData = measDataObj;
											break;
										}
									}
								}
								myDashApp.getController("ExternalIntegrationController").showExternalDataForBlock(jsonData, configPanl, updateBxId);
							}
							else
							{
								if(isKpiWidget)
								{
									var kpiChartData = jsonData.kpiChartData;
									var measDataObj='';
									for(var count in kpiChartData)
									{
										if(Kpicount==count)
										{
											measDataObj = kpiChartData[count];
											jsonData = measDataObj;
											break;
										}
									}
								}
								myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							}
						}
					},
					failure : function(response)
					{
						configPanl.setLoading(false);
						configPanl.showLoadingMsg=false;
					}
		});
	},
	validateWidgetConfiguration : function(widgetID)
	{
		var addMetricsObj = this.getWidgetOptionsWindow();
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if(widgetID!=null && widgetID.indexOf("_")>-1)
		{
			widgetType=widgetID.substr(0, widgetID.indexOf("_"));
		}
		else
		{
			widgetType=widgetID;
		}
		var useExternalData=false;
		//if(!addMetricsObj.isExternalDataSourceWidget)
		{
			var useExternalDataObj=Ext.getCmp('useExternalData');
			
			if(!Ext.isEmpty(useExternalDataObj))
			{
				useExternalData=useExternalDataObj.getValue();
			}
		}

		if(useExternalData)
		{
			return;
		}
		else
		{

			if(widgetType!=null && (widgetType=='ddTable' || widgetType=='TopNAnalysis' || widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox' || widgetType=='ScatterPlot'))
			{
				var configForm = addMetricsObj.getComponent('configForm').getForm();
				var componentCombo = configForm.findField('componentCombo');
				var testCombo = configForm.findField('testCombo');
				var compTypeCombo = configForm.findField('componentTypeCombo');
				var measureCombo = configForm.findField('measureCombo');
				var selectedCompType=compTypeCombo.getValue();
				var component=componentCombo.getValue();
				var measure = measureCombo.getValue();					
				var selectedTest = testCombo.getValue();

				var selectedDescriptorObj= configForm.findField('descriptorCombo');
				var selectedDescriptor = '';
				if(selectedDescriptorObj != null && !Ext.isEmpty(selectedDescriptorObj))
				{
					selectedDescriptor = selectedDescriptorObj.getValue();
				}
				if (selectedCompType != null && selectedCompType == '-1') {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : compTypAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
				} else if (component != null && (component == '' || component == '-1')) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : componentAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
				} else if (selectedTest != null && selectedTest == '-1') {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : testAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
				} else if (measure != null && (measure == '' || measure == '-1')) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : measureAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
				}

				if(widgetType=='ddTable')
				{
					var selectedDDCols = configForm.findField('ddColumnsCombo');

					if (selectedDDCols != null && selectedDDCols == '' || selectedDDCols == "-1") {
						Ext.Msg.show({
							title : myDashboardAlertLbl,
							msg : noDDColSelectedAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
						});
						return false;
					}

				}
				else
				{
					if (selectedDescriptor != null && selectedDescriptor == '' || selectedDescriptor == "chooseDescriptors") {
						Ext.Msg.show({
							title : myDashboardAlertLbl,
							msg : descriptorAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
						});
						return false;
					}
				}
			}
			else
			{
				if(widgetType!=null && widgetType!='servicehealth')
				{	
					var gridObj =this.getComparisontable();
					var gridStore = gridObj.getStore();
					var configuredMeasures = '';
					var configuredComponents = '';
					var configuredDescriptors = '';
					var componentDisplayNames = '';
					var descriptorDisplayNames = '';
					var gridRecordCount = gridObj.getStore().getCount();
					if (gridRecordCount == 0) {
						Ext.Msg.show({
							title : myDashboardAlertLbl,
							msg : measureAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
						});
						return false;
					}
				}
			}
		}
	},
	showWidgetPreview : function(widgetID)
	{
		var previewImageContainer=Ext.getCmp(widgetID+'_previewImage');
		if(!Ext.isEmpty(previewImageContainer))
		{
			//previewImageContainer.removeAll();
			var widgetType = widgetID;
			if(widgetType!=null && widgetType.indexOf("_")>0)
			{
				widgetType=widgetType.substring(0, widgetID.indexOf("_"));
			}
			var addMetricsObj = this.getWidgetOptionsWindow();
			if(addMetricsObj.isExternalDataSourceWidget)
			{
				this.saveAddExternalMetrics(true,previewImageContainer);
			}
			else
			{
				if(!Ext.isEmpty(widgetType))
				{
					if(widgetType=='ddTable')
					{
						this.addDDMeasures(true,previewImageContainer);
					}
					else if(widgetType=='TopologyWidget')
					{
						this.saveTopologyConfig(true,previewImageContainer);
					}
					else if(widgetType=='vmAlarmsWidget')
					{
						this.updateVMBlockConfig(true,previewImageContainer);
					}
					else if(widgetType=='health')
					{
						this.updateHealthBlockConfig(true,previewImageContainer);
					}
					else if(widgetType=='TopNAnalysis')
					{
						this.updateTopNConfig(true,previewImageContainer);
					}
					else if(widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox')
					{
						this.updateDialConfig(true,previewImageContainer);
					}
					else if(widgetType=='ScatterPlot')
					{
						this.updateScatterPlotConfig(true,previewImageContainer);
					}
					else if(widgetType=='servicehealth')
					{
						this.updateInfrastructureHealth(true,previewImageContainer);
					}
					else
					{
						this.updateBlockConfig(true,previewImageContainer);
					}
				}
			}
		}
	},
	updateWidget : function()
	{
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		if(addMetricsPopup.isKpi==true)
		{
			widgetType='Kpi';
		}
		if(!Ext.isEmpty(widgetType))
		{
			var useExternalDataObj=Ext.getCmp('useExternalData');
			var useExternalData=false;
			if(!Ext.isEmpty(useExternalDataObj))
			{
				useExternalData=useExternalDataObj.getValue();
			}
			if(useExternalData)
			{
				if(widgetType=='Kpi')
				{
					if(addMetricsPopup.isKpi==true)
					{
						var Kpicount=addMetricsPopup.Kpicount;
					}
					this.saveAddExternalMetricsForKPI(false,Kpicount);
				}
				else
				{
					this.saveAddExternalMetrics();
				}
			}
			else
			{
				if(widgetType=='ddTable')
				{
					this.addDDMeasures();
				}
				else if(widgetType=='TopologyWidget')
				{
					this.saveTopologyConfig();
				}
				else if(widgetType=='vmAlarmsWidget')
				{
					this.updateVMBlockConfig();
				}
				else if(widgetType=='health')
				{
					this.updateHealthBlockConfig();
				}
				else if(widgetType=='TopNAnalysis')
				{
					this.updateTopNConfig();
				}
				else if(widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox')
				{
					this.updateDialConfig();
				}
				else if(widgetType=='ResourceConsumptionAnalysis')
				{
					this.updateResourceConsumptionAnalysisConfig();
				}
				else if(widgetType=='CitrixReceiverAnalysis')
				{
					this.updateCitrixReceiverAnalysisConfig();
				}
				else if(widgetType=='ScatterPlot')
				{
					this.updateScatterPlotConfig();
				}
				else if(widgetType=='Kpi')
				{
					var previewImageContainer='';
					if(addMetricsPopup.isKpi==true)
					{
						var Kpicount=addMetricsPopup.Kpicount;
					}
					this.updateKpiDialDigitalConfig(false,Kpicount);
				}
				else if(widgetType=='servicehealth')
				{
					this.updateInfrastructureHealth();
				}
				else if(widgetType=='serverUptimeDowntimeAnalysis')
				{
					this.updateServerUptimeDowntimeAnalysisConfig();
				}
				else
				{
					this.updateBlockConfig();
				}
			}
		}
	},
	updateCitrixReceiverAnalysis : function()
	{
		var meC=this;
		var configWindowObj = this.getWidgetOptionsWindow();
		var widgetID = configWindowObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		var configFormObj = Ext.getCmp('citrixReceiverAnalysisConfigForm');
		var configForm = configFormObj.getForm();
		var filterByCombo = configForm.findField('filterBy');
		var excludeCmpDescObj = configForm.findField('excludeCmpDescObj');
		var filterBy = '';
		if(!Ext.isEmpty(filterByCombo))
		{
			filterBy=filterByCombo.getValue();
		}
		var excludeDescCompVal = '';
		if(!Ext.isEmpty(excludeCmpDescObj))
		{
		//	excludeDescCompVal=configForm.findField('excludeCmpDescObj').fromField.getValue();
			var excludedCmpDescRecords = configForm.findField('excludeCmpDescObj').fromField.getStore().getRange();
			
			var compsStr='';
			if(!Ext.isEmpty(excludedCmpDescRecords))
			{
				Ext.each(excludedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					compsStr=compsStr+','+cmpStr;
				});
			}

			if(compsStr!=null && compsStr.indexOf(',')==0)
				compsStr=compsStr.substring(1);

		/*	if(Ext.isEmpty(compsStr))
			{
				Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : noServersAssociatedMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation',
				minWidth:280
				});
				return;
			}*/

			if(Ext.isEmpty(compsStr))
				compsStr="None";

			excludeDescCompVal=meC.filterEncode(compsStr);
		}
		var configPanl=Ext.getCmp(widgetID);
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		
		var paramsForSave='action=saveCitrixReceiverAnalysisConfig&analysisBy='+encodeURIComponent(filterBy)+"&excludeCmpDescObj="+encodeURIComponent(excludeDescCompVal)+'&profileName='+encodeURIComponent(tmpProfNam)+'&blockId='+encodeURIComponent(widgetID);
		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave,
					scope : this,
					success : function(response) {
						var updateBxId=widgetID;
						
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							configPanl.isConfigured=true;
							var configuredWidgetsID=[];
							if(publicJson['myDashboardConfigDetails']!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID'))
							{
								configuredWidgetsID=publicJson['myDashboardConfigDetails']['configuredWidgetsID'];
							}
							configPanl.isExternalDataSourceWidget=false;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							if(configWindowObj!=null)
							{
								configWindowObj.close();
							}
						}
					},
					failure : function(response, opts) {
						if (response.timedout) {
							configPanl.removeAll();
							configPanl.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	updateServerUptimeDowntimeAnalysisConfig : function()
	{
		var meC=this;
		var configWindowObj = this.getWidgetOptionsWindow();
		var widgetID = configWindowObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var configFormObj = Ext.getCmp('serverUpDownConfigForm');
		var configForm = configFormObj.getForm();
		var analysisByCombo = configForm.findField('uptimeDowntimeAnalysisBy');
		var timelineCombo = configForm.findField('timelineCombo');
		var includeMaintenanceCombo = configForm.findField('includeMaintenanceCombo');
		var uptimeForCombo = configForm.findField('uptimeForCombo');
		var compntTypFilterCmb = configForm.findField('compntTypFilterCmb');
		var subTypeCompCombo = configForm.findField('subTypeCompCombo');
		var hostPoolFilterCmb = configForm.findField('hostPoolFilterCmb');
		var analysisBy = '';
		if(!Ext.isEmpty(analysisByCombo))
		{
			analysisBy=analysisByCombo.getValue();
		}
		var selectedCompType = '';
		if(!Ext.isEmpty(compntTypFilterCmb))
		{
			selectedCompType=compntTypFilterCmb.getValue();
		}
		var selectedInfraType = '';
		if(!Ext.isEmpty(subTypeCompCombo))
		{
			selectedInfraType=subTypeCompCombo.getValue();
		}
		var selectedIncludeMaintenance = '';
		if(!Ext.isEmpty(includeMaintenanceCombo))
		{
			selectedIncludeMaintenance=includeMaintenanceCombo.getValue();
		}
		var selectedUptimeFor = '';
		if(!Ext.isEmpty(uptimeForCombo))
		{
			selectedUptimeFor=uptimeForCombo.getValue();
		}
		var selectedTimeline = '';
		if(!Ext.isEmpty(timelineCombo))
		{
			selectedTimeline=timelineCombo.getValue();
		}
		var selectedHostPool = '';
		if(!Ext.isEmpty(hostPoolFilterCmb))
		{
			selectedHostPool=hostPoolFilterCmb.getValue();
			if(selectedHostPool!=null)
				selectedHostPool=meC.filterEncode(selectedHostPool);
		}
		var excludeDescCompVal = '';
		if(!Ext.isEmpty(excludeCmpDescObj))
		{
			var excludedCmpDescRecords = configForm.findField('excludeCmpDescObj').fromField.getStore().getRange();
			var compsStr='';
			if(!Ext.isEmpty(excludedCmpDescRecords))
			{
				Ext.each(excludedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					compsStr=compsStr+','+cmpStr;
				});
			}
			if(compsStr!=null && compsStr.indexOf(',')==0)
				compsStr=compsStr.substring(1);
			if(Ext.isEmpty(compsStr))
				compsStr="None";
			excludeDescCompVal=meC.filterEncode(compsStr);

			var selectedDescCompVal = '';
			var selectedCmpDescRecords = configForm.findField('excludeCmpDescObj').toField.getStore().getRange();
			var componentsStr='';
			if(!Ext.isEmpty(selectedCmpDescRecords))
			{
				Ext.each(selectedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					componentsStr=componentsStr+','+cmpStr;
				});
			}
			if(componentsStr!=null && componentsStr.indexOf(',')==0)
				componentsStr=componentsStr.substring(1);

			if(Ext.isEmpty(componentsStr))
				componentsStr="None";
		}

		var configPanl=Ext.getCmp(widgetID);
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForSave='action=saveServerUptimeDowntimeAnalysisConfig&analysisBy='+encodeURIComponent(analysisBy)+"&selectedTimeline="+encodeURIComponent(selectedTimeline)+"&selectedHostPool="+encodeURIComponent(selectedHostPool)+"&selectedIncludeMaintenance="+encodeURIComponent(selectedIncludeMaintenance)+"&selectedCompType="+encodeURIComponent(selectedCompType)+"&selectedInfraType="+encodeURIComponent(selectedInfraType)+"&selectedUptimeFor="+encodeURIComponent(selectedUptimeFor)+"&selectedCmpDescObj="+encodeURIComponent(selectedDescCompVal)+'&profileName='+encodeURIComponent(tmpProfNam)+'&blockId='+encodeURIComponent(widgetID);
		iAjax.request({
			url : '/final/servlet/com.eg.egMyDashboardController',
			method : 'POST',
			params : paramsForSave,
			scope : this,
			success : function(response) {
				var updateBxId=widgetID;
				
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					configPanl.isInitialResizeCompleted=false;
					configPanl.isHighChartUpdate=false;
					configPanl.isConfigured=true;
					var configuredWidgetsID=[];
					if(publicJson['myDashboardConfigDetails']!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID'))
					{
						configuredWidgetsID=publicJson['myDashboardConfigDetails']['configuredWidgetsID'];
					}
					configPanl.isExternalDataSourceWidget=false;
					myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
					if(configWindowObj!=null)
					{
						configWindowObj.close();
					}
				}
			},
			failure : function(response, opts) {
				if (response.timedout) {
					configPanl.removeAll();
					configPanl.add({
								xtype : 'panel',
								html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
										+ (configPanl.getHeight() - 20)
										+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
										+ requestTimeoutMsg + '</div></td></tr></table></div>'
							});
					configPanl.setLoading(false);
					configPanl.showLoadingMsg=false;
					configPanl.doLayout();
				}
			}
		});
	},
	updateResourceConsumptionAnalysisConfig : function()
	{
		var meC=this;
		var configWindowObj = this.getWidgetOptionsWindow();
		var widgetID = configWindowObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		var configFormObj = Ext.getCmp('rcaConfigForm');
		var configForm = configFormObj.getForm();
		var analysisByCombo = configForm.findField('analysisBy');
		var timelineCombo = configForm.findField('timelineCombo');
		var excludeCmpDescObj = configForm.findField('excludeCmpDescObj');
		var analysisBy = '';
		if(!Ext.isEmpty(analysisByCombo))
		{
			analysisBy=analysisByCombo.getValue();
		}
		var selectedTimeline = '';
		if(!Ext.isEmpty(analysisByCombo))
		{
			selectedTimeline=timelineCombo.getValue();
		}
		var excludeDescCompVal = '';
		if(!Ext.isEmpty(excludeCmpDescObj))
		{
		//	excludeDescCompVal=configForm.findField('excludeCmpDescObj').fromField.getValue();
			var excludedCmpDescRecords = configForm.findField('excludeCmpDescObj').fromField.getStore().getRange();
			
			var compsStr='';
			if(!Ext.isEmpty(excludedCmpDescRecords))
			{
				Ext.each(excludedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					compsStr=compsStr+','+cmpStr;
				});
			}

			if(compsStr!=null && compsStr.indexOf(',')==0)
				compsStr=compsStr.substring(1);

		/*	if(Ext.isEmpty(compsStr))
			{
				Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : noServersAssociatedMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation',
				minWidth:280
				});
				return;
			}*/

			if(Ext.isEmpty(compsStr))
				compsStr="None";

			excludeDescCompVal=meC.filterEncode(compsStr);
		}
		var configPanl=Ext.getCmp(widgetID);
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		
		var paramsForSave='action=saveResourceConsumptionAnalysisConfig&analysisBy='+encodeURIComponent(analysisBy)+"&selectedTimeline="+encodeURIComponent(selectedTimeline)+"&excludeCmpDescObj="+encodeURIComponent(excludeDescCompVal)+'&profileName='+encodeURIComponent(tmpProfNam)+'&blockId='+encodeURIComponent(widgetID);
		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave,
					scope : this,
					success : function(response) {
						var updateBxId=widgetID;
						
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							configPanl.isConfigured=true;
							var configuredWidgetsID=[];
							if(publicJson['myDashboardConfigDetails']!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID'))
							{
								configuredWidgetsID=publicJson['myDashboardConfigDetails']['configuredWidgetsID'];
							}
							configPanl.isExternalDataSourceWidget=false;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							if(configWindowObj!=null)
							{
								configWindowObj.close();
							}
						}
					},
					failure : function(response, opts) {
						if (response.timedout) {
							configPanl.removeAll();
							configPanl.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	testsOnChange : function(testComboObj)
	{
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		if(widgetType!=null && (widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox' || widgetType=='ScatterPlot') )
		{
			this.loadHealthMeasures(testComboObj);
		}
		else if(widgetType!=null && widgetType=='ddTable')
		{
			this.loadDDMeasures(testComboObj);
		}
		else
		{
			this.loadMeasures(testComboObj);
		}
	},
	componentOnChange : function(compComboObj)
	{
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		if(widgetType!=null && (widgetType=='dialChart' || widgetType=='digitalChart' || widgetType=='liveMeasuresBox' || widgetType=='ddTable' || widgetType=='ScatterPlot'))
		{
			this.loadTestsForComp(compComboObj);
		}
		else if(widgetType!=null && widgetType=='vmAlarmsWidget')
		{
			this.loadDescriptorsForVmAlarmsCompName(compComboObj);
		}
		else
		{
			this.loadDescriptors(compComboObj);
		}
	},
	loadDescriptorsForVmAlarmsCompName : function(combo)
	{
		var configForm = Ext.getCmp('configForm').getForm();
		var componentType = configForm.findField('componentTypeCombo');
		var selectedCompType = componentType.getValue();
		var selectedCompName = combo.getValue();

		if (selectedCompName != "-1" && selectedCompType != "-1") {
			var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
			var profileName = dashLayoutObj.profileName;
			var paramsForRc = 'C=true&F=getVmsForHyperVisor&P0={' + selectedCompType + '}&P1={' + selectedCompName + '}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadVmDescriptors', 'vmPopup', '', true);
		} else {
			var vmDescrCombo = configForm.findField('vmListCombo');
			var vmCompComboStore = vmDescrCombo.getStore();
			vmCompComboStore.removeAll();
			vmCompComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			vmDescrCombo.setValue('-1');
		}
	},
	loadHealthMeasures : function(combo) {
		var healthmetricsObj = this.getWidgetOptionsWindow();
		var configForm = healthmetricsObj.getComponent('configForm').getForm();
		var selectedComp = configForm.findField('componentCombo').getValue();
		var compType = configForm.findField('componentTypeCombo').getValue();
		var selectedTest = combo.getValue();
		if (selectedTest != "-1") {
			var paramsForRc = 'C=true&calljson=true';
			paramsForRc = paramsForRc + '&F=getMeasuresAndDesriptorsForTest&P0={' + compType + '}&P1={' + selectedComp + '}&P2={' + selectedTest + '}';
			this.callRemoteScriptingMethod(paramsForRc, 'loadHealthMeasures', 'healthPopup', '', true);
		} else {
			var measureCombo = configForm.findField('measureCombo');
			var measuresComboStore = measureCombo.getStore();
			measuresComboStore.removeAll();
			measuresComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			measureCombo.setValue('-1');
			var descriptorCombo = configForm.findField('descriptorCombo');
			var descriptorComboStore = descriptorCombo.getStore();
			descriptorComboStore.removeAll();
			descriptorComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			descriptorCombo.setValue('-1');
		}
	},
	getSettingValue : function(filter){
			var settingVal=null;
			switch(filter.ControlType){
				case "combo": 
							  settingVal+="&"+filter.id+"="+encodeURIComponent(Ext.getCmp(filter.id).getValue());
								break;
				case "Checkbox": 
							var chkboxObjArr=filter['options']['optsArr'];
							for(var chkboxIdx in chkboxObjArr)
							{
								var chkBxObj=chkboxObjArr[chkboxIdx];
								settingVal+="&"+chkBxObj+"="+encodeURIComponent(Ext.getCmp(chkBxObj).getValue());
							}
								break;
				case "ColorCombo": settingVal+="&"+filter.id+"="+encodeURIComponent(Ext.getCmp(filter.id).getValue());
								break;
				case "Switch": settingVal+="&"+filter.id+"="+encodeURIComponent(Ext.getCmp(filter.id).getValue());
								break;
				case "TextBox": settingVal+="&"+filter.id+"="+encodeURIComponent(Ext.getCmp(filter.id).getValue());
								break;
			}
			return settingVal;
	},
	addDDMeasures : function() {
		return addDDMeasures(false,'');
	},
	addDDMeasures : function(isWidgetPreviewMode,previewImageContainer) {
		var ddMetricsObj = this.getWidgetOptionsWindow();
		var configForm = ddMetricsObj.getComponent('configForm').getForm();
		var ddMeasuresCombo = configForm.findField('measureCombo');
		var ddcompCombo = configForm.findField('componentCombo');
		var ddColumnsComboLbl = Ext.getCmp('ddColumnsComboLbl');
		var ddColumnsCombo = configForm.findField('ddColumnsCombo');
		var testCombo = configForm.findField('testCombo');
		var ddCompTypeCombo = configForm.findField('componentTypeCombo');
		var chartTypeCombo = configForm.findField('chartTypeCombo');
		var selectedChartType = chartTypeCombo.getValue();		
		var selectedTest = testCombo.getValue();
		var selectedCompType = ddCompTypeCombo.getValue();
		var measure = ddMeasuresCombo.getValue();
		var component = ddcompCombo.getValue();
		var ddColumns = ddColumnsCombo.getValue();
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		if (selectedCompType != null && selectedCompType == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation',
				minWidth:280
			});
			return;
		} else if (component != null && (component == '' || component == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (selectedTest != null && selectedTest == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (measure != null && (measure == '' || measure == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}else if (ddColumns != null && ddColumns == '-1' ) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : ddColsnotApplicableAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}else if (ddColumns != null && ddColumns == '' ) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : noDDColSelectedAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var ddColsComboStore = ddColumnsCombo.getStore();
		var ddColumnVals = '';
		for ( var ddcol in ddColumns) {
			var selectedDDCol = ddColumns[ddcol];
			var ddColRecord = ddColsComboStore.findRecord(ddColumnsCombo.valueField, selectedDDCol, 0, false, true, true);
			var mIdx = ddColsComboStore.indexOf(ddColRecord);
			var dispDDCol = ddColsComboStore.getAt(mIdx).get('displayField');
			ddColumnVals = ddColumnVals + "," + selectedDDCol + ":" + dispDDCol;
		}
		if (ddColumnVals != null && ddColumnVals.indexOf(',') == 0) {
			ddColumnVals = ddColumnVals.substr(1);
		}
		if(selectedChartType != null && (selectedChartType == 'Bar Chart' || selectedChartType == 'Time Line' || selectedChartType=='Area'))
		{
			var summarizeDDColumnObj = configForm.findField('summarizeDDColumnCombo');
			var summarizeDDColumnsValue = summarizeDDColumnObj.getValue();
			
			if (summarizeDDColumnsValue != null && summarizeDDColumnsValue == '-1' ) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : noSummarizeDDColSelectedAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}else if (summarizeDDColumnsValue != null && summarizeDDColumnsValue == '' ) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : noSummarizeDDColSelectedAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			var summarizeDDColumnsDisp = summarizeDDColumnObj.getRawValue();
			summarizeDDColumnsValue = summarizeDDColumnsValue + ":" + summarizeDDColumnsDisp;
			
			var ddColumnValues=ddColumnVals.split(',');
			for(var col in ddColumnValues)
			{
				var column = ddColumnValues[col];
				if(column==summarizeDDColumnsValue)
				{
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : alreadyExistLbl,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
			}
		}
		
		var testMeasure = encodeURIComponent(selectedTest + ":" + measure);
		var meC = this;
		var widgetID = ddMetricsObj.widgetID;
		var configPanl = null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
		}
		else
		{
			configPanl=Ext.getCmp(widgetID);
		}
		if(!Ext.isEmpty(publicJson['myDashboardConfigDetails']))
		{
			if(publicJson['myDashboardConfigDetails']['configIds'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configIds'].push(widgetID);
			}
			if(publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID') && publicJson['myDashboardConfigDetails']['configuredWidgetsID'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configuredWidgetsID'].push(widgetID);
			}
		}
		if(widgetID.indexOf('ddTable')>-1)
		{
			//configPanl.showCombo = true;
		}
		if(!isWidgetPreviewMode)
		{
			ddMetricsObj.close();
		}
		ddColumnVals = meC.filterEncode(ddColumnVals);
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForSave = "action=saveDDConfig&profileName=" +encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&component=" + encodeURIComponent(component)+ "&measure=" + testMeasure + "&ddColumns=" + encodeURIComponent(ddColumnVals);
		
		if(selectedChartType != null && selectedChartType == 'Bar Chart')
		{
			summarizeDDColumnsValue = meC.filterEncode(summarizeDDColumnsValue);
			paramsForSave = paramsForSave+'&summarizeDDColumns='+encodeURIComponent(summarizeDDColumnsValue);
			var viewTypeOpt = configForm.findField('ViewType').getValue();
			if(viewTypeOpt!=null)
			{
				paramsForSave = paramsForSave+'&viewTypeOpt='+viewTypeOpt;
			}
			if(isWidgetPreviewMode)
			{
				if(!Ext.isEmpty(ddColumnsComboLbl) && !Ext.isEmpty(summarizeDDColumnObj))
				{
					if(viewTypeOpt!=null && viewTypeOpt == 'Vertical')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
						ddColumnsComboLbl.setText('DD Columns (Y axis)');
					}
					else if(viewTypeOpt!=null && viewTypeOpt == 'Horizontal')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
						ddColumnsComboLbl.setText('DD Columns (X axis)');
					}
				}
			}
		}
		else if(selectedChartType != null && (selectedChartType == 'Table' || selectedChartType == 'Time Line' || selectedChartType=='Area'))
		{			
			var showChartSummarySwitchObj = configForm.findField('showChartSummary');

			if(showChartSummarySwitchObj != null && !Ext.isEmpty(showChartSummarySwitchObj))
			{
				var showChartSummarySwitchVal = showChartSummarySwitchObj.getValue();
				var showChartSummaryVal="no";
				if(showChartSummarySwitchVal!=null && showChartSummarySwitchVal==true)
				{
					showChartSummaryVal='yes';
				}
				paramsForSave = paramsForSave +'&showChartSummary='+showChartSummaryVal; 
			}

			paramsForSave = paramsForSave+'&summarizeDDColumns='+encodeURIComponent(summarizeDDColumnsValue);

			var er_timeline = configForm.findField('Timeline').getValue();
			paramsForSave = paramsForSave + "&saveTimeline=true&time_line=" + er_timeline + "&timelineKey=" + widgetID ;			  			
		}

	//	configPanl.setLoading(true, true);
		var descriptorVal = configForm.findField('excludeDesc').getValue();
		if(descriptorVal!=null && (descriptorVal.indexOf('*')==0 && descriptorVal.length==1))
		{
			Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : descriptorExcludeAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
						});
						return;
		}
		if(selectedChartType!=null && selectedChartType!='')
		{		
			paramsForSave = paramsForSave+'&selectedChartType='+encodeURIComponent(selectedChartType);
		}

		descriptorVal = this.filterEncode(descriptorVal);
		paramsForSave = paramsForSave+'&excludedDescriptors='+encodeURIComponent(descriptorVal);

		if(widgetID!=null && widgetID.indexOf('ddTable')>-1)
		{
			var drillDownOptObj=configForm.findField('drillDown');
			if(drillDownOptObj != null && !Ext.isEmpty(drillDownOptObj) && drillDownOptObj != undefined)
			{
				var selectedDrillDown = drillDownOptObj.getValue();
				selectedDrillDown = this.filterEncode(selectedDrillDown);
				paramsForSave=paramsForSave + "&selectedDrillDownOpt=" + encodeURIComponent(selectedDrillDown);
			}
		}

		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		if(isWidgetPreviewMode)
		{
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		var removeSelectedDesc = 'false';
		if(preSelectedTestForDD!=null && (preSelectedTestForDD!=selectedTest))
		{
			var descComboObj = Ext.getCmp(blockId+"dd_combo");
			var descStore = descComboObj.getStore();
			descStore.removeAll();
			descComboObj.setValue('');
			removeSelectedDesc = 'true';
		}
		removeSelectedDesc = this.filterEncode(removeSelectedDesc);
		paramsForSave=paramsForSave+'&removeSelectedDesc='+encodeURIComponent(removeSelectedDesc);
		gridStackObj=null;
		delete gridStackObj;
		iAjax
				.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var updateBxId=widgetID;
						if(isWidgetPreviewMode)
						{
							updateBxId=widgetID+"_previewImage";
						}
						else
						{
							meC.getPortlet().setRefresh(configPanl);
						}
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isConfigured=true;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
						}
					},
					failure : function(response, opts) {
						if (response.timedout) {
							configPanl.removeAll();
							configPanl
									.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	loadDDMeasures : function(combo) {
		var selectedTest = combo.getValue();
		if (selectedTest != "-1") {
			var paramsForRc = 'C=true&F=getDDMeasuresJSON&P0={' + selectedTest + '}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadDDMeasures', 'ddPopup', '', true);
		} else {
			var ddMetricsObj = this.getWidgetOptionsWindow();
			var configForm = ddMetricsObj.getComponent('configForm').getForm();
			var ddMeasuresCombo = configForm.findField('measureCombo');
			var ddMeasuresComboStore = ddMeasuresCombo.getStore();
			ddMeasuresComboStore.removeAll();
			ddMeasuresComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			ddMeasuresCombo.setValue('-1');
			var ddMeasureCols = configForm.findField('ddMeasureCols');
			var ddMeasureColsComboStore = ddMeasureCols.getStore();
			ddMeasureColsComboStore.removeAll();
			ddMeasureColsComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			ddMeasureCols.setValue('-1');
		}
	},
	loadDDColumns : function(combo) {
		var ddMetricsObj = this.getWidgetOptionsWindow();
		var configForm = ddMetricsObj.getComponent('configForm').getForm();
		var selectedTest = configForm.findField('testCombo').getValue();
		var compType = configForm.findField('componentTypeCombo').getValue();
		var compName = configForm.findField('componentCombo').getValue();
		var selectedMeasure = combo.getValue();
		if (selectedMeasure != "-1") {
			var paramsForRc = 'C=true&F=getDDColumnsJSON&P0={' + selectedTest + '}&P1={' + selectedMeasure + '}&P2={'+compType+'}&P3={'+compName+'}&P4={true}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadDDColumns', 'ddPopup', '', true);
		} else {
			var ddMeasureCols = configForm.findField('ddColumnsCombo');
			var ddMeasureColsComboStore = ddMeasureCols.getStore();
			ddMeasureColsComboStore.removeAll();
			ddMeasureColsComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			ddMeasureCols.setValue('-1');

			var summarizeDDColumnCols = configForm.findField('summarizeDDColumnCombo');
			var summarizeDDColumnStore = summarizeDDColumnCols.getStore();
			summarizeDDColumnStore.removeAll();
			summarizeDDColumnStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			summarizeDDColumnCols.setValue('-1');
		}
	},
	updateTopNConfig : function()
	{
		return updateTopNConfig(false,'');
	},
	updateTopNConfig : function(isWidgetPreviewMode,previewImageContainer)
	{
		var addDialMetricsObj = this.getWidgetOptionsWindow();
		var widgetID = addDialMetricsObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		//var autoAssServChkBoxObj=Ext.getCmp('autoAssServers');

		var autoCompAssociationEnabled=addDialMetricsObj.autoAssociateComponents;
		
	/*	if(!Ext.isEmpty(autoAssServChkBoxObj))
		{
			var stValObj=autoAssServChkBoxObj.getValue();
			var autoAssociateServers='';
			if(!Ext.isEmpty(stValObj) && stValObj.hasOwnProperty('autoAssServs'))
			{
				autoAssociateServers=stValObj.autoAssServs;
			}
			if(autoAssociateServers!=null && autoAssociateServers=='yes')
			{
				autoCompAssociationEnabled='yes';
			}
		}*/

		var addMetricsForm = addDialMetricsObj.getComponent('configForm').getForm();
	/*	var dialComponentCombo = configForm.findField('componentCombo');
		var dialDescriptorCombo = configForm.findField('descriptorCombo');
		var testCombo = configForm.findField('testCombo');
		var dialCompTypeCombo = configForm.findField('componentTypeCombo');*/

		var configuredMeasures = addMetricsForm.findField('measureCombo').getValue();
		var selectedTest = addMetricsForm.findField('testCombo').getValue();
		var topNComponentCombo = addMetricsForm.findField('componentCombo');
		var topNcompTypeCombo = addMetricsForm.findField('componentTypeCombo');
		var components = topNComponentCombo.getValue();
		if (selectedTest != null && selectedTest == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		if (configuredMeasures != null && (configuredMeasures == '' || configuredMeasures == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		configuredMeasures = selectedTest + ":" + configuredMeasures;
		var selectedCompType = topNcompTypeCombo.getValue();
		if (selectedCompType != null && (selectedCompType == '' || selectedCompType == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		if (!autoCompAssociationEnabled && (Ext.isEmpty(components) || (components != null && (components == '' || components == '-1'))) || components=='undefined') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var compsForTopN = '';
		var componentComboStore = topNComponentCombo.getStore();
		if(autoCompAssociationEnabled!=null && autoCompAssociationEnabled==true)
		{
			components=[];
			components.push('allServers');
		}
		for ( var comp in components) {
			var selectedComp = components[comp];
			var compRecord = componentComboStore.findRecord(topNComponentCombo.valueField, selectedComp, 0, false, true, true);
			var cIdx = componentComboStore.indexOf(compRecord);
			var dispComp ='';
		
			if(cIdx!=null && cIdx<=-1)
				continue;

			if (selectedComp != null && selectedComp == 'allServers') {
				selectedComp = selectedCompType + ":" + selectedComp;
				var displayCompType = topNcompTypeCombo.getRawValue();
				dispComp=displayCompType+' All Components';
			}
			else
			{
				dispComp = componentComboStore.getAt(cIdx).get('displayField');
			}
			compsForTopN = compsForTopN + "," + dispComp + "$" + selectedComp;
		}
		if (compsForTopN != null && compsForTopN.indexOf(",") == 0)
			compsForTopN = compsForTopN.substr(1);
		
		var tmpTopNChartId=widgetID;
		var displayTypeObj=addMetricsForm.findField('displayType').getValue();
		var displayType=displayTypeObj.chartType;
		if(displayType!=null && displayType=="-1")
		{
			displayType="none";
		}

		
		var priority=Ext.getCmp('Priority').getValue();
		
	/*	if(tmpTopNChartId!=null && tmpTopNChartId.indexOf('TopNAnalysis')>-1)
		{
			if(displayType!=null && displayType=='Bar')
			{
				maxBarChartId = parseInt(maxBarChartId) + 1;
				widgetID = "BarChart_" + maxBarChartId;
			}
			else
			{
				maxTableId = parseInt(maxTableId) + 1;
				widgetID = "table_" + maxTableId;
			}
			Ext.getCmp('dashboardLayoutObj').topChartIDMap[tmpTopNChartId]=widgetID;
		}*/

		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForSave = "action=saveConfig&profileName=" + encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&isTopNComputation=true&configuredMeasures="
				+ encodeURIComponent(configuredMeasures) + '&configuredComponents=' + encodeURIComponent(compsForTopN)+'&displayType='+displayType+"&topNPriority="+encodeURIComponent(priority);
		var descriptorCombo = addMetricsForm.findField('descriptorCombo');
		var descriptors=descriptorCombo.getValue();
		if (descriptors != null && descriptors == '') {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : descriptorAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
		}
		var configuredDescriptors='';
		if(descriptors!=null && descriptors=='allDescriptors')
		{
			configuredDescriptors="AllInfos";
		}
		else
		{
			for ( var desc in descriptors) {
				var selectedDesc = descriptors[desc];
				if(selectedDesc!=null && selectedDesc=='allDescriptors')
				{
					configuredDescriptors="AllInfos";
					break;
				}
				else
				{
					configuredDescriptors=configuredDescriptors+","+selectedDesc;
				}
			}
			if(configuredDescriptors!=null && configuredDescriptors.indexOf(",")==0)
				configuredDescriptors=configuredDescriptors.substring(1);
		}
		if(configuredDescriptors!=null && configuredDescriptors=="-1")
			configuredDescriptors="AllInfos";

		configuredDescriptors = this.filterEncode(configuredDescriptors);

		paramsForSave=paramsForSave+"&configuredDescriptors="+encodeURIComponent(configuredDescriptors);
	/*	var startDateVal = addMetricsForm.findField('er_stdate').dataArray;
		var endDateVal = addMetricsForm.findField('er_enddate').dataArray;
		var startHour = addMetricsForm.findField('er_sthr').dataArray;
		var endHour = addMetricsForm.findField('er_endhr').dataArray;
		var stDate = addMetricsForm.findField('er_stdate').getValue();
		var enDate = addMetricsForm.findField('er_enddate').getValue();
		stDate.setHours(addMetricsForm.findField('er_sthr').getValue());
		enDate.setHours(addMetricsForm.findField('er_endhr').getValue());	*/		
		var er_timeline = addMetricsForm.findField('Timeline').getValue();
	/*	var startMinObj = addMetricsForm.findField('er_stmin');
		var endMinObj = addMetricsForm.findField('er_endmin');			
		var stmin=startMinObj.getValue();
		var endmin=endMinObj.getValue();
		stDate.setMinutes(stmin);
		enDate.setMinutes(endmin);

		var fromValue = formatDate(stDate, mgrDisplayDateFormat);
		var ToValue = formatDate(enDate, mgrDisplayDateFormat);	
		//Date validation
		var today = new Date();		
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(er_timeline!=null && er_timeline.toLowerCase() == 'any')
		{		
			if(new Date(fromValue) > new Date(ToValue))
			{
				Ext.MessageBox.show({
					title:myDashboardAlertLbl,
					msg: DateErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});				
				return false;
			}
			if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
			{	
				if(startHour > endHour)
				{
					Ext.MessageBox.show({
					title:myDashboardAlertLbl,
					msg: DateErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
					});
					return false;
				}
				if(startHour == endHour)
				{
					if(stmin >= endmin)
					{
						Ext.MessageBox.show({
						title: myDashboardAlertLbl,
						msg: DateErrorMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
						});					
						return false;
					}
				}
			}
			if(today < new Date(fromValue) )
			{
				Ext.MessageBox.show({
					title: myDashboardAlertLbl,
					msg: timeErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
					});
					return false;
			}
		}*/
		paramsForSave = paramsForSave + "&saveTimeline=true&time_line=" + er_timeline + "&timelineKey=" + widgetID ;
		//+ "&starttime=" + encodeURI(startDateVal)	+ "&endtime=" + encodeURI(endDateVal) + "&starthr=" + startHour + "&endhr=" + endHour+"&stmin="+stmin+"&endmin="+endmin;

		var computeAverageOpt='No';
		var computeAverageOptObj=addMetricsForm.findField('ComputeAverage').getValue();
		if(computeAverageOptObj==true)
		{
			computeAverageOpt='yes';
		}
		paramsForSave = paramsForSave +'&computeAverage='+computeAverageOpt;

		var weightedAverageOpt='No';
		var weightedAverageOptObj=addMetricsForm.findField('WeightedAverage').getValue();
		if(weightedAverageOptObj==true)
		{
			weightedAverageOpt='yes';
		}
		paramsForSave = paramsForSave +'&weightedAverage='+weightedAverageOpt;
		
		var palette=Ext.get('PaletteId').getValue();
		paramsForSave=paramsForSave+"&palette="+encodeURIComponent(palette);
	
		var showDescOptObj=addMetricsForm.findField('DescriptorschkBxOpt');
		var showDescOpt = 'no';
		if(!Ext.isEmpty(showDescOptObj) && showDescOptObj.getValue()==true)
		{
			showDescOpt='yes';
		}

		var showServersOptObj=addMetricsForm.findField('ServerschkBxOpt');
		var showServersOpt = 'no';
		if(!Ext.isEmpty(showServersOptObj) && showServersOptObj.getValue()==true)
		{
			showServersOpt='yes';
		}

		if((showDescOptObj!=null && showDescOptObj==false) && (showServersOptObj!=null && showServersOptObj==false))
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : displayTypeAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt; //added showMetrics Param
		var viewTypeOpt = addMetricsForm.findField('ViewType').getValue();
		if(viewTypeOpt!=null)
		{
			paramsForSave = paramsForSave+'&viewTypeOpt='+viewTypeOpt;
		}
		var descriptorVal = addMetricsForm.findField('excludeDesc').getValue();
		//if(descriptorVal!=null && (descriptorVal.indexOf('*')>-1 || descriptorVal.indexOf('*.*')>-1))
		if(descriptorVal!=null && (descriptorVal.indexOf('*')==0 && descriptorVal.length==1))
		{
			Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : descriptorExcludeAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
						});
						return;
		}
		descriptorVal = filterEncode(descriptorVal);
		paramsForSave = paramsForSave+'&excludedDescriptors='+encodeURIComponent(descriptorVal);

		if(!isWidgetPreviewMode)
		{
			addDialMetricsObj.close();
		}
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		
	/*	if(!Ext.isEmpty(autoCompAssociationEnabled))
		{
			paramsForSave=paramsForSave+"&autoAssociateComponents="+autoCompAssociationEnabled;
		}*/
		gridStackObj=null;
		delete gridStackObj;
		var configPanl = Ext.getCmp(tmpTopNChartId);
		if(!Ext.isEmpty(publicJson['myDashboardConfigDetails']))
		{
			if(publicJson['myDashboardConfigDetails']['configIds'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configIds'].push(widgetID);
			}
			if(publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID') && publicJson['myDashboardConfigDetails']['configuredWidgetsID'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configuredWidgetsID'].push(widgetID);
			}
		}
		if(isWidgetPreviewMode)
		{
			configPanl = previewImageContainer;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
//		configPanl.setLoading(true, true);
		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							if(!isWidgetPreviewMode)
							{
								myDashApp.getController("Main").getPortlet().setRefresh(configPanl);
							}
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							var updateBxId=tmpTopNChartId;
							if(isWidgetPreviewMode)
							{
								updateBxId=tmpTopNChartId+"_previewImage";
							}
							configPanl.isConfigured=true;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							jsonData=null;
							delete jsonData;
						}
						jsonText=null;
						delete jsonText;
					},
					failure : function(response, opts) {
						if (response.timedout) {
							if (widgetType != null && widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType=='combinationChart' || widgetType == 'TrendGraph') {
								configPanl
										.update('<table width="100%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></div></td></tr></table>');
							} else {
								configPanl.removeAll();
								configPanl
										.add({
											xtype : 'panel',
											html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
													+ (configPanl.getHeight() - 20)
													+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
													+ requestTimeoutMsg + '</div></td></tr></table></div>'
										});
							}
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
		});
	},
	saveAddExternalMetrics : function()
	{
		return saveAddExternalMetrics(false,'');
	},
	saveAddExternalMetrics : function(isWidgetPreviewMode,previewImageContainer)
	{
		return myDashApp.getController("ExternalIntegrationController").saveAddExternalMetrics(isWidgetPreviewMode,previewImageContainer);
	},

	saveAddExternalMetricsForKPI : function()
	{
		return saveAddExternalMetricsForKPI(false,'');
	},
	saveAddExternalMetricsForKPI : function(isWidgetPreviewMode,previewImageContainer)
	{
		return myDashApp.getController("ExternalIntegrationController").saveAddExternalMetricsForKPI(isWidgetPreviewMode,previewImageContainer);
	},

	updateBlockConfig : function()
	{
		return updateBlockConfig(false,'');
	},
	updateDialConfig : function(isWidgetPreviewMode,previewImageContainer) {
		var digitalChartImgContObj=Ext.getCmp('digitalChartImgCont');
		var addDialMetricsObj = this.getWidgetOptionsWindow();
		var widgetID = addDialMetricsObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		var configForm = addDialMetricsObj.getComponent('configForm').getForm();
		var dialComponentCombo = configForm.findField('componentCombo');
		var dialDescriptorCombo = configForm.findField('descriptorCombo');
		var testCombo = configForm.findField('testCombo');
		var dialCompTypeCombo = configForm.findField('componentTypeCombo');
		var useStateColorObj=Ext.getCmp('UseStateColorForFonts');
		var showGaugeCircleObj=Ext.getCmp('ShowGaugeCircle');
		var useStateColor='';
	//	var fontResize='';
		if(useStateColorObj != null && !Ext.isEmpty(useStateColorObj) && useStateColorObj != undefined)
		{
			useStateColor=useStateColorObj.getValue();
		}
		var useStateColorForFonts='';
		if(useStateColor != null && useStateColor == true)
		{
			useStateColorForFonts="yes";
		}
		else
		{
			useStateColorForFonts="no";
		}
		var useStateColorBackgroundObj=Ext.getCmp('UseStateColorForBackground');
		var useStateColorBackground='';
		if(useStateColorBackgroundObj != null && useStateColorBackgroundObj != "" && useStateColorBackgroundObj != undefined)
		{
			useStateColorBackground=useStateColorBackgroundObj.getValue();
		}
		var useStateColorForBackground='';
		if(useStateColorBackground != null && useStateColorBackground == true)
		{
			useStateColorForBackground="yes";
		}
		else
		{
			useStateColorForBackground="no";
		}
		if (widgetType != null && widgetType == 'dialChart') {
			var blkId = addDialMetricsObj.widgetID;
			var showGaugeCircle='';
			if(showGaugeCircleObj != null && !Ext.isEmpty(showGaugeCircleObj) && showGaugeCircleObj != undefined)
			{
				showGaugeCircle=showGaugeCircleObj.getValue();
			}
			if(showGaugeCircle != null && showGaugeCircle == true)
			{
				showGaugeCircle="yes";
			}
			else
			{
				showGaugeCircle="no";
			}
			var useGaugeStateColor='';
			var useGaugeStateColorObj=Ext.getCmp('UseStateColorForGauge');
			if(useGaugeStateColorObj != null && !Ext.isEmpty(useGaugeStateColorObj) && useGaugeStateColorObj != undefined)
			{
				useGaugeStateColor=useGaugeStateColorObj.getValue();
			}
			var stateColorForGaugeVal='';
			if(useGaugeStateColor != null && useGaugeStateColor == true)
			{
				stateColorForGaugeVal="yes";
			}
			else
			{
				stateColorForGaugeVal="no";
			}
		}
		var selectedTest = testCombo.getValue();
		var selectedCompType = dialCompTypeCombo.getValue();
		var measure = '';
		if (widgetType != null && widgetType == 'liveMeasuresBox') {
			var measureMultiCombo = configForm.findField('measureCombo');
			measure = measureMultiCombo.getValue();
			//fontResize=Ext.getCmp('resizeFontYesNo').getValue();
		} else {
			var measureSingleCombo = configForm.findField('measureCombo');
			measure = measureSingleCombo.getValue();
		}
		var component = dialComponentCombo.getValue();
		var selectedDescriptor = dialDescriptorCombo.getValue();
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		if (!isWidgetPreviewMode && selectedCompType != null && selectedCompType == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!isWidgetPreviewMode && component != null && (component == '' || component == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!isWidgetPreviewMode && selectedTest != null && selectedTest == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!isWidgetPreviewMode && measure != null && (measure == '' || measure == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!isWidgetPreviewMode && selectedDescriptor != null && selectedDescriptor == '' || selectedDescriptor == "chooseDescriptors") {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : descriptorAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		if (selectedDescriptor != null && selectedDescriptor == "-1")
			selectedDescriptor = "None";
		var testMeasure = '';
		var blkDispOpt='vertical';
		if (widgetType != null && widgetType == 'liveMeasuresBox') {
			var selectedMeas = configForm.findField('measureCombo').boundList.getSelectionModel().getSelection();
			for ( var selM in selectedMeas) {
				var selectedVal = selectedMeas[selM].data['valueField'];
				var selectedDispVal = selectedMeas[selM].data['displayField'];
				testMeasure = testMeasure + "," + (selectedDispVal + "$" + selectedTest + ":" + selectedVal);
			}
			if (testMeasure != null && testMeasure.indexOf(",") == 0) {
				testMeasure = encodeURIComponent(testMeasure.substring(1));
			}
		} else {
			testMeasure = encodeURIComponent(selectedTest + ":" + measure);
		}
		var meC = this;
		var widgetID = addDialMetricsObj.widgetID;
		var configPanl = null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
		}
		else
		{
			configPanl=Ext.getCmp(widgetID);
		}
		if(!Ext.isEmpty(publicJson['myDashboardConfigDetails']))
		{
			if(publicJson['myDashboardConfigDetails']['configIds'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configIds'].push(widgetID);
			}
			if(publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID') && publicJson['myDashboardConfigDetails']['configuredWidgetsID'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configuredWidgetsID'].push(widgetID);
			}
		}
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		if(!Ext.isEmpty(selectedDescriptor))
		{
			selectedDescriptor=this.filterEncode(selectedDescriptor);
		}
		var paramsForSave = "action=saveDialConfig&profileName=" +encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&component="
				+ encodeURIComponent(component) + "&measure=" + testMeasure + "&selectedDescriptor=" + encodeURIComponent(selectedDescriptor);

		if (widgetType != null && widgetType == 'liveMeasuresBox') {
			paramsForSave=paramsForSave+"&viewType="+blkDispOpt + "&useStateColorForBackground=" + useStateColorForBackground;
			var displayTypeObj=Ext.getCmp('widgetType');
			if(!Ext.isEmpty(displayTypeObj))
			{
				var dispType=displayTypeObj.getValue();
				if(!Ext.isEmpty(dispType))
				{
					paramsForSave=paramsForSave+"&displayType="+dispType;
				}
			}
		}
		if (widgetType != null && widgetType == 'dialChart') {
			//paramsForSave=paramsForSave+"&showGaugeCircle="+showGaugeCircle;
			paramsForSave=paramsForSave+"&showGaugeCircle="+showGaugeCircle+"&useStateColorForGauge=" + stateColorForGaugeVal;
			var colorPaletteObj=Ext.getCmp('ColorPicker').getValue();
			var colorPalette=colorPaletteObj.ColorPickerOpt;
			if(colorPalette!=null && colorPalette!='')
			{
				paramsForSave=paramsForSave+"&selectedColor="+colorPalette;
			}
		}
		if (widgetType != null && widgetType == 'digitalChart') {
			paramsForSave=paramsForSave + "&useStateColorForFonts=" + useStateColorForFonts;
		}
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridStackObj=null;
		delete gridStackObj;
		var showChartSummaryObj=Ext.getCmp('ChartSummaryEnabled');
		if(!Ext.isEmpty(showChartSummaryObj))
		{
			var enableChartSummary=showChartSummaryObj.getValue();
			if(enableChartSummary!=null && enableChartSummary==true)
			{
				var chartSummaryGraphTypeObj=Ext.getCmp('SummaryGraphType').getValue();
				var chartSummaryGraphType=chartSummaryGraphTypeObj.chartType;
				if(chartSummaryGraphType!=null && chartSummaryGraphType=="-1")
				{
					chartSummaryGraphType="none";
				}
				paramsForSave=paramsForSave+"&enableChartSummary=yes&summaryGraphType="+encodeURIComponent(chartSummaryGraphType);

				var showIcon=Ext.getCmp('ShowIcon').getValue();
				if(showIcon!=null && showIcon==true)
				{
					paramsForSave=paramsForSave+"&enableChartIcon=yes";
				}
				else
				{
					paramsForSave=paramsForSave+"&enableChartIcon=no";
				}

				var templateImageIconObj=$('#dashboardImageIcon');
				if(!Ext.isEmpty(templateImageIconObj))
				{
					var fileName = templateImageIconObj[0].src;
					var imgPath = null;
					if(fileName!=null && fileName.lastIndexOf("/")>0)
					{
						imgPath = fileName.substring(0,fileName.lastIndexOf("/"));
						fileName=fileName.substring(fileName.lastIndexOf("/")+1);
					}
					else if(fileName!=null && fileName.lastIndexOf("\\")>0)
					{
						imgPath = fileName.substring(0,fileName.lastIndexOf("\\"));
						fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
					}
					else
					{
						var digitalChartImgContObj=Ext.getCmp('digitalChartImgCont');					
						fileName =digitalChartImgContObj.iconClass;
					}

					if(fileName!=null)
					{
						if(imgPath!=null && !imgPath.endsWith("/final/images/"+strSkin))
						{
							fileName = "Custom:"+fileName;
							paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
						}
						else if(imgPath == null)
						{
							fileName = "Default:"+fileName;
							paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
						}
					}
				}
			}
			else
			{
				paramsForSave=paramsForSave+"&enableChartSummary=no&enableChartIcon=no";
			}
		}

		var drillDownOptObj=Ext.getCmp('drillDown');
		if(drillDownOptObj != null && !Ext.isEmpty(drillDownOptObj) && drillDownOptObj != undefined)
		{
			var selectedDrillDown = drillDownOptObj.getValue();
			selectedDrillDown = this.filterEncode(selectedDrillDown);
			paramsForSave=paramsForSave + "&selectedDrillDownOpt=" + encodeURIComponent(selectedDrillDown);
		}

		if(isWidgetPreviewMode)
		{
			if(addDialMetricsObj.isKpi)
			{
				paramsForSave=paramsForSave+"&kpiPreview=yes";
			}
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		else
		{
			addDialMetricsObj.close();
		}
		paramsForSave=paramsForSave+"&useExternalData=no";
		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var updateBxId=widgetID;
						if(isWidgetPreviewMode)
						{
							updateBxId=widgetID+"_previewImage";
						}
						else
						{
							meC.getPortlet().setRefresh(configPanl);
						}
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							configPanl.isConfigured=true;
							var configuredWidgetsID=[];
							if(publicJson['myDashboardConfigDetails']!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID'))
							{
								configuredWidgetsID=publicJson['myDashboardConfigDetails']['configuredWidgetsID'];
							}
							configPanl.isExternalDataSourceWidget=false;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
						}
					},
					failure : function(response, opts) {
						if (response.timedout) {
							configPanl.removeAll();
							configPanl.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},

	updateKpiDialDigitalConfig : function(isWidgetPreviewMode,previewImageContainer) {
		if(isWidgetPreviewMode !=true)
		{
			var digitalChartImgContObj=Ext.getCmp('digitalChartImgCont');
			var addDialMetricsObj = this.getWidgetOptionsWindow();
			
			var widgetID = addDialMetricsObj.widgetID;
			var Kpicount = addDialMetricsObj.Kpicount;
			var totalKpiCount = addDialMetricsObj.totalKpiCount;
			var widgetType = widgetID.substr(0, widgetID.indexOf("_"));

			var configForm = addDialMetricsObj.getComponent('configForm').getForm();
			var dialComponentCombo = configForm.findField('componentCombo');
			var dialDescriptorCombo = configForm.findField('descriptorCombo');
			var testCombo = configForm.findField('testCombo');
			var dialCompTypeCombo = configForm.findField('componentTypeCombo');
			var useStateColorObj=Ext.getCmp('UseStateColorForFonts');
			var showGaugeCircleObj=Ext.getCmp('ShowGaugeCircle');
			var useStateColor='';
		
			if(useStateColorObj != null && !Ext.isEmpty(useStateColorObj) && useStateColorObj != undefined)
			{
				useStateColor=useStateColorObj.getValue();
			}
			var useStateColorForFonts='';
			if(useStateColor != null && useStateColor == true)
			{
				useStateColorForFonts="yes";
			}
			else
			{
				useStateColorForFonts="no";
			}
			var useStateColorBackgroundObj=Ext.getCmp('UseStateColorForBackground');
			var useStateColorBackground='';
			if(useStateColorBackgroundObj != null && useStateColorBackgroundObj != "" && useStateColorBackgroundObj != undefined)
			{
				useStateColorBackground=useStateColorBackgroundObj.getValue();
			}
			var useStateColorForBackground='';
			if(useStateColorBackground != null && useStateColorBackground == true)
			{
				useStateColorForBackground="yes";
			}
			else
			{
				useStateColorForBackground="no";
			}
			if (widgetType != null && widgetType == 'dialChart') {
				var blkId = addDialMetricsObj.widgetID;
				var showGaugeCircle='';
				if(showGaugeCircleObj != null && !Ext.isEmpty(showGaugeCircleObj) && showGaugeCircleObj != undefined)
				{
					showGaugeCircle=showGaugeCircleObj.getValue();
				}
				if(showGaugeCircle != null && showGaugeCircle == true)
				{
					showGaugeCircle="yes";
				}
				else
				{
					showGaugeCircle="no";
				}
				var useGaugeStateColor='';
				var useGaugeStateColorObj=Ext.getCmp('UseStateColorForGauge');
				if(useGaugeStateColorObj != null && !Ext.isEmpty(useGaugeStateColorObj) && useGaugeStateColorObj != undefined)
				{
					useGaugeStateColor=useGaugeStateColorObj.getValue();
				}
				var stateColorForGaugeVal='';
				if(useGaugeStateColor != null && useGaugeStateColor == true)
				{
					stateColorForGaugeVal="yes";
				}
				else
				{
					stateColorForGaugeVal="no";
				}
			}
			var selectedTest = testCombo.getValue();
			var selectedCompType = dialCompTypeCombo.getValue();
			var measure = '';
			if (widgetType != null && widgetType == 'liveMeasuresBox') {
				var measureMultiCombo = configForm.findField('measureCombo');
				measure = measureMultiCombo.getValue();
				//fontResize=Ext.getCmp('resizeFontYesNo').getValue();
			} else {
				var measureSingleCombo = configForm.findField('measureCombo');
				measure = measureSingleCombo.getValue();
			}
			var component = dialComponentCombo.getValue();
			var selectedDescriptor = dialDescriptorCombo.getValue();
			var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
			if (!isWidgetPreviewMode && selectedCompType != null && selectedCompType == '-1') {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : compTypAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			} else if (!isWidgetPreviewMode && component != null && (component == '' || component == '-1')) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : componentAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			} else if (!isWidgetPreviewMode && selectedTest != null && selectedTest == '-1') {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : testAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			} else if (!isWidgetPreviewMode && measure != null && (measure == '' || measure == '-1')) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : measureAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			} else if (!isWidgetPreviewMode && selectedDescriptor != null && selectedDescriptor == '' || selectedDescriptor == "chooseDescriptors") {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : descriptorAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			if (selectedDescriptor != null && selectedDescriptor == "-1")
				selectedDescriptor = "None";
			var testMeasure = '';
			var blkDispOpt='vertical';
			/*if (widgetType != null && widgetType == 'liveMeasuresBox') {
				var selectedMeas = configForm.findField('measureCombo').boundList.getSelectionModel().getSelection();
				for ( var selM in selectedMeas) {
					var selectedVal = selectedMeas[selM].data['valueField'];
					var selectedDispVal = selectedMeas[selM].data['displayField'];
					testMeasure = testMeasure + "," + (selectedDispVal + "$" + selectedTest + ":" + selectedVal);
				}
				if (testMeasure != null && testMeasure.indexOf(",") == 0) {
					testMeasure = encodeURIComponent(testMeasure.substring(1));
				}
			} else {*/
				testMeasure = encodeURIComponent(selectedTest + ":" + measure);
			//}
			var meC = this;
			var widgetID = addDialMetricsObj.widgetID;
			var configPanl = null;
			if(isWidgetPreviewMode)
			{
				configPanl=previewImageContainer;
			}
			
			var kpiBlckId='';
			var widgetName='';
			if(addDialMetricsObj.isKpi==true)
			{
				widgetName = widgetID;
				kpiBlckId = addDialMetricsObj.kpiBlckId;
				widgetID = kpiBlckId+'_'+widgetID;
			}
			selectedDescriptor = this.filterEncode(selectedDescriptor);
			var tmpProfNam=dashLayoutObj.profileName;
			if(!Ext.isEmpty(tmpProfNam))
			{
				tmpProfNam=this.filterEncode(tmpProfNam);
			}
			var paramsForSave = "action=saveKPIConfig&profileName=" + encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&widgetNameId="+widgetName+"&widgetType="+widgetType+"&KpiWidgetCount="+totalKpiCount+"&component="
					+ encodeURIComponent(component) + "&measure=" + testMeasure + "&selectedDescriptor=" + encodeURIComponent(selectedDescriptor);

			paramsForSave = paramsForSave+"&KpiWidgetCount="+totalKpiCount;

			if (widgetType != null && widgetType == 'dialChart') {
				paramsForSave=paramsForSave+"&showGaugeCircle="+showGaugeCircle+"&useStateColorForGauge=" + stateColorForGaugeVal;
				var colorPaletteObj=Ext.getCmp('ColorPicker').getValue();
				var colorPalette=colorPaletteObj.ColorPickerOpt;
				if(colorPalette == null || colorPalette == undefined || Ext.isEmpty(colorPalette))
				{
					colorPalette = '88CFE7';
				}
				if(colorPalette!=null && colorPalette!='')
				{
					paramsForSave=paramsForSave+"&selectedColor="+colorPalette;
				}
			}
			if (widgetType != null && widgetType == 'digitalChart') {
				paramsForSave=paramsForSave + "&useStateColorForFonts=" + useStateColorForFonts;
			}
			var gridStackObj=this.getGridstackpanel();
			var posStrVal=gridStackObj._serializationStr();
			if(posStrVal!=null && posStrVal!='')
			{
				paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
			}
			gridStackObj=null;
			delete gridStackObj;
			var showChartSummaryObj=Ext.getCmp('ChartSummaryEnabled');
			if(!Ext.isEmpty(showChartSummaryObj))
			{
				var enableChartSummary=showChartSummaryObj.getValue();
				if(enableChartSummary!=null && enableChartSummary==true)
				{
					var chartSummaryGraphTypeObj=Ext.getCmp('SummaryGraphType').getValue();
					var chartSummaryGraphType=chartSummaryGraphTypeObj.chartType;
					if(chartSummaryGraphType!=null && chartSummaryGraphType=="-1")
					{
						chartSummaryGraphType="none";
					}
					paramsForSave=paramsForSave+"&enableChartSummary=yes&summaryGraphType="+encodeURIComponent(chartSummaryGraphType);

					var showIcon=Ext.getCmp('ShowIcon').getValue();
					if(showIcon!=null && showIcon==true)
					{
						paramsForSave=paramsForSave+"&enableChartIcon=yes";
					}
					else
					{
						paramsForSave=paramsForSave+"&enableChartIcon=no";
					}

					var templateImageIconObj=$('#dashboardImageIcon');
					if(!Ext.isEmpty(templateImageIconObj))
					{
						var fileName = templateImageIconObj[0].src;
						var imgPath = null;
						if(fileName!=null && fileName.lastIndexOf("/")>0)
						{
							imgPath = fileName.substring(0,fileName.lastIndexOf("/"));
							fileName=fileName.substring(fileName.lastIndexOf("/")+1);
						}
						else if(fileName!=null && fileName.lastIndexOf("\\")>0)
						{
							imgPath = fileName.substring(0,fileName.lastIndexOf("\\"));
							fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
						}
						else
						{
							var digitalChartImgContObj=Ext.getCmp('digitalChartImgCont');					
							fileName =digitalChartImgContObj.iconClass;
						}

						if(fileName!=null)
						{
							if(imgPath!=null && !imgPath.endsWith("/final/images/"+strSkin))
							{
								fileName = "Custom:"+fileName;
								paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
							}
							else if(imgPath == null)
							{
								fileName = "Default:"+fileName;
								paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
							}
						}
					}
				}
				else
				{
					paramsForSave=paramsForSave+"&enableChartSummary=no&enableChartIcon=no";
				}
			}

			var drillDownOptObj=Ext.getCmp('drillDown');
			if(drillDownOptObj != null && !Ext.isEmpty(drillDownOptObj) && drillDownOptObj != undefined)
			{
				var selectedDrillDown = drillDownOptObj.getValue();
				selectedDrillDown = this.filterEncode(selectedDrillDown);
				paramsForSave=paramsForSave + "&selectedDrillDownOpt=" + encodeURIComponent(selectedDrillDown);
			}
		
			if(isWidgetPreviewMode)
			{
				paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			}
			paramsForSave=paramsForSave+"&useExternalData=no";
		}

		iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave,
					scope : this,
					success : function(response) {
						var updateBxId=widgetID;
						
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							if(!isWidgetPreviewMode)
							{								
								var win = Ext.widget('kpiConfigurationWindow', {
									blockId : kpiBlckId,
									blckType : 'KpiWidget',
									isFluidWindowConfigPopup : true,
									isConfigured:true,
									count:Kpicount,
								});
								if (win != null) {
									win.setTitle('KPI Configuration');
									win.show();
								}
							}
						}
					},
					failure : function(response, opts) {
						if (response.timedout) {
							configPanl.removeAll();
							configPanl.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},

	updateScatterPlotConfig : function()
	{
		return updateScatterPlotConfig(false,'');
	},
		
	updateScatterPlotConfig : function(isPreviewMode,previewContObj)
	{
		var meC = this;
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var addMetricsForm = addMetricsPopup.getComponent('configForm').getForm();

		var scatterTab_Obj=Ext.getCmp('scatterTab');
		
		var xAxisConfigured = scatterTab_Obj.xAxisConfigured
		var xAxisSelectedCompType = scatterTab_Obj.xAxisCompType;
		var xAxisComponent = scatterTab_Obj.xAxisComp;
		var xAxisSelectedTest = scatterTab_Obj.xAxisTest;
		var xAxisMeasure = scatterTab_Obj.xAxisMeas;
		var xAxisSelectedDescriptor = scatterTab_Obj.xAxisDesc;
	
		var yAxisConfigured = scatterTab_Obj.yAxisConfigured
		var yAxisSelectedCompType = scatterTab_Obj.yAxisCompType;
		var yAxisComponent = scatterTab_Obj.yAxisComp;
		var yAxisSelectedTest = scatterTab_Obj.yAxisTest;
		var yAxisMeasure = scatterTab_Obj.yAxisMeas;
		var yAxisSelectedDescriptor = scatterTab_Obj.yAxisDesc;
	
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForSave = "action=saveCorrelationConfig&profileName=" +encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID;

		if(true)
		{
			if ((xAxisSelectedCompType != null && xAxisSelectedCompType == '-1') || xAxisSelectedCompType==undefined) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : xAxisComponentTypeAlert,
				//msg :'Please choose a x axis component type',
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return false;
			} else if (xAxisComponent != null  && (xAxisComponent == '' || xAxisComponent == '-1' || xAxisComponent==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : xAxisComponentAlert,
					//msg :'Please choose a x axis component',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			} else if (xAxisSelectedTest==undefined || (xAxisSelectedTest != null && xAxisSelectedTest == '-1')) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : xAxisTestAlert,
					//msg :'Please choose a x axis test',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			} else if (xAxisMeasure != null && (xAxisMeasure == '' || xAxisMeasure == '-1' || xAxisMeasure==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : xAxisMeasureAlert,
					//msg :'Please choose a x axis measure',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			}

			if (xAxisSelectedDescriptor != null && xAxisSelectedDescriptor == '' || xAxisSelectedDescriptor == "chooseDescriptors" || xAxisSelectedDescriptor==undefined) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : xAxisDescriptorAlert,
						//msg :'Please choose a x axis descriptor',
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
			}
			xAxisSelectedDescriptor = filterEncode(xAxisSelectedDescriptor);
			 paramsForSave=paramsForSave + "&configuredXAxis=true&xAxisCompType="
				+ encodeURIComponent(xAxisSelectedCompType) + "&xAxisComponent="
				+ encodeURIComponent(xAxisComponent) +"&xAxisTest="
				+ encodeURIComponent(xAxisSelectedTest) + "&xAxisMeasure=" + encodeURIComponent(xAxisMeasure) + "&xAxisDescriptor=" + encodeURIComponent(xAxisSelectedDescriptor)
		}
		
		var isYAxisTabLoaded = scatterTab_Obj.isYAxisTabLoaded;
		var isWidgetConfigured = scatterTab_Obj.isWidgetConfigured;
	
		if(isYAxisTabLoaded)
		{		
			if ((yAxisSelectedCompType != null && yAxisSelectedCompType == '-1') || yAxisSelectedCompType==undefined) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : yAxisComponentTypeAlert,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return false;
			} else if (yAxisComponent != null && (yAxisComponent == '' || yAxisComponent == '-1'|| yAxisComponent==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisComponentAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			}else if (yAxisSelectedTest==undefined || (yAxisSelectedTest == '' || yAxisSelectedTest != null && yAxisSelectedTest == '-1')) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisTestAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			} else if (yAxisMeasure != null && (yAxisMeasure == '' || yAxisMeasure == '-1' | yAxisMeasure==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisMeasureAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			}

			if (yAxisSelectedDescriptor != null && yAxisSelectedDescriptor == '' || yAxisSelectedDescriptor == "chooseDescriptors" || xAxisSelectedDescriptor==undefined) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : yAxisDescriptorAlert,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
			}
			yAxisSelectedDescriptor = filterEncode(yAxisSelectedDescriptor);
			paramsForSave=paramsForSave + "&configuredYAxis=true&yAxisCompType="
				+ encodeURIComponent(yAxisSelectedCompType) + "&yAxisComponent="
				+ encodeURIComponent(yAxisComponent) +"&yAxisTest="
				+ encodeURIComponent(yAxisSelectedTest) + "&yAxisMeasure=" + encodeURIComponent(yAxisMeasure) + "&yAxisDescriptor=" + encodeURIComponent(yAxisSelectedDescriptor);

		}
		else if (!isWidgetConfigured)
		{
			if ((yAxisSelectedCompType != null && yAxisSelectedCompType == '-1') || yAxisSelectedCompType==undefined) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : yAxisComponentTypeAlert,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return false;
			} else if (yAxisComponent != null && (yAxisComponent == '' || yAxisComponent == '-1'|| yAxisComponent==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisComponentAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			} else if (yAxisSelectedTest==undefined || (yAxisSelectedTest == '' || yAxisSelectedTest != null && yAxisSelectedTest == '-1')) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisTestAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			} else if (yAxisMeasure != null && (yAxisMeasure == '' || yAxisMeasure == '-1' | yAxisMeasure==undefined)) {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : yAxisMeasureAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return false;
			}

			if (yAxisSelectedDescriptor != null && yAxisSelectedDescriptor == '' || yAxisSelectedDescriptor == "chooseDescriptors" || xAxisSelectedDescriptor==undefined) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : yAxisDescriptorAlert,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return false;
			}
			yAxisSelectedDescriptor = filterEncode(yAxisSelectedDescriptor);
			paramsForSave=paramsForSave + "&configuredYAxis=true&yAxisCompType="
				+ encodeURIComponent(yAxisSelectedCompType) + "&yAxisComponent="
				+ encodeURIComponent(yAxisComponent) +"&yAxisTest="
				+ encodeURIComponent(yAxisSelectedTest) + "&yAxisMeasure=" + encodeURIComponent(yAxisMeasure) + "&yAxisDescriptor=" + encodeURIComponent(yAxisSelectedDescriptor);
		}

		if (widgetType != null) {
			var er_timeline = addMetricsForm.findField('Timeline').getValue();
			
			paramsForSave = paramsForSave + "&saveTimeline=true&time_line=" + er_timeline + "&timelineKey=" + widgetID ;
		}

		var colorPaletteObj=Ext.getCmp('ColorPicker').getValue();
		var colorPalette=colorPaletteObj.ColorPickerOpt;
		if(colorPalette!=null && colorPalette!='')
		{
			paramsForSave=paramsForSave+"&selectedColor="+colorPalette;
		}

		var showDescOptObj=addMetricsForm.findField('DescriptorschkBxOpt');
		var showDescOpt = 'no';
		if(!Ext.isEmpty(showDescOptObj) && showDescOptObj.getValue()==true)
		{
			showDescOpt='yes';
		}
		var showServersOptObj=addMetricsForm.findField('ServerschkBxOpt');
		var showServersOpt = 'no';
		if(!Ext.isEmpty(showServersOptObj) && showServersOptObj.getValue()==true)
		{
			showServersOpt='yes';
		}

		var showMetricsOptObj=addMetricsForm.findField('MetricschkBxOpt');
		var showMetricsOpt = 'no';
		if(!Ext.isEmpty(showMetricsOptObj) && showMetricsOptObj.getValue()==true)
		{
			showMetricsOpt='yes';
		}

		paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt+'&showMetrics='+showMetricsOpt;

		if(!isPreviewMode)
		{
			addMetricsPopup.close();
		}
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridStackObj=null;
		delete gridStackObj;
		var configPanl = Ext.getCmp(widgetID);
		if(!Ext.isEmpty(publicJson['myDashboardConfigDetails']))
		{
			if(publicJson['myDashboardConfigDetails']['configIds'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configIds'].push(widgetID);
			}
			if(publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID') && publicJson['myDashboardConfigDetails']['configuredWidgetsID'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configuredWidgetsID'].push(widgetID);
			}
		}
		if(isPreviewMode)
		{
			configPanl = previewContObj;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}

		iAjax
				.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							if(!isPreviewMode)
							{
								meC.getPortlet().setRefresh(configPanl);
							}
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							var updateBxId=widgetID;
							if(isPreviewMode)
							{
								updateBxId=widgetID+"_previewImage";
							}
							configPanl.isConfigured=true;

							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							jsonData=null;
							delete jsonData;
						}
						jsonText=null;
						delete jsonText;
					},
					failure : function(response, opts) {
						if (response.timedout) {
							if (widgetType != null && widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType=='combinationChart' || widgetType == 'TrendGraph') {
								configPanl
										.update('<table width="100%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></div></td></tr></table>');
							} else {
								configPanl.removeAll();
								configPanl
										.add({
											xtype : 'panel',
											html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
													+ (configPanl.getHeight() - 20)
													+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
													+ requestTimeoutMsg + '</div></td></tr></table></div>'
										});
							}
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	updateBlockConfig : function(isPreviewMode,previewContObj)
	{
		var meC = this;
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var widgetID = addMetricsPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var addMetricsForm = addMetricsPopup.getComponent('configForm').getForm();
		var isTopNTable = false;
		var requestParameterMapping={};

		var paramsForSave ='';
	/*	var settingsCtrlArr=addMetricsPopup.widgetSettingsJsonArr;
		if(!Ext.isEmpty(settingsCtrlArr))
		{
			for(var setObj in  settingsArrJson)
			{
				var settingOptObj=settingsArrJson[setObj];
				paramsForSave+=getSettingValue(settingOptObj);

			}
		}*/
		/*if (btn != null && btn.getId() == 'updateTopN') {
			
		} else {*/
		var topNMeasure = '';
		var showValuesOpt='No';
		var sortAcrossPages='No';
		if (widgetType != null && widgetType == "table") {
			showValuesOpt=addMetricsForm.findField('ShowValues').getValue();
			if(showValuesOpt==true)
				showValuesOpt="yes";
			else
				showValuesOpt="no";
			//showValuesOpt = showValuesOptObj[0].inputValue;
			
			var sortAcrossPagesVal=addMetricsForm.findField('sortAcrossPages').getValue();
			if(sortAcrossPagesVal==true)
				sortAcrossPages="yes";
			else
				sortAcrossPages="no";
		}
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var configuredMeasures = '';
		var configuredComponents = '';
		var configuredDescriptors = '';
		var componentDisplayNames = '';
		var descriptorDisplayNames = '';
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var isCombinationChart=false;
		var isBarChart=false;
		var isStackedBarChart=false;
		if(widgetType!=null && widgetType=='combinationChart')
		{
			isCombinationChart=true;
		}
		else if(widgetType!=null && widgetType == 'BarChart')
		{
			var stackedChartObj = addMetricsForm.findField('Stacked').getValue();
			var stackedChart="no";
			
			if(stackedChartObj!=null && stackedChartObj==true)
			{
				stackedChart='yes';
				isStackedBarChart=true;
			}
			isBarChart=true;
		}
		var autoAssociateServers=addMetricsPopup.autoAssociateComponents;
		
		var autoCompAssociationEnabled='no';
		if(isPreviewMode && (autoAssociateServers!=null && autoAssociateServers==true))
		{
			autoCompAssociationEnabled='yes';
		}
		/*var autoCompAssociationEnabled='no';
		var autoAssServChkBoxObj=Ext.getCmp('autoAssServers');
		if(!Ext.isEmpty(autoAssServChkBoxObj))
		{
			var stValObj=autoAssServChkBoxObj.getValue();
			var autoAssociateServers='';
			if(!Ext.isEmpty(stValObj) && stValObj.hasOwnProperty('autoAssServs'))
			{
				autoAssociateServers=stValObj.autoAssServs;
			}
			if(autoAssociateServers!=null && autoAssociateServers=='yes')
			{
				autoCompAssociationEnabled='yes';
			}
		}*/
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var descItmArr=[];
		var compItmArr=[];
		var isPromptUserToAggregateMetrics=false;
		for ( var i = 0; i < gridRecordCount; i++) {
			var measuresHidVal = gridObj.getStore().getAt(i).get('measuresHidVal');
			var componentsHidVal = gridObj.getStore().getAt(i).get('componentsHidVal');
			var descriptorHidVal = gridObj.getStore().getAt(i).get('descriptorHidVal');
			var componentDisplayName = gridObj.getStore().getAt(i).get('componentDisplayName');
			var descriptorDisplayName = gridObj.getStore().getAt(i).get('descriptorDisplayName');
			if (configuredMeasures.indexOf(measuresHidVal) == -1) {
				configuredMeasures = configuredMeasures + "," + measuresHidVal;
			}
			if (configuredComponents.indexOf(componentsHidVal) == -1) {
				configuredComponents = configuredComponents + "," + componentsHidVal;
			}
			configuredDescriptors = configuredDescriptors + "," + descriptorHidVal;
			if(!Ext.isEmpty(componentDisplayName))
			{
				if(compItmArr!=null && !Ext.Array.contains(compItmArr,componentDisplayName))
				{
					componentDisplayNames=componentDisplayNames+","+componentDisplayName;
					compItmArr.push(componentDisplayName);
				}
			}
			if(!Ext.isEmpty(descriptorDisplayName))
			{
				if(descItmArr!=null && !Ext.Array.contains(descItmArr,descriptorDisplayName))
				{
					descriptorDisplayNames=descriptorDisplayNames+","+descriptorDisplayName;
					descItmArr.push(descriptorDisplayName);
				}
			}
			if(isStackedBarChart)
			{
				if(descriptorHidVal.indexOf("|HASH|")<0)
				{
					isPromptUserToAggregateMetrics=true;
					break;
				}
			}
		}
		if(isStackedBarChart && isPromptUserToAggregateMetrics)
		{
			Ext.MessageBox.show({
				title: myDashboardAlertLbl,
				msg: aggEnableAlertMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});					
			return false;
		}
		if (configuredMeasures != null && configuredMeasures.indexOf(",") == 0) {
			configuredMeasures = configuredMeasures.substring(1);
		}
		if (configuredComponents != null && configuredComponents.indexOf(",") == 0) {
			configuredComponents = configuredComponents.substring(1);
		}
		if (configuredDescriptors != null && configuredDescriptors.indexOf(",") == 0) {
			configuredDescriptors = configuredDescriptors.substring(1);
		}
		if (componentDisplayNames != null && componentDisplayNames.indexOf(",") == 0) {
			componentDisplayNames=componentDisplayNames.substring(1);
		}
		if (descriptorDisplayNames != null && descriptorDisplayNames.indexOf(",") == 0) {
			descriptorDisplayNames=descriptorDisplayNames.substring(1);
		}
		configuredMeasures = meC.filterEncode(configuredMeasures);
		configuredDescriptors = meC.filterEncode(configuredDescriptors);
		
		paramsForSave = "action=saveConfig&profileName=" + encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&configuredMeasures="
				+ encodeURIComponent(configuredMeasures) + "&configuredComponents=" + encodeURIComponent(configuredComponents) + "&configuredDescriptors="
				+ encodeURIComponent(configuredDescriptors);
		if(!Ext.isEmpty(componentDisplayNames))
		{
			paramsForSave=paramsForSave+"&ComponentDisplayNames="+encodeURIComponent(componentDisplayNames);
		}
		if(!Ext.isEmpty(descriptorDisplayNames))
		{
			paramsForSave=paramsForSave+"&descriptorDisplayNames="+encodeURIComponent(descriptorDisplayNames);
		}
		if (widgetType != null) {
			 if (widgetType == 'CombinedTimelineChart' || widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType=='combinationChart' || isTopNTable ||widgetType=='TrendGraph' ) {
				var addMetricsForm = addMetricsPopup.getComponent('configForm').getForm();
				var startDateVal = addMetricsForm.findField('er_stdate').dataArray;
				var endDateVal = addMetricsForm.findField('er_enddate').dataArray;
				var startHour = addMetricsForm.findField('er_sthr').dataArray;
				var endHour = addMetricsForm.findField('er_endhr').dataArray;
				var stDate = addMetricsForm.findField('er_stdate').getValue();
				var enDate = addMetricsForm.findField('er_enddate').getValue();
				stDate.setHours(addMetricsForm.findField('er_sthr').getValue());
				enDate.setHours(addMetricsForm.findField('er_endhr').getValue());
				var er_timeline = addMetricsForm.findField('er_timeline').getValue();
				var startMinObj = addMetricsForm.findField('er_stmin');
				var endMinObj = addMetricsForm.findField('er_endmin');
				var stmin=startMinObj.getValue();
				var endmin=endMinObj.getValue();
				stDate.setMinutes(stmin);
				enDate.setMinutes(endmin);
				var fromValue = formatDate(stDate, mgrDisplayDateFormat);
				var ToValue = formatDate(enDate, mgrDisplayDateFormat);	

				var startHourVal = addMetricsForm.findField('er_sthr').getValue();
				var endHourVal = addMetricsForm.findField('er_endhr').getValue();
				//Date validation
				var today = new Date();		
				var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
				if(er_timeline!=null && er_timeline.toLowerCase() == 'any')
				{		
					if(new Date(fromValue) > new Date(ToValue))
					{
						Ext.MessageBox.show({
							title:myDashboardAlertLbl,
							msg: DateErrorMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
						});				
						return false;
					}
					if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
					{	
						if(startHour > endHour)
						{
							Ext.MessageBox.show({
							title: myDashboardAlertLbl,
							msg: DateErrorMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});					
							return false;
						}
						if(startHour == endHour)
						{
							if(stmin >= endmin)
							{
								Ext.MessageBox.show({
								title: myDashboardAlertLbl,
								msg: DateErrorMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
								});					
								return false;
							}
						}
					}			
					if(today < new Date(fromValue) )
					{
						Ext.MessageBox.show({
							title: myDashboardAlertLbl,
							msg: timeErrorMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
							});
							return false;
					}
				}
				startDateVal = formatDate(new Date(getDateFromFormat(startDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");
				endDateVal = formatDate(new Date(getDateFromFormat(endDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");

				paramsForSave = paramsForSave + "&saveTimeline=true&time_line=" + er_timeline + "&timelineKey=" + widgetID + "&starttime="
						+ encodeURI(startDateVal) + "&endtime=" + encodeURI(endDateVal) + "&starthr=" + startHour + "&endhr=" + endHour+"&stmin="+stmin+"&endmin="+endmin;
			}  
			if (widgetType != null && widgetType == 'table') {
				if(!isTopNTable)
				{
					paramsForSave = paramsForSave +'&showValues='+showValuesOpt; //paramsForSave + "&thresholdKey=" + widgetID + "_ThresholdNeeded&thresholdValue=" + isShowThreshold+
					paramsForSave = paramsForSave +'&sortAcrossPages='+sortAcrossPages;
					var enableMeasureStateColor='';
					var stateColorOnValue=addMetricsForm.findField('SetStateColorOn').getValue();
					if(stateColorOnValue!=null && stateColorOnValue=="None")
					{
						 enableMeasureStateColor='no';
					}else{
						 enableMeasureStateColor='yes';
					}
					paramsForSave=paramsForSave+"&EnableMeasureStateColor="+encodeURIComponent(enableMeasureStateColor);
					paramsForSave=paramsForSave+"&SetStateColorOn="+encodeURIComponent(stateColorOnValue);
					
					var showChartSummaryObj=Ext.getCmp('enableChartSummary');
					var chartTypeOpts=addMetricsForm.findField('SummaryGraphType')
					if(!Ext.isEmpty(showChartSummaryObj))
					{
						var enableChartSummary=showChartSummaryObj.getValue();
						if(enableChartSummary!=null && enableChartSummary==true)
						{
							var chartSummaryGraphTypeObj=chartTypeOpts.getValue();
							var chartSummaryGraphType=chartSummaryGraphTypeObj.chartType;

							if(chartSummaryGraphType!=null && chartSummaryGraphType=="-1")
							{
								chartSummaryGraphType="none";
							}
							paramsForSave=paramsForSave+"&ChartSummaryEnabled=yes&SummaryGraphType="+encodeURIComponent(chartSummaryGraphType);
						}
						else
						{
							paramsForSave=paramsForSave+"&ChartSummaryEnabled=no&SummaryGraphType=none";
						}	
					}
				}
			}
			if(widgetType != null && (widgetType == 'areaChart'  || widgetType == 'BarChart'))
			{
				var stackedChartObj = addMetricsForm.findField('Stacked').getValue();
				var stackedChart="no";
				if(!Ext.isEmpty(stackedChartObj) && stackedChartObj==true)
				{
					stackedChart = "yes";
				}
				paramsForSave = paramsForSave +'&stackedChart='+stackedChart; 
				
			}
			if(widgetType != null && (widgetType == 'TimelineChart' || widgetType == "TrendGraph"))
			{
				var chartSplineGraphTypeObj=addMetricsForm.findField('chartType').getValue();
				chartSplineGraphType=chartSplineGraphTypeObj.chartType;
				if(chartSplineGraphType!=null && chartSplineGraphType=="line")
				{
					chartSplineGraphType="line";
				}
				paramsForSave=paramsForSave+"&splineGraphType="+encodeURIComponent(chartSplineGraphType);

				if(widgetType == "TrendGraph")
				{
					var period=addMetricsForm.findField('period').getValue();
					var trendGraphOpt=addMetricsForm.findField('Statistics').getValue();
					paramsForSave=paramsForSave+"&period="+encodeURIComponent(period)+"&trendGraphOpt="+encodeURIComponent(trendGraphOpt);
				}
			}
		}
		if (widgetType == 'CombinedTimelineChart' || widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType=='combinationChart' || widgetType=='TrendGraph' || widgetType=='pieChart' || widgetType=='activityChart' || widgetType=='BarChart' || widgetType=='heatMapChart')
		{
			var palette=Ext.get('PaletteId').getValue();
			paramsForSave=paramsForSave+"&palette="+encodeURIComponent(palette);

		 }
	
		var showDescOptObj=addMetricsForm.findField('DescriptorschkBxOpt');
		var showDescOpt = 'no';
		if(!Ext.isEmpty(showDescOptObj) && showDescOptObj.getValue()==true)
		{
			showDescOpt='yes';
		}

		var showServersOptObj=addMetricsForm.findField('ServerschkBxOpt');
		var showServersOpt = 'no';
		if(!Ext.isEmpty(showServersOptObj) && showServersOptObj.getValue()==true)
		{
			showServersOpt='yes';
		}
		
		if (widgetType != null && (widgetType != 'table' && widgetType != 'BarChart')) {
			var showMetricsOptObj=addMetricsForm.findField('MetricschkBxOpt');
			var showMetricsOpt = 'no';
			if(!Ext.isEmpty(showMetricsOptObj) && showMetricsOptObj.getValue()==true)
			{
				showMetricsOpt='yes';
			}
		}
		if (widgetType != null && (widgetType == 'areaChart' || widgetType == 'TimelineChart' || widgetType == 'combinationChart' || widgetType == 'TrendGraph'))
		{
				var showChartSummarySwitchVal = addMetricsForm.findField('showChartSummary').getValue();
				var showChartSummaryVal="no";
				if(showChartSummarySwitchVal!=null && showChartSummarySwitchVal==true)
				{
					if(!isPreviewMode && ((showDescOptObj!=null && showDescOptObj.getValue()==false) && (showMetricsOptObj!=null && showMetricsOptObj.getValue()==false) && (showServersOptObj!=null && showServersOptObj.getValue()==false)))
					{
						Ext.Msg.show({
							title : myDashboardAlertLbl,
							msg : legendTypeAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
						});
						return;
					}
					showChartSummaryVal='yes';
					if(showDescOpt=='no' && showServersOpt=='no'){
						showMetricsOpt='yes';
					}
				}
				paramsForSave = paramsForSave +'&showChartSummary='+showChartSummaryVal; 
		}
		
		/* code end for displaying metrics in legend */
		else if (widgetType != null && (widgetType == 'table' || widgetType == 'BarChart')) {
			if((showDescOptObj!=null && showDescOptObj.getValue()==false) && (showServersOptObj!=null && showServersOptObj.getValue()==false))
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : legendTypeAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
		}
		/* code begin for showing percentahge distribution  in piechart */
		if(widgetType!=null && (widgetType=='pieChart' || widgetType=='activityChart'))
		{
			if((showDescOptObj!=null && showDescOptObj.getValue()==false) && (showMetricsOptObj!=null && showMetricsOptObj.getValue()==false) && (showServersOptObj!=null && showServersOptObj.getValue()==false))
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : legendTypeAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			var showDistprcntOpt='no';
			var radioBtnObject=addMetricsForm.findField('showDistprcnt');			
			if (!radioBtnObject.isHidden()) {
				var showDistprcnt = radioBtnObject.getValue();
				if(showDistprcnt)
				{
					showDistprcntOpt = 'yes';
				}
			} else {
				showDistprcntOpt = 'yes';
			}
		}
		/* code end for showing percentahge distribution  in piechart */
		if(widgetType!=null && widgetType=='pieChart')
		{
			var chartType='donut';
			var btnObjectForPType=addMetricsForm.findField('chartType');			
			if (!btnObjectForPType.isHidden()) {
				var chartType = btnObjectForPType.getValue().chartType;
			}
			var pieLabelsOpt='yes';
			var btnObjectForPLabels=addMetricsForm.findField('pieLabels');			
			if (!btnObjectForPLabels.isHidden()) {
				var pieLabels = btnObjectForPLabels.getValue();
				if(!pieLabels)
				{
					pieLabelsOpt = 'no';
				}
			}
			else{
				pieLabelsOpt='yes';
			}
			var pieLegendPlacement='bottom';
			var btnObjectForLegendPlacement=addMetricsForm.findField('pieLegendPlacement');			
			if (!btnObjectForLegendPlacement.isHidden()) {
				var pieLegendPlacement = btnObjectForLegendPlacement.getValue();
			}
			var pieLegendMode='bottom';
			var btnObjectForLegendMode=addMetricsForm.findField('pieLegendMode');			
			if (!btnObjectForLegendMode.isHidden()) {
				var pieLegendMode = btnObjectForLegendMode.getValue();
			}
			paramsForSave = paramsForSave+'&chartType='+chartType+'&pieLabels='+pieLabelsOpt+'&pieLegendPlacement='+pieLegendPlacement+'&pieLegendMode='+pieLegendMode;
		}
		if(widgetType!=null && (widgetType=='pieChart' || widgetType=='activityChart'))
		{
			var modifiedWidget= addMetricsPopup.modified;
			
			if(!modifiedWidget){
				if (configuredComponents != null && configuredComponents.indexOf(",") > 0) {
					showServersOpt = 'yes';
				}else{
					showServersOpt = 'no';
				}
			
				if (configuredMeasures != null && configuredMeasures.indexOf(",") > 0) {
					showMetricsOpt = 'yes';
				}else{
					showMetricsOpt = 'no';
				}
			}
			paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt+'&showMetrics='+showMetricsOpt+'&showDistprcnt='+showDistprcntOpt/*+"&showLegendStyle="+showLegendStyleOpt*/;
		}
		else
		{
			paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt+'&showMetrics='+showMetricsOpt; //added showMetrics Param
		}
		if (widgetType == 'BarChart')
		{
			var viewTypeOpt = addMetricsForm.findField('ViewType').getValue();
			if(viewTypeOpt!=null)
			{
				paramsForSave = paramsForSave+'&viewTypeOpt='+viewTypeOpt;
			}
		}
		if (widgetType != null && (widgetType == 'combinationChart' || widgetType == 'TimelineChart' || widgetType == 'areaChart'|| widgetType=='table' || widgetType=='CombinedTimelineChart' || widgetType == 'BarChart') || widgetType == 'TrendGraph' || widgetType == 'pieChart' || widgetType == 'activityChart' || widgetType == 'heatMapChart') 
		{
			var descriptorVal = addMetricsForm.findField('excludeDesc').getValue();
			//if(descriptorVal!=null && (descriptorVal.indexOf('*')>-1 || descriptorVal.indexOf('*.*')>-1))
			if(descriptorVal!=null && (descriptorVal.indexOf('*')==0 && descriptorVal.length==1))
			{
				Ext.Msg.show({
							title : myDashboardAlertLbl,
							msg : descriptorExcludeAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
							});
							return;
			}
			descriptorVal = filterEncode(descriptorVal);
			paramsForSave = paramsForSave+'&excludedDescriptors='+encodeURIComponent(descriptorVal);
		}
		if( widgetType == 'TimelineChart' || widgetType == 'areaChart')
		{
			//var yMaxValue = Ext.getCmp("yMax");
			var yMaxValue = addMetricsForm.findField('yMax').getValue();
			if(yMaxValue!=null && yMaxValue!='')
			{
				if(!Ext.isNumeric(yMaxValue))
				{
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : screenLabelsObj['yMaxLimit-Non-NumericAlertMsg'],
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
				paramsForSave=paramsForSave+'&yMaxValue='+encodeURIComponent(yMaxValue);
			}
		}
		paramsForSave=paramsForSave+"&useExternalData=no";
		
		if( widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType == 'combinationChart' || widgetType == 'TrendGraph')
		{
			var sortByPriority=Ext.getCmp('SortByPriority');
			if(!Ext.isEmpty(sortByPriority))
			{
				var sortByPriorityVal=sortByPriority.getValue();
				if(!Ext.isEmpty(sortByPriorityVal) && sortByPriorityVal==true)
				{
					var priority=Ext.getCmp('Priority').getValue();
					paramsForSave=paramsForSave+"&sortByPriority=yes&topNPriority="+priority;
				}
				else
				{
					paramsForSave=paramsForSave+"&sortByPriority=no";
				}
			}
		}
	/*	if (isTopNTable) {

			paramsForSave = paramsForSave + "&isTopNComputation=true&topNMeasure=" + encodeURIComponent(topNMeasure);
		}*/
    var drillDownOptObj=Ext.getCmp('drillDown');
		if(drillDownOptObj != null && !Ext.isEmpty(drillDownOptObj) && drillDownOptObj != undefined)
		{
			var selectedDrillDown = drillDownOptObj.getValue();
			selectedDrillDown = this.filterEncode(selectedDrillDown);
			paramsForSave=paramsForSave + "&selectedDrillDownOpt=" + encodeURIComponent(selectedDrillDown);
		}
		if(!isPreviewMode)
		{
			addMetricsPopup.close();
		}
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridStackObj=null;
		delete gridStackObj;
		var configPanl = Ext.getCmp(widgetID);

		if(!Ext.isEmpty(publicJson['myDashboardConfigDetails']))
		{
			if(publicJson['myDashboardConfigDetails']['configIds'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configIds'].push(widgetID);
			}
			if(publicJson['myDashboardConfigDetails'].hasOwnProperty('configuredWidgetsID') && publicJson['myDashboardConfigDetails']['configuredWidgetsID'].indexOf(widgetID)==-1)
			{
				publicJson['myDashboardConfigDetails']['configuredWidgetsID'].push(widgetID);
			}
		}
		if(isPreviewMode)
		{
			configPanl = previewContObj;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		
//		configPanl.setLoading(true, true);
		if(isPreviewMode && !Ext.isEmpty(autoCompAssociationEnabled))
		{
			paramsForSave=paramsForSave+"&autoAssociateComponents="+autoCompAssociationEnabled;
		}

		iAjax
				.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							if(!isPreviewMode)
							{
								meC.getPortlet().setRefresh(configPanl);
							}
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							configPanl.isExternalDataSourceWidget=false;
							var updateBxId=widgetID;
							if(isPreviewMode)
							{
								updateBxId=widgetID+"_previewImage";
							}
							configPanl.isConfigured=true;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
							jsonData=null;
							delete jsonData;
						}
						jsonText=null;
						delete jsonText;
					},
					failure : function(response, opts) {
						if (response.timedout) {
							if (widgetType != null && widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType=='combinationChart' || widgetType == 'TrendGraph') {
								configPanl
										.update('<table width="100%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></div></td></tr></table>');
							} else {
								configPanl.removeAll();
								configPanl
										.add({
											xtype : 'panel',
											html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
													+ (configPanl.getHeight() - 20)
													+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
													+ requestTimeoutMsg + '</div></td></tr></table></div>'
										});
							}
							configPanl.setLoading(false);
							configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
			});
	},
	filterEncode: function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&',';','"',':','.'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|','|scol|',"|dqt|","|colon|","|dot|"];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	loadTestsForComp : function(combo) {
		var selectedComp = combo.getValue();

		if (selectedComp != "-1") {
			var paramsForRc = 'C=true&F=getTestsAsJSONForComponent&P0={' + selectedComp + '}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadHealthTests', 'healthPopup', '', true);
		} else {
			var healthmetricsObj = this.getWidgetOptionsWindow();
			var configForm = healthmetricsObj.getComponent('configForm').getForm();
			var testCombo = configForm.findField('testCombo');
			var testComboStore = testCombo.getStore();
			testComboStore.removeAll();
			testComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			testCombo.setValue('-1');
			var measuresCombo = configForm.findField('measureCombo');
			var measuresComboStore = measuresCombo.getStore();
			measuresComboStore.removeAll();
			measuresComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			measuresCombo.setValue('-1');
			var descriptorCombo = configForm.findField('descriptorCombo');
			if(descriptorCombo != null && !Ext.isEmpty(descriptorCombo))
			{
				var descriptorComboStore = descriptorCombo.getStore();
				descriptorComboStore.removeAll();
				descriptorComboStore.insert(0, {
					displayField : notApplicable,
					valueField : '-1'
				});
				descriptorCombo.setValue('-1');
			}
		}
	},
	descriptorsOnClick : function(view, record, item, index, e, eOpts) {
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var descriptorCombo = configForm.findField('descriptorCombo');
		var selectedDescs = view.getSelectionModel().getSelection();
		var isAllDescriptorsSelected = false;
		var allDescRecIdx = null;
		for ( var sel in selectedDescs) {
			var selectedVal = selectedDescs[sel].data['valueField'];
			if (selectedVal != null && selectedVal == 'allDescriptors') {
				allDescRecIdx = sel;
				isAllDescriptorsSelected = true;
			} else {
				isAllDescriptorsSelected = false;
			}
		}
		if (isAllDescriptorsSelected) {
			descriptorCombo.setValue('allDescriptors');
		} else if (allDescRecIdx != null) {
			view.getSelectionModel().deselect(selectedDescs[allDescRecIdx]);
		}
	},
	expandMe : function(btn) {
		var comBoId = '';
		var expandPopupAlertMsg = '';
		var btnId = btn.getId();
		if (btnId == 'componentExpandSelector') {
			comBoId = 'componentCombo';
			expandPopupAlertMsg = componentAlertMsg;
		} else if (btnId == 'measureExpandSelector') {
			comBoId = 'measureCombo';
			expandPopupAlertMsg = componentAlertMsg;
		} else if (btnId == 'descriptorExpandSelector') {
			comBoId = 'descriptorCombo';
			expandPopupAlertMsg = descriptorAlertMsg;
		}
		else if (btnId == 'ddColumnsExpandSelector') {
			comBoId = 'ddColumnsCombo';
			expandPopupAlertMsg = noDDColSelectedAlertMsg;
		}
		else if (btnId == 'summarizeDDColumnExpandSelector') {
			comBoId = 'summarizeDDColumnCombo';
			expandPopupAlertMsg = noDDColSelectedAlertMsg;
		}
		var CmpClone = Ext.getCmp(comBoId);
		var cloneStore = Ext.clone(CmpClone.getStore());
		btn.setDisabled(true);
		var meC = this;
		var expandWindow = Ext.create('Ext.window.Window', {
			title : Ext.getCmp(comBoId + 'Lbl').text,
			//cls:'expandWindowPopupShadow',
			ui:'eg-new-window',
			height:350,
			layout:{
							type:'vbox',
							align:'stretch',
						},
			padding:'0 10 010',
			width : 260,
			frame:true,
			border:true,
			ghost:false,
			id: btnId+'View',
			closeAction : 'destroy',
			buttonAlign : 'center',
			btnObjId : btnId,
			comboBxId : comBoId,
			modal : true,
			items : [{
						xtype: 'container',
						//width:240,
						flex:1,
						layout:{
							type:'vbox',
							align:'stretch',
						},
						margin: 0,
						items: [
						{
							xype: 'container',
							cls: 'multisearchlist',
							style:{'top':'0px'},
							items: [{
								xtype: 'customtrigger',
								width:225,
								id: 'compSearch',
								listeners :
								{
									'change' : function(triggerField, newValue, oldValue, eOpts) {
										if(!Ext.isEmpty(cloneStore))
										{
											if(newValue=="*")
											{
												cloneStore.clearFilter();
											}
											else
											{
												if(newValue.lastIndexOf("*")==(newValue.length-1))
												{
													newValue = newValue.substr(0,(newValue.length-1));
												}
												cloneStore.clearFilter();
												if (newValue) {
													var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
													cloneStore.filter({
														filterFn: function(record) {
															return matcher.test(record.get('displayField')) ;
														}
													});
												}
											triggerField.focus();
											}
										}
									}

								}
							}]
						},{
							xtype: 'multiselect',
							width:240,
							flex:1,
							border : 0,
							autoScroll : true,
							scroll : true,
							labelAlign : 'left',
							baseCls : 'egmultiselect',
							multiSelect : true,
							id : comBoId + '_Clone',
							name : comBoId + '_Clone',
							store : cloneStore,
							value : CmpClone.getValue(),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							listConfig : {
								simpleSelect : true,
								id : comBoId + '_maximize',
								name : comBoId + '_maximize'
							}
						}
					]
				}
			],
			buttons : [ {
				text : 'Select',
				id : 'expand',
				margin:'0 0 10 0',
				padding:'0 4 0 4',
				cls : 'quickMenuWhiteButton',
				name : 'expand',
				handler : function() {
					var maxComboObj = Ext.getCmp(this.up('window').comboBxId + '_Clone');
					if (maxComboObj.getValue() != '') {
						var thisBtnObj = Ext.getCmp(this.up('window').btnObjId);
						if (thisBtnObj != null) {
							thisBtnObj.setDisabled(false);
						}
						if (comBoId != null && comBoId == 'componentCombo') {
							var tmpSt = [];
							for ( var i = 0; i < maxComboObj.getStore().getCount(); i++) {
								var rec = maxComboObj.getStore().getAt(i);
								tmpSt.push(rec);
							}
							CmpClone.getStore().loadData(tmpSt, false);
							CmpClone.setValue(maxComboObj.getValue());
							meC.loadDescriptors();
						} else {
							CmpClone.setValue(maxComboObj.getValue());
						}
						expandWindow.destroy();
					} else {
						Ext.MessageBox.show({
							title : myDashboardAlertLbl,
							msg : expandPopupAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : 'iconExclamation'
						});
						return;
					}
				}
			}],
			listeners : {
				'destroy' : function() {
					if (btnId == 'oneClickCompExpand') {
						cloneStore.clearFilter();
					}
					var thisBtnObj = Ext.getCmp(this.btnObjId);
					if (thisBtnObj != null) {
						thisBtnObj.setDisabled(false);
					}
				}
			}
		}).show();
//		this.getMain().doLayout();
	},
	showAggOptions : function(radioBtnObj) {
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var showAggOpt = radioBtnObj.getValue();
		//var showAggOpt = showAggOptObj[0].inputValue;
		if (showAggOpt != null && showAggOpt == true) {
			configForm.findField('aggOptions').show();
		//	Ext.getCmp('descriptorComboLbl').hide();
			Ext.getCmp('descriptorMultiSelectOuterBox').setDisabled(true);
		//	Ext.getCmp('descriptorExpandSelector').setDisabled(true);
	//		Ext.getCmp('descriptorSearchTextBox').hide();
		//	Ext.getCmp('descriptorCombo').hide();
		} else {
			configForm.findField('aggOptions').hide();
		//	Ext.getCmp('descriptorComboLbl').show();
			Ext.getCmp('descriptorMultiSelectOuterBox').setDisabled(false);
			Ext.getCmp('descriptorExpandSelector').setDisabled(false);
		//	Ext.getCmp('descriptorSearchTextBox').show();
		//	Ext.getCmp('descriptorCombo').show();
		}
	},
	loadComponents : function(combo) {
		var selectedCompType = combo.getValue();
		var addMetricsObj = this.getWidgetOptionsWindow();
		
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		if (selectedCompType != "-1") {
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			var paramsForRc = 'C=true&F=getComponentsJSONForType&P0={' + selectedCompType + '}&calljson=true';
			var widgetID = addMetricsObj.widgetID;
			var widgetType = '';
			if (widgetID != null && widgetID.indexOf("_") > 0)
				widgetType = widgetID.substr(0, widgetID.indexOf("_"));

			if(widgetType == 'BarChart' || widgetType == 'table' || widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType == 'TrendGraph' || widgetType == 'CombinedTimelineChart' || widgetType == 'combinationChart' || widgetType == 'TopNAnalysis')
			{
						if(!Ext.isEmpty(addMetricsObj) && addMetricsObj.autoAssociateComponents==true)
						{
							return;
						}
			}
		/*	var showTopNOpt = '';
			if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
				var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
				showTopNOpt = showTopNOptObj[0].inputValue;
				if (showTopNOpt != null && showTopNOpt != 'yes') {
					configForm.findField('aggOptions').hide();
					configForm.findField('showAggOpt').hide();
					configForm.findField('descriptorCombo').show();
					Ext.getCmp('descExpandSelector').show();
					Ext.getCmp('descriptorComboLbl').show();
					Ext.getCmp('descriptorSearchTextBox').show();
				}
			} else if (widgetType != null && (widgetType == 'table' || widgetType == 'piChart')) {
				configForm.findField('aggOptions').hide();
				configForm.findField('showAggOpt').hide();
				configForm.findField('descriptorCombo').show();
				Ext.getCmp('descExpandSelector').show();
				Ext.getCmp('descriptorComboLbl').show();
				Ext.getCmp('descriptorSearchTextBox').show();
			}*/
			if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table' || widgetType == 'TopNAnalysis' || widgetType == 'health')) {
				if ( widgetType == 'TopNAnalysis') {
					var test = configForm.findField('testCombo').getValue();
					paramsForRc = paramsForRc + "&P1={true}&P2={" + test + "}&P3={" + profileName + "}"; // getCompsAndMeasuresForTest
				}
				else
				{
					paramsForRc = paramsForRc + "&P1={" + profileName + "}&P2={"+widgetID+"}";
				}
			} else {
				paramsForRc = paramsForRc + "&P1={" + profileName + "}";
			}
			this.callRemoteScriptingMethod(paramsForRc, 'loadComponents', '', '', true);
		} else {
			
			var compCombo = configForm.findField('componentCombo');
			var compComboStore = compCombo.getStore();
			compComboStore.removeAll();
			compComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			compCombo.setValue('-1');
			var descriptorCombo = configForm.findField('descriptorCombo');
			var descriptorComboStore = descriptorCombo.getStore();
			descriptorComboStore.removeAll();
			descriptorComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			descriptorCombo.setValue('-1');
		}

		if(widgetType != null && widgetType == 'ScatterPlot')
		{
			this.saveSelection('compType');
		}
	},
	loadMeasures : function(combo) {
		var selectedTest = combo.getValue();
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		if (selectedTest != "-1") {
			var widgetID = addMetricsObj.widgetID;
			var widgetType = '';
			if (widgetID != null && widgetID.indexOf("_") > 0)
				widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		/*	var showTopNOpt = '';
			if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
				var isStackedBarChart=false;
				if(widgetType == 'BarChart')
				{
					var stackedChartObj = configForm.findField('StackedChart').getChecked();
					var stackedChart="no";
					if(!Ext.isEmpty(stackedChartObj))
					{
						stackedChart = stackedChartObj[0].inputValue;
					}
					if(stackedChart!=null && stackedChart=="yes")
					{
						isStackedBarChart=true;
					}
				}
				if(!isStackedBarChart)
				{
					var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
					showTopNOpt = showTopNOptObj[0].inputValue;
					if (showTopNOpt != null && showTopNOpt != 'yes') {
						configForm.findField('aggOptions').hide();
						configForm.findField('showAggOpt').hide();
						configForm.findField('descriptorCombo').show();
						Ext.getCmp('descExpandSelector').show();
						Ext.getCmp('descriptorComboLbl').show();
						Ext.getCmp('descriptorSearchTextBox').show();
					}
				}
			} else if (widgetType != null && (widgetType == 'table' || widgetType == 'pieChart')) {
				configForm.findField('aggOptions').hide();
				configForm.findField('showAggOpt').hide();
				configForm.findField('descriptorCombo').show();
				Ext.getCmp('descExpandSelector').show();
				Ext.getCmp('descriptorComboLbl').show();
				Ext.getCmp('descriptorSearchTextBox').show();
			}*/
			var paramsForRc = 'C=true&P0={' + selectedTest + '}&calljson=true';
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			if (widgetType != null && widgetType=='TopNAnalysis') {
				paramsForRc = paramsForRc + "&F=getCompTypeAndMeasuresJSONForTest&P1={true}&P2={" + encodeURIComponent(profileName) + "}"; // getCompsAndMeasuresForTest
			} else {
				paramsForRc = paramsForRc + "&F=getCompTypeAndMeasuresJSONForTest&P1={false}&P2={" + encodeURIComponent(profileName) + "}&P3={"+encodeURIComponent(widgetID)+"}";
			}
			this.callRemoteScriptingMethod(paramsForRc, 'loadMeasures', '', '', true);
		} else {
			var measureCombo = configForm.findField('measureCombo');
			var measureComboStore = measureCombo.getStore();
			measureComboStore.removeAll();
			measureComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			measureCombo.setValue('-1');
		/*	var showTopNOpt = '';
			if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
				var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
				showTopNOpt = showTopNOptObj[0].inputValue;
			}*/
			var compTypeObjName = 'componentTypeCombo';
			var compObjName = 'componentCombo';
		/*	if (showTopNOpt != null && showTopNOpt == 'yes') {
				compTypeObjName = 'topNcompTypeCombo';
				compObjName = 'topNComponentCombo';
				var measureSingleCombo = configForm.findField('measureSingleCombo');
				measureSingleCombo.setValue('-1');
				var compTypeCombo = configForm.findField(compTypeObjName);
				compTypeCombo.setValue('-1');
			}*/
			var compCombo = configForm.findField(compObjName);
			var compComboStore = compCombo.getStore();
			compComboStore.removeAll();
			compComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			compCombo.setValue('-1');
			var descriptorCombo = configForm.findField('descriptorCombo');
			var descriptorComboStore = descriptorCombo.getStore();
			descriptorComboStore.removeAll();
			descriptorComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			descriptorCombo.setValue('-1');
		}
	},
	loadDescriptors : function() {
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var componentCombo = configForm.findField('componentCombo');
		var selectedComps = componentCombo.getValue();
		if (selectedComps != "-1") {
			var widgetType = '';
			var widgetID = addMetricsObj.widgetID;
			if (widgetID != null && widgetID.indexOf("_") > 0)
				widgetType = widgetID.substr(0, widgetID.indexOf("_"));
			var compType = '';
		/*	var showTopNOpt = '';
			if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table') ) {
				var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
				showTopNOpt = showTopNOptObj[0].inputValue;
			}
			if (showTopNOpt != null && showTopNOpt == 'yes') {
				compType=configForm.findField('topNcompTypeCombo').getValue();
			}
			else
			{*/
				compType=configForm.findField('componentTypeCombo').getValue();
			//}
			var test = configForm.findField('testCombo').getValue();
			var dashboardLayObj=Ext.getCmp('dashboardLayoutObj');
			var dashboardName = dashboardLayObj.profileName;
			var paramsForRc = 'C=true&F=getDescriptorsForServersJSON&P0={' + compType + '}&P1={' + selectedComps + '}&P2={' + test + '}&P3={'+encodeURIComponent(dashboardName)+'}&P4={'+encodeURIComponent(widgetID)+'}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadDescriptors', '', '', true);
		} else {
		/*	var compCombo = configForm.findField('componentCombo');
			var compComboStore = compCombo.getStore();
			compComboStore.removeAll();
			compComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			compCombo.setValue('-1');*/
			var descriptorCombo = configForm.findField('descriptorCombo');
			var descriptorComboStore = descriptorCombo.getStore();
			descriptorComboStore.removeAll();
			descriptorComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			descriptorCombo.setValue('-1');
		}
	},
	callRemoteScriptingMethod : function(paramsForRc, from, popupType, selectedValue, asyncMode) {
		var meC = this;
		var configForm = '';
		var addMetricsObj = '';
		/*if (popupType != null && popupType == 'ddPopup') {
			var ddMetricsObj = this.getDdmetrics();
			configForm = ddMetricsObj.getComponent('ddconfigForm').getForm();
		} else if (popupType != null && popupType == 'vmPopup') {
			var vmconfigObj = this.getVmAlarmsWidgetConfigPopup();
			configForm = vmconfigObj.getComponent('configForm').getForm();
		} else if (popupType != null && popupType == 'dialPopup') {
			addMetricsObj = this.getAdddialmetrics();
			configForm = addMetricsObj.getComponent('dialConfigForm').getForm();
		}
		else if (popupType != null && popupType == 'oneClickDashboardPopup') {
			addMetricsObj = this.getOneclickdashboardconfiguration();
			configForm = addMetricsObj.getComponent('oneclickdashconfigform').getForm();
		}
		else if (popupType != null && popupType == 'healthPopup') {
			addMetricsObj = this.getAddhealthwidget();
			configForm = addMetricsObj.getComponent('healthconfigForm').getForm();
		}
		else {*/
			if(popupType!=null && popupType=='filterPopup')
			{
				configForm = Ext.getCmp('configForm').getForm();
			}
			else if(popupType != null && popupType == 'uptimeDowntimePopup')
			{
				addMetricsObj = this.getWidgetOptionsWindow();
				configForm = addMetricsObj.getComponent('serverUpDownConfigForm').getForm();
			}
			else
			{
				addMetricsObj = this.getWidgetOptionsWindow();
				configForm = addMetricsObj.getComponent('configForm').getForm();
			}
		//.}
		iAjax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : asyncMode,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					if (from != null && from == 'loadMeasures') {
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						/*var showTopNOpt = '';
						if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
							var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
							showTopNOpt = showTopNOptObj[0].inputValue;
						}*/
						if (addMetricsObj.isTopNWidget) {
							var measureSingleCombo = configForm.findField('measureCombo');
							meC.setValueWithOptionInList(measureSingleCombo, jsonData['measureOpts'], '-1', measureAlertMsg);

							var compTypeCombo = configForm.findField('componentTypeCombo');
							meC.setValueWithOptionInList(compTypeCombo, jsonData['compTypeOpts'], '-1', '');
							var compCombo = configForm.findField('componentCombo');
							var compComboStore = compCombo.getStore();
							compComboStore.removeAll();
							compComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							compCombo.setValue('-1');
							var compSearchBoxObj = configForm.findField('componentSearchTextBox');
							compSearchBoxObj.componentStore = null;
							compSearchBoxObj.setValue('');
						} else {
							var compTypeCombo = configForm.findField('componentTypeCombo');
							meC.setValueWithOptionInList(compTypeCombo, jsonData['compTypeOpts'], '-1', '');
							var measureCombo = configForm.findField('measureCombo');
							meC.setValueWithMultiSelectOptionInList(measureCombo, jsonData['measureOpts'], '', '','');
							var compCombo = configForm.findField('componentCombo');
							var compComboStore = compCombo.getStore();
							compComboStore.removeAll();
							compComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							compCombo.setValue('-1');
							if (widgetType != null && widgetType != 'pieChart' && widgetType!='activityChart')
							{
								var compSearchBoxObj = configForm.findField('componentSearchTextBox');
								compSearchBoxObj.componentStore = null;
								compSearchBoxObj.setValue('');
							}							
							var descCombboxId = 'descriptorCombo';
							var descriptorCombo = configForm.findField(descCombboxId);
							var descriptorComboStore = descriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							descriptorCombo.setValue('-1');
							if (widgetType != null && (widgetType != 'pieChart' &&  widgetType != 'activityChart'))
							{
								var descriptorSearchBox = configForm.findField('descriptorSearchTextBox');
								descriptorSearchBox.descriptorStore = null;
								descriptorSearchBox.setValue('');
							}
						}
					}
					else if(from!=null && from=='loadOneClickDashboardTemplates')
					{
						var dashTemplatesList = configForm.findField('dashTemplatesList');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						var selectedDashboardTemplate=jsonData['selectedDashboardTemplate'];
						if(selectedDashboardTemplate!=null && (selectedDashboardTemplate!='' && selectedDashboardTemplate!='null'))
						{
							selectedValue=selectedDashboardTemplate;
						}
						var componentCombo=configForm.findField('oneClickComponentCombo');
						var compComboStore = componentCombo.getStore();
							compComboStore.removeAll();
							compComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							componentCombo.setValue('-1');
						meC.setValueWithOptionInList(dashTemplatesList, jsonData['templateList'], selectedValue, templateAlertMsg);
						if(selectedDashboardTemplate!=null && (selectedDashboardTemplate!='' && selectedDashboardTemplate!='null'))
						{
							dashTemplatesList.fireEvent('select', dashTemplatesList);
						}
					}
					else if(from!=null && from=='loadDescriptorsForOneClickDashboard')
					{
						var descriptorCombo = configForm.findField('oneClickDescriptorCombo');
						var descriptorListJson = jsonData['descriptorsList'];
						if (descriptorListJson != null && !Ext.isEmpty(descriptorListJson)) {
							if (descriptorListJson.length == 1 && descriptorListJson[0].valueField == '-1') {
								var descriptorComboStore = descriptorCombo.getStore();
								descriptorComboStore.removeAll();
								descriptorCombo.suspendEvents(false);
								descriptorComboStore.loadRawData(descriptorListJson);
								descriptorCombo.setValue('-1');
								descriptorCombo.resumeEvents();
							} else {
								var comboStre = descriptorCombo.getStore();
								comboStre.removeAll();
								descriptorCombo.suspendEvents(false);
								comboStre.loadRawData(descriptorListJson);
								comboStre.insert(0, {
									displayField : descriptorAlertMsg,
									valueField : 'chooseDescriptors'
								});
								descriptorCombo.setValue('chooseDescriptors');
								descriptorCombo.resumeEvents();
							}
							var selectedDescriptor = jsonData['selectedDescriptor'];
							if(!Ext.isEmpty(selectedDescriptor) && selectedDescriptor!="undefined")
							{
								descriptorCombo.setValue(selectedDescriptor);
							}
						} else {
							var descriptorCombo = configForm.findField('oneClickDescriptorCombo');
							var descriptorComboStore = descriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							descriptorCombo.setValue('-1');
						}
						descriptorCombo.show();
					}
					else if(from!=null && from=='loadCompsForOneClickDashboardTemplate')
					{
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						var selectedComp=jsonData['selectedComponent'];
						var compsSelection=jsonData['compsSelection'];
						if(selectedComp!=null && (selectedComp!='' && selectedComp!='null'))
						{
							selectedValue=selectedComp;
						}
						var componentCombo =null;
						if(compsSelection!=null && compsSelection=='multi')
						{
							var compCombo=configForm.findField('oneClickInfraElementsCombo');
							componentCombo = configForm.findField('oneClickComponentCombo');
							meC.setValueWithMultiSelectOptionInList(compCombo, jsonData['compOptsJson'], 'allServers', allServers);
							componentCombo.hide();
							compCombo.show();
						}
						else
						{
							var compCombo=configForm.findField('oneClickInfraElementsCombo');
							componentCombo = configForm.findField('oneClickComponentCombo');
							meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);
							compCombo.hide();
							componentCombo.show();
						}
						if(jsonData!=null && jsonData.hasOwnProperty('showDescriptorsCombo'))
						{
							var oneClickDescriptorCombo=configForm.findField('oneClickDescriptorCombo');
							componentCombo.loadDescriptors=true;
							var descriptorComboStore = oneClickDescriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable+"_1111",
								valueField : '-1'
							});
							oneClickDescriptorCombo.setValue('-1');
							oneClickDescriptorCombo.show();
							if (selectedValue != null && (selectedValue!='' && selectedValue!='null')) {
			                        componentCombo.fireEvent('select', componentCombo);
					        }
						}
						else
						{
							componentCombo.loadDescriptors=false;
							var oneClickDescriptorCombo=configForm.findField('oneClickDescriptorCombo');
							var descriptorComboStore = oneClickDescriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							oneClickDescriptorCombo.setValue('-1');
							oneClickDescriptorCombo.hide();
						}
					}
					else if (from != null && from == 'loadComponents') {
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
					/*	var showTopNOpt = '';
						if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
							var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
							showTopNOpt = showTopNOptObj[0].inputValue;
						}*/
						var hideAllServers=false;
					/*	if (showTopNOpt != null && showTopNOpt == 'yes') {
							var compCombo = configForm.findField('componentCombo');
							var topNCompListJson = jsonData['compOptsJson'];
							if (topNCompListJson != null && topNCompListJson[0]['valueField'] != "-1") {
								meC.setValueWithMultiSelectOptionInList(compCombo, topNCompListJson, '', '','');
							} else if (!Ext.isEmpty(topNCompListJson)) {
								compCombo.setValue(topNCompListJson[0].valueField);
								meC.setValueWithMultiSelectOptionInList(compCombo, topNCompListJson, topNCompListJson[0].valueField, '','');
							}
							var compSearchBoxObj = configForm.findField('topnComponentSearchTextBox');
							compSearchBoxObj.componentStore = null;
							compSearchBoxObj.setValue('');
						} else {*/
							var componentCombo = configForm.findField('componentCombo');
							var defaultOptMsg='';
							var defaultVal='';
							if (widgetType != null && (widgetType== 'dialChart' || widgetType== 'digitalChart' || widgetType== 'pieChart' || widgetType== 'activityChart' || widgetType== 'liveMeasuresBox' || widgetType== 'ddTable' || widgetType == 'vmAlarmsWidget'))
							{
								defaultOptMsg=componentAlertMsg;
								defaultVal='-1';
							}

							meC.setValueWithMultiSelectOptionInList(componentCombo, jsonData['compOptsJson'], defaultVal, defaultOptMsg,'');
							if(widgetType!=null && (widgetType!="pieChart" &&  widgetType != 'activityChart'))
							{
								var compSearchBoxObj = configForm.findField('componentSearchTextBox');
								if(!Ext.isEmpty(compSearchBoxObj))
								{
									compSearchBoxObj.componentStore = null;
									compSearchBoxObj.setValue('');
								}
							}
					//	}
						if (widgetType != null && (widgetType != 'ddTable' && widgetType != 'vmAlarmsWidget'))
						{
							var descCombboxId = 'descriptorCombo';
							var descriptorCombo = configForm.findField(descCombboxId);
							var descriptorComboStore = descriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							descriptorCombo.setValue('-1');					
							if (widgetType != null && (widgetType != 'pieChart' &&  widgetType != 'activityChart' && widgetType!="dialChart" && widgetType=="digitalChart" && widgetType=="liveMeasuresBox"))
							{
								var descriptorSearchBox = configForm.findField('descriptorSearchTextBox');
								descriptorSearchBox.descriptorStore = null;
								descriptorSearchBox.setValue('');
							}
						}
						if (widgetType != null && widgetType == 'ScatterPlot')
						{
							var testCombo = configForm.findField('testCombo');
							var testComboStore = testCombo.getStore();
							testComboStore.removeAll();
							testComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							testCombo.setValue('-1');
							var measuresCombo = configForm.findField('measureCombo');
							var measuresComboStore = measuresCombo.getStore();
							measuresComboStore.removeAll();
							measuresComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							measuresCombo.setValue('-1');
						}


					} else if (from != null && from == 'loadDescriptors') {
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						var descriptorCombo = configForm.findField('descriptorCombo');
						var descriptorListJson = jsonData['descriptorsList'];
						if (descriptorListJson != null && descriptorListJson[0]['valueField'] != "-1") {
							var isTopN=false;
							if (widgetType != null && (widgetType == 'table' || widgetType == 'BarChart' || widgetType=='heatMapChart' || widgetType=='pieChart' ||  widgetType == 'activityChart')) {
								var isStackedBarChart=false;
								var showTopNOpt = '';
								if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'table')) {
								/*	var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
									showTopNOpt = showTopNOptObj[0].inputValue;

									if(widgetType == 'BarChart')
									{
										var stackedChartObj = configForm.findField('StackedChart').getChecked();
										var stackedChart="no";
										if(!Ext.isEmpty(stackedChartObj))
										{
											stackedChart = stackedChartObj[0].inputValue;
										}
										if(stackedChart!=null && stackedChart=="yes")
										{
											isStackedBarChart=true;
										}
									}*/
								}

								if(isStackedBarChart)
								{
									configForm.findField('showAggOpt').hide();
									configForm.findField('aggOptions').show();
									configForm.findField('descriptorCombo').hide();
									Ext.getCmp('descExpandSelector').hide();
									Ext.getCmp('descriptorComboLbl').hide();
									Ext.getCmp('descriptorSearchTextBox').hide();
									Ext.getCmp('descriptormainCont').hide();
								}
								else
								{
									configForm.findField('descriptorCombo').show();
//									Ext.getCmp('descExpandSelector').show();
//									Ext.getCmp('descriptorComboLbl').show();
//									Ext.getCmp('descriptorSearchTextBox').show();
//									Ext.getCmp('descriptormainCont').show();
/*									if (showTopNOpt != null && showTopNOpt != 'yes') {
										var showAggAOpt = configForm.findField('showAggOpt');
										showAggAOpt.setValue({
											showAgg : 'no'
										});
										showAggAOpt.show();
									}
									else
									{
										isTopN=true;
									}*/
								}
							}
							if(widgetType!= null && widgetType=="heatMapChart")
							{
								meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, '', '','');
							}
							else
							{
								if (isTopN)
								{
									var configurationPopupJson=addMetricsObj.configPopupJson;
									if(!Ext.isEmpty(configurationPopupJson) && configurationPopupJson.hasOwnProperty('configuredDetails'))
									{
									var configuredData = configurationPopupJson['configuredDetails'];
									var selectedDescriptors=configuredData['selectedDescriptors'];
										if(selectedDescriptors!=null && (selectedDescriptors=='allDescriptors' || selectedDescriptors==''))
										{
											meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allDescriptors', allDescriptors,'');
										}
										else
										{
											if(selectedDescriptors!=null && selectedDescriptors=='AllInfos')
												selectedDescriptors='allDescriptors';

											meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, selectedDescriptors,allDescriptors,'allDescriptors');
										}
									}
									else
									{
										meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allDescriptors', allDescriptors,'');
									}
								}
								else
								{
									meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allDescriptors', allDescriptors,'');
								}
							}
						} else if (!Ext.isEmpty(descriptorListJson)) {
							descriptorCombo.setValue(descriptorListJson[0].valueField);
							meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, descriptorListJson[0].valueField, '','');

							if(widgetType == 'BarChart')
							{
								var stackedChartObj = configForm.findField('Stacked').getValue();
								var stackedChart="no";
								var isStackedBarChart=false;
								if(stackedChartObj!=null && stackedChartObj==true)
								{
									stackedChart="yes";
									isStackedBarChart=true;
								}

								if(isStackedBarChart)
								{
									configForm.findField('showAggOpt').hide();
									configForm.findField('aggOptions').show();
									configForm.findField('descriptorCombo').hide();
									Ext.getCmp('descriptorExpandSelector').hide();
									Ext.getCmp('descriptorComboLbl').hide();
									Ext.getCmp('descriptorSearchTextBox').hide();
									Ext.getCmp('descriptorMultiSelectOuterBox').hide();
								}
								else
								{
									configForm.findField('descriptorCombo').show();
									Ext.getCmp('descriptorExpandSelector').show();
									Ext.getCmp('descriptorComboLbl').show();
									Ext.getCmp('descriptorSearchTextBox').show();
									Ext.getCmp('descriptorMultiSelectOuterBox').show();
								}
							}
						}
						var descriptorSearchBox = configForm.findField('descriptorSearchTextBox');
						descriptorSearchBox.descriptorStore = null;
						descriptorSearchBox.setValue('');
					} else if (from != null && from == 'loadVmDescriptors') {

						if (popupType != null && popupType == 'healthCenterPopup') 
						{
							var descriptorCombo = configForm.findField('vmListCombo');
							var descriptorListJson = jsonData['descriptorsList'];
							if (descriptorListJson != null && descriptorListJson[0]['valueField'] != "-1" && selectedValue != null) {

								meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allVms', allVms,'');
								descriptorCombo.setValue(selectedValue);
								
								
								
							} else if (!Ext.isEmpty(descriptorListJson)) {
								descriptorCombo.setValue(descriptorListJson[0].valueField);
								meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, descriptorListJson[0].valueField, '','');
							}
						}
						else
						{

							var descriptorCombo = configForm.findField('vmListCombo');
							var descriptorListJson = jsonData['descriptorsList'];
							if (descriptorListJson != null && descriptorListJson[0]['valueField'] != "-1") {
								meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allVms', allVms,'');
							} else if (!Ext.isEmpty(descriptorListJson)) {
								descriptorCombo.setValue(descriptorListJson[0].valueField);
								meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, descriptorListJson[0].valueField, '','');
							}
						}
						
					} else if (from != null && from == 'loadComponentTypesForPie') {
						var dialCompTypeCombo = configForm.findField('dialCompTypeCombo');
						meC.setValueWithOptionInList(dialCompTypeCombo, jsonData['compTypeOpts'], '-1', '');
					} else if (from != null && from == 'loadComponentsForDial') {
						var componentCombo = configForm.findField('dialComponentCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						
						  if (widgetType != null && widgetType == 'liveMeasuresBox') { 
								var measureMultiCombo =  configForm.findField('measureMultiCombo');
								  var measureMultiComboStore =  measureMultiCombo.getStore();
								  measureMultiComboStore.removeAll();
								  measureMultiComboStore.insert(0, {
									  displayField: notApplicable,
										valueField: '-1' });
								  measureMultiCombo.setValue('-1'); }
						  else if (widgetType != null && (widgetType != 'pieChart' &&  widgetType != 'activityChart')) {
							var testCombo = configForm.findField('testCombo');
							var testComboStore = testCombo.getStore();
							testComboStore.removeAll();
							testComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							testCombo.setValue('-1');
							var measureSingleCombo = configForm.findField('measureSingleCombo');
							var measureSingleComboStore = measureSingleCombo.getStore();
							measureSingleComboStore.removeAll();
							measureSingleComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							measureSingleCombo.setValue('-1');
						}
						var dialDescriptorCombo = configForm.findField('dialDescriptorCombo');
						var dialDescriptorComboStore = dialDescriptorCombo.getStore();
						dialDescriptorComboStore.removeAll();
						dialDescriptorComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						dialDescriptorCombo.setValue('-1');
					} else if (from != null && from == 'loadDDComponents') {
						var componentCombo = configForm.findField('ddcompCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);
						var testCombo = configForm.findField('testCombo');
						var testComboStore = testCombo.getStore();
						testComboStore.removeAll();
						testComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						testCombo.setValue('-1');
						var ddMeasuresCombo = configForm.findField('ddMeasuresCombo');
						var ddMeasuresComboStore = ddMeasuresCombo.getStore();
						ddMeasuresComboStore.removeAll();
						ddMeasuresComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						ddMeasuresCombo.setValue('-1');
						var ddMeasureCols = configForm.findField('ddMeasureCols');
						var ddMeasureColsComboStore = ddMeasureCols.getStore();
						ddMeasureColsComboStore.removeAll();
						ddMeasureColsComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						ddMeasureCols.setValue('-1');
					}
					else if (from != null && from == 'loadHealthCenterComponents') {
						var componentTypeCombo = configForm.findField('healthCenterCompTypeCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}

						if (componentTypeCombo.selectedOption != null && componentTypeCombo.selectedOption == 'Servers')
						{
							var componentCombo = configForm.findField('healthCenterComponentCombo');
							meC.setValueWithMultiSelectOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, '','');

							if(selectedValue != null && selectedValue =='-1')
							{
								componentCombo.getStore().insert(0,{
									displayField:'All Components',
									valueField: 'allServers'
								});
								componentCombo.setValue('allServers');
							}
						}
						else if (componentTypeCombo.selectedOption != null && componentTypeCombo.selectedOption == 'Descriptors')
						{
							var componentCombo = configForm.findField('healthCenterCompScrollCombo');
							componentCombo.show();
							meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);
						}
						else if (componentTypeCombo.selectedOption != null && componentTypeCombo.selectedOption == 'vms')
						{
							var componentCombo = configForm.findField('healthCenterComponentCombo');
							meC.setValueWithMultiSelectOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, '','');
						}
					}
					else if (from != null && from == 'loadUptimeDowntimeInfraElements') {
						var testCombo = configForm.findField('subTypeCompCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(testCombo, jsonData['configuredDetails'], selectedValue, '');
					}
					else if (from != null && from == 'loadHealthCenterComponentsTests') {
						
						var testCombo = configForm.findField('healthCenterTestScrollCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(testCombo, jsonData['runningTestsForServer'], selectedValue, testAlertMsg);
										
					
					}
					else if (from != null && from == 'loadVmComponents') {
						var componentCombo = configForm.findField('vmcompCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);

					} else if (from != null && from == 'loadTestsForDial') {
						var testCombo = configForm.findField('testCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(testCombo, jsonData['runningTestsForServer'], selectedValue, testAlertMsg);
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						
						  if (widgetType != null && widgetType == 'liveMeasuresBox') { 
							var measureMultiCombo =  configForm.findField('measureMultiCombo');
							var measureMultiComboStore =  measureMultiCombo.getStore();
							measureMultiComboStore.removeAll();
							measureMultiComboStore.insert(0, {
								displayField: notApplicable,
							  valueField: '-1' });
							measureMultiCombo.setValue('-1');
						  }
						  else {
							var measureSingleCombo = configForm.findField('measureSingleCombo');
							var measureSingleComboStore = measureSingleCombo.getStore();
							measureSingleComboStore.removeAll();
							measureSingleComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							measureSingleCombo.setValue('-1');
						 }
						var dialDescriptorCombo = configForm.findField('dialDescriptorCombo');
						var dialDescriptorComboStore = dialDescriptorCombo.getStore();
						dialDescriptorComboStore.removeAll();
						dialDescriptorComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						dialDescriptorCombo.setValue('-1');
					} else if (from != null && from == 'loadDDTests') {
						var testCombo = configForm.findField('testCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(testCombo, jsonData['runningTestsForServer'], selectedValue, testAlertMsg);
						var ddMeasuresCombo = configForm.findField('ddMeasuresCombo');
						var ddMeasuresComboStore = ddMeasuresCombo.getStore();
						ddMeasuresComboStore.removeAll();
						ddMeasuresComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						ddMeasuresCombo.setValue('-1');
						var ddMeasureCols = configForm.findField('ddMeasureCols');
						var ddMeasureColsComboStore = ddMeasureCols.getStore();
						ddMeasureColsComboStore.removeAll();
						ddMeasureColsComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						ddMeasureCols.setValue('-1');
					} else if (from != null && from == 'loadMeasuresForDial') {
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						
						 if (widgetType != null && widgetType == 'liveMeasuresBox') { 
							 var measureMultiCombo =  configForm.findField('measureMultiCombo');
							  meC.setValueWithMultiSelectOptionInList(measureMultiCombo,jsonData['measuresOpts'],
						  selectedValue, ''); var
						  dialDescriptorCombo =
						  configForm.findField('dialDescriptorCombo');
						  var descriptorJson =
						  jsonData['descpritorList']; if
						  (descriptorJson != null &&
						  !Ext.isEmpty(descriptorJson)) { if
						  (descriptorJson.length == 1 &&
						  descriptorJson[0].valueField == '-1') {
						  var dialDescriptorComboStore =
						  dialDescriptorCombo.getStore();
						  dialDescriptorComboStore.removeAll();
						  dialDescriptorComboStore.loadRawData(descriptorJson);
						  dialDescriptorCombo.setValue('-1'); }
						  else { var comboStre =
						 dialDescriptorCombo.getStore();
						  comboStre.removeAll();
						  dialDescriptorCombo.suspendEvents(false);
						  comboStre.loadRawData(descriptorJson);
						  comboStre.insert(0, { displayField:
						  descriptorAlertMsg, valueField:
						  'chooseDescriptors' });
						  dialDescriptorCombo.setValue('chooseDescriptors');
						  dialDescriptorCombo.resumeEvents();
						//  meC.setValueWithOptionInList(dialDescriptorCombo,descriptorJson,selectedValue,descriptorAlertMsg);
						} }
						  else { 
							  var dialDescriptorCombo =  configForm.findField('dialDescriptorCombo');
						  var dialDescriptorComboStore =  dialDescriptorCombo.getStore();
						  dialDescriptorComboStore.removeAll();
						  dialDescriptorComboStore.insert(0, {
						  displayField: notApplicable,
						  valueField: '-1' });
						  dialDescriptorCombo.setValue('-1'); } }
						  else {
						 
						var measureSingleCombo = configForm.findField('measureSingleCombo');
						meC.setValueWithOptionInList(measureSingleCombo, jsonData['measureOpts'], selectedValue, measureAlertMsg);
						var dialDescriptorCombo = configForm.findField('dialDescriptorCombo');
						var dialDescriptorComboStore = dialDescriptorCombo.getStore();
						dialDescriptorComboStore.removeAll();
						dialDescriptorComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						dialDescriptorCombo.setValue('-1');
						 }
					} else if (from != null && from == 'loadDescriptorsForDial') {
						var dialDescriptorCombo = configForm.findField('dialDescriptorCombo');
						var descriptorJson = jsonData['descriptorsList'];
						if (descriptorJson != null && !Ext.isEmpty(descriptorJson)) {
							if (descriptorJson.length == 1 && descriptorJson[0].valueField == '-1') {
								var dialDescriptorComboStore = dialDescriptorCombo.getStore();
								dialDescriptorComboStore.removeAll();
								dialDescriptorComboStore.loadRawData(descriptorJson);
								dialDescriptorCombo.setValue('-1');
							} else {
								var comboStre = dialDescriptorCombo.getStore();
								comboStre.removeAll();
								dialDescriptorCombo.suspendEvents(false);
								comboStre.loadRawData(descriptorJson);
								comboStre.insert(0, {
									displayField : descriptorAlertMsg,
									valueField : 'chooseDescriptors'
								});
								dialDescriptorCombo.setValue('chooseDescriptors');
								dialDescriptorCombo.resumeEvents();
							}
						} else {
							var dialDescriptorCombo = configForm.findField('dialDescriptorCombo');
							var dialDescriptorComboStore = dialDescriptorCombo.getStore();
							dialDescriptorComboStore.removeAll();
							dialDescriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							dialDescriptorCombo.setValue('-1');
						}
					} 
					else if (from != null && from == 'loadDescriptorsForHealthCenter') {
						var healthCenterComponentComboObj = configForm.findField('healthCenterComponentCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						var descriptorJson = jsonData['descriptorsList'];
						if (descriptorJson != null && !Ext.isEmpty(descriptorJson)) {
							if (descriptorJson.length == 1 && descriptorJson[0].valueField == '-1') {

								var dialDescriptorComboStore = healthCenterComponentComboObj.getStore();
								dialDescriptorComboStore.removeAll();
								dialDescriptorComboStore.loadRawData(descriptorJson);
								healthCenterComponentComboObj.setValue('-1');
							}
							else
							{
								meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, descriptorJson, 'allDescriptors', 'All Descriptors','allDescriptors');
							}
						}
						else {
							var dialDescriptorComboStore = healthCenterComponentComboObj.getStore();
							dialDescriptorComboStore.removeAll();
							dialDescriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							healthCenterComponentComboObj.setValue('-1');
						}
					}	
					else if (from != null && from == 'loadDDMeasures') {
						var ddMeasuresCombo = configForm.findField('measureCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(ddMeasuresCombo, jsonData['ddMeasureOpts'], selectedValue, measureAlertMsg);
						var ddMeasureCols = configForm.findField('ddColumnsCombo');
						var ddMeasureColsComboStore = ddMeasureCols.getStore();
						ddMeasureColsComboStore.removeAll();
						ddMeasureColsComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						ddMeasureCols.setValue('-1');
					} else if (from != null && from == 'loadDDColumns') {
						var ddMeasureCols = configForm.findField('ddColumnsCombo');
						var ddMeasureColsComboStore = ddMeasureCols.getStore();
						meC.setValueWithMultiSelectOptionInList(ddMeasureCols, jsonData['ddColumns'], selectedValue, '');
						 var ddcolumnValue = ddMeasureCols.getValue();
						 if (ddcolumnValue!=null && ddcolumnValue == '-1' )
						 {
							ddMeasureColsComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
						 }
						 
						if (selectedValue != null && selectedValue == '') 
						{
							selectedValue = "-1";
						}
						 var summarizeDDCols = configForm.findField('summarizeDDColumnCombo');
						 var summarizeDDColsStore = summarizeDDCols.getStore();
						 meC.setValueWithOptionInList(summarizeDDCols, jsonData['ddColumns'], selectedValue, noDDColSelectedAlertMsg);

					}
					else if (from != null && from == 'loadHealthDescriptors') {
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						var descriptorCombo = configForm.findField('descriptorCombo');
						var descriptorListJson = jsonData['descriptorsList'];
						if (descriptorListJson != null && descriptorListJson[0]['valueField'] != "-1") {
							meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, 'allDescriptors', allDescriptors);
						} else if (!Ext.isEmpty(descriptorListJson)) {
							descriptorCombo.setValue(descriptorListJson[0].valueField);
							meC.setValueWithMultiSelectOptionInList(descriptorCombo, descriptorListJson, descriptorListJson[0].valueField, '');
						}
					}
					else if (from != null && from == 'loadHealthComponents') {
						var componentCombo = configForm.findField('componentCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(componentCombo, jsonData['compOptsJson'], selectedValue, componentAlertMsg);
						var testCombo = configForm.findField('testCombo');
						var testComboStore = testCombo.getStore();
						testComboStore.removeAll();
						testComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						testCombo.setValue('-1');
						var measuresCombo = configForm.findField('measureCombo');
						var measuresComboStore = measuresCombo.getStore();
						measuresComboStore.removeAll();
						measuresComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						measuresCombo.setValue('-1');
						var descriptorCombo = configForm.findField('descriptorCombo');
						var descriptorComboStore = descriptorCombo.getStore();
						descriptorComboStore.removeAll();
						descriptorComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						descriptorCombo.setValue('-1');
					} else if (from != null && from == 'loadHealthTests') {
						var testCombo = configForm.findField('testCombo');
						if (selectedValue != null && selectedValue == '') {
							selectedValue = "-1";
						}
						meC.setValueWithOptionInList(testCombo, jsonData['runningTestsForServer'], selectedValue, testAlertMsg);
						var measuresCombo = configForm.findField('measureCombo');
						var measuresComboStore = measuresCombo.getStore();
						measuresComboStore.removeAll();
						measuresComboStore.insert(0, {
							displayField : notApplicable,
							valueField : '-1'
						});
						measuresCombo.setValue('-1');

						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));
						
						if (widgetType != null && widgetType == 'ddTable') {
							var ddColumnsObj = configForm.findField('ddColumnsCombo');
							var ddColumnsObjComboStore = ddColumnsObj.getStore();
							ddColumnsObjComboStore.removeAll();
								ddColumnsObjComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							var summarizeDDColumnsObj = configForm.findField('summarizeDDColumnCombo');
							var summarizeDDObjComboStore = summarizeDDColumnsObj.getStore();
							summarizeDDObjComboStore.removeAll();
							summarizeDDObjComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							summarizeDDColumnsObj.setValue('-1');
						}
						else
						{
							var descriptorCombo = configForm.findField('descriptorCombo');
							var descriptorComboStore = descriptorCombo.getStore();
							descriptorComboStore.removeAll();
							descriptorComboStore.insert(0, {
								displayField : notApplicable,
								valueField : '-1'
							});
							descriptorCombo.setValue('-1');
						}
						if(widgetType != null && widgetType == 'ScatterPlot')
						{
							this.saveSelection('componentCombo');
						}
					}
					else if (from != null && from == 'loadHealthMeasures') {
						var widgetType = '';
						var widgetID = addMetricsObj.widgetID;
						if (widgetID != null && widgetID.indexOf("_") > 0)
							widgetType = widgetID.substr(0, widgetID.indexOf("_"));

						if(widgetType!=null && widgetType=='health')
						{
							var measuresCombo = configForm.findField('measureCombo');
							if (selectedValue != null && selectedValue == '') {
								selectedValue = "-1";
							}
							meC.setValueWithOptionInList(measuresCombo, jsonData['measuresOpts'], '', '');
							var descriptorCombo = configForm.findField('descriptorCombo');
							if (selectedValue != null && selectedValue == '') {
								selectedValue = "-1";
							}
							meC.setValueWithOptionInList(descriptorCombo, jsonData['descpritorList'], '', '');
						}
						else
						{
							var measuresCombo = configForm.findField('measureCombo');
							if (selectedValue != null && selectedValue == '') {
								selectedValue = "-1";
							}
							if(widgetType!=null && widgetType=='liveMeasuresBox')
							{
								meC.setValueWithOptionInList(measuresCombo, jsonData['measuresOpts'], '', '');
							}
							else
							{
								meC.setValueWithOptionInList(measuresCombo, jsonData['measuresOpts'], selectedValue, measureAlertMsg);
							}
							var descriptorCombo = configForm.findField('descriptorCombo');
							if (selectedValue != null && selectedValue == '') {
								selectedValue = "-1";
							}
							if(!Ext.isEmpty(jsonData['descpritorList']))
							{
								if(jsonData['descpritorList'][0].valueField=="-1")
								{
									meC.setValueWithOptionInList(descriptorCombo, jsonData['descpritorList'], selectedValue, '');
								}
								else
								{
									//meC.setValueWithOptionInList(descriptorCombo, jsonData['descpritorList'], selectedValue, descriptorAlertMsg);

									/*if (jsonData['descpritorList'].length == 1 && jsonData['descpritorList'][0].valueField == '-1') {

										meC.setValueWithOptionInList(descriptorCombo, jsonData['descpritorList'], selectedValue, descriptorAlertMsg);
									}else{*/
										
										var comboStre = descriptorCombo.getStore();
										comboStre.removeAll();
										descriptorCombo.suspendEvents(false);
										comboStre.loadRawData(jsonData['descpritorList']);
										comboStre.insert(0, {
											displayField : descriptorAlertMsg,
											valueField : 'chooseDescriptors'
										});
										descriptorCombo.setValue('chooseDescriptors');
										descriptorCombo.resumeEvents();
									//}
								}
							}
						}
						if(widgetType != null && widgetType == 'ScatterPlot')
						{
							this.saveSelection('testCombo');
						}
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function() {
			}
		});
	},
	setValueWithOptionInList : function(comboObj, list, value, defaultMsg) {
		var comboStre = comboObj.getStore();
		if(!Ext.isEmpty(comboStre))
		{
			comboStre.removeAll();
			comboObj.suspendEvents(false);
			comboStre.loadRawData(list);
			if (defaultMsg != null && defaultMsg != '') {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : '-1'
				});
				comboObj.setValue(value);
			} else {
				var valueAssigned = false;
				for ( var listCounter = 0; listCounter < list.length; listCounter++) {
					if (list[listCounter].valueField == value && value != "" && value != null) {
						comboObj.setValue(value);
						valueAssigned = true;
					}
				}
				if (!valueAssigned) {
					comboObj.setValue(list[0].valueField);
				}
			}
			comboObj.resumeEvents();
		}
	},
	setValueWithMultiSelectOptionInList : function(comboObj, list, value, defaultMsg,defaultValue) {
		var comboStre = comboObj.getStore();
		comboStre.removeAll();
		comboObj.suspendLayout = true;
		comboObj.suspendEvents(false);
		comboStre.loadRawData(list);
		if (defaultMsg != null && defaultMsg != '') {
			if ((value != null && value == 'allDescriptors') || (defaultValue!=null && defaultValue=='allDescriptors')) {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allDescriptors'
				});
			} else if (value != null && value == 'allServers') {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allServers'
				});
			} else if ((value != null && value == 'allVms') || (defaultValue!=null && defaultValue=='allVms')) {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allVms'
				});
			} else {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : '-1'
				});
			}
		}
		comboObj.setValue(value);
		comboObj.resumeEvents();
		comboObj.suspendLayout = false;
	},
	addHealthBlockConfig : function() {
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var compTypeCombo = configForm.findField('componentTypeCombo');
		var componentCombo = configForm.findField('componentCombo');
		var testCombo = configForm.findField('testCombo');
		var measureCombo = configForm.findField('measureCombo');
		var descriptorCombo = configForm.findField('descriptorCombo');
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if (widgetID != null && widgetID.indexOf("_") > 0)
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var selectedCompType = compTypeCombo.getValue();
		var displayCompType = compTypeCombo.getRawValue();
		var components = componentCombo.getValue();
		var dispComponents = componentCombo.getRawValue();
		var selectedTest = testCombo.getValue();
		var displayTest = testCombo.getRawValue();
		var measures = measureCombo.getValue();
		var selectedDesc = descriptorCombo.getValue();
		var dispDesc = descriptorCombo.getRawValue();
		var isAllDescriptors = false;
		if (selectedDesc != null && selectedDesc == 'allDescriptors') {
			isAllDescriptors = true;
		}
		if (selectedCompType != null && selectedCompType == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		else if (components != null && (components == '' || components == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		else if (selectedTest != null && selectedTest == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		else if (measures != null && (measures == '' || measures == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		else if (selectedDesc != null && selectedDesc == '') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : descriptorAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var measureComboStore = measureCombo.getStore();
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var configuredData = new Array();
		for ( var meas in measures) {
			var selectedMeas = measures[meas];
			var measRecord = measureComboStore.findRecord(measureCombo.valueField, selectedMeas, 0, false, true, true);
			var mIdx = measureComboStore.indexOf(measRecord);
			var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
			var tmp_selectedDesc=selectedDesc;
			if (isAllDescriptors) {
				var hidVal = components + ":" + selectedTest + ":" + selectedMeas + ":" + "AllInfos";
				var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
				var descriptorHidVal = components + "$" + dispComponents + "|" + measuresHidVal + "$AllInfos";
				var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
				if (getIdx == -1) {
					configuredData.push({
						component : dispComponents,
						test : displayTest,
						measure : dispMeas,
						descriptor : allDescriptors,
						measuresHidVal : measuresHidVal,
						descriptorHidVal : descriptorHidVal,
						componentsHidVal : components,
						hidVal : hidVal
					});
				} else {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : 'Your current selection has already been added',
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
			} else {
				if (dispDesc != null && (dispDesc == "+" || dispDesc == "Not Applicable")) {
					dispDesc = "-";
				}
				if (tmp_selectedDesc == "-1" || tmp_selectedDesc == "")
					tmp_selectedDesc = "+";
				var tempDesc = "+";
				if (tmp_selectedDesc != null && tmp_selectedDesc != "+" && tmp_selectedDesc.indexOf("+") == 0 && tmp_selectedDesc.length > 1) {
					tempDesc = tmp_selectedDesc.substring(1);
				}
				var hidVal = components + ":" + selectedTest + ":" + selectedMeas + ":" + tempDesc;
				var dispCompLbl = dispComponents;
				if (tmp_selectedDesc != null && (tmp_selectedDesc != '' && tmp_selectedDesc != "+")) {
					tmp_selectedDesc = tmp_selectedDesc.substr(1);
					dispCompLbl = dispCompLbl + "-" + dispDesc;
				}
				var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
				var descriptorHidVal = components + "$" + dispCompLbl + "|" + measuresHidVal + "$" + tmp_selectedDesc;
				var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
				if (getIdx == -1) {
					configuredData.push({
						component : dispComponents,
						test : displayTest,
						measure : dispMeas,
						descriptor : dispDesc,
						measuresHidVal : measuresHidVal,
						descriptorHidVal : descriptorHidVal,
						componentsHidVal : components,
						hidVal : hidVal
					});
				} else {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : 'Your current selection has already been added',
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
			}
		}
		gridStore.add(configuredData);
		gridObj.doLayout();
		var controllerSettingObj=Ext.getCmp('controllerSetting');
		if(!Ext.isEmpty(controllerSettingObj))
		{
			controllerSettingObj.setDisabled(false);
		}
		this.flashMsgBox(metricsConfiguredAlert);
	},
	updateHealthBlockConfig : function()
	{
		return updateHealthBlockConfig(false,'');
	},
	updateHealthBlockConfig : function(isWidgetPreviewMode,previewImageContainer) {
		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var addMetricsForm = addMetricsObj.getComponent('configForm').getForm();
		var widgetID = addMetricsObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var paramsForSave ='';
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var configuredMeasures = '';
		var configuredComponents = '';
		var configuredDescriptors = '';
		var componentDisplayNames = '';
		var descriptorDisplayNames = '';
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var descItmArr=[];
		var compItmArr=[];
		for ( var i = 0; i < gridRecordCount; i++) {
			var measuresHidVal = gridObj.getStore().getAt(i).get('measuresHidVal');
			var componentsHidVal = gridObj.getStore().getAt(i).get('componentsHidVal');
			var descriptorHidVal = gridObj.getStore().getAt(i).get('descriptorHidVal');
			var componentDisplayName = gridObj.getStore().getAt(i).get('componentDisplayName');
			var descriptorDisplayName = gridObj.getStore().getAt(i).get('descriptorDisplayName');
			if (configuredMeasures.indexOf(measuresHidVal) == -1) {
				configuredMeasures = configuredMeasures + "," + measuresHidVal;
			}
			if (configuredComponents.indexOf(componentsHidVal) == -1) {
				configuredComponents = configuredComponents + "," + componentsHidVal;
			}
			configuredDescriptors = configuredDescriptors + "," + descriptorHidVal;
			if(!Ext.isEmpty(componentDisplayName))
			{
				if(compItmArr!=null && !Ext.Array.contains(compItmArr,componentDisplayName))
				{
					componentDisplayNames=componentDisplayNames+","+componentDisplayName;
					compItmArr.push(componentDisplayName);
				}
			}
			if(!Ext.isEmpty(descriptorDisplayName))
			{
				if(descItmArr!=null && !Ext.Array.contains(descItmArr,descriptorDisplayName))
				{
					descriptorDisplayNames=descriptorDisplayNames+","+descriptorDisplayName;
					descItmArr.push(descriptorDisplayName);
				}
			}
		}
		if (configuredMeasures != null && configuredMeasures.indexOf(",") == 0) {
			configuredMeasures = configuredMeasures.substring(1);
		}
		if (configuredComponents != null && configuredComponents.indexOf(",") == 0) {
			configuredComponents = configuredComponents.substring(1);
		}
		if (configuredDescriptors != null && configuredDescriptors.indexOf(",") == 0) {
			configuredDescriptors = configuredDescriptors.substring(1);
		}
		if (componentDisplayNames != null && componentDisplayNames.indexOf(",") == 0) {
			componentDisplayNames=componentDisplayNames.substring(1);
		}
		if (descriptorDisplayNames != null && descriptorDisplayNames.indexOf(",") == 0) {
			descriptorDisplayNames=descriptorDisplayNames.substring(1);
		}
		
		configuredMeasures = filterEncode(configuredMeasures);
		
		configuredDescriptors = filterEncode(configuredDescriptors);
		paramsForSave = "action=saveConfig&profileName="+encodeURIComponent(tmpProfNam)+"&blockId="+widgetID+"&configuredMeasures="+encodeURIComponent(configuredMeasures)+"&configuredComponents="+encodeURIComponent(configuredComponents) + "&configuredDescriptors="+encodeURIComponent(configuredDescriptors);
		if(!Ext.isEmpty(componentDisplayNames))
		{
			paramsForSave=paramsForSave+"&ComponentDisplayNames="+encodeURIComponent(componentDisplayNames);
		}
		if(!Ext.isEmpty(descriptorDisplayNames))
		{
			descriptorDisplayNames= filterEncode(descriptorDisplayNames);
			paramsForSave=paramsForSave+"&descriptorDisplayNames="+encodeURIComponent(descriptorDisplayNames);
		}

		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridStackObj=null;
		delete gridStackObj;

		var descriptorVal = addMetricsForm.findField('excludeDesc').getValue();
		if(descriptorVal!=null && (descriptorVal.indexOf('*')==0 && descriptorVal.length==1))
		{
			Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : descriptorExcludeAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
						});
						return;
		}
		descriptorVal = filterEncode(descriptorVal);
		paramsForSave = paramsForSave+'&excludedDescriptors='+encodeURIComponent(descriptorVal); 

		var configPanl = null;
		if(isWidgetPreviewMode)
		{
			configPanl = previewContObj;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		else
		{
			configPanl=Ext.getCmp(widgetID);
			addMetricsObj.close();
		}
		//configPanl.setLoading(true, true);
		Ext.Ajax
		.request({
			url : '/final/servlet/com.eg.egMyDashboardController',
			method : 'POST',
			params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					meC.getPortlet().setRefresh(configPanl);
					var jsonData = Ext.decode(jsonText);
					configPanl.isConfigured=true;
					myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, widgetID);
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				if (response.timedout) {
					if (widgetType != null && widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType == 'TrendGraph') {
						configPanl
								.update('<table width="100%" height="'
										+ (configPanl.getHeight() - 20)
										+ '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
										+ requestTimeoutMsg + '</div></div></td></tr></table>');
					} else {
						configPanl.removeAll();
						configPanl
								.add({
									xtype : 'panel',
									html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
											+ (configPanl.getHeight() - 20)
											+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
											+ requestTimeoutMsg + '</div></td></tr></table></div>'
								});
					}
					configPanl.setLoading(false);
					configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	/*  -----  For End Editing the Widget Configuration Window  ----- */

	/*  ----- For   Showing  the Widget Configuration Window  ----- */

	showWidgetOptionsWindow : function(btn,portLetObjId,action,isKpi,count,defaultDataArray,kpiBlckId,totalKpiCount,isKPIExternalDataSourceWidget)
	{
		var widgetOptionsWindow=this.getWidgetOptionsWindow();
		if (Ext.isEmpty(widgetOptionsWindow))
		{
			var blkId=portLetObjId;
			var blkType=blkId;
			if(!Ext.isEmpty(blkId) && blkId.lastIndexOf("_")>0)
			{
				blkType=blkId.substring(0,blkId.lastIndexOf("_"));
			}
			var isExternalDataSourceWidget = false;
			var widgetObj=Ext.getCmp(blkId);
			if(!Ext.isEmpty(widgetObj))
			{
				isExternalDataSourceWidget=widgetObj.isExternalDataSourceWidget;
			}
			var autoAssComps=false;
			if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('autoAssociateComponents'))
			{
				var autoAssociateComponentsStr=publicJson['myDashboardConfigDetails']['autoAssociateComponents'];

				if(autoAssociateComponentsStr!=null && autoAssociateComponentsStr.toLowerCase()=='yes')
				{
					autoAssComps=true;
				}
			}
			//widgetOptionsWindow = Ext.widget('widgetOptionsWindow' , { widgetID : portLetObjId , widgetType : blkType , action : action , isExternalDataSourceWidget : isExternalDataSourceWidget , autoAssociateComponents : autoAssComps });

			if(isKpi)
			{
				isExternalDataSourceWidget=isKPIExternalDataSourceWidget;

			}	  

			widgetOptionsWindow = Ext.widget('widgetOptionsWindow' , { widgetID : portLetObjId , widgetType : blkType , action : action , isExternalDataSourceWidget : isExternalDataSourceWidget,isKpi: isKpi,Kpicount: count,KpiDataArray : defaultDataArray ,kpiBlckId : kpiBlckId, totalKpiCount:totalKpiCount, autoAssociateComponents : autoAssComps});

			widgetOptionsWindow.show();
			widgetOptionsWindow.loadSampleSnippet();
		}
		widgetOptionsWindow=null;
		delete widgetOptionsWindow;
	},
	flashMsgBox:function(msg){
	Ext.create('Ext.window.Window', {
				floating:true,
				plain:true,
				ui:'flash-msg',
				resizable:false,
				frame:false,
				header:false,
				border:false,
				closeAction:'destroy',
				bodyPadding:10,
				html:'<div style="margin-top:10px;">'+msg+'</div>',
				//width: 159,
			  height:53,
			listeners:{
				show:function(win){
					win.getEl().setOpacity(0);
					win.getEl().fadeIn({duration: 1000,callback:function(){
						Ext.defer(function(){
							win.hide();
						},5000)
					}});
					  win.hide();
				},
				hide : function(win) {
                    win.getEl().fadeOut({duration: 1000, callback: function() {
                        win.close();
                    }});
            }
			}
			}).show();
	},
	addBlockConfig : function() {
		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();		
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if (widgetID != null && widgetID.indexOf("_") > 0)
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		var isTopNTable = false;
	/*	if (widgetType != null && widgetType == 'table') {
			var showTopNOptObj = configForm.findField('showTopNOpt').getChecked();
			showTopNOpt = showTopNOptObj[0].inputValue;
			if (showTopNOpt != null && showTopNOpt == 'yes') {
				this.addTopNMetrics();
				isTopNTable=true;
			}
		}*/
		if (widgetType != null && widgetType == 'heatMapChart')
		{
			var gridObj = this.getComparisontable();			
			var gridStore = gridObj.getStore();
			var recCount = gridStore.getCount();			
			if(recCount!=null && recCount>=5)
			{
				Ext.Msg.show({
					title: 'My Dashboard',
					msg: 'Adding more metrics with a heat map will make the map cluttered. Do you want to add more?',
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function (buttonId) {						
						if (buttonId == "yes") 
						{							
							meC.addConfig(widgetType,isTopNTable);					
						}
						else
						{
							return;
						}
					}
				});
			}
			else
			{
				meC.addConfig(widgetType,isTopNTable);
			}
		}
/*		else if(widgetType != null && widgetType=='health')
		{
			meC.addHealthBlockConfig();
		}*/
		else if(widgetType != null)
		{
			meC.addConfig(widgetType,isTopNTable);
		}
	},
	addConfig: function()
	{
		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var measureCombo = configForm.findField('measureCombo');
		var componentCombo = configForm.findField('componentCombo');
		var descCombboxId = 'descriptorCombo';
		var descriptorCombo = configForm.findField(descCombboxId);
		var testCombo = configForm.findField('testCombo');
		var compTypeCombo = configForm.findField('componentTypeCombo');
		var selectedTest = testCombo.getValue();
		var displayTest = testCombo.getRawValue();
		var selectedCompType = compTypeCombo.getValue();
		var displayCompType = compTypeCombo.getRawValue();
		var measures = measureCombo.getValue();					
		var components = componentCombo.getValue();
		var descriptors = descriptorCombo.getValue();
		var widgetID = addMetricsObj.widgetID;
		var widgetType = '';
		if (widgetID != null && widgetID.indexOf("_") > 0)
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));

		var isTopNTable = false;
		var isAggregationAllowedForBlock = false;
		var isAggregateMeasureApplicable = false;
		var aggFuncDisp = '';
		var aggFunc = '';
		var showAggOpt = '';
		var autoCompAssociationEnabled=false;
		var showCompAutoAssociatioOption=false;
		if(widgetType == 'BarChart' || widgetType == 'table' || widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType == 'TrendGraph' || widgetType == 'CombinedTimelineChart' || widgetType == 'combinationChart' || widgetType == 'TopNAnalysis')
		{
			showCompAutoAssociatioOption=true;
			autoCompAssociationEnabled=addMetricsObj.autoAssociateComponents;
		}
		if(autoCompAssociationEnabled)
		{
			if(!Ext.isEmpty(componentCombo))
			{
				componentCombo.AutoAssociateServersEnabled=true;
				components="allServers";
				descriptors="allDescriptors";
			}
		}
	/*	var autoAssServChkBoxObj=Ext.getCmp('autoAssServers');
		if(!Ext.isEmpty(autoAssServChkBoxObj))
		{
			var stValObj=autoAssServChkBoxObj.getValue();
			var autoAssociateServers='';
			if(!Ext.isEmpty(stValObj) && stValObj.hasOwnProperty('autoAssServs'))
			{
				autoAssociateServers=stValObj.autoAssServs;
			}
			if(autoAssociateServers!=null && autoAssociateServers=='yes')
			{
				if(!Ext.isEmpty(componentCombo))
				{
					componentCombo.AutoAssociateServersEnabled=true;
					components="allServers";
					descriptors="allDescriptors";
				}
			}
			else
			{
				//if(componentCombo.AutoAssociateServersEnabled)
				//{
				//	Ext.Msg.show({
				//		title : myDashboardAlertLbl,
				//		msg : screenLabelsObj['autoAssociateCompsErrMsg'],
				//		buttons : Ext.MessageBox.OK,
				//		icon : 'iconExclamation'
				//	});
				//	return;
				//}
			}
		}*/
		
		if (widgetType != null && (widgetType == 'table' || widgetType == 'BarChart' || widgetType=='heatMapChart' || widgetType=='pieChart' || widgetType=='activityChart')) {
			isAggregationAllowedForBlock = true;
			var isCheckAggregateOption=true;
			var isStackedBarChart=false;
			if(widgetType == 'BarChart')
			{
				var stackedChart="no";
				var stackedChart = configForm.findField('Stacked').getValue();
				if(stackedChart!=null && stackedChart)
				{
					showAggOpt = 'Yes';
					aggFuncDisp = configForm.findField('aggOptions').getRawValue();
					aggFunc = configForm.findField('aggOptions').getValue();
					isAggregateMeasureApplicable = true;
					isCheckAggregateOption=false;
					isStackedBarChart=true;
				}
			}
			if(isCheckAggregateOption)
			{
				var radioBtnObj = configForm.findField('showAggOpt');
				if (!radioBtnObj.isHidden()) {
					var showAggOpt = radioBtnObj.getValue();
					if (showAggOpt == true) {
						showAggOpt = 'Yes';
						aggFuncDisp = configForm.findField('aggOptions').getRawValue();
						aggFunc = configForm.findField('aggOptions').getValue();
						isAggregateMeasureApplicable = true;
					} else {
						showAggOpt = 'No';
						aggFuncDisp = '-';
						aggFunc = '';
					}
				} else {
					showAggOpt = 'No';
					aggFuncDisp = '-';
					aggFunc = '';
				}
			}
		}
		var isAllDescriptors = false;
		if (descriptors != null && descriptors == 'allDescriptors') {
			isAllDescriptors = true;
		}
		if (selectedTest != null && selectedTest == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (measures != null && (measures == '' || measures == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (selectedCompType != null && selectedCompType == '-1') {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!autoCompAssociationEnabled && (components != null && (components == '' || components == '-1'))) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		} else if (!isStackedBarChart && (descriptors != null && descriptors == '') && (showAggOpt!=null && showAggOpt!="Yes")) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : descriptorAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}			

		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();

		if (widgetType != null && widgetType == 'heatMapChart')
		{
			var recordCount = measures.length;
			if(gridStore.getCount()==0 && recordCount>=6)
			{
				Ext.Msg.show({
					title: 'My Dashboard',
					msg: 'Adding more metrics with a heat map will make the map cluttered.Do you want to add more?',
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function (buttonId) {						
						if (buttonId == "yes") 
						{	
							meC.addRecordsToGrid(isTopNTable,isAggregationAllowedForBlock,isAggregateMeasureApplicable,aggFuncDisp,aggFunc,showAggOpt,widgetType);
						}
						else
						{
							return;
						}
					}
				});
			}
			else
			{
				meC.addRecordsToGrid(isTopNTable,isAggregationAllowedForBlock,isAggregateMeasureApplicable,aggFuncDisp,aggFunc,showAggOpt,widgetType);
			}
		}
		else
		{
			meC.addRecordsToGrid(isTopNTable,isAggregationAllowedForBlock,isAggregateMeasureApplicable,aggFuncDisp,aggFunc,showAggOpt,widgetType);
		}
		
	},
	addRecordsToGrid: function(isTopNTable,isAggregationAllowedForBlock,isAggregateMeasureApplicable,aggFuncDisp,aggFunc,showAggOpt,widgetType)
	{
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var measureCombo = configForm.findField('measureCombo');
		var componentCombo = configForm.findField('componentCombo');
		var descCombboxId = 'descriptorCombo';
		if (!isTopNTable) {
			var descriptorCombo = configForm.findField(descCombboxId);
			var testCombo = configForm.findField('testCombo');
			var compTypeCombo = configForm.findField('componentTypeCombo');
			var selectedTest = testCombo.getValue();
			var displayTest = testCombo.getRawValue();
			var selectedCompType = compTypeCombo.getValue();
			var displayCompType = compTypeCombo.getRawValue();
			var measures = measureCombo.getValue();					
			var components = componentCombo.getValue();
			var descriptors = descriptorCombo.getValue();
			var isAllDescriptors = false;
			if (descriptors != null && descriptors == 'allDescriptors') {
				isAllDescriptors = true;
			}
			var descriptorComboStore = descriptorCombo.getStore();
			var measureComboStore = measureCombo.getStore();
			var componentComboStore = componentCombo.getStore();
			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var configuredData = [];
			if(componentCombo!=null && (componentCombo.hasOwnProperty('AutoAssociateServersEnabled') && componentCombo.AutoAssociateServersEnabled==true))
			{
				components=[];
				components.push(selectedCompType+":allServers");
				/*var compRecord = componentComboStore.findRecord(componentCombo.valueField, components, 0, false, true, true);
				var cIdx = componentComboStore.indexOf(compRecord);

				if(cIdx==-1)
				{
					componentComboStore.insert(0, {
						displayField : 'All Servers',
						valueField : 'allServers',
						editedFieldName : 'All Servers'
					});
				}*/
				if(!isAggregateMeasureApplicable)
				{
				//	if(!Ext.isEmpty(descriptors) && descriptors!="-1")
					{
						descriptors="allDescriptors";
						isAllDescriptors=true;
					}
				}
			}
			if (widgetType != null && (widgetType != 'pieChart' && widgetType != 'activityChart'))
			{
				for ( var comp in components) 
				{
					var selectedComp = '';
					selectedComp = components[comp];
					var compRecord = componentComboStore.findRecord(componentCombo.valueField, selectedComp, 0, false, true, true);
					var cIdx = componentComboStore.indexOf(compRecord);
					var dispComp = '';
					if(selectedComp!=null && selectedComp.indexOf(':allServers')>-1)
					{
						dispComp=displayCompType+" All Components";
					}
					else
					{
						dispComp=componentComboStore.getAt(cIdx).get('editedFieldName');
					}
					for ( var meas in measures) {
						var selectedMeas = measures[meas];
						var measRecord = measureComboStore.findRecord(measureCombo.valueField, selectedMeas, 0, false, true, true);
						var mIdx = measureComboStore.indexOf(measRecord);
						var dispMeas = measureComboStore.getAt(mIdx).get('editedFieldName');
						if (isAggregationAllowedForBlock) {
							if (isAggregateMeasureApplicable) {
								var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + "|HASH|" + aggFunc + ":-";
								var measuresHidVal = dispMeas + " (" + aggFuncDisp + ")$" + selectedTest + ":" + selectedMeas + "|HASH|" + aggFunc;
								var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$-";
								dispMeas = dispMeas;
								var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
								if (getIdx == -1) {
									configuredData.push({
										component : dispComp,
										test : displayTest,
										measure : dispMeas,
										descriptor : '-',
										measuresHidVal : measuresHidVal,
										descriptorHidVal : descriptorHidVal,
										componentsHidVal : selectedComp,
										isAggregationEnabled : showAggOpt,
										aggFunction : aggFuncDisp,
										hidVal : hidVal,
										chartType : 'line'
									});
								} else {
									Ext.Msg.show({
										title : myDashboardAlertLbl,
										msg : 'Your current selection has already been added',
										buttons : Ext.MessageBox.OK,
										icon : 'iconInformation'
									});
									return;
								}
							} else {
								if (isAllDescriptors) {
									var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + "AllInfos";
									var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
									var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$AllInfos";
									var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
									if (getIdx == -1) {
										configuredData.push({
											component : dispComp,
											test : displayTest,
											measure : dispMeas,
											descriptor : allDescriptors,
											measuresHidVal : measuresHidVal,
											descriptorHidVal : descriptorHidVal,
											componentsHidVal : selectedComp,
											isAggregationEnabled : showAggOpt,
											aggFunction : aggFuncDisp,
											hidVal : hidVal,
											chartType : 'line'
										});
									} else {
										Ext.Msg.show({
											title : myDashboardAlertLbl,
											msg : 'Your current selection has already been added',
											buttons : Ext.MessageBox.OK,
											icon : 'iconExclamation'
										});
										return;
									}
								} else {
									for ( var desc in descriptors) {
										var selectedDesc = descriptors[desc];
										var descRecord = descriptorComboStore.findRecord(descriptorCombo.valueField, selectedDesc, 0, false, true, true);
										var dIdx = descriptorComboStore.indexOf(descRecord);
										var dispDesc = descriptorComboStore.getAt(dIdx).get('editedFieldName');
										if (dispDesc != null && (dispDesc == "+" || dispDesc == "Not Applicable" || dispDesc == "")) {
											dispDesc = "-";
										}
										if (selectedDesc == "-1" || selectedDesc == "")
											selectedDesc = "+";
										var tempDesc = "+";
										if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
											tempDesc = selectedDesc.substring(1);
										}
										var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + tempDesc;
										var dispCompLbl = dispComp;
										if (selectedDesc != null && (selectedDesc != '' && selectedDesc != "+")) {
											selectedDesc = selectedDesc.substr(1);
											dispCompLbl = dispCompLbl + "!HYPEN!" + dispDesc;
										}
										var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
										var descriptorHidVal = selectedComp + "$" + dispCompLbl + "|" + measuresHidVal + "$" + selectedDesc;
										var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
										if (getIdx == -1) {
											configuredData.push({
												component : dispComp,
												test : displayTest,
												measure : dispMeas,
												descriptor : dispDesc,
												measuresHidVal : measuresHidVal,
												descriptorHidVal : descriptorHidVal,
												componentsHidVal : selectedComp,
												isAggregationEnabled : showAggOpt,
												aggFunction : aggFuncDisp,
												hidVal : hidVal,
												chartType : 'line'
											});
										} else {
											Ext.Msg.show({
												title : myDashboardAlertLbl,
												msg : 'Your current selection has already been added',
												buttons : Ext.MessageBox.OK,
												icon : 'iconExclamation'
											});
											return;
										}
									}
								}
							}
						} else {
							if (isAllDescriptors) {
								var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + "AllInfos";
								var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
								var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$AllInfos";
								var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
								if (getIdx == -1) {
									configuredData.push({
										component : dispComp,
										test : displayTest,
										measure : dispMeas,
										descriptor : allDescriptors,
										measuresHidVal : measuresHidVal,
										descriptorHidVal : descriptorHidVal,
										componentsHidVal : selectedComp,
										hidVal : hidVal,
										chartType : 'line'
									});
								} else {
									Ext.Msg.show({
										title : myDashboardAlertLbl,
										msg : 'Your current selection has already been added',
										buttons : Ext.MessageBox.OK,
										icon : 'iconExclamation'
									});
									return;
								}
							} else {
								for ( var desc in descriptors) {
									var selectedDesc = descriptors[desc];
									var descRecord = descriptorComboStore.findRecord(descriptorCombo.valueField, selectedDesc, 0, false, true, true);
									var dIdx = descriptorComboStore.indexOf(descRecord);
									var dispDesc = descriptorComboStore.getAt(dIdx).get('editedFieldName');
									if (dispDesc != null && (dispDesc == "+" || dispDesc == "Not Applicable" || dispDesc=="")) {
										dispDesc = "-";
									}
									if (selectedDesc == "-1" || selectedDesc == "")
									{
										selectedDesc = "+";
									}
									var tempDesc = "+";
									if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
										tempDesc = selectedDesc.substring(1);
									}
									var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + tempDesc;
									var dispCompLbl = dispComp;
									if (selectedDesc != null && (selectedDesc != '' && selectedDesc != "+")) {
										selectedDesc = selectedDesc.substr(1);
										dispCompLbl = dispCompLbl + "!HYPEN!" + dispDesc;
									}
									var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
									var descriptorHidVal = selectedComp + "$" + dispCompLbl + "|" + measuresHidVal + "$" + selectedDesc;
									var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
									if (getIdx == -1) {
										configuredData.push({
											component : dispComp,
											test : displayTest,
											measure : dispMeas,
											descriptor : dispDesc,
											measuresHidVal : measuresHidVal,
											descriptorHidVal : descriptorHidVal,
											componentsHidVal : selectedComp,
											hidVal : hidVal,
											chartType : 'line'
										});
									} else {
										Ext.Msg.show({
											title : myDashboardAlertLbl,
											msg : 'Your current selection has already been added',
											buttons : Ext.MessageBox.OK,
											icon : 'iconExclamation'
										});
										return;
									}
								}
							}
						}
					}
				}
			}
			else
			{	
				selectedComp = components;
				var compRecord = componentComboStore.findRecord(componentCombo.valueField, selectedComp, 0, false, true, true);
				var cIdx = componentComboStore.indexOf(compRecord);
				var dispComp = componentComboStore.getAt(cIdx).get('displayField');
				for ( var meas in measures) {
					var selectedMeas = measures[meas];
					var measRecord = measureComboStore.findRecord(measureCombo.valueField, selectedMeas, 0, false, true, true);
					var mIdx = measureComboStore.indexOf(measRecord);
					var dispMeas = measureComboStore.getAt(mIdx).get('editedFieldName');
					if (isAggregationAllowedForBlock) {
						if (isAggregateMeasureApplicable) {
							var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + "|HASH|" + aggFunc + ":-";
							var measuresHidVal = dispMeas + " (" + aggFuncDisp + ")$" + selectedTest + ":" + selectedMeas + "|HASH|" + aggFunc;
							var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$-";
							dispMeas = dispMeas;
							var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
							if (getIdx == -1) {
								configuredData.push({
									component : dispComp,
									test : displayTest,
									measure : dispMeas,
									descriptor : '-',
									measuresHidVal : measuresHidVal,
									descriptorHidVal : descriptorHidVal,
									componentsHidVal : selectedComp,
									isAggregationEnabled : showAggOpt,
									aggFunction : aggFuncDisp,
									hidVal : hidVal,
									chartType : 'line'
								});
							} else {
								Ext.Msg.show({
									title : myDashboardAlertLbl,
									msg : 'Your current selection has already been added',
									buttons : Ext.MessageBox.OK,
									icon : 'iconExclamation'
								});
								return;
							}
						} else {
							if (isAllDescriptors) {
								var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + "AllInfos";
								var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
								var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$AllInfos";
								var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
								if (getIdx == -1) {
									configuredData.push({
										component : dispComp,
										test : displayTest,
										measure : dispMeas,
										descriptor : allDescriptors,
										measuresHidVal : measuresHidVal,
										descriptorHidVal : descriptorHidVal,
										componentsHidVal : selectedComp,
										isAggregationEnabled : showAggOpt,
										aggFunction : aggFuncDisp,
										hidVal : hidVal,
										chartType : 'line'
									});
								} else {
									Ext.Msg.show({
										title : myDashboardAlertLbl,
										msg : 'Your current selection has already been added',
										buttons : Ext.MessageBox.OK,
										icon : 'iconExclamation'
									});
									return;
								}
							} else {
								for ( var desc in descriptors) {
									var selectedDesc = descriptors[desc];
									var descRecord = descriptorComboStore.findRecord(descriptorCombo.valueField, selectedDesc, 0, false, true, true);
									var dIdx = descriptorComboStore.indexOf(descRecord);
									var dispDesc = descriptorComboStore.getAt(dIdx).get('editedFieldName');
									if (dispDesc != null && (dispDesc == "+" || dispDesc == "Not Applicable" || dispDesc == "")) {
										dispDesc = "-";
									}
									if (selectedDesc == "-1" || selectedDesc == "")
										selectedDesc = "+";
									var tempDesc = "+";
									if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
										tempDesc = selectedDesc.substring(1);
									}
									var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + tempDesc;
									var dispCompLbl = dispComp;
									if (selectedDesc != null && (selectedDesc != '' && selectedDesc != "+")) {
										selectedDesc = selectedDesc.substr(1);
										dispCompLbl = dispCompLbl + "!HYPEN!" + dispDesc;
									}
									var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
									var descriptorHidVal = selectedComp + "$" + dispCompLbl + "|" + measuresHidVal + "$" + selectedDesc;
									var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
									if (getIdx == -1) {
										configuredData.push({
											component : dispComp,
											test : displayTest,
											measure : dispMeas,
											descriptor : dispDesc,
											measuresHidVal : measuresHidVal,
											descriptorHidVal : descriptorHidVal,
											componentsHidVal : selectedComp,
											isAggregationEnabled : showAggOpt,
											aggFunction : aggFuncDisp,
											hidVal : hidVal,
											chartType : 'line'
										});
									} else {
										Ext.Msg.show({
											title : myDashboardAlertLbl,
											msg : 'Your current selection has already been added',
											buttons : Ext.MessageBox.OK,
											icon : 'iconExclamation'
										});
										return;
									}
								}
							}
						}
					} else {
						if (isAllDescriptors) {
							var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + "AllInfos";
							var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
							var descriptorHidVal = selectedComp + "$" + dispComp + "|" + measuresHidVal + "$AllInfos";
							var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
							if (getIdx == -1) {
								configuredData.push({
									component : dispComp,
									test : displayTest,
									measure : dispMeas,
									descriptor : allDescriptors,
									measuresHidVal : measuresHidVal,
									descriptorHidVal : descriptorHidVal,
									componentsHidVal : selectedComp,
									hidVal : hidVal,
									chartType : 'line'
								});
							} else {
								Ext.Msg.show({
									title : myDashboardAlertLbl,
									msg : 'Your current selection has already been added',
									buttons : Ext.MessageBox.OK,
									icon : 'iconExclamation'
								});
								return;
							}
						} else {
							for ( var desc in descriptors) {
								var selectedDesc = descriptors[desc];
								var descRecord = descriptorComboStore.findRecord(descriptorCombo.valueField, selectedDesc, 0, false, true, true);
								var dIdx = descriptorComboStore.indexOf(descRecord);
								var dispDesc = descriptorComboStore.getAt(dIdx).get('editedFieldName');
								if (dispDesc != null && (dispDesc == "+" || dispDesc == "Not Applicable" || dispDesc == "")) {
									dispDesc = "-";
								}
								if (selectedDesc == "-1" || selectedDesc == "")
									selectedDesc = "+";
								var tempDesc = "+";
								if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
									tempDesc = selectedDesc.substring(1);
								}
								var hidVal = selectedComp + ":" + selectedTest + ":" + selectedMeas + ":" + tempDesc;
								var dispCompLbl = dispComp;
								if (selectedDesc != null && (selectedDesc != '' && selectedDesc != "+")) {
									selectedDesc = selectedDesc.substr(1);
									dispCompLbl = dispCompLbl + "!HYPEN!" + dispDesc;
								}
								var measuresHidVal = dispMeas + "$" + selectedTest + ":" + selectedMeas;
								var descriptorHidVal = selectedComp + "$" + dispCompLbl + "|" + measuresHidVal + "$" + selectedDesc;
								var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
								if (getIdx == -1) {
									configuredData.push({
										component : dispComp,
										test : displayTest,
										measure : dispMeas,
										descriptor : dispDesc,
										measuresHidVal : measuresHidVal,
										descriptorHidVal : descriptorHidVal,
										componentsHidVal : selectedComp,
										hidVal : hidVal,
										chartType : 'line'
									});
								} else {
									Ext.Msg.show({
										title : myDashboardAlertLbl,
										msg : 'Your current selection has already been added',
										buttons : Ext.MessageBox.OK,
										icon : 'iconExclamation'
									});
									return;
								}
							}
						}
					}
				}			
			}			
			gridStore.add(configuredData);
			gridObj.doLayout();
			var controllerSettingObj=Ext.getCmp('controllerSetting');
			if(!Ext.isEmpty(controllerSettingObj))
			{
				controllerSettingObj.setDisabled(false);
			}
			this.flashMsgBox(metricsConfiguredAlert);
			/*Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : metricsConfiguredAlert,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
			});*/
			if(widgetType!=null && widgetType=="table")
			{
				var sortAcrossPagesObj=configForm.findField('sortAcrossPages');
				var distinctTests=[];
				distinctTests=gridStore.collect("test",false,false);

				if(!Ext.isEmpty(distinctTests) && distinctTests.length>1)
				{
					sortAcrossPagesObj.setValue(false);
				}
				else
				{
					sortAcrossPagesObj.setValue(false);
				}
			}
		}
	},
	updateVMBlockConfig : function()
	{
		return updateVMBlockConfig(false,'');
	},
	updateVMBlockConfig : function(isWidgetPreviewMode,previewImageContainer) {
		var meC = this;
		var vmPopup = this.getWidgetOptionsWindow();
		var widgetID = vmPopup.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var gridObj = this.getGridcomparisontable();
		var configuredHiddenVal = '';

		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : addVMs,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		for ( var i = 0; i < gridRecordCount; i++) {
			var measuresHidVal = gridObj.getStore().getAt(i).get('hiddenVal');
			configuredHiddenVal = configuredHiddenVal+ measuresHidVal+ ",";
		}
		var SaveValC = configuredHiddenVal.lastIndexOf(",");
		var vmConfigValForSave = configuredHiddenVal.substring(0, SaveValC);

		vmConfigValForSave = filterEncode(vmConfigValForSave);

		var paramsForSave ="action=saveVMConfig&profileName=" + encodeURIComponent(tmpProfNam) + "&blockId=" + widgetID + "&configuredVMAlarmDetails="+ encodeURIComponent(vmConfigValForSave);
		
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridStackObj=null;
		delete gridStackObj;

		var configPanl =null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		else
		{
			configPanl=Ext.getCmp(widgetID);
			vmPopup.close();
		}
//		configPanl.setLoading(true, true);
		iAjax
				.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							configPanl.isInitialResizeCompleted=false;
							configPanl.isHighChartUpdate=false;
							configPanl.isConfigured=true;
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, widgetID);
							jsonData=null;
							delete jsonData;
						}
						jsonText=null;
						delete jsonText;
					},
					failure : function(response, opts) {
						if (response.timedout) {
								configPanl.removeAll();
								configPanl
										.add({
											xtype : 'panel',
											html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
													+ (configPanl.getHeight() - 20)
													+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
													+ requestTimeoutMsg + '</div></td></tr></table></div>'
										});
							
								configPanl.setLoading(false);
								configPanl.showLoadingMsg=false;
							configPanl.doLayout();
						}
					}
				});
	},
	getWidgetConfigurationWindowObj : function()
	{
		return this.getWidgetOptionsWindow();
	},
	getGSPanel : function()
	{
		return this.getGridstackpanel();
	},
	
	saveSelection : function(action)
	{
		var scatterTab_Obj=Ext.getCmp('scatterTab');
		var tabToSave = scatterTab_Obj.activeTab.itemId;
			
		var compTypeCombo=Ext.getCmp('componentTypeCombo');
		var componentCombo=Ext.getCmp('componentCombo');
		var testCombo=Ext.getCmp('testCombo');
		var measureCombo=Ext.getCmp('measureCombo');
		var descriptorCombo=Ext.getCmp('descriptorCombo');
	
		var selectedCompType=compTypeCombo.getValue();
		var component=componentCombo.getValue();
		var selectedTest=testCombo.getValue();
		var measure=measureCombo.getValue();
		var selectedDescriptor=descriptorCombo.getValue();
	
		if(tabToSave=='x_Axis')
		{
			var x_Axis_Obj=Ext.getCmp('x_Axis');
			var y_Axis_Obj=Ext.getCmp('y_Axis');
			scatterTab_Obj.xAxisConfigured= true;
			if(action=='compType')
			{
				scatterTab_Obj.xAxisCompType= selectedCompType;
				scatterTab_Obj.xAxisComp= '';
				scatterTab_Obj.xAxisTest= '';
				scatterTab_Obj.xAxisMeas= '';
				scatterTab_Obj.xAxisDesc= '';
				x_Axis_Obj.setIconCls('');
				x_Axis_Obj.setTitle('Configure X Axis');
			}
			else if(action=='componentCombo')
			{
				scatterTab_Obj.xAxisComp= component;
				scatterTab_Obj.xAxisTest= '';
				scatterTab_Obj.xAxisMeas= '';
				scatterTab_Obj.xAxisDesc= '';
				x_Axis_Obj.setIconCls('');
				x_Axis_Obj.setTitle('Configure X Axis');
			}
			else if(action=='testCombo')
			{
				scatterTab_Obj.xAxisTest= selectedTest;
				scatterTab_Obj.xAxisMeas= '';
				scatterTab_Obj.xAxisDesc= '';
				x_Axis_Obj.setIconCls('');
				x_Axis_Obj.setTitle('Configure X Axis');
			}
			else if(action=='measureCombo')
			{
				scatterTab_Obj.xAxisMeas= measure;
				scatterTab_Obj.xAxisDesc= selectedDescriptor;

				if(selectedDescriptor!='chooseDescriptors' && selectedDescriptor!='' && selectedDescriptor!=''&& selectedDescriptor!=null)
				{
					x_Axis_Obj.setIconCls('checkBoxTick');
					x_Axis_Obj.setTitle('X Axis Configured');
				}
			}
			else if(action=='descCombo')
			{
				scatterTab_Obj.xAxisDesc= selectedDescriptor;
				if(selectedDescriptor!='chooseDescriptors' && selectedDescriptor!='' && selectedDescriptor!='-1' && selectedDescriptor!=null)
				{
					x_Axis_Obj.setIconCls('checkBoxTick');
					x_Axis_Obj.setTitle('X Axis Configured');
				}
			}	
		}
		else if (tabToSave=='y_Axis')
		{
			var x_Axis_Obj=Ext.getCmp('x_Axis');
			var y_Axis_Obj=Ext.getCmp('y_Axis');
			scatterTab_Obj.yAxisConfigured= true;
			if(action=='compType')
			{
				scatterTab_Obj.yAxisCompType= selectedCompType;
				scatterTab_Obj.yAxisComp= '';
				scatterTab_Obj.yAxisTest= '';
				scatterTab_Obj.yAxisMeas= '';
				scatterTab_Obj.yAxisDesc= '';
				y_Axis_Obj.setIconCls('');
				y_Axis_Obj.setTitle('Configure Y Axis');
			}
			else if(action=='componentCombo')
			{
				scatterTab_Obj.yAxisComp= component;
				scatterTab_Obj.yAxisTest= '';
				scatterTab_Obj.yAxisMeas= '';
				scatterTab_Obj.yAxisDesc= '';
				y_Axis_Obj.setIconCls('');
				y_Axis_Obj.setTitle('Configure Y Axis');
			}
			else if(action=='testCombo')
			{
				scatterTab_Obj.yAxisTest= selectedTest;
				scatterTab_Obj.yAxisMeas= '';
				scatterTab_Obj.yAxisDesc= '';
				y_Axis_Obj.setIconCls('');
				y_Axis_Obj.setTitle('Configure Y Axis');
			}
			else if(action=='measureCombo')
			{
				scatterTab_Obj.yAxisMeas= measure;
				scatterTab_Obj.yAxisDesc= selectedDescriptor;
				if(selectedDescriptor!='chooseDescriptors' && selectedDescriptor!='' && selectedDescriptor!='' && selectedDescriptor!=null)
				{
					y_Axis_Obj.setIconCls('checkBoxTick');
					y_Axis_Obj.setTitle('Y Axis Configured');
				}
			}
			else if(action=='descCombo')
			{
				scatterTab_Obj.yAxisDesc= selectedDescriptor;
				if(selectedDescriptor!='chooseDescriptors' && selectedDescriptor!='' && selectedDescriptor!='-1' && selectedDescriptor!=null)
				{
					y_Axis_Obj.setIconCls('checkBoxTick');
					y_Axis_Obj.setTitle('Y Axis Configured');
				}
			}
		}
	},
	mapWindowModifyClick : function(mapPnlId)
	{		
		var isOneClickDashboard=false;
		var oneClickWidgets=[];
		if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
		{
			oneClickWidgets=publicJson['myDashboardConfigDetails']['oneClickWidgets'];
        }
		var mapWidgetObj=Ext.getCmp(mapPnlId);
		var portalPanlId = mapWidgetObj.id;
		var portalPanlTitle = mapWidgetObj.title;
		var selectedCategory = mapWidgetObj.selectedCategory;
		var blockType = portalPanlId;
		if(portalPanlId!=null && portalPanlId.indexOf("_")>0)
		{
			blockType=portalPanlId.substr(0, portalPanlId.indexOf("_"));
		}

		if(Ext.isEmpty(portalPanlTitle))
		{
			portalPanlTitle='GeoMap';
		}
		var conf_title = portalPanlTitle+' - '+mapConfigurationMsg;
		var defaultAction = publicJson['action'];

		var win = Ext.widget('mapwidgetconfiguration', {
				blockId : portalPanlId,
				blckType : blockType,
				isFluidWindowConfigPopup : true,
				id : portalPanlId+'_mapconfigwindow',
				selectedCategory : selectedCategory
			});
			if (win != null) {
				win.setTitle(conf_title);
				win.show();
			}
	},
	
	updateKpiWidget: function()
	{
		var meC=this;
		var kpiConfigurationWindowObj=Ext.getCmp('kpiConfigurationWindow');
		var widgetId = '';
		var profileName = '';
		var KpiWidgetCount = '';
		var InitialWidgetCount = '';
		var configuredChartsCount = 0;
		var isNeedToDeleteWidget = false;
		if(!Ext.isEmpty(kpiConfigurationWindowObj))
		{
			widgetId = kpiConfigurationWindowObj.blockId;
			InitialWidgetCount = kpiConfigurationWindowObj.chartCount;
			configuredChartsCount = kpiConfigurationWindowObj.configuredChartsCount;
		}

		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		if(!Ext.isEmpty(dashLayoutObj))
		{
			profileName = dashLayoutObj.profileName;
		}

		if(!Ext.isEmpty(kpiConfigurationWindowObj))
		{
			KpiWidgetCount = kpiConfigurationWindowObj.addedWidgetsCount;
		}

		if(KpiWidgetCount<InitialWidgetCount)
		{
			isNeedToDeleteWidget = true;
		}

		//var maxWidgetCount = 5;
	/*	if(!Ext.isEmpty(configuredChartsCount) && configuredChartsCount < 3)
		{
			var msgBox = kpiConfigurationWindowObj.add(new Ext.window.MessageBox({
			cls : 'x-message-box adminAlert',
			bodyPadding:'10 0',
			listeners:{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						
						var el = Ext.fly(dom[dom.length-1]);
						
						el.addCls('background_modal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('background_modal');
					}
				}	
			}
			
			}));
			var kpiDoneButtonNewObj = Ext.getCmp('kpiDoneButton');	
			kpiDoneButtonNewObj.setDisabled(true);
			msgBox.show({
				title : myDashboardAlertLbl,
			//	cls: 'msgbox',
				msg: 'Configure least 3 widgets',
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation',
				fn:function(btn) {
					 kpiDoneButtonNewObj.setDisabled(false);

				}
					
			});
			return;

		} */
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var paramsForSave = '&action=saveKpiWidget&profileName=' + encodeURIComponent(tmpProfNam) + '&blockId='+widgetId+ '&KpiWidgetCount='+KpiWidgetCount+ '&isNeedToDeleteWidget='+isNeedToDeleteWidget+ '&maxWidgetCount=';//+maxWidgetCount;

		iAjax.request({
				url : '/final/servlet/com.eg.egMyDashboardController',
				method : 'POST',
				params : paramsForSave,
				scope : this,
				success : function(response) {

				var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);

						if(!Ext.isEmpty(kpiConfigurationWindowObj))
						{
							kpiConfigurationWindowObj.close();
						}
						var configPanl = Ext.getCmp(widgetId);
						myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, widgetId);
					}					
				}
		});
	},
	
	changeCategoryOptionCombo : function(categoryComboObj)
	{
		var meC=this;
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var selectedCategory = categoryComboObj.getValue();
		var addHealthCenterButtonObj = Ext.getCmp('addHealthCenter');
		//var updateHealthCenterButtonObj = Ext.getCmp('updateHealthCenter');
		var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
		var gridContainerObj = Ext.getCmp('gridContainer');
		

		var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
		var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		if(selectedCategory == 'all')
		{
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.hide();
			}
			if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
			{
				healthCenterCompContinerObj.hide();
				healthCenterComponentComboObj.hide();
				healthCenterComponentSearchTextBoxObj.hide();
			}
		}
		else if(selectedCategory == 'Components')
		{		
			var enableLegendOptObj =  Ext.getCmp('enableLegendOpt');
			enableLegendOptObj.show();
			var compVmBOX = Ext.getCmp('compVmBOX');
			if(!Ext.isEmpty(compVmBOX))
			{
				compVmBOX.hide();
			}
			var healthCenterVMComboLblObj = Ext.getCmp('healthCenterVMComboLbl');
			if(!Ext.isEmpty(healthCenterVMComboLblObj))
			{
				healthCenterVMComboLblObj.hide();
			}
			if(!Ext.isEmpty(gridContainerObj))
			{
				gridContainerObj.hide();
			}
			var legandCheckBoxObj = Ext.getCmp('legandCheckBox');
			if(!Ext.isEmpty(legandCheckBoxObj))
			{
				legandCheckBoxObj.hide();
			}
			var confTabGridObj=Ext.getCmp('configTableGrid');
			if(!Ext.isEmpty(confTabGridObj))
			{
				confTabGridObj.hide();
			}
			addHealthCenterButtonObj.hide();
			//updateHealthCenterButtonObj.show();

			this.loadHealthCenterCompType(selectedCategory);
			
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();
			}
			
			var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
			healthCenterCompScrollComboObj.hide();
			var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
			if (!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}

			if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
			{
				healthCenterCompContinerObj.hide();
				healthCenterComponentComboObj.hide();
				healthCenterComponentSearchTextBoxObj.hide();
			}
		}
		else if(selectedCategory == 'vms|desktop|users')
		{
			var enableLegendOptObj =  Ext.getCmp('enableLegendOpt');
			enableLegendOptObj.hide();
			//var vmMultiselectcontObj = Ext.getCmp('vmMultiselectcont');
			//vmMultiselectcontObj.show();
			var legandCheckBoxObj = Ext.getCmp('legandCheckBox');
			legandCheckBoxObj.hide();
			Ext.getCmp('configTableGrid').hide();
			addHealthCenterButtonObj.hide();
			//updateHealthCenterButtonObj.show();

			this.loadHealthCenterCompType(selectedCategory);
			
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();
			}
			
			var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
			healthCenterCompScrollComboObj.hide();
			var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
			healthCenterTestScrollComboObj.hide();
			
			if (!Ext.isEmpty(healthCenterComponentComboObj))
			{
				healthCenterComponentComboObj.suspendEvents(true);				
				var componentCombo = healthCenterComponentComboObj.getStore();
				componentCombo.removeAll();

				componentCombo.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterComponentComboObj.setValue('-1');
				healthCenterComponentComboObj.resumeEvents();
			}

			if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
			{
				healthCenterCompContinerObj.show();
				healthCenterComponentComboObj.show();
				healthCenterComponentSearchTextBoxObj.show();
				healthCenterComponentComboLblObj.setText('Components:');
			}
		}
		else if(selectedCategory == 'ComponentType')
		{
			var enableLegendOptObj =  Ext.getCmp('enableLegendOpt');
			enableLegendOptObj.hide();
			var compVmBOX = Ext.getCmp('compVmBOX');
			if(!Ext.isEmpty(compVmBOX))
			{
				compVmBOX.hide();
			}
			var healthCenterVMComboLblObj = Ext.getCmp('healthCenterVMComboLbl');
			if(!Ext.isEmpty(healthCenterVMComboLblObj))
			{
				healthCenterVMComboLblObj.hide();
			}
			if(!Ext.isEmpty(gridContainerObj))
			{
				gridContainerObj.hide();
			}
			var legandCheckBoxObj = Ext.getCmp('legandCheckBox');
			if(!Ext.isEmpty(legandCheckBoxObj))
			{
				legandCheckBoxObj.hide();
			}
			var confTabGridObj=Ext.getCmp('configTableGrid');
			if(!Ext.isEmpty(confTabGridObj))
			{
				confTabGridObj.hide();
			}
			addHealthCenterButtonObj.hide();

			var param="comesFrom=myDashboard&action=loadComponentTypesForDataHealth&profileName="+encodeURIComponent(tmpProfNam)+"&selectedCategory="+encodeURIComponent(selectedCategory);
			
			var meC = this;
			iAjax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params : param,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, jsonData['comptypes'], '', '','');

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();
							healthCenterComponentComboLblObj.setText(selectedCategory+'s');
						}

						var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
						healthCenterCompScrollComboObj.hide();
						var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
						if(!Ext.isEmpty(healthCenterTestScrollComboObj))
						{
							healthCenterTestScrollComboObj.hide();
						}

						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.hide();
			}
		}
		else if(selectedCategory == 'Zone' || selectedCategory == 'Segment' || selectedCategory == 'Service')
		{
			var enableLegendOptObj =  Ext.getCmp('enableLegendOpt');
			var mePopup = Ext.getCmp('filterPopupWindow');
			if(mePopup!=null && mePopup.hasOwnProperty('widgetType'))
			{
				if(mePopup.widgetType!=null && mePopup.widgetType=='tierhealth')
				{
					enableLegendOptObj.isDefault=false;
					enableLegendOptObj.hide();
				}
				else
				{
					enableLegendOptObj.show();
				}
			}
			else
			{
				enableLegendOptObj.show();
			}
			var compVmBOX = Ext.getCmp('compVmBOX');
			if(!Ext.isEmpty(compVmBOX))
			{
				compVmBOX.hide();
			}
			var healthCenterVMComboLblObj = Ext.getCmp('healthCenterVMComboLbl');
			if(!Ext.isEmpty(healthCenterVMComboLblObj))
			{
				healthCenterVMComboLblObj.hide();
			}
			if(!Ext.isEmpty(gridContainerObj))
			{
				gridContainerObj.hide();
			}
			var legandCheckBoxObj = Ext.getCmp('legandCheckBox');
			if(!Ext.isEmpty(legandCheckBoxObj))
			{
				legandCheckBoxObj.hide();
			}
			var confTabGridObj=Ext.getCmp('configTableGrid');
			if(!Ext.isEmpty(confTabGridObj))
			{
				confTabGridObj.hide();
			}
			addHealthCenterButtonObj.hide();
			//updateHealthCenterButtonObj.show();

			var paramsForRc = 'C=true&P0={' + selectedCategory + '}&P1={' + encodeURIComponent(tmpProfNam) + '}&calljson=true&F=getCategoryOptionsForTypeJSON';
			
			var meC = this;
			iAjax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, jsonData['optionsForType'], '', '','');

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();
							healthCenterComponentComboLblObj.setText(selectedCategory+'s');
						}

						var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
						healthCenterCompScrollComboObj.hide();
						var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
						if(!Ext.isEmpty(healthCenterTestScrollComboObj))
						{
							healthCenterTestScrollComboObj.hide();
						}

						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.hide();
			}
		}
		else if(selectedCategory == 'Descriptors')
		{	
			var enableLegendOptObj =  Ext.getCmp('enableLegendOpt');
			enableLegendOptObj.hide();
			var compVmBOX = Ext.getCmp('compVmBOX');
			compVmBOX.hide();
			var healthCenterVMComboLblObj = Ext.getCmp('healthCenterVMComboLbl');
			healthCenterVMComboLblObj.hide();
			gridContainerObj.show();
			var legandCheckBoxObj = Ext.getCmp('legandCheckBox');
			legandCheckBoxObj.show();
			//updateHealthCenterButtonObj.hide();
			addHealthCenterButtonObj.show();
		
			this.loadHealthCenterCompType(selectedCategory);

			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();
			}
			if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
			{
				healthCenterCompContinerObj.show();
				healthCenterComponentComboObj.show();
				healthCenterComponentSearchTextBoxObj.show();
				healthCenterComponentComboLblObj.setText('Descriptors');
			}

			var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
			if (!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompScrollComboObj.suspendEvents(true);				
				var compScrollComboStore = healthCenterCompScrollComboObj.getStore();
				compScrollComboStore.removeAll();

				compScrollComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterCompScrollComboObj.setValue('-1');
				healthCenterCompScrollComboObj.resumeEvents();
				healthCenterCompScrollComboObj.show();
			}

			var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
			if (!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.suspendEvents(true);				
				var testScrollComboStore = healthCenterTestScrollComboObj.getStore();
				testScrollComboStore.removeAll();

				testScrollComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterTestScrollComboObj.setValue('-1');
				healthCenterTestScrollComboObj.resumeEvents();
				healthCenterTestScrollComboObj.show();
			}

			var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

			if (!Ext.isEmpty(healthCenterComponentComboObj))
			{
				healthCenterComponentComboObj.suspendEvents(true);				
				var componentCombo = healthCenterComponentComboObj.getStore();
				componentCombo.removeAll();

				componentCombo.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterComponentComboObj.setValue('-1');
				healthCenterComponentComboObj.resumeEvents();
			}

			var configTableGrid = Ext.getCmp('configTableGrid');
			configTableGrid.suspendEvents(true);
			var gridStore = configTableGrid.getStore();
			gridStore.removeAll();
			configTableGrid.show();
			configTableGrid.resumeEvents();
			configTableGrid.doComponentLayout();
		}
	},
	
	loadComponentItems : function(categoryComboObj,selectedcompTypeValue,selectedvalue)
	{
		var selectedCategoryValue = categoryComboObj.getValue();
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
		var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		if(selectedCategoryValue != null && (selectedCategoryValue == 'Components' || selectedCategoryValue == 'vms|desktop|users'))
		{	
			var paramsForRc = 'C=true&F=getComponentsJSONForType&P0={' + selectedcompTypeValue + '}&P1={' + encodeURIComponent(tmpProfNam) + '}&calljson=true';
			var meC = this;
			iAjax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);											
						if (!Ext.isEmpty(healthCenterComponentComboObj))
						{
							healthCenterComponentComboObj.suspendEvents(true);				
							var componentCombo = healthCenterComponentComboObj.getStore();
							componentCombo.loadRawData(jsonData['compOptsJson']);
							if(selectedCategoryValue != null && selectedCategoryValue != 'vms|desktop|users')
							{	
								componentCombo.insert(0,{
									displayField:'All Components',
									valueField: 'allServers'
								});
							}
							healthCenterComponentComboObj.setValue(selectedvalue);
							healthCenterComponentComboObj.resumeEvents();
						}

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();

							if(selectedCategoryValue == 'vms|desktop|users')
							{		
								healthCenterComponentComboLblObj.setText('Components:');
							}
							else
							{
								healthCenterComponentComboLblObj.setText(selectedCategoryValue+':');
							}
						}
						jsonData=null;
						delete jsonData;
					}
					else
					{
						meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, '', '', notApplicable,'');

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();
							healthCenterComponentComboLblObj.setText(selectedCategoryValue+'s');
						}
					}
					jsonText=null;
					delete jsonText;
				}
			});
		}
	},

	loadGroupedItems : function(categoryComboObj,selectedvalue)
	{
		var selectedCategoryValue = categoryComboObj.getValue();
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		
		var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
		var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		if(selectedCategoryValue == 'Zone' || selectedCategoryValue == 'Segment' || selectedCategoryValue == 'Service')
		{	
			var paramsForRc = 'C=true&P0={' + selectedCategoryValue + '}&P1={' + encodeURIComponent(profileName) + '}&calljson=true&F=getCategoryOptionsForTypeJSON';
			var meC = this;
			iAjax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, jsonData['optionsForType'], selectedvalue, '','');

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();
							healthCenterComponentComboLblObj.setText(selectedCategoryValue+'s');
						}
						jsonData=null;
						delete jsonData;
					}
					else
					{
						meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, '', '', notApplicable,'');

						if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
						{
							healthCenterCompContinerObj.show();
							healthCenterComponentComboObj.show();
							healthCenterComponentSearchTextBoxObj.show();
							healthCenterComponentComboLblObj.setText(selectedCategoryValue+'s');
						}
					}
					jsonText=null;
					delete jsonText;
				}
			});
		}
	},
	
	changeHealthCenterCompTypeVal : function()
	{
		var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
		this.onChangeHealthCenterCompType(healthCenterCompTypeComboObj);
	},
	
	onChangeHealthCenterCompType : function(compTypeObj)
	{
		this.changeHealthCenterCompType(compTypeObj,'');
	},
	changeUptimeForComboVal : function(uptimeForObj)
	{
		var comesFrom = 'myDashboard';
		if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
		{
			comesFrom = 'Template';
		}
		var categoryOptsObj = Ext.getCmp('uptimeDowntimeAnalysisBy');
		var compTypeObj = Ext.getCmp('compntTypFilterCmb');
		var selectedCategory = categoryOptsObj.getValue();
		var selectedUptimeFor = uptimeForObj.getValue();
		var hostPoolObj = Ext.getCmp('hostPoolFilterCmb');
		if(!Ext.isEmpty(hostPoolObj) && selectedUptimeFor!='WVD_RDS_server_SessionHost')
		{
			hostPoolObj.hide();
			hostPoolObj.setValue('');
		}
		var fMethod='getInfraElementsForTypeJSON';
		var dispInfraTypLbl=selectedCategory;
		if(!Ext.isEmpty(dispInfraTypLbl))
		{
			dispInfraTypLbl=dispInfraTypLbl.charAt(0).toUpperCase() + dispInfraTypLbl.slice(1)
		}
		var uptimeDowntimeSubTypeCompComboObj = Ext.getCmp('subTypeCompCombo');
		var uptimeDowntimecompntTypFilterCmb = Ext.getCmp('compntTypFilterCmb');

		uptimeDowntimecompntTypFilterCmb.hide();
		var dashboardCompsItmSelectorObj=Ext.getCmp('excludeCmpDescObj');
		if(!Ext.isEmpty(dashboardCompsItmSelectorObj))
		{
			if(dashboardCompsItmSelectorObj.fromField.store.getCount() > 0)
			{
				dashboardCompsItmSelectorObj.fromField.store.removeAll();
			}
			if(dashboardCompsItmSelectorObj.toField.store.getCount() > 0)
			{
				dashboardCompsItmSelectorObj.toField.store.removeAll();
			}
		}

		if(selectedCategory == 'components')
		{
			var selectedcompTypeValue = compTypeObj.getValue();
			if(selectedcompTypeValue!=null && selectedcompTypeValue == '-1')
			{
				selectedcompTypeValue = 'all';
			}
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('subTypeCompCombo');
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					fMethod='getCompTypesForElement';
					paramsForRc = 'C=true&P0={' + selectedCategory + '}&P1={' + selectedcompTypeValue + '}&P2={' + encodeURIComponent(profileName) + '}&calljson=true&F='+fMethod+'&P3={}&P4={'+comesFrom+'}&P5={'+selectedUptimeFor+'}&P6={uptimeDowntimeDashboard}';
				}
			}
		}
		else
		{
			var selectedcompTypeValue = compTypeObj.getValue();
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('subTypeCompCombo');
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					var paramsForRc = 'C=true&P0={' + selectedCategory + '}&P1={' + encodeURIComponent(profileName) + '}&calljson=true&F='+fMethod+'&P2={}&P3={'+selectedUptimeFor+'}&P4={uptimeDowntimeDashboard}';
				}
			}
		}
		var meC = this;
		iAjax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					if(selectedCategory!=null && selectedCategory=='components')
					{
						uptimeDowntimeSubTypeCompComboObj.hide();
						var compntTypFilterCmb=Ext.getCmp('compntTypFilterCmb');
						if(!Ext.isEmpty(compntTypFilterCmb))
						{
							meC.setValueWithOptionInList(compntTypFilterCmb, jsonData['compTypeOpts'], '-1', '');
						}
						compntTypFilterCmb.show();
					}
					else
					{
						uptimeDowntimeSubTypeCompComboObj.hide();
						uptimeDowntimecompntTypFilterCmb.hide();
						var infraOptsArr=jsonData['optionsForType'];
						var infraOptsArrForDropDown=[];
						if(!Ext.isEmpty(infraOptsArr) && infraOptsArr.length>1)
						{
							for(var infElm in infraOptsArr)
							{
								var infElmObj=infraOptsArr[infElm];
								if(!Ext.isEmpty(infElmObj))
								{
									var infElmVal=infElmObj['valueField'];
									if(infElmVal!=null && infElmVal!=("ALL"))
									{
										infraOptsArrForDropDown.push(infElmObj);
									}
								}
							}
						}
						var defaultOptMsg='';
						if(selectedCategory!=null && selectedCategory=='zone')
						{
							defaultOptMsg=noZoneSelectedAlertMsg;
						}
						else if(selectedCategory!=null && selectedCategory=='segment')
						{
							defaultOptMsg=noSegmentSelectedAlertMsg;
						}
						else if(selectedCategory!=null && selectedCategory=='service')
						{
							defaultOptMsg=noServiceSelectedAlertMsg;
						}

						uptimeDowntimeSubTypeCompComboObj.setFieldLabel(dispInfraTypLbl);
						meC.setValueWithOptionInList(uptimeDowntimeSubTypeCompComboObj, infraOptsArrForDropDown, '-1', defaultOptMsg);
						uptimeDowntimeSubTypeCompComboObj.show();
						var compntTypFilterCmb=Ext.getCmp('compntTypFilterCmb');
						if(!Ext.isEmpty(compntTypFilterCmb))
						{
							compntTypFilterCmb.hide();
						}
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				console.log("response ",response);
			}
		});
	

	},

	changeUptimeDowntimeAnalysisByVal : function(compTypeObj)
	{
		var categoryOptsObj = Ext.getCmp('uptimeDowntimeAnalysisBy');
		var selectedCategory = categoryOptsObj.getValue();
		var selectedUptimeFor= Ext.getCmp('uptimeForCombo').getValue();
		var fMethod='getInfraElementsForTypeJSON';
		var dispInfraTypLbl=selectedCategory;
		if(!Ext.isEmpty(dispInfraTypLbl))
		{
			dispInfraTypLbl=dispInfraTypLbl.charAt(0).toUpperCase() + dispInfraTypLbl.slice(1)
		}
		var hostPoolObj = Ext.getCmp('hostPoolFilterCmb');
		if(!Ext.isEmpty(hostPoolObj) && selectedUptimeFor!='WVD_RDS_server_SessionHost')
		{
			hostPoolObj.hide();
			hostPoolObj.setValue('');
		}
		var dashboardCompsItmSelectorObj=Ext.getCmp('excludeCmpDescObj');
		if(!Ext.isEmpty(dashboardCompsItmSelectorObj))
		{
			if(dashboardCompsItmSelectorObj.fromField.store.getCount() > 0)
			{
				dashboardCompsItmSelectorObj.fromField.store.removeAll();
			}
			if(dashboardCompsItmSelectorObj.toField.store.getCount() > 0)
			{
				dashboardCompsItmSelectorObj.toField.store.removeAll();
			}
		}
		var uptimeDowntimeSubTypeCompComboObj = Ext.getCmp('subTypeCompCombo');
		var uptimeDowntimecompntTypFilterCmb = Ext.getCmp('compntTypFilterCmb');
		var dashboardCompsItmSelectorObj=Ext.getCmp('excludeCmpDescObj');
		if(selectedCategory == 'components')
		{
			var selectedcompTypeValue = compTypeObj.getValue();
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('subTypeCompCombo');
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					fMethod='getCompTypesForElement';
					paramsForRc = 'C=true&P0={' + selectedCategory + '}&P1={' + selectedcompTypeValue + '}&P2={' + encodeURIComponent(profileName) + '}&calljson=true&F='+fMethod+'&P3={}&P4={}&P5={'+selectedUptimeFor+'}&P6={uptimeDowntimeDashboard}';
				}
			}
		}
		else
		{
			var selectedcompTypeValue = compTypeObj.getValue();
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('subTypeCompCombo');
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					var paramsForRc = 'C=true&P0={' + selectedCategory + '}&P1={' + encodeURIComponent(profileName) + '}&calljson=true&F='+fMethod+'&P2={}&P3={'+selectedUptimeFor+'}&P4={uptimeDowntimeDashboard}';
				}
			}
		}
		var meC = this;
		iAjax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					if(selectedCategory!=null && selectedCategory=='components')
					{
						uptimeDowntimeSubTypeCompComboObj.hide();
						var compntTypFilterCmb=Ext.getCmp('compntTypFilterCmb');
						if(!Ext.isEmpty(compntTypFilterCmb))
						{
							meC.setValueWithOptionInList(compntTypFilterCmb, jsonData['compTypeOpts'], '-1', '');
						}
						compntTypFilterCmb.show();
						
					}
					else
					{
						var infraOptsArr=jsonData['optionsForType'];
						var infraOptsArrForDropDown=[];
						
						if(!Ext.isEmpty(infraOptsArr) && infraOptsArr.length>1)
						{
							for(var infElm in infraOptsArr)
							{
								var infElmObj=infraOptsArr[infElm];
								if(!Ext.isEmpty(infElmObj))
								{
									var infElmVal=infElmObj['valueField'];

									if(infElmVal!=null && infElmVal!=("ALL"))
									{
										infraOptsArrForDropDown.push(infElmObj);
									}
								}
							}
						}

						var defaultOptMsg='';
						if(selectedCategory!=null && selectedCategory=='zone')
						{
							defaultOptMsg=noZoneSelectedAlertMsg;
						}
						else if(selectedCategory!=null && selectedCategory=='segment')
						{
							defaultOptMsg=noSegmentSelectedAlertMsg;
						}
						else if(selectedCategory!=null && selectedCategory=='service')
						{
							defaultOptMsg=noServiceSelectedAlertMsg;
						}

						uptimeDowntimeSubTypeCompComboObj.setFieldLabel(dispInfraTypLbl);
						meC.setValueWithOptionInList(uptimeDowntimeSubTypeCompComboObj, infraOptsArrForDropDown, '-1', defaultOptMsg);
						uptimeDowntimeSubTypeCompComboObj.show();
						var compntTypFilterCmb=Ext.getCmp('compntTypFilterCmb');
						if(!Ext.isEmpty(compntTypFilterCmb))
						{
							compntTypFilterCmb.hide();
						}
						var hostPoolObj = Ext.getCmp('hostPoolFilterCmb');
						if(!Ext.isEmpty(hostPoolObj))
						{
							hostPoolObj.hide();
							hostPoolObj.setValue('');
						}
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				console.log("response ",response);
			}
		});
	},
	loadCompTypesForSelectedInfraType: function(selectedInfraElementCombo)
	{
		try
		{
			var uptimeDowntimeAnalysisObj = this.getWidgetOptionsWindow();
			if (Ext.isEmpty(uptimeDowntimeAnalysisObj))
				uptimeDowntimeAnalysisObj = Ext.widget('widgetOptionsWindow');

			var widgetConfigForm = uptimeDowntimeAnalysisObj.getComponent('serverUpDownConfigForm').getForm();
			var selectedType = widgetConfigForm.findField('uptimeDowntimeAnalysisBy').getValue();
			var selectedUptimeFor = widgetConfigForm.findField('uptimeForCombo').getValue();
			var selectedInfraElement = selectedInfraElementCombo.getValue();
			var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
			var profileName = dashLayoutObj.profileName;
			var compntTypFilterCmb=Ext.getCmp('compntTypFilterCmb');
			var hostPoolObj = Ext.getCmp('hostPoolFilterCmb');
			if(!Ext.isEmpty(hostPoolObj) && selectedUptimeFor!='WVD_RDS_server_SessionHost')
			{
				hostPoolObj.hide();
				hostPoolObj.setValue('');
			}
			var dashboardCompsItmSelectorObj=Ext.getCmp('excludeCmpDescObj');
			if(!Ext.isEmpty(dashboardCompsItmSelectorObj))
			{
				if(dashboardCompsItmSelectorObj.fromField.store.getCount() > 0)
				{
					dashboardCompsItmSelectorObj.fromField.store.removeAll();
				}
				if(dashboardCompsItmSelectorObj.toField.store.getCount() > 0)
				{
					dashboardCompsItmSelectorObj.toField.store.removeAll();
				}
			}
			var fMethod='getCompTypesForElement';
			selectedInfraElement=filterEncode(selectedInfraElement);
			var paramsForRc = 'C=true&P0={'+ selectedType +'}&P1={'+selectedInfraElement+'}&P2={' + encodeURIComponent(profileName) +'}&calljson=true&F='+fMethod+'&P3={}&P4={}&P5={'+selectedUptimeFor+'}&P6={uptimeDowntimeInfraElement}';
			var meC = this;
			iAjax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(compntTypFilterCmb))
						{
							meC.setValueWithOptionInList(compntTypFilterCmb, jsonData['compTypeOpts'], '-1', '');
						}
						compntTypFilterCmb.show();
						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				},
				failure : function(response, opts) {
					console.log("response ",response);
				}
			});
		}
		catch (jsExcp)
		{
			console.log("Exception...",jsExcp);
		}
	},
	loadCompsForSelectedInfraType : function(compTypObj)
	{
		try
		{
			var comesFrom = 'myDashboard';
			if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
			{
				comesFrom = 'Template';
			}
			var uptimeDowntimeAnalysisObj = this.getWidgetOptionsWindow();
			if (Ext.isEmpty(uptimeDowntimeAnalysisObj))
				uptimeDowntimeAnalysisObj = Ext.widget('widgetOptionsWindow');
			var widgetConfigForm = uptimeDowntimeAnalysisObj.getComponent('serverUpDownConfigForm').getForm();
			var selectedType = widgetConfigForm.findField('uptimeDowntimeAnalysisBy').getValue();
			var selectedUptimeFor = widgetConfigForm.findField('uptimeForCombo').getValue();
			var selectedInfraElement = '';
			if(!Ext.isEmpty(selectedType) && selectedType!='components')
			{
				var filterZoneComboxObj=Ext.getCmp('subTypeCompCombo');
				if(!Ext.isEmpty(filterZoneComboxObj))
				{
					selectedInfraElement=filterZoneComboxObj.getValue();
				}
			}
			var upDownWidgetId = this.getWidgetOptionsWindow().widgetID;
			var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
			var hostPoolObj = Ext.getCmp('hostPoolFilterCmb');
			var profileName = dashLayoutObj.profileName;
			var cmpTypeVal='';
			if(selectedUptimeFor!=null && selectedUptimeFor=='WVD_RDS_server_SessionHost')
			{
				cmpTypeVal=hostPoolObj.getValue();
			}else
			{
				cmpTypeVal=compTypObj.getValue();
			}
			var hostPoolValue = hostPoolObj.getValue();
			if(selectedUptimeFor!=null && selectedUptimeFor=='WVD_RDS_server_SessionHost' && Ext.isEmpty(hostPoolValue))
			{
				var fMethod='getHostPoolForSelectedCompType';
				selectedInfraElement=filterEncode(selectedInfraElement);
				var paramsForRc = 'C=true&P0={' + selectedType + '}&P1={'+selectedInfraElement+'}&P2={' + encodeURIComponent(cmpTypeVal) + '}&calljson=true&F='+fMethod+'&P3={'+encodeURIComponent(profileName)+'}&P4={'+comesFrom+'}&P5={ '+ selectedUptimeFor + '}'+'&P6={'+ upDownWidgetId+'}';
				var meC = this;
				iAjax.request({
					url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
					method : 'POST',
					params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
								if(!Ext.isEmpty(hostPoolFilterCmb))
								{
									meC.setValueWithOptionInList(hostPoolObj, jsonData['compOptsJson'], '-1', '');
								}
								hostPoolObj.show();
								jsonData=null;
								delete jsonData;
							}
							jsonText=null;
							delete jsonText;
						
					},
					failure : function(response, opts) {
						console.log("response ",response);
					}
				});
			}
			else
			{
				var fMethod='getComponentsForSelectedCompType';
				selectedInfraElement=filterEncode(selectedInfraElement);
				var dashItmSelectorObj=Ext.getCmp('excludeCmpDescObj');
				var paramsForRc = 'C=true&P0={' + selectedType + '}&P1={'+selectedInfraElement+'}&P2={' + encodeURIComponent(cmpTypeVal) + '}&calljson=true&F='+fMethod+'&P3={'+encodeURIComponent(profileName)+'}&P4={'+comesFrom+'}&P5={ '+ selectedUptimeFor + '}'+'&P6={'+ upDownWidgetId+'}';
				var meC = this;
				iAjax.request({
					url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
					method : 'POST',
					params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							if(!Ext.isEmpty(dashItmSelectorObj))
							{
								var selectedValue='';
								var selectedComp=jsonData['selectedComponent'];
								var excludedComp=jsonData['excludedCompsList'];
								var compsSelection=jsonData['compOptsJson'];
								if(selectedComp!=null && (selectedComp!='' && selectedComp!='null'))
								{
									selectedValue=selectedComp;
								}
								dashItmSelectorObj.getStore().removeAll();
								if(dashItmSelectorObj.fromField.store.getCount() > 0)
								{
									dashItmSelectorObj.fromField.store.removeAll();
								}
								if(dashItmSelectorObj.toField.store.getCount() > 0)
								{
									dashItmSelectorObj.toField.store.removeAll();
								}
								if (!Ext.isEmpty(selectedValue))
								{
									dashItmSelectorObj.toField.store.add(selectedValue);
								}
								if (!Ext.isEmpty(compsSelection))
								{
									dashItmSelectorObj.toField.store.add(compsSelection);
								}
								if(excludedComp!=null && (excludedComp!='' && excludedComp!='null'))
								{
									if(!Ext.isEmpty(excludedComp) && excludedComp!='none')
									{
										dashItmSelectorObj.fromField.store.add(excludedComp);
									}
									else
									{
										dashItmSelectorObj.fromField.store.removeAll();
									}
								}else
								{
									dashItmSelectorObj.fromField.store.removeAll();
								}
							}

							jsonData=null;
							delete jsonData;
						}
						jsonText=null;
						delete jsonText;
					},
					failure : function(response, opts) {
						console.log("response ",response);
					}
				});
			}
		}
		catch (jsExcp)
		{
			console.log("Exception...",jsExcp);
		}
	},
	changeHealthCenterCompType : function(compTypeObj, selectedValue)
	{
		var categoryOptsObj = Ext.getCmp('categoryOpts');
		var selectedCategory = categoryOptsObj.getValue();

		if(selectedCategory == 'Descriptors')
		{
			var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
			healthCenterCompScrollComboObj.show();
			var selectedcompTypeValue = compTypeObj.getValue();
			
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
				componentTypeComboObj.selectedOption = 'Descriptors';
				
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					var paramsForRc = 'C=true&F=getComponentsJSONForType&P0={' + selectedcompTypeValue + '}&P1={' + profileName + '}&calljson=true';
					this.callRemoteScriptingMethod(paramsForRc, 'loadHealthCenterComponents', 'healthCenterPopup', '', true);
				}
				else
				{
					var healthCenterComponentScrollComboStore = healthCenterCompScrollComboObj.getStore();
					healthCenterComponentScrollComboStore.removeAll();
					healthCenterComponentScrollComboStore.insert(0, {
						displayField : notApplicable,
						valueField : '-1'
					});
					healthCenterCompScrollComboObj.setValue('-1');
				}
			}

			var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
			if (!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.suspendEvents(true);				
				var testScrollComboStore = healthCenterTestScrollComboObj.getStore();
				testScrollComboStore.removeAll();

				testScrollComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterTestScrollComboObj.setValue('-1');
				healthCenterTestScrollComboObj.resumeEvents();
				healthCenterTestScrollComboObj.show();
			}
			var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

			if (!Ext.isEmpty(healthCenterComponentComboObj))
			{
				healthCenterComponentComboObj.suspendEvents(true);				
				var componentCombo = healthCenterComponentComboObj.getStore();
				componentCombo.removeAll();

				componentCombo.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterComponentComboObj.setValue('-1');
				healthCenterComponentComboObj.resumeEvents();
			}
		}
		else if(selectedCategory == 'Components' || selectedCategory == 'vms|desktop|users')
		{
			var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
			var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
			var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
			var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');
			var selectedcompTypeValue = compTypeObj.getValue();
			
			if(selectedcompTypeValue != null)
			{	
				var componentTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
				if(selectedCategory == 'vms|desktop|users')
				{
					componentTypeComboObj.selectedOption = 'vms';
				}
				else
				{
					componentTypeComboObj.selectedOption = 'Servers';
				}				
				
				if (selectedcompTypeValue != "-1") 
				{
					var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var profileName = dashLayoutObj.profileName;
					var paramsForRc = 'C=true&F=getComponentsJSONForType&P0={' + selectedcompTypeValue + '}&P1={' + profileName + '}&calljson=true';
					this.callRemoteScriptingMethod(paramsForRc, 'loadHealthCenterComponents', 'filterPopup', '', true);

					if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
					{
						healthCenterCompContinerObj.show();
						healthCenterComponentComboObj.show();
						healthCenterComponentSearchTextBoxObj.show();
						healthCenterComponentComboLblObj.setText('Components:');
					}
				}
				else
				{
					var healthCenterComponentComboStore = healthCenterComponentComboObj.getStore();
					healthCenterComponentComboStore.removeAll();
					healthCenterComponentComboStore.insert(0, {
						displayField : notApplicable,
						valueField : '-1'
					});
					healthCenterComponentComboObj.setValue('-1');
				}
			}
		}
	},
		
	loadHealthCenterCompType : function(selectedCategory)
	{
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;

		//var param="comesFrom=myDashboard&action=loadComponentTypesForDataHealth&profileName="+profileName;
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var param="comesFrom=myDashboard&action=loadComponentTypesForDataHealth&profileName="+encodeURIComponent(tmpProfNam)+"&selectedCategory="+encodeURIComponent(selectedCategory);
			Ext.Ajax.request(
			{
				url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				params: param,
				scope: this,
				method: 'POST',
				success: function(response)
				{
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					if (!Ext.isEmpty(jsonData))
					{
						if(jsonData.hasOwnProperty('comptypes'))
						{
							var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
							healthCenterCompTypeComboObj.suspendEvents(true);				
							healthCenterCompTypeComboObj.getStore().loadRawData(jsonData['comptypes']);
							var compTypeStore = healthCenterCompTypeComboObj.getStore();

							var categoryOptsObj = Ext.getCmp('categoryOpts');
							var selectedCategory = categoryOptsObj.getValue();
							
							compTypeStore.insert(0,{
								displayField:compTypAlertMsg,
								valueField: '-1'
							});
							healthCenterCompTypeComboObj.setValue('-1');
							healthCenterCompTypeComboObj.resumeEvents();
						}	
						else
						{
							var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
							healthCenterCompTypeComboObj.suspendEvents(true);				
							var compTypeStore = healthCenterCompTypeComboObj.getStore();
							compTypeStore.removeAll();

							compTypeStore.insert(0,{
								displayField:compTypAlertMsg,
								valueField: '-1'
							});
							healthCenterCompTypeComboObj.setValue('-1');
							healthCenterCompTypeComboObj.resumeEvents();
						}						
					}
				}
			});
	},

	changeHealthCenterCompScrollCombo : function(compScrollComboObj)
	{
		var selectedCompValue = compScrollComboObj.getValue();

		var healthCenterTestCombo = Ext.getCmp('healthCenterTestScrollCombo');
		var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

		if (!Ext.isEmpty(healthCenterComponentComboObj))
		{
			healthCenterComponentComboObj.suspendEvents(true);				
			var componentCombo = healthCenterComponentComboObj.getStore();
			componentCombo.removeAll();

			componentCombo.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			healthCenterComponentComboObj.setValue('-1');
			healthCenterComponentComboObj.resumeEvents();
		}


		if (selectedCompValue != "-1") {
			var paramsForRc = 'C=true&F=getTestsAsJSONForComponent&P0={' + selectedCompValue + '}&calljson=true';
			this.callRemoteScriptingMethod(paramsForRc, 'loadHealthCenterComponentsTests', 'healthCenterPopup', '', true);
			healthCenterTestCombo.show();
		} 
		else
		{
			if (!Ext.isEmpty(healthCenterTestCombo))
			{
				healthCenterTestCombo.suspendEvents(true);				
				var testStore = healthCenterTestCombo.getStore();
				testStore.removeAll();

				testStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterTestCombo.setValue('-1');
				healthCenterTestCombo.resumeEvents();
				healthCenterTestCombo.show();
			}

			if (!Ext.isEmpty(healthCenterComponentComboObj))
			{
				healthCenterComponentComboObj.suspendEvents(true);				
				var componentCombo = healthCenterComponentComboObj.getStore();
				componentCombo.removeAll();

				componentCombo.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterComponentComboObj.setValue('-1');
				healthCenterComponentComboObj.resumeEvents();
			}
		}
	},

	loadVms : function(combo)
	{
		var categoryOptsObj = Ext.getCmp('categoryOpts');
		var selectedCategory = categoryOptsObj.getValue();

		if(selectedCategory != null && selectedCategory != 'vms|desktop|users')
		{
			return;
		}

		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var legandCheckBoxObj = configForm.findField('legandCheckBox');
		legandCheckBoxObj.show();
		var componentType = configForm.findField('healthCenterCompTypeCombo');
		var selectedCompType = componentType.getValue();
		var selectedCompName = combo.getValue();
		var compVmBOX = Ext.getCmp('compVmBOX');
		var vmDescrCombo = configForm.findField('vmListCombo');
		if (selectedCompName != "-1" && selectedCompType != "-1") {
			var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
			var profileName = dashLayoutObj.profileName;
			Ext.getCmp('healthCenterVMComboLbl').show();
			compVmBOX.show();
			var paramsForRc = 'C=true&F=getVmsForHyperVisor&P0={' + selectedCompType + '}&P1={' + selectedCompName + '}&calljson=true';

			var selectedVMs = ''; 
			if(componentType != null && componentType.hasOwnProperty('vmData'))
			{
				var selectedItems = componentType['vmData'];
				if(selectedItems != null && selectedItems.hasOwnProperty('selectedVMs'))
				{
					selectedVMs = selectedItems['selectedVMs'];
				}
			}

			if(selectedVMs != null && selectedVMs != '')
			{
				this.callRemoteScriptingMethod(paramsForRc, 'loadVmDescriptors', 'healthCenterPopup', selectedVMs, true);
			}
			else
			{
				this.callRemoteScriptingMethod(paramsForRc, 'loadVmDescriptors', 'healthCenterPopup', '', true);
			}

			
		} else {
			
			var vmCompComboStore = vmDescrCombo.getStore();
			vmCompComboStore.removeAll();
			vmCompComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
			});
			vmDescrCombo.setValue('-1');
		}	
	},

	changeHealthCenterTestScrollCombo : function(testScrollComboObj)
	{
		var selectedTestValue = testScrollComboObj.getValue();
		var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
		var healthCenterCompScrollComboObj = Ext.getCmp('healthCenterCompScrollCombo');
		var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
		var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		var dashboardLayObj=Ext.getCmp('dashboardLayoutObj');
		var dashboardName = dashboardLayObj.profileName;

		if (selectedTestValue != "-1") {
			var compType = healthCenterCompTypeComboObj.getValue();
			var selectedComps = healthCenterCompScrollComboObj.getValue();
			
			var paramsForRc = 'C=true&F=getDescriptorsForServersJSON&P0={' + compType + '}&P1={' + selectedComps + '}&P2={' + selectedTestValue + '}&calljson=true';
			
			this.callRemoteScriptingMethod(paramsForRc, 'loadDescriptorsForHealthCenter', 'healthCenterPopup', '', true);
		}
		else
		{
			healthCenterComponentComboObj.suspendEvents(true);				
			var componentCombo = healthCenterComponentComboObj.getStore();
			componentCombo.removeAll();

			componentCombo.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			healthCenterComponentComboObj.setValue('-1');
			healthCenterComponentComboObj.resumeEvents();
		}

		if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
		{
			healthCenterCompContinerObj.show();
			healthCenterComponentComboObj.show();
			healthCenterComponentSearchTextBoxObj.show();
			healthCenterComponentComboLblObj.setText('Descriptors');
		}
	},
	
	updateInfrastructureHealth : function()
	{
		return updateInfrastructureHealth(false,'');
	},
		
	updateInfrastructureHealth : function(isPreviewMode,previewContObj) {
		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var categoryOptsValue = configForm.findField('categoryOpts').getValue();

		if(categoryOptsValue == 'Descriptors')
		{
			meC.updateHealthCenterDescriptors(isPreviewMode,previewContObj);
		}
		else
		{
			meC.updateHealthCenterServers(isPreviewMode,previewContObj);
		}
	},

	updateHealthCenterServers : function(isPreviewMode,previewContObj) {
		var meC = this;
		var addMetricsObj = null;
		if(previewContObj!=null && previewContObj=='filterPopup')
		{
			addMetricsObj=Ext.getCmp('filterPopupWindow');
			previewContObj='';
		}
		else
		{
			addMetricsObj=this.getWidgetOptionsWindow();
		}
		var configForm = addMetricsObj.getComponent('configForm').getForm();

		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		var blockId = addMetricsObj.widgetID;
		var configPanl = Ext.getCmp(blockId);

		var categoryOptsValue = configForm.findField('categoryOpts').getValue();
		var healthCenterComponentComboValue = configForm.findField('healthCenterComponentCombo').getValue();
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		var paramsForSave = "action=saveHealthCenterDataServerConfig&profileName=" +encodeURIComponent(tmpProfNam) + "&blockId=" + blockId +"&category=" + encodeURIComponent(categoryOptsValue);

		if(categoryOptsValue == 'Components' || categoryOptsValue == 'vms|desktop|users')
		{	
			var healthCenterCompTypeComboValue = configForm.findField('healthCenterCompTypeCombo').getValue();			
		
			if (healthCenterCompTypeComboValue != null && healthCenterCompTypeComboValue == '-1') 
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : compTypAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			if(Ext.isEmpty(healthCenterComponentComboValue) || healthCenterComponentComboValue == '' || healthCenterComponentComboValue == '-1')
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Please choose a component',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			if(healthCenterComponentComboValue.includes('allServers') && healthCenterComponentComboValue.length > 1)
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Individual components cannot be choosen if All Components option selected',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			healthCenterComponentComboValue=meC.filterEncode(healthCenterComponentComboValue);
			paramsForSave = paramsForSave+"&compType=" + encodeURIComponent(healthCenterCompTypeComboValue)+"&components="+encodeURIComponent(healthCenterComponentComboValue);

			if(categoryOptsValue == 'vms|desktop|users')
			{
				var selVms=Ext.getCmp('vmListCombo').getValue();

				if(Ext.isEmpty(selVms) || selVms == '' || selVms == '-1')
				{
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : addVMs,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}

				if(selVms.includes('allVms') && selVms.length > 1)
				{
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : allVMsSelectonAlert,
						buttons : Ext.MessageBox.OK,
						icon : 'iconExclamation'
					});
					return;
				}
				if(!Ext.isEmpty(selVms))
				{
					var selVmsLen= selVms.length;
					var selVmsStr='';
					for(var v=0;v<selVmsLen;v++)
					{
						var vmStr=selVms[v];
						selVmsStr=selVmsStr+","+meC.filterEncode(vmStr);
					}
					paramsForSave = paramsForSave+"&vms=" + encodeURIComponent(selVmsStr);
				}
				
				var showDescOptObj=configForm.findField('showDescOpt').getValue();
				var showServersOptObj=configForm.findField('showServersOpt').getValue();
				var showDescOpt = 'no';
				if(showDescOptObj!=null && showDescOptObj==true)
				{
					showDescOpt='yes';
				}
				var showServersOpt = 'no';
				if(showServersOptObj!=null && showServersOptObj==true)
				{
					showServersOpt='yes';
				}

				paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt;
			}

			if(categoryOptsValue == 'Components')
			{
				var enableLegendOptObj = Ext.getCmp('enableLegendOpt');
				var enableLegendOption='';
				if(enableLegendOptObj != null && enableLegendOptObj != "" && enableLegendOptObj != undefined)
				{
					enableLegendOption=enableLegendOptObj.getValue();
				}
				var showLegends='';
				if(enableLegendOption != null && enableLegendOption == true)
				{
					showLegends="yes";
				}
				else
				{
					showLegends="no";
				}
				
				paramsForSave = paramsForSave+"&showLegends="+ encodeURIComponent(showLegends);
			}

		}
		else if(categoryOptsValue == 'Zone' || categoryOptsValue == 'Segment' || categoryOptsValue == 'Service' || categoryOptsValue == 'ComponentType')
		{		
			if(Ext.isEmpty(healthCenterComponentComboValue) || healthCenterComponentComboValue == '' || healthCenterComponentComboValue == '-1')
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Please choose a '+categoryOptsValue,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			if(healthCenterComponentComboValue.includes('ALL') && healthCenterComponentComboValue.length > 1)
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Individual '+ categoryOptsValue +'s cannot be added if ALL option selected',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
			healthCenterComponentComboValue=meC.filterEncode(healthCenterComponentComboValue);
			paramsForSave = paramsForSave+"&components=" + encodeURIComponent(healthCenterComponentComboValue);
			
			var enableLegendOptObj = Ext.getCmp('enableLegendOpt');
			var enableLegendOption='';
			if(enableLegendOptObj != null && enableLegendOptObj != "" && enableLegendOptObj != undefined)
			{
				enableLegendOption=enableLegendOptObj.getValue();
			}
			var showLegends='';
			if(enableLegendOption != null && enableLegendOption == true)
			{
				showLegends="yes";
			}
			else
			{
				showLegends="no";
			}
			paramsForSave = paramsForSave+"&showLegends="+ encodeURIComponent(showLegends);
		}
		else if(categoryOptsValue == 'all') 
		{
			var enableLegendOptObj = Ext.getCmp('enableLegendOpt');
			var enableLegendOption='';
			if(enableLegendOptObj != null && enableLegendOptObj != "" && enableLegendOptObj != undefined)
			{
				enableLegendOption=enableLegendOptObj.getValue();
			}
			var showLegends='';
			if(enableLegendOption != null && enableLegendOption == true)
			{
				showLegends="yes";
			}
			else
			{
				showLegends="no";
			}
			paramsForSave = paramsForSave+"&showLegends="+ encodeURIComponent(showLegends);
		}

		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
				
		if(!isPreviewMode)
		{
			addMetricsObj.close();			
		}
		gridStackObj=null;
		delete gridStackObj;

		if(isPreviewMode)
		{
			configPanl = previewContObj;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}

		iAjax
			.request({
				url : '/final/servlet/com.eg.egMyDashboardController',
				method : 'POST',
				params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
				scope : this,
				success : function(response) {
					meC.getPortlet().setRefresh(configPanl);
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						if(!isPreviewMode)
						{
							meC.getPortlet().setRefresh(configPanl);
						}
						var jsonData = Ext.decode(jsonText);
						configPanl.isInitialResizeCompleted=false;
						configPanl.isHighChartUpdate=false;
						configPanl.isExternalDataSourceWidget=false;
						var updateBxId=blockId;
						if(isPreviewMode)
						{
							updateBxId=blockId+"_previewImage";
						}
						configPanl.isConfigured=true;
						myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
						//meC.showLiveDataForBlock(jsonData, configPanl, blockId);
					}
				},
				failure : function(response, opts) {
					if (response.timedout) {
						configPanl.removeAll();
						configPanl
								.add({
									xtype : 'panel',
									html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
											+ (configPanl.getHeight() - 20)
											+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
											+ requestTimeoutMsg + '</div></td></tr></table></div>'
								});
						configPanl.doLayout();
					}
				}
			});
	},

	addHealthCenterDescriptors : function(btn) {

		var meC = this;
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();
		var healthCenterCompTypeComboValue = configForm.findField('healthCenterCompTypeCombo').getValue();	
		
		if (healthCenterCompTypeComboValue != null && healthCenterCompTypeComboValue == '-1') 
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		var healthCenterComponentScrollComboValue = configForm.findField('healthCenterCompScrollCombo').getValue();
		
		if(Ext.isEmpty(healthCenterComponentScrollComboValue) || healthCenterComponentScrollComboValue == '' || healthCenterComponentScrollComboValue == '-1')
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : componentAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		var healthCenterTestScrollComboValue = configForm.findField('healthCenterTestScrollCombo').getValue();
				
		if(Ext.isEmpty(healthCenterTestScrollComboValue) || healthCenterTestScrollComboValue == '' || healthCenterTestScrollComboValue == '-1')
		{
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : testAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		var healthCenterDescriptorsValue = configForm.findField('healthCenterComponentCombo').getValue();
		
		if ((healthCenterDescriptorsValue != null && healthCenterDescriptorsValue == '') || (healthCenterDescriptorsValue == '-1')) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : descriptorAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		this.addGridForHealth();
	},

	addGridForHealth : function() 
	{
		var addMetricsObj = this.getWidgetOptionsWindow();
		var configForm = addMetricsObj.getComponent('configForm').getForm();

		var healthCenterCompTypeComboValue = configForm.findField('healthCenterCompTypeCombo').getValue();	
		var selectedComp = configForm.findField('healthCenterCompScrollCombo').getValue();
		var dispComp = configForm.findField('healthCenterCompScrollCombo').getRawValue();

		var selectedTest = configForm.findField('healthCenterTestScrollCombo').getValue();
		var displayTest = configForm.findField('healthCenterTestScrollCombo').getRawValue();
		var descriptors = configForm.findField('healthCenterComponentCombo').getValue();
		
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var configuredData = [];

		var checkAllDescriptors = false;
		
		for ( var desc in descriptors) {
			var selectedDesc = descriptors[desc];
			var isAllDescriptors = false;
			if (selectedDesc != null && selectedDesc == 'allDescriptors') {
				isAllDescriptors = true;
				checkAllDescriptors = true;
			}
			if (selectedDesc == "-1" || selectedDesc == "")
				selectedDesc = "+";
			var tempDesc = "+";
			var dispDesc = "+";
			if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
				tempDesc = selectedDesc.substring(1);
			}
			if(isAllDescriptors)
			{
				tempDesc = "AllInfos";
				dispDesc = allDescriptors;
			}else{

				dispDesc = tempDesc;
			}

			if(checkAllDescriptors && !isAllDescriptors)
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : allDescriptorsAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			var hidVal = selectedComp+ "|$|" +dispComp+ "!@!" + selectedTest + "|$|" + displayTest+ "!@!" + tempDesc;
			var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
			if (getIdx == -1) {
				configuredData.push({
					component : dispComp,
					test : displayTest,
					descriptor : dispDesc,
					hidVal : hidVal
				});
			} else {
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'selection already exists',
					buttons : Ext.MessageBox.OK,
					icon : 'iconExclamation'
				});
				return;
			}
		}
		gridStore.add(configuredData);
		gridObj.doLayout();
	},
	
	updateHealthCenterDescriptors : function(isPreviewMode,previewContObj) {
		
		var meC = this;
		var addMetricsPopup = this.getWidgetOptionsWindow();
		var configForm = addMetricsPopup.getComponent('configForm').getForm();
		var categoryOptsValue = configForm.findField('categoryOpts').getValue();
		
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var configuredValues = '';
		var configuredMeasures = '';
		var configuredComponents = '';
		var configuredDescriptors = '';
		var componentDisplayNames = '';
		var descriptorDisplayNames = '';
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		for ( var i = 0; i < gridRecordCount; i++) {
			var hidVal = gridObj.getStore().getAt(i).get('hidVal');
			if (configuredValues.indexOf(hidVal) == -1) {
				configuredValues = configuredValues + "," + hidVal;
			}

			if (configuredValues != null && configuredValues.indexOf(",") == 0) {
				configuredValues=configuredValues.substring(1);
			}
			
		}
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var profileName = dashLayoutObj.profileName;
		var blockId = addMetricsPopup.widgetID;
		var configPanl = Ext.getCmp(blockId);

		configuredValues = meC.filterEncode(configuredValues);
		var tmpProfNam=profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=meC.filterEncode(tmpProfNam);
		}
		paramsForSave = "action=saveHealthCenterDataServerConfig&profileName=" + encodeURIComponent(tmpProfNam) + "&blockId=" + blockId + "&category=" + encodeURIComponent(categoryOptsValue) +"&configuredValues="
					+ encodeURIComponent(configuredValues);


		var showDescOptObj=configForm.findField('showDescOpt').getValue();
		var showServersOptObj=configForm.findField('showServersOpt').getValue();
		var showDescOpt = 'no';
		if(showDescOptObj!=null && showDescOptObj==true)
		{
			showDescOpt='yes';
		}
		var showServersOpt = 'no';
		if(showServersOptObj!=null && showServersOptObj==true)
		{
			showServersOpt='yes';
		}
		/*if(showServersOpt == 'no' && showDescOpt == 'no')
		{

			Ext.Msg.show({
				title : myDashboardAlertLbl,
				msg : legendTypeAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : 'iconExclamation'
			});
			return;
		}*/

		paramsForSave = paramsForSave+'&showDescriptors='+showDescOpt+'&showServers='+showServersOpt;

		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		if(!isPreviewMode)
		{
			addMetricsPopup.close();
		}

		if(isPreviewMode)
		{
			configPanl = previewContObj;
			paramsForSave=paramsForSave+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		
		iAjax
			.request({
				url : '/final/servlet/com.eg.egMyDashboardController',
				method : 'POST',
				params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
				scope : this,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						
						if(!isPreviewMode)
						{
							meC.getPortlet().setRefresh(configPanl);
						}
						meC.getPortlet().setRefresh(configPanl);
						var jsonData = Ext.decode(jsonText);
						configPanl.isInitialResizeCompleted=false;
						configPanl.isHighChartUpdate=false;
						configPanl.isExternalDataSourceWidget=false;
						var updateBxId=blockId;
						if(isPreviewMode)
						{
							updateBxId=blockId+"_previewImage";
						}
						configPanl.isConfigured=true;
						//meC.showLiveDataForBlock(jsonData, configPanl, blockId);
						myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, updateBxId);
						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				},
				failure : function(response, opts) {
					if (response.timedout) {
						if (blockType != null && blockType == 'TimelineChart' || blockType == 'areaChart' || blockType=='combinationChart' || blockType == 'TrendGraph') {
							configPanl
									.update('<table width="100%" height="'
											+ (configPanl.getHeight() - 20)
											+ '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
											+ requestTimeoutMsg + '</div></div></td></tr></table>');
						} else {
							configPanl.removeAll();
							configPanl
									.add({
										xtype : 'panel',
										html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
												+ (configPanl.getHeight() - 20)
												+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
												+ requestTimeoutMsg + '</div></td></tr></table></div>'
									});
						}
						configPanl.doLayout();
					}
				}
			});
	},
	
	onChangeDDChartType : function(chartTypeComboObj)
	{
		var selectedChartTypeValue = chartTypeComboObj.getValue();
		var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
		var ddColumnsComboLbl = Ext.getCmp('ddColumnsComboLbl');
		var viewTypeObj = Ext.getCmp('ViewType');
		var timeLineObj = Ext.getCmp('Timeline');
		var showChartSummarySwitchVal = Ext.getCmp('showChartSummary');

		if(selectedChartTypeValue != null && selectedChartTypeValue == 'Bar Chart')
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.hide();
				showChartSummarySwitchVal.up('container').hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				timeLineObj.hide();
				timeLineObj.up('container').hide();
			}
			if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
			{
				summarizeDDColumnObj.show();
				summarizeDDColumnObj.setValue('-1');
				summarizeDDColumnObj.up('container').show();
				viewTypeObj.show();
				viewTypeObj.up('container').show();

				if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
				{
					var viewTypeVal = viewTypeObj.getValue();
					if(viewTypeVal!=null && viewTypeVal == 'Vertical')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
						ddColumnsComboLbl.setText('DD Columns (Y axis)');
					}
					else if(viewTypeVal!=null && viewTypeVal == 'Horizontal')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
						ddColumnsComboLbl.setText('DD Columns (X axis)');
					}
				}
			}			
		}
		else if(selectedChartTypeValue != null && (selectedChartTypeValue == 'Time Line' || selectedChartTypeValue == 'Area'))
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.show();
				showChartSummarySwitchVal.up('container').show();
			}
			if(viewTypeObj != null && !Ext.isEmpty(viewTypeObj))
			{
				viewTypeObj.hide();
				viewTypeObj.up('container').hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				var timelineComboStore=timeLineObj.getStore();
				timelineComboStore.removeAll();
				var timelineOpts=timeLineObj.timelineOpts;
				timelineComboStore.loadRawData(timelineOpts);
				var selectedValue=timeLineObj.selectedValue;
				if(Ext.isEmpty(selectedValue))
					selectedValue="1 hour";
			
				timeLineObj.setValue(selectedValue);
				timeLineObj.show();
				timeLineObj.up('container').show();
				var timeLineObjContainer = timeLineObj.up('container');
				Ext.defer(function(){
					$('#'+timeLineObjContainer.id).css({'border-width': '1px 0px 1px 0px'})
				},500);
			}
			
			if(!Ext.isEmpty(ddColumnsComboLbl) && !Ext.isEmpty(summarizeDDColumnObj))
			{
				summarizeDDColumnObj.setFieldLabel('Summarize DD Data By');
				ddColumnsComboLbl.setText('DD Columns');
			}
			if(!Ext.isEmpty(summarizeDDColumnObj))
			{
				summarizeDDColumnObj.show();
				summarizeDDColumnObj.setValue('-1');
				summarizeDDColumnObj.up('container').show();
			}
		}
		else
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.hide();
				showChartSummarySwitchVal.up('container').hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				var timelineComboStore=timeLineObj.getStore();
				var timelineRec = timelineComboStore.findRecord(timeLineObj.valueField, 'recent', 0, false, true, true);
				var tIdx = timelineComboStore.indexOf(timelineRec);
				if(tIdx==-1)
				{
					var timelineOpts=timeLineObj.timelineOpts;
					var selectedValue=timeLineObj.selectedValue;
					var timlineArr=[];
					timlineArr.push({
						displayField : 'Latest',
						valueField : 'recent'
					});
					if(!Ext.isEmpty(timelineOpts))
					{
						for(var tOpt in timelineOpts)
						{
							timlineArr.push(timelineOpts[tOpt]);
						}
					}
					timelineComboStore.loadRawData(timlineArr);
					if(Ext.isEmpty(selectedValue))
						selectedValue='recent';

					timeLineObj.setValue(selectedValue);
				}
			//	timeLineObj.setValue('recent');
				timeLineObj.show();
				timeLineObj.up('container').show();
			}
			if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
			{
				summarizeDDColumnObj.hide();
				viewTypeObj.hide();
				summarizeDDColumnObj.up('container').show();
				viewTypeObj.up('container').hide();
			}

			var ddColumnsComboLbl = Ext.getCmp('ddColumnsComboLbl');
			if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
			{
				ddColumnsComboLbl.setText('DD Columns');
			}
		}	
	},
	onSearchTriggerclick : function(textboxObj) {
		var blockId = textboxObj.widgetID;
		var configPanl=Ext.getCmp(blockId);
		var viewDashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=viewDashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForData = '&action=loadBlockData&profileName=' +encodeURIComponent(tmpProfNam)+ '&blockId=' + blockId ;
		var meC = this;
		if (isAnonymousUserAccess) {
			paramsForData = paramsForData + '&anonymousUser=true';
		}
		var searchStr='none';

		var searchStrCont= textboxObj.getValue();

		if(!Ext.isEmpty(searchStrCont))
		{
			searchStr=searchStrCont;
		}
		if(!Ext.isEmpty(searchStr))
		{
		  searchStr=this.filterEncode(searchStr);
		}

		configPanl.setLoading(true, true);

		paramsForData = paramsForData + '&searchString='+encodeURIComponent(searchStr);	

		iAjax.request({
			url : '/final/servlet/com.eg.egMyDashboardController',
			method : 'POST',
			params : paramsForData + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					configPanl.isInitialResizeCompleted=false;
					configPanl.isHighChartUpdate=false;
					myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, blockId);
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				if (response.timedout) {
					configPanl.removeAll();
					configPanl
							.add({
								xtype : 'panel',
								html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="'
										+ (configPanl.getHeight() - 20)
										+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">'
										+ requestTimeoutMsg + '</div></td></tr></table></div>'
							});
				//	configPanl.setLoading(false);
					configPanl.doLayout();
				}
			}
		});
	},
	showAlarmFilterPopup : function(blockId)
	{
		var meC=this;
		try
		{
			var profName = Ext.getCmp('dashboardLayoutObj').profileName;
			var tmpProfNam=profName;
			if(!Ext.isEmpty(tmpProfNam))
			{
				tmpProfNam=this.filterEncode(tmpProfNam);
			}
			var reqPrms='action=getAlarmsFilterOptions&comesFrom=myDashboard&profileName='+encodeURIComponent(tmpProfNam);
			if (isAnonymousUserAccess) {				
				reqPrms = reqPrms + '&anonymousUser=true';
			}
			Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
			method : 'POST',
			params: reqPrms,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					var filterOptsJson=[];
					var prioirtyFilterOpt=[];
					var compTypesFilterOpt=[];

					filterOptsJson=jsonData['alarmFilterOptions']['filterOptsJson'];
					prioirtyFilterOpt=jsonData['alarmFilterOptions']['prioirtyFilterOpt'];
					compTypesFilterOpt=jsonData['alarmFilterOptions']['selectedTyps'];
			

					var almFilterPopup=Ext.create('Ext.window.Window', {
						resizable:false,
						ui:'newPopupWindow widgetOptionsWindowHeader',
						cls:'myDashboardwindow',
						width:'420px',
						draggable: true,
						title : screenLabelsObj['AlarmFilterSettingsLbl'],
						id : "AlarmFilterPopup",
						closeAction: 'destroy',
						modal:true,
						renderTo:Ext.getBody(),
						//height:'250px',
						bodyPadding : '10',
						items:[
							{
								xtype: 'container',
								layout: { type : 'hbox', align : 'stretch' },
								items : [
											{
												xtype: 'container',
												margin : '10',
												items: [
													{
														xtype: 'scrollcombo',
														fieldLabel: screenLabelsObj['FilterBy'],
														labelAlign:'top',
														emptyText: '',
														labelSeparator:'',
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode : 'local',
														id : 'alarmFilterOpts',
														width:140,
														store:new Ext.data.Store({
																		fields: ['valueField','displayField'],
																		data: filterOptsJson
														}),
														editable : true,
														forceSelection:true,
														listeners : {
																'select' : function(cmbObj)
																{
																	var selectedFilterOpt=cmbObj.getValue();

																	if(selectedFilterOpt!=null && selectedFilterOpt=='filterByPriority')
																	{
																		var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
																		if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
																		{
																			alarmSubFilterMultiSelectContObj.hide();
																		}
																		var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
																		if(!Ext.isEmpty(alarmSubFilterOptsObj))
																		{
																			alarmSubFilterOptsObj.setFieldLabel('Priority');
																			
																			alarmSubFilterOptsObj.getStore().loadRawData(prioirtyFilterOpt);
																			var selectedVal=alarmSubFilterOptsObj.getValue();
																			if(Ext.isEmpty(selectedVal))
																			{
																				alarmSubFilterOptsObj.setValue("all");
																			}
																			alarmSubFilterOptsObj.show();
																		}
																	}
																	else if(selectedFilterOpt!=null && selectedFilterOpt=='filterByComponentType')
																	{
																		
																		var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
																		if(!Ext.isEmpty(alarmSubFilterOptsObj))
																		{
																			alarmSubFilterOptsObj.hide();
																		}
																		var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
																		if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
																		{
																			alarmSubFilterMultiSelectContObj.show();
																		}										
																	}
																	else if(selectedFilterOpt!=null && (selectedFilterOpt=='filterByZone' || selectedFilterOpt=='filterBySegment' || selectedFilterOpt=='filterByService'))
																	{
																		meC.getOptionsForInfraElement(profName,selectedFilterOpt,blockId);
																		
																	}
																}

														}
													}
												]
											},
											{
												xtype: 'container',
												margin : '10',
												items: [
													{
														xtype: 'scrollcombo',
														fieldLabel: screenLabelsObj['PriorityLbl'],
														labelAlign:'top',
														emptyText: '',
														labelSeparator:'',
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode : 'local',
														id : 'alarmSubFilterOpts',
														name : 'alarmSubFilterOpts',
														width:140,
														store:new Ext.data.Store({
																		fields: ['valueField','displayField'],
																		data: prioirtyFilterOpt
														}),
														editable : true,
														forceSelection:true,
													}
												]
											},
											{
												xtype: 'container',						
												id:'alarmSubFilterMultiSelectCont',
												margin : '10',
												layout:{type:'vbox',align:'stretch'},
												hidden : true,
												items: [
														 {
															xtype : 'label',
															id : 'alarmCompTypesLbl',
															name : 'alarmCompTypesLbl',
															text : componentTypeLbl,
															width : 200
														},
														{
															xtype:'container',
															layout:{type:'vbox',align:'stretch'},
															width : 200,
															cls:'darkbox',
															height:145,
															items:[{
																xtype:'trigger',
																margin : '5',
																id : 'alarmCompTypesSearchTextBox',
																name : 'alarmCompTypesSearchTextBox',
																width : 178,
																cls: 'whitedropdown_search',
																emptyText : 'Search',
																componentStore : null,
																listeners :
																{
																	'change' : function(triggerField, newValue, oldValue, eOpts) {
																		var me = this;
																		var compntStore = me.componentStore;
																		if(compntStore==null)
																		{
																			me.componentStore = Ext.getCmp('alarmSubFilterMultiSelectOpts').getStore();
																			compntStore = me.componentStore;
																		}
																		if(newValue=="*")
																		{
																			compntStore.clearFilter();
																		}
																		else
																		{
																			if(newValue.lastIndexOf("*")==(newValue.length-1))
																			{
																				newValue = newValue.substr(0,(newValue.length-1));
																			}
																			compntStore.clearFilter();
																			if (newValue) {
																				var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
																				compntStore.filter({
																					filterFn: function(record) {
																						return matcher.test(record.get('displayField')) ;
																					}
																				});
																			}
																		 triggerField.focus();
																		}
																	 }
																}
															},{
																xtype: 'multiselect',
																id: 'alarmSubFilterMultiSelectOpts',
																baseCls: 'egmultiselect',
																name: 'alarmSubFilterMultiSelectOpts',
																multiSelect: true,
																height:106,
																store: Ext.create('Ext.data.Store', {
																	fields: ['displayField', 'valueField','editedCompName'],
																	data: compTypesFilterOpt
																}),
																fieldLabel : '',
																labelAlign:'top',
																editable: false,
																displayField: 'displayField',
																valueField: 'valueField',
																queryMode: 'local',
																listConfig: {
																	id: 'alarmSubFilterMultiSelectOptsC',
																	name: 'alarmSubFilterMultiSelectOptsC',
																	simpleSelect: true
																}
															}]
														}]
											}]
							},
							{
								xtype : 'button',
								id:'applyButton',
								text : 'Apply',
								//height : 20,
								width : 70,
								margin:'0 20 0 180',
								padding:'0',
								cls : 'buttonNewBig',
								handler : function()
								{
									var profName = Ext.getCmp('dashboardLayoutObj').profileName;
									var alarmWidgObj=Ext.getCmp(blockId);
									var selectedFilterOption=Ext.getCmp('alarmFilterOpts').getValue();
									//Ext.state.Manager.set(profName + "_" + blockId + "_filterby", selectedFilterOption);
									var alarmSubFilterOpts="";
									if(selectedFilterOption!=null && selectedFilterOption=='filterByPriority')
									{
										alarmSubFilterOpts=Ext.getCmp('alarmSubFilterOpts').getValue();
										//Ext.state.Manager.set(profName + "_" + blockId + "_selectedSubFilterOpt", alarmSubFilterOpts);
									}
									else if(selectedFilterOption!=null && selectedFilterOption=='filterByComponentType')
									{
										alarmSubFilterOpts=Ext.getCmp('alarmSubFilterMultiSelectOpts').getValue();
										if (Ext.isEmpty(alarmSubFilterOpts) || alarmSubFilterOpts == '-1') {
											Ext.Msg.show({
												title : myDashboardAlertLbl,
												msg : compTypAlertMsg,
												buttons : Ext.MessageBox.OK,
												icon : 'iconExclamation'
											});
											return;
										}
										if(alarmSubFilterOpts!=null && (alarmSubFilterOpts.length>1) && alarmSubFilterOpts.indexOf('allTypes')>-1){
											Ext.Msg.show({
												title : myDashboardAlertLbl,
												msg : individualCompTypsCannotAdd,
												buttons : Ext.MessageBox.OK,
												icon : 'iconExclamation'
											});
											return;
										} 
									//	Ext.state.Manager.set(profName + "_" + blockId + "_selectedSubFilterOpt", alarmSubFilterOpts);
									}
									else if(selectedFilterOption!=null && (selectedFilterOption=='filterByZone' || selectedFilterOption=='filterBySegment' || selectedFilterOption=='filterByService'))
									{
										alarmSubFilterOpts=Ext.getCmp('alarmSubFilterOpts').getValue();
//										Ext.state.Manager.set(profName + "_" + blockId + "_selectedSubFilterOpt", alarmSubFilterOpts);
									}
									Ext.getCmp('AlarmFilterPopup').close();
									
									meC.applyAlarmFilterSettings(alarmWidgObj,profName,blockId,selectedFilterOption,alarmSubFilterOpts);
									//myDashApp.getController("Main").loadDataForBlock(alarmWidgObj, profName, blockId,true);
								}
							}
						],
						listeners : {
							'afterrender': function(alarmWinObj)
							{
								var profName = Ext.getCmp('dashboardLayoutObj').profileName;
								var alarmWidgObj=Ext.getCmp(blockId);
//								var selectedFilterOption=Ext.state.Manager.get(profName + "_" + blockId + "_filterby");
//								var selectedSubFilterOption=Ext.state.Manager.get(profName + "_" + blockId + "_selectedSubFilterOpt");
							/*	if(Ext.isEmpty(selectedFilterOption))
								{ */
									selectedFilterOption=alarmWidgObj.selectedFilterOption;
//								}
							/*	if(Ext.isEmpty(selectedSubFilterOption))
								{ */
									selectedSubFilterOption=alarmWidgObj.selectedSubFilterOption;
							//	}

								var alarmFilterOptsObj=Ext.getCmp('alarmFilterOpts');
								if(!Ext.isEmpty(alarmFilterOptsObj))
								{
									alarmFilterOptsObj.setValue(selectedFilterOption);
								}
								if(selectedFilterOption!=null && selectedFilterOption=='filterByPriority')
								{
									var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
									if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
									{
										alarmSubFilterMultiSelectContObj.hide();
									}
									var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
									if(!Ext.isEmpty(alarmSubFilterOptsObj))
									{
										if(Ext.isEmpty(selectedSubFilterOption))
										{
											selectedSubFilterOption="all";
										}
										
										alarmSubFilterOptsObj.setValue(selectedSubFilterOption);
										alarmSubFilterOptsObj.show();
									}
								}
								else if(selectedFilterOption!=null && selectedFilterOption=='filterByComponentType')
								{
									var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
									if(!Ext.isEmpty(alarmSubFilterOptsObj))
									{
										alarmSubFilterOptsObj.hide();
									}
									var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
									if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
									{
										var alarmSubFilterOpts=Ext.getCmp('alarmSubFilterMultiSelectOpts')
										alarmSubFilterOpts.setValue(selectedSubFilterOption);
										alarmSubFilterMultiSelectContObj.show();
									}										
								}
								else if(selectedFilterOption!=null && (selectedFilterOption=='filterByZone' || selectedFilterOption=='filterBySegment' || selectedFilterOption=='filterByService'))
								{
									var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
									if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
									{
										alarmSubFilterMultiSelectContObj.hide();
									}
									meC.getOptionsForInfraElement(profName,selectedFilterOption,blockId);
									var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
									if(!Ext.isEmpty(alarmSubFilterOptsObj))
									{
										if(Ext.isEmpty(selectedSubFilterOption))
										{
											selectedSubFilterOption="ALL";
										}
										alarmSubFilterOptsObj.setValue(selectedSubFilterOption);
										alarmSubFilterOptsObj.show();
									}
								}
							}

						}
						
					});

					almFilterPopup.show();
				}
			}
			});
		}
		catch (ap)
		{
			console.log("error ",ap);
		}
	},
	getOptionsForInfraElement : function(dashboardName,selectedFilterOpt,blockId)
	{
		try
		{
			var profName=dashboardName;
			var selectedInfraElement='';
			if(selectedFilterOpt!=null && selectedFilterOpt=='filterByZone')
			{
				selectedInfraElement='Zone';
			}
			else if(selectedFilterOpt!=null && selectedFilterOpt=='filterBySegment')
			{
				selectedInfraElement='Segment';
			}
			else if(selectedFilterOpt!=null && selectedFilterOpt=='filterByService')
			{
				selectedInfraElement='Service';
			}
			if(!Ext.isEmpty(dashboardName))
			{
				dashboardName=this.filterEncode(dashboardName);
			}
			var alarmWidgObj=Ext.getCmp(blockId);
			var reqPrms='C=True&P0={'+selectedInfraElement+'}&P1={'+dashboardName+'}&F=getOptionsForTypeJSON&calljson=true';
			Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params: reqPrms,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					var alarmSubFilterMultiSelectContObj=Ext.getCmp('alarmSubFilterMultiSelectCont');
					if(!Ext.isEmpty(alarmSubFilterMultiSelectContObj))
					{
						alarmSubFilterMultiSelectContObj.hide();
					}
					var alarmSubFilterOptsObj=Ext.getCmp('alarmSubFilterOpts');
					if(!Ext.isEmpty(alarmSubFilterOptsObj))
					{
						
						var infElementsArr=jsonData['optionsForType'];
						if(!Ext.isEmpty(infElementsArr))
						{
							var selectedSubFilterOption='';//Ext.state.Manager.get(profName + "_" + blockId + "_selectedSubFilterOpt");
							if(!Ext.isEmpty(alarmWidgObj))
							{
								selectedSubFilterOption=alarmWidgObj.selectedSubFilterOption;
							}
							alarmSubFilterOptsObj.suspendEvents(false);
							alarmSubFilterOptsObj.setFieldLabel(selectedInfraElement);
							alarmSubFilterOptsObj.getStore().loadRawData(jsonData['optionsForType']);
							if(Ext.isEmpty(selectedSubFilterOption))
							{
								selectedSubFilterOption="ALL";
							}
							alarmSubFilterOptsObj.setValue(selectedSubFilterOption);
						/*	var selectedVal=alarmSubFilterOptsObj.getValue();
							if(Ext.isEmpty(selectedVal))
							{
								selectedSubFilterOption="ALL";
								alarmSubFilterOptsObj.setValue(selectedSubFilterOption);
							}*/
							alarmSubFilterOptsObj.resumeEvents();
							alarmSubFilterOptsObj.show();
						}
					}
				}
			}
			});
		}
		catch (excp)
		{
			console.log("Exception when trying to get options for infra element---->"+selectedFilterOpt);
		}
	},
	applyAlarmFilterSettings : function(configPanl,profName,blockId,selectedFilterOpt,selectedSubFilterOpt)
	{
		try
		{
			
			var prfNam=profName;
			if(!Ext.isEmpty(prfNam))
			{
				prfNam=this.filterEncode(prfNam);
			}
			if(!Ext.isEmpty(selectedFilterOpt))
			{
				selectedFilterOpt=this.filterEncode(selectedFilterOpt);
			}
			if(!Ext.isEmpty(selectedSubFilterOpt))
			{
				selectedSubFilterOpt=this.filterEncode(selectedSubFilterOpt);
			}
			
			var paramsForData = 'action=applyAlarmFilterSettings&profileName=' + encodeURIComponent(prfNam) + '&blockId=' + blockId;
			paramsForData = paramsForData + '&selectedFilterOption=' + encodeURIComponent(selectedFilterOpt);
			paramsForData = paramsForData + '&selectedSubFilterOption=' + encodeURIComponent(selectedSubFilterOpt);
			
			iAjax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForData + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') 
						{
							var jsonData = Ext.decode(jsonText);
							myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, blockId);
							jsonData=null;
						}
					}
			});
		}
		catch (excp)
		{
		}
	},
	createWidgetFilterpopup : function()
	{
		var thisWidgetID=this.widgetID;
		
		var widgetPnlObj=Ext.getCmp(thisWidgetID);
		
		var componentarr = new Array();

			var compmultiselectLable ={
				xtype: 'label',
				id: 'healthCenterComponentComboLbl',
				name: 'healthCenterComponentComboLbl',
				margin:'0px 10px 0px 0px',
				style: {
					'font-family':'Roboto',
					'padding': '0 0 4px 0'
				},
				text:'Components',
				
			};

			var compmultiselectcont ={
				xtype:'container',
				layout:{type:'vbox',align:'stretch'},
				width : 230,
				cls:'darkbox',
				height:125,
				id:'compTypeBOX',
				items:[{
					xtype:'trigger',
					margin : '10',
					id : 'healthCenterComponentSearchTextBox',
					name : 'healthCenterComponentSearchTextBox',
					width : 178,
					cls: 'whitedropdown_search',
					emptyText : 'Search',
					componentStore : null,
					hidden : true,
					listeners :
					{
						'change' : function(triggerField, newValue, oldValue, eOpts) {
							var me = this;
							var compntStore = me.componentStore;
							if(compntStore==null)
							{
								me.componentStore = this.up('form').getForm().findField('healthCenterComponentCombo').getStore();
								compntStore = me.componentStore;
							}
							if(newValue=="*")
							{
								compntStore.clearFilter();
							}
							else
							{
								if(newValue.lastIndexOf("*")==(newValue.length-1))
								{
									newValue = newValue.substr(0,(newValue.length-1));
								}
								compntStore.clearFilter();
								if (newValue) {
									var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
									compntStore.filter({
										filterFn: function(record) {
											return matcher.test(record.get('displayField')) ;
										}
									});
								}
							 triggerField.focus();
							}
						 }
					}
				},{
					xtype: 'multiselect',
					id: 'healthCenterComponentCombo',
					baseCls: 'egmultiselect',
					name: 'healthCenterComponentCombo',
					multiSelect: true,
					height:82,
					hidden: true,
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField', 'valueField','editedCompName'],
						data: []
					}),
					editable: false,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listConfig: {
						id: 'componentListC',
						itemTpl: new Ext.XTemplate(
							'<tpl for=".">',
							'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
							'</tpl>'
						),
						listeners: {
						}
					}
				}]
			};

			componentarr.push(compmultiselectLable);
			componentarr.push(compmultiselectcont);
				 
		var infraHealthForm = {
					xtype: 'container',
					layout : {
						type : 'vbox',
						align :  'stretch'
					},
					autoScroll : true,
					width: 540,
				//	height: 202,
					flex:1,
					cls:'',
					margin:'0 0 0 0',
					padding:'0 0 0 0',
						items: [{
							xtype:'container',
							layout : {
									type : 'hbox'
								},
							padding:0,
							defaults:{
								margin: '10 0 10 20 ',
								labelWidth:'auto',
								labelSeparator:'',
								labelStyle: 'white-space: pre;'
							},
							items: [
								{
								xtype:'container',
								padding:0,
								defaults:{
									margin: '0 10 10 20 ',
									labelWidth:'auto',
									labelSeparator:'',
									labelStyle: 'white-space: pre;'
								},
								items: [{
										xtype: 'scrollcombo',
										id: 'categoryOpts',
										name: 'categoryOpts',
										hidden : false,
										selectOnTab: true,
										editable : true,
										forceSelection : true,
										labelAlign: 'top',
										width: 220,
										margin:'-5 0 10 0',
										fieldLabel :'Category',
										displayField: 'displayField',
										valueField: 'valueField',
										store: Ext.create('Ext.data.Store', {
											fields: ['displayField', 'valueField'],
											data: []
										}),
										lazyRender: true,
										editable: true,
										forceSelection:true,
										queryMode: 'local'
									},
										{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									labelAlign: 'top',
									fieldLabel: 'Component Type',
									id: 'healthCenterCompTypeCombo',
									name: 'healthCenterCompTypeCombo',
									hidden: true,
									width: 220,
									margin:'5 0 10 0',
									store: Ext.create('Ext.data.Store', {
										fields: ['displayField', 'valueField'],
										data: []
									}),
									editable: true,
									forceSelection:true,
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								},
								{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									fieldLabel: 'Component',
									labelAlign: 'top',
									id: 'healthCenterCompScrollCombo',
									name: 'healthCenterCompScrollCombo',
									hidden: true,
									width: 220,
									margin:'5 0 10 0',
									store: Ext.create('Ext.data.Store', {
										fields: ['displayField', 'valueField'],
										data: []
									}),
									editable: true,
									forceSelection:true,
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								},
								{
									xtype : 'switchfield',
									name: 'Enable Legend',
									id: 'enableLegendOpt',
									widgetID:thisWidgetID,
									defaults:{
										margin:'5 0 20 10',
									},
									labelWidth:100,
									//labelStyle: 'margin: 4px 0 10px 15px; padding: 0;font-family:LucidaGrandeBold',
								//	labelSeparator:'',
									fieldLabel: 'Enable Legend',
									inputValue: 'Yes',
									uncheckedValue:'No',
									margin:'4 0 0 0',
									width :200,
									vertical: false,
									checked:false
								}]	
						},
						{
							xtype:'container',
							padding:0,
							margin: '5 0 10 20 ',
							defaults:{
								margin: '0 0 10 0 ',
								labelWidth:'auto',
								labelSeparator:'',
								labelStyle: 'white-space: pre;'
							},
							items: [
								{
									xtype: 'container',
									layout:{type:'column',align:'left'},
									width: 260,
									flex:1,
									id:'healthCenterCompContiner',
									hidden:true,
									margin: '0 0 10 0',	
									items: componentarr
							   },
							   {
									xtype : 'button',
									width:80,
									text: addDispBtn,
									hidden:true,
									margin: '5 0 0 0',	
									id: 'addHealthCenter',
									name: 'addHealthCenter',
									cls: 'button20'
							}]
						}]
					}]
				};
				
			return {
					xtype: 'form', 
					id : 'configForm',
					width: '100%',
					flex:1,
					modal: true,
					autoScroll:false,
					layout : {
						type : 'vbox'
					},
					defaults: {
						labelAlign: 'top',
						labelSeparator:''
					},	
					bodyPadding:10,
					margin:'0 0 0 0',
					items: [
						{
							xtype:'panel',
							width: '100%',
							items:[{
								xtype:'container',
								width: '100%',
								layout : {
									type : 'hbox'
								},
								items: [infraHealthForm]
							}]
						}],
					dockedItems : [{
						xtype: 'toolbar',
						dock: 'bottom',
					//	cls:'egFooterNewConfigWin',
						height: 40,
						layout : {
							type:'hbox',
							pack:'center',

						},
						items: [{
									xtype : 'button',
									width:80,
									//height: 30,
									text: screenLabelsObj['applyFilters'],
//									margin: '5 0 0 0',
									padding :'2',
									id: 'applyFilterOpts',
									name: 'applyFilterOpts',
									cls: 'buttonNew'
							}]
					}]
						
					
				};

	},
	openFilterPopup : function(widgetID,widgetType)
	{
		try
		{
				var meC=this;
				var filterOptCont=meC.createWidgetFilterpopup();
			 	var almFilterPopup=Ext.create('Ext.window.Window', {
						resizable:false,
						ui:'newPopupWindow widgetOptionsWindowHeader',
						cls:'myDashboardwindow',
						width:'620px',
						draggable: false,
						title : screenLabelsObj['AlarmFilterSettingsLbl'],
						id : "filterPopupWindow",
						closeAction: 'destroy',
						modal:true,
						widgetID : widgetID,
						widgetType : widgetType,
						renderTo:Ext.getBody(),
						//height:'250px',
						bodyPadding : '10',
						items:filterOptCont,
						listeners : {

						'render': function()
						{
							meC.loadDefaultDataforFilterPopup();
							//this.callParent(this);
						}
						}
				});
				almFilterPopup.show();
						
		}
		catch (excp)
		{
			console.log(excp);
		}
	},
	loadDefaultDataforFilterPopup : function()
	{
		var meC=this;
		 var mePopup = Ext.getCmp('filterPopupWindow');
			var gridContainerObj = Ext.getCmp('gridContainer');
			var metricsFormPanelObj = Ext.getCmp('configForm');
			var metricsForm = metricsFormPanelObj.getForm();
			var editViewPage='dashboardLayoutObj';
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		/*	var thisWind = new Ext.LoadMask(mePopup.getEl(), {
				msg: "Loading .."
			});
			thisWind.show();*/
			var tmpProfNam=profileName;
			if(!Ext.isEmpty(tmpProfNam))
			{
				tmpProfNam=filterEncode(tmpProfNam);
			}
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method: 'POST',
				params: 'comesFrom=myDashboard&action=loadDataHealthConfigPopup&profileName=' + encodeURIComponent(tmpProfNam) + '&blockId=' + mePopup.widgetID  +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						this.suspendEvents(true);
						Ext.suspendLayouts();
						var configuredData = jsonData['configuredDetails'];
						var categoryType = '';
						var groupOption = '';

						if(mePopup.widgetType!=null && mePopup.widgetType=='networkhealth')
						{
							mePopup.setTitle(screenLabelsObj['filterSettingsLbl']);
						}
						else
						{
							mePopup.setTitle(screenLabelsObj['filterSettingsLbl']);
						}

						if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('categoryCombo') && configuredData.hasOwnProperty('selectedCategory')) 
						{
							var categoryOptsObj = metricsForm.findField('categoryOpts');
							categoryOptsObj.suspendEvents(true);
							categoryOptsObj.getStore().loadRawData(configuredData['categoryCombo']);
							categoryOptsObj.setValue(configuredData['selectedCategory']);
							categoryOptsObj.resumeEvents();
							categoryType = configuredData['selectedCategory'];
							if(!Ext.isEmpty(categoryType))
							{
								categoryType=categoryType.trim();
							}
						}
						
						if(categoryType == 'Components')
						{	
							var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
							enableLegendOptObj.isDefault=true;
							enableLegendOptObj.show();	
							var showLegends = configuredData['showLegends'];
							if(showLegends!=null && showLegends=="yes")
							{
								enableLegendOptObj.setValue(true);
							}
							else
							{
								enableLegendOptObj.setValue(false);
							}
							enableLegendOptObj.isDefault=false;
							if(!Ext.isEmpty(gridContainerObj))
							{
								gridContainerObj.hide();
							}
							var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
							var showDescOptObj = metricsForm.findField('showDescOpt');
							if(!Ext.isEmpty(showDescOptObj))
							{
								showDescOptObj.suspendEvents(false);
								showDescOptObj.setValue(true);
								showDescOptObj.resumeEvents();
							}
							if(!Ext.isEmpty(legandCheckBoxObj))
							{
								legandCheckBoxObj.hide();
							}
							if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('comptypes') && configuredData.hasOwnProperty('selectedCompType'))
							{
								var selectedCompType = configuredData['selectedCompType'];
								var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
								healthCenterCompTypeComboObj.suspendEvents(true);	
								healthCenterCompTypeComboObj.getStore().loadRawData(jsonData['comptypes']);
								if(selectedCompType == null || selectedCompType == '' || selectedCompType == '-1')
								{
									var compTypeStore = healthCenterCompTypeComboObj.getStore();
									compTypeStore.insert(0,{
										displayField:compTypAlertMsg,
										valueField: '-1'
									});
									healthCenterCompTypeComboObj.setValue('-1');
								}
								else
								{
									var compTypeStore = healthCenterCompTypeComboObj.getStore();
									compTypeStore.insert(0,{
										displayField:compTypAlertMsg,
										valueField: '-1'
									});
									healthCenterCompTypeComboObj.setValue(selectedCompType);
								}
								healthCenterCompTypeComboObj.resumeEvents();
								healthCenterCompTypeComboObj.show();
							}

							if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
							{
								var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
							}
						}
						else if(categoryType == 'vms|desktop|users')
						{	
							var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
							enableLegendOptObj.hide();
							var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
							legandCheckBoxObj.show();
							
							var showServersOptObj = metricsForm.findField('showServersOpt');
							showServersOptObj.suspendEvents(false);
							var showServers = configuredData['showServers'];
							if(showServers!=null && showServers=="yes")
							{
								showServersOptObj.setValue(true);
							}
							else
							{
								showServersOptObj.setValue(false);
							}
							showServersOptObj.resumeEvents();

							var showDescOptObj = metricsForm.findField('showDescOpt');
							showDescOptObj.suspendEvents(false);
							var showDescriptors = configuredData['showDescriptors'];
							if(showDescriptors!=null && showDescriptors=="yes")
							{
								showDescOptObj.setValue(true);
							}
							else
							{
								showDescOptObj.setValue(false);
							}
							showDescOptObj.resumeEvents();

							/*if(showServers!="yes" && showDescriptors!="yes")
							{
								showDescOptObj.suspendEvents(false);
								showDescOptObj.setValue(true);
								showDescOptObj.resumeEvents();
							}*/
							if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('comptypes') && configuredData.hasOwnProperty('selectedCompType'))
							{
								var selectedCompType = configuredData['selectedCompType'];
								var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
								healthCenterCompTypeComboObj.suspendEvents(true);	
								healthCenterCompTypeComboObj.getStore().loadRawData(jsonData['comptypes']);
								if(selectedCompType == null || selectedCompType == '' || selectedCompType == '-1')
								{
									var compTypeStore = healthCenterCompTypeComboObj.getStore();
									compTypeStore.insert(0,{
										displayField:compTypAlertMsg,
										valueField: '-1'
									});
									healthCenterCompTypeComboObj.setValue('-1');
								}
								else
								{
									var compTypeStore = healthCenterCompTypeComboObj.getStore();
									compTypeStore.insert(0,{
										displayField:compTypAlertMsg,
										valueField: '-1'
									});
									healthCenterCompTypeComboObj.setValue(selectedCompType);
								}
								healthCenterCompTypeComboObj.resumeEvents();
								healthCenterCompTypeComboObj.show();

								if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
								{

									healthCenterCompTypeComboObj.vmData = configuredData;
									var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
								}

							}

							if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
							{
								var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
							}
						}
						else if(categoryType == 'Descriptors')
						{
							var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
							enableLegendOptObj.hide();
							gridContainerObj.show();
							var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
							legandCheckBoxObj.show();

							var showServersOptObj = metricsForm.findField('showServersOpt');
							showServersOptObj.suspendEvents(false);
							var showServers = configuredData['showServers'];
							if(showServers!=null && showServers=="yes")
							{
								showServersOptObj.setValue(true);
							}
							else
							{
								showServersOptObj.setValue(false);
							}
							showServersOptObj.resumeEvents();

							var showDescOptObj = metricsForm.findField('showDescOpt');
							showDescOptObj.suspendEvents(false);
							var showDescriptors = configuredData['showDescriptors'];
							if(showDescriptors!=null && showDescriptors=="yes")
							{
								showDescOptObj.setValue(true);
							}
							else
							{
								showDescOptObj.setValue(false);
							}
							showDescOptObj.resumeEvents();

							/*if(showServers!="yes" && showDescriptors!="yes")
							{
								showDescOptObj.suspendEvents(false);
								showDescOptObj.setValue(true);
								showDescOptObj.resumeEvents();
							}*/
							
							var categoryOptsObj = metricsForm.findField('categoryOpts');
							var myDashC = myDashApp.getController("WidgetConfigurationController").changeCategoryOptionCombo(categoryOptsObj);
							
							if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('gridData') && !Ext.isEmpty(configuredData['gridData'])) 
							{

							 var configTableGrid = Ext.getCmp('configTableGrid');
								configTableGrid.suspendEvents(true);
								
								var gridStore = configTableGrid.getStore();
								gridStore.add(configuredData['gridData']);
								configTableGrid.show();
								configTableGrid.resumeEvents();
								configTableGrid.doComponentLayout();
							}
							else
							{
								 var configTableGrid = Ext.getCmp('configTableGrid');
								configTableGrid.suspendEvents(true);
								
								var gridStore = configTableGrid.getStore();
								gridStore.removeAll();
								configTableGrid.show();
								configTableGrid.resumeEvents();
								configTableGrid.doComponentLayout();

							}
						}
						else if(categoryType == 'Zone' || categoryType == 'Segment' || categoryType == 'Service' || categoryType == 'ComponentType')
						{
							var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
							if(mePopup.widgetType!=null && mePopup.widgetType=='tierhealth')
							{
								enableLegendOptObj.isDefault=false;
								enableLegendOptObj.hide();
							}
							else
							{
								enableLegendOptObj.isDefault=true;
								enableLegendOptObj.show();
							}

							var showLegends = configuredData['showLegends'];
							if(showLegends!=null && showLegends=="yes")
							{
								enableLegendOptObj.setValue(true);
							}
							else
							{
								enableLegendOptObj.setValue(false);
							}
							
							enableLegendOptObj.isDefault=false;

							if(!Ext.isEmpty(gridContainerObj))
							{
								gridContainerObj.hide();
							}
							var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
							/*var showDescOptObj = metricsForm.findField('showDescOpt');
							showDescOptObj.setValue(true);
							showDescOptObj.resumeEvents();*/
							if(!Ext.isEmpty(legandCheckBoxObj))
							{
								legandCheckBoxObj.hide();
							}

							if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents'))
							{			
								var categoryOptsObj = metricsForm.findField('categoryOpts');
								var myDashC = myDashApp.getController("WidgetConfigurationController").loadGroupedItems(categoryOptsObj,configuredData['selectedComponents']);
							}
							else if((categoryType=='ComponentType')  && configuredData.hasOwnProperty('selectedComponentType'))
							{
								var categoryOptsObj = metricsForm.findField('categoryOpts');
								var healthCenterCompContinerObj = Ext.getCmp('healthCenterCompContiner');
								var healthCenterComponentSearchTextBoxObj = Ext.getCmp('healthCenterComponentSearchTextBox');
								var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
								var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');
								if(!Ext.isEmpty(jsonData['comptypes']))
								{
									meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, jsonData['comptypes'], configuredData['selectedComponentType'], '','');
									if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
									{
										healthCenterCompContinerObj.show();
										healthCenterComponentComboObj.show();
										healthCenterComponentSearchTextBoxObj.show();
										healthCenterComponentComboLblObj.setText('Component Type');
									}
								}
								else
								{
									meC.setValueWithMultiSelectOptionInList(healthCenterComponentComboObj, '', '', notApplicable,'');

									if (!Ext.isEmpty(healthCenterCompContinerObj) && !Ext.isEmpty(healthCenterComponentComboObj) && !Ext.isEmpty(healthCenterComponentSearchTextBoxObj))
									{
										healthCenterCompContinerObj.show();
										healthCenterComponentComboObj.show();
										healthCenterComponentSearchTextBoxObj.show();
										healthCenterComponentComboLblObj.setText(selectedCategoryValue+'s');
									}
								}
							}
							else
							{
								var categoryOptsObj = metricsForm.findField('categoryOpts');
								var myDashC = myDashApp.getController("WidgetConfigurationController").loadGroupedItems(categoryOptsObj,'-1');
							}
						}
						else if(categoryType == 'all')
						{
							var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
							if(mePopup.widgetType!=null && mePopup.widgetType=='tierhealth')
							{
								enableLegendOptObj.isDefault=false;
								enableLegendOptObj.hide();

							}
							else
							{
								enableLegendOptObj.isDefault=true;
								enableLegendOptObj.show();
							}

							var showLegends = configuredData['showLegends'];
							if(showLegends!=null && showLegends=="yes")
							{
								enableLegendOptObj.setValue(true);
							}
							else
							{
								enableLegendOptObj.setValue(false);
							}
							
							enableLegendOptObj.isDefault=false;
						}
						this.resumeEvents();
						Ext.resumeLayouts(true);
					}
				},
				failure: function () {

				}
			});

	},
	applyFilterOptions : function()
	{
		this.updateHealthCenterServers(false,'filterPopup');
	},
  updateRUMUXWidgetConfig : function()
	{
		try
		{
			var rumUXWidgetMetricsObj = this.getRumuxconfigwindow();           
			var configForm = rumUXWidgetMetricsObj.getComponent('configForm').getForm();
			var compName=configForm.findField('rumuxWigdetConfigCombo').getValue();
			var rumUXTyp=configForm.findField('rumuxWigdetTypeCombo').getValue();
			
			
			var blockId = rumUXWidgetMetricsObj.blockId;
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			var configPanl = Ext.getCmp(blockId);         
			var meC=this; 		
			if(!Ext.isEmpty(profileName))
			{
				profileName=meC.filterEncode(profileName);
			}
			if(!Ext.isEmpty(compName))
			{
				compName=meC.filterEncode(compName);
			}
			var paramsForSave = "action=saveRUMUXWidgetConfig&profileName=" + encodeURIComponent(profileName) + "&blockId=" + blockId +"&componentName="+encodeURIComponent(compName)+"&selectedRUMUXType="+encodeURIComponent(rumUXTyp);
			
			if(rumUXTyp!=null && rumUXTyp=="mobile")
			{
				var mobileOSTyp=configForm.findField('mobileOSTypeCombo').getValue();
				paramsForSave=paramsForSave+"&selectedMobileOSType="+encodeURIComponent(mobileOSTyp);
			}
      if(blockId!=null && blockId.indexOf("webSimulationWidget")>-1)
      {
        var webSimulationExtAgentListComboObj=Ext.getCmp('webSimulationExtAgentListCombo');
				var webSimulationScriptListComboObj=Ext.getCmp('webSimulationScriptListCombo');
        paramsForSave=paramsForSave+'&selectedExtAgent='+encodeURIComponent(webSimulationExtAgentListComboObj.getValue())+'&selectedScript='+encodeURIComponent(webSimulationScriptListComboObj.getValue());
      }
			var gridStackObj=this.getGridstackpanel();
			var posStrVal=gridStackObj._serializationStr();
			if(posStrVal!=null && posStrVal!='')
			{
				paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
			}
			gridStackObj=null;
			delete gridStackObj;
			iAjax.request({
						url : '/final/servlet/com.eg.egMyDashboardController',
						method : 'POST',
						params : paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
						scope : this,
						success : function(response) {
							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var jsonData = Ext.decode(jsonText);
								configPanl.isInitialResizeCompleted=false;
								if(!Ext.isEmpty(rumUXWidgetMetricsObj))
								{
									rumUXWidgetMetricsObj.close();
								}
								myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, blockId);
							}
						},
						failure : function(response, opts) {
							if (response.timedout) {
								{
									configPanl.removeAll();
									configPanl
											.add({
												xtype : 'container',
												html : requestTimeoutMsg
											});
								}
	//							configPanl.setLoading(false);
								configPanl.doLayout();						
						}
					  }
			});	  
		}
		catch (Excp)
		{
			console.log("Excp ",Excp);
		}
	},
	saveUpDownExcludeIncludeWidgetConfig: function()
	{
		try
		{
		var meC=this;
		var configWindowObj = this.getWidgetOptionsWindow();
		var widgetID = configWindowObj.widgetID;
		var widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		var configFormObj = Ext.getCmp('serverUpDownConfigForm');
		var configForm = configFormObj.getForm();
		var analysisByCombo = configForm.findField('uptimeDowntimeAnalysisBy');
		var timelineCombo = configForm.findField('timelineCombo');
		var includeMaintenanceCombo = configForm.findField('includeMaintenanceCombo');
		var uptimeForCombo = configForm.findField('uptimeForCombo');
		var excludeCmpDescObj = configForm.findField('excludeCmpDescObj');
		var compntTypFilterCmb = configForm.findField('compntTypFilterCmb');
		var subTypeCompCombo = configForm.findField('subTypeCompCombo');
		var analysisBy = '';
		if(!Ext.isEmpty(analysisByCombo))
		{
			analysisBy=analysisByCombo.getValue();
		}
		var selectedCompType = '';
		if(!Ext.isEmpty(compntTypFilterCmb))
		{
			selectedCompType=compntTypFilterCmb.getValue();
		}
		var selectedInfraType = '';
		if(!Ext.isEmpty(subTypeCompCombo))
		{
			selectedInfraType=subTypeCompCombo.getValue();
		}
		var selectedIncludeMaintenance = '';
		if(!Ext.isEmpty(includeMaintenanceCombo))
		{
			selectedIncludeMaintenance=includeMaintenanceCombo.getValue();
		}
		var selectedUptimeFor = '';
		if(!Ext.isEmpty(uptimeForCombo))
		{
			selectedUptimeFor=uptimeForCombo.getValue();
		}
		var selectedTimeline = '';
		if(!Ext.isEmpty(timelineCombo))
		{
			selectedTimeline=timelineCombo.getValue();
		}
		var excludeDescCompVal = '';
		if(!Ext.isEmpty(excludeCmpDescObj))
		{
			var excludedCmpDescRecords = configForm.findField('excludeCmpDescObj').fromField.getStore().getRange();
			var compsStr='';
			if(!Ext.isEmpty(excludedCmpDescRecords))
			{
				Ext.each(excludedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					compsStr=compsStr+','+cmpStr;
				});
			}

			if(compsStr!=null && compsStr.indexOf(',')==0)
				compsStr=compsStr.substring(1);
			if(Ext.isEmpty(compsStr))
				compsStr="None";
			excludeDescCompVal=meC.filterEncode(compsStr);
			var selectedDescCompVal = '';
			var selectedCmpDescRecords = configForm.findField('excludeCmpDescObj').toField.getStore().getRange();
			var componentsStr='';
			if(!Ext.isEmpty(selectedCmpDescRecords))
			{
				Ext.each(selectedCmpDescRecords, function(item, idx) {
					var cmpStr=item.getData().valueField;
					componentsStr=componentsStr+','+cmpStr;
				});
			}
			if(componentsStr!=null && componentsStr.indexOf(',')==0)
				componentsStr=componentsStr.substring(1);

			if(Ext.isEmpty(componentsStr))
				componentsStr="None";
			selectedDescCompVal=meC.filterEncode(componentsStr);
		}
		var configPanl=Ext.getCmp(widgetID);
		var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
		var tmpProfNam=dashLayoutObj.profileName;
		if(!Ext.isEmpty(tmpProfNam))
		{
			tmpProfNam=this.filterEncode(tmpProfNam);
		}
		var paramsForSave='action=saveUpDownExcludeIncludeComponentConfig&excludeCmpDescObj='+encodeURIComponent(excludeDescCompVal)+"&selectedCmpDescObj="+encodeURIComponent(selectedDescCompVal)+'&profileName='+encodeURIComponent(tmpProfNam)+'&blockId='+encodeURIComponent(widgetID);
		iAjax.request({
			url : '/final/servlet/com.eg.egMyDashboardController',
			method : 'POST',
			params : paramsForSave,
			scope : this,
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var isUpdated = jsonData['updated'] ;
					if(isUpdated){
							Ext.Msg.show({
							title : uptimeDowntimeWidgetAlertLbl,
							msg : excludeIncludeAlertLbl,
							cls: 'adminAlert',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
					}
				}
				jsonData=null;
				jsontext=null;
				//componentsFilterObj	=null;
			}
		});
		}
		catch (Excep)
		{
			console.log("Excep ",Excep);
		}
	}
});