var errorPanel = false;
Ext.define('comparisonDashboard.controller.Main', {
	extend: 'Ext.app.Controller',
	views:['comparisonDashboard.view.Main',
		'comparisonDashboard.view.Paging',
		'comparisonDashboard.view.SimulationsChartPanel',
		'comparisonDashboard.view.TabularView',
		'comparisonDashboard.view.SegmentView'
	],
	stores:['SortRetain'],
	transactionMeasuresChartURL:"/final/servlet/com.egurkha.TransactionMeasures",
	time_line_obj:null,
	chart_url:null,
	refs:[
	{
		ref:'TreePanel',
		selector:'treepanel'
	},
	{
		ref:'main',
		selector:'main'
	},
	{
		ref:'componentsPanelCombo',
		selector:'generalMeasuresGridPanel[itemId="components"] combo'
	},
	{
		ref : 'Tree',
		selector : 'treepanel > panel'
	},
	{
		ref:'commonPanel',
		selector:'generalMeasuresGridPanel[id="perPanel"]'
	},
	{
		ref:'systemPanel',
		selector:'generalMeasuresGridPanel[itemId="system"]'
	},
	{
		ref:'componentsPanel',
		selector:'generalMeasuresGridPanel[itemId="components"]'
	},
	{
		ref:'networkPanel',
		selector:'generalMeasuresGridPanel[itemId="network"]'
	}
	,
	{
		ref:'extenalMonitorPanel',
		selector:'generalMeasuresGridPanel[itemId="externalMonitor"]'
	}
	,
	{
		ref:'componentsPanelCombo',
		selector :'generalMeasuresGridPanel[itemId="components"] > panel > toolbar > combobox'
	},
	{
		ref:'componentsTypeCombo',
		selector :'generalMeasuresGridPanel[itemId="components"] > panel > toolbar > combobox'
	},
	{
		ref:'componentsTypeCombo',
		selector :'generalMeasuresGridPanel[itemId="system"] > panel > toolbar > combobox'
	},
	{
		ref:'monitorsTypeCombo',
		selector :'generalMeasuresGridPanel[itemId="externalMonitor"] > panel > toolbar > combobox'
	},
	{
		ref:'systemPanel',
		selector :'generalMeasuresGridPanel[itemId="system"] > panel > toolbar > textfield'
	},
	{
		ref:'componentsPanel',
		selector :'generalMeasuresGridPanel[itemId="components"] > panel > toolbar > textfield'
	},
	{
		ref:'simulationsChartPanel',
		selector:'simulationsChartPanel'
	},
	{
		ref:'simulationsPanelToolbar',
		selector:'simulationFloatingContainer > panel'
	},
	{
		ref : 'simulationComboMode',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "mode"]'
	},{
		ref : 'simulationComboTimeline',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "timeline"]'
	},{
		ref : 'simulationComboFromhr',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "fromhr"]'
	},{
		ref : 'simulationComboTohr',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "tohr"]'
	},{
		ref : 'simulationComboFrommin',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "frommin"]'
	},{
		ref : 'simulationComboTomin',
		selector : 'simulationFloatingContainer > panel > combo[itemId= "tomin"]'
	},{
		ref : 'simulationFromDate',
		selector : 'simulationFloatingContainer > panel > datefield[itemId= "from"]'
	},{
		ref : 'simulationToDate',
		selector : 'simulationFloatingContainer > panel > datefield[itemId= "to"]'
	}
	],
	init: function() {
		setInterval("execute()",refreshFrequency);
		//setInterval("execute()",8000);
		this.control({
			'treepanel':{
				beforerender:function(){
				}
			},
			'treepanel > panel':{
				'afterrender':this.treeLoad,
				'itemclick': this.treeItemClick
			},
			'main > panel':{
				'afterrender':this.mainLoad,
			},
			'generalMeasuresGridPanel combo[id="filterByCombo"]':{
				'select':this.compFilterByComboOnChange
			},
			'generalMeasuresGridPanel combo[id="subFilterCombo"]':{
				change:this.compSubFilterComboOnChange
			},
			'generalMeasuresGridPanel combo[id="componentTypCombo"]':{
				change:this.componentTypeComboOnChange
			},
			'generalMeasuresGridPanel combo[id="extAgent"]':{
				change:this.externalAgentOnChange
			},
			'generalMeasuresGridPanel combo[id="extTest"]':{
				change:this.externalTestOnChange
			},
			'generalMeasuresGridPanel combo[id="tenant"]':{
				change:this.tenantOnChange
			},
			'generalMeasuresGridPanel combo[id="sortByCombo"]':{
				'select':this.componentsmeasureComboChange
			},
			'generalMeasuresGridPanel combo[id="monitorsCombo"]':{
				change:this.monitorTypeComboChange
			},
			'generalMeasuresGridPanel button[id="submitbut"]':{
				click:this.submitButtonChange
			},
			'generalMeasuresGridPanel textfield[id="nickName"]':{
				specialkey: function(field, e){
					if (e.keyCode == 13) {
						this.compSubmitButtonClicked();
					}
					else if (e.getKey() == e.ENTER) {
						this.compSubmitButtonClicked();
					}
				}
				
			},
			'dashboardgeneralmeasuresgrid':{
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
			},
			'simulationsChartPanel':{
				  'afterrender':this.onChartsPanelRender
			  },
			'simulationsChartPanel button[id= "settingBt"]':{
				click:this.settingClick
			},
			'simulationFloatingContainer > panel > combo[itemId= "timeline"]':{
				  select:this.timelineChangeHandler 
			},
			'simulationFloatingContainer > panel > button[action = "simulationGraphBtn"]':{
				  click:this.displayGraph
			},
			
	   });
	},
	treeItemClick:function(view, record, item, index, event)
	{
		if(!Ext.isEmpty(record.raw.link)){
			var url=record.raw.link;
			Refurl=url;
			Refid=record.raw.id;
			Reftext=record.raw.text;
			if(record.raw.id=='system' || record.raw.id=='component' || record.raw.id=='components')
			{
				var curViewPort=  Ext.getCmp('innerPanel');
				//curViewPort.removeAll();
				var resultItems=curViewPort.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					//commonpanel.destroy(resultItems[item]);
					resultItems[item].destroy();
				}
				curViewPort.setTitle(record.raw.text);
				curViewPort.header.addClass("panelTitle");
				curViewPort.add({
					xtype:'generalMeasuresGridPanel',
					//title:record.raw.text,
					cls:'gridHeadercenter iconGrid',
					itemId:record.raw.id,
					margin:0,
					padding:0,
					frame:false,
					border:true,
					forceFit:true,
					//layout:{type:'vbox',align:'stretch'},
					//layout:'fit',
					//flex:1,
					autoScroll:true,
					screenLabelPath:"monitor.Dashboard",
					url:url,
					listeners: {
						'afterrender': function (obj) {
							this.loadTab(obj.url,'','','','',(isIframe)?true:'','comparisonDashboard');
						}
					}
				});
			}
		}
	},
	treeLoad:function(treePanel){
		/*var titlesys="Systems";
		var itemIdforsysandcom="system";
		var url="/final/monitor/monitorSystem.jsp?pageNo=1";
		if(treeTitle!=null && treeTitle=="system")
		{
			url=url;
			titlesys="Systems";
			itemIdforsysandcom="system";
		}
		else if(treeTitle!=null && treeTitle=="components")
		{
			url="/final/monitor/monitorComponent.jsp?treeTitle=Component&appCurrentHost=Windows_server&pageNo=1";
			titlesys='Components';
			itemIdforsysandcom="components";
		}
		else
		{
			url=url;
			titlesys="Systems";
			itemIdforsysandcom="system";
		}*/

		Refurl=perf_url;
		Refid=perf_id;
		Reftext=perf_disp_name;
		var curViewPort=  Ext.getCmp('innerPanel');
		//curViewPort.removeAll();
		var resultItems=curViewPort.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			//commonpanel.destroy(resultItems[item]);
			resultItems[item].destroy();
		}
		curViewPort.setTitle(perf_disp_name);
		curViewPort.header.addClass("panelTitle");
		curViewPort.add({
			xtype:'generalMeasuresGridPanel',
			//title:titlesys,
			//title:perf_disp_name,
			//cls:'gridHeadercenter iconGrid',
			//itemId:itemIdforsysandcom,
			id:'perPanel',
			itemId:perf_id,
			margin:0,
			padding:0,
			frame:false,
			border:true,
			forceFit:true,
			layout:{type:'vbox',align:'stretch'},
			screenLabelPath:"monitor.Dashboard",
			url:perf_url,
			listeners: {
				'afterrender': function (obj) {
					this.loadTab(obj.url,'','','','',(isIframe)?true:'','comparisonDashboard');
				}
			}
		});
	curViewPort.doLayout();
	},
	mainLoad:function(treePanel){
		/*var titlesys="Systems";
		var itemIdforsysandcom="system";
		var url="/final/monitor/monitorSystem.jsp?pageNo=1";
		if(treeTitle!=null && treeTitle=="system")
		{
			url=url;
			titlesys="Systems";
			itemIdforsysandcom="system";
		}
		else if(treeTitle!=null && treeTitle=="components")
		{
			url="/final/monitor/monitorComponent.jsp?treeTitle=Component&appCurrentHost=Windows_server&pageNo=1";
			titlesys='Components';
			itemIdforsysandcom="components";
		}
		else
		{
			url=url;
			titlesys="Systems";
			itemIdforsysandcom="system";
		}*/
		Refurl=perf_url;
		Refid=perf_id;
		var me = this;
		var curViewPort =  Ext.getCmp('innerPanel');
		//curViewPort.removeAll();
		var resultItems=curViewPort.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			//commonpanel.destroy(resultItems[item]);
			resultItems[item].destroy();
		}
		

		if(selectedState != undefined && selectedState != null && selectedState != 'null' && selectedState != '' ){
			if(selectedState.toLowerCase() == 'high')
				selectedState="Critical";
			else if(selectedState.toLowerCase() == 'intermediate')
				selectedState="Major";
			else if(selectedState.toLowerCase() == 'low')
				selectedState="Minor";
			else if(selectedState.toLowerCase() == 'good')
				selectedState="Normal";
			else if(selectedState.toLowerCase() == 'unknown')
				selectedState="Unknown";
			if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
				perf_disp_name +=" in "+selectedState+" State  for the zone : "+zoneName;
			else
				perf_disp_name +=" in "+selectedState+" State ";
		}else if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			perf_disp_name +=" for the zone : "+zoneName;
		
		Reftext=perf_disp_name;
		if(showGraph != null && (showGraph == 'true' || showGraph == 'TRUE'))
		{
			var panelArr = new Array();
			var transurl =  '/final/monitor/simulationGraph.jsp?treeTitle=services&site='+selectedParam;
			if(!Ext.isEmpty(externalAgent) && externalAgent != null && externalAgent != undefined && externalAgent !='undefined')
			{
				selectedExtAgent = externalAgent;
				transurl += '&mHost='+selectedExtAgent;
			}
			if(!Ext.isEmpty(componentNameSearch) && componentNameSearch != null && componentNameSearch != undefined && componentNameSearch !='undefined')
			{
				//selectedSimulation = componentNameSearch;
				transurl += '&componentNameSearch='+componentNameSearch;
			}
			if(!Ext.isEmpty(componentNameService) && componentNameService != null && componentNameService != undefined && componentNameService !='undefined')
			{
				//selectedSimulation = componentNameSearch;
				transurl += '&componentNameService='+componentNameService;
			}
			if(!Ext.isEmpty(timelineParamJson.time_line) && timelineParamJson.time_line != null && timelineParamJson.time_line != undefined && timelineParamJson.time_line !='undefined' && timelineParamJson.time_line !='null')
			{
				//selectedSimulation = componentNameSearch;
				transurl += '&time_line='+timelineParamJson.time_line+'&starthr='+timelineParamJson.starthr+'&endhr='+timelineParamJson.endhr+'&starttime='+timelineParamJson.starttime+'&endtime='+timelineParamJson.endtime+'&startmin='+timelineParamJson.startmin+'&endmin='+timelineParamJson.endmin+'&mode='+timelineParamJson.mode;
			}

			Ext.Ajax.request({
					url : transurl,
					scope:this,
					success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsondata1 = Ext.decode(jsonText);
							if(jsondata1 != null && jsondata1 != undefined)
							{
								if(!Ext.isEmpty(isfromCitrix) && isfromCitrix != undefined && isfromCitrix != null && isfromCitrix != "null"){
									panelArr.push({
										xtype:'generalMeasuresGridPanel',
										itemId:perf_id,
										cls:'iconGrid',
										ui:'eg-x-panel',
										frame:false,
										border:true,
										hideHeader:true,
										forceFit:true,
										layout:'fit',
										//layout:{type:'vbox',align:'stretch'},
										//flex:0.5, // --to rest the flex in generalMeasuresGridPanel
										height:230,
										margin:'0 1 0 0',
										style:{'border':'0px solid red !important'},
										//minHeight:200,
										screenLabelPath:"monitor.Dashboard",
										url:perf_url,
										listeners: {
											'afterrender': function (obj) {
												this.loadTab(obj.url,'','','','',(isIframe)?true:'','comparisonDashboard');
											},
											'render':function(obj){
										
													//Ext.get("Main-body").setStyle('backgound','#fff !important');
													
													if (Ext.get("perPanel"))
													{
														//Ext.get("perPanel").setStyle('margin','-10px !important')
													}

													if (Ext.getCmp("innerPanel_header"))
													{
														Ext.getCmp("innerPanel_header").hide();
														
														
													}

											}
										}
									});
									panelArr.push({
										xtype:'simulationsChartPanel',
										id:'simulationsChartPanelId',
										//animCollapse:true,
										//columnWidth:1.0,
										//height:255,
										//height:(Ext.getBody().getViewSize().height - 225),
										//flex:1,
										jsonData:jsondata1,
										minHeight:265,
										margin:'10 1 10 0',
										//margin:'5 0 0 0',
										padding:0,
										//flex:0.57,
										border:true
							
									});
								}
								else
								{
									panelArr.push({
										xtype:'generalMeasuresGridPanel',
										itemId:perf_id,
										cls:'iconGrid',
										frame:false,
										border:true,
										hideHeader:true,
										forceFit:true,
										layout:{type:'vbox',align:'stretch'},
										flex:0.5, // --to rest the flex in generalMeasuresGridPanel
										//height:189,
										screenLabelPath:"monitor.Dashboard",
										url:perf_url,
										listeners: {
											'afterrender': function (obj) {
												this.loadTab(obj.url,'','','','',(isIframe)?true:'','comparisonDashboard');
											},
											'render':function(obj){
										
													Ext.get("Main-body").setStyle('backgound','#fff !important');
													
													if (Ext.get("perPanel"))
													{
														//Ext.get("perPanel").setStyle('margin','-10px !important')
													}

													if (Ext.getCmp("innerPanel_header"))
													{
														Ext.getCmp("innerPanel_header").hide();
														
														
													}

											}
										}
									});
									panelArr.push({
										xtype:'simulationsChartPanel',
										id:'simulationsChartPanelId',
										//animCollapse:true,
										//columnWidth:1.0,
										//height:255,
										//height:(Ext.getBody().getViewSize().height - 225),
										flex:1,
										jsonData:jsondata1,
										//margin:'5 0 0 0',
										padding:0,
										//flex:0.57,
										border:true
							
									});
								}
								curViewPort.add(panelArr);
								curViewPort.doLayout();
							}
						}
					  },
					failure:function(){
						window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
			else
			{
				var css_class='gridHeadercenter iconGrid';
				var dashboardName = 'comparisonDashboard';
				if(!Ext.isEmpty(perf_id) && (perf_id=='ExtTestDashboard' || perf_id=='EmailPath'))
				{
					dashboardName = 'ExternalMonitor';
					css_class='gridHeadercenter';
				}
				if(isIframe)
				{
					curViewPort.header.hide();
				}
				else
				{
					curViewPort.setTitle(perf_disp_name);
					curViewPort.header.addClass("panelTitle");
				}
				//if(perf_id == "EmailPath")
					//css_class='';
				curViewPort.add({
					xtype:'generalMeasuresGridPanel',
					plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
					//title:titlesys,
					//title:perf_disp_name+" --Man At Work--",
					cls:css_class,
					//itemId:itemIdforsysandcom,
					itemId:perf_id,
					margin:0,
					padding:0,
					id:'perPanel',
					forceFit:true,
					frame:false,
					border:true,
					layout:{type:'vbox',align:'stretch'},
					flex:1,
					screenLabelPath:"monitor.Dashboard",
					url:perf_url,
					fromKioskMode : fromKioskMode,
					listeners: {
						'afterrender': function (obj) {
							this.loadTab(obj.url,'','','','',(isIframe)?true:'',dashboardName);
						}
					}
				});
				me.autoScrollTvMode(curViewPort.id);
			}

		if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
			Ext.getCmp('back').setVisible(true);
		else if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			Ext.getCmp('back').setVisible(true);
		
	},
	loadGraph:function(extAgent){
		var transurl =  '/final/monitor/simulationGraph.jsp?treeTitle=services&site='+selectedParam+'&mHost='+extAgent;

		var graphViewPort =  Ext.getCmp('simulationsChartPanel');
		//graphViewPort.removeAll();
		/*var resultItems=graphViewPort.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			resultItems[item].destroy();
		}*/

		Ext.Ajax.request({
					url : transurl,
					scope:this,
					success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsondata1 = Ext.decode(jsonText);
							this.getSimulationComboMode().hide();
							var chartPanel=this.getSimulationsChartPanel();
							if(!Ext.isEmpty(jsondata1) && !Ext.isEmpty(jsondata1)){
								var jsonData=jsondata1;
								var mode="";
								var starttime="";
								var endtime="";
								var startHr="";
								var startMin="";
								var endHr="";
								var endMin="";
								var time_line="";
								var dateError = '';
								var chartToolbar=this.getSimulationsPanelToolbar();
								var modeCombo=chartToolbar.getComponent("mode");
								if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
									  mode=modeCombo.getValue();
								}
								var startTimeField=chartToolbar.getComponent("from");
								if(!Ext.isEmpty(startTimeField)){
									if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
										  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
									}else{
										  if(!Ext.isEmpty(time_line_obj)){
											  starttime=time_line_obj.starttime;
										  }else{
											  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
										  }
									}
								}
								  
								  var endTimeField=chartToolbar.getComponent("to");
								  if(!Ext.isEmpty(endTimeField)){
									  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
									  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
									  }else{
										  if(!Ext.isEmpty(time_line_obj)){
											  endtime=time_line_obj.endtime;
										  }else{
											  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
										  }
									  }
								  }
								
								var fromCombo=chartToolbar.getComponent("fromhr");
								if(!Ext.isEmpty(fromCombo)){
									  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
										startHr=fromCombo.getValue();
										 
									  }else{
										  if(!Ext.isEmpty(time_line_obj)){
											  startHr=time_line_obj.starthr;
											   
										  }else{
												startHr=fromCombo.getValue();
											}
									}
								}

								  var toCombo=chartToolbar.getComponent("tohr");
								  if(!Ext.isEmpty(toCombo)){
									  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
										  endHr=toCombo.getValue();
									}else{
										  if(!Ext.isEmpty(time_line_obj)){
												endHr=time_line_obj.endhr;
										  }else{
												endHr=toCombo.getValue();
										  }
									  }
								  }			

								   //Get Minutes
							 var startMin="";
							 var fromMinCombo=chartToolbar.getComponent("frommin");
							  if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
								  startMin=fromMinCombo.getValue();
												  
							  }			

							  var endMin="";
							  var toMinCombo=chartToolbar.getComponent("tomin");
							  if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
								  endMin=toMinCombo.getValue();
							  }

								 var timeLineCombo=this.getSimulationComboTimeline();
								  if(timeLineCombo.getValue() =="Any"){
										var dateError = startTimeField.getName();
										var currentDateError = endTimeField.getName()
										var startTime = startTimeField.getValue();
										var endTime = endTimeField.getValue();
										var curTime = curDateTime;
										var currentMgrDate = new Date(curTime);
										var starttime= formatDate(startTime, "MM/dd/yyyy");
										var endtime= formatDate(endTime, "MM/dd/yyyy");
												
										if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
										{
											var msg ="From date should be lesser than to date";
											Ext.Msg.alert('Error', dateError);
											return;
										}
								}
								 
								  this.anyStartTime=starttime;
								  this.anyEndTime=endtime;
								  this.anyStartHr=startHr;
								  this.anyEndHr=endHr;
								  var timelineCombo=chartToolbar.getComponent("timeline");
								  if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
									  time_line=timelineCombo.getValue();
								  }
								  var chartPanel=this.getSimulationsChartPanel();
								 
								  var cdate = this.getCurrentDateTime();
								  var chartOption = chartGraphType(cdate);
								  this.transactionMeasuresParam={
											 startTrans:'',
											 site:"NULL",
											 comp:jsonData.HiddenFields.compName,
											 test:jsonData.HiddenFields.testForTab,
											 measure:jsonData.HiddenFields.measurelst,
											 gformat:"graph",
											 chartType:chartOption,
											 GraphSize:"true",
											 monitorSkin:jsonData.HiddenFields.monitorSkin,
											 mode:'2D',
											 starttime:startTimeField.getRawValue(),
											 endtime:endTimeField.getRawValue(),
											 starthr:startHr,
											 endhr:endHr,
											 startmin:startMin,
											 endmin:endMin,
											 time_line:time_line,
											 all_trans_names:jsonData.HiddenFields.all_trans_names,
											 msmt_host:jsonData.HiddenFields.mHost,
											 endTrans:'',
											 isAreaChart:isAreaChart,
											 isLogonType:isLogonType
										  };
									transParam = this.transactionMeasuresParam;
								  if(chartOption.indexOf("highchart") > -1)
								  {
									  this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
									  this.getSimulationComboMode().hide();
								  }
								  else
								  {
									  this.getSimulationComboMode().hide();
									  chartPanel.getEl().mask("Loading...");
									Ext.Ajax.request({
									  url : this.transactionMeasuresChartURL,
									  params: this.transactionMeasuresParam,
									  method:'get',
									  scope:this,
									  success: function(response){
												var chartPnl=this.getSimulationsChartPanel();
												chartPnl.getEl().unmask();
												this.createGraphs(response);
											},
											failure:function(){
												var chartPnl=this.getSimulationsChartPanel();
												chartPnl.getEl().unmask();
											}
								  });
							  }
							  }
						}
					}
		});
	},
	renewSortState:function(thisObj,opts){
		this.getSortRetainStore().getProxy().clear();
	},

	retainColumnSort:function(thisObj,opts){
		var store = this.getSortRetainStore();
		store.load();
		var panelId = null;
		if(!Ext.isEmpty(thisObj.up('generalMeasuresGridPanel')) && !Ext.isEmpty(thisObj.up('generalMeasuresGridPanel').itemId)){
			panelId = thisObj.up('generalMeasuresGridPanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = thisObj.up('generalMeasuresGridPanel').itemId;
		}
		var record = store.findRecord('panelId',panelId);
		if(!Ext.isEmpty(record)){
			thisObj.store.sort(record.get('dataIndex'),record.get('direction'));
		}
	},

	getSortDetails:function(ct, column, direction, eOpts){
		var objFlag = true;
		var panelId = null;
		if(!Ext.isEmpty(ct.up('generalMeasuresGridPanel')) && !Ext.isEmpty(ct.up('generalMeasuresGridPanel').itemId)){
			panelId = ct.up('generalMeasuresGridPanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = ct.up('generalMeasuresGridPanel').itemId;
		}
		var object = {
			panelId:panelId,
			dataIndex:column.dataIndex,
			direction:direction
		}
		var store = this.getSortRetainStore();
		if(store.getCount() != 0){
			store.each(function(record){
				if(record.get('panelId') == object.panelId){
					record.set(object);
					objFlag = false;
					return false;
				}
			},this);
		}
		if(objFlag)
			store.add(object);
		store.sync();
		store.commitChanges();
	},
	zonesDashboardAfterRenderHandler:function(tabpanel){
		this.loadActiveTabData(tabpanel);
	},

	itemset:function(window,e){
		window.add(window.setData("",""));
	},

	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		if(selectedTab=='Component' || selectedTab=='Aggregate')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		if(name=='serviceComp')
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);

		}
		else if(name=='serviceMeasure')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			var dispName=newvalue[0].data.name;
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
		}
		else{}
	},

	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add')
		{
			descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			if(descMeasureUnit=='Yes')
				testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
			testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
			name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},

	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if(this.hasSpecialCharacters(dispName))
					{
						if(this.hasNumbers(dispName)){
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}

					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
		
			Ext.Ajax.request({
				url: url,
				params:params,
				method : 'POST',
				scope:this,
				success: function(response){
					var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
					var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
					var dispName="";
					var measureName=-1;
					var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
					var compname='';
					var componentType='';
					var descMeasureUnit='';
					var testfun='';
					if(perform=='Add')
					{
						descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
						if(descMeasureUnit=='Yes')
							testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.alert("","Measure Added Successfully");
					}
					if(selectedTab=='Component' || selectedTab=='Aggregate')
						componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
					this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
				},
				failure:function(){
					window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},

	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},

	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		return  /[^a-zA-Z/ ]/g.test(t);
	},
	
	systemsmeasureComboChange:function(combo){
		var combotype=combo.getValue();
		var componentsUrl=this.getSystemPanel().url;
		var filterByComboVal=Ext.getCmp('filterByCombo').getValue();
		var subFilterComboVal=Ext.getCmp('subFilterCombo').getValue();
		var nickName=Ext.getCmp('nickName').getValue();
		if(combotype!=null && combotype=="-1")
		{
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
				componentsUrl=componentsUrl+"&pageNo=1";
			if(componentsUrl.indexOf("&column=") != -1)
				componentsUrl=componentsUrl.replace(/(column=)[^\&]+/, '$1' +'');
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
				
			
		}
		else
		{
			
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
				componentsUrl=componentsUrl+"&pageNo=1";
			
			if(componentsUrl.indexOf("&column=") != -1)
				componentsUrl=componentsUrl.replace(/(column=)[^\&]+/, '$1' +combotype);
			else
				componentsUrl=componentsUrl+"&column="+combotype;
			
			if(componentsUrl.indexOf("&sortOrder=") != -1)
				componentsUrl=componentsUrl.replace(/(sortOrder=)[^\&]+/, '$1' +'ASC');
			else
				componentsUrl=componentsUrl+"&sortOrder=ASC";
			
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
		}
		var url = componentsUrl;
		Refurl=url;
		this.getSystemPanel().loadTab(url,'','','','',(isIframe)?true:'','comparisonDashboard');
		
	},
	componentsmeasureComboChange:function(combo){
		var combotype=combo.getValue();
		var filterByComboVal=Ext.getCmp('filterByCombo').getValue();
		var subFilterComboVal=Ext.getCmp('subFilterCombo').getValue();
		var componentTypCombo = Ext.getCmp('componentTypCombo').getValue();
		var nickName=Ext.getCmp('nickName').getValue();
		var componentsUrl=this.getComponentsPanel().url;

		if(combotype!=null && combotype=="-1")
		{
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("&appCurrentHost=") != -1)
				componentsUrl=componentsUrl.replace(/(appCurrentHost=)[^\&]+/, '$1' +componentTypCombo);
			else
				componentsUrl=componentsUrl+"&appCurrentHost="+componentTypCombo;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
			 componentsUrl=componentsUrl+"&pageNo=1";

			if(componentsUrl.indexOf("&appcolumn=") != -1)
				componentsUrl=componentsUrl.replace(/(appcolumn=)[^\&]+/, '$1' +'');
			
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
		}
		else
		{
			
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("&appCurrentHost=") != -1)
				componentsUrl=componentsUrl.replace(/(appCurrentHost=)[^\&]+/, '$1' +componentTypCombo);
			else
				componentsUrl=componentsUrl+"&appCurrentHost="+componentTypCombo;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
			 componentsUrl=componentsUrl+"&pageNo=1";
			
			if(componentsUrl.indexOf("&appcolumn=") != -1)
				componentsUrl=componentsUrl.replace(/(appcolumn=)[^\&]+/, '$1' +combotype);
			else
				componentsUrl=componentsUrl+"&appcolumn="+combotype;
			
			if(componentsUrl.indexOf("&appsortOrder=") != -1)
				componentsUrl=componentsUrl.replace(/(appsortOrder=)[^\&]+/, '$1' +'descending');
			else
				componentsUrl=componentsUrl+"&appsortOrder=descending";
			
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
		}
		//changecombox="";
		var url = componentsUrl;
		Refurl=url;
		this.getComponentsPanel().loadTab(url,'','','','',(isIframe)?true:'','comparisonDashboard');
	},
	
	natworkmeasureComboChange:function(combo){
		var combotype=combo.getValue();
		var filterByComboVal=Ext.getCmp('filterByCombo').getValue();
		var subFilterComboVal=Ext.getCmp('subFilterCombo').getValue();
		var componentTypCombo = Ext.getCmp('componentTypCombo').getValue();
		var nickName=Ext.getCmp('nickName').getValue();
		var componentsUrl=this.getNetworkPanel().url;
		if(combotype!=null && combotype=="-1")
		{
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("&appCurrentHost=") != -1)
				componentsUrl=componentsUrl.replace(/(appCurrentHost=)[^\&]+/, '$1' +componentTypCombo);
			else
				componentsUrl=componentsUrl+"&appCurrentHost="+componentTypCombo;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
			 componentsUrl=componentsUrl+"&pageNo=1";

			if(componentsUrl.indexOf("&appcolumn=") != -1)
				componentsUrl=componentsUrl.replace(/(appcolumn=)[^\&]+/, '$1' +'');
			
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
		}
		else
		{
			
			if(componentsUrl.indexOf("treeTitle=") != -1)
				componentsUrl=componentsUrl.replace(/(treeTitle=)[^\&]+/, '$1' +filterByComboVal);
			else
				componentsUrl=componentsUrl+"&treeTitle="+filterByComboVal;
			
			if(componentsUrl.indexOf("selectedNode=") != -1)
				componentsUrl=componentsUrl.replace(/(selectedNode=)[^\&]+/, '$1' +subFilterComboVal);
			else
				componentsUrl=componentsUrl+"&selectedNode="+subFilterComboVal;
			
			if(componentsUrl.indexOf("&appCurrentHost=") != -1)
				componentsUrl=componentsUrl.replace(/(appCurrentHost=)[^\&]+/, '$1' +componentTypCombo);
			else
				componentsUrl=componentsUrl+"&appCurrentHost="+componentTypCombo;
			
			if(componentsUrl.indexOf("pageNo=") != -1)
				componentsUrl=componentsUrl.replace(/(pageNo=)[^\&]+/, '$1' +"1");
			else
			 componentsUrl=componentsUrl+"&pageNo=1";
			
			if(componentsUrl.indexOf("&appcolumn=") != -1)
				componentsUrl=componentsUrl.replace(/(appcolumn=)[^\&]+/, '$1' +combotype);
			else
				componentsUrl=componentsUrl+"&appcolumn="+combotype;
			
			if(componentsUrl.indexOf("&appsortOrder=") != -1)
				componentsUrl=componentsUrl.replace(/(appsortOrder=)[^\&]+/, '$1' +'descending');
			else
				componentsUrl=componentsUrl+"&appsortOrder=descending";
			
			if(componentsUrl.indexOf("&searchnickname=") != -1)
				componentsUrl=componentsUrl.replace(/(searchnickname=)[^\&]+/, '$1' +nickName);
			else
				componentsUrl=componentsUrl+"&searchnickname="+nickName;
			
		}
		var url = componentsUrl;
		Refurl=url;
		this.getNetworkPanel().loadTab(url,'','','','',(isIframe)?true:'','comparisonDashboard');
	},
	compFilterByComboOnChange:function(combo){

		//var hostType=combo.getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}
		
		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}
		else if(itemIdVal=='externalMonitor' || itemIdVal=='externalMonitor')
		{
			url="/final/monitor/comparisonExternalMonitor.jsp?treeTitle=ExternalMonitor";
		}

		url=url+"&filterBy="+filterByComboVal;
		

		var subFilterComboObj = Ext.getCmp('subFilterCombo');
		var isOthers=false;
		if(filterByComboVal=='Component' || filterByComboVal=='System' ||  filterByComboVal=='Network' || filterByComboVal=='ExternalMonitor' )
		{
			subFilterComboObj.hide();
			isOthers = true;
		}
		else
		{
			subFilterComboObj.show();
		}

		

		Ext.Ajax.request({
			url :url,
			scope:this,
			timeout:280000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				subFilterComboObj.getStore().loadRawData(jsonData.subFilterOptions);
				subFilterComboObj.setValue(jsonData.pageParams.selectedSubFilterOption);
				subFilterComboObj.setFieldLabel(jsonData.pageParams.subFilterLabel);
				if(isOthers)
				{
					var dashboardName = 'comparisonDashboard';
					if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
					{
						dashboardName = 'ExternalMonitor';
						//css_class='gridHeadercenter';
					}
					this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
					Refurl=url;
				}
			}
		});
	},
	
	compSubFilterComboOnChange:function(combo){

		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}
		
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
			var url = url;
			Refurl=url;
			var dashboardName = 'comparisonDashboard';
			if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
			{
				dashboardName = 'ExternalMonitor';
				//css_class='gridHeadercenter';
			}
			this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
			//return false;
		}
		else if(itemIdVal=='components' || itemIdVal=='Components' )
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='externalMonitor' || itemIdVal=='externalMonitor')
		{
			url="/final/monitor/comparisonExternalMonitor.jsp?treeTitle=ExternalMonitor";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
			Refurl=url;
			var dashboardName = 'comparisonDashboard';
			if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
			{
				dashboardName = 'ExternalMonitor';
				//css_class='gridHeadercenter';
			}
			this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
			//return false;
		}
	},
	externalAgentOnChange:function(combo){

		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
			
		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var extAgentVal="";
		if(Ext.getCmp('extAgent')!=null && Ext.getCmp('extAgent')!=undefined && Ext.getCmp('extAgent').getValue()!=null && Ext.getCmp('extAgent').getValue()!='null')
		{
			extAgentVal = Ext.getCmp('extAgent').getValue();
		}
		var itemIdVal=this.getCommonPanel().itemId;
		
		if(ltype != null && ltest != null && ltype != 'null' && ltest != 'null' && ltype != undefined && ltest != 'undefined') 
		{
			
			url="/final/monitor/comparisonLogonSimulator.jsp?ltype="+ltype+"&ltest="+ltest+"&treeTitle="+treeTitle+"&monitorsBy="+monitorsBy;
			url=url+"&filterBy="+filterByComboVal+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
			url+="&isLogonType="+isLogonType;
		}
		else
		{
			url=Refurl+"&subFilter="+subFilterComboVal;
			url+="&isLogonType="+isLogonType;
			var isNeedAddParamEA= true;
			var isNeedAddParamCNS= true;
			if(url.indexOf("externalAgent=")>-1)
			{
				if(url.indexOf("externalAgent=")>-1 && extAgentVal != null && extAgentVal != 'null' && extAgentVal != undefined && extAgentVal != 'undefined')
				{
					url=url.replace(/(externalAgent=).*?(&)/,'$1' + extAgentVal + '$2');
					isNeedAddParamEA =false;
				}
			}
			if(url.indexOf("componentNameSearch=")>-1)
			{
				if(url.indexOf("componentNameSearch=")>-1 && nickNameVal != null && nickNameVal != 'null' && nickNameVal != undefined && nickNameVal != 'undefined')
				{
					url=url.replace(/(componentNameSearch=).*?(&)/,'$1' + nickNameVal + '$2');
					isNeedAddParamCNS =false;
				}
			}
			if(isNeedAddParamCNS)
			{
				url=url+"&componentNameSearch="+nickNameVal;
			}
			else if(isNeedAddParamEA)
			{
				url=url+"&externalAgent="+extAgentVal;
			}
			else
				url=url+"&externalAgent="+extAgentVal+"&componentNameSearch="+nickNameVal;
		}
		if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
			url+="&isFromInfraHome="+isFromInfraHome;
		if(isFromMenu != undefined && isFromMenu != null && isFromMenu != 'null' && isFromMenu != '' && (isFromMenu== true || isFromMenu=='true' ))
			url+="&isFromMenu="+isFromMenu;
		
		if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
		{	
			url+="&isFromZoneInfra="+isFromZoneInfra;

			if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
				url+="&zoneName="+zoneName;
		}

		if(serviceName != null && serviceName != 'null' && serviceName != '' && fromServiceDashboard != undefined && fromServiceDashboard != null && fromServiceDashboard != 'null' && fromServiceDashboard != '' && (fromServiceDashboard== true || fromServiceDashboard=='true' ))
		{
			url+="&fromServiceDashboard="+fromServiceDashboard+"&servicename="+serviceName;
			selectedExtAgent=extAgentVal;
			this.loadGraph(extAgentVal);
		}
		url+="&fromExtComboChange=true";
		url += "&isIframe="+isIframe;
		url += "&selectedState="+selectedState;
		Refurl=url;
		var dashboardName = 'comparisonDashboard';
		if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
		{
			dashboardName = 'ExternalMonitor';
			//css_class='gridHeadercenter';
		}
		//var curViewPort=  Ext.getCmp('innerPanel');
		//curViewPort.setTitle("Synthetic Monitoring");
		this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
	},
	externalTestOnChange:function(combo){
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
			
		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var extAgentVal="";
		if(Ext.getCmp('extAgent')!=null && Ext.getCmp('extAgent')!=undefined && Ext.getCmp('extAgent').getValue()!=null && Ext.getCmp('extAgent').getValue()!='null')
		{
			extAgentVal = Ext.getCmp('extAgent').getValue();
		}

		var extTestVal="";
		if(Ext.getCmp('extTest')!=null && Ext.getCmp('extTest')!=undefined && Ext.getCmp('extTest').getValue()!=null && Ext.getCmp('extTest').getValue()!='null')
		{
			extTestVal = Ext.getCmp('extTest').getValue();
			try
			{
				extTestVal = combo.lastSelection[0].data.url;
			}
			catch (e)
			{
				extTestVal = Ext.getCmp('extTest').getValue();
			}
		}

		if(Ext.isEmpty(extTestVal) || extTestVal == null || extTestVal == 'undefined')
			extTestVal = ltest;

		if(extParamList != null && extParamList.length > 0){
			var index = extParamList.indexOf(extTestVal);
			if(index >= 0)
				monitorsBy = extParamList[index-1];
			else
				monitorsBy = null;
		}

		var itemIdVal=this.getCommonPanel().itemId;
		if(extTestVal.indexOf("?") == -1)
			url="/final/monitor/comparisonLogonSimulator.jsp?isIframe="+isIframe+"&ltest="+extTestVal+"&treeTitle="+treeTitle+"&monitorsBy="+monitorsBy;
		else
		{
			if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
				extTestVal+="&isFromInfraHome="+isFromInfraHome;

			if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			{	
				extTestVal+="&isFromZoneInfra="+isFromZoneInfra;

				if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
					extTestVal+="&zoneName="+zoneName;
			}
			extTestVal += "&isIframe="+isIframe;
			document.location = extTestVal;
			return;
		}

		url=url+"&filterBy="+filterByComboVal+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
		
		if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
			url+="&isFromInfraHome="+isFromInfraHome;
		
		if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
		{	
			url+="&isFromZoneInfra="+isFromZoneInfra;

			if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
				url+="&zoneName="+zoneName;
		}

		if(serviceName != null && serviceName != 'null' && serviceName != '' && fromServiceDashboard != undefined && fromServiceDashboard != null && fromServiceDashboard != 'null' && fromServiceDashboard != '' && (fromServiceDashboard== true || fromServiceDashboard=='true' ))
		{
			url+="&fromServiceDashboard="+fromServiceDashboard+"&servicename="+serviceName;
			selectedExtAgent=extAgentVal;
			this.loadGraph(extAgentVal);
		}
		//url+="&fromExtComboChange=true";
		Refurl=url;
		var dashboardName = 'comparisonDashboard';
		if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
		{
			dashboardName = 'ExternalMonitor';
			//css_class='gridHeadercenter';
		}
		url += "&isIframe="+isIframe;
		this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
	},
	tenantOnChange:function(combo){
		
		
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}
		
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
			
		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var tagName="";
		if(Ext.getCmp('tenant')!=null && Ext.getCmp('tenant')!=undefined && Ext.getCmp('tenant').getValue()!=null && Ext.getCmp('tenant').getValue()!='null')
		{
			tagName = Ext.getCmp('tenant').getValue();
		}
		var itemIdVal=this.getCommonPanel().itemId;
		
		if(ltype != null && ltest != null && ltype != 'null' && ltest != 'null' && ltype != undefined && ltest != 'undefined') 
		{
			
			url="/final/monitor/comparisonLogonSimulator.jsp?ltype="+ltype+"&ltest="+ltest+"&treeTitle="+treeTitle+"&monitorsBy="+monitorsBy;
			url=url+"&filterBy="+filterByComboVal+"&selectedTagName="+tagName+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
			url+="&isLogonType="+isLogonType;
		}
		else
		{
			url=Refurl+"&subFilter="+subFilterComboVal;
			url+="&isLogonType="+isLogonType;
			var isNeedAddParamEA= true;
			var isNeedAddParamCNS= true;
			if(url.indexOf("selectedTagName=")>-1)
			{
				if(url.indexOf("selectedTagName=")>-1 && tagName != null && tagName != 'null' && tagName != undefined && tagName != 'undefined')
				{
					url=url.replace(/(selectedTagName=).*?(&)/,'$1' + tagName + '$2');
					isNeedAddParamEA =false;
				}
			}
			if(url.indexOf("componentNameSearch=")>-1)
			{
				if(url.indexOf("componentNameSearch=")>-1 && nickNameVal != null && nickNameVal != 'null' && nickNameVal != undefined && nickNameVal != 'undefined')
				{
					url=url.replace(/(componentNameSearch=).*?(&)/,'$1' + nickNameVal + '$2');
					isNeedAddParamCNS =false;
				}
			}
			if(isNeedAddParamCNS)
			{
				url=url+"&componentNameSearch="+nickNameVal;
			}
			else if(isNeedAddParamEA)
			{
				url=url+"&selectedTagName="+tagName;
			}
			else
				url=url+"&selectedTagName="+tagName+"&componentNameSearch="+nickNameVal;
		}
		if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
			url+="&isFromInfraHome="+isFromInfraHome;
		if(isFromMenu != undefined && isFromMenu != null && isFromMenu != 'null' && isFromMenu != '' && (isFromMenu== true || isFromMenu=='true' ))
			url+="&isFromMenu="+isFromMenu;
		
		if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
		{	
			url+="&isFromZoneInfra="+isFromZoneInfra;

			if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
				url+="&zoneName="+zoneName;
		}

		if(serviceName != null && serviceName != 'null' && serviceName != '' && fromServiceDashboard != undefined && fromServiceDashboard != null && fromServiceDashboard != 'null' && fromServiceDashboard != '' && (fromServiceDashboard== true || fromServiceDashboard=='true' ))
		{
			url+="&fromServiceDashboard="+fromServiceDashboard+"&servicename="+serviceName;
			selectedTagName=tagName;
			//this.loadGraph(selectedTagName);
		}		
		Refurl=url;
		var dashboardName = 'comparisonDashboard';
		if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
		{
			dashboardName = 'ExternalMonitor';
			//css_class='gridHeadercenter';
		}
		url += "&isIframe="+isIframe;
		this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
	},
	componentTypeComboOnChange:function(combo)
	{
		var componentTypeVal=combo.getValue();

		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined)
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		//var componentsUrl=this.getComponentsPanel().url;

		url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+nickNameVal;
		Refurl=url;
		var dashboardName = 'comparisonDashboard';
		if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
		{
			dashboardName = 'ExternalMonitor';
			//css_class='gridHeadercenter';
		}
		this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
	},
	
	compSubmitButtonClicked:function()
	{
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
			nickNameVal=nickNameVal.replace(/\+/g,'|plus|');
			if(isIframe)
				nickNameVal = parent.parent.filterEncode(nickNameVal);
			else
				nickNameVal = parent.filterEncode(nickNameVal);
		}
		var sortByComboVal="";
		if(Ext.getCmp('sortByCombo')!=null && Ext.getCmp('sortByCombo')!=undefined && Ext.getCmp('sortByCombo').getValue()!=null && Ext.getCmp('sortByCombo').getValue()!='null')
		{
			sortByComboVal = Ext.getCmp('sortByCombo').getValue();
		}

		var extAgentVal="";
		if(Ext.getCmp('extAgent')!=null && Ext.getCmp('extAgent')!=undefined && Ext.getCmp('extAgent').getValue()!=null && Ext.getCmp('extAgent').getValue()!='null')
		{
			extAgentVal = Ext.getCmp('extAgent').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+encodeURIComponent(nickNameVal);
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+encodeURIComponent(nickNameVal);
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+encodeURIComponent(nickNameVal);
		}
		/*else if(itemIdVal=='logonSimualtion')
		{
			url="/final/monitor/comparisonLogonSimulator.jsp?ltype=citrix&treeTitle=logonSimualtion&monitorsBy=LogonSimulator";
			url=url+"&filterBy="+filterByComboVal+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+nickNameVal;

			if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
				url+="&isFromInfraHome="+isFromInfraHome;
			
			if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			{	
				url+="&isFromZoneInfra="+isFromZoneInfra;

				if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
					url+="&zoneName="+zoneName;
			}
		}
		else if(itemIdVal=='horizonlogonSimualtion')
		{
			url="/final/monitor/comparisonLogonSimulator.jsp?ltype=horizon&treeTitle=horizonlogonSimualtion&monitorsBy=hrznLogonSimulator";
			url=url+"&filterBy="+filterByComboVal+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+nickNameVal;

			if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
				url+="&isFromInfraHome="+isFromInfraHome;
			
			if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			{	
				url+="&isFromZoneInfra="+isFromZoneInfra;

				if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
					url+="&zoneName="+zoneName;
			}
		}*/
		else
		{
			if(ltype != null && ltest != null && ltype != 'null' && ltest != 'null' && ltype != undefined && ltest != 'undefined') 
			{
				
				url="/final/monitor/comparisonLogonSimulator.jsp?ltype="+ltype+"&ltest="+ltest+"&treeTitle="+treeTitle+"&monitorsBy="+monitorsBy;
				url=url+"&filterBy="+filterByComboVal+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+encodeURIComponent(nickNameVal);
			}
			else
			{
				url=Refurl;
				if(url.indexOf("externalAgent=")>-1 || url.indexOf("componentNameSearch=")>-1)
				{
					if(url.indexOf("externalAgent=")>-1 && extAgentVal != null && extAgentVal != 'null' && extAgentVal != undefined && extAgentVal != 'undefined')
					{
						url=url.replace(/(externalAgent=).*?(&)/,'$1' + extAgentVal + '$2');
					}
					if(url.indexOf("componentNameSearch=")>-1 && nickNameVal != null && nickNameVal != 'null' && nickNameVal != undefined && nickNameVal != 'undefined')
					{
						url=url.replace(/(componentNameSearch=).*?(&)/,'$1' + encodeURIComponent(nickNameVal) + '$2');
					}
				}
				else
					url=url+"&externalAgent="+extAgentVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+encodeURIComponent(nickNameVal);
			}

			if(isFromInfraHome != undefined && isFromInfraHome != null && isFromInfraHome != 'null' && isFromInfraHome != '' && (isFromInfraHome== true || isFromInfraHome=='true' ))
				url+="&isFromInfraHome="+isFromInfraHome;
			
			if(isFromZoneInfra != undefined && isFromZoneInfra != null && isFromZoneInfra != 'null' && isFromZoneInfra != '' && (isFromZoneInfra== true || isFromZoneInfra=='true' ))
			{	
				url+="&isFromZoneInfra="+isFromZoneInfra;

				if(zoneName != undefined && zoneName != null && zoneName != 'null' && zoneName != '' )
					url+="&zoneName="+zoneName;
			}
			if(isFromMenu != undefined && isFromMenu != null && isFromMenu != 'null' && isFromMenu != '' && (isFromMenu== true || isFromMenu=='true' ))
				url+="&isFromMenu="+isFromMenu;
		}
		url+="&isLogonType="+isLogonType;
		url += "&isIframe="+isIframe;
		url += "&selectedState="+selectedState;
		Refurl=url;

		var dashboardName = 'comparisonDashboard';
		if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
		{
			dashboardName = 'ExternalMonitor';
			//css_class='gridHeadercenter';
		}
		this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
	},
	
	searchAlarms:function(field, event ){
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			var itemIdVal=this.getCommonPanel().itemId;
			if(itemIdVal=='system' || itemIdVal=='System')
				this.compSubmitButtonClicked();
			else if(itemIdVal=='components' || itemIdVal=='Components')
				this.compSubmitButtonClicked();
			//field.focus();
		}
		else
		{
			var itemIdVal=this.getCommonPanel().itemId;
			if(itemIdVal=='system' || itemIdVal=='System')
				this.compSubmitButtonClicked();
			else if(itemIdVal=='components' || itemIdVal=='Components')
				this.compSubmitButtonClicked();
		}
		field.focus();
	},

	refresh:function()
	{
		var tabUrl1;

		if(Refurl!=null)
		{
			tabUrl1=Refurl;
		}
		
		if(Refid=='EmailPath')
		{
			Ext.getBody
			Ext.Ajax.request({
				url : tabUrl1,
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsondata = Ext.decode(jsonText);
						if(!jsondata.hasOwnProperty("error"))
						{
							var tabularView = Ext.ComponentQuery.query('[itemId="tabularView"]')[0];
							if(!Ext.isEmpty(tabularView) && !Ext.isEmpty(jsondata.measures))
							{
								tabularView.suspendLayouts();
								//tabularView.reconfigure(tabularView.getStore(), jsondata.columns);
								tabularView.jsonDataForDD = jsondata;
								tabularView.getStore().loadData(jsondata.measures);
								tabularView.resumeLayouts(true);	
								tabularView.getView().refresh();
							}
							else{
								var curViewPort=  Ext.getCmp('innerPanel');
								var css_class='gridHeadercenter iconGrid';
								var dashboardName = 'comparisonDashboard';
								if(!Ext.isEmpty(perf_id) && (perf_id=='ExtTestDashboard' || perf_id=='EmailPath'))
								{
									dashboardName = 'ExternalMonitor';
									css_class='gridHeadercenter';
								}
								if(isIframe)
								{
									curViewPort.header.hide();
								}
								else
								{
									curViewPort.setTitle(perf_disp_name);
									curViewPort.header.addClass("panelTitle");
								}
								//if(perf_id == "EmailPath")
									//css_class='';
								curViewPort.add({
									xtype:'generalMeasuresGridPanel',
									plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
									//title:titlesys,
									//title:perf_disp_name+" --Man At Work--",
									cls:css_class,
									//itemId:itemIdforsysandcom,
									itemId:perf_id,
									margin:0,
									padding:0,
									id:'perPanel',
									forceFit:true,
									frame:false,
									border:true,
									layout:{type:'vbox',align:'stretch'},
									flex:1,
									screenLabelPath:"monitor.Dashboard",
									url:perf_url,
									fromKioskMode : fromKioskMode,
									listeners: {
										'afterrender': function (obj) {
											this.loadTab(obj.url,'','','','',(isIframe)?true:'',dashboardName);
										}
									}
								});							
							}
						}
						else
						{
							var curViewPort=  Ext.getCmp('innerPanel');
							var css_class='gridHeadercenter iconGrid';
							var dashboardName = 'comparisonDashboard';
							if(!Ext.isEmpty(perf_id) && (perf_id=='ExtTestDashboard' || perf_id=='EmailPath'))
							{
								dashboardName = 'ExternalMonitor';
								css_class='gridHeadercenter';
							}
							if(isIframe)
							{
								curViewPort.header.hide();
							}
							else
							{
								curViewPort.setTitle(perf_disp_name);
								curViewPort.header.addClass("panelTitle");
							}
							//if(perf_id == "EmailPath")
								//css_class='';
							curViewPort.add({
								xtype:'generalMeasuresGridPanel',
								plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
								//title:titlesys,
								//title:perf_disp_name+" --Man At Work--",
								cls:css_class,
								//itemId:itemIdforsysandcom,
								itemId:perf_id,
								margin:0,
								padding:0,
								id:'perPanel',
								forceFit:true,
								frame:false,
								border:true,
								layout:{type:'vbox',align:'stretch'},
								flex:1,
								screenLabelPath:"monitor.Dashboard",
								url:perf_url,
								fromKioskMode : fromKioskMode,
								listeners: {
									'afterrender': function (obj) {
										this.loadTab(obj.url,'','','','',(isIframe)?true:'',dashboardName);
									}
								}
							});			

						}
						
						var ddPopupWindow = Ext.ComponentQuery.query('[itemId="popupWindow"]')[0];
						try
						{
							if(!Ext.isEmpty(ddPopupWindow))
							{
								var update = false;
								var index = null;
								var measuresGraphKeys = ddPopupWindow.measuresGraphKeys;
								var tagName = ddPopupWindow.itemData["0MeasureValue"];
								var gridData = tabularView.jsonDataForDD.measures;
								for(var t=0;t<gridData.length;t++)
								{
									//if(gridData[t]["rowIndex"] == ddPopupWindow["rowIndex"])
									//{
										if(tagName == gridData[t]["0MeasureValue"])
										{
											update = true;
											index = t;
											break;
										}
									//}
								}
								
								if(update && index != null)
								{
									var valueData = gridData[index];
									Ext.ComponentQuery.query('[itemId="1MeasureValue"]')[0].setHtml(valueData["3MeasureValueState"],valueData["3MeasureValue_org"]);
									Ext.ComponentQuery.query('[itemId="2MeasureValue"]')[0].setHtml(valueData["4MeasureValueState"],valueData["4MeasureValue"]);
									Ext.ComponentQuery.query('[itemId="3MeasureValue"]')[0].setHtml(valueData["5MeasureValueState"],valueData["5MeasureValue_org"]);
									Ext.ComponentQuery.query('[itemId="4MeasureValue"]')[0].setHtml(valueData["6MeasureValueState"],valueData["6MeasureValue"]);
									Ext.ComponentQuery.query('[itemId="5MeasureValue"]')[0].setHtml(valueData["7MeasureValueState"],valueData["7MeasureValue"]);

									for(var a=0;a<measuresGraphKeys.length;a++){
										var keyName = measuresGraphKeys[a];
										if(valueData.hasOwnProperty(keyName)){
											var newUrlHit = valueData[keyName].PARAMS;
											var newchartColor = valueData[keyName+'Color'];
											var panelSelector = Ext.ComponentQuery.query('[itemId="itemId'+a+'"]')[0]
											panelSelector.urlHit = newUrlHit;
											panelSelector.chartColor = newchartColor;
											panelSelector.setTitle(valueData[keyName].TITLE);
											panelSelector.ajaxHit();
										}
									}
								}
								else
									ddPopupWindow.close();
							}
							
						}
						catch (er)
						{
							//console.log("er=-=-=-=-=->",er);
						}						
					}
				}
			});
		}
		else if(Refid=='ExtTestDashboard' || Refid=='system' || Refid=='component' || Refid=='components' || Refid=='network' ||(!Ext.isEmpty(simulationSupportList) && simulationSupportList.indexOf(Refid) != -1))
		{
			var curViewPort=  Ext.getCmp('innerPanel');
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			var cls='';
			if(!Ext.isEmpty(simulationSupportList) && simulationSupportList.indexOf(Refid) != -1)
			{
				cls = 'gridHeadercenter iconGrid';
			}

			if(showGraph != null && (showGraph == 'true' || showGraph == 'TRUE'))
			{
				var panelArr = new Array();
				var transurl = '/final/monitor/simulationGraph.jsp?treeTitle=services&site='+selectedParam+'&mHost='+selectedExtAgent;


				Ext.Ajax.request({
					url : transurl,
					scope:this,
					success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsondata2 = Ext.decode(jsonText);
							if(jsondata2 != null && jsondata2 != undefined)
							{
								panelArr.push({
									xtype:'generalMeasuresGridPanel',
									//cls:'iconGrid',
									itemId:Refid,
									margin:0,
									padding:0,
									id:'perPanel',
									frame:false,
									border:true,
									forceFit:true,
									//layout:{type:'vbox',align:'stretch'},
									//flex:0.4,
									layout:'fit',
									//height:'50%',
									screenLabelPath:"monitor.Dashboard",
									url:tabUrl1,
									listeners: {
										'afterrender': function (obj) {
											this.loadTab(obj.url,Reftot,RefpageVal,'','',(isIframe)?true:'','comparisonDashboard');
											
										},
										'render':function(obj){
												//console.log('this.getDockedItems--------------',this.getDockedItems());
												var header=this.getDockedItems();
												//obj.removeDocked();
												//alert(Ext.getCmp("innerPanel"));

												//Ext.get("Main-body").setStyle('backgound','none !important');
												//Ext.get("innerPanel-body").setStyle('backgound','none !important');
												
												//Ext.getCmp("innerPanel").getEl().setStyle('margin','0px');
												//Ext.get("Main-body").setStyle('margin','0px !important');


												if (Ext.getCmp("innerPanel_header"))
												{
													Ext.getCmp("innerPanel_header").hide();
													
													
												}

										}
									}
								});
								panelArr.push({
									xtype:'simulationsChartPanel',
									columnWidth:1.0,
									jsonData:jsondata2,
									margin:'5 6 0 6',
									padding:0,
									//flex:0.57,
									border:false,
									height:300,
								});
								curViewPort.add(panelArr);
							}
						}
					  },
					failure:function(){
						window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
			else
			{
				var dashboardName = 'comparisonDashboard';
				if(Refid=='ExtTestDashboard')
				{
					dashboardName = 'ExternalMonitor';					
				}
				curViewPort.setTitle(Reftext);
				curViewPort.header.addClass("panelTitle");
				if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
					cls='gridHeadercenter';

				curViewPort.add({
					xtype:'generalMeasuresGridPanel',
					//title:Reftext,
					cls:cls,
					itemId:Refid,
					margin:0,
					padding:0,
					frame:false,
					border:true,
					forceFit:true,
					id:'perPanel',
					layout:{type:'vbox',align:'stretch'},
					//flex:1,
					screenLabelPath:"monitor.Dashboard",
					url:tabUrl1,
					listeners: {
						'afterrender': function (obj) {
							this.loadTab(obj.url,Reftot,RefpageVal,'','',(isIframe)?true:'',dashboardName);
							//this.loadTab(obj.url);
						}
					}
				});
			}
		}
		else
		{
			var titlesys="Systems";
			var itemIdforsysandcom="system";
			var curViewPort=  Ext.getCmp('innerPanel');
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			if(tabUrl1.indexOf("treeTitle=System") > -1)
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}
			else if(tabUrl1.indexOf("treeTitle=Component") > -1)
			{
				titlesys='Components';
				itemIdforsysandcom="components";
			}
			else if(tabUrl1.indexOf("treeTitle=ExternalMonitor") > -1)
			{
				titlesys=perf_disp_name;
				itemIdforsysandcom="externalMonitor";
			}
			else
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}
			//perf_disp_name
			//alert('titlesys-->'+titlesys)
			curViewPort.setTitle(titlesys);
			curViewPort.header.addClass("panelTitle");
			curViewPort.add({
				xtype:'generalMeasuresGridPanel',
				//title:titlesys,
				cls:'gridHeadercenter iconGrid',
				itemId:itemIdforsysandcom,
				margin:0,
				padding:0,
				frame:false,
				forceFit:true,
				id:'perPanel',
				border:true,
				layout:{type:'vbox',align:'stretch'},
				flex:1,
				screenLabelPath:"monitor.Dashboard",
				url:tabUrl1,
				listeners: {
					'afterrender': function (obj)
					{
						this.loadTab(obj.url,Reftot,RefpageVal,'','',(isIframe)?true:'','comparisonDashboard');
						//this.loadTab(obj.url);
					}
				}
			});
		}
	},
	openServiceConfigWindow : function(button){
		var VWidth = Ext.Element.getViewportWidth( );
		if(!this.getConfigWindow())
		{
			var win=Ext.create('services.view.ConfigWindow');
			win.show();
			container = Ext.create('Ext.container.Container',{
				padding:10,
				floating:true,
				frame:true,
				width:600,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'508px'}
					},
					{
						xtype:'container',
						margin:'-4px 0px 6px 4px',
						html:'<div class="settingsfont" style="float:left;color:#f7f7f7;text-transform:uppercase">Settings</div><div style="text-align:right;float:right;"><div class="iconClose3"></div></div>',
					},
						win
				]
			});
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:50,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
					Ext.create('Ext.fx.Anim', {
						target: container,
						duration: 500,
						from: {
						left: VWidth -615,
							top:50
						},
						to: {
						   top:-500,
						left: VWidth -615
						},
						callback: function(){
							container.hide();
						}
					});
			},this);
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
					top:50,
					left: VWidth -615
				}
			});
			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
		}
	},
	monitorTypeComboChange:function(combo){
		var monitorsByComboVal=combo.getValue();
		var url="/final/monitor/comparisonExternalMonitor.jsp?treeTitle=ExternalMonitor";
			url=url+"&monitorsBy="+monitorsByComboVal;
			Refurl=url;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('locationCombo');
					//componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					//componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					//componentTypCombo.setValue('Madurai');
					//componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
					this.submitButtonChange();
				}
			});
		},
		submitButtonChange:function(){
			var filterByComboVal="";
			if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
			{
				filterByComboVal = Ext.getCmp('filterByCombo').getValue();
			}

			var subFilterComboVal="";
			if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
			{
				subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
			}
			var monitorsComboVal="";
			if(Ext.getCmp('monitorsCombo')!=null && Ext.getCmp('monitorsCombo')!=undefined && Ext.getCmp('monitorsCombo').getValue()!=null && Ext.getCmp('monitorsCombo').getValue()!='null')
			{
				monitorsComboVal = Ext.getCmp('monitorsCombo').getValue();
			}

			var locationComboVal="";
			if(Ext.getCmp('locationCombo')!=null && Ext.getCmp('locationCombo')!=undefined && Ext.getCmp('locationCombo').getValue()!=null && Ext.getCmp('locationCombo').getValue()!='null')
			{
				locationComboVal = Ext.getCmp('locationCombo').getValue();
			}
			var nickNameVal="";
			if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
			{
				nickNameVal = Ext.getCmp('nickName').getValue();
			}

			var url="/final/monitor/comparisonExternalMonitor.jsp?treeTitle=ExternalMonitor";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal+"&monitorsBy="+monitorsComboVal+"&locationBy="+locationComboVal;
			var url = url;
			Refurl=url;
			var dashboardName = 'comparisonDashboard';
			if(!Ext.isEmpty(perf_id) && perf_id=='ExtTestDashboard')
			{
				dashboardName = 'ExternalMonitor';
				//css_class='gridHeadercenter';
			}
			this.getCommonPanel().loadTab(url,'','','','',(isIframe)?true:'',dashboardName);
		},
		onChartsPanelRender:function(panel){
			this.displayGraphInitially(panel.jsonData);
		},

		timelineChangeHandler:function(combo){
	    	  var timelineValue=combo.getValue();
	    	  if(timelineValue=="Any"){
	    		  this.enableDisableDateFields(true);
	    	  }else{
	    		  this.enableDisableDateFields(false);
	    	  }
	    	  var chartToolbar=this.getSimulationsPanelToolbar();
	    	  
	    	  var chartPanel=this.getSimulationsChartPanel();
	    	  var remoteURL=chartPanel.jsonData.HiddenFields.remoteURL;
	    	  var format=chartPanel.jsonData.HiddenFields.currentDateFormat;
	    	  
	    	  var starttime="";
    		  var startTimeField=chartToolbar.getComponent("from");
    		  if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
    			  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);

    		  }
    		  
	    	  var endtime="";
    		  var endTimeField=chartToolbar.getComponent("to");
    		  if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
    			  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
    		  }
    		  
    		  var startHr="";
    		 var fromCombo=chartToolbar.getComponent("fromhr");
    		  if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
    			  startHr=fromCombo.getValue();
				  				  
    		  }			  

			var endHr="";
    		  var toCombo=chartToolbar.getComponent("tohr");
    		  if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
    			  endHr=toCombo.getValue();
    		  }

             //Get Minutes
			 var startMin="";
    		 var fromMinCombo=chartToolbar.getComponent("frommin");
    		  if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
    			  startMin=fromMinCombo.getValue();
				  				  
    		  }			

			  var endMin="";
    		  var toMinCombo=chartToolbar.getComponent("tomin");
    		  if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
    			  endMin=toMinCombo.getValue();
    		  }
			  var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&P6=['+startMin+']&P7=['+endMin+']&C=1&calljson=true';
			  Ext.Ajax.request({
				  url: remoteURL,
				  scope:this,
				  method: 'POST',
				  params: paramValues,
				  success: function( response )
				  {
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						this.setTime(jsonData.getTime,timelineValue);
					}
				  },
					failure:function(){
						window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
			});
      },
		enableDisableDateFields:function(enable){
	    	  var chartToolbar=this.getSimulationsPanelToolbar();
	    	  var startTimeField=chartToolbar.getComponent("from");
	    	  var endTimeField=chartToolbar.getComponent("to");
	    	  var fromCombo=chartToolbar.getComponent("fromhr");
	    	  var toCombo=chartToolbar.getComponent("tohr");
	    	  
	    	  if(enable){
	    		  startTimeField.setDisabled(false);
	    		  endTimeField.setDisabled(false);
	    		  fromCombo.setDisabled(false);
	    		  toCombo.setDisabled(false);
	    	  }else{
	    		  startTimeField.setDisabled(true);
	    		  endTimeField.setDisabled(true);
	    		  fromCombo.setDisabled(true);
	    		  toCombo.setDisabled(true);
	    	  }
	    },
		setTime:function(timeVal,timelineValue){	
	    		var arrOptions = timeVal.split('\t');
				var frHr="",toHr="";
				var frMin="",toMin="";
	    		time_line_obj=new Object();
	    		time_line_obj.starttime=arrOptions[0];
				var startdt ="",enddt="";

				if(timelineValue=="Any"){
					 startdt = Ext.Date.format(arrOptions[6],mgr_dateFormat);
					 enddt = Ext.Date.format(arrOptions[7],mgr_dateFormat);
				}
				else
			    {
					startdt = new Date(arrOptions[6]);
					enddt = new Date(arrOptions[7]);

					 startdt = Ext.Date.format(arrOptions[6],mgr_dateFormat);
					 enddt = Ext.Date.format(arrOptions[7],mgr_dateFormat);
				}
				if(startdt == "Invalid Date" || startdt =="" )
					startdt = arrOptions[6];
				if(enddt == "Invalid Date" || enddt =="" )
					enddt = arrOptions[7];
				var tmp_start_date="",tmp_end_date="";
				tmp_start_date= Ext.Date.format(startdt,mgr_dateFormat);
				tmp_end_date = Ext.Date.format(enddt,mgr_dateFormat);
				startdt = (tmp_start_date == "")?startdt:tmp_start_date;
				enddt = (tmp_end_date == "")?enddt:tmp_end_date;
				this.getSimulationsPanelToolbar().getComponent("from").setValue(startdt);
				
	    		time_line_obj.endtime=arrOptions[1];
				this.getSimulationsPanelToolbar().getComponent("to").setValue(enddt);
	    		time_line_obj.starthr=arrOptions[2];
				 if(timelineValue=="Any"){
					frHr = arrOptions[8];
					toHr = arrOptions[9];
				 }
				 else
				  {
					frHr = arrOptions[8];
					toHr = arrOptions[9];
				  }

				  //set Min
				frMin = arrOptions[10];
				toMin = arrOptions[11];
				this.getSimulationsPanelToolbar().getComponent("frommin").setValue(frMin);
				this.getSimulationsPanelToolbar().getComponent("tomin").setValue(toMin);
				this.getSimulationsPanelToolbar().getComponent("fromhr").setValue(frHr);
	    		time_line_obj.endhr=arrOptions[3];
				this.getSimulationsPanelToolbar().getComponent("tohr").setValue(toHr);
				var chartToolbar=this.getSimulationsPanelToolbar();
			},
		displayGraph:function(){
			this.getSimulationComboMode().hide();
			var chartPanel=this.getSimulationsChartPanel();
			if(!Ext.isEmpty(chartPanel) && !Ext.isEmpty(chartPanel.jsonData)){
				var jsonData=chartPanel.jsonData;
				var mode="";
				var starttime="";
				var endtime="";
				var startHr="";
				var startMin="";
				var endHr="";
				var endMin="";
				var time_line="";
				var dateError = '';
	    		var chartToolbar=this.getSimulationsPanelToolbar();
	    		var modeCombo=chartToolbar.getComponent("mode");
	    		if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
	    			  mode=modeCombo.getValue();
					  timelineGraphParamJson['mode']=mode;
	    		}
	    		var startTimeField=chartToolbar.getComponent("from");
	    		if(!Ext.isEmpty(startTimeField)){
					if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
						  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
						  timelineGraphParamJson['starttime']=starttime;
					}else{
						  if(!Ext.isEmpty(time_line_obj)){
							  starttime=time_line_obj.starttime;
							  timelineGraphParamJson['starttime']=starttime;
						  }else{
							  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
							  timelineGraphParamJson['starttime']=starttime;
						  }
					}
	    		}
	    		  
	    		  var endTimeField=chartToolbar.getComponent("to");
	    		  if(!Ext.isEmpty(endTimeField)){
	    			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
	    				endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
						timelineGraphParamJson['endtime']=endtime;
	    			  }else{
						  if(!Ext.isEmpty(time_line_obj)){
							  endtime=time_line_obj.endtime;
							  timelineGraphParamJson['endtime']=endtime;
						  }else{
							  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
							  timelineGraphParamJson['endtime']=endtime;
						  }
	    			  }
	    		  }
	    		
	    		var fromCombo=chartToolbar.getComponent("fromhr");
	    		if(!Ext.isEmpty(fromCombo)){
	    			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
	    				startHr=fromCombo.getValue();
						 timelineGraphParamJson['starthr']=startHr;
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  startHr=time_line_obj.starthr;
							  timelineGraphParamJson['starthr']=startHr;
							   
	    				  }else{
	    						startHr=fromCombo.getValue();
								timelineGraphParamJson['starthr']=startHr;
							}
	    			}
	    		}

	    		  var toCombo=chartToolbar.getComponent("tohr");
	    		  if(!Ext.isEmpty(toCombo)){
	    			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
	    				  endHr=toCombo.getValue();
						  timelineGraphParamJson['endhr']=endHr;
	    			}else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    						endHr=time_line_obj.endhr;
								timelineGraphParamJson['endhr']=endHr;
	    				  }else{
	    						endHr=toCombo.getValue();
								timelineGraphParamJson['endhr']=endHr;
	    				  }
	    			  }
	    		  }			

				   //Get Minutes
			 var startMin="";
    		 var fromMinCombo=chartToolbar.getComponent("frommin");
    		  if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
    			  startMin=fromMinCombo.getValue();
				  timelineGraphParamJson['startmin']=startMin;
				  				  
    		  }			

			  var endMin="";
    		  var toMinCombo=chartToolbar.getComponent("tomin");
    		  if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
    			  endMin=toMinCombo.getValue();
				  timelineGraphParamJson['endmin']=endMin;
    		  }

				 var timeLineCombo=this.getSimulationComboTimeline();
	    		  if(timeLineCombo.getValue() =="Any"){
						var dateError = startTimeField.getName();
						var currentDateError = endTimeField.getName()
						var startTime = startTimeField.getValue();
						var endTime = endTimeField.getValue();
						var curTime = curDateTime;
						var currentMgrDate = new Date(curTime);
						var starttime= formatDate(startTime, "MM/dd/yyyy");
						var endtime= formatDate(endTime, "MM/dd/yyyy");
								
						if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
						{
							var msg ="From date should be lesser than to date";
							Ext.Msg.alert('Error', dateError);
							return;
						}
	    		}
	    		 
	    		  this.anyStartTime=starttime;
				  this.anyEndTime=endtime;
				  this.anyStartHr=startHr;
				  this.anyEndHr=endHr;
	    		  var timelineCombo=chartToolbar.getComponent("timeline");
	    		  if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
	    			  time_line=timelineCombo.getValue();
					  timelineGraphParamJson['time_line']=time_line;
	    		  }
				  parent.Ext.getCmp('logonSimCompId').timelineParamJson=timelineGraphParamJson;
	    		  var chartPanel=this.getSimulationsChartPanel();
	    		 
				  var cdate = this.getCurrentDateTime();
				  var chartOption = chartGraphType(cdate);
	    		  this.transactionMeasuresParam={
							 startTrans:'',
			    		     site:"NULL",
			    		     comp:jsonData.HiddenFields.compName,
			    		     test:jsonData.HiddenFields.testForTab,
			    		     measure:jsonData.HiddenFields.measurelst,
			    		     gformat:"graph",
							 chartType:chartOption,
			    		     GraphSize:"true",
			    		     monitorSkin:jsonData.HiddenFields.monitorSkin,
			    		     mode:'2D',
			    		     starttime:startTimeField.getRawValue(),
			    		     endtime:endTimeField.getRawValue(),
			    		     starthr:startHr,
			    		     endhr:endHr,
							 startmin:startMin,
							 endmin:endMin,
							 time_line:time_line,
			    		     all_trans_names:jsonData.HiddenFields.all_trans_names,
			    		     msmt_host:jsonData.HiddenFields.mHost,
							 endTrans:'',
							 isAreaChart:isAreaChart,
							 isLogonType:isLogonType
			    	  	  };
					transParam = this.transactionMeasuresParam;
				  if(chartOption.indexOf("highchart") > -1)
				  {
					  this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
					  this.getSimulationComboMode().hide();
				  }
				  else
				  {
					  this.getSimulationComboMode().hide();
					  chartPanel.getEl().mask("Loading...");
					Ext.Ajax.request({
		    		  url : this.transactionMeasuresChartURL,
		    		  params: this.transactionMeasuresParam,
					  method:'get',
		    		  scope:this,
		    		  success: function(response){
		    	  		  		var chartPnl=this.getSimulationsChartPanel();
		    	  		  		chartPnl.getEl().unmask();
		    	  		  		this.createGraphs(response);
		    			  	},
		    				failure:function(){
		    			  		var chartPnl=this.getSimulationsChartPanel();
		    	  		  		chartPnl.getEl().unmask();
		    			  	}
		    	  });
	    	  }
			  }
	      },
		displayGraphInitially:function(jsonData){
	    	 var  mode=jsonData.HiddenFields.mode
	    	 var  starttime=jsonData.HiddenFields.starttime
	    	 var  endtime=jsonData.HiddenFields.endtime
	    	 var  starthr=jsonData.HiddenFields.startHr
	    	 var  endhr=jsonData.HiddenFields.endHr
	    	 var  time_line=jsonData.HiddenFields.time_line
			 var  startmin = jsonData.HiddenFields.startMin
			 var  endmin = 	 jsonData.HiddenFields.endMin

	    	 var cdate = this.getCurrentDateTime();
			 var chartOption = chartGraphType(cdate);

			starttime=Ext.Date.format(new Date(starttime),mgr_dateFormat);
			endtime=Ext.Date.format(new Date(endtime),mgr_dateFormat);

			if(!Ext.isEmpty(refresh) && refresh != null && refresh != undefined && (refresh==true || refresh == 'true')){
	    		   mode=timelineParamJson.mode
		    	   starttime=timelineParamJson.starttime
		    	   endtime=timelineParamJson.endtime
		    	   starthr=timelineParamJson.starthr
		    	   endhr=timelineParamJson.endhr
				   startmin = timelineParamJson.startmin
				   endmin=timelineParamJson.endmin 
		    	   time_line=timelineParamJson.time_line
	    	 }
				
	    	 this.transactionMeasuresParam={
	    		     //site:jsonData.HiddenFields.siteName,
					 site:"NULL",
	    		     comp:jsonData.HiddenFields.compName,
	    		     test:jsonData.HiddenFields.testForTab,
	    		     measure:jsonData.HiddenFields.measurelst,
	    		     gformat:"graph",
	    		     GraphSize:"true",
	    		     monitorSkin:jsonData.HiddenFields.monitorSkin,
	    		     mode:mode,
	    		     starttime:starttime,
	    		     endtime:endtime,
	    		     starthr:starthr,
					 startmin:startmin,
                 
					 //starthr:startHr,
	    		     endhr:endhr,
					 endmin:endmin,
	    		     time_line:time_line,
	    		     all_trans_names:jsonData.HiddenFields.all_trans_names,
	    		     msmt_host:jsonData.HiddenFields.mHost,
					 isAreaChart:isAreaChart,
					 isLogonType:isLogonType
	    	  	  };
				transParam = this.transactionMeasuresParam;
	    	  if(!Ext.isEmpty(jsonData.HiddenFields)){
				  var cdate = this.getCurrentDateTime();
				  var chartOption = chartGraphType(cdate);
				  if(chartOption.indexOf("highchart") > -1)
				  {
					  this.getSimulationComboMode().hide();
					  this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				  }
				  else
				  {
					  this.getSimulationComboMode().hide();
					 var chartPnl=this.getSimulationsChartPanel();
					 chartPnl.setLoading(true,true);
					  Ext.Ajax.request({
						  url : this.transactionMeasuresChartURL,
						  params:this.transactionMeasuresParam,
						  scope:this,
						  success: function(response){
									this.createGraphs(response);
									chartPnl.setLoading(false);
								},
								failure:function(){
									//alert('2')
									//window.parent.location.href="/final/servlet/com.egurkha.Logout";
								}
					  });
				  }
	    	  }
	      },

		getCurrentDateTime:function(){
		var endHr="";
		var startHr="";
		var starttime="";
		var endtime="";
		var time_line ="";
		var chartToolbar=this.getSimulationsPanelToolbar();
		var timelineCombo=chartToolbar.getComponent("timeline");
		if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
						  time_line=timelineCombo.getValue();
					  }
		 var startTimeField=chartToolbar.getComponent("from");
		  if(!Ext.isEmpty(startTimeField)){
			  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  starttime=time_line_obj.starttime;
				  }else{
					  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
				  }
			  }
		  }
		  
		  var endTimeField=chartToolbar.getComponent("to");
		  if(!Ext.isEmpty(endTimeField)){
			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
			  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  endtime=time_line_obj.endtime;
				  }else{
					  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
				  }
			  }
		  }
		
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo))
			{
			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
				startHr=fromCombo.getValue();
				 
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  startHr=time_line_obj.starthr;
					   
				  }else{
						startHr=fromCombo.getValue();
					}
			}
		}

		  var toCombo=chartToolbar.getComponent("tohr");
		  if(!Ext.isEmpty(toCombo)){
			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
				  endHr=toCombo.getValue();
			}else{
				  if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
				  }else{
						endHr=toCombo.getValue();
				  }
			  }
		  }
		starttime = Ext.Date.dateFormat(startTimeField.getValue(), 'm/d/Y');
		endtime = Ext.Date.dateFormat(endTimeField.getValue(), 'm/d/Y');
		var retDate = time_line+":"+starttime+":"+startHr+":"+endtime+":"+endHr;
		return retDate;
	},
	createHighStockChart:function(url,param){
			var seriesOptions = [],
			yAxisOptions = [],
			seriesCounter = 0;
			var title = "";
			var colors = "";
			var fmts = "";
			var axisTitle = "";
			var min = "";
			var max = "";
			var xmax = "";
			var xmin = "";
			var lineWidth = "";
			var TotalTd = 0;
			var cell_count=0;
			var itemsArray=[];
			var tdValues="";
			 var chartPanel=this.getSimulationsChartPanel();
			var measures=chartPanel.jsonData.HiddenFields.measurelst;
			var measure_list_value=measures.split(",");
			var tab="Web";
			
			var firstCmp = Ext.getCmp('firstid');
			var midCmp = Ext.getCmp('midid');
			var lastCmp = Ext.getCmp('lastid');

			if(!Ext.isEmpty(errorPanel) && errorPanel==true)
			{
				chartPanel.update("");
				if(!Ext.isEmpty(firstCmp))
					chartPanel.remove(firstCmp);
				if(!Ext.isEmpty(midCmp))
					chartPanel.remove(midCmp);
				if(!Ext.isEmpty(lastCmp))
					chartPanel.remove(lastCmp);
			}
			var me = this;
			 var chartPnl=this.getSimulationsChartPanel();
			chartPnl.setLoading(true,true);
			Ext.Ajax.request(
			{
				url : url,
				params:param,
				scope:this,
				success: function(response) 
				{	
					if(response.status == 200 && !Ext.isEmpty(response))
					{
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var data=Ext.decode(jsonText);
							if(!Ext.isEmpty(data))
							{
								var chartData=[];
								var htmlStr1='';
								var htmlStr2='';
								var htmlStrMid='';
								var itemsArray=[];
								var highChartUrls = new Array();
								var highChartIds = new Array();
								var highChartFmts = new Array();
								var highChartXmax = new Array();
								var highChartXmin = new Array();
								var highChartMax = new Array();
								var highChartAxislabel = new Array();
								var highChartSeriesOptions = new Array();
								var highChartTotalTd = new Array();
								var highChartColor = new Array();
								var highChartTitle = new Array();
								var size = 0;
								var tmp_div_size_of_td = 0;
								var itemInc = 0;
								for(var inc in data)
								{
									if(inc.indexOf("chart") > -1)
										size = size+1;
								}
								me.createDivforHighChart(size);
								if(size > 0 )
								{
									var styleAttrbs=new Object();
									styleAttrbs['fontFamily']='Arial';
									styleAttrbs['fontSize']='11px';
									
									styleAttrbs['axisLabelGridColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
									styleAttrbs['axisLabelColor']= ( strSkin == 'Light' )?'#969696':'#c6c6c6';
									styleAttrbs['axisLabelFontFmy']='Arial';
									styleAttrbs['axisLabelFontSize']='11px';
									styleAttrbs['axisLabelLineColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
									styleAttrbs['axisLabelMinorGrid']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
									styleAttrbs['axisLabelTickColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
									styleAttrbs['axisTitleColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
									styleAttrbs['axisTitleFontFmy']='Arial';
									styleAttrbs['axisTitleFontSize']='11px';


									styleAttrbs['TooltipFontFmy']='Arial';
									styleAttrbs['TooltipFontSize']='11px';
									styleAttrbs['TooltipBgColor']= ( strSkin == 'Light' )?'white':'#161616';
									styleAttrbs['TooltipBorderColor']= ( strSkin == 'Light' )?'black':'#0c0c0c';

									styleAttrbs['legendFontFmy']='Arial';
									styleAttrbs['legendFontSize']='12px';
									styleAttrbs['legendColor']= ( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
									styleAttrbs['titleFontClr']=( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
									styleAttrbs['titleFontFmy']='Roboto-Bold';
									styleAttrbs['titleFontSize']='13px';
									styleAttrbs['lineThickness']='2';

									var styleObj = data["styles"];
									/*if(!Ext.isEmpty(styleObj['axisLabelStyle']))
									{
										styleAttrbs['capFontClr'] = styleObj['axisLabelStyle'].COLOR;
										styleAttrbs['capFontFmy'] = styleObj['axisLabelStyle'].FAMILY;
										styleAttrbs['capFontSize'] = styleObj['axisLabelStyle'].SIZE;
										styleAttrbs['capFontWgt'] = styleObj['axisLabelStyle'].WEIGHT;
									}
									
									if(!Ext.isEmpty(styleObj['timeLabelStyle']))
									{
										styleAttrbs['xlabelfontClr'] = styleObj['timeLabelStyle'].COLOR;
										styleAttrbs['xlabelfontFmy'] = styleObj['timeLabelStyle'].FAMILY;
										styleAttrbs['xlabelfontSize'] = styleObj['timeLabelStyle'].SIZE;
										styleAttrbs['xlabelfontWgt'] = styleObj['timeLabelStyle'].WEIGHT;
									}
									if(!Ext.isEmpty(styleObj['panelLineStyle']))
									{
										styleAttrbs['plotPanelColor']=styleObj['panelLineStyle'].COLOR;
										styleAttrbs['lineThickness']=styleObj['panelLineStyle'].LINETHICKNESS;
									}*/

									for(var mainKey in data)
									{
										var dataOfKey = data[mainKey];
										if( mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") == -1)
										{
											for ( var key in dataOfKey )
											{
												if(!isNaN(key))
												{
													title = dataOfKey[key]['title'];
													fmts = dataOfKey[key]['fmts'];
													axisTitle = dataOfKey[key]['axislabel'];
													xmax = dataOfKey[key]['xmax'];
													xmin = dataOfKey[key]['xmin'];
													max = dataOfKey[key]['max'];
													colors = dataOfKey[key]['color'],
													lineWidth = dataOfKey[key]['lineWidth'],
													seriesOptions[key] =
													{
														name: dataOfKey[key]['name'],
														data: dataOfKey[key]['data'],
														color: dataOfKey[key]['color'],
														dataGrouping: {
															enabled: false
														}
													};
												}
												highChartColor.push(colors);
											}
											highChartTitle.push(title);
											highChartFmts.push(fmts);
											highChartXmax.push(xmax);
											highChartXmin.push(xmin);
											highChartMax.push(max);
											highChartAxislabel.push(axisTitle);
											highChartSeriesOptions.push(seriesOptions);
											highChartTotalTd.push(TotalTd);
											//highChartColor.push(colors);
											//if(TotalTd == 3)
											if(TotalTd == 3 || (this.tab=="emulated" && TotalTd ==1) ) //fix for emulated legends
											{
													var Legend_Total = seriesOptions.length;
													var tdValues="<table align='right' style='margin-top:5px'><tr>";
													if(Legend_Total!=null && Legend_Total!='')
													{
														for(var z=0;z<Legend_Total;z++)
														{
															var LegendTdName    =seriesOptions[z].name;
															if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
															{
																var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
																//var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
																tdValues=tdValues+"<td width='10' height='10' align='center'>";
																tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
																tdValues=tdValues+"<tr>";
																//tdValues=tdValues+"<td width = '10' style='background:#"+color_code_temp+"' class='linesquare_white' height='10'><img src = '/final/monitor/eg_images/spacer.gif' width = '10' height = '10' border = '0'></td></tr></table></td>";
																tdValues=tdValues+"<td nowrap style='width:40px;padding-right:10px; height:10px' >"+trans_name_temp+"</td>";
															}
															else
															{
																tdValues=tdValues+"<td width='10' height='10' align='center'>";
																tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
																tdValues=tdValues+"<tr>";
																tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+highChartColor[z]+";height:8px;width:8px' ><div></td></tr></table></td>";
																tdValues=tdValues+"<td nowrap class='font_normal11' style='padding-left:5px;padding-right:15px; height:10px' >"+LegendTdName+"</td>";
															}
														}
													}
													tdValues = tdValues+"</tr></table>";
													var legContainer = Ext.get('legends');
													if(!Ext.isEmpty(legContainer))
													{
														Ext.getCmp('legends').update(tdValues);
													}
											}
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs);
											Ext.getCmp('transchart'+TotalTd).setTitle('<span style="display:block;text-align:center !important" class="font_bold13 fontStyleRobot">'+title+'</span>');
											TotalTd = TotalTd+1;
											itemInc = itemInc+1;
											chartPanel.getEl().unmask();
											chartPnl.setLoading(false);
										}
										else
										{
											if(  mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") > -1 )
											{
												var myImgHtml = '<div style="margin:12% 0 auto 25%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"  /></div>';
												if( itemInc < size )
												{
													var timTitle = dataOfKey.substring(4);
													Ext.getCmp('transchart'+itemInc).setTitle('<span style="display:block;text-align:center !important" class="font_bold13 fontStyleRobot">'+timTitle+'</span>');
													Ext.getCmp('transchart'+itemInc).setHeight(240);
													Ext.getCmp('transchart'+itemInc).update(myImgHtml);
													itemInc = itemInc+1;
												}
											}
											chartPnl.setLoading(false);
										}
									}
									errorPanel = false;
								}
								else
								{
									this.displayErrorMsg();
								}
								errorPanel = false;
							}
							else
							{
								this.displayErrorMsg();
							}
							errorPanel = false;
						}
						else
						{
							this.displayErrorMsg();
						}
					}
				},
				failure:function(){
					//alert('1')
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		  },
		  createDivforHighChart:function(size){
			  var chartPanel=this.getSimulationsChartPanel();
			  var imgDiv = '';
			  if(this.tab=='emulated')
					tmp_div_size_of_td=size;
			  else
					tmp_div_size_of_td=(size/2);
				var inc = 0;
				var chartPane = '',legendPanel = '';
				chartPanel.removeAll();
				var scrollPanel=Ext.create('utilities.ScrollPanel',{
					layout:{type:'vbox',align:'stretch'},
					padding:'0 15 15 15',
					//flex:1,
					items:[
						{
							xtype:'container',
							id:'legends'
						},
						{
							xtype : 'container',
							border:true,
							//padding:'20 0 0 0',
							layout:'column',
							id:'midid',
							defaults:{
								columnWidth:.33,
								//minHeight: 280
							},
							items:this.getItems(size)
						}
					]
				});
				chartPanel.add(scrollPanel);
				chartPanel.doLayout();
		},
			getItems:function(size){
			   var skinBg="";

				if (strSkin=="Dark")
				{
					skinBg="#444444";
				}
				else if (strSkin=="Light")
				{
					skinBg="#ffffff";
				}
				var items=[];
				for(var i=0;i<size;i++){
					var idName ='transchart'+i; 
					var borderright="1px solid #f2f2f2 !important";
					var borderbottom="1px solid #f2f2f2 !important";
					if (i != 0 && i%2==0)
					{
						borderright="0px solid #f2f2f2 !important";
						
					}
				    items.push({
						xtype: 'panel',
						ui:'newPlainPanel',
						border:true,
						//padding:'10 0 10 0',
						bodyStyle:{background: skinBg+'!important',borderRight:borderright, borderBottom: borderbottom},
					/*tools:[
						{
							xtype:'toolbar',
							ui:'footer',
							items:[
								{
									xtype:'button',
									border:0,
									id:'highMax'+i,
									cls:'iconMaximize showgraph',
									handler:function(){
										var idStr = this.getId();
										idStr = idStr.substring(7);
										parent.showGraph('event',idStr,transParam);
									}
								}	
							]
						}	 
					 ],*/
					 margin:'10 0 0 0',
					 frame:true,
					 //padding:'30 0 10 0',
				     title:'',
					 id:idName
					})
				}
			
			return items;
		  },
		displayErrorMsg:function(){
			  errorPanel = true;
	    	  var chartPanel=this.getSimulationsChartPanel();
			  var pHeight=Ext.getBody().getViewSize().height-685;

			 //chartPanel.setHeight(pHeight);
			chartPanel.setHeight(Ext.getBody().getViewSize().height-385)

			if ( errorPanel = true)
			{
				if (screen.height<=768)
				 {
					chartPanel.setHeight(Ext.getBody().getViewSize().height-855);
					 //$("#citrix_ground").css("overflow", "hidden !important");
				 }
				 else
				 {
					chartPanel.setHeight(Ext.getBody().getViewSize().height-272);
					// $("#citrix_ground").css("overflow", "hidden !important");
					$("#citrix_ground").scroll(false)
				 }
			}

		
			  
			  chartPanel.setLoading(false);
	    	  var htmlStr='<table width="100%" height="100%"><tr style="text-align:center;" width="100%" height="100%"><td width="100%" height="100%">';
			  htmlStr+='<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div>No measure available for the current selection</div></div>'
	    	  htmlStr+='</td></tr></table>';
			  chartPanel.removeAll();
			  chartPanel.update(htmlStr);
		},
		settingClick:function(image){
			var timlinePos=Ext.getCmp("settingBt").getPosition();
			var winObj = Ext.getCmp('timeWindow');
			winObj.showAt([timlinePos[0]-680,timlinePos[1]+20]);

	},
	autoScrollTvMode:function(domID){
			if (!Ext.isEmpty(window.parent.isTvMode)) {
				//has scroll plugin
				$.fn.hasScrollBar = function() {
					return this.get(0).scrollHeight - 40 > this.height();
				}
				if (window.parent.isTvMode) {
					
					var ifScrollt = window.parent.Ext.getCmp('playBtn').ifScroll = true;
					var totalScrollLength = Ext.get(domID).dom.scrollHeight - Ext.get(domID).dom.offsetHeight;
					var scrollHeightx = totalScrollLength * 100;
					var scrollHeightDurationx = totalScrollLength * 70;
					var ifPageHasScroll = $('#'+domID).hasScrollBar();
					var ClickActionPause=false;
					var clearTimeOut="";
					var getTvModePlayAction = function () {
							var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
							if(silderAction == "pause"){
									Ext.get(domID).getActiveAnimation().paused = false;
									ClickActionPause = true;
								
								}
								else{
									clearTimeout( clearTimeOut );
									Ext.get(domID).getActiveAnimation().paused = true;
									window.parent.Ext.getCmp('tvmode').sliderObj.pause();
									ClickActionPause = false;
								}
					};
					if(ifPageHasScroll){
						var sc = Ext.get(domID).getActiveAnimation().paused = true;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						Ext.get(domID).scroll("b",
						scrollHeightx, {
							duration: scrollHeightDurationx,
							listeners: {
								beforeanimate: function (el, eOpts) {
									isKioskModeScrollInProgress = true;
								},
								afteranimate: function (el, startTime, eOpts) {
									Ext.get(domID).stopAnimation();
									Ext.defer(function () {
										isKioskModeScrollInProgress = false;
											window.parent.Ext.getCmp('tvmode').sliderObj.play();
											if (!Ext.isEmpty(runner)) {
												runner.destroy();
											}
									}, 1000);
									window.parent.Ext.getCmp('playBtn').ifScroll = false;
								}
							}
						}, {
							scope: Ext.get(domID)
						});
					}else{
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						if(ClickActionPause == true){
							clearTimeout( clearTimeOut );
							window.parent.Ext.getCmp('tvmode').sliderObj.pause();
							
						}
						else{
						clearTimeOut = Ext.defer(function(){
								window.parent.Ext.getCmp('tvmode').sliderObj.play();  
								},window.parent.Ext.getCmp('tvmode').getTimeFrequency);  
						}
					}
					var runner = new Ext.util.TaskRunner();
					var task = runner.start({
												run: getTvModePlayAction,
												interval: 1000
											});

					
				
				}
			}
			
	}
});

function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}
