<%
/*
 *   File		:	EgConfigureComponentTestsp.jsp
 *   Purpose	:	Processing page for test configuration
 *   Author		:	S.Anand (2008)
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgUtils"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="java.io.File" %>
<%@ page import="com.eg.UploadCorrectiveScript" %>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.egurkha.admin.EgTestSpecification"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgCorrectiveScripts" %>
<%@ page import= "egurkha.EgUIUtils"%>
<%@ page import = "java.util.Map.Entry"%>

<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="servicer" class="egurkha.ServiceBean" scope="page" />

<%!
	String eventTests[] = {"UserEnviron2008Test","SecurityLogTest","ADAMEvtLogTest","FRSEvtLogTest","DSEvtLogTest","DNSEvtTest","VsEvtLogTest","SystemEvtLogTest","AppEvtLogTest","SystemEvtTest","AppEvtTest","CustEvtLogTest"};

	String[] getDeleteQueries(String componentName,String testname)
	{
		String[] str = StringUtils.getTokens(componentName,":");
		String measure_last = "delete from measure_last where test_name='"+testname+"' and trgt_host='"+str[0]+"' and port_no='NULL' and site_name>'' and info>'' and msmt_host >''";
		String metatest = "delete from metatest where comp_name='"+componentName+"' and comp_type>'' and site_name>'' and info>'' and msmt_host>'' and test_name ='"+testname+"'";
		String testtable = "delete from "+testname+" where trgt_host='"+str[0]+"' and port_no='NULL' and site_name>'' and info>'' and msmt_host>'' and msmt_time>''";
		String reporttable = "delete from report where site_name>'' and comp_name='"+componentName+"' and comp_type>'' and info>'' and layer_name>'' and test_name='"+testname+"' and measure>'' and msmt_time>''";
		String query[] = {measure_last,metatest,testtable,reporttable};
		return query;
	}

	public String getValidIPFromNtxCtrlIPMapList(ArrayList ipAddresses, String discValue, boolean fromDiscIni)
	{
		String validIP = "";
		if((ipAddresses == null || ipAddresses.isEmpty()) || (discValue == null || discValue.trim().length() == 0))
		{
			return "";
		}

		for (int i=0;i<ipAddresses.size();i++)
		{
			String ipAddr = (String)ipAddresses.get(i);
			if (fromDiscIni)
			{
				if (discValue.toLowerCase().indexOf(","+ipAddr.toLowerCase()+",") > -1)
				{
					validIP = ipAddr;
					break;
				}
			}
			else
			{
				if (discValue.toLowerCase().equals(ipAddr.toLowerCase()))
				{
					validIP = ipAddr;
					break;
				}
			}
		}
		return validIP;
	}

	private String getNtxCtrlMappingSubject(String strVCAgentName, String strVCName)
	{
		String subName = "";
		IniFile nutanixMappIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_nutanixcentralmapping.ini");
		String [] allSubjects = nutanixMappIni.getSubjects();
		if (allSubjects != null && allSubjects.length > 0)
		{
			int allSubSize = allSubjects.length;
			boolean found = false;
			for (int as=0;as<allSubSize;as++)
			{
				String strAgtlessSub = allSubjects[as];
				String [] strVarsForChosenSub = nutanixMappIni.getVariables(strAgtlessSub);
				if (strVarsForChosenSub != null && strVarsForChosenSub.length > 0)
				{
					int varSize = strVarsForChosenSub.length;
					for (int var=0;var<varSize;var++)
					{
						String strAgtlessVar = strVarsForChosenSub[var];
						if (StringUtils.isNull(strAgtlessVar))
						{
							continue;
						}

						//if (strAgtlessVar.indexOf("#") != -1 && strAgtlessVar.endsWith("#"+strVCAgentName))
						if (strAgtlessVar.indexOf("#") != -1)
						{
							ArrayList tmpPrismList  = StringUtils.egTokenizer(strAgtlessVar,"#");

							if (strAgtlessVar.endsWith("#"+strVCAgentName))
							{
								if (tmpPrismList != null && tmpPrismList.contains(strVCName))
								{
									found = true;
									subName = strAgtlessSub+"~|~"+strAgtlessVar;
								}
							}
							else
							{
								if (tmpPrismList != null && tmpPrismList.contains(strVCName))
								{
									found = true;
									subName = strAgtlessSub+"~|~"+strAgtlessVar;
								}
							}
						}
						else if (strAgtlessVar.equalsIgnoreCase(strVCName))
						{
							found = true;
							subName = strAgtlessSub+"~|~"+strAgtlessVar;
						}
					}
				}

				if (found)
				{
					break;
				}
			}
		}
		return subName;
	}

	private Hashtable getNtxCtrlMappingSubject(String strVCAgentName, String strVCName, boolean fromAgentDiscovery)
	{
		Hashtable subAndVarname = new Hashtable();
		IniFile nutanixMappIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_nutanixcentralmapping.ini");
		String [] allSubjects = nutanixMappIni.getSubjects();
		if (allSubjects != null && allSubjects.length > 0)
		{
			int allSubSize = allSubjects.length;
			boolean found = false;
			for (int as=0;as<allSubSize;as++)
			{
				String strAgtlessSub = allSubjects[as];
				String [] strVarsForChosenSub = nutanixMappIni.getVariables(strAgtlessSub);
				if (strVarsForChosenSub != null && strVarsForChosenSub.length > 0)
				{
					int varSize = strVarsForChosenSub.length;
					for (int var=0;var<varSize;var++)
					{
						String strAgtlessVar = strVarsForChosenSub[var];
						if (StringUtils.isNull(strAgtlessVar))
						{
							continue;
						}

						//if (strAgtlessVar.equalsIgnoreCase(ntxMappIniVar)
						{
							if (strAgtlessVar.indexOf("#") != -1)
							{
								if (strAgtlessVar.endsWith("#"+strVCAgentName))
								{
									ArrayList tmpPrismList  = StringUtils.egTokenizer(strAgtlessVar,"#");
									if (tmpPrismList != null && tmpPrismList.contains(strVCName))
									{
										if(fromAgentDiscovery)
										{
											found = true;
										}
										//subName = strAgtlessSub+"~|~"+strAgtlessVar;

										if(subAndVarname.containsKey(strAgtlessSub))
										{
											ArrayList lst = (ArrayList) subAndVarname.get(strAgtlessSub);
											if(!lst.contains(strAgtlessVar))
												lst.add(strAgtlessVar);
											subAndVarname.put(strAgtlessSub, lst);
										}
										else
										{
											ArrayList varNameList = new ArrayList();
											varNameList.add(strAgtlessVar);
											subAndVarname.put(strAgtlessSub, varNameList);
										}
									}
								}
								else if (strAgtlessVar.startsWith(strVCName+"#") || strAgtlessVar.endsWith("#"+strVCName))
								{
									if (!fromAgentDiscovery)
									{
										found = true;
									}
									//subName = strAgtlessSub+"~|~"+strAgtlessVar;
									if(subAndVarname.containsKey(strAgtlessSub))
									{
										ArrayList lst = (ArrayList) subAndVarname.get(strAgtlessSub);
										if(!lst.contains(strAgtlessVar))
											lst.add(strAgtlessVar);
										subAndVarname.put(strAgtlessSub, lst);
									}
									else
									{
										ArrayList varNameList = new ArrayList();
										varNameList.add(strAgtlessVar);
										subAndVarname.put(strAgtlessSub, varNameList);
									}
								}
							}
							else if (strAgtlessVar.equalsIgnoreCase(strVCName))
							{
								if (!fromAgentDiscovery)
								{
									found = true;
								}
								//subName = strAgtlessSub+"~|~"+strAgtlessVar;
								if(subAndVarname.containsKey(strAgtlessSub))
								{
									ArrayList lst = (ArrayList) subAndVarname.get(strAgtlessSub);
									if(!lst.contains(strAgtlessVar))
										lst.add(strAgtlessVar);
									subAndVarname.put(strAgtlessSub, lst);
								}
								else
								{
									ArrayList varNameList = new ArrayList();
									varNameList.add(strAgtlessVar);
									subAndVarname.put(strAgtlessSub, varNameList);
								}
							}
						}
					}
				}

				if (found)
				{
					break;
				}
			}
		}
		return subAndVarname;
	}

	private ArrayList getNtxCtrlMappingVariables(String strVCAgentName, String strSubject)
	{
		ArrayList varsList = new ArrayList();
		IniFile nutanixMappIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_nutanixcentralmapping.ini");
		String [] allVars = nutanixMappIni.getVariables(strSubject);
		if (allVars != null && allVars.length > 0)
		{
			int len = allVars.length;
			boolean found = false;
			for (int var=0;var<len;var++)
			{
				String strAgtlessVar = allVars[var];
				if (StringUtils.isNull(strAgtlessVar))
				{
					continue;
				}

				if (strAgtlessVar.indexOf("#") != -1 && strAgtlessVar.endsWith("#"+strVCAgentName))
				{
					//ArrayList tmpPrismList  = StringUtils.egTokenizer(strAgtlessVar,"#");
					//if (tmpPrismList != null && tmpPrismList.contains(strVCName))
					{
						varsList.add(strAgtlessVar);
					}
				}
				else 
				{
					varsList.add(strAgtlessVar);
				}
			}
		}
		return varsList;
	}
%>

<%

	JSONObject rootJson = new JSONObject();
	//A component which the user is going to configure in the main test configuration page is
	//referred as UserInitiatedComponent. A test which is choosen by the user in the main page
	//for configuration is referred as UserInitiatedTest.
	
	//tells information about the corresponding authenticated user
	String userNameStr = (String)session.getAttribute("sess_userid");
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),userNameStr);
	boolean allCompAccess = ri.hasAllComponentAccess();
	EgUserElementsInfo userElmentsObj = new EgUserElementsInfo();
	EgAgentInfo agentInfo = new EgAgentInfo("manager");
	IniFile egAgtlessDiscIni = null;
	EgExternalInfo externalAgentInfo = new EgExternalInfo("manager"); 

	String[] rmtAgentList =  externalAgentInfo.getAllRemoteAgents();
	ArrayList userRmtAgentList = new ArrayList();
	if (!allCompAccess)
	{
		ArrayList agentsList = userElmentsObj.getRemoteAgentsForUser(_user.getLoginID());
		userRmtAgentList.addAll(agentsList);
	}
	else
	{
		userRmtAgentList = new ArrayList(Arrays.asList(rmtAgentList));
	}

	//code for auditlog - starts
	boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
	boolean isSaveTheAudit = false;
	AuditLogThread auditLogThread = null;
	int auditParamIdx = 1;
	if (isAuditLogEnabled)
	{
		auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Specific Test Configuration");
		auditLogThread.setValue("Activity","Configure Test");
	}
	boolean showAddAuditlog=true;
	Hashtable auditLogHt = null;
	Object auditLogHtObj = session.getAttribute("auditLogHt");
	if(auditLogHtObj != null && auditLogHtObj instanceof Hashtable)
	{
		auditLogHt = (Hashtable)auditLogHtObj;
	}
	if(auditLogHt == null)
	{
		auditLogHt = new Hashtable();
	}
	if(session.getAttribute("clickedFrom")!=null)
	{
		showAddAuditlog = ((String)session.getAttribute("clickedFrom")).equalsIgnoreCase("configurebutton");
	}
	//code for auditlog - ends

	//list having ini values for the selected test only.
	ArrayList aListParamNamesAndValues = (ArrayList)session.getAttribute("aListParamNamesValues");

	Hashtable hashTestsAndDelimiters = new Hashtable();

	//contains tests having '#' as delimiter - starts
	String testNameDelimiter[] = egSpecs.getTestInfosWithDelimiters();
	ArrayList aListTestsWithDelimiterHash = new ArrayList();
	for (int i=0; i<testNameDelimiter.length; i++)
	{
		String delimiter = egSpecs.getTestInfoDelimiter(testNameDelimiter[i]);
		if (delimiter.equals("#"))
		{
			if (!aListTestsWithDelimiterHash.contains(testNameDelimiter[i]))
			{
				aListTestsWithDelimiterHash.add(testNameDelimiter[i]);
			}
		}
		hashTestsAndDelimiters.put(testNameDelimiter[i].trim(),delimiter);
	}
	//contains tests having '#' as delimiter - ends

	Hashtable hashDelimitersAndMasks = new Hashtable();
	IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
	String strDelimiters[] = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
	String strEvtTests[] = testsIni.getVariables("EVENTLOG_POLICIES");
	for (int m=0;m<strDelimiters.length;m++)
	{
		String strDelimiterTemp = strDelimiters[m];
		String strMaskTemp = testsIni.getValue("TEST_INFO_DELIMITER_MASK",strDelimiterTemp);
		hashDelimitersAndMasks.put(strDelimiterTemp,strMaskTemp);
	}

	// Event log tests - starts
	ArrayList aListEventTests = new ArrayList(Arrays.asList(eventTests));

	if (strEvtTests != null && strEvtTests.length > 0)
	{
		for (int e=0;e<strEvtTests.length;e++)
		{
			String strEvtTestVar = strEvtTests[e];
			if (!com.egurkha.util.StringUtils.isNull(strEvtTestVar) && strEvtTestVar.indexOf(":") != -1)
			{
				String strEvtTest = strEvtTestVar.substring(0,strEvtTestVar.indexOf(":"));
				if (!aListEventTests.contains(strEvtTest))
				{
					aListEventTests.add(strEvtTest);
				}
			}
		}
	}
	// Event log tests - ends

	String strDelimiter = "";
	String strMask = "";
	boolean b_testWithDelimiter = false;
	boolean b_delimiterWithMask = false;

	Arrays.sort(paramToContinue,String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV1V2ParamToContinue,String.CASE_INSENSITIVE_ORDER);

	//whether the request comes from test-configure main page (EgConfigureComponentTests.jsp)
	//or intermediate page - apply to other components (EgApplyToOtherComponents.jsp).
	String fromPage = request.getParameter("requestFrom");
	fromPage = (fromPage != null)?fromPage:"EgConfigureComponentTests.jsp";

	ArrayList aListSpecialCharacterAllowedParam = new ArrayList();
	String specialCharactersAllowedParameter = (String)session.getAttribute("specialCharactersAllowedParameter");
	if (!StringUtils.isNull(specialCharactersAllowedParameter))
	{
		StringTokenizer stParams = new StringTokenizer(specialCharactersAllowedParameter,",");
		while (stParams.hasMoreTokens())
		{
			String specialParam = (stParams.nextToken()).toLowerCase();
			aListSpecialCharacterAllowedParam.add(specialParam);
		}
	}

	String[] tcKeywords = (String[])session.getAttribute("tcKeywords");
	ArrayList aListEgKeyWords = new ArrayList(Arrays.asList(tcKeywords));

	ArrayList aListPasswordParameters = (ArrayList)session.getAttribute("aListPasswordParameters");
	boolean hasPasswordParameters = false;
	if (aListPasswordParameters != null)
	{
		hasPasswordParameters = true;
	}

	boolean isOldSnmp = false;
	Boolean isOldSnmpObj = (Boolean)session.getAttribute("isOldSnmp");
	if (isOldSnmpObj != null)
	{
		isOldSnmp = isOldSnmpObj.booleanValue();
	}

	boolean agentIniFlag = false;
	boolean configureEsxVdi = false;
	boolean configureAcroVdi = false;
	boolean configureRhevVdi = false;
	boolean configureHMCComp = false;
	String ipAddress = "";
	String subVal = "";
	ArrayList updatedEsxList = new ArrayList();

	String componentType = "";
	String componentName = "";
	String testName = "";
	String testPeriod = "";
	String detailedDiagnosis = "";
	String applyComponentName = "";
	EgPwdProfile pwdProf = new EgPwdProfile();

	//For result page
	ArrayList aListDisplayParamNamesAndValues = new ArrayList();

	//Apply to other components - Start
	String selectedParameters = "";
	String selectedComponents = "";
	//Apply to other components - End

	//This list will contain user updated parameter name and values
	ArrayList aListTemp = new ArrayList();

	//This list will contain list of components
	ArrayList aListComponents = new ArrayList();

	//put for intermediate page - starts
	Hashtable hashParamNamesAndValues = new Hashtable();
	ArrayList aListChoosenParameters = null;
	ArrayList aListChoosenParametersInLowerCase = new ArrayList();
	StringTokenizer stParamTemp = null;
	ArrayList otherHVIpAddrList = new ArrayList();
	ArrayList aListTempValue = new ArrayList();
	ArrayList aListSelectedComponents = null;
	//put for intermediate page - ends

	//performance test or configuration test
	String testType = "";

	//contains enabled test for a component type
	ArrayList aListEnabledTestForCompType = new ArrayList();

	ArrayList aListParamsWithDoubleQuotes = (ArrayList)session.getAttribute("aListParamsWithDoubleQuotes");
	if (aListParamsWithDoubleQuotes == null)
	{
		aListParamsWithDoubleQuotes = new ArrayList();
	}

	//creating the ini object
	IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
	IniFile testParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");
	IniFile testinfoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testinfo.ini");
	boolean allowAggOperation = false;
	IniFile aggIni = null;
	if (allowAggOperation)
	{
		aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
	}
	IniFile eg_vcmappingIni = null;
	IniFile eg_servicesIni = null;
	IniFile eg_hmcMapping = null;
	IniFile eg_rhevMapping = null;
	IniFile eg_nutanixMapping = null;

	//variables declared for config file sync - starts
	ArrayList aListAgentsIniEntries = null;
	ArrayList aListServicesIniEntries = null;
	ArrayList aListAgtlessDiscIniEntries = null;
	ArrayList aListHmcMappingIniEntries = null;
	ArrayList aListVcMappingIniEntries = null;
	ArrayList aListRhevMappingIniEntries = null;
	ArrayList aListTestInfoIniEntries = null;
	ArrayList aListPwdProfIniEntries = null;
	ArrayList aListNutMappingIniEntries = null;
	ArrayList aListNtxCenterMappIniEntries = null;
	ArrayList aListDiscParamIniEntries = null;
	Set aListUpdateHyperVisorServers = null;
	ArrayList autoConfigHVCompsForAuditLog = new ArrayList();
	Hashtable ntxMappIniPrismDetails = (Hashtable) session.getAttribute("ntxMappIniPrismDetails");

	String[] allVCComps = discInfo.getAllServersOfType("Virtual_center");
	boolean isVCServerConfigured = (allVCComps != null && allVCComps.length > 0) ? true : false;
	//variables declared for config file sync - ends

	boolean isPortRelevantForTest = false;
	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		componentType = request.getParameter("componentType");
		componentName = request.getParameter("componentName");
		testName = request.getParameter("testName");
		isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
		testPeriod = request.getParameter("testPeriod");
		testType = request.getParameter("testType");
		testType = testType != null?testType:"PerformanceTest";
		detailedDiagnosis = request.getParameter("detaileddiagnosis");
		if (!StringUtils.isNull(componentName))
		{
			int idx_val = componentName.indexOf(":");
			applyComponentName = componentName.substring(0, idx_val);
		}
		b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		String include_descriptors = "all";
		String exclude_descriptors = "none";
		String action_on_descriptors = request.getParameter("action_on_descriptors");
		boolean actionOnDescriptors = false;
		if((testName.endsWith("_ag") || testName.endsWith("_agx")) && action_on_descriptors != null)
		{
			actionOnDescriptors=true;
			if(action_on_descriptors.trim().equalsIgnoreCase("include"))
			{
				exclude_descriptors = "none";
				include_descriptors = request.getParameter("include_descriptors");
			}
			else if(action_on_descriptors.trim().equalsIgnoreCase("exclude"))
			{
				include_descriptors = "all";
				exclude_descriptors = request.getParameter("excludeDescriptor");
			}
		}
		// for bug id - 14020
		String strEvtLogSub = "EVENTLOG_POLICIES";
		String strEvtlogPolicies[] = testsIni.getVariables(strEvtLogSub);
		ArrayList specificTestsEventLogPolicyList = new ArrayList();
		if (strEvtlogPolicies != null)
		{
			for (int i=0;i<strEvtlogPolicies.length;i++)
			{
				String strPolicyVar = strEvtlogPolicies[i];
				if (!com.egurkha.util.StringUtils.isNull(strPolicyVar) && strPolicyVar.startsWith(testName.trim()))
				{
					specificTestsEventLogPolicyList.add(strPolicyVar);
				}
			}
		}
		// for bug id - 14020

		String strFilterType = request.getParameter("selectedFilterType");
		//contains user updated parameter name and values - starts
		JSONArray encodeParamList = new JSONArray();
		if(session.getAttribute("encodeParamJsonList") != null)
		{
			encodeParamList = (JSONArray)session.getAttribute("encodeParamJsonList");
		}
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements())
		{
			String strParamName = (String)e.nextElement();
			String strParamValue = request.getParameter(strParamName);
			if(encodeParamList != null && encodeParamList.contains(strParamName))
			{
				strParamValue = EgUIUtils.decodeMultiChars(strParamValue);
				strParamValue = EgUIUtils.decodeSecurityChar(strParamValue);
			}
			if(actionOnDescriptors)
			{
				if(strParamName.trim().equalsIgnoreCase("excludeDescriptor"))
				{
					strParamValue = EgUIUtils.decodeSecurityChar(exclude_descriptors);
				}
				else if(strParamName.trim().equalsIgnoreCase("include_descriptors"))
				{
					strParamValue = EgUIUtils.decodeSecurityChar(include_descriptors);
				} 
			}
			if (!StringUtils.isNull(strParamName) && strParamName.equals("data_over_tcp"))
			{
				String groupLead = request.getParameter(strParamName+"_radioGrp");
				String sasiTestYes = request.getParameter(strParamName+"1");
				String sasiTestNo = request.getParameter(strParamName+"2");
				//strParamValue
			}
			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
						
			boolean isPasswordParameter = false;
			boolean allowToTrim = true;
			if (hasPasswordParameters)
			{
				if (aListPasswordParameters.contains("-"+strParamName))
				{
					isPasswordParameter = true;
					allowToTrim = false;
				}
			}

			if (!isPasswordParameter)
			{
				if(strParamName.equalsIgnoreCase("log_format"))
					isPasswordParameter = true;
			}
			if (!isPasswordParameter)
			{
				if (strParamValue.indexOf(" -") > -1 || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
				{
					if (!strParamValue.startsWith("\"") && !strParamValue.endsWith("\""))
					{
						strParamValue = "\"" + strParamValue + "\"";
						allowToTrim = false;
					}
				}
			}

			if (strParamName.equalsIgnoreCase("monitor_url_post_data"))
			{
				strParamValue = EgCrypt.encrypt(strParamValue);
			}

			//a line feed ('\n') or enter key
			while(strParamValue.indexOf("\n") > -1)
			{
				int idx = strParamValue.indexOf("\n");
				String strPrefix = strParamValue.substring(0,idx);
				String strSuffix = strParamValue.substring(idx+1,strParamValue.length());
				strSuffix = strSuffix.trim();
				strParamValue = strPrefix + strSuffix;
			}

			if (strParamName.equalsIgnoreCase("management_server_text"))
			{
				strParamName = "management_server";
			}

			if (strParamName.equalsIgnoreCase("-logtype"))
			{
				strParamValue = strParamValue.toLowerCase();
			}

			//special case - if the user selects multiple value for filter
			if (strParamName.equalsIgnoreCase("filter") || strParamName.equalsIgnoreCase("filter_combo"))
			{
				String[] filterValue = null;
				if  (!StringUtils.isNull(strFilterType) && strFilterType.equals("combo")) 
				{
					strParamName = "filter";
					filterValue = request.getParameterValues("filter_combo");
					ArrayList aListFilterList = new ArrayList();
					ArrayList tmpFilterList = new ArrayList(Arrays.asList(filterValue));
					if (tmpFilterList != null && tmpFilterList.size() > 0)
					{
						for (int t=0;t<tmpFilterList.size();t++)
						{
							String strFilterData = (String) tmpFilterList.get(t);
							if (!StringUtils.isNull(strFilterData) && strFilterData.indexOf(",") != -1)
							{
								ArrayList newFilterList = StringUtils.egTokenizer(strFilterData,",");
								aListFilterList.addAll(newFilterList);
							}
							else
							{
								aListFilterList.add(strFilterData);
							}
						}
					}

					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 starts... 
					Hashtable resultPolicy = new Hashtable();
					String strLogType = request.getParameter("logType");
					boolean isExistPolicy = false;
					if (aListFilterList != null && !aListFilterList.isEmpty())
					{
						if (!aListFilterList.contains("all"))
						{
							aListFilterList.add("all");
						}

						for (int pol=0;pol<aListFilterList.size();pol++)
						{
							String strPolicy = (String) aListFilterList.get(pol);
							String vardecal=testName.trim()+":"+strLogType.toLowerCase()+":"+strPolicy;
							if (specificTestsEventLogPolicyList != null && !specificTestsEventLogPolicyList.isEmpty())
							{
								for (int j=0;j<specificTestsEventLogPolicyList.size();j++)
								{
									String strCorrectVariable = (String) specificTestsEventLogPolicyList.get(j);
									if (!com.egurkha.util.StringUtils.isNull(strCorrectVariable))
									{
										if(strCorrectVariable.equalsIgnoreCase(vardecal))
										{
											vardecal= strCorrectVariable;
											break;
										}

										if (strCorrectVariable.endsWith(strPolicy))
										{
											String assignValue = testsIni.getValue(strEvtLogSub,strCorrectVariable);
											resultPolicy.put(vardecal,assignValue);
										}
									}
								}
							}
						}
					}

					if (resultPolicy != null && resultPolicy.size() > 0)
					{
						ArrayList resultPolicyList = new ArrayList();
						Iterator keyIt = resultPolicy.entrySet().iterator();
						while(keyIt.hasNext())
						{
							Map.Entry entry =  (Map.Entry) keyIt.next();
							resultPolicyList.add((String) entry.getKey());
						}

						IniFile egTestsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
						for (int r=0;r<resultPolicyList.size();r++)
						{
							String strEvtPolVar = (String) resultPolicyList.get(r);
							String strEvtPolVal = (String) resultPolicy.get(strEvtPolVar);
							egTestsIni.setValue(strEvtLogSub,strEvtPolVar,strEvtPolVal);
						}
						egTestsIni.saveFile();
						EgConfigFilesSync.releaseInstance(egTestsIni);
					}
					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 ends... 
				}
				else
				{
					filterValue = request.getParameterValues("filter");
				}
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							//strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("pageTypesToBeincludedindashboard"))
			{
				String[] filterValue = request.getParameterValues(strParamName);
				
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue == null || strParamValue.length() <= 0) 
				{
					strParamValue = "None";
				}
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("select_actions"))
			{
				String[] filterValue = request.getParameterValues(strParamName);
				
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue == null || strParamValue.length() <= 0) 
				{
					strParamValue = "None";
				}
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
			{
				String targetDiskIORate_select = request.getParameter("TargetDiskIORate_select");
				String targetDiskIORate = request.getParameter("Target_DiskIO_Rate");
				strParamValue = targetDiskIORate_select + "_" + targetDiskIORate;
			}
			else if (strParamName.equalsIgnoreCase("executiontime") && 
				request.getParameter("minutes") != null && 
				request.getParameter("hours") != null)
			{
				strParamValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
			}
			else if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}

			if (strParamName.equalsIgnoreCase("log_format"))
			{
				strParamValue = EgCrypt.encrypt(strParamValue);
			}

			aListTemp.add("-"+strParamName);
			if (allowToTrim)
			{
				strParamValue = strParamValue.trim();
			}
			aListTemp.add(strParamValue);
		}
		//contains user updated parameter name and values - ends

		//adding the components - starts
		aListComponents.add(componentName);
		//adding the components - ends
	}
	else
	{
		//from EgApplyToOtherComponents.jsp
		hashParamNamesAndValues = (Hashtable)session.getAttribute("hashParamNamesAndValues");
		componentType = (String)hashParamNamesAndValues.get("componentType");
		componentName = (String)hashParamNamesAndValues.get("componentName");
		testName = (String)hashParamNamesAndValues.get("testName");
		isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
		testPeriod = (String)hashParamNamesAndValues.get("testPeriod");
		testType = (String)hashParamNamesAndValues.get("testType");
		detailedDiagnosis = (String)hashParamNamesAndValues.get("detaileddiagnosis");
	
		if (!StringUtils.isNull(componentName))
		{
			int idx_val = componentName.indexOf(":");
			applyComponentName = componentName.substring(0, idx_val);
		}

		b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		//contains user updated parameter name and values - starts
		aListTemp = (ArrayList)hashParamNamesAndValues.get("userUpdatedParamNamesAndValues");
		ArrayList aList_A = new ArrayList();
		boolean isNeedToAddHypvCredentials = false;
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strParamValue = (String)aListTemp.get(i+1);

			if (strParamName.equalsIgnoreCase("-virtual_center"))
			{
				if (!strParamValue.equalsIgnoreCase("none"))
				{
					isNeedToAddHypvCredentials = true;
				}
			}
			
			if (strParamName.equalsIgnoreCase("-log_format"))
			{
				strParamValue = EgCrypt.encrypt(strParamValue);
			}

			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
			
			if (strParamName.equalsIgnoreCase("-delimiter") || strParamName.equalsIgnoreCase("-delimiterMask"))
			{
				continue;
			}

			if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}

			aList_A.add(strParamName);
			aList_A.add(strParamValue);
		}
		aListTemp = aList_A;
		//contains user updated parameter name and values - ends

		aListChoosenParameters = getArrayList(EgUIUtils.decodeSecurityChar(request.getParameter("selectedParameters")),",");
			
		if (aListChoosenParameters != null)
		{
			if (isNeedToAddHypvCredentials)
			{
				if (componentType.equalsIgnoreCase("VmEsx_i_server") || componentType.equalsIgnoreCase("VmVdi_i_server"))
				{
					aListChoosenParameters.add("-Esx_user");
					aListChoosenParameters.add("-Esx_password");
					aListChoosenParameters.add("-webPort");
					aListChoosenParameters.add("-ssl");
				}
			}
		}
		//aListChoosenParametersInLowerCase
		for (int i=0;i<aListChoosenParameters.size();i++)
		{
			aListChoosenParametersInLowerCase.add(aListChoosenParameters.get(i).toString().toLowerCase());
		}

		//Apply to other components - Start
		selectedComponents = request.getParameter("selectedComponents");
		//Apply to other components - End

		aListSelectedComponents = getArrayList(selectedComponents,",");

		//adding the components - starts
		//adding the very first component is the component which the user has choosen for configuration (clicked).
		aListComponents.add(componentName);
		//adding the component(s) which user pick from apply to other component page
		aListComponents.addAll(aListSelectedComponents);
		//adding the components - ends
	}

	boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
	//In eg_testparam.ini
	//[TEST_RELATIONS] ==> here when one test is configured,the corresponding test 
	//also get configured,except test period value.
	//i.e all similar parameters except test period

	//[COMMON_TEST_RELATIONS] ==> here when one test is configured,the corresponding 
	//test also get configured including test period value.
	//i.e all similar parameters including test period

	//code to get test relations from eg_testparam.ini starts here
	ArrayList aListRelationTests = new ArrayList();
	aListRelationTests.add(testName);
	
	boolean isRESTICTest=false;
	
	if(testName!=null && testName.endsWith("_ex"))
	{
		String mappedTestForIcTest=testsIni.getValue("TEST_MAPPING",testName);
		if(mappedTestForIcTest!=null && mappedTestForIcTest.equalsIgnoreCase("EgRESTTest"))
		{
			isRESTICTest=true;
		}
	}

	String testRelationVariables[] = testParamIni.getVariables("TEST_RELATIONS");
	String testRelation = testParamIni.getValue("TEST_RELATIONS",testName);
	if (testRelation != null && testRelation.length() > 0)
	{
		aListRelationTests.addAll(getArrayList(testRelation,","));
	}

	String commonTestRelationVariables[] = testParamIni.getVariables("COMMON_TEST_RELATIONS");
	ArrayList aListCommonTestRelationVariables = new ArrayList();
	for (int i=0;i<commonTestRelationVariables.length;i++)
	{
		String eachVariable = commonTestRelationVariables[i];
		ArrayList aListTempVariable = getArrayList(eachVariable,",");
		if (aListTempVariable.contains(testName))
		{
			aListCommonTestRelationVariables.addAll(aListTempVariable);
			break;
		}
	}
	//ends here

	boolean isVcenterCompType = (!StringUtils.isNull(componentType) && componentType.equalsIgnoreCase("virtual_center"));
	boolean isNutClusterCompType = (!StringUtils.isNull(componentType) && (componentType.equalsIgnoreCase("nutanix_cluster") || componentType.equalsIgnoreCase("nutanix_prism_center")));
	boolean isNutanixInfraComponentType = (!StringUtils.isNull(componentType) && (componentType.equalsIgnoreCase("nutanix_cluster") || componentType.equalsIgnoreCase("nutanix_prism_center") || componentType.equalsIgnoreCase("Nutanix_Acropolis") || componentType.equalsIgnoreCase("Nutanix_Acropolis_Vdi")));
	boolean isNtxCtrlCompType = (!StringUtils.isNull(componentType) && componentType.equalsIgnoreCase("nutanix_prism_center"));
	boolean isRHEVLinuxMgrCompType = (!StringUtils.isNull(componentType) && componentType.equalsIgnoreCase("Redhat_linux_mgr"));
	boolean isHMCSrvrCompType = (!StringUtils.isNull(componentType) && componentType.equalsIgnoreCase("hmc_server"));
	IniFile agtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
	IniFile servIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String eGMgrModel = servIni.getValue("MISC_ARGS","eGMgrModel");

	//for password - starts
	ArrayList aListDefaultPasswordParameters = (ArrayList)session.getAttribute("aListDefaultPasswordParameters");
	boolean hasDefaultPasswordParameter = false;
	if (aListDefaultPasswordParameters != null)
	{
		hasDefaultPasswordParameter = true;
	}
	//for password - ends

	//for aggregate - starts
	boolean isAggSupported = false;
	boolean isAggComponentType = false;
	ArrayList aListAggTest = null;
	boolean hasAggServerType = false;
	//contains aggtest and their mapping test
	ArrayList managedComponents = null;
	//for auditlog - contains list of configured aggregate component
	ArrayList aListAuditAggComponents = null;
	String aggComponentType = null;
	if (allowAggOperation)
	{
		isAggSupported = EgInstallInfo.isAggSupported;
		Hashtable ht_AggComponentType = null;
		Enumeration en_AggComponentType = null;
		isAggComponentType = componentType.startsWith("Agg_");
		if (isAggSupported && !isAggComponentType)
		{
			if (isAuditLogEnabled)
			{
				aListAuditAggComponents = new ArrayList();
			}

			ht_AggComponentType = new Hashtable();
			aListAggTest = new ArrayList();
			managedComponents = discInfo.getAllManagedNames(true);

			String allAggServerTypes[] = aggIni.getVariables("COMPONENT_TYPE_MAPPING");
			allAggServerTypes = (allAggServerTypes != null)?allAggServerTypes:new String[0];
			for (int m=0;m<allAggServerTypes.length;m++)
			{
				String tempAggComponentType = allAggServerTypes[m];
				String tempComponentType = aggIni.getValue("COMPONENT_TYPE_MAPPING",allAggServerTypes[m]);
				ht_AggComponentType.put(tempAggComponentType,tempComponentType);
			}

			en_AggComponentType = ht_AggComponentType.keys();
			while (en_AggComponentType.hasMoreElements())
			{
				String tempAggCompType = (String)en_AggComponentType.nextElement();
				String strCompType = (String)ht_AggComponentType.get(tempAggCompType);
				StringTokenizer stAgg = new StringTokenizer(strCompType,",");
				while (stAgg.hasMoreTokens())
				{
					String thisToken = stAgg.nextToken();
					if (!thisToken.equals(componentType)) continue;
					aggComponentType = tempAggCompType;
					hasAggServerType = true;
				}
			}

			String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");
			allAggTests = (allAggTests != null)?allAggTests:new String[0];
			for (int m=0;m<allAggTests.length;m++)
			{
				String tempAggTest = allAggTests[m];
				String tempTest = aggIni.getValue("AGGREGATE_TEST",allAggTests[m]);
				aListAggTest.add(tempTest);
				aListAggTest.add(tempAggTest);
			}
		}
	}
	//for aggregate - ends

	//for auditlog -starts
	if (isAuditLogEnabled)
	{
		String auditComponent = "";
		if (componentName.indexOf(":NULL") > -1)
		{
			auditComponent = componentName.substring(0,componentName.indexOf(":"));
		}
		else
		{
			auditComponent = new String(componentName);
		}

		if (!isPortRelevantForTest)
		{
			if (auditComponent.indexOf(":") > -1)
			{
				auditComponent = auditComponent.substring(0,auditComponent.indexOf(":"));
			}
		}
		if(showAddAuditlog)
		{
			auditLogThread.setValue("Description","Test " + "$test$:" + testName + " for component " + auditComponent + " of type $ctype$:" + componentType + " has been configured");
		}
		else
		{
			auditLogThread.setValue("Description","Test " + "$test$:" + testName + " for component " + auditComponent + " of type $ctype$:" + componentType + " has been reconfigured");
		}
	}
	//for auditlog -ends

	//tells whether _cf test is enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	if (isConfigSupported)
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		aListEnabledTestForCompType.addAll(egSpecs.getEnabledTests(componentType,true));
	}
	else
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
	}

	// eg_discoveryParams.ini file is need to be change from specific test configuraion UI - starts
	boolean isDiscParamsNeedToUpdate = false;
	Hashtable discParamsList = new Hashtable();
	Vector discParamsVarList = new Vector();
	IniFile discParamsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discoveryParams.ini");
	String[] allSubjects = discParamsIni.getSubjects();
	if (allSubjects != null && allSubjects.length > 0)
	{
		for (int a=0;a < allSubjects.length;a++)
		{
			String strSubject = allSubjects[a];
			if (!StringUtils.isNull(strSubject) && strSubject.equals(componentType))
			{
				isDiscParamsNeedToUpdate = true;
				break;
			}
		}
	}

	if (isDiscParamsNeedToUpdate)
	{
		if (aListComponents != null && !aListComponents.isEmpty())
		{
			int compSize = aListComponents.size();
			for (int c=0;c<compSize;c++)
			{
				String strCompName = (String) aListComponents.get(c);
				if (StringUtils.isNull(strCompName))
				{
					continue;
				}
				discParamsVarList.add(componentType+":"+strCompName);
			}
		}

		int compsCount = discParamsVarList.size();
		for (int cc=0;cc<compsCount;cc++)
		{
			String strServerName = (String)discParamsVarList.get(cc);

			ArrayList agentIniNewValList = new ArrayList();
			if (cc == 0)
			{
				int paramSize = aListParamNamesAndValues.size();
				for (int p=0;p<paramSize;p=p+2)
				{
					String strParamName = (String)aListParamNamesAndValues.get(p);
					String strParamValue = (String)aListParamNamesAndValues.get(p+1);

					if (!StringUtils.isNull(componentType) && 
						componentType.equalsIgnoreCase("eG_Manager") &&
						!StringUtils.isNull(strParamName) && 
						strParamName.equalsIgnoreCase("-url"))
					{
						continue;
					}

					if (strParamName.equalsIgnoreCase("-virtual_center") || strParamName.equalsIgnoreCase("-prism_ip") ||
					strParamName.equalsIgnoreCase("-rhel_mgr_host") ||
					strParamName.equalsIgnoreCase("-management_server"))
					{
						if (strParamValue.indexOf("~#~") != -1)
						{
							strParamValue = strParamValue.substring(0,strParamValue.indexOf("~#~"));
						}
					}

					agentIniNewValList.add(strParamName);
					boolean isPasswordData = false;
					if (hasPasswordParameters && aListPasswordParameters.contains(strParamName))
					{
						isPasswordData = true;
					}
					else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strParamName.toLowerCase()))
					{
						isPasswordData = true;
					}

					if (aListTemp.contains(strParamName))
					{
						int idx = aListTemp.indexOf(strParamName);
						String strValue = (String)aListTemp.get(idx+1);
						
						if (strParamName.equalsIgnoreCase("-virtual_center") || strParamName.equalsIgnoreCase("-prism_ip") ||
						strParamName.equalsIgnoreCase("-rhel_mgr_host") ||
						strParamName.equalsIgnoreCase("-management_server"))
						{
							if (strValue.indexOf("~#~") != -1)
							{
								strValue = strValue.substring(0,strValue.indexOf("~#~"));
							}
						}

						if (isPasswordData)
						{
							String strPwdWithSalt = strValue;
							if (!isNumber(strPwdWithSalt))
							{
								strPwdWithSalt = EgCrypt.decrypt(strPwdWithSalt);
							}
							if (strPwdWithSalt.indexOf("~EG~") != -1)
							{
								strPwdWithSalt = strPwdWithSalt.substring(0,strPwdWithSalt.indexOf("~EG~"));
							}
							strValue = EgCrypt.encrypt(strPwdWithSalt);
						}

						agentIniNewValList.add(strValue);
					}
					else
					{

						if (isPasswordData)
						{
							String strPwdWithSalt =  strParamValue;
							if (!isNumber(strPwdWithSalt))
							{
								strPwdWithSalt = EgCrypt.decrypt(strPwdWithSalt);
							}
							if (strPwdWithSalt.indexOf("~EG~") != -1)
							{
								strPwdWithSalt = strPwdWithSalt.substring(0,strPwdWithSalt.indexOf("~EG~"));
							}
							strParamValue = EgCrypt.encrypt(strPwdWithSalt);
						}
						agentIniNewValList.add(strParamValue);
					}
				}
			}
			else
			{
				if (aListChoosenParameters != null && !aListChoosenParameters.isEmpty())
				{
					int count = aListChoosenParameters.size();
					for (int ch=0;ch<count;ch++)
					{
						String strChoosenParamName = (String)aListChoosenParameters.get(ch);
						if (!StringUtils.isNull(componentType) && 
							componentType.equalsIgnoreCase("eG_Manager") && 
							!StringUtils.isNull(strChoosenParamName) && 
							strChoosenParamName.equalsIgnoreCase("-url"))
						{
							continue;
						}

						boolean isPasswordData = false;
						if (hasPasswordParameters && aListPasswordParameters.contains(strChoosenParamName))
						{
							isPasswordData = true;
						}
						else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strChoosenParamName.toLowerCase()))
						{
							isPasswordData = true;
						}

						if (aListTemp.contains(strChoosenParamName))
						{
							int idx = aListTemp.indexOf(strChoosenParamName);
							String strChoosenParamValue = (String)aListTemp.get(idx+1);

							if (strChoosenParamName.equalsIgnoreCase("-virtual_center") ||
								strChoosenParamName.equalsIgnoreCase("-prism_ip") ||
								strChoosenParamName.equalsIgnoreCase("-rhel_mgr_host") ||
								strChoosenParamName.equalsIgnoreCase("-management_server"))
							{
								if (strChoosenParamValue.indexOf("~#~") != -1)
								{
									strChoosenParamValue = strChoosenParamValue.substring(0,strChoosenParamValue.indexOf("~#~"));
								}
							}

							if (isPasswordData)
							{
								String strPwdWithSalt =  strChoosenParamValue;
								if (!isNumber(strPwdWithSalt))
								{
									strPwdWithSalt =  EgCrypt.decrypt(strPwdWithSalt);
								}
								if (strPwdWithSalt.indexOf("~EG~") != -1)
								{
									strPwdWithSalt = strPwdWithSalt.substring(0,strPwdWithSalt.indexOf("~EG~"));
								}
								strChoosenParamValue = EgCrypt.encrypt(strPwdWithSalt);
							}
							agentIniNewValList.add(strChoosenParamName);
							agentIniNewValList.add(strChoosenParamValue);
						}
					}
				}
			}
			discParamsList.put(strServerName,agentIniNewValList);
		}
	}
	// eg_discoveryParams.ini file is need to be change from specific test configuraion UI - ends

	//Stopping the discovery process
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	servicer.stopDiscovery();

	boolean isHashDelimiter = aListTestsWithDelimiterHash.contains(testName);
	detailedDiagnosis = (detailedDiagnosis != null)?detailedDiagnosis:"";

	IniFile pwdProfIniSync = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_pwdprofile.ini");
	boolean isPwdProfileUpdate = false;
	String profileName = "";
	boolean isSpecificProfile = false;
	String pwdProfileParams = "";
	String specificProfile = "";
	String strUsePwdProfValue = "";
	JSONObject pwdParamSetList = (JSONObject) session.getAttribute("pwdParamSetList");
	updatedEsxList.addAll(aListComponents); // for vc updates to esx
	String strAgentlessSubject = "";
	//Iterating each component - starts
	for (int z=0;z<aListComponents.size();z++)
	{
		ArrayList aListConfigurableTest = new ArrayList();
		String tempComponentName = (String)aListComponents.get(z);
		String tempComponentNickName = tempComponentName.substring(0,tempComponentName.indexOf(":"));
		String tempPort = tempComponentName.substring(tempComponentName.indexOf(":")+1);
		List aListAgents = getAgents(tempComponentName);
		ArrayList aListUpdatedParamNamesAndValues = new ArrayList();

		//for aggregate - starts
		List aggCompWithType = null;
		if (allowAggOperation)
		{
			if (isAggSupported && !isAggComponentType)
			{
				aggCompWithType = egAggInfo.getAssociatedAggList(componentType + ":" + tempComponentName);
				aggCompWithType = aggCompWithType != null?aggCompWithType:new ArrayList();
			}
		}
		//for aggregate - ends

		if (z == 0)
		{
			for (int i=0;i<aListParamNamesAndValues.size();i=i+2)
			{
				String paramName = (String)aListParamNamesAndValues.get(i);
				String paramValue = (String)aListParamNamesAndValues.get(i+1);
				aListUpdatedParamNamesAndValues.add(paramName);
				if (aListTemp.contains(paramName))
				{
					int idx = aListTemp.indexOf(paramName);
					String strValue = (String)aListTemp.get(idx+1);
					if (isHashDelimiter && strValue.indexOf(',') > -1)
					{
						strValue = StringUtils.replace(strValue,",","#");
					}
					//No else if block to replace comma with pipe because
					//down the line we have to process the parameter value where 
					//each token is separated using comma.After processing the parameter,
					//comma is replaced with pipe symbol.
					//for eg credentials,url parameter value have to be processed.
					aListUpdatedParamNamesAndValues.add(strValue);
				}
				else
				{
					aListUpdatedParamNamesAndValues.add(paramValue);
				}
			}
			aListTempValue = new ArrayList(aListUpdatedParamNamesAndValues);
		}
		else
		{
			String tempAgentNickName = null;
			if (isExternalTest)
			{
				tempAgentNickName = (String)aListAgents.get(1);
			}
			else
			{
				tempAgentNickName = (String)aListAgents.get(0);
			}

			if (tempAgentNickName == null) continue;

			String specificPattern_A = testName + ":" + componentType + ":" + tempComponentName;
			String specificPattern_B = testName + ":" + componentType + ":" + tempComponentNickName;
			String defaultPattern_A = testName + "::" + tempComponentName;
			String defaultPattern_B = testName + "::" + tempComponentNickName;
			String agentIniVariables[] = agentIni.getVariables(tempAgentNickName);
			List listAgentIniVariables = Arrays.asList(agentIniVariables);
			String resultantPattern = "";
			if (listAgentIniVariables.contains(specificPattern_A))
			{
				resultantPattern = specificPattern_A;
			}
			else if (listAgentIniVariables.contains(specificPattern_B))
			{
				resultantPattern = specificPattern_B;
			}
			else if (listAgentIniVariables.contains(defaultPattern_A))
			{
				resultantPattern = defaultPattern_A;
			}
			else if (listAgentIniVariables.contains(defaultPattern_B))
			{
				resultantPattern = defaultPattern_B;
			}

			if (resultantPattern.equalsIgnoreCase("")) continue;

			String iniValue =  agentIni.getValue(tempAgentNickName,resultantPattern);
			iniValue = iniValue.substring(iniValue.indexOf(",")+1,iniValue.lastIndexOf(","));

			if (isOldSnmp)
			{
				ArrayList aListOldParams = getParameterList(iniValue,true);
				if (!aListOldParams.contains("-snmpversion"))
				{
					int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
					aListOldParams = getParameterList(iniValue,false);
					aListOldParams.add(snmpComIdx+2,"-snmpversion");
					aListOldParams.add(snmpComIdx+3,"v1");

					iniValue = aListOldParams.toString();
					iniValue = iniValue.substring(1,iniValue.length()-1);
					iniValue = StringUtils.replace(iniValue,",","");
				}
			}

			ArrayList aListSample = getParameterList(iniValue,false);
			aListUpdatedParamNamesAndValues = new ArrayList(aListSample);

			for (int m=0;m<aListChoosenParameters.size();m++)
			{
				String eachParam = (String)aListChoosenParameters.get(m);
				if (aListUpdatedParamNamesAndValues.contains(eachParam))
				{
					//fetching the selected parameter from the builded list
					int idx = aListUpdatedParamNamesAndValues.indexOf(eachParam);
					int idx2 = aListTempValue.indexOf(eachParam);
					String str1 = (String)aListTempValue.get(idx2+1);
					aListUpdatedParamNamesAndValues.remove(idx+1);
					aListUpdatedParamNamesAndValues.add(idx+1,str1);
				}
			}
		}

		ArrayList aListProcessedParamNamesAndValues = new ArrayList();
		for (int i=0; i<aListUpdatedParamNamesAndValues.size(); i=i+2)
		{
			String strParamName = (String)aListUpdatedParamNamesAndValues.get(i);
			String strParamNameLowerCase = strParamName.toLowerCase();
			String strParamValue = (String)aListUpdatedParamNamesAndValues.get(i+1);
			boolean allowToModifyParameter = true;

			if (strParamName.equalsIgnoreCase("-virtual_center") || strParamName.equalsIgnoreCase("-prism_ip") ||
			strParamName.equalsIgnoreCase("-rhel_mgr_host") ||
			strParamName.equalsIgnoreCase("-management_server"))
			{
				String strOtherOptionAgtlessSubject = request.getParameter("agentlessSubject");
				if (!StringUtils.isNull(strOtherOptionAgtlessSubject))
				{
					strAgentlessSubject = strOtherOptionAgtlessSubject;
				}

				if (strParamValue.indexOf("~#~") != -1)
				{
					strAgentlessSubject = strParamValue.substring(strParamValue.indexOf("~#~")+3);
					strParamValue = strParamValue.substring(0,strParamValue.indexOf("~#~"));
				}

				if (strParamValue.indexOf(" (") != -1)
				{
					strAgentlessSubject = strParamValue.substring(strParamValue.indexOf(" (")+2,strParamValue.indexOf(")"));
					strParamValue = strParamValue.substring(0,strParamValue.indexOf(" ("));
				}
			}

			if ((strParamName.equalsIgnoreCase("-AWS_Account_ID_To_Monitor") || 
				strParamName.equalsIgnoreCase("-AWS_Role_Name")) &&
				(strParamValue.equalsIgnoreCase("$unconfigured")))
			{
				String strAccessType = request.getParameter("Access_Type");
				if (!StringUtils.isNull(strAccessType) && strAccessType.equalsIgnoreCase("Secret"))
				{
					strParamValue = "none";
				}
			}
			//applicable only to "apply to other components".not to UserInitiatedComponent.
			//this code fires when the user in transit page(EgApplyToOtherCompoent.jsp),unclick 
			//the parameter.
			if (z > 0 && 
				!aListChoosenParametersInLowerCase.contains(strParamNameLowerCase))
			{
				allowToModifyParameter = false;
			}
			if(isRESTICTest && strParamName.equalsIgnoreCase("-request_headers"))
			{
				if(strParamValue!=null && !strParamValue.equals(""))
				{
					strParamValue = EgCrypt.encrypt(strParamValue);
					if (strParamValue.indexOf(";") > -1)
					{
						strParamValue = StringUtils.replace(strParamValue,";","!cma!");
					}
					if (strParamValue.indexOf("~#~") > -1)
					{
						strParamValue = StringUtils.replace(strParamValue,"~#~","!cma!");
					}
					if (strParamValue.indexOf("!colon!") > -1)
					{
						strParamValue = StringUtils.replace(strParamValue,":","!colon!");
					}
				}
			}

			if (allowToModifyParameter)
			{
				boolean encryptPasswordData = false;
				if (hasPasswordParameters && aListPasswordParameters.contains(strParamName))
				{
					encryptPasswordData = true;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strParamNameLowerCase))
				{
					encryptPasswordData = true;
				}
				
				if (strParamName.equalsIgnoreCase("-logtype"))
				{
					strParamValue = strParamValue.toLowerCase();
				}

				if (strParamName.equals("-url"))
				{
					String strHiddenUrlDelim = ",";
					if (testName.equals("HttpTest") || 
						testName.equals("HttpPostTest") || 
						testName.equals("SMHttpTest") || 
						testName.equals("AzureWebAcsTest") || 
						testName.equals("AzrIntAdmCtrTest") || 
						testName.equals("AlibabaHttpTest") || 
						testName.equals("AWSHttpTest") || 
						testName.equals("AzrWVDAcsTest") || 
						testName.equals("vCloudHttpTest") || 
						testName.equals("DownSpeedTest"))
					{
						String strHiddenUrl = request.getParameter("hiddenURLs");
						strParamValue = strHiddenUrl;
						strHiddenUrlDelim = "|";
					}
					//handling parameter value for url
					//if (strParamValue.indexOf(",") > -1)
					if (strParamValue.indexOf(strHiddenUrlDelim) > -1)
					{
						String encodedUrl = "";
						StringTokenizer st12 = new StringTokenizer(strParamValue,strHiddenUrlDelim);
						//StringTokenizer st12 = new StringTokenizer(strParamValue,",");
						String tempUrl = "";
						while (st12.hasMoreTokens())
						{
							tempUrl = st12.nextToken();
							String tmpUrlName = tempUrl.substring(0,tempUrl.indexOf(":"));
							String tmpUrlValue = tempUrl.substring(tempUrl.indexOf(":")+1);
							tmpUrlValue = tmpUrlValue.trim();
							tempUrl = tmpUrlName + ":" + tmpUrlValue;

							if (tempUrl.indexOf(" ") != -1)
							{
								tempUrl = StringUtils.replace(tempUrl," ","~egSpace~");
							}
							if (tempUrl.indexOf("?") > -1)
							{
								int urlIndex = tempUrl.indexOf("?");
								tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
							}
							if (encodedUrl != null && !encodedUrl.equals(""))
							{
								encodedUrl = encodedUrl + "|" + tempUrl;
							}
							else
							{
								encodedUrl = tempUrl;
							}
						}
						strParamValue = encodedUrl;
					}
					else
					{
						String tmpUrlName = strParamValue.substring(0,strParamValue.indexOf(":"));
						String tmpUrlValue = strParamValue.substring(strParamValue.indexOf(":")+1);
						tmpUrlValue = tmpUrlValue.trim();
						strParamValue = tmpUrlName + ":" + tmpUrlValue;
						if (strParamValue.indexOf(" ") != -1)
						{
							strParamValue = StringUtils.replace(strParamValue," ","~egSpace~");
						}

						if(strParamValue.indexOf("?") > -1)
						{
							int vecValIndex = strParamValue.indexOf("?");
							strParamValue = strParamValue.substring(0, vecValIndex) + "?" + URLEncoder.encode(strParamValue.substring(vecValIndex + 1));
						}
					}
				}
				else if (encryptPasswordData)
				{
					//handling parameter value for password data
					if (!isNumber(strParamValue))
					{
						strParamValue = EgCrypt.decrypt(strParamValue);
					}
					String passList = "";
					if (testName.equals("CtxAuthTest") || 
						testName.equals("WinAuthTest") || 
						testName.equals("TermAuthTest") || 
						testName.equals("WindowshareTest") || 
						testName.equals("UNCCheckTest"))
					{
						if (strParamValue.indexOf("#~#") > -1)
						{
							ArrayList aListTokens = StringUtils.myTokenizer(strParamValue, "#~#");
							for(int m=0;m<aListTokens.size();m++)
							{
								String strToken = (String) aListTokens.get(m);
								String strTokenSalt = strToken;
								if (!isNumber(strTokenSalt))
								{
									strTokenSalt = EgCrypt.decrypt(strTokenSalt);
								}

								if (strTokenSalt.indexOf("@") != -1)
								{
									String strTokenGetDomain =  strTokenSalt.substring(0,strTokenSalt.indexOf("@"));
									String strTokenGetPass =  strTokenSalt.substring(strTokenSalt.indexOf("@")+1);
									if (!isNumber(strTokenGetPass))
									{
										strTokenGetPass = EgCrypt.decrypt(strTokenGetPass);
									}
									if (strTokenGetPass.indexOf("~EG~") != -1)
									{
										strTokenGetPass = strTokenGetPass.substring(0,strTokenGetPass.indexOf("~EG~"));
									}
									strTokenSalt = strTokenGetDomain+ "@" + strTokenGetPass;
								}

								if (strTokenSalt.indexOf("~EG~") != -1)
								{
									strToken = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
								}
								else
								{
									strToken = strTokenSalt;
								}
								passList += EgCrypt.encrypt(strToken)+"|";
							}
							passList = passList.substring(0, passList.length()-1);
						}
						else
						{
							if (strParamValue.indexOf("@") != -1)
							{
								String strSingleTokenGetDomain =  strParamValue.substring(0,strParamValue.indexOf("@"));
								String strSingleTokenGetPass =  strParamValue.substring(strParamValue.indexOf("@")+1);
								if (!isNumber(strSingleTokenGetPass))
								{
									strSingleTokenGetPass = EgCrypt.decrypt(strSingleTokenGetPass);
								}
								if (strSingleTokenGetPass.indexOf("~EG~") != -1)
								{
									strSingleTokenGetPass = strSingleTokenGetPass.substring(0,strSingleTokenGetPass.indexOf("~EG~"));
								}

								strParamValue = strSingleTokenGetDomain+ "@" + strSingleTokenGetPass;

							}

							String strSaltParamValue = strParamValue;
							if (!isNumber(strSaltParamValue))
							{
								strSaltParamValue = EgCrypt.decrypt(strSaltParamValue);
							}
							if (strSaltParamValue.indexOf("~EG~") != -1)
							{
								strParamValue = strSaltParamValue.substring(0,strSaltParamValue.indexOf("~EG~"));
							}
							else
							{
								strParamValue = strSaltParamValue;
							}
							passList = EgCrypt.encrypt(strParamValue);
						}
					}
					else
					{
						if (strParamValue.indexOf("#~#") > -1)
						{
							ArrayList aListTokens1 = StringUtils.myTokenizer(strParamValue, "#~#");
							for(int m=0;m<aListTokens1.size();m++)
							{
								String strToken1 = (String) aListTokens1.get(m);
								String strSaltToken = strToken1;
								if (!isNumber(strSaltToken))
								{
									strSaltToken = EgCrypt.decrypt(strSaltToken);
								}
								if (strSaltToken.indexOf("~eGHash~") > -1)
								{
									ArrayList aListTokens2 = StringUtils.myTokenizer(strSaltToken, "~eGHash~");
									strSaltToken = "";
									for(int n=0;n<aListTokens2.size();n++)
									{
										String strToken2 = (String) aListTokens2.get(n);
										String strSaltToken1 = strToken2;
										if (!isNumber(strSaltToken1))
										{
											strSaltToken1 = EgCrypt.decrypt(strSaltToken1);
										}
										if (strSaltToken1.indexOf("~EG~") != -1)
										{
											strToken2 = strSaltToken1.substring(0,strSaltToken1.indexOf("~EG~"));
										}

										strSaltToken += (strToken2)+"~eGHash~";
									}
									strToken1 = strSaltToken.substring(0, strSaltToken.length()-8);
								}

								if (strSaltToken.indexOf("~EG~") != -1)
								{
									strToken1 = strSaltToken.substring(0,strSaltToken.indexOf("~EG~"));
								}
								else
								{
									strToken1 = strSaltToken;
								}

								if (strParamName.equals("Two_factor_auth_password") && strToken1.equalsIgnoreCase("none"))
								{
									strToken1 = strToken1.toLowerCase();
								}
								passList += (strToken1)+"#~#";
							}

							passList = passList.substring(0, passList.length()-3);
							passList = EgCrypt.encrypt(passList);
						}
						else
						{
							String strSaltParamValue = strParamValue;
							if (!isNumber(strSaltParamValue))
							{
								strSaltParamValue = EgCrypt.decrypt(strSaltParamValue);
							}

							if (strSaltParamValue.indexOf("~eGHash~") > -1)
							{
								ArrayList aListTokens1 = StringUtils.myTokenizer(strSaltParamValue, "~eGHash~");
								for(int m=0;m<aListTokens1.size();m++)
								{
									String strToken1 = (String) aListTokens1.get(m);
									if (!isNumber(strToken1))
									{
										strToken1 = EgCrypt.decrypt(strToken1);
									}

									if (strToken1.indexOf("~EG~") != -1)
									{
										strToken1 = strToken1.substring(0,strToken1.indexOf("~EG~"));
									}
									passList += (strToken1)+"~eGHash~";
								}
								passList = passList.substring(0, passList.length()-8);
							}
							else
							{
								if (strSaltParamValue.indexOf("~EG~") != -1)
								{
									strParamValue = strSaltParamValue.substring(0,strSaltParamValue.indexOf("~EG~"));
								}
								else
								{
									strParamValue = strSaltParamValue;
								}
							}

							if (strParamName.equals("Two_factor_auth_password") && strParamValue.equalsIgnoreCase("none"))
							{
								strParamValue = strParamValue.toLowerCase();
							}
							else if (strParamName.equals("-Resource_password") && !StringUtils.isNull(passList))
							{
								strParamValue = passList;
							}

							passList = EgCrypt.encrypt(strParamValue);
						}
					}
					strParamValue = passList;
				}
				else if(strParamName.equalsIgnoreCase("-credentials"))
				{
					//handling parameter value for credentials
					String credentialUser = "";
					String credentialPassword = "";
					int thisCount = 0;
					StringBuffer credentialResultantBuffer = new StringBuffer();
					StringTokenizer credentialTokens = new StringTokenizer(strParamValue,",");
					while (credentialTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							credentialResultantBuffer.append("|");
						}
						String eachUnameUpass = credentialTokens.nextToken();
						credentialUser = eachUnameUpass.substring(0,eachUnameUpass.indexOf(":"));
						String strPassChkSalt = "";

						if (egServicesInfo.isAesEncryptForTestConfig())
						{
							strPassChkSalt = eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length());
							if (!isNumber(strPassChkSalt))
							{
								strPassChkSalt = EgCrypt.decrypt(strPassChkSalt);
							}
							if (strPassChkSalt.indexOf("~EG~") != -1)
							{
								strPassChkSalt = strPassChkSalt.substring(0,strPassChkSalt.indexOf("~EG~"));
							}
							credentialPassword = EgCrypt.encrypt(strPassChkSalt);
						}
						else
						{
							strPassChkSalt = eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length());
							if (!isNumber(strPassChkSalt))
							{
								strPassChkSalt = EgCrypt.decrypt(strPassChkSalt);
							}
							if (strPassChkSalt.indexOf("~EG~") != -1)
							{
								strPassChkSalt = strPassChkSalt.substring(0,strPassChkSalt.indexOf("~EG~"));
							}
							credentialPassword = EgCrypt.encrypt(strPassChkSalt, true);
						}
						credentialResultantBuffer.append(credentialUser+":"+credentialPassword);
					}
					strParamValue = credentialResultantBuffer.toString();
				}
				else if(strParamName.equalsIgnoreCase("-privateKey"))
				{
					//handling parameter value for File password
					String filePath="none";
					String filePassword = "none";
					String encryptedFilePassword= "";
					int thisCount = 0;
					StringBuffer resultantBuffer = new StringBuffer();
					StringTokenizer resultTokens = new StringTokenizer(strParamValue,",");
					while (resultTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							resultantBuffer.append("|");
						}
						String eachFnameFpass = resultTokens.nextToken();
						String tokens[] = EgUtils.getTokens(eachFnameFpass,"#~~#");
						if(tokens != null && tokens.length==2)
						{
							filePath = tokens[0];
							filePassword = tokens[1];
						}

						String strPassChkSaltPrivate = "";
						if (egServicesInfo.isAesEncryptForTestConfig())
						{
							strPassChkSaltPrivate = filePassword;
							if (!isNumber(strPassChkSaltPrivate))
							{
								strPassChkSaltPrivate = EgCrypt.decrypt(strPassChkSaltPrivate);
							}
							if (strPassChkSaltPrivate.indexOf("~EG~") != -1)
							{
								strPassChkSaltPrivate = strPassChkSaltPrivate.substring(0,strPassChkSaltPrivate.indexOf("~EG~"));
							}
							encryptedFilePassword = EgCrypt.encrypt(strPassChkSaltPrivate);
						}
						else
						{
							strPassChkSaltPrivate = filePassword;
							if (!isNumber(strPassChkSaltPrivate))
							{
								strPassChkSaltPrivate = EgCrypt.decrypt(strPassChkSaltPrivate);
							}
							if (strPassChkSaltPrivate.indexOf("~EG~") != -1)
							{
								strPassChkSaltPrivate = strPassChkSaltPrivate.substring(0,strPassChkSaltPrivate.indexOf("~EG~"));
							}
							encryptedFilePassword = EgCrypt.encrypt(strPassChkSaltPrivate, true);
						}
						resultantBuffer.append(filePath+":"+encryptedFilePassword);
					}
					strParamValue = resultantBuffer.toString();
				}
				else if (strParamName.equalsIgnoreCase("-alertFile"))
				{
					if (testName.equalsIgnoreCase("EgErrorLogTest") || 
						testName.equalsIgnoreCase("EgThreshLogTest") || 
						testName.equalsIgnoreCase("EgTrendLogTest"))
					{
						if (strParamValue.indexOf(",") != -1)
						{
							String strUpdatedParamValue = "";
							StringTokenizer strTokens = new StringTokenizer(strParamValue,",");
							while (strTokens.hasMoreTokens())
							{
								String strToken = strTokens.nextToken();
								strUpdatedParamValue = strUpdatedParamValue + "(EG_HOME_DIR)" + strToken + ",";
							}
							strParamValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-1);
						}
						else
						{
							strParamValue = "(EG_HOME_DIR)" + strParamValue;
						}
					}
				}
				else if (strParamName.equals("-Published_resources"))
				{
					String strHiddenPubResrc = request.getParameter("hiddenPublishedResource");
					strHiddenPubResrc = EgUIUtils.decodeSecurityChar(strHiddenPubResrc);

					if ((!StringUtils.isNull(strHiddenPubResrc) && strHiddenPubResrc.indexOf(" -") > -1) || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase().substring(1)))
					{
						strHiddenPubResrc = "\"" + strHiddenPubResrc + "\"";
					}
					strParamValue = strHiddenPubResrc;
				}
				else if (strParamName.equals("-site_URL(S)"))
				{
					String strHiddenSiteURL = request.getParameter("hiddenSiteURL");

					strParamValue = EgUIUtils.decodeSecurityChar(strHiddenSiteURL);
					//strParamValue = strHiddenSiteURL;
				}
				else if (strParamName.equalsIgnoreCase("-Script_name"))
				{
					if (!StringUtils.isNull(strParamValue) && !strParamValue.equals("none"))
					{
						strParamValue = getModifiedParamValue(strParamValue);
					}
				}

				//replacing pipe in place of comma for the tests having pipe as delimiter
				if (!isHashDelimiter && strParamValue.indexOf(",") > -1)
				{
					strParamValue = StringUtils.replace(strParamValue,",","|");
				}
				if (!isHashDelimiter && strParamValue.indexOf(";") > -1)
				{
					if(!aListEventTests.contains(testName) && !testName.equalsIgnoreCase("WinProcessTest") && !testName.equalsIgnoreCase("LSEventLogTest") && !testName.equalsIgnoreCase("LSEdgeEvtLogTest"))
					{
						strParamValue = StringUtils.replace(strParamValue,";","~#~");
					}
				}
			}

			if (z == 0 && strParamName.startsWith("-password_profile"))
			{
				isPwdProfileUpdate = true;
				String paramsSetForThisParam = (String) pwdParamSetList.get(strParamName.substring(1));

				isSpecificProfile = pwdProf.isTestHasSpecificPwdProfile(componentType+":"+componentName+"#^#"+paramsSetForThisParam,testName);

				if (aListPwdProfIniEntries == null)
				{
					aListPwdProfIniEntries = new ArrayList();
				}

				strUsePwdProfValue = strParamValue;
				if (!strParamValue.equals("-1") && !strParamValue.equalsIgnoreCase("none"))
				{
					if (fromPage.equals("EgConfigureComponentTests.jsp"))
					{
						profileName = request.getParameter(strParamName.substring(1));
					}
					else
					{
						int idx = aListTemp.indexOf(strParamName);
						String strPwdProfValue = (String)aListTemp.get(idx+1);
						profileName = strPwdProfValue;
					}

					if (!StringUtils.isNull(profileName) && !profileName.equals("-1"))
					{
						//pwdProfileParams = pwdProfIniSync.getValue("TestNames",testName);
						pwdProfileParams = request.getParameter("pwdProfileParams");

						if (isSpecificProfile)
						{
							specificProfile = pwdProf.getProfNameForSpecificConfiguration(componentType+":"+componentName+"#^#"+paramsSetForThisParam,testName);
							String pwdProfSubExist = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;

							if (!StringUtils.isNull(specificProfile) && !specificProfile.equals(profileName))
							{
								pwdProfSubExist = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;

								aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,testName,""));

							}
							pwdProfSubExist = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+profileName;
							aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSubExist,testName,paramsSetForThisParam));
						}
						else
						{
							String pwdProfSub = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+profileName;
							aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSub,testName,paramsSetForThisParam));
						}
					}
					else
					{
						if (isSpecificProfile)
						{
							specificProfile = pwdProf.getProfNameForSpecificConfiguration(componentType+":"+componentName+"#^#"+paramsSetForThisParam,testName);

							if (!StringUtils.isNull(specificProfile))
							{
								String pwdProfSubExist = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;
								aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,testName,""));
							}
						}
					}
				}
				else
				{
					if (isSpecificProfile)
					{
						specificProfile = pwdProf.getProfNameForSpecificConfiguration(componentType+":"+componentName+"#^#"+paramsSetForThisParam,testName);

						if (!StringUtils.isNull(specificProfile))
						{
							String pwdProfSubExist = componentType+":"+componentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;

							aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,testName,""));
						}
					}
				}
				continue;
			}
			aListProcessedParamNamesAndValues.add(strParamName);
			aListProcessedParamNamesAndValues.add(strParamValue);
		}

		//to display the updated parameters and their values to the user - starts
		if (z == 0)
		{
			String tempValue = new String(testPeriod);
			tempValue = tempValue.trim();
			if (Integer.parseInt(tempValue) <= 60)
			{
				tempValue+=" secs";
			}
			else if (Integer.parseInt(tempValue) <= 3599)
			{
				int tpmin=Integer.parseInt(tempValue)/60;
				tempValue=""+tpmin+" mins";
			}
			else if (tempValue.equals("3600"))
			{
				tempValue="1 hr";
			}
			else
			{
				int tphr=Integer.parseInt(tempValue)/3600;
				tempValue=""+tphr+" hrs";
			}

			aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test.TEST PERIOD"));
			aListDisplayParamNamesAndValues.add(tempValue);

			//for auditlog - starts
			if (isAuditLogEnabled)
			{
				if(showAddAuditlog)
				{
					auditLogThread.setCurrentValue("01~~TEST PERIOD",tempValue);
				}
				else
				{
					if (auditLogHt.containsKey("testPeriod"))
					{
						String preTestPeriod = (String)auditLogHt.get("testPeriod");
						if (!StringUtils.isNull(preTestPeriod) && (preTestPeriod=preTestPeriod.trim()).length()>0 && !preTestPeriod.equalsIgnoreCase("null"))
						{
							if (Integer.parseInt(preTestPeriod) <= 60)
							{
								preTestPeriod+=" secs";
							}
							else if (Integer.parseInt(preTestPeriod) <= 3599)
							{
								int tpmin=Integer.parseInt(preTestPeriod)/60;
								preTestPeriod=""+tpmin+" mins";
							}
							else if (preTestPeriod.equals("3600"))
							{
								preTestPeriod="1 hr";
							}
							else
							{
								int tphr=Integer.parseInt(preTestPeriod)/3600;
								preTestPeriod=""+tphr+" hrs";
							}
							auditLogThread.setPreviousValue("01~~TEST PERIOD",preTestPeriod);
						}
					}
					auditLogThread.setCurrentValue("01~~TEST PERIOD",tempValue);
				}
				auditParamIdx++;
			}
			//for auditlog - ends

			ArrayList aListDisplay = (ArrayList)session.getAttribute("aListDisplay");

			boolean showExcludeDesc = false;
			boolean showIncludeDesc = false;
			int idx = aListProcessedParamNamesAndValues.indexOf("-action_on_descriptors");
			if(idx>0)
			{
				String action_on_descriptors_value = (String)aListProcessedParamNamesAndValues.get(idx+1);
				if(action_on_descriptors_value.equalsIgnoreCase("exclude"))
				{
					showExcludeDesc = true;
					showIncludeDesc = false;
				}
				else if(action_on_descriptors_value.equalsIgnoreCase("include"))
				{
					showExcludeDesc = false;
					showIncludeDesc=true;
				}
			}
			for(int i=0;i<aListProcessedParamNamesAndValues.size();i=i+2)
			{
				String paramName = (String)aListProcessedParamNamesAndValues.get(i);

				if (fromPage.equalsIgnoreCase("EgApplyToOtherComponents.jsp") && 
					!aListTemp.contains(paramName))
				{
					continue;
				}

				paramName = paramName.substring(1).trim();
				String auditLogParamName = updateAuditlogParams(paramName);
				if (fromPage.equalsIgnoreCase("EgConfigureComponentTests.jsp") &&
					request.getParameter(paramName) == null)
				{
					if(paramName.equalsIgnoreCase("filter"))
					{
						if(request.getParameter("filter_combo") == null)
						{
							continue;
						}
					}
					else
					{
						continue;
					}
				}

				String paramValue = (String)aListProcessedParamNamesAndValues.get(i+1);
				paramValue = paramValue.trim();

				int paramIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (paramIdx > -1) continue;

				if (paramName.equalsIgnoreCase("port") && paramValue.equalsIgnoreCase("NULL"))
					continue;

				boolean showConfirmPassWord = false;
				if (hasPasswordParameters && aListPasswordParameters.contains("-" + paramName))
				{
					if (isAuditLogEnabled && auditLogHt.containsKey(paramName))
					{
						if(showAddAuditlog)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"*****");
						}
						else
						{
							String preParamValue = (String)auditLogHt.get(paramName);
							if(preParamValue != null && paramValue != null && !preParamValue.equals(paramValue))
							{
								auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"*****");
								auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"******");
							}
						}
					}
					auditParamIdx++;
					continue;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains("-" + paramName.toLowerCase()))
				{
					if (isAuditLogEnabled && auditLogHt.containsKey(paramName))
					{
						if(showAddAuditlog)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"*****");
						}
						else
						{
							String preParamValue = (String)auditLogHt.get(paramName);
							if(preParamValue != null && paramValue != null && !preParamValue.equals(paramValue))
							{
								auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"*****");
								auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"******");
							}
						}
					}
					auditParamIdx++;
					continue;
				}

				if (paramName.equals("rptName") || paramName.equals("mCount"))
				{
					continue;
				}

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}

				if (paramName.equalsIgnoreCase("os"))
				{
					if (paramValue.equalsIgnoreCase("xp"))
					{
						paramValue = "Window XP";
					}
					else if (paramValue.equalsIgnoreCase("2003"))
					{
						paramValue = "Windows 2003";
					}
					else if (paramValue.equalsIgnoreCase("2008"))
					{
						paramValue = "Windows 2008";
					}
					else if (paramValue.equalsIgnoreCase("w2k"))
					{
						paramValue = "Windows 2000";
					}
					else if (paramValue.equalsIgnoreCase("nt"))
					{
						paramValue = "Windows NT";
					}
					else if (paramValue.equalsIgnoreCase("hpux") || 
						paramValue.equalsIgnoreCase("aix"))
					{
						paramValue = paramValue.toUpperCase();
					}
					else if (paramValue.equalsIgnoreCase("tru64"))
					{
						paramValue = "Tru64";
					}
					else if (paramValue.equalsIgnoreCase("linux"))
					{
						paramValue = "Linux";
					}
					else if (paramValue.equalsIgnoreCase("solaris"))
					{
						paramValue = "Solaris";
					}
					else if (paramValue.equalsIgnoreCase("other"))
					{
						paramValue = "Other";
					}
				}
				else if (paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
					String tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());

					if (tempTargetDiskIORate.equalsIgnoreCase("eq"))
					{
						tempTargetDiskIORate = "Equals";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("lt"))
					{
						tempTargetDiskIORate = "Less Than";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("le"))
					{
						tempTargetDiskIORate = "Less Than or Equal To";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("gt"))
					{
						tempTargetDiskIORate = "Greater Than";
					}
					else
					{
						tempTargetDiskIORate = "Greater Than or Equal To";
					}

					paramValue = tempTargetDiskIORate + " " + tempTargetDiskIORateValue;
				}
				else if (paramName.equalsIgnoreCase("executiontime") && 
					request.getParameter("minutes") != null && 
					request.getParameter("hours") != null)
				{
					paramValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
				}
				if(isRESTICTest && paramName.equalsIgnoreCase("request_headers"))
				{
					if(paramValue!=null && !paramValue.equals(""))
					{
						paramValue = EgCrypt.encrypt(paramValue);
						if (paramValue.indexOf(";") > -1)
						{
							paramValue = StringUtils.replace(paramValue,";","!cma!");
						}
						if (paramValue.indexOf("~#~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~#~","!cma!");
						}
						if (paramValue.indexOf("!colon!") > -1)
						{
							paramValue = StringUtils.replace(paramValue,":","!colon!");
						}
					}
				}

				if (!aListDisplay.contains(paramName+"#"+paramValue) && 
					(paramValue.equalsIgnoreCase("false") || paramValue.equalsIgnoreCase("n") || paramValue.equalsIgnoreCase("no")))
				{
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.No"));

					//for auditlog - starts
					if (isAuditLogEnabled && auditLogHt.containsKey(paramName))
					{
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							if(showAddAuditlog)
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
								}
							}
							else
							{
								String preParamValue = (String)auditLogHt.get(paramName);
								if (auditParamIdx <= 9)
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
										}
										else
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
										}
									}
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
								}
								else
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
										}
										else
										{
											auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
										}
									}
									auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
								}
							}
						}
						else
						{
							if(showAddAuditlog)
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"No");
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,"No");
								}
							}
							else
							{
								String preParamValue = (String)auditLogHt.get(paramName);
								if (auditParamIdx <= 9)
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"Yes");
										}
										else
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"No");
										}
									}
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"No");
								}
								else
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~"+auditLogParamName,"Yes");
										}
										else
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~"+auditLogParamName,"No");
										}
									}
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,"No");
								}
							}
						}
						auditParamIdx++;
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
							if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
							{
								String query[] = getDeleteQueries(componentName,testName);
								com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
								updateAndTransmitUserInfo.rename(query);
							}
						}
					}
					//for auditlog - ends
				}
				else if (!aListDisplay.contains(paramName+"#"+paramValue) && 
					(paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("y") || paramValue.equalsIgnoreCase("yes")))
				{
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.Yes"));

					//for auditlog - starts
					if (isAuditLogEnabled && auditLogHt.containsKey(paramName))
					{
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							if(showAddAuditlog)
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
								}
							}
							else
							{
								String preParamValue = (String)auditLogHt.get(paramName);
								if (auditParamIdx <= 9)
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
										}
										else
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
										}
									}
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
								}
								else
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
										}
										else
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","Yes");
										}
									}
									auditLogThread.setCurrentValue(auditParamIdx+"~~REPORT BY DESCRIPTORS","No");
								}
							}
						}
						else
						{
							if(showAddAuditlog)
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"Yes");
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,"Yes");
								}
							}
							else
							{
								String preParamValue = (String)auditLogHt.get(paramName);
								if (auditParamIdx <= 9)
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"Yes");
										}
										else
										{
											auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,"No");
										}
									}
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,"Yes");
								}
								else
								{
									if(preParamValue != null)
									{
										if(preParamValue.equalsIgnoreCase("true") || preParamValue.equalsIgnoreCase("y") || preParamValue.equalsIgnoreCase("yes"))
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~"+auditLogParamName,"Yes");
										}
										else
										{
											auditLogThread.setPreviousValue(auditParamIdx+"~~"+auditLogParamName,"No");
										}
									}
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,"Yes");
								}
							}
						}
						auditParamIdx++;
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
							if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
							{
								String query[] = getDeleteQueries(componentName,testName);
								com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
								updateAndTransmitUserInfo.rename(query);
							}
						}
					}
					//for auditlog - ends
				}
				else
				{
					ArrayList credentials = new ArrayList();
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					if(paramName.equalsIgnoreCase("credentials"))
					{
						String temp = "";
						ArrayList aListUsers = getArrayList(paramValue,"|");
						credentials = aListUsers;
						for(int b=0;b<aListUsers.size();b++)
						{
							String str=(String)aListUsers.get(b);
							str = str.substring(0,str.indexOf(":"));
							temp = temp + str + ",";
						}
						temp = temp.substring(0,temp.length()-1);
						paramValue = temp;
					}

					if (paramName.equalsIgnoreCase("alertFile"))
					{
						if (testName.equalsIgnoreCase("EgErrorLogTest") || 
							testName.equalsIgnoreCase("EgThreshLogTest") || 
							testName.equalsIgnoreCase("EgTrendLogTest"))
						{
							if (paramValue.indexOf("|") != -1)
							{
								String strUpdatedParamValue = "";
								StringTokenizer strTokens = new StringTokenizer(paramValue,"|");
								while (strTokens.hasMoreTokens())
								{
									String strToken = strTokens.nextToken();
									strUpdatedParamValue = strUpdatedParamValue + strToken.substring(strToken.indexOf("(EG_HOME_DIR)")+13) + "| ";
								}
								paramValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-2);
							}
							else
							{
								paramValue = paramValue.substring(paramValue.indexOf("(EG_HOME_DIR)")+13);
							}
						}
					}

					if(paramValue.indexOf("|")>-1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if(!paramName.equalsIgnoreCase("snmpcommunity") && paramValue.indexOf("#")>-1)
					{
						paramValue = StringUtils.replace(paramValue,"#",",");
					}
					String backupParamValue = paramValue;
					if (paramName.equalsIgnoreCase("url"))
					{
						int tempUrlIdx = aListTemp.indexOf("-"+paramName);
						paramValue = (String)aListTemp.get(tempUrlIdx+1);
					}

					if (b_testWithDelimiter && strMask.length() > 0 && paramValue.indexOf(strMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strMask,strDelimiter);
					}

					if (aListDisplay.contains(paramName+"#"+paramValue))
					{
						int paramValIdx = aListDisplay.indexOf(paramName+"#"+paramValue);
						paramValue = (String)aListDisplay.get(paramValIdx+1);
					}
					aListDisplayParamNamesAndValues.add(paramValue);

					if (paramName.equalsIgnoreCase("snmpversion") && 
						(paramValue.equalsIgnoreCase("v1") || paramValue.equalsIgnoreCase("v2")))
					{
						//Displaying the needed parameters in the ui for snmpV1 and snmpV2 only.
						int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);

						if (snmpParamIdx > -1) continue;
					}
					if (paramName.equalsIgnoreCase("url"))//this is for auditlog
					{
						paramValue = backupParamValue;
					}
					//for auditlog - starts
					if (isAuditLogEnabled && auditLogHt.containsKey(paramName))
					{
						if(showExcludeDesc && paramName.equals("include_descriptors"))
						{
							continue;
						}
						else if(showIncludeDesc && paramName.equals("excludeDescriptor"))
						{
							continue;
						}
						if(showAddAuditlog)
						{
							if (paramName.equalsIgnoreCase("host"))
							{
								if(!testName.endsWith("_ag") && !testName.endsWith("_agx"))
								{
									auditLogThread.setCurrentValue("02~~HOST",paramValue);
									auditParamIdx++;
								}
							}
							else if (paramName.equalsIgnoreCase("port"))
							{
								auditLogThread.setCurrentValue("03~~PORT",paramValue);
								auditParamIdx++;
							}
							else
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,paramValue);
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,paramValue);
								}
								if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
								{
									String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
									if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
									{
										String query[] = getDeleteQueries(componentName,testName);
										com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
										updateAndTransmitUserInfo.rename(query);
									}
								}
								auditParamIdx++;
							}
						}
						else
						{
							if (paramName.equalsIgnoreCase("host"))
							{
								if(!testName.endsWith("_ag") && !testName.endsWith("_agx"))
								{
									if(auditLogHt.containsKey(paramName))
									{
										String previousValue = (String)auditLogHt.get(paramName);
										auditLogThread.setPreviousValue("02~~HOST",previousValue);
									}
									auditLogThread.setCurrentValue("02~~HOST",paramValue);
									auditParamIdx++;
								}
							}
							else if (paramName.equalsIgnoreCase("port"))
							{
								if(auditLogHt.containsKey(paramName))
								{
									String previousValue = (String)auditLogHt.get(paramName);
									auditLogThread.setPreviousValue("03~~PORT",previousValue);
								}
								auditLogThread.setCurrentValue("03~~PORT",paramValue);
								auditParamIdx++;
							}
							else
							{
								String currentValue = paramValue;
								if(paramName.equalsIgnoreCase("Inside_view_using"))
								{
									if(auditLogHt.containsKey(paramName))
									{
										String previousValue = (String)auditLogHt.get(paramName);
										auditLogHt.put(paramName, previousValue.equals("exe")?"Remote connection to VM(windows)":previousValue.equals("tcp")?"eG VM Agent(windows)":previousValue);
									}
									currentValue = currentValue.equals("exe")?"Remote connection to VM(windows)":currentValue.equals("tcp")?"eG VM Agent(windows)":currentValue;
								}
								else if(testName.equalsIgnoreCase("HttpTest"))
								{
									if(paramName.equalsIgnoreCase("credentials"))
									{
										if(credentials != null && credentials.size()>0)
										{
											currentValue = (String)credentials.get(0);
										}
										int idxCol = currentValue.indexOf(":");
										String crPwd = "";
										if(idxCol != -1)
										{
											String s1 = currentValue.substring(0,idxCol);
											crPwd = currentValue.substring(idxCol+1);
											if (!isNumber(crPwd))
											{
												crPwd = EgCrypt.decrypt(crPwd);
											}
											currentValue = (s1+":"+crPwd).equals("none:none")?"none":s1;
										}
										if(auditLogHt.containsKey(paramName))
										{
											String previousValue = (String)auditLogHt.get(paramName);
											idxCol = previousValue.indexOf(":");
											if(idxCol != -1)
											{
												String s1 = previousValue.substring(0,idxCol);
												String prPwd = previousValue.substring(idxCol+1);
												if (!isNumber(prPwd))
												{
													prPwd = EgCrypt.decrypt(prPwd);
												}
												previousValue = (s1+":"+prPwd).equals("none:none")?"none":s1;
												if(!crPwd.equals(prPwd))
												{
													previousValue += ":*****";
													currentValue += ":******";
												}
												auditLogHt.put(paramName,previousValue);
											}
										}
									}
									else if(paramName.equalsIgnoreCase("content"))
									{
										int idxCol = currentValue.indexOf(":");
										if(idxCol != -1)
										{
											String s1 = currentValue.substring(0,idxCol);
											s1 = s1.equalsIgnoreCase("Inc") ? "Include" : s1.equalsIgnoreCase("Exc") ? "Exclude" : s1.equalsIgnoreCase("none") ? "None" : s1;
											currentValue = s1+":"+currentValue.substring(idxCol+1);
										}
										if(auditLogHt.containsKey(paramName))
										{
											String previousValue = (String)auditLogHt.get(paramName);
											idxCol = previousValue.indexOf(":");
											if(idxCol != -1)
											{
												String s1 = previousValue.substring(0,idxCol);
												s1 = s1.equalsIgnoreCase("Inc") ? "Include" : s1.equalsIgnoreCase("Exc") ? "Exclude" : s1.equalsIgnoreCase("none") ? "None" : s1;
												auditLogHt.put(paramName,s1+":"+previousValue.substring(idxCol+1));
											}
										}
									}
									else if(paramName.equalsIgnoreCase("privatekey"))
									{
										int idxCol = currentValue.indexOf(":");
										String crPwd = "";
										if(idxCol != -1)
										{
											String s1 = currentValue.substring(0,idxCol);
											crPwd = currentValue.substring(idxCol+1);
											if (!isNumber(crPwd))
											{
												crPwd = EgCrypt.decrypt(crPwd);
											}
											currentValue = (s1+":"+crPwd).equals("none:none") ? "none" : s1;
										}
										if(auditLogHt.containsKey(paramName))
										{
											String previousValue = (String)auditLogHt.get(paramName);
											idxCol = previousValue.indexOf(":");
											if(idxCol != -1)
											{
												String s1 = previousValue.substring(0,idxCol);
												String prPwd = previousValue.substring(idxCol+1);
												if (!isNumber(prPwd))
												{
													prPwd = EgCrypt.decrypt(prPwd);
												}
												previousValue = (s1+":"+prPwd).equals("none:none") ? "none" : s1;
												if(!crPwd.equals(prPwd))
												{
													previousValue += ":*****";
													currentValue += ":******";
												}
												auditLogHt.put(paramName,previousValue);
											}
										}
									}
								}

								if (auditParamIdx <= 9)
								{
									if(auditLogHt.containsKey(paramName))
									{
										String previousValue = (String)auditLogHt.get(paramName);
										if(aListDisplay != null)
										{
											int aidx = aListDisplay.indexOf(paramName+"#"+previousValue);
											if(aidx>-1)
											{
												previousValue=(String)aListDisplay.get(aidx+1);
												System.out.println();
											}
										}

										if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("H"))
										{
											previousValue="Critical";
										}
										else if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("M"))
										{
											previousValue="Critical/Major";
										}
										else if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("L"))
										{
											previousValue="Critical/Major/Minor";
										}
										else if(previousValue.equalsIgnoreCase("true") || previousValue.equalsIgnoreCase("y") || previousValue.equalsIgnoreCase("yes"))
										{
											previousValue="Yes";
										}
										else if(previousValue.equalsIgnoreCase("false") || previousValue.equalsIgnoreCase("n") || previousValue.equalsIgnoreCase("no"))
										{
											previousValue="No";
										}
										else if(previousValue.indexOf("|")>-1)
										{
											previousValue = StringUtils.replace(previousValue,"|",",");
										}
										previousValue=StringUtils.replace(previousValue,"~egSpace~"," ");
										auditLogThread.setPreviousValue("0"+auditParamIdx+"~~"+auditLogParamName,previousValue);
									}
									currentValue=StringUtils.replace(currentValue,"~egSpace~"," ");
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+auditLogParamName,currentValue);
								}
								else
								{
									if(auditLogHt.containsKey(paramName))
									{
										String previousValue = (String)auditLogHt.get(paramName);
										if(aListDisplay != null)
										{
											int aidx = aListDisplay.indexOf(paramName+"#"+previousValue);
											if(aidx>-1)
											{
												previousValue=(String)aListDisplay.get(aidx+1);
												System.out.println();
											}
										}
										if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("H"))
										{
											previousValue="Critical";
										}
										else if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("M"))
										{
											previousValue="Critical/Major";
										}
										else if(paramName.equalsIgnoreCase("alarmtype") && previousValue.equalsIgnoreCase("L"))
										{
											previousValue="Critical/Major/Minor";
										}
										else if(previousValue.equalsIgnoreCase("true") || previousValue.equalsIgnoreCase("y") || previousValue.equalsIgnoreCase("yes"))
										{
											previousValue="Yes";
										}
										else if(previousValue.equalsIgnoreCase("false") || previousValue.equalsIgnoreCase("n") || previousValue.equalsIgnoreCase("no"))
										{
											previousValue="No";
										}
										else if(previousValue.indexOf("|")>-1)
										{
											previousValue = StringUtils.replace(previousValue,"|",",");
										}
										auditLogThread.setPreviousValue(auditParamIdx+"~~"+auditLogParamName,previousValue);
									}
									auditLogThread.setCurrentValue(auditParamIdx+"~~"+auditLogParamName,currentValue);
								}
								if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
								{
									String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
									if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
									{
										String query[] = getDeleteQueries(componentName,testName);
										com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
										updateAndTransmitUserInfo.rename(query);
									}
								}
								auditParamIdx++;
							}
						}
					}
					//for auditlog - ends
				}
			}

			if (!detailedDiagnosis.equals(""))
			{
				aListDisplayParamNamesAndValues.add("DETAILEDDIAGNOSIS");
				aListDisplayParamNamesAndValues.add(detailedDiagnosis);

				//for auditlog - starts
				if (isAuditLogEnabled && auditLogHt.containsKey("detaileddiagnosis"))
				{
					if(showAddAuditlog)
					{
						if (auditParamIdx <= 9)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~DETAILED DIAGNOSIS",detailedDiagnosis);
						}
						else
						{
							auditLogThread.setCurrentValue(auditParamIdx+"~~DETAILED DIAGNOSIS",detailedDiagnosis);
						}
					}
					else
					{
						if (auditParamIdx <= 9)
						{
							if(auditLogHt.containsKey("detaileddiagnosis"))
							{
								String previousValue = (String)auditLogHt.get("detaileddiagnosis");
								auditLogThread.setPreviousValue("0"+auditParamIdx+"~~DETAILED DIAGNOSIS",previousValue);
							}
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~DETAILED DIAGNOSIS",detailedDiagnosis);
						}
						else
						{
							if(auditLogHt.containsKey("detaileddiagnosis"))
							{
								String previousValue = (String)auditLogHt.get("detaileddiagnosis");
								auditLogThread.setPreviousValue(auditParamIdx+"~~DETAILED DIAGNOSIS",previousValue);
							}
							auditLogThread.setCurrentValue(auditParamIdx+"~~DETAILED DIAGNOSIS",detailedDiagnosis);
						}
					}
					auditParamIdx++;
				}
				//for auditlog - ends
			}
		}
		//to display the updated paramters and their values to the user - ends

		String strValue = aListProcessedParamNamesAndValues.toString();
		strValue = strValue.substring(1,strValue.length()-1);
		strValue = StringUtils.replace(strValue,",","");
		strValue = strValue.trim();

		ArrayList aListDisabledTest = new ArrayList();

		String strDisabledTest = disableIni.getValue("Default_server","Default_server" + ":" + tempComponentNickName);

		if (strDisabledTest!= null && !strDisabledTest.equals(""))
		{
			aListDisabledTest = getArrayList(strDisabledTest,",");
		}

		strDisabledTest = disableIni.getValue(componentType,componentType + ":" + tempComponentName);
		if (strDisabledTest!= null && !strDisabledTest.equals(""))
		{
			aListDisabledTest.addAll(getArrayList(strDisabledTest,","));
		}

		for(int k=0;k<aListRelationTests.size();k++)
		{
			String strTestName = (String)aListRelationTests.get(k);
			if (aListEnabledTestForCompType.contains(strTestName) && 
				!aListDisabledTest.contains(strTestName))
			{
				aListConfigurableTest.add(strTestName);
			}
		}

		boolean isVCThruDiscover = false;
		boolean isHMCThruDiscover = false;
		boolean isRHEVThruDiscover = false;
		boolean hasVCinServicesIni = false;
		String type = "vcenter";
		String subVc = "VIRTUAL_CENTER";

		IniFile mgrMiscIniObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
		String discoverHyperThru = mgrMiscIniObj.getValue("MISC_ARGS", "DiscoverHypervisorsThru");
		if (StringUtils.isNull(discoverHyperThru))
		{
			if (eGMgrModel != null && eGMgrModel.equalsIgnoreCase("msp"))
			{
				discoverHyperThru = "Agent";
			}
			else
			{
				discoverHyperThru = "Manager";
			}
		}

		String strVCAgentName = "";
		if (isVcenterCompType || isNutClusterCompType || isRHEVLinuxMgrCompType)
		{
			if (!StringUtils.isNull(tempComponentNickName))
			{
				String strVCCompName = tempComponentNickName;
				if (isNutClusterCompType || isNtxCtrlCompType)
				{
					type = "nutanix";
					subVc = "NUTANIX";
				}
				else if (isRHEVLinuxMgrCompType)
				{
					type = "rhev";
					subVc = "RHEV";
				}
				String[] allVCs = servIni.getVariables(subVc);

				int ipIdx = 0;
				String vcIpAddr = "";
				if (aListProcessedParamNamesAndValues.contains("-host"))
				{
					ipIdx = aListProcessedParamNamesAndValues.indexOf("-host");
					vcIpAddr = (String)aListProcessedParamNamesAndValues.get(ipIdx+1);
				}

				if (allVCs != null && allVCs.length > 0)
				{
					ArrayList tmpList = new ArrayList(Arrays.asList(allVCs));
					if (tmpList.contains(strVCCompName) || tmpList.contains(vcIpAddr))
					{
						hasVCinServicesIni = true;
					}
				}

				List agentList = getAgents(componentType, strVCCompName);
				strVCAgentName = (String) agentList.get(0);

				if (userRmtAgentList != null && userRmtAgentList.contains(strVCAgentName))
				{
					String[] allVCsOfAgent = agtlessDiscIni.getVariables(strVCAgentName);
					if (allVCsOfAgent != null && allVCsOfAgent.length > 0)
					{
						ArrayList tmpList = new ArrayList(Arrays.asList(allVCsOfAgent));
						if (tmpList.contains(type+"#"+strVCCompName) || tmpList.contains(type+"#"+vcIpAddr))
						{
							if (isRHEVLinuxMgrCompType)
							{
								isRHEVThruDiscover = true;
							}
							else
							{
								isVCThruDiscover = true;
							}
						}
					}

					if (!isVCThruDiscover && isNutClusterCompType)
					{
						String ntxMappSubject = getNtxCtrlMappingSubject(strVCAgentName, vcIpAddr);
						if (!StringUtils.isNull(ntxMappSubject))
						{
							isVCThruDiscover = true;
						}
					}
				}
			}
		}
		boolean isReqParamsChanged = false; // avoid repeation for each test in eg_agentless process for vc coomp type
		//processing each test-starts here
		String strTestPeriod = "";
		for (int k=0;k<aListConfigurableTest.size();k++)
		{
			String strTestName = (String)aListConfigurableTest.get(k);
			boolean isSaveTheAuditForOtherTest = false;

			// discovering the virtual center components code starts here...
			if (k == 0 && (isVCThruDiscover || isRHEVThruDiscover || hasVCinServicesIni))
			{
				int vcUserIdx = -1;
				int vcPasswordIdx = -1;

				String unameStr = "-Vc_user";
				String upassStr = "-Vc_password";
				String sslStr = "-ssl";
				String webportStr = "-webPort";
				String domainStr = "-Rhel_manager_domain";

				if (type.equals("nutanix"))
				{
					unameStr = "-Nutanix_prism_user";
					upassStr = "-Nutanix_prism_password";
					if (isNtxCtrlCompType)
					{
						unameStr = "-Nutanix_prism_center_user";
						upassStr = "-Nutanix_prism_center_password";
					}
				}
				else if (type.equals("rhev"))
				{
					webportStr = "-port";
					unameStr = "-Rhel_manager_user";
					upassStr = "-Rhel_manager_password";
				}


				if (aListProcessedParamNamesAndValues.contains(unameStr))
				{
					vcUserIdx = aListProcessedParamNamesAndValues.indexOf(unameStr);
					vcPasswordIdx = aListProcessedParamNamesAndValues.indexOf(upassStr);
				}

				String vcUserValue = (String)aListProcessedParamNamesAndValues.get(vcUserIdx+1);
				String vcPasswordValue = (String)aListProcessedParamNamesAndValues.get(vcPasswordIdx+1);
				//vcPasswordValue = EgCrypt.decrypt(vcPasswordValue);
				String strVcPassTokenSalt = vcPasswordValue;
				if (!isNumber(strVcPassTokenSalt))
				{
					strVcPassTokenSalt = EgCrypt.decrypt(strVcPassTokenSalt);
				}
				if (strVcPassTokenSalt.indexOf("~EG~") != -1)
				{
					vcPasswordValue = strVcPassTokenSalt.substring(0,strVcPassTokenSalt.indexOf("~EG~"));
				}
				else
				{
					vcPasswordValue = strVcPassTokenSalt;
				}
				vcPasswordValue = EgCrypt.encrypt(vcPasswordValue);

				int vcSSLIdx = aListProcessedParamNamesAndValues.indexOf(sslStr);
				String vcSSLValue = (String)aListProcessedParamNamesAndValues.get(vcSSLIdx+1);

				int vcWebPortIdx = aListProcessedParamNamesAndValues.indexOf(webportStr);
				String vcWebPort = (String)aListProcessedParamNamesAndValues.get(vcWebPortIdx+1);

				String isVcDiscovery = "no";

				String preVcSSL = "";
				String preVcname = "";
				String preVcPass = "";
				String preVcWebPort = "";
				String preDomain = "";
				String domainValue = "";

				boolean isNtxCtrlHyperVisor =  true;
				boolean hasReqParamsForVcModify = (vcUserIdx != -1 && vcPasswordIdx != -1 &&  vcSSLIdx != -1 && vcWebPortIdx != -1);
				if (aListAgtlessDiscIniEntries == null)
				{
					aListAgtlessDiscIniEntries = new ArrayList();
				}

				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}

				if (aListNtxCenterMappIniEntries == null)
				{
					aListNtxCenterMappIniEntries = new ArrayList();
				}

				if (isVCThruDiscover || isRHEVThruDiscover) // for agent discovery process
				{
					if (!StringUtils.isNull(strVCAgentName) && hasReqParamsForVcModify && !isReqParamsChanged)
					{
						String strVCName = discInfo.getComponentIP(componentType, tempComponentName);
						otherHVIpAddrList.add(strVCName);
						String pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase();
						if (isRHEVThruDiscover)
						{
							int domainIdx = aListProcessedParamNamesAndValues.indexOf(domainStr);
							domainValue = (String) aListProcessedParamNamesAndValues.get(domainIdx+1);
							pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~"+domainValue;
						}

						if (type.equals("nutanix"))
						{
							pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~false";
							if (isNtxCtrlCompType)
							{
								pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~true";
							}
						}

						String vcExistVal = agtlessDiscIni.getValue(strVCAgentName, type +"#" +strVCName);
						if (!StringUtils.isNull(vcExistVal))
						{
							isNtxCtrlHyperVisor = false;
							StringTokenizer sst =  new StringTokenizer(vcExistVal,"~#~");
							int totalCnt = sst.countTokens();
							if (sst.hasMoreTokens())
							{
								if (isRHEVThruDiscover)
								{
									isVcDiscovery = sst.nextToken();
									preVcname = sst.nextToken();
									preVcPass = sst.nextToken();
									preVcSSL = sst.nextToken();
									preVcWebPort = sst.nextToken();
									preDomain = sst.nextToken();
								}
								else
								{
									isVcDiscovery = sst.nextToken();
									preVcname = sst.nextToken();
									preVcPass = sst.nextToken();
									preVcWebPort = sst.nextToken();
									preVcSSL = sst.nextToken();
								}
							}

							//preVcPass = EgCrypt.decrypt(preVcPass);
							if (!isNumber(preVcPass))
							{
								preVcPass = EgCrypt.decrypt(preVcPass);
							}
							if (preVcPass.indexOf("~EG~") != -1)
							{
								preVcPass = preVcPass.substring(0,preVcPass.indexOf("~EG~"));
							}

							String currPass = vcPasswordValue;
							if (!isNumber(currPass))
							{
								currPass = EgCrypt.decrypt(currPass);
							}
							if (currPass.indexOf("~EG~") != -1)
							{
								currPass = currPass.substring(0,currPass.indexOf("~EG~"));
							}

							boolean isUpdateHVParams = (!vcSSLValue.equalsIgnoreCase(preVcSSL) || 
								!vcUserValue.equalsIgnoreCase(preVcname) ||
								!currPass.equalsIgnoreCase(preVcPass) ||
								!vcWebPort.equalsIgnoreCase(preVcWebPort));
							if (isRHEVThruDiscover)
							{
								isUpdateHVParams = (!vcSSLValue.equalsIgnoreCase(preVcSSL) || 
								!vcUserValue.equalsIgnoreCase(preVcname) ||
								!currPass.equalsIgnoreCase(preVcPass) ||
								!vcWebPort.equalsIgnoreCase(preVcWebPort) ||
								!domainValue.equalsIgnoreCase(preDomain));
							}

							if (isUpdateHVParams)
							{
								if (z != 0) // for not initiated component changes
								{
									if (!aListChoosenParametersInLowerCase.contains(unameStr.toLowerCase()))
									{
										vcUserValue = preVcname;
									}

									if (!aListChoosenParametersInLowerCase.contains(upassStr.toLowerCase()))
									{
										vcPasswordValue = preVcPass;
									}

									if (!aListChoosenParametersInLowerCase.contains(webportStr.toLowerCase()))
									{
										vcWebPort = preVcWebPort;
									}

									if (!aListChoosenParametersInLowerCase.contains(sslStr.toLowerCase()))
									{
										vcSSLValue = preVcSSL;
									}

									if (isRHEVThruDiscover)
									{
										if (!aListChoosenParametersInLowerCase.contains(domainStr))
										{
											domainValue = preDomain;
										}
									}
								}

								isReqParamsChanged = true;
								pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase();
								if (isRHEVThruDiscover)
								{
									pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~"+domainValue;
								}

								if (type.equals("nutanix"))
								{
									String preMgrtype = "false";
									if (isNtxCtrlCompType)
									{
										preMgrtype = "true";
									}
									if (totalCnt > 5)
									{
										preMgrtype = sst.nextToken();
									}

									pattern = isVcDiscovery+"~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~"+preMgrtype;
								}
								aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strVCAgentName, type +"#"+ strVCName,pattern));

								if (isNtxCtrlCompType)
								{
									String strNtxCtrlIP = discInfo.getComponentIP(componentType, tempComponentName);

									ArrayList ntxCtrlMappVars = getNtxCtrlMappingVariables(strVCAgentName,strNtxCtrlIP);
									if (ntxCtrlMappVars != null && !ntxCtrlMappVars.isEmpty())
									{
										String strNtxCtrlMappPattern = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#No#"+vcWebPort+"#false";

										for (int v=0;v<ntxCtrlMappVars.size();v++)
										{
											String varName = (String) ntxCtrlMappVars.get(v);
											
											if (!StringUtils.isNull(varName) && varName.startsWith("nutanix#"))
											{
												strNtxCtrlMappPattern = "no~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~false";
											}
											aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,strNtxCtrlIP, varName,strNtxCtrlMappPattern));
										}
									}
								}
							}
						}
						else
						{
							isReqParamsChanged = true;

							if (isNutClusterCompType)
							{
								Hashtable subAndVar = getNtxCtrlMappingSubject(strVCAgentName,strVCName,true);
								if (subAndVar != null && !subAndVar.isEmpty())
								{
									Set ntxObjSet = subAndVar.entrySet();
									Iterator itr = ntxObjSet.iterator();
									while (itr.hasNext())
									{
										Map.Entry ntxObj = (Map.Entry)itr.next();
										String ntxCtrlMappSub =  (String) ntxObj.getKey();

										ArrayList ntxCtrlMappVars = (ArrayList) ntxObj.getValue();
										if (ntxCtrlMappVars != null && !ntxCtrlMappVars.isEmpty())
										{
											String strNtxCtrlMappPattern = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#No#"+vcWebPort+"#false";

											for (int v=0;v<ntxCtrlMappVars.size();v++)
											{
												String varName = (String) ntxCtrlMappVars.get(v);
												if (!StringUtils.isNull(varName) && varName.startsWith("nutanix#"))
												{
													strNtxCtrlMappPattern = "no~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~false";
												}
												aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,ntxCtrlMappSub, varName,strNtxCtrlMappPattern));
											}
										}
									}
								}
								else
								{
									aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strVCAgentName, type +"#"+ strVCName,pattern));
								}

								if (isNtxCtrlHyperVisor && !isNtxCtrlCompType)
								{
									String ntxCtrlCompIP = getNtxCtrlMappingSubject(strVCAgentName, strVCName);
									if (!StringUtils.isNull(ntxCtrlCompIP) && ntxCtrlCompIP.indexOf("~|~") != -1)
									{
										ntxCtrlCompIP = ntxCtrlCompIP.substring(0, ntxCtrlCompIP.indexOf("~|~"));
									}
									String strExistNtxCtrlValues = agtlessDiscIni.getValue(strVCAgentName,"nutanix#" +ntxCtrlCompIP);

									if (!StringUtils.isNull(strExistNtxCtrlValues))
									{
										String ntxCtrlValues = "yes~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~true";
										aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strVCAgentName,"nutanix#" +ntxCtrlCompIP,ntxCtrlValues));
									}
								}
							}
							else
							{
								aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strVCAgentName, type +"#"+ strVCName,pattern));
							}
						}
					}
				}
				preVcSSL = "";
				preVcname = "";
				preVcPass = "";
				preVcWebPort = "";

				int vcIpIdx = 0;
				String vcIp = "";
				if (aListProcessedParamNamesAndValues.contains("-host"))
				{
					vcIpIdx = aListProcessedParamNamesAndValues.indexOf("-host");
					vcIp = (String)aListProcessedParamNamesAndValues.get(vcIpIdx+1);
				}
				if (eg_servicesIni == null)
				{
					eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
				}
				String virtualCenterPattern = eg_servicesIni.getValue(subVc,vcIp);
				if (!StringUtils.isNull(virtualCenterPattern))
				{
					isNtxCtrlHyperVisor = false;
				}
				String separ = "#";
				if(virtualCenterPattern == null || virtualCenterPattern.length() <=0)
				{
					IniFile f1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
					virtualCenterPattern = f1.getValue(strVCAgentName, type +"#" +vcIp);
					separ = "~#~";
				}
				
				StringTokenizer sst =  new StringTokenizer(virtualCenterPattern,separ);
				if (sst.hasMoreTokens())
				{
					preVcSSL = sst.nextToken();
					preVcname = sst.nextToken();
					preVcPass = sst.nextToken();
					if (separ.equals("~#~"))
					{
						preVcWebPort = sst.nextToken();
						isVcDiscovery = sst.nextToken();
					}
					else
					{
						isVcDiscovery = sst.nextToken();
						preVcWebPort = sst.nextToken();
					}
					
					if (isRHEVThruDiscover)
					{
						preDomain = sst.nextToken();
					}
				}

				if (!isNumber(preVcPass))
				{
					preVcPass = EgCrypt.decrypt(preVcPass);
				}
				if (preVcPass.indexOf("~EG~") != -1)
				{
					preVcPass = preVcPass.substring(0,preVcPass.indexOf("~EG~"));
				}

				if (separ.equals("~#~") && !StringUtils.isNull(preVcSSL))
				{
					String swapVar = preVcSSL;
					preVcSSL = isVcDiscovery;
					isVcDiscovery = swapVar;
				}

				if(hasReqParamsForVcModify)
				{
					String currVcPass = vcPasswordValue;
					if (!isNumber(currVcPass))
					{
						currVcPass = EgCrypt.decrypt(currVcPass);
					}
					if (currVcPass.indexOf("~EG~") != -1)
					{
						currVcPass = currVcPass.substring(0,currVcPass.indexOf("~EG~"));
					}

					boolean isAnyOneChanged = (!((vcSSLValue.equalsIgnoreCase(preVcSSL)) && (vcUserValue.equalsIgnoreCase(preVcname)) && (currVcPass.equalsIgnoreCase(preVcPass)) && (vcWebPort.equalsIgnoreCase(preVcWebPort))));
					if (isRHEVThruDiscover)
					{
						isAnyOneChanged = (!((vcSSLValue.equalsIgnoreCase(preVcSSL)) && (vcUserValue.equalsIgnoreCase(preVcname)) && (currVcPass.equalsIgnoreCase(preVcPass)) && (vcWebPort.equalsIgnoreCase(preVcWebPort)) && (domainValue.equalsIgnoreCase(preDomain))));
					}

					if (isAnyOneChanged)
					{
						if (z == 0)
						{
							ipAddress = vcIp;
						}
						agentIniFlag = true;
						if (type.equals("nutanix"))
						{
							configureAcroVdi = true;
						}
						else if (type.equals("rhev"))
						{
							configureRhevVdi = true;
						}
						else 
						{
							configureEsxVdi = true;
						}
						if (z != 0)
						{
							if (!aListChoosenParametersInLowerCase.contains(unameStr.toLowerCase()))
							{
								vcUserValue = preVcname;
							}

							if (!aListChoosenParametersInLowerCase.contains(upassStr.toLowerCase()))
							{
								vcPasswordValue = preVcPass;
							}

							if (!aListChoosenParametersInLowerCase.contains(webportStr.toLowerCase()))
							{
								vcWebPort = preVcWebPort;
							}

							if (!aListChoosenParametersInLowerCase.contains(sslStr.toLowerCase()))
							{
								vcSSLValue = preVcSSL;
							}

							if (isRHEVThruDiscover)
							{
								if (!aListChoosenParametersInLowerCase.contains(domainStr))
								{
									domainValue = preDomain;
								}
							}
						}
					}
					subVal = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#"+isVcDiscovery+"#"+vcWebPort;
					if (isRHEVThruDiscover)
					{
						subVal = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#"+isVcDiscovery+"#"+vcWebPort+"#"+domainValue;
					}

					if (type.equals("nutanix"))
					{
						subVal = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#"+isVcDiscovery+"#"+vcWebPort+"#false";
						if (isNtxCtrlCompType)
						{
							subVal = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#"+isVcDiscovery+"#"+vcWebPort+"#true";
						}
					}

					if (hasVCinServicesIni)
					{
						isReqParamsChanged = true;
						aListServicesIniEntries.add(new IniHelper(IniHelper.SET,subVc,vcIp,subVal));
					}

					if (isNutClusterCompType)
					{
						if (isNtxCtrlCompType)
						{
							String strNtxCtrlIP = discInfo.getComponentIP(componentType, tempComponentName);
							ArrayList ntxCtrlMappVars = getNtxCtrlMappingVariables(strVCAgentName,strNtxCtrlIP);
							if (ntxCtrlMappVars != null && !ntxCtrlMappVars.isEmpty())
							{
								for (int v=0;v<ntxCtrlMappVars.size();v++)
								{
									String strNtxCtrlMappPattern = subVal;
									String varName = (String) ntxCtrlMappVars.get(v);
									if (!StringUtils.isNull(varName) && varName.startsWith("nutanix#"))
									{
										strNtxCtrlMappPattern = "no~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~false";
									}
									aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,strNtxCtrlIP, varName,strNtxCtrlMappPattern));
								}
							}
						}
						else
						{
							Hashtable subAndVar = getNtxCtrlMappingSubject(strVCAgentName,vcIp, false);

							if (subAndVar != null && !subAndVar.isEmpty())
							{
								Set ntxObjSet = subAndVar.entrySet();
								Iterator itr = ntxObjSet.iterator();
								while (itr.hasNext())
								{
									Map.Entry ntxObj = (Map.Entry)itr.next();
									String ntxCtrlMappSub =  (String) ntxObj.getKey();

									ArrayList ntxCtrlMappVars = (ArrayList) ntxObj.getValue();
									if (ntxCtrlMappVars != null && !ntxCtrlMappVars.isEmpty())
									{
										String strNtxCtrlMappPattern = vcSSLValue.toLowerCase()+"#"+vcUserValue+"#"+vcPasswordValue+"#No#"+vcWebPort+"#false";

										for (int v=0;v<ntxCtrlMappVars.size();v++)
										{
											String varName = (String) ntxCtrlMappVars.get(v);
											if (!StringUtils.isNull(varName) && varName.startsWith("nutanix#"))
											{
												strNtxCtrlMappPattern = "no~#~"+vcUserValue+"~#~"+vcPasswordValue+"~#~"+vcWebPort+"~#~"+vcSSLValue.toLowerCase()+"~#~false";
											}
											aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,ntxCtrlMappSub, varName,strNtxCtrlMappPattern));
										}
									}
								}
							}

							if (isNtxCtrlHyperVisor)
							{
								String ntxCtrlCompIP = getNtxCtrlMappingSubject(strVCAgentName, vcIp);
								if (!StringUtils.isNull(ntxCtrlCompIP) && ntxCtrlCompIP.indexOf("~|~") != -1)
								{
									ntxCtrlCompIP = ntxCtrlCompIP.substring(0, ntxCtrlCompIP.indexOf("~|~"));
								}
								String strExistNtxCtrlValues = eg_servicesIni.getValue("NUTANIX",ntxCtrlCompIP);

								if (!StringUtils.isNull(strExistNtxCtrlValues))
								{
									String ntxCtrlValues = vcSSLValue + "#" + vcUserValue + "#" + vcPasswordValue + "#Yes#" + vcWebPort + "#true";
									aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",ntxCtrlCompIP,ntxCtrlValues));
								}
							}
						}
					}
				}
			}
			// discovering the virtual center components code starts here...

			boolean isTestAtIntialConfiguration = false;
			List aListTempAgents = null;
			boolean isThisTestExternal = egSpecs.isExternalTest(strTestName,componentType);
			if (isThisTestExternal)
			{
				aListTempAgents = aListAgents.subList(1,aListAgents.size());
			}
			else
			{
				aListTempAgents = aListAgents.subList(0,1);
			}

			String specificPattern_A = strTestName + ":" + componentType + ":" + tempComponentName;
			String specificPattern_B = strTestName + ":" + componentType + ":" + tempComponentNickName;
			String defaultPattern_A = strTestName + "::" + tempComponentName;
			String defaultPattern_B = strTestName + "::" + tempComponentNickName;

			//Applicable to external test only - starts
			//Scenario :A generic comptype say gen1 has one internal or remote agent
			//and 3 external agents. We already know that an external test say network
			//test will have same set of test-parameters for all the external agents
			//For e.g., [agent148] or [agent66] or [192.168.10.50]
			//NetworkTest::gen148=-manual, -host 192.168.10.148 -packetSize 32
			//-packetCount 5 -timeout 10 -packetInterval 100 -targets victory -rptName gen148, 300
			//Hence, a single set of parameters are enough to be built for updation to all
			//the external agent sections
			boolean isParameterSetAvailable = false;
			String tempTestValue = null;
			String tempResultantPattern = null;
			//Applicable to external test only - ends
			for (int i=0; i<aListTempAgents.size(); i++)
			{
				String tempAgentNickName = (String)aListTempAgents.get(i);
				StringBuffer strBuffer = null;
				String resultantPattern = "";
				if (!isParameterSetAvailable)
				{
					String agentIniVariables[] = agentIni.getVariables(tempAgentNickName);
					List listAgentIniVariables = Arrays.asList(agentIniVariables);
					if (listAgentIniVariables.contains(specificPattern_A))
					{
						resultantPattern = specificPattern_A;
					}
					else if (listAgentIniVariables.contains(specificPattern_B))
					{
						resultantPattern = specificPattern_B;
					}
					else if (listAgentIniVariables.contains(defaultPattern_A))
					{
						resultantPattern = defaultPattern_A;
					}
					else if (listAgentIniVariables.contains(defaultPattern_B))
					{
						resultantPattern = defaultPattern_B;
					}

					if (resultantPattern.equalsIgnoreCase("")) continue;

					boolean isUserInitiatedTest = strTestName.equals(testName);
					String oldIniValue = agentIni.getValue(tempAgentNickName,resultantPattern);
					String testConfigurationStatus = oldIniValue.substring(0,oldIniValue.indexOf(","));
					if (testConfigurationStatus.equals("-auto"))
					{
						isTestAtIntialConfiguration = true;
					}
					String oldValue = oldIniValue.substring(oldIniValue.indexOf(",")+1,oldIniValue.lastIndexOf(","));
					if (isOldSnmp)
					{
						ArrayList aListOldParams = getParameterList(oldValue,true);
						if (!aListOldParams.contains("-snmpversion"))
						{
							int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
							aListOldParams = getParameterList(oldValue,false);
							aListOldParams.add(snmpComIdx+2,"-snmpversion");
							aListOldParams.add(snmpComIdx+3,"v1");

							oldValue = aListOldParams.toString();
							oldValue = oldValue.substring(1,oldValue.length()-1);
							oldValue = StringUtils.replace(oldValue,",","");
						}
					}

					String testParam = null;
					if (isUserInitiatedTest)
					{
						testParam = strValue;
						if (k == 0)
						{
							boolean configureVc = false;
							boolean configureHmc = false;
							boolean configureRhev = false;
							boolean configureNutanix = false;
							boolean configureXMSIP = false;
							if (z == 0)
							{
								//for VC
								if (aListProcessedParamNamesAndValues.contains("-virtual_center"))
								{
									configureVc = true;
									configureEsxVdi = true;
								}

								//for Nutanix
								if (aListProcessedParamNamesAndValues.contains("-Prism_IP"))
								{
									configureNutanix = true;
									configureAcroVdi = true;
								}

								//for HMC
								if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									configureHmc = true;
								}
								// for RHEV
								if (aListProcessedParamNamesAndValues.contains("-Rhel_mgr_host"))
								{
									configureRhevVdi = true;
									configureRhev = true;
								}
								else if (aListProcessedParamNamesAndValues.contains("-management_server") && 
									aListProcessedParamNamesAndValues.contains("-management_user"))
								{
									if (aListProcessedParamNamesAndValues.indexOf("-is_managed_by") > -1)
									{
										int tempIdx = aListProcessedParamNamesAndValues.indexOf("-is_managed_by");
										String tempValue = (String)aListProcessedParamNamesAndValues.get(tempIdx+1);
										tempValue = tempValue.trim();
										if (tempValue != null && tempValue.equalsIgnoreCase("hmc"))
										{
											configureHMCComp = true;
											configureHmc = true;
										}
									}
								}

								//for xmsIP
								if (aListProcessedParamNamesAndValues.contains("-xms_ip"))
								{
									configureXMSIP = true;
								}

							}
							else
							{
								//for VC
								if (aListChoosenParametersInLowerCase.contains("-virtual_center") && 
									aListProcessedParamNamesAndValues.contains("-virtual_center"))
								{
									configureVc = true;
								}

								//for Nutanix
								if (aListChoosenParametersInLowerCase.contains("-prism_ip") && 
									aListProcessedParamNamesAndValues.contains("-Prism_IP"))
								{
									configureNutanix = true;
								}

								//for HMC
								if (aListChoosenParametersInLowerCase.contains("-hmc_server") && 
									aListChoosenParametersInLowerCase.contains("-hmc_user") && 
									aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									configureHmc = true;
								}
								else if (aListChoosenParametersInLowerCase.contains("-management_server") && 
										aListChoosenParametersInLowerCase.contains("-management_user") && 
										aListProcessedParamNamesAndValues.contains("-management_server") && 
										aListProcessedParamNamesAndValues.contains("-management_user"))
								{
									if (aListProcessedParamNamesAndValues.indexOf("-is_managed_by") > -1)
									{
										int tempIdx = aListProcessedParamNamesAndValues.indexOf("-is_managed_by");
										String tempValue = (String)aListProcessedParamNamesAndValues.get(tempIdx+1);
										tempValue = tempValue.trim();
										if (tempValue != null && tempValue.equalsIgnoreCase("hmc"))
										{
											configureHMCComp = true;
											configureHmc = true;
										}
									}
								}
								//for RHEV
								if (aListChoosenParametersInLowerCase.contains("-rhel_mgr_host") && 
									aListProcessedParamNamesAndValues.contains("-Rhel_mgr_host"))
								{
									configureRhev = true;
								} 

								//for XMS IP
								if (aListChoosenParametersInLowerCase.contains("-xms_ip") && 
									aListProcessedParamNamesAndValues.contains("-xms_ip"))
								{
									configureXMSIP = true;
								}
							}

							if (configureHmc)
							{
								if (eg_hmcMapping == null)
								{
									eg_hmcMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_hmcmapping.ini");
								}

								int hostIdx = aListProcessedParamNamesAndValues.indexOf("-host");
								String hostValue = (String)aListProcessedParamNamesAndValues.get(hostIdx+1);
								String hmcServerValue = "";
								int hmcServerIdx = 0;
								if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									hmcServerIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_server");
								}
								else
								{
									hmcServerIdx = aListProcessedParamNamesAndValues.indexOf("-management_server");
								}
								hmcServerValue = (String)aListProcessedParamNamesAndValues.get(hmcServerIdx+1);

								if (z == 0)
								{
									if (eg_servicesIni == null)
									{
										eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
									}

									int hmcUserIdx = 0;
									int hmcPasswordIdx = 0;

									if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
										aListProcessedParamNamesAndValues.contains("-hmc_user"))
									{
										hmcUserIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_user");
										hmcPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_password");
									}
									else
									{
										hmcUserIdx = aListProcessedParamNamesAndValues.indexOf("-management_user");
										hmcPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-management_password");
									}

									String hmcUserValue = (String)aListProcessedParamNamesAndValues.get(hmcUserIdx+1);

									String hmcPasswordValue = (String)aListProcessedParamNamesAndValues.get(hmcPasswordIdx+1);
									//hmcPasswordValue = EgCrypt.decrypt(hmcPasswordValue);
									String strTokenSalt = hmcPasswordValue;
									if (!isNumber(strTokenSalt))
									{
										strTokenSalt = EgCrypt.decrypt(strTokenSalt);
									}
									if (strTokenSalt.indexOf("~EG~") != -1)
									{
										hmcPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
									}
									else
									{
										hmcPasswordValue = strTokenSalt;
									}
									hmcPasswordValue = EgCrypt.encrypt(hmcPasswordValue);

									int sslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
									String sslValue = (String)aListProcessedParamNamesAndValues.get(sslIdx+1);

									String hmcPattern = null;
									if (hmcServerValue == null)
									{
										hmcPattern = eg_servicesIni.getValue("HMC",hostValue);
									}
									else
									{
										hmcPattern = eg_servicesIni.getValue("HMC",hmcServerValue);
									}

									String isDiscovery = "No";
									String hostName = hmcServerValue;
									if (hmcPattern != null)
									{
										StringTokenizer sst = new StringTokenizer(hmcPattern,"#");
										if(sst.hasMoreTokens())
										{
											String s = sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
											hostName = sst.nextToken();
										}
									}
									String pattern = sslValue + "#" + hmcUserValue + "#" + hmcPasswordValue + "#" + isDiscovery + "#" + hostName;

									if (aListServicesIniEntries == null)
									{
										aListServicesIniEntries = new ArrayList();
									}

									if (aListUpdateHyperVisorServers == null)
									{
										aListUpdateHyperVisorServers = new HashSet();
									}
									if (hmcServerValue == null)
									{
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hostValue,pattern));

									}
									//else
									//{
										//aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hmcServerValue,pattern));
									//}


									if (aListAgtlessDiscIniEntries == null)
									{
										aListAgtlessDiscIniEntries = new ArrayList();
									}

									String agentForSubject = "";
									boolean isAgentLessComponent = agentInfo.isAgentlessServer(tempComponentNickName,componentType);
									egAgtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
									String strExistHmc = "";

									IniFile egServIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
									strExistHmc = egServIni.getValue("HMC",hmcServerValue);
									if (!StringUtils.isNull(strExistHmc))
									{
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hmcServerValue,pattern));
										String strMethodArgs = hmcServerValue+"~|~"+sslValue + "~|~" + hmcUserValue + "~|~" + hmcPasswordValue + "~|~" + isDiscovery + "~|~" + hostName;
										aListUpdateHyperVisorServers.add(strMethodArgs);
									}

									if (isAgentLessComponent)
									{
										if (!StringUtils.isNull(strAgentlessSubject))
										{
											strExistHmc = egAgtlessDiscIni.getValue(strAgentlessSubject,"hmc#" +hmcServerValue);
											if (!StringUtils.isNull(strExistHmc))
											{
												String agtlessSubVal = isDiscovery.toLowerCase()+"~#~"+hmcUserValue+"~#~"+hmcPasswordValue+"~#~"+sslValue.toLowerCase()+"~#~"+hostName;

												aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strAgentlessSubject,"hmc#" +hmcServerValue,agtlessSubVal));

												String strMethodArgs = hmcServerValue+"~|~"+sslValue + "~|~" + hmcUserValue + "~|~" + hmcPasswordValue + "~|~" + isDiscovery + "~|~" + hostName;
												aListUpdateHyperVisorServers.add(strMethodArgs);
											}
										}
									}
								}

								String Var = componentType + ":" + tempComponentName;
								String Val = componentType + "," + tempComponentNickName + "," + hostValue + ",NULL";
								if (aListHmcMappingIniEntries == null)
								{
									aListHmcMappingIniEntries = new ArrayList();
								}
								aListHmcMappingIniEntries.add(new IniHelper(IniHelper.SET,hmcServerValue,Var,Val));
							}

							// for discovery changes - starts
							if (configureVc)
							{
								int vcidx = aListProcessedParamNamesAndValues.indexOf("-virtual_center");
								String virtual_centerValue = (String)aListProcessedParamNamesAndValues.get(vcidx+1);

								if (!virtual_centerValue.equalsIgnoreCase("other") && !virtual_centerValue.equalsIgnoreCase("none"))
								{
									if (z == 0)
									{
										ipAddress = virtual_centerValue; // for update eg_specs.ini
									}

									if (eg_vcmappingIni == null)
									{
										eg_vcmappingIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_vcmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);

									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int esxUserIdx = aListProcessedParamNamesAndValues.indexOf("-Esx_user");
										String strEsxUserValue = (String)aListProcessedParamNamesAndValues.get(esxUserIdx+1);
										String curUname = strEsxUserValue;
										String actualEsxUname = strEsxUserValue;

										int esxPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Esx_password");
										String strEsxPasswordValue = (String)aListProcessedParamNamesAndValues.get(esxPasswordIdx+1);
										//strEsxPasswordValue = EgCrypt.decrypt(strEsxPasswordValue);
										String strTokenSalt = strEsxPasswordValue;
										if (!isNumber(strTokenSalt))
										{
											strTokenSalt = EgCrypt.decrypt(strTokenSalt);
										}
										if (strTokenSalt.indexOf("~EG~") != -1)
										{
											strEsxPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
										}
										else
										{
											strEsxPasswordValue = strTokenSalt;
										}

										String curPwd = strEsxPasswordValue;
										strEsxPasswordValue = EgCrypt.encrypt(strEsxPasswordValue);

										int esxSslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(esxSslIdx+1);
										String checkSSL = strSslValue;

										int webPortIdx = aListProcessedParamNamesAndValues.indexOf("-webPort");
										String webPort = (String)aListProcessedParamNamesAndValues.get(webPortIdx+1);
										String curWebPort = webPort;

										String preSSL = "";
										String preUname = "";
										String preUPass = "";
										String preWebPort = "";

										String isDiscovery = "No";
										//String hosted_vm_type="ServerVMs";
										String virtualCenterPattern = eg_servicesIni.getValue("VIRTUAL_CENTER",virtual_centerValue);
										StringTokenizer sst = new StringTokenizer(virtualCenterPattern,"#");
										if (sst.hasMoreTokens())
										{
											preSSL = sst.nextToken();
											preUname = sst.nextToken();
											preUPass = sst.nextToken();
											isDiscovery = sst.nextToken();

											preWebPort = sst.nextToken();
											//preUPass = EgCrypt.decrypt(preUPass);
											if (!isNumber(preUPass))
											{
												preUPass = EgCrypt.decrypt(preUPass);
											}
											if (preUPass.indexOf("~EG~") != -1)
											{
												preUPass = preUPass.substring(0,preUPass.indexOf("~EG~"));
											}

											/*sst.nextToken();
											if(sst.hasMoreTokens())
											{
												hosted_vm_type = sst.nextToken();
											}*/
										}

										if (strSslValue != null)
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												if (webPort != null)
												{
													if (webPort.equalsIgnoreCase("default"))
													{
														webPort = "443";
													}
												}
												else
												{
													webPort = "443";
												}
											}
											else
											{
												if (webPort != null)
												{
													if (webPort.equalsIgnoreCase("default"))
													{
														webPort = "80";
													}
												}
												else
												{
													webPort = "80";
												}
											}
										}

										boolean isAnyOneChanged = (!((checkSSL.equals(preSSL)) && (curUname.equals(preUname)) && (curPwd.equals(preUPass)) && (curWebPort.equals(preWebPort))));
										if (isAnyOneChanged)
										{
											agentIniFlag = true;
										}

										String pattern = strSslValue + "#" + strEsxUserValue + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
										subVal = pattern ; // for update eg_specs.ini
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										if (aListUpdateHyperVisorServers == null)
										{
											aListUpdateHyperVisorServers = new HashSet();
										}

										if (aListAgtlessDiscIniEntries == null)
										{
											aListAgtlessDiscIniEntries = new ArrayList();
										}

										String agentForSubject = "";
										boolean isAgentLessComponent = agentInfo.isAgentlessServer(tempComponentNickName,componentType);
										egAgtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
										String strExistVCenter = "";

										IniFile egServIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										strExistVCenter = egServIni.getValue("VIRTUAL_CENTER",virtual_centerValue);

										if (!StringUtils.isNull(strExistVCenter))
										{
											if (strEsxUserValue.indexOf("#") != -1)
											{
												actualEsxUname =StringUtils.replace(actualEsxUname,"#", "~eGHash~");
												pattern = strSslValue + "#" + actualEsxUname + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
											}

											aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER",virtual_centerValue,pattern));
											if (isVCServerConfigured)
											{
												String strMethodArgs = virtual_centerValue+"~|~"+strSslValue + "~|~" + actualEsxUname + "~|~" + strEsxPasswordValue + "~|~" + isDiscovery + "~|~" + webPort;
												aListUpdateHyperVisorServers.add(strMethodArgs);
											}
										}

										if (isAgentLessComponent)
										{
											if (!StringUtils.isNull(strAgentlessSubject))
											{
												strExistVCenter = egAgtlessDiscIni.getValue(strAgentlessSubject,"vcenter#" +virtual_centerValue);
												if (!StringUtils.isNull(strExistVCenter))
												{
													StringTokenizer stVc = new StringTokenizer(strExistVCenter,"~#~");
													if (stVc.hasMoreTokens())
													{
														isDiscovery = stVc.nextToken();
														preUname = stVc.nextToken();
														preUPass = stVc.nextToken();
														preWebPort = stVc.nextToken();
														preSSL = stVc.nextToken();
														
														preUPass = EgCrypt.decrypt(preUPass);
														String strPreTokenSalt = preUPass;
														if (strPreTokenSalt.indexOf("~EG~") != -1)
														{
															preUPass = strPreTokenSalt.substring(0,strPreTokenSalt.indexOf("~EG~"));
														}
													}

													if (!isAnyOneChanged)
													{
														isAnyOneChanged = (!((checkSSL.equals(preSSL)) && (curUname.equals(preUname)) && (curPwd.equals(preUPass)) && (curWebPort.equals(preWebPort))));
														if (isAnyOneChanged)
														{
															agentIniFlag = true;
														}
													}
													String agtlessSubVal = isDiscovery.toLowerCase()+"~#~"+strEsxUserValue+"~#~"+strEsxPasswordValue+"~#~"+webPort+"~#~"+strSslValue.toLowerCase();

													aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strAgentlessSubject,"vcenter#" +virtual_centerValue,agtlessSubVal));
													if (isVCServerConfigured)
													{
														String strMethodArgs = virtual_centerValue+"~|~"+strSslValue + "~|~" + strEsxUserValue + "~|~" + strEsxPasswordValue + "~|~" + isDiscovery + "~|~" + webPort;
														aListUpdateHyperVisorServers.add(strMethodArgs);
													}
												}
											}
										}
									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + strHostValue + "," + tempComponentNickName + ",NULL";

									if (aListVcMappingIniEntries == null)
									{
										aListVcMappingIniEntries = new ArrayList();
									}
									aListVcMappingIniEntries.add(new IniHelper(IniHelper.SET,virtual_centerValue,Var,Val));
								}
							}

							// for nutanix changes - starts
							if (configureNutanix)
							{
								int cvmipidx = aListProcessedParamNamesAndValues.indexOf("-Prism_IP");
								String cvm_ipValue = (String)aListProcessedParamNamesAndValues.get(cvmipidx+1);

								if (!cvm_ipValue.equalsIgnoreCase("other") && !cvm_ipValue.equalsIgnoreCase("none"))
								{
									if (z == 0)
									{
										ipAddress = cvm_ipValue; // for update eg_specs.ini
									}
									
									if (eg_nutanixMapping == null)
									{
										eg_nutanixMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_nutanixmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);

									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int cvmUserIdx = aListProcessedParamNamesAndValues.indexOf("-Prism_user");
										String strCVMUserValue = (String)aListProcessedParamNamesAndValues.get(cvmUserIdx+1);
										String curUname = strCVMUserValue;

										int cmvPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Prism_password");
										String strCVMPasswordValue = (String)aListProcessedParamNamesAndValues.get(cmvPasswordIdx+1);
										//strCVMPasswordValue = EgCrypt.decrypt(strCVMPasswordValue);
										String strTokenSalt = strCVMPasswordValue; //salt for pwd
										if (!isNumber(strTokenSalt))
										{
											strTokenSalt = EgCrypt.decrypt(strTokenSalt);
										}

										if (strTokenSalt.indexOf("~EG~") != -1)
										{
											strCVMPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
										}
										else
										{
											strCVMPasswordValue = strTokenSalt;
										}

										String curPwd = strCVMPasswordValue;
										strCVMPasswordValue = EgCrypt.encrypt(strCVMPasswordValue);

										int cvmSslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(cvmSslIdx+1);
										String checkSSL = strSslValue;

										int webPortIdx = aListProcessedParamNamesAndValues.indexOf("-webPort");
										String webPort = (String)aListProcessedParamNamesAndValues.get(webPortIdx+1);
										String curWebPort = webPort;

										String preSSL = "";
										String preUname = "";
										String preUPass = "";
										String preWebPort = "";

										String isDiscovery = "No";
										String nutanixPattern = eg_servicesIni.getValue("NUTANIX",cvm_ipValue);
										StringTokenizer sst = new StringTokenizer(nutanixPattern,"#");
										if (sst.hasMoreTokens())
										{
											preSSL = sst.nextToken();
											preUname = sst.nextToken();
											preUPass = sst.nextToken();
											isDiscovery = sst.nextToken();

											preWebPort = sst.nextToken();
											//preUPass = EgCrypt.decrypt(preUPass);
											if (!isNumber(preUPass))
											{
												preUPass = EgCrypt.decrypt(preUPass);
											}
											if (preUPass.indexOf("~EG~") != -1)
											{
												preUPass = preUPass.substring(0,preUPass.indexOf("~EG~"));
											}
										}

										boolean isAnyOneChanged = (!((checkSSL.equals(preSSL)) && (curUname.equals(preUname)) && (curPwd.equals(preUPass)) && (curWebPort.equals(preWebPort))));
										if (isAnyOneChanged)
										{
											agentIniFlag = true;
										}

										String pattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#" + isDiscovery + "#" + webPort + "#false";
										subVal = pattern; // for update eg_specs.ini
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										//aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",cvm_ipValue,pattern));
										if (aListUpdateHyperVisorServers == null)
										{
											aListUpdateHyperVisorServers = new HashSet();
										}
										if (aListAgtlessDiscIniEntries == null)
										{
											aListAgtlessDiscIniEntries = new ArrayList();
										}

										if (aListNtxCenterMappIniEntries == null)
										{
											aListNtxCenterMappIniEntries = new ArrayList();
										}

										String agentForSubject = "";
										boolean isAgentLessComponent = agentInfo.isAgentlessServer(tempComponentNickName,componentType);
										egAgtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
										String strExistNutanix = "";
										boolean isNutanixCtrlHVs = true;
										IniFile egServIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										strExistNutanix = egServIni.getValue("NUTANIX",cvm_ipValue);

										if (!StringUtils.isNull(strExistNutanix))
										{
											isNutanixCtrlHVs = false;
											aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",cvm_ipValue,pattern));
											String strMethodArgs = cvm_ipValue+"~|~"+strSslValue + "~|~" + strCVMUserValue + "~|~" + strCVMPasswordValue + "~|~" + isDiscovery + "~|~" + webPort;

											aListUpdateHyperVisorServers.add(strMethodArgs);
										}
										else
										{
											if (ntxMappIniPrismDetails != null && ntxMappIniPrismDetails.containsKey(cvm_ipValue))
											{
												ArrayList subAndVarList = (ArrayList) ntxMappIniPrismDetails.get(cvm_ipValue);
												if (subAndVarList != null && !subAndVarList.isEmpty()) 
												{
													for (int s=0;s<subAndVarList.size();s++)
													{
														String subAndVar = (String) subAndVarList.get(s);
														String strNtxCtrlMappPattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#No#" + webPort + "#false";
														String ntxCtrlMappSub = subAndVar.substring(0,subAndVar.indexOf("~|~"));
														String ntxCtrlMappVar = subAndVar.substring(subAndVar.indexOf("~|~")+3);
														if (ntxCtrlMappVar.startsWith("nutanix#"))
														{
															strNtxCtrlMappPattern = "no~#~"+strCVMUserValue+"~#~"+strCVMPasswordValue+"~#~"+webPort+"~#~"+strSslValue.toLowerCase()+"~#~false";
														}
														aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,ntxCtrlMappSub,ntxCtrlMappVar,strNtxCtrlMappPattern));
													}
													String strMethodArgs = cvm_ipValue+"~|~"+strSslValue + "~|~" + strCVMUserValue + "~|~" + strCVMPasswordValue + "~|~" + isDiscovery + "~|~" + webPort;
													aListUpdateHyperVisorServers.add(strMethodArgs);
												}
											}
										}

										if (isAgentLessComponent)
										{
											String agtlessSubVal = isDiscovery.toLowerCase()+"~#~"+strCVMUserValue+"~#~"+strCVMPasswordValue+"~#~"+webPort+"~#~"+strSslValue.toLowerCase()+"~#~false";
											String strMethodArgs = cvm_ipValue+"~|~"+strSslValue + "~|~" + strCVMUserValue + "~|~" + strCVMPasswordValue + "~|~" + isDiscovery + "~|~" + webPort;

											if (!StringUtils.isNull(strAgentlessSubject))
											{
												strExistNutanix = egAgtlessDiscIni.getValue(strAgentlessSubject,"nutanix#" +cvm_ipValue);

												if (!StringUtils.isNull(strExistNutanix))
												{
													isNutanixCtrlHVs = false;
													aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strAgentlessSubject,"nutanix#" +cvm_ipValue,agtlessSubVal));

													aListUpdateHyperVisorServers.add(strMethodArgs);
												}
											}
											else
											{

												if (ntxMappIniPrismDetails != null && ntxMappIniPrismDetails.containsKey(cvm_ipValue))
												{
													ArrayList subAndVarList = (ArrayList) ntxMappIniPrismDetails.get(cvm_ipValue);
													for (int s=0;s<subAndVarList.size();s++)
													{
														String subAndVar = (String) subAndVarList.get(s);
														if (!StringUtils.isNull(subAndVar)) 
														{
															String strNtxCtrlMappPattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#No#" + webPort + "#false";
															String ntxCtrlMappSub = subAndVar.substring(0,subAndVar.indexOf("~|~"));
															String ntxCtrlMappVar = subAndVar.substring(subAndVar.indexOf("~|~")+3);
															if (ntxCtrlMappVar.startsWith("nutanix#"))
															{
																strNtxCtrlMappPattern = "no~#~"+strCVMUserValue+"~#~"+strCVMPasswordValue+"~#~"+webPort+"~#~"+strSslValue.toLowerCase()+"~#~false";
															}

															aListNtxCenterMappIniEntries.add(new IniHelper(IniHelper.SET,ntxCtrlMappSub, ntxCtrlMappVar, strNtxCtrlMappPattern));
														}
													}
													aListUpdateHyperVisorServers.add(strMethodArgs);
												}
											}
										}
										if (isNutanixCtrlHVs) // update nutanix central hypervisor thru acropolis component configuration...
										{
											String ntxCtrlCompIP = getNtxCtrlMappingSubject(strAgentlessSubject, cvm_ipValue);
											if (!StringUtils.isNull(ntxCtrlCompIP) && ntxCtrlCompIP.indexOf("~|~") != -1)
											{
												ntxCtrlCompIP = ntxCtrlCompIP.substring(0, ntxCtrlCompIP.indexOf("~|~"));
											}
											String strExistNtxCtrlValues = egAgtlessDiscIni.getValue(strAgentlessSubject,"nutanix#" +ntxCtrlCompIP);

											if (!StringUtils.isNull(strExistNtxCtrlValues))
											{
												String ntxCtrlValues = "yes~#~"+strCVMUserValue+"~#~"+strCVMPasswordValue+"~#~"+webPort+"~#~"+strSslValue.toLowerCase()+"~#~true";
												aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strAgentlessSubject,"nutanix#" +ntxCtrlCompIP,ntxCtrlValues));
											}

											strExistNtxCtrlValues = egServIni.getValue("NUTANIX",ntxCtrlCompIP);
											if (!StringUtils.isNull(strExistNtxCtrlValues))
											{
												String ntxCtrlValues = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#Yes#" + webPort + "#true";
												aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",ntxCtrlCompIP,ntxCtrlValues));
											}
										}
									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + tempComponentNickName + "," + strHostValue + ",NULL";

									if (aListNutMappingIniEntries == null)
									{
										aListNutMappingIniEntries = new ArrayList();
									}
									aListNutMappingIniEntries.add(new IniHelper(IniHelper.SET,cvm_ipValue,Var,Val));
								}
							}
							// for nutanix changes - ends

							// for RHEV //////////////////////
							if (configureRhev)
							{
								int rhevIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_host");
								String rhev_mgrValue = (String)aListProcessedParamNamesAndValues.get(rhevIdx+1);
								if (!rhev_mgrValue.equalsIgnoreCase("other") && !rhev_mgrValue.equalsIgnoreCase("none"))
								{
									if (eg_rhevMapping == null)
									{
										eg_rhevMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_rhevmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);
									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int rhevUserIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_user");
										String strRhevUserValue = (String)aListProcessedParamNamesAndValues.get(rhevUserIdx+1);

										int rhevPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_password");
										String strRhevPasswordValue = (String)aListProcessedParamNamesAndValues.get(rhevPasswordIdx+1);
										//strRhevPasswordValue = EgCrypt.decrypt(strRhevPasswordValue);
										String strTokenSalt = strRhevPasswordValue; //salt for pwd
										if (!isNumber(strTokenSalt))
										{
											strTokenSalt = EgCrypt.decrypt(strTokenSalt);
										}
										if (strTokenSalt.indexOf("~EG~") != -1)
										{
											strRhevPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
										}
										else
										{
											strRhevPasswordValue = strTokenSalt;
										}
										strRhevPasswordValue = EgCrypt.encrypt(strRhevPasswordValue);

										int rhevSSLIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(rhevSSLIdx+1);

										int mgrPortIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_port");
										String mgrPort = (String)aListProcessedParamNamesAndValues.get(mgrPortIdx+1);

										int domainIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_domain");
										String domain = (String)aListProcessedParamNamesAndValues.get(domainIdx+1);

										String isDiscovery = "No";
										String rhevMgrPattern = eg_servicesIni.getValue("RHEV",rhev_mgrValue);
										StringTokenizer sst = new StringTokenizer(rhevMgrPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
										}

										if (strSslValue != null)
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												if (mgrPort != null)
												{
													if (mgrPort.equalsIgnoreCase("default"))
													{
														mgrPort = "8443";
													}
												}
												else
												{
													mgrPort = "8443";
												}
											}
											else
											{
												if (mgrPort != null)
												{
													if (mgrPort.equalsIgnoreCase("default"))
													{
														mgrPort = "8080";
													}
												}
												else
												{
													mgrPort = "8080";
												}
											}
										}
										String pattern = strSslValue + "#" + strRhevUserValue + "#" + strRhevPasswordValue + "#" + isDiscovery + "#" + mgrPort +"#"+ domain; 
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										//aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"RHEV",rhev_mgrValue,pattern));
										if (aListUpdateHyperVisorServers == null)
										{
											aListUpdateHyperVisorServers = new HashSet();
										}
										if (aListAgtlessDiscIniEntries == null)
										{
											aListAgtlessDiscIniEntries = new ArrayList();
										}

										String agentForSubject = "";
										boolean isAgentLessComponent = agentInfo.isAgentlessServer(tempComponentNickName,componentType);
										egAgtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
										String strExistRhev = "";

										IniFile egServIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										strExistRhev = egServIni.getValue("RHEV",rhev_mgrValue);

										if (!StringUtils.isNull(strExistRhev))
										{
											aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"RHEV",rhev_mgrValue,pattern));

											String strMethodArgs = rhev_mgrValue+"~|~"+strSslValue + "~|~" + strRhevUserValue + "~|~" + strRhevPasswordValue + "~|~" + isDiscovery + "~|~" + mgrPort + "~|~" + domain;
											aListUpdateHyperVisorServers.add(strMethodArgs);
										}

										if (isAgentLessComponent)
										{
											if (!StringUtils.isNull(strAgentlessSubject))
											{
												strExistRhev = egAgtlessDiscIni.getValue(strAgentlessSubject,"rhev#" +rhev_mgrValue);

												if (!StringUtils.isNull(strExistRhev))
												{
													String agtlessSubVal = isDiscovery.toLowerCase()+"~#~"+strRhevUserValue+"~#~"+strRhevPasswordValue+"~#~"+mgrPort+"~#~"+strSslValue.toLowerCase()+"~#~"+domain;

													aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,strAgentlessSubject,"rhev#" +rhev_mgrValue,agtlessSubVal));

													String strMethodArgs = rhev_mgrValue+"~|~"+strSslValue + "~|~" + strRhevUserValue + "~|~" + strRhevPasswordValue + "~|~" + isDiscovery + "~|~" + mgrPort+ "~|~" + domain;
													aListUpdateHyperVisorServers.add(strMethodArgs);
												}
											}
										}
									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + strHostValue  + "," + tempComponentNickName + ","+tempPort;

									if (aListRhevMappingIniEntries == null)
									{
										aListRhevMappingIniEntries = new ArrayList();
									}
									aListRhevMappingIniEntries.add(new IniHelper(IniHelper.SET,rhev_mgrValue,Var,Val));

								}
							}


							// for XMS IP Configuration
							if (configureXMSIP)
							{
								int xmsIPIdx = aListProcessedParamNamesAndValues.indexOf("-xms_ip");
								String xmsIPValue = (String)aListProcessedParamNamesAndValues.get(xmsIPIdx+1);
								if (!xmsIPValue.equalsIgnoreCase("other") && !xmsIPValue.equalsIgnoreCase("none"))
								{
									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int xmsUserIdx = aListProcessedParamNamesAndValues.indexOf("-XtremIO_user");
										String strXMSUserValue = (String)aListProcessedParamNamesAndValues.get(xmsUserIdx+1);

										int xmsPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-XtremIO_password");
										String strXMSPasswordValue = (String)aListProcessedParamNamesAndValues.get(xmsPasswordIdx+1);
										//strXMSPasswordValue = EgCrypt.decrypt(strXMSPasswordValue);
										String strTokenSalt = strXMSPasswordValue; //salt for pwd
										if (!isNumber(strTokenSalt))
										{
											strTokenSalt = EgCrypt.decrypt(strTokenSalt);
										}
										if (strTokenSalt.indexOf("~EG~") != -1)
										{
											strXMSPasswordValue = strTokenSalt.substring(0,strTokenSalt.indexOf("~EG~"));
										}
										else
										{
											strXMSPasswordValue = strTokenSalt;
										}

										strXMSPasswordValue = EgCrypt.encrypt(strXMSPasswordValue);

										int xmsSSLIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(xmsSSLIdx+1);

										if (!StringUtils.isNull(strSslValue))
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												strSslValue = "Yes";
											}
											else
											{
												strSslValue = "No";
											}
										}

										String isDiscovery = "No";
										String xmsMgrPattern = eg_servicesIni.getValue("EMC_XtremIO_4x",xmsIPValue);
										StringTokenizer sst = new StringTokenizer(xmsMgrPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
										}

										String pattern = strSslValue + "#" + strXMSUserValue + "#" + strXMSPasswordValue + "#" + isDiscovery; 
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"EMC_XtremIO_4x",xmsIPValue,pattern));
									}
								}
							}
						}
					}
					else
					{
						ArrayList aListEachTestNameVal = getParameterList(oldValue,false);
						ArrayList aListEachTestNameValTemp = getParameterList(oldValue,true);

						for (int m=0;m<aListProcessedParamNamesAndValues.size();m=m+2)
						{
							String paramName = (String)aListProcessedParamNamesAndValues.get(m);
							String paramNameInLowerCase = paramName.toLowerCase();
							String paramValue = (String)aListProcessedParamNamesAndValues.get(m+1);

							boolean allowToModifyParameterValue = true;
							if (k != 0)
							{
								if (paramNameInLowerCase.equals("-ddfreq") || paramNameInLowerCase.equals("-exclude"))
								{
									allowToModifyParameterValue = false;
								}
							}

							if (aListEachTestNameValTemp.contains(paramNameInLowerCase) && allowToModifyParameterValue)
							{
								boolean isParamChoosen = true;

								//Applicable only to other components.not to UserInitiatedComponent.
								if (z > 0)
								{

									if (paramName.equalsIgnoreCase("-AWS_Account_ID_To_Monitor") || paramName.equalsIgnoreCase("-AWS_Role_Name"))
									{
										String accessRoleParamsVal = "$unconfigured";
										int idx = aListEachTestNameVal.indexOf(paramName);
										if (idx != -1)
										{
											accessRoleParamsVal = (String)aListEachTestNameVal.get(idx+1);
										}

										String strAccessType = "Role_Based";
										if (aListTemp.contains("-Access_Type"))
										{
											int accTypeIdx = aListTemp.indexOf("-Access_Type");
											strAccessType = (String) aListTemp.get(accTypeIdx+1);
										}

										if (aListChoosenParametersInLowerCase.contains("-access_type") && strAccessType.equalsIgnoreCase("Secret") && accessRoleParamsVal.equalsIgnoreCase("$unconfigured"))
										{
											if (paramValue.equalsIgnoreCase("$unconfigured"))
											{
												paramValue = "none";
											}
											if (!aListChoosenParametersInLowerCase.contains(paramNameInLowerCase))
											{
												aListChoosenParametersInLowerCase.add(paramNameInLowerCase);
											}
										}
									}

									//ensuring "Are we updating the only the parameter(s) which we picked in apply to other component page?"
									if (!aListChoosenParametersInLowerCase.contains(paramNameInLowerCase))
									{
										isParamChoosen = false;
									}
								}
								else
								{
									if (paramName.equalsIgnoreCase("-AWS_Account_ID_To_Monitor") || paramName.equalsIgnoreCase("-AWS_Role_Name"))
									{
										String accessRoleParamsVal = "$unconfigured";
										int idx = aListEachTestNameVal.indexOf(paramName);
										if (idx != -1)
										{
											accessRoleParamsVal = (String)aListEachTestNameVal.get(idx+1);
										}

										String strAccessType = request.getParameter("Access_Type");
										if (!StringUtils.isNull(strAccessType) && 
											strAccessType.equalsIgnoreCase("Secret") && accessRoleParamsVal.equalsIgnoreCase("$unconfigured"))
										{
											if (paramValue.equalsIgnoreCase("$unconfigured"))
											{
												paramValue = "none";
											}

											if (!aListTemp.contains(paramName))
											{
												aListTemp.add(paramName);
												aListTemp.add(paramValue);
											}
										}
									}
									
									//Applicable only to UserInitiatedComponent.
									//ensuring "Are we updating the parameter(s) that are displayed 
									//in UI?"i.e shouldnot configure the hidden parameters such as 
									//mCount,rptName
									if (!aListTemp.contains(paramName))
									{
										isParamChoosen = false;
									}
								}

								if (isParamChoosen)
								{
									int paramIdx = aListEachTestNameValTemp.indexOf(paramNameInLowerCase);
									aListEachTestNameVal.remove(paramIdx+1);
									aListEachTestNameVal.add(paramIdx+1,paramValue);
								}
							}
						}
						testParam = aListEachTestNameVal.toString();
						testParam = testParam.substring(1,testParam.length()-1);
						testParam = StringUtils.replace(testParam,",","");
					}
					strBuffer = new StringBuffer();
					if (isTestAtIntialConfiguration)
					{
						String lowerCaseTestParam = testParam.toLowerCase();
						ArrayList aListOldValues = getParameterList(oldValue,false);
						ArrayList aListNewValues = getParameterList(testParam.trim(),false);
						if (lowerCaseTestParam.indexOf(" -mode ") > -1 && 
							(lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 || lowerCaseTestParam.indexOf(" -service_url_path ") > -1))
						{
							//only for the component type "Java Application"
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -mode_type ") > -1 && 
							(lowerCaseTestParam.indexOf(" -jmx_remote_port ")  > -1 || lowerCaseTestParam.indexOf(" -service_url_path ") > -1))
						{
							//only for the component type "Java Application"
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -measure_mode ") > -1 && 
							(lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 || lowerCaseTestParam.indexOf(" -service_url_path ") > -1) &&
							lowerCaseTestParam.indexOf(" -logfilename ") > -1)
						{
							//only for the component type "Java Application" and JvmMemPoolGCTest
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -measurement_mode ") > -1 && 
							lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 &&
							lowerCaseTestParam.indexOf(" -ssl ") > -1 && lowerCaseTestParam.indexOf(" -url ") > -1)
						{
							//only for the component type "Java Application" and JvmMemPoolGCTest
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -connection_type ") > -1)
						{
							//only for the component type "SAP ABAP System"
							strBuffer.append(doProperUpdateForABAPSystemComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -using_horizon_api ") > -1 && testName.equals("VMViewEventsTest"))
						{
							//only for the component type "Horizon POD/Cluster" and VMViewEventsTest
							strBuffer.append(doProperUpdateForHorzPodEvtTest(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -use_sapcontrol ") > -1 && (testName.equals("AsAbapWorkTest") || testName.equals("AsAbapWPCnfTest_cf")  || testName.equals("AsAbapSyslgTest")))
						{
							//only for the component type "SAP ABAP Instance" and AsAbapWorkTest and AsAbapWPCnfTest_cf
							strBuffer.append(doProperUpdateForABAPComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -data_collection_mode ") > -1 && 
							(testName.equals("WDispAvailTest") ||
							testName.equals("WDispCacheTest") || 
							testName.equals("WDispConnTest") || 
							testName.equals("WDispServListTest") || 
							testName.equals("WDispConfigTest") || 
							testName.equals("WDispStatusTest") || 
							testName.equals("WDispThreadTest")))
						{
							//only for the component type "SAP ABAP Instance" and AsAbapWorkTest and AsAbapWPCnfTest_cf
							strBuffer.append(doProperUpdateForSAPWebDispComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if(lowerCaseTestParam.indexOf(" -snmpport ") > -1)
						{
							//only for snmp component
							strBuffer.append(doProperUpdateForSNMPComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else
						{
							//other components
							strBuffer.append(doProperUpdate(aListOldValues,aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
					}
					else
					{
						strBuffer.append("-manual");
					}
					strBuffer.append(", " + testParam + ", ");

					//for handling test period value - starts here
					if (isUserInitiatedTest)
					{
						if (z == 0)
						{
							strTestPeriod = new String(testPeriod);
						}
						else
						{
							if (aListChoosenParametersInLowerCase.contains("-testperiod"))
							{
								strTestPeriod = new String(testPeriod);
							}
							else
							{
								strTestPeriod = oldIniValue.substring(oldIniValue.lastIndexOf(",")+1,oldIniValue.length());
							}
						}
					}
					else
					{
						if (aListCommonTestRelationVariables.contains(strTestName))
						{
							strTestPeriod = new String(testPeriod);
						}
						else
						{
							strTestPeriod = oldIniValue.substring(oldIniValue.lastIndexOf(",")+1,oldIniValue.length());
						}
					}
					//ends here
					strBuffer.append(strTestPeriod.trim());

					if (!oldIniValue.equals(strBuffer.toString()))
					{
						isSaveTheAudit = true;
						isSaveTheAuditForOtherTest = true;
					}

					if (aListTempAgents.size() > 1)
					{
						tempTestValue = strBuffer.toString();
						tempResultantPattern = resultantPattern;
						isParameterSetAvailable = true;
					}

					//for auditlog - starts
					if (isAuditLogEnabled && isSaveTheAuditForOtherTest && z == 0 && k > 0)
					{
						//if(showAddAuditlog) //for apply to other tests also visible
						{
							if(strTestName.endsWith("_ex"))
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)",strTestName);
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)",strTestName);
								}
							}
							else
							{
								if (auditParamIdx <= 9)
								{
									auditLogThread.setCurrentValue("0"+auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)","$test$:"+strTestName);
								}
								else
								{
									auditLogThread.setCurrentValue(auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)","$test$:"+strTestName);
								}
							}
						}

						if (k == aListConfigurableTest.size())
						{
							auditParamIdx++;
						}
					}
					//for auditlog - ends


				}
				else
				{
					strBuffer = new StringBuffer(tempTestValue);
					resultantPattern = tempResultantPattern;
				}

				if (isPwdProfileUpdate)
				{
					if (pwdParamSetList != null)
					{
						ArrayList allSelectedPwdParams = new ArrayList();
						Iterator pwdParamsItr = pwdParamSetList.keySet().iterator();
						while(pwdParamsItr.hasNext())
						{
							allSelectedPwdParams.add(pwdParamsItr.next());
						}

						int size = allSelectedPwdParams.size();
						for (int d=0;d<size;d++)
						{
							String strPwdProfParamName = (String) allSelectedPwdParams.get(d);
							String paramsSetForThisParam = (String) pwdParamSetList.get(strPwdProfParamName);

							if (z != 0)
							{
								boolean hasPwdProfileParameter = checkPwdProfileParams(aListChoosenParametersInLowerCase,"-"+strPwdProfParamName); // checking string condition is startsWith 
								if (!hasPwdProfileParameter)
								{
									continue;
								}
							}

							if (checkParamsExist(paramsSetForThisParam,strBuffer))
							{
								isSpecificProfile = pwdProf.isTestHasSpecificPwdProfile(componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam,strTestName);
								String strProfName = "";//request.getParameter(strPwdProfParamName);

								if (fromPage.equals("EgConfigureComponentTests.jsp"))
								{
									strProfName = request.getParameter(strPwdProfParamName);
								}
								else
								{
									int idx = aListTemp.indexOf("-"+strPwdProfParamName);
									if (idx != -1)
									{
										String strPwdProfValue = (String)aListTemp.get(idx+1);
										strProfName = strPwdProfValue;
									}
								}
								if (!StringUtils.isNull(strProfName) && !strProfName.equals("-1") && !strProfName.equalsIgnoreCase("none"))
								{
									if (isSpecificProfile)
									{
										specificProfile = pwdProf.getProfNameForSpecificConfiguration(componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam,strTestName);
										String pwdProfSubExist = componentType+":"+tempComponentName+"#^#"+strProfName;

										if (!StringUtils.isNull(specificProfile) && !specificProfile.equals(strProfName))
										{
											pwdProfSubExist = componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;

											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));

										}
										pwdProfSubExist = componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSubExist,strTestName,paramsSetForThisParam));
									}
									else
									{
										String pwdProfSub = componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam+"#^#"+strProfName;
										aListPwdProfIniEntries.add(new IniHelper(IniHelper.SET,pwdProfSub,strTestName,paramsSetForThisParam));
									}
								}
								else
								{
									// this case for already selected profile is need to be deleted, coz profile not selected  in last updation....
									if (isSpecificProfile)
									{
										specificProfile = pwdProf.getProfNameForSpecificConfiguration(componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam,strTestName);
										if (!StringUtils.isNull(specificProfile))
										{
											String pwdProfSubExist = componentType+":"+tempComponentName+"#^#"+paramsSetForThisParam+"#^#"+specificProfile;

											aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,pwdProfSubExist,strTestName,""));
										}
									}
								}
							}
						}
					}
				}

				if (aListAgentsIniEntries == null)
				{
					aListAgentsIniEntries = new ArrayList();
				}
				aListAgentsIniEntries.add(new IniHelper(IniHelper.SET,tempAgentNickName,resultantPattern,strBuffer.toString()));
			}

			//for aggregate - starts
			boolean isAggregateTest = egAggInfo.isAggregateTest(strTestName);
			if (isAggSupported && allowAggOperation && !isAggComponentType && !isAggregateTest)
			{
				boolean hasAggTest = false;
				boolean allowAggregateOperation = true;

				//this case will come for apply to other component.
				//Aggregate operation shoul dbe suspended when testperiod
				//is deselected
				if (z > 0)
				{
					allowAggregateOperation = aListChoosenParametersInLowerCase.contains("-testperiod");
				}

				//this case will come for test relation
				//aggregation operation should be suspended for the test other than user intiated
				//test, when there is no relation under[COMMON_TEST_RELATION]
				if (allowAggregateOperation)
				{
					if (k > 0)
					{
						allowAggregateOperation = aListCommonTestRelationVariables.contains(strTestName);
					}
				}

				if (allowAggregateOperation)
				{
					String maxTestFrequency = new String(testPeriod);
					String aggregateTestName = "";
					if (aListAggTest.contains(strTestName))
					{
						aggregateTestName = (String)aListAggTest.get(aListAggTest.indexOf(strTestName)+1);
						hasAggTest = true;
					}
					if (hasAggServerType && hasAggTest)
					{
						for (int m=0;m<aggCompWithType.size();m++)
						{
							String strAgg = (String)aggCompWithType.get(m);
							if (!managedComponents.contains(strAgg)) continue;

							String strAggType = strAgg.substring(0,strAgg.indexOf(":"));
							String strAggCompName = strAgg.substring(strAgg.indexOf(":")+1);
							List aListAgentsForAggComponent = getAgents(strAggCompName);
							List aListTempAggAgents = null;
							boolean isThisAggTestExternal = egSpecs.isExternalTest(aggregateTestName,strAggType);
							if (isThisAggTestExternal)
							{
								aListTempAggAgents = aListAgentsForAggComponent.subList(1,aListAgentsForAggComponent.size());
							}
							else
							{
								aListTempAggAgents = aListAgentsForAggComponent.subList(0,1);
							}

							if (aListTempAggAgents == null) continue;
							for (int s=0;s<aListTempAggAgents.size();s++)
							{
								String auditAggTest = "";
								String tempPattern = "";
								String tempTestParam = "";
								String strComp = "";
								String tempAggAgent = (String)aListTempAggAgents.get(s);
								boolean b_isPortRelevantForAggTest = egSpecs.isPortRelevantForTest(aggregateTestName);

								String agg_resultantPattern = "";
								String agg_specificPattern_A = aggregateTestName + ":" + strAggType + ":" + strAggCompName;
								String agg_specificPattern_B = aggregateTestName + ":" + strAggType + ":" + strAggCompName.substring(0,strAggCompName.indexOf(":"));
								String agg_defaultPattern_A = aggregateTestName + "::" + strAggCompName;
								String agg_defaultPattern_B = aggregateTestName + "::" + strAggCompName.substring(0,strAggCompName.indexOf(":"));
								List listAgentIniVariables = Arrays.asList(agentIni.getVariables(tempAggAgent));

								if (listAgentIniVariables.contains(agg_specificPattern_A))
								{
									agg_resultantPattern = agg_specificPattern_A;
								}
								else if (listAgentIniVariables.contains(agg_specificPattern_B))
								{
									agg_resultantPattern = agg_specificPattern_B;
								}
								else if (listAgentIniVariables.contains(agg_defaultPattern_A))
								{
									agg_resultantPattern = agg_defaultPattern_A;
								}
								else if (listAgentIniVariables.contains(agg_defaultPattern_B))
								{
									agg_resultantPattern = agg_defaultPattern_B;
								}

								if (agg_resultantPattern.equalsIgnoreCase("")) continue;

								tempTestParam = agentIni.getValue(tempAggAgent,agg_resultantPattern);
								if(tempTestParam == null || tempTestParam.trim().length()==0) continue;
								String oldTestFrequency = tempTestParam.substring(tempTestParam.lastIndexOf(EgConstants.COMMA)+1).trim();
								oldTestFrequency = oldTestFrequency.trim();
								if (Integer.parseInt(maxTestFrequency) > Integer.parseInt(oldTestFrequency))
								{
									tempTestParam = "-manual," + tempTestParam.substring(tempTestParam.indexOf(",")+1,tempTestParam.lastIndexOf(",")) + ", " + maxTestFrequency;
									if (aListAgentsIniEntries == null)
									{
										aListAgentsIniEntries = new ArrayList();
									}
									aListAgentsIniEntries.add(new IniHelper(IniHelper.SET,tempAggAgent,agg_resultantPattern,tempTestParam));
									aListAuditAggComponents.add(agg_resultantPattern);
								}
							}
						}
					}
				}
			}
			//for aggregate - ends
		}

		//Detailed Diagnosis - start
		if (!detailedDiagnosis.equals(""))
		{
			List listDisabledDDTestGlobally = Arrays.asList(testinfoIni.getVariables("Disable_DD"));
			if (!listDisabledDDTestGlobally.contains(testName))
			{
				String strComp = "";
				String disabledSpecificDDTests = "";
				if (isPortRelevantForTest)
				{
					strComp = tempComponentName;
					disabledSpecificDDTests = testinfoIni.getValue("Disable_Specific_DD",strComp);
				}
				else
				{
					if (tempComponentName.indexOf(":") == -1)
					{
						strComp = tempComponentName+":NULL";
					}
					else
					{
						strComp = tempComponentNickName + ":NULL";
					}
					disabledSpecificDDTests = testinfoIni.getValue("Disable_Specific_DD",strComp);
				}

				ArrayList aListDisabledSpecificDDTests = getArrayList(disabledSpecificDDTests,",");

				if (aListTestInfoIniEntries == null)
				{
					aListTestInfoIniEntries = new ArrayList();
				}

				if (detailedDiagnosis.equals("Off") && !aListDisabledSpecificDDTests.contains(testName))
				{
					String str = aListDisabledSpecificDDTests.toString();
					str = str.substring(1,str.length()-1);
					str = StringUtils.replace(str," ","");
					if(str.length()>0)
					{
						str = str + "," + testName;
					}
					else
					{
						str = testName;
					}

					aListTestInfoIniEntries.add(new IniHelper(IniHelper.SET,"Disable_Specific_DD",strComp,str));
				}
				else if (detailedDiagnosis.equals("On") && aListDisabledSpecificDDTests.contains(testName))
				{
					aListDisabledSpecificDDTests.remove(testName);
					if (aListDisabledSpecificDDTests.size() == 0)
					{
						aListTestInfoIniEntries.add(new IniHelper(IniHelper.DELETE,"Disable_Specific_DD",strComp,""));
					}
					else
					{
						String str = aListDisabledSpecificDDTests.toString();
						str = str.substring(1,str.length()-1);
						str = StringUtils.replace(str," ","");
						aListTestInfoIniEntries.add(new IniHelper(IniHelper.SET,"Disable_Specific_DD",strComp,str));
					}
				}
			}
		}
		//Detailed Diagnosis - ends

		//for auditlog - starts
		//if (isAuditLogEnabled && showAddAuditlog && z > 0)
		if (isAuditLogEnabled && z > 0)
		{
			String otherComponent = tempComponentName;
			if (otherComponent.indexOf(":NULL") > -1)
			{
				otherComponent = otherComponent.substring(0,otherComponent.indexOf(":"));
			}

			if (auditParamIdx <= 9)
			{
				auditLogThread.setCurrentValue("0"+auditParamIdx+"~~TEST CONFIGURED FOR OTHER COMPONENTS",otherComponent);
			}
			else
			{
				auditLogThread.setCurrentValue(auditParamIdx+"~~TEST CONFIGURED FOR OTHER COMPONENTS",otherComponent);
			}
		}
		//for auditlog - ends
	}
	//Iterating each component - ends

	if (aListAuditAggComponents != null)
	{
		if (!aListAuditAggComponents.isEmpty())
		{
			auditParamIdx = auditParamIdx+1;
		}

		TreeMap tmapAuditAggComp = new TreeMap();
		for (int i=0;i<aListAuditAggComponents.size();i++)
		{
			String strAuditPattern = (String)aListAuditAggComponents.get(i);
			String auditAggTest = strAuditPattern.substring(0,strAuditPattern.indexOf(":"));
			String auditAggComponentName = strAuditPattern.substring(strAuditPattern.indexOf("::")+2,strAuditPattern.length());
			int idx = auditAggComponentName.indexOf(":NULL");
			if (idx != -1)
			{
				auditAggComponentName = auditAggComponentName.substring(0,idx);
			}

			ArrayList aListAuditTests = (ArrayList)tmapAuditAggComp.get(auditAggComponentName);

			if (aListAuditTests == null)
			{
				ArrayList aListTempAuditTests = new ArrayList();
				aListTempAuditTests.add(auditAggTest);
				tmapAuditAggComp.put(auditAggComponentName,aListTempAuditTests);
			}
			else
			{
				aListAuditTests.add(auditAggTest);
			}
		}

		if (allowAggOperation)
		{
			Iterator itrComponents = tmapAuditAggComp.keySet().iterator();
			while (itrComponents.hasNext())
			{
				String strComponentName = (String)itrComponents.next();
				ArrayList aListAuditTests = (ArrayList)tmapAuditAggComp.get(strComponentName);
				for (int j=0;j<aListAuditTests.size();j++)
				{
					String auditAggTest = (String)aListAuditTests.get(j);
					if(showAddAuditlog)
					{
						if (auditAggTest.endsWith("_ex"))
						{
							if (auditParamIdx <= 9)
							{
								auditLogThread.setCurrentValue("0"+auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),auditAggTest);
							}
							else
							{
								auditLogThread.setCurrentValue(auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),auditAggTest);
							}
						}
						else
						{
							if (auditParamIdx <= 9)
							{
								auditLogThread.setCurrentValue("0"+auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),"$test$:"+auditAggTest);
							}
							else
							{
								auditLogThread.setCurrentValue(auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),"$test$:"+auditAggTest);
							}
						}
					}
				}
				auditParamIdx++;
			}
		}
	}

	//for eg_agents.ini - starts
	// apply to other component logic only if os matches
	if (aListAgentsIniEntries != null)
	{
		Hashtable htableKeyVarVal = new Hashtable();
		Hashtable mgrmiscBulkData = new Hashtable();
		AgentConfig agentconfig =  AgentConfig.getAgentConfig();

		EgTablesInfo tablesInfo = new EgTablesInfo("manager");
		EgCorrectiveScripts egCorrectiveScript = new EgCorrectiveScripts();
		boolean isExternalAgent = egCorrectiveScript.isExternalAgentForComp(applyComponentName, componentType);
		boolean isRemoteBasedComp = agentInfo.isAgentlessServer(applyComponentName, componentType);
		String appliedAgentOS = agentconfig.getAgentOS(applyComponentName);
		IniFile eg_agentsIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_agents.ini");
		for (int i=0;i<aListAgentsIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListAgentsIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			boolean isNotRemoteAgent = true;
			if (!isRemoteBasedComp && !isExternalAgent)
			{
				ArrayList allHostLevelTests = tablesInfo.getHostLevelTests();
				String compNickNameStr = "";
				String componentNameStr = "";

				if (key.indexOf("::") > -1)
				{
					int ind_val = key.indexOf("::");
					int len_val = key.length();
					String keySubStr = key.substring(ind_val+2, len_val);
					if (keySubStr.indexOf(":") > -1)
					{
						int ind_id = keySubStr.indexOf(":");
						compNickNameStr = keySubStr.substring(0, ind_id); 
					}
					else
					{
						compNickNameStr = keySubStr; 
					}
					int idx_val = key.indexOf(compNickNameStr);
					componentNameStr = key.substring(idx_val, len_val);
					String testNameSubStr = key.substring(0, ind_val);
					boolean isHostLevelTest = (allHostLevelTests != null && allHostLevelTests.contains(testNameSubStr))? true : false ;
					if (isHostLevelTest)
					{
						componentNameStr = componentNameStr + ":" + "NULL";
					}
				}
				else
				{
					int ind_val = key.indexOf(":");
					int len_val = key.length();
					String keySubStr = key.substring(ind_val+1, len_val);
					int ind_id = keySubStr.indexOf(":");
					int len_no = keySubStr.length();
					String compTypeSubStr = keySubStr.substring(ind_id+1, len_no);
					int nick_idx = compTypeSubStr.indexOf(":");
					if (nick_idx != -1)
					{
						compNickNameStr = compTypeSubStr.substring(0, nick_idx);
					}
					else
					{
						compNickNameStr = compTypeSubStr;
					}
					int idx_val = key.indexOf(compNickNameStr);
					componentNameStr = key.substring(idx_val, len_val);
				}
				boolean isRemoteAgent = agentInfo.isAgentlessServer(compNickNameStr, componentType);
				if (isRemoteAgent)
				{
					isNotRemoteAgent = false;
				}
				if (StringUtils.isNull(appliedAgentOS))
				{
					if (!applyComponentName.equals(sub))
					{
						String agentValue = eg_agentsIniSync.getValue(sub, key);
						val = updateValuesCs(val, agentValue);
					}
				}
				else
				{
					String agentOS = agentconfig.getAgentOS(sub);
					if (appliedAgentOS.equals(agentOS))
					{
						if (isNotRemoteAgent)
						{
							mgrmiscBulkData.put(componentType + ":" + componentNameStr + ":" +agentOS,val);							
							//sets the variables in eg_mgrmisc.ini file
							//updateMgrMiscFile(val, agentOS, componentType, componentNameStr);
						}
					}
					else
					{
						String agentValue = eg_agentsIniSync.getValue(sub, key);
						val = updateValuesCs(val, agentValue);
					}
				}
			}

			Vector vecVarVal = (Vector) htableKeyVarVal.get(sub);
			if (vecVarVal == null)
			{
				vecVarVal = new Vector();
				Vector vecVar = new Vector();
				Vector vecVal = new Vector();
				vecVar.add(key);
				vecVal.add(val);
				vecVarVal.add(vecVar);
				vecVarVal.add(vecVal);
				htableKeyVarVal.put(sub,vecVarVal);
			}
			else
			{
				Vector vecVar = (Vector) vecVarVal.get(0);
				Vector vecVal = (Vector) vecVarVal.get(1);
				vecVar.add(key);
				vecVal.add(val);
			}
		}

		Set set = htableKeyVarVal.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();

			String subject = (String) me.getKey();
			Vector agentIniVarVal = (Vector)  me.getValue();
			Vector agentIniVariable = (Vector)  agentIniVarVal.get(0);
			Vector agentIniValue = (Vector)  agentIniVarVal.get(1);

			if (agentIniVariable != null && agentIniVariable.size() > 0)
			{
				eg_agentsIniSync.setValues(subject, agentIniVariable, agentIniValue, false);
			}
		}

		eg_agentsIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_agentsIniSync);
		
		if (mgrmiscBulkData != null && !mgrmiscBulkData.isEmpty())
		{
			updateMgrMiscFile(mgrmiscBulkData);
		}
	}
	//for eg_agents.ini - ends

	//for eg_discoveryParams.ini - starts

	//discParamsList
	if (discParamsVarList != null && !discParamsVarList.isEmpty())
	{
		Vector allVarsForSelectedCompType = new Vector();
		Vector allValsForSelectedCompType = new Vector();

		IniFile eg_discParamsIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");

		Set set = discParamsList.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();

			String agentIniVar = (String) me.getKey();
			ArrayList agentIniVal = (ArrayList)  me.getValue();

			String existDiscParamsVal = eg_discParamsIniSync.getValue(componentType,agentIniVar);
			String discParamsNewVal = updateDiscParamsValues(agentIniVal,existDiscParamsVal);

			if (!StringUtils.isNull(discParamsNewVal))
			{
				allVarsForSelectedCompType.add(agentIniVar);
				allValsForSelectedCompType.add(discParamsNewVal);
			}
		}

		if (allVarsForSelectedCompType != null && allVarsForSelectedCompType.size() > 0)
		{
			eg_discParamsIniSync.setValues(componentType, allVarsForSelectedCompType, allValsForSelectedCompType, false);
			eg_discParamsIniSync.saveFile();
		}
		EgConfigFilesSync.releaseInstance(eg_discParamsIniSync);
	}
	//for eg_discoveryParams.ini - ends

	//for eg_testinfo.ini - starts
	if (aListTestInfoIniEntries != null)
	{
		IniFile eg_testInfoIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testinfo.ini");
		for (int i=0;i<aListTestInfoIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListTestInfoIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_testInfoIniSync.setValue(sub,key,val);
				}
				else if (iniAction.equals(IniHelper.DELETE))
				{
					eg_testInfoIniSync.deleteValue(sub,key);
				}
			}
		}
		eg_testInfoIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_testInfoIniSync);
	}
	//for eg_testinfo.ini - ends

	//for eg_nutanixmapping.ini - starts
	if (aListNutMappingIniEntries != null)
	{
		IniFile eg_NutMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_nutanixmapping.ini");
		for (int i=0;i<aListNutMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListNutMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_NutMappingIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_NutMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_NutMappingIniSync);
	}
	//for eg_nutanixmapping.ini - ends

	//for eg_nutanixmapping.ini - starts
	if (aListNtxCenterMappIniEntries != null)
	{
		IniFile eg_NtxCtrlMappIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_nutanixcentralmapping.ini");
		for (int i=0;i<aListNtxCenterMappIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListNtxCenterMappIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_NtxCtrlMappIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_NtxCtrlMappIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_NtxCtrlMappIniSync);
	}
	//for eg_nutanixmapping.ini - ends

	//for eg_vcmapping.ini - starts
	if (aListVcMappingIniEntries != null)
	{
		ArrayList vcMapDeleteList = new ArrayList();
		IniFile eg_VcMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_vcmapping.ini");
		String[] allVcMapSubjects = eg_VcMappingIniSync.getSubjects();
		for (int i=0;i<aListVcMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListVcMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_VcMappingIniSync.setValue(sub,key,val);
				}
			}
			vcMapDeleteList.add(key);
		}

		if (allVcMapSubjects != null && allVcMapSubjects.length > 0)
		{
			for (int a=0;a<allVcMapSubjects.length;a++)
			{
				String subject = allVcMapSubjects[a];
				if (ipAddress.equals(subject)) continue;
				for (int v=0;v<vcMapDeleteList.size();v++)
				{
					String comp = (String) vcMapDeleteList.get(v);
					String value = eg_VcMappingIniSync.getValue(subject,comp);
					if (value != null && value.length() > 0)
					{
						eg_VcMappingIniSync.deleteValue(subject,comp);
					}
				}
			}
		}
		eg_VcMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_VcMappingIniSync);
	}
	//for eg_vcmapping.ini - ends
	
	// for eg_rhevmapping.ini - starts
	if (aListRhevMappingIniEntries != null)
	{
		IniFile eg_rhevMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_rhevmapping.ini");
		for (int i=0;i<aListRhevMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListRhevMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null && iniAction.equals(IniHelper.SET))
			{
				eg_rhevMappingIniSync.setValue(sub,key,val);
			}
		}
		eg_rhevMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_rhevMappingIniSync);
	}
	// for eg_rhevmapping.ini - ends
	
	// for eg_rhevmapping.ini - starts
	if (aListPwdProfIniEntries != null)
	{
		IniFile writePwdProfIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_pwdprofile.ini");
		for (int i=0;i<aListPwdProfIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListPwdProfIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null )
			{
				if (iniAction.equals(IniHelper.SET))
				{
					writePwdProfIniSync.setValue(sub,key,val);
				}
				else if (iniAction.equals(IniHelper.DELETE))
				{
					writePwdProfIniSync.deleteValue(sub,key);
				}
			}
		}
		writePwdProfIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(writePwdProfIniSync);
	}
	// for eg_rhevmapping.ini - ends

	// eg_specs.ini update code starts here...
	ArrayList typeList = new ArrayList();
	String componentTypeEsx = "";
	String baseCompType = "";
	String baseTypeParam = "";
	String subTypeParam = "";
	HashMap discBaseCompValsToChange = new HashMap();
	HashMap discCompValsToChange = new HashMap();
	Set discParamsBaseCompoModify = new HashSet();
	Set discParamsSubCompModify = new HashSet();
	ArrayList listOfComponents = new ArrayList();
	Hashtable listOfComponentsmap = new Hashtable();
			
	
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	String userid = _user.getLoginID();
	boolean isSuperOrg = egUuidInfo.isSuperOrg(userid);
	boolean isOrg = egUuidInfo.isOrg(userid);
	String orgNameStr = "";
	if (isSuperOrg)
	{
		orgNameStr = userid;
	}
	else
	{
		if (isOrg)
		{
			orgNameStr = userid;
		}
		else
		{
			orgNameStr = egUuidInfo.getDirectDependentOU(userid);
		}
	}

	//if(from.startsWith("hmc"))
	//{
		//typeList.add("hmc_server");
		//typeList.add("pSeries_server");
	//}

	if(configureHMCComp)
	{
		componentTypeEsx = "hmc";
		//typeList.add("pSeries_server");
	}
	else if(configureAcroVdi)
	{
		componentTypeEsx = "nutanix";
		typeList.add("Nutanix_Acropolis");
		typeList.add("Nutanix_Acropolis_Vdi");
		if (isNutClusterCompType)
		{
			if (isNtxCtrlCompType)
			{
				typeList.add("Nutanix_Cluster");
			}
			else
			{
				typeList.add("Nutanix_Prism_Center");
			}
		}
		else
		{
			typeList.add("Nutanix_Cluster");
			typeList.add("Nutanix_Prism_Center");
		}
	}
	else if(configureRhevVdi)
	{
		componentTypeEsx = "rhev";
		typeList.add("Redhat_linux_hpv");
		typeList.add("Redhat_linux_vdi");
	}
	else if (configureEsxVdi || (isVcenterCompType && aListSelectedComponents != null && !aListSelectedComponents.isEmpty()))
	{
		if (!StringUtils.isNull(subVal))
		{
			StringTokenizer tmpST = new StringTokenizer(subVal, "#"); 
			String discCompSSL = tmpST.nextToken();
			String discCompUName = tmpST.nextToken();
			String discCompUPass = tmpST.nextToken();
			String discCompDisc = tmpST.nextToken();
			String discCompWebPort = tmpST.nextToken();
			
			discBaseCompValsToChange.put("vc_user",discCompUName);
			discBaseCompValsToChange.put("vc_password",discCompUPass);
			discBaseCompValsToChange.put("ssl",discCompSSL);
			discBaseCompValsToChange.put("webport",discCompWebPort);
				
			discCompValsToChange.put("esx_user",discCompUName);
			discCompValsToChange.put("esx_password",discCompUPass);
			discCompValsToChange.put("ssl",discCompSSL);
			discCompValsToChange.put("webport",discCompWebPort);
		}
			
		componentTypeEsx = "vcenter";
		baseCompType = "Virtual_center";
		baseTypeParam = "vc_user";
		subTypeParam = "virtual_center";
		typeList.add("VmEsx_i_server");
		typeList.add("VmVdi_i_server");
	}

	if (agentIniFlag) //this condition checks any one of the value is changed...
	{
		String[] manageTypes = discInfo.getServerTypes();
		ArrayList getmanageTypeList = new ArrayList();
		
		IniFile discFilePtr = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
		IniFile egDscParamsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discoveryParams.ini");

		if (typeList != null && !typeList.isEmpty())
		{
			String unmanagedCompArr[] = null;
			//if (true) //allCompAccess)
			//{
				for(int t=0; t<typeList.size(); t++)
				{
					String strServerType = (String) typeList.get(t);
					synchronized ("siteServerSection")
					{
						unmanagedCompArr = discFilePtr.getVariables(strServerType);
					}
					if (unmanagedCompArr != null && unmanagedCompArr.length >0)
					{
						for (int v=0; v<unmanagedCompArr.length; v++)
						{
							String strUnmanComp = unmanagedCompArr[v];
							if (strUnmanComp.startsWith("#"))
							{
								strUnmanComp = strUnmanComp.substring(strUnmanComp.indexOf("|")+1);

								String discParamVal = egDscParamsIni.getValue(strServerType,strUnmanComp);
								if(discParamVal.length() > 0 && discParamVal!=null)
								{
									int paramIdx = discParamVal.toLowerCase().indexOf("-"+subTypeParam.toLowerCase());
									if (paramIdx > -1)
									{
										String tmpStr2 = discParamVal.substring(paramIdx + subTypeParam.length() +1).trim();
										String serverIp = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
										if (serverIp.equals(ipAddress))
										{
											discParamsSubCompModify.add(strUnmanComp);
										}
									}
								}
							}
						}
					}
				}
				
				synchronized ("siteServerSection")
				{
					unmanagedCompArr = discFilePtr.getVariables(baseCompType);
				}
				
				if (unmanagedCompArr != null && unmanagedCompArr.length >0)
				{
					for (int b=0; b<unmanagedCompArr.length; b++)
					{
						String strUnmanComp = unmanagedCompArr[b];
						if (strUnmanComp.startsWith("#"))
						{
							strUnmanComp = strUnmanComp.substring(strUnmanComp.indexOf("|")+1);
							String discParamVal = egDscParamsIni.getValue(baseCompType,strUnmanComp);
							if(discParamVal!=null && discParamVal.length() > 0)
							{
								int paramIdx = discParamVal.toLowerCase().indexOf("-"+baseTypeParam.toLowerCase());
								if (paramIdx > -1)
								{
									String strUnmanCompLower = strUnmanComp.toLowerCase();
									if(strUnmanCompLower.indexOf(":"+ipAddress.toLowerCase()+":") > 0 || 
									strUnmanCompLower.endsWith(":"+ipAddress.toLowerCase()))
									{
										discParamsBaseCompoModify.add(strUnmanComp);
									}
								}
							}
						}
					}
				}
			//}
		}
	
		if (manageTypes != null && manageTypes.length >0)
		{
			for(int m=0; m<manageTypes.length; m++)
			{
				String strType = manageTypes[m];
				if (typeList != null && typeList.contains(strType))
				{
					if (!com.egurkha.util.StringUtils.isNull(strType) && (!strType.equalsIgnoreCase("Virtual_center") &&  !strType.equalsIgnoreCase("Redhat_linux_mgr")))
					{
						getmanageTypeList.add(strType);
					}
				}
			}
		}
		updateSpecsValues(getmanageTypeList,ipAddress,subVal,componentTypeEsx,isConfigSupported);
		if (updatedEsxList != null && updatedEsxList.size() > 0)
		{
			ArrayList tmpEsxList = new ArrayList();
			for (int up=0;up<updatedEsxList.size();up++)
			{
				String strNickName = updatedEsxList.get(up).toString();
				tmpEsxList.add(componentType+":"+strNickName);
			}

			updatedEsxList = new ArrayList();
			updatedEsxList.addAll(tmpEsxList);
		}

		if (isNutanixInfraComponentType)
		{
			String tmpComptNickName = componentName.substring(0,componentName.indexOf(":"));
			List agentList = getAgents(componentType, tmpComptNickName);
			String strVCAgentName = (String) agentList.get(0);

			HashSet result = new HashSet();
			if (isNutClusterCompType)
			{
				if (isNtxCtrlCompType)
				{
					ArrayList ipAddrList = new ArrayList();
					ArrayList variables = getNtxCtrlMappingVariables(strVCAgentName,ipAddress);

					if (variables != null && !variables.isEmpty())
					{
						int size = variables.size();
						for (int a=0;a<size;a++)
						{
							String prismIPVar = (String) variables.get(a);
							if  (!StringUtils.isNull(prismIPVar) && prismIPVar.indexOf("#") != -1)
							{
								int len_val = prismIPVar.length();
								int prismIdx = prismIPVar.indexOf("nutanix#");
								if (prismIdx != -1)
								{

									int lastIdx = prismIPVar.lastIndexOf("#");
									String eachPrismIP = prismIPVar.substring(prismIdx+"nutanix#".length(), lastIdx);
									int hashIdx = eachPrismIP.indexOf("#");
									if (!StringUtils.isNull(eGMgrModel) && eGMgrModel.equalsIgnoreCase("msp"))
									{
										eachPrismIP = eachPrismIP.substring(hashIdx+1);
									}
									else
									{
										eachPrismIP = eachPrismIP.substring(0, hashIdx);
									}
									ipAddrList.add(eachPrismIP);
								}
								else
								{
									String eachPrismIP = prismIPVar;
									int hashIdx = eachPrismIP.indexOf("#");
									if (!StringUtils.isNull(eGMgrModel) && eGMgrModel.equalsIgnoreCase("msp"))
									{
										eachPrismIP = eachPrismIP.substring(hashIdx+1);
									}
									else
									{
										eachPrismIP = eachPrismIP.substring(0, hashIdx);
									}
									ipAddrList.add(eachPrismIP);
								}
							}
							else
							{
								ipAddrList.add(prismIPVar);
							}
						}
					}
					result = updateNutanixAgentsValues(getmanageTypeList,ipAddrList,subVal,componentTypeEsx,updatedEsxList,ri,aListAgtlessDiscIniEntries);
				}
				else
				{
					String ntxCtrlSubject = getNtxCtrlMappingSubject(strVCAgentName,ipAddress);
					if (!StringUtils.isNull(ntxCtrlSubject) && ntxCtrlSubject.indexOf("~|~") != -1)
					{
						ntxCtrlSubject = ntxCtrlSubject.substring(0, ntxCtrlSubject.indexOf("~|~"));
					}
					result = updateNutanixAgentsValues(getmanageTypeList,ipAddress,subVal,componentTypeEsx,updatedEsxList,ri,aListAgtlessDiscIniEntries,ntxCtrlSubject);
				}
			}
			else
			{
				String ntxCtrlSubject = getNtxCtrlMappingSubject(strVCAgentName,ipAddress);
				if (!StringUtils.isNull(ntxCtrlSubject) && ntxCtrlSubject.indexOf("~|~") != -1)
				{
					ntxCtrlSubject = ntxCtrlSubject.substring(0, ntxCtrlSubject.indexOf("~|~"));
				}
				result = updateNutanixAgentsValues(getmanageTypeList,ipAddress,subVal,componentTypeEsx,updatedEsxList,ri,aListAgtlessDiscIniEntries,ntxCtrlSubject);
			}

			if (result != null && !result.isEmpty())
			{
				autoConfigHVCompsForAuditLog.addAll(result);
			}
		}
		else
		{
			if (isVcenterCompType)
			{
				HashSet result = updateAgentsValues(getmanageTypeList,ipAddress,subVal,componentTypeEsx,updatedEsxList,ri,aListAgtlessDiscIniEntries);
				if (result != null && !result.isEmpty())
				{
					autoConfigHVCompsForAuditLog.addAll(result);
					discParamsSubCompModify.addAll(result);
				}
			}
		}

		if(!StringUtils.isNull(componentTypeEsx) && (rmtAgentList != null && rmtAgentList.length > 0))
		{
			String componentNickName = componentName.substring(0,componentName.indexOf(":"));
			String remoteAgent = "";

			boolean isRemote = false;

			// To fetch the exact agent for the selected component - start
			isRemote = externalAgentInfo.isRemoteBased(componentNickName);
			if (isRemote)
			{
				//Agentless
				remoteAgent = externalAgentInfo.getRemoteAgentForHost(componentNickName);
			}
			
			if (egAgtlessDiscIni == null)
			{
				egAgtlessDiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentlessdisc.ini");
			}
		
			int otherRmtAgtSize = rmtAgentList.length;
			for(int r=0;r<otherRmtAgtSize;r++)
			{
				String otherRmtAgent = (String) rmtAgentList[r];
				if (remoteAgent.equalsIgnoreCase(otherRmtAgent))
				{
					continue;
				}
				String otherRmtAgentValue = egAgtlessDiscIni.getValue(otherRmtAgent,componentTypeEsx+ "#" +ipAddress);
				if (!StringUtils.isNull(otherRmtAgentValue))
				{
					StringTokenizer otherSt = new StringTokenizer(subVal, "#"); 
					String otherSSL = otherSt.nextToken();
					String otherUName = otherSt.nextToken();
					String otherUPass = otherSt.nextToken();
					String otherDisc = otherSt.nextToken();
					String otherWebPort = otherSt.nextToken();
					
					otherRmtAgentValue = otherDisc+"~#~"+otherUName+"~#~"+otherUPass+"~#~"+otherWebPort+"~#~"+otherSSL;
					aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,otherRmtAgent,componentTypeEsx+ "#" +ipAddress,otherRmtAgentValue));
				}
			}
		}
	}
	// eg_specs.ini update code ends here...

	if (isVcenterCompType && aListSelectedComponents != null && !aListSelectedComponents.isEmpty())
	{
		
		egurkha.EgUIUtils eguiutil = new egurkha.EgUIUtils();
		ArrayList valsToChange = new ArrayList();
		valsToChange.add(discBaseCompValsToChange);
		valsToChange.add(discCompValsToChange);
		for(int h=0;h<typeList.size();h++)
		{
			String thisType = (String) typeList.get(h);
			listOfComponents = new ArrayList(Arrays.asList(discInfo.getAllServersOfType(thisType)));
			listOfComponentsmap.put(thisType,listOfComponents);
		}
		eguiutil.updateChangesBaseToDiscComps (componentType, componentName, baseTypeParam, subTypeParam, otherHVIpAddrList, valsToChange, listOfComponentsmap, aListSelectedComponents, rmtAgentList, allCompAccess, orgNameStr);
	}

	if (aListUpdateHyperVisorServers != null && !aListUpdateHyperVisorServers.isEmpty())
	{
		ArrayList tmpVCList = new ArrayList(aListUpdateHyperVisorServers);
		String pattern = (String) tmpVCList.get(0);

		StringTokenizer st = new StringTokenizer(pattern, "~|~"); //ipAddress+"~|~"+ssl+"~|~"+UName+"~|~"+UPass+"~|~"+isDis+"~|~"+webPort;
		String vcIPAddr = st.nextToken();
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();
		String domain = "";
		if(configureRhevVdi)
		{
			domain = st.nextToken();
			webPort = webPort + "~#~" + domain;
		}

		if (UName.indexOf("~eGHash~") != -1)
		{
			UName =StringUtils.replace(UName,"~eGHash~", "#");
		}

		if (!isNutanixInfraComponentType)
		{
			HashSet resultHVs = updateHyperVisorsThruTestConfig(componentTypeEsx, vcIPAddr, UName, UPass, ssl, webPort);
			if (resultHVs != null && !resultHVs.isEmpty())
			{
				autoConfigHVCompsForAuditLog.addAll(resultHVs);
				discParamsBaseCompoModify.addAll(resultHVs);
			}
		}
	}

	if (aListDiscParamIniEntries == null)
	{
		aListDiscParamIniEntries = new ArrayList();
	}

	IniFile discParamIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_discoveryParams.ini");

	//TO Modify the base component param in eg_discoveryParams.ini
	if (discParamsBaseCompoModify !=null && discParamsBaseCompoModify.size() > 0)
	{
		Iterator ittt = discParamsBaseCompoModify.iterator();
		while(ittt.hasNext())
		{
			String Compo =(String) ittt.next();
			String compoType = Compo.substring(0,Compo.indexOf(":"));
			String value = discParamIni.getValue(compoType,Compo);
		
			if(value.length() > 0 && value!=null)
			{
				Iterator it = discBaseCompValsToChange.keySet().iterator();
				while (it.hasNext())
				{
					String param = (String)it.next();
					String paramVal = (String)discBaseCompValsToChange.get(param);
					int paramIdx = value.toLowerCase().indexOf("-"+param.toLowerCase());
					int paramLen = param.length()+1;
					if (paramIdx > -1)
					{
						String strTmp1 = value.substring(0,paramIdx+paramLen).trim();
						String strTmp2 = value.substring(paramIdx+paramLen).trim();
						int idx = strTmp2.indexOf(" ");
						if(idx !=-1)
						{ 
							strTmp2 = strTmp2.substring(idx).trim();
						}
						else
						{
							strTmp2="";
						}
						value = strTmp1 + " " + paramVal + " " + strTmp2;
					}
				}
				aListDiscParamIniEntries.add(new IniHelper(IniHelper.SET,compoType,Compo,value));
				//discParamIni.setValue(compoType,Compo,value);
			}
		}
	}

	//TO Modify the discovery component param in eg_discoveryParams.ini
	if(discParamsSubCompModify!=null && discParamsSubCompModify.size() >0)
	{
		Iterator itt = discParamsSubCompModify.iterator();
		while(itt.hasNext())
		{
			String Compo =(String) itt.next();
			String compoType = Compo.substring(0,Compo.indexOf(":"));
			String value = discParamIni.getValue(compoType,Compo);

			if (value.length() > 0)
			{
				Iterator it = discCompValsToChange.keySet().iterator();
				while (it.hasNext())
				{
					String param = (String)it.next();
					String paramVal = (String)discCompValsToChange.get(param);
					int paramIdx = value.toLowerCase().indexOf("-"+param.toLowerCase());
					int paramLen = param.length()+1;
					if (paramIdx > -1)
					{
						String strTmp1 = value.substring(0,paramIdx+paramLen).trim();
						String strTmp2 = " ";
						strTmp2 = value.substring(paramIdx+paramLen).trim();
						int idx = strTmp2.indexOf(" ");
						if(idx !=-1)
						{ 
							strTmp2 = strTmp2.substring(idx).trim();
						}
						else
						{
							strTmp2="";
						}
						value = strTmp1 + " " + paramVal + " " + strTmp2;
					}
				}
				aListDiscParamIniEntries.add(new IniHelper(IniHelper.SET,compoType,Compo,value));
				//discParamIni.setValue(compoType,Compo,value);
			}
		}
	}
		
	//for eg_discoveryParams.ini for unmanage components - starts
	if (aListDiscParamIniEntries != null)
	{
		IniFile eg_discParamIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
		for (int i=0;i<aListDiscParamIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListDiscParamIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_discParamIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_discParamIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_discParamIniSync);
	}
	//for eg_discoveryParams.ini for unmanage components - ends

	//for eg_agentlessdisc.ini - starts
	if ((rmtAgentList != null && rmtAgentList.length > 0) && aListAgtlessDiscIniEntries != null) // if remote agent exists we put an entry in agentlessdisc.ini file
	{
		IniFile eg_agtlessdiscIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_agentlessdisc.ini");
		for (int i=0;i<aListAgtlessDiscIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListAgtlessDiscIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_agtlessdiscIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_agtlessdiscIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_agtlessdiscIniSync);
	}
	//for eg_agentlessdisc.ini - ends

	//for eg_services.ini - starts
	if (aListServicesIniEntries != null)
	{
		IniFile eg_servicesIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		for (int i=0;i<aListServicesIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListServicesIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_servicesIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_servicesIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_servicesIniSync);
	}
	//for eg_services.ini - ends

	if (isAuditLogEnabled)
	{
		if(!autoConfigHVCompsForAuditLog.isEmpty())
		{
			Iterator itr = autoConfigHVCompsForAuditLog.iterator();
			while (itr.hasNext())
			{
				String server = (String) itr.next();
				String servType = server.substring(0,server.indexOf(":"));
				String servName = server.substring(server.indexOf(":")+1);
				if (servName.indexOf(":NULL") > -1)
				{
					servName = servName.substring(0,servName.indexOf(":"));
				}

				server = servName+ " ("+_mapping.getComponentTypeDescription(servType)+") ";
				auditLogThread.setCurrentValue("OTHER AUTO CONFIGURED COMPONENTS",server);
			}
		}
	}

	//for auditlog - ends
	if (isAuditLogEnabled && isSaveTheAudit)
	{
		auditLogThread.sendItToDB();
	}
	//for auditlog - ends

	//Starting the discovery process
	servicer.startDiscovery("1");
	EgConfigFilesSync.releaseInstance(infraIni);
	//source:EgTestParamp.jsp

	//forward to result page - starts
	session.setAttribute("aListDisplayParamNamesAndValues",aListDisplayParamNamesAndValues);
	if (fromPage.equals("EgApplyToOtherComponents.jsp") && !aListSelectedComponents.isEmpty())
	{
		session.setAttribute("aListAdditionalComponentsConfigured",aListSelectedComponents);
	}

	String query = "EgConfigureComponentResult.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testName="+EgURLEncoder.encode(testName,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
	//forward to result page - ends


	String fromWizard = request.getParameter("fromWizard");
	if (!StringUtils.isNull(fromWizard))
	{
		ArrayList listManagedComponents = new ArrayList();
		listManagedComponents.add(componentType+":"+componentName);

		EgTestSpecification egTestSpecification = new EgTestSpecification(listManagedComponents);

		//ensure whether the user is configuration management enabled
		if (_user != null && isConfigSupported)
		{
			EgUserRole userRole = _user.getUserRole();
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
			egTestSpecification.setConfigSupported(isConfigSupported);
		}
		
		rootJson.put("isConfiguredAll",true);

		TreeMap tmapUnConfigTests = (TreeMap)egTestSpecification.getUnconfiguredTest();
		if (tmapUnConfigTests != null && !tmapUnConfigTests.isEmpty())
		{
			rootJson.put("isConfiguredAll",false);
		}
	}



	rootJson.put("success",true);
	rootJson.put("successUpdate","true");
	out.println(rootJson.toString());
%>



<%!
	EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	String[] paramToContinue = {"agentless","site","aluser","alpassword","almode","sshPort"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	public ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	private void uploadScript(String agentOS, String file)
	{
		File scriptFile = new File(file);

		if(scriptFile == null || !scriptFile.exists())
		{
			return;
		}
		else
		{
			//Here we would need just the script file's name for a
			// SM to download it. Not the file name with path.
			if(file.indexOf("/") > -1)
			{
				file = file.substring(file.lastIndexOf("/"));
			}
			else if(file.indexOf("\\") > -1)
			{
				file = file.substring(file.lastIndexOf("\\"));
			}
		}

		if(EgInstallInfo.isClusterSupported)
		{
			//If clustering is supported intimate other managers about the new script.
			UploadCorrectiveScript uploadCorrectiveScript = new UploadCorrectiveScript();
			uploadCorrectiveScript.getCorrectiveScript(agentOS, file);
			uploadCorrectiveScript = null;
		}

		String os = System.getProperty("os.name");
		Runtime r=null;
		Process p = null;

		String destinationStr = EgInstallInfo.getInstallDir() + "/bin/AutoCorrect/" + agentOS;
		File destinationDir = new File(destinationStr);

		try
		{
			if( os.indexOf("Windows")!= -1)
			{
				r = Runtime.getRuntime();
				String cmd ="cmd.exe /c copy " + file +" "+ destinationDir.getAbsolutePath();
				p = r.exec(cmd);

			}
			else
			{
				r = Runtime.getRuntime();
				String cmd ="cp "+ file +" "+ destinationDir.getAbsolutePath();
				try
				{
					p = r.exec(cmd);
				}
				catch(Exception eee)
				{
				}
			}
		}
		catch(Exception x){}

		try
		{
			if (p != null)
			{
				int processExecuted = p.waitFor();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		if (p != null)
		{
			p.destroy();
		}
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";

		boolean isRemote = false;

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	public String doProperUpdate(
			ArrayList aListOldValues,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVal = "";
		String result = "-manual";

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);

			if (aListParamsWithDoubleQuotes.contains(tmpVar.toLowerCase()))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				if (aListParamsWithDoubleQuotes.contains(tmpVar.toLowerCase()))
				{
					tmpVal = (String)aListOldValues.get(i+1);
				}
				else
				{
					tmpVal = (String)aListOldValues.get(i+1);
					tmpVal = tmpVal.trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result = "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForSNMPComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		ArrayList aListSnmpV1V2Param = new ArrayList();
		aListSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListSnmpV3Param = new ArrayList();
		aListSnmpV3Param.add("username");
		aListSnmpV3Param.add("authpass");
		aListSnmpV3Param.add("authtype");
		aListSnmpV3Param.add("encryptflag");
		aListSnmpV3Param.add("encrypttype");
		aListSnmpV3Param.add("encryptpassword");

		int tempIdx = newValueLowerCase.indexOf("-snmpversion");
		String tempValue = "";
		String newSnmpVersion = "";
		if (tempIdx > -1)
		{
			tempValue = newValue.substring(tempIdx+1);
			newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newSnmpVersion = newSnmpVersion.trim();
		}

		String oldSnmpVersion = "";
		if (!oldValue.equals(""))
		{
			tempIdx = oldValueLowerCase.indexOf("-snmpversion")+1;
			if (tempIdx > -1)
			{
				tempValue = oldValue.substring(tempIdx);
				oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				oldSnmpVersion = oldSnmpVersion.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (newSnmpVersion.equalsIgnoreCase("v3"))
				{
					if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
				}
				else//v1,v2
				{
					if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
				{
					tmpVal = (String)aListOldValues.get(i+1);
				}
				else
				{
					tmpVal = (String)aListOldValues.get(i+1);
					tmpVal = tmpVal.trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (oldSnmpVersion.equalsIgnoreCase("v3"))
					{
						if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
					}
					else //v1,v2
					{
						if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForJVMComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasModeType = (oldValue.indexOf("-mode_type") > -1);
		boolean hasMeasureMode = (oldValue.indexOf("-measure_mode") > -1);
		boolean hasMeasurementMode = (oldValue.indexOf("-measurement_mode") > -1);

		ArrayList aListJvmParam = new ArrayList();
		//The RadioParams "mode" and "profiler" are not added.because we know that these params will not have $unconfigured value.
		aListJvmParam.add("jmx_remote_port");
		aListJvmParam.add("Jmx_user");
		aListJvmParam.add("Jmx_password");
		aListJvmParam.add("user");
		aListJvmParam.add("password");
		aListJvmParam.add("pct_low_cpu_util_threads");
		aListJvmParam.add("pct_medium_cpu_util_threads");
		aListJvmParam.add("pct_high_cpu_util_threads");
		aListJvmParam.add("service_url_path");


		ArrayList aListJvmLogParam = new ArrayList();
		aListJvmLogParam.add("jrehome");
		aListJvmLogParam.add("logfilename");

		ArrayList aListJvmWarParam = new ArrayList();
		aListJvmWarParam.add("ssl");
		aListJvmWarParam.add("url");
		aListJvmWarParam.add("username");
		aListJvmWarParam.add("password");
		aListJvmWarParam.add("encryptpass");

		ArrayList aListJvmSnmpV1V2Param = new ArrayList();
		aListJvmSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListJvmSnmpV3Param = new ArrayList();
		aListJvmSnmpV3Param.add("username");
		aListJvmSnmpV3Param.add("authpass");
		aListJvmSnmpV3Param.add("authtype");
		aListJvmSnmpV3Param.add("encryptflag");
		aListJvmSnmpV3Param.add("encrypttype");
		aListJvmSnmpV3Param.add("encryptpassword");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both jmx and snmp
		aListCommonParams.add("profiler_home");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newModeTypeValue = "";
		if (hasModeType)
		{
			tempIdx = newValueLowerCase.indexOf("-mode_type")+1;
			tempValue = newValue.substring(tempIdx);
			newModeTypeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newModeTypeValue = newModeTypeValue.trim();
		}
		String newModeValue = "";
		if (newValueLowerCase.indexOf(" -mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-mode")+1;
			tempValue = newValue.substring(tempIdx);
			newModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newModeValue = newModeValue.trim();
		}

		//retreving the snmpversion value
		String newSnmpVersion = "";
		if (newValueLowerCase.indexOf(" -snmpversion ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-snmpversion")+1;
			tempValue = newValue.substring(tempIdx);
			newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newSnmpVersion = newSnmpVersion.trim();
		}

		//retreving the profiler value if exist
		String newProfilerValue = "";
		if (newValueLowerCase.indexOf(" -profiler ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -profiler ")+1;
			tempValue = newValue.substring(tempIdx);
			newProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newProfilerValue = newProfilerValue.trim();
		}

		//retreving the measure mode value
		String newMeasureModeValue = "";
		if (newValueLowerCase.indexOf(" -measure_mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-measure_mode")+1;
			tempValue = newValue.substring(tempIdx);
			newMeasureModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newMeasureModeValue = newMeasureModeValue.trim();
		}

		//retreving the measurement mode value
		String newMeasurementModeValue = "";
		if (newValueLowerCase.indexOf(" -measurement_mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-measurement_mode")+1;
			tempValue = newValue.substring(tempIdx);
			newMeasurementModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newMeasurementModeValue = newMeasurementModeValue.trim();
		}

		String oldModeValue = "";
		String oldMeasureModeValue = "";
		String oldMeasurementModeValue = "";
		String oldSnmpVersion = "";
		String oldProfilerValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasMeasureMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-measure_mode")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldMeasureModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldMeasureModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldMeasureModeValue = oldMeasureModeValue.trim();
			}

			//retreving the measurement mode value
			if (hasMeasurementMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-measurement_mode")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldMeasurementModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldMeasurementModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldMeasurementModeValue = oldMeasurementModeValue.trim();
			}

			//retreving the mode value
			tempIdx = oldValueLowerCase.indexOf("-mode")+1;
			tempValue = oldValue.substring(tempIdx);
			if (tempValue.indexOf("-") != -1)
			{
				oldModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			}
			else
			{
				oldModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
			}
			oldModeValue = oldModeValue.trim();

			//retreving the snmpversion value
			tempIdx = oldValueLowerCase.indexOf("-snmpversion")+1;
			tempValue = oldValue.substring(tempIdx);
			oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			oldSnmpVersion = oldSnmpVersion.trim();

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -profiler ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -profiler ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldProfilerValue = oldProfilerValue.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (hasMeasureMode)
				{
					if (newMeasureModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //logFile
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}
				else if (hasMeasurementMode)
				{
					if (newMeasurementModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //warFile
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}
				else
				{
					if (newModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else//snmp
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}

						if (newSnmpVersion.equalsIgnoreCase("v1") || 
							newSnmpVersion.equalsIgnoreCase("v2"))
						{
							if (aListJvmSnmpV3Param.contains(tmpVarLowerCase))
							{
								continue;
							}
						}
						else//v3
						{
							if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase))
							{
								continue;
							}
						}
					}

					if (newProfilerValue.equalsIgnoreCase("false") && 
						tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
					{
						continue;
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else//snmp
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}

						if (oldSnmpVersion.equalsIgnoreCase("v1") || 
							oldSnmpVersion.equalsIgnoreCase("v2"))
						{
							if (aListJvmSnmpV3Param.contains(tmpVarLowerCase)) continue;
						}
						else//v3
						{
							if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
						}
					}

					if (newProfilerValue.equalsIgnoreCase("false") && 
						tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
					{
						continue;
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForABAPComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasUseSapControl = (oldValue.indexOf("-use_sapcontrol") > -1);

		ArrayList aListOsUserParam = new ArrayList();
		aListOsUserParam.add("os_username");
		aListOsUserParam.add("os_password");
		aListOsUserParam.add("ssl");
		aListOsUserParam.add("wsdl_port");

		ArrayList aListSapUserParam = new ArrayList();
		aListSapUserParam.add("timeout");
		aListSapUserParam.add("sapuser");
		aListSapUserParam.add("sysno");
		aListSapUserParam.add("clientname");
		aListSapUserParam.add("router");
		aListSapUserParam.add("password");
		aListSapUserParam.add("Jco_version");
		aListSapUserParam.add("instancename");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both SAP control yes and no
		aListCommonParams.add("ddFreq");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newUseSAPControlValue = "";
		if (newValueLowerCase.indexOf(" -use_sapcontrol ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-use_sapcontrol")+1;
			tempValue = newValue.substring(tempIdx);
			newUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newUseSAPControlValue = newUseSAPControlValue.trim();
		}

		//retreving the profiler value if exist
		String newDDFreqValue = "";
		if (newValueLowerCase.indexOf(" -ddFreq ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -ddFreq ")+1;
			tempValue = newValue.substring(tempIdx);
			newDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newDDFreqValue = newDDFreqValue.trim();
		}

		String oldUseSAPControlValue = "";
		String oldDDFreqValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasUseSapControl)
			{
				tempIdx = oldValueLowerCase.indexOf("-use_sapcontrol")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldUseSAPControlValue = oldUseSAPControlValue.trim();
			}

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -ddFreq ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -ddFreq ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldDDFreqValue = oldDDFreqValue.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (hasUseSapControl)
				{
					if (newUseSAPControlValue.equalsIgnoreCase("false"))//SAP control false
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //SAP control true
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldUseSAPControlValue.equalsIgnoreCase("false"))//SAP control false
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForABAPSystemComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);
		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();
		boolean hasAppServerMode = (oldValue.indexOf("-Connection_type") > -1);

		ArrayList aListAPIModeParam = new ArrayList();
		aListAPIModeParam.add("application_server");
		aListAPIModeParam.add("sysno");

		ArrayList aListDatabaseParam = new ArrayList();
		aListDatabaseParam.add("message_server");
		aListDatabaseParam.add("logon_group");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both SAP control yes and no
		aListCommonParams.add("ddFreq");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newAPIModeControlValue = "";
		if (newValueLowerCase.indexOf(" -connection_type ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-connection_type")+1;
			tempValue = newValue.substring(tempIdx);
			newAPIModeControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newAPIModeControlValue = newAPIModeControlValue.trim();
		}

		//retreving the profiler value if exist
		String newDDFreqValue = "";
		if (newValueLowerCase.indexOf(" -ddFreq ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -ddFreq ")+1;
			tempValue = newValue.substring(tempIdx);
			newDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newDDFreqValue = newDDFreqValue.trim();
		}

		String oldAPIModeControlValue = "";
		String oldDDFreqValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasAppServerMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-connection_type")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldAPIModeControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldAPIModeControlValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldAPIModeControlValue = oldAPIModeControlValue.trim();
			}

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -ddFreq ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -ddFreq ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldDDFreqValue = oldDDFreqValue.trim();
			}
		}
		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}
			if (tmpVal.startsWith("$"))
			{
				if (hasAppServerMode)
				{
					if (!newAPIModeControlValue.equalsIgnoreCase("application_server"))//API control false
					{
						if (!aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //API control true
					{
						if (aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (!oldAPIModeControlValue.equalsIgnoreCase("application_server"))//API control false
					{
						if (!aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else
					{
						if (aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}
		return result;
	}

	private String doProperUpdateForHorzPodEvtTest(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);
		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasUseAPIMode = (oldValue.indexOf("-Using_Horizon_API") > -1);

		ArrayList aListAPIModeParam = new ArrayList();
		aListAPIModeParam.add("Connection_server_name");
		aListAPIModeParam.add("Domain_name");
		aListAPIModeParam.add("User_name");
		aListAPIModeParam.add("Password");

		ArrayList aListDatabaseParam = new ArrayList();
		aListDatabaseParam.add("databasetype");
		aListDatabaseParam.add("databaseserver");
		aListDatabaseParam.add("eventsdatabasename");
		aListDatabaseParam.add("eventstablename");
		aListDatabaseParam.add("instance");
		aListDatabaseParam.add("databaseport");
		aListDatabaseParam.add("domain");
		aListDatabaseParam.add("user");
		aListDatabaseParam.add("password");
		aListDatabaseParam.add("ssl");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both SAP control yes and no
		aListCommonParams.add("ddFreq");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newAPIModeControlValue = "";
		if (newValueLowerCase.indexOf(" -using_horizon_api ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-using_horizon_api")+1;
			tempValue = newValue.substring(tempIdx);
			newAPIModeControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newAPIModeControlValue = newAPIModeControlValue.trim();
		}

		//retreving the profiler value if exist
		String newDDFreqValue = "";
		if (newValueLowerCase.indexOf(" -ddFreq ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -ddFreq ")+1;
			tempValue = newValue.substring(tempIdx);
			newDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newDDFreqValue = newDDFreqValue.trim();
		}

		String oldAPIModeControlValue = "";
		String oldDDFreqValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasUseAPIMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-using_horizon_api")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldAPIModeControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldAPIModeControlValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldAPIModeControlValue = oldAPIModeControlValue.trim();
			}

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -ddFreq ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -ddFreq ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldDDFreqValue = oldDDFreqValue.trim();
			}
		}
		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}
			if (tmpVal.startsWith("$"))
			{
				if (hasUseAPIMode)
				{
					if (newAPIModeControlValue.equalsIgnoreCase("false"))//API control false
					{
						if (!aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //API control true
					{
						if (aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}
				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldAPIModeControlValue.equalsIgnoreCase("false"))//API control false
					{
						if (!aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else
					{
						if (aListDatabaseParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}
		return result;
	}

	private String doProperUpdateForSAPWebDispComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasUseSapControl = (oldValue.indexOf("-data_collection_mode") > -1);

		ArrayList aListOsUserParam = new ArrayList();
		aListOsUserParam.add("os_username");
		aListOsUserParam.add("os_password");
		aListOsUserParam.add("ssl");
		aListOsUserParam.add("wsdl_port");

		ArrayList aListSapUserParam = new ArrayList();
		aListSapUserParam.add("web_dispatcher_dir");
		aListSapUserParam.add("profile_file");
		aListSapUserParam.add("timeout(seconds)");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both SAP control yes and no
		aListCommonParams.add("ddFreq");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newUseSAPControlValue = "";
		if (newValueLowerCase.indexOf(" -data_collection_mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-data_collection_mode")+1;
			tempValue = newValue.substring(tempIdx);
			newUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newUseSAPControlValue = newUseSAPControlValue.trim();
		}

		//retreving the profiler value if exist
		String newDDFreqValue = "";
		if (newValueLowerCase.indexOf(" -ddFreq ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -ddFreq ")+1;
			tempValue = newValue.substring(tempIdx);
			newDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newDDFreqValue = newDDFreqValue.trim();
		}

		String oldUseSAPControlValue = "";
		String oldDDFreqValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasUseSapControl)
			{
				tempIdx = oldValueLowerCase.indexOf("-data_collection_mode")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldUseSAPControlValue = oldUseSAPControlValue.trim();
			}

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -ddFreq ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -ddFreq ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldDDFreqValue = oldDDFreqValue.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (hasUseSapControl)
				{
					if (newUseSAPControlValue.equalsIgnoreCase("sapcontrol"))//SAP control false
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //SAP control true
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldUseSAPControlValue.equalsIgnoreCase("sapcontrol"))//SAP control false
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = encryptParam;
		if (!isNumber(decryptParam))
		{
			decryptParam = EgCrypt.decrypt(decryptParam);
		}
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}

	private String updateValuesCs(String newValue, String oldValue)
	{
		ArrayList newTokenList = getParameterList(newValue,false);
		ArrayList oldTokenList = getParameterList(oldValue,false);
		int n_size = newTokenList.size();
		int o_size = oldTokenList.size();
		String fst_val = (String) newTokenList.get(0);
		StringBuffer sb = new StringBuffer();
		String paramStr = fst_val + " ";
		sb.append(paramStr);
		for (int i=1; i<n_size-1; i=i+2)
		{
			String newParamName = (String) newTokenList.get(i);
			String newParamVal = (String) newTokenList.get(i+1);
			if (newParamName.equals("-correct"))
			{
				if (oldTokenList.contains(newParamName))
				{
					int idx = oldTokenList.indexOf(newParamName);
					String oldParamVal = (String) oldTokenList.get(idx+1);
					newParamVal = oldParamVal;
				}
			}
			else if (newParamName.equals("-alarmtype"))
			{
				if (oldTokenList.contains(newParamName))
				{
					int idx = oldTokenList.indexOf(newParamName);
					String oldParamVal = (String) oldTokenList.get(idx+1);
					newParamVal = oldParamVal;
				}
			}
			else if (newParamName.equals("-userparams"))
			{
				if (oldTokenList.contains(newParamName))
				{
					int idx = oldTokenList.indexOf(newParamName);
					String oldParamVal = (String) oldTokenList.get(idx+1);
					newParamVal = oldParamVal;
				}
			}
			else if (newParamName.equals("-correctivescript"))
			{
				if (oldTokenList.contains(newParamName))
				{
					int idx = oldTokenList.indexOf(newParamName);
					String oldParamVal = (String) oldTokenList.get(idx+1);
					newParamVal = oldParamVal;
				}
			}
			paramStr = "" + newParamName + " " + newParamVal + " ";
			sb.append(paramStr);
		}
		String lst_val = (String) newTokenList.get(n_size-1);
		sb.append(lst_val);
		String val = sb.toString();
		return val;
	}

	private void updateMgrMiscFile(Hashtable resultData)
	{
		Hashtable deleteHash = new Hashtable();
		Hashtable addHash = new Hashtable();
		String subject = "ASSOCIATED_CORRECTIVE_SCRIPTS";
		IniFile mgrMiscObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
		boolean saveFile = false;
		
		Set set = resultData.entrySet();
		Iterator it = set.iterator();
		
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();
			String key = (String) me.getKey();
			String value = (String)  me.getValue();
			
			ArrayList aListToken = new ArrayList();
			StringTokenizer strTokenizer = new StringTokenizer(value," ");
			while (strTokenizer.hasMoreTokens())
			{
				String strToken = strTokenizer.nextToken();
				aListToken.add(strToken);
			}
			String correctivescriptFile = "";
			int listTokenSize = aListToken.size();
			for (int i=1; i<listTokenSize-1; i=i+2)
			{
				String parameterName = (String) aListToken.get(i);
				String parameterVal = (String) aListToken.get(i+1);

				if (parameterName.equals("-correctivescript"))
				{
					correctivescriptFile = parameterVal;
				}
			}
			if (correctivescriptFile.indexOf("#") > -1)
			{
				correctivescriptFile = correctivescriptFile.replace("#",",");
			}
			else if (correctivescriptFile.indexOf("|") > -1)
			{
				correctivescriptFile = correctivescriptFile.replace("|",",");
			}
			ArrayList correctiveScriptFileList = new ArrayList();
			if (!StringUtils.isNull(correctivescriptFile) && !correctivescriptFile.equals("none"))
			{
				if (correctivescriptFile.indexOf(",") == -1)
				{
					correctiveScriptFileList.add(correctivescriptFile);
				}
				else
				{
					ArrayList correctiveScriptList = StringUtils.egTokenizer(correctivescriptFile,",");
					if (correctiveScriptList != null)
					{
						int csSize = correctiveScriptList.size();
						for (int s=0;s<csSize;s++)
						{
							String strFileName = (String) correctiveScriptList.get(s);
							correctiveScriptFileList.add(strFileName);
						}
					}
				}
				if (correctiveScriptFileList != null)
				{
					String defaultVariable = "";
					int csFileSize = correctiveScriptFileList.size();
					for (int t=0; t<csFileSize; t++)
					{
						String strScriptFileName = (String) correctiveScriptFileList.get(t);
						String testNameSubStr = "";
						String measureName = "";
						int indexValue = strScriptFileName.indexOf("_");
						if (indexValue != -1)
						{
							int strLength = strScriptFileName.length();
							testNameSubStr = strScriptFileName.substring(0, indexValue);
							String measureNameSubStr = strScriptFileName.substring(indexValue+1, strLength);
							int indexValueId = measureNameSubStr.indexOf(".");
							if (indexValueId != -1)
							{
								measureName = measureNameSubStr.substring(0, indexValueId);
							}
						}
						else
						{
							int indexVal =  strScriptFileName.indexOf(".");
							testNameSubStr = strScriptFileName.substring(0, indexVal);
						}
						String strVariable = "";
						String strValueForVar = "";
						String agentOS = key.substring(key.lastIndexOf(":")+1);
						//defaultVariable =  componentType + ":" + componentName + ":" +agentOS+ ":" + testNameSubStr ;
						defaultVariable = key + ":" + testNameSubStr ;
						if (!StringUtils.isNull(measureName))
						{
							strVariable = defaultVariable + ":" + measureName;
							strValueForVar = agentOS+ ":" + testNameSubStr + ":" + measureName +":"+strScriptFileName;
						}
						else
						{
							strVariable = defaultVariable;
							strValueForVar = agentOS+ ":" + testNameSubStr + ":" +strScriptFileName;
						}
						
						Vector valVar = (Vector) addHash.get(subject);
						if(valVar != null)
						{
							Vector _vars  = (Vector)valVar.get(0);
							Vector _vals  = (Vector)valVar.get(1);

							_vars.add(strVariable);
							_vals.add(strValueForVar);
						}
						else
						{
							Vector varss = new Vector();
							Vector valss = new Vector();
							varss.add(strVariable);
							valss.add(strValueForVar);

							valVar = new Vector();
							valVar.add(varss);
							valVar.add(valss);
							addHash.put(subject,valVar);
						}
					}
					String[] allVariablesArr = mgrMiscObj.getVariables(subject);
					Vector variablesVector = new Vector();
					if (allVariablesArr != null)
					{
						int allVarsSize = allVariablesArr.length;
						for (int v=0; v<allVarsSize; v++)
						{
							String miscFileVariable = (String) allVariablesArr[v];
							if (miscFileVariable.startsWith(defaultVariable))
							{
								Vector varr = (Vector) deleteHash.get(subject);
								if (varr == null)
								{
									varr = new Vector();
								}
								varr.add(miscFileVariable);
								deleteHash.put(subject,varr);
							}
						}
					}
				}
			}
		}
		
		if(!deleteHash.isEmpty())
		{
			try
			{
				if (deleteHash.size() > 0)
				{
					Enumeration ee = deleteHash.keys();
					while (ee.hasMoreElements())
					{
						String key = (String) ee.nextElement();
						Vector vars = (Vector)deleteHash.get(key);
						if (vars != null && vars.size() > 0)
						{
							mgrMiscObj.deleteValues(key, vars);
							saveFile = true;
						}
					}
				}
			}
			catch(Exception exc)
			{
				//ex.printStackTrace();
			}
		}

		if(!addHash.isEmpty())
		{
			try
			{
				Iterator itr = addHash.entrySet().iterator();
				while(itr.hasNext())
				{
					Entry entry = (Entry)itr.next();
					String sub = (String)entry.getKey();
					Vector varVals = (Vector)entry.getValue();
					Vector _vars  = (Vector)varVals.get(0);
					Vector _vals  = (Vector)varVals.get(1);
					mgrMiscObj.setValues(sub, _vars, _vals,false);
					saveFile = true;
				}									
			}
			catch(Exception exc)
			{
				//exc.printStackTrace();
			}
		}
		
		if (saveFile)
		{
			mgrMiscObj.saveFile();
		}
		EgConfigFilesSync.releaseInstance(mgrMiscObj);
	}

	private void updateMgrMiscFile(String value, String agentOS, String componentType, String componentName)
	{
		ArrayList aListToken = new ArrayList();
		StringTokenizer strTokenizer = new StringTokenizer(value," ");
		while (strTokenizer.hasMoreTokens())
		{
			String strToken = strTokenizer.nextToken();
			aListToken.add(strToken);
		}
		String correctivescriptFile = "";
		int listTokenSize = aListToken.size();
		for (int i=1; i<listTokenSize-1; i=i+2)
		{
			String parameterName = (String) aListToken.get(i);
			String parameterVal = (String) aListToken.get(i+1);

			if (parameterName.equals("-correctivescript"))
			{
				correctivescriptFile = parameterVal;
			}
		}
		if (correctivescriptFile.indexOf("#") > -1)
		{
			correctivescriptFile = correctivescriptFile.replace("#",",");
		}
		else if (correctivescriptFile.indexOf("|") > -1)
		{
			correctivescriptFile = correctivescriptFile.replace("|",",");
		}
		ArrayList correctiveScriptFileList = new ArrayList();
		if (!StringUtils.isNull(correctivescriptFile) && !correctivescriptFile.equals("none"))
		{
			if (correctivescriptFile.indexOf(",") == -1)
			{
				correctiveScriptFileList.add(correctivescriptFile);
			}
			else
			{
				ArrayList correctiveScriptList = StringUtils.egTokenizer(correctivescriptFile,",");
				if (correctiveScriptList != null)
				{
					int csSize = correctiveScriptList.size();
					for (int s=0;s<csSize;s++)
					{
						String strFileName = (String) correctiveScriptList.get(s);
						correctiveScriptFileList.add(strFileName);
					}
				}
			}
			if (correctiveScriptFileList != null)
			{
				IniFile mgrMiscObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
				Vector allVariablesVec = new Vector();
				Vector allValuesVec = new Vector();
				String defaultVariable = "";
				int csFileSize = correctiveScriptFileList.size();
				for (int t=0; t<csFileSize; t++)
				{
					String strScriptFileName = (String) correctiveScriptFileList.get(t);
					String testNameSubStr = "";
					String measureName = "";
					int indexValue = strScriptFileName.indexOf("_");
					if (indexValue != -1)
					{
						int strLength = strScriptFileName.length();
						testNameSubStr = strScriptFileName.substring(0, indexValue);
						String measureNameSubStr = strScriptFileName.substring(indexValue+1, strLength);
						int indexValueId = measureNameSubStr.indexOf(".");
						if (indexValueId != -1)
						{
							measureName = measureNameSubStr.substring(0, indexValueId);
						}
					}
					else
					{
						int indexVal =  strScriptFileName.indexOf(".");
						testNameSubStr = strScriptFileName.substring(0, indexVal);
					}
					String strVariable = "";
					String strValueForVar = "";
					defaultVariable =  componentType + ":" + componentName + ":" +agentOS+ ":" + testNameSubStr ;
					if (!StringUtils.isNull(measureName))
					{
						strVariable = defaultVariable + ":" + measureName;
						strValueForVar = agentOS+ ":" + testNameSubStr + ":" + measureName +":"+strScriptFileName;
					}
					else
					{
						strVariable = defaultVariable;
						strValueForVar = agentOS+ ":" + testNameSubStr + ":" +strScriptFileName;
					}
					allVariablesVec.add(strVariable);
					allValuesVec.add(strValueForVar);
				}
				String[] allVariablesArr = mgrMiscObj.getVariables("ASSOCIATED_CORRECTIVE_SCRIPTS");
				Vector variablesVector = new Vector();
				if (allVariablesArr != null)
				{
					int allVarsSize = allVariablesArr.length;
					for (int v=0; v<allVarsSize; v++)
					{
						String miscFileVariable = (String) allVariablesArr[v];
						if (miscFileVariable.startsWith(defaultVariable))
						{
							variablesVector.add(miscFileVariable);
						}
					}
				}
				if (variablesVector != null && variablesVector.size() > 0)
				{
					mgrMiscObj.deleteValues ("ASSOCIATED_CORRECTIVE_SCRIPTS", variablesVector);
				}
				if (allVariablesVec != null && allVariablesVec.size() > 0)
				{
					mgrMiscObj.setValues("ASSOCIATED_CORRECTIVE_SCRIPTS", allVariablesVec, allValuesVec, false);
				}
				mgrMiscObj.saveFile();
				EgConfigFilesSync.releaseInstance(mgrMiscObj);
			}
		}
	}

	private ArrayList getConfigurableTests(EgSpecsInfo egSpecs, ArrayList aListEnabledTestForCompType)
	{
		ArrayList aListConfigurableTest = new ArrayList();

		String testName = "";
		if (aListEnabledTestForCompType != null && aListEnabledTestForCompType.size() > 0)
		{
			testName = aListEnabledTestForCompType.get(0).toString();
		}

		//code to get test relations from eg_testparam.ini starts here
		egurkha.EgTestParamBean prgBean = new egurkha.EgTestParamBean();
		prgBean.createFile("eg_testparam.ini");

		String testRelationVariables[] = prgBean.getVariables("TEST_RELATIONS");
		String testRelation = prgBean.getStrValue("TEST_RELATIONS",testName);
		ArrayList aListRelationTests = new ArrayList();

		if (!testRelation.equals("") && testRelation.length() > 0)
		{
			aListRelationTests.add(testName);
			aListRelationTests.addAll(getArrayList(testRelation,","));
		}
		else if (testRelation.equals("") && testRelation.length() == 0)
		{
			aListRelationTests.add(testName);
		}

		if (aListEnabledTestForCompType != null)
		{
			for(int k=0;k<aListRelationTests.size();k++)
			{
				String strTestName = (String)aListRelationTests.get(k);
				if (aListEnabledTestForCompType.contains(strTestName))
				{
					aListConfigurableTest.add(strTestName);
				}
			}
		}
		return aListConfigurableTest;
	}

	private void updateSpecsValues(ArrayList typeList, String ipAddress, String values, String from, boolean isConfigSupported)
	{
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		ArrayList aListConfigurableTest = null;
		ArrayList aListEnabledTestForCompType = null;

		StringTokenizer st = new StringTokenizer(values, "#"); //ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();
		String domain = "";

		if(from.startsWith("rhev"))
		{
			domain = st.nextToken();
		}
		String specsFile = "eg_specs.ini";
		String specsFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";

		IniFile specsIniFile = EgConfigFilesSync.getInstance(specsFile_dir + specsFile,true);
		
		for(int h=0;h<typeList.size();h++)
		{
			String componentType = (String) typeList.get(h);

			if (isConfigSupported)
			{
				aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
				aListEnabledTestForCompType.addAll(egSpecs.getEnabledTests(componentType,true));
			}
			else
			{
				aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
			}

			aListConfigurableTest = getConfigurableTests(egSpecs,aListEnabledTestForCompType);
			if(aListConfigurableTest != null && aListConfigurableTest.size()>0)
			{
				for(int i=0;i<aListConfigurableTest.size();i++)
				{
					String strTestName = ((String)aListConfigurableTest.get(i)).trim();
					String patternA = strTestName + ":" + componentType + ":" + "$hostName:$portNo";
					String patternB = strTestName + ":" + componentType + ":" + "$hostName";
					String patternC = strTestName + "::" + "$hostName" + ":$portNo";
					String patternD = strTestName + "::" + "$hostName";

					List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
					String resultantPattern = "";
					if (listSpecficationVariables.contains(patternA))
					{
						resultantPattern = patternA;
					}
					else if (listSpecficationVariables.contains(patternB))
					{
						resultantPattern = patternB;
					}
					else if (listSpecficationVariables.contains(patternC))
					{
						resultantPattern = patternC;
					}
					else if (listSpecficationVariables.contains(patternD))
					{
						resultantPattern = patternD;
					}

					if (resultantPattern.equals("")) continue;

					String value = egSpecs.getArgsForTest(resultantPattern);
					if (from.startsWith("hmc"))
					{
						int hmcIndex = value.toLowerCase().indexOf("-hmc_server");
						if (hmcIndex > -1)
						{
							String tmpStr1 = value.substring(0,hmcIndex + "-hmc_server".length()).trim();
							String tmpStr2 = value.substring(hmcIndex + "-hmc_server".length() +1).trim();
							String hmc_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
							if (hmc_server.equals(ipAddress))
							{
								int esxUserIndex = value.toLowerCase().indexOf("-hmc_user");
								if (esxUserIndex > -1)
								{
									tmpStr1 = value.substring(0,esxUserIndex + "-hmc_user".length()).trim();
									tmpStr2 = value.substring(esxUserIndex + "-hmc_user".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UName+ " "+tmpStr2;
								}

								int esxPwdIndex = value.toLowerCase().indexOf("-hmc_password");
								if(esxPwdIndex > -1)
								{
									tmpStr1 = value.substring(0,esxPwdIndex + "-hmc_password".length()).trim();
									tmpStr2 = value.substring(esxPwdIndex + "-hmc_password".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UPass+ " "+tmpStr2;
								}
								int sslIndex = value.toLowerCase().indexOf("-ssl");
								if (sslIndex > -1)
								{
									tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
									tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
								}
								specsIniFile.setValue(EgSpecsInfo.testSpecSection,resultantPattern,value);
							}
						}
					}
					else if(from.startsWith("nutanix"))
					{
						int nutanixIndex = value.toLowerCase().indexOf("-prism_ip");
						if (nutanixIndex > -1)
						{
							String tmpStr1 = value.substring(0,nutanixIndex + "-Prism_IP".length()).trim();
							String tmpStr2 = value.substring(nutanixIndex + "-Prism_IP".length() +1).trim();
							String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
							if (nutanix_server.equals(ipAddress))
							{
								int cvmUserIdx = value.toLowerCase().indexOf("-prism_user");

								if (cvmUserIdx > -1)
								{
									tmpStr1 = value.substring(0,cvmUserIdx + "-prism_user".length()).trim();
									tmpStr2 = value.substring(cvmUserIdx + "-prism_user".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UName+ " "+tmpStr2;
								}
								int cvmPwdIndex = value.toLowerCase().indexOf("-prism_password");
								if(cvmPwdIndex > -1)
								{
									tmpStr1 = value.substring(0,cvmPwdIndex + "-prism_password".length()).trim();
									tmpStr2 = value.substring(cvmPwdIndex + "-prism_password".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UPass+ " "+tmpStr2;
								}
								int sslIndex = value.toLowerCase().indexOf("-ssl");
								if (sslIndex > -1)
								{
									tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
									tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
								}
								specsIniFile.setValue(EgSpecsInfo.testSpecSection,resultantPattern,value);
							}
						}
					}
					else if(from.startsWith("rhev"))
					{
						int hostIdx = value.toLowerCase().indexOf("-rhel_mgr_host");
						if (hostIdx > -1)
						{
							int hostLen = "-Rhel_mgr_host".length();
							String tmpStr1 = value.substring(0,hostIdx + hostLen).trim();
							String tmpStr2 = value.substring(hostIdx + hostLen +1).trim();
							String rhev_host = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
							if (rhev_host.equals(ipAddress))
							{
								int userIdx = value.toLowerCase().indexOf("-rhel_mgr_user");
								if (userIdx > -1)
								{
									int usrLen = "-Rhel_mgr_user".length();
									tmpStr1 = value.substring(0,userIdx + usrLen).trim();
									tmpStr2 = value.substring(userIdx + usrLen +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UName+ " "+tmpStr2;
								}
								int pwdIdx = value.toLowerCase().indexOf("-Rhel_mgr_password");
								if(pwdIdx > -1)
								{
									int pwdLen = "-Rhel_mgr_password".length();
									tmpStr1 = value.substring(0,pwdIdx + pwdLen).trim();
									tmpStr2 = value.substring(pwdIdx + pwdLen +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UPass+ " "+tmpStr2;
								}
								int sslIndex = value.toLowerCase().indexOf("-ssl");
								if (sslIndex > -1)
								{
									tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
									tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
								}
								int webPortIndex = value.toLowerCase().indexOf("-Rhel_mgr_port");
								if(webPortIndex > -1)
								{
									int webportLen = "-Rhel_mgr_port".length();
									tmpStr1 = value.substring(0,webPortIndex + webportLen).trim();
									tmpStr2 = value.substring(webPortIndex + webportLen +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+webPort+ " "+tmpStr2;
								}

								int domainIdx = value.toLowerCase().indexOf("-Rhel_mgr_domain");
								if(domainIdx > -1)
								{
									int domainLen = "-Rhel_mgr_domain".length();
									tmpStr1 = value.substring(0,domainIdx + domainLen).trim();
									tmpStr2 = value.substring(domainIdx + domainLen +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+domain+ " "+tmpStr2;
								}
								specsIniFile.setValue(EgSpecsInfo.testSpecSection,resultantPattern,value);
							}
						}
					}
					else
					{
						int vCenterIndex = value.toLowerCase().indexOf("-virtual_center");
						if (vCenterIndex > -1)
						{
							String tmpStr1 = value.substring(0,vCenterIndex + "-virtual_center".length()).trim();
							String tmpStr2 = value.substring(vCenterIndex + "-virtual_center".length() +1).trim();
							String virtual_center = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
							if (virtual_center.equals(ipAddress))
							{
								int esxUserIndex = value.toLowerCase().indexOf("-esx_user");
								if (esxUserIndex > -1)
								{
									tmpStr1 = value.substring(0,esxUserIndex + "-esx_user".length()).trim();
									tmpStr2 = value.substring(esxUserIndex + "-esx_user".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UName+ " "+tmpStr2;
								}
								int esxPwdIndex = value.toLowerCase().indexOf("-esx_password");
								if(esxPwdIndex > -1)
								{
									tmpStr1 = value.substring(0,esxPwdIndex + "-Esx_password".length()).trim();
									tmpStr2 = value.substring(esxPwdIndex + "-Esx_password".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+UPass+ " "+tmpStr2;
								}
								int sslIndex = value.toLowerCase().indexOf("-ssl");
								if (sslIndex > -1)
								{
									tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
									tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
								}
								int webPortIndex = value.toLowerCase().indexOf("-webport");
								if(webPortIndex > -1)
								{
									tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
									tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
									tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
									value = tmpStr1 + " "+webPort+ " "+tmpStr2;
								}
								specsIniFile.setValue(EgSpecsInfo.testSpecSection,resultantPattern,value);
							}
						}
					}
				}
				specsIniFile.saveFile();
			}
		}
		EgConfigFilesSync.releaseInstance(specsIniFile);
	}

	private HashSet updateNutanixAgentsValues(ArrayList typeList, ArrayList ipAddress, String values, String from, ArrayList exceptEsxList,EgRoleInfo ri, ArrayList aListAgtlessDiscIniEntries)
	{
		Hashtable htableKeyVarVal = new Hashtable();
		String agFile = "eg_agents.ini";
		String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
		IniFile mappingIni = new IniFile(iniFile_dir + "eg_nutanixmapping.ini");

		StringTokenizer st = new StringTokenizer(values, "#"); //ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();
		String domain = "";

		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		ArrayList testEnabled = new ArrayList();
		ArrayList testListForAuditlog = new ArrayList();
		HashSet compListForAuditlog = new HashSet();
		Set agentListForHyperVisorsChange = new HashSet();
		ArrayList listOfComponents = null;

		ArrayList associateCompsList =  new ArrayList();
		for(int i=0;i<ipAddress.size();i++)
		{
			String strIpAddress = (String) ipAddress.get(i);
			String[] associateComps = mappingIni.getVariables(strIpAddress);
			if (associateComps != null && associateComps.length > 0)
			{
				ArrayList tmpCompsList = new ArrayList(Arrays.asList(associateComps));
				associateCompsList.addAll(tmpCompsList);
			}
		}
		boolean isDiscThruNutanixCentral = false;
		ArrayList ntxBaseCompTypes = new ArrayList();
		HashSet ipAddrList = new HashSet();

		IniFile agIniFile = EgConfigFilesSync.getInstance(iniFile_dir + agFile,true);
		for(int h=0;h<typeList.size();h++)
		{
			Hashtable nickAgentMap = new Hashtable();
			String thisType = (String) typeList.get(h);
			listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));
			if (thisType.equalsIgnoreCase("Nutanix_Cluster"))
			{
				isDiscThruNutanixCentral = true;
				ntxBaseCompTypes.add(thisType);
				continue;
			}

			ArrayList associateManagedCompList = new ArrayList();
			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for (int l=0;l<listOfComponents.size();l++)
				{
					String strCompName = listOfComponents.get(l).toString();
					if (exceptEsxList != null && exceptEsxList.contains(strCompName))
					{
						continue;
					}

					if(associateCompsList != null && associateCompsList.contains(strCompName))
					{
						associateManagedCompList.add(strCompName);
					}
				}

				//if (!associateManagedCompList.isEmpty())
				{
					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
			}

			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for(int j=0;j<listOfComponents.size();j++)
				{
					String nickName = (String)listOfComponents.get(j);
					nickName = nickName.substring(nickName.indexOf(":")+1);

					List agentList = getAgents(thisType, nickName);
					if(agentList != null && agentList.size() >0)
					{
						agentListForHyperVisorsChange.addAll(agentList);
						for(int k=0;k<agentList.size();k++)
						{
							ArrayList agentNameList = new ArrayList();
							agentNameList.add(nickName);
							String thisSubject = (String) agentList.get(k);
							if(nickAgentMap.containsKey(thisSubject))
							{
								ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
								if(!lst.contains(nickName))
									lst.add(nickName);
								nickAgentMap.put(thisSubject, lst);
							}
							else
							{
								nickAgentMap.put(thisSubject, agentNameList);
							}
						}
					}
				}
			}

			String[] strTests = egSpecs.getTestsForServer(thisType);
			if (strTests != null && strTests.length > 0)
			{
				testEnabled = new ArrayList(Arrays.asList(strTests));
			}
			
			ArrayList availPatterns = new ArrayList();
			Enumeration ee = nickAgentMap.keys();
			if(from.startsWith("nutanix"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int nutanixIndex = value.toLowerCase().indexOf("-prism_ip");
								if (nutanixIndex > -1)
								{
									String tmpStr1 = value.substring(0,nutanixIndex + "-Prism_IP".length()).trim();
									String tmpStr2 = value.substring(nutanixIndex + "-Prism_IP".length() +1).trim();
									String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									//if (nutanix_server.equals(ipAddress))
									if (ipAddress.contains(nutanix_server))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-prism_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-prism_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-prism_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-prism_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-prism_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-prism_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}

										int webPortIndex = value.toLowerCase().indexOf("-webport");
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
											tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}
										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
		}

		if (isDiscThruNutanixCentral)
		{
			IniFile discIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_discover.ini");
			for(int n=0;n<ntxBaseCompTypes.size();n++)
			{
				Hashtable nickAgentMap = new Hashtable();
				String thisType = (String) ntxBaseCompTypes.get(n);
				String userName = "-nutanix_prism_user";
				String passWord = "-nutanix_prism_password";
				listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));

				ArrayList associateManagedCompList = new ArrayList();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for (int l=0;l<listOfComponents.size();l++)
					{
						String strCompName = listOfComponents.get(l).toString();
						if (exceptEsxList != null && exceptEsxList.contains(strCompName))
						{
							continue;
						}

						//if (associateCompsList != null && associateCompsList.contains(strCompName))
						{
							associateManagedCompList.add(strCompName);
						}
					}

					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
				nickAgentMap = new Hashtable();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for(int j=0;j<listOfComponents.size();j++)
					{
						String nickName = (String)listOfComponents.get(j);
						//String discVal = discIni.getValue(thisType,nickName);
						//String strIPAddress = getValidIPFromNtxCtrlIPMapList(ipAddress,discVal,true);

						nickName = nickName.substring(nickName.indexOf(":")+1);

						List agentList = getAgents(thisType, nickName);
						if(agentList != null && agentList.size() >0)
						{
							agentListForHyperVisorsChange.addAll(agentList);
							for(int k=0;k<agentList.size();k++)
							{
								ArrayList agentNameList = new ArrayList();
								agentNameList.add(nickName);
								String thisSubject = (String) agentList.get(k);
								if(nickAgentMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
									if(!lst.contains(nickName))
										lst.add(nickName);
									nickAgentMap.put(thisSubject, lst);
								}
								else
								{
									nickAgentMap.put(thisSubject, agentNameList);
								}
							}
						}
					}
				}

				String[] strTests = egSpecs.getTestsForServer(thisType);
				if (strTests != null && strTests.length > 0)
				{
					testEnabled = new ArrayList(Arrays.asList(strTests));
				}
				
				ArrayList availPatterns = new ArrayList();
				Enumeration ee = nickAgentMap.keys();
				if(from.startsWith("nutanix"))
				{
					while(ee.hasMoreElements())
					{
						String thisElement = (String) ee.nextElement();
						String [] variables = agIniFile.getVariables(thisElement);
						ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
						for(int j=0;nickList != null && j<nickList.size();j++)
						{
							String thisNick = (String) nickList.get(j);
							for (int k=0;k<testEnabled.size();k++)
							{
								String thisTest = (String) testEnabled.get(k);
								String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);

								if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
								{
									String value = agIniFile.getValue(thisElement,thisPattern);
									int nutanixIndex = value.toLowerCase().indexOf(userName);

									if (nutanixIndex > -1)
									{
										String tmpStr1 = "";//value.substring(0,nutanixIndex + "-host".length()).trim();
										String tmpStr2 = "";//value.substring(nutanixIndex + "-host".length() +1).trim();
										//String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

										String nutanix_server = value.substring(value.indexOf("-host")+5).trim();
										nutanix_server = nutanix_server.substring(0,nutanix_server.indexOf(" ")).trim();

										String agentVarLower = thisPattern.toLowerCase();
										String strIPAddress = getValidIPFromNtxCtrlIPMapList(ipAddress,nutanix_server,false);

										if(agentVarLower.indexOf(":"+strIPAddress.toLowerCase()+":") > 0 || 
										agentVarLower.endsWith(":"+strIPAddress.toLowerCase()) || 
										nutanix_server.equalsIgnoreCase(strIPAddress)) // IP / Host name / Nick , any one equals with Nutanix, then do.
										{
											int esxUserIndex = value.toLowerCase().indexOf(userName);
											if (esxUserIndex > -1)
											{
												tmpStr1 = value.substring(0,esxUserIndex + userName.length()).trim();
												tmpStr2 = value.substring(esxUserIndex + userName.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UName+ " "+tmpStr2;
											}
											int esxPwdIndex = value.toLowerCase().indexOf(passWord);
											if(esxPwdIndex > -1)
											{
												tmpStr1 = value.substring(0,esxPwdIndex + passWord.length()).trim();
												tmpStr2 = value.substring(esxPwdIndex + passWord.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UPass+ " "+tmpStr2;
											}
											int sslIndex = value.toLowerCase().indexOf("-ssl");
											if (sslIndex > -1)
											{
												tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
												tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
											}

											int webPortIndex = value.toLowerCase().indexOf("-webport");
											if(webPortIndex > -1)
											{
												tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
												tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+webPort+ " "+tmpStr2;
											}
											//agIniFile.setValue(thisElement,thisPattern,value);
											Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
											if (vecVarVal == null)
											{
												vecVarVal = new Vector();
												Vector vecVar = new Vector();
												Vector vecVal = new Vector();
												vecVar.add(thisPattern);
												vecVal.add(value);
												vecVarVal.add(vecVar);
												vecVarVal.add(vecVal);
												htableKeyVarVal.put(thisElement,vecVarVal);
											}
											else
											{
												Vector vecVar = (Vector) vecVarVal.get(0);
												Vector vecVal = (Vector) vecVarVal.get(1);
												vecVar.add(thisPattern);
												vecVal.add(value);
											}
											if (!testListForAuditlog.contains(thisTest))
												testListForAuditlog.add(thisTest);

											if (!compListForAuditlog.contains(thisType+":"+thisNick))
												compListForAuditlog.add(thisType+":"+thisNick);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//EgConfigFilesSync.releaseInstance(agIniFile);

		Set set = htableKeyVarVal.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();

			String subject = (String) me.getKey();
			Vector agentIniVarVal = (Vector)  me.getValue();
			Vector agentIniVariable = (Vector)  agentIniVarVal.get(0);
			Vector agentIniValue = (Vector)  agentIniVarVal.get(1);

			if (agentIniVariable != null && agentIniVariable.size() > 0)
			{
				agIniFile.setValues(subject, agentIniVariable, agentIniValue, false);
			}
		}

		agIniFile.saveFile();
		EgConfigFilesSync.releaseInstance(agIniFile);

		if (!agentListForHyperVisorsChange.isEmpty())
		{
			ArrayList hvConfigAgtLst = new ArrayList(agentListForHyperVisorsChange);
			int size = hvConfigAgtLst.size();
			IniFile agtlssIni = new IniFile(iniFile_dir + "eg_agentlessdisc.ini");

			for (int ag=0; ag<size;ag++)
			{
				String agtName = (String) hvConfigAgtLst.get(ag);
				String existValue = agtlssIni.getValue(agtName, from +"#" +ipAddress);
				if (!StringUtils.isNull(existValue))
				{
					String strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase(); //vc & nutanix same format
					if (from.equals("hmc"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+ssl+"~#~"+ipAddress;
					}
					else if (from.equals("rhev"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase()+"~#~"+domain;
					}
					aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,agtName,from +"#" +ipAddress,strPattern));
				}
			}
		}
		return compListForAuditlog;
	}

	private HashSet updateNutanixAgentsValues(ArrayList typeList, String ipAddress, String values, String from, ArrayList exceptEsxList,EgRoleInfo ri, ArrayList aListAgtlessDiscIniEntries, String ntxCtrlSubject)
	{
		Hashtable htableKeyVarVal = new Hashtable();
		String agFile = "eg_agents.ini";
		String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
		IniFile mappingIni = new IniFile(iniFile_dir + "eg_nutanixmapping.ini");

		StringTokenizer st = new StringTokenizer(values, "#"); //ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();
		String domain = "";

		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		ArrayList testEnabled = new ArrayList();
		ArrayList testListForAuditlog = new ArrayList();
		HashSet compListForAuditlog = new HashSet();
		Set agentListForHyperVisorsChange = new HashSet();
		ArrayList listOfComponents = null;

		ArrayList associateCompsList = null;
		String[] associateComps = mappingIni.getVariables(ipAddress);
		if (associateComps != null && associateComps.length > 0)
		{
			associateCompsList = new ArrayList(Arrays.asList(associateComps));
		}

		boolean isNutanixPrismServers = false;
		ArrayList ntxBaseCompTypes = new ArrayList();
		HashSet ipAddrList = new HashSet();

		IniFile agIniFile = EgConfigFilesSync.getInstance(iniFile_dir + agFile,true);
		for(int h=0;h<typeList.size();h++)
		{
			Hashtable nickAgentMap = new Hashtable();
			String thisType = (String) typeList.get(h);
			listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));
			if (thisType.equalsIgnoreCase("Nutanix_Prism_Center") || thisType.equalsIgnoreCase("Nutanix_Cluster"))
			{
				isNutanixPrismServers = true;
				ntxBaseCompTypes.add(thisType);
				continue;
			}

			ArrayList associateManagedCompList = new ArrayList();
			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for (int l=0;l<listOfComponents.size();l++)
				{
					String strCompName = listOfComponents.get(l).toString();
					if (exceptEsxList != null && exceptEsxList.contains(strCompName))
					{
						continue;
					}

					if(associateCompsList != null && associateCompsList.contains(strCompName))
					{
						associateManagedCompList.add(strCompName);
					}
				}

				//if (!associateManagedCompList.isEmpty())
				{
					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
			}

			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for(int j=0;j<listOfComponents.size();j++)
				{
					String nickName = (String)listOfComponents.get(j);
					nickName = nickName.substring(nickName.indexOf(":")+1);

					List agentList = getAgents(thisType, nickName);
					if(agentList != null && agentList.size() >0)
					{
						agentListForHyperVisorsChange.addAll(agentList);
						for(int k=0;k<agentList.size();k++)
						{
							ArrayList agentNameList = new ArrayList();
							agentNameList.add(nickName);
							String thisSubject = (String) agentList.get(k);
							if(nickAgentMap.containsKey(thisSubject))
							{
								ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
								if(!lst.contains(nickName))
									lst.add(nickName);
								nickAgentMap.put(thisSubject, lst);
							}
							else
							{
								nickAgentMap.put(thisSubject, agentNameList);
							}
						}
					}
				}
			}

			String[] strTests = egSpecs.getTestsForServer(thisType);
			if (strTests != null && strTests.length > 0)
			{
				testEnabled = new ArrayList(Arrays.asList(strTests));
			}
			
			ArrayList availPatterns = new ArrayList();
			Enumeration ee = nickAgentMap.keys();
			if(from.startsWith("nutanix"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int nutanixIndex = value.toLowerCase().indexOf("-prism_ip");
								if (nutanixIndex > -1)
								{
									String tmpStr1 = value.substring(0,nutanixIndex + "-Prism_IP".length()).trim();
									String tmpStr2 = value.substring(nutanixIndex + "-Prism_IP".length() +1).trim();
									String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (nutanix_server.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-prism_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-prism_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-prism_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-prism_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-prism_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-prism_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}

										int webPortIndex = value.toLowerCase().indexOf("-webport");
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
											tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}
										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
		}

		if (isNutanixPrismServers)
		{
			//associateManagedCompList = new ArrayList();
			for(int n=0;n<ntxBaseCompTypes.size();n++)
			{
				Hashtable nickAgentMap = new Hashtable();
				String thisType = (String) ntxBaseCompTypes.get(n);
				String userName = "-nutanix_prism_user";
				String passWord = "-nutanix_prism_password";
				if (thisType.equalsIgnoreCase("Nutanix_Prism_Center"))
				{
					userName = "-nutanix_prism_center_user";
					passWord = "-nutanix_prism_center_password";
				}
				else
				{
					ntxCtrlSubject = ipAddress;
				}
				listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));

				ArrayList associateManagedCompList = new ArrayList();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for (int l=0;l<listOfComponents.size();l++)
					{
						String strCompName = listOfComponents.get(l).toString();
						if (exceptEsxList != null && exceptEsxList.contains(strCompName))
						{
							continue;
						}

						//if (associateCompsList != null && associateCompsList.contains(strCompName))
						{
							associateManagedCompList.add(strCompName);
						}
					}

					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
				nickAgentMap = new Hashtable();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for(int j=0;j<listOfComponents.size();j++)
					{
						String nickName = (String)listOfComponents.get(j);
						nickName = nickName.substring(nickName.indexOf(":")+1);

						List agentList = getAgents(thisType, nickName);
						if(agentList != null && agentList.size() >0)
						{
							agentListForHyperVisorsChange.addAll(agentList);
							for(int k=0;k<agentList.size();k++)
							{
								ArrayList agentNameList = new ArrayList();
								agentNameList.add(nickName);
								String thisSubject = (String) agentList.get(k);
								if(nickAgentMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
									if(!lst.contains(nickName))
										lst.add(nickName);
									nickAgentMap.put(thisSubject, lst);
								}
								else
								{
									nickAgentMap.put(thisSubject, agentNameList);
								}
							}
						}
					}
				}

				String[] strTests = egSpecs.getTestsForServer(thisType);
				if (strTests != null && strTests.length > 0)
				{
					testEnabled = new ArrayList(Arrays.asList(strTests));
				}
				
				ArrayList availPatterns = new ArrayList();
				Enumeration ee = nickAgentMap.keys();
				if(from.startsWith("nutanix"))
				{
					while(ee.hasMoreElements())
					{
						String thisElement = (String) ee.nextElement();
						String [] variables = agIniFile.getVariables(thisElement);
						ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
						for(int j=0;nickList != null && j<nickList.size();j++)
						{
							String thisNick = (String) nickList.get(j);
							for (int k=0;k<testEnabled.size();k++)
							{
								String thisTest = (String) testEnabled.get(k);
								String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);

								if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
								{
									String value = agIniFile.getValue(thisElement,thisPattern);
									int nutanixIndex = value.toLowerCase().indexOf(userName);

									if (nutanixIndex > -1)
									{
										String tmpStr1 = "";//value.substring(0,nutanixIndex + "-host".length()).trim();
										String tmpStr2 = "";//value.substring(nutanixIndex + "-host".length() +1).trim();
										//String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

										String nutanix_server = value.substring(value.indexOf("-host")+5).trim();
										nutanix_server = nutanix_server.substring(0,nutanix_server.indexOf(" ")).trim();
										String agentVarLower = thisPattern.toLowerCase();

										if(agentVarLower.indexOf(":"+ntxCtrlSubject.toLowerCase()+":") > 0 || 
										agentVarLower.endsWith(":"+ntxCtrlSubject.toLowerCase()) || 
										nutanix_server.equalsIgnoreCase(ntxCtrlSubject)) // IP / Host name / Nick , any one equals with Nutanix, then do.
										{
											int esxUserIndex = value.toLowerCase().indexOf(userName);
											if (esxUserIndex > -1)
											{
												tmpStr1 = value.substring(0,esxUserIndex + userName.length()).trim();
												tmpStr2 = value.substring(esxUserIndex + userName.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UName+ " "+tmpStr2;
											}
											int esxPwdIndex = value.toLowerCase().indexOf(passWord);
											if(esxPwdIndex > -1)
											{
												tmpStr1 = value.substring(0,esxPwdIndex + passWord.length()).trim();
												tmpStr2 = value.substring(esxPwdIndex + passWord.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UPass+ " "+tmpStr2;
											}
											int sslIndex = value.toLowerCase().indexOf("-ssl");
											if (sslIndex > -1)
											{
												tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
												tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
											}

											int webPortIndex = value.toLowerCase().indexOf("-webport");
											if(webPortIndex > -1)
											{
												tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
												tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+webPort+ " "+tmpStr2;
											}
											//agIniFile.setValue(thisElement,thisPattern,value);
											Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
											if (vecVarVal == null)
											{
												vecVarVal = new Vector();
												Vector vecVar = new Vector();
												Vector vecVal = new Vector();
												vecVar.add(thisPattern);
												vecVal.add(value);
												vecVarVal.add(vecVar);
												vecVarVal.add(vecVal);
												htableKeyVarVal.put(thisElement,vecVarVal);
											}
											else
											{
												Vector vecVar = (Vector) vecVarVal.get(0);
												Vector vecVal = (Vector) vecVarVal.get(1);
												vecVar.add(thisPattern);
												vecVal.add(value);
											}
											if (!testListForAuditlog.contains(thisTest))
												testListForAuditlog.add(thisTest);

											if (!compListForAuditlog.contains(thisType+":"+thisNick))
												compListForAuditlog.add(thisType+":"+thisNick);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//EgConfigFilesSync.releaseInstance(agIniFile);

		Set set = htableKeyVarVal.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();

			String subject = (String) me.getKey();
			Vector agentIniVarVal = (Vector)  me.getValue();
			Vector agentIniVariable = (Vector)  agentIniVarVal.get(0);
			Vector agentIniValue = (Vector)  agentIniVarVal.get(1);

			if (agentIniVariable != null && agentIniVariable.size() > 0)
			{
				agIniFile.setValues(subject, agentIniVariable, agentIniValue, false);
			}
		}

		agIniFile.saveFile();
		EgConfigFilesSync.releaseInstance(agIniFile);

		if (!agentListForHyperVisorsChange.isEmpty())
		{
			ArrayList hvConfigAgtLst = new ArrayList(agentListForHyperVisorsChange);
			int size = hvConfigAgtLst.size();
			IniFile agtlssIni = new IniFile(iniFile_dir + "eg_agentlessdisc.ini");

			for (int ag=0; ag<size;ag++)
			{
				String agtName = (String) hvConfigAgtLst.get(ag);
				String existValue = agtlssIni.getValue(agtName, from +"#" +ipAddress);
				if (!StringUtils.isNull(existValue))
				{
					String strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase(); //vc & nutanix same format
					if (from.equals("hmc"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+ssl+"~#~"+ipAddress;
					}
					else if (from.equals("rhev"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase()+"~#~"+domain;
					}
					aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,agtName,from +"#" +ipAddress,strPattern));
				}
			}
		}
		return compListForAuditlog;
	}

	private HashSet updateAgentsValues(ArrayList typeList, String ipAddress, String values, String from, ArrayList exceptEsxList,EgRoleInfo ri, ArrayList aListAgtlessDiscIniEntries)
	{
		Hashtable htableKeyVarVal = new Hashtable();
		IniFile mappingIni = null;
		String agFile = "eg_agents.ini";
		String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";

		StringTokenizer st = new StringTokenizer(values, "#"); //ssl+"#"+UName+"#"+UPass+"#"+isDis+"#"+webPort;
		String ssl = st.nextToken();
		String UName = st.nextToken();
		String UPass = st.nextToken();
		String isDis = st.nextToken();
		String webPort = st.nextToken();
		String domain = "";

		if(from.startsWith("hmc"))
		{
			mappingIni = new IniFile(iniFile_dir + "eg_hmcmapping.ini");
		}
		else if(from.startsWith("nutanix"))
		{
			mappingIni = new IniFile(iniFile_dir + "eg_nutanixmapping.ini");
		}
		else if(from.startsWith("rhev"))
		{
			domain = st.nextToken();
			mappingIni = new IniFile(iniFile_dir + "eg_rhevmapping.ini");
		}
		else
		{
			mappingIni = new IniFile(iniFile_dir + "eg_vcmapping.ini");
		}

		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		ArrayList testEnabled = new ArrayList();
		ArrayList testListForAuditlog = new ArrayList();
		HashSet compListForAuditlog = new HashSet();
		Set agentListForHyperVisorsChange = new HashSet();
		ArrayList listOfComponents = null;

		ArrayList associateCompsList = null;
		String[] associateComps = mappingIni.getVariables(ipAddress);
		if (associateComps != null && associateComps.length > 0)
		{
			associateCompsList = new ArrayList(Arrays.asList(associateComps));
		}

		boolean isDiscThruNutanixCentral = false;
		ArrayList ntxBaseCompTypes = new ArrayList();
		HashSet ipAddrList = new HashSet();

		IniFile agIniFile = EgConfigFilesSync.getInstance(iniFile_dir + agFile,true);
		for(int h=0;h<typeList.size();h++)
		{
			Hashtable nickAgentMap = new Hashtable();
			String thisType = (String) typeList.get(h);
			listOfComponents = new ArrayList(Arrays.asList(discInfo.getAllServersOfType(thisType)));
			if (thisType.equalsIgnoreCase("Nutanix_Cluster") || thisType.equalsIgnoreCase("Nutanix_Prism_Center"))
			{
				isDiscThruNutanixCentral = true;
				ntxBaseCompTypes.add(thisType);
				continue;
			}

			ArrayList associateManagedCompList = new ArrayList();
			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for (int l=0;l<listOfComponents.size();l++)
				{
					String strCompName = listOfComponents.get(l).toString();
					if (exceptEsxList != null && exceptEsxList.contains(strCompName))
					{
						continue;
					}

					if(associateCompsList != null && associateCompsList.contains(strCompName))
					{
						associateManagedCompList.add(strCompName);
					}
				}

				//if (!associateManagedCompList.isEmpty())
				{
					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
			}
			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for(int j=0;j<listOfComponents.size();j++)
				{
					String nickName = (String)listOfComponents.get(j);
					nickName = nickName.substring(nickName.indexOf(":")+1);

					List agentList = getAgents(thisType, nickName);
					if(agentList != null && agentList.size() >0)
					{
						agentListForHyperVisorsChange.addAll(agentList);
						for(int k=0;k<agentList.size();k++)
						{
							ArrayList agentNameList = new ArrayList();
							agentNameList.add(nickName);
							String thisSubject = (String) agentList.get(k);
							if(nickAgentMap.containsKey(thisSubject))
							{
								ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
								if(!lst.contains(nickName))
									lst.add(nickName);
								nickAgentMap.put(thisSubject, lst);
							}
							else
							{
								nickAgentMap.put(thisSubject, agentNameList);
							}
						}
					}
				}
			}

			String[] strTests = egSpecs.getTestsForServer(thisType);
			if (strTests != null && strTests.length > 0)
			{
				testEnabled = new ArrayList(Arrays.asList(strTests));
			}
			
			ArrayList availPatterns = new ArrayList();
			Enumeration ee = nickAgentMap.keys();
			if(from.startsWith("hmc"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);

							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int hmcIndex = value.toLowerCase().indexOf("-hmc_server");
								if (hmcIndex > -1)
								{
									String tmpStr1 = value.substring(0,hmcIndex + "-hmc_server".length()).trim();
									String tmpStr2 = value.substring(hmcIndex + "-hmc_server".length() +1).trim();
									String hmc_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (hmc_server.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-hmc_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-hmc_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-hmc_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-hmc_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-hmc_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-hmc_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}
										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
			else if(from.startsWith("rhev"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);

							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int rhevHostIndex = value.toLowerCase().indexOf("-Rhel_mgr_host");
								if (rhevHostIndex > -1)
								{
									int hostLen ="-Rhel_mgr_host".length();
									String tmpStr1 = value.substring(0,rhevHostIndex + hostLen).trim();
									String tmpStr2 = value.substring(rhevHostIndex + hostLen +1).trim();
									String rhev_host = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (rhev_host.equals(ipAddress))
									{
										int userIndex = value.toLowerCase().indexOf("-rhel_mgr_user");
										int rhelUsrLen = "-Rhel_mgr_user".length();
										if (userIndex > -1)
										{
											tmpStr1 = value.substring(0,userIndex + rhelUsrLen).trim();
											tmpStr2 = value.substring(userIndex + rhelUsrLen +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}

										int pwdIndex = value.toLowerCase().indexOf("-Rhel_mgr_password");
										int rhelPwdLen = "-Rhel_mgr_password".length();
										if(pwdIndex > -1)
										{
											tmpStr1 = value.substring(0,pwdIndex + rhelPwdLen).trim();
											tmpStr2 = value.substring(pwdIndex + rhelPwdLen +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}

										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}

										int webPortIndex = value.toLowerCase().indexOf("-Rhel_mgr_port");
										int portLen = "-Rhel_mgr_port".length();
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + portLen).trim();
											tmpStr2 = value.substring(webPortIndex + portLen +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}

										int domainIndex = value.toLowerCase().indexOf("-Rhel_mgr_domain");
										int domainLen = "-Rhel_mgr_domain".length();
										if(domainIndex > -1)
										{
											tmpStr1 = value.substring(0,domainIndex + domainLen).trim();
											tmpStr2 = value.substring(domainIndex + domainLen +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+domain+ " "+tmpStr2;
										}

										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
			else if(from.startsWith("nutanix"))
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int nutanixIndex = value.toLowerCase().indexOf("-prism_ip");
								if (nutanixIndex > -1)
								{
									String tmpStr1 = value.substring(0,nutanixIndex + "-Prism_IP".length()).trim();
									String tmpStr2 = value.substring(nutanixIndex + "-Prism_IP".length() +1).trim();
									String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (nutanix_server.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-prism_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-prism_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-prism_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-prism_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-prism_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-prism_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}

										int webPortIndex = value.toLowerCase().indexOf("-webport");
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
											tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}
										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
			else
			{
				while(ee.hasMoreElements())
				{
					String thisElement = (String) ee.nextElement();
					String [] variables = agIniFile.getVariables(thisElement);
					ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
					for(int j=0;nickList != null && j<nickList.size();j++)
					{
						String thisNick = (String) nickList.get(j);
						for (int k=0;k<testEnabled.size();k++)
						{
							String thisTest = (String) testEnabled.get(k);
							String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
							if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
							{
								String value = agIniFile.getValue(thisElement,thisPattern);
								int vCenterIndex = value.toLowerCase().indexOf("-virtual_center");
								if (vCenterIndex > -1)
								{
									String tmpStr1 = value.substring(0,vCenterIndex + "-virtual_center".length()).trim();
									String tmpStr2 = value.substring(vCenterIndex + "-virtual_center".length() +1).trim();
									String virtual_center = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();
									if (virtual_center.equals(ipAddress))
									{
										int esxUserIndex = value.toLowerCase().indexOf("-esx_user");
										if (esxUserIndex > -1)
										{
											tmpStr1 = value.substring(0,esxUserIndex + "-esx_user".length()).trim();
											tmpStr2 = value.substring(esxUserIndex + "-esx_user".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UName+ " "+tmpStr2;
										}
										int esxPwdIndex = value.toLowerCase().indexOf("-esx_password");
										if(esxPwdIndex > -1)
										{
											tmpStr1 = value.substring(0,esxPwdIndex + "-Esx_password".length()).trim();
											tmpStr2 = value.substring(esxPwdIndex + "-Esx_password".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+UPass+ " "+tmpStr2;
										}
										int sslIndex = value.toLowerCase().indexOf("-ssl");
										if (sslIndex > -1)
										{
											tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
											tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
										}
										int webPortIndex = value.toLowerCase().indexOf("-webport");
										if(webPortIndex > -1)
										{
											tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
											tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
											tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
											value = tmpStr1 + " "+webPort+ " "+tmpStr2;
										}
										//agIniFile.setValue(thisElement,thisPattern,value);
										Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
										if (vecVarVal == null)
										{
											vecVarVal = new Vector();
											Vector vecVar = new Vector();
											Vector vecVal = new Vector();
											vecVar.add(thisPattern);
											vecVal.add(value);
											vecVarVal.add(vecVar);
											vecVarVal.add(vecVal);
											htableKeyVarVal.put(thisElement,vecVarVal);
										}
										else
										{
											Vector vecVar = (Vector) vecVarVal.get(0);
											Vector vecVal = (Vector) vecVarVal.get(1);
											vecVar.add(thisPattern);
											vecVal.add(value);
										}
										if (!testListForAuditlog.contains(thisTest))
											testListForAuditlog.add(thisTest);

										if (!compListForAuditlog.contains(thisType+":"+thisNick))
											compListForAuditlog.add(thisType+":"+thisNick);
									}
								}
								//agIniFile.saveFile();
							}
						}
					}
				}
				//agIniFile.saveFile();
			}
		}

		if (isDiscThruNutanixCentral)
		{
			//associateManagedCompList = new ArrayList();
			for(int n=0;n<ntxBaseCompTypes.size();n++)
			{
				Hashtable nickAgentMap = new Hashtable();
				String thisType = (String) ntxBaseCompTypes.get(n);
				String userName = "-nutanix_prism_user";
				String passWord = "-nutanix_prism_password";
				if (thisType.equalsIgnoreCase("Nutanix_Prism_Center"))
				{
					userName = "-nutanix_prism_center_user";
					passWord = "-nutanix_prism_center_password";
				}
				listOfComponents = new ArrayList(Arrays.asList(ri.getAllServersOfType(thisType)));

				ArrayList associateManagedCompList = new ArrayList();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for (int l=0;l<listOfComponents.size();l++)
					{
						String strCompName = listOfComponents.get(l).toString();
						if (exceptEsxList != null && exceptEsxList.contains(strCompName))
						{
							continue;
						}

						//if (associateCompsList != null && associateCompsList.contains(strCompName))
						{
							associateManagedCompList.add(strCompName);
						}
					}

					listOfComponents = new ArrayList();
					listOfComponents.addAll(associateManagedCompList);
				}
				nickAgentMap = new Hashtable();
				if(listOfComponents != null && listOfComponents.size()>0)
				{
					for(int j=0;j<listOfComponents.size();j++)
					{
						String nickName = (String)listOfComponents.get(j);
						nickName = nickName.substring(nickName.indexOf(":")+1);

						List agentList = getAgents(thisType, nickName);
						if(agentList != null && agentList.size() >0)
						{
							agentListForHyperVisorsChange.addAll(agentList);
							for(int k=0;k<agentList.size();k++)
							{
								ArrayList agentNameList = new ArrayList();
								agentNameList.add(nickName);
								String thisSubject = (String) agentList.get(k);
								if(nickAgentMap.containsKey(thisSubject))
								{
									ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
									if(!lst.contains(nickName))
										lst.add(nickName);
									nickAgentMap.put(thisSubject, lst);
								}
								else
								{
									nickAgentMap.put(thisSubject, agentNameList);
								}
							}
						}
					}
				}

				String[] strTests = egSpecs.getTestsForServer(thisType);
				if (strTests != null && strTests.length > 0)
				{
					testEnabled = new ArrayList(Arrays.asList(strTests));
				}
				
				ArrayList availPatterns = new ArrayList();
				Enumeration ee = nickAgentMap.keys();
				if(from.startsWith("nutanix"))
				{
					while(ee.hasMoreElements())
					{
						String thisElement = (String) ee.nextElement();
						String [] variables = agIniFile.getVariables(thisElement);
						ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
						for(int j=0;nickList != null && j<nickList.size();j++)
						{
							String thisNick = (String) nickList.get(j);
							for (int k=0;k<testEnabled.size();k++)
							{
								String thisTest = (String) testEnabled.get(k);
								String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);

								if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
								{
									String value = agIniFile.getValue(thisElement,thisPattern);
									int nutanixIndex = value.toLowerCase().indexOf(userName);

									if (nutanixIndex > -1)
									{
										String tmpStr1 = "";//value.substring(0,nutanixIndex + "-host".length()).trim();
										String tmpStr2 = "";//value.substring(nutanixIndex + "-host".length() +1).trim();
										//String nutanix_server = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

										String nutanix_server = value.substring(value.indexOf("-host")+5).trim();
										nutanix_server = nutanix_server.substring(0,nutanix_server.indexOf(" ")).trim();
										String agentVarLower = thisPattern.toLowerCase();
										String strNtxClusterIP = ipAddress;
										if (thisType.equalsIgnoreCase("Nutanix_Prism_Center"))
										{
											strNtxClusterIP = getNtxCtrlMappingSubject(thisElement,ipAddress);
											if (!StringUtils.isNull(strNtxClusterIP) && strNtxClusterIP.indexOf("~|~") != -1)
											{
												strNtxClusterIP = strNtxClusterIP.substring(0, strNtxClusterIP.indexOf("~|~"));
											}
										}
										if(agentVarLower.indexOf(":"+strNtxClusterIP.toLowerCase()+":") > 0 || 
										agentVarLower.endsWith(":"+strNtxClusterIP.toLowerCase()) || 
										nutanix_server.equalsIgnoreCase(strNtxClusterIP)) // IP / Host name / Nick , any one equals with Nutanix, then do.
										{

										//if (nutanix_server.equals(ipAddress))
										//{
											int esxUserIndex = value.toLowerCase().indexOf(userName);
											if (esxUserIndex > -1)
											{
												tmpStr1 = value.substring(0,esxUserIndex + userName.length()).trim();
												tmpStr2 = value.substring(esxUserIndex + userName.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UName+ " "+tmpStr2;
											}
											int esxPwdIndex = value.toLowerCase().indexOf(passWord);
											if(esxPwdIndex > -1)
											{
												tmpStr1 = value.substring(0,esxPwdIndex + passWord.length()).trim();
												tmpStr2 = value.substring(esxPwdIndex + passWord.length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+UPass+ " "+tmpStr2;
											}
											int sslIndex = value.toLowerCase().indexOf("-ssl");
											if (sslIndex > -1)
											{
												tmpStr1 = value.substring(0,sslIndex + "-ssl".length()).trim();
												tmpStr2 = value.substring(sslIndex + "-ssl".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+ssl.toLowerCase()+ " "+tmpStr2;
											}

											int webPortIndex = value.toLowerCase().indexOf("-webport");
											if(webPortIndex > -1)
											{
												tmpStr1 = value.substring(0,webPortIndex + "-webport".length()).trim();
												tmpStr2 = value.substring(webPortIndex + "-webport".length() +1).trim();
												tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")).trim();
												value = tmpStr1 + " "+webPort+ " "+tmpStr2;
											}
											//agIniFile.setValue(thisElement,thisPattern,value);
											Vector vecVarVal = (Vector) htableKeyVarVal.get(thisElement);
											if (vecVarVal == null)
											{
												vecVarVal = new Vector();
												Vector vecVar = new Vector();
												Vector vecVal = new Vector();
												vecVar.add(thisPattern);
												vecVal.add(value);
												vecVarVal.add(vecVar);
												vecVarVal.add(vecVal);
												htableKeyVarVal.put(thisElement,vecVarVal);
											}
											else
											{
												Vector vecVar = (Vector) vecVarVal.get(0);
												Vector vecVal = (Vector) vecVarVal.get(1);
												vecVar.add(thisPattern);
												vecVal.add(value);
											}
											if (!testListForAuditlog.contains(thisTest))
												testListForAuditlog.add(thisTest);

											if (!compListForAuditlog.contains(thisType+":"+thisNick))
												compListForAuditlog.add(thisType+":"+thisNick);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//EgConfigFilesSync.releaseInstance(agIniFile);

		Set set = htableKeyVarVal.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext())
		{
			Map.Entry me = (Map.Entry)it.next();

			String subject = (String) me.getKey();
			Vector agentIniVarVal = (Vector)  me.getValue();
			Vector agentIniVariable = (Vector)  agentIniVarVal.get(0);
			Vector agentIniValue = (Vector)  agentIniVarVal.get(1);

			if (agentIniVariable != null && agentIniVariable.size() > 0)
			{
				agIniFile.setValues(subject, agentIniVariable, agentIniValue, false);
			}
		}

		agIniFile.saveFile();
		EgConfigFilesSync.releaseInstance(agIniFile);

		if (!agentListForHyperVisorsChange.isEmpty())
		{
			ArrayList hvConfigAgtLst = new ArrayList(agentListForHyperVisorsChange);
			int size = hvConfigAgtLst.size();
			IniFile agtlssIni = new IniFile(iniFile_dir + "eg_agentlessdisc.ini");

			for (int ag=0; ag<size;ag++)
			{
				String agtName = (String) hvConfigAgtLst.get(ag);
				String existValue = agtlssIni.getValue(agtName, from +"#" +ipAddress);
				if (!StringUtils.isNull(existValue))
				{
					String strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase(); //vc & nutanix same format
					if (from.equals("hmc"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+ssl+"~#~"+ipAddress;
					}
					else if (from.equals("rhev"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase()+"~#~"+domain;
					}
					aListAgtlessDiscIniEntries.add(new IniHelper(IniHelper.SET,agtName,from +"#" +ipAddress,strPattern));
				}
			}
		}
		return compListForAuditlog;
	}

	private HashSet updateHyperVisorsThruTestConfig(String HVType, String ipAddress, String UName, String UPass, String ssl, String webPort)
	{
		Hashtable htableKeyVarVal = new Hashtable();
		HashSet compListForAuditlog = new HashSet();
		boolean configureHMC = false;

		IniFile agIniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		EgExternalInfo externalInfo = new EgExternalInfo("manager"); 

		if (HVType.equals("hmc"))
		{

			IniFile extIniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini",true);

			configureHMC = true;
			String[] hmcComps = discInfo.getAllServersOfType("hmc_server");
			for (int i=0; i<hmcComps.length; i++)
			{
				String hmcVar = hmcComps[i];
				String hmcVal[] = discInfo.getFieldValuesForServer("hmc_server",hmcVar);
				ArrayList hmcValList = new ArrayList();
				for (int p=0; p<hmcVal.length; p++)
				{
					hmcValList.add(hmcVal[p].toLowerCase());
				}

				if (hmcValList.contains(ipAddress.toLowerCase())) //Check this VC is added as a component thru Add/Modify
				{
					String hmc = hmcVar.substring(hmcVar.indexOf(":")+1);
					hmc = hmc.substring(0,hmc.indexOf(":"));
					if (!compListForAuditlog.contains(hmcVar))
						compListForAuditlog.add(hmcVar);

					String newValue = UName+ "," + UPass;
					String existValue = externalInfo.getAgentlessInfos(hmc);
					ArrayList agents = StringUtils.myTokenizer(existValue, ",");

					for (int j=2; j<agents.size(); j++)
					{
						String value = agents.get(j).toString();
						newValue += ","+ value;
					}
					extIniFile.setValue("Agentless_Infos_Section",hmc,newValue);
				}
			}
			extIniFile.saveFile();
			EgConfigFilesSync.releaseInstance(extIniFile);

		}
		else if (HVType.equals("rhev"))
		{
			webPort = webPort.substring(0,webPort.indexOf("~#~"));
			String domain = webPort.substring(webPort.indexOf("~#~")+3);

			int temp = "-Rhel_manager_user".length();
			int temp2="-Rhel_manager_password".length();

			String[] nutComps = discInfo.getAllServersOfType("Redhat_linux_mgr");
			for (int i=0; i<nutComps.length; i++)
			{
				String nutVar = nutComps[i];
				String nutVal[] = discInfo.getFieldValuesForServer("Redhat_linux_mgr",nutVar);
				ArrayList nutValList = new ArrayList();
				for (int p=0; p<nutVal.length; p++)
				{
					nutValList.add(nutVal[p].toLowerCase());
				}
				ArrayList agents = new ArrayList();
				if (nutValList.contains(ipAddress.toLowerCase())) //Check this VC is added as a component thru Add/Modify
				{
					String nutanix = nutVar.substring(nutVar.indexOf(":")+1);
					nutanix = nutanix.substring(0,nutanix.indexOf(":"));
					if (!compListForAuditlog.contains(nutVar))
						compListForAuditlog.add(nutVar);

					agents = new ArrayList(externalInfo.getAgentsForHost(nutanix));
					for (int j=0; j<agents.size(); j++)
					{
						String agent = agents.get(j).toString();
						String[] agentVars = agIniFile.getVariables(agent);
						for (int k=0; k<agentVars.length; k++)
						{
							String agentVar = agentVars[k];
							String agentVal = agIniFile.getValue(agent,agentVar);

							if (agentVal.toLowerCase().indexOf("-rhel_manager_user") > 0)
							{
								String valHost = agentVal.substring(agentVal.indexOf("-host")+5).trim();
								valHost = valHost.substring(0,valHost.indexOf(" ")).trim();
								String agentVarLower = agentVar.toLowerCase();

								if(agentVarLower.indexOf(":"+ipAddress.toLowerCase()+":") > 0 || 
									agentVarLower.endsWith(":"+ipAddress.toLowerCase()) || 
									valHost.equalsIgnoreCase(ipAddress)) // IP / Host name / Nick , any one equals with nutanix, then do.
								{
									String strTmp1 = agentVal.substring(0,agentVal.toLowerCase().indexOf("-rhel_manager_user")+temp).trim();
									String strTmp2 = agentVal.substring(agentVal.toLowerCase().indexOf("-rhel_manager_user")+temp).trim();
									strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
									agentVal = strTmp1 + " " + UName + " " + strTmp2;

									int rhelPwdIndex = agentVal.toLowerCase().indexOf("-rhel_manager_password");
									if (rhelPwdIndex > -1)
									{
										strTmp1 = agentVal.substring(0,rhelPwdIndex+temp2).trim();
										strTmp2 = agentVal.substring(rhelPwdIndex+temp2).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + UPass + " " + strTmp2;
									}
									int sslIndex = agentVal.toLowerCase().indexOf("-ssl");
									if (sslIndex > -1)
									{
										strTmp1 = agentVal.substring(0,sslIndex+4).trim();
										strTmp2 = agentVal.substring(sslIndex+4).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + ssl.toLowerCase() + " " + strTmp2;
									}

									int webPortIndex = agentVal.toLowerCase().indexOf("-port");
									if (webPortIndex > -1)
									{
										int portLen = "-port".length();
										strTmp1 = agentVal.substring(0,webPortIndex+portLen).trim();
										strTmp2 = agentVal.substring(webPortIndex+portLen).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + webPort + " " + strTmp2;
									}

									int domainIdx = agentVal.toLowerCase().indexOf("-rhel_manager_domain");
									if (domainIdx > -1)
									{
										int temp3 = "Rhel_manager_domain".length();
										strTmp1 = agentVal.substring(0,domainIdx+temp3).trim();
										strTmp2 = agentVal.substring(domainIdx+temp3).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + domain + " " + strTmp2;
									}

									//agIniFile.setValue(agent,agentVar,agentVal);
									Vector vecVarVal = (Vector) htableKeyVarVal.get(agent);
									if (vecVarVal == null)
									{
										vecVarVal = new Vector();
										Vector vecVar = new Vector();
										Vector vecVal = new Vector();
										vecVar.add(agentVar);
										vecVal.add(agentVal);
										vecVarVal.add(vecVar);
										vecVarVal.add(vecVal);
										htableKeyVarVal.put(agent,vecVarVal);
									}
									else
									{
										Vector vecVar = (Vector) vecVarVal.get(0);
										Vector vecVal = (Vector) vecVarVal.get(1);
										vecVar.add(agentVar);
										vecVal.add(agentVal);
									}
								}
							}
						}
					}
					//agIniFile.saveFile();
				}
			}
		}
		else if (HVType.equals("nutanix"))
		{
			int temp = "-nutanix_prism_user".length();
			int temp2="-nutanix_prism_password".length();

			String[] nutComps = discInfo.getAllServersOfType("Nutanix_Cluster");
			for (int i=0; i<nutComps.length; i++)
			{
				String nutVar = nutComps[i];
				String nutVal[] = discInfo.getFieldValuesForServer("Nutanix_Cluster",nutVar);
				ArrayList nutValList = new ArrayList();
				for (int p=0; p<nutVal.length; p++)
				{
					nutValList.add(nutVal[p].toLowerCase());
				}
				ArrayList agents = new ArrayList();
				if (nutValList.contains(ipAddress.toLowerCase())) //Check this VC is added as a component thru Add/Modify
				{
					String nutanix = nutVar.substring(nutVar.indexOf(":")+1);
					nutanix = nutanix.substring(0,nutanix.indexOf(":"));
					if (!compListForAuditlog.contains(nutVar))
						compListForAuditlog.add(nutVar);
					agents = new ArrayList(externalInfo.getAgentsForHost(nutanix));
					for (int j=0; j<agents.size(); j++)
					{
						String agent = agents.get(j).toString();
						String[] agentVars = agIniFile.getVariables(agent);
						for (int k=0; k<agentVars.length; k++)
						{
							String agentVar = agentVars[k];
							String agentVal = agIniFile.getValue(agent,agentVar);
							if (agentVal.toLowerCase().indexOf("-nutanix_prism_user") > 0)
							{
								String valHost = agentVal.substring(agentVal.indexOf("-host")+5).trim();
								valHost = valHost.substring(0,valHost.indexOf(" ")).trim();
								String agentVarLower = agentVar.toLowerCase();

								if(agentVarLower.indexOf(":"+ipAddress.toLowerCase()+":") > 0 || 
									agentVarLower.endsWith(":"+ipAddress.toLowerCase()) || 
									valHost.equalsIgnoreCase(ipAddress)) // IP / Host name / Nick , any one equals with nutanix, then do.
								{
									String strTmp1 = agentVal.substring(0,agentVal.toLowerCase().indexOf("-nutanix_prism_user")+temp).trim();
									String strTmp2 = agentVal.substring(agentVal.toLowerCase().indexOf("-nutanix_prism_user")+temp).trim();
									strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
									agentVal = strTmp1 + " " + UName + " " + strTmp2;

									int nutanixPwdIndex = agentVal.toLowerCase().indexOf("-nutanix_prism_password");
									if (nutanixPwdIndex > -1)
									{
										strTmp1 = agentVal.substring(0,nutanixPwdIndex+temp2).trim();
										strTmp2 = agentVal.substring(nutanixPwdIndex+temp2).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + UPass + " " + strTmp2;
									}
									int sslIndex = agentVal.toLowerCase().indexOf("-ssl");
									if (sslIndex > -1)
									{
										strTmp1 = agentVal.substring(0,sslIndex+4).trim();
										strTmp2 = agentVal.substring(sslIndex+4).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + ssl.toLowerCase() + " " + strTmp2;
									}
									int webPortIndex = agentVal.toLowerCase().indexOf("-webport");
									if (webPortIndex > -1)
									{
										strTmp1 = agentVal.substring(0,webPortIndex+8).trim();
										strTmp2 = agentVal.substring(webPortIndex+8).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + webPort + " " + strTmp2;
									}
									//agIniFile.setValue(agent,agentVar,agentVal);
									Vector vecVarVal = (Vector) htableKeyVarVal.get(agent);
									if (vecVarVal == null)
									{
										vecVarVal = new Vector();
										Vector vecVar = new Vector();
										Vector vecVal = new Vector();
										vecVar.add(agentVar);
										vecVal.add(agentVal);
										vecVarVal.add(vecVar);
										vecVarVal.add(vecVal);
										htableKeyVarVal.put(agent,vecVarVal);
									}
									else
									{
										Vector vecVar = (Vector) vecVarVal.get(0);
										Vector vecVal = (Vector) vecVarVal.get(1);
										vecVar.add(agentVar);
										vecVal.add(agentVal);
									}
								}
							}
						}
					}
					//agIniFile.saveFile();
				}
			}
		}
		else
		{
			String[] vCComps = discInfo.getAllServersOfType("Virtual_center");
			for (int i=0; i<vCComps.length; i++)
			{
				String vcVar = vCComps[i];
				String vcVal[] = discInfo.getFieldValuesForServer("Virtual_center",vcVar);
				ArrayList vcValList = new ArrayList();
				for (int p=0; p<vcVal.length; p++)
				{
					vcValList.add(vcVal[p].toLowerCase());
				}
				ArrayList agents = new ArrayList();
				if (vcValList.contains(ipAddress.toLowerCase())) //Check this VC is added as a component thru Add/Modify
				{
					String vc = vcVar.substring(vcVar.indexOf(":")+1);
					vc = vc.substring(0,vc.indexOf(":"));
					if (!compListForAuditlog.contains(vcVar))
						compListForAuditlog.add(vcVar);
					agents = new ArrayList(externalInfo.getAgentsForHost(vc));
					for (int j=0; j<agents.size(); j++)
					{
						String agent = agents.get(j).toString();
						String[] agentVars = agIniFile.getVariables(agent);
						for (int k=0; k<agentVars.length; k++)
						{
							String agentVar = agentVars[k];
							String agentVal = agIniFile.getValue(agent,agentVar);
							if (agentVal.toLowerCase().indexOf("-vc_user") > 0)
							{
								String valHost = agentVal.substring(agentVal.indexOf("-host")+5).trim();
								valHost = valHost.substring(0,valHost.indexOf(" ")).trim();
								String agentVarLower = agentVar.toLowerCase();

								if(agentVarLower.indexOf(":"+ipAddress.toLowerCase()+":") > 0 || 
									agentVarLower.endsWith(":"+ipAddress.toLowerCase()) || 
									valHost.equalsIgnoreCase(ipAddress)) // IP / Host name / Nick , any one equals with VC, then do.
								{
									String strTmp1 = agentVal.substring(0,agentVal.toLowerCase().indexOf("-vc_user")+8).trim();
									String strTmp2 = agentVal.substring(agentVal.toLowerCase().indexOf("-vc_user")+8).trim();
									strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
									agentVal = strTmp1 + " " + UName + " " + strTmp2;

									int vcPwdIndex = agentVal.toLowerCase().indexOf("-vc_password");
									if (vcPwdIndex > -1)
									{
										strTmp1 = agentVal.substring(0,vcPwdIndex+12).trim();
										strTmp2 = agentVal.substring(vcPwdIndex+12).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + UPass + " " + strTmp2;
									}
									int sslIndex = agentVal.toLowerCase().indexOf("-ssl");
									if (sslIndex > -1)
									{
										strTmp1 = agentVal.substring(0,sslIndex+4).trim();
										strTmp2 = agentVal.substring(sslIndex+4).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + ssl.toLowerCase() + " " + strTmp2;
									}
									int webPortIndex = agentVal.toLowerCase().indexOf("-webport");
									if (webPortIndex > -1)
									{
										strTmp1 = agentVal.substring(0,webPortIndex+8).trim();
										strTmp2 = agentVal.substring(webPortIndex+8).trim();
										strTmp2 = strTmp2.substring(strTmp2.indexOf(" ")).trim();
										agentVal = strTmp1 + " " + webPort + " " + strTmp2;
									}
									//agIniFile.setValue(agent,agentVar,agentVal);
									Vector vecVarVal = (Vector) htableKeyVarVal.get(agent);
									if (vecVarVal == null)
									{
										vecVarVal = new Vector();
										Vector vecVar = new Vector();
										Vector vecVal = new Vector();
										vecVar.add(agentVar);
										vecVal.add(agentVal);
										vecVarVal.add(vecVar);
										vecVarVal.add(vecVal);
										htableKeyVarVal.put(agent,vecVarVal);
									}
									else
									{
										Vector vecVar = (Vector) vecVarVal.get(0);
										Vector vecVal = (Vector) vecVarVal.get(1);
										vecVar.add(agentVar);
										vecVal.add(agentVal);
									}
								}
							}
						}
					}
					//agIniFile.saveFile();
				}
			}
		}

		if (!configureHMC)
		{
			Set set = htableKeyVarVal.entrySet();
			Iterator it = set.iterator();
			while (it.hasNext())
			{
				Map.Entry me = (Map.Entry)it.next();

				String subject = (String) me.getKey();
				Vector agentIniVarVal = (Vector)  me.getValue();
				Vector agentIniVariable = (Vector)  agentIniVarVal.get(0);
				Vector agentIniValue = (Vector)  agentIniVarVal.get(1);

				if (agentIniVariable != null && agentIniVariable.size() > 0)
				{
					agIniFile.setValues(subject, agentIniVariable, agentIniValue, false);
				}
			}
			agIniFile.saveFile();
			EgConfigFilesSync.releaseInstance(agIniFile);
		}

		return compListForAuditlog;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentType,String componentName)
	{
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompType = new String(componentType);
		String tempCompName = new String(componentName);
		String agentNickName = "";
		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			if (tempCompType.equals("Oracle_server"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			else
			{
				tempCompName = tempCompName.substring(0,tempCompName.lastIndexOf(":"));
			}
		}
		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}
		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	private String getResultantPattern(String componentType, String compName, String testName, String[] testVariables)
	{
		String tempResultantPattern = null;
		String specificPattern_A = testName + ":" + componentType + ":" + compName;
		String specificPattern_B = testName + ":" + componentType + ":" + compName.substring(0,compName.indexOf(":"));
		String defaultPattern_A = testName + "::" + compName;
		String defaultPattern_B = testName + "::" + compName.substring(0,compName.indexOf(":"));
		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}

	private boolean checkParamsExist(String pwdProfileParams, StringBuffer strBuffer)
	{
		String aResultant  = strBuffer.toString();
		boolean isAnyOneNull = (com.egurkha.util.StringUtils.isNull(pwdProfileParams) || 
								com.egurkha.util.StringUtils.isNull(aResultant));

		if (isAnyOneNull)
		{
			return false;
		}

		boolean isAllParamsMatch = false;
		//-manual, -host TEST -port NULL -virtual_center None -Esx_user SSSS -Esx_password 5DC53085159943A8D9C31ADD6F2E52E7 -webPort 443 -ssl true -ignore_vms_inside_view none -ignore_winNT true -exclude_vms none -Inside_view_using tcp -domain none|none|none -admin_user EGUSER|ADMIN|XDADMIN -admin_password 740C22FD3B187D81FE59C3D01FA252462C10029C3E2B731DA3CD2C97547193B3 -Report_By_User true -Report_Powered_Os true -agentless y -mCount 34 -ddFreq 1:1 -aluser None -alpassword CCF1978907AD00AB972C9B9138C9744A -almode Other -os vmware -sshPort 22 -alencrypt None -alkeyfile None -rptName TEST2, 300

		StringTokenizer st = new StringTokenizer(pwdProfileParams,",");
		int totalPwdParams = st.countTokens();
		int paramCnt = 0;
		while(st.hasMoreTokens())
		{
			String token = (String) st.nextToken();
			if (aResultant.indexOf("-"+token) != -1)
			{
				paramCnt++;
			}
		}

		if (paramCnt == totalPwdParams)
		{
			isAllParamsMatch = true;
		}
		return isAllParamsMatch;
	}

	private boolean checkPwdProfileParams(ArrayList aListChoosenParametersInLowerCase, String chkString)
	{
		boolean isAnyOneNull = (com.egurkha.util.StringUtils.isNull(chkString) || 
								aListChoosenParametersInLowerCase == null);

		if (isAnyOneNull)
		{
			return false;
		}

		boolean isAllParamsMatch = false;
		Iterator st = aListChoosenParametersInLowerCase.iterator();
		while(st.hasNext())
		{
			String token = (String) st.next();
			if (token.startsWith(chkString))
			{
				isAllParamsMatch = true;
				break;
			}
		}
		return isAllParamsMatch;
	}

	private String updateAuditlogParams(String paramName)
	{
		if(paramName != null && !paramName.equals(""))
		{
			return paramName.equalsIgnoreCase("jboss_domain_mode") ? "IS JBOSS RUNNING IN DOMAIN MODE?" :
			paramName.equalsIgnoreCase("jboss_server_instance") ? "JBOSS SERVER INSTANCE NAME" :
			paramName.equalsIgnoreCase("Method_Exec_CutOff") ? "METHOD EXECUTION CUTOFF(MS)" :
			paramName.equalsIgnoreCase("SQL_Exec_CutOff") ? "SQL EXECUTION CUTTOFF(MS)" :
			paramName.equalsIgnoreCase("Show_HTTPStatus") ? "SHOW HTTP STATUS" :
			paramName.equalsIgnoreCase("ddFreq") ? "DD FREQUENCY" :
			paramName.equalsIgnoreCase("rotatingfile") ? "ROTATING FILE" :
			paramName.equalsIgnoreCase("excludePatterns") ? "EXCLUDE PATTERNS" :
			paramName.equalsIgnoreCase("includePatterns") ? "INCLUDE PATTERNS" :
			paramName.equalsIgnoreCase("syslogfile") ? "SYSLOG FILE" :
			paramName.equalsIgnoreCase("Key_Excluded_Patterns") ? "EXCLUDED PATTERNS" :
			StringUtils.replace(paramName.toUpperCase(),"_"," ");
		}
		return paramName;
	}

	private String getModifiedParamValue(String paramValue)
	{
		ArrayList paramValueList = StringUtils.egTokenizer(paramValue,",");
		HashMap hash_map = new HashMap();
		for (int x=0; x<paramValueList.size(); x++)
		{
			String paramValueStr = (String) paramValueList.get(x);
			ArrayList paramList = StringUtils.egTokenizer(paramValueStr,"#^#");
			String fileNameStr = (String)paramList.get(0);
			String uNameStr = (String)paramList.get(1);
			if (hash_map.containsKey(uNameStr))
			{
				String fNameStr = (String) hash_map.get(uNameStr);
				hash_map.put(uNameStr,fNameStr+"~#~"+fileNameStr);
			}
			else
			{
				hash_map.put(uNameStr,fileNameStr);
			}
		}

		String strParamValue ="";
		Iterator userItr = hash_map.keySet().iterator();
		while (userItr.hasNext())
		{
			String userKey = (String) userItr.next();
			String filesValue = (String)hash_map.get(userKey);
			strParamValue += "|"+userKey+"#^#"+filesValue;
		}
		strParamValue = strParamValue.substring(1);

		return strParamValue;
	}

	private String updateDiscParamsValues(ArrayList agentTokenList, String discParamValue)
	{
		StringBuffer sb = new StringBuffer();
		String paramStr = "";
		if (StringUtils.isNull(discParamValue))
		{
			return paramStr;
		}

		ArrayList discParamTokenList = getParameterList(discParamValue,false);
		int n_size = agentTokenList.size();
		int o_size = discParamTokenList.size();
		if (n_size == 0 || o_size == 0)
		{
			return paramStr;
		}

		ArrayList resultList = new ArrayList();
		for (int i=0; i<o_size-1; i=i+2)
		{
			String discParamName = (String) discParamTokenList.get(i);
			String discParamVal = (String) discParamTokenList.get(i+1);

			if (agentTokenList.contains(discParamName))
			{
				int idx = agentTokenList.indexOf(discParamName);
				String agentParamVal = (String) agentTokenList.get(idx+1);
				discParamVal = agentParamVal;
			}

			resultList.add(discParamName);
			resultList.add(discParamVal);
		}

		if (resultList != null && !resultList.isEmpty())
		{
			discParamValue = getString(resultList);
		}
		return discParamValue;
	}

	public static String getString(List list)
	{
		StringBuffer buffer = new StringBuffer(32);

		if (list != null && list.size() > 0)
		{
			for (Iterator i=list.iterator(); i.hasNext(); )
			{
				String line = (String)i.next();
				buffer.append(line);
				buffer.append(" ");
			}
		}

		/*
		 * Take out the last space and return the string
		 */
		String string = buffer.toString();
		return string.substring(0, string.length()-1);
	}
	
	public boolean isNumber(String s_number)
	{
		try 
		{
			Long.parseLong(s_number);
		} 
		catch (NumberFormatException e)
		{
			return false;
		}
		return true;
	}

%>
