<%
/**********************************************************************************
*	Name			:	EgUploadMIB.jsp
*	Purpose			:	Upload the MIB file and Delete the MIb file.
***********************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgMibUtil" %>
<%@ page import="com.eg.UploadMIBFile" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import= "com.egurkha.util.StringUtils"%>
<%@ page import="java.io.File"%>
<%@ page import ="net.sf.json.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	session.setAttribute("egPageDesc","EgUploadMIB.jsp");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	
	EgUserRole usrRole = _user.getUserRole();
	boolean hasAllComponentAccess = usrRole.hasAllComponentAccess();
	
	String session_userid = (String)session.getAttribute("sess_userid");
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	String dirPath = EgInstallInfo.getInstallDir()+"/.snmp";
	String orgname = "";
	if (!hasAllComponentAccess)
	{
		boolean isSuperOrg = egUuidInfo.isSuperOrg(session_userid);
		boolean isOrg = egUuidInfo.isOrg(session_userid);
		if (isSuperOrg)
		{
			orgname = session_userid;
		}
		else if (isOrg)
		{
			orgname = session_userid;
		}
		else
		{
			orgname = egUuidInfo.getDirectDependentOU(session_userid);
		}
		
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			dirPath = EgInstallInfo.getInstallDir()+"/.snmp";
			hasAllComponentAccess = true;
		}
		else
		{
			dirPath = EgInstallInfo.getInstallDir()+"/.snmp/"+orgname;
		}
	}
	else
	{
		orgname = "egenterprise";
	}

	String deleteMIBFile = request.getParameter("deleteMIBFile");
	String deletedMIBFileNames[] = request.getParameterValues("MIBfiles");
	String strDelMIBFileNames = request.getParameter("StrMIBfiles");
	strDelMIBFileNames = egurkha.EgUIUtils.decodeSecurityChar(strDelMIBFileNames);
	
	rootJson.put("deletMIBFile",deleteMIBFile);
	
	IniFile trapsConfig = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini");
	
	if (deleteMIBFile != null && deleteMIBFile.equals("true"))
	{
		if(deletedMIBFileNames == null || deletedMIBFileNames.length == 0)
		{
			if (!StringUtils.isNull(strDelMIBFileNames) && strDelMIBFileNames.length() > 0)
			{
				String[] tempDeleteMibArr = StringUtils.getTokens(strDelMIBFileNames,",");
				deletedMIBFileNames = new String[tempDeleteMibArr.length];
				for (int i=0;i<tempDeleteMibArr.length;i++)
				{
					String tmpVal = tempDeleteMibArr[i];
					deletedMIBFileNames[i] = tmpVal;
				}
			}
		}

		if(deletedMIBFileNames!=null && deletedMIBFileNames.length > 0)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","SNMP Traps - Upload MIB");
			auditLogThread.setValue("Activity","Delete");
			
			//out.println(Arrays.asList(deletedMIBFileNames));
			ArrayList deletedMibFilesList = new ArrayList(); 
			for(int j=0;j<deletedMIBFileNames.length;j++)
			{
				String del_file = deletedMIBFileNames[j].trim();
				File deleteFileObj = new File(dirPath+"/"+del_file);
				if(deleteFileObj != null && deleteFileObj.exists())
				{
					EgMibUtil.unloadMib(del_file, orgname, hasAllComponentAccess);
					String delFileWithoutExt = del_file.substring(0, del_file.lastIndexOf("."));
					deletedMibFilesList.add(delFileWithoutExt);
					deleteFileObj.delete();
					auditLogThread.setCurrentValue("MIB Files",del_file);
				}
				if(EgInstallInfo.isClusterSupported)
				{
					if (!hasAllComponentAccess)
					{
						del_file = orgname+System.getProperty("file.separator")+del_file;
					}
					UploadMIBFile uploadMib = new UploadMIBFile();
					uploadMib.deleteMIBFile(del_file);
				}
			}
			
			auditLogThread.setValue("Description","The MIB files have been deleted successfully.");
			auditLogThread.sendItToDB();
			
			Vector varablesVec = trapsConfig.getVariables("ModuleData^#^"+orgname,true);
			Vector valuesVec = trapsConfig.getAllValues("ModuleData^#^"+orgname);
			
			Vector selectedVarVec = new Vector();
			if (valuesVec != null && valuesVec.size() > 0)
			{
				int size = valuesVec.size();
				for(int k=0; k<size; k++)
				{
					String valueStr = (String) valuesVec.get(k);
					int data_idx = valueStr.indexOf("^#^");
					String existingFileName = valueStr;
					if (data_idx != -1)
					{
						existingFileName = valueStr.substring(0,data_idx);
					}
					if (deletedMibFilesList.contains(existingFileName))
					{
						String varStr = (String) varablesVec.get(k);
						selectedVarVec.add(varStr);
					}
				}
			}
			
			if (selectedVarVec != null && selectedVarVec.size() > 0)
			{
				IniFile trapsConfig_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_trappriority.ini",true);
				trapsConfig_write.deleteValues("ModuleData^#^"+orgname,selectedVarVec);
				trapsConfig_write.saveFile();
				EgConfigFilesSync.releaseInstance(trapsConfig_write);
			}
		}
	}
	
	EgMibUtil.loadMibs();
	
	ArrayList allSelectedFileList = new ArrayList();
	String[] alltrapsSubjects = trapsConfig.getSubjects();
	if (alltrapsSubjects != null && alltrapsSubjects.length > 0)
	{
		int len = alltrapsSubjects.length;
		for (int x=0; x<len; x++)
		{
			String subject = alltrapsSubjects[x];
			if (subject.startsWith(orgname))
			{
				ArrayList tokensList = new ArrayList(StringUtils.egTokenizer(subject,"^#^"));
				String selectedFileName = (String) tokensList.get(1);
				if (selectedFileName.equals("OIDNameMap"))
				{
					continue;
				}
				if (!allSelectedFileList.contains(selectedFileName))
				{
					allSelectedFileList.add(selectedFileName);
				}
			}
		}
	}

	ArrayList fileNameList = new ArrayList();	
	File uploadMIBDir = new File(dirPath);
	if(uploadMIBDir.exists())
	{
		File uploadMIBFiles[] = uploadMIBDir.listFiles();
		if(uploadMIBFiles != null)
		{
			for(int i=0;i<uploadMIBFiles.length;i++)
			{
				File temp = (File)uploadMIBFiles[i];
				if(!temp.isDirectory())
				{
					String fileName = temp.getName();
					fileNameList.add(fileName);
				}
			}
		}
	}
	
	if(fileNameList.size() > 0)
	{
		screenLabels.put("mulitselt_title",_mapping.getTextDescription("admin.user.Select the MIB files to be deleted"));

		Collections.sort(fileNameList,String.CASE_INSENSITIVE_ORDER);

		JSONArray mibUploadDataArr = new JSONArray();
		JSONArray mibUploadDataGridArr = new JSONArray();
		for(int k=0;k<fileNameList.size();k++)
		{
			JSONObject mibUploadDataObj = new JSONObject();
			JSONObject mibUploadDataGridObj = new JSONObject();
			String fileName = (String)fileNameList.get(k);
			mibUploadDataObj.put("displayField",fileName);
			mibUploadDataObj.put("valueField",fileName);
			mibUploadDataGridObj.put("Mibname",fileName);
			fileName = fileName.substring(0,fileName.indexOf("."));
			if (allSelectedFileList != null && allSelectedFileList.contains(fileName))
			{
				mibUploadDataGridObj.put("isDisabled",true);
			}
			else
			{
				mibUploadDataGridObj.put("isDisabled",false);
			}

			mibUploadDataArr.add(mibUploadDataObj);
			mibUploadDataGridArr.add(mibUploadDataGridObj);
		}
		rootJson.put("mibUploadDataArr",mibUploadDataArr);
		rootJson.put("mibUploadDataGridArr",mibUploadDataGridArr);

		rootJson.put("isDeleteButton",true);
		rootJson.put("isSearchBcx",true);
		rootJson.put("isNoMibFiles",false);

	}
	else
	{
		rootJson.put("isDeleteButton",false);
		rootJson.put("isSearchBox",false);
		rootJson.put("isNoMibFiles",true);

	}

	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp");
%>



