<%@page import="com.eg.IniFile" %>
<%@page import="com.eg.EgInstallInfo" %>
<%@page import="com.egurkha.util.DateUtil" %>
<%@page import="java.util.*"%>
<%@page import="java.io.*" %>
<%@ page import ="java.text.SimpleDateFormat"%>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.FileUtils"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	EgToolKitInfo tkinfo = new EgToolKitInfo();
	if (!tkinfo.isToolkitAccessEnabled)
	{
		return;
	}

	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ViewBackupConfig");
				return;
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
				return;
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ViewBackupConfig");
				return;
			}
			else
			{
				session.setAttribute("reqFromForTk","ViewBackupConfig");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
				return;
			}
		}	
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
			return;
		}
	}
	session.setAttribute("reqFromForTk","ViewBackupConfig");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("Config"))
	{
		session.setAttribute("treeViewSrc","ViewBackupConfig");
	}
	
	List configFileList = new ArrayList();
	List subjectList = new ArrayList();
	Map entryMap = new LinkedHashMap();

	String backupDate = request.getParameter("backupDate");
	String fileName = request.getParameter("fileName");
	String subject = request.getParameter("subject");
	String error_msg = null;
	String defaultSelSub = "Not applicable"; 

	String backupPath = EgInstallInfo.getInstallDir()+ "/manager/backup";
	Map backupDateMap = DateUtil.getDateMap(FileUtils.getFileList(new File(backupPath),"dateDirectory"),"MM/dd/yyyy",true);

	if(backupDate != null && !backupDate.equals("-1"))
	{
		configFileList = FileUtils.getFileList(new File(backupPath+"/"+backupDate),"configFile");
	}

	IniFile iniFile = null;
	if(fileName != null && backupDate != null)
	{
		iniFile = new IniFile(backupPath+"/"+backupDate+"/"+fileName);
	}

	if(iniFile != null)
	{
		String[] allSubjs = iniFile.getSubjects();
		if(allSubjs != null && allSubjs.length >0)
		{
			subjectList.addAll(Arrays.asList(allSubjs));
			defaultSelSub = "Select a subject";
		}
		if(subject != null)
		{
			String[] vars = iniFile.getVariables(subject);
			if(vars != null)
			{
				for(int i=0;i<vars.length;i++)
				{
					entryMap.put(vars[i],iniFile.getValue(subject,vars[i]));
				}
			}
			if(entryMap.isEmpty())
			{
				error_msg = "No data found!";
			}
		}
	}
%>
<html>
<head>
	<title>View Backup Configuration File</title>
	<meta name="created" content="23/12/2020">
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<Link REL = "StyleSheet" href = "eg_styles\adminstyle_blue.css"/>
	<style>
	#maintitle
	{
		padding-top: 3px;
		padding-left:3px;
		padding-right:3px;
		padding-bottom:3px;
		font-size: 13px; 
		font-family: Arial,  Century Gothic, Verdana;
		font-weight: bold;
		color: #ffffff;
		background-color: #00003C;
	}
	</style>
	<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
	<script language="JavaScript" src="/final/scripts/utilities/EncodeDecodeParams.js"></script>
	<script>
	document.onscroll = function()
	{
		clearTimeout(time);
		time = setTimeout(logout,timeoutTime);
	}
	</script>
	<script language="JavaScript">
	var backDir ='';
	var fileName = '';
	var subject = '';

	function getObj()
	{
		var selectedBckDate = document.getElementById("backupDate");
		var selectedFile = document.getElementById("iniList");
		var selectedSub = document.getElementById("subject");

		backDir = selectedBckDate[selectedBckDate.selectedIndex].value;
		fileName = selectedFile[selectedFile.selectedIndex].value;
		subject = selectedSub[selectedSub.selectedIndex].value;
	}

	function changeBackupDate(value)
	{
		window.location.href="/final/admin/EgViewConfigBackup.jsp?backupDate="+value+"&sessionInUse=true";
	}

	function changeFile()
	{
		getObj();
		var queryString = "backupDate="+backDir+"&fileName="+fileName+"&sessionInUse=true";
		window.location.href="/final/admin/EgViewConfigBackup.jsp?"+queryString;
	}

	function changeSubject()
	{
		getObj();
		var queryString = "backupDate="+backDir+"&fileName="+fileName+"&subject="+subject+"&sessionInUse=true";
		window.location.href="/final/admin/EgViewConfigBackup.jsp?"+queryString;
	}
	</script>
</head>

<body style="overflow:auto" id="space6" >
	<form name="EgConfig" method="post" style="margin:0px" action="EgConfigFileEdit.jsp">
	<input type="hidden" name="op" value="">
	<input type="hidden" name="variable" value="">
	<input type="hidden" name="value" value="">
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
			<tr>
				<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
			</tr>
			<tr>
				<td width="100%" height="24" id="eg_title" align="center">&nbsp;BACKUP CONFIGURATION FILES&nbsp;</td>
			</tr>
			<tr>
				<td height="20" align="center" colspan="2">
					<table align="center" width="85%" cellspacing="0" cellpadding="4" border="0">
						<tr>
							<td  height="24" nowrap align="right" width="33%" class="eg_cellbglits"><img src="/final/admin/eg_images/info2.gif"> </td>
							<td height="24" nowrap align="left" class="eg_cellbglits">This page enables the administrator to view backup configuration files.</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
					<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td id="eg_blankspace" height="5" nowrap>&nbsp;</td>
						</tr>
						<tr>
							<td align="center" valign="top">
								<table cellspacing="0"width="100%" cellpadding="4" style="border:0px solid cyan" class="eg_subcontentbg">
									<tr class="eg_cellbglits">
										<td style="width:25%;text-align:left;"><egui:intnl text='admin.manager.Backup Date'/></td>
										<td style="width:25%;text-align:left"><egui:intnl text='admin.manager.INI File'/></td>
										<td style="width:25%;text-align:left;"><egui:intnl text='admin.manager.Subject'/></td>
									</tr>
									<tr class="eg_cellbglits">
										<td style="width:25%;">
											<select id="backupDate" name="backupDate" onchange='javascript:changeBackupDate(this.value)' style="width:100%">
											<%=FileUtils.selectOptionList("Select a backup date",backupDateMap,backupDate,false)%>
											</select>
										</td>
										<td style="width:25%;">
											<select id="iniList" name="iniList" onchange='javascript:changeFile()' style="width:100%">
											<%=FileUtils.selectOptionList("Select an INI File",configFileList,fileName,true)%>
											</select>
										</td>
										<td style="width:25%;">
											<select id="subject" name="subject" onchange='javascript:changeSubject()' style="width:100%">
											<%=FileUtils.selectOptionList(defaultSelSub,subjectList,subject,true)%>
											</select>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
<%
	if (!entryMap.isEmpty())
	{
%>
					<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="margin-top:20px">
						<tr>
							<td colspan="5" id="maintitle" nowrap>&nbsp;&nbsp;<%=fileName%></td>
						</tr>
						<tr>
							<td colspan="5">
								<table align="center" cellspacing="0" cellpadding="3" width="100%" border="0" id="cell_border1">
									<tr>
										<td nowrap>&nbsp;&nbsp;<%=subject%></td>
										<td align="right" nowrap>Total Entries&nbsp;:&nbsp;<%=entryMap.size()%>&nbsp;&nbsp;</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="5" id="eg_blankspace" nowrap height="5" class="eg_whitebg">&nbsp;</td>
						</tr>
						<tr>
							<td colspan="5" id="eg_whitebg" class="eg_blankspace" height="15" nowrap>&nbsp;</td>
								<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" class="eg_subcontentbg">
<%
		ArrayList entryList = new ArrayList(entryMap.keySet());
		Collections.sort(entryList,String.CASE_INSENSITIVE_ORDER);
		Iterator entryItr = entryList.iterator();
		while(entryItr.hasNext())
		{
			String variable = (String)entryItr.next();
			String value = (String)entryMap.get(variable);
			value = (value == null || value.trim().length() == 0) ? "-" : value;
%>
									<tr>
										<td class="form_border">&nbsp;&nbsp;&nbsp;</td>
										<td valign="top" width="50%" class="form_border"><%=variable%></td>
										<td valign="top" width="50%" class="form_border"><div style="word-break:break-all;"><%out.print(value);%></div></td>
										<td class="form_border">&nbsp;&nbsp;&nbsp;</td>
									</tr>
<%
		}
%>
								</table>
							</td>
						</tr>
					</table>
<%
	}
%>
				</td>
			</tr>
			<tr>
				<td colspan="5" id="eg_blankspace" nowrap height="5" class="eg_whitebg">&nbsp;</td>
			</tr>
		</table>
<%
	if(error_msg != null)
	{
%>
		<table cellspacing="0" cellpadding="0" border="0" bordercolor="blue" id="dispTab" width="100%" style="margin-top:150px">
			<tr>
				<td align="center" width="100%" valign="middle">
				<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
					<label style="font-family:Arial Narrow;font-size:15px" id="dispLabel"><%=error_msg%></label>
				</td>
			</tr>
		</table>
<%
	}
%>
</form>
</body>
</html>



