<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*"%>
<%@ page import="net.sf.json.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.apm.EgApmConfigEntry"%>
<%@ page import="egurkha.EgUIUtils"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.EgQueryRunner"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import ="java.text.*"%>
<%@ page import ="java.util.concurrent.TimeUnit"%>

<%
try{
	response.setContentType("application/json");
	String apmConfigIniPath = EgInstallInfo.getInstallDir() + "/manager/config/eg_apmconfig.ini";	
	String action = request.getParameter("action");
	String variable = request.getParameter("fromPage");
	String comPort = request.getParameter("comPort");
	String compNickName = request.getParameter("compNickName");
	String componentId = EgUIUtils.decodeSecurityChar(request.getParameter("guidValue"));
	String section = request.getParameter("parentNode");
	//System.out.println("componentId:"+componentId);
	String sessId = request.getParameter("sessionId");
	if (sessId == null)
		sessId = session.getId();

	User user = UserRegistry.getInstance().getUser(sessId,true);
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",user.getLoginID());
	auditLogThread.setValue("Host_ip",user.getUserIP(sessId));
	auditLogThread.setValue("Session_id",sessId);
	auditLogThread.setValue("Module","BTM Profiler Settings");
	/* code for auditlog ends */
	
	if(action != null && action.equalsIgnoreCase("read")){
		// Read eg_apmconfig.ini
		JSONObject treeJsObj = new JSONObject();
		try {
			HashMap fieldMap = new HashMap();
			IniFile iniFileObj = new IniFile(apmConfigIniPath);
			String arrayValue = iniFileObj.getValue(variable,componentId);
			if(arrayValue!=""){
				getUpdatedConfigs(arrayValue, fieldMap, section, variable);
			}
			if(fieldMap!=null && fieldMap.size() > 0){
				treeJsObj.put("gridLogEntries",getLogOption(fieldMap,componentId,session,comPort,compNickName,variable,_mapping));
			}else {
				getDefaultConfigs(fieldMap, section, variable);
				treeJsObj.put("gridLogEntries",getLogOption(fieldMap,componentId,session,comPort,compNickName,variable,_mapping));
			}
		}catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(treeJsObj.size() > 0){
				out.println(treeJsObj.toString());
			}
		}
	}else if(action.equalsIgnoreCase("save")){
		JSONObject rootJson = new JSONObject();
		try {
			IniFile iniFileObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_apm.ini");
			
			String Description ="";
			if(componentId != null){
				ArrayList ignoreParamList = new ArrayList();
				ignoreParamList.add("action");
				ignoreParamList.add("fromPage");
				ignoreParamList.add("parentNode");
				ignoreParamList.add("guidValue");
				ignoreParamList.add("com.eg.CSRF_NONCE");
				HashMap map = new HashMap();
				JSONObject jsonObj = new JSONObject();
				Enumeration enumeration = request.getParameterNames();
				while(enumeration.hasMoreElements()){
					String key = (String)enumeration.nextElement();
					if(!ignoreParamList.contains(key))
					{
						String value = EgUIUtils.decodeSecurityChar(request.getParameter(key));
						map.put(key,value);
						jsonObj.put(key,value);
					}
				}
				rootJson.put("result",jsonObj);
				EgApmConfigEntry apmConfig = new EgApmConfigEntry();
				String oldConfig = apmConfig.getConfigIniEntry(variable,componentId);
				String configEntry[] = getOldConfigEntry(oldConfig);
				if(configEntry!=null && configEntry.length > 0)
				{
					 if(configEntry[0].equalsIgnoreCase("RUM_INTEGRATION_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						if(configValue.length==4){
							String keyValue= configValue[0];
							if(keyValue!=null)
							{
								if(keyValue.equalsIgnoreCase("true"))
									auditLogThread.setPreviousValue("Enable RUM injection","Yes");
								else
									auditLogThread.setPreviousValue("Enable RUM injection","No");
							}
							else{
								auditLogThread.setPreviousValue("Enable RUM injection","Yes");
							}
							keyValue = configValue[1];
							auditLogThread.setPreviousValue("Real user monitor component",keyValue);

							keyValue = configValue[2];
							if(keyValue.equalsIgnoreCase("true"))
								auditLogThread.setPreviousValue("Inject RUM script via BTM","Yes");
							else
								auditLogThread.setPreviousValue("Inject RUM script via BTM","No");
							
								auditLogThread.setPreviousValue("RUM code snippet","HTML");

						}
						else
						{
							String keyValue= configValue[0];
							if(keyValue.equalsIgnoreCase("true"))
								auditLogThread.setPreviousValue("Enable RUM BTM Integration Cookie","Yes");
							else
								auditLogThread.setPreviousValue("Enable RUM BTM Integration Cookie","No");
						}
					}
					else if(configEntry[0].equalsIgnoreCase("EXCEPTION_AND_ERROR_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						String keyValue= configValue[0];
						if(keyValue.equalsIgnoreCase("true"))
							auditLogThread.setPreviousValue("Capture cause of exception","Enable");
						else
							auditLogThread.setPreviousValue("Capture cause of exception","Disable");
						keyValue= configValue[1];
						auditLogThread.setPreviousValue("Max exception cause depth",keyValue);
						keyValue= configValue[2];
						auditLogThread.setPreviousValue("Error status code range",keyValue);
					}
					else if(configEntry[0].equalsIgnoreCase("SQL_AND_JDBC_TEMPLATE"))
					{
						auditLogThread.setPreviousValue("Max sql call count limit",configEntry[1]);
					}
					else if(configEntry[0].equalsIgnoreCase("MISCELLANEOUS_TEMPLATE"))
					{
						auditLogThread.setPreviousValue("Remote header address",configEntry[1]);
					}
					else if(configEntry[0].equalsIgnoreCase("DIAGNOSTIC_SESSION_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						if(configValue.length>4){
							String keyValue= configValue[0];
							if(keyValue!=null)
							{
								if(keyValue.equalsIgnoreCase("true"))
								auditLogThread.setPreviousValue("Diagnostic session is enabled","Yes");
								else
								auditLogThread.setPreviousValue("Diagnostic session is enabled","No");
							}
							
							keyValue = configValue[1];
							auditLogThread.setPreviousValue("Business Transaction",keyValue);
							
							keyValue = configValue[2];
							auditLogThread.setPreviousValue("URL",keyValue);
							
							keyValue = configValue[3];
							auditLogThread.setPreviousValue("Diagnosis session duration",keyValue);
							
							keyValue = configValue[4];
							auditLogThread.setPreviousValue("Max parallel collections within a minute",keyValue);
							
							keyValue = configValue[5];
							auditLogThread.setPreviousValue("Sampling interval",keyValue);
							
							keyValue = configValue[6];
							auditLogThread.setPreviousValue("Stack trace depth",keyValue);
							
							keyValue = configValue[7];
							auditLogThread.setPreviousValue("Max samples",keyValue);
							
							keyValue = configValue[9];
							auditLogThread.setPreviousValue("Max concurrent requests",keyValue);
						}
					}
				}
				else 
				{
					if(variable.equalsIgnoreCase("RUM_injection_Via_BTM"))
					{
						String displayUIString = iniFileObj.getValue("RUM_INTEGRATION_TEMPLATE","RUM_injection_Via_BTM");
						String valuesList[] =displayUIString.split("%|%");
						String valueArray[] =valuesList[0].split("~\\|~");
						if(valueArray[0].equalsIgnoreCase("false"))
							auditLogThread.setPreviousValue("Enable RUM injection","No");
						auditLogThread.setPreviousValue("Real user monitor component",valueArray[1]);
						auditLogThread.setPreviousValue("Inject RUM script via BTM","No");
						auditLogThread.setPreviousValue("RUM code snippet","HTML");
					}
					else if(variable.equalsIgnoreCase("Integration_Cookie"))
					{
						String displayUIString = iniFileObj.getValue("RUM_INTEGRATION_TEMPLATE","Integration_Cookie");
						String Value[] =displayUIString.split("%|%");
						if(Value[0].equalsIgnoreCase("false"))
							auditLogThread.setPreviousValue("Enable RUM BTM Integration Cookie","No");
					}
					else if(variable.equalsIgnoreCase("Exception_and_Error")){
						String displayUIString = iniFileObj.getValue("EXCEPTION_AND_ERROR_TEMPLATE","Exception_and_Error");
						String valuesList[] =displayUIString.split("%|%");
						String valueArray[] =valuesList[0].split("~\\|~");
						if(valueArray[0].equalsIgnoreCase("false"))
							auditLogThread.setPreviousValue("Capture cause of exception","Disable");
						auditLogThread.setPreviousValue("Max exception cause depth",valueArray[1]);
						auditLogThread.setPreviousValue("Error status code range",valueArray[2]);
					}
					else if(variable.equalsIgnoreCase("SQL_and_JDBC")){
						String displayUIString = iniFileObj.getValue("SQL_AND_JDBC_TEMPLATE","SQL_and_JDBC");
						String valuesList[] =displayUIString.split("%|%");
						auditLogThread.setPreviousValue("Max sql call count limit",valuesList[0]);
					}
					else if(variable.equalsIgnoreCase("Miscellaneous"))
					{
						String displayUIString = iniFileObj.getValue("MISCELLANEOUS_TEMPLATE","Miscellaneous");

						String valuesList[] =displayUIString.split("%|%");
						auditLogThread.setPreviousValue("Remote header address",valuesList[0]);
					}
					else if(variable.equalsIgnoreCase("Settings"))
					{
						String displayUIString = iniFileObj.getValue("DIAGNOSTIC_SESSION_TEMPLATE","Settings");
						String valuesList[] =displayUIString.split("%|%");
						String valueArray[] =valuesList[0].split("~\\|~");
						auditLogThread.setPreviousValue("Diagnostic session is enabled",valueArray[0]);
						auditLogThread.setPreviousValue("Business Transaction",valueArray[1]);
						auditLogThread.setPreviousValue("URL",valueArray[2]);
						auditLogThread.setPreviousValue("Diagnosis session duration",valueArray[3]);
						auditLogThread.setPreviousValue("Max parallel collections within a minute",valueArray[4]);
						auditLogThread.setPreviousValue("Sampling interval",valueArray[5]);
						auditLogThread.setPreviousValue("Stack trace depth",valueArray[6]);
						auditLogThread.setPreviousValue("Max samples",valueArray[7]);
						auditLogThread.setPreviousValue("Max concurrent requests",valueArray[8]);
					}
				}
				
				//Current Value
				apmConfig.addConfigEntry(section, variable, componentId, map);
				if(section.equalsIgnoreCase("RUM_Integration"))
				{
					if(variable.equalsIgnoreCase("RUM_injection_Via_BTM"))
					{	
						String keyValue=String.valueOf(map.get("Enable_rum_integration"));
							
						if(keyValue.equalsIgnoreCase("true"))
							auditLogThread.setCurrentValue("Enable RUM injection","Yes");
						else
							auditLogThread.setCurrentValue("Enable RUM injection","No");
						
						auditLogThread.setCurrentValue("Real user monitor component",String.valueOf(map.get("Real_user_monitor_component")));
						keyValue=String.valueOf(map.get("Inject_rum_script_via_btm"));
						
						if(keyValue.equalsIgnoreCase("true"))
							auditLogThread.setCurrentValue("Inject RUM script via BTM","Yes");
						else
							auditLogThread.setCurrentValue("Inject RUM script via BTM","No");
					
						keyValue=String.valueOf(map.get("RUM_code_snippet"));
							
						if(keyValue.equalsIgnoreCase("true"))
							auditLogThread.setCurrentValue("RUM code snippet","HTML");
						else
							auditLogThread.setCurrentValue("RUM code snippet","Javascript");
						
						auditLogThread.setValue("Activity","RUM injection via BTM");
						Description="RUM injection via BTM has been updated for ";
					}
					else if(variable.equalsIgnoreCase("Integration_Cookie"))
					{
						String value=String.valueOf(map.get("Drop_RUM_BTM_Integration_Cookie"));
						if(value.equalsIgnoreCase("true"))
							auditLogThread.setCurrentValue("Enable RUM BTM Integration Cookie","Yes");
						else
							auditLogThread.setCurrentValue("Enable RUM BTM Integration Cookie","No");
						
						auditLogThread.setValue("Activity","Integration Cookie");
						Description="Integration Cookie has been updated for ";
					}
				}
				 else if(section.equalsIgnoreCase("Exception_and_Error"))
				{
					
					String keyValue=String.valueOf(map.get("ERROR_STATUS_CODE_RANGE"));
					auditLogThread.setCurrentValue("Error status code range",keyValue);
							
					keyValue=String.valueOf(map.get("MAX_EXCEPTION_CAUSE_DEPTH"));
					auditLogThread.setCurrentValue("Max exception cause depth",keyValue);
							
					keyValue=String.valueOf(map.get("CAPTURE_CAUSE_OF_EXCEPTION"));
							
					if(keyValue.equalsIgnoreCase("true"))
						auditLogThread.setCurrentValue("Capture cause of exception","Enable");
					else
						auditLogThread.setCurrentValue("Capture cause of exception","Disable");
							
					auditLogThread.setValue("Activity","Exception and Error");
					Description="Exception and Error has been updated for ";
							
				}
				else if(section.equalsIgnoreCase("SQL_and_JDBC"))
				{
					String keyValue=String.valueOf(map.get("MAX_SQL_CALL_COUNT_LIMIT"));
					auditLogThread.setCurrentValue("Max sql call count limit",keyValue);
					auditLogThread.setValue("Activity","SQL and JDBC");	
					Description="SQL and JDBC has been updated for ";
					
				}
				else if(section.equalsIgnoreCase("Miscellaneous"))
				{
					String value=String.valueOf(map.get("REMOTE_HEADER_ADDRESS"));
					auditLogThread.setCurrentValue("Remote header address",value);
					auditLogThread.setValue("Activity","Miscellaneous");
					Description="Miscellaneous has been updated for ";
				}
				else		
				{
					String keyValue=String.valueOf(map.get("Enable_Diagnostic_Session"));
					if(keyValue.equalsIgnoreCase("true"))
						auditLogThread.setCurrentValue("Diagnostic session is enabled","Yes");
					else
						auditLogThread.setCurrentValue("Diagnostic session is enabled","No");
					
					keyValue=String.valueOf(map.get("Business_Transaction"));
					auditLogThread.setCurrentValue("Business Transaction",keyValue);
					
					keyValue=String.valueOf(map.get("URL"));
					auditLogThread.setCurrentValue("URL",keyValue);
					
					keyValue=String.valueOf(map.get("Diagnosis_Session_Duration"));
					auditLogThread.setCurrentValue("Diagnosis session duration",keyValue);
					
					keyValue=String.valueOf(map.get("Max_Parallel_Collections_within_a_Minute"));
					auditLogThread.setCurrentValue("Max parallel collections within a minute",keyValue);
					
					keyValue=String.valueOf(map.get("Sampling_Interval"));
					auditLogThread.setCurrentValue("Sampling interval",keyValue);
					
					keyValue=String.valueOf(map.get("Stack_Trace_Depth"));
					auditLogThread.setCurrentValue("Stack trace depth",keyValue);
					
					keyValue=String.valueOf(map.get("Max_Samples"));
					auditLogThread.setCurrentValue("Max samples",keyValue);
					
					keyValue=String.valueOf(map.get("Max_Concurrent_Requests"));
					auditLogThread.setCurrentValue("Max concurrent requests",keyValue);
					
					auditLogThread.setValue("Activity","Diagnostic session");
					Description="Diagnostic session has been updated for ";
					
				}	
					auditLogThread.setValue("Description",Description+compNickName+":"+comPort);
					auditLogThread.sendItToDB();
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(rootJson.size() > 0){
				out.println(rootJson.toString());
			}
		}
	}else if(action.equalsIgnoreCase("reset")){
		JSONObject rootJson = new JSONObject();
		try {
			EgApmConfigEntry apmConfig = new EgApmConfigEntry();
			IniFile iniFileObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_apm.ini");
			HashMap map = apmConfig.readTemplateValueMap(section, variable);
			JSONObject jsonObj = new JSONObject();
			if(map.size() > 0){
				Iterator it = map.keySet().iterator();
				while(it.hasNext())
				{
					String dkey = (String) it.next();
					String key = dkey.substring(dkey.lastIndexOf(".")+1, dkey.length());
					String value = (String)map.get(key);
					jsonObj.put(key,value);
				}
			}
			try{
				//Previous Value
				String oldConfig = apmConfig.getConfigIniEntry(variable,componentId);
				String configEntry[] = getOldConfigEntry(oldConfig);
				
				if(configEntry!=null && configEntry.length > 0)
				{
					if(configEntry[0].equalsIgnoreCase("RUM_INTEGRATION_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						if(configValue.length==4){
							String keyValue= configValue[0];
							if(keyValue!=null)
							{
								if(keyValue.equalsIgnoreCase("true"))
									auditLogThread.setPreviousValue("Enable RUM injection","Yes");
								else
									auditLogThread.setPreviousValue("Enable RUM injection","No");
							}
							else{
								auditLogThread.setPreviousValue("Enable RUM injection","Yes");
							}
							keyValue = configValue[1];
							auditLogThread.setPreviousValue("Real user monitor component",keyValue);

							keyValue = configValue[2];
							if(keyValue.equalsIgnoreCase("true"))
								auditLogThread.setPreviousValue("Inject RUM script via BTM","Yes");
							else
								auditLogThread.setPreviousValue("Inject RUM script via BTM","No");
							
								auditLogThread.setPreviousValue("RUM code snippet","HTML");
						}
						else
						{
							String keyValue= configValue[0];
							if(keyValue.equalsIgnoreCase("true"))
								auditLogThread.setPreviousValue("Enable RUM BTM Integration Cookie","Yes");
							else
								auditLogThread.setPreviousValue("Enable RUM BTM Integration Cookie","No");
						}
					}
					else if(configEntry[0].equalsIgnoreCase("EXCEPTION_AND_ERROR_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						String keyValue= configValue[0];
						if(keyValue.equalsIgnoreCase("true"))
							auditLogThread.setPreviousValue("Capture cause of exception","Enable");
						else
							auditLogThread.setPreviousValue("Capture cause of exception","Disable");
						keyValue= configValue[1];
						auditLogThread.setPreviousValue("Max exception cause depth",keyValue);
						keyValue= configValue[2];
						auditLogThread.setPreviousValue("Error status code range",keyValue);
					}
					else if(configEntry[0].equalsIgnoreCase("SQL_AND_JDBC_TEMPLATE"))
					{
						auditLogThread.setPreviousValue("Max sql call count limit",configEntry[1]);
					}
					else if(configEntry[0].equalsIgnoreCase("MISCELLANEOUS_TEMPLATE"))
					{
						auditLogThread.setPreviousValue("Remote header address",configEntry[1]);
					}
					else if(configEntry[0].equalsIgnoreCase("DIAGNOSTIC_SESSION_TEMPLATE"))
					{
						String configValue[] = configEntry[1].split("~\\|~");
						if(configValue.length>4){
							String keyValue= configValue[0];
							if(keyValue!=null)
							{
								if(keyValue.equalsIgnoreCase("true"))
									auditLogThread.setPreviousValue("Diagnostic session is enabled","Yes");
								else
									auditLogThread.setPreviousValue("Diagnostic session is enabled","No");
							}
							
							keyValue = configValue[1];
							auditLogThread.setPreviousValue("Business Transaction",keyValue);
							
							keyValue = configValue[2];
							auditLogThread.setPreviousValue("URL",keyValue);
							
							keyValue = configValue[3];
							auditLogThread.setPreviousValue("Diagnosis session duration",keyValue);
							
							keyValue = configValue[4];
							auditLogThread.setPreviousValue("Max parallel collections within a minute",keyValue);
							
							keyValue = configValue[5];
							auditLogThread.setPreviousValue("Sampling interval",keyValue);
							
							keyValue = configValue[6];
							auditLogThread.setPreviousValue("Stack trace depth",keyValue);
							
							keyValue = configValue[7];
							auditLogThread.setPreviousValue("Max samples",keyValue);
							
							keyValue = configValue[9];
							auditLogThread.setPreviousValue("Max concurrent requests",keyValue);
							
						}
					}
				}
				String Description="";
				//Current Value
				if(variable.equalsIgnoreCase("RUM_injection_Via_BTM"))
				{
					String displayUIString = iniFileObj.getValue("RUM_INTEGRATION_TEMPLATE","RUM_injection_Via_BTM");
					String valuesList[] =displayUIString.split("%|%");
					String valueArray[] =valuesList[0].split("~\\|~");
					if(valueArray[0].equalsIgnoreCase("false"))
						auditLogThread.setCurrentValue("Enable RUM injection","No");
					auditLogThread.setCurrentValue("Real user monitor component",valueArray[1]);
					if(valueArray[2].equalsIgnoreCase("false"))
						auditLogThread.setCurrentValue("Inject RUM script via BTM","No");
					auditLogThread.setCurrentValue("RUM code snippet","HTML");
					auditLogThread.setValue("Activity","RUM injection via BTM");
					Description="RUM injection via BTM has been reset for ";
				}
				else if(variable.equalsIgnoreCase("Integration_Cookie"))
				{
					String displayUIString = iniFileObj.getValue("RUM_INTEGRATION_TEMPLATE","Integration_Cookie");
					String Value[] =displayUIString.split("%|%");
					if(Value[0].equalsIgnoreCase("false"))
						auditLogThread.setCurrentValue("Enable RUM BTM Integration Cookie","No");
					auditLogThread.setValue("Activity","Integration Cookie");
					Description="Integration Cookie has been reset for ";
				}
				else if(variable.equalsIgnoreCase("Exception_and_Error")){
					
					String displayUIString = iniFileObj.getValue("EXCEPTION_AND_ERROR_TEMPLATE","Exception_and_Error");
					String valuesList[] =displayUIString.split("%|%");
					String valueArray[] =valuesList[0].split("~\\|~");
					if(valueArray[0].equalsIgnoreCase("false"))
						auditLogThread.setCurrentValue("Capture cause of exception","Disable");
					auditLogThread.setCurrentValue("Max exception cause depth",valueArray[1]);
					auditLogThread.setCurrentValue("Error status code range",valueArray[2]);
					auditLogThread.setValue("Activity","Exception and Error");
					Description="Exception and Error has been reset for ";
				}
				else if(variable.equalsIgnoreCase("SQL_and_JDBC")){
					String displayUIString = iniFileObj.getValue("SQL_AND_JDBC_TEMPLATE","SQL_and_JDBC");
					String valuesList[] =displayUIString.split("%|%");
					auditLogThread.setCurrentValue("Max sql call count limit",valuesList[0]);
					auditLogThread.setValue("Activity","SQL and JDBC");
					Description="SQL and JDBC has been reset for ";
				}
				else if(variable.equalsIgnoreCase("Miscellaneous"))
				{
					String displayUIString = iniFileObj.getValue("MISCELLANEOUS_TEMPLATE","Miscellaneous");
					String valuesList[] =displayUIString.split("%|%");
					auditLogThread.setCurrentValue("Remote header address",valuesList[0]);
					auditLogThread.setValue("Activity","Miscellaneous");
					Description="Miscellaneous has been reset for ";
				}
				else 
				{
					String displayUIString = iniFileObj.getValue("DIAGNOSTIC_SESSION_TEMPLATE","Settings");
					System.out.println("displayUIString :"+displayUIString);
					String valuesList[] =displayUIString.split("%|%");
					String valueArray[] =valuesList[0].split("~\\|~");
					auditLogThread.setCurrentValue("Diagnostic session is enabled",valueArray[0]);
					auditLogThread.setCurrentValue("Business Transaction",valueArray[1]);
					auditLogThread.setCurrentValue("URL",valueArray[2]);
					auditLogThread.setCurrentValue("Diagnosis session duration",valueArray[3]);
					auditLogThread.setCurrentValue("Max parallel collections within a minute",valueArray[4]);
					auditLogThread.setCurrentValue("Sampling interval",valueArray[5]);
					auditLogThread.setCurrentValue("Stack trace depth",valueArray[6]);
					auditLogThread.setCurrentValue("Max samples",valueArray[7]);
					auditLogThread.setCurrentValue("Max concurrent requests",valueArray[8]);
					auditLogThread.setValue("Activity","Diagnostic session");
					Description="Diagnostic session has been reset for ";
				}
				auditLogThread.setValue("Description",Description+compNickName+":"+comPort);
			}catch(Exception e){
				e.printStackTrace();
			}finally{
				auditLogThread.sendItToDB();
			}
			rootJson.put("result",jsonObj);
			apmConfig.resetConfigEntry(section, variable, componentId, map);
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(rootJson.size() > 0){
				out.println(rootJson.toString());
			}
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}

%>

<%!

	EgApmConfigEntry apmConfig = new EgApmConfigEntry();
	String SAMPLING_DIAGNOSTICSESSION = "SAMPLING_DIAGNOSTICSESSION";
	private void getDefaultConfigs(HashMap fieldMap, String section, String variable){
		try {
			ArrayList keyList = new ArrayList();
			ArrayList valueList = new ArrayList();
			EgApmConfigEntry apmConfig = new EgApmConfigEntry();
			String defaultValues[] = apmConfig.readTemplateValues(section, variable);
			String defaultKeys[] = apmConfig.readTemplateKeys(section, variable);
			for(int index = 0; index < defaultKeys.length; index++){
				String dkey = defaultKeys[index];
				//String defaultKey = dkey.substring(dkey.lastIndexOf(".")+1, dkey.length());
				keyList.add(dkey);
				valueList.add(defaultValues[index]);
			}
			fieldMap.put("keyList",keyList);
			fieldMap.put("valueList",valueList);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private String[] getOldConfigEntry(String configvalue){
		if(configvalue!=null && configvalue.length() > 0){
			String value[] = configvalue.split("~\\%~");
			return value;
		}
		return null;
	}

	private void getUpdatedConfigs(String arrayValue, HashMap fieldMap, String section, String variable){
		try {
			ArrayList keyList = new ArrayList();
			ArrayList valueList = new ArrayList();
			EgApmConfigEntry apmConfig = new EgApmConfigEntry();
			String defaultKeys[] = apmConfig.readTemplateKeys(section, variable);
			if(defaultKeys!=null){
				String value[] = arrayValue.split("~\\%~");
				String valueArray[] = value[1].split("~\\|~");
				for(int index = 0; index < defaultKeys.length; index++){
					String dkey = defaultKeys[index];
					//String defaultKey = dkey.substring(dkey.lastIndexOf(".")+1, dkey.length());
					keyList.add(dkey);
					valueList.add(valueArray[index]);
				}
				fieldMap.put("keyList",keyList);
				fieldMap.put("valueList",valueList);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private String addOption(String value,String option) {
		StringBuffer buffer = new StringBuffer();
		try {
			if(value.equalsIgnoreCase(option)) {
				buffer.append("<option value=\""+option+"\" selected>"+option+"</option>");
			}else {
				buffer.append("<option value=\""+option+"\">"+option+"</option>");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer.toString();
	}

	
	private String getLogOption(HashMap fieldMap, String componentId, HttpSession session,String comPort, String compNickName,String variable,EgMappingInfo _mapping){
		JSONArray logFields=new JSONArray();
		StringBuffer hiddenFormFields = new StringBuffer();
		HashMap valuesMap = new HashMap();
		try{
			
			//commented old valueMap
			//Format: type#%#drop-down-box Items#%#event method call#%#display units#%#height#%#width#%#drop-down Title Text#%#drop-down disabled#%#description
			valuesMap.put("LOG_LEVEL","DROP-DOWN-BOX#%#ALL~!~TRACE~!~DEBUG~!~INFO~!~WARN~!~ERROR~!~OFF#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Various log levels - ALL, TRACE, DEBUG, INFO, WARN, ERROR and OFF"));
			valuesMap.put("LOG_FILE_COUNT","TEXT-BOX#%#NO_DATA#%#onkeypress=\"javascript:return isNumber(event)\"#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Maximum number of rotated log files to be maintained"));
			valuesMap.put("LOG_FILE_SIZE","TEXT-BOX#%#NO_DATA#%#onkeypress=\"javascript:return isNumber(event)\"#%# (MB)#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Maximum log file size (in MB)"));
			valuesMap.put("FILTER_MATCH","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#300px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Log messages are filtered based on the match string"));
			valuesMap.put("LAYOUT","DROP-DOWN-BOX#%#text~!~json#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Log messages are logged as either plain text / json format"));
			valuesMap.put("PATTERN","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#300px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Logging pattern used which is applicable for text layout"));
			valuesMap.put("CAPTURE_CAUSE_OF_EXCEPTION","RADIO-BUTTON#%#Enable~!~Disable#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable or Disable to capture the cause of the Exception(s)"));
			valuesMap.put("REMOTE_HEADER_ADDRESS","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#121px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Use this name to get the client ip using HTTP Header(s)"));
			valuesMap.put("MAX_EXCEPTION_CAUSE_DEPTH","TEXT-BOX#%#NO_DATA#%#onkeypress=\"javascript:return isNumber(event)\"#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.To limit the depth of root cause when CAPTURE_CAUSE_OF_EXCEPTION is Enable"));
			valuesMap.put("ERROR_STATUS_CODE_RANGE","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.To mark a transaction as error when the HTTP response status code is within the range provided"));
			valuesMap.put("MAX_SQL_CALL_COUNT_LIMIT","TEXT-BOX#%#NO_DATA#%#onkeypress=\"javascript:return isNumber(event)\"#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.To limit the Max. SQL call count captured in a business transaction(include Fast/Slow/Error)"));
			valuesMap.put("Defult_Text_Box","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#NO_DATA");
			valuesMap.put("Enable_rum_integration","RADIO-BUTTON#%#Yes~!~No#%#onchange=\"clearRumIntegrationFilter(this)\"#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable or Disable RUM injection"));
			String rumComps = getRumComponents(session);
			String displayString = (rumComps.length()<2)?"None":_mapping.getTextDescription("admin.apm.setting.Please select a Component");
			valuesMap.put("Real_user_monitor_component","DROP-DOWN-BOX#%#"+rumComps+"#%#NO_DATA#%#NO_DATA#%#23px#%#200px#%#"+displayString+"#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Select the real user monitoring component"));
			valuesMap.put("Inject_rum_script_via_btm","HIDDEN#%#true#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable or Disable RUM integration"));
			valuesMap.put("RUM_code_snippet","RUMCODEHIDDEN#%#true#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting. HTML is the default"));
			valuesMap.put("Enable_Diagnostic_Session","RADIO-BUTTON#%#Enable~!~Disable#%#onchange=\"clearDiagnosticSession(this)\"#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable or Disable diagnostic session for the business transaction"));
			String btmTrans = getBusinessTransaction(comPort,compNickName);
			String btmDisplay = (btmTrans.length()<2)?"None":_mapping.getTextDescription("admin.apm.setting.Select a Transaction");
			valuesMap.put("Business_Transaction","DROP-DOWN-BOX#%#"+btmTrans+"#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#"+btmDisplay+"#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Select the business transaction for which the deep diagnosis to be enabled"));
			valuesMap.put("Sampling.URL","TEXT-BOX#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable deep diagnosis for a specific URL"));
			valuesMap.put("Diagnosis_Session_Duration","DROP-DOWN-BOX#%#"+getDiagnosisSessionDuration()+"#%#NO_DATA#%# (Minutes)#%#23px#%#83px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Deep diagnosis duration(in minutes) for the selected business transaction"));
			valuesMap.put("Max_Parallel_Collections_within_a_Minute","DROP-DOWN-BOX#%#"+getMaxParallelColection()+"#%#NO_DATA#%#NO_DATA#%#23px#%#83px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Maximum number of deep diagnosis collections for a request that are started within a minute"));
			valuesMap.put("Sampling_Interval","DROP-DOWN-BOX#%#"+getApmIniValue(SAMPLING_DIAGNOSTICSESSION,"Sampling_interval")+"#%#NO_DATA#%#NO_DATA#%#23px#%#83px#%#NO_DATA#%#true#%#"+_mapping.getTextDescription("admin.apm.setting.Time interval between sample collection"));
			valuesMap.put("Stack_Trace_Depth","DROP-DOWN-BOX#%#"+getApmIniValue(SAMPLING_DIAGNOSTICSESSION,"Stack_trace_depth")+"#%#NO_DATA#%#NO_DATA#%#23px#%#83px#%#NO_DATA#%#true#%#"+_mapping.getTextDescription("admin.apm.setting.The maximum number of allowed lines for a sample"));
			valuesMap.put("Max_Samples","DROP-DOWN-BOX#%#"+getApmIniValue(SAMPLING_DIAGNOSTICSESSION,"Max_samples")+"#%#NO_DATA#%#NO_DATA#%#23px#%#83px#%#NO_DATA#%#true#%#"+_mapping.getTextDescription("admin.apm.setting.Maximum number of samples to be collected for a request"));
			valuesMap.put("Max_Concurrent_Requests","DROP-DOWN-BOX#%#"+getApmIniValue(SAMPLING_DIAGNOSTICSESSION,"Max_concurrent_requests")+"#%#NO_DATA#%#NO_DATA#%#23px#%#83px#%#NO_DATA#%#true#%#"+_mapping.getTextDescription("admin.apm.setting.Maximum number of concurrent requests allowed for sampling"));
			valuesMap.put("Drop_RUM_BTM_Integration_Cookie","RADIO-BUTTON#%#Yes~!~No#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Enable or Disable RUM BTM integration cookie"));
			valuesMap.put("Is_diagnostic_session_enabled","LABEL#%#Yes#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Diagnostic Session is Enabled or Not"));
			valuesMap.put("Diagnostic_session_started_at","LABEL#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Time at which Diagnostic Session was started"));
			valuesMap.put("Diagnosis_session_remaining_duration","LABEL#%#NO_DATA#%#NO_DATA#%#(Minutes)#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Remaining Time for the Diagnostic session"));
			valuesMap.put("Business_Transaction_label","LABEL#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.Business Transaction"));
			valuesMap.put("URL_label","LABEL#%#NO_DATA#%#NO_DATA#%#NO_DATA#%#23px#%#100%#%#NO_DATA#%#NO_DATA#%#"+_mapping.getTextDescription("admin.apm.setting.URL"));

			String utcTimeMillis = getUTCTimeMillis();
			valuesMap.put("Sampling.UTC_Time","HIDDEN#%#"+utcTimeMillis+"#%#NO_DATA#%#NO_DATA#%#23px#%#81px#%#NO_DATA#%#NO_DATA#%#NO_DATA");
			StringBuffer idBuffer = new StringBuffer();
			ArrayList keysList = (ArrayList)fieldMap.get("keyList");
			ArrayList valuesList = (ArrayList)fieldMap.get("valueList");
			IniFile iniFileObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_apm.ini");
			if(keysList!=null && valuesList!=null && keysList.size() > 0 && valuesList.size() >0 && keysList.size() == valuesList.size())
			{
				for(int index = 0;index < keysList.size(); index++)
				{
					String dkey = (String)keysList.get(index);
					String key = dkey.substring(dkey.lastIndexOf(".")+1, dkey.length());
					String value = (String)valuesList.get(index);
					if(idBuffer.length()>0) {
						idBuffer.append(",");
					}
					idBuffer.append(key);
					String valuesString="";
					String finalKey=key;
					if(valuesMap.containsKey(key)){
						valuesString = valuesMap.get(key).toString();
					}else if(valuesMap.containsKey(dkey)){
						valuesString = valuesMap.get(dkey).toString();
						finalKey=dkey;
					}else{
						valuesString = valuesMap.get("Defult_Text_Box").toString();
					}
					
					String valuesToken[] = valuesString.split("#@#");
					if(valuesToken == null){
						continue;
					}

					String fieldDescription = "";
					String detailsString  = "";
					
					if(valuesToken.length == 2){
						detailsString = valuesToken[0];
						fieldDescription =_mapping.getTextDescription("admin.apm.setting."+valuesToken[1]);
					}
					else if(valuesToken.length == 1){
						detailsString = valuesToken[0];
					}

					if(detailsString == null || detailsString.equals("")){
						continue;
					}

					String valuesArray[] = detailsString.split("#%#");
					if(valuesArray == null || valuesArray.length < 8){
						continue;
					}

					String displayUIString = iniFileObj.getValue("Display_Menu",key);
					if(displayUIString == null || displayUIString.equals("")){
						displayUIString = key;
					}
						
					String fieldType = getData(valuesArray[0]);
					String fieldValue = getData(valuesArray[1]);
					String eventTxt = getData(valuesArray[2]);
					String unitText = getData(valuesArray[3]);
					String displayKey = displayUIString.replaceAll("_"," ")+unitText;
					String heightPX = getData(valuesArray[4]);
					String widthPX = getData(valuesArray[5]);
					String dropDownTitleTxt = getData(valuesArray[6]);
					String dropDownDisabled = getData(valuesArray[7]);
					 fieldDescription = getData(valuesArray[8]);

					if(fieldType.equalsIgnoreCase("DROP-DOWN-BOX"))
					{	
						StringBuffer htmlStr = new StringBuffer();
						if(dropDownDisabled.equalsIgnoreCase("true")){
							htmlStr.append("<select disabled style=\"height:"+heightPX+";width:"+widthPX+";\" id=\""+key+"\" name=\""+key+"\">");
						}else{
							htmlStr.append("<select style=\"height:"+heightPX+";width:"+widthPX+";\" id=\""+key+"\" name=\""+key+"\">");
						}
						htmlStr.append("<option selected disabled hidden value=\"\">"+dropDownTitleTxt+"</option>");
						if(fieldValue!=null && !fieldValue.equalsIgnoreCase("")){
							String fieldList[] = fieldValue.split("~!~");
							for(int optIndex=0;optIndex<fieldList.length;optIndex++) {
								htmlStr.append(addOption(value,fieldList[optIndex]));
							}
						}
						htmlStr.append("</select>");
						logFields.add(appendFormFiled(index, keysList, idBuffer, componentId, displayKey, fieldDescription, htmlStr.toString(), hiddenFormFields));
					}else if(fieldType.equalsIgnoreCase("RADIO-BUTTON"))
					{
						String fieldList[] = fieldValue.split("~!~");
						String yesChecked = (value.equalsIgnoreCase("true")) ? " checked " : "";
						String noChecked = (value.equalsIgnoreCase("false")) ? " checked " : "";
						String htmlStr = "<input type=\"radio\" name=\""+key+"\" id=\""+key+"\" autocomplete=\"off\" "+yesChecked+" value=\"true\" "+eventTxt+"><label f or=\""+key+"\">&nbsp;"+fieldList[0]+"&nbsp;</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"radio\" name=\""+key+"\" id=\""+key+"\" autocomplete=\"off\" "+noChecked+"value=\"false\" "+eventTxt+"><label for=\""+key+"\">&nbsp;"+fieldList[1]+"&nbsp;</label>";
						logFields.add(appendFormFiled(index, keysList, idBuffer, componentId, displayKey, fieldDescription, htmlStr, hiddenFormFields));
					}else if(fieldType.equalsIgnoreCase("HIDDEN"))
					{
						String htmlStr = "<input type=\"hidden\" name=\""+key+"\" id=\""+key+"\" value=\""+fieldValue+"\" \">";
						hiddenFormFields.append(htmlStr);
					}
					else if(fieldType.equalsIgnoreCase("RUMCODEHIDDEN"))
					{
						value="HTML";
						String htmlStr="<input type=\"hidden\" name=\""+key+"\" id=\""+key+"\" value=\""+fieldValue+"\" \">"+value+"";	
						logFields.add(appendFormFiled(index, keysList, idBuffer, componentId, displayKey, fieldDescription, htmlStr, hiddenFormFields));
					}
					else if(fieldType.equalsIgnoreCase("LABEL"))
					{
						long remainingTime = getRemainingDuration(componentId);
						String label[]=getLabelValues(componentId);
						if(key.equalsIgnoreCase("Is_diagnostic_session_enabled"))
						{
							if(label[0].equalsIgnoreCase("false")|| remainingTime <= 0)
								value="No";
							else
								value ="Yes";
							
						}
						else if(key.equalsIgnoreCase("Diagnostic_session_started_at"))
						{
							String TimeUTC=label[4];
							Long TimeUTCLong=Long.parseLong(TimeUTC);
							DateFormat obj = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
							Date startedTiming = new Date(TimeUTCLong);
							if(remainingTime<=0)
								value="None";
							else
								value=obj.format(startedTiming);
						}
						else if(key.equalsIgnoreCase("Diagnosis_session_remaining_duration"))
						{
							// convert to minutes
							//long durationInsec = remainingTime / 1000L;
							long minutes = TimeUnit.MILLISECONDS.toMinutes(remainingTime);
							value=""+minutes;
						}
						else if(key.equalsIgnoreCase("Business_Transaction_label"))
						{
							if(remainingTime<=0)
								value="None";
							else
								value=label[2];
						}
						else if(key.equalsIgnoreCase("URL_label"))
						{
							if(remainingTime<=0)
								value="None";
							else
								value=label[3];
						}
						String htmlStr="<label for=\"html\" name=\""+key+"\" id=\""+key+"\" value=\""+value+"\">"+value+"</label><br>";	
						logFields.add(appendFormFiled(index, keysList, idBuffer, componentId, displayKey, fieldDescription, htmlStr, hiddenFormFields));
					}
					else 
					{
						String htmlStr = "<input type=\"text\" name=\""+key+"\" id=\""+key+"\" autocomplete=\"off\" value=\""+value+"\" style=\"height:"+heightPX+";width:"+widthPX+"; \""+eventTxt+"\" \">";
						logFields.add(appendFormFiled(index, keysList, idBuffer, componentId, displayKey, fieldDescription, htmlStr, hiddenFormFields));
					}
				}
			}
		}catch(Exception e) {
			e.printStackTrace();
		}
		return logFields.toString();
	}
	
	private long getRemainingDuration(String componentId)
	{
		String label[]=getLabelValues(componentId);
		String TimeUTC=label[4];
		String transactionDuration =label[1];
		int transDurationMin=Integer.parseInt(transactionDuration);

		long currentUtcTime = getUTCTimeLongMillis();
		long transactionDurationOld=0L;
		
		if(TimeUTC.equalsIgnoreCase("None"))
			transactionDurationOld=0L;
		else
			transactionDurationOld =Long.parseLong(TimeUTC);

		long diff =currentUtcTime - transactionDurationOld;

		long durationInMillis = transDurationMin * 60 * 1000L;

		long remainTime = 0L;
		
		if(diff < durationInMillis){
			remainTime = durationInMillis - diff;
		}
		return remainTime;
	}
	
	private String[] getLabelValues(String componentId)
	{
		String oldConfig = apmConfig.getConfigIniEntry("Settings",componentId);
		String resultArray[]= new String[5];
		String configEntry[] = getOldConfigEntry(oldConfig);
		if(configEntry!=null && configEntry.length > 0)
		{
			if(configEntry[0].equalsIgnoreCase("DIAGNOSTIC_SESSION_TEMPLATE"))
			{
				String configValue[] = configEntry[1].split("~\\|~");
				String keyValue= configValue[0];
				resultArray[0]=keyValue;
				resultArray[1]= configValue[3];
				resultArray[2]=configValue[1];
				resultArray[3]=configValue[2];
				resultArray[4]=configValue[8];
			}
		}
		else{
			resultArray[0]="false";
			resultArray[1]="15";
			resultArray[2]="None";
			resultArray[3]="None";
			resultArray[4]="0";
		}
		return resultArray;
	}
	
	
	private String appendKeyIdentity(int index, ArrayList keys,StringBuffer buffer, String componentId,StringBuffer hiddenFormFields){
		String keyList="";
		try {
				if(index+1 == keys.size()) {
					buffer.append(",guidValue");
					keyList = hiddenFormFields.toString()+"<input type=\"hidden\" name=\"keyIdentityList\" id=\"keyIdentityList\" value=\""+buffer.toString()+"\"><input type=\"hidden\" name=\"guidValue\" id=\"guidValue\" value=\""+componentId+"\">";
				}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return keyList;
	}
	
	private String appendFormFiled(int index, ArrayList keysList, StringBuffer idBuffer,  String componentId, String displayKey, String description, String htmlTxt, StringBuffer hiddenFormFields){
		StringBuffer buffer = new StringBuffer();
		try {
				buffer.append("{");
				buffer.append("'propName': '"+displayKey+" <img src=\"/final/images/spacer.gif\" style=\"height:30px;vertical-align: middle;\"/>',");
				buffer.append("'propValue': '"+appendKeyIdentity(index,keysList,idBuffer,componentId,hiddenFormFields)+htmlTxt+"',");
				buffer.append("'propDesc': '"+description+"',");
				buffer.append("}");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer.toString();
	}
	
	private String getData(String value) {
		try {
			if(value.equalsIgnoreCase("NO_DATA")) {
				value = "";
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return value;
	}
	
	private String getRumComponents(HttpSession session) {
		StringBuffer buffer = new StringBuffer();
		try {
			EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(), (String) session.getAttribute("sess_userid"));
			EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
			egSpecs.checkForUpdate();
			ArrayList<String> rumComponents = egSpecs.getAllComponentTypesForTest("RUMAppTest");
			ArrayList servers = null;
			for (int b = 0; b < rumComponents.size(); b++) {
				String strServer = rumComponents.get(b);
				if (strServer == null || strServer.equalsIgnoreCase("null"))
				strServer = "";
				String[] serversArray = roleInfo.getAllServersOfType(strServer);
				servers = serversArray == null ? new ArrayList(): new ArrayList(Arrays.asList(serversArray));
				if (servers == null || servers.size() <= 0) {
					continue;
				}
			}
			for (int r = 0; r< servers.size(); r++) {
				String serverTxt = (String)servers.get(r);
				if(serverTxt.indexOf("Real_user_monitor")!=-1){
					String rumComp[] = serverTxt.split(":");
					if(buffer.length()>0) {
						buffer.append("~!~");
					}
					buffer.append(rumComp[1]);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer.toString();
	}
	
	private String getBusinessTransaction(String comPort, String compNickName){
		StringBuffer buffer = new StringBuffer();
		try {
				String stackTraceDetailsQuery = "select distinct info  from Businesstranstest_DDD where TRGT_HOST='"+compNickName+"' and port_no ='"+comPort+"'";
				com.egurkha.EgQueryRunner dbRunner = new com.egurkha.EgQueryRunner();
				java.util.List<Map<String,Object>> map  = dbRunner.select(stackTraceDetailsQuery, true);
				for (Map<String,Object> rowData : map) {
					if(buffer.length()>0) {
						buffer.append("~!~");
					}
					buffer.append(rowData.get("info").toString().substring(1));
				}
		} catch (Exception e) {
			String errorMessage = e.getMessage().toLowerCase();
			if(errorMessage.contains("invalid object name") || errorMessage.contains("table or view does not exit")){
				// Do Nothing
			}
			else {
				e.printStackTrace();
			}
		}
		return buffer.toString();
	}
	
	private String getDiagnosisSessionDuration(){
		StringBuffer buffer = new StringBuffer();
		try {
				int minValue = Integer.parseInt(getApmIniValue(SAMPLING_DIAGNOSTICSESSION, "Diagnosis_session_duration_min_value"));
				int maxValue = Integer.parseInt(getApmIniValue(SAMPLING_DIAGNOSTICSESSION, "Diagnosis_session_duration_max_value"));
				for(int count=minValue;count<=maxValue;count+=5){
					if(buffer.length()>0) {
						buffer.append("~!~");
					}
					buffer.append(count);
				}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer.toString();
	}
	
	private String getMaxParallelColection(){
		StringBuffer buffer = new StringBuffer();
		try {
				int minValue = Integer.parseInt(getApmIniValue(SAMPLING_DIAGNOSTICSESSION, "Max_parallel_collections_within_a_minute_min_value"));
				int maxValue = Integer.parseInt(getApmIniValue(SAMPLING_DIAGNOSTICSESSION, "Max_parallel_collections_within_a_minute_max_value"));
				for(int count=minValue;count<=maxValue;count++){
					if(buffer.length()>0) {
						buffer.append("~!~");
					}
					buffer.append(count);
				}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer.toString();
	}
	
	private String getApmIniValue(String section, String variable){
		String value = "";
		try {
			String apmIniPath = EgInstallInfo.getInstallDir() + "/manager/config/eg_apm.ini";
			IniFile iniFileObj = new IniFile(apmIniPath);
			value = iniFileObj.getValue(section,variable);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return value;
	}
	
	private String getUTCTimeMillis(){
		String milis="0";
		try {
			Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC")); 
			milis = String.valueOf(cal.getTimeInMillis());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return milis;
	}

	private long getUTCTimeLongMillis(){
		long milis= 0L;
		try {
			Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC")); 
			milis = cal.getTimeInMillis();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return milis;
	}
%>
