var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
        selType: 'checkboxmodel',
        mode: 'MULTI',
        checkOnly: true,
        renderer: function (val, meta, record, rowIndex, colIndex, store, view) {
            if (record.get('isDisabled')) {
                meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
                return '<div class="iconLock" style="position:relative;left:-5px">&#160;</div>';
            } else {
                meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
                return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
            }
        },
        selectAll: function () {
            var rowIndex = 0;
            while (typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex)) != 'undefined') {
                var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
                if (record.get('isDisabled')) {
                    Ext.getCmp('mainBTMJarsgrid').getSelectionModel().deselect(rowIndex, true);
                } else {
                    Ext.getCmp('mainBTMJarsgrid').getSelectionModel().select(rowIndex, true);
                }
                rowIndex++;
            }
            var view = Ext.getCmp('mainBTMJarsgrid').getView();
            var headerCt = view.headerCt;
            var hdSelectStatus = this.selected.getCount() === this.store.getCount();
            var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
            if (checkHd) {
                checkHd.el.addCls(Ext.baseCSSPrefix + 'grid-hd-checker-on');
            }
        },
        deselectAll: function () {
            var rowIndex = 0;
            while (typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex)) != 'undefined') {
                var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
                Ext.getCmp('mainBTMJarsgrid').getSelectionModel().deselect(rowIndex, true);
                rowIndex++;
            }
            var view = Ext.getCmp('mainBTMJarsgrid').getView();
            var headerCt = view.headerCt;
            var hdSelectStatus = this.selected.getCount() === this.store.getCount();
            var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
            if (checkHd) {
                checkHd.el.removeCls(Ext.baseCSSPrefix + 'grid-hd-checker-on');
            }
        }
    });

Ext.define('BTMProfilerDownload.view.BTMJarGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.btmjargrid',
    id: 'mainBTMJarsgrid',
    selType: 'checkboxmodel',
    ui: 'newGridPanel',
    emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">' + NoBtmFound + '</td></tr></table></td></tr></table>',
    requires: [
        'Ext.ux.CheckColumn',
        'Ext.ux.RowExpander',
        'Ext.grid.*',
        'utilities.CustomGrid',
        'Ext.ux.data.PagingMemoryProxy',
        'BTMProfilerDownload.view.BTMJar',
    ],
    viewConfig: {
        deferEmptyText: true
    },
    margin: '10 0 10 10',
    cls: 'outerpanel',
    flex: 1,

    initComponent: function () {
        this.dockedItems = [{
                xtype: 'pagingtoolbar',
                id: 'gridRmtDisplay',
                store: this.store,
                remoteFilter: true,
                dock: 'bottom',
                cls: 'newPagination',
                displayInfo: true,
                selModel: mySelectionModel,
                listeners: {
                    beforeselect: function (selModel, record, index) {
                        if (record.get('isDisabled')) {
                            return false;
                        }
                    },
                    rowclick: function (in_this, rowIndex, e) {
                        var record = in_this.getStore().getAt(rowIndex);
                        if (record.get('isDisabled')) {
                            in_this.getSelectionModel().deselectRow(rowIndex);
                        }
                    }
                },
            }
        ];
        this.callParent();
    },

    tools: [],

    dockedItems: [],

    columns: [{
            text: "APM TYPE",
            dataIndex: 'APMName',
            id: 'DispAPMName',
            flex: 0.5,
        }, {
            text: "Component Type",
            dataIndex: 'compType',
            id: 'DispCompType',
            flex: 0.6,
            // hidden:true
        }, {
            text: "Nick Name",
            dataIndex: 'CompNickName',
            id: 'DispCompNickName',
            flex: 0.7
        }, {
            text: "Host name/IP",
            dataIndex: 'hostIP',
            id: 'DispHostIP',
            flex: 0.5,
            // width: 200
        }, {
            text: 'Host Port',
            dataIndex: 'comPort',
            id: 'DispComPort',
            flex: 0.4,
            // width: 200
        }, {
            text: "Agent IP",
            dataIndex: 'agentIP',
            id: 'DispAgentIP',
            flex: 0.5,
            // width: 200
        }, {
            text: "Monitoring",
            dataIndex: 'monitoring',
            id: 'DispMonitoring',
            flex: 0.5,
        }, {
            text: "Application Name",
            dataIndex: 'appName',
            id: 'DispappName',
            flex: 0.6,
      			//INFO: Uncomment this when no appflow need
            // hidden:true
        }, {
            text: "Tier Name",
            dataIndex: 'tierName',
            id: 'DispTierName',
            flex: 0.4,
	      		//INFO: Uncomment this when no appflow need
            //hidden:true
        }, {
            text: "GUID",
            dataIndex: 'GUID',
            id: 'DispGuid',
            flex: 2,
            hidden: true,
            renderer: function (value, metaData, record, row, col, store, gridView) {
                metaData.tdAttr = "data-qtip='" + value + "' data-qclass='yellowTip'";
                return "<div style='cursor:pointer'>" + value + "</div>";
            }
        }, {
            text: "EG Server Type",
            dataIndex: 'egServerType',
            id: 'egServerType',
            flex: 0.6,
            hidden: true,
        },  {
            text: "Node Js Script",
            dataIndex: 'nodejsScript',
            id: 'nodejsScript',
            flex: 0.6,
            hidden: true,
        },{
			      //INFO: Uncomment this when no appflow need
            // hidden:true,
            // header : '<div class="iconHelp3" data-qtip="Optional: Specifiy Application name & Tier name to corresponding components" data-qclass="yellowTip"></div>',
            header: '<div class="iconTooltipHelp" data-qtip="Optional: Specifiy Application name & Tier name to corresponding components" data-qclass="yellowTip"></div>',
            xtype: 'actioncolumn',
            // width: 35,
            flex: 0.2,
            id: 'EditRmtOver',
            sortable: false,
            renderer: function (value, metaData, record, row, col, store, gridView) {
                metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
                var hostName = record.get('CompNickName');
                return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleEditIconClick('" + gridView + "','" + row + "','" + col + "')\" class='iconModify'></div>";
            }
        }, {
			
            header: '<div class="iconTooltipHelp" data-qtip="'+copyJVMOption+'" data-qclass="yellowTip"></div>',
            xtype: 'actioncolumn',
            flex: 0.2,
            id: 'CopyRmtOver',
            sortable: false,
            renderer: function (value, metaData, record, row, col, store, gridView) {
        				var obj = Ext.getCmp('gridRmtDisplay').getStore().getAt(row);
        				var apmType = obj.get('APMName');
        				var copyOptionTitle=""
        				if(apmType=="NODE.JS"){
        					copyOptionTitle=copyNodeJsOption;
        				}else{
        					copyOptionTitle=copyJVMOption
        				}
	
                metaData.tdAttr = "data-qtip='"+copyOptionTitle+"' data-qclass='yellowTip'";
                return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.copyComponentGuid('" + gridView + "','" + row + "','" + col + "')\" class='iconCopy'></div>";
            }
        }, {
			
            header: '<div class="iconTooltipHelp" data-qtip="'+settingTxt+'" data-qclass="yellowTip"></div>',
            xtype: 'actioncolumn',
            flex: 0.2,
            id: 'advancedSettingsOption',
            sortable: false,
            renderer: function (value, metaData, record, row, col, store, gridView) {
        				var obj = Ext.getCmp('gridRmtDisplay').getStore().getAt(row);
        				var apmType = obj.get('APMName');
        				if(apmType=="NODE.JS"){
							    //metaData.tdAttr = "data-qtip='"+settingTxt+"' data-qclass='yellowTip'";
        					//return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.showSettiongsOption('" + gridView + "','" + row + "','" + col + "')\" class='iconConfigure'></div>";
        					metaData.tdAttr = "";
        					return "";
        				}else{
        					metaData.tdAttr = "data-qtip='"+settingTxt+"' data-qclass='yellowTip'";
        					return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.showAdvancedSettiongsOption('" + gridView + "','" + row + "','" + col + "')\" class='iconConfigure'></div>";
        				}
            }
        }, {
            header: '<div class="icStorage_small" data-qtip="Download Selected" data-qclass="yellowTip"></div>',
            xtype: 'actioncolumn',
            // width: 200,
            flex: 0.1,
            id: 'download',
            sortable: false,
            listeners: {
                headerclick: function (g, index, ev) {
                    appRmtCnt.handleDownloadSelected();
                }
            },
            renderer: function (value, metaData, record, row, col, store, gridView) {
                metaData.tdAttr = "data-qtip='Download' data-qclass='yellowTip'";
                return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleDownloadIconClick('" + gridView + "','" + row + "','" + col + "')\" class='iconDownload'></div>";
            }
        }
    ]
});