<%
/**
 *	Name		:	EgUpgradeStatusJson.jsp
 *	Purpose		:	
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "java.util.List" %>
<%@ page import = "java.util.LinkedList" %>
<%@ page import = "java.util.Iterator" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.ArrayUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogHashtable"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	Hashtable map = new Hashtable();
	map.put("AIX","AIX");
	map.put("HPUX","HP-UX");
	map.put("LINUX","Linux");
	map.put("SOLARIS","Solaris");
	map.put("TRU64","Tru64");
	map.put("WINDOWSNT","Windows XP");
	map.put("WINDOWS2000","Windows 2000");
	map.put("WINDOWS2003","Windows 2003");
	map.put("WINDOWS2008","Windows 2008");
	map.put("WINDOWS2012","Windows 2012");
	map.put("WINDOWS2016","Windows 2016");
	map.put("WINDOWS2019","Windows 2019");
	map.put("WINDOWS2022","Windows 2022");
	if(request.getParameter("firstTime") != null && request.getParameter("firstTime").equals("true"))
	{
		session.setAttribute("selectTab","tab1");
	}
	JSONObject rootJSON = new JSONObject();
	JSONObject jsnObj;
	rootJSON.put("success","true");
	
	String str = request.getParameter("AgentStatus");
	if(str == null || str.equals("")) str = "Enabled";
	UpgradeStatusHelper ush = new UpgradeStatusHelper();

	List agents = ush.getAllDetails();
	if (agents.size() > 0)
	{
		String separator = ush.getSeparator();
		User user=registry.getUser(session.getId());
		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		String thisLanguage = ui.getDefaultLanguage();
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
		String none=mappingInfo.getTextDescription("admin.common.None");
		String versions=mappingInfo.getTextDescription("admin.upgrade.Version");
		String operatingsystem=mappingInfo.getTextDescription("admin.upgrade.Operating System");
		String upgradesetting=mappingInfo.getTextDescription("admin.upgrade.Upgrade Status"); 
		String jreversion=mappingInfo.getTextDescription("admin.upgrade.JRE Version");
		String lastupgrade=mappingInfo.getTextDescription("admin.upgrade.Last Upgraded Package ID");
		String componentType=mappingInfo.getTextDescription("admin.upgrade.Component Type");

		String[] options = {none,versions,operatingsystem,upgradesetting,jreversion,lastupgrade,componentType};
		String selectedOption = request.getParameter("filterBy");
		if (StringUtils.isNull(selectedOption))
		{
			selectedOption = options[0];
		}
		List list = new ArrayList();
		String csvFilterBy = "Filter By, " + selectedOption;
		list.add(csvFilterBy);

		Hashtable forprint = new Hashtable();
		forprint.put("Filter By",selectedOption);

		Object[] filterOptions = null;
		if (selectedOption.equals(options[1]))
		{
			/*
			 * Get the versions
			 */
			List version = new LinkedList();
			for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
			{
				String line = (String)iterator.next();
				String[] tokens = StringUtils.getTokens(line, separator);
				if (version.indexOf(tokens[1]) == -1)
				{
					version.add(tokens[1]);
				}
			}
			filterOptions = version.toArray();
		}
		else if (selectedOption.equals(options[2]))
		{
			/*
			 * Get the OSes
			 */
			filterOptions = new String[] {"AIX", "HPUX", "Linux", "Solaris", "Windows2003","Windows2008","Windows2012","Windows2016","Windows2019","Windows2022"};
		}
		else if (selectedOption.equals(options[3]))
		{
			/*
			 * Upgrade settings
			 */
			filterOptions = new String[] {"Enabled", "Disabled"};
		}
		else if (selectedOption.equals(options[4]))
		{
			/*
			 * Get the versions
			 */
			List version = new LinkedList();
			for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
			{
				String line = (String)iterator.next();
				String[] tokens = StringUtils.getTokens(line, separator);
				if (version.indexOf(tokens[tokens.length-1]) == -1)
				{
					version.add(tokens[tokens.length-1]);
				}
			}
			filterOptions = version.toArray();
		}
		else if(selectedOption.equals(options[5]))
		{
			List upgradeList = new ArrayList();
			for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
			{
				String line = (String)iterator.next();
				String[] tokens = StringUtils.getTokens(line, separator);
				if(!upgradeList.contains(tokens[6]))
				{
					upgradeList.add(tokens[6]);
				}
			}
			if(!upgradeList.isEmpty())
			{
				Collections.sort(upgradeList,String.CASE_INSENSITIVE_ORDER);
				for(int k=0; k<upgradeList.size(); k++)
				{
					String s = (String) upgradeList.get(k);
					if(s.equalsIgnoreCase("NONE"))
					{
						upgradeList.remove(k);
						if(!upgradeList.contains("NONE"))
						{
							upgradeList.add(0,"NONE");
						}
					}
				}
				filterOptions =  upgradeList.toArray();
			}
			else
			{
				filterOptions = new String[] {"NONE"};
			}
		}
		else if(selectedOption.equals(options[6]))
		{
			EgDiscInfo discInfo = new EgDiscInfo("manager");
			Vector v_allComps = discInfo.getAllManagedComponents();
			Vector compTypeList=new Vector();
			for(int i=0;i < v_allComps.size(); i++)
			{
				String component=(String)v_allComps.elementAt(i);
				String serverName=component.substring(0,component.indexOf(","));
				if(!compTypeList.contains(serverName))
					compTypeList.add(serverName);
			}
			if(!compTypeList.isEmpty())
			{
				compTypeList.remove("WVD_RDS_server");
				if(compTypeList != null && !compTypeList.isEmpty())
				{
					ArrayList componentTypes = new ArrayList();
					componentTypes.addAll(compTypeList);
					compTypeList.clear();
					EgName nameObj = null;
					MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
					ArrayList serverList = sorter.getSortedCompTypeList(componentTypes);
					for(int i=0;i<serverList.size();i++)
					{
						nameObj = (EgName)serverList.get(i);
						compTypeList.add(nameObj.getActualName());
					}
				}
				filterOptions =  compTypeList.toArray();
			}
			else
			{
				filterOptions = new String[] {"NONE"};
			}
		}

		String selectedCriteria = request.getParameter("filterCriteria");
		if ((StringUtils.isNull(selectedCriteria) 
			|| filterOptions == null)
			|| !ArrayUtils.contains(filterOptions, selectedCriteria))
		{
			if (filterOptions == null)
			{
				selectedCriteria = EgConstants.BLANK_STRING;
			}
			else
			{
				selectedCriteria = (String)filterOptions[0];
			}
		}
		if(selectedOption != null && !selectedOption.equalsIgnoreCase("none"))
		{
			String csvFilterCriteria = "Filter Criteria,";
			if(map.containsKey(selectedCriteria.toUpperCase()))
			{
				csvFilterCriteria += (String)map.get(selectedCriteria.toUpperCase());
			}
			else
			{
				csvFilterCriteria += selectedCriteria;
			}
			String selCriteria = selectedCriteria;
			if(selectedOption.equals(options[6]))
			{
				csvFilterCriteria = "Filter Criteria," + mappingInfo.getComponentTypeDescription(selectedCriteria);
				selCriteria = mappingInfo.getComponentTypeDescription(selectedCriteria);
			}
			list.add(csvFilterCriteria);
			if(map.containsKey(selCriteria.toUpperCase()))
			{
				forprint.put("Filter Criteria",(String)map.get(selCriteria.toUpperCase()));
			}
			else
			{
				forprint.put("Filter Criteria",selCriteria);
			}
		}
		JSONArray filters = new JSONArray();
		for (int f=0; f < options.length; f++)
		{
			jsnObj = new JSONObject();
			jsnObj.put("displayField",options[f]);
			jsnObj.put("valueField",options[f]);
			filters.add(jsnObj);
		}
		rootJSON.put("filterBy",filters);
		rootJSON.put("filterBySelected",selectedOption);

		if (selectedOption.equals(options[0]))
		{
			rootJSON.put("filterCriteriaOption",false);
		}
		else
		{
			rootJSON.put("filterCriteriaOption",true);
			JSONArray citerias = new JSONArray();
			for (int f=0; f < filterOptions.length; f++)
			{
				jsnObj = new JSONObject();
				String filterOption = (String)filterOptions[f];
				if(selectedOption.equals(options[6]))
				{
					jsnObj.put("displayField",mappingInfo.getComponentTypeDescription(filterOption));
					jsnObj.put("valueField",filterOption);
					citerias.add(jsnObj);
				}
				else
				{
					if(filterOption.equalsIgnoreCase("None"))
					{
						filterOption = "NONE (Not yet upgraded)";
					}
					String oskey=filterOption.toUpperCase();
					if(map.containsKey(oskey))
					{
						jsnObj.put("displayField",(String)map.get(oskey));
						jsnObj.put("valueField",filterOptions[f]);
					}
					else
					{
						jsnObj.put("displayField",filterOption);
						jsnObj.put("valueField",filterOptions[f]);
					}
					citerias.add(jsnObj);
				}
			}
			rootJSON.put("filterCriteria",citerias);
			rootJSON.put("filterCriteriaSelected",selectedCriteria);
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[3]))
		{
			rootJSON.put("gridStatusCol",true);
		}
		else
		{
			rootJSON.put("gridStatusCol",false);
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[2]))
		{
			rootJSON.put("gridOsCol",true);
		}
		else
		{
			rootJSON.put("gridOsCol",false);
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[1]))
		{
			rootJSON.put("gridVersionCol",true);
		}
		else
		{
			rootJSON.put("gridVersionCol",false);
		}
		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[4]))
		{
			rootJSON.put("gridJreVersionCol",true);
		}
		else
		{
			rootJSON.put("gridJreVersionCol",false);
		}
		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[5]))
		{
			rootJSON.put("gridUpgrade",true);
		}
		else
		{
			rootJSON.put("gridUpgrade",false);
		}
		int lin  = 0;
		int sol  = 0;
		int aix  = 0;
		int hpux = 0;
		int w2k3 = 0;
		int w2k8 = 0;
		int w2k12 = 0;
		int w2k16 = 0;
		int w2k19 = 0;
		int w2k22 = 0;

		AuditLogHashtable tableRowsPrintDataHt = new AuditLogHashtable();
		ArrayList tableRowsColumnPdf = new ArrayList();
		ArrayList tableRows = new ArrayList();
		boolean columnsForCsvNotSet=true;
		Vector columnNamesForCSV = new Vector();
		int count = 0;
		JSONArray gridData = new JSONArray();
		for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
		{
			String line = (String)iterator.next();
			String[] tokens = StringUtils.getTokens(line, separator);
			/*
			 * tokens[0] : Agent IP/Name
			 * tokens[1] : Version
			 * tokens[2] : Upgrade setting
			 * tokens[3] : Operating system
			 * tokens[4] : Host name
			 * tokens[5] : Startup time
			 * tokens[6] : Last upgraded package
			 * tokens[7] : Last upgraded time
			 */
			String agent = tokens[0];
			if (agent.indexOf(EgConstants.COLON) > -1)
			{
				agent = StringUtils.replace(agent, EgConstants.COLON, ", ");
			}
			if(agent.indexOf("#~#")>-1)
			{
				//for WVD Host Pool components
				agent = StringUtils.replace(agent, "#~#", " - ");
			}
			String agentVer = tokens[1];
			String upgradeVer = tokens[2];
			String osName = tokens[3];
			String lastUpgrade = tokens[6];
			if ((osName).equalsIgnoreCase("linux")) lin++;
			else if ((osName).equalsIgnoreCase("aix")) aix++;
			else if ((osName).equalsIgnoreCase("hpux")) hpux++;
			else if ((osName).equalsIgnoreCase("solaris"))sol++;
			else if ((osName).equalsIgnoreCase("windows2003"))w2k3++;
			else if ((osName).equalsIgnoreCase("windows2008"))w2k8++;
			else if ((osName).equalsIgnoreCase("windows2012"))w2k12++;
			else if ((osName).equalsIgnoreCase("windows2016"))w2k16++;
			else if ((osName).equalsIgnoreCase("windows2019"))w2k19++;
			else if ((osName).equalsIgnoreCase("windows2022"))w2k22++;

			if (!tokens[7].equalsIgnoreCase("None"))
			{
				tokens[7] = (new java.util.Date(Long.parseLong(tokens[7]))).toString();
			}
			String javaVersion = tokens[8];

			boolean condition = false;
			if (selectedOption.equals(options[1]))
			{
				condition = (selectedCriteria.equals(agentVer));
			}
			else if (selectedOption.equals(options[2]))
			{
				condition = (selectedCriteria.equals(osName));
			}
			else if (selectedOption.equals(options[3]))
			{
				condition = (selectedCriteria.equals(upgradeVer));
			}
			else if(selectedOption.equals(options[4]))
			{
				condition = (selectedCriteria.equals(javaVersion));
			}
			else if(selectedOption.equals(options[5]))
			{
				condition = (selectedCriteria.equals(lastUpgrade));
			}
			else if (selectedOption.equals(options[6]))
			{
				EgDiscInfo discInfo = new EgDiscInfo("manager");
				Hashtable hh = discInfo.getServerTypesForAllNicks();
				String allAgents[] = StringUtils.getTokens(tokens[0],":");
				for(int m=0;m<allAgents.length;m++)
				{
					List componentTypes1 = (List)hh.get(allAgents[m]);
					if(componentTypes1 != null && componentTypes1.contains(selectedCriteria))
					{
						condition=true;
						break;
					}
				}
			}
			else if (selectedOption.equals(options[0]))
			{
				condition = true;
			}
			ArrayList tableRowsPrintData = new ArrayList();
			String csvRow = "";
			if (condition)
			{
				JSONObject gridRow = new JSONObject();
				gridRow.put("AgentID",agent);
				if(columnsForCsvNotSet)
				{
					columnNamesForCSV.add("Agent ID");
					tableRowsColumnPdf.add("Agent ID");
				}
				csvRow = "\""+agent+"\"";
				tableRowsPrintData.add(agent);
				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[5]))
				{
					tableRowsPrintData.add(lastUpgrade);
					csvRow += ","+lastUpgrade;
					if(columnsForCsvNotSet)
					{
						tableRowsColumnPdf.add("Last Upgraded Package ID");
						columnNamesForCSV.add("Last Upgraded Package ID");
					}
					gridRow.put("LastUpgradedPackageID",lastUpgrade);
				}
				gridRow.put("LastUpgradedTime",tokens[7]);
				tableRowsPrintData.add(tokens[7]);
				csvRow += ","+tokens[7];
				if(columnsForCsvNotSet)
				{
					columnNamesForCSV.add("Last Upgraded Time");
					tableRowsColumnPdf.add("Last Upgraded Time");
				}
				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[3]))
				{
					tableRowsPrintData.add(upgradeVer);
					csvRow += ","+upgradeVer;
					if(columnsForCsvNotSet)
					{
						tableRowsColumnPdf.add("Status");
						columnNamesForCSV.add("Status");
					}
					gridRow.put("Status",upgradeVer);
				}

				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[2]))
				{
					String displayOs=(String)map.get(osName.toUpperCase());
					tableRowsPrintData.add(displayOs);
					csvRow += ","+displayOs;
					if(columnsForCsvNotSet)
					{
						tableRowsColumnPdf.add("OS");
						columnNamesForCSV.add("OS");
					}
					gridRow.put("OS",displayOs);
				}

				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[1]))
				{
					tableRowsPrintData.add(agentVer);
					csvRow += ","+agentVer;
					if(columnsForCsvNotSet)
					{
						tableRowsColumnPdf.add("Version");
						columnNamesForCSV.add("Version");
					}
					gridRow.put("Version",agentVer);
				}
				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[4]))
				{
					tableRowsPrintData.add(javaVersion);
					csvRow += ","+javaVersion;
					if(columnsForCsvNotSet)
					{
						tableRowsColumnPdf.add("JRE Version");
						columnNamesForCSV.add("JRE Version");
					}
					gridRow.put("JREVersion",javaVersion);
				}
				gridData.add(gridRow);
				count++;
				columnsForCsvNotSet=false;
				tableRows.add(csvRow);
				tableRowsPrintDataHt.put(agent,tableRowsPrintData);
			}
		}
		rootJSON.put("agentInfoGrid",gridData);
		if (count == 0)
		{
			rootJSON.put("noAgentsFound",true);
		}

		if (count>0)
		{
			rootJSON.put("selectedAgentsCount",count);
		}
		rootJSON.put("totalAgentsCount",(aix+hpux+lin+sol+w2k3+w2k8+w2k12+w2k16));

		String csvAgentsCount = "Agents for your current selection," + count;
		list.add(csvAgentsCount);
		list.add(columnNamesForCSV);


		forprint.put("count",String.valueOf(count));
		forprint.put("table_columns",tableRowsColumnPdf);
		forprint.put("table_rows",tableRowsPrintDataHt);
		session.setAttribute("forPdf",forprint);

		if(tableRows != null && !tableRows.isEmpty())
		{
			for(int i=0;i<tableRows.size();i++)
			{
				list.add((String)tableRows.get(i));
			}
		}
		session.setAttribute("list",list);
		session.setAttribute("isAuditlogCSV","true");


		List tab2ListCSV = new ArrayList();
		Vector tab2Headers = new Vector();
		tab2Headers.add("OPERATING SYSTEM");
		tab2Headers.add("AGENTS");
		tab2ListCSV.add(tab2Headers);

		ArrayList tab2Headers1 = new ArrayList();
		tab2Headers1.add("OPERATING SYSTEM");
		tab2Headers1.add("AGENTS");

		AuditLogHashtable tab2Rows = new AuditLogHashtable();
		Hashtable tab2Print = new Hashtable();
		tab2Print.put("table_columns",tab2Headers1);

		String[] osList =  new String[] {"AIX", "HPUX", "LINUX", "SOLARIS", "WINDOWS2003","WINDOWS2008","WINDOWS2012","WINDOWS2016","WINDOWS2019","WINDOWS2022"};
		String[] osCount = new String[] {aix+"", hpux+"", lin+"", sol+"", w2k3+"", w2k8+"", w2k12+"", w2k16+"", w2k19+"", w2k22+""};
		JSONArray osCountArray = new JSONArray();
		JSONObject osRow;
		for (int a=0; a < osList.length; a++)
		{
			String displayOs=(String)map.get(osList[a]);
			ArrayList tmp = new ArrayList();
			osRow = new JSONObject();
			osRow.put("OS",displayOs);
			osRow.put("Agents",osCount[a]);
			osCountArray.add(osRow);

			tmp.add(displayOs);
			tmp.add(osCount[a]);
			tab2Rows.put(new Integer(a),tmp);

			tab2ListCSV.add(displayOs+","+osCount[a]);
		}
		tab2Print.put("table_rows",tab2Rows);
		osRow = new JSONObject();
		osRow.put("OS","<b>"+_mapping.getTextDescription("admin.upgrade.Total agents")+"</b>");
		osRow.put("Agents","<b>"+(aix+hpux+lin+sol+w2k3+w2k8+w2k12+w2k16+w2k19+w2k22)+"</b>");
		osCountArray.add(osRow);
		rootJSON.put("totalAgentsGrid",osCountArray);

		session.setAttribute("listTab2",tab2ListCSV);
		session.setAttribute("forPdfTab2",tab2Print);
	}
	else
	{
		rootJSON.put("noAgentsConfigured",true);
	}

	//block starts for pdf
	String mngrIProc = new IniFile(new com.eg.EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName = mngrIProc+"/final/admin/AgentUpgradeStatus/data/upgradeAgentStatusPrint.jsp;jsessionid="+session.getId()+"?reloaded=true&pdfpage=true";
	session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","AGENT UPGRADE STATUS");
	session.setAttribute("REPORT_LAYOUT","Landscape");//Portrait
	session.setAttribute("PAGE_WIDTH_PDF","1500");
	//block ends for pdf


	out.println(rootJSON);
%>







