Ext.define('TemplateReportApp.view.DatabaseTable',{
	extend:'Ext.container.Container',
	alias:'widget.databasetable',
	layout:'column',
	columnWidth:1.0,
	id:'databasetable_id',
	margin: '10 0 0 0',
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		try
		{
			var headerColumFields = new Array();
			var columnArray = new Array();
			var resultsValue = resultJson.RESULTS;
			var reportData = resultsValue['panelObj'];
			var selectionDetailsData = resultsValue['selectionDetails'];
			var er_title = resultJson.er_title;
			var summaryTable = reportData.Summary;
			var gridValuesArray = reportData.Detail;
			var currentSessionData = reportData.chartJSON
			var actualval = reportData.Actual
			var percentageVal = reportData.Percentage
			var columns = reportData.HeaderObj;
			var percentTitle = reportData.PercentTitle;
			var selectedtest = reportData.SelectedTest;
			var selectedmeasure = reportData.SelectedMeasure;

			if(!Ext.isEmpty(columns)) 
			{
				for (var key in columns)
				{
					var alignValue = 'center';
					var headerName = columns[key];
					var sortingVal = true;
					if(key!=null && key == 'Percentage')
					{
						//sortingVal = false;
					}
					if(key!=null && key == 'Test Name')
					{
						alignValue = 'left';
					}

					headerColumFields.push(key);
					columnArray.push({
						header: headerName,
						sortable:sortingVal,
						flex:1.5,
						align: alignValue,
						dataIndex: key,
						renderer: function (value, metaData, record, row, col, store, gridView)
						{
							var toolotipVal=value;
							if(value != undefined && value.indexOf('~')>-1)
							{
								var decimalValue = value.substring( 0, value.indexOf('~') );
								toolotipVal=decimalValue;
								var classandColor = value.substring( value.indexOf('~') + 1 );
								if(classandColor != undefined && classandColor.indexOf('#')>-1)
								{
									var myClass = classandColor.substring( 0, classandColor.indexOf('#') );
									var myColor = classandColor.substring( classandColor.indexOf('#') + 1 );
									value = '<table align="center"><tbody><tr style="width:100%"><td style="width:20%"><div class="'+myClass+'"></div></td><td style="width:80%"><div style="text-align:center;color:#ffffff;border-radius:2px;background:'+myColor+'">'+decimalValue+'</div></td></tr></tbody></table>';
								}
								else
								{
									value = '<table align="center"><tbody><tr style="width:100%"><td style="width:20%"><div class="'+classandColor+'"></div></td><td style="width:80%"><div style="text-align:center">'+decimalValue+'</div></td></tr></tbody></table>';
								}
							}
							
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolotipVal+'"';
							return value;
						},
						doSort: function(state) {
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							if(field=='Percentage')
							{
								field = 'PercentageVal';
							}
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(!isNaN(v1) && !isNaN(v2))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
									}
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						},
					});
				}
			}
			headerColumFields.push('PercentageVal');
			var painnationNeeded = false;
			if (gridValuesArray != undefined && gridValuesArray != 'undefined' && gridValuesArray.length <= 20)
			{
				painnationNeeded = true;
			}

			var paddingCustom = null;
			var percentTable = null;

			if(percentageVal != undefined && percentageVal.indexOf('#')>-1)
			{
				var decimalVal = percentageVal.substring( 0, percentageVal.indexOf('#') );
				var decimalClass = percentageVal.substring( percentageVal.indexOf('#') + 1 );
				
				percentTable = '<div class="'+decimalClass+'"><span style="padding-left:30px">'+decimalVal+'</span></div></div><br/><div class="newFont_normal13">'+percentTitle+'</div>';

				paddingCustom = '40px 50px';
			}
			else
			{
				percentTable = percentageVal + '</div><div class="newFont_normal13">'+percentTitle+'</div>';
				paddingCustom = '42px 50px';
			}

			var digitalHtm='<div style="width:100%;text-align:center;padding:'+paddingCustom+'"><div class="newFont_bold28">'+actualval+'</div><div class="newFont_normal13">Current Size (GB)</div><br/><br/><br/><br/><div class="newFont_bold28">'+percentTable+'</div>';

			this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:'<span class="newfont_bold14">Summary</span>',
					columnWidth:0.2,
					margin:'0 5 10 0',
					height:290,
					html:digitalHtm
				},
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:'<span class="newfont_bold14">Database Size Trend</span>',
					columnWidth:0.8,
					height:290,
					margin:'0 0 10 5',
					items:[{
						xtype:'container',
						id:'actualchaet',
						listeners: {
							'boxready' : function()
							{
								var highChart = {};
								highChart = jQuery.extend(true, {}, getHighChartsInstance('actualchaet',80,80), highChart);
								highChart.setData(currentSessionData,appConstants.currentDateFormat,'');
								highChart.drawChart();
							}
						}
					}]
				}
			);
			if(!Ext.isEmpty(columnArray))
			{
				var storeObj = Ext.create('Ext.data.ArrayStore', {
					fields : headerColumFields,
					proxy: {
						type:'pagingmemory',
						reader: {
							type: 'json'
						},
					},
					remoteSort:true,
					pageSize:20,
					autoLoad:true,
					data: gridValuesArray,
					sorters: { property: headerColumFields[1], direction : 'DESC' }
				});
				this.add({
					xtype:'panel',
					ui:'newGraphPanel',
					columnWidth:1.0,
					margin:'0 2 2 0',
					items:[
					{
						xtype:'customgrid',
						ui:'newGridPanel',
						margin:'10 10 10 10',
						forceFit:true,
						columnWidth:1.0,
						title:'<span class="newfont_bold14">Trend of tables with highest volume of data</span>',
						id:'gridId',
						frame:false,
						border:true,
						scroll:true,
						autoScroll:true,
						store: storeObj,
						columns: columnArray,
						listeners:
						{
							render:function(obj)
							{
								Ext.defer(function() 
								{
									if(!Ext.isEmpty(obj.columns[1]))
									{
										obj.columns[1].doSort('DESC');
									}
								},100);
							}
						},
						dockedItems:[{
							xtype:'container',
							dock: 'bottom',
							margin:'10 0 0 5',
							html:'<div style="font-style:italic;font-size:10px">*This trend considers tables with highest volume of data reported by '+selectedtest+' test of the '+selectionDetailsData['Component Type']+' - '+selectionDetailsData['Component']+'</div>'
						},{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:painnationNeeded,
							displayInfo: true,
							displayMsg: 'Displaying {0} - {1} of {2}',
							emptyMsg: "No topics to display",
						}]
					}]
				});
			}
			else
			{
				var noDataGridText = reportData.NoDataGridText;
				if(noDataGridText != undefined)
				{
					this.add({
						xtype:'panel',
						margin:'0 2 2 0',
						ui:"newGraphPanel",
						flex:1,
						columnWidth:1.0,
						height:120,
						title:'<span class="newfont_bold14">Trend of tables with highest volume of data</span>',
						html:'<div class="egFlexCenterByColumnWise" style="height:100%"><div class="iconInformation"></div> <div class="commonErrorMsgText">'+noDataGridText+'</div></div>',
						dockedItems:[{
							xtype:'container',
							dock: 'bottom',
							margin:'10 0 0 5',
							html:'<div style="font-style:italic;font-size:10px">*This trend considers tables with highest volume of data reported by '+selectedtest+' test of the '+selectionDetailsData['Component Type']+' - '+selectionDetailsData['Component']+'</div>'
						}]
					})
				}
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	setSelectionDetails:function(RESULTS)
	{
		if(appConstants.showMainForm=='yes')
		{
			Ext.getCmp('selectionDetails').setSelectionDetailsData(RESULTS.selectionDetails);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'container',
			columnWidth:1.0,
			margin:10,
			height:height,
			html:'<div class="egFlexCenterByColumnWise" style="height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'!</div> </div>'
		}
	}
});


