Ext.define('componentDashboard.view.virtual.virtualGraphPanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.virtualgraphpanel',
	requires:['componentDashboard.view.virtual.VirtualGraphGrid'],
	autoScroll:true,
	layout:{
		type:'column'
	},
	//title:"Key Performance Metrics To Display",
	jsonData : null,
	//style:{'border':'1px solid #c3c3c3'},
	cls:'datapanel',
	bodyPadding:5,
	id:'virtual-legend-tool',
	//bodyCls:'virtual-tab-upper-Background bottom-left-radius bottom-right-radius top-left-radius top-right-radius',
	border: true,
	
    initComponent : function(){
		 jsonData = this.jsonData;
		 if(!Ext.isEmpty(jsonData))
		 { 
			 if(typeof jsonData.graphInfoRoot !== "undefined")
			 {
			 	 this.title=jsonData.screenLabels.AnalysisGraphLabels.ChartHeader;
				 if(jsonData.hiddenFields.barchartStatus)
				 {
					 var imgbtn = jsonData.screenLabels.AnalysisGraphLabels.measuresViewImage;
					 var tooltip = jsonData.screenLabels.AnalysisGraphLabels.measuresViewTooltip;
					  this.tools=[{
							 xtype:'button',
								 action:'measuresgraph',
								 tooltip: tooltip,
								 //cls:'iconBarChart',
								style:{'background':'none','border':'none'},
								 iconCls:'iconAreaChart'
							 }];
				 }
				 else
				 {
					 var imgbtn = jsonData.screenLabels.AnalysisGraphLabels.barViewImage;
					 var tooltip = jsonData.screenLabels.AnalysisGraphLabels.barViewTooltip;
					// if(!Ext.isEmpty(Ext.getCmp('net-legend-tool')))
						//Ext.getCmp('net-legend-tool').removeAll();

					// if(!Ext.isEmpty(Ext.getCmp('sys-legend-tool')))
					//	Ext.getCmp('sys-legend-tool').removeAll();


					 var isChecked = jsonData.LegendInChart;
					 isChecked = (isChecked == 'false' || isChecked == 'no' )?0:1;
					 this.tools=[{
								xtype:'checkboxgroup',
								//cls: 'checkbt',
								id: 'er_chart_checkbox',
								margin:'0 10 0 0',
								
								items: [{
									boxLabel: 'Show Legends',
									inputValue: 'true',
									padding:'0 0 0 0',
									margin:'0 0 0 0',
									itemId: 'showLegend',
									cls: 'showLegend checkbt',
									checked:isChecked
									 }]
						},{
						 xtype:'button',
							 //cls:'virtual-graph-btn',
						 	 iconCls:'iconBarChart',
							style:{'background':'none','border':'none'},
							 action:'measuresgraph',
							 tooltip: tooltip
						 }];
				 }
				 var chartLength = jsonData.graphInfoRoot.length;
				 var j=0;
				 var columnWid = 1/3;
				 var chartItems = new Array();
				 
				 var selectedView = jsonData.viewComboSelected;
				 if((selectedView.indexOf("Memory")>-1))
				 {
					 for(var i=0;i<chartLength;i++)
					 {
					 	if(jQuery.isEmptyObject(jsonData.graphInfoRoot[i]))
						{
						 	//to avoid empty objects
						}
					 	else if(typeof jsonData.graphInfoRoot[i].measuregraphURL === "undefined")
					 	{
					 		chartItems.push(this.returnGrid(jsonData.graphInfoRoot[i],i,columnWid));
					 	}
						else
						{
							chartItems.push(this.returnChart(jsonData.graphInfoRoot[i],columnWid));
						}
					 }
				 }
				 else
				 {
					 for(var i=0;i<chartLength;i++)
					 {
						if(jQuery.isEmptyObject(jsonData.graphInfoRoot[i]))
						{
							//to avoid empty objects
						}
						else
						{
							chartItems.push(this.returnChart(jsonData.graphInfoRoot[i],columnWid));
						}
					  }
				 }
				 if(typeof jsonData.tablesInfo !== "undefined")
				 {
					 var cgridpanel;
					 if(!Ext.isEmpty(jsonData.tablesInfo.nodataFound) && typeof jsonData.tablesInfo.nodataFound !== "undefined")
					 {
						 var ptitle = jsonData.tablesInfo.Title;
						 var img = jsonData.tablesInfo.imageURL;
						 var msg = jsonData.tablesInfo.nodataFound;
						 cgridpanel={
								 xtype: 'panel',
								
								 title: ptitle,
								 cls:'block1',
								 margin: "10 5 10 10",
								 height:250,
								 columnWidth : columnWid,
								 //bodyCls:'virtual-tab-upper-Background',
								 html:'<center><div style="margin:20% 0 auto 0"><div class="iconInformation" ></div>'+msg+'</div></center>'
						 };
					 }
					 else
					 {
						 cgridpanel = {
								 xtype: 'virtualgraphgrid',
								//cls:'gridSkin',
								ui:'newGridPanel headerWrap with_DataPnl_Header whiteHeader',
								//border:true,
								frame:false,
								border:true,
								//style:{'border':'1px solid blue'},
								 jsonData: jsonData,
								 forceFit: true,
								 height:230,
								 columnWidth : columnWid,
								 margin: "10 0 10 10"
								 
						 };
					 }
					chartItems.push(cgridpanel);
				 
				 }
				 this.items=chartItems;
		 }//no graphinfo
		 else
		 {
			 var img = jsonData.NoDataAvailable.imageURL;
			 var msg = jsonData.NoDataAvailable.errorMessage;
			 this.border = true;
			 var errPanel = {
			 	  	xtype:'container',
					autoScroll:false,
					scroll:false,
					 //margin: "75 10 10 350",
					//style:{'border':'1px solid orange'},
					 height:250,
					 //columnWidth : columnWid,
					 width:'100%',
					 border:false,
					 //forcefit: true,
					 //bodyCls:'virtual-tab-upper-Background',
					 html:'<center style="margin:10% 0 auto 0"><div class="iconInformation"></div>'+msg+'</center>'
					 /*xtype:'panel',
					 margin: "75 10 10 350",
					//style:{'border':'1px solid orange'},
					 height:200,
					 columnWidth : columnWid,
					 border:false,
					 forcefit: true,
					 //bodyCls:'virtual-tab-upper-Background',
					 html:'<center style="position:absolute;top:50%;left:35%;"><div class="iconInformation"></div><br>'+msg+'</center>'*/
			 }
			 this.items=[errPanel];
		 }
	}//no jsondata
		 else
		 {
			 this.border = true;
			 var msg = 'No Data Received From Server!';
				var nodata={
						xtype:'panel',
						layout:'fit',
						//bodyCls: 'virtual-tab-upper-Background',
						//cls : 'header-image event-header-align',
						margin: '10 0 0 400',
						border:false,
						html : '<div style="text-align:center;padding:38px; top:100px; height:155px" class="system-error-bg"><br><div class="iconInformation"></div><div class="list-empty-text system-error-bg">'+msg+'</div></div>'
				}
			 this.items=[nodata];
		 }
		 this.callParent();
	 },
	returnChart : function(jsonData,columnWid){
		me=this;
		var chartPanel;
		var imgSrc = jsonData.measuregraphURL;
		var imgId = jsonData.grpId;
		var panTitle = jsonData.measuresGraphDisplayName+"("+jsonData.unitForMeasure+")";
		var htmlVal='';
		//alert("imgSrc--->"+imgSrc.indexOf("dashboardtimelinemeasures"));
		if ( !Ext.isEmpty( jsonData.chartOption ) && jsonData.chartOption=='highcharts')
		{
			var isAxisTimeReq = false;
			var legendPos = "bottom";
			var graphUrl = imgSrc;
			imgDiv = '<div class="component-list-left-font" style="width:100%"><b>'+panTitle+'</b></div><center><div id="'+imgId+'"/></div></center>';
			graphUrl = graphUrl+"&isSmall=true";
			var bigGrpUrl=jsonData.measureGraphMaximizeURL;
			var containerId = imgId;
			var sparObj = Ext.getCmp(containerId);
			if (!Ext.isEmpty(sparObj))
			{
				sparObj.destroy();
			}
			//---------key performance Metrics-----------------
			// High Chart
			chartPanel = {
				id:containerId,
				xtype :'panel',
				cls:'block1',
				title: panTitle,
				border:true,
				//padding:6,
			
				//cls : 'history-tab-header-image history-tab-header header-image',
				//bodyCls:'virtual-tab-upper-Background',
				layout :'fit',
				
				margin: "10 0 10 10",
				height: 230,
				//width:300,
				columnWidth : columnWid,
				listeners:{
					'afterrender': function(v){
						var panelWidth = ( $( window ).width() / 3 ) - 75;
						bigHighChart(graphUrl,v.body.id,190,panelWidth,bigGrpUrl,isAxisTimeReq,legendPos,'upper','true');
					}
				},
				/*items:[
				{
					xtype:'container',
					html:imgDiv
				}	
				],*/
				
				tools:[{
						xtype:'button',
						iconCls:'iconMaximize',
						style:{'background':'none'},
						border:false,
						clickUrl:bigGrpUrl,
						
						
						listeners:{
						'afterrender':function(thisObj){
							thisObj.el.on('click',function(){
							
								componentDashboard.app.getController("VirtualController").displayBigGraph(thisObj.clickUrl,"Measuregraph");
							});
						}
					}
				}],
				
			}
			return chartPanel;
		}
		else if ( !Ext.isEmpty( jsonData.chartOption ) && jsonData.chartOption=='graph')
		{
			htmlVal=' <div><b>'+panTitle+'</b></div><div><img width="100%" src="'+imgSrc+'" /></div>';
		}
		else
		{
			
			if(!valueFusion)
			{
				var isAxisTimeReq = false;
				var legendPos = "bottom";
				var graphUrl = imgSrc;
				imgDiv = '<div class="component-list-left-font" style="width:100%"><b></b></div><center><div id="'+imgId+'"/></div></center>';
				graphUrl = graphUrl+"&isSmall=true";
				var bigGrpUrl=jsonData.measureGraphMaximizeURL;
				var containerId = imgId;
				var sparObj = Ext.getCmp(containerId);
				var errHtml = '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No measures available</div></div></div>'
				if (!Ext.isEmpty(sparObj))
				{
					sparObj.destroy();
				}
				
					chartPanel = {
					
					xtype : 'panel',
					id:containerId,
					cls:'block1',
					title: panTitle,
					frame:false,
					border:true,
					padding:0,
					//style:{'border':'1px solid red'},
					//cls : 'history-tab-header-image history-tab-header header-image',
					//bodyCls:'virtual-tab-upper-Background',
					layout :'anchor',
					margin: "10 0 10 10",
					height: 250,
					//width:300,
					columnWidth : columnWid,
					clickUrl:bigGrpUrl,
					tools:[{
					xtype:'toolbar',
					items:[
						{
						xtype:'button',
						cls:'iconMaximize',
						border:false,
						contId:containerId,
						listeners:{
						'afterrender':function(thisObj){
							thisObj.el.on('click',function(){
								var dataUrl =thisObj.contId;
								if(dataUrl.indexOf("graphImg") >-1)
								{
									var splitValue = dataUrl.substring(8);	
									showFullviewVMTab(splitValue,this,'1');
									//showFullviewVMTab(splitValue,event,'1');

								}
							
								});
							}
						}
					
					}
					]
					}],
					items:[{
						xtype:'container',
						html:imgDiv
					}],
					listeners:{
						'afterrender': function(thisObj){
							var panelWidth = ( $( window ).width() / 3 ) - 75;
							Ext.Ajax.request({
									url:imgSrc,
									success : function(response) {
										//try
										//{
											var jsonText = response.responseText;
										
											if(!Ext.isEmpty(jsonText))
											{
												if(jsonText.indexOf("<HTML>") > -1 || jsonText.indexOf(".png") > -1 || jsonText.indexOf("<html>") > -1 || jsonText.indexOf("<div ") > -1)
												{
													thisObj.update(errHtml);
												}
												else
												{
													var formdata = Ext.decode(jsonText);
												
													if(!Ext.isEmpty(formdata.DataSet) && !Ext.isEmpty(thisObj.body)  && !Ext.isEmpty(thisObj.body.id))
													{
														formdata['title'] = false;
														formdata['tick'] = true;
														formdata['fromPage'] = 'virtualTab';
														var barChart = {};
														//barChart = jQuery.extend(true, {}, createBar(thisObj.body.id,formdata.chartHeight,panelWidth), barChart);
														barChart = jQuery.extend(true, {}, createBar(thisObj.body.id,thisObj.body.lastBox.height,panelWidth), barChart);
														barChart.setData(formdata,'','','bar');
														barChart.drawChart();
													}
													else
													{
													
														temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div style="text-align:center;font-weight:bold"><b>'+jsonData.title+'</b></div></div></center>';
														temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >No Data Found</div></div></center>';
														thisObj.update(temp);
														
													}
												}
											}
										
										/*}
										catch (err )
										{
											Ext.getCmp(containerId).update(errHtml);
										}*/
									},
							});
						}
					}
				}
				return chartPanel;
			}
			else
			{
		
				htmlVal=' <div><b>'+panTitle+'</b></div><div><iframe src="'+imgSrc+'" scrolling="no" frameborder="0"  marginheight="0" marginwidth="0" style="text-align:left;margin-left: auto; margin-right: auto; ALLOWTRANSPARENCY="true" ></iframe></div>';
			}
		}
		// Fusion Chart
		if (!Ext.isEmpty(htmlVal))
		{
			chartPanel = {
						id:imgId,
						xtype : 'container',
						//title: panTitle,
						border:false,
						
						//cls:'datapanel',
						padding:10,
						//cls : 'history-tab-header-image history-tab-header header-image',
						//bodyCls:'virtual-tab-upper-Background',
						layout :'fit',
						//html:'<iframe frameBorder="0" scrolling="no"  width="100%" height="100%" <img width="100%" src="'+imgSrc+'"/></iframe>',
						html:htmlVal,
						//margin: "10 10 8 10",
						height: 250,
						columnWidth : columnWid,
						clickUrl:jsonData.measureGraphMaximizeURL,
						listeners:{
							render:function(thisObj){
								thisObj.el.on('click',function(){
									if ( !Ext.isEmpty( thisObj.clickUrl ) && thisObj.clickUrl.indexOf('DashboardTimelineMeasures')>-1)
									{
										componentDashboard.app.getController("VirtualController").displayBigGraph(thisObj,"analysisMeasuregraph")
									}
								});
							}
						}
				}
			return chartPanel;
		}
	},
	returnGrid : function(jsonData,i,columnWid)
	{
		var gridStore = Ext.create('Ext.data.Store',{
			fields : ['measure','currentMesValue'],

			proxy: {
				type: 'memory',
				reader: {
					type: 'json',
					root:'0'
				}
			},
			data:jsonData
		});
		
		custom_unit= jsonData[i].unit;
		
		var memGrid={
				xtype:'customgrid',
				ui:'newGridPanel',
				hideHeaders:true,
				border: true,
				store:gridStore,
				height:248,
				//bodyCls:'virtual-memory-grid top-left-radius top-rigth-radius bottom-left-radius bottom-right-radius',
				forceFit: true,
				columns:[{
					dataIndex:'measure',
					renderer:function(value,metaData,record,rowIndex,colIndex)
					{
						if(!Ext.isEmpty(record.get('measure'))){
							var mes = record.get(('measure'));
							var state = "state_"+record.raw.stateValue;
							var link = record.raw.link;
							var unit_data = record.raw.unit;
							var ret ='<span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="'+state+'" style="vertical-align: middle;"/> <a href="'+link+'">'+mes+unit_data+'</a></span>';
							return ret;
						}
					}
				},
				{
					dataIndex:'currentMesValue'
				}],
				columnWidth : columnWid,
				margin: "10 10 10 10"
		};
		return memGrid;
	}
});